C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE  ISORT1(N,A,TAG)
C
C     sort array A (integer*4) with array TAG
C     N = number of elementa of A
C     Reference ....
C ******
      INTEGER    N
      INTEGER    A(*),T,TT
      INTEGER    TAG(*),TG
      INTEGER    IU(24),IL(24)
C===========================================================
      M=1
      I=1
      J=N
    5 IF(I.GE.J) GO TO 70
   10 K=I
      IJ=(J+I)/2
      T=A(IJ)
      IF(A(I).LE.T) GO TO 20
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)

      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG

   20 L=J
      IF(A(J).GE.T) GO TO 40
      A(IJ)=A(J)
      A(J)=T
      T=A(IJ)

      TG=TAG(IJ)
      TAG(IJ)=TAG(J)
      TAG(J)=TG

      IF(A(I).LE.T) GO TO 40
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)

      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG

      GO TO 40
   30 A(L)=A(K)
      A(K)=TT

      TG=TAG(L)
      TAG(L)=TAG(K)
      TAG(K)=TG

   40 L=L-1
      IF(A(L).GT.T) GO TO 40
      TT=A(L)
   50 K=K+1
      IF(A(K).LT.T) GO TO 50
      IF(K.LE.L) GO TO 30
      IF((L-I).LE.(J-K)) GO TO 60
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GO TO 80
   60 IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GO TO 80
   70 M=M-1
      IF(M.EQ.0) RETURN
      I=IL(M)
      J=IU(M)
   80 IF((J-I).GE.1) GO TO 10
      IF(I.EQ.1) GO TO 5
      I=I-1
   90 I=I+1
      IF(I.EQ.J) GO TO 70
      T=A(I+1)
      IF(A(I).LE.T) GO TO 90

      TG=TAG(I+1)

      K=I
  100 A(K+1)=A(K)

      TAG(K+1)=TAG(K)

      K=K-1
      IF(T.LT.A(K)) GO TO 100
      A(K+1)=T

      TAG(K+1)=TG

      GO TO 90
      END
C
      SUBROUTINE  sort_real(N,A,TAG)
C
C     sort array A (real) with array TAG
C     N = number of elementa of A
C     Reference ....
C ******
      INTEGER    N
      REAL       A(*),T,TT
      INTEGER    TAG(*),TG
      INTEGER    IU(24),IL(24)
C===========================================================
      M=1
      I=1
      J=N
    5 IF(I.GE.J) GO TO 70
   10 K=I
      IJ=(J+I)/2
      T=A(IJ)
      IF(A(I).LE.T) GO TO 20
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)

      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG

   20 L=J
      IF(A(J).GE.T) GO TO 40
      A(IJ)=A(J)
      A(J)=T
      T=A(IJ)

      TG=TAG(IJ)
      TAG(IJ)=TAG(J)
      TAG(J)=TG

      IF(A(I).LE.T) GO TO 40
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)

      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG

      GO TO 40
   30 A(L)=A(K)
      A(K)=TT

      TG=TAG(L)
      TAG(L)=TAG(K)
      TAG(K)=TG

   40 L=L-1
      IF(A(L).GT.T) GO TO 40
      TT=A(L)
   50 K=K+1
      IF(A(K).LT.T) GO TO 50
      IF(K.LE.L) GO TO 30
      IF((L-I).LE.(J-K)) GO TO 60
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GO TO 80
   60 IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GO TO 80
   70 M=M-1
      IF(M.EQ.0) RETURN
      I=IL(M)
      J=IU(M)
   80 IF((J-I).GE.1) GO TO 10
      IF(I.EQ.1) GO TO 5
      I=I-1
   90 I=I+1
      IF(I.EQ.J) GO TO 70
      T=A(I+1)
      IF(A(I).LE.T) GO TO 90

      TG=TAG(I+1)

      K=I
  100 A(K+1)=A(K)

      TAG(K+1)=TAG(K)

      K=K-1
      IF(T.LT.A(K)) GO TO 100
      A(K+1)=T

      TAG(K+1)=TG

      GO TO 90
      END
c

c
C---Function to calculate modified bessell functions ( I(X))
C
      SUBROUTINE BESSI0(X,X1,X2)
C
C---Calculates value of bessel function. It retruns EXP(X2)*X1
C---to avoid overflow
      REAL T,X,X1,X2,AX
C
      T = ABS(X)/3.75
C
      IF(T.LT.1.0) THEN
        T  = T*T
        X2 = 0.0
        X1 = ((((((T*0.0045813+0.0360768)*T+0.2659732)*T+1.2067492)*T+
     +        3.0899424)*T+3.5156229)*T+1.0)
      ELSE
        AX = ABS(X)
        X2 = AX
        T  = 1.0/T
        X1 = (1.0/SQRT(AX))*((((((((T*0.00392377-0.01647633)*T+
     +        0.02635537)*T-0.02057706)*T+0.00916281)*T-
     +        0.00157565)*T+0.00225319)*T+0.01328592)*T+0.39894228)
      ENDIF
      END

      SUBROUTINE BESSI0_R(X,X1,X2)
      IMPLICIT NONE
      INCLUDE 'expcost.fh'
C
C---Takes value of I0 from the table
C
      REAL X,X1,X2
      REAL X_A
      INTEGER N_POINT
C
      X_A  = ABS(X)

      IF(X_A.GT.AMAX_ARG_BESS) THEN
         CALL BESSI0(X,X1,X2)
      ELSE
        N_POINT = INT(X_A/AMAX_ARG_BESS*FLOAT(NMAX_ARG_BESS))+1
        X1   = BESSI0_X1_TAB(N_POINT)
        X2   = BESSI0_X2_TAB(N_POINT)
      ENDIF
      
      END
C
      SUBROUTINE BESSI1(X,X1,X2)
C
C---Calculates value of bessel function. It retruns EXP(X2)*X1
C---to avoid overflow
      REAL  Y,P1,P2,P3,P4,P5,P6,P7,
     *                 Q1,Q2,Q3,Q4,Q5,Q6,Q7,Q8,Q9

      DATA P1,P2,P3,P4,P5,P6,P7 /0.5D0,0.87890594D0,0.51498869D0,
     *     0.15084934D0,0.2658733D-1,0.301532D-2,0.32411D-3/
      DATA Q1,Q2,Q3,Q4,Q5,Q6,Q7,Q8,Q9 /0.39894228D0,-0.3988024D-1,
     *     -0.362018D-2,0.163801D-2,-0.1031555D-1,0.2282967D-1,
     *     -0.2895312D-1,0.1787654D-1,-0.420059D-2/
      IF(ABS(X).LT.3.75)THEN
        Y  = X/3.75
        Y  = Y*Y
        X2 = 0.0
        X1 = X*(P1+Y*(P2+Y*(P3+Y*(P4+Y*(P5+Y*(P6+Y*P7))))))
      ELSE
        AX = ABS(X)
        Y  = 3.75/AX
        X2 = X
        X1 = 1.0/SQRT(AX)*
     * (Q1+Y*(Q2+Y*(Q3+Y*(Q4+Y*(Q5+Y*(Q6+Y*(Q7+Y*(Q8+Y*Q9))))))))
        IF(X.LT.0.0)X1 = -X1
      ENDIF
      END 
C
      SUBROUTINE GENPRE
      use agreem
      use CellAndSymmetry
      use refi_flags
      implicit none
C
C---Calculate orthogonalization and deorthogonalization matrices
      INCLUDE 'const.fh'
      INCLUDE 'files.fh'
      INCLUDE 'atom_com.fh'
      include 'gaussian.fh'

      LOGICAL LOGIC
      REAL ALPHA,BETTA,GAMMA
      REAL RS(3,3),RS_CONV(6,6)
      integer i,j,ii,jj,ip,isym
      real a1,a2,a3,s
      real check,det
      real x_0_1,x_0_i
C
C---Cell parameters are known. It uses cell from celsym.f90. 
C---I.e. current active cell.
      CHECK = 0.0
      DO     I=1,6
         CHECK = CHECK + CS_CELL(I)**2
      ENDDO
      IF(CHECK.LT.EPSCH1/10.0) THEN
        CALL ERRWRT(1,'Cell parameters should be known by now')
      ENDIF
      A1    = CS_CELL(1)
      A2    = CS_CELL(2)
      A3    = CS_CELL(3)
      IF(CS_CELL(4).LE.5.0.AND.CS_CELL(5).LE.5.0
     &                    .AND.CS_CELL(6).LE.5.0) THEN
        ALPHA = CS_CELL(4)
        BETTA = CS_CELL(5)
        GAMMA = CS_CELL(6)
      ELSE
        ALPHA = CS_CELL(4)*DEGTOR
        BETTA = CS_CELL(5)*DEGTOR
        GAMMA = CS_CELL(6)*DEGTOR
      ENDIF
C
      COSA = COS(ALPHA)
      SINA = SIN(ALPHA)
      COSB = COS(BETTA)
      SINB = SIN(BETTA)
      COSG = COS(GAMMA)
      SING = SIN(GAMMA)
      COSZ = 
     +   SQRT(1.-COSA**2-COSB**2-COSG**2+2.*COSA*COSB*COSG)/SING
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      S      = (ALPHA+BETTA+GAMMA)*0.5
      VOLUME = 2.0*CS_CELL(1)*CS_CELL(2)*CS_CELL(3)*
     +      SQRT(SIN(S)*SIN(S-ALPHA)*SIN(S-BETTA)*SIN(S-GAMMA))
C
C---These lines should be changed to double precision if it ever will be 
C---necessary
C
      DCOSA = COS(ALPHA)
      DSINA = SIN(ALPHA)
      DCOSB = COS(BETTA)
      DSINB = SIN(BETTA)
      DCOSG = COS(GAMMA)
      DSING = SIN(GAMMA)
      DCOSZ =
     + SQRT(1.-DCOSA**2-DCOSB**2-DCOSG**2+2.*DCOSA*DCOSB*DCOSG)/DSING
C
C----Orthogonalisation matrix. That is duplication of CS_FRAC2ORTH in
C----atom_com.fh
      ROR(1,1) = A1
      ROR(1,2) = A2*COSG
      ROR(1,3) = A3*COSB
      ROR(2,2) = A2*SING
      ROR(2,3) = A3*(COSA-COSB*COSG)/SING
      ROR(3,3) = A3*COSZ
      ROR(2,1) = 0.0
      ROR(3,1) = 0.0
      ROR(3,2) = 0.0
C
C----Unit ortogonolisation matrox
      RO_UNIT(1,1) = CS_FRAC_TO_ORT(1,1)/A1
      RO_UNIT(1,2) = CS_FRAC_TO_ORT(1,2)/A2
      RO_UNIT(1,3) = CS_FRAC_TO_ORT(1,3)/A3
      RO_UNIT(2,2) = CS_FRAC_TO_ORT(2,2)/A2
      RO_UNIT(2,3) = CS_FRAC_TO_ORT(2,3)/A3
      RO_UNIT(3,3) = CS_FRAC_TO_ORT(3,3)/A3
      RO_UNIT(2,1) = 0.0
      RO_UNIT(3,1) = 0.0
      RO_UNIT(3,2) = 0.0
      CALL MATINV3_R(RO_UNIT,RMATR_ORT2CELL)

C
C---Unit deorthogonolization matrix
C
C---Deorthogonolization matrix. That is duplication of CS_ORT2FRAC in
C---atom_com.f
      DET      = ROR(1,1)*ROR(2,2)*ROR(3,3)
      RFR(1,1) = 1/A1
      RFR(1,2) = -(ROR(1,2)*ROR(3,3) - ROR(1,3)*ROR(3,2))/DET
      RFR(1,3) =  (ROR(1,2)*ROR(2,3) - ROR(1,3)*ROR(2,2))/DET 
      RFR(2,2) = ROR(1,1)*ROR(3,3)/DET
      RFR(2,3) = -ROR(1,1)*ROR(2,3)/DET
      RFR(3,3) = ROR(1,1)*ROR(2,2)/DET
      RFR(2,1) = 0.0
      RFR(3,1) = 0.0
      RFR(3,2) = 0.0
C
C---Prepare matrices for aniso U matrix
C
C---Symmetry martices for anisotropic B-values. In cell edges (angstroms)
      DO     ISYM=1,NumSymmetry
        DO   II=1,3
          DO  JJ=1,3
            RS(II,JJ)  = RealSymmMatrx(II,JJ,ISYM)
          ENDDO
        ENDDO
        CALL FIND_CONV_MATRIX(RS,RS_CONV)
        DO    II=1,6
          DO    JJ=1,6
            RealSymm_Aniso(II,JJ,ISYM) = RS_CONV(II,JJ)
          ENDDO
        ENDDO
      ENDDO
C
C----Conversion from cell to orthogonal coordinates

      CALL FIND_CONV_MATRIX(RO_UNIT,UUCELL2ORTH)
      CALL FIND_CONV_MATRIX(RMATR_ORT2CELL,UUORTH2CELL)

C
C----Conversion from orthogonal to cell
      CALL ANISO_EIGENS
c
c----Symmetry preperation
C---Calculate initial values of sigmas so on using coordinates or other means
      LOGIC = .FALSE.
      DO    I=1,NPART+1
          LOGIC = LOGIC.OR.
     .     (IMLSCALTYP(I).EQ.1).OR.(ILSCALTYP(I).EQ.1)
      ENDDO
      IF(LOGIC.OR.IMLSCALTYPOV.EQ.1.OR.ILSSCALTYPOV.EQ.1) 
     .             CALL ANISOSCLCONSTR
      IF(MLSCALTYPE.EQ.'ISOTR') IMLSCALTYPOV = 0
      IF(LSSCALTYPE.EQ.'ISOTR') ILSSCALTYPOV = 0
      IF(IMLSCALTYPOV.EQ.1) THEN
        DO    I=1,NPART+1
          IMLSCALTYP(I) = 1
        ENDDO
      ENDIF
      IF(ILSSCALTYPOV.EQ.1) THEN
        DO    I=1,NPART+1
          ILSCALTYP(I) = 1
        ENDDO
      ENDIF
C---
C---Parameters here?????
C--- 
C---Save parameters of partial structures. 
      NPARTALL_SAVE   = NPARTALL
      NPART_SAVE      = NPART
      FPART_FLAG_SAVE = FPART_FLAG
      DO    IP=1,NPARTALL
        ILSCALTYP_SAVE(IP) = ILSCALTYP(IP)
        ISCPART_SAVE(IP)  = ISCPART(IP)       
      ENDDO
      call expcos_table
      IF(REFID.NE.'IDEA')THEN
        x_0_integr = 0.0
        X_0_I = x_0_integr
        delta_integr = 0.005
        npoint_int  = 5
        ntab_integr = 2200
        DO   J=1,ntab_integr
          x_0_1 = x_0_i
          CALL GAUSS_COEF_TAB_A2INF(npoint_int,x_0_1,
     &        X_POINTS_int(1,J),W_POINTS_int(1,J))
cd          write(*,*)
cd         write(*,*)x_0_i
          do    i=1,npoint_int
             x_points_int(i,J) = x_points_int(i,J)
             w_points_int(i,J) = w_points_int(i,J)
          enddo
          x_0_i = x_0_i + delta_integr
        enddo
      endif
c
c---  twin: process and make sure that everything is consistent
c      call twin_prepare
cd      stop
C
      RETURN
      END
C
      subroutine twin_prepare(ierr)
      use CellAndSymmetry
      use refi_flags
      implicit none
      include 'atom_com.fh'
      include 'twin_refmac.fh'
c
      integer maxsym_l
      integer ioutput
      real*8 tol_a
      real*8 cell_a(6)
      integer sym_to_a(3,3,192),trans_to_a(3,192)
      integer sym_tw(3,3,192)
      integer n_twins,n_twins2
      real*8 score_tw(192)
      integer itw,itw1
      integer sym_candidate(3,3)
      real rot_l1(3,3)
      real sym_simple
c
      integer nobs1,ncomp1
      integer sym_temp(3,3)
      integer ierr,idelta,irepeat
      integer i,j,i1,j1,is
      integer ivalid(48)
      real twin_sum
      real rot_l(3,3),tr_l(3)
      real rot_s(3,3,192),tr_s(3,192)
      integer nprim_symm
      real rot_p(3,3,192),tr_p(3,192)
      character input_file*512
      character text_loc*512
      real eps
      data eps/0.1e-6/
      integer in_file
      character refl_type*4
c
      ierr = 0
c
      call find_prim_symm(maxsym,nsym,nprim_symm,rot,tr,rot_p,tr_p)
      tol_a = twin_toler
      if(reftyp.eq.'HKL') then
         twin_flag = .TRUE.
         call read_hklf5_size(nobs1,ncomp1,ntwin_domain,ierr,input_file)
         if(ierr.gt.0) then
            write(*,*)'Problem with input hklf 5 file'
            call errwrt(1,'Cannot continue')
         endif
      endif
c     
      if(.not.twin_flag) return
      if(reftyp.ne.'HKL') then
c     
c--   If the input reflection file is not hklf 5 then correct twin operators
         cell_a(1:6) = dble(cell(1:6))
         maxsym_l = 192
         rot_s(1:3,1:3,1:nsym) = rot(1:3,1:3,1:nsym)
         tr_s(1:3,1:nsym) = tr(1:3,1:nsym)
         call symm2int_by12_1(maxsym_l,nsym,rot,tr,sym_to_a,
     &        trans_to_a)
         ioutput = 0
         call yyy_cell2tg(cell_a,tol_a,nsym,sym_to_a,trans_to_a,
     &        maxsym_l,n_twins,n_twins2,sym_tw,score_tw,ioutput)
         do itw = 1,n_twins
            sym_simple = sum(abs(sym_tw(1:3,1:3,itw)))
            itw1 = 1
            rot_l(1:3,1:3) = float(sym_tw(1:3,1:3,itw))/12.0
            do is=2,nprim_symm
               rot_l1 = matmul(rot_l(1:3,1:3),rot_p(1:3,1:3,is))
               if(sym_simple.gt.12.0*sum(abs(rot_l1(1:3,1:3)))) then
                  sym_simple = 12.0*sum(abs(rot_l1(1:3,1:3)))
                  itw1 = is
                  sym_candidate(1:3,1:3) = nint(rot_l1(1:3,1:3)*12.0)
               endif
            enddo
            if(itw1.ne.1) then
               sym_tw(1:3,1:3,itw) = sym_candidate(1:3,1:3)
            endif
         enddo
c
c---  If twin operators have been set then check them
c---  If twin operators have not been set then use derived operators as
c---  twin operators. They will need to be analysed during refinement
c         ntwin_domain = 1
c         n_twins      = 1
         if(twin_oper_set) then
            do i=1,ntwin_domain
               do is = 1,cs_nsym
                  sym_temp(1:3,1:3)=matmul(twin_oper(1:3,1:3,i),
     &                 sym_to_a(1:3,1:3,is))
                  do j=1,n_twins
                     idelta = maxval(abs(sym_temp(1:3,1:3)/12-
     &                    sym_tw(1:3,1:3,i)))
                     if(idelta.eq.0) goto 100
                  enddo
               enddo
               write(*,*)'Problem. Twin opeator number ',i,
     &              ' is not among the potential twin operatos'
               ierr = ierr + 1
 100           continue
            enddo
            if(ierr.gt.0) then
               write(*,*)'Problem in input twin operators'
               write(*,*)'Twin operators can be defined for'//
     &              ' (pseudo)merohedral cases only.'
               write(*,*)'To refine nonmerohedral twins SHELX hklf 5'//
     &              ' file format should be used'
               write(*,*)
     &              'Correct twin operators with the correct syntax'
               call header('Potential twin operators')
               do i=1,n_twins
                  rot_l(1:3,1:3) = float(sym_tw(1:3,1:3,i))/12.0
                  tr_l(1:3) = 0.0
                  call put_symm_to_text(rot_l,tr_l,text_loc)
                  write(*,*)'twin operator '//trim(text_loc)
               enddo
               call header('End of twin operators')
            endif
         else
            ntwin_domain = n_twins
            twin_oper(1:3,1:3,1:n_twins) = sym_tw(1:3,1:3,1:n_twins)
            twin_score(1:n_twins) = score_tw(1:n_twins)
            twin_oper_set = .TRUE.
         endif
c
c---  Accidental repeats should also be removed
         ivalid(1:ntwin_domain) = 1
         do i=ntwin_domain,2,-1
            do is=1,nsym
               sym_temp = 
     &              matmul(sym_tw(1:3,1:3,i),sym_to_a(1:3,1:3,is))/12
               do j=i-1,1,-1
                  idelta=
     &                 maxval(abs(sym_temp(1:3,1:3)-sym_tw(1:3,1:3,j)))
                  if(idelta.eq.0) ivalid(i) = 0
                  goto 150
               enddo
            enddo
 150        continue
         enddo
         i1 = 1
         j1 = 1
         do i=2,ntwin_domain
            i1 = i1 + 1
            if(ivalid(i).eq.1) then
               j1 = j1 + 1 
               sym_tw(1:3,1:3,j1) = sym_tw(1:3,1:3,i1)
            endif
         enddo
         ntwin_domain = j1
c
c---  Make sure that the first operator is identity and twin operatos cover all domains
c---  including the first one. Identity means that given operator is an element of 
c---  the point group of the crystal
         ivalid(1:ntwin_domain) = 0
         irepeat = 0
         do i=1,ntwin_domain
            rot_l(1:3,1:3) = float(sym_tw(1:3,1:3,i))/12.0
            do is=1,nsym
               if(maxval(abs(rot_l(1:3,1:3)-
     &              rot_s(1:3,1:3,is))).le.eps) then
c                  if(i.gt.1) then
                     sym_tw(1:3,1:3,i) = sym_tw(1:3,1:3,1)
                     sym_tw(1:3,1:3,1) = 0
                     sym_tw(1,1,1) = 12
                     sym_tw(2,2,1) = 12
                     sym_tw(3,3,1) = 12
                     ivalid(i) = 1
                     goto 190
c                  endif
               endif
            enddo
 190        continue
         enddo
         irepeat = sum(ivalid(1:ntwin_domain))
c
c---If none of the symm operators is identity. Add identity as a first operator
         if(irepeat.eq.0) then
            ntwin_domain = ntwin_domain + 1
            do i=ntwin_domain,2,-1
               sym_tw(1:3,1:3,i) = sym_tw(1:3,1:3,i-1)
            enddo
            sym_tw(1:3,1:3,1) = 0
            sym_tw(1,1,1) = 12
            sym_tw(2,2,1) = 12
            sym_tw(3,3,1) = 12  
         endif
      endif
c
c--   If twin factions have been set then check them. Sum of them should be one
c--   if they have not bee defined then initialise them
      if(sum(twin_frac(1:ntwin_domain)).le.0.001) then
         twin_frac_set=.FALSE.
         twin_frac(1:ntwin_domain) = 0.0
      endif
      if(twin_frac_set) then
         if(twin_frac(ntwin_domain).eq.0.0) then
            do i=ntwin_domain,2,-1
               twin_frac(i) = twin_frac(i-1)
            enddo
            twin_frac(1) = 1.0  -sum(twin_frac(2:ntwin_domain))
         endif
      else
         twin_frac(1:ntwin_domain) = 1.0/ntwin_domain
         twin_frac(1) = twin_frac(1)*1.4
      endif
c
c--   Make sure that sum of all twin fractions is 1
      twin_sum = sum(twin_frac(1:ntwin_domain))
      twin_frac(1:ntwin_domain) = twin_frac(1:ntwin_domain)/twin_sum
      twin_frac_set = .TRUE.
      return
      end

      REAL FUNCTION SIM(X)
C     ====================
C
C-----extracted from R.Reads sigmaa.
C
C---- Calculate sim and srinivasan non-centric figure of merit
C     as i1(x)/i0(x), where i1 and i0 are the modified 1st and zero
C     order bessel functions.
C     references: sim, g. a. (1960) acta cryst. 13, 511-512;
C       srinivasan, r. (1966) acta cryst. 20, 143-144;
C       abramowitz & stegun, handbook of mathematical functions, 378.
C     this routine was obtained from w. kabsch.
C
C
C
C
C     .. Scalar Arguments ..
      REAL X
C     ..
C     .. Local Scalars ..
      REAL T
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS,SIGN
C     ..
C     .. Save statement ..
      SAVE
C     ..
C
      T = ABS(X)/3.75
C
      IF (T.GT.1.0) THEN
        T = 1.0/T
        SIM = ((((((((0.01787654-T*0.00420059)*T+ (-0.02895312))*T+
     +        0.02282967)*T+ (-0.01031555))*T+0.00163801)*T+
     +        (-0.00362018))*T+ (-0.03988024))*T+0.39894228)*
     +        SIGN(1.0,X)/ ((((((((-0.01647633+T*0.00392377)*T+
     +        0.02635537)*T+ (-0.02057706))*T+0.00916281)*T+
     +        (-0.00157565))*T+0.00225319)*T+0.01328592)*T+0.39894228)
      ELSE
        T = T*T
        SIM = ((((((T*0.00032411+0.00301532)*T+0.02658733)*T+
     +        0.15084934)*T+0.51498869)*T+0.87890594)*T+0.5)*X/
     +        ((((((T*0.0045813+0.0360768)*T+0.2659732)*T+1.2067492)*T+
     +        3.0899424)*T+3.5156229)*T+1.0)
      END IF
      END
C
      REAL FUNCTION SIM_R(XX)
      IMPLICIT NONE
C
C
C--Takes value of sim = I1(XX)/I0(XX) from the table
      INCLUDE 'expcost.fh'
      REAL XX
      REAL XX1
      INTEGER N_POINT
      REAL SIM
      EXTERNAL SIM
C
      XX1 = ABS(XX)
      IF(XX1.GT.AMAX_ARG_BESS) THEN
        SIM_R = SIM(XX)
      ELSE
        N_POINT = INT(XX1/AMAX_ARG_BESS*FLOAT(NMAX_ARG_BESS))+1
        SIM_R   = SIM_TABLE(N_POINT) 
        IF(XX.LT.0.0) SIM_R = -SIM_R
      ENDIF
C
      END
c
      subroutine fom_and_cosa_calc(icent,xx,abcd,cosp,sinp,
     &     fom,cosa,sina,cos2a,sin2a)
      implicit none
c
c---  calculate figure of merit and expectation values for cos(phi),sin(phi)
c---  cos(2phi),sin(2phi), cos2phi and sin2phi are not calculated yet
      integer icent
      real xx,cosp,sinp
      real abcd(4)
      real fom,cosa,sina,cos2a,sin2a
c
c---  locals
      real, parameter :: eps_loc=0.1e-6
      real xx0
      real abcd1(4)

      real fom_calc,sim
c
c---  body

      if(sum(abs(abcd(1:4)**2)).le.eps_loc) then
         fom = fom_calc(icent,xx)
         cosa = fom*cosp
         sina = fom*sinp
c         cos2a = cosa*cosa-sina*sina
c         sin2a = 2.0*cosa*sina
      else
         abcd1(1) = abcd(1) + cosp*xx
         abcd1(2) = abcd(2) + sinp*xx
         abcd1(3:4) = abcd(3:4)
         if(abcd1(3)**2+abcd1(4)**2.le.eps_loc) then
            xx0 = sqrt(abcd1(1)**2+abcd1(2)**2)
            fom = sim(xx0/2)
            cosa = fom*abcd1(1)/xx0
            sina = fom*abcd1(2)/xx0
         else
            if(icent.eq.0) then
               call phprob_0(abcd1(1),abcd1(2),abcd1(3),abcd1(3),
     &              cosa,sina)
               fom = sqrt(cosa**2+sina**2)
            else
               call phprob_centr_0(abcd1(1),abcd1(2),cosa,sina)
               fom = sqrt(cosa**2+sina**2)
            endif
         endif
      endif
c
      return
      end

      real function fom_calc(icent,xx)
      implicit none
c
      integer icent
      real xx
      real sim
      external sim
c
      if(icent.eq.0) then
         fom_calc = sim(xx)
      else
         if(xx.eq.0.0) then
            fom_calc = 0.0
         elseif(xx.gt.30) then
            fom_calc = 1.0
         else
            fom_calc = tanh(xx)
         endif
      endif
      end
c
      SUBROUTINE EXPCOS_TABLE
C
C----Calculate tables for exponent and triganometric functions
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      DOUBLE PRECISION DEXP,DCOS,DSIN
      INTRINSIC DEXP,DCOS,DSIN
C
cd      NTRIGINC = 2
cd      NINTEGRSTEP = 360
cd      ARGMAX = 80.0
      WIDTH       = REAL(NTRIGINC)*TWOPI/REAL(NMAXTRIG)
      STEP = TWOPI/REAL(NMAXTRIG)
      COS1_TAB(1) = 1.0
      SIN1_TAB(1) = 0.0
      COS2_TAB(1) = 1.0
      SIN2_TAB(1) = 0.0

      DCOS1_TAB(1) = 1.0D0
      DSIN1_TAB(1) = 0.0D0
      DCOS2_TAB(1) = 1.0D0
      DSIN2_TAB(1) = 0.0D0
C
      ARGM = 0.0 
      DO     I=2,NMAXTRIG
         ARGM    = ARGM + STEP
         COS1_TAB(I) = COS(ARGM)
         SIN1_TAB(I) = SIN(ARGM)
         COS2_TAB(I) = COS(2.0*ARGM)
         SIN2_TAB(I) = SIN(2.0*ARGM)

         DCOS1_TAB(I) = DCOS(DBLE(ARGM))
         DSIN1_TAB(I) = DSIN(DBLE(ARGM))
         DCOS2_TAB(I) = DCOS(DBLE(2.0*ARGM))
         DSIN2_TAB(I) = DSIN(DBLE(2.0*ARGM))
      ENDDO
C
      ARGSTEP = ARGMAX/REAL(NMAXEXP)
      ETAB(1) = 1.0D0
      ARGM = 0.0
      DO    I=2,NMAXEXP+1
        ARGM = ARGM + ARGSTEP
        ETAB(I) = EXP(ARGM)
      ENDDO
C
C---Now tabulate bessel functions
      AMAX_ARG_BESS = 500.0
      ARG_STEP_BESS = AMAX_ARG_BESS/FLOAT(NMAX_ARG_BESS)
      SIM_TABLE(1) = 0.0
      ARG_CURRENT  = 0.0
      BESSI0_X1_TAB(1) = 1.0
      BESSI0_X2_TAB(1) = 0.0
      DO  I=2,NMAX_ARG_BESS
        ARG_CURRENT = ARG_CURRENT + ARG_STEP_BESS
        SIM_TABLE(I) = SIM(ARG_CURRENT)
        CALL BESSI0(ARG_CURRENT,X1,X2)
        BESSI0_X1_TAB(I) = X1
        BESSI0_X2_TAB(I) = X2
      ENDDO
C
      RETURN
      END 
C
      SUBROUTINE ANISOSCLCONSTR
      use agreem
      use CellAndSymmetry
C
C---Defines symmetry related constraints on the overall anisotropic B value
      include 'twin_refmac.fh'

      if (twin_flag) return
      IF((ISPNO.GE.195.AND.ISPNO.LE.230).OR.ISPNO.EQ.1197) THEN
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,
     +    '---------------------------------------------------------')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(0,
     +    'Cubic space groups cannot have overall anisotropic B-value')
        CALL ERRWRT(0,
     +    'Isotropic overall B-values will be refined')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,
     +    '---------------------------------------------------------')
        CALL ERRWRT(-1,' ')
        MLSCALTYPE = 'ISOTR'
        LSSCALTYPE = 'ISOTR'
      ENDIF
      RETURN
      END
C
      SUBROUTINE FULL_ATOM_NAME(IA,AT_FULL,IERROR)
      IMPLICIT NONE
C
c---Extracts full atom name corresponding to atomic number IA
      INCLUDE 'atom_com.fh'
      include 'makecif.fh'
      INTEGER IA,IERROR
      CHARACTER AT_FULL*(*)
      CHARACTER CHNNMP*12,jrsc*5
      INTEGER JRS
c
      IF(IA.GT.N_ATOM.OR.IA.LE.0) THEN
        AT_FULL = ' '
        IERROR  = 1
        RETURN
      ENDIF

      jrsc = res_num_pdb(i_resid(ia))(3:7)
cd      READ(RES_NUM_PDB(I_RESID(IA))(3:6),*)JRS
      
      CHNNMP = RES_NUM_PDB(I_RESID(IA))
      if(make_segid_in_flag.eq.'Y') then
         IF(ID_ALT(IA).NE.'.') THEN
            WRITE(AT_FULL,'(A4,1x,A5,A4,A)')
     +           CHNNMP(8:11),jrsc,ATM_NAME(IA),ID_ALT(IA)
         ELSE
            WRITE(AT_FULL,'(A4,1x,A5,A4)')
     +           CHNNMP(8:11),jrsc,ATM_NAME(IA)
         ENDIF
      else
         IF(ID_ALT(IA).NE.'.') THEN
            WRITE(AT_FULL,'(A1,4x,A5,A4,A)')
     +           CHNNMP(8:8),jrsc,ATM_NAME(IA),ID_ALT(IA)
         ELSE
            WRITE(AT_FULL,'(A1,4x,A5,A4)')
     +           CHNNMP(8:8),jrsc,ATM_NAME(IA)
         ENDIF
      endif
      RETURN
      END
C
      subroutine get_chain_namepdb(chnamp,ir)
      implicit none
      include 'atom_com.fh'
      include 'makecif.fh'
c
c--inputs
      integer ir
c
c---outputs
      character chnamp*(*)
c
c---body
      chnamp = ' '
      if(make_segid_in_flag.eq.'Y') then
         chnamp=res_num_pdb(ir)(8:11)
      else
         chnamp=res_num_pdb(ir)(1:1)
      endif
      return
      end
c
      subroutine get_asm_group_id(asmgrp,ich)
      implicit none
      include 'atom_com.fh'
      include 'makecif.fh'
c
c--inputs
      integer ich
c
c--outputs
      character asmgrp*(*)
c
c---body
      asmgrp = ' '
      if(make_segid_in_flag.eq.'Y') then
         asmgrp=asm_group_id(ich)
      else
         asmgrp=asm_group_id(ich)(1:1)
      endif
      return
      end
c
      SUBROUTINE DIAG_INVERSE_R(AM,V,DV)
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'vitals.fh'
C
      REAL AM(*),V(*),DV(*)

      REAL AMAT(6,6),BVEC(6)
      LOGICAL ERROR

      LV = 1
      LM = 1
      DO   IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
          AMAT(1,1) = AM(LM)
          AMAT(1,2) = AM(LM+3)
          AMAT(1,3) = AM(LM+4)
          AMAT(2,1) = AMAT(1,1)
          AMAT(2,2) = AM(LM+1)
          AMAT(2,3) = AM(LM+3)
          AMAT(3,1) = AMAT(1,3)
          AMAT(3,2) = AMAT(2,3)
          AMAT(3,3) = AM(LM+2)
          BVEC(1)   = V(LV)
          BVEC(2)   = V(LV+1)
          BVEC(3)   = V(LV+2)
          CALL GAUSSJ(AMAT,3,6,BVEC,1,1,ERROR)
          DV(LV)     = BVEC(1)
          DV(LV + 1) = BVEC(2)
          DV(LV + 2) = BVEC(3)
          LV         = LV + 3
          LM         = LM + 6
        ENDIF
      ENDDO
      LM   = NMPOS + 9*NDIS + 1
      LV   = NVPOS + 1
      IF(ITEMP.GT.0) THEN
        DO   IA = 1,N_ATOM
          IF(ATOM_REF_FLAG(IA).GT.0) THEN
            IF(U_ANISO(2,IA).EQ.0.0) THEN
              DV(LV) = V(LV)/AM(LM)
              LV    = LV + 1
              LM    = LM + 1
            ELSE
              AMAT(1,1) = AM(LM)
              AMAT(2,2) = AM(LM+ 1)
              AMAT(3,3) = AM(LM+ 2)
              AMAT(4,4) = AM(LM+ 3)
              AMAT(5,5) = AM(LM+ 4)
              AMAT(6,6) = AM(LM+ 5)
              AMAT(1,2) = AM(LM+ 6)
              AMAT(1,3) = AM(LM+ 7)
              AMAT(1,4) = AM(LM+ 8)
              AMAT(1,5) = AM(LM+ 9)
              AMAT(1,6) = AM(LM+10)
              AMAT(2,3) = AM(LM+11)
              AMAT(2,4) = AM(LM+12)
              AMAT(2,5) = AM(LM+13)
              AMAT(2,6) = AM(LM+14)
              AMAT(3,4) = AM(LM+15)
              AMAT(3,5) = AM(LM+16)
              AMAT(3,6) = AM(LM+17)
              AMAT(4,5) = AM(LM+18)
              AMAT(4,6) = AM(LM+19)
              AMAT(5,6) = AM(LM+20)
              DO    I=1,5
                 DO   J=I+1,6
                   AMAT(J,I) = AMAT(I,J)
                 ENDDO
              ENDDO
              BVEC(1) = V(LV)
              BVEC(2) = V(LV+1)
              BVEC(3) = V(LV+2)
              BVEC(4) = V(LV+3)
              BVEC(5) = V(LV+4)
              BVEC(6) = V(LV+5)
              CALL GAUSSJ(AMAT,6,6,BVEC,1,1,ERROR)
              DO   I=0,5
                DV(LV+I) = BVEC(I+1)
              ENDDO
              LM  = LM + 21
              LV  = LV + 6
            ENDIF
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END
C
      SUBROUTINE TCHEB_RECURRENCE(N,Y,TCHEB)
C
C---Calculates N Tchebyshev polynom polynoms at the point Y
C---Y is assumed to be between (-1,1)
C
      INTEGER N
      REAL    X
      REAL    TCHEB(*)
C
      INTEGER I
      REAL    Y
C
cd      Y = (X - 0.5*(XMAX+XMIN))/(XMAX-XMIN)
      TCHEB(1) = 1.0
      TCHEB(2) = Y
      DO   I=3,N
        TCHEB(I) = 2.0*Y*TCHEB(I-1) - TCHEB(I-2)
      ENDDO

      RETURN
      END
C
      SUBROUTINE CALC_TCHEB_APPROX_CLENSHW(N,Y,COEFS,FVALUE)
      IMPLICIT NONE
C
C---Calculates value of function using Tchebyshev approximation.
C---For efficiency Clenshaw algorithm is used. Y is assumed to be between 
C---(-1,1). 
C
      INTEGER N
      REAL Y,FVALUE
      REAL COEFS(*)
C
      INTEGER  I
      REAL D1,D2
      REAL TMP
C
      D2 = 0.0
      D1 = 0.0
      DO   I=N,2,-1
        TMP = 2.0*Y*D2-D1+COEFS(I)
        D1  = D2
        D2  = TMP
      ENDDO
C
      FVALUE = Y*D2-D1-0.5*COEFS(1)
      
      RETURN
      END
C
      SUBROUTINE CALC_TCHEB_POLYNOMS(N,COEFS,TCHEB,FVALUE)
C
C----Calculates value of function if values of Tchebyshev polynoms and
C----coefficients for approximations are given
C
      INTEGER N
      REAL FVALUE
      REAL TCHEB(*),COEFS(*)
C
      INTEGER I
C
      FVALUE = -0.5*COEFS(1)
      DO   I=2,N
        FVALUE = FVALUE + COEFS(I)*TCHEB(I)
      ENDDO

      RETURN
      END
C
      subroutine SMOOTH_GAUSS(n_points,kernel_width,x_points,y_points,
     &                 x_current,y_current)
      implicit none
      integer n_points
      real kernel_width
      real x_points(*)
      real y_points(*)
      real x_current,y_current
C
C----Uses gussian smoothining to calculate value of function at the given 
C----point. Returns value of the function. Uses direct calculation. Alternative
C----is use of FFT for all points using convolution theorem.
C
C---This routine returns derivative of the function wrt y_current also
C----local variables
C
      integer i
      real expdx,an,fn,dx,dx1
      real kernel_width2
C
      if(n_points.eq.1) then
        y_current = y_points(1)
        return
      endif
      kernel_width2 = kernel_width**2*2.0
      if(x_current.le.x_points(n_points).and.x_current.ge.x_points(1)) 
     &                                                    then
cd      if(1.eq.1) then
        an = 0.0
        fn = 0.0
        do  i=1,n_points
          dx = (x_current-x_points(i))**2/(kernel_width2)
          if(dx.le.30.0) then
            expdx = exp(-dx)
            an = an + expdx
            fn = fn + y_points(i)*expdx
          endif
        enddo
        if(an.le.0.0) then
cd           write(*,*)n_points,kernel_width
           write(*,*)'===> Error in smooth gauss.',
     &                       ' Width might be too small'
           stop
        endif
        y_current = fn/an
      elseif(x_current.gt.x_points(n_points)) then
        dx1 = (x_current-x_points(n_points))**2/(kernel_width2)
        an  = 1.0
        fn  = y_points(n_points)
        do   i=1,n_points-1
          dx = (x_current-x_points(i))**2/(kernel_width2) - dx1
          if(dx.le.30.0) then
            expdx = exp(-dx)
            an    = an + expdx
            fn = fn + y_points(i)*expdx
          endif
        enddo
        if(an.le.0.0) then
           write(*,*)'===> Error in smooth gauss.',
     &                       ' Width might be too small'
           stop
        endif
        y_current = fn/an

      elseif(x_current.lt.x_points(1)) then
        dx1 = (x_current-x_points(1))**2/(kernel_width2)
        an = 1.0
        fn = y_points(1)
        do   i=2,n_points
          dx = (x_current-x_points(i))**2/(kernel_width2)-dx1
          if(dx.le.30.0) then
            expdx = exp(-dx)
            an    = an + expdx
            fn = fn + y_points(i)*expdx
          endif
        enddo
        if(an.le.0.0) then
           write(*,*)'===> Error in smooth gauss.',
     &                       ' Width might be too small'
           stop
        endif
        y_current = fn/an
      endif

      return
      end
C        
      subroutine SMOOTH_GAUSS_D(n_points,kernel_width,x_points,y_points,
     &                 x_current,y_current,y_derivs)
      implicit none
      integer n_points
      real kernel_width
      real x_points(*)
      real y_points(*)
      real y_derivs(*)
      real x_current,y_current
C
C----Uses gussian smoothining to calculate value of function at the given 
C----point. Returns value of the function. Uses direct calculation. Alternative
C----is use of FFT for all points using convolution theorem.
C
C---This routine returns derivative of the function wrt y_current also
C----local variables
C
      integer i
      real expdx,an,fn,dx,dx1
      real kernel_width2
C
      if(n_points.eq.1) then
        y_current = y_points(1)
        y_derivs(1) = 1.0
        return
      endif
      kernel_width2 = kernel_width**2*2.0
      if(x_current.le.x_points(n_points).and.x_current.ge.x_points(1)) 
     &                                                    then
        an = 0.0
        fn = 0.0
        do  i=1,n_points
          dx = (x_current-x_points(i))**2/(kernel_width2)
          if(dx.le.30.0) then
            expdx = exp(-dx)
            an = an + expdx
            fn = fn + y_points(i)*expdx
            y_derivs(i) = expdx
          endif
        enddo
        if(an.le.0.0) then
cd           write(*,*)n_points,kernel_width
           write(*,*)'===> Error in smooth gauss.',
     &                       ' Width might be too small'
           stop
        endif
        y_current = fn/an
C
C---calculate derivatives
        do   i=1,n_points
          dx = (x_current-x_points(i))**2/kernel_width2
          if(dx.le.30.0) then
            y_derivs(i) = y_derivs(i)/an
          else
            y_derivs(i) = 0.0
          endif
        enddo
      elseif(x_current.gt.x_points(n_points)) then
        dx1 = (x_current-x_points(n_points))**2/(kernel_width2)
        an  = 1.0
        fn  = y_points(n_points)
        y_derivs(n_points) = 1.0
        do   i=1,n_points-1
          dx = (x_current-x_points(i))**2/(kernel_width2) - dx1
          if(dx.le.30.0) then
            expdx = exp(-dx)
            an    = an + expdx
            fn = fn + y_points(i)*expdx
            y_derivs(i) = expdx
          endif
        enddo
        if(an.le.0.0) then
           write(*,*)'===> Error in smooth gauss.',
     &                       ' Width might be too small'
           stop
        endif
        y_current = fn/an
C
C---calculate derivatives
        do   i=1,n_points
          dx = (x_current-x_points(i))**2/kernel_width2 - dx1
          if(dx.le.30.0) then
            y_derivs(i) = y_derivs(i)/an
          else
            y_derivs(i) = 0.0
          endif
        enddo
      elseif(x_current.lt.x_points(1)) then
        dx1 = (x_current-x_points(1))**2/(kernel_width2)
        an = 1.0
        fn = y_points(1)
        y_derivs(1) = 1.0
        do   i=2,n_points
          dx = (x_current-x_points(i))**2/(kernel_width2)-dx1
          if(dx.le.30.0) then
            expdx = exp(-dx)
            an    = an + expdx
            fn = fn + y_points(i)*expdx
            y_derivs(i) = expdx
          endif
        enddo
        if(an.le.0.0) then
           write(*,*)'===> Error in smooth gauss.',
     &                       ' Width might be too small'
           stop
        endif
        y_current = fn/an
C
C---calculate derivatives
        do   i=1,n_points
          dx = (x_current-x_points(i))**2/kernel_width2 - dx1
          if(dx.le.30.0) then
            y_derivs(i) = y_derivs(i)/an
          else
            y_derivs(i) = 0.0
          endif
        enddo
      endif

      return
      end            
C
      subroutine find_avemaxrms(nv,dv,ave_shift,max_shift,rms_shift)
C
C---find average, absolute maximum and rms for the given vector
C
      integer nv
      real ave_shift,max_shift,rms_shift
      real dv(*)
C
      integer i
C
      ave_shift = 0.0
      max_shift = -1.0E32
      rms_shift = 0.0
      do i =1,nv
        ave_shift = ave_shift + dv(i)
        max_shift = amax1(max_shift,abs(dv(i)))
        rms_shift = rms_shift + dv(i)**2
      enddo
      ave_shift = ave_shift/nv
      rms_shift = sqrt(rms_shift/nv-ave_shift**2)
      return
      end
C
      real function exp_r(xx)
      implicit none
      include 'expcost.fh'
      real xx
      integer ind

      ind = max(1,min(nmaxexp,int(abs(xx)/argstep+1.5)))
cd      write(*,*)ind,etab(ind),argmax,argstep,nmaxexp,xx
      if(xx.ge.0.0) then
         exp_r = etab(ind)
      else if(xx.gt.-argmax) then
         exp_r = 1.0/etab(ind)
      else
         exp_r = 0.0
      endif

      end

      subroutine print_prerefine_info
      use ncs_constraints

      integer i
      real alpha,beta,gamma
      real psi,phi,chi
      real radtodeg
      logical error
c
c---  bodyxs
      radtodeg = 45.0/atan(1.0)

      if(n_ncs_const.gt.1) then
         write(*,'(150a)')('-',j=1,120)
         call header('Info about NCS constraints operators')
         write(*,*)'NCS operaters are parameterised in three forms:'
         write(*,*)'1) Matrix and vector: First nine elements of '//
     &        'ncsconst matrix are rotation and the last three '//
     &        'elements are translations'
         write(*,*)'2) Euler angles and vector:  First three '//
     &        'elements are alpha beta gamma and the last three '//
     &        'elements are translations'
         write(*,*)'3) Polar angles and vector: First three '//
     &        'elements are angles - psi,phi,chi and the last '//
     &        'three elements are translations'
         write(*,*)
         write(*,'(150a)')('-',j=1,120)
         do i=1,n_ncs_const
            write(*,*)'#'
            write(*,*)'#  NCS operator ',i
            write(*,*)'#'
           write(*,*)'ncsconst matrix -'
           write(*,*)ncs_c_rot(1,1:3,i),' -'
           write(*,*)ncs_c_rot(2,1:3,i),' -'
           write(*,*)ncs_c_rot(3,1:3,i),' -'
           write(*,*)ncs_c_tr(1:3,i)

           call matr2eul_unsafe(ncs_c_rot(1:3,1:3,i),alpha,beta,gamma)
           write(*,*)'ncsconst euler ',
     &          alpha*radtodeg,beta*radtodeg,
     &          gamma*radtodeg,ncs_c_tr(1:3,i)
           call polar(ncs_c_rot(1:3,1:3,i),psi,phi,chi)
           write(*,*)'ncsconst polar ',psi,phi,chi,ncs_c_tr(1:3,i)
         enddo
         write(*,'(150a)')('-',j=1,120)
         write(*,*)
      endif
      end
