program MultiImpute
  use mtz_things
  use CellAndSymmetry
  use parser_things
  use GlebSasha
  use AsymList
  implicit none

  character(len=512) :: labin_c=' ',labout_c=' '

  !
  !   mtz things
  integer i_int_obs,i_sig_obs,i_free
  real :: res_max=0.0,res_max_mtz=0.0
  real res_max1
  !
  !   Free things
  real free_fraction
  integer irfrac,nfree_max
  integer :: irand,nrand = 1000
  real rvec(1000)
  !
  integer nasym
  integer, allocatable :: hkl_asym(:,:),hkl_obs(:,:)
  integer ir,ia,itemp
  integer nref
  real, allocatable :: iobs(:,:),iobs_asym(:,:),fobs(:,:,:)
  integer, allocatable :: freer(:),freer_asym(:)

  integer, allocatable :: index(:)
  integer nobs_pos

  !
  !   Read all mtz

  CALL CCP4_PROG_VERSION('MultImp_gen',0)
  CALL CCPFYP
  CALL MTZINI


  call read_instrs
  call assign_intensity_labels
  call read_mtz_info
  call read_mtz
  res_max = max(res_max,res_max_mtz)

  res_max1 = sqrt(res_max)/2.0
  call asym_list_size(nsym,nsym,rot,tr,cell,nasym,res_max1)
  allocate(hkl_asym(3,nasym))
  call asym_list(nsym,nsym,rot,tr,cell,nasym,res_max1,hkl_asym)

  allocate(index(nref))

  call to_asym_unit(hkl_obs)
  do ir=1,nref
     index(ir) = ir
  enddo
  do ir=1,nref
     itemp = hkl_obs(1,ir)
     hkl_obs(1,ir) = hkl_obs(3,ir)
     hkl_obs(3,ir) = itemp
  enddo
  call iheap_sort_r(nref,3,hkl_obs,index)
  do ir=1,nref
     itemp = hkl_obs(1,ir)
     hkl_obs(1,ir) = hkl_obs(3,ir)
     hkl_obs(3,ir) = itemp
  enddo

  allocate(iobs_asym(2,nasym))
  allocate(freer_asym(nasym))
  iobs_asym(1:2,1:nasym) = 0
  freer_asym(1:nasym) = -1

  ir = 1
  ia = 1
  do while(ir.le.nref.and.ia.le.nasym)
     if(hkl_obs(3,ir).lt.hkl_asym(3,ia)) then
        ir = ir + 1
     else if(hkl_obs(3,ir).gt.hkl_asym(3,ia)) then
        ia = ia + 1
     else
        if(hkl_obs(2,ir).lt.hkl_asym(2,ia)) then
           ir = ir + 1
        else if(hkl_obs(2,ir).gt.hkl_asym(2,ia)) then
           ia = ia + 1
        else
           if(hkl_obs(1,ir).lt.hkl_asym(1,ia)) then
              ir = ir + 1
           else if(hkl_obs(1,ir).gt.hkl_asym(1,ia)) then
              ia = ia + 1
           else
              iobs_asym(1:2,ia) = iobs(1:2,index(ir))
              freer_asym(ia)    = freer(index(ir))
              ir = ir + 1
           endif
        endif
     endif
  enddo
  nobs_pos = 0
  do ir=1,nasym
     if(iobs_asym(2,ir).gt.0.0) nobs_pos = nobs_pos + 1
  enddo
  deallocate(index)
  deallocate(hkl_obs)
  deallocate(iobs)
  deallocate(freer)
  !
  !   Complete freeR set. Use the same fraction as it was in the mtz file. Add only for those reflections that 
  !   are generated de-novo
  irfrac = nint(1.0/free_fraction)
  call ranmar(rvec,nrand)
  nfree_max = maxval(freer_asym(1:nasym))
  irand = 0
  do ir=1,nasym
     if(freer_asym(ir).ge.0) cycle
     irand = irand + 1
     if(irand.gt.nrand) then
        call ranmar(rvec,nrand)
        irand = 1
     endif
     freer_asym(ir) = min(nfree_max,max(0,min(irfrac-1,int(irfrac*rvec(irand)))))
  enddo
  !
  !   Complete freer flags
  call scale_GlebSasha_I(hkl_asym,iobs_asym)
  !
  !   Generate some stats

  !
  !   Convert to Fs and generate randoms etc. Prepare for refinement
  call generate_and_write_mtz
  deallocate(iobs_asym)
  deallocate(freer_asym)
  deallocate(hkl_asym)

contains
  subroutine read_instrs
    !
    !   Parse labin, resolution for data to be taken, maximum resolution to extend etc. 
    !   These things should be command line
    !
    integer itk
    !
    !   body
    key = ' '
    line_parse = ' '
    lend = .FALSE.
    do while(key.ne.'END' .and. .not.lend)
       line_parse = ' '
       call parser(key,line_parse,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,lprint)
       write(*,*)trim(line_parse)
       call ccpupc(key)
       do itk=1,ntok
          call ccpupc(cvalue(itk))
       enddo
       if(key.eq.'LABI') then 
          labin_c = line_parse
       elseif(key.eq.'RESO') then
          itk = 2
          do while(itk.lt.ntok)
             if(cvalue(itk).eq.'EXTE') then
                itk = itk + 1
                res_max = max(0.0,fvalue(itk))
                itk = itk + 1
                if(res_max.gt.0.0) then
                   res_max = 1/res_max**2
                   res_max = res_max
                endif
             elseif(cvalue(itk).eq.'DATA') then
                itk = itk + 1
                res_max_mtz = max(0.0,fvalue(itk))
                itk = itk + 1
                if(res_max_mtz.gt.0.0) then
                   res_max_mtz = 1.0/res_max_mtz**2
                endif
             else
                itk = itk + 1
             endif
          enddo
       endif
    enddo
    return

  end subroutine read_instrs


  subroutine read_mtz_info
    
    integer i,j,is,isym_unit,nospgr,nsymp
    character namspg_cifs*20,nampg*20
    character text_now*128
    !
    integer temp_c
    real rrr(3,3,6)
    real res_max_mtz_1,res_min_mtz_1
    real, parameter :: pi = 4.0*atan(1.0)
    real, parameter :: rtodeg = 180.0/pi
    !
    !  Take all info from the mtz file
    call lrsort(mtzin,isort)
    IF (NDATASETS.GT.0.and.setid.gt.0) THEN
       pname_out(1) = pname(1)
       dname_out(1) = dname(1)
       xname_out(1) = xname(1)
       datwave_out(1) = datwave(1)
       datcell_out(1:6,1) = datcell(1:6,1)
       csetout(5:nlprgo) = 1
       csetout(1:4) = csetid(lookup(1))

       i = 1
       do while(i.le.ndatasets.and.isets(i).ne.setid)
          i = i + 1
       enddo
       if (i.le.ndatasets) then
          pname_out(2) = pname(i)
          dname_out(2) = dname(i)
          xname_out(2) = xname(i)
          datwave_out(2) = datwave(i)
          datcell_out(1:6,2) = datcell(1:6,i)
          ndatasets_out = 2
          cell_mtz(1:6) = datcell(1:6,i)
       else
          call ccperr(1,'Problem accessing datasets in mtz')
       endif
    endif
    if (minval(cell_mtz(1:6)).le.0.0.or.setid.le.0.or.ndatasets.le.0) then
       call lrcell(mtzin,cell_mtz)
    endif
    cell(1:6) = cell_mtz(1:6)
    call lstrsl(mtzin,cell(1),cell(2),cell(3),cell(4),cell(5),cell(6))
    call lrrsol(mtzin,res_min_mtz_1,res_max_mtz_1)
    if(res_max_mtz.gt.0.0) then
       res_max_mtz = min(res_max_mtz_1,res_max_mtz)
    else
       res_max_mtz = res_max_mtz_1
    endif
    if(res_max.le.0) then
       res_max = res_max_mtz_1
    endif

    call rbfro1(cell,volume,rrr)
    call rbrcel(rcell,rvol)
    !
    !  We may need these things later: rcell, rvol etc.
    CALL RBFRO1(CELL,VOLUME,RRR)
    CALL RBRCEL(RCELL,RVOL)

    nospgr = 0
    call lrsymi(mtzin,NumPrimSymm,Ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
    if(len_trim(SpaceGroupName).le.1)  nospgr = NumSpaceGroup
    if(trim(SpaceGroupName).eq.'R 3'.or. trim(SpaceGroupName).eq.'R3') then
       if(cell(6).le.5.0) then
          temp_c = nint(cell(6)*rtodeg)
       else
          temp_c = nint(cell(6))
       endif
       if(cell(1).eq.cell(2).and.temp_c.eq.120) then
          SpaceGroupName = 'H3'
       endif
    else if(trim(SpaceGroupName).eq.'H 3'.or.trim(SpaceGroupName).eq.'H3') then
       if(cell(1).eq.cell(2).and.cell(1).eq.cell(3).and.cell(4).eq.cell(6).and.cell(4).eq.cell(6)) then
          SpaceGroupName = 'R3'
       endif
    endif
    if(trim(SpaceGroupName).eq.'R 3 2'.or.trim(SpaceGroupName).eq.'R32') then
       if(cell(6).le.5.0) then
          temp_c = nint(cell(6)*rtodeg)
       else
          temp_c = nint(cell(6))
       endif
       if(cell(1).eq.cell(2).and.temp_c.eq.120) then
          SpaceGroupName = 'H32'
       endif
    else if(trim(SpaceGroupName).eq.'H 3 2'.or.trim(SpaceGroupName).eq.'H32') then
       if(cell(1).eq.cell(2).and.cell(1).eq.cell(3).and. cell(4).eq.cell(6).and.cell(4).eq.cell(6)) then
          SpaceGroupName = 'R32'
       endif
    endif

    call msymlb3(isym_unit,nospgr,SpaceGroupName,namspg_cifs,nampg,nsymp,NumSymmetry,RealSymmMatrx)

    NumSpaceGroup = nospgr
    call lrsymm(mtzin,NumSymmetry,RealSymmMatrx)
    CALL PGDEFN(PointGroupName,NumPrimSymm,NumSymmetry,RealSymmMatrx,LPRINT)
    CALL PGNLAU(PointGroupName,NumLaueSymm,LaueGroupName)
    !
    !---- Now set up the extinction check for soutfC
    CALL EPSLN(NumSymmetry,NumPrimSymm,RealSymmMatrx,0)
    CALL CENTRIC(NumSymmetry,RealSymmMatrx,0)
    NSMULT = NumSymmetry/NumPrimSymm
    rot(1:3,1:3,1:numsymmetry)=realsymmmatrx(1:3,1:3,1:numsymmetry)
    tr(1:3,1:numsymmetry)=realsymmmatrx(1:3,4,1:numsymmetry)
    NSYM  = NumSymmetry
    ISPNO = NumSpaceGroup
    write(*,*)'Space group                  = ',SpaceGroupName
    write(*,*)'Space group number           = ',nospgr
    write(*,*)'Number of symmetry operators = ',NumSymmetry
    write(*,*)'Space group elements '
    do is=1,NumSymmetry
       call put_symm_to_text(RealSymmMatrx(1:3,1:3,is),RealSymmMatrx(1:3,4,is),text_now)
       write(*,'(i5,2x,a)')is,trim(text_now)
    enddo
    write(*,*)
    return

  end subroutine read_mtz_info

  subroutine write_mtz_info
    !
    !   locals
    integer isetid
    integer :: iappnd = 0
    integer icol
    !
    !   body
    CALL LWCELL(MTZOUT,CELL)
    CALL LWSORT(MTZOUT,ISORT)
    !
    NumPrimSymm = NumSymmetry/NSMULT
    !            ******************************
    CALL LWSYMM(MTZOUT,NumSymmetry,NumPrimSymm,RealSymmMatrx,Ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
    ! Store the project name and dataset name in the mtz header:
    IF (NDATASETS_out.GT.0) THEN
       DO ISET = 1,NDATASETS_out
          CALL LWIDX(MTZOUT,PNAME_out(ISET),XNAME_out(ISET),DNAME_out(ISET),DATCELL_out(1,ISET),DATWAVE_out(ISET))
       ENDDO
       do  icol=1,nlprgo
          isetid = csetout(icol)+1
          xname_col(icol) = xname_out(isetid)
          dname_col(icol) = dname_out(isetid)
       enddo
       CALL LWIDASX(MTZOUT,NLPRGO,XNAME_col,DNAME_col,0)
    ENDIF

  end subroutine write_mtz_info

  subroutine assign_intensity_labels
    !
    !    Open mtz file and assign labels. We generate 21 different Fs. 20 of them randomly from Wilson distribution
    !    and one for F=<F>. Standard deviation is a problem. At the moment we use Sigma of Wilson distribution as standard
    !    deviation
    !
    !   locals
    integer iprint,ifail,itk
    integer i,icell,ir
    integer ncol
    character*2 ch2
    character*20 ff
    character ip_name*20,sigip_name*20,free_name*20,cl_tmp*20,cl_save*20
    !
    !   body
    !
    mtzin = 1
    i_int_obs = 4
    i_sig_obs = 5
    i_free    = 6
    iprint =  0
    ifail  = -1

    nlprgi = 6
    lsprgi(1) = 'H'
    ctprgi(1) = 'H'
    lsprgi(2) = 'K'
    ctprgi(2) = 'H'
    lsprgi(3) = 'L'
    ctprgi(3) = 'H'
    lsprgi(4) = 'IP'
    ctprgi(4) = 'J'
    lsprgi(5) = 'SIGIP'
    ctprgi(5) = 'Q'
    lsprgi(6) = 'FREE'
    ctprgi(6) = 'I'

    write(*,*)'Here'
    call lropen(mtzin,'HKLIN',iprint,ifail)

    clabs(1:mcols) = ' '
    ctyps(1:mcols) = ' '
    call lrclab(mtzin,clabs,ctyps,ncol)
    !
    !   If there is no labin then try to extract form the file
    if(len_trim(labin_c).le.0) then
       !
       !  Try to extract label for intensities 
       labin_c = 'LABIN'
       ip_name = ' '
       do i=1,ncol
          if(ctyps(i).eq.'J') then
             labin_c = trim(labin_c)//' IP='//trim(clabs(i))
             ip_name = trim(clabs(i))
             exit
          endif
       enddo
       if(len_trim(ip_name).le.0) then
          write(*,*)
          write(*,*)'There are no intensities in the file.'
          call ccperr(1,'Fatal error: Problem with the input file')
       endif

       sigip_name = ' '
       cl_save = ' '
       do i=1,ncol
          if(ctyps(i).eq.'Q') then
             cl_save = clabs(i)
          endif
          cl_tmp = clabs(i)
          call ccpupc(cl_tmp(1:3))
          if(trim(cl_tmp).eq.'SIG'//trim(ip_name)) then
             labin_c = trim(labin_c)//' SIGIP='//trim(clabs(i))
             sigip_name = clabs(i)
             exit
          endif
       enddo
       if(len_trim(sigip_name).le.0.and.len_trim(cl_save).gt.0) then
          labin_c = trim(labin_c)//' SIGIP='//trim(cl_save)
          sigip_name = trim(cl_save)
       endif
       if(len_trim(sigip_name).le.0) then
          write(*,*)
          write(*,*)'There are no sigmas in the file.'
          call ccperr(1,'Fatal error: Problem with the input file')
       endif
       free_name = ' '
       do i=1,ncol
          if(ctyps(i).eq.'I') then
             labin_c = trim(labin_c)//' FREE='//trim(clabs(i))
             free_name = trim(clabs(i))
             exit
          endif
       enddo
       if(len_trim(free_name).le.0) then
          write(*,*)
          write(*,*)'There is no free R flag in the file. File must contain free R flag'
          call ccperr(1,'Fatal error: Problem with the input file')
       endif
    endif

    call parser(key,labin_c,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,lprint)
    call lkyin(mtzin,lsprgi,nlprgi,ntok,labin_c,ibeg,iend)
    call lrassn(mtzin,lsprgi,nlprgi,lookup,ctprgi)


    if(lookup(i_int_obs).le.0.or.lookup(i_sig_obs).le.0.or.lookup(i_free).le.0) then
       call ccperr(1,'Fatal error: intensities, sigmas or freeR are absent from the input file')
    endif
    !
    !   Take datasets name 
    ndatasets = msets
    CALL LRIDX(MTZIN,PNAME,XNAME,DNAME,ISETS,DATCELL,DATWAVE,NDATASETS)
    IF (NDATASETS.GT.0) CALL LRCLID(MTZIN,CSETID,NCOL)
    setid = 0
    if(LookUp(i_int_obs).ne.0) then
       setid = csetid(lookup(i_int_obs))
    endif
    !
    !   Sort out output file. We will write 21 output files
    labout_c = 'LABOUT'
    ctprgo(1:3) = 'H'
    lsprgo(1) = 'H'
    lsprgo(2) = 'K'
    lsprgo(3) = 'L'
    lsprgo(4) = 'F_i2f'
    ctprgo(4) = 'F'
    lsprgo(5) = 'SIGF_i2f'
    ctprgo(5) = 'Q'
    labout_c = trim(labout_c)//' FI2F=F_i2f SIGFI2F=SIGF_i2f'
    do i=2,21
       write(ch2,'(i2)')i
       ff = 'F'//trim(adjustl(ch2))
       labout_c = trim(labout_c)//' '//trim(ff)//'='//trim(ff)
       labout_c = trim(labout_c)//' '//'SIG'//trim(ff)//'='//'SIG'//trim(ff)
       ctprgo(3+2*i-1) = 'F'
       ctprgo(3+2*i) = 'Q'
       lsprgo(3+2*i-1) = trim(ff)
       lsprgo(3+2*i) = 'SIG'//trim(ff)
    enddo
    lsprgo(46) = 'F_exp'
    ctprgo(46) = 'F'
    lsprgo(47) = 'SIGF_exp'
    ctprgo(47) = 'Q'
    labout_c = trim(labout_c)//' Fexp=F_exp SIGFexp=SIGF_exp'

    write(*,*)free_name
    labout_c = trim(labout_c)//' FREE='//trim(free_name)
    ctprgo(48) = 'I'
    lsprgo(48) = trim(free_name)
    !
    call lwopen(mtzout,'HKLOUT')
    ntok  = 200
    call parser(key,labout_c,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,.FALSE.)
    nlprgo = 48
    call lkyout(mtzout,lsprgo,nlprgo,ntok,labout_c,ibeg,iend)
    call lwassn(mtzout,lsprgo,nlprgo,ctprgo,0)
    call lwclab(mtzout,lsprgo,nlprgo,ctprgo,0)

  end subroutine assign_intensity_labels

  subroutine read_mtz

    !
    !   Read intensities and hkl from mtz.

    !
    ! locals
    integer iref
    logical eof
    real ssq
    real adata(100)
    !
    !   Free things
    real perc_free,fraction
    real res_min_l,res_max_l
    integer nfree_max,free_sum

    !
    !  body
    call lrrewd(mtzin)

    iref = 0
    call lrrefl(mtzin,ssq,adata,eof)
    do while(.not.eof)
       if(res_max_mtz.le.0.0 .or. ssq.le.res_max_mtz) then
          iref = iref + 1
       endif
       call lrrefl(mtzin,ssq,adata,eof)
    enddo

    nref = iref
    allocate(hkl_obs(3,nref))
    allocate(iobs(2,nref))
    iobs(1:2,1:nref) = 0.0
    allocate(freer(nref))
    freer(1:nref) = -1

    call lrrewd(mtzin)
    iref = 0
    call lrrefl(mtzin,ssq,adata,eof)
    free_sum = 0
    res_min_l = 1.0e32
    res_max_l = -1.0e32
    open(22)
    do while(.not.eof)
       if(res_max_mtz.le.0.0 .or. ssq.le.res_max_mtz) then
          iref = iref + 1
          call lrrefm(mtzin,logmss)

          hkl_obs(1:3,iref) = nint(adata(1:3))
          if(.not.logmss(lookup(i_int_obs)).and. .not.logmss(lookup(i_sig_obs))) then
             iobs(1,iref) = adata(lookup(i_int_obs))
             iobs(2,iref) = adata(lookup(i_sig_obs))
             write(22,*)ssq,iobs(1:2,iref)
             res_min_l = min(res_min_l,ssq)
             res_max_l = max(res_max_l,ssq)
          endif
          if(.not.logmss(lookup(i_free))) then
             freer(iref) = nint(adata(lookup(i_free)))
             if(freer(iref).eq.0) then
                free_sum = free_sum + 1
             endif
          endif
       endif
       call lrrefl(mtzin,ssq,adata,eof)
    enddo
    perc_free = 0.0
    fraction = float(free_sum)/iref
    nfree_max = nint(1.0/fraction)
    free_fraction = 1.0/float(nfree_max)
    write(*,*)'The number of reflections from mtz = ',iref
    write(*,*)'Percentage of free reflections     = ',free_fraction*100.0
    write(*,*)'Minimum resolution of the data     = ',sqrt(1.0/res_min_l)
    write(*,*)'Maximum resolution of the data     = ',sqrt(1.0/res_max_l)
    write(*,*)'Extension resolution               = ',sqrt(1.0/res_max)
    call lrclos(mtzin,0)
    !
    !   Sort out the nature of free: percentage etc
  end subroutine read_mtz

  subroutine generate_and_write_mtz

    integer i,ir
    real bdata(100)
    integer :: iappnd=0
    !
    !    body
    mtzout = 2
    call lwtitl(mtzout,'Data for Multiple Imputation',1)
    !    call lwassn(mtzout,lsprgo,nlprgo,ctprgo,iappnd)    
    
    call write_mtz_info

    allocate(fobs(2,nasym,22))
    fobs(1:2,1:nasym,1:22) = 0.0

    !
    !   Convert intensities to Fs using French & Wilson method.    
    call convert_I2F(hkl_asym,iobs_asym,fobs(1:2,1:nasym,1))
    !
    !  Generate random numbers using Wilson distribution for reflections that have not been observed
    do i=2,22
       fobs(1:2,1:nasym,i) = fobs(1:2,1:nasym,1)
    enddo
    !
    !   Generate expected valuse for reflections that have not been observed
    do i=1,20
       call random_generate_chisq(hkl_asym,fobs(1:2,1:nasym,i+1))
    enddo
    call expected_value_chisq(hkl_asym,fobs(1:2,1:nasym,22))
    do ir=1,nasym
       call equal_magic(mtzout,bdata,nlprgo)
       bdata(1:3) = hkl_asym(1:3,ir)
       do i=1,22
          if(fobs(2,ir,i).gt.0.0) then
             bdata(3 + 2*i-1) = fobs(1,ir,i)
             bdata(3 + 2*i)   = fobs(2,ir,i)
          endif
       enddo
       bdata(48) = freer_asym(ir)
       call lwrefl(mtzout,bdata)
    enddo
    call lwclos(mtzout,0)
    deallocate(fobs)

  end subroutine generate_and_write_mtz

end program MultiImpute
