module bvalue_routines
implicit none

contains
  subroutine add_mixed_bvalues(nmodel)
    use atomcom
    use restr_files
    !
    !  Things for parser
    character line*512
    integer   ntok
    logical ::  lprint=.FALSE.
    logical ::  lend
    real      fvalue(500)
    integer   ibeg(500),iend(500),ityp(500),idec(500)
    character key*4
    character cvalue(500)*4
    !
    integer, intent(in) :: nmodel
    !
    !  locals. Things for atom slection, local file openings etc
    integer ikey_file,lend_f,ierr
    integer ires_beg_sel,ires_end_sel
    integer :: nmax_atom_select_loc=100
    integer natom_select
    character(len=4) :: atom_select(100)
    character(len=4) :: chnid_sel
    !
    !   chain names etc from as in pdb
    integer ires_pdb
    character(len=4) :: chnnmp
    !
    !  running vriables
    integer i,j,itk,l,im
    !
    !  Some other useful intermediate parameters
    logical :: apply
    !
    !   body
    line = ' '
    key  = ' '
    lprint = .FALSE.
    ntok   = 500
    call open_form_file(ikey_file,keywords_file,ierr)
    lend_f = 0
    do while(len_trim(line).eq.0.and.lend_f.eq.0)
       read(ikey_file,'(a)',iostat=lend_f)line
    enddo
    if(lend_f.eq.0) then
       call parser(key,line,ibeg,iend,ityp,fvalue,cvalue,idec,   &
            ntok,lend,lprint)
       call ccpupc(key)
       do i=1,ntok
          call ccpupc(cvalue(i))
       enddo
    endif
    !
    !  Read keyword file till the end and try to interpret
    do while(lend_f.eq.0.and.key(1:3).ne.'END') 
       !
       !  Instruction line should start BREF MIXED ANISO. It may allow us to add more options for 
       !  BREF as well as MIXED        
       natom_select = 0
       if(key(1:4).eq.'BREF') then
          if(cvalue(2).eq.'MIXE') then
             itk = 3
             if(cvalue(itk).eq.'ANIS') then
                itk = itk+1
                if(cvalue(itk).eq.'RESI') then
                   itk = itk + 1
                   if(cvalue(itk).eq.'FROM') then
                      call read_fromto1(ntok,itk,cvalue,line,ibeg,iend,ityp,fvalue,ires_beg_sel,ires_end_sel,chnid_sel,ierr)
                   else
                      if(ityp(itk).eq.2) then
                         ires_beg_sel = nint(fvalue(itk))
                         ires_end_sel = ires_beg_sel
                         itk = itk + 1
                         chnid_sel = line(ibeg(itk):iend(itk))
                         itk = itk + 1
                      else
                         write(*,*)'Error==> Problem in treat_mixed_bvalue. Wrong keyword'
                         write(*,*)'Error==> Correct keyword should be:'
                         call ccperr(1,'Keyword interpretation error')
                      endif
                   endif
                   if(cvalue(itk).eq.'ATOM') then
                      itk = itk + 1
                      natom_select = ntok-itk+1
                      if(natom_select.gt.0) then
                         if(natom_select.gt.nmax_atom_select_loc) then
                            write(*,*)'Error in treat_mixed_bvalue. Too many atom selection'
                            call ccperr(1,'Problem in atom selection')
                         endif
                         do i=itk,ntok
                            atom_select(i-itk+1) = line(ibeg(i):iend(i))
                         enddo
                      endif
                   endif
                   !
                   !  now apply selection
                   do i=1,n_atom
                      apply=.FALSE.
                      call get_chain_namepdb(chnnmp,i_resid(i))
                      if(chnnmp.eq.chnid_sel) then
                         read(res_num_pdb(i_resid(i))(3:6),*)ires_pdb
                         if(ires_pdb.ge.ires_beg_sel.and.ires_pdb.le.ires_end_sel) then
                            if(natom_select.le.0) then
                               apply=.TRUE.
                            else
                               do j=1,natom_select
                                  l = len_trim(atom_select(j))
                                  if(atom_select(j)(l:l).eq.'*') then
                                     if(l.le.1) then
                                        apply=.TRUE.
                                     else
                                        if(atm_name(i)(1:l-1).eq.atom_select(j)(1:l-1)) apply=.TRUE.
                                     endif
                                  else
                                     if(atm_name(i).eq.atom_select(j))  apply=.TRUE.
                                  endif
                               enddo
                            endif
                         endif
                      endif
                      if(apply.and.u_aniso(2,i).le.0.0) then
                         do im=1,nmodel
                            if(im.eq.1) then
                               u_aniso(1:3,i) = u_aniso(1,i)
                               u_aniso(4:6,i) = 0.0
                            endif
                            u_aniso_mod(1:3,i,im) = u_aniso_mod(1,i,im)
                            u_aniso_mod(4:6,i,im) = 0.0
                         enddo
                      endif
                   enddo
                elseif(cvalue(itk).eq.'ATOM') then
                   itk = itk + 1
                   natom_select = ntok-itk+1
                   if(natom_select.gt.0) then
                      do i=itk,ntok
                         atom_select(i-itk+1) = line(ibeg(i):iend(i))
                      enddo
                      do i=1,n_atom
                         apply = .FALSE.
                         do j=1,natom_select
                            l=len_trim(atom_select(j))
                            if(atom_select(j)(l:l).eq.'*') then
                               if(l.le.1) then
                                  apply=.TRUE.
                               else
                                  if(atm_name(i)(1:(l-1)).eq.atom_select(j)(1:(l-1))) apply=.TRUE.
                               endif
                            else
                               if(atm_name(i).eq.atom_select(j)) apply = .TRUE.
                            endif
                         enddo
                         if(apply.and.u_aniso(2,i).le.0.0) then
                            do im=1,nmodel
                               if(im.eq.1) then
                                  u_aniso(1:3,i) = u_aniso(1,i)
                                  u_aniso(4:6,i) = 0.0
                               endif
                               u_aniso_mod(1:3,i,im) = u_aniso_mod(1,i,im)
                               u_aniso_mod(4:6,i,im) = 0.0
                            enddo
                         endif
                      enddo
                   endif
                endif
             endif
          endif
       endif
       line = ' '
       do while(len_trim(line).eq.0.and.lend_f.eq.0)
          read(ikey_file,'(a)',iostat=lend_f)line
       enddo
       if(lend_f.eq.0) then
          call parser(key,line,ibeg,iend,ityp,fvalue,cvalue,idec,   &
               ntok,lend,lprint)
          call ccpupc(key)
          do i=1,ntok
             call ccpupc(cvalue(i))
          enddo
       endif
    enddo
    close(ikey_file)
  end subroutine add_mixed_bvalues

end module bvalue_routines
