      subroutine idensity_extend_plane(n1,n2,n3,nx,ny,nz,den,
     &     nsym,rot,tr)
      implicit none
c
c--Adds planes to the electron density
      integer n1,n2,n3,nx,ny,nz
      integer den(0:n1+1,0:n2+1,0:n3+1)
      integer nsym
      real rot(3,3,nsym),tr(3,nsym)
c
      integer ix,iy,iz,is
      integer ixin(3),ixs(3)
      integer irot(3,3,nsym),itr(3,nsym)
c
c---Convert symmetry elements to integers
      call find_int_symm(nsym,rot,tr,nx,ny,nz,irot,itr)
c
c--Add planes on each side to make references to symmetry related poitns easy
      do ix=0,n1+1
         do iy=0,n2+1
            iz=0
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 1
               endif
            enddo
 1          continue
            iz = n3 + 1
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 2
               endif
            enddo
 2          continue
         enddo
      enddo
      do ix=0,n1+1
         do iz=0,n3+1
            iy=0
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 3
               endif
            enddo
 3          continue
            iy = n2 + 1
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 4
               endif
            enddo
 4          continue
         enddo
      enddo

      do iy=0,n2+1
         do iz=0,n3+1
            ix=0
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 5
               endif
            enddo
 5          continue
            ix = n1 + 1
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 6
               endif
            enddo
 6          continue
         enddo
      enddo

      return
      end
c
      subroutine density_extend_plane(n1,n2,n3,nx,ny,nz,den,
     &     nsym,rot,tr)
      implicit none
c
c--Adds planes to the electron density
      integer n1,n2,n3,nx,ny,nz
      real den(0:n1+1,0:n2+1,0:n3+1)
      integer nsym
      real rot(3,3,nsym),tr(3,nsym)
c
      integer ix,iy,iz,is
      integer ixin(3),ixs(3)
      integer irot(3,3,nsym),itr(3,nsym)
c
c---Convert symmetry elements to integers
      call find_int_symm(nsym,rot,tr,nx,ny,nz,irot,itr)
c
c--Add planes on each side to make references to symmetry related poitns easy
      do ix=0,n1+1
         do iy=0,n2+1
            iz=0
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 1
               endif
            enddo
 1          continue
            iz = n3 + 1
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 2
               endif
            enddo
 2          continue
         enddo
      enddo
      do ix=0,n1+1
         do iz=0,n3+1
            iy=0
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 3
               endif
            enddo
 3          continue
            iy = n2 + 1
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 4
               endif
            enddo
 4          continue
         enddo
      enddo

      do iy=0,n2+1
         do iz=0,n3+1
            ix=0
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 5
               endif
            enddo
 5          continue
            ix = n1 + 1
            ixin(1) = ix-1
            ixin(2) = iy-1
            ixin(3) = iz-1
            do is=1,nsym
               ixs = matmul(irot(1:3,1:3,is),ixin)+itr(1:3,is)
               ixs(1) = modulo(ixs(1),nx)+1
               ixs(2) = modulo(ixs(2),ny)+1
               ixs(3) = modulo(ixs(3),nz)+1
               if(ixs(1).le.n1.and.ixs(2).le.n2.and.ixs(3).le.n3) then
                  den(ix,iy,iz) = den(ixs(1),ixs(2),ixs(3))
                  goto 6
               endif
            enddo
 6          continue
         enddo
      enddo

      return
      end
