module lib_com
    !===================================================================
   !
   !    Minimal values of parameters depend on the program which uses those
   !    common blocks, i.e. depend on the number of different kinds of
   !    monomers are in the structure. 
   !
   !===================================================================
   !
   !     Parameters of the library.
   !
   !===================================================================
   !     Library of monomers.
   !       
  INTEGER MAXMLIST
  PARAMETER (MAXMLIST  =20000 )
  INTEGER MAXMMON
  PARAMETER (MAXMMON   =  5000 )
  INTEGER MAXMATM
  PARAMETER (MAXMATM   = 40 * MAXMMON )
  INTEGER MAXMCNN
  PARAMETER (MAXMCNN   = MAXMMON * 20 )
  INTEGER MAXMBND
  PARAMETER (MAXMBND   = MAXMATM * 2  )
  INTEGER MAXMANG
  PARAMETER (MAXMANG   =  2 * MAXMATM )
  INTEGER MAXMTOR
  PARAMETER (MAXMTOR   = MAXMATM )
  INTEGER MAXMCHR
  PARAMETER (MAXMCHR   = 3 * MAXMMON )
  INTEGER MAXMPLN
  PARAMETER (MAXMPLN   = 2 * MAXMMON )
  INTEGER MAXMAPL
  PARAMETER (MAXMAPL   =  200 )
  INTEGER MAXASYMB
  PARAMETER (MAXASYMB  = 500 )
  INTEGER MAXNSYM
  PARAMETER (MAXNSYM   =  96 )
   !
   !     PARAMETER (MAXETYP   =  50 )
   !
   ! ---------
   !  MAXMLIST - max number of monomers in the library list, i.e.
   !             list of all monomer in the library.
   !  MAXMMON  - max number of kind of monomers which be used.
   !  MAXMATM  - max number of atoms in the all used kinds of monomers
   !  MAXMBND  - max number of bonds in the all used kinds of monomers 
   !  MAXMANG  - max number of angles in the all used kinds of monomers
   !  MAXMTOR  - max number of torsion angles in the all used kinds of monomers
   !  MAXMCHR  - max number of chiralities in the all used kinds of monomers
   !  MAXMPLN  - max number of plans in the all used kinds of monomers
   !  MAXMAPL  - max number of atoms in the plan.
   !  MAXASYMB - max number of different kind of atom / for atom. scatt. SF/
   !  MAXNSYM  - max number of cryst. symmetry operators.
   !
   !  MAXETYP  - max number of different chemical types of atom
   !
   ! ---------
  INTEGER MAXLLNK
  PARAMETER (MAXLLNK   = 500)
  INTEGER MAXLATM
  PARAMETER (MAXLATM   = 30 * MAXLLNK )
  INTEGER MAXLCNN
  PARAMETER (MAXLCNN   = MAXLATM )
  INTEGER MAXLBND 
  PARAMETER (MAXLBND   = MAXLATM )
  INTEGER MAXLANG
  PARAMETER (MAXLANG   =  2 * MAXLATM )
  INTEGER MAXLTOR
  PARAMETER (MAXLTOR   = MAXLATM )
  INTEGER MAXLCHR
  PARAMETER (MAXLCHR   = 3 * MAXLLNK )
  INTEGER MAXLPLN
  PARAMETER (MAXLPLN   = 2 * MAXLLNK )
  INTEGER MAXLAPL
  PARAMETER (MAXLAPL   = 50 )
   !-------
   !  MAXLLNK - max number of link's type in the library.
   !  MAXLATM
   !  MAXLBND
   !  MAXLANG
   !  MAXLTOR
   !  MAXLCHR
   !  MAXLPLN
   !  MAXLAPL
   ! ---------
  INTEGER MAXDMDF
  PARAMETER (MAXDMDF   = 400)
  INTEGER MAXDATM
  PARAMETER (MAXDATM   = 30 * MAXDMDF )
  INTEGER MAXDCNN
  PARAMETER (MAXDCNN   = MAXDATM )
  INTEGER MAXDBND
  PARAMETER (MAXDBND   = MAXDATM )
  INTEGER MAXDANG
  PARAMETER (MAXDANG   =  2 * MAXDATM )
  INTEGER MAXDTOR
  PARAMETER (MAXDTOR   = MAXDATM )
  INTEGER MAXDCHR
  PARAMETER (MAXDCHR   = 3 * MAXDMDF )
  INTEGER MAXDPLN
  PARAMETER (MAXDPLN   = 2 * MAXDMDF )
  INTEGER MAXDAPL
  PARAMETER (MAXDAPL   = 50 )
   ! ---------
   !  MAXDMDF - max number of modification's type in the library.
   !  MAXDATM
   !  MAXDBND
   !  MAXDANG
   !  MAXDTOR
   !  MAXDCHR
   !  MAXDPLN
   !  MAXDAPL
   ! ===========================================================
   !     Library of energetic parameters.
   !
  INTEGER MAXETYP
  PARAMETER (MAXETYP   = 500 )
  INTEGER MAXBTYP
  PARAMETER (MAXBTYP   = 800 )
  INTEGER MAXWTYP
  PARAMETER (MAXWTYP   = 500 )
  INTEGER MAXHTYP
  PARAMETER (MAXHTYP   = 300 )
  INTEGER MAXATYP
  PARAMETER (MAXATYP   =1500 )
  INTEGER MAXTTYP
  PARAMETER (MAXTTYP   = 500 )
  INTEGER MAXSTYP
  PARAMETER (MAXSTYP   = 100 )
   !
   ! ---------
   !
   !  MAXETYP  - max number of different chemical types of atom
   !  MAXBTYP  - max number of different types of bond
   !  MAXWTYP  - max number of different types of VDW contact
   !  MAXHTYP  - max number of different types of H-bond
   !  MAXATYP  - max number of different types of angle
   !  MAXTTYP  - max number of different types of torsion angle
   !
   !===================================================================
   ! ---- Common arrays for library informations about current monomer.
   ! ----------------------------------------------------------
  INTEGER MAX1ATM
  PARAMETER (MAX1ATM   = 600 )
  INTEGER MAX1BND
  PARAMETER (MAX1BND   = MAX1ATM )
  INTEGER MAX1ANG
  PARAMETER (MAX1ANG   =  2 * MAX1ATM )
  INTEGER MAX1TOR
  PARAMETER (MAX1TOR   = MAX1ATM )
  INTEGER MAX1CHR
  PARAMETER (MAX1CHR   =  50 )
  INTEGER MAX1PLN
  PARAMETER (MAX1PLN   =  80 )
  INTEGER MAX1APL
  PARAMETER (MAX1APL   = 100 )
  INTEGER MAX1BRN
  PARAMETER (MAX1BRN   =  12 )
  INTEGER MAX1EXT
  PARAMETER (MAX1EXT   =  12 )
  INTEGER MAX1CONN
  PARAMETER (MAX1CONN  = 500 )
   !-------------------------------------------------------
   ! ---- Common arrays for structure informations about current monomer.
   ! ----------------------------------------------------------
  INTEGER MX1ATOM
  PARAMETER (MX1ATOM = 600)
  INTEGER MX1BRN
  PARAMETER (MX1BRN  =   12)
  INTEGER MX1ALT
  PARAMETER (MX1ALT  =  20)
  INTEGER MX1EXT
  PARAMETER (MX1EXT  =  50)
  !===================================================================

  !===================================================================
  ! ---- Common arrays for information of library file.
  ! ----------------------------------------------------------
  !     General information about library file. 
  !
  INTEGER MAXLIB
  PARAMETER (MAXLIB  =  20)
  INTEGER*4 LMI_IUN,LMI2_IUN,LMO_IUN,LEI_IUN,LEO_IUN,LSI_IUN
  INTEGER*4 LB_PASS,LB_NUMB_LIB
  CHARACTER LB_NAME *16,LB_VERS *16,LB_DATE *16
  CHARACTER LB2_NAME*16,LB2_VERS*16,LB2_DATE*16
  CHARACTER LB_HFLAG*1
  CHARACTER LB_TFLAG*1
  CHARACTER LMI_FILE(MAXLIB)*256,LMI_PATH*256 ,LMI_EXT*256
  CHARACTER LMI2_FILE*256       ,LMI2_PATH*256,LMI2_EXT*256
  CHARACTER LMO_FILE*256        ,LMO_PATH*256 ,LMO_EXT*256
  CHARACTER LEI_FILE*256        ,LEI_PATH*256 ,LEI_EXT*256
  CHARACTER LEO_FILE*256        ,LEO_PATH*256 ,LEO_EXT*256
  CHARACTER LSI_FILE*256        ,LSI_PATH*256 ,LSI_EXT*256
  CHARACTER LIN_FILE*256        ,LIN_PATH*256 ,LIN_EXT*256
   !  LB_NAME -  name of library
  ! LB_VERS -  version's number
  ! LB_DATE -  creating date
  ! LB_HFLAG - flag of treatment of hydrogen atoms
  ! LB_TFLAG - flag
  ! LMI_FILE -+
  ! LMI_PATH -  ! input file "mon_lib.cif"
  ! LMI_EXT  -+
  ! LMO_FILE -+
  ! LMO_PATH -  ! output file "new_mon_lib.cif"
  ! LMO_EXT  -+
  ! LEI_FILE -+
  ! LEI_PATH -  ! input file "ener_lib.cif"
  ! LEI_EXT  -+
  ! LMO_FILE -+
  ! LMO_PATH -  ! output file "new_ener_lib.cif"
  ! LMO_EXT  -+
  ! LSI_FILE -+
  ! LSI_PATH -  ! input file "symlib.sym"
  ! LSI_EXT  -+
  !----------------------------------------------------------
  INTEGER LML_NPRSNT

  !===================================================================
  

  !===================================================================
  !
  !   Minimal values of parameters depend on the program which uses those
  !   common blocks, i.e. depend on the number of different kinds of
  !   monomers are in the structure. 
  !
  !===================================================================
  !
  !    Parameters of the library.
  !
  !===================================================================
  !    Library of monomers.
  !
  !     PARAMETER (MAXMLIST  = 1300 )
  !     PARAMETER (MAXMMON   = 1300 )
  !     PARAMETER (MAXMATM   = 40 * MAXMMON )
  !     PARAMETER (MAXMCNN   = MAXMMON * 20 )
  !     PARAMETER (MAXMBND   = MAXMATM * 2  )
  !     PARAMETER (MAXMANG   =  2 * MAXMATM )
  !     PARAMETER (MAXMTOR   = MAXMATM )
  !     PARAMETER (MAXMCHR   = 3 * MAXMMON )
  !     PARAMETER (MAXMPLN   = 2 * MAXMMON )
  !     PARAMETER (MAXMAPL   =  50 )
  !
  !     PARAMETER (MAXASYMB  =  30 )
  !     PARAMETER (MAXNSYM   =  96 )
  !
  !    PARAMETER (MAXETYP   =  50 )
  !
  !-------
  ! MAXMLIST - max number of monomers in the library list, i.e.
  !            list of all monomer in the library.
  ! MAXMMON  - max number of kind of monomers which be used.
  ! MAXMATM  - max number of atoms in the all used kinds of monomers
  ! MAXMBND  - max number of bonds in the all used kinds of monomers 
  ! MAXMANG  - max number of angles in the all used kinds of monomers
  ! MAXMTOR  - max number of torsion angles in the all used kinds of monomers
  ! MAXMCHR  - max number of chiralities in the all used kinds of monomers
  ! MAXMPLN  - max number of plans in the all used kinds of monomers
  ! MAXMAPL  - max number of atoms in the plan.
  ! MAXASYMB - max number of different kind of atom / for atom. scatt. SF/
  ! MAXNSYM  - max number of cryst. symmetry operators.
  !
  ! MAXETYP  - max number of different chemical types of atom
  !
  !-------
  !     PARAMETER (MAXLLNK   = 300)
  !     PARAMETER (MAXLATM   = 30 * MAXLLNK )
  !     PARAMETER (MAXLCNN   = MAXLATM )
  !     PARAMETER (MAXLBND   = MAXLATM )
  !     PARAMETER (MAXLANG   =  2 * MAXLATM )
  !     PARAMETER (MAXLTOR   = MAXLATM )
  !     PARAMETER (MAXLCHR   = 3 * MAXLLNK )
  !     PARAMETER (MAXLPLN   = 2 * MAXLLNK )
  !     PARAMETER (MAXLAPL   = 50 )
  !-------
  ! MAXLLNK - max number of link's type in the library.
  ! MAXLATM
  ! MAXLBND
  ! MAXLANG
  ! MAXLTOR
  ! MAXLCHR
  ! MAXLPLN
  ! MAXLAPL
  !-------
  !     PARAMETER (MAXDMDF   = 300)
  !     PARAMETER (MAXDATM   = 30 * MAXDMDF )
  !     PARAMETER (MAXDCNN   = MAXDATM )
  !     PARAMETER (MAXDBND   = MAXDATM )
  !     PARAMETER (MAXDANG   =  2 * MAXDATM )
  !     PARAMETER (MAXDTOR   = MAXDATM )
  !     PARAMETER (MAXDCHR   = 3 * MAXDMDF )
  !     PARAMETER (MAXDPLN   = 2 * MAXDMDF )
  !     PARAMETER (MAXDAPL   = 50 )
  !-------
  ! MAXDMDF - max number of modification's type in the library.
  ! MAXDATM
  ! MAXDBND
  ! MAXDANG
  ! MAXDTOR
  ! MAXDCHR
  ! MAXDPLN
  ! MAXDAPL
  !===========================================================
  !    Library of energetic parameters.
  !
  !      PARAMETER (MAXETYP   = 300 )
  !      PARAMETER (MAXBTYP   = 500 )
  !      PARAMETER (MAXWTYP   = 500 )
  !      PARAMETER (MAXHTYP   = 300 )
  !      PARAMETER (MAXATYP   =1500 )
  !      PARAMETER (MAXTTYP   = 500 )
  !
  !-------
  !
  ! MAXETYP  - max number of different chemical types of atom
  ! MAXBTYP  - max number of different types of bond
  ! MAXWTYP  - max number of different types of VDW contact
  ! MAXHTYP  - max number of different types of H-bond
  ! MAXATYP  - max number of different types of angle
  ! MAXTTYP  - max number of different types of torsion angle
  !
  !===================================================================
  !
  !     PARAMETER (MAXMLIST  = 200 )
  !     PARAMETER (MAXMMON   = 100 )
  !     PARAMETER (MAXMATM   = 30 * MAXMMON )
  !     PARAMETER (MAXMBND   = MAXMATM )
  !     PARAMETER (MAXMANG   =  2 * MAXMATM )
  !     PARAMETER (MAXMTOR   = MAXMATM )
  !     PARAMETER (MAXMCHR   = 3 * MAXMMON )
  !     PARAMETER (MAXMPLN   = 2 * MAXMMON )
  !     PARAMETER (MAXMAPL   =  50 )
  !
  !     PARAMETER (MAXASYMB  =  30 )
  !     PARAMETER (MAXNSYM   =  96 )
  !
  !     PARAMETER (MAXETYP   =  50 )
  !
  !-------
  ! MAXMLIST - max number of monomers in the library list, i.e.
  !            list of all monomer in the library.
  ! MAXMMON  - max number of kind of monomers which be used.
  ! MAXMATM  - max number of atoms in the all used kinds of monomers
  ! MAXMBND  - max number of bonds in the all used kinds of monomers 
  ! MAXMANG  - max number of angles in the all used kinds of monomers
  ! MAXMTOR  - max number of torsion angles in the all used kinds of monomers
  ! MAXMCHR  - max number of chiralities in the all used kinds of monomers
  ! MAXMPLN  - max number of plans in the all used kinds of monomers
  ! MAXMAPL  - max number of atoms in the plan.
  ! MAXASYMB - max number of different kind of atom / for atom. scatt. SF/
  ! MAXNSYM  - max number of cryst. simmetry operators.
  !
  ! MAXETYP  - max number of different chemical types of atom
  !
  !===================================================================
  
  !===================================================================
  !--------
  !     COMMON /LBM_LIST/ 


  INTEGER LBM_LIST_SIZE_I
  PARAMETER (LBM_LIST_SIZE_I = MAXMLIST*14 + 2)
  INTEGER LBM_LIST_SIZE_C
  PARAMETER (LBM_LIST_SIZE_C = MAXMLIST*139   )
  
  
  INTEGER*4 LML_NMON
  INTEGER*4 LML_IMON
  INTEGER*4 LML_PASS  (MAXMLIST)
  INTEGER*4 LML_IATOM (MAXMLIST)
  INTEGER*4 LML_ISYN  (MAXMLIST)
  INTEGER*4 LML_IDER  (MAXMLIST)
  INTEGER*4 LML_IMMON (MAXMLIST)
  INTEGER*4 LML_ILMON (MAXMLIST)
  INTEGER*4 LML_ICONN (MAXMLIST)
  INTEGER*4 LML_IBOND (MAXMLIST)
  INTEGER*4 LML_ITHET (MAXMLIST)
  INTEGER*4 LML_ITORS (MAXMLIST)
  INTEGER*4 LML_IPLAN (MAXMLIST)
  INTEGER*4 LML_ICHIR (MAXMLIST)
  INTEGER*4 LML_NATM  (MAXMLIST)
  INTEGER*4 LML_NHATM (MAXMLIST)
  
  CHARACTER LML_MNAME (MAXMLIST) * 8
  CHARACTER LML_MNAME2(MAXMLIST) * 8
  CHARACTER LML_NAME  (MAXMLIST) *48
  CHARACTER LML_FORM  (MAXMLIST) *48
  CHARACTER LML_CODE1 (MAXMLIST) * 1
  CHARACTER LML_TYPE  (MAXMLIST) *16
  CHARACTER LML_MODE  (MAXMLIST) * 8
  CHARACTER LML_FUSE  (MAXMLIST) * 1
  CHARACTER LML_PRSNT (MAXMLIST) * 1

  !LML_NMON  - number of monomers.
  !LML_IMON  - current monomer's number
  !LML_IATOM - pointer to atom's array
  !LML_IBOND - pointer to bond's array
  !LML_ITHET - pointer to angle's array
  !LML_ITORS - pointer to torsion's array
  !LML_IPLAN - pointer to plan's array
  !LML_ICHIR - pointer to chirality's array
  !LML_NATM  - number of atoms 
  !LML_NHATM   number of non-hydrogen atoms
  !LML_MNAME - monomer's name
  !LML_CODE1 - one letter's code
  !LML_NAME  - full name of monomer
  !LML_FORM  - formule
  !LML_TYPE  - type of monomer: 'L-peptide','DNA','RNA','non-polymer','solvent'
  !LML_MODE  -
  !LML_FUSE  - flag 'Y' or 'N'. Will monomer be used. 
  !--------
  !--------
  !     COMMON /LBM_INDEX/ 
  !
  !    * LMX_NMON,LMX_NATOM
  !
  !    *,LMX_MNAME,LMX_INDEX,LMX_CONTENT
  !

  INTEGER LBM_INDX_SIZE_I
  PARAMETER (LBM_INDX_SIZE_I = MAXMLIST*1 + 1)
  INTEGER LBM_INDX_SIZE_C
  PARAMETER (LBM_INDX_SIZE_C = MAXMLIST*86)
  

  INTEGER*4 LMX_NMON
  INTEGER*4 LMX_NATOM  (MAXMLIST)
  
  CHARACTER LMX_MNAME  (MAXMLIST) * 8
  CHARACTER LMX_INDEX  (MAXMLIST) * 24
  CHARACTER LMX_CONTENT(MAXMLIST) * 30
  CHARACTER LMX_PAIR   (MAXMLIST) * 24
  !--------
  !     COMMON /LBM_SYNO/ 
  !
  !    * LMS_NSYN,LMS_ISYN,LMS_NEW
  !
  !    *,LMS_MOD,LMS_ATOM,LMS_AATOM,LMS_MNAME,LMS_MNAME2,LMS_AMNAME
  !    *,LMS_AMNAME2,LMS_FLAG
  !
  
  INTEGER LBM_SYNO_SIZE_I
  PARAMETER (LBM_SYNO_SIZE_I = 3           )
  INTEGER LBM_SYNO_SIZE_C
  PARAMETER (LBM_SYNO_SIZE_C = MAXMLIST*49 )
  
  INTEGER*4 LMS_NSYN
  INTEGER*4 LMS_ISYN,LMS_NEW
  
  CHARACTER LMS_MNAME  (MAXMLIST)*8
  CHARACTER LMS_MNAME2 (MAXMLIST)*8
  CHARACTER LMS_ATOM   (MAXMLIST)*4
  CHARACTER LMS_MOD    (MAXMLIST)*8
  CHARACTER LMS_AMNAME (MAXMLIST)*8
  CHARACTER LMS_AMNAME2(MAXMLIST)*8
  CHARACTER LMS_AATOM  (MAXMLIST)*4
  CHARACTER LMS_FLAG   (MAXMLIST)*1
  !--------
  !     COMMON /LBM_DERI/
  !
  !    * LDR_NDER,LDR_IDER
  !
  !    *,LDR_MOD,LDR_TYPE,LDR_MNAME,LDR_SMNAME,LDR_MNAME2
  !    *,LDR_SMNAME2,LDR_NAME
  !
  INTEGER LBM_DERI_SIZE_I
  PARAMETER (LBM_DERI_SIZE_I = 2            )
  INTEGER LBM_DERI_SIZE_C
  PARAMETER (LBM_DERI_SIZE_C = MAXMLIST*104 )
  
  INTEGER*4 LDR_NDER
  INTEGER*4 LDR_IDER
  
  CHARACTER LDR_MNAME  (MAXMLIST)* 8
  CHARACTER LDR_SMNAME (MAXMLIST)* 8
  CHARACTER LDR_MNAME2 (MAXMLIST)* 8
  CHARACTER LDR_SMNAME2(MAXMLIST)* 8
  CHARACTER LDR_MOD    (MAXMLIST)* 8
  CHARACTER LDR_TYPE   (MAXMLIST)*16
  CHARACTER LDR_NAME   (MAXMLIST)*48
  !--------
  !     COMMON /LBM_MOD/ LRM_NMON
  !    *                ,LRM_MON,LRM_MOD
  !     INTEGER*4 LRM_NMON
  !     CHARACTER LRM_MON (MAXMLIST)*3
  !     CHARACTER LRM_MOD (MAXMLIST)*8
  !--------
  !     COMMON /LBM_LINK/ 
  !
  !    * LRL_NMON
  !
  !    *,LRL_MON,LRL_LINK
  !
  
  INTEGER LBM_LINK_SIZE_I
  PARAMETER (LBM_LINK_SIZE_I = 1           )
  INTEGER LBM_LINK_SIZE_C
  PARAMETER (LBM_LINK_SIZE_C = MAXMLIST*16 )
  
  INTEGER*4 LRL_NMON
  
  CHARACTER LRL_MON  (MAXMLIST)*8
  CHARACTER LRL_LINK (MAXMLIST)*8
  !-------------------------------------------
  !     COMMON /LBM_ATOM/ 
  !
  !    * LMA_CHARG,LMA_X,LMA_Y,LMA_Z
  !    *,LMA_NATOM,LMA_IATOM,LMA_SF_ID
  !
  !    *,LMA_BACK,LMA_TYPE,LMA_FORW,LMA_MNAME,LMA_MNAME2
  !    *,LMA_ANAME,LMA_SYMB,LMA_CHEM,LMA_COOR_FLAG
  !
  INTEGER LBM_ATOM_SIZE_I
  PARAMETER (LBM_ATOM_SIZE_I = MAXMATM*5 +2 )
  INTEGER LBM_ATOM_SIZE_C
  PARAMETER (LBM_ATOM_SIZE_C = MAXMATM*45   )
  
  REAL      LMA_CHARG(MAXMATM)
  REAL      LMA_X    (MAXMATM)
  REAL      LMA_Y    (MAXMATM)
  REAL      LMA_Z    (MAXMATM)
  INTEGER*4 LMA_NATOM 
  INTEGER*4 LMA_IATOM 
  INTEGER*4 LMA_SF_ID(MAXMATM) 
  
  CHARACTER LMA_BACK      (MAXMATM)*4
  CHARACTER LMA_TYPE      (MAXMATM)*8
  CHARACTER LMA_FORW      (MAXMATM)*4
  CHARACTER LMA_MNAME     (MAXMATM)*8
  CHARACTER LMA_MNAME2    (MAXMATM)*8
  CHARACTER LMA_ANAME     (MAXMATM)*4
  CHARACTER LMA_SYMB      (MAXMATM)*4
  CHARACTER LMA_CHEM      (MAXMATM)*4
  CHARACTER LMA_COOR_FLAG (MAXMATM)*1
  
  !LMA_CHARG -
  !LMA_NATOM -
  !LMA_BACK  -
  !LMA_FORW  -
  !LMA_MNAME -
  !LMA_ANAME -
  !LMA_SYMB  -
  !LMA_CHEM  -
  !-------------------------------------------
  !     COMMON /LBM_CONN/ 
  !
  !    * LMN_NCONN
  !
  !    *,LMN_1ATM,LMN_2ATM,LMN_MNAME,LMN_TYPE
  !
  INTEGER LBM_CONN_SIZE_I
  PARAMETER (LBM_CONN_SIZE_I = 1            )
  INTEGER LBM_CONN_SIZE_C
  PARAMETER (LBM_CONN_SIZE_C = MAXMCNN*24   )
  
  INTEGER*4 LMN_NCONN 

  CHARACTER LMN_MNAME (MAXMCNN)*8
  CHARACTER LMN_1ATM  (MAXMCNN)*4
  CHARACTER LMN_2ATM  (MAXMCNN)*4
  CHARACTER LMN_TYPE  (MAXMCNN)*8
  !
  !
  !--------------------------------------------------
  !     COMMON /LBM_BOND/ 
  !
  !    * LMB_VAL,LMB_DEV,LMB_NBOND
  !
  !    *,LMB_1ATM,LMB_2ATM,LMB_MNAME,LMB_MNAME2,LMB_TYPE
  !
  INTEGER LBM_BOND_SIZE_I
  PARAMETER (LBM_BOND_SIZE_I = MAXMBND*2  +1 )
  INTEGER LBM_BOND_SIZE_C
  PARAMETER (LBM_BOND_SIZE_C = MAXMBND*32    )

  REAL      LMB_VAL   (MAXMBND)
  REAL      LMB_DEV   (MAXMBND)
  INTEGER*4 LMB_NBOND 
  
  CHARACTER LMB_1ATM  (MAXMBND)*4
  CHARACTER LMB_2ATM  (MAXMBND)*4
  CHARACTER LMB_MNAME (MAXMBND)*8
  CHARACTER LMB_MNAME2(MAXMBND)*8
  CHARACTER LMB_TYPE  (MAXMBND)*8

  !LMB_VAL
  !LMB_DEV
  !LMB_NBOND 
  !LMB_1ATM
  !LMB_2ATM
  !LMB_MNAME
  !LMB_TYPE 
  !-------------------------------------------
  !     COMMON /LBM_ANGL/ 
  !
  !    * LMG_VAL,LMG_DEV,LMG_NANGL
  !
  !    *,LMG_1ATM,LMG_2ATM,LMG_3ATM,LMG_MNAME,LMG_MNAME2
  !
  INTEGER LBM_ANGL_SIZE_I
  PARAMETER (LBM_ANGL_SIZE_I = MAXMANG*2  +1 )
  INTEGER LBM_ANGL_SIZE_C
  PARAMETER (LBM_ANGL_SIZE_C = MAXMANG*28    )
  
  REAL      LMG_VAL   (MAXMANG)
  REAL      LMG_DEV   (MAXMANG)
  INTEGER*4 LMG_NANGL 
  
  CHARACTER LMG_1ATM  (MAXMANG)*4
  CHARACTER LMG_2ATM  (MAXMANG)*4
  CHARACTER LMG_3ATM  (MAXMANG)*4
  CHARACTER LMG_MNAME (MAXMANG)*8
  CHARACTER LMG_MNAME2(MAXMANG)*8

  !LMG_VAL
  !LMG_DEV
  !LMG_NANGL 
  !LMG_1ATM
  !LMG_2ATM
  !LMG_3ATM
  !LMG_MNAME
  !-------------------------------------------
  !     COMMON /LBM_TORS/
  !
  !    * LMT_VAL,LMT_DEV,LMT_NTORS,LMT_PRD
  !
  !    *,LMT_1ATM,LMT_2ATM,LMT_3ATM,LMT_4ATM,LMT_MNAME,LMT_MNAME2
  !    *,LMT_LABEL
  !
  
  INTEGER LBM_TORS_SIZE_I
  PARAMETER (LBM_TORS_SIZE_I = MAXMTOR*3  +1 )
  INTEGER LBM_TORS_SIZE_C
  PARAMETER (LBM_TORS_SIZE_C = MAXMTOR*40    )
  
  REAL      LMT_VAL   (MAXMTOR)
  REAL      LMT_DEV   (MAXMTOR)
  INTEGER*4 LMT_NTORS 
  INTEGER*4 LMT_PRD   (MAXMTOR)
  
  CHARACTER LMT_1ATM  (MAXMTOR)*4
  CHARACTER LMT_2ATM  (MAXMTOR)*4
  CHARACTER LMT_3ATM  (MAXMTOR)*4
  CHARACTER LMT_4ATM  (MAXMTOR)*4
  CHARACTER LMT_MNAME (MAXMTOR)*8
  CHARACTER LMT_MNAME2(MAXMTOR)*8
  CHARACTER LMT_LABEL (MAXMTOR)*8
  
  !LMT_VAL
  !LMT_DEV
  !LMT_NTORS 
  !LMT_PRD 
  !LMT_1ATM
  !LMT_2ATM
  !LMT_3ATM
  !LMT_4ATM
  !LMT_MNAME
  !LMT_LABEL
  !-------------------------------------------
  !     COMMON /LBM_CHIR/
  !
  !    * LMC_NCHIR
  !
  !    *,LMC_1ATM,LMC_2ATM,LMC_3ATM,LMC_4ATM,LMC_MNAME,LMC_MNAME2
  !    *,LMC_SIGN,LMC_FLAG
  !
  INTEGER LBM_CHIR_SIZE_I
  PARAMETER (LBM_CHIR_SIZE_I = 1             )
  INTEGER LBM_CHIR_SIZE_C
  PARAMETER (LBM_CHIR_SIZE_C = MAXMBND*61    )

  INTEGER*4 LMC_NCHIR 
  
  CHARACTER LMC_1ATM  (MAXMCHR)*4
  CHARACTER LMC_2ATM  (MAXMCHR)*4
  CHARACTER LMC_3ATM  (MAXMCHR)*4
  CHARACTER LMC_4ATM  (MAXMCHR)*4
  
  CHARACTER LMC_5ATM  (MAXMCHR)*4
  CHARACTER LMC_6ATM  (MAXMCHR)*4
  CHARACTER LMC_7ATM  (MAXMCHR)*4
  CHARACTER LMC_8ATM  (MAXMCHR)*4
  CHARACTER LMC_9ATM  (MAXMCHR)*4
  
  CHARACTER LMC_MNAME (MAXMCHR)*8
  CHARACTER LMC_MNAME2(MAXMCHR)*8
  CHARACTER LMC_SIGN  (MAXMCHR)*8
  CHARACTER LMC_FLAG  (MAXMCHR)*1
  
  !LMC_NCHIR 
  !LMC_1ATM
  !LMC_2ATM
  !LMC_3ATM
  !LMC_4ATM
  !LMC_MNAME
  !LMC_SIGN
  !-------------------------------------------
  !     COMMON /LBM_PLAN/ 
  !
  !    * LMP_DEV,LMP_NPLAN,LMP_NATOM,LMP_ATOM
  !
  !    *,LMP_MNAME,LMP_MNAME2,LMP_LABEL
  !
  
  INTEGER LBM_PLAN_SIZE_I
  PARAMETER (LBM_PLAN_SIZE_I = MAXMAPL*MAXMPLN*2 + MAXMPLN + 1 )
  INTEGER LBM_PLAN_SIZE_C
  PARAMETER (LBM_PLAN_SIZE_C = MAXMPLN*24    )

  REAL      LMP_DEV   (MAXMAPL,MAXMPLN)
  INTEGER*4 LMP_NPLAN
  INTEGER*4 LMP_NATOM (MAXMPLN)
  INTEGER*4 LMP_ATOM  (MAXMAPL,MAXMPLN)
  
  CHARACTER LMP_MNAME (MAXMPLN)*8
  CHARACTER LMP_MNAME2(MAXMPLN)*8
  CHARACTER LMP_LABEL (MAXMPLN)*8
  !LMP_DEV 
  !LMP_NPLAN 
  !LMP_NATOM
  !LMP_ATOM
  !LMP_MNAME
  !LMP_LABEL
  !===================================================================
  !
  !    PARAMETER (MAXLLNK   = 10 )
  !    PARAMETER (MAXLATM   = 30 * MAXLLNK )
  !    PARAMETER (MAXLBND   = MAXLATM )
  !    PARAMETER (MAXLANG   =  2 * MAXLATM )
  !    PARAMETER (MAXLTOR   = MAXLATM )
  !    PARAMETER (MAXLCHR   = 3 * MAXLLNK )
  !    PARAMETER (MAXLPLN   = 2 * MAXLLNK )
  !    PARAMETER (MAXLAPL   =  6 )
  !-------
  ! MAXLLNK
  ! MAXLATM
  ! MAXLBND
  ! MAXLANG
  ! MAXLTOR
  ! MAXLCHR
  ! MAXLPLN
  ! MAXLAPL
  !-----------------------------------------
  !     COMMON /LBL_LIST/ 
  !
  !    * LLL_NLINK,LLL_ILINK,LLL_ICONN,LLL_IATOM,LLL_IBOND,LLL_ITHET
  !    *,LLL_ITORS,LLL_IPLAN,LLL_ICHIR,LLL_FLAG1,LLL_FLAG2
  !
  !    *,LLL_TYPE1,LLL_TYPE2,LLL_MON1,LLL_MON2,LLL_MON12,LLL_MON22
  !    *,LLL_MOD1,LLL_MOD2,LLL_DETAIL,LLL_LNAME,LLL_CODE1,LLL_FUSE
  !
  INTEGER LBL_LIST_SIZE_I
  PARAMETER (LBL_LIST_SIZE_I = MAXLLNK*9   + 2 )
  INTEGER LBL_LIST_SIZE_C
  PARAMETER (LBL_LIST_SIZE_C = MAXLLNK*122     )
  

  INTEGER*4 LLL_NLINK
  INTEGER*4 LLL_ILINK
  INTEGER*4 LLL_ICONN (MAXLLNK)
  INTEGER*4 LLL_IATOM (MAXLLNK)
  INTEGER*4 LLL_IBOND (MAXLLNK)
  INTEGER*4 LLL_ITHET (MAXLLNK)
  INTEGER*4 LLL_ITORS (MAXLLNK)
  INTEGER*4 LLL_IPLAN (MAXLLNK)
  INTEGER*4 LLL_ICHIR (MAXLLNK)
  INTEGER*4 LLL_FLAG1 (MAXLLNK)
  INTEGER*4 LLL_FLAG2 (MAXLLNK)
  
  CHARACTER LLL_MON1  (MAXLLNK)* 8
  CHARACTER LLL_MON2  (MAXLLNK)* 8
  CHARACTER LLL_MON12 (MAXLLNK)* 8
  CHARACTER LLL_MON22 (MAXLLNK)* 8
  CHARACTER LLL_MOD1  (MAXLLNK)* 8
  CHARACTER LLL_MOD2  (MAXLLNK)* 8
  CHARACTER LLL_TYPE1 (MAXLLNK)* 8
  CHARACTER LLL_TYPE2 (MAXLLNK)* 8
  CHARACTER LLL_CODE1 (MAXLLNK)* 1
  CHARACTER LLL_DETAIL(MAXLLNK)*48
  CHARACTER LLL_LNAME (MAXLLNK)* 8
  CHARACTER LLL_FUSE  (MAXLLNK)* 1

  !LLL_NLINK -
  !LLL_LNAME -
  !-------------------------------------------
  !     COMMON /LBL_CONN/ 
  !
  !    * LLN_NCONN,LLN_ICONN,LLN_FATOM,LLN_FBACK,LLN_FFORW
  !    *,LLN_F1ATM,LLN_F2ATM
  !
  !    *,LLN_ATOM,LLN_BACK,LLN_BTYPE,LLN_FORW,LLN_1ATM,LLN_2ATM
  !    *,LLN_TYPE,LLN_LNAME
  !
  INTEGER LBL_CONN_SIZE_I
  PARAMETER (LBL_CONN_SIZE_I = MAXLCNN*5   + 2 )
  INTEGER LBL_CONN_SIZE_C
  PARAMETER (LBL_CONN_SIZE_C = MAXLCNN*44      )

  INTEGER*4 LLN_NCONN,LLN_ICONN 
  INTEGER*4 LLN_FATOM (MAXLCNN)
  INTEGER*4 LLN_FBACK (MAXLCNN)
  INTEGER*4 LLN_FFORW (MAXLCNN)
  INTEGER*4 LLN_F1ATM (MAXLCNN)
  INTEGER*4 LLN_F2ATM (MAXLCNN)

  CHARACTER LLN_ATOM  (MAXLCNN)*4
  CHARACTER LLN_BACK  (MAXLCNN)*4
  CHARACTER LLN_BTYPE (MAXLCNN)*8
  CHARACTER LLN_FORW  (MAXLCNN)*4
  CHARACTER LLN_1ATM  (MAXLCNN)*4
  CHARACTER LLN_2ATM  (MAXLCNN)*4
  CHARACTER LLN_TYPE  (MAXLCNN)*8
  CHARACTER LLN_LNAME (MAXLCNN)*8
  
  !-------------------------------------------
  !     COMMON /LBL_ATOM/ 
  !
  !    * LLA_NATOM,LLA_FATOM,LLA_FBACK,LLA_FFORW
  !
  !    *,LLA_ATOM,LLA_BACK,LLA_FORW,LLA_LNAME
  !
  INTEGER LBL_ATOM_SIZE_I
  PARAMETER (LBL_ATOM_SIZE_I = MAXLATM*3   + 1 )
  INTEGER LBL_ATOM_SIZE_C
  PARAMETER (LBL_ATOM_SIZE_C = MAXLATM*20      )
  
  INTEGER*4 LLA_NATOM 
  INTEGER*4 LLA_FATOM (MAXLATM)
  INTEGER*4 LLA_FBACK (MAXLATM)
  INTEGER*4 LLA_FFORW (MAXLATM)
  
  CHARACTER LLA_ATOM  (MAXLATM)*4
  CHARACTER LLA_BACK  (MAXLATM)*4
  CHARACTER LLA_FORW  (MAXLATM)*4
  CHARACTER LLA_LNAME (MAXLATM)*8
  
  !LLA_NATOM 
  !LLA_FATOM 
  !LLA_ATOM
  !LLA_FBACK 
  !LLA_BACK 
  !LLA_FFORW 
  !LLA_FORW 
  !LLA_LNAME
  !-------------------------------------------
  !     COMMON /LBL_BOND/ 
  !
  !    * LLB_VAL,LLB_DEV,LLB_VOBS,LLB_NBOND,LLB_F1ATM,LLB_F2ATM
  !
  !    *,LLB_1ATM,LLB_2ATM,LLB_LNAME,LLB_TYPE
  !
  INTEGER LBL_BOND_SIZE_I
  PARAMETER (LBL_BOND_SIZE_I = MAXLBND*5   + 1 )
  INTEGER LBL_BOND_SIZE_C
  PARAMETER (LBL_BOND_SIZE_C = MAXLBND*24      )
  
  REAL      LLB_VAL   (MAXLBND)
  REAL      LLB_VOBS  (MAXLBND)
  REAL      LLB_DEV   (MAXLBND)
  INTEGER*4 LLB_NBOND 
  INTEGER*4 LLB_F1ATM (MAXLBND)
  INTEGER*4 LLB_F2ATM (MAXLBND)

  CHARACTER LLB_1ATM  (MAXLBND)*4
  CHARACTER LLB_2ATM  (MAXLBND)*4
  CHARACTER LLB_LNAME (MAXLBND)*8
  CHARACTER LLB_TYPE  (MAXLBND)*8
  
  !LLB_VAL
  !LLB_DEV
  !LLB_NBOND 
  !LLB_F1ATM
  !LLB_1ATM
  !LLB_F2ATM
  !LLB_2ATM
  !LLB_LNAME
  !LLB_TYPE 
  !-------------------------------------------
  !     COMMON /LBL_ANGL/ 
  !
  !    * LLG_VAL,LLG_DEV,LLG_VOBS,LLG_NANGL,LLG_F1ATM,LLG_F2ATM
  !    *,LLG_F3ATM
  !
  !    *,LLG_1ATM,LLG_2ATM,LLG_3ATM,LLG_LNAME
  !
  INTEGER LBL_ANGL_SIZE_I
  PARAMETER (LBL_ANGL_SIZE_I = MAXLANG*6   + 1 )
  INTEGER LBL_ANGL_SIZE_C
  PARAMETER (LBL_ANGL_SIZE_C = MAXLANG*20      )

  REAL      LLG_VAL   (MAXLANG)
  REAL      LLG_VOBS  (MAXLANG)
  REAL      LLG_DEV   (MAXLANG)
  INTEGER*4 LLG_NANGL 
  INTEGER*4 LLG_F1ATM (MAXLANG)
  INTEGER*4 LLG_F2ATM (MAXLANG)
  INTEGER*4 LLG_F3ATM (MAXLANG)
  
  CHARACTER LLG_1ATM  (MAXLANG)*4
  CHARACTER LLG_2ATM  (MAXLANG)*4
  CHARACTER LLG_3ATM  (MAXLANG)*4
  CHARACTER LLG_LNAME (MAXLANG)*8
  
  !LLG_VAL
  !LLG_DEV
  !LLG_NANGL 
  !LLG_F1ATM
  !LLG_1ATM
  !LLG_F2ATM
  !LLG_2ATM
  !LLG_F3ATM
  !LLG_3ATM
  !LLG_LNAME
  !-------------------------------------------
  !     COMMON /LBL_TORS/ 
  !
  !    * LLT_VAL,LLT_DEV,LLT_VOBS,LLT_NTORS,LLT_PRD
  !    *,LLT_F1ATM,LLT_F2ATM,LLT_F3ATM,LLT_F4ATM
  !
  !    *,LLT_1ATM,LLT_2ATM,LLT_3ATM,LLT_4ATM,LLT_LNAME,LLT_LABEL
  !
  INTEGER LBL_TORS_SIZE_I
  PARAMETER (LBL_TORS_SIZE_I = MAXLTOR*8   + 1 )
  INTEGER LBL_TORS_SIZE_C
  PARAMETER (LBL_TORS_SIZE_C = MAXLTOR*32      )
  
  REAL      LLT_VAL   (MAXLTOR)
  REAL      LLT_VOBS  (MAXLTOR)
  REAL      LLT_DEV   (MAXLTOR)
  INTEGER*4 LLT_NTORS 
  INTEGER*4 LLT_PRD   (MAXLTOR)
  INTEGER*4 LLT_F1ATM (MAXLTOR)
  INTEGER*4 LLT_F2ATM (MAXLTOR)
  INTEGER*4 LLT_F3ATM (MAXLTOR)
  INTEGER*4 LLT_F4ATM (MAXLTOR)
  
  CHARACTER LLT_1ATM  (MAXLTOR)*4
  CHARACTER LLT_2ATM  (MAXLTOR)*4
  CHARACTER LLT_3ATM  (MAXLTOR)*4
  CHARACTER LLT_4ATM  (MAXLTOR)*4
  CHARACTER LLT_LNAME (MAXLTOR)*8
  CHARACTER LLT_LABEL (MAXLTOR)*8
  
  !LLT_VAL
  !LLT_DEV
  !LLT_NTORS 
  !LLT_PRD 
  !LLT_F1ATM
  !LLT_1ATM
  !LLT_F2ATM
  !LLT_2ATM
  !LLT_F3ATM
  !LLT_3ATM
  !LLT_F4ATM
  !LLT_4ATM
  !LLT_LNAME
  !LLT_LABEL
  !-------------------------------------------
  !     COMMON /LBL_CHIR/ 
  !
  !    * LLC_VOL,LLC_NCHIR,LLC_F1ATM,LLC_F2ATM,LLC_F3ATM,LLC_F4ATM
  !
  !    *,LLC_1ATM,LLC_2ATM,LLC_3ATM,LLC_4ATM,LLC_LNAME,LLC_SIGN
  !
  INTEGER LBL_CHIR_SIZE_I
  PARAMETER (LBL_CHIR_SIZE_I = MAXLCHR*5   + 1 )
  INTEGER LBL_CHIR_SIZE_C
  PARAMETER (LBL_CHIR_SIZE_C = MAXLCHR*32      )
  
  REAL      LLC_VOL   (MAXLCHR)
  INTEGER*4 LLC_NCHIR 
  INTEGER*4 LLC_F1ATM (MAXLCHR)
  INTEGER*4 LLC_F2ATM (MAXLCHR)
  INTEGER*4 LLC_F3ATM (MAXLCHR)
  INTEGER*4 LLC_F4ATM (MAXLCHR)

  CHARACTER LLC_1ATM  (MAXLCHR)*4
  CHARACTER LLC_2ATM  (MAXLCHR)*4
  CHARACTER LLC_3ATM  (MAXLCHR)*4
  CHARACTER LLC_4ATM  (MAXLCHR)*4
  CHARACTER LLC_LNAME (MAXLCHR)*8
  CHARACTER LLC_SIGN  (MAXLCHR)*8
  
  !LLC_NCHIR 
  !LLC_F1ATM
  !LLC_1ATM
  !LLC_F2ATM
  !LLC_2ATM
  !LLC_F3ATM
  !LLC_3ATM
  !LLC_F4ATM
  !LLC_4ATM
  !LLC_LNAME
  !LLC_SIGN
  !-------------------------------------------
  !     COMMON /LBL_PLAN/ 
  !
  !    * LLP_DEV,LLP_DOBS,LLP_NPLAN,LLP_NATOM,LLP_ATOM,LLP_FATOM
  !
  !    *,LLP_LNAME,LLP_LABEL
  !
  INTEGER LBL_PLAN_SIZE_I
  PARAMETER (LBL_PLAN_SIZE_I = MAXLAPL*MAXLPLN*4 + MAXLPLN + 1 )
  INTEGER LBL_PLAN_SIZE_C
  PARAMETER (LBL_PLAN_SIZE_C = MAXLPLN*16      )
  
  REAL      LLP_DEV  (MAXLAPL,MAXLPLN)
  REAL      LLP_DOBS (MAXLAPL,MAXLPLN)
  INTEGER*4 LLP_NPLAN
  INTEGER*4 LLP_NATOM (MAXLPLN)
  INTEGER*4 LLP_FATOM (MAXLAPL,MAXLPLN)
  INTEGER*4 LLP_ATOM  (MAXLAPL,MAXLPLN)

  CHARACTER LLP_LNAME (MAXLPLN)*8
  CHARACTER LLP_LABEL (MAXLPLN)*8

  !LLP_DEV 
  !LLP_NPLAN 
  !LLP_NATOM
  !LLP_FAT0M
  !LLP_AT0M
  !LLP_LNAME
  !LLP_LABEL
  !===================================================================
  !
  !    PARAMETER (MAXDMDF   = 10 )
  !    PARAMETER (MAXDATM   = 30 * MAXDMDF )
  !    PARAMETER (MAXDBND   = MAXMATM )
  !    PARAMETER (MAXDANG   =  2 * MAXMATM )
  !    PARAMETER (MAXDTOR   = MAXMATM )
  !    PARAMETER (MAXDCHR   = 3 * MAXDMDF )
  !    PARAMETER (MAXDPLN   = 2 * MAXDMDF )
  !    PARAMETER (MAXDAPL   =  6 )
  !-------
  ! MAXDMDF
  ! MAXDATM
  ! MAXDBND
  ! MAXDANG
  ! MAXDTOR
  ! MAXDCHR
  ! MAXDPLN
  ! MAXDAPL
  !--------------------------------------------------------
  !     COMMON /LMD_LIST/
  !
  !    * LDL_NMOD,LDL_IMOD,LDL_IATOM,LDL_ICONN,LDL_IBOND,LDL_ITHET
  !    *,LDL_ITORS,LDL_IPLAN,LDL_ICHIR,LDL_ORDER
  !
  !    *,LDL_DETAIL,LDL_TYPE,LDL_MNAME,LDL_COMP,LDL_FUSE
  !
  INTEGER LMD_LIST_SIZE_I
  PARAMETER (LMD_LIST_SIZE_I = MAXDMDF*8   + 2 )
  INTEGER LMD_LIST_SIZE_C
  PARAMETER (LMD_LIST_SIZE_C = MAXDMDF*73      )
  
  INTEGER*4 LDL_NMOD
  INTEGER*4 LDL_IMOD
  INTEGER*4 LDL_IATOM (MAXDMDF)
  INTEGER*4 LDL_ICONN (MAXDMDF)
  INTEGER*4 LDL_IBOND (MAXDMDF)
  INTEGER*4 LDL_ITHET (MAXDMDF)
  INTEGER*4 LDL_ITORS (MAXDMDF)
  INTEGER*4 LDL_IPLAN (MAXDMDF)
  INTEGER*4 LDL_ICHIR (MAXDMDF)
  INTEGER*4 LDL_ORDER (MAXDMDF)
  
  !    CHARACTER LDL_CODE1   (MAXDMDF)* 1
  CHARACTER LDL_COMP    (MAXDMDF)* 8
  CHARACTER LDL_DETAIL  (MAXDMDF)*48
  !    CHARACTER LDL_SUB_MOD (MAXDMDF)* 8
  CHARACTER LDL_TYPE    (MAXDMDF)* 8
  CHARACTER LDL_MNAME   (MAXDMDF)* 8
  CHARACTER LDL_FUSE    (MAXDMDF)* 1
  
  !
  !LDL_NMOD  -
  !LDL_MNAME -
  !-------------------------------------------
  !     COMMON /LMD_RLIST/
  !
  !    * LMR_NREC
  !
  !    *,LMR_COMP,LMR_COMP2,LMR_MNAME,LMR_DETAIL,LMR_TYPE
  !
  INTEGER LMD_RLIST_SIZE_I
  PARAMETER (LMD_RLIST_SIZE_I = 1               )
  INTEGER LMD_RLIST_SIZE_C
  PARAMETER (LMD_RLIST_SIZE_C = MAXDMDF*80      )
  
  INTEGER*4 LMR_NREC
  
  CHARACTER LMR_COMP  (MAXDMDF)* 8
  CHARACTER LMR_COMP2 (MAXDMDF)* 8
  CHARACTER LMR_MNAME (MAXDMDF)* 8
  CHARACTER LMR_DETAIL(MAXDMDF)*48
  CHARACTER LMR_TYPE  (MAXDMDF)* 8

  !-------------------------------------------
  !     COMMON /LMD_ATOM/ 
  !
  !    * LDA_CHARG,LDA_NATOM,LDA_BACK,LDA_FORW
  !
  !    *,LDA_MNAME,LDA_ANAME,LDA_ANEW,LDA_SYMB,LDA_CHEM,LDA_FUNCT
  !
  INTEGER LMD_ATOM_SIZE_I
  PARAMETER (LMD_ATOM_SIZE_I = MAXDATM     + 1 )
  INTEGER LMD_ATOM_SIZE_C
  PARAMETER (LMD_ATOM_SIZE_C = MAXDATM*40      )
  
  REAL      LDA_CHARG (MAXDATM)
  INTEGER*4 LDA_NATOM 
  
  CHARACTER LDA_BACK  (MAXDATM)*4
  CHARACTER LDA_FORW  (MAXDATM)*4
  CHARACTER LDA_MNAME (MAXDATM)*8
  CHARACTER LDA_ANAME (MAXDATM)*4
  CHARACTER LDA_ANEW  (MAXDATM)*4
  CHARACTER LDA_SYMB  (MAXDATM)*4
  CHARACTER LDA_CHEM  (MAXDATM)*4
  CHARACTER LDA_FUNCT (MAXDATM)*8

  !LDA_CHARG
  !LDA_NATOM 
  !LDA_BACK 
  !LDA_FORW 
  !LDA_MNAME
  !LDA_ANAME
  !LDA_ANEW
  !LDA_SYMB 
  !LDA_CHEM
  !LDA_FUNCT 
  !-------------------------------------------
  !     COMMON /LMD_CONN/ 
  !
  !    * LDN_NCONN
  !
  !    *,LDN_ATOM,LDN_BACK,LDN_BTYPE,LDN_FORW,LDN_FUNCT
  !    *,LDN_1ATM,LDN_2ATM,LDN_MNAME,LDN_TYPE
  !
  INTEGER LMD_CONN_SIZE_I
  PARAMETER (LMD_CONN_SIZE_I = 1               )
  INTEGER LMD_CONN_SIZE_C
  PARAMETER (LMD_CONN_SIZE_C = MAXDCNN*52      )
  
  INTEGER*4 LDN_NCONN 
  
  CHARACTER LDN_MNAME (MAXDCNN)*8
  CHARACTER LDN_ATOM  (MAXDCNN)*4
  CHARACTER LDN_BACK  (MAXDCNN)*4
  CHARACTER LDN_BTYPE (MAXDCNN)*8
  CHARACTER LDN_FORW  (MAXDCNN)*4
  CHARACTER LDN_1ATM  (MAXDCNN)*4
  CHARACTER LDN_2ATM  (MAXDCNN)*4
  CHARACTER LDN_TYPE  (MAXDCNN)*8
  CHARACTER LDN_FUNCT (MAXDCNN)*8
  !
  !
  !--------------------------------------------------
  !     COMMON /LMD_BOND/ 
  !
  !    * LDB_VAL,LDB_DEV,LDB_VOBS,LDB_NBOND
  !
  !    *,LDB_1ATM,LDB_2ATM,LDB_MNAME,LDB_TYPE,LDB_FUNCT
  !
  INTEGER LMD_BOND_SIZE_I
  PARAMETER (LMD_BOND_SIZE_I = MAXDBND*3   + 1 )
  INTEGER LMD_BOND_SIZE_C
  PARAMETER (LMD_BOND_SIZE_C = MAXDBND*32      )
  
  REAL      LDB_VAL   (MAXDBND)
  REAL      LDB_VOBS  (MAXDBND)
  REAL      LDB_DEV   (MAXDBND)
  INTEGER*4 LDB_NBOND 
  
  CHARACTER LDB_1ATM  (MAXDBND)*4
  CHARACTER LDB_2ATM  (MAXDBND)*4
  CHARACTER LDB_MNAME (MAXDBND)*8
  CHARACTER LDB_TYPE  (MAXDBND)*8
  CHARACTER LDB_FUNCT (MAXDBND)*8
  
  !LDB_VAL
  !LDB_DEV
  !LDB_NBOND 
  !LDB_1ATM
  !LDB_2ATM
  !LDB_MNAME
  !LDB_TYPE 
  !LDB_FUNCT
  !-------------------------------------------
  !     COMMON /LMD_ANGL/ 
  !
  !    * LDG_VAL,LDG_DEV,LDG_VOBS,LDG_NANGL
  !
  !    *,LDG_1ATM,LDG_2ATM,LDG_3ATM,LDG_MNAME,LDG_FUNCT
  !
  INTEGER LMD_ANGL_SIZE_I
  PARAMETER (LMD_ANGL_SIZE_I = MAXDANG*3   + 1 )
  INTEGER LMD_ANGL_SIZE_C
  PARAMETER (LMD_ANGL_SIZE_C = MAXDANG*28      )
  
  REAL      LDG_VAL   (MAXDANG)
  REAL      LDG_VOBS  (MAXDANG)
  REAL      LDG_DEV   (MAXDANG)
  INTEGER*4 LDG_NANGL 
  
  CHARACTER LDG_1ATM  (MAXDANG)*4
  CHARACTER LDG_2ATM  (MAXDANG)*4
  CHARACTER LDG_3ATM  (MAXDANG)*4
  CHARACTER LDG_MNAME (MAXDANG)*8
  CHARACTER LDG_FUNCT (MAXDANG)*8
  
  !LDG_VAL
  !LDG_DEV
  !LDG_NANGL 
  !LDG_1ATM
  !LDG_2ATM
  !LDG_3ATM
  !LDG_MNAME
  !LDG_FUNCT
  !-------------------------------------------
  !     COMMON /LMD_TORS/ 
  !
  !    * LDT_VAL,LDT_DEV,LDT_VOBS,LDT_NTORS,LDT_PRD
  !
  !    *,LDT_1ATM,LDT_2ATM,LDT_3ATM,LDT_4ATM,LDT_MNAME,LDT_LABEL
  !    *,LDT_FUNCT
  INTEGER LMD_TORS_SIZE_I
  PARAMETER (LMD_TORS_SIZE_I = MAXDTOR*4   + 1 )
  INTEGER LMD_TORS_SIZE_C
  PARAMETER (LMD_TORS_SIZE_C = MAXDTOR*40      )
  
  REAL      LDT_VAL   (MAXDTOR)
  REAL      LDT_VOBS  (MAXDTOR)
  REAL      LDT_DEV   (MAXDTOR)
  INTEGER*4 LDT_NTORS 
  INTEGER*4 LDT_PRD   (MAXDTOR)

  CHARACTER LDT_1ATM  (MAXDTOR)*4
  CHARACTER LDT_2ATM  (MAXDTOR)*4
  CHARACTER LDT_3ATM  (MAXDTOR)*4
  CHARACTER LDT_4ATM  (MAXDTOR)*4
  CHARACTER LDT_MNAME (MAXDTOR)*8
  CHARACTER LDT_LABEL (MAXDTOR)*8
  CHARACTER LDT_FUNCT (MAXDTOR)*8

  !LDT_VAL
  !LDT_DEV
  !LDT_NTORS 
  !LDT_PRD 
  !LDT_1ATM
  !LDT_2ATM
  !LDT_3ATM
  !LDT_4ATM
  !LDT_MNAME
  !LDT_LABEL
  !LDT_FUNCT
  !-------------------------------------------
  !     COMMON /LMD_CHIR/ 
  !
  !    * LDC_VOL,LDC_NCHIR
  !
  !    *,LDC_1ATM,LDC_2ATM,LDC_3ATM,LDC_4ATM,LDC_MNAME,LDC_SIGN
  !    *,LDC_FUNCT
  !
  INTEGER LMD_CHIR_SIZE_I
  PARAMETER (LMD_CHIR_SIZE_I = MAXDCHR     + 1 )
  INTEGER LMD_CHIR_SIZE_C
  PARAMETER (LMD_CHIR_SIZE_C = MAXDCHR*60      )

  REAL      LDC_VOL   (MAXDCHR)
  INTEGER*4 LDC_NCHIR 
  
  CHARACTER LDC_1ATM  (MAXDCHR)*4
  CHARACTER LDC_2ATM  (MAXDCHR)*4
  CHARACTER LDC_3ATM  (MAXDCHR)*4
  CHARACTER LDC_4ATM  (MAXDCHR)*4
  CHARACTER LDC_5ATM  (MAXDCHR)*4
  CHARACTER LDC_6ATM  (MAXDCHR)*4
  CHARACTER LDC_7ATM  (MAXDCHR)*4
  CHARACTER LDC_8ATM  (MAXDCHR)*4
  CHARACTER LDC_9ATM  (MAXDCHR)*4
  CHARACTER LDC_MNAME (MAXDCHR)*8
  CHARACTER LDC_SIGN  (MAXDCHR)*8
  CHARACTER LDC_FUNCT (MAXDCHR)*8
  
  !LDC_NCHIR 
  !LDC_1ATM
  !LDC_2ATM
  !LDC_3ATM
  !LDC_4ATM
  !LDC_MNAME
  !LDC_SIGN
  !LDC_FUNCT
  !-------------------------------------------
  !     COMMON /LMD_PLAN/ 
  !
  !    * LDP_DEV,LDP_DOBS,LDP_NPLAN,LDP_NATOM,LDP_ATOM
  !
  !    *,LDP_MNAME,LDP_LABEL,LDP_FUNCT
  !
  INTEGER LMD_PLAN_SIZE_I
  PARAMETER (LMD_PLAN_SIZE_I = MAXDAPL*MAXDPLN*3 + MAXDPLN + 1 )
  INTEGER LMD_PLAN_SIZE_C
  PARAMETER (LMD_PLAN_SIZE_C = MAXDPLN*24      )

  REAL      LDP_DEV   (MAXDAPL,MAXDPLN)
  REAL      LDP_DOBS  (MAXDAPL,MAXDPLN)
  INTEGER*4 LDP_NPLAN
  INTEGER*4 LDP_NATOM (MAXDPLN)
  INTEGER*4 LDP_ATOM  (MAXDAPL,MAXDPLN)

  CHARACTER LDP_MNAME (MAXDPLN)*8
  CHARACTER LDP_LABEL (MAXDPLN)*8
  CHARACTER LDP_FUNCT (MAXDPLN)*8
      
  !LDP_DEV 
  !LDP_NPLAN 
  !LDP_NATOM
  !LDP_AT0M
  !LDP_MNAME
  !LDP_LABEL
  !LDP_FUNCT
  !===================================================================
  !     COMMON /LIBSFC/ 
  INTEGER LIBSFC_SIZE_I
  PARAMETER (LIBSFC_SIZE_I = MAXASYMB*13  + 1 )
  INTEGER LIBSFC_SIZE_C
  PARAMETER (LIBSFC_SIZE_C = MAXASYMB*8       )
  
  INTEGER*4 LSF_NASYMB
  INTEGER*4 LSF_NE (MAXASYMB)
  REAL      LSF_A1 (MAXASYMB)
  REAL      LSF_A2 (MAXASYMB)
  REAL      LSF_A3 (MAXASYMB)
  REAL      LSF_A4 (MAXASYMB)
  REAL      LSF_B1 (MAXASYMB)
  REAL      LSF_B2 (MAXASYMB)
  REAL      LSF_B3 (MAXASYMB)
  REAL      LSF_B4 (MAXASYMB)
  REAL      LSF_C  (MAXASYMB)
  REAL      LSF_FI (MAXASYMB)
  REAL      LSF_FII(MAXASYMB)
  REAL      LSF_RAD(MAXASYMB)
  
  CHARACTER LSF_ATOM   (MAXASYMB)*4
  CHARACTER LSF_ELEMENT(MAXASYMB)*4
  
  !
  !LSF_NASYM - number of different kind of atom / for atom. scatt. SF/
  !LSF_NE   
  !LSF_A1   
  !LSF_A2
  !LSF_A3
  !LSF_A4
  !LSF_B1    - type_scat_Cromer_Mann_
  !LSF_B2
  !LSF_B3
  !LSF_B4
  !LSF_C
  !LSF_FI    - scatt_dispersion_real
  !LSF_FII   - scatt_dispersion_imag
  !LSF_ATOM  - type_symbol
  !===================================================================
  !     COMMON /LIBSYM/ 
  !
  !    * LSO_NSYM
  !
  !    *,LSO_SYMOP
  !
  INTEGER LIBSYM_SIZE_I
  PARAMETER (LIBSYM_SIZE_I = 1                )
  INTEGER LIBSYM_SIZE_C
  PARAMETER (LIBSYM_SIZE_C = MAXNSYM*24       )

  INTEGER*4 LSO_NSYM
  
  CHARACTER LSO_SYMOP(MAXNSYM)*24

  !
  !LSO_NSYM  - number of cryst. symmetry operators.
  !LSO_SYMOP - strings of characters with cryst.symmetry operators
  !===================================================================
  
  !-- Common arrays for library informations about current monomer.
  !--------------------------------------------------------
  !     PARAMETER (MAX1ATM   = 250 )
  !     PARAMETER (MAX1BND   = MAX1ATM )
  !     PARAMETER (MAX1ANG   =  2 * MAX1ATM )
  !     PARAMETER (MAX1TOR   = MAX1ATM )
  !     PARAMETER (MAX1CHR   =  20 )
  !     PARAMETER (MAX1PLN   =  20 )
  !     PARAMETER (MAX1APL   =  50 )
  !     PARAMETER (MAX1BRN   =   8 )
  !     PARAMETER (MAX1EXT   =   8 )
  !     PARAMETER (MAX1CONN  = 500 )
  !--------
  !     COMMON /L1M_LIST/ 
  !
  !    * L1L_NATM,L1L_NHATM
  !
  !    *,L1L_MNAME,L1L_MNAME2,L1L_CODE1,L1L_NAME,L1L_FORM,L1L_TYPE
  !    *,L1L_MODE,L1L_FUSE,L1L_HFLAG,L1L_PRSNT
  !
  INTEGER L1M_LIST_SIZE_I
  PARAMETER (L1M_LIST_SIZE_I =   2 )
  INTEGER L1M_LIST_SIZE_C
  PARAMETER (L1M_LIST_SIZE_C = 140 )

  INTEGER*4 L1L_NATM 
  INTEGER*4 L1L_NHATM
  
  CHARACTER L1L_MNAME * 8
  CHARACTER L1L_MNAME2* 8
  CHARACTER L1L_CODE1 * 1
  CHARACTER L1L_NAME  *48
  CHARACTER L1L_FORM  *48
  CHARACTER L1L_TYPE  *16
  CHARACTER L1L_MODE  * 8
  CHARACTER L1L_FUSE  * 1
  CHARACTER L1L_PRSNT * 1
  CHARACTER L1L_HFLAG * 1
  
  !L1L_NATM  - number of atoms 
  !L1L_NHATM   number of non-hydrogen atoms
  !L1L_MNAME - monomer's name
  !L1L_CODE1 - one letter's code
  !L1L_NAME  - full name of monomer
  !L1L_FORM  - formule
  !L1L_TYPE  - type of monomer: 'L-peptide','DNA','RNA','non-polymer','solvent'
  !L1L_MODE  - don't used now.
  !L1L_FUSE  - flag 'Y' or 'N'. Will monomer be used. 
  !L1L_HFLAG - 'A' all ,'N' without, 'Y' only where occur
  !
  INTEGER L1M_ATOM_SIZE_I

  INTEGER L1M_ATOM_SIZE_C
  PARAMETER (L1M_ATOM_SIZE_C = MAX1ATM*38                 )
  
  REAL      L1A_CHARG (MAX1ATM)
  REAL      L1A_X     (MAX1ATM)
  REAL      L1A_Y     (MAX1ATM)
  REAL      L1A_Z     (MAX1ATM)
  REAL      L1A_LENGTH(MAX1ATM)
  REAL      L1A_THETA (MAX1ATM)
  REAL      L1A_PHI   (MAX1ATM)
  INTEGER*4 L1A_NATOM 
  INTEGER*4 L1A_NHATOM 
  INTEGER*4 L1A_NDUMMY 
  INTEGER*4 L1A_IGATM 
  INTEGER*4 L1A_ISTART 
  INTEGER*4 L1A_IFINISH
  INTEGER*4 L1A_I2START 
  INTEGER*4 L1A_I2FINISH
  INTEGER*4 L1A_NRING    (MAX1ATM)
  INTEGER*4 L1A_RING_ID  (MAX1BRN,MAX1ATM)
  INTEGER*4 L1A_RING_ORD (MAX1BRN,MAX1ATM)
  INTEGER*4 L1A_RING_FLAT(MAX1BRN,MAX1ATM)
  
  INTEGER*4 L1A_INEW  (MAX1ATM) 
  INTEGER*4 L1A_IOLD  (MAX1ATM) 
  INTEGER*4 L1A_ICR   (MAX1ATM)
  INTEGER*4 L1A_NDIST (MAX1ATM) 
  INTEGER*4 L1A_NEXTR (MAX1ATM) 
  INTEGER*4 L1A_IEXTR (MAX1EXT,MAX1ATM) 
  INTEGER*4 L1A_TEXTR (MAX1EXT,MAX1ATM)
  INTEGER*4 L1A_CONN  (MAX1BRN,MAX1ATM) 
  INTEGER*4 L1A_LENCON(MAX1BRN,MAX1ATM) 
  INTEGER*4 L1A_IBACK (MAX1ATM)
  INTEGER*4 L1A_IFORW (MAX1ATM)
  INTEGER*4 L1A_ICHEM (MAX1ATM)
  INTEGER*4 L1A_ICHIR (MAX1ATM)
  INTEGER*4 L1A_SF_ID (MAX1ATM)
  
  CHARACTER L1A_BACK      (MAX1ATM)*4
  CHARACTER L1A_TYPE      (MAX1ATM)*8
  CHARACTER L1A_FORW      (MAX1ATM)*4
  CHARACTER L1A_ANAME     (MAX1ATM)*4
  CHARACTER L1A_SYMB      (MAX1ATM)*4
  CHARACTER L1A_CHEM      (MAX1ATM)*4
  CHARACTER L1A_ATYPE     (MAX1ATM)*1
  CHARACTER L1A_COOR_FLAG (MAX1ATM)*1   
  CHARACTER L1A_ID_PSI    (MX1ATOM)*8 
  
  !L1A_CHARG
  !L1A_NATOM 
  !L1A_IGATM 
  !L1A_INEW
  !L1A_IOLD
  !L1A_ICR
  !L1A_NDIST
  !L1A_IEXTR
  !L1A_TEXTR 
  !L1A_CONN
  !L1A_LENCON
  !L1A_IBACK 
  !L1A_IFORW 
  !L1A_BACK 
  !L1A_FORW 
  !L1A_ANAME
  !L1A_SYMB 
  !L1A_CHEM 
  !L1A_ATYPE
  !-------------------------------------------
  !     COMMON /L1M_CONN/ 
  !
  !    * L1N_NCONN,L1N_I1ATM,L1N_I2ATM
  !
  !    *,L1N_1ATM,L1N_2ATM,L1N_TYPE
  !
  INTEGER L1M_CONN_SIZE_I
  PARAMETER (L1M_CONN_SIZE_I = MAX1CONN*2  + 1)
  INTEGER L1M_CONN_SIZE_C
  PARAMETER (L1M_CONN_SIZE_C = MAX1CONN*16    )
  
  INTEGER*4 L1N_NCONN 
  INTEGER*4 L1N_I1ATM (MAX1CONN)
  INTEGER*4 L1N_I2ATM (MAX1CONN)
  
  CHARACTER L1N_1ATM  (MAX1CONN)*4
  CHARACTER L1N_2ATM  (MAX1CONN)*4
  CHARACTER L1N_TYPE  (MAX1CONN)*8
  !
  !
  !-------------------------------------------
  !     COMMON /L1M_BOND/ 
  !
  !    * L1B_VAL,L1B_DEV,L1B_VOBS,L1B_EVAL,L1B_NBOND
  !    *,L1B_I1ATM,L1B_I2ATM
  !
  !    *,L1B_1ATM,L1B_2ATM,L1B_TYPE,L1B_FLAG
  !
  INTEGER L1M_BOND_SIZE_I
  PARAMETER (L1M_BOND_SIZE_I = MAX1BND*6  + 1)
  INTEGER L1M_BOND_SIZE_C
  PARAMETER (L1M_BOND_SIZE_C = MAX1BND*17    )

  REAL      L1B_VAL   (MAX1BND)
  REAL      L1B_DEV   (MAX1BND)
  REAL      L1B_VOBS  (MAX1BND)
  REAL      L1B_EVAL  (MAX1BND)
  INTEGER*4 L1B_NBOND 
  INTEGER*4 L1B_I1ATM (MAX1BND)
  INTEGER*4 L1B_I2ATM (MAX1BND)
  
  CHARACTER L1B_1ATM  (MAX1BND)*4
  CHARACTER L1B_2ATM  (MAX1BND)*4
  CHARACTER L1B_TYPE  (MAX1BND)*8
  CHARACTER L1B_FLAG  (MAX1BND)*1
  
  !L1B_VAL
  !L1B_DEV
  !L1B_NBOND 
  !L1B_1ATM
  !L1B_2ATM
  !L1B_TYPE 
  !L1B_FLAG
  !-------------------------------------------
  !     COMMON /L1M_ANGL/ 
  !
  !    * L1G_VAL,L1G_DEV,L1G_VOBS,L1G_EVAL,L1G_NANGL
  !    *,L1G_I1ATM,L1G_I2ATM,L1G_I3ATM
  !
  !    *,L1G_1ATM,L1G_2ATM,L1G_3ATM,L1G_FLAG
  !
  INTEGER L1M_ANGL_SIZE_I
  PARAMETER (L1M_ANGL_SIZE_I = MAX1ANG*7  + 1)
  INTEGER L1M_ANGL_SIZE_C
  PARAMETER (L1M_ANGL_SIZE_C = MAX1ANG*13    )

  REAL      L1G_VAL   (MAX1ANG)
  REAL      L1G_DEV   (MAX1ANG)
  REAL      L1G_VOBS  (MAX1ANG)
  REAL      L1G_EVAL  (MAX1ANG)
  INTEGER*4 L1G_NANGL 
  INTEGER*4 L1G_I1ATM (MAX1ANG)
  INTEGER*4 L1G_I2ATM (MAX1ANG)
  INTEGER*4 L1G_I3ATM (MAX1ANG)
  
  CHARACTER L1G_1ATM  (MAX1ANG)*4
  CHARACTER L1G_2ATM  (MAX1ANG)*4
  CHARACTER L1G_3ATM  (MAX1ANG)*4
  CHARACTER L1G_FLAG  (MAX1ANG)*1

  !L1G_VAL
  !L1G_DEV
  !L1G_NANGL 
  !L1G_1ATM
  !L1G_2ATM
  !L1G_3ATM
  !L1G_FLAG
  !-------------------------------------------
  !     COMMON /L1M_TORS/ 
  !
  !    * L1T_VAL,L1T_DEV,L1T_VOBS,L1T_EVAL,L1T_NTORS,L1T_PRD
  !    *,L1T_I1ATM,L1T_I2ATM,L1T_I3ATM,L1T_I4ATM
  !
  !    *,L1T_1ATM,L1T_2ATM,L1T_3ATM,L1T_4ATM,L1T_LABEL,L1T_FLAG
  !
  INTEGER L1M_TORS_SIZE_I
  PARAMETER (L1M_TORS_SIZE_I = MAX1TOR*9  + 1)
  INTEGER L1M_TORS_SIZE_C
  PARAMETER (L1M_TORS_SIZE_C = MAX1TOR*25    )
  
  REAL      L1T_VAL   (MAX1TOR)
  REAL      L1T_DEV   (MAX1TOR)
  REAL      L1T_VOBS  (MAX1TOR)
  REAL      L1T_EVAL  (MAX1TOR)
  INTEGER*4 L1T_NTORS 
  INTEGER*4 L1T_PRD   (MAX1TOR)
  INTEGER*4 L1T_I1ATM (MAX1TOR)
  INTEGER*4 L1T_I2ATM (MAX1TOR)
  INTEGER*4 L1T_I3ATM (MAX1TOR)
  INTEGER*4 L1T_I4ATM (MAX1TOR)
  
  CHARACTER L1T_1ATM  (MAX1TOR)*4
  CHARACTER L1T_2ATM  (MAX1TOR)*4
  CHARACTER L1T_3ATM  (MAX1TOR)*4
  CHARACTER L1T_4ATM  (MAX1TOR)*4
  CHARACTER L1T_LABEL (MAX1TOR)*8
  CHARACTER L1T_FLAG  (MAX1TOR)*1
  
  !L1T_VAL
  !L1T_DEV
  !L1T_NTORS 
  !L1T_PRD 
  !L1T_1ATM
  !L1T_2ATM
  !L1T_3ATM
  !L1T_4ATM
  !L1T_LABEL
  !L1T_FLAG
  !-------------------------------------------
  !     COMMON /L1M_CHIR/ 
  !
  !    * L1C_VOL,L1C_VOBS,L1C_EVOL,L1C_NCHIR
  !    *,L1C_I1ATM,L1C_I2ATM,L1C_I3ATM,L1C_I4ATM
  !
  !    *,L1C_1ATM,L1C_2ATM,L1C_3ATM,L1C_4ATM,L1C_SIGN,L1C_FLAG
  !
  INTEGER L1M_CHIR_SIZE_I
  PARAMETER (L1M_CHIR_SIZE_I = MAX1CHR*12  + 1)
  INTEGER L1M_CHIR_SIZE_C
  PARAMETER (L1M_CHIR_SIZE_C = MAX1CHR*45    )
  
  REAL      L1C_VOL   (MAX1CHR)
  REAL      L1C_VOBS  (MAX1CHR)
  REAL      L1C_EVOL  (MAX1CHR)
  INTEGER*4 L1C_NCHIR 
  INTEGER*4 L1C_I1ATM (MAX1CHR)
  INTEGER*4 L1C_I2ATM (MAX1CHR)
  INTEGER*4 L1C_I3ATM (MAX1CHR)
  INTEGER*4 L1C_I4ATM (MAX1CHR)
  
  INTEGER*4 L1C_I5ATM (MAX1CHR)
  INTEGER*4 L1C_I6ATM (MAX1CHR)
  INTEGER*4 L1C_I7ATM (MAX1CHR)
  INTEGER*4 L1C_I8ATM (MAX1CHR)
  INTEGER*4 L1C_I9ATM (MAX1CHR)
  
  CHARACTER L1C_1ATM  (MAX1CHR)*4
  CHARACTER L1C_2ATM  (MAX1CHR)*4
  CHARACTER L1C_3ATM  (MAX1CHR)*4
  CHARACTER L1C_4ATM  (MAX1CHR)*4
  
  CHARACTER L1C_5ATM  (MAX1CHR)*4
  CHARACTER L1C_6ATM  (MAX1CHR)*4
  CHARACTER L1C_7ATM  (MAX1CHR)*4
  CHARACTER L1C_8ATM  (MAX1CHR)*4
  CHARACTER L1C_9ATM  (MAX1CHR)*4
  
  CHARACTER L1C_SIGN  (MAX1CHR)*8
  CHARACTER L1C_FLAG  (MAX1CHR)*1

  !L1C_NCHIR 
  !L1C_1ATM
  !L1C_2ATM
  !L1C_3ATM
  !L1C_4ATM
  !L1C_SIGN
  !L1C_FLAG
  !-------------------------------------------
  !     COMMON /L1M_PLAN/ 
  !
  !    * L1P_DEV,L1P_DOBS,L1P_EDEV,L1P_NPLAN,L1P_NATOM,L1P_IATOM
  !    *,L1P_ATOM,L1P_FLAG
  !
  !    *,L1P_LABEL
  !
  INTEGER L1M_PLAN_SIZE_I
  PARAMETER (L1M_PLAN_SIZE_I = MAX1APL*MAX1PLN*6 + MAX1PLN + 1)
  INTEGER L1M_PLAN_SIZE_C
  PARAMETER (L1M_PLAN_SIZE_C = MAX1PLN*8    )
  
  REAL      L1P_DEV  (MAX1APL,MAX1PLN)
  REAL      L1P_DOBS (MAX1APL,MAX1PLN)
  REAL      L1P_EDEV (MAX1APL,MAX1PLN)
  INTEGER*4 L1P_NPLAN
  INTEGER*4 L1P_NATOM (MAX1PLN)
  INTEGER*4 L1P_IATOM (MAX1APL,MAX1PLN)
  INTEGER*4 L1P_ATOM  (MAX1APL,MAX1PLN)
  INTEGER*4 L1P_FLAG  (MAX1APL,MAX1PLN)
  
  CHARACTER L1P_LABEL (MAX1PLN)*8
  
  !L1P_DEV 
  !L1P_NPLAN 
  !L1P_NATOM
  !L1P_ATOM
  !L1P_FLAG
  !L1P_LABEL
  !-----------------------------------------
  !-----------------------------------------
  !     COMMON /L2M_LIST/ 
  !
  !    * L2L_NATM,L2L_NHATM
  !
  !    *,L2L_MNAME,L2L_MNAME2,L2L_CODE1,L2L_NAME,L2L_FORM,L2L_TYPE
  !    *,L2L_MODE,L2L_FUSE,L2L_HFLAG,L2L_PRSNT
  !
  
  INTEGER L2M_LIST_SIZE_I
  PARAMETER (L2M_LIST_SIZE_I =   2 )
  INTEGER L2M_LIST_SIZE_C
  PARAMETER (L2M_LIST_SIZE_C = 140 )
  
  INTEGER*4 L2L_NATM 
  INTEGER*4 L2L_NHATM
  
  CHARACTER L2L_MNAME * 8
  CHARACTER L2L_MNAME2* 8
  CHARACTER L2L_CODE1 * 1
  CHARACTER L2L_NAME  *48
  CHARACTER L2L_FORM  *48
  CHARACTER L2L_TYPE  *16
  CHARACTER L2L_MODE  * 8
  CHARACTER L2L_FUSE  * 1
  CHARACTER L2L_PRSNT * 1
  CHARACTER L2L_HFLAG * 1
  
  !L2L_NATM  - number of atoms 
  !L2L_NHATM   number of non-hydrogen atoms
  !L2L_MNAME - monomer's name
  !L2L_CODE1 - one letter's code
  !L2L_NAME  - full name of monomer
  !L2L_FORM  - formule
  !L2L_TYPE  - type of monomer: 'L-peptide','DNA','RNA','non-polymer','solvent'
  !L2L_MODE  - don't used now.
  !L2L_FUSE  - flag 'Y' or 'N'. Will monomer be used. 
  !L2L_HFLAG - 'A' all ,'N' without, 'Y' only where occur
  !-------------------------------------------
  !     COMMON /L2M_ATOM/ 
  !
  !    * L2A_CHARG,L2A_X,L2A_Y,L2A_Z,L2A_LENGTH,L2A_THETA,L2A_PHI
  !    *,L2A_NATOM,L2A_NHATOM,L2A_NDUMMY,L2A_IGATM,L2A_ISTART,L2A_IFINISH
  !    *,L2A_INEW,L2A_IOLD,L2A_ICR,L2A_NDIST,L2A_NEXTR,L2A_IEXTR
  !    *,L2A_TEXTR,L2A_CONN,L2A_LENCON,L2A_IBACK,L2A_IFORW,L2A_ICHEM
  !    *,L2A_NRING,L2A_RING_ID,L2A_RING_ORD,L2A_SF_ID
  !    *,L2A_I2START,L2A_I2FINISH
  !
  !    *,L2A_BACK,L2A_TYPE,L2A_FORW
  !    *,L2A_ANAME,L2A_SYMB,L2A_CHEM,L2A_ATYPE,L2A_COOR_FLAG,L2A_ID_PSI
  !
  INTEGER L2M_ATOM_SIZE_I

  INTEGER L2M_ATOM_SIZE_C
  PARAMETER (L2M_ATOM_SIZE_C = MAX1ATM*38                 )
  
  REAL      L2A_CHARG (MAX1ATM)
  REAL      L2A_X     (MAX1ATM)
  REAL      L2A_Y     (MAX1ATM)
  REAL      L2A_Z     (MAX1ATM)
  REAL      L2A_LENGTH(MAX1ATM)
  REAL      L2A_THETA (MAX1ATM)
  REAL      L2A_PHI   (MAX1ATM)
  INTEGER*4 L2A_NATOM 
  INTEGER*4 L2A_NHATOM 
  INTEGER*4 L2A_NDUMMY
  INTEGER*4 L2A_IGATM 
  INTEGER*4 L2A_ISTART 
  INTEGER*4 L2A_IFINISH
  INTEGER*4 L2A_I2START 
  INTEGER*4 L2A_I2FINISH
  INTEGER*4 L2A_NRING    (MAX1ATM)
  INTEGER*4 L2A_RING_ID  (MAX1BRN,MAX1ATM)
  INTEGER*4 L2A_RING_ORD (MAX1BRN,MAX1ATM)
  INTEGER*4 L2A_INEW  (MAX1ATM) 
  INTEGER*4 L2A_IOLD  (MAX1ATM) 
  INTEGER*4 L2A_ICR   (MAX1ATM)
  INTEGER*4 L2A_NDIST (MAX1ATM) 
  INTEGER*4 L2A_NEXTR (MAX1ATM) 
  INTEGER*4 L2A_IEXTR (MAX1EXT,MAX1ATM) 
  INTEGER*4 L2A_TEXTR (MAX1EXT,MAX1ATM)
  INTEGER*4 L2A_CONN  (MAX1BRN,MAX1ATM) 
  INTEGER*4 L2A_LENCON(MAX1BRN,MAX1ATM) 
  INTEGER*4 L2A_IBACK (MAX1ATM)
  INTEGER*4 L2A_IFORW (MAX1ATM)
  INTEGER*4 L2A_ICHEM (MAX1ATM)
  INTEGER*4 L2A_SF_ID (MAX1ATM)
  
  CHARACTER L2A_BACK      (MAX1ATM)*4
  CHARACTER L2A_TYPE      (MAX1ATM)*8
  CHARACTER L2A_FORW      (MAX1ATM)*4
  CHARACTER L2A_ANAME     (MAX1ATM)*4
  CHARACTER L2A_SYMB      (MAX1ATM)*4
  CHARACTER L2A_CHEM      (MAX1ATM)*4
  CHARACTER L2A_ATYPE     (MAX1ATM)*1
  CHARACTER L2A_COOR_FLAG (MAX1ATM)*1
  CHARACTER L2A_ID_PSI    (MX1ATOM)*8 

  !L2A_CHARG
  !L2A_NATOM 
  !L2A_IGATM 
  !L2A_INEW
  !L2A_IOLD
  !L2A_ICR
  !L2A_NDIST
  !L2A_IEXTR
  !L2A_TEXTR 
  !L2A_CONN
  !L2A_LENCON
  !L2A_IBACK 
  !L2A_IFORW 
  !L2A_BACK 
  !L2A_FORW 
  !L2A_ANAME
  !L2A_SYMB 
  !L2A_CHEM 
  !L2A_ATYPE
  !-------------------------------------------
  !     COMMON /L2M_CONN/ 
  !
  !    * L2N_NCONN,L2N_I1ATM,L2N_I2ATM
  !
  !    *,L2N_1ATM,L2N_2ATM,L2N_TYPE
  !
  INTEGER L2M_CONN_SIZE_I
  PARAMETER (L2M_CONN_SIZE_I = MAX1CONN*2  + 1)
  INTEGER L2M_CONN_SIZE_C
  PARAMETER (L2M_CONN_SIZE_C = MAX1CONN*16    )
  
  INTEGER*4 L2N_NCONN 
  INTEGER*4 L2N_I1ATM (MAX1CONN)
  INTEGER*4 L2N_I2ATM (MAX1CONN)
  
  CHARACTER L2N_1ATM  (MAX1CONN)*4
  CHARACTER L2N_2ATM  (MAX1CONN)*4
  CHARACTER L2N_TYPE  (MAX1CONN)*8
  !
  !-------------------------------------------
  !     COMMON /L2M_BOND/ 
  !
  !    * L2B_VAL,L2B_DEV,L2B_VOBS,L2B_EVAL,L2B_NBOND
  !    *,L2B_I1ATM,L2B_I2ATM
  !
  !    *,L2B_1ATM,L2B_2ATM,L2B_TYPE,L2B_FLAG
  !
  INTEGER L2M_BOND_SIZE_I
  PARAMETER (L2M_BOND_SIZE_I = MAX1BND*6  + 1)
  INTEGER L2M_BOND_SIZE_C
  PARAMETER (L2M_BOND_SIZE_C = MAX1BND*17    )

  REAL      L2B_VAL   (MAX1BND)
  REAL      L2B_DEV   (MAX1BND)
  REAL      L2B_VOBS  (MAX1BND)
  REAL      L2B_EVAL  (MAX1BND)
  INTEGER*4 L2B_NBOND 
  INTEGER*4 L2B_I1ATM (MAX1BND)
  INTEGER*4 L2B_I2ATM (MAX1BND)
  
  CHARACTER L2B_1ATM  (MAX1BND)*4
  CHARACTER L2B_2ATM  (MAX1BND)*4
  CHARACTER L2B_TYPE  (MAX1BND)*8
  CHARACTER L2B_FLAG  (MAX1BND)*1
  
  !L2B_VAL
  !L2B_DEV
  !L2B_NBOND 
  !L2B_1ATM
  !L2B_2ATM
  !L2B_TYPE 
  !L2B_FLAG
  !-------------------------------------------
  !     COMMON /L2M_ANGL/ 
  !
  !    * L2G_VAL,L2G_DEV,L2G_VOBS,L2G_EVAL,L2G_NANGL
  !    *,L2G_I1ATM,L2G_I2ATM,L2G_I3ATM
  !
  !    *,L2G_1ATM,L2G_2ATM,L2G_3ATM,L2G_FLAG
  !
  INTEGER L2M_ANGL_SIZE_I
  PARAMETER (L2M_ANGL_SIZE_I = MAX1ANG*7  + 1)
  INTEGER L2M_ANGL_SIZE_C
  PARAMETER (L2M_ANGL_SIZE_C = MAX1ANG*13    )

  REAL      L2G_VAL   (MAX1ANG)
  REAL      L2G_DEV   (MAX1ANG)
  REAL      L2G_VOBS  (MAX1ANG)
  REAL      L2G_EVAL  (MAX1ANG)
  INTEGER*4 L2G_NANGL 
  INTEGER*4 L2G_I1ATM (MAX1ANG)
  INTEGER*4 L2G_I2ATM (MAX1ANG)
  INTEGER*4 L2G_I3ATM (MAX1ANG)
  
  CHARACTER L2G_1ATM  (MAX1ANG)*4
  CHARACTER L2G_2ATM  (MAX1ANG)*4
  CHARACTER L2G_3ATM  (MAX1ANG)*4
  CHARACTER L2G_FLAG  (MAX1ANG)*1
  
  !L2G_VAL
  !L2G_DEV
  !L2G_NANGL 
  !L2G_1ATM
  !L2G_2ATM
  !L2G_3ATM
  !L2G_FLAG
  !-------------------------------------------
  !     COMMON /L2M_TORS/ 
  !
  !    * L2T_VAL,L2T_DEV,L2T_VOBS,L2T_EVAL,L2T_NTORS,L2T_PRD
  !    *,L2T_I1ATM,L2T_I2ATM,L2T_I3ATM,L2T_I4ATM
  !
  !    *,L2T_1ATM,L2T_2ATM,L2T_3ATM,L2T_4ATM,L2T_LABEL,L2T_FLAG
  !
  INTEGER L2M_TORS_SIZE_I
  PARAMETER (L2M_TORS_SIZE_I = MAX1TOR*9  + 1)
  INTEGER L2M_TORS_SIZE_C
  PARAMETER (L2M_TORS_SIZE_C = MAX1TOR*25    )
  
  REAL      L2T_VAL   (MAX1TOR)
  REAL      L2T_DEV   (MAX1TOR)
  REAL      L2T_VOBS  (MAX1TOR)
  REAL      L2T_EVAL  (MAX1TOR)
  INTEGER*4 L2T_NTORS 
  INTEGER*4 L2T_PRD   (MAX1TOR)
  INTEGER*4 L2T_I1ATM (MAX1TOR)
  INTEGER*4 L2T_I2ATM (MAX1TOR)
  INTEGER*4 L2T_I3ATM (MAX1TOR)
  INTEGER*4 L2T_I4ATM (MAX1TOR)
  
  CHARACTER L2T_1ATM  (MAX1TOR)*4
  CHARACTER L2T_2ATM  (MAX1TOR)*4
  CHARACTER L2T_3ATM  (MAX1TOR)*4
  CHARACTER L2T_4ATM  (MAX1TOR)*4
  CHARACTER L2T_LABEL (MAX1TOR)*8
  CHARACTER L2T_FLAG  (MAX1TOR)*1
  
  !L2T_VAL
  !L2T_DEV
  !L2T_NTORS 
  !L2T_PRD 
  !L2T_1ATM
  !L2T_2ATM
  !L2T_3ATM
  !L2T_4ATM
  !L2T_LABEL
  !L2T_FLAG
  !-------------------------------------------
  !     COMMON /L2M_CHIR/ 
  !
  !    * L2C_VOL,L2C_VOBS,L2C_EVOL,L2C_NCHIR
  !    *,L2C_I1ATM,L2C_I2ATM,L2C_I3ATM,L2C_I4ATM
  !
  !    *,L2C_1ATM,L2C_2ATM,L2C_3ATM,L2C_4ATM,L2C_SIGN,L2C_FLAG
  !
  INTEGER L2M_CHIR_SIZE_I
  PARAMETER (L2M_CHIR_SIZE_I = MAX1CHR*12  + 1)
  INTEGER L2M_CHIR_SIZE_C
  PARAMETER (L2M_CHIR_SIZE_C = MAX1CHR*45    )

  REAL      L2C_VOL   (MAX1CHR)
  REAL      L2C_VOBS  (MAX1CHR)
  REAL      L2C_EVOL  (MAX1CHR)
  INTEGER*4 L2C_NCHIR 
  INTEGER*4 L2C_I1ATM (MAX1CHR)
  INTEGER*4 L2C_I2ATM (MAX1CHR)
  INTEGER*4 L2C_I3ATM (MAX1CHR)
  INTEGER*4 L2C_I4ATM (MAX1CHR)

  INTEGER*4 L2C_I5ATM (MAX1CHR)
  INTEGER*4 L2C_I6ATM (MAX1CHR)
  INTEGER*4 L2C_I7ATM (MAX1CHR)
  INTEGER*4 L2C_I8ATM (MAX1CHR)
  INTEGER*4 L2C_I9ATM (MAX1CHR)
  
  CHARACTER L2C_1ATM  (MAX1CHR)*4
  CHARACTER L2C_2ATM  (MAX1CHR)*4
  CHARACTER L2C_3ATM  (MAX1CHR)*4
  CHARACTER L2C_4ATM  (MAX1CHR)*4
  
  CHARACTER L2C_5ATM  (MAX1CHR)*4
  CHARACTER L2C_6ATM  (MAX1CHR)*4
  CHARACTER L2C_7ATM  (MAX1CHR)*4
  CHARACTER L2C_8ATM  (MAX1CHR)*4
  CHARACTER L2C_9ATM  (MAX1CHR)*4
  
  CHARACTER L2C_SIGN  (MAX1CHR)*8
  CHARACTER L2C_FLAG  (MAX1CHR)*1
  
  !L2C_NCHIR 
  !L2C_1ATM
  !L2C_2ATM
  !L2C_3ATM
  !L2C_4ATM
  !L2C_SIGN
  !L2C_FLAG
  !-------------------------------------------
  !     COMMON /L2M_PLAN/ 
  !
  !    * L2P_DEV,L2P_DOBS,L2P_EDEV,L2P_NPLAN,L2P_NATOM,L2P_IATOM
  !    *,L2P_ATOM,L2P_FLAG
  !
  !    *,L2P_LABEL
  !
  INTEGER L2M_PLAN_SIZE_I
  PARAMETER (L2M_PLAN_SIZE_I = MAX1APL*MAX1PLN*6 + MAX1PLN + 1)
  INTEGER L2M_PLAN_SIZE_C
  PARAMETER (L2M_PLAN_SIZE_C = MAX1PLN*8    )

  REAL      L2P_DEV  (MAX1APL,MAX1PLN)
  REAL      L2P_DOBS (MAX1APL,MAX1PLN)
  REAL      L2P_EDEV (MAX1APL,MAX1PLN)
  INTEGER*4 L2P_NPLAN
  INTEGER*4 L2P_NATOM (MAX1PLN)
  INTEGER*4 L2P_IATOM (MAX1APL,MAX1PLN)
  INTEGER*4 L2P_ATOM  (MAX1APL,MAX1PLN)
  INTEGER*4 L2P_FLAG  (MAX1APL,MAX1PLN)
  
  CHARACTER L2P_LABEL (MAX1PLN)*8

  !L2P_DEV 
  !L2P_NPLAN 
  !L2P_NATOM
  !L2P_ATOM
  !L2P_FLAG
  !L2P_LABEL
  !===================================================================
  
  !===================================================================
  !-- Common arrays for structure informations about current monomer.
  !--------------------------------------------------------
  !     PARAMETER (MX1ATOM = 250)
  !     PARAMETER (MX1BRN  =   8)
  !     PARAMETER (MX1ALT  =  20)
  !     PARAMETER (MX1EXT  =  50)
  !--------------------------------------------------------
  !     COMMON /CR1ATM/ 
  !
  !    * C1_XYZ,C1_CSD,C1_BISO,C1_BSD,C1_ANIS,C1_ASD,C1_OCC,C1_OSD
  !    *,C1_USER,C1_NATOM,C1_NALT,C1_IGLOBAL,C1_IALT,C1_IGATM,C1_IRES
  !    *,C1_IGRES,C1_ICH,C1_SF_ID
  !
  !    *,C1_ANAME,C1_ANAME_INP,C1_ASYMB,C1_ATYPE,C1_ALT,C1_CORR,C1_BTYPE,C1_RNAME
  !    *,C1_CODE1,C1_PNUM,C1_RTYPE,C1_S_TERM,C1_F_TERM,C1_FSC,C1_FSA
  !    *,C1_FUS,C1_HFLAG,C1_SEG
  !
  INTEGER ICR1ATM_SIZE_I
  PARAMETER (ICR1ATM_SIZE_I = MX1ATOM*26  +  6 )
  INTEGER ICR1ATM_SIZE_C
  PARAMETER (ICR1ATM_SIZE_C = MX1ATOM*20  + 53  + MX1ATOM*8)
  
  REAL   C1_XYZ  (3,MX1ATOM) 
  REAL   C1_CSD  (3,MX1ATOM)  
  REAL   C1_BISO (  MX1ATOM) 
  REAL   C1_BSD  (  MX1ATOM)  
  REAL   C1_ANIS (6,MX1ATOM) 
  REAL   C1_ASD  (6,MX1ATOM) 
  REAL   C1_OCC  (  MX1ATOM)  
  REAL   C1_OSD  (  MX1ATOM)
  REAL   C1_USER (  MX1ATOM)
  INTEGER*4 C1_NATOM  
  INTEGER*4 C1_NALT  (MX1ATOM)
  INTEGER*4 C1_IGLOBAL   
  INTEGER*4 C1_IALT  (MX1ATOM)
  INTEGER*4 C1_IGATM
  INTEGER*4 C1_IRES 
  INTEGER*4 C1_IGRES 
  INTEGER*4 C1_ICH  
  INTEGER*4 C1_SF_ID (MX1ATOM) 

  CHARACTER C1_ANAME (MX1ATOM)*4  
  CHARACTER C1_ANAME_INP(MX1ATOM)*4  
  CHARACTER C1_ASYMB (MX1ATOM)*4  
  CHARACTER C1_ATYPE (MX1ATOM)*1
  CHARACTER C1_ALT   (MX1ATOM)*1
  CHARACTER C1_CORR  (MX1ATOM)*1
  CHARACTER C1_BTYPE (MX1ATOM)*1 
  CHARACTER C1_RNAME  * 8
  CHARACTER C1_CODE1  * 1
  CHARACTER C1_PNUM   *12
  CHARACTER C1_RTYPE  *16
  CHARACTER C1_S_TERM * 8
  CHARACTER C1_F_TERM * 8
  CHARACTER C1_FSC   (MX1ATOM)*1
  CHARACTER C1_FSA   (MX1ATOM)*1
  CHARACTER C1_FUS   (MX1ATOM)*1
  CHARACTER C1_HFLAG (MX1ATOM)*1
  CHARACTER C1_SEG   (MX1ATOM)*8
  
  !C1_XYZ   - coordinates.                           
  !C1_CSD   - sd of coords.                          
  !C1_BISO  - iso.temp.factor                         
  !C1_BSD   - sd iso.temp.factor                       
  !C1_ANIS  - aniso.temp.factor                      
  !C1_ASD   - sd aniso                                
  !C1_OCC   - occupancy.                             
  !C1_OSD   - sd occupancy.                          
  !C1_USER  - user's data
  !C1_NATOM - number of atoms in the monomer.
  !C1_NALT  - number of alt. position for this atom (only for first alt.atoms,
  !                                                  for others NALT=0 ).
  !C1_IGLOBAL - global serial number of first atom of monomer - 1.
  !C1_IALT    - for first alt atom = 0, for others = atom's number of 
  !                                                            first atom
  !C1_IGATM   - global serial number of atom in the monomer
  !C1_IRES    - serial number of residue in chain started from 1.
  !C1_IGRES   - global serial number of residue in the structure.
  !C1_ICH     - serial number of chain for each residue started from 1.
  !C1_ANAME   - atom's name - 4 chars.            
  !C1_ASYMB   - atom's symbol - 4 chars.  / for SF /         
  !C1_ATYPE   - atom's type: "M" missing,"R" rebuild,"D" dummy, "U" unknown. 
  !C1_ALT     - ID of alternative position.       
  !C1_CORR    - ID of correlated alt. positions.  
  !C1_BTYPE   - "I" - iso,"A" - aniso,"O" - overal. 
  !C1_RNAME   - 3 letters code of residue. 
  !C1_CODE1   - 1 letter code of residue. 
  !C1_PNUM    - chainID + residue's number + insertion code.
  !C1_RTYPE   - type of residue: "pept","DNA","RNA,"solv",...
  !C1_TERM    - type of terminus of chain: "NH3", "COO", ...
  !C1_FSC     - flag of coord's sigma
  !C1_FSA     - flag of aniso's sigma
  !C1_FUS     - flag of user data
  !C1_HFLAG   -
  !-----------------------------------------------
  !     COMMON /CR1STR/ 
  !
  !    * S1_VDW,S1_ION,S1_CHAR,S1_DIST,S1_THT,S1_PSI,S1_INEW,S1_IOLD,S1_ILIB
  !    *,S1_ICRD
  !    *,S1_NDIST,S1_NEXTR,S1_IEXTR,S1_CONN,S1_LENCON,S1_IBACK
  !    *,S1_IFORW,S1_ICHEM,S1_ISTART,S1_IFINISH,S1_CONN_S,S1_CONN_F
  !
  !    *,S1_BACK,S1_FORW,S1_CHEM,S1_HBT,S1_ID_PSI,S1_FTREE
  !
  INTEGER ICR1STR_SIZE_I

  INTEGER ICR1STR_SIZE_C 
  PARAMETER (ICR1STR_SIZE_C = MX1ATOM*21  + 1        )
  
  REAL      S1_VDW    (MX1ATOM)
  REAL      S1_ION    (MX1ATOM)
  REAL      S1_CHAR   (MX1ATOM)
  REAL      S1_DIST   (MX1ATOM)  
  REAL      S1_THT    (MX1ATOM)
  REAL      S1_PSI    (MX1ATOM)
  INTEGER*4 S1_INEW   (MX1ATOM) 
  INTEGER*4 S1_IOLD   (MX1ATOM) 
  INTEGER*4 S1_ILIB   (MX1ATOM) 

  INTEGER*4 S1_ICRD   (MX1ATOM) 
  
  INTEGER*4 S1_NDIST  (MX1ATOM) 
  INTEGER*4 S1_NEXTR  (MX1ATOM) 
  INTEGER*4 S1_IEXTR  (MX1EXT,MX1ATOM) 
  INTEGER*4 S1_CONN   (MX1BRN,MX1ATOM) 
  INTEGER*4 S1_LENCON (MX1BRN,MX1ATOM) 
  INTEGER*4 S1_IBACK  (MX1ATOM) 
  INTEGER*4 S1_IFORW  (MX1ATOM) 
  INTEGER*4 S1_ICHEM  (MX1ATOM)  
  INTEGER*4 S1_CONN_S (MX1ATOM)  
  INTEGER*4 S1_CONN_F (MX1ATOM)  
  INTEGER*4 S1_ISTART (MX1ATOM)
  INTEGER*4 S1_IFINISH(MX1ATOM)
  
  CHARACTER S1_BACK   (MX1ATOM)*4
  CHARACTER S1_FORW   (MX1ATOM)*4
  CHARACTER S1_CHEM   (MX1ATOM)*4  
  CHARACTER S1_HBT    (MX1ATOM)*1  
  CHARACTER S1_ID_PSI (MX1ATOM)*8 
  CHARACTER S1_FTREE           *1  
  
  !S1_VDW    - Van_der_Waals radius.
  !S1_CHAR   - Charge
  !S1_DIST   - 
  !S1_THT    -
  !S1_PSI    -
  !S1_INEW,S1_IOLD,S1_ILIB
  !S1_NDIST,S1_IEXTR,S1_CONN,S1_LENCON
  !S1_IBACK  -
  !S1_IFORW   -
  !S1_BACK   -
  !S1_FORW    -
  !S1_ICHEM  - chemical type number.
  !S1_CHEM   - chemical type.  
  !S1_HBT    - Type of hydrogen. Donor "D",acceptor "A",both "B" or "N".
  !S1_ID_PSI -
  !S1_FTREE
  !--------------------------------------------------------
  !
  INTEGER ICR2ATM_SIZE_I
  PARAMETER (ICR2ATM_SIZE_I = MX1ATOM*26  +  6 )
  INTEGER ICR2ATM_SIZE_C
  PARAMETER (ICR2ATM_SIZE_C = MX1ATOM*20  + 53 + MX1ATOM*8)
  
  REAL   C2_XYZ  (3,MX1ATOM) 
  REAL   C2_CSD  (3,MX1ATOM)  
  REAL   C2_BISO (  MX1ATOM) 
  REAL   C2_BSD  (  MX1ATOM)  
  REAL   C2_ANIS (6,MX1ATOM) 
  REAL   C2_ASD  (6,MX1ATOM) 
  REAL   C2_OCC  (  MX1ATOM)  
  REAL   C2_OSD  (  MX1ATOM)
  REAL   C2_USER (  MX1ATOM)
  INTEGER*4 C2_NATOM  
  INTEGER*4 C2_NALT  (MX1ATOM)
  INTEGER*4 C2_IGLOBAL   
  INTEGER*4 C2_IALT  (MX1ATOM)
  INTEGER*4 C2_IGATM   
  INTEGER*4 C2_IRES 
  INTEGER*4 C2_IGRES 
  INTEGER*4 C2_ICH 
  INTEGER*4 C2_SF_ID (MX1ATOM) 
  
  CHARACTER C2_ANAME (MX1ATOM)*4  
  CHARACTER C2_ANAME_INP(MX1ATOM)*4  
  CHARACTER C2_ASYMB (MX1ATOM)*4  
  CHARACTER C2_ATYPE (MX1ATOM)*1
  CHARACTER C2_ALT   (MX1ATOM)*1
  CHARACTER C2_CORR  (MX1ATOM)*1
  CHARACTER C2_BTYPE (MX1ATOM)*1 
  CHARACTER C2_RNAME  * 8
  CHARACTER C2_CODE1  * 1
  CHARACTER C2_PNUM   *12
  CHARACTER C2_RTYPE  *16
  CHARACTER C2_S_TERM * 8
  CHARACTER C2_F_TERM * 8
  CHARACTER C2_FSC   (MX1ATOM)*1
  CHARACTER C2_FSA   (MX1ATOM)*1
  CHARACTER C2_FUS   (MX1ATOM)*1
  CHARACTER C2_HFLAG (MX1ATOM)*1
  CHARACTER C2_SEG   (MX1ATOM)*8
  
  !-----------------------------------------------
  !     COMMON /CR2STR/ 
  !
  !    * S2_VDW,S2_ION,S2_CHAR,S2_DIST,S2_THT,S2_PSI,S2_INEW,S2_IOLD,S2_ILIB
  !    *,S2_ICRD
  !    *,S2_NDIST,S2_NEXTR,S2_IEXTR,S2_CONN,S2_LENCON,S2_IBACK,S2_IFORW
  !    *,S2_ICHEM,S2_ISTART,S2_IFINISH,S2_CONN_S,S2_CONN_F
  !
  !    *,S2_BACK,S2_FORW,S2_CHEM,S2_HBT,S2_ID_PSI,S2_FTREE
  !
  INTEGER ICR2STR_SIZE_I

  INTEGER ICR2STR_SIZE_C
  PARAMETER (ICR2STR_SIZE_C = MX1ATOM*21  + 1        )
  
  REAL      S2_VDW    (MX1ATOM)
  REAL      S2_ION    (MX1ATOM)
  REAL      S2_CHAR   (MX1ATOM)
  REAL      S2_DIST   (MX1ATOM)  
  REAL      S2_THT    (MX1ATOM)
  REAL      S2_PSI    (MX1ATOM)
  INTEGER*4 S2_INEW   (MX1ATOM) 
  INTEGER*4 S2_IOLD   (MX1ATOM) 
  INTEGER*4 S2_ILIB   (MX1ATOM) 
  
  INTEGER*4 S2_ICRD   (MX1ATOM) 
  
  INTEGER*4 S2_NDIST  (MX1ATOM) 
  INTEGER*4 S2_NEXTR  (MX1ATOM) 
  INTEGER*4 S2_IEXTR  (MX1EXT,MX1ATOM) 
  INTEGER*4 S2_CONN   (MX1BRN,MX1ATOM) 
  INTEGER*4 S2_LENCON (MX1BRN,MX1ATOM) 
  INTEGER*4 S2_IBACK  (MX1ATOM) 
  INTEGER*4 S2_IFORW  (MX1ATOM) 
  INTEGER*4 S2_ICHEM  (MX1ATOM)  
  INTEGER*4 S2_CONN_S (MX1ATOM)  
  INTEGER*4 S2_CONN_F (MX1ATOM)  
  INTEGER*4 S2_ISTART (MX1ATOM)
  INTEGER*4 S2_IFINISH(MX1ATOM)
  
  CHARACTER S2_BACK   (MX1ATOM)*4
  CHARACTER S2_FORW   (MX1ATOM)*4
  CHARACTER S2_CHEM   (MX1ATOM)*4  
  CHARACTER S2_HBT    (MX1ATOM)*1  
  CHARACTER S2_ID_PSI (MX1ATOM)*8 
  CHARACTER S2_FTREE           *1  
  !==============================================================
  
  !==============================================================
  !
  !    Connectivities.
  ! 
  !    initialization in INIT_CONN_INF / GETLIB (make_lib.f) /
  !
  !-----------------------------------------------------------------
  INTEGER NSTOR_PAR
  PARAMETER ( NSTOR_PAR = 50 )
  INTEGER NSTORPAR_SIZE_I
  PARAMETER ( NSTORPAR_SIZE_I = NSTOR_PAR*8 + 1 + MAXLLNK*3 )
  INTEGER NSTORPAR_SIZE_C
  PARAMETER ( NSTORPAR_SIZE_C = NSTOR_PAR*4 )
  
  !     COMMON /COM_CONN_INF/  N_STOR,IFLAG_STOR,ICONN_ATOM_IND
  !    *                      ,X_STOR,Y_STOR,Z_STOR,BOND_IDL
  !
  !    *                      ,ATOM_STOR
  !-----------------------------------------------------------------
  !-
  INTEGER    ICONN_ATOM_IND(2,MAXLLNK)
  INTEGER    N_STOR,IFLAG_STOR(NSTOR_PAR,2)
  REAL       X_STOR(NSTOR_PAR,2),Y_STOR(NSTOR_PAR,2)
  real       Z_STOR(NSTOR_PAR,2),BOND_IDL(MAXLLNK)
  !
  CHARACTER  ATOM_STOR(NSTOR_PAR)*4
  !-----------------------------------------------------------------
  !===============================================================
  !    Library of energetic parameters.
  !
  !      PARAMETER (MAXETYP   = 300 )
  !      PARAMETER (MAXBTYP   = 500 )
  !      PARAMETER (MAXWTYP   = 500 )
  !      PARAMETER (MAXHTYP   = 300 )
  !      PARAMETER (MAXATYP   =1500 )
  !      PARAMETER (MAXTTYP   = 500 )
  !      PARAMETER (MAXSTYP   = 100 )
  !
  !===================================================================

  INTEGER LEA_PAR_SIZE_I
  PARAMETER (LEA_PAR_SIZE_I = MAXETYP*8 + 2 )
  INTEGER LEA_PAR_SIZE_C
  PARAMETER (LEA_PAR_SIZE_C = MAXETYP*10    )
  
  REAL      LEA_WEIGHT (MAXETYP)
  REAL      LEA_RADIUS (MAXETYP)
  REAL      LEA_HRADIUS(MAXETYP)
  REAL      LEA_IRADIUS(MAXETYP)
  REAL      LEA_POLAR  (MAXETYP)
  REAL      LEA_HPOLAR (MAXETYP)
  INTEGER*4 LEA_VALENCY(MAXETYP)
  INTEGER*4 LEA_SP     (MAXETYP)
  INTEGER*4 LEA_NATOM,LEA_IATOM
  
  CHARACTER LEA_ANAME (MAXETYP)*4
  CHARACTER LEA_ENAME (MAXETYP)*4
  CHARACTER LEA_HTYPE (MAXETYP)*1
  CHARACTER LEA_TYPE  (MAXETYP)*1
  !-------------------------------------------

  INTEGER LEB_PAR_SIZE_I
  PARAMETER (LEB_PAR_SIZE_I = MAXBTYP*4 + 2 )
  INTEGER LEB_PAR_SIZE_C
  PARAMETER (LEB_PAR_SIZE_C = MAXBTYP*16    )
  
  REAL      LEB_CONST   (MAXBTYP)
  REAL      LEB_LENGTH  (MAXBTYP)
  INTEGER*4 LEB_NBOND,LEB_IBOND
  INTEGER*4 LEB_I1ATM   (MAXBTYP)
  INTEGER*4 LEB_I2ATM   (MAXBTYP)
  
  CHARACTER LEB_1ATM  (MAXBTYP)*4
  CHARACTER LEB_2ATM  (MAXBTYP)*4
  CHARACTER LEB_TYPE  (MAXBTYP)*8
  !-------------------------------------------
  
  PARAMETER (LEG_PAR_SIZE_I = MAXATYP*5 + 2 )
  INTEGER LEG_PAR_SIZE_C
  PARAMETER (LEG_PAR_SIZE_C = MAXATYP*12    )
  
  REAL      LEG_CONST (MAXATYP)
  REAL      LEG_ANGLE (MAXATYP)
  INTEGER*4 LEG_NANGL,LEG_IANGL 
  INTEGER*4 LEG_I1ATM (MAXATYP)
  INTEGER*4 LEG_I2ATM (MAXATYP)
  INTEGER*4 LEG_I3ATM (MAXATYP)
  
  CHARACTER LEG_1ATM  (MAXATYP)*4
  CHARACTER LEG_2ATM  (MAXATYP)*4
  CHARACTER LEG_3ATM  (MAXATYP)*4
  !-------------------------------------------
  !     COMMON /LBE_TORS/ LET_CONST,LET_ANGLE,LET_NTORS,LET_ITORS
  !    *                 ,LET_PRD
  !    *                 ,LET_1ATM,LET_2ATM,LET_3ATM,LET_4ATM
  !    *                 ,LET_LABEL
  INTEGER LET_PAR_SIZE_I
  PARAMETER (LET_PAR_SIZE_I = MAXTTYP*3 + 2 )
  INTEGER LET_PAR_SIZE_C
  PARAMETER (LET_PAR_SIZE_C = MAXTTYP*24    )
  
  REAL      LET_CONST (MAXTTYP)
  REAL      LET_ANGLE (MAXTTYP)
  INTEGER*4 LET_NTORS,LET_ITORS 
  INTEGER*4 LET_PRD   (MAXTTYP)
  
  CHARACTER LET_1ATM  (MAXTTYP)*4
  CHARACTER LET_2ATM  (MAXTTYP)*4
  CHARACTER LET_3ATM  (MAXTTYP)*4
  CHARACTER LET_4ATM  (MAXTTYP)*4
  CHARACTER LET_LABEL (MAXTTYP)*8
  !-------------------------------------------
  !     COMMON /LBE_VDW/ LEW_EMIN,LEW_RMIN,LEW_NCONT,LEW_ICONT
  !    *                ,LEW_1ATM,LEW_2ATM
  !    *                ,LEW_HFLAG
  INTEGER LEW_PAR_SIZE_I
  PARAMETER (LEW_PAR_SIZE_I = MAXWTYP*2 + 2 )
  INTEGER LEW_PAR_SIZE_C
  PARAMETER (LEW_PAR_SIZE_C = MAXWTYP*9    )
  
  REAL      LEW_EMIN  (MAXWTYP)
  REAL      LEW_RMIN  (MAXWTYP)
  INTEGER*4 LEW_NCONT,LEW_ICONT
  
  CHARACTER LEW_1ATM  (MAXWTYP)*4
  CHARACTER LEW_2ATM  (MAXWTYP)*4
  CHARACTER LEW_HFLAG (MAXWTYP)*1
  !-------------------------------------------
  !     COMMON /LBE_HBOND/ LEH_EMIN,LEH_DIST,LEH_NHBOND,LEH_IHBOND
  !    *                ,LEH_1ATM,LEH_2ATM
  INTEGER LEH_PAR_SIZE_I
  PARAMETER (LEH_PAR_SIZE_I = MAXHTYP*2 + 2 )
  INTEGER LEH_PAR_SIZE_C
  PARAMETER (LEH_PAR_SIZE_C = MAXHTYP*8    )

  REAL      LEH_EMIN  (MAXHTYP)
  REAL      LEH_DIST  (MAXHTYP)
  INTEGER*4 LEH_NHBOND,LEH_IHBOND

  CHARACTER LEH_1ATM  (MAXHTYP)*4
  CHARACTER LEH_2ATM  (MAXHTYP)*4
  !-------------------------------------------
  !     COMMON /LBE_ASYN/ LES_NSYN,LES_ISYN
  !    *                 ,LES_ATYP,LES_STYP
  INTEGER LES_PAR_SIZE_I
  PARAMETER (LES_PAR_SIZE_I =  2           )
  INTEGER LES_PAR_SIZE_C
  PARAMETER (LES_PAR_SIZE_C = MAXSTYP*8    )
  
  INTEGER*4 LES_NSYN,LES_ISYN
  
  CHARACTER LES_ATYP  (MAXSTYP)*4
  CHARACTER LES_STYP  (MAXSTYP)*4

contains
  subroutine allocate_lib_arrays

  end subroutine allocate_lib_arrays

  subroutine deallocate_lib_arrays

  end subroutine deallocate_lib_arrays
end module lib_com
