module linalg90

contains
  subroutine cholesky(ain,aout)
    implicit none
    real, intent(in) :: ain(:,:)
    real, intent(out) :: aout(:,:)
    !
    ! locals
    integer i,j,k,n
    real a11
    !
    !   body
    n = size(ain(1,:))
    
    aout(1:n,1:n) = 0.0
    do i=1,n
       do j=1,i
          sum = 0.0
          do k=1,j-1
             sum = sum + aout(i,k)*aout(j,k)
          enddo
          if(i.eq.j) then
             aout(i,i) = sqrt(ain(i,i)-sum)
          else
             aout(i,j) = (ain(i,j)-sum)/aout(j,j)
          endif
       enddo
    enddo

    !
    !  Derivatives
    do i=1,n
       do j=1,i
          sum = 0.0
          do k=1,j-1
             sum = sum + aout(i,j)*aout(j,k)
          enddo
          if(i.eq.j) then
             a11 = 0.5/(ain(i,i)-sum)
             daout(i,i,i,i) = a11
             do k=1,j-1
                daout(i,i,i,k) = -a11*(aout(j,k)*daout(i,k,i,k)+aout(i,k)*daout(j,k,i,k))
                daout(i,i,j,k) = -a11*(aout(i,k)*daout(j,k,j,k)+aout(j,k)*daout(i,k,j,k))
             enddo
          else
             daout(i,j,i,j) = 1/aout(j,j)
             do k=1,j-1
                daout(i,j,i,k) = -aout(i,k)*daout(j,k,i,k)

             enddo
          endif
       enddo
    enddo




                do k=1,n
       a11 = 0.0
       if(k.gt.1) then
          do i=1,k-1
             a11 = a11 + aout(k,i)
          enddo
       enddo

       aout(k,k) = sqrt(ain(k,k) - a11)
       do j=k+1,l
          a11 = 0.0
          if(k.lt.n) then
             do i=n,k+1,-1
                a11 = s11 + aout(j,i)*aout(k,i)
             enddo
          endif
          aout(j,k) = (ain(j,k)-a11)/aout(k,k)
       enddo
    enddo

    return
  end subroutine cholesky

  subroutine dudcholesky(ain,aout)
    implicit none
    real, intent(in) :: ain(:,:)
    real, intent(out) :: aout(:,:,:,:)
    !
    !  locals
    integer i,j,k,l,n
    !
    ! body
    n = size(ain(1,:))

    aout(1:n,1:n,1:n,1:n) = 0.0

    do k=1,n
       a11 = 0.5/ain(k,k)
       aout(k,k,k,k) = aout(k,k,k,k) + a11
       if(k.gt.1) then
          do p=1,k-1
             do i=1,k-1
                aout(k,k,k,i) = aout(k,k,k,i) - 2.0*a11*aout(k,p,k,i)*ain(k,p)
             enddo
          enddo
       endif

       do j=k+1,n
          aout(j,k,j,k) = aout(j,k,j,k) + 1.0/ain(k,k)
          do p=k+1,n
             aout(j,k,j,p) = aout(j,k,j,p) - ain(k,p)/ain(k,k)
             aout(j,k,k,p) = aout(j,k,j,p) - ain(j,p)/ain(k,k)
          enddo
       enddo
    enddo

    return
  end subroutine dudcholesky

end module linalg90
