module local_tls
  use linalgebra_f90
  implicit none
  ! 
  ! Parameters for local tls restraints and their initial values
  integer :: local_tls_pairs=0
  real :: local_tls_dist=5.5
  real :: local_tls_weight=1.0
  real :: local_tls_sigma=0.1

contains
  subroutine local_tls_rest(sum_tmp,nmpos,nvpos,nmtmp,a_mat,vect,n_target,n_object,nw_uval,nsym_dist, &
       xyz_crd,u_aniso,occup,atom_ref_flag,rest_pos_per_atom,rest_per_atom,rot,tr,cell)
    implicit none
    !
    !   Local tls restraints. U values of atoms within sphere with the radius equal to local_tls_dist
    !   are used to predict U value of the atom (for each atom) and tr(U-U_est)**2 is used as restraints.
    !   Note that U_est depends on all U values (in general and positional parameters) of all atoms within sphere
    
    integer, intent(in) :: nmpos,nvpos,nmtmp
    real, intent(out) :: sum_tmp
    
    real, intent(in) :: cell(6)
    real, intent(in) :: rot(:,:,:)
    real, intent(in) :: tr(:,:)
    real, intent(in) :: xyz_crd(:,:),u_aniso(:,:),occup(:)
    integer, intent(in) :: atom_ref_flag(:)

    real, intent(inout) :: a_mat(:),vect(:)
    integer, intent(in) :: n_target(:),n_object(:),nw_uval(:),nsym_dist(:,:)

    integer, intent(in) :: rest_pos_per_atom(:)
    integer, intent(in) :: rest_per_atom(:)
    !
    !locals    
    integer nrest_per_atom1
    integer, allocatable :: rest_per_atom1(:)
    real(kind=8) :: tmat_loc(6),lmat_loc(6),smat_loc(8)
    real(kind=8), allocatable :: dtmatdu(:,:,:)

    integer, allocatable :: lposv(:)
    integer, allocatable :: lposm(:)
    integer, allocatable :: lpos_nd(:)

    integer nsym_dist_l(4)
    integer iposu1,iposu2,iposm,ian,ian1,idist,imode
    integer i,j,ia,ndist,im,ia1,ia2,ir,ir1,is1
    
    real wtt
    real dfda(6),d2fda2(6),dadu(6),deltau(6)
    real xyz_tmp(3),xyz_tmp1(3)
    real dist
    
    integer nsym,n_atom
    logical derflag
    !
    !  Body
    if(local_tls_pairs.eq.0) return

    n_atom = size(xyz_crd(1,:))
    if(n_atom.le.2) return
    ndist = size(n_target(:))
    if(ndist.le.1) return
    nsym = size(rot(1,1,:))
    !
    !  Find position of of atoms and distances in the gradient and second derivative matrix
    allocate(lposv(n_atom))
    allocate(lposm(n_atom))
    call find_pos_of_u(n_atom,n_atom,atom_ref_flag(1:n_atom),u_aniso(1:6,1:n_atom),lposv,lposm,1)
    allocate(lpos_nd(ndist))
    call find_pos_of_u_nd(ndist,n_target,n_object,u_aniso(1:6,1:n_atom),lpos_nd)

    sum_tmp = 0.0
    wtt = 1.0/local_tls_sigma**2
    do ia=1,n_atom
       if(atom_ref_flag(ia).gt.0.and.rest_pos_per_atom(ia).eq.rest_pos_per_atom(ia+1)) cycle
       if(u_aniso(2,ia).le.0.0) cycle
       allocate(rest_per_atom1(rest_pos_per_atom(ia+1)-rest_per_atom(ia)+1))
       nrest_per_atom1 = 1
       rest_per_atom1(1) = ia
       do i=rest_pos_per_atom(ia)+1,rest_pos_per_atom(ia+1)
          ia1 = rest_per_atom(i)
          dist = sqrt(sum((xyz_crd(1:3,ia)-xyz_crd(1:3,ia1))**2))
          if(dist.ge.local_tls_dist) cycle
          nrest_per_atom1 = nrest_per_atom1 + 1
          rest_per_atom1(nrest_per_atom1) = rest_per_atom(i)
       enddo
       allocate(dtmatdu(6,6,nrest_per_atom1))
       !
       !   Estimate TLS parameters at this atom using neighbours. After estimation we need onlye T component 
       !  (since contributions of L and S at this atom are zero)
       call local_tls_fit(ia,nrest_per_atom1,rest_per_atom1(1:nrest_per_atom1),                   &
            xyz_crd,u_aniso,occup,atom_ref_flag,rot,tr,cell,tmat_loc,lmat_loc,smat_loc,dtmatdu)

       deltau = u_aniso(1:6,ia)-tmat_loc(1:6)
       sum_tmp = sum_tmp + 0.5*wtt*(sum(deltau(1:3)**2)+2.0*sum(deltau(4:6)**2))

       !
       ! Weights a la Kulback-Leibler divergence or F/Wishart distribution?
       dfda(1:6) = deltau(1:6)
       dfda(4:6) = 2.0*dfda(4:6)
       d2fda2(1:3) = 1.0
       d2fda2(4:6) = 2.0
       
       do i=1,6
          dtmatdu(i,i,1) = dtmatdu(i,i,1)-1.0
       enddo
       
       dfda = wtt*dfda
       d2fda2 = wtt*d2fda2
       iposu1 = lposv(ia1)+nvpos
       iposu2 = iposu1+5
       !            write(*,*)'Before vect',iposu1,iposu2,iposm
       
       do ir=1,nrest_per_atom1
          ia1 = rest_per_atom1(ir)
          iposu1 = lposv(ia1)
          iposu2 = iposu1+5
          do i=1,6
             vect(iposu1:iposu2) = vect(iposu1:iposu2) + sum(dfda(1:6)*dtmatdu(1:6,i,ir))
          enddo
          iposm = nmpos + lposm(ia1)-1
          
          do ian=1,6
             iposm=iposm+1
             a_mat(iposm) = a_mat(iposm) + sum(d2fda2(1:6)*dtmatdu(1:6,ian,ir)**2)
          enddo
          do ian=1,5
             do ia1=ian1+1,6
                iposm = iposm+1
                a_mat(iposm) = a_mat(iposm) + sum(d2fda2(1:6)*dtmatdu(1:6,ian,ir)*dtmatdu(1:6,ian1,ir))
             enddo
          enddo
          !
          !  add diagonals
       enddo
       
       do ir=1,nrest_per_atom1-1
          ia1 = rest_per_atom1(ir)
          do ir1=ir+1,nrest_per_atom1
             !
             !  Symmetry needs to be considered somewhere here
             ia2 = rest_per_atom1(ir1)
             nsym_dist_l(1:4) = 0
             nsym_dist_l(1) = 1
             if(ia1.ne.ia2) then
                call find_restraint(ndist,ndist,idist,ia1,ia2,nsym_dist_l,n_atom,rest_pos_per_atom, &
                     rest_per_atom,n_target,n_object,nsym_dist,nw_uval,imode)
                iposm = nmtmp + lpos_nd(idist)-1
                do ian=1,6
                   do ian1=1,6
                      iposm = iposm+1
                      a_mat(iposm)=a_mat(iposm)+ sum(d2fda2(1:6)*dtmatdu(1:6,ian,ir)*dtmatdu(1:6,ian1,ir1))
                   enddo
                enddo
             else
             endif
          enddo
       enddo
       deallocate(rest_per_atom1)
       deallocate(dtmatdu)
    enddo
    
    deallocate(lposv)
    deallocate(lposm)
    deallocate(lpos_nd)

    return
  end subroutine local_tls_rest
  !
  !
  subroutine local_tls_fit(ia,nrest_per_atom,rest_per_atom,  &
       xyz_crd,u_aniso,occup,atom_ref_flag,rot,tr,cell,tmat_loc,lmat_loc,smat_loc,dtmatdu)
    implicit none
    !
    !---  This routine estimates local tls parameters for each atom.
    !---  The number of atoms should be sufficient for this estimate to be reliable
    !---  
    real, intent(in) :: rot(:,:,:),tr(:,:),cell(6)
    real, intent(in) :: xyz_crd(:,:),u_aniso(:,:),occup(:)
    real(kind=8), intent(out) ::  tmat_loc(6),lmat_loc(6),smat_loc(8)
    real(kind=8), optional, intent(out) :: dtmatdu(:,:,:)
    integer, intent(in) :: atom_ref_flag(:)
    integer, intent(in) :: nrest_per_atom,rest_per_atom(:)
    
    real ro_unit(3,3),rfr_unit(3,3)
    real rsymm_ort(3,3,192)
    integer i,j,k,l,ia,ia1,ir,in,im,is,isym,ierror
    real xyz_this(3),xyz_ort(3),xyz_neighbour(3),xyz1(3),xyz2(3)
    real u2v(6),u2(3,3),tmp(3,3)
    real dfdu(6),d2fdu2(6)
    real d2fd2(20,6)
    real dudtls(6,20)
    real(kind=8) :: toler=1.0d-8
    real(kind=8) :: dist,wtt
    real(kind=8) ::  dfdtls(20),d2fdtls2(20,20),d2fdtls2i(20,20),shft_tls(20)
    real :: nwork_space = 1000
    real(kind=8) :: workspace(1000)
    real(kind=8), allocatable :: dfdtlsdu(:,:,:)
    !
    integer nsym,n_atom
    real ci(6)
    !
    !---  body 
    if(nrest_per_atom.le.0) return    
    ia1 = atom_ref_flag(ia)/10
    if(atom_ref_flag(ia).le.0.or.ia1.le.0) return
    !
    nsym = size(rot(1,1,:))
    n_atom = size(xyz_crd(1,:))
    call find_ort_symm(nsym,rot(1:3,1:3,1:nsym),tr(1:3,1:nsym),cell,rsymm_ort(1:3,1:3,1:nsym))
    !
    !---Central atom
    xyz_ort(1:3) = 0.0
    call derivs_wrt_tlspars(xyz_ort,dudtls)
    dfdu = u_aniso(1:6,ia)
    dfdu(4:6) = 2.0*dfdu(4:6)
    ci(1:3) = 1.0
    ci(4:6) = 2.0
    d2fdu2(1:3) = 1.0
    d2fdu2(4:6) = 2.0
    
    dfdtls(1:20) = 0.0
    d2fdtls2(1:20,1:20) = 0.0
    if(present(dtmatdu)) then
       allocate(dfdtlsdu(20,6,nrest_per_atom))
       dfdtlsdu(1:20,1:6,1:nrest_per_atom) = 0.0
    endif
    do k=1,20       
       do i=1,6
          dfdtls(k)       = -dfdu(i)*dudtls(i,k)
          if(present(dtmatdu)) dfdtlsdu(k,i,1) = -ci(i)*dudtls(i,k)
       enddo
    enddo
    
    do k=1,20
       do l=1,20
          do i=1,6
             d2fdtls2(k,l) = d2fdtls2(k,l) + d2fdu2(i)*dudtls(i,k)*dudtls(i,l) 
          enddo
       enddo
    enddo
    !
    !---  Neighbouring atoms
    xyz_this = xyz_crd(1:3,ia)
    do ir=1,nrest_per_atom
       in = rest_per_atom(ir)
       if(atom_ref_flag(in).gt.0) then
          xyz_neighbour(1:3) = xyz_crd(1:3,in)
          
          !
          !  Ignore symmetries for now

          xyz_ort = xyz_neighbour(1:3)-xyz_this(1:3)
          dist = sqrt(sum(xyz_ort(1:3)**2))
          wtt = 1.0
          
          call derivs_wrt_tlspars(xyz_ort,dudtls)
          
          u2v = u_aniso(1:6,in)
          call aniso_vect2mat(u2v,u2)
          if(isym.gt.1) then
             tmp = matmul(rsymm_ort(1:3,1:3,isym),u2)
             u2  = matmul(tmp,transpose(rsymm_ort(1:3,1:3,isym)))
          endif
          
          call aniso_mat2vec(u2,u2v)
          dfdu(1:3) = u2v(1:3)
          dfdu(4:6) = 2.0*u2v(4:6)
          d2fdu2(1:3) = 1.0
          d2fdu2(4:6) = 2.0
          
          dfdu = wtt*dfdu
          d2fdu2 = wtt*d2fdu2
          do k=1,20
             do i=1,6 
                dfdtls(k)          = dfdtls(k) - dfdu(i)*dudtls(i,k)
                if(present(dtmatdu)) dfdtlsdu(k,i,ir+1) = dfdtlsdu(k,i,ir+1) - ci(i)*dudtls(i,k)
             enddo
          enddo
          do k=1,20
             do l=1,20
                do i=1,6
                   d2fdtls2(k,l) = d2fdtls2(k,l) + d2fdu2(i)*dudtls(i,k)*dudtls(i,l)
                enddo
             enddo
          enddo
       endif
    enddo
    call deigen_filter_invert_f90_r(d2fdtls2,d2fdtls2i,toler)
    
    shft_tls = matmul(d2fdtls2i,dfdtls)
    !       call deigen_filter_r(toler,d2fdtls2,20,20,dfdtls,shft_tls, workspace,nwork_space)
    tmat_loc(1:6) = shft_tls(1:6)
    if(present(dtmatdu)) then
       do ir=1,nrest_per_atom + 1
          dtmatdu(1:6,1:6,ir) = matmul(d2fdtls2i(1:6,1:20),dfdtlsdu(1:20,1:6,ir))
       enddo
    endif
    lmat_loc(1:6) = shft_tls(7:12)
    smat_loc(1:8) = shft_tls(13:20)

    write(*,*)'i:',ia,n_atom
    write(*,*)'n:',nrest_per_atom
    write(*,*)'u:',u_aniso(1:6,ia)
    write(*,*)'t:',tmat_loc(1:6)
    write(*,*)'l:',lmat_loc(1:6)
    write(*,*)'s:',smat_loc(1:8)
       
    call make_l_positive_1(tmat_loc,lmat_loc,smat_loc)
    write(*,*)'after '
    write(*,*)'i:',ia,n_atom
    write(*,*)'n:',nrest_per_atom
    write(*,*)'u:',u_aniso(1:6,ia)
    write(*,*)'t:',tmat_loc(1:6)
    write(*,*)'l:',lmat_loc(1:6)
    write(*,*)'s:',smat_loc(1:8)

    if(allocated(dfdtlsdu)) deallocate(dfdtlsdu)
    write(*,*)'After local_tls_fit'
    stop
    return
  end subroutine local_tls_fit


end module local_tls
