C --- MAKECIF.F ---
C -------------------------------------------------------
      INTEGER*4 IERR,LEN,MDOC,M,IG
      CHARACTER IN_COORD_FILE*256,OUT_FILE_CIF*256,FILE_LIB2*256
      CHARACTER LINE*256,PATH*256,EXT*256,NAME*80,MSG*1,H_FLAG*1
      CHARACTER CHECK_SPEC*1,CONN_FLAG*1,RFLAG*1,FORM*1,SYMM_FLAG*1
      CHARACTER CIS_FLAG*1,LNK_FLAG*1,CHAIN_FLAG*1,PEPT_FLAG*1,SRCH*1
      CHARACTER SS_FLAG*1,SUGAR_FLAG*1,LIST*1,CHECK*1,NEW*1,COOR*1
      CHARACTER SEG_FLAG*1
      CHARACTER PROG_LIB_PATH*256,PROG_NAME*8,FSTOP*1
      CHARACTER LIBS_PATH*256,LIBS_NAME*256,LIBS_EXT*256
      CHARACTER LIB_OUT*256 
      INTEGER*4 NOSPGR_INPUT
      REAL      CELL_INPUT(6)
C ---
      INCLUDE 'makecif_version.fh'
C ===========================
      M    = 0
      IERR = 0
      CALL GET_PATH(M,'CLIBD_MON',LINE,IERR)
C     CALL GET_PATH(M,'MAKECIF',LINE,IERR)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.0) THEN
C       PROG_LIB_PATH = LINE(1:LEN)//'/dic/'
        PROG_LIB_PATH = LINE(1:LEN)
      ELSE
        PROG_LIB_PATH = ' '
      ENDIF
C --------------------------
      LIBS_PATH = ' '
      LIBS_NAME = ' '
      LIBS_EXT  = ' ' 
      PROG_NAME = 'makecif'
      CALL SET_PATH_PROG_PARM(PROG_LIB_PATH,PROG_NAME
     *                         ,LIBS_PATH,LIBS_NAME,LIBS_EXT)
C ===========================
      IERR = 0
      M    = 0
      IG   = 0
      CALL START_CCP4
C     PROG = 'makecif'
      CALL START(IG,M,PROG_NAME)
C ---------------------------
      CALL MSGDOC(M,' ')
      CALL MSGDOC(M,VERSION)
      CALL MSGDOC(M,' ')
C -------------------------------------------------------------
      CALL MSGDOC(M,
     *' Do you want to have FILE-DOCUMENT /makecif.doc/ ? /<N>/Y/A :')
      CALL MSGDOC(M,'   N - means without DOC-file')
      CALL MSGDOC(M,'   Y - with new contents')
      CALL MSGDOC(M,
     *'   A - means to keep old contents and add new information')
      CALL MSGDOC(M,
     *'       with DOC-file program creates batch file: makecif.bat')
      CALL DISPL_BL('_DOC:')
      READ(*,'(A)') LINE

      IBATCH = 0
      IF(LINE(1:4).EQ.'_DOC') THEN
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.GE.6) THEN
          DO I=6,LEN
            IF(LINE(I:I).NE.' ') THEN
              MSG=LINE(I:I)
              GO TO 10
            ENDIF
          ENDDO
        ENDIF
  10    CONTINUE
        IBATCH = 1
      ELSE
        MSG=LINE(1:1)
      ENDIF

      IF(MSG.EQ.'y') MSG = 'Y'
      IF(MSG.EQ.'a') MSG = 'A'
      IF(MSG.NE.'Y'.AND.MSG.NE.'A'.AND.MSG.NE.'#') MSG = 'N'

      IF(MSG.NE.'N'.OR.MSG.EQ.'#') THEN
        IF(MSG.EQ.'Y') MDOC = 999
        IF(MSG.EQ.'A') MDOC = 998
        IF(MSG.EQ.'#') MDOC = 997
        CALL START(IG,MDOC,PROG_NAME)
      ELSE
        MDOC=0
      ENDIF
      IF(IBATCH.EQ.1) CALL SET_BATCH(IBATCH)
C ---------------------------
 100  IERR = 0
      CALL CHECK_BATCH(IBAT)
      IF(IBAT.LE.0) CALL SET_DEFAULT('   input-coord-file')
      LINE='FILE_C'
      CALL ASK(LINE)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LT.1.OR.LINE(1:1).EQ.','.OR.LINE(1:1).EQ.' ') THEN
        CALL MSGDOC(M,' ERROR: wrong name of input file')
        GO TO 100
      ENDIF
      IN_COORD_FILE = LINE(1:LEN)
      CALL CORR_FILE_NAME(IN_COORD_FILE)
C -------------------------------------------
      NOSPGR_INPUT = 0
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO
      DMIN_SPEC = 0.0
      CUTOFF    = 0.0
      CALL MSGDOC(M,' ')
      CALL SET_DEFAULT(' ')
      CALL SET_DEFAULT('      Keywords:')
      CALL SET_DEFAULT(' ')
      CALL SET_DEFAULT(
     *'FILE_O: <new> - output_CIFiles /name without extention/')
      CALL SET_DEFAULT(
     *'FILE_L:  < >  - additional library, " " means without this file
     *')
      CALL SET_DEFAULT(
     *'SPEC:   <N>/Y - Y - check atoms in special position, N - not use
     *it.')
      CALL SET_DEFAULT(
     *'DMIN:   <0.5> - minimal distance to recognize atom in special pos
     *ition')
      CALL SET_DEFAULT(
     *'CONN: <N>/Y/D/0 - N - only check chain"s connection between resid
     *ues.')
      CALL SET_DEFAULT(
     *'SEG: <N>/Y      - Y - use SEG_ID instead CHAIN_ID')
      CALL SET_DEFAULT(
     *'                Y - use new chain"s connection between residues.
     *')
      CALL SET_DEFAULT(
     *'                D - use new but ignore user"s definition')
      CALL SET_DEFAULT(
     *'                0 - not do anything (include SS,SUGAG)')
      CALL SET_DEFAULT(
     *'CIS:   <N>/Y  - Y - check and change peptide link')
      CALL SET_DEFAULT(
     *'SS:   <Y>/N/D - N - only check SS-links')
      CALL SET_DEFAULT(
     *'                Y - use new SS-links between residues.')
      CALL SET_DEFAULT(
     *'                D - use new but ignore user"s definition')
      CALL SET_DEFAULT(
     *'SUGAR: <S>/N/Y/D -N - only check links between residues.')
      CALL SET_DEFAULT(
     *'                S - use only standard new links.')
      CALL SET_DEFAULT(
     *'                Y - use new links between residues.')
      CALL SET_DEFAULT(
     *'                D - use new but ignore user"s definition')
      CALL SET_DEFAULT(
     *'LINK: <N>/Y/D/0 - N - only check links between residues.')
      CALL SET_DEFAULT(
     *'                Y - use new links between residues.')
      CALL SET_DEFAULT(
     *'                D - use new but ignore user"s definition')
      CALL SET_DEFAULT(
     *'                0 - not do anything (include SS,SUGAG)')
      CALL SET_DEFAULT(
     *'CHAIN: <N>/Y  - Y - check and change chain description')
      CALL SET_DEFAULT(
     *'PEPT:  <N>/Y  - Y - check and correct AA in PDB file (L or D)')
      CALL SET_DEFAULT(
     *'SYMM: <N>/Y   - Y - use links between symmetry reated residues.')
      CALL SET_DEFAULT(
     *'CHECK: <N>/Y/0 - Y - full check of all monomers')
      CALL SET_DEFAULT(
     *'                 N - not check Prot, DNA/RNA, Sugars')
      CALL SET_DEFAULT(
     *'                 0 - not check any monomers')
      CALL SET_DEFAULT(
     *'SEARCH: <N>/G  - G - search sub-structure')
      CALL SET_DEFAULT(
     *'COOR: <N>/Y   - use Vobs from coords instead Videal')
      CALL SET_DEFAULT(
     *'CUT:    <0>   - distance cut_off, 0 - means without VDW and H-bon
     *d')
      CALL SET_DEFAULT(
     *'                restraints')
      CALL SET_DEFAULT(
     *'HFLAG: <Y>/A/N - Y - hydrogen atoms where they are (not create ne
     *w)')
      CALL SET_DEFAULT(
     *'                 A - with all hydrogen atoms (rebuild all missing
     * H atoms)')
      CALL SET_DEFAULT(
     *'                 N - without hydrogen atoms (i.e. remove H)')
      CALL SET_DEFAULT(
     *'RFLAG:  <N>/Y  - Y - rebuild non-hydrogen atoms')
      CALL SET_DEFAULT(
     *'                 restraints will not be created if HFLAG="A" or R
     *FLAG="Y"')
      CALL SET_DEFAULT(
     *'FORM:   <F>/U  - format of restrain file, U - unformatted')
      CALL SET_DEFAULT(
     *'NOSG:   <0>    - Number of new space group')
      CALL SET_DEFAULT(
     *'CELL:   <0>    - new cell: A,B,C,Alpha,Beta,Gamma')
      CALL SET_DEFAULT(
     *'LIST: <M>/S/L   - S short output, L - long, M - medium')
      CALL SET_DEFAULT(
     *'LOUT: <new.lib> - output file of new dictionary')
      CALL MSGDOC(M,'#')
      CALL MSGDOC(M,' ')
C ---
      CALL SET_DEFAULT('?')
C -------------------------------------------
      LINE='FILE_O'
      CALL ASK(LINE)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LT.1.OR.LINE(1:1).EQ.','.OR.LINE(1:1).EQ.' ') THEN
        LINE='new'
        CALL LENSTR_BL(LINE,LEN)
      ENDIF
      OUT_FILE_CIF=LINE(1:LEN)
      CALL CORR_FILE_NAME(OUT_FILE_CIF)
C ---
      CALL LENSTR_BL(OUT_FILE_CIF,LEN)
      CALL MSGDOC(MDOC,
     *'    output files:')
      CALL MSGDOC(MDOC,' ')
      LINE='   '//OUT_FILE_CIF(1:LEN)//
     *'.crd - coordinates'
      CALL MSGDOC(MDOC,LINE)
      LINE='   '//OUT_FILE_CIF(1:LEN)//
     *'.str - chemical structure information'
      CALL MSGDOC(MDOC,LINE)
      LINE='   '//OUT_FILE_CIF(1:LEN)//
     *'.rst - restraints'
      CALL MSGDOC(MDOC,LINE)
      LINE='   '//OUT_FILE_CIF(1:LEN)//
     *'.vdw - HB and VDW restraints (if CUT > 0)'
      CALL MSGDOC(MDOC,LINE)
      CALL MSGDOC(MDOC,' ')
C ---
      LINE='LOUT'
      CALL ASK(LINE)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LT.1.OR.LINE(1:1).EQ.','.OR.LINE(1:1).EQ.' ') THEN
        LIB_OUT=' '
      ELSE
        LIB_OUT=LINE(1:LEN)
        CALL CORR_FILE_NAME(LIB_OUT)
      ENDIF
C ---
      LINE='CUT'
      CALL ASK(LINE)
      READ(LINE,*) CUTOFF
C ---
      LINE='DMIN'
      CALL ASK(LINE)
      READ(LINE,*) DMIN_SPEC
C ---
      LINE='SPEC'
      CALL ASK(LINE)
      CHECK_SPEC=LINE(1:1)
C ---
      LINE='SEG'
      CALL ASK(LINE)
      SEG_FLAG=LINE(1:1)
C ---
      LINE='PEPT'
      CALL ASK(LINE)
      PEPT_FLAG=LINE(1:1)
C ---
      LINE='LINK'
      CALL ASK(LINE)
      LNK_FLAG=LINE(1:1)
C ---
      LINE='CHAIN'
      CALL ASK(LINE)
      CHAIN_FLAG=LINE(1:1)
C ---
      LINE='CIS'
      CALL ASK(LINE)
      CIS_FLAG=LINE(1:1)
C ---
      LINE='SS'
      CALL ASK(LINE)
      SS_FLAG=LINE(1:1)
C ---
      LINE='SUGAR'
      CALL ASK(LINE)
      SUGAR_FLAG=LINE(1:1)
C ---
      LINE='CONN'
      CALL ASK(LINE)
      CONN_FLAG=LINE(1:1)
C ---
      LINE='SYMM'
      CALL ASK(LINE)
      SYMM_FLAG=LINE(1:1)
C ---
      LINE='HFLAG'
      CALL ASK(LINE)
      H_FLAG=LINE(1:1)
C ---
      LINE='RFLAG'
      CALL ASK(LINE)
      RFLAG=LINE(1:1)
C ---
      LINE='FORM'
      CALL ASK(LINE)
      FORM=LINE(1:1)
C ---
      LINE='LIST'
      CALL ASK(LINE)
      LIST=LINE(1:1)
C ---
      LINE='CHECK'
      CALL ASK(LINE)
      CHECK=LINE(1:1)
C ---
      LINE='SEARCH'
      CALL ASK(LINE)
      SRCH=LINE(1:1)
C ---
      LINE='COOR'
      CALL ASK(LINE)
      COOR=LINE(1:1)
C ---
      LINE='NOSG'
      CALL ASK(LINE)
      READ(LINE,*) NOSPGR_INPUT
C ---
      LINE='CELL'
      CALL ASK(LINE)
      READ(LINE,*)  CELL_INPUT(1),CELL_INPUT(2),CELL_INPUT(3)
     *             ,CELL_INPUT(4),CELL_INPUT(5),CELL_INPUT(6)
C ---
      LINE='FILE_L'
      CALL ASK(LINE)
      FILE_LIB2=LINE
      CALL CORR_FILE_NAME(FILE_LIB2)
C ---
      LIBS_PATH = ' '
      LIBS_NAME = ' '
      LIBS_EXT  = ' ' 
C ---------------------------
      CALL MAKECIF(MDOC,IN_COORD_FILE,OUT_FILE_CIF,FILE_LIB2
     *     ,CUTOFF,DMIN_SPEC,CONN_FLAG,CIS_FLAG,LNK_FLAG,CHAIN_FLAG
     *     ,PEPT_FLAG,CHECK_SPEC,H_FLAG,RFLAG,FORM,SYMM_FLAG,SS_FLAG
     *     ,SUGAR_FLAG,LIST,CHECK,COOR,SRCH,SEG_FLAG
     *     ,PROG_LIB_PATH,LIBS_PATH,LIBS_NAME,LIBS_EXT,PROG_NAME
     *     ,NOSPGR_INPUT,CELL_INPUT,LIB_OUT,NEW,FSTOP,IERR)
      IF(IERR.NE.0) GO TO 500    
C ---------------------------
  500 CONTINUE
      CALL FINISH
      END
