C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C ******
      SUBROUTINE CREAT_DESCR(MMDOC,LIST,RESTR_FLAG,CUTOFF,DMIN
     *                               ,SYMM_FLAG,H_FLAG,RFLAG,IERR)
C -----------------------------------------------
C -P- CREAT_DESCR -
C -S-
C     'atom_com.fh' in CREAT_DSC and GET_MONOM
C
C     cro_file  = ' ' without to write crd-file
C     crro_file = ' ' without to write rst-file
C     crso_file = ' ' without to write srt-file
C     crvo_file = ' ' without to write vdw-file
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER RESTR_FLAG*1,RFLAG*1,H_FLAG*1
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
c     INTEGER*4 IEND
      INTEGER   NOSPGR_INPUT
      REAL      CELL_INPUT(6)
      character spgr_input*24
      CHARACTER LINE*256
      CHARACTER MON*8,MODE*4,MOD*8,LINK*8,MSG*1,PATH*80,EXT*3
      INTEGER*4 IPR_MISS,IPR_ABS,IPR_DEL,NA_MISS,NA_ABS,NA_DEL
      INTEGER*4 NA_REBLD 
      CHARACTER MON_NEW*8,MON_STD*8,CONN_FLAG*1,CH_FLAG*1,SYMM_FLAG*1
      CHARACTER CH_FLAG_OLD*1,SYMM1*8,SYMM2*8,LIST*1
C -----------------------------------
      IERR       = 0
      IERR_TOT   = 0
      MDOC       = MMDOC
      MD         = -ABS(MDOC)-1
      M          = 99
      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MD   = 999
      ENDIF

      IF(LIST.EQ.'T') THEN
        md = mdoc
        CALL MSGDOC(MDoc,' --- make_rst: CREAT_DESCR --- ')
        CALL PRINT_INFO_TEST(MDoc)
      ENDIF
C --------
c     IEND       = -1
C --------
      IPR_MISS    = 0
      IPR_ABS     = 0
      IPR_DEL     = 0
      NA_MISS     = 0
      NA_ABS      = 0
      NA_ABS_SUM  = 0
      NA_REBLD    = 0
      NA_DEL      = 0
      IFIRST      = 1
      C1_IGLOBAL  = 0
      C2_IGLOBAL  = 0
      CR_HFLAG    = H_FLAG
      CH_FLAG_OLD = '?'
      IG_OLD      = 0
      IR_OLD      = 0
      IAS_OLD     = 0
      IAF_OLD     = 0
      CALL INITCS_2
C ------------------------------------
      MODE = 'TITL'
      CALL WRT_CCRD(MODE,MDOC,N_ANISO,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: write title in WRT_CRD')
        RETURN
      ENDIF
      CALL WRT_STR (MODE,MDOC,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: write title in WRT_STR')     
        RETURN
      ENDIF
      IF(RESTR_FLAG.EQ.'A') THEN     
        CALL WRT_RST (MODE,MDOC,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: write title in WRT_RST')
          RETURN
        ENDIF
      ENDIF
C -----------------
C ---
      IF(LN_N.GT.0) THEN      
        DO I=1,LN_N
          IF(LN_USED(I).NE.'S') LN_USED(I) = 'N'
        ENDDO
      ENDIF
C ---
      IF(N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: N-chains = 0')
        IERR=1
        RETURN
      ENDIF

      IF(IFIRST.EQ.1) THEN
        CALL MSGDOC(MDOC,' --------------------------------')
        CALL MSGDOC(MDOC,' --- title of input coord file ---')
        CALL MSGDOC(MDOC,' ')
        WRITE(LINE,'('' PDB_code:'',A)') CR_CD_PDB
        CALL MSGDOC(MDOC,LINE)
        CALL LENSTR_BL(CR_NAME_PDB,L)
        IF(L.GT.68) L=68
        WRITE(LINE,'('' PDB_name:'',A)') CR_NAME_PDB(1:L)
        CALL MSGDOC(MDOC,LINE)
        CALL LENSTR_BL(CR_DATE_PDB,L)
        IF(L.GT.68) L=68
        WRITE(LINE,'('' PDB_date:'',A)') CR_DATE_PDB(1:L)
        CALL MSGDOC(MDOC,LINE)
        CALL MSGDOC(MDOC,' --------------------------------')
        IFIRST = 0
      ENDIF

      DO IG=1,N_GROUP

        NR       = NRES_CHAIN     (IG)
        IRS_TREE = IRES_START_TREE(IG)
        IRF_TREE = IRES_END_TREE  (IG)
        IRS      = IRES_FIRST     (IG)

        IF(NR.LE.0.OR.IRS.LE.0) THEN
          CALL MSGERR(MDOC,' ERROR: N-residues = 0')
          IERR = 1
          RETURN
        ENDIF

        IF(IRS_TREE.LE.0) THEN
          CALL MSGERR(MDOC,' ERROR: wrong tree structure ...')
          IERR = 1
          RETURN
        ENDIF
        IF(IRF_TREE.LE.0) THEN
          CALL MSGERR(MDOC,' ERROR: wrong tree structure .')
          IERR = 1
          RETURN
        ENDIF

        ITS = ITERM_S_TYPE(IG)
        ITF = ITERM_F_TYPE(IG)
        ITC = ICH_TYPE    (IG)

        IRF = IRS + NR - 1

          IF(LIST.EQ.'T') THEN
            write(line,'('' ====>iGROUP,IS,IF:'',7i4)')
     *      ig,IRES_START_TREE(IG),IRES_END_TREE(IG),ITS,ITF,ITC,NR
            CALL MSGDOC(MDOC,LINE)
          ENDIF 

C -- tree --
        IR = IRS_TREE         
C ----------        
C       DO IRT=IRS,IRF
 800    CONTINUE  
          IR1 = IRES_BACK(IR)
          IF((IR1.LE.0  .AND.IR.NE.IRS_TREE).OR.
     *       (IR1.GT.IRF.AND.IR.NE.IRS_TREE).OR. 
     *       (IR1.LT.IRS.AND.IR.NE.IRS_TREE)    ) THEN
            CALL MSGERR(MDOC,' ERROR: wrong tree structure ....')
            IERR = 1
            RETURN
          ENDIF
C -- tree --
C          IR  = IRT
C          IR1 = IR-1

          IF(LIST.EQ.'T') THEN
            write(line,'('' ====>iG,IR,IRBACK,IRFORW,Icn:'',5i4)')
     *      ig,IR,IRES_BACK(IR),IRES_FORW(IR),ICONN_TYPE(IR)
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          IAS = IRATM_FIRST(IR)
          NA  = NATM_RES   (IR)     

          IF(NA.LE.0.OR.IAS.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: N-atoms = 0')
            IERR=1
            RETURN
          ENDIF

          IAF    = IAS+NA-1
          MON    = RES_NAME  (IR)
          ICONN  = ICONN_TYPE(IR)
C         IRTYPE = IRES_TYPE (IR)

          IF(ITC.EQ.7.AND.IR1.GT.0) THEN
C           sugar
            IF1 = IRES_FORW(IR1) 
C           -- gap --
            IF(IF1.NE.IR) ICONN = 10
          ENDIF

          IF(NR.LE.1) THEN
            ICONN = 1
          ENDIF

          CALL GET_MONOM(MD,LIST,IG,IR,IAS,IAF,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGDOC(MD,' ERROR: in subroutine GET_MONOM')
            IERR_TOT = 1
            IERR     = 0
            GO TO 100
          ENDIF
C ---     
          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC      = MOD_ICHN    (IM)
              MR      = MOD_IRES    (IM)
              MON_NEW = MOD_RNAM_NEW(IM) 
              MON_STD = MOD_RNAM    (IM)
              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                IF(MON_NEW.NE.'.'.AND.MON_NEW.NE.' '.AND.
     *             MON_STD.NE.'.'.AND.MON_NEW.EQ.MON      ) THEN

                  CALL CP_MLIB(MD,MON_STD,IERR)
                  IF(IERR.EQ.2) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 100
                  ENDIF
                  IF(IERR.NE.0) RETURN
                  GO TO 500
                ENDIF
              ENDIF
            ENDDO
          ENDIF

          CALL CP_MLIB(MDoc,MON,IERR)
          IF(IERR.EQ.2) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 100
          ENDIF
          IF(IERR.NE.0) RETURN

 500      CONTINUE
C --- 
          IM = 0
          IF(IR.EQ.IRS_TREE) THEN
            IM = ITS
            IF(IM.GT.1.AND.IM.LE.N_STERM_TYPE) THEN
              MOD = TERM_S_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
              ENDIF
              IF(IERR.NE.0) RETURN
            ENDIF
          ENDIF
          IM = 0
          IF(IR.EQ.IRF_TREE) THEN
            IM = ITF
            IF(IM.GT.1.AND.IM.LE.N_FTERM_TYPE) THEN
              MOD = TERM_F_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
              ENDIF
              IF(IERR.NE.0) RETURN
            ENDIF
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO I=1,MOD_N
              MC  = MOD_ICHN(I)
              MR  = MOD_IRES(I)
              MOD = MOD_ID  (I)
              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                CALL MODIF(MD,MOD,IERR)
                IF(IERR.EQ.2) THEN
                  IERR_TOT = 1
                  IERR     = 0
                ENDIF
                IF(IERR.NE.0) RETURN
              ENDIF
            ENDDO
          ENDIF
C ----
          LINK = ' '
          IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE) THEN
            LINK      = CONN_TYPE(ICONN)
          ENDIF
          CH_FLAG = 'Y'
          IF(IR   .EQ.IRS_TREE                   ) CH_FLAG = 'S'
          IF(IR   .EQ.IRS_TREE.AND.IR.EQ.IRF_TREE) CH_FLAG = 'M'
          IF(LINK .EQ.'gap'                      ) CH_FLAG = 'G'
          IF(MON  .EQ.'HOH'.OR.MON.EQ.'DUM'      ) CH_FLAG = 'M'

          IF(ITC.EQ.7) THEN
C           sugar - correct tree
            CALL CHANGE_TREE_SUGAR(MD,IG,IR,IERR)
          ENDIF
C ---     
C         message flag, N - without massages
C
          MSG = 'Y'

          IF(LIST.EQ.'T') THEN
            LINE = '--- chklst---:'//MON//':'//CH_FLAG
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          CALL CHKLST(MDoc,MON,IPR_MISS,IPR_ABS,IPR_DEL
     *           ,NA_MISS,NA_ABS,NA_DEL,MSG,LIST,IERR)
          IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 100
          ENDIF

          IF(NA.GT.1.OR.C1_NATOM.GT.0) THEN

            IF(LIST.EQ.'T') THEN
              write(*,*) ' def_dist-th',ch_flag            
            ENDIF

            CALL DEF_DIST_TH_PH(MD,LIST,CH_FLAG,IERR)
            IF(IERR.NE.0) THEN
              IERR_TOT = 1
              IERR     = 0
            ENDIF

          ENDIF

          IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE) THEN
            LINK      = CONN_TYPE(ICONN)
            CONN_FLAG = 'Y'
            IREVERS   = 0

            IF(LIST.EQ.'T') THEN
              write(*,*) ' def_dist-th_l',link,conn_flag,ir1,ir            
            ENDIF

            CALL DEF_DIST_TH_PH_LINK(MD,LINK,IREVERS,CONN_FLAG,IERR)
            IF(IERR.NE.0) THEN
              IERR_TOT = 1
              IERR     = 0
            ENDIF

            LINK = CONN_TYPE(ICONN)

            IF(LN_N.GT.0) THEN      
              DO L=1,LN_N
                IF((LINK.EQ.LN_ID(L).AND.IG.EQ.LN_1ICHN(L).AND.
     *                                   IG.EQ.LN_2ICHN(L)     ).AND.
     *             ((IR.EQ.LN_1IRES(L).AND.IR1.EQ.LN_2IRES(L)).OR.
     *              (IR.EQ.LN_2IRES(L).AND.IR1.EQ.LN_1IRES(L)) ).AND.
     *              LN_USED(L).NE.'S'                          ) THEN
                  LN_USED(L) = 'Y'
                ENDIF
              ENDDO
            ENDIF
     
            CONN_FLAG = 'Y'
            LID       = 0
            IF(LIST.EQ.'T') THEN
              write(*,*) ' descr_ln',link,conn_flag,LID
              write(*,*) ' link,-->',ig,ir1,ir,RES_NAME(IR)
            ENDIF

            IF(RESTR_FLAG.EQ.'A'.AND.IR1.GT.0.AND.IR.GT.0) THEN 
              CALL DSCR_LINKS(MD,LIST,LINK,LID,CONN_FLAG
     *                        ,IG,IR1,IG,IR,IERR)
              IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
              ENDIF
            ENDIF

          ENDIF
C ---
C 
          NA = NATM_RES(IR)
C          IF(NA.GT.1.AND.MON.NE.'HOH') THEN
          IF(NA.GT.1) THEN

            IF(LIST.EQ.'T') THEN
              write(*,*) ' wrt_rst' 
            ENDIF

            IF(RESTR_FLAG.EQ.'A') THEN     
              MODE = 'WRIT'
              CALL WRT_RST(MODE,MDOC,IERR)
              IF(IERR.NE.0) RETURN
             
              IF(LIST.EQ.'T') THEN
                write(*,*) ' make_rst' 
              ENDIF

              CALL MAKE_REST(MD,IG,IR,IERR)
              IF(IERR.NE.0) RETURN
            ENDIF

          ENDIF

c          MODE = 'WRIT'
c          CALL WRT_CCRD(MODE,MDOC,N_ANISO,IERR)
c          IF(IERR.NE.0) RETURN

          IF(IG.NE.1.OR.IR.NE.IRS_TREE) THEN

            IF(LIST.EQ.'T') THEN
              write(*,*) ' clc-l-th'           
            ENDIF

            CALL CALC_L_TH_PHI(MD,CH_FLAG,CH_FLAG_OLD,IR
     *                                   ,IRS_TREE,IRF_TREE,IERR)

            IF(LIST.EQ.'T') THEN
              write(*,*) ' reb-l-th'           
            ENDIF
            
            CALL REBUILD(MD,LIST,CH_FLAG,CH_FLAG_OLD
     *              ,IR,IRS_TREE,IRF_TREE,H_FLAG,RFLAG,NA_REBLD,IERR)

            IF(LIST.EQ.'T') THEN
              write(*,*) ' wr'           
            ENDIF

            MODE = 'WRIT'
            CALL WRT_CCRD2(MODE,MDOC,N_ANISO,IERR)
            IF(IERR.NE.0) RETURN
 
            CALL WRT_STR(MODE,MDOC,IERR)
            IF(IERR.NE.0) RETURN

            CALL COPY2_U_ATOMS(MD,IG_OLD,IR_OLD,IAS_OLD,IAF_OLD,IERR)    
            IF(IERR.NE.0) RETURN

          ENDIF

          IF(IERR.NE.0) RETURN

C         CALL COPY_U_ATOMS(MDOC,IG,IR,IAS,IAF,IERR)    
C         IF(IERR.NE.0) RETURN

          IG_OLD      = IG
          IR_OLD      = IR
          IAS_OLD     = IAS
          IAF_OLD     = IAF

          IRES_GLOBAL(IR) = C1_IGLOBAL

          CH_FLAG_OLD = CH_FLAG
          CALL ADD_U_ATOMS(MD,IG,IR,IAS,IAF,NADD,H_FLAG,IERR)    
          CALL COPYC2(MD,IERR)
          CALL COPYL2(MD,IERR)

          C1_IGLOBAL = C1_IGLOBAL + C1_IGATM + NADD
c          NA_ABS     = NA_ABS + NADD
          NA_ABS_SUM = NA_ABS_SUM + NADD
C ---     

 100      CONTINUE
          IERR = 0
C --- tree --
C       ENDDO
        IF(IR.NE.IRF_TREE) THEN
          IR = IRES_FORW(IR)
          IF(IR.LE.0.OR.IR.LT.IRS.OR.IR.GT.IRF) THEN
            CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
            IERR = 1
            RETURN
          ENDIF
          GO TO 800
        ENDIF
C --- tree --
      ENDDO

      CH_FLAG = 'M'

      CALL CALC_L_TH_PHI(MD,CH_FLAG,CH_FLAG_OLD,IR
     *                            ,IRS_TREE,IRF_TREE,IERR)

      CALL REBUILD(MD,LIST,CH_FLAG,CH_FLAG_OLD
     *        ,IR,IRS_TREE,IRF_TREE,H_FLAG,RFLAG,NA_REBLD,IERR)

      MODE = 'WRIT'
      CALL WRT_CCRD2(MODE,MDOC,N_ANISO,IERR)
      IF(IERR.NE.0) RETURN
      CALL WRT_STR (MODE,MDOC,IERR)
      IF(IERR.NE.0) RETURN
      CALL COPY2_U_ATOMS(MD,IG_OLD,IR_OLD,IAS_OLD,IAF_OLD,IERR)    
      IF(IERR.NE.0) RETURN

C      NA_ABS_FINAL  = NA_ABS
      NA_ABS_FINAL  = NA_ABS_SUM
      NA_MISS_FINAL = NA_MISS
      NA_DEL_FINAL  = NA_DEL
C -----------------
C     if rebuilding - finish


C ----------------
C  links !!!
C

      IF(LIST.EQ.'T') THEN
        write(*,*) '----link start >>>>>>',NA_ABS,LN_N
        DO I=1,LN_N
          I1    = LN_1ICHN(I)
          I2    = LN_2ICHN(I)
          LINK  = LN_ID   (I)
          SYMM1 = LN_SYMM1(I)
          SYMM2 = LN_SYMM2(I)
          write(*,*) '--link:',i,link,i1,i2,LN_USED(I),LN_ent(I)
          write(*,*) 
     *  '   ',LN_1ICHN(i),LN_1IRES(i),LN_ATOM1(i),LN_ALT1(I),symm1,
     *  ' - ',LN_2ICHN(i),LN_2IRES(i),LN_ATOM2(i),LN_ALT2(I),symm2
        ENDDO
        write(*,*) '----------------------------'
      ENDIF


      N_LINK_SPEC = 0 
      N_LINK_SYMM = 0 

      IF(LN_N.GT.0) THEN      

        DO I=1,LN_N

          I1    = LN_1ICHN(I)
          I2    = LN_2ICHN(I)
          LINK  = LN_ID   (I)
          SYMM1 = LN_SYMM1(I)
          SYMM2 = LN_SYMM2(I)

          IF(LIST.EQ.'T') THEN
            write(*,*) '>>> link:',i,link,i1,i2,LN_USED(I),LN_ent(I)
     *      ,symm1,symm2
          ENDIF

          IF(LN_USED(I).EQ.'S') THEN
            N_LINK_SPEC =  N_LINK_SPEC + 1
            IF(SYMM1.NE.'.'.AND.SYMM1.NE.'1_555'.OR.
     *         SYMM2.NE.'.'.AND.SYMM2.NE.'1_555') THEN           
              N_LINK_SYMM =  N_LINK_SYMM + 1           
            ENDIF
            GO TO 300
          ENDIF

c          IF(LN_USED(I).EQ.'Y'.OR.LN_ENT(I).EQ.'E'.OR.
c     *                            LN_ENT(I).EQ.'e') GO TO 300

          IF(LN_USED(I).EQ.'Y') GO TO 300

          IF(SYMM1.NE.'.'.AND.SYMM1.NE.'1_555'.OR.
     *       SYMM2.NE.'.'.AND.SYMM2.NE.'1_555') THEN
            N_LINK_SYMM =  N_LINK_SYMM + 1
            GO TO 300
          ENDIF


          CALL LOOK_LINK_LIST(LINK,ILINK)

          IF(ILINK.LE.0) GO TO 300

C          CALL SET_ICONN(LINK,ICONN)
C          IF(ICONN.GE.2.AND.ICONN.LE.N_CONN_TYPE) GO TO 300

c          IF(LINK .EQ.'CIS     ') GO TO 300
c          IF(LINK .EQ.'PCIS    ') GO TO 300
          IF(LINK .EQ.'gap     ') GO TO 300

          IG  = I1 
          IG1 = IG
          NR  = NRES_CHAIN (IG)
          IRS = IRES_FIRST (IG)

          IF(NR.LE.0.OR.IRS.LE.0) THEN
            CALL MSGDOC(MD,' ERROR:  N-residues  = 0.')
            IERR = 0
            GO TO 300
          ENDIF

          ITS = ITERM_S_TYPE(IG)
          ITF = ITERM_F_TYPE(IG)
          ITC = ICH_TYPE    (IG)
          IRF = IRS + NR - 1        

          IRS = IRES_START_TREE(IG)
          IRF = IRES_END_TREE  (IG)

          IR    = LN_1IRES(I)
          IRES1 = IR
          IAS   = IRATM_FIRST(IR)
          NA    = NATM_RES(IR)     

          IF(NA.LE.0.OR.IAS.LE.0) THEN
            CALL MSGDOC(MD,' ERROR: N-atoms= 0')
            IERR_TOT = 1
            IERR     = 0
            GO TO 300
          ENDIF

          IAF   = IAS+NA-1
          MON   = RES_NAME  (IR)
          ICONN = ICONN_TYPE(IR)

          CALL GET_MONOM(MD,LIST,IG,IR,IAS,IAF,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MD,' ERROR: in subroutine GET_MONOM.')
            IERR_TOT = 1
            IERR     = 0
            GO TO 300
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC      = MOD_ICHN    (IM)
              MR      = MOD_IRES    (IM)
              MON_NEW = MOD_RNAM_NEW(IM)
              MON_STD = MOD_RNAM    (IM)

              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                IF(MON_NEW.NE.'.'.AND.MON_NEW.NE.' '.AND.
     *             MON_STD.NE.'.'.AND.MON_NEW.EQ.MON      ) THEN

                  CALL CP_MLIB(MD,MON_STD,IERR)
                  IF(IERR.EQ.2) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 300 
                  ELSE IF(IERR.NE.0) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 200
                  ENDIF
                  GO TO 600
                ENDIF
              ENDIF
            ENDDO
          ENDIF

          CALL CP_MLIB(MD,MON,IERR)
          IF(IERR.EQ.2) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 300 
          ELSE IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 200
          ENDIF

 600      CONTINUE
          IM = 0
          IF(IR.EQ.IRS) THEN
            IM = ITS
            IF(IM.GT.1.AND.IM.LE.N_STERM_TYPE) THEN
              MOD = TERM_S_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 300 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 200
              ENDIF
            ENDIF 
          ENDIF
          IF(IR.EQ.IRF) THEN
            IM = ITF
            IF(IM.GT.1.AND.IM.LE.N_FTERM_TYPE) THEN
              MOD = TERM_F_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 300 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 200
              ENDIF
            ENDIF
          ENDIF
          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC  = MOD_ICHN(IM)
              MR  = MOD_IRES(IM)
              MOD = MOD_ID  (IM)
              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                CALL MODIF(MD,MOD,IERR)
                IF(IERR.EQ.2) THEN
                  IERR_TOT = 1
                  IERR     = 0
                ENDIF
                IF(IERR.NE.0) RETURN
              ENDIF
            ENDDO
          ENDIF

          MSG = 'N'
          CALL CHKLST(MD,MON,IPR_MISS,IPR_ABS,IPR_DEL
     *           ,NA_MISS,NA_ABS,NA_DEL,MSG,LIST,IERR)
          IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 300 
          ENDIF

          C1_IGLOBAL = IRES_GLOBAL(IR) 
          CALL COPYC2(MD,IERR)
C         CALL COPYL2(MD,IERR)

          IG  = I2 
          IG2 = IG
          NR  = NRES_CHAIN (IG)
          IRS = IRES_FIRST (IG)
          IF(NR.LE.0.OR.IRS.LE.0) THEN
            CALL MSGERR(MD,' ERROR : N-residues = 0')
            IERR_TOT = 1
            IERR     = 0
            GO TO 300
          ENDIF

          ITS = ITERM_S_TYPE(IG)
          ITF = ITERM_F_TYPE(IG)
          ITC = ICH_TYPE    (IG)

          IRF = IRS+NR-1        

          IR    = LN_2IRES(I)
          IRES2 = IR
          IAS   = IRATM_FIRST(IR)
          NA    = NATM_RES   (IR)     
          IF(NA.LE.0.OR.IAS.LE.0) THEN
            CALL MSGERR(MD,' ERROR :N-atoms = 0')
            IERR_TOT = 1
            IERR     = 0
            GO TO 300
          ENDIF
          IAF   = IAS+NA-1
          MON   = RES_NAME  (IR)
          ICONN = ICONN_TYPE(IR)

          CALL GET_MONOM(MD,LIST,IG,IR,IAS,IAF,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MD,' ERROR: in subroutine GET_MONOM..')
            IERR_TOT = 1
            IERR     = 0
            GO TO 300
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC      = MOD_ICHN    (IM)
              MR      = MOD_IRES    (IM)
              MON_NEW = MOD_RNAM_NEW(IM)
              MON_STD = MOD_RNAM    (IM)

              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                IF(MON_NEW.NE.'.'.AND.MON_NEW.NE.' '.AND.
     *             MON_STD.NE.'.'.AND.MON_NEW.EQ.MON      ) THEN
                  CALL CP_MLIB(MD,MON_STD,IERR)
                  IF(IERR.EQ.2) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 300 
                  ELSE IF(IERR.NE.0) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 200
                  ENDIF
                  GO TO 700
                ENDIF
              ENDIF
            ENDDO
          ENDIF

          CALL CP_MLIB(MD,MON,IERR)
          IF(IERR.EQ.2) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 300 
          ELSE IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 200
          ENDIF

 700      CONTINUE
          IM = 0
          IF(IR.EQ.IRS) THEN
            IM = ITS
            IF(IM.GT.1.AND.IM.LE.N_STERM_TYPE) THEN
              MOD = TERM_S_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 300 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 200
              ENDIF 
            ELSE
              IM = 0
            ENDIF 
          ENDIF
          IF(IR.EQ.IRF) THEN
            IM = ITF
            IF(IM.GT.1.AND.IM.LE.N_FTERM_TYPE) THEN
              MOD = TERM_F_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 300 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 200
              ENDIF 
            ENDIF
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC  = MOD_ICHN(IM)
              MR  = MOD_IRES(IM)
              MOD = MOD_ID  (IM)
              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                CALL MODIF(MD,MOD,IERR)
                IF(IERR.EQ.2) THEN
                  IERR_TOT = 1
                  IERR     = 0
                ENDIF
                IF(IERR.NE.0) RETURN
              ENDIF
            ENDDO
          ENDIF

C ---     
          MSG = 'N'
          CALL CHKLST(MD,MON,IPR_MISS,IPR_ABS,IPR_DEL
     *           ,NA_MISS,NA_ABS,NA_DEL,MSG,LIST,IERR)
          IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 300 
          ENDIF

          C1_IGLOBAL = IRES_GLOBAL(IR) 

          LINK      = LN_ID(I)
          LID       = 0
          CONN_FLAG = 'N'
          
C 
          IF(RESTR_FLAG.EQ.'A'.AND.IRES1.GT.0.AND.IRES2.GT.0) THEN 

            CALL DSCR_LINKS(MD,LIST,LINK,LID,CONN_FLAG
     *                      ,IG1,IRES1,IG2,IRES2,IERR)
            IF(IERR.NE.0) THEN
              IERR_TOT = 1
              IERR     = 0
            ENDIF
          ENDIF
C
 300      CONTINUE

        ENDDO
      ENDIF
C ------------------------------------------------------------
  200 CONTINUE
C ----
      IF(LIST.EQ.'T') THEN
        write(*,*) '>> wrt mode=stop'
      ENDIF

      MODE='STOP'
      CALL WRT_CCRD(MODE,MDOC,N_ANISO,IERR)
      IF(IERR.NE.0) RETURN
      CALL WRT_STR (MODE,MDOC,IERR)
      IF(IERR.NE.0) RETURN
C      CALL WRT_RST (MODE,MDOC,IERR)
C      IF(IERR.NE.0) RETURN
C ---
      PATH = ' '
      EXT  = 'crd'
      NOSPGR_INPUT = 0
      spgr_input = ' '
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO

      IF(LIST.EQ.'T') THEN
        write(*,*) '>> rd atom'
      ENDIF

      IERR = 1
      CALL READ_ATOMS(M,PATH,CRRO_FILE,EXT    
     *               ,NOSPGR_INPUT,spgr_input,CELL_INPUT,IERR)
      IF(IERR.GE.7) THEN
        IERR = 0
      ELSE IF(IERR.NE.0) THEN
        IERR_TOT = 1
        IERR     = 0
        GO TO 400
      ENDIF

      IF(LIST.EQ.'T') THEN
        write(*,*) '>> rd str'
        EXT  = 'crd'
        PATH = ' '
        LINE = 'new_test5'
        CALL WRITE_ATOMS(MDOC,PATH,LINE,EXT,IERR)
      ENDIF

      PATH = ' '
      EXT  = 'str'
      CALL READ_STR(M,PATH,CRSO_FILE,EXT,IERR)    
      IF(IERR.NE.0) THEN
        IERR_TOT = 1
        IERR     = 0
        GO TO 400
      ENDIF

      IF((NA_REBLD.GT.0.OR.NA_MISS_FINAL.GT.0).AND.
     *   (H_FLAG.EQ.'A'.OR.RFLAG.EQ.'Y')           ) THEN

        IF(LIST.EQ.'T') THEN
          write(*,*) '>> CHECK_REBUILD'
        ENDIF

        NA_REBLD_NEW = 0
        NA_MISS  = 0
        CALL CHECK_REBUILD(MDOC,LIST,H_FLAG,RFLAG
     *                       ,NA_MISS,NA_REBLD_NEW,IERR)
        IF(NA_REBLD_NEW.GT.0) THEN
          NA_REBLD      = NA_REBLD      + NA_MISS
          NA_MISS_FINAL = NA_MISS_FINAL - NA_MISS
          IF(NA_MISS_FINAL.LT.0) NA_MISS_FINAL = 0
          PATH = ' '
          EXT  = 'crd'
          IERR = 0

          CALL WRITE_ATOMS(M,PATH,CRRO_FILE,EXT,IERR)    
          IF(IERR.NE.0) RETURN      
        ENDIF

        PATH = ' '
        EXT  = 'str'
        CALL WRITE_STR(M,PATH,CRSO_FILE,EXT,IERR)
        IF(IERR.NE.0) THEN
          IERR_TOT = 1
          IERR     = 0
          GO TO 400
        ENDIF

      ENDIF
C ----
C ---- special and symm links
      IF(RESTR_FLAG.EQ.'A') THEN     
C ----
C ----  special links
        IF(N_LINK_SPEC.GT.0.AND.LN_N.GT.0) THEN

           IF(LIST.EQ.'T') THEN
              write(*,*) '>> spec link:',N_LINK_SPEC,LN_N
              DO I=1,LN_N
                 I1    = LN_1ICHN(I)
                 I2    = LN_2ICHN(I)
                 LINK  = LN_ID   (I)
                 SYMM1 = LN_SYMM1(I)
                 SYMM2 = LN_SYMM2(I)
                 write(*,*) '--link:',i,link,i1,i2,LN_USED(I),LN_ent(I)
                 write(*,*) 
     *  '   ',LN_1ICHN(i),LN_1IRES(i),LN_ATOM1(i),LN_ALT1(I),symm1,
     *  ' - ',LN_2ICHN(i),LN_2IRES(i),LN_ATOM2(i),LN_ALT2(I),symm2
              ENDDO
              write(*,*) '----------------------------'
              
           ENDIF


        DO I=1,LN_N

          I1    = LN_1ICHN(I)
          I2    = LN_2ICHN(I)
          LINK  = LN_ID   (I)
          SYMM1 = LN_SYMM1(I)
          SYMM2 = LN_SYMM2(I)

          IF(LN_USED(I).NE.'S') GO TO 310

          IF(LIST.EQ.'T') THEN
            write(*,*) '>> link:',link,i1,i2,LN_USED(I),LN_ent(I)
     *      ,symm1,symm2
          ENDIF

          IF(SYMM1.NE.'.'.AND.SYMM1.NE.'1_555'.OR.
     *       SYMM2.NE.'.'.AND.SYMM2.NE.'1_555') THEN           
            GO TO 310
          ENDIF


          CALL LOOK_LINK_LIST(LINK,ILINK)

          IF(ILINK.LE.0) GO TO 310

C          CALL SET_ICONN(LINK,ICONN)
C          IF(ICONN.GE.2.AND.ICONN.LE.N_CONN_TYPE) GO TO 310

c          IF(LINK .EQ.'CIS     ') GO TO 310
c          IF(LINK .EQ.'PCIS    ') GO TO 310
          IF(LINK .EQ.'gap     ') GO TO 310

          IG  = I1 
          IG1 = IG
          NR  = NRES_CHAIN (IG)
          IRS = IRES_FIRST (IG)

          IF(NR.LE.0.OR.IRS.LE.0) THEN
            CALL MSGDOC(MD,' ERROR:  N-residues  = 0.')
            IERR = 0
            GO TO 310
          ENDIF

          ITS = ITERM_S_TYPE(IG)
          ITF = ITERM_F_TYPE(IG)
          ITC = ICH_TYPE    (IG)
          IRF = IRS + NR - 1        

          IRS = IRES_START_TREE(IG)
          IRF = IRES_END_TREE  (IG)

          IR    = LN_1IRES(I)
          IRES1 = IR

          IAS   = IRATM_FIRST(IR)
          NA    = NATM_RES(IR)     

          IF(NA.LE.0.OR.IAS.LE.0) THEN
            CALL MSGDOC(MD,' ERROR: N-atoms= 0')
            IERR_TOT = 1
            IERR     = 0
            GO TO 310
          ENDIF

          IAF   = IAS+NA-1
          MON   = RES_NAME  (IR)
          ICONN = ICONN_TYPE(IR)

          CALL GET_MONOM(MD,LIST,IG,IR,IAS,IAF,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MD,' ERROR: in subroutine GET_MONOM.')
            IERR_TOT = 1
            IERR     = 0
            GO TO 310
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC      = MOD_ICHN    (IM)
              MR      = MOD_IRES    (IM)
              MON_NEW = MOD_RNAM_NEW(IM)
              MON_STD = MOD_RNAM    (IM)

              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                IF(MON_NEW.NE.'.'.AND.MON_NEW.NE.' '.AND.
     *             MON_STD.NE.'.'.AND.MON_NEW.EQ.MON      ) THEN

                  CALL CP_MLIB(MD,MON_STD,IERR)
                  IF(IERR.EQ.2) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 310 
                  ELSE IF(IERR.NE.0) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 210
                  ENDIF
                  GO TO 610
                ENDIF
              ENDIF
            ENDDO
          ENDIF

          CALL CP_MLIB(MD,MON,IERR)
          IF(IERR.EQ.2) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 310 
          ELSE IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 210
          ENDIF

 610      CONTINUE
          IM = 0
          IF(IR.EQ.IRS) THEN
            IM = ITS
            IF(IM.GT.1.AND.IM.LE.N_STERM_TYPE) THEN
              MOD = TERM_S_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 310 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 210
              ENDIF
            ENDIF 
          ENDIF
          IF(IR.EQ.IRF) THEN
            IM = ITF
            IF(IM.GT.1.AND.IM.LE.N_FTERM_TYPE) THEN
              MOD = TERM_F_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 310 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 210
              ENDIF
            ENDIF
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC  = MOD_ICHN(IM)
              MR  = MOD_IRES(IM)
              MOD = MOD_ID  (IM)
              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                CALL MODIF(MD,MOD,IERR)
                IF(IERR.EQ.2) THEN
                  IERR_TOT = 1
                  IERR     = 0
                ENDIF
                IF(IERR.NE.0) RETURN
              ENDIF
            ENDDO
          ENDIF

          IF(LN_USED(I).EQ.'S') THEN
            MOD = LLL_MOD1(ILINK)
            CALL MODIF(MD,MOD,IERR)
             IF(IERR.EQ.2) THEN
               IERR_TOT = 1
               IERR     = 0
             ENDIF
             IF(IERR.NE.0) RETURN
          ENDIF 
C ---     
          MSG = 'N'
          CALL CHKLST(MD,MON,IPR_MISS,IPR_ABS,IPR_DEL
     *           ,NA_MISS,NA_ABS,NA_DEL,MSG,LIST,IERR)
          IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 310 
          ENDIF

          C1_IGLOBAL = IRES_GLOBAL(IR) 
          CALL COPYC2(MD,IERR)
C         CALL COPYL2(MD,IERR)

          IG  = I2 
          IG2 = IG
          NR  = NRES_CHAIN (IG)
          IRS = IRES_FIRST (IG)
          IF(NR.LE.0.OR.IRS.LE.0) THEN
            CALL MSGERR(MD,' ERROR : N-residues = 0')
            IERR_TOT = 1
            IERR     = 0
            GO TO 310
          ENDIF

          ITS = ITERM_S_TYPE(IG)
          ITF = ITERM_F_TYPE(IG)
          ITC = ICH_TYPE    (IG)

          IRF = IRS+NR-1        

          IR    = LN_2IRES(I)
          IRES2 = IR

          IAS   = IRATM_FIRST(IR)
          NA    = NATM_RES   (IR)     
          IF(NA.LE.0.OR.IAS.LE.0) THEN
            CALL MSGERR(MD,' ERROR :N-atoms = 0')
            IERR_TOT = 1
            IERR     = 0
            GO TO 310
          ENDIF
          IAF   = IAS+NA-1
          MON   = RES_NAME  (IR)
          ICONN = ICONN_TYPE(IR)

          CALL GET_MONOM(MD,LIST,IG,IR,IAS,IAF,IERR)
          IF(IERR.NE.0) THEN
            CALL MSGERR(MD,' ERROR: in subroutine GET_MONOM..')
            IERR_TOT = 1
            IERR     = 0
            GO TO 310
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC      = MOD_ICHN    (IM)
              MR      = MOD_IRES    (IM)
              MON_NEW = MOD_RNAM_NEW(IM)
              MON_STD = MOD_RNAM    (IM)

              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                IF(MON_NEW.NE.'.'.AND.MON_NEW.NE.' '.AND.
     *             MON_STD.NE.'.'.AND.MON_NEW.EQ.MON      ) THEN
                  CALL CP_MLIB(MD,MON_STD,IERR)
                  IF(IERR.EQ.2) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 310 
                  ELSE IF(IERR.NE.0) THEN
                    IERR_TOT = 1
                    IERR     = 0
                    GO TO 210
                  ENDIF
                  GO TO 710
                ENDIF
              ENDIF
            ENDDO
          ENDIF

          CALL CP_MLIB(MD,MON,IERR)
          IF(IERR.EQ.2) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 310 
          ELSE IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 210
          ENDIF

 710      CONTINUE
          IM = 0
          IF(IR.EQ.IRS) THEN
            IM = ITS
            IF(IM.GT.1.AND.IM.LE.N_STERM_TYPE) THEN
              MOD = TERM_S_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 310 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 210
              ENDIF 
            ELSE
              IM = 0
            ENDIF 
          ENDIF
          IF(IR.EQ.IRF) THEN
            IM = ITF
            IF(IM.GT.1.AND.IM.LE.N_FTERM_TYPE) THEN
              MOD = TERM_F_TYPE(IM)
              CALL MODIF(MD,MOD,IERR)
              IF(IERR.EQ.2) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 310 
              ELSE IF(IERR.NE.0) THEN
                IERR_TOT = 1
                IERR     = 0
                GO TO 210
              ENDIF 
            ENDIF
          ENDIF

          IF(MOD_N.GT.0) THEN      
            DO IM=1,MOD_N
              MC  = MOD_ICHN(IM)
              MR  = MOD_IRES(IM)
              MOD = MOD_ID  (IM)
              IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                CALL MODIF(MD,MOD,IERR)
                IF(IERR.EQ.2) THEN
                  IERR_TOT = 1
                  IERR     = 0
                ENDIF
                IF(IERR.NE.0) RETURN
              ENDIF
            ENDDO
          ENDIF

          IF(LN_USED(I).EQ.'S') THEN
            MOD = LLL_MOD2(ILINK)
            CALL MODIF(MD,MOD,IERR)
             IF(IERR.EQ.2) THEN
               IERR_TOT = 1
               IERR     = 0
             ENDIF
             IF(IERR.NE.0) RETURN
          ENDIF 
C ---     
          MSG = 'N'
          CALL CHKLST(MD,MON,IPR_MISS,IPR_ABS,IPR_DEL
     *           ,NA_MISS,NA_ABS,NA_DEL,MSG,LIST,IERR)
          IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 310 
          ENDIF

          C1_IGLOBAL = IRES_GLOBAL(IR) 

          LINK      = LN_ID(I)
          LID       = I
          CONN_FLAG = 'N'
C 
          IF(IRES1.GT.0.AND.IRES2.GT.0) THEN 

            CALL DSCR_LINKS(MD,LIST,LINK,LID,CONN_FLAG
     *                      ,IG1,IRES1,IG2,IRES2,IERR)
            IF(IERR.NE.0) THEN
              IERR_TOT = 1
              IERR     = 0
            ENDIF

          ENDIF
C
 310      CONTINUE

        ENDDO

 210    CONTINUE

        ENDIF
C ----
C ----  symm links

          IF(LIST.EQ.'T') THEN
            write(*,*) '>> symm link:',SYMM_FLAG,N_LINK_SYMM
          ENDIF


        IF(SYMM_FLAG.NE.'N'.AND.N_LINK_SYMM.GT.0) THEN


          CALL DSCR_LINKS_SYMM(MDOC,LIST,RESTR_FLAG,SYMM_FLAG,IERR)
          IF(LIST.EQ.'T') THEN
            write(*,*) '>> symm link_end:',ierr,RS_NBNDS
          ENDIF
          IF(IERR.NE.0) THEN
            IERR_TOT = 1
            IERR     = 0
            GO TO 400
          ENDIF
          IF(RS_NBNDS.GT.0) THEN
            PATH = ' '
            EXT  = 'crd'
            CALL WRITE_ATOMS(M,PATH,CRRO_FILE,EXT,IERR)    
            IF(IERR.NE.0) RETURN      
          ENDIF
        ENDIF
C ---
        MODE = 'STOP'
        CALL WRT_RST (MODE,MDOC,IERR)
        IF(IERR.NE.0) RETURN      
      ENDIF
C --
C --

      IF(CUTOFF.GT.0.0.AND.RESTR_FLAG.EQ.'A') THEN     
        CALL MSGDOC(MDOC,' I am creating VDW restraints')
        CALL CREAT_VDW_REST(MDOC,CRVO_FILE,CUTOFF,DMIN,IERR)
        IF(IERR.NE.0) THEN
          IERR_TOT = 1
          IERR     = 0
        ENDIF
      ENDIF

 400  CONTINUE
C ----
      NA_MISS = NA_MISS - NA_REBLD
      WRITE(LINE,'('' Number of chains                  :'',I8)')
     * N_GROUP
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Total number of monomers          :'',I8)')
     * N_RESIDUE
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of atoms                   :'',I8)')
     * N_ATOM
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of missing atoms           :'',I8)') 
     * NA_MISS_FINAL
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of rebuilt atoms           :'',I8)') 
     * NA_REBLD
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of unknown atoms           :'',I8)') 
     * NA_ABS_FINAL
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of deleted atoms           :'',I8)') 
     * NA_DEL_FINAL
      CALL MSGDOC(MDOC,LINE)
C ----
      IF(RESTR_FLAG.EQ.'A') THEN     

      CALL MSGDOC(MDOC,' ')
      WRITE(LINE,'('' Number of bonds restraints    :'',I8)') 
     * RS_NBOND
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of angles restraints   :'',I8)') 
     * RS_NANGL
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of torsions restraints :'',I8)') 
     * RS_NTORS
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of chiralities         :'',I8)') 
     * RS_NCHIR
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of planar groups       :'',I8)') 
     * RS_NPLAN
      CALL MSGDOC(MDOC,LINE)
      IF(RSV_NVDW.GT.0) THEN
        WRITE(LINE,'('' Number of VDW_contacts        :'',I8)') 
     *   RSV_NVDW
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      IF(RS_NBNDS.GT.0) THEN
        WRITE(LINE,'('' Number of symm_links          :'',I8)') 
     *   RS_NBNDS
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      IF(RSV_NHB.GT.0) THEN
        WRITE(LINE,'('' Number of H_bonds             :'',I8)') 
     *  RSV_NHB
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      ENDIF
     
      IF(IERR.EQ.0) IERR = IERR_TOT
      IF(IERR.EQ.0.AND.NA_ABS_FINAL.GT.0) IERR = 1
      RETURN
      END

      SUBROUTINE CHANGE_TREE_SUGAR(MDOC,IG,IR,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
C     INTEGER*4 IEND
      CHARACTER LINK*8,TREE*1,ATOM*4,PNUM*12
C     CHARACTER LINE*256
C -----------------------------------
      IERR   = 0

C     back connection for start atom      

      ISTART = 0
      IRB    = IRES_BACK(IR)
      ICONN  = ICONN_TYPE(IR)
      LINK   = ' '

      IF(IRB.GT.0) THEN
        IFB = IRES_FORW(IRB) 
C         -- gap --
        IF(IFB.NE.IR) ICONN = 10
        IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE) THEN
          LINK = CONN_TYPE(ICONN)
        ENDIF
        ATOM = ' '
        IF(LN_N.GT.0) THEN      
          DO L=1,LN_N
            IF(LN_USED(L).NE.'S') THEN
            IF((LINK.EQ.LN_ID(L).AND.IG.EQ.LN_1ICHN(L).AND.
     *                               IG.EQ.LN_2ICHN(L)     ).AND.
     *         ((IR.EQ.LN_1IRES(L).AND.IRB.EQ.LN_2IRES(L)).OR.
     *          (IR.EQ.LN_2IRES(L).AND.IRB.EQ.LN_1IRES(L)))) THEN
   
              IF(IR.EQ.LN_1IRES(L)) THEN 
                ATOM = LN_ATOM1(L)(1:4)
              ELSE IF(IR.EQ.LN_2IRES(L)) THEN 
                ATOM = LN_ATOM2(L)(1:4)
              ENDIF
              GO TO 100
            ENDIF
            ENDIF
          ENDDO
        ENDIF
 100    CONTINUE
        DO LA=1,L1A_NATOM
          IF(ATOM.EQ.L1A_ANAME(LA)) THEN
            ISTART = LA
            GO TO 200
          ENDIF
        ENDDO
 200    CONTINUE
      ENDIF

C     forward connection for end atom      

      IFINISH = 0
      IRF     = IRES_FORW(IR)
      IF(IRF.GT.0) THEN
        ICONN  = ICONN_TYPE(IRF)
        LINK   = ' '
        IRFB   = IRES_BACK(IRF) 
C         -- gap --
        IF(IRFB.NE.IR) ICONN = 10
        IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE) THEN
          LINK = CONN_TYPE(ICONN)
        ENDIF
        ATOM = ' '
        IF(LN_N.GT.0) THEN      
          DO L=1,LN_N
            IF(LN_USED(L).NE.'S') THEN
            IF((LINK.EQ.LN_ID(L)  .AND.IG.EQ.LN_1ICHN(L).AND.
     *                                 IG.EQ.LN_2ICHN(L)     ).AND.
     *         ((IR.EQ.LN_1IRES(L).AND.IRF.EQ.LN_2IRES(L)).OR.
     *          (IR.EQ.LN_2IRES(L).AND.IRF.EQ.LN_1IRES(L)))) THEN
   
              IF(IR.EQ.LN_1IRES(L)) THEN 
                ATOM = LN_ATOM1(L)(1:4)
              ELSE IF(IR.EQ.LN_2IRES(L)) THEN 
                ATOM = LN_ATOM2(L)(1:4)
              ENDIF
              GO TO 300
            ENDIF
            ENDIF
          ENDDO
        ENDIF
 300    CONTINUE
        DO LA=1,L1A_NATOM
          IF(ATOM.EQ.L1A_ANAME(LA)) THEN
            IFINISH = LA
            GO TO 400
          ENDIF
        ENDDO
 400    CONTINUE
      ENDIF
C ---
      TREE = 'Y'
      PNUM = ' '
      CALL SET_NUM_MOD(MDOC,L1L_MNAME,PNUM,IERR)
      IF(IERR.NE.0) THEN
        TREE = 'N' 
        IERR = 0
      ENDIF
      IF(TREE.EQ.'Y'.AND.
     *   ((ISTART .NE.0.AND.ISTART .NE.L1A_ISTART ).OR.
     *    (IFINISH.NE.0.AND.IFINISH.NE.L1A_IFINISH)    )) THEN
        IF(ISTART.EQ.L1A_IFINISH.AND.ISTART.GT.0) THEN
          ITYPE = 0
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 500
          ENDIF
        ENDIF
        IF(ISTART.NE.L1A_ISTART.AND.ISTART.GT.0) THEN
          ITYPE = 1
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 500
          ENDIF
        ENDIF
        IF(IFINISH.NE.L1A_IFINISH.AND.IFINISH.GT.0) THEN
          ITYPE = 2
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 500
          ENDIF
        ENDIF
      ENDIF
 500  CONTINUE

      RETURN
      END

      SUBROUTINE GET_MONOM(MDOC,LIST,IG,IR,IAS,IAF,IERR)    
C -----------------------------------------------
C -P- GET_MONOM - reads current monomer.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IR,IAS,IAF,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------------------------------
      CHARACTER LINE*256,LIST*1
C -----------------------------------
      PI       = 4.0*ATAN(1.0)
      CONST    = 8.0*PI*PI
      C1_NATOM = 0

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '--GET_MONOM' 
        DO IA=IAS,IAF
          WRITE(*,*) '->',IA,';',ATM_NAME(IA),';',ATM_TYPE(IA),';'
     *    ,ID_ALT(IA),';'
        ENDDO   
      ENDIF 

      DO IA=IAS,IAF

        IF(ATM_TYPE(IA).EQ.'U'.OR.ATM_TYPE(IA).EQ.'D'.OR.
     *     ATM_TYPE(IA).EQ.'M'.OR.ATM_TYPE(IA).EQ.'N') THEN
          GO TO 200
        ENDIF

        IF(C1_NATOM.GT.0) THEN
          DO   I=1,C1_NATOM
            IF(ATM_NAME(IA).EQ.C1_ANAME(I)) THEN
C              IATM=I
              C1_NALT(I) = C1_NALT(I)+1
              C1_IALT(I) = 0
              IAT_ALT    = I
              NN_ALT     = 0
              IF(ID_ALT(IA).EQ.C1_ALT(I)) THEN
                WRITE(LINE,'(3A,A,A)')
     *' WARNING : ',C1_ANAME(I),' double atom"s occurrence:',
     *RES_NUM_PDB(IR),', Now alt_id = "?"'
                CALL MSGDOC(MDOC,LINE)
                ID_ALT(IA) = '?'
              ENDIF
              GO TO 100
            ENDIF
          ENDDO
        ENDIF
        IAT_ALT = 0
        NN_ALT  = 1             
  100   CONTINUE
        IF(C1_NATOM.GE.MX1ATOM) THEN
          WRITE(LINE
     * ,'('' ERROR: number of atoms of monomer '',A,'' >'',I6)') 
     *    RES_NUM_PDB(IR),MX1ATOM
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MX1ATOM in "lib_com.fh"')
          IERR=2
          RETURN
        ENDIF
        C1_NATOM         = C1_NATOM + 1
        IATM             = C1_NATOM

        C1_NALT (IATM)   = NN_ALT
        C1_IALT (IATM)   = IAT_ALT
        C1_ANAME(IATM)   = ATM_NAME(IA)
        C1_ANAME_INP(IATM) = ATM_NAME_INP(IA)
        C1_ICH           = IG  

        C1_IRES          = IRES_SERIAL(IR) 

C       C1_IGRES= CR_IGRES

        DO   I=1,3
          C1_XYZ(I,IATM) = XYZ_CRD(I,IA)
C         C1_CSD(I,IATM) = 0.0
        ENDDO
        DO   I=1,6
          C1_ANIS(I,IATM) = 0.0
C         C1_ASD (I,IATM) = 0.0
        ENDDO

        S1_ICRD(IATM)   = IA

        S1_CHAR(IATM)   = 0.0 
        S1_CHEM(IATM)   = ATM_CHEM(IA)

C       C1_BSD   (IATM) = 0.0

        C1_OCC   (IATM) = OCCUP   (IA)
C       C1_OSD   (IATM) = 0.0
        C1_USER  (IATM) = MULT_FACTOR(IA)+0.001

        INSF            = ID_SF   (IA)
        C1_ASYMB (IATM) = CS_ATYPE(INSF)
        C1_SF_ID (IATM) = INSF


        IF(ATM_TYPE(IA).EQ.'R') THEN
          C1_ATYPE (IATM) = 'm'
        ELSE
          C1_ATYPE (IATM) = 'M'
        ENDIF

        C1_ALT   (IATM) = ID_ALT  (IA)
        C1_SEG   (IATM) = SEG_ID  (IA)
        C1_CORR  (IATM) = ID_CORR (IA)

c        write(*,*) '===',iatm,C1_SEG(IATM),SEG_ID(IA)

        C1_BTYPE (IATM) = 'I'
        IF(B_FLAG(IA).GT.0) THEN
          C1_BTYPE(IATM) = 'A'
          DO   I=1,6
            C1_ANIS(I,IATM) = U_ANISO(I,IA)
          ENDDO
          CALL CALC_B_EQUIV(U_ANISO(1,IA),BISO)
          C1_BISO  (IATM) = BISO
        ELSE
          C1_ANIS(1,IATM) = U_ANISO(1,IA)
          C1_BISO(IATM)   = U_ANISO(1,IA)*CONST
        ENDIF

        IF(LIST.EQ.'T') THEN
          WRITE(*,*) '=>',iatm,IA,';',C1_ANAME(IATM),';',C1_IALT (IATM)
     *    ,';',C1_NALT (IATM),';',C1_ALT(IATM)
        ENDIF 
c       write(*,*) '>>',iatm,C1_BISO(IATM),C1_XYZ(1,IATM)

        C1_RNAME        = RES_NAME(IR)
        C1_CODE1        = '.'

C      TERM_S_TYPE( 1) = '.       '
C      TERM_S_TYPE( 2) = 'NH3     '
C      TERM_S_TYPE( 3) = 'FOR-N   '
C      TERM_S_TYPE( 4) = 'p5*END  '
C      TERM_S_TYPE( 5) = '5*END   '
C      TERM_S_TYPE( 6) = 'NH3-COO '

        ITS             = ITERM_S_TYPE(IG)
        IF(ITS.GT.1.AND.ITS.LE.N_STERM_TYPE) THEN
          C1_S_TERM     = TERM_S_TYPE(ITS)
        ELSE
          C1_S_TERM = '.'
        ENDIF

        C1_PNUM         = RES_NUM_PDB(IR)
        IRT             = IRES_TYPE  (IR)
        C1_RTYPE        = RES_TYPE   (IRT)
        C1_FSC   (IATM) = 'N'
        C1_FSA   (IATM) = 'N'
        C1_FUS   (IATM) = 'N'

 200    CONTINUE

      ENDDO

      RETURN
      END

      SUBROUTINE ADD_U_ATOMS(MDOC,IG,IR,IAS,IAF,NADD,HFLAG,IERR)    
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C -----------------------------------------------------------
C     CHARACTER LINE*256
      CHARACTER HFLAG*1
C -----------------------------------
      IERR = 0 
      NADD = 0
C ---
      IF(C1_NATOM.GT.0) THEN
        DO L=1,C1_NATOM
          IF((C1_ATYPE(L).EQ.'D'.AND.S1_ILIB(L).NE.0).OR.
     *        C1_ATYPE(L).EQ.'U') THEN

c           IF(C1_ASYMB(L)(1:2).NE.'H '.OR.HFLAG.NE.'N') THEN
            IF(C1_ASYMB(L)(1:2).NE.'H ') THEN
              NADD = NADD + 1
            ENDIF

          ENDIF
        ENDDO
      ENDIF
C ---    
      DO IA=IAS,IAF
        IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D'.AND.
     *                             ATM_TYPE(IA).NE.'N') GO TO 200

c         WRITE(*,*) '--==',ID_SF(IA),';',ATM_CHEM(IA),';',
c     *   ';',CS_ELEMENT(ID_SF(IA))

        IF(ATM_CHEM(IA)(1:2).NE.'H ') THEN
          NADD = NADD + 1
        ENDIF
 200    CONTINUE
      ENDDO
C --
      RETURN
      END

      SUBROUTINE COPY_U_ATOMS(MDOC,IG,IR,IAS,IAF,IERR)    
C -----------------------------------------------
C -P- GET_MONOM - reads current monomer.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IR,IAS,IAF,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C -----------------------------------------------------------
C     CHARACTER LINE*256
C -----------------------------------
      IERR  = 0 
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
      IUN   = CRO_IUN 
      NA    = 0
C ---
      DO IA=IAS,IAF

        IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D'.AND.
     *                             ATM_TYPE(IA).NE.'N') GO TO 200

        C1_IGATM  = C1_IGATM + 1
        CR_IATOLD = C1_IGLOBAL + C1_IGATM 

        IRES      = I_RESID    (IA)
        CR_RNAME  = RES_NAME   (IRES)
        CR_IRES   = IRES_SERIAL(IRES)
        IG        = I_CHAIN    (IRES) 
        CR_IGROUP = IG 
        IB        = B_FLAG     (IA)
        CR_PNUM   = RES_NUM_PDB(IRES)
        CR_GROUP  = GROUP_ID   (IG)

        CR_BTYPE  = '.'
        IF(N_ANISO.GT.0) CR_BTYPE  = 'A' 

        IF(IB.EQ.0) THEN
          CR_B_FLAG  = 0
          DO IAN=1,6
            CR_ANIS(IAN) = 0.0
          ENDDO
          CR_ANIS(1) = U_ANISO(1,IA)
          CR_BISO    = U_ANISO(1,IA)*CONST
        ELSE
          CR_B_FLAG = 1
          DO IAN=1,6
            CR_ANIS(IAN) = U_ANISO(IAN,IA)
          ENDDO
          CALL CALC_B_EQUIV(U_ANISO(1,IA),BISO)
          CR_BISO = BISO
        ENDIF   

        CR_ANAME  = ATM_NAME (IA)     
        CR_ANAME_INP = ATM_NAME_INP(IA)     
        INSF      = ID_SF    (IA)
        CR_ASYMB  = CS_ELEMENT(INSF)
        IF(CR_ASYMB.EQ.'?') THEN
          CR_ASYMB  = CS_ATYPE (INSF)
        ENDIF   
     
        ST_CHEM   = ATM_CHEM (IA)
        CR_SF_ID  = INSF
        CR_ATYPE  = ATM_TYPE (IA)    
        CR_ALT    = ID_ALT   (IA)    
        CR_SEG    = SEG_ID   (IA)    
        CR_CORR   = ID_CORR  (IA)    
        CR_XYZ(1) = XYZ_CRD  (1,IA) 
        CR_XYZ(2) = XYZ_CRD  (2,IA)  
        CR_XYZ(3) = XYZ_CRD  (3,IA)   

        CR_OCC    = OCCUP    (IA)
        CR_MULT_FACTOR = MULT_FACTOR(IA)
        NA        = NA + 1

        IEND      = 0
        MODE_WRT  = 0

        CALL WRCRD_CIF(MDOC,IUN,MODE_WRT,IEND,IERR)

 200    CONTINUE

      ENDDO
      RETURN
      END

      SUBROUTINE COPY2_U_ATOMS(MDOC,IG,IR,IAS,IAF,IERR)    
C -----------------------------------------------
C -P- GET_MONOM - reads current monomer.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IR,IAS,IAF,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C -----------------------------------------------------------
C     CHARACTER LINE*256
C -----------------------------------
      IERR  = 0 
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
      IUN   = CRO_IUN 
      NA    = 0
C ---
      DO IA=IAS,IAF

C??? ia
        IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D'.AND.
     *                             ATM_TYPE(IA).NE.'N') GO TO 200

c        C1_IGATM  = C1_IGATM + 1
c        CR_IATOLD = C1_IGLOBAL + C1_IGATM 

        NA        = NA + 1

        CR_IATOLD = C2_IGLOBAL + C2_IGATM + NA 

        IRES      = I_RESID    (IA)
        CR_RNAME  = RES_NAME   (IRES)
        CR_IRES   = IRES_SERIAL(IRES)
        IG        = I_CHAIN    (IRES) 
        CR_IGROUP = IG 
        IB        = B_FLAG     (IA)
        CR_PNUM   = RES_NUM_PDB(IRES)
        CR_GROUP  = GROUP_ID   (IG)

        CR_BTYPE  = '.'
        IF(N_ANISO.GT.0) CR_BTYPE  = 'A' 

        IF(IB.EQ.0) THEN
          CR_B_FLAG = 0
          DO IAN=1,6
            CR_ANIS(IAN) = 0.0
          ENDDO
          CR_ANIS(1) = U_ANISO(1,IA)
          CR_BISO    = U_ANISO(1,IA)*CONST
        ELSE
          CR_B_FLAG = 1
          DO IAN=1,6
            CR_ANIS(IAN) = U_ANISO(IAN,IA)
          ENDDO
          CALL CALC_B_EQUIV(U_ANISO(1,IA),BISO)
          CR_BISO = BISO
        ENDIF   

        CR_ANAME  = ATM_NAME (IA)     
        CR_ANAME_INP = ATM_NAME_INP(IA)     
        INSF      = ID_SF    (IA)
        CR_ASYMB  = CS_ELEMENT(INSF)      
        IF(CR_ASYMB.EQ.'?') THEN
          CR_ASYMB  = CS_ATYPE (INSF)
        ENDIF   
        CR_SF_ID  = INSF
        ST_CHEM   = ATM_CHEM (IA)
        CR_ATYPE  = ATM_TYPE (IA)    
        CR_ALT    = ID_ALT   (IA)    
        CR_SEG    = SEG_ID   (IA)    
        CR_CORR   = ID_CORR  (IA)    
        CR_XYZ(1) = XYZ_CRD  (1,IA) 
        CR_XYZ(2) = XYZ_CRD  (2,IA)  
        CR_XYZ(3) = XYZ_CRD  (3,IA)   

        CR_OCC    = OCCUP    (IA)
        CR_MULT_FACTOR = MULT_FACTOR(IA)

        IEND      = 0
        MODE_WRT  = 0
        IUN       = CRO_IUN 
        CALL WRCRD_CIF(MDOC,IUN,MODE_WRT,IEND,IERR)

        IUN       = CRSO_IUN 
        IEND      = 0
        MODE_WRT  = 0

        ST_IA     = CR_IATOLD
C       ST_CHEM   = '.'
        ST_HBT    = '.'
        ST_PNUM   = CR_PNUM(3:7)
        ST_IBACK  = 0
        ST_IFOR   = 0
        ST_IEXTR  = 0
        ST_ID_PSI = '.'
        ST_DIST   = 0.0
        ST_THT    = 0.0
        ST_PSI    = 0.0
        ST_CHAR   = 0.0
        ST_VDW    = 0.0
        ST_ION    = 0.0

        CALL WRSTR_CIF(MDOC,IUN,MODE_WRT,IEND,IERR)

 200    CONTINUE

      ENDDO
      RETURN
      END

      SUBROUTINE MAKE_REST(MDOC,ICHAIN,IRES,IERR)
C -----------------------------------------------
C -P- MAKE_REST - 
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ------------------------------------
      INTEGER*4 INAME1(MX1ALT)
      CHARACTER CORR1 (MX1ALT)*2
      INTEGER*4 INAME2(MX1ALT)
      CHARACTER CORR2 (MX1ALT)*2
      INTEGER*4 INAME3(MX1ALT)
      CHARACTER CORR3 (MX1ALT)*2
      INTEGER*4 INAME4(MX1ALT)
      CHARACTER CORR4 (MX1ALT)*2
      CHARACTER CHECK*1
      CHARACTER CORR(MAX1APL)*2
C -----------------------------------
      REAL      SD
      INTEGER*4 IPERIOD
      CHARACTER ALT1*1,ALT2*1,ALT3*1,ALT4*1
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,CHEM4*4
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4
C     CHARACTER NAMEP*4
      CHARACTER ATYPE1*1,ATYPE2*1,ATYPE3*1,ATYPE4*1
      CHARACTER LABEL*8,NAMEB*4,NAMEG*4,NAMET*4,NAMEC*4
      DATA NAMEB/'BOND'/,NAMEG/'ANGL'/,NAMET/'TORS'/
      DATA NAMEC/'CHIR'/
C     DATA NAMEP/'PLAN'/
C --------------------------------------------------------
      LABEL = ' '
      IF(L1B_NBOND.GT.0) THEN
        DO  IB=1,L1B_NBOND

           
          CALL SRCH_NUM(MDOC,L1B_1ATM(IB),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 100

          CALL SRCH_NUM(MDOC,L1B_2ATM(IB),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 100

          DO I=1,N1
            DO J=1,N2
              CORR(1) = CORR1(I)
              CORR(2) = CORR2(J)
              N       = 2

              CALL CHK_ALT(N,CORR,CHECK)
              IF(CHECK.EQ.'Y') THEN

                IA1    = INAME1(I)+C1_IGLOBAL          
                IA2    = INAME2(J)+C1_IGLOBAL          
                IA3    = 0
                IA4    = 0
                IA     = S1_INEW(INAME1(I))
                ATOM1  = C1_ANAME(IA)
                ATYPE1 = C1_ATYPE(IA)
                ALT1   = C1_ALT  (IA)
                CHEM1  = S1_CHEM (IA)
                OCC1   = C1_OCC  (IA)
                IA     = S1_INEW(INAME2(J))
                ATOM2  = C1_ANAME(IA)
                ATYPE2 = C1_ATYPE(IA)
                ALT2   = C1_ALT  (IA)
                CHEM2  = S1_CHEM (IA)
                OCC2   = C1_OCC  (IA)
                ATOM3  = ' '  
                ALT3   = ' '
                ATOM4  = ' '  
                ALT4   = ' '
                ECONST = 0.0

                IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M') THEN
                  CALL CALC_IDOBS(INAME1(I),INAME2(J),DOBS)
                ELSE
                  DOBS = 0.0
                ENDIF
                  
                DO K=1,LEB_NBOND

          IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *       (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1)) THEN
                    ECONST = LEB_CONST(K)
                    GO TO 500
                  ENDIF
                ENDDO
 500            CONTINUE


                IF((ATYPE1.NE.'M'.AND.ATYPE2.NE.'M').AND.
     *             (OCC1.GT.0.001.AND.OCC2.GT.0.001)     ) THEN
                  DIST    = 0.0
                  DESD    = 0.0
                  IPERIOD = 0

                  CALL CHECK_IDL_SPEC_LINK(MDOC,ICHAIN,IRES
     *              ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *              ,VIDL,VDEV,IYES,IERR)

                  IF(IYES.GT.0.AND.VIDL.GT.0.0001) THEN
                    IF(VDEV.LT.0.0001) VDEV = L1B_DEV(IB)  
                  ELSE
                    VIDL = L1B_VAL(IB)
                    VDEV = L1B_DEV(IB)  
                  ENDIF

                  CALL WRESTR(MDOC,NAMEB,L1B_TYPE(IB),IA1,IA2,IA3,IA4 
     *            ,VIDL,VDEV,DOBS,IPERIOD
     *            ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *            ,ALT1,ALT2,ALT3,ALT4,IERR)
                ENDIF

              ENDIF
            ENDDO
          ENDDO
  100     CONTINUE                    
        ENDDO      
      ENDIF

      IF(L1G_NANGL.GT.0) THEN
        DO  IG=1,L1G_NANGL

          CALL SRCH_NUM(MDOC,L1G_1ATM(IG),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 200
          CALL SRCH_NUM(MDOC,L1G_2ATM(IG),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 200
          CALL SRCH_NUM(MDOC,L1G_3ATM(IG),N3,CORR3,INAME3,IERR)
          IF(N3.LE.0) GO TO 200


          ANG = L1G_VAL(IG)
          DEV = L1G_DEV(IG)

          CALL CALC_DIST_ANGL(ANG,DEV,L1G_1ATM(IG),L1G_2ATM(IG)
     *                 ,L1G_3ATM(IG),DIST,DESD)

          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                CORR(1) = CORR1(I)
                CORR(2) = CORR2(J)
                CORR(3) = CORR3(K)
                N = 3
                CALL CHK_ALT(N,CORR,CHECK)
                IF(CHECK.EQ.'Y') THEN

                  IA1    = INAME1(I)+C1_IGLOBAL          
                  IA2    = INAME2(J)+C1_IGLOBAL          
                  IA3    = INAME3(K)+C1_IGLOBAL          
                  IA4    = 0
                  IA     = S1_INEW(INAME1(I))
                  ATOM1  = C1_ANAME(IA)
                  ATYPE1 = C1_ATYPE(IA)
                  ALT1   = C1_ALT  (IA)
                  CHEM1  = S1_CHEM (IA)
                  OCC1   = C1_OCC  (IA)
                  IA     = S1_INEW(INAME2(J))
                  ATOM2  = C1_ANAME(IA)
                  ATYPE2 = C1_ATYPE(IA)
                  ALT2   = C1_ALT  (IA)
                  CHEM2  = S1_CHEM (IA)
                  OCC2   = C1_OCC  (IA)
                  IA     = S1_INEW(INAME3(K))
                  ATOM3  = C1_ANAME(IA)
                  ATYPE3 = C1_ATYPE(IA)
                  ALT3   = C1_ALT  (IA)
                  CHEM3  = S1_CHEM (IA)
                  OCC3   = C1_OCC  (IA)
                  ATOM4  = ' '  
                  ALT4   = ' '
                  ECONST = 0.0

                  IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *               ATYPE3.NE.'M'                       ) THEN
                    CALL CALC_IANGOBS(INAME1(I),INAME2(J)
     *              ,INAME3(K),ANGOBS)
                  ELSE
                    ANGOBS = 0.0
                  ENDIF

                  DO L=1,LEG_NANGL
        IF((LEG_1ATM(L).EQ.CHEM1.AND.LEG_2ATM(L).EQ.CHEM2.AND.
     *                               LEG_3ATM(L).EQ.CHEM3).OR.
     *     (LEG_1ATM(L).EQ.CHEM3.AND.LEG_2ATM(L).EQ.CHEM2.AND. 
     *                               LEG_3ATM(L).EQ.CHEM1)) THEN
                      ECONST = LEG_CONST(L) 
                      GO TO 510
                    ENDIF
                  ENDDO
 510              CONTINUE


                  IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *               ATYPE3.NE.'M'.AND.OCC1.GT.0.001.AND.
     *               OCC2.GT.0.001.AND.OCC3.GT.0.001     ) THEN
c                   DIST=0.0
c                   DESD=0.0
                    IPERIOD=0

                    CALL CHECK_IDL_SPEC_LINK(MDOC,ICHAIN,IRES
     *                ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *                ,VIDL,VDEV,IYES,IERR)

                    IF(IYES.GT.0.AND.VIDL.GT.0.0001) THEN
                      IF(VDEV.LT.0.0001) VDEV = L1G_DEV(IG)  
                    ELSE
                      VIDL = L1G_VAL(IG)
                      VDEV = L1G_DEV(IG)  
                    ENDIF


                    CALL WRESTR(MDOC,NAMEG,LABEL,IA1,IA2,IA3,IA4 
     *              ,VIDL,VDEV
     *              ,ANGOBS,IPERIOD
     *              ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *              ,ALT1,ALT2,ALT3,ALT4,IERR)
                  ENDIF

                ENDIF
              ENDDO
            ENDDO
          ENDDO
  200     CONTINUE                    
        ENDDO      
      ENDIF

      IF(L1T_NTORS.GT.0) THEN
        DO  IT=1,L1T_NTORS
          CALL SRCH_NUM(MDOC,L1T_1ATM(IT),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 300
          CALL SRCH_NUM(MDOC,L1T_2ATM(IT),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 300
          CALL SRCH_NUM(MDOC,L1T_3ATM(IT),N3,CORR3,INAME3,IERR)
          IF(N3.LE.0) GO TO 300
          CALL SRCH_NUM(MDOC,L1T_4ATM(IT),N4,CORR4,INAME4,IERR)
          IF(N4.LE.0) GO TO 300

          ANG = L1T_VAL(IT)
          DEV = L1T_DEV(IT)
          CALL CALC_DIST_TORS(ANG,DEV,L1T_1ATM(IT),L1T_2ATM(IT)
     *                   ,L1T_3ATM(IT),L1T_4ATM(IT),DIST,DESD)

          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                DO L=1,N4
                  CORR(1) = CORR1(I)
                  CORR(2) = CORR2(J)
                  CORR(3) = CORR3(K)
                  CORR(4) = CORR4(L)
                  N = 4
                  CALL CHK_ALT(N,CORR,CHECK)
                  IF(CHECK.EQ.'Y') THEN

                    CALL CALC_ITRSOBS(INAME1(I),INAME2(J),INAME3(K)
     *                    ,INAME4(L),ANGOBS)
                    IA1     = INAME1(I)+C1_IGLOBAL          
                    IA2     = INAME2(J)+C1_IGLOBAL          
                    IA3     = INAME3(K)+C1_IGLOBAL          
                    IA4     = INAME4(L)+C1_IGLOBAL          
                    IPERIOD = L1T_PRD(IT)
                    IA      = S1_INEW(INAME1(I))
                    ATOM1   = C1_ANAME(IA)
                    ATYPE1  = C1_ATYPE(IA)
                    ALT1    = C1_ALT  (IA)
                    CHEM1   = S1_CHEM (IA)
                    OCC1    = C1_OCC  (IA)
                    IA      = S1_INEW(INAME2(J))
                    ATOM2   = C1_ANAME(IA)
                    ATYPE2  = C1_ATYPE(IA)
                    ALT2    = C1_ALT  (IA)
                    CHEM2   = S1_CHEM (IA)
                    OCC3    = C1_OCC  (IA)
                    IA      = S1_INEW(INAME3(K))
                    ATOM3   = C1_ANAME(IA)
                    ATYPE3  = C1_ATYPE(IA)
                    ALT3    = C1_ALT  (IA)
                    CHEM3   = S1_CHEM (IA)
                    OCC3    = C1_OCC  (IA)
                    IA      = S1_INEW(INAME4(L))
                    ATOM4   = C1_ANAME(IA)
                    ATYPE4  = C1_ATYPE(IA)
                    ALT4    = C1_ALT  (IA)
                    CHEM4   = S1_CHEM (IA)
                    OCC4    = C1_OCC  (IA)
                    ECONST  = 0.0

                    IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *                 ATYPE3.NE.'M'.AND.ATYPE4.NE.'M'     ) THEN
                      CALL CALC_ITRSOBS(INAME1(I),INAME2(J),INAME3(K)
     *                      ,INAME4(L),ANGOBS)
                    ELSE
                      ANGOBS = 0.0
                    ENDIF

                    DO M=1,LET_NTORS
        IF((LET_2ATM(M).EQ.CHEM2.AND.LET_3ATM(M).EQ.CHEM3).OR.
     *     (LET_2ATM(M).EQ.CHEM3.AND.LET_3ATM(M).EQ.CHEM2)) THEN
                        ECONST = LET_CONST(M) 
                        GO TO 520
                      ENDIF
                    ENDDO
 520                CONTINUE

                    IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *                 ATYPE3.NE.'M'.AND.ATYPE4.NE.'M'.AND.
     *                 OCC1.GT.0.001.AND.OCC2.GT.0.001.AND.
     *                 OCC3.GT.0.001.AND.OCC4.GT.0.001     ) THEN
                      CALL WRESTR(MDOC,NAMET,L1T_LABEL(IT),IA1,IA2 
     *                ,IA3,IA4,L1T_VAL(IT),L1T_DEV(IT)
     *                ,ANGOBS,IPERIOD
     *                ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *                ,ALT1,ALT2,ALT3,ALT4,IERR)
                    ENDIF

                  ENDIF
                ENDDO
              ENDDO
            ENDDO
          ENDDO
  300     CONTINUE                    
        ENDDO      
      ENDIF

      IF(L1C_NCHIR.GT.0) THEN
        DO  IC=1,L1C_NCHIR
        IF(L1C_SIGN(IC)(1:4).NE.'star'.AND.
     *     L1C_SIGN(IC)(1:4).NE.'cros'     ) THEN

          CALL SRCH_NUM(MDOC,L1C_1ATM(IC),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 400
          CALL SRCH_NUM(MDOC,L1C_2ATM(IC),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 400
          CALL SRCH_NUM(MDOC,L1C_3ATM(IC),N3,CORR3,INAME3,IERR)
          IF(N3.LE.0) GO TO 400
          CALL SRCH_NUM(MDOC,L1C_4ATM(IC),N4,CORR4,INAME4,IERR)
          IF(N4.LE.0) GO TO 400

          CALL CALC_IVOL(IC,VOLIDL,PH_IDL,PH2,PH3)
          L1C_VOL(IC) = VOLIDL

          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                DO L=1,N4
                  CORR(1) = CORR1(I)
                  CORR(2) = CORR2(J)
                  CORR(3) = CORR3(K)
                  CORR(4) = CORR4(L)
                  N       = 4
                  CALL CHK_ALT(N,CORR,CHECK)
                  IF(CHECK.EQ.'Y') THEN

                    IA1     = INAME1(I)+C1_IGLOBAL          
                    IA2     = INAME2(J)+C1_IGLOBAL          
                    IA3     = INAME3(K)+C1_IGLOBAL          
                    IA4     = INAME4(L)+C1_IGLOBAL          
                    IA      = S1_INEW(INAME1(I))
                    ATOM1   = C1_ANAME(IA)
                    ATYPE1  = C1_ATYPE(IA)
                    OCC1    = C1_OCC  (IA)
                    ALT1    = C1_ALT  (IA)
                    IA      = S1_INEW(INAME2(J))
                    ATOM2   = C1_ANAME(IA)
                    ATYPE2  = C1_ATYPE(IA)
                    ALT2    = C1_ALT  (IA)
                    OCC2    = C1_OCC  (IA)
                    IA      = S1_INEW(INAME3(K))
                    ATOM3   = C1_ANAME(IA)
                    ATYPE3  = C1_ATYPE(IA)
                    ALT3    = C1_ALT  (IA)
                    OCC3    = C1_OCC  (IA)
                    IA      = S1_INEW(INAME4(L))
                    ATOM4   = C1_ANAME(IA)
                    ATYPE4  = C1_ATYPE(IA)
                    ALT4    = C1_ALT  (IA)
                    OCC4    = C1_OCC  (IA)

                    IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *                 ATYPE3.NE.'M'.AND.ATYPE4.NE.'M'.AND.    
     *                 OCC1.GT.0.001.AND.OCC2.GT.0.001.AND.
     *                 OCC3.GT.0.001.AND.OCC4.GT.0.001     ) THEN

                      CALL CALC_I_OVOL(INAME1(I),INAME2(J)
     *                  ,INAME3(K),INAME4(L),VOLOBS,PH)

                      SD      = 0.02
                      IPERIOD = 0
                      DIST    = 0.0
                      DESD    = 0.0
                      ECONST  = PH

                      CALL WRESTR(MDOC,NAMEC,L1C_SIGN(IC),IA1,IA2 
     *                ,IA3,IA4,L1C_VOL(IC),SD
     *                ,VOLOBS,IPERIOD
     *                ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *                ,ALT1,ALT2,ALT3,ALT4,IERR)

                    ENDIF

                  ENDIF
                ENDDO
              ENDDO
            ENDDO
          ENDDO

  400     CONTINUE                    
        ENDIF
        ENDDO      
      ENDIF


      CALL IPLAN_RSTR(MDOC,IERR)

      RETURN
      END

C ******
      SUBROUTINE IPLAN_RSTR(MDOC,IERR)
C -----------------------------------------------
C -P- IPLAN_RSTR -
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
      INTEGER*4 INAME(MX1ALT)
      CHARACTER CORR (MX1ALT)*2

      REAL      DEV_PLAN(MAX1APL)
      REAL      DEV     (MAX1APL)
      REAL      DOBS    (MAX1APL)
      INTEGER*4 IATM    (MAX1APL)
      INTEGER*4 IN_PLAN (MAX1APL)
      INTEGER*4 IA_PLAN (MX1ALT,MAX1APL)
      INTEGER*4 ICORR   (MX1ALT,MAX1APL)
      INTEGER*4 IC_CODE (MAX1APL)
      INTEGER*4 IA_CODE (MAX1APL)
      CHARACTER CHAR1*1
C     CHARACTER ATYPE*1
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C --------------------------------------------------------
      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          IF(L1P_NATOM(IP).GT.0) THEN
            N  = 0
            NC = 0
            NA = 0  
            DO  I = 1,L1P_NATOM(IP)
              ICH4 = L1P_ATOM(I,IP)
              CALL SRCH_NUM(MDOC,CH4,NN,CORR,INAME,IERR)
              IF(NN.NE.0) THEN
                N           = N+1
                DEV_PLAN(N) = L1P_DEV(I,IP)
                JJ          = 0
                IN_PLAN(N)  = 0
                DO J=1,NN
                  IF(CORR(J).EQ.'..') THEN
                    JJ            = 1
                    IN_PLAN   (N) = JJ
                    ICORR  (JJ,N) = 0
                    IA_PLAN(JJ,N) = INAME(J)
                    GO TO 100
                  ELSE IF(CORR(J)(1:1).NE.'.') THEN
                    JJ          = JJ+1
                    IN_PLAN (N) = JJ
                    CHAR1       = CORR(J)(1:1)
                    CALL CHTOINT(CHAR1,ICODE)
                    IA_PLAN(JJ,N) = INAME(J)
                    ICORR  (JJ,N) = ICODE
                    IF(NC.GT.0) THEN
                      DO IC=1,NC
                        IF(IC_CODE(IC).EQ.ICODE) GO TO 200
                      ENDDO
                    ENDIF
                    NC          = NC+1
                    IC_CODE(NC) = ICODE
  200               CONTINUE
                  ELSE IF(CORR(J)(2:2).NE.'.') THEN
                    JJ          = JJ+1
                    IN_PLAN (N) = JJ
                    CHAR1       = CORR(J)(2:2)
                    CALL CHTOINT(CHAR1,ICODE)
                    ICODE         =-ICODE
                    IA_PLAN(JJ,N) = INAME(J)
                    ICORR  (JJ,N) = ICODE
                    IF(NA.GT.0) THEN
                      DO IA=1,NA
                        IF(IA_CODE(IA).EQ.ICODE) GO TO 300
                      ENDDO
                    ENDIF
                    NA          = NA+1
                    IA_CODE(NA) = ICODE
  300               CONTINUE
                  ENDIF
                ENDDO
              ENDIF
  100         CONTINUE
            ENDDO
C ---  
            IF(N.GE.4) THEN
              IF(NC.EQ.0.AND.NA.EQ.0) THEN       
                NP = 0
                DO J=1,N
                  IF(IN_PLAN(J).GT.0) THEN
                    NP       = NP+1
                    DEV (NP) = DEV_PLAN(J)
                    IATM(NP) = IA_PLAN(1,J)
                  ENDIF
                ENDDO
                IF(NP.GE.4) THEN
                  CALL CALC_IPLDEV(NP,NN,IATM,DOBS)
                  IF(NN.GE.4) THEN
                    CALL WPRSTR(MDOC,L1P_LABEL(IP),NP
     *                     ,DEV,DOBS,IATM,IERR)
                  ENDIF
                ENDIF
              ELSE
                IF(NC.GT.0) THEN       
                  DO I=1,NC
                    NP    = 0
                    ICODE = IC_CODE(I)
                    DO J=1,N
                      IF(IN_PLAN(J).GT.0) THEN
                      DO K=1,IN_PLAN(J)
                        IF(ICORR(K,J).EQ.0.OR.ICORR(K,J).EQ.ICODE) THEN
                          NP       = NP+1
                          DEV(NP)  = DEV_PLAN(J)
                          IATM(NP) = IA_PLAN(K,J)
                          GO TO 400
                        ENDIF
                      ENDDO
                      ENDIF
  400                 CONTINUE
                    ENDDO
                    IF(NP.GE.4) THEN
                      CALL CALC_IPLDEV(NP,NN,IATM,DOBS)
                      IF(NN.GE.4) THEN
                        CALL WPRSTR(MDOC,L1P_LABEL(IP),NP
     *                           ,DEV,DOBS,IATM,IERR)
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF       
                IF(NA.GT.0) THEN       
                  DO I=1,NA
                    NP = 0
                    ICODE=IA_CODE(I)
                    DO J=1,N
                      IF(IN_PLAN(J).GT.0) THEN
                      DO K=1,IN_PLAN(J)
                        IF(ICORR(K,J).EQ.0.OR.ICORR(K,J).EQ.ICODE) THEN
                          NP       = NP+1
                          DEV(NP)  = DEV_PLAN(J)
                          IATM(NP) = IA_PLAN(K,J)
                          GO TO 500
                        ENDIF
                      ENDDO
                      ENDIF
  500                 CONTINUE
                    ENDDO
                    IF(NP.GE.4) THEN
                      CALL CALC_IPLDEV(NP,NN,IATM,DOBS)
                      IF(NN.GE.4) THEN
                        CALL WPRSTR(MDOC,L1P_LABEL(IP),NP
     *                           ,DEV,DOBS,IATM,IERR)
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF       
              ENDIF
            ENDIF
          ELSE
            L1P_NATOM(IP) = 0
          ENDIF
        ENDDO      
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_IDL_SPEC_LINK(MDOC,IG,IR
     * ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,VIDL,VDEV,IYES,IERR)
C -----------------------------------------------
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IG,IR,IYES
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER ALT1*1,ALT2*1,ALT3*1
      REAL      VIDL,VDEV
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
c      INCLUDE 'crd_com.fh'
C ---
      CHARACTER MOD*8,SYMM1*8,SYMM2*8,LINK*8,ALT*1
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IYES = 0
      VIDL = 0.0
      VDEV = 0.0

      IF(LN_N.GT.0) THEN      

        DO I=1,LN_N

          IF(LN_USED(I).NE.'S') GO TO 310

          I1    = LN_1ICHN(I)
          I2    = LN_2ICHN(I)
          IR1   = LN_1IRES(I)
          IR2   = LN_2IRES(I)
          SYMM1 = LN_SYMM1(I)
          SYMM2 = LN_SYMM2(I)

          IF(SYMM1.NE.'.'.AND.SYMM1.NE.'1_555'.OR.
     *       SYMM2.NE.'.'.AND.SYMM2.NE.'1_555') THEN           
            GO TO 310
          ENDIF
          LINK  = LN_ID(I)
          CALL LOOK_LINK_LIST(LINK,ILINK)
          IF(ILINK.LE.0) GO TO 310

          IF(IR.EQ.IR1.AND.IG.EQ.I1.AND.
     *       (LN_ALT1(I).NE.'.'.AND.LN_ALT1(I).NE.' ')) THEN
            MOD = LLL_MOD1(ILINK)             
            ALT = LN_ALT1(I)
          ELSE IF(IR.EQ.IR2.AND.IG.EQ.I2.AND.
     *       (LN_ALT2(I).NE.'.'.AND.LN_ALT2(I).NE.' ')) THEN
            MOD = LLL_MOD2(ILINK)
            ALT = LN_ALT2(I)
          ELSE
            GO TO 310
          ENDIF

          IF(ALT.NE.ALT1.AND.ALT.NE.ALT2.AND.ALT.NE.ALT3) GO TO 310

          CALL USE_IDL_SPEC_LINK(MDOC,MOD
     *    ,ATOM1,ATOM2,ATOM3,VIDL,VDEV,IYES,IERR)

          IF(IYES.GT.0) RETURN

 310      CONTINUE
        ENDDO
      ENDIF
C ---
      RETURN
      END

      SUBROUTINE USE_IDL_SPEC_LINK(MDOC,MOD
     *    ,ATOM1,ATOM2,ATOM3,VIDL,VDEV,IYES,IERR)
C -----------------------------------------------
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MOD*8
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
C ---
      INCLUDE 'lib_com.fh'
C ---
      REAL      VAL,DEV
      CHARACTER FUNCT*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IYES = 0

      IF(MOD(1:1).EQ.'.'.OR.MOD(1:1).EQ.' '.OR.LDL_NMOD.LE.0) RETURN

      DO   L=1,LDL_NMOD
        IF(MOD.EQ.LDL_MNAME(L)) THEN
          LDL_IMOD = L
          GO TO 100
        ENDIF
      ENDDO  
      RETURN

  100 CONTINUE

      L = LDL_IMOD
      IF(L.LE.0) RETURN

      IF(ATOM3(1:1).NE.'.'.AND.ATOM3(1:1).NE.' ') THEN
        IG = LDL_ITHET(L)
        IB = 0
      ELSE
        IB = LDL_IBOND(L)
        IG = 0
      ENDIF

      IF(IB.GT.0) THEN

        IF(LDB_NBOND.LE.0.OR.LDB_NBOND.LT.IB) RETURN

        DO   L=IB,LDB_NBOND
          IF(MOD.EQ.LDB_MNAME(L)) THEN
            FUNCT=LDB_FUNCT(L)
            ATM1 =LDB_1ATM (L)
            ATM2 =LDB_2ATM (L)
            VAL  =LDB_VAL  (L)
            DEV  =LDB_DEV  (L)
            IF(FUNCT(1:6).EQ.'change'.OR.FUNCT(1:3).EQ.'add') THEN
              IF((ATM1.EQ.ATOM1.AND.ATM2.EQ.ATOM2).OR. 
     *           (ATM2.EQ.ATOM1.AND.ATM1.EQ.ATOM2)    ) THEN
                IF(ABS(VAL).GT.0.0001) THEN
                  VIDL = VAL
                  VDEV = DEV
                  IYES = 1
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDDO

      ELSE IF(IG.GT.0) THEN

        IF(LDG_NANGL.LE.0.OR.LDG_NANGL.LT.IG) RETURN

        DO   L=IG,LDG_NANGL
          IF(MOD.EQ.LDG_MNAME(L)) THEN
            FUNCT=LDG_FUNCT(L)
            ATM1 =LDG_1ATM (L)
            ATM2 =LDG_2ATM (L)
            ATM3 =LDG_3ATM (L)
            VAL  =LDG_VAL  (L)
            DEV  =LDG_DEV  (L)
            IF(FUNCT(1:6).EQ.'change'.OR.FUNCT(1:3).EQ.'add') THEN

              IF((ATM1.EQ.ATOM1.AND.ATM2.EQ.ATOM2 
     *                                   .AND.ATM3.EQ.ATOM3).OR. 
     *           (ATM3.EQ.ATOM1.AND.ATM2.EQ.ATOM2
     *                                   .AND.ATM1.EQ.ATOM3) ) THEN  
                IF(ABS(VAL).GT.0.00001) THEN
                  VIDL = VAL
                  VDEV = DEV
                  IYES = 1
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE DEF_DIST_TH_PH(MDOC,LIST,CH_FLAG,IERR)
C -----------------------------------------------
C -P- MAKE_REST - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER CH_FLAG*1,LIST*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
C ------------------------------------
      INTEGER*4 INAME1(MX1ALT)
      CHARACTER CORR1 (MX1ALT)*2
      INTEGER*4 INAME2(MX1ALT)
      CHARACTER CORR2 (MX1ALT)*2
      INTEGER*4 INAME3(MX1ALT)
      CHARACTER CORR3 (MX1ALT)*2
      INTEGER*4 INAME4(MX1ALT)
      CHARACTER CORR4 (MX1ALT)*2
      CHARACTER CHECK*1
      CHARACTER CORR(MAX1APL)*2
C -----------------------------------
C     REAL      SD
      INTEGER*4 IPERIOD
      CHARACTER SIGN*8,MON*8
      CHARACTER ATYPE1*1,ATYPE2*1,ATYPE3*1,ATYPE4*1
      CHARACTER LABEL*8
      CHARACTER ATOM1*4
C     CHARACTER ATOM2*4,ATOM3*4,ATOM4*4
      CHARACTER ATOM5*4,ATOM6*4,ATYPE5*1,ATYPE6*1
      INTEGER*4 INAME5(MX1ALT)
      CHARACTER CORR5 (MX1ALT)*2
      INTEGER*4 INAME6(MX1ALT)
      CHARACTER CORR6 (MX1ALT)*2
C --------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
C     TWOPI = 2.0*PI
      PI180 = PI/180.0
      MON   = ' '

      IF(LIST.EQ.'T') write(*,*) ' --- tree ---bond'

      IF(L1B_NBOND.GT.0) THEN
        DO  IB=1,L1B_NBOND

          CALL SRCH_NUM(MDOC,L1B_1ATM(IB),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 100

          CALL SRCH_NUM(MDOC,L1B_2ATM(IB),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 100

          DO I=1,N1
            DO J=1,N2
              CORR(1) = CORR1(I)
              CORR(2) = CORR2(J)
              N       = 2

              CALL CHK_ALT(N,CORR,CHECK)
              IF(CHECK.EQ.'Y') THEN

                IAA1   = S1_INEW (INAME1(I))
                IL1    = S1_ILIB (IAA1)
                ATYPE1 = C1_ATYPE(IAA1)
                IAA2   = S1_INEW (INAME2(J))
                IL2    = S1_ILIB (IAA2)
                ATYPE2 = C1_ATYPE(IAA2)

                IF((ATYPE1.NE.'M'.AND.ATYPE2.NE.'M').AND.
     *             (C1_OCC(IAA1).GT.0.001.AND.C1_OCC(IAA2).GT.0.001))
     *                                                           THEN
                  CALL CALC_IDOBS(INAME1(I),INAME2(J),DOBS)
                ELSE
                  DOBS = L1B_VAL(IB)
                ENDIF
                  
                IF(IL1.GT.0.AND.IL2.GT.0) THEN
                  IF(L1A_IBACK(IL1).EQ.IL2) THEN 
                    S1_DIST(IAA1)   = DOBS   
C                    S1_DIST(IAA1)   = L1B_VAL(IB)   
                    L1A_LENGTH(IL1) = L1B_VAL(IB)
                  ELSE IF(L1A_IBACK(IL2).EQ.IL1) THEN                  
                    S1_DIST(IAA2)   = DOBS   
C                    S1_DIST(IAA2)   = L1B_VAL(IB)  
                    L1A_LENGTH(IL2) = L1B_VAL(IB)
                  ENDIF
                ENDIF

              ENDIF
            ENDDO
          ENDDO
  100     CONTINUE                    
        ENDDO      
      ENDIF

      IF(LIST.EQ.'T') write(*,*) ' --- tree --- angle'

      IF(L1G_NANGL.GT.0) THEN
        DO  IG=1,L1G_NANGL

          CALL SRCH_NUM(MDOC,L1G_1ATM(IG),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 200
          CALL SRCH_NUM(MDOC,L1G_2ATM(IG),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 200
          CALL SRCH_NUM(MDOC,L1G_3ATM(IG),N3,CORR3,INAME3,IERR)
          IF(N3.LE.0) GO TO 200


          ANG = L1G_VAL(IG)
          DEV = L1G_DEV(IG)


          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                CORR(1) = CORR1(I)
                CORR(2) = CORR2(J)
                CORR(3) = CORR3(K)
                N = 3
                CALL CHK_ALT(N,CORR,CHECK)
                IF(CHECK.EQ.'Y') THEN

                  IAA1   = S1_INEW (INAME1(I))
                  ATYPE1 = C1_ATYPE(IAA1)
                  IL1    = S1_ILIB (IAA1)
                  IAA2   = S1_INEW (INAME2(J))
                  IL2    = S1_ILIB (IAA2)
                  ATYPE2 = C1_ATYPE(IAA2)
                  IAA3   = S1_INEW (INAME3(K))
                  IL3    = S1_ILIB (IAA3)
                  ATYPE3 = C1_ATYPE(IAA3)

                  IF((ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.ATYPE3.NE.'M')
     *              .AND.(C1_OCC(IAA1).GT.0.001.AND.
     *              C1_OCC(IAA2).GT.0.001.AND.C1_OCC(IAA3).GT.0.001))
     *                                                           THEN
                    CALL CALC_IANGOBS(INAME1(I),INAME2(J)
     *              ,INAME3(K),ANGOBS)
                    ANG = ANGOBS
                  ELSE
                    ANG = L1G_VAL(IG)
                  ENDIF

                  IF(IL1.GT.0.AND.IL2.GT.0.AND.IL3.GT.0) THEN

                    ILB3 = L1A_IBACK(IL3)  
                    ILB2 = L1A_IBACK(IL2)  
                    ILB1 = L1A_IBACK(IL1)  

                    IF(ILB2.GT.0) THEN 

                      IF(ILB1.EQ.IL2) THEN 
C
C                                 1
C                                ^ 
C                               /
C                       3 -> - 2
C                            
                        IF(ILB2.EQ.IL3) THEN
C                         S1_THT(IAA1)   = ANG
                          S1_THT(IAA1)   = L1G_VAL(IG)
                          L1A_THETA(IL1) = L1G_VAL(IG)
                          IF(ILB3.LT.0.AND.(CH_FLAG.EQ.'S'.OR.
     *                       CH_FLAG.EQ.'M'.OR.CH_FLAG.EQ.'G')) THEN 
                            ILF  = L1A_IFORW(IL2)
                            IF(ILF.EQ.IL1) THEN
                              S1_PSI    (IAA1) = 0.0   
                              L1A_PHI   (IL1 ) = 0.0  
                              S1_ID_PSI (IAA1) = '.'
                              L1A_ID_PSI(IL1 ) = '.'
                              S1_PSI    (IAA2) = 0.0   
                              L1A_PHI   (IL2 ) = 0.0  
                              S1_ID_PSI (IAA2) = '.'
                              L1A_ID_PSI(IL2 ) = '.'
                              S1_PSI    (IAA3) = 0.0   
                              L1A_PHI   (IL3 ) = 0.0  
                              S1_ID_PSI (IAA3) = '.'
                              L1A_ID_PSI(IL3 ) = '.'
                            ENDIF
                          ENDIF
                        ENDIF

                      ELSE IF(ILB3.EQ.IL2) THEN 
C
C                                 3
C                                ^ 
C                               /
C                       1 -> - 2
C
                        IF(ILB2.EQ.IL1) THEN
C                         S1_THT(IAA3)   = ANG   
                          S1_THT(IAA3)   = L1G_VAL(IG)  
                          L1A_THETA(IL3) = L1G_VAL(IG)
                          IF(ILB1.LT.0.AND.(CH_FLAG.EQ.'S'.OR.
     *                       CH_FLAG.EQ.'M'.OR.CH_FLAG.EQ.'G')) THEN 
                            ILF  = L1A_IFORW(IL2)
                            IF(ILF.EQ.IL3) THEN
                              S1_PSI    (IAA1) = 0.0   
                              L1A_PHI   (IL1 ) = 0.0  
                              S1_ID_PSI (IAA1) = '.'
                              L1A_ID_PSI(IL1 ) = '.'
                              S1_PSI    (IAA2) = 0.0   
                              L1A_PHI   (IL2 ) = 0.0  
                              S1_ID_PSI (IAA2) = '.'
                              L1A_ID_PSI(IL2 ) = '.'
                              S1_PSI    (IAA3) = 0.0   
                              L1A_PHI   (IL3 ) = 0.0  
                              S1_ID_PSI (IAA3) = '.'
                              L1A_ID_PSI(IL3 ) = '.'
                            ENDIF
                          ENDIF
                        ENDIF
                      ENDIF
                    ELSE IF(ILB2.LT.0.AND.(CH_FLAG.EQ.'S'.OR.
     *                CH_FLAG.EQ.'M'.OR.CH_FLAG.EQ.'G')) THEN 
                      IF(ILB1.EQ.IL2.AND.ILB3.EQ.IL2) THEN 
                        ILF  = L1A_IFORW(IL2)
                        ILN  = 0
                        ILN1 = 0
                        LND  = L1A_NDIST(IL2)
                        IF(LND.GT.0) THEN
                          ILN = L1A_CONN(LND,IL2)  
                          IF(LND.GT.1) THEN
                            ILN1 = L1A_CONN(LND-1,IL2)  
                          ENDIF
                        ENDIF
                        IF(ILF.GT.0) THEN  
                          IF(IL1.EQ.ILF) THEN
C
C                                    3
C                           START 2 <          
C                                    1 (forward)
C
                            S1_THT(IAA3)   = ANG   
C                            S1_THT(IAA3)   = L1G_VAL(IG)   
                            L1A_THETA(IL3) = L1G_VAL(IG)
                            IF(ILN1.GT.0.AND.IL3.EQ.ILN1) THEN  
                              S1_THT(IAA1)   = ANG   
C                              S1_THT(IAA1)   = L1G_VAL(IG)  
                              L1A_THETA(IL1) = L1G_VAL(IG)
                            ENDIF
                          ELSE IF(IL3.EQ.ILF) THEN
C
C                                    3 (forward)
C                           START 2 <          
C                                    1 
                            S1_THT(IAA1)   = ANG   
C                            S1_THT(IAA1)   = L1G_VAL(IG)   
                            L1A_THETA(IL1) = L1G_VAL(IG)
                            IF(ILN1.GT.0.AND.IL1.EQ.ILN1) THEN  
                              S1_THT(IAA3)   = ANG   
C                              S1_THT(IAA3)   = L1G_VAL(IG)  
                              L1A_THETA(IL3) = L1G_VAL(IG)
                            ENDIF
                          ENDIF
                        ELSE
                          IF(ILN.GT.0) THEN
                            IF(IL1.EQ.ILN) THEN
C
C                                          3 
C                             START&END 2 <          
C                                          1 (N- last atom) 
C
                              S1_THT(IAA3)   = ANG   
                              L1A_THETA(IL3) = L1G_VAL(IG)

                            ELSE IF(IL3.EQ.ILN) THEN
C
C                                          3 (N- last atom)
C                             START&END 2 <          
C                                          1 
C
C                             S1_THT(IAA1)   = ANG   
                              S1_THT(IAA1)   = L1G_VAL(IG)   
                              L1A_THETA(IL1) = L1G_VAL(IG)
                            ENDIF
                            IF(ILN1.GT.0) THEN 
C
C                                      (N- last atom) 
C                                       ! (N-1) 
C                             START&END 2<          
C                                       ! 
C
                              IF(IL1.EQ.ILN.AND.IL3.EQ.ILN1) THEN
C                               S1_THT(IAA1)   = ANG   
                                S1_THT(IAA1)   = L1G_VAL(IG)  
                                L1A_THETA(IL1) = L1G_VAL(IG)
                              ELSE IF(IL3.EQ.ILN.AND.IL1.EQ.ILN1) THEN
C                               S1_THT(IAA3)   = ANG   
                                S1_THT(IAA3)   = L1G_VAL(IG)   
                                L1A_THETA(IL3) = L1G_VAL(IG)
                              ENDIF
                            ENDIF
                          ENDIF
                        ENDIF
                      
                      ENDIF

                    ENDIF

                  ENDIF

                ENDIF
              ENDDO
            ENDDO
          ENDDO
  200     CONTINUE                    
        ENDDO      
      ENDIF

      IF(LIST.EQ.'T') write(*,*) ' --- tree --- tors'

      IF(L1T_NTORS.GT.0) THEN
        DO  IT=1,L1T_NTORS
          CALL SRCH_NUM(MDOC,L1T_1ATM(IT),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 300
          CALL SRCH_NUM(MDOC,L1T_2ATM(IT),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 300
          CALL SRCH_NUM(MDOC,L1T_3ATM(IT),N3,CORR3,INAME3,IERR)
          IF(N3.LE.0) GO TO 300
          CALL SRCH_NUM(MDOC,L1T_4ATM(IT),N4,CORR4,INAME4,IERR)
          IF(N4.LE.0) GO TO 300

          ANG_IDL = L1T_VAL(IT)
          DEV     = L1T_DEV(IT)
          IPERIOD = L1T_PRD(IT)
          LABEL   = L1T_LABEL(IT)

          IL1  = S1_ILIB(S1_INEW(INAME1(1)))
          IL2  = S1_ILIB(S1_INEW(INAME2(1)))
          IL3  = S1_ILIB(S1_INEW(INAME3(1)))
          IL4  = S1_ILIB(S1_INEW(INAME4(1)))
          ILB1 = L1A_IBACK(IL1)  
          ILB2 = L1A_IBACK(IL2)  
          ILB3 = L1A_IBACK(IL3)  
          ILB4 = L1A_IBACK(IL4)  


          IF(ILB2.EQ.IL3) THEN
C           wrong direction
            CALL SRCH_NUM(MDOC,L1T_4ATM(IT),N1,CORR1,INAME1,IERR)
            IF(N1.LE.0) GO TO 300
            CALL SRCH_NUM(MDOC,L1T_3ATM(IT),N2,CORR2,INAME2,IERR)
            IF(N2.LE.0) GO TO 300
            CALL SRCH_NUM(MDOC,L1T_2ATM(IT),N3,CORR3,INAME3,IERR)
            IF(N3.LE.0) GO TO 300
            CALL SRCH_NUM(MDOC,L1T_1ATM(IT),N4,CORR4,INAME4,IERR)
            IF(N4.LE.0) GO TO 300
            ANG_IDL = -ANG_IDL
            IL1  = S1_ILIB(S1_INEW(INAME1(1)))
            IL2  = S1_ILIB(S1_INEW(INAME2(1)))
            IL3  = S1_ILIB(S1_INEW(INAME3(1)))
            IL4  = S1_ILIB(S1_INEW(INAME4(1)))
            ILB1 = L1A_IBACK(IL1)  
            ILB2 = L1A_IBACK(IL2)  
            ILB3 = L1A_IBACK(IL3)  
            ILB4 = L1A_IBACK(IL4)  
          ENDIF

          IF(ILB2.NE.IL1.AND.ILB1.EQ.IL2.AND.ILB2.GT.0) THEN
            ATOM1 = L1A_ANAME(ILB2)
            CALL SRCH_NUM(MDOC,ATOM1,N1,CORR1,INAME1,IERR)
            IF(N1.LE.0) GO TO 300
            IL1     = ILB2 
            LABEL   = 'V'
            IPERIOD = 1
            ANG_IDL = 0.0
          ENDIF

C ///
          IL1  = S1_ILIB(S1_INEW(INAME1(1)))
          IL2  = S1_ILIB(S1_INEW(INAME2(1)))
          IL3  = S1_ILIB(S1_INEW(INAME3(1)))
          IL4  = S1_ILIB(S1_INEW(INAME4(1)))

          IF(LIST.EQ.'T') THEN
            write(*,*) ' T2:',L1A_aname(IL1), L1A_aname(IL2), 
     *               L1A_aname(IL3), L1A_aname(IL4),ang_idl
            write(*,*) il1,il2,il3,il4
          ENDIF
C ///

          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                DO L=1,N4
                  CORR(1) = CORR1(I)
                  CORR(2) = CORR2(J)
                  CORR(3) = CORR3(K)
                  CORR(4) = CORR4(L)
                  N = 4
                  CALL CHK_ALT(N,CORR,CHECK)
                  IF(CHECK.EQ.'Y') THEN

                    IAA1   = S1_INEW (INAME1(I))
                    IA1    = INAME1(I)         
                    ATYPE1 = C1_ATYPE(IAA1)
                    IL1    = S1_ILIB (IAA1)
                    IAA2   = S1_INEW (INAME2(J))
                    IA2    = INAME2(J)         
                    ATYPE2 = C1_ATYPE(IAA2)
                    IL2    = S1_ILIB (IAA2)
                    IAA3   = S1_INEW (INAME3(K))
                    IA3    = INAME3(K)         
                    ATYPE3 = C1_ATYPE(IAA3)
                    IL3    = S1_ILIB (IAA3)
                    IAA4   = S1_INEW (INAME4(L))
                    IA4    = INAME4(L)         
                    ATYPE4 = C1_ATYPE(IAA4)
                    IL4    = S1_ILIB (IAA4)

                    IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *                 ATYPE3.NE.'M'.AND.ATYPE4.NE.'M'.AND.
     *            C1_OCC(IAA1).GT.0.001.AND.C1_OCC(IAA2).GT.0.001.AND.
     *            C1_OCC(IAA3).GT.0.001.AND.C1_OCC(IAA4).GT.0.001) THEN

                      CALL CALC_ITRSOBS(INAME1(I),INAME2(J),INAME3(K)
     *                      ,INAME4(L),ANGOBS)
                      ANG = ANGOBS
                      
                    ELSE

                      ANG    = ANG_IDL

                      ANGOBS = 0.0
                    ENDIF

                    IF(IL1.GT.0.AND.IL2.GT.0.AND.IL3.GT.0.AND.
     *                 IL4.GT.0                               ) THEN

                      ILB1 = L1A_IBACK(IL1)  
                      ILB2 = L1A_IBACK(IL2)  
                      ILB3 = L1A_IBACK(IL3)  
                      ILB4 = L1A_IBACK(IL4)  

                      ILF  = L1A_IFORW(IL3)  
                      ILN  = 0
                      ILN1 = 0
                      ILN2 = 0
                      LND  = L1A_NDIST(IL3)
                      IF(LND.GT.0) THEN
                        ILN = L1A_CONN(LND,IL3)  
                        IF(LND.GT.1) THEN
                          ILN1 = L1A_CONN(LND-1,IL3)  
                          IF(LND.GT.2) THEN
                            ILN2 = L1A_CONN(LND-2,IL3)  
                          ENDIF
                        ENDIF
                      ENDIF
C                     ILE extra atom
                      ILE = 0
                      NE  = L1N_NCONN
                      IF(NE.GT.0) THEN
                        DO KK=1,NE
                          IF(L1N_I1ATM(KK).EQ.IL3) THEN
                            ILE = L1N_I2ATM(KK)
                          ELSE IF(L1N_I2ATM(KK).EQ.IL3) THEN
                            ILE = L1N_I1ATM(KK)
                          ENDIF
                        ENDDO
                      ENDIF

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) 'IL:',IL1,IL2,IL3,IL4
                        WRITE(*,*) 'ILB,ILE:',ILB1,ILB2,ILB3,ILB4
                        WRITE(*,*) 'ILF,ILN,ILE:',ILF,ILN,ILN1,ILN2,ILE
                      ENDIF

                      IF(ILB4.EQ.IL3.OR.ILE.EQ.IL4) THEN 
C
C                          IL1 --> IL2 --> IL3 --> IL4
C
C                      or  IL1 --> IL2 --> IL3.....IL4
C
C                               cases ???:
C                               IL1 ...> IL2 ---> IL3 ---> IL4
C                               IL1 ---> IL2 ...> IL3 ---> IL4
C
C
C               RNA         IL1 ---> IL2 ---> IL3 ...> IL4   IL3 has chirality
C                           O4*      C1*      C2*      C3*
C                                                
C                                              V  
C                                              O2*-->HO2
C                                             forw
C
C                                              .I4(extr) C3*
C                                        C2* .
C               DNA         IL1 --> IL2 --> IL3. --> i(forw)  IL3 not chirality
C                            O4*     C1*      \
C                                              j    for example i and j Hatoms
C                                                      DNA
C
                        IF(ILB3.EQ.IL2.AND.ILB2.EQ.IL1) THEN

                          IF(IL4.NE.ILN.AND.IL4.NE.ILE) THEN

                            IF(ILF.GT.0) THEN
                              ATOM5 = L1A_ANAME(ILF)
                              CALL SRCH_NUM(MDOC,ATOM5,N5,CORR5
     *                                          ,INAME5,IERR)
                              IF(N5.GT.0) THEN
                                DO M=1,N5
                                  CORR(5) = CORR5(M)
                                  N       = 5
                                  CALL CHK_ALT(N,CORR,CHECK)
                                  IF(CHECK.EQ.'Y') THEN
                                    IA5     = INAME5(M)         
                                    IAA5    = S1_INEW (INAME5(M))
                                    ATYPE5  = C1_ATYPE(IAA5)
                                    IF(ATYPE1.NE.'M'.AND.
     *                                 ATYPE2.NE.'M'.AND.
     *                                 ATYPE3.NE.'M'.AND.
     *                                 ATYPE5.NE.'M'.AND.    
     *            C1_OCC(IAA1).GT.0.001.AND.C1_OCC(IAA2).GT.0.001.AND.
     *            C1_OCC(IAA3).GT.0.001.AND.C1_OCC(IAA5).GT.0.001) THEN

                                      CALL CALC_ITRSOBS(INAME1(I)
     *                                       ,INAME2(J),INAME3(K)
     *                                       ,INAME5(M),ANGOBS)
                                    ELSE
                                      ANGOBS = 0.0
                                    ENDIF
                                    ANG_IDL = 0.0
                                    LABEL   = 'v'
                                    ANG              = ANGOBS
                                    S1_PSI    (IAA5) = ANG   
                                    L1A_PHI   (ILF ) = ANG_IDL  
                                    L1A_ID_PSI(ILF ) = LABEL
                                    S1_ID_PSI (IAA5) = LABEL

                                  ENDIF
                                ENDDO
                              ENDIF
                                                    
                              IF(ILF.NE.ILN) THEN
                                IL5 = ILN
                                IL6 = ILN1
                              ELSE
                                IL5 = ILN1
                                IL6 = ILN2
                              ENDIF
                               
                              IL5 = 0
                              IL6 = 0
                              IF(ILF.NE.IL4.AND.ILN.NE.IL4) THEN
                                IL5 = ILN
                                IF(ILN1.NE.IL4) IL6 = ILN1
                              ELSE
                                IF(ILN1.NE.IL4) THEN
                                  IL5 = ILN1
                                  IF(ILN2.NE.IL4) IL6 = ILN2
                                ELSE
                                  IF(ILN2.NE.IL4) IL5 = ILN2
                                ENDIF
                              ENDIF

                            ELSE

C                             put PH(4) = PHidl , check coords(?)
C
                              S1_PSI    (IAA4) = ANG   
                              L1A_PHI   (IL4 ) = ANG_IDL  
                              S1_ID_PSI (IAA4) = 'Co1T'
                              L1A_ID_PSI(IL4 ) = 'Co1T'

                              IL5 = 0
                              IL6 = 0
                              IF(IL4.NE.ILN1) THEN
                                IL5 = ILN1
                                IF(IL4.NE.ILN2) THEN
                                  IL6 = ILN2
                                ENDIF
                              ELSE
                                IF(IL4.NE.ILN2) THEN
                                  IL5 = ILN2
                                ENDIF
                              ENDIF

                            ENDIF

                          ELSE IF(IL4.EQ.ILN.OR.IL4.EQ.ILE) THEN
                   
                            IF(IL4.EQ.ILN) THEN
C                             put PH(4) = PHobs 
C 
                              LABEL = 'vv'
                              IF(IPERIOD.LE.0) LABEL = 'cvv'       
                              ANG              = ANGOBS
                              IF(ATYPE4.EQ.'M') ANG =  ANG_IDL
                              S1_PSI    (IAA4) = ANG   
                              L1A_PHI   (IL4 ) = ANG_IDL  
                              L1A_ID_PSI(IL4 ) = LABEL
                              S1_ID_PSI (IAA4) = LABEL

C                             get others(i) if not chir or plan. 
C                             example: two H or two O
C                             check coords    
C                          
                              IL5 = ILN1
                              IL6 = ILN2

                            ELSE IF(IL4.EQ.ILE) THEN
C
C                             get ILN and others if not chir or plan 
C                       
                              IL5 = ILN
                              IL6 = ILN1

                            ENDIF

                          ENDIF

                          PHH  = 999.0
                          IPH5 = 0

                          CALL SRCH_CHIR_CENTRE(MDOC,MON,IL3,LC,IERR)

C =5===
                          IF(IL5.GT.0.AND.LC.LE.0) THEN

                            CALL SRCH_PLAN(MDOC,MON,IL2,IL3,IL4,IL5
     *                                     ,LP,IERR)
                             
                            IF(LP.LE.0) THEN
                              ATOM5 = L1A_ANAME(IL5)
                              CALL SRCH_NUM(MDOC,ATOM5,N5,CORR5
     *                                          ,INAME5,IERR)
                              IF(N5.GT.0) THEN
                                DO M=1,N5
                                  CORR(5) = CORR5(M)
                                  N      = 5
                                  CALL CHK_ALT(N,CORR,CHECK)
                                  IF(CHECK.EQ.'Y') THEN
                                    IA5     = INAME5(M)         
                                    IAA5    = S1_INEW (INAME5(M))
                                    ATYPE5  = C1_ATYPE(IAA5)

                                    IF(ATYPE2.NE.'M'.AND.
     *                                 ATYPE3.NE.'M'.AND.
     *                                 ATYPE4.NE.'M'.AND.
     *                                 ATYPE5.NE.'M'.AND.
     *            C1_OCC(IAA5).GT.0.001.AND.C1_OCC(IAA2).GT.0.001.AND.
     *            C1_OCC(IAA3).GT.0.001.AND.C1_OCC(IAA4).GT.0.001) THEN

                                      CALL CALC_I_OVOL(IA3,IA2,IA5,IA4
     *                                                 ,VOL,PH)

                                      PH  = -PH
                                      PHH =  PH
                                    ENDIF
C                                                 I4 
C                                                 ^
C                                         A1     /    
C                                      I2 ----->I3  A12  PH 
C                                         A2     \    
C                                                 V
C                                                 I5
C                            
                                    CALL SRCH_ANGL(MDOC,MON,IL2,IL3
     *                                   ,IL4,A1,LG1,IERR)
                                    CALL SRCH_ANGL(MDOC,MON,IL2,IL3
     *                                   ,IL5,A2,LG2,IERR)
                                    CALL SRCH_ANGL(MDOC,MON,IL4,IL3
     *                                   ,IL5,A12,LG12,IERR)
                                    IERR = 0
                                    A1   = A1 *PI180         
                                    A2   = A2 *PI180         
                                    A12  = A12*PI180         
                                    CALL GET_TORS(A1,A2,A12,PH5)
                                    PH5 = PH5/PI180

                                    IF(PHH.LT.999.0) THEN
                                      IF(PH.LT.0.0) PH5 = -ABS(PH5)
                                    ELSE
                                      PH  = PH5
                                    ENDIF
                                    IPH5 = 1
                                    IF(PH5.LT.0.0) IPH5 = -1
                                    IF(S1_ID_PSI(IAA5).EQ.'?') THEN
                                      S1_PSI    (IAA5) = PH   
C                                     S1_PSI    (IAA5) = PH5   
                                      L1A_PHI   (IL5 ) = PH5  
                                      S1_ID_PSI (IAA5) = 'Co5T'
                                      L1A_ID_PSI(IL5 ) = 'Co5T'
                                    ENDIF
c                                    S1_ID_PSI (IAA5) = 'Co5T'
c                                    L1A_ID_PSI(IL5 ) = 'Co5T'

                                  ENDIF
                                ENDDO
                              ENDIF
                            ENDIF
                          ENDIF
C ==5===
C ==6===
                          IF(IL6.GT.0.AND.LC.LE.0) THEN

                            CALL SRCH_PLAN(MDOC,MON,IL2,IL3,IL4,IL6
     *                                     ,LP,IERR)
                            IF(LP.LE.0) THEN
                              ATOM6 = L1A_ANAME(IL6)
                              CALL SRCH_NUM(MDOC,ATOM6,N6,CORR6
     *                                       ,INAME6,IERR)
                              IF(N6.GT.0) THEN
                                DO M=1,N6
                                  CORR(5) = CORR6(M)
                                  N      = 5
                                  CALL CHK_ALT(N,CORR,CHECK)
                                  IF(CHECK.EQ.'Y') THEN
                                    IPH6    = 0
                                    IA6     = INAME6(M)         
                                    IAA6    = S1_INEW (INAME6(M))
                                    ATYPE6  = C1_ATYPE(IAA6)
                                    IF(ATYPE2.NE.'M'.AND.
     *                                 ATYPE3.NE.'M'.AND.
     *                                 ATYPE4.NE.'M'.AND.
     *                                 ATYPE6.NE.'M'.AND.
     *            C1_OCC(IAA6).GT.0.001.AND.C1_OCC(IAA2).GT.0.001.AND.
     *            C1_OCC(IAA3).GT.0.001.AND.C1_OCC(IAA4).GT.0.001) THEN

                                      CALL CALC_I_OVOL(IA3,IA2,IA6,IA4
     *                                ,VOL,PH)

                                      PH   = -PH
                                      IPH6 = 1
                                      IF(PH.LT.0.0) IPH6 = -1
                                    ENDIF
C                                                I4 
C                                                ^
C                                        A1     /    
C                                     I2 ----->I3  A12  PH 
C                                        A2     \    
C                                                V
C                                                I6
C                            
                                    CALL SRCH_ANGL(MDOC,MON,IL2,IL3
     *                                   ,IL4,A1,LG1,IERR)
                                    CALL SRCH_ANGL(MDOC,MON,IL2,IL3
     *                                   ,IL6,A2,LG2,IERR)
                                    CALL SRCH_ANGL(MDOC,MON,IL4,IL3
     *                                   ,IL6,A12,LG12,IERR)
                                    IERR = 0
                                    A1   = A1 *PI180         
                                    A2   = A2 *PI180         
                                    A12  = A12*PI180         
                                    CALL GET_TORS(A1,A2,A12,PH6)
                                    PH6 = PH6/PI180
                                    IF(IPH6.EQ.0) PH = PH6

                                    IF(IPH6.GT.0) THEN
                                      PH6 = ABS(PH6)
                                      PH  = -ABS(PH) 
                                    ELSE IF(IPH6.LT.0) THEN
                                      PH6 = -ABS(PH6) 
                                    ENDIF

                                    IF(IPH5.GT.0) THEN
                                      PH  =-ABS(PH)
                                      PH6 =-ABS(PH6)
                                    ELSE IF(IPH5.LT.0) THEN
                                      PH  = ABS(PH)
                                      PH6 = ABS(PH6)
                                    ENDIF

                                    IF(S1_ID_PSI(IAA6).EQ.'?') THEN
                                      S1_PSI    (IAA6) = PH   
C                                      S1_PSI    (IAA6) = PH6   
                                      L1A_PHI   (IL6 ) = PH6  
                                      S1_ID_PSI (IAA6) = 'Co6T'
                                      L1A_ID_PSI(IL6 ) = 'Co6T'
                                    ENDIF
c                                    S1_ID_PSI (IAA6) = 'Co6T'
c                                    L1A_ID_PSI(IL6 ) = 'Co6T'

                                  ENDIF
                                ENDDO
                              ENDIF

                            ENDIF
                          ENDIF
C ==6===
                        ENDIF
                      ENDIF
                    ENDIF

                  ENDIF
                ENDDO
              ENDDO
            ENDDO
          ENDDO
  300     CONTINUE                    
        ENDDO      
      ENDIF

      IF(LIST.EQ.'T') write(*,*) ' --- tree --- chir'

      IF(L1C_NCHIR.GT.0) THEN
        DO  IC=1,L1C_NCHIR
        IF(L1C_SIGN(IC)(1:4).NE.'star'.AND.
     *     L1C_SIGN(IC)(1:4).NE.'cros'     ) THEN
          CALL SRCH_NUM(MDOC,L1C_1ATM(IC),N1,CORR1,INAME1,IERR)
          IF(N1.LE.0) GO TO 400
          CALL SRCH_NUM(MDOC,L1C_2ATM(IC),N2,CORR2,INAME2,IERR)
          IF(N2.LE.0) GO TO 400
          CALL SRCH_NUM(MDOC,L1C_3ATM(IC),N3,CORR3,INAME3,IERR)
          IF(N3.LE.0) GO TO 400
          CALL SRCH_NUM(MDOC,L1C_4ATM(IC),N4,CORR4,INAME4,IERR)
          IF(N4.LE.0) GO TO 400

          SIGN = L1C_SIGN(IC) 
          IS   = 0
          IF(SIGN(1:3).EQ.'pos') IS = 1
          IF(SIGN(1:3).EQ.'neg') IS =-1

          CALL CALC_IVOL(IC,VOLIDL,PH1,PH2,PH3)
          L1C_VOL(IC) = VOLIDL

C                            I3 
C                  PH3      ^
C                   A3     /    
C               I2 ----->I1  A1  PH1 
C                   A2     \    
C                  PH2      V
C                            I4 (Extra or forward or N (if I1-end) )
          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                DO L=1,N4
                  CORR(1) = CORR1(I)
                  CORR(2) = CORR2(J)
                  CORR(3) = CORR3(K)
                  CORR(4) = CORR4(L)
                  N       = 4
                  CALL CHK_ALT(N,CORR,CHECK)
                  IF(CHECK.EQ.'Y') THEN

                    IA1     = INAME1(I)          
                    IA2     = INAME2(J)          
                    IA3     = INAME3(K)          
                    IA4     = INAME4(L)         

                    IAA1    = S1_INEW (INAME1(I))
                    IL1     = S1_ILIB (IAA1)
                    ATYPE1  = C1_ATYPE(IAA1)
                    IAA2    = S1_INEW (INAME2(J))
                    IL2     = S1_ILIB (IAA2)
                    ATYPE2  = C1_ATYPE(IAA2)
                    IAA3    = S1_INEW (INAME3(K))
                    IL3     = S1_ILIB (IAA3)
                    ATYPE3  = C1_ATYPE(IAA3)
                    IAA4    = S1_INEW (INAME4(L))
                    IL4     = S1_ILIB (IAA4)
                    ATYPE4  = C1_ATYPE(IAA4)


                    IF(LIST.EQ.'T') THEN
                      WRITE(*,*) 'chir:',ic
                      WRITE(*,*) il1,il2,il3,il4,is
                      write(*,*) L1A_aname(IL1), L1A_aname(IL2), 
     *                L1A_aname(IL3), L1A_aname(IL4)
                    ENDIF

                    ILB  = L1A_IBACK(IL1)  
                    ILF  = L1A_IFORW(IL1)  
                    ILN  = 0
                    ILN1 = 0
                    ILN2 = 0
                    LND  = L1A_NDIST(IL1)
                    IF(LND.GT.0) THEN
                      ILN = L1A_CONN(LND,IL1)  
                      IF(LND.GT.1) THEN
                        ILN1 = L1A_CONN(LND-1,IL1)  
                        IF(LND.GT.2) THEN
                          ILN2 = L1A_CONN(LND-2,IL1)  
                        ENDIF
                      ENDIF
                    ENDIF

                    PH_IDL = PH1
                    IF(IL2.NE.ILB) THEN 
                      IF(IL3.EQ.ILB) THEN
                        IT     = IL2                       
                        IL2    = IL3
                        IL3    = IL4
                        IL4    = IT
                        IT     = IAA2                       
                        IAA2   = IAA3
                        IAA3   = IAA4
                        IAA4   = IT
                        IT     = IA2                       
                        IA2    = IA3
                        IA3    = IA4
                        IA4    = IT
                        PH_IDL = PH2
                      ELSE IF(IL4.EQ.ILB) THEN 
                        IT     = IL2                       
                        IL2    = IL4
                        IL4    = IL3
                        IL3    = IT
                        IT     = IAA2                       
                        IAA2   = IAA4
                        IAA4   = IAA3
                        IAA3   = IT
                        IT     = IA2                       
                        IA2    = IA4
                        IA4    = IA3
                        IA3    = IT
                        PH_IDL = PH3
                      ELSE
                        GO TO 400
                      ENDIF
                    ENDIF

C                   ILE extra atom
                    ILE = 0
                    NE = L1N_NCONN
                    IF(NE.GT.0) THEN
                      DO KK=1,NE
                        IF(L1N_I1ATM(KK).EQ.IL1) THEN
                          ILE = L1N_I2ATM(KK)
                        ELSE IF(L1N_I2ATM(KK).EQ.IL1) THEN
                          ILE = L1N_I1ATM(KK)
                        ENDIF
                      ENDDO
                    ENDIF

                    IF((ILE.LE.0.AND.IL4.NE.ILN).OR.
     *                 (ILE.GT.0.AND.IL4.NE.ILE)    ) THEN 
                      IT   = IL3                       
                      IL3  = IL4
                      IL4  = IT
                      IT   = IAA3                       
                      IAA3 = IAA4
                      IAA4 = IT
                      IT   = IA3                       
                      IA3  = IA4
                      IA4  = IT
                      IS   = IS*(-1)
                    ENDIF

                    ILB1  = L1A_IBACK(IL1)  
                    ILB2  = L1A_IBACK(IL2)  
                    ILB3  = L1A_IBACK(IL3)  
                    ILB4  = L1A_IBACK(IL4)  

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) 'is:',Is
                        WRITE(*,*) 'IL:',IL1,IL2,IL3,IL4
                        WRITE(*,*) 'ILB,ILE:',ILB1,ILB2,ILB3,ILB4
                        WRITE(*,*) 'ILF,ILN,ILE:',ILF,ILN,ILN1,ILN2,ILE
                      ENDIF

                    IF(IL4.NE.ILN.AND.
     *                     (ILE.GT.0.AND.IL4.NE.ILE)) GO TO 400 

                    IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *                 ATYPE3.NE.'M'.AND.ATYPE4.NE.'M'.AND.
     *            C1_OCC(IAA1).GT.0.001.AND.C1_OCC(IAA2).GT.0.001.AND.
     *            C1_OCC(IAA3).GT.0.001.AND.C1_OCC(IAA4).GT.0.001) THEN

                      CALL CALC_I_OVOL(IA1,IA2,IA3,IA4,VOLOBS,PH3)
                      PH3  = -PH3
                      VOL = VOLOBS 
                      IF(VOL.LT.-0.5) PH_IDL = -PH_IDL                     
                    ELSE
                      VOL = VOLIDL 
                      IF(IS.NE.0) PH_IDL = PH_IDL * IS
                      PH3 = PH_IDL
                    ENDIF
                      
                    ILB3  = L1A_IBACK(IL3)  
                    IF(ILB3.EQ.IL1) THEN


                      IF(LIST.EQ.'T') THEN
                        write(*,*) '--1',IL3
                      ENDIF

C                     IL3 not extra atom
C                          
                      IF(S1_ID_PSI(IAA3).EQ.'?') THEN
                        S1_PSI    (IAA3) = PH3   
C                       S1_PSI    (IAA3) = PH_IDL   
                        L1A_PHI   (IL3 ) = PH_IDL  
                        S1_ID_PSI (IAA3) = 'Co1C'
                        L1A_ID_PSI(IL3 ) = 'Co1C'
                      ENDIF
c                      S1_ID_PSI (IAA3) = 'Co1C'
c                      L1A_ID_PSI(IL3 ) = 'Co1C'

                    ENDIF
                    IF(ILN1.GT.0.OR.ILN2.GT.0) THEN
C
C                     search others
C
                      IF((IL3.EQ.ILN.OR.ILN.EQ.IL4).AND.ILN1.NE.IL3
     *                            .AND.ILN1.NE.IL4) THEN
                        IL5 = ILN1
                      ELSE
                        IL5 = ILN2
                      ENDIF

                      IF(LIST.EQ.'T') THEN
                        write(*,*) '--2',il5
                      ENDIF

                      IF(IL5.GT.0) THEN
                        ATOM5 = L1A_ANAME(IL5)
                        CALL SRCH_NUM(MDOC,ATOM5,N5,CORR5
     *                                    ,INAME5,IERR)
                        IF(N5.GT.0) THEN
                          DO M=1,N5
                            CORR(5) = CORR5(M)
                            N      = 5
                            CALL CHK_ALT(N,CORR,CHECK)
                            IF(CHECK.EQ.'Y') THEN
                              IA5     = INAME5(M)         
                              IAA5    = S1_INEW (INAME5(M))
                              ATYPE5  = C1_ATYPE(IAA5)
                              PHH = 999.0  
                              IF(ATYPE1.NE.'M'.AND.ATYPE2.NE.'M'.AND.
     *                           ATYPE4.NE.'M'.AND.ATYPE5.NE.'M'.AND.
     *            C1_OCC(IAA1).GT.0.001.AND.C1_OCC(IAA2).GT.0.001.AND.
     *            C1_OCC(IAA5).GT.0.001.AND.C1_OCC(IAA4).GT.0.001) THEN

                                CALL CALC_I_OVOL(IA1,IA2,IA5,IA4
     *                          ,VOLOBS,PH5)
                                PH5  = -PH5
                                VOL = VOLOBS 
                                IF(VOL.LT.-0.5) PH5 = -PH5
                                IF(IL4.NE.ILF) PH5 = -PH5
                                PHH = PH5
                              ENDIF

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) '--22 :',IA1,IA2,IA5,IA4,vol
                        WRITE(*,*) '--22 PH5,PHH:',PH5,PHH
                      ENDIF

C                                           I4 
C                                           ^
C                                   A1     /    
C                                I2 ----->I1  A12  PH5 
C                                   A2     \    
C                                           V
C                                            I5
C                            
C                                CALL SRCH_BOND(MDOC,MON,IL1,IL2,VAL,LB
C     *                                     ,IERR)
                              CALL SRCH_ANGL(MDOC,MON,IL2,IL1,IL4,A1
     *                                   ,LG1,IERR)
                              CALL SRCH_ANGL(MDOC,MON,IL2,IL1,IL5,A2
     *                                   ,LG2,IERR)
                              CALL SRCH_ANGL(MDOC,MON,IL4,IL1,IL5,A12
     *                                   ,LG12,IERR)
                              IERR = 0
                              A1   = A1 *PI180         
                              A2   = A2 *PI180         
                              A12  = A12*PI180         
                              CALL GET_TORS(A1,A2,A12,PH5I)
                              PH5I = PH5I/PI180         
 
                              IF(PHH.LT.999.0) THEN
                                IF(PH5.LT.0.0) PH5I = -PH5I
                              ELSE
                                PH5 = PH5I
                              ENDIF

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) '--23:',PH5I
                      ENDIF

                              IF(PH_IDL.GT.0.0) THEN
                                PH5I = -ABS(PH5I)
                                IF(PHH.GE.999.0) PH5 = PH5I
                              ENDIF

                      IF(LIST.EQ.'T') THEN
                       write(*,*) '--3',S1_ID_PSI(IAA5),PH5,PH5I
                      ENDIF
                              IF(S1_ID_PSI(IAA5).EQ.'?') THEN
                                S1_PSI    (IAA5) = PH5   
C                               S1_PSI    (IAA5) = PH5   
                                L1A_PHI   (IL5 ) = PH5I  
                                S1_ID_PSI (IAA5) = 'Co5C'
                                L1A_ID_PSI(IL5 ) = 'Co5C'
                              ENDIF
C                              S1_ID_PSI (IAA5) = 'Co5C'
C                              L1A_ID_PSI(IL5 ) = 'Co5C'

                            ENDIF
                          ENDDO
                        ENDIF
                      ENDIF
                    ENDIF

                  ENDIF
                ENDDO
              ENDDO
            ENDDO
          ENDDO

  400     CONTINUE                    
        ENDIF
        ENDDO      
      ENDIF
                     
      IF(LIST.EQ.'T') write(*,*) ' --- tree --- plan'

      CALL IPLAN_DEF_DTHPH(MDOC,IERR)

      IF(LIST.EQ.'T') write(*,*) ' --- tree --- end'

      RETURN
      END

      SUBROUTINE IPLAN_DEF_DTHPH(MDOC,IERR)
C -----------------------------------------------
C -P- IPLAN_RSTR -
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ------------------------------
      INTEGER*4 INAME(MX1ALT)
      CHARACTER CORR (MX1ALT)*2

      INTEGER*4 IATM    (MAX1APL)
      INTEGER*4 IN_PLAN (MAX1APL)
      INTEGER*4 IA_PLAN (MX1ALT,MAX1APL)
      INTEGER*4 ICORR   (MX1ALT,MAX1APL)
      INTEGER*4 IC_CODE (MAX1APL)
      INTEGER*4 IA_CODE (MAX1APL)
      CHARACTER CHAR1*1
C     CHARACTER ATYPE*1
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C --------------------------------------------------------
      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN

          IF(L1P_NATOM(IP).GT.0) THEN
            N  = 0
            NC = 0
            NA = 0  
            DO  I = 1,L1P_NATOM(IP)

              ICH4 = L1P_ATOM(I,IP)
              CALL SRCH_NUM(MDOC,CH4,NN,CORR,INAME,IERR)
              IF(NN.NE.0) THEN
                N           = N+1
                JJ          = 0
                IN_PLAN(N)  = 0
                DO J=1,NN
                  IF(CORR(J).EQ.'..') THEN
                    JJJ            = 1
                    IN_PLAN    (N) = JJJ
                    ICORR  (JJJ,N) = 0
                    IA_PLAN(JJJ,N) = INAME(J)
                    GO TO 100
                  ELSE IF(CORR(J)(1:1).NE.'.') THEN
                    JJ          = JJ+1
                    IN_PLAN (N) = JJ
                    CHAR1       = CORR(J)(1:1)
                    CALL CHTOINT(CHAR1,ICODE)
                    IA_PLAN(JJ,N) = INAME(J)
                    ICORR  (JJ,N) = ICODE
                    IF(NC.GT.0) THEN
                      DO IC=1,NC
                        IF(IC_CODE(IC).EQ.ICODE) GO TO 200
                      ENDDO
                    ENDIF
                    NC          = NC+1
                    IC_CODE(NC) = ICODE
  200               CONTINUE
                  ELSE IF(CORR(J)(2:2).NE.'.') THEN
                    JJ          = JJ+1
                    IN_PLAN (N) = JJ
                    CHAR1       = CORR(J)(2:2)
                    CALL CHTOINT(CHAR1,ICODE)
                    ICODE         =-ICODE
                    IA_PLAN(JJ,N) = INAME(J)
                    ICORR  (JJ,N) = ICODE
                    IF(NA.GT.0) THEN
                      DO IA=1,NA
                        IF(IA_CODE(IA).EQ.ICODE) GO TO 300
                      ENDDO
                    ENDIF
                    NA          = NA+1
                    IA_CODE(NA) = ICODE
  300               CONTINUE
                  ENDIF
                ENDDO
              ENDIF
  100         CONTINUE
            ENDDO
C ---  
            IF(N.GE.4) THEN
              IF(NC.EQ.0.AND.NA.EQ.0) THEN       
                NP = 0
                DO J=1,N
                  IF(IN_PLAN(J).GT.0) THEN
                    NP       = NP + 1
                    IATM(NP) = IA_PLAN(1,J)
                  ENDIF
                ENDDO
                IF(NP.GE.4) THEN

                  CALL CALC_DTP_PLAN(MDOC,NP,IATM,IERR)

                ENDIF
              ELSE
                IF(NC.GT.0) THEN       
                  DO I=1,NC
                    NP    = 0
                    ICODE = IC_CODE(I)
                    DO J=1,N
                      IF(IN_PLAN(J).GT.0) THEN
                      DO K=1,IN_PLAN(J)
                        IF(ICORR(K,J).EQ.0.OR.ICORR(K,J).EQ.ICODE) THEN
                          NP       = NP+1
                          IATM(NP) = IA_PLAN(K,J)
                          GO TO 400
                        ENDIF
                      ENDDO
                      ENDIF
  400                 CONTINUE
                    ENDDO
                    IF(NP.GE.4) THEN

                      CALL CALC_DTP_PLAN(MDOC,NP,IATM,IERR)

                    ENDIF
                  ENDDO
                ENDIF       
                IF(NA.GT.0) THEN       
                  DO I=1,NA
                    NP    = 0
                    ICODE = IA_CODE(I)
                    DO J=1,N
                      IF(IN_PLAN(J).GT.0) THEN
                      DO K=1,IN_PLAN(J)
                        IF(ICORR(K,J).EQ.0.OR.ICORR(K,J).EQ.ICODE) THEN
                          NP       = NP+1
                          IATM(NP) = IA_PLAN(K,J)
                          GO TO 500
                        ENDIF
                      ENDDO
                      ENDIF
  500                 CONTINUE
                    ENDDO
                    IF(NP.GE.4) THEN

                      CALL CALC_DTP_PLAN(MDOC,NP,IATM,IERR)

                    ENDIF
                  ENDDO
                ENDIF       
              ENDIF
            ENDIF
          ELSE
            L1P_NATOM(IP) = 0
          ENDIF
        ENDDO      
      ENDIF

      RETURN
      END

      SUBROUTINE CALC_DTP_PLAN(MDOC,N,IATM,IERR)
C -------------------------------------------------
      INTEGER*4 MDOC,N,IATM(*),IERR
C ---
      INCLUDE 'lib_com.fh'
C ----------------------------------------------
C     REAL      X(3,MAX1APL)
C     CHARACTER LINE*256
C -------------------------------------------------
C                          I2                            I2 ( Hatom)
C                          ^                            ^
C                         /                            /   
C               I1 ---->IA                    I1 ---->IA   (N=1)
C           ^             \                 /         .    
C          /               V                           . 
C       (I4)                I3(forw or N)               V
C                                                        I3 (extra)
C ------------------------
      IERR = 0

      DO  I = 1,N
        NN    = 0
        I1    = 0
        I2    = 0
        I3    = 0
        I4    = 0
        IA    = S1_INEW(IATM(I))
        ILA   = S1_ILIB(IA)
        ILB   = L1A_IBACK(ILA)
        ILF   = L1A_IFORW(ILA)
        ILN   = 0
        ILN1  = 0

        LND   = L1A_NDIST(ILA)
        IF(LND.GT.0) THEN
          ILN = L1A_CONN(LND,ILA)  
          IF(LND.GT.1) THEN
            ILN1 = L1A_CONN(LND-1,ILA)  
          ENDIF
        ENDIF

C       ILE extra atom
        ILE = 0
        NE = L1N_NCONN
        IF(NE.GT.0) THEN
          DO K=1,NE
            IF(L1N_I1ATM(K).EQ.ILA) THEN
              ILE = L1N_I2ATM(K)
            ELSE IF(L1N_I2ATM(K).EQ.ILA) THEN
              ILE = L1N_I1ATM(K)
            ENDIF
          ENDDO
        ENDIF


        ILB1 = 0
        DO  J = 1,N
          IF(J.NE.I) THEN
            JA    = S1_INEW(IATM(J))
            JLA   = S1_ILIB(JA)
            JLB   = L1A_IBACK(JLA)
            IF(ILB.EQ.JLA) THEN
              IF(I1.LE.0) NN = NN + 1
              I1   = J
              IA1  = JA
              IL1  = JLA
              ILB1 = JLB
            ELSE IF(JLB.EQ.ILA) THEN

              IF(ILN.EQ.JLA) THEN
                IF(I3.LE.0) NN = NN + 1
                I3  = J
                IA3 = JA
                IL3 = JLA
              ELSE IF(ILE.EQ.JLA.AND.LND.EQ.1) THEN
                IF(I3.LE.0) NN = NN + 1
                I3  = J
                IA3 = JA
                IL3 = JLA
              ELSE 
                IF(I2.LE.0) NN = NN + 1
                I2  = J
                IA2 = JA
                IL2 = JLA
              ENDIF

            ENDIF
          ENDIF
        ENDDO

        IF(NN.EQ.3) THEN

          I4 =0
          DO  J = 1,N
            IF(J.NE.I) THEN
              JA    = S1_INEW(IATM(J))
              JLA   = S1_ILIB(JA)
              JLB   = L1A_IBACK(JLA)
              IF(ILB1.EQ.JLA) THEN
                I4  = J
                IA4 = JA
                IL4 = JLA
              ENDIF
            ENDIF
          ENDDO
          NNN = 0

          IF(IL3.EQ.ILN) THEN

            S1_PSI    (IA2) = 180.0    
            L1A_PHI   (IL2) = 180.0  
            S1_ID_PSI (IA2) = 'Co1P'
            L1A_ID_PSI(IL2) = 'Co1P'

            IF(I4.GT.0) THEN
C             check I3
              IF(C1_OCC(IA4).GT.0.001.AND.C1_ATYPE(IA4).NE.'M'.AND.
     *           C1_OCC(IA1).GT.0.001.AND.C1_ATYPE(IA1).NE.'M'.AND.
     *           C1_OCC(IA ).GT.0.001.AND.C1_ATYPE(IA ).NE.'M'.AND.
     *           C1_OCC(IA3).GT.0.001.AND.C1_ATYPE(IA3).NE.'M'   ) THEN
                NNN = 1

                CALL CALC_ITRSOBS(IATM(I4),IATM(I1),IATM(I)
     *                           ,IATM(I3),VAL)
                ANG = 180.0
                IF(ABS(VAL).LT.90.0) ANG = 0.0 
                S1_PSI    (IA3) = ANG    
                L1A_PHI   (IL3) = ANG
                S1_ID_PSI (IA3) = 'Co2P'
                L1A_ID_PSI(IL3) = 'Co2P'

              ELSE

                CALL CHECK_RING_PH(IATM(I4),IATM(I1),IATM(I),IATM(I3)
     *                            ,VAL)
              
                S1_PSI    (IA3) = VAL   
                L1A_PHI   (IL3) = VAL
                S1_ID_PSI (IA3) = 'Co3P'
                L1A_ID_PSI(IL3) = 'Co3P'

              ENDIF
            ENDIF
          ELSE
C           I3 - extra
C           check I32
            IF(C1_OCC(IA4).GT.0.001.AND.C1_ATYPE(IA4).NE.'M'.AND.
     *         C1_OCC(IA1).GT.0.001.AND.C1_ATYPE(IA1).NE.'M'.AND.
     *         C1_OCC(IA ).GT.0.001.AND.C1_ATYPE(IA ).NE.'M'.AND.
     *         C1_OCC(IA2).GT.0.001.AND.C1_ATYPE(IA2).NE.'M'     ) THEN
              NNN = 1

              CALL CALC_ITRSOBS(IATM(I4),IATM(I1),IATM(I)
     *                         ,IATM(I2),VAL)
              ANG = 180.0
              IF(ABS(VAL).LT.90.0) ANG = 0.0 
              S1_PSI    (IA2) = ANG    
              L1A_PHI   (IL2) = ANG
              S1_ID_PSI (IA2) = 'Co4P'
              L1A_ID_PSI(IL2) = 'Co4P'

            ELSE

              CALL CHECK_RING_PH(IATM(I4),IATM(I1),IATM(I),IATM(I2),VAL)
              
C ???
              IF(L1A_SYMB(IL2)(1:2).EQ.'H '.OR.
     *           L1A_SYMB(IL2)(1:2).EQ.'D '    ) VAL = 180.0
              
              S1_PSI    (IA2) = VAL   
              L1A_PHI   (IL2) = VAL
              S1_ID_PSI (IA2) = 'Co5P'
              L1A_ID_PSI(IL2) = 'Co5P'

            ENDIF

          ENDIF
        ENDIF
      ENDDO
C
C ---------------------------------------------------------------
C
C            I3            IA(forw or N)                 I3           
C              \          /                     or        \              
C               I2 ---->I1                                I2 ---->I1  
C                                                                   \
C                                                                    IA
C                                                                (forw or N)
      DO  I = 1,N

        NN    = 0
        I1    = 0
        I2    = 0
        I3    = 0
        IA    = S1_INEW(IATM(I))
        ILA   = S1_ILIB(IA)
        ILB   = L1A_IBACK(ILA)
        ILN   = 0
        ILN1  = 0
        LND   = L1A_NDIST(ILA)
        IF(LND.GT.0) THEN
          ILN = L1A_CONN(LND,ILA)  
          IF(LND.GT.1) THEN
            ILN1 = L1A_CONN(LND-1,ILA)  
          ENDIF
        ENDIF
        DO  J = 1,N
          IF(J.NE.I) THEN
            JA  = S1_INEW(IATM(J))
            JLA = S1_ILIB(JA)
            JLB = L1A_IBACK(JLA)
            JLN   = 0
            JLN1  = 0
            LNDJ  = L1A_NDIST(JLA)
            IF(LNDJ.GT.0) THEN
              JLN = L1A_CONN(LNDJ,JLA)  
              IF(LNDJ.GT.1) THEN
                JLN1 = L1A_CONN(LNDJ-1,JLA)  
              ENDIF
            ENDIF

            IF(ILB.EQ.JLA.AND.ILA.EQ.JLN) THEN
              IF(I1.LE.0) NN = NN + 1
              I1  = JA
              IA1 = JA
              IL1 = JLA
              DO  K = 1,N
                IF(K.NE.J.AND.K.NE.I) THEN
                  KA  = S1_INEW(IATM(K))
                  KLA = S1_ILIB(KA)
                  KLB = L1A_IBACK(KLA)  
                  IF(JLB.EQ.KLA) THEN
                    IF(I2.LE.0) NN = NN + 1
                    I2  = KA
                    IA2 = KA
                    IL2 = KLA
                    DO  L = 1,N
                      IF(L.NE.J.AND.L.NE.I.AND.L.NE.K) THEN
                        LA  = S1_INEW(IATM(L))
                        LLA = S1_ILIB(LA)
                        LLB = L1A_IBACK(LLA)
                        IF(KLB.EQ.LLA) THEN
                          IF(I3.LE.0) NN = NN + 1
                          I3  = LA
                          IA3 = LA
                          IL3 = LLA
                          GO TO 100
                        ENDIF
                      ENDIF
                    ENDDO
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO
 100    CONTINUE

        IF(NN.EQ.3) THEN

          IF(C1_OCC(IA).GT.0.001.AND.C1_ATYPE(IA).NE.'M'.AND.
     *       C1_OCC(JA).GT.0.001.AND.C1_ATYPE(JA).NE.'M'.AND.
     *       C1_OCC(KA).GT.0.001.AND.C1_ATYPE(KA).NE.'M'.AND.
     *       C1_OCC(LA).GT.0.001.AND.C1_ATYPE(LA).NE.'M'     ) THEN

            CALL CALC_ITRSOBS(IATM(L),IATM(K),IATM(J),IATM(I),VAL)

            ANG = 180.0
            IF(ABS(VAL).LT.90.0) ANG = 0.0 
            S1_PSI    (IA)  = ANG    
            L1A_PHI   (ILA) = ANG
            S1_ID_PSI (IA)  = 'Co6P'
            L1A_ID_PSI(ILA) = 'Co6P'


          ELSE

            CALL CHECK_RING_PH(IATM(L),IATM(K),IATM(J),IATM(I),VAL)

C ???
            IF(L1A_SYMB(ILA)(1:2).EQ.'H '.OR.
     *         L1A_SYMB(ILA)(1:2).EQ.'D '    ) VAL = 180.0


            S1_PSI    (IA)  = VAL    
            L1A_PHI   (ILA) = VAL  
            S1_ID_PSI (IA)  = 'Co7P'
            L1A_ID_PSI(ILA) = 'Co7P'


          ENDIF

        ENDIF

      ENDDO

      RETURN
      END                

      SUBROUTINE CHECK_RING_PH(L,K,J,I,VAL)
C -------------------------
C      L -->K-->J-->I
C -------------------------
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,CHEM4*4
      CHARACTER RING1*3,RING2*3,RING3*3,RING4*3
C -------------------------
      VAL = 0.0
      LLA   = S1_INEW(L) 
      LA    = S1_ILIB(LLA)
      CHEM1 = L1A_CHEM(LA)
      CALL CHECK_RING(CHEM1,RING1)
      KKA   = S1_INEW(K)
      KA    = S1_ILIB(KKA)
      CHEM2 = L1A_CHEM(KA)
      CALL CHECK_RING(CHEM2,RING2)
      JJA   = S1_INEW(J)
      JA    = S1_ILIB(JJA)
      CHEM3 = L1A_CHEM(JA)
      CALL CHECK_RING(CHEM3,RING3)
      IIA   = S1_INEW(I)
      IA    = S1_ILIB(IIA)
      CHEM4 = L1A_CHEM(IA)
      CALL CHECK_RING(CHEM4,RING4)

      IF(RING2(1:1).EQ.'R'.AND.RING3(1:1).EQ.'R') THEN
        IF(RING2(2:2).EQ.'R'.AND.RING2(2:2).EQ.RING3(2:2)) THEN 
          VAL = 180.0
          IF(RING2(3:3).EQ.'5'.AND.RING1(2:2).EQ.RING4(2:2)) 
     *    VAL = 0.0
        ELSE IF(RING2(2:2).EQ.'R'.AND.
     *          RING2(2:2).NE.RING3(2:2)) THEN 
          IF(RING4(1:1).EQ.'R') THEN 
            VAL = 180.0
          ELSE
            VAL = 0.0
          ENDIF
        ELSE IF(RING3(2:2).EQ.'R'.AND.
     *          RING2(2:2).NE.RING3(2:2)) THEN 
          IF(RING1(1:1).EQ.'R') THEN 
            VAL = 180.0
          ELSE
            VAL = 0.0
          ENDIF
        ELSE
          IF(RING1(1:1).EQ.RING4(1:1)) THEN 
            VAL = 0.0
          ELSE
            VAL = 180.0
          ENDIF
        ENDIF
      ENDIF

      RETURN
      END

      SUBROUTINE CHK_ALT(N,CORR,CHECK)
C -----------------------------------------------
C -P- CHK_ALT - 
C -S-
      INTEGER*4 I
      CHARACTER CORR(*)*2
      CHARACTER CHECK*1
C -------------------------
      CHARACTER LETT*1
C --------------------------
      CHECK = 'N'
      LETT  = '.'
      DO I=1,N
        IF(CORR(I)(1:1).NE.LETT.AND.CORR(I)(1:1).NE.'.') 
     *  LETT=CORR(I)(1:1)
      ENDDO
      IF(LETT.NE.'.') THEN
        DO I=1,N
          IF(CORR(I)(1:1).NE.LETT.AND.CORR(I).NE.'..') GO TO 100
        ENDDO
      ENDIF
      IF(LETT.EQ.'.') THEN
        LETT = '.'
        DO I=1,N
          IF(CORR(I)(2:2).NE.LETT.AND.CORR(I)(2:2).NE.'.') 
     *    LETT=CORR(I)(2:2)
        ENDDO
        IF(LETT.NE.'.') THEN
          DO I=1,N
            IF(CORR(I)(2:2).NE.LETT.AND.CORR(I).NE.'..') GO TO 100
          ENDDO
        ENDIF
      ENDIF
      CHECK = 'Y'
  100 CONTINUE
      RETURN
      END

C ******
      SUBROUTINE SRCH_NUM(MDOC,NAME,N,CORR,INAME,IERR)
C -----------------------------------------------
C -P- SRCH_NUM - 
C -S-
      INTEGER*4 MDOC,IERR,INAME(*)
      CHARACTER NAME*(*),CORR(*)*2
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C --------------------------
      IERR = 0
      N    = 0
      IF(C1_IGATM.GT.0) THEN
      DO   I=1,C1_IGATM
        IC = S1_INEW(I)

        IF(NAME(1:4).EQ.C1_ANAME(IC).AND.
     *           C1_ATYPE(IC).NE.'U'.AND.C1_ATYPE(IC).NE.'D') THEN

          N            = N + 1
          CORR(N)(2:2) = C1_ALT (IC)
          CORR(N)(1:1) = C1_CORR(IC)

          INAME(N)     = I

          IF(C1_NALT(IC).GT.1) THEN
            DO  J=1,C1_IGATM
              JC = S1_INEW(J)
              IF(C1_IALT(JC).EQ.IC) THEN
                IF(N.GE.MX1ALT) THEN
                  WRITE(LINE,'(A,I6)')' ERR: number of alt. positions >'
     *            ,MX1ALT
                  CALL MSGERR(MDOC,LINE)
                  CALL MSGERR(MDOC
     * ,'         Change parameter MX1ALT in "lib_com.fh"')
                  IERR=1
                ENDIF
                N            = N + 1
                CORR(N)(2:2) = C1_ALT (JC)
                CORR(N)(1:1) = C1_CORR(JC)

                INAME(N)     = J

              ENDIF
            ENDDO 
          ENDIF
          GO TO 100
        ENDIF
      ENDDO
      ENDIF
100   CONTINUE
      RETURN
      END

C ******
      SUBROUTINE CALC_IDOBS(I1,I2,DOBS)
C -----------------------------------------------
C -P- CALC_IDOBS - 
C -S-
C            IA1        IA2 
C            I2 < - 2 -> I1 
C
      REAL      DOBS
      INTEGER*4 I1,I2
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
      DOBS = 0.0
      IA1  = S1_INEW(I1)
      IA2  = S1_INEW(I2)
      IF(C1_OCC(IA1).LT.0.001) RETURN
      IF(C1_OCC(IA2).LT.0.001) RETURN
      X1   = C1_XYZ(1,IA1)
      Y1   = C1_XYZ(2,IA1)
      Z1   = C1_XYZ(3,IA1)
      X2   = C1_XYZ(1,IA2)
      Y2   = C1_XYZ(2,IA2)
      Z2   = C1_XYZ(3,IA2)
      DX   = X1-X2
      DY   = Y1-Y2
      DZ   = Z1-Z2
      DOBS = SQRT(DX*DX+DY*DY+DZ*DZ)
      RETURN
      END

C ******
      SUBROUTINE CALC_IANGOBS(I1,I2,I3,ANGOBS)
C -----------------------------------------------
C -P- CALC_IANGOBS - 
C -S-
C              IA1         IA2        IA3
C               I1 <- 1 -> I2  <- 2 -> I3 
C
      REAL      ANGOBS
      INTEGER*4 I1,I2,I3
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      ANGOBS = 0.0

      IA1 = S1_INEW(I1)
      IA2 = S1_INEW(I2)
      IA3 = S1_INEW(I3)
      IF(C1_OCC(IA1).LT.0.001) RETURN
      IF(C1_OCC(IA2).LT.0.001) RETURN
      IF(C1_OCC(IA3).LT.0.001) RETURN
      X1  = C1_XYZ(1,IA1)
      Y1  = C1_XYZ(2,IA1)
      Z1  = C1_XYZ(3,IA1)
      X2  = C1_XYZ(1,IA2)
      Y2  = C1_XYZ(2,IA2)
      Z2  = C1_XYZ(3,IA2)
      X3  = C1_XYZ(1,IA3)
      Y3  = C1_XYZ(2,IA3)
      Z3  = C1_XYZ(3,IA3)

      A3  = X3-X2
      B3  = Y3-Y2
      C3  = Z3-Z2
      IF(IA1.EQ.0) THEN
        A2 = 1.
        B2 = 0.
        C2 = 0.
      ELSE
        A2 = X2-X1
        B2 = Y2-Y1
        C2 = Z2-Z1
      ENDIF
      AMOD   = SQRT(A2*A2+B2*B2+C2*C2)*SQRT(A3*A3+B3*B3+C3*C3)
      IF(AMOD.LT.1.0E-8) AMOD = 1.0
      COST   = (A3*A2+B3*B2+C3*C2)/AMOD
      IF(COST.GT. 1.0) COST = 1.0      
      IF(COST.LT.-1.0) COST =-1.0
      ANGOBS = ACOS(COST)
      ANGOBS = PI-ANGOBS
      IF(ANGOBS.GT.PI)  ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LE.-PI) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180

      RETURN
      END

C ******
      SUBROUTINE CALC_ITRSOBS(I1,I2,I3,I4,ANGOBS)
C -----------------------------------------------
C -P- CALC_ITRSOBS - 
C -S-
C               I1         I2        I3       I4
C                * - 1 ->  *  - 2 ->  * - 3 -> *
C
      REAL      ANGOBS
      INTEGER*4 I1,I2,I3,I4
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      ANGOBS = 0.0

      IA1 = S1_INEW(I1)
      IA2 = S1_INEW(I2)
      IA3 = S1_INEW(I3)
      IA4 = S1_INEW(I4)
      IF(C1_OCC(IA1).LT.0.001) RETURN
      IF(C1_OCC(IA2).LT.0.001) RETURN
      IF(C1_OCC(IA3).LT.0.001) RETURN
      IF(C1_OCC(IA4).LT.0.001) RETURN
      X1 = C1_XYZ(1,IA1)
      Y1 = C1_XYZ(2,IA1)
      Z1 = C1_XYZ(3,IA1)
      X2 = C1_XYZ(1,IA2)
      Y2 = C1_XYZ(2,IA2)
      Z2 = C1_XYZ(3,IA2)
      X3 = C1_XYZ(1,IA3)
      Y3 = C1_XYZ(2,IA3)
      Z3 = C1_XYZ(3,IA3)
      X4 = C1_XYZ(1,IA4)
      Y4 = C1_XYZ(2,IA4)
      Z4 = C1_XYZ(3,IA4)

      A3 = X4-X3
      B3 = Y4-Y3
      C3 = Z4-Z3
      IF(IA2.EQ.0) THEN
        A2 = 1.
        B2 = 0.
        C2 = 0.
        A1 = 1.
        B1 =-1.
        C1 = 0.
      ELSE
        A2 = X3-X2
        B2 = Y3-Y2
        C2 = Z3-Z2
        IF(IA1.EQ.0) THEN
          A1 = 1.
          B1 = 0.
          C1 = 0.
        ELSE
          A1 = X2-X1
          B1 = Y2-Y1
          C1 = Z2-Z1
        ENDIF
      ENDIF
      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z)
      E3   = SQRT(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z)
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG = 1.
        IF(E1.LT.0.) COSG =-1.
      ELSE
        COSG = E1/(E2*E3)
      ENDIF
C---------------NOW WE ARE CALCULATING MIXED VECTORS------------------
C-----ABC=A1*(B2*C3-B3*C2)-A2*(B1*C3-B3*C1)+A3*(B1*C2-B2*C1) !-------
C------------------------------------------------------------------
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
      IF(ANGOBS.GT. PI) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LE.-PI) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180

      IF(ABS(ABS(ANGOBS)-180.0).LT.0.1) THEN
        ANGOBS = 180.0
      ENDIF
      IF(ABS(ANGOBS).LT.0.1) THEN
        ANGOBS = 0.0
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE CALC_I_OVOL(I1,I2,I3,I4,VOLOBS,PH)
C -----------------------------------------------
C -P- CALC_I_OVOL - 
C -S-
C              
C                                V2 -> I3  !
C               I2 - V1 -> I1  <           ! ph
C                                V3 -> I4  V
C
      REAL      VOLOBS
      INTEGER*4 I1,I2,I3,I4
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
      REAL  A(9)
      REAL  V1(3),V2(3),V3(3),VT(3),V12(3),V13(3)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      VOLOBS = 0.0
      PH     = 0.0

      IA1  = S1_INEW(I1)
      IA2  = S1_INEW(I2)
      IA3  = S1_INEW(I3)
      IA4  = S1_INEW(I4)

      IF(C1_OCC(IA1).LT.0.001) GO TO 300
      IF(C1_OCC(IA2).LT.0.001) GO TO 300
      IF(C1_OCC(IA3).LT.0.001) GO TO 300
      IF(C1_OCC(IA4).LT.0.001) GO TO 300

      A(1) = C1_XYZ(1,IA2)-C1_XYZ(1,IA1)
      A(4) = C1_XYZ(2,IA2)-C1_XYZ(2,IA1)
      A(7) = C1_XYZ(3,IA2)-C1_XYZ(3,IA1)
      A(2) = C1_XYZ(1,IA3)-C1_XYZ(1,IA1)
      A(5) = C1_XYZ(2,IA3)-C1_XYZ(2,IA1)
      A(8) = C1_XYZ(3,IA3)-C1_XYZ(3,IA1)
      A(3) = C1_XYZ(1,IA4)-C1_XYZ(1,IA1)
      A(6) = C1_XYZ(2,IA4)-C1_XYZ(2,IA1)
      A(9) = C1_XYZ(3,IA4)-C1_XYZ(3,IA1)

      VOLOBS = A(1)*(A(5)*A(9)-A(8)*A(6))
     *       - A(4)*(A(2)*A(9)-A(8)*A(3))
     *       + A(7)*(A(2)*A(6)-A(5)*A(3))

      PH    = 0.0

      II1   = IA2
      II2   = IA1
      II3   = IA3
      II4   = IA4

      V1(1) = C1_XYZ(1,II2) - C1_XYZ(1,II1) 
      V1(2) = C1_XYZ(2,II2) - C1_XYZ(2,II1) 
      V1(3) = C1_XYZ(3,II2) - C1_XYZ(3,II1) 
      V2(1) = C1_XYZ(1,II3) - C1_XYZ(1,II2) 
      V2(2) = C1_XYZ(2,II3) - C1_XYZ(2,II2) 
      V2(3) = C1_XYZ(3,II3) - C1_XYZ(3,II2) 
      V3(1) = C1_XYZ(1,II4) - C1_XYZ(1,II2) 
      V3(2) = C1_XYZ(2,II4) - C1_XYZ(2,II2) 
      V3(3) = C1_XYZ(3,II4) - C1_XYZ(3,II2) 

      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VMOD(V3,AV3)
      CALL NB_VMULT(V1,V2,V12)
      CALL NB_VMOD(V12,AV12)
      CALL NB_VMULT(V1,V3,V13)
      CALL NB_VMOD(V13,AV13)

      IF(AV12.LE.0.0.OR.AV13.LE.0.0) GO TO 200

      CALL NB_VPROD(V12,V13,ACOS23)

      T = AV12*AV13
      IF(ABS(T).LT.1.0E-8) T = 1.0
      ACOS23 = ACOS23/T


      IF(ACOS23.GT. 1.0) ACOS23 = 1.0      
      IF(ACOS23.LT.-1.0) ACOS23 =-1.0
      
      PH     = ACOS(ACOS23) 


      CALL NB_VMULT(V1,V2,VT)
      CALL NB_VPROD(VT,V3,TEST)


      IF(TEST.LT.0.0) PH = -PH


      IF(PH.GT. PI) PH = PH - TWOPI        
      IF(PH.LE.-PI) PH = PH + TWOPI        

      PH = PH/PI180

      RETURN

 200  CONTINUE

      RETURN

 300  CONTINUE

      RETURN

      END

      SUBROUTINE CALC_DIST_ANGL(ANG,DEV,ATM1,ATM2,ATM3,DIST,DESD)
C -----------------------------------------------
C -P- 
C -S-
C        
      CHARACTER ATM1*4,ATM2*4,ATM3*4
      REAL      ANG,DEV,DESD
C     REAL      DICT
C     INTEGER*4 IG
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
C     TWOPI = 2.0*PI
      PI180 = PI/180.0
      I1    = 0
      I2    = 0
  
      IF(L1B_NBOND.GT.0) THEN
        DO  IB=1,L1B_NBOND
          IF(I1.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.ATM1 .AND.
     *          L1B_2ATM(IB).EQ.ATM2).OR.
     *         (L1B_1ATM(IB).EQ.ATM2 .AND.
     *          L1B_2ATM(IB).EQ.ATM1)    ) THEN
              V1 = L1B_VAL(IB)
              I1=1
            ENDIF  
          ENDIF  
          IF(I2.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.ATM2 .AND.
     *          L1B_2ATM(IB).EQ.ATM3).OR.
     *         (L1B_1ATM(IB).EQ.ATM3 .AND.
     *          L1B_2ATM(IB).EQ.ATM2)    ) THEN
              V2 = L1B_VAL(IB)
              I2=1
            ENDIF  
          ENDIF
          IF(I1.EQ.1.AND.I2.EQ.1) GO TO 100 
        ENDDO
      ENDIF
      GO TO 1000
  100 CONTINUE                    

      ANGL = ANG*PI180
      DEVI = DEV*PI180
      COSA = COS(ANGL)
      DIST = SQRT(V1*V1 + V2*V2 - 2.0*V1*V2*COSA)
      A    = ANGL+DEVI
      COSA = COS(A)
      D1   = SQRT(V1*V1+V2*V2 - 2.0*V1*V2*COSA)
      A    = ANGL-DEVI
      COSA = COS(A)
      D2   = SQRT(V1*V1+V2*V2 - 2.0*V1*V2*COSA)
      DESD = (ABS(DIST-D1)+ABS(DIST-D2))/2.0
      RETURN

 1000 CONTINUE
      DIST = 0.0
      DESD = 0.0
      RETURN
      END

C ******
      SUBROUTINE CALC_DIST_TORS(ANG,DEV
     *            ,ATM1,ATM2,ATM3,ATM4,DIST,DESD)
C -----------------------------------------------
C -P- 
C -S-
C
      REAL      DIST,DEV
C     INTEGER*4 IC
      CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
C     TWOPI = 2.0*PI
      PI180 = PI/180.0

      I1 = 0
      I2 = 0
      I3 = 0
      IF(L1B_NBOND.GT.0.AND.L1G_NANGL.GT.0) THEN
        DO  IB=1,L1B_NBOND
          IF(I1.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.ATM1 .AND.
     *          L1B_2ATM(IB).EQ.ATM2).OR.
     *         (L1B_1ATM(IB).EQ.ATM2 .AND.
     *          L1B_2ATM(IB).EQ.ATM1)    ) THEN
              AV1 = L1B_VAL(IB)
              I1  = 1
            ENDIF  
          ENDIF  
          IF(I2.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.ATM2 .AND.
     *          L1B_2ATM(IB).EQ.ATM3).OR.
     *         (L1B_1ATM(IB).EQ.ATM3 .AND.
     *          L1B_2ATM(IB).EQ.ATM2)    ) THEN
              AV2 = L1B_VAL(IB)
              I2  = 1
            ENDIF  
          ENDIF  
          IF(I3.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.ATM3 .AND.
     *          L1B_2ATM(IB).EQ.ATM4).OR.
     *         (L1B_1ATM(IB).EQ.ATM4 .AND.
     *          L1B_2ATM(IB).EQ.ATM3)    ) THEN
              AV3 = L1B_VAL(IB)
              I3  = 1
            ENDIF  
          ENDIF  
          IF(I1.EQ.1.AND.I2.EQ.1.AND.I3.EQ.1) GO TO 100 
        ENDDO
        GO TO 1000
  100   CONTINUE                    
        I1 = 0
        I2 = 0
        DO  IG=1,L1G_NANGL
          IF(I1.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.ATM3 .OR.
     *         L1G_1ATM(IG).EQ.ATM1)  THEN
              IF(L1G_2ATM(IG).EQ.ATM2) THEN
                IF(L1G_3ATM(IG).EQ.ATM3 .OR.
     *             L1G_3ATM(IG).EQ.ATM1)  THEN
c                  ANG1 = L1G_VAL(IG)*PI180
                  ANG1 = L1G_VAL(IG)
                  I1=1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I2.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.ATM2 .OR.
     *         L1G_1ATM(IG).EQ.ATM4)  THEN
              IF(L1G_2ATM(IG).EQ.ATM3) THEN
                IF(L1G_3ATM(IG).EQ.ATM2 .OR.
     *             L1G_3ATM(IG).EQ.ATM4)  THEN
c                  ANG2 = L1G_VAL(IG)*PI180
                  ANG2 = L1G_VAL(IG)          
                  I2=1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I1.EQ.1.AND.I2.EQ.1) GO TO 200 
        ENDDO
        GO TO 1000
  200   CONTINUE
                    

        PHI   = ANG * PI180
        DPHI  = DEV * PI180
        ANG1  = ANG1* PI180
        ANG2  = ANG2* PI180

 
        CALL DIST_14(AV1,AV2,AV3,ANG1,ANG2,PHI,DIST)

        A = PHI+DPHI
        CALL DIST_14(AV1,AV2,AV3,ANG1,ANG2,A,D1)
        A = PHI-DPHI
        CALL DIST_14(AV1,AV2,AV3,ANG1,ANG2,A,D2)      

        DESD = (ABS(DIST-D1)+ABS(DIST-D2))/2.0

        RETURN
      ENDIF
 1000 CONTINUE
      DIST = 0.0
      DESD = 0.0
      RETURN
      END


      SUBROUTINE DIST_14(AV1,AV2,AV3,ANG1,ANG2,PHI,DIST)
C --------------------
      REAL V1(3),V2(3),V3(3),N12(3),P12(3),V23(3)
     *    ,VP3(3),VN3(3),VS(3),X(3)
C --------------------
      COSA1  = COS(ANG1)
      COSA2  = COS(ANG2)
      SINA1  = SIN(ANG1)
      SINA2  = SIN(ANG2)
      COSPHI = COS(PHI)
      SINPHI = SIN(PHI)
      V1(1)  = AV1
      V1(2)  = 0.0
      V1(3)  = 0.0
      V2(1)  =-AV2*COSA1
      V2(2)  = AV2*SINA1
      V2(3)  = 0.0
C --
      CALL NB_VMULT(V1,V2,X)
      CALL NB_VUNIT(X,N12,JERR)
      CALL NB_VMULT(N12,V2,X)
      CALL NB_VUNIT(X,P12,JERR)

      AP23 = AV3*SINA2
      T  = AV2
      IF(ABS(T).LT.1.0E-8) T = 1.0      
      T = (AV3*(-COSA2))/T
      CALL NB_VSCAL(V2,T,V23)
      T1 = AP23*COSPHI
      CALL NB_VSCAL(P12,T1,VP3)
      T1 = AP23*SINPHI
      CALL NB_VSCAL(N12,T1,VN3)

      CALL NB_VADD(V23,VP3,X)
      CALL NB_VADD(X,VN3,V3)

      CALL NB_VADD(V1,V2,X)
      CALL NB_VADD(X,V3,VS)
C --
      CALL NB_VMOD(VS,DIST)
C --------------------------- 
      RETURN
      END

C ******
      SUBROUTINE CALC_IPLDEV(N,NN,IATM,DOBS)
C -----------------------------------------------
C -P- CALC_IPLDEV - 
C -S-
      INTEGER*4 N,IATM(*)
      REAL      DOBS(*)
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
      REAL      X(3,MAX1APL),DEL(MAX1APL),VM(3)
      INTEGER   NUMBER(MAX1APL)
      CHARACTER ATYPE*1
C -------------------------------------------------
      NN = 0
      DO  I = 1,N
        IA      = S1_INEW(IATM(I))
        DOBS(I) = 0.0
        ATYPE   = C1_ATYPE(IA)
        IF(C1_OCC(IA).GT.0.001.AND.ATYPE.NE.'M') THEN
          NN         = NN + 1
          NUMBER(NN) = I
          X(1,NN)    = C1_XYZ(1,IA)
          X(2,NN)    = C1_XYZ(2,IA)
          X(3,NN)    = C1_XYZ(3,IA)
        ENDIF
      ENDDO

      IF(NN.GE.4) THEN

        CALL FIT_PLANE(NN,X,VM,D)

        DO  I = 1,NN
          DEL(I) = 0
          DO J=1,3
            DEL(I) = DEL(I)+VM(J)*X(J,I)
          ENDDO
          K       = NUMBER(I)
          DOBS(K) = DEL(I)-D
        ENDDO

      ELSE

        DO  I = 1,N
          DOBS(I) = 0.0
        ENDDO

      ENDIF

      RETURN
      END      

      SUBROUTINE DSCR_LINKS(MDOC,LIST,LINK,LID,CONN_FLAG
     *                           ,IG1,IRES1,IG2,IRES2,IERR)
C -----------------------------------------------
C -P- DSCR_LINKS -
C -S-
      INTEGER*4 MDOC,IERR,LID
      CHARACTER LINK*8,CONN_FLAG*1,LIST*1
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ----
      INTEGER*4 INAME1(MX1ALT)
      CHARACTER CORR1(MX1ALT)*2
      INTEGER*4 INAME2(MX1ALT)
      CHARACTER CORR2(MX1ALT)*2
      INTEGER*4 INAME3(MX1ALT)
      CHARACTER CORR3(MX1ALT)*2
      INTEGER*4 INAME4(MX1ALT)
      CHARACTER CORR4(MX1ALT)*2
      CHARACTER CHECK*1
      CHARACTER CORR(MAX1APL)*2
      INTEGER*4 IAT1(MX1ALT)
      INTEGER*4 IAT2(MX1ALT)
      INTEGER*4 IAT3(MX1ALT)
      INTEGER*4 IAT4(MX1ALT)
      REAL      X1(3,MAX1APL),X2(3,MAX1APL),X3(3,MAX1APL)
     *         ,X4(3,MAX1APL)
C -----------------------------------
      REAL      SD
      INTEGER*4 IPERIOD,IFL(4)
      CHARACTER ALT1*1,ALT2*1,ALT3*1,ALT4*1,LCHEM(4)*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,MON(4)*8,MON1*8,MON2*8
      CHARACTER LATOM1*4,LATOM2*4
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4,LATOM(4)*4
      CHARACTER LMON1*8,LMOD1*8,LTYPE1*8,LMON2*8,LMOD2*8,LTYPE2*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4,TYPE*8,SIGN*8
      CHARACTER LABEL*8,NAMEB*4,NAMEG*4,NAMET*4,NAMEC*4,NAMEP*4
      CHARACTER ALTS*1,ATOMS1*4,ATOMS2*4,ALTS1*1,ALTS2*1
      CHARACTER ALT1_OUT*10,ALT2_OUT*10
      CHARACTER ALT_OUT*10
      CHARACTER LINE*256
      DATA NAMEB/'BOND'/,NAMEG/'ANGL'/,NAMET/'TORS'/
      DATA NAMEC/'CHIR'/,NAMEP/'PLAN'/
C --------------------------------------------------------
      IERR     = 0
      ALTS     = '.'
      ALTS1    = '.'
      ALTS2    = '.'
      ATOMS1   = ' '
      ATOMS2   = ' '
      LIDS     = 0
      NL_OUT   = 0
      ALT_OUT  = ' '
      ALT1_OUT = ' '
      ALT2_OUT = ' '
      LABEL    = ' '
      IF(LLL_NLINK.LE.0) THEN
        CALL MSGDOC(MDOC,
     * ' WARNING : number of links in library = 0')
        IERR=0
        RETURN
      ENDIF
      DO   L=1,LLL_NLINK
        IF(LINK.EQ.LLL_LNAME(L)) THEN
          LLL_ILINK = L
          GO TO 600
        ENDIF
      ENDDO
      WRITE(LINE
     *  ,'('' WARNING : link '',A8,'' not found in library.'')')
     *  LINK
      CALL MSGDOC(MDOC,LINE)
      IERR = 0
      RETURN
  600 CONTINUE
      IF(LINK.EQ.'gap') RETURN

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '--- link ---:',IRES1,'-->',IRES2
      ENDIF

      MON1 = RES_NAME(IRES1)
      MON2 = RES_NAME(IRES2)

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) 'M1,M2,IG1,IG2:',MON1,MON2,IG1,IG2
      ENDIF


      LATOM1 = '.'
      LATOM2 = '.'
      LIDS   = 0
      IF(LID.GT.0.AND.LID.LE.LN_N) THEN
        IF(LN_USED(LID).EQ.'S') THEN
          ATOMS1 = LN_ATOM1(LID)
          ATOMS2 = LN_ATOM2(LID)
          ALTS1  = LN_ALT1 (LID)     
          ALTS2  = LN_ALT2 (LID)      
          LIDS   = 1

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) 'Spec link:',link,atoms1,alts1,atoms2,alts2
          ENDIF

        ELSE

          LATOM1 = LN_ATOM1(LID)
          LATOM2 = LN_ATOM2(LID)

        ENDIF

      ENDIF

      L  = LLL_ILINK

      LA = LLL_IATOM(L)
      LN = LLL_ICONN(L)
      LB = LLL_IBOND(L)
      LG = LLL_ITHET(L)
      LT = LLL_ITORS(L)
      LP = LLL_IPLAN(L)
      LC = LLL_ICHIR(L)

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(7i5)') LA,LN,LB,LG,LT,LP,LC
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      LMON1  = LLL_MON1 (L)
      LMOD1  = LLL_MOD1 (L)
      LTYPE1 = LLL_TYPE1(L)

      LMON2  = LLL_MON2 (L)
      LMOD2  = LLL_MOD2 (L)
      LTYPE2 = LLL_TYPE2(L)

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) 'LM1,LM2:',LMON1,LMON2
      ENDIF

      CALL WRT_T_L(MDOC,LINK,IERR)
      IF(IERR.NE.0) RETURN

      IFIRST = 0
      IF(LB.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MDOC,' --dl bond')
        ENDIF

        DO  IB=LB,LLB_NBOND
        IF(LINK.EQ.LLB_LNAME(IB)) THEN


          ATM1   = LLB_1ATM (IB)   
          IFLAG1 = LLB_F1ATM(IB)
          ATM2   = LLB_2ATM (IB)
          IFLAG2 = LLB_F2ATM(IB)
          VAL    = LLB_VAL  (IB)
          DEV    = LLB_DEV  (IB)
          TYPE   = LLB_TYPE (IB)
c          if(trim(link).eq.'SERTYR') then
c             write(*,*)atm1,iflag1,atm2,iflag2,val,dev,type 
c          endif
          IF(IFIRST.EQ.0) THEN
            IF(LID.LE.0) THEN
              IF(IFLAG1.EQ.1) THEN
                LATOM1 = LLB_1ATM(IB)
                LATOM2 = LLB_2ATM(IB)
              ELSE
                LATOM1 = LLB_2ATM(IB)
                LATOM2 = LLB_1ATM(IB)
              ENDIF
            ENDIF

            NL_OUT = 0
            IF(LN_N.GT.0) THEN      
              DO L=1,LN_N
                IF(IG1.EQ.LN_1ICHN(L).AND.IG2.EQ.LN_2ICHN(L).AND.
     *            ((IRES1.EQ.LN_1IRES(L).AND.IRES2.EQ.LN_2IRES(L)).OR.
     *            (IRES1.EQ.LN_2IRES(L).AND.IRES2.EQ.LN_1IRES(L)) ).AND.
     *             LN_USED(L).EQ.'S'.AND.L.NE.LID                 ) THEN
                  IF(LATOM1.EQ.LN_ATOM1(L).AND.
     *               LATOM2.EQ.LN_ATOM2(L).AND.NL_OUT.LT.10) THEN
                    NL_OUT = NL_OUT+1
                    ALT1_OUT(NL_OUT:NL_OUT) = LN_ALT1(L)         
                    ALT2_OUT(NL_OUT:NL_OUT) = LN_ALT2(L)         
                  ENDIF
                ENDIF
              ENDDO
            ENDIF

            IFIRST = 1
          ENDIF

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) 'A1,A2:',ATM1,ATM2
            WRITE(*,*) 'LA1,LA2:',LATOM1,LATOM2
            WRITE(*,*) 'NL_OUT:',NL_OUT
            WRITE(*,*) 'AL1_out:',ALT1_OUT,';'          
            WRITE(*,*) 'AL2_out:',ALT2_OUT,';'
          ENDIF

          IF(IFLAG1.EQ.1) THEN
            ALTS = '.'
            IF(ATM1.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM1.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF

            CALL SRCH_NUM2(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)

            IF(LIST.EQ.'T') THEN
              write(*,*) '11:',nout,atm1,iflag1,latom1,alt_out,n1
            ENDIF

            IGLOB1 = C2_IGLOBAL
            IF(N1.GT.0) THEN
              IA1    = S2_INEW(INAME1(1))
              CHEM1  = S2_CHEM (IA1)
              MON(1) = C2_RNAME
              IFL(1) = 2
            ENDIF
          ELSE
            ALTS = '.'
            IF(ATM1.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM1.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF

            CALL SRCH_NUM1(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)

            IF(LIST.EQ.'T') THEN
              write(*,*) '1:',nout,atm1,iflag1,latom1,alt_out,n1
            ENDIF

            IGLOB1 = C1_IGLOBAL
            IF(N1.GT.0) THEN
              IA1    = S1_INEW(INAME1(1))
              CHEM1  = S1_CHEM (IA1)
              MON(1) = C1_RNAME
              IFL(1) = 1
            ENDIF
          ENDIF
c          if(trim(link).eq.'SERTYR') then
c             write(*,*)n1
c             stop
c          endif
          IF(N1.LE.0) GO TO 100

          IF(IFLAG2.EQ.1) THEN
            ALTS = '.'
            IF(ATM2.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM2.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)

            IF(LIST.EQ.'T') THEN
              write(*,*) '22:',nout,atm2,iflag2,latom2,alt_out,n2
            ENDIF

            IGLOB2 = C2_IGLOBAL
            IF(N2.GT.0) THEN
              IA2    = S2_INEW(INAME2(1))
              CHEM2  = S2_CHEM (IA2)
              MON(2) = C2_RNAME
              IFL(2) = 2
            ENDIF
          ELSE
            ALTS = '.'
            IF(ATM2.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM2.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)

            IF(LIST.EQ.'T') THEN
              write(*,*) '2:',nout,atm2,iflag2,latom2,alt_out,n2
            ENDIF

            IGLOB2 = C1_IGLOBAL
            IF(N2.GT.0) THEN
              IA2    = S1_INEW(INAME2(1))
              CHEM2  = S1_CHEM (IA2)
              MON(2) = C1_RNAME
              IFL(2) = 1
            ENDIF
          ENDIF
          IF(N2.LE.0) GO TO 100

          ECONST = 0.0
          DO K=1,LEB_NBOND
          IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *       (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1)) THEN
              ECONST = LEB_CONST(K) 
              GO TO 500
            ENDIF
          ENDDO
 500      CONTINUE

          DO I=1,N1
            DO J=1,N2
              CORR(1) = CORR1(I)
              CORR(2) = CORR2(J)

              IWREST  = 0
              N       = 2
              CALL CHK_ALT(N,CORR,CHECK)

             IF(LID.GT.0.AND.LID.LE.LN_N) THEN
             IF(LN_USED(LID).EQ.'S'.AND.
     *           (ALTS1.NE.ALTS2.AND.
     *            ALTS1.NE.'.'.AND.ALTS2.NE.'.').AND.
     *           (ALTS1.EQ.CORR(1)(2:2).AND.
     *            ALTS2.EQ.CORR(2)(2:2)     )) THEN
                CHECK = 'Y'
              ENDIF
              ENDIF

              IF(CHECK.EQ.'Y') THEN


                IF(IAT1(I).GT.0.AND.IAT2(J).GT.0) THEN
                  CALL CALC_IDOBS_L(INAME1(I),INAME2(J)
     *            ,X1(1,I),X2(1,J),DOBS)
                  IWREST = 1
                ELSE
                  DOBS = VAL
                ENDIF
                IF(LID.LE.0) THEN
                  IA1 = INAME1(I)+IGLOB1          
                  IA2 = INAME2(J)+IGLOB2          
                ELSE
                  IA1 = IAT1(I)         
                  IA2 = IAT2(J)         
               ENDIF
                IA3 = 0
                IA4 = 0

                ATOM1 = ATM1
                ALT1  = CORR(1)(2:2)
                ATOM2 = ATM2 
                ALT2  = CORR(2)(2:2)
                ATOM3 = ' '  
                ALT3  = ' '
                ATOM4 = ' '  
                ALT4  = ' '
                DIST  = 0.0
                DESD  = 0.0

                IPERIOD = 0

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(2i5)') IA1,IA2
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'('':'',A,'':'',A,'':'')') ATOM1,ATOM2
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'('':'',A,'':'',A,'':'')') ALT1,ALT2
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'('':'',A,'':'',A,'':'')') 
     *  CORR(1),CORR(2)
        CALL MSGDOC(MDOC,LINE)
      ENDIF



                IF(IWREST.GT.0) THEN
                  CALL WRESTR(MDOC,NAMEB,TYPE,IA1,IA2,IA3,IA4 
     *            ,VAL,DEV,DOBS,IPERIOD
     *            ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *            ,ALT1,ALT2,ALT3,ALT4,IERR)
                ENDIF

              ENDIF
            ENDDO
          ENDDO
  100     CONTINUE
                    
        ENDIF
        ENDDO      
      ENDIF
      IF(IFIRST.EQ.0) RETURN

      IF(LG.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MDOC,' --dl angl')
        ENDIF

        DO  IG=LG,LLG_NANGL
        IF(LINK.EQ.LLG_LNAME(IG)) THEN

          ATM1     = LLG_1ATM (IG)   
          IFLAG1   = LLG_F1ATM(IG)
          ATM2     = LLG_2ATM (IG)
          IFLAG2   = LLG_F2ATM(IG)
          ATM3     = LLG_3ATM (IG)
          IFLAG3   = LLG_F3ATM(IG)
          VAL      = LLG_VAL  (IG)
          DEV      = LLG_DEV  (IG)
          LATOM(1) = ATM1
          LATOM(2) = ATM2
          LATOM(3) = ATM3

          IF(IFLAG1.EQ.1) THEN
            ALTS = '.'
            IF(ATM1.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM1.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB1 = C2_IGLOBAL
            IF(N1.GT.0) THEN
              IA1    = S2_INEW(INAME1(1))
              CHEM1  = S2_CHEM (IA1)
              MON(1) = C2_RNAME
              IFL(1) = 2
            ENDIF
          ELSE
            ALTS = '.'
            IF(ATM1.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM1.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB1 = C1_IGLOBAL
            IF(N1.GT.0) THEN
              IA1    = S1_INEW(INAME1(1))
              CHEM1  = S1_CHEM (IA1)
              MON(1) = C1_RNAME
              IFL(1) = 1
            ENDIF
          ENDIF
          IF(N1.LE.0) GO TO 200
          IF(IFLAG2.EQ.1) THEN
            ALTS = '.'
            IF(ATM2.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM2.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB2 = C2_IGLOBAL
            IF(N2.GT.0) THEN
              IA2    = S2_INEW(INAME2(1))
              CHEM2  = S2_CHEM (IA2)
              MON(2) = C2_RNAME
              IFL(2) = 2
            ENDIF
          ELSE
            ALTS = '.'
            IF(ATM2.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM2.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB2 = C1_IGLOBAL
            IF(N2.GT.0) THEN
              IA2    = S1_INEW(INAME2(1))
              CHEM2  = S1_CHEM (IA2)
              MON(2) = C1_RNAME
              IFL(2) = 1
            ENDIF
          ENDIF
          IF(N2.LE.0) GO TO 200
          IF(IFLAG3.EQ.1) THEN
            ALTS = '.'
            IF(ATM3.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM3.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM3,ALTS,N3,CORR3,INAME3,IAT3,X3
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB3 = C2_IGLOBAL
            IF(N3.GT.0) THEN
              IA3    = S2_INEW(INAME3(1))
              CHEM3  = S2_CHEM (IA3)
              MON(3) = C2_RNAME
              IFL(3) = 2
            ENDIF
          ELSE
            ALTS = '.'
            IF(ATM3.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM3.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM3,ALTS,N3,CORR3,INAME3,IAT3,X3
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB3 = C1_IGLOBAL
            IF(N3.GT.0) THEN
              IA3    = S1_INEW(INAME3(1))
              CHEM3  = S1_CHEM (IA3)
              MON(3) = C1_RNAME
              IFL(3) = 1
            ENDIF
          ENDIF
          IF(N3.LE.0) GO TO 200

          ECONST = 0.0
          DO L=1,LEG_NANGL
           IF((LEG_1ATM(L).EQ.CHEM1.AND.LEG_2ATM(L).EQ.CHEM2.AND.
     *                                  LEG_3ATM(L).EQ.CHEM3  ).OR.
     *        (LEG_1ATM(L).EQ.CHEM3.AND.LEG_2ATM(L).EQ.CHEM2.AND. 
     *                                  LEG_3ATM(L).EQ.CHEM1)) THEN
              ECONST = LEG_CONST(L) 
              GO TO 510
            ENDIF
          ENDDO
 510      CONTINUE


          CALL CALC_DISTL_ANGL(VAL,DEV
     *                   ,LB,IFL,MON,LATOM,LINK,DIST,DESD)

          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                CORR(1) = CORR1(I)
                CORR(2) = CORR2(J)
                CORR(3) = CORR3(K)
                N       = 3
                IWREST  = 0
                CALL CHK_ALT(N,CORR,CHECK)
                IF(CHECK.EQ.'Y') THEN

                  IF(IAT1(I).GT.0.AND.IAT2(J).GT.0.AND.
     *                                IAT3(K).GT.0     ) THEN
                    CALL CALC_IANGOBS_L(IAT1(I),IAT2(J),IAT3(K)
     *              ,X1(1,I),X2(1,J),X3(1,K),ANGOBS)
                    IWREST = 1
                  ELSE
                    ANGOBS = VAL
                  ENDIF

                  IF(LID.LE.0) THEN
                    IA1     = INAME1(I)+IGLOB1          
                    IA2     = INAME2(J)+IGLOB2          
                    IA3     = INAME3(K)+IGLOB3          
                  ELSE
                    IA1     = IAT1(I) 
                    IA2     = IAT2(J) 
                    IA3     = IAT3(K) 
                  ENDIF
                  IA4     = 0
                  ATOM1   = ATM1 
                  ALT1    = CORR(1)(2:2)
                  ATOM2   = ATM2
                  ALT2    = CORR(2)(2:2)
                  ATOM3   = ATM3
                  ALT3    = CORR(3)(2:2)
                  ATOM4   = ' '  
                  ALT4    = ' '
                  IPERIOD = 0

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(3i5)') IA1,IA2,IA3
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'('':'',A,'':'',A,'':'',A,'':'')') ATOM1,ATOM2,ATOM3
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'('':'',A,'':'',A,'':'',A,'':'')') ALT1,ALT2,ALT3
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'('':'',A,'':'',A,'':'',A,'':'')') 
     *  CORR(1),CORR(2),CORR(3)
        CALL MSGDOC(MDOC,LINE)
      ENDIF




                  IF(IWREST.GT.0) THEN
                    CALL WRESTR(MDOC,NAMEG,LABEL,IA1,IA2,IA3,IA4 
     *              ,VAL,DEV
     *              ,ANGOBS,IPERIOD
     *              ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *              ,ALT1,ALT2,ALT3,ALT4,IERR)
                  ENDIF

                ENDIF
              ENDDO
            ENDDO
          ENDDO
  200     CONTINUE                    
                    
        ENDIF
        ENDDO      
      ENDIF

      IF(LT.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MDOC,' --dl tors')
        ENDIF

        DO  IT=LT,LLT_NTORS
        IF(LINK.EQ.LLT_LNAME(IT)) THEN

          ATM1     = LLT_1ATM (IT)   
          IFLAG1   = LLT_F1ATM(IT)
          ATM2     = LLT_2ATM (IT)
          IFLAG2   = LLT_F2ATM(IT)
          ATM3     = LLT_3ATM (IT)
          IFLAG3   = LLT_F3ATM(IT)
          ATM4     = LLT_4ATM (IT)
          IFLAG4   = LLT_F4ATM(IT)
          VAL      = LLT_VAL  (IT)
          DEV      = LLT_DEV  (IT)
          IPRD     = LLT_PRD  (IT)
          LABEL    = LLT_LABEL(IT)
          LATOM(1) = ATM1
          LATOM(2) = ATM2
          LATOM(3) = ATM3
          LATOM(4) = ATM4

          IF(IFLAG1.EQ.1) THEN
            ALTS = '.'
            IF(ATM1.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM1.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB1 = C2_IGLOBAL
            MON(1) = C2_RNAME
            IFL(1) = 2
          ELSE
            ALTS = '.'
            IF(ATM1.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM1.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB1 = C1_IGLOBAL
            MON(1) = C1_RNAME
            IFL(1) = 1
          ENDIF
          IF(N1.LE.0) GO TO 300
          IF(IFLAG2.EQ.1) THEN
            ALTS = '.'
            IF(ATM2.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM2.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB2 = C2_IGLOBAL
            IF(N2.GT.0) THEN
              IA2    = S2_INEW(INAME2(1))
              CHEM2  = S2_CHEM (IA2)
              MON(2) = C2_RNAME
              IFL(2) = 2
            ENDIF
          ELSE
            ALTS = '.'
            IF(ATM2.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM2.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB2 = C1_IGLOBAL
            IF(N2.GT.0) THEN
              IA2    = S1_INEW(INAME2(1))
              CHEM2  = S1_CHEM (IA2)
              MON(2) = C1_RNAME
              IFL(2) = 1
            ENDIF
          ENDIF
          IF(N2.LE.0) GO TO 300
          IF(IFLAG3.EQ.1) THEN
            ALTS = '.'
            IF(ATM3.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM3.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM3,ALTS,N3,CORR3,INAME3,IAT3,X3
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB3 = C2_IGLOBAL
            IF(N3.GT.0) THEN
              IA3    = S2_INEW(INAME3(1))
              CHEM3  = S2_CHEM (IA3)
              MON(3) = C2_RNAME
              IFL(3) = 2
            ENDIF
          ELSE
            ALTS = '.'
            IF(ATM3.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM3.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM3,ALTS,N3,CORR3,INAME3,IAT3,X3
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB3 = C1_IGLOBAL
            IF(N3.GT.0) THEN
              IA3    = S1_INEW(INAME3(1))
              CHEM3  = S1_CHEM (IA3)
              MON(3) = C1_RNAME
              IFL(3) = 1
            ENDIF
          ENDIF
          IF(N3.LE.0) GO TO 300
          IF(IFLAG4.EQ.1) THEN
            ALTS = '.'
            IF(ATM4.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM4.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM4,ALTS,N4,CORR4,INAME4,IAT4,X4
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB4 = C2_IGLOBAL
            MON(4) = C2_RNAME
            IFL(4) = 2
          ELSE
            ALTS = '.'
            IF(ATM4.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM4.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM4,ALTS,N4,CORR4,INAME4,IAT4,X4
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB4 = C1_IGLOBAL
            MON(4) = C1_RNAME
            IFL(4) = 1
          ENDIF
          IF(N4.LE.0) GO TO 300

          ECONST = 0
          DO M=1,LET_NTORS
            IF((LET_2ATM(M).EQ.CHEM2.AND.LET_3ATM(M).EQ.CHEM3).OR.
     *      (LET_2ATM(M).EQ.CHEM3.AND.LET_3ATM(M).EQ.CHEM2)) THEN
              ECONST = LET_CONST(M) 
              GO TO 520
            ENDIF
          ENDDO
 520      CONTINUE

          CALL CALC_DISTL_TORS(VAL,DEV
     *         ,LB,LG,IFL,MON,LATOM,LINK,DIST,DESD)

          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                DO L=1,N4
                  CORR(1) = CORR1(I)
                  CORR(2) = CORR2(J)
                  CORR(3) = CORR3(K)
                  CORR(4) = CORR4(L)
                  IWREST  = 0
                  N       = 4
                  CALL CHK_ALT(N,CORR,CHECK)
                  IF(CHECK.EQ.'Y') THEN

                    IF(IAT1(I).GT.0.AND.IAT2(J).GT.0.AND.
     *                 IAT3(K).GT.0.AND.IAT4(L).GT.0     ) THEN
                      CALL CALC_ITRSOBS_L(IAT1(I),IAT2(J),IAT3(K)
     *                ,IAT4(L),X1(1,I),X2(1,J),X3(1,K),X4(1,L),ANGOBS)
                      IWREST = 1
                    ELSE
                      ANGOBS = VAL
                    ENDIF

                    IF(LID.LE.0) THEN
                      IA1     = INAME1(I)+IGLOB1          
                      IA2     = INAME2(J)+IGLOB2          
                      IA3     = INAME3(K)+IGLOB3          
                      IA4     = INAME4(L)+IGLOB4          
                     ELSE
                      IA1     = IAT1(I) 
                      IA2     = IAT2(J) 
                      IA3     = IAT3(K) 
                      IA4     = IAT4(L) 
                    ENDIF


                    ATOM1   = ATM1 
                    ALT1    = CORR(1)(2:2)
                    ATOM2   = ATM2
                    ALT2    = CORR(2)(2:2)
                    ATOM3   = ATM3
                    ALT3    = CORR(3)(2:2)
                    ATOM4   = ATM4
                    ALT4    = CORR(4)(2:2)
                    IPERIOD = IPRD

                    IF(IWREST.GT.0) THEN
                      CALL WRESTR(MDOC,NAMET,LABEL,IA1,IA2 
     *                ,IA3,IA4,VAL,DEV
     *                ,ANGOBS,IPERIOD
     *                ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *                ,ALT1,ALT2,ALT3,ALT4,IERR)
                    ENDIF

                  ENDIF
                ENDDO
              ENDDO
            ENDDO
          ENDDO
  300     CONTINUE                    
                    
        ENDIF
        ENDDO      
      ENDIF

      IF(LC.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MDOC,' --dl chir')
        ENDIF

        DO  IC=LC,LLC_NCHIR
        IF(LINK.EQ.LLC_LNAME(IC)) THEN

          ATM1   = LLC_1ATM (IC)   
          IFLAG1 = LLC_F1ATM(IC)
          ATM2   = LLC_2ATM (IC)
          IFLAG2 = LLC_F2ATM(IC)
          ATM3   = LLC_3ATM (IC)
          IFLAG3 = LLC_F3ATM(IC)
          ATM4   = LLC_4ATM (IC)
          IFLAG4 = LLC_F4ATM(IC)
          VOL    = LLC_VOL  (IC)
          SIGN   = LLC_SIGN (IC)

          LATOM(1) = ATM1
          LATOM(2) = ATM2
          LATOM(3) = ATM3
          LATOM(4) = ATM4

          IF(IFLAG1.EQ.1) THEN
            ALTS = '.'
            IF(ATM1.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM1.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB1   = C2_IGLOBAL
            MON(1)   = C2_RNAME
            IF(N1.GT.0) THEN
              IA       = S2_INEW(INAME1(1))
              LCHEM(1) = S2_CHEM (IA)
            ENDIF
            IFL(1)   = 2
          ELSE
            ALTS = '.'
            IF(ATM1.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM1.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM1,ALTS,N1,CORR1,INAME1,IAT1,X1
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB1   = C1_IGLOBAL
            MON(1)   = C1_RNAME
            IF(N1.GT.0) THEN
              IA       = S1_INEW(INAME1(1))
              LCHEM(1) = S1_CHEM (IA)
            ENDIF 
            IFL(1)   = 1
          ENDIF
          IF(N1.LE.0) GO TO 400
          IF(IFLAG2.EQ.1) THEN
            ALTS = '.'
            IF(ATM2.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM2.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB2   = C2_IGLOBAL
            MON(2)   = C2_RNAME
            IF(N2.GT.0) THEN
              IA       = S2_INEW(INAME2(1))
              LCHEM(2) = S2_CHEM (IA)
            ENDIF
            IFL(2)   = 2
          ELSE
            ALTS = '.'
            IF(ATM2.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM2.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM2,ALTS,N2,CORR2,INAME2,IAT2,X2
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB2   = C1_IGLOBAL
            MON(2)   = C1_RNAME
            IF(N2.GT.0) THEN
              IA       = S1_INEW(INAME2(1))
              LCHEM(2) = S1_CHEM (IA)
            ENDIF
            IFL(2)   = 1
          ENDIF
          IF(N2.LE.0) GO TO 400
          IF(IFLAG3.EQ.1) THEN
            ALTS = '.'
            IF(ATM3.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM3.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM3,ALTS,N3,CORR3,INAME3,IAT3,X3
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB3   = C2_IGLOBAL
            MON(3)   = C2_RNAME
            IF(N3.GT.0) THEN
              IA       = S2_INEW(INAME3(1))
              LCHEM(3) = S2_CHEM (IA)
            ENDIF
            IFL(3)   = 2
          ELSE
            ALTS = '.'
            IF(ATM3.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM3.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM3,ALTS,N3,CORR3,INAME3,IAT3,X3
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB3   = C1_IGLOBAL
            MON(3)   = C1_RNAME
            IF(N3.GT.0) THEN
              IA       = S1_INEW(INAME3(1))
              LCHEM(3) = S1_CHEM (IA)
            ENDIF
            IFL(3)   = 1
          ENDIF
          IF(N3.LE.0) GO TO 400
          IF(IFLAG4.EQ.1) THEN
            ALTS = '.'
            IF(ATM4.EQ.ATOMS1) ALTS = ALTS1
            NOUT = 0
            IF(ATM4.EQ.LATOM1) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT1_OUT
            ENDIF
            CALL SRCH_NUM2(MDOC,ATM4,ALTS,N4,CORR4,INAME4,IAT4,X4
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB4   = C2_IGLOBAL
            MON(4)   = C2_RNAME
            IF(N4.GT.0) THEN
              IA       = S2_INEW(INAME4(1))
              LCHEM(4) = S2_CHEM (IA)
            ENDIF
            IFL(4)   = 2
          ELSE
            ALTS = '.'
            IF(ATM4.EQ.ATOMS2) ALTS = ALTS2
            NOUT = 0
            IF(ATM4.EQ.LATOM2) THEN
              NOUT    = NL_OUT
              ALT_OUT = ALT2_OUT
            ENDIF
            CALL SRCH_NUM1(MDOC,ATM4,ALTS,N4,CORR4,INAME4,IAT4,X4
     *                                        ,NOUT,ALT_OUT,LID,IERR)
            IGLOB4   = C1_IGLOBAL
            MON(4)   = C1_RNAME
            IF(N4.GT.0) THEN
              IA       = S1_INEW(INAME4(1))
              LCHEM(4) = S1_CHEM (IA)
            ENDIF
            IFL(4)   = 1
          ENDIF
          IF(N4.LE.0) GO TO 400

          CALL CALC_IIVOL_L(IFL,MON,LATOM
     *                       ,LCHEM,LINK,VOLIDL,PH_IDL,PH2,PH3)
          VOL = VOLIDL

          DO I=1,N1
            DO J=1,N2
              DO K=1,N3
                DO L=1,N4
                  CORR(1) = CORR1(I)
                  CORR(2) = CORR2(J)
                  CORR(3) = CORR3(K)
                  CORR(4) = CORR4(L)
                  N       = 4
                  IWREST  = 0
                  PH      = 0
                  CALL CHK_ALT(N,CORR,CHECK)
                  IF(CHECK.EQ.'Y') THEN

                    IF(IAT1(I).GT.0.AND.IAT2(J).GT.0.AND.
     *                 IAT3(K).GT.0.AND.IAT4(L).GT.0     ) THEN
                      CALL CALC_I_OVOL_L(IAT1(I),IAT2(J),IAT3(K),
     *                IAT4(L),X1(1,I),X2(1,J),X3(1,K),X4(1,L),VOLOBS,PH)
                      IWREST = 1
                    ELSE
                      VOLOBS = VOLIDL
                    ENDIF

                    IF(LID.LE.0) THEN
                      IA1     = INAME1(I)+IGLOB1          
                      IA2     = INAME2(J)+IGLOB2          
                      IA3     = INAME3(K)+IGLOB3          
                      IA4     = INAME4(L)+IGLOB4          
                     ELSE
                      IA1     = IAT1(I) 
                      IA2     = IAT2(J) 
                      IA3     = IAT3(K) 
                      IA4     = IAT4(L) 
                    ENDIF

                    ATOM1   = ATM1 
                    ALT1    = CORR(1)(2:2)
                    ATOM2   = ATM2
                    ALT2    = CORR(2)(2:2)
                    ATOM3   = ATM3
                    ALT3    = CORR(3)(2:2)
                    ATOM4   = ATM4
                    ALT4    = CORR(4)(2:2)
                    ECONST  = PH
                    DIST    = 0.0
                    DESD    = 0.0
                    IPERIOD = 0
                    SD      = 0.02

                    IF(IWREST.GT.0) THEN
                      CALL WRESTR(MDOC,NAMEC,SIGN,IA1,IA2 
     *                ,IA3,IA4,VOL,SD
     *                ,VOLOBS,IPERIOD
     *                ,DIST,DESD,ECONST,ATOM1,ATOM2,ATOM3,ATOM4
     *                ,ALT1,ALT2,ALT3,ALT4,IERR)
                    ENDIF

                  ENDIF
                ENDDO
              ENDDO
            ENDDO
          ENDDO

  400     CONTINUE                    
                    
        ENDIF
        ENDDO      
      ENDIF

      L  = LLL_ILINK

      CALL IPLAN_RSTR_L(MDOC,LIST,L,LINK,ATOMS1,ALTS1,ATOMS2,ALTS2
     *               ,NL_OUT,LATOM1,LATOM2,ALT1_OUT,ALT2_OUT,LID,IERR)

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' --dl ---')
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE IPLAN_RSTR_L(MDOC,LIST,L,LINK
     *      ,ATOMS1,ALTS1,ATOMS2,ALTS2
     *      ,NL_OUT,LATOM1,LATOM2,ALT1_OUT,ALT2_OUT,LID,IERR)
C -----------------------------------------------
C -P- IPLAN_RSTR -
C -S-
      INTEGER*4 MDOC,IERR,LID
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
      INTEGER*4 INAME (MX1ALT)
      INTEGER*4 IGLOB (MX1ALT)
      INTEGER*4 IAT   (MX1ALT)
      CHARACTER CORR  (MX1ALT)*2

      REAL      DEV_PLAN(MAX1APL)
      REAL      DEV     (MAX1APL)
      REAL      DOBS    (MAX1APL)

      INTEGER*4 IATM    (MAX1APL)
      INTEGER*4 IGLB    (MAX1APL)
      INTEGER*4 IATM_A  (MAX1APL)
      REAL      XXX     (3,MAX1APL)

      INTEGER*4 IN_PLAN (MAX1APL)

      INTEGER*4 IA_GLOB   (MX1ALT,MAX1APL)
      INTEGER*4 IA_PLAN   (MX1ALT,MAX1APL)
      INTEGER*4 IA_PLAN_A (MX1ALT,MAX1APL)
      REAL      XX        (3,MX1ALT,MAX1APL)

      INTEGER*4 ICORR     (MX1ALT,MAX1APL)

      INTEGER*4 IC_CODE (MAX1APL)
      INTEGER*4 IA_CODE (MAX1APL)

      REAL      X(3,MX1ALT)

      CHARACTER CHAR1*1,LINK*8,LIST*1,ALTS*1
      CHARACTER ATOMS1*4,ATOMS2*4,ALTS1*1,ALTS2*1,LATOM1*4,LATOM2*4
      INTEGER   IATOM
      CHARACTER ALT_OUT*10,ALT1_OUT*10,ALT2_OUT*10
C ---
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C --------------------------------------------------------
      LP = LLL_IPLAN(L)
      ALTS    = '.'
      ALT_OUT = '.'
 
      IF(LLP_NPLAN.GT.0.AND.LP.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MDOC,' --dl plan')
        ENDIF


        DO  IP=LP,LLP_NPLAN

          IF(LINK.EQ.LLP_LNAME(IP)) THEN

          IF(LLP_NATOM(IP).GT.0) THEN

            N  = 0
            NC = 0
            NA = 0  
            DO  I = 1,LLP_NATOM(IP)

              IATOM = LLP_ATOM (I,IP)
              IFLAG = LLP_FATOM(I,IP)

              ICH4 = IATOM
              IF(IFLAG.EQ.1) THEN
                ALTS = '.'
                IF(CH4.EQ.ATOMS1) ALTS = ALTS1
                NOUT = 0
                IF(CH4.EQ.LATOM1) THEN
                  NOUT    = NL_OUT
                  ALT_OUT = ALT1_OUT
                ENDIF
                CALL SRCH_NUM2(MDOC,CH4,ALTS,NN,CORR,INAME,IAT,X
     *                                        ,NOUT,ALT_OUT,LID,IERR)
                IGLOB1 = C2_IGLOBAL
              ELSE
                ALTS = '.'
                IF(CH4.EQ.ATOMS2) ALTS = ALTS2
                NOUT = 0
                IF(CH4.EQ.LATOM2) THEN
                  NOUT    = NL_OUT
                  ALT_OUT = ALT2_OUT
                ENDIF
                CALL SRCH_NUM1(MDOC,CH4,ALTS,NN,CORR,INAME,IAT,X
     *                                        ,NOUT,ALT_OUT,LID,IERR)
                IGLOB1 = C1_IGLOBAL
              ENDIF

              IF(NN.NE.0) THEN
                DO II = 1,NN
                  IGLOB(II) = IGLOB1
                ENDDO
                N           = N + 1
                DEV_PLAN(N) = LLP_DEV(I,IP)
                JJ          = 0
                IN_PLAN(N)  = 0
                DO J=1,NN
                  IF(CORR(J).EQ.'..') THEN
                    JJ              = 1
                    IN_PLAN   (N)   = JJ
                    ICORR  (JJ,N)   = 0
                    IA_PLAN  (JJ,N) = INAME(J)
                    IA_GLOB  (JJ,N) = IGLOB(J)
                    IA_PLAN_A(JJ,N) = IAT  (J)
                    XX     (1,JJ,N) = X  (1,J)
                    XX     (2,JJ,N) = X  (2,J)
                    XX     (3,JJ,N) = X  (3,J)
                    GO TO 100
                  ELSE IF(CORR(J)(1:1).NE.'.') THEN
                    JJ          = JJ+1
                    IN_PLAN (N) = JJ
                    CHAR1       = CORR(J)(1:1)
                    CALL CHTOINT(CHAR1,ICODE)
                    IA_PLAN  (JJ,N) = INAME(J)
                    IA_GLOB  (JJ,N) = IGLOB(J)
                    IA_PLAN_A(JJ,N) = IAT  (J)
                    XX     (1,JJ,N) = X  (1,J)
                    XX     (2,JJ,N) = X  (2,J)
                    XX     (3,JJ,N) = X  (3,J)
                    ICORR    (JJ,N) = ICODE
                    IF(NC.GT.0) THEN
                      DO IC=1,NC
                        IF(IC_CODE(IC).EQ.ICODE) GO TO 200
                      ENDDO
                    ENDIF
                    NC          = NC + 1
                    IC_CODE(NC) = ICODE
  200               CONTINUE
                  ELSE IF(CORR(J)(2:2).NE.'.') THEN
                    JJ          = JJ + 1
                    IN_PLAN (N) = JJ
                    CHAR1       = CORR(J)(2:2)
                    CALL CHTOINT(CHAR1,ICODE)
                    ICODE           =-ICODE
                    IA_PLAN  (JJ,N) = INAME(J)
                    IA_GLOB  (JJ,N) = IGLOB(J)
                    IA_PLAN_A(JJ,N) = IAT  (J)
                    ICORR  (JJ,N)   = ICODE
                    XX     (1,JJ,N) = X  (1,J)
                    XX     (2,JJ,N) = X  (2,J)
                    XX     (3,JJ,N) = X  (3,J)
                    IF(NA.GT.0) THEN
                      DO IA=1,NA
                        IF(IA_CODE(IA).EQ.ICODE) GO TO 300
                      ENDDO
                    ENDIF
                    NA          = NA + 1
                    IA_CODE(NA) = ICODE
  300               CONTINUE
                  ENDIF
                ENDDO
              ENDIF
  100         CONTINUE
            ENDDO
C ---  
            IF(N.GE.4) THEN

              IF(NC.EQ.0.AND.NA.EQ.0) THEN       

                NP    = 0
                DO J=1,N
                  IF(IN_PLAN(J).GT.0) THEN
                    K = 1
                    IF(ICORR(K,J).EQ.0
     *                            .AND.IA_PLAN_A(K,J).GT.0 ) THEN
                      NP             = NP + 1
                      DEV   (NP)     = DEV_PLAN(J)
                      IATM  (NP)     = IA_PLAN  (K,J)
                      IGLB  (NP)     = IA_GLOB  (K,J)
                      IATM_A(NP)     = IA_PLAN_A(K,J)
                      XXX     (1,NP) = XX  (1,K,J)
                      XXX     (2,NP) = XX  (2,K,J)
                      XXX     (3,NP) = XX  (3,K,J)
                      GO TO 600
                    ENDIF
                  ENDIF
  600             CONTINUE
                ENDDO

                IF(NP.GE.4) THEN

                  IF(LIST.EQ.'T') THEN
                    CALL MSGDOC(MDOC,' --dl plan 1')
                  ENDIF

                  CALL CALC_IPLDEV_L(MDOC,LIST,NP,IATM,IATM_A,XXX,DOBS)
                  CALL WPRSTR_LN(MDOC,LLP_LABEL(IP),NP
     *           ,DEV,DOBS,IATM,IATM_A,IGLB,C1_IGLOBAL,C2_IGLOBAL
     *           ,LID,IERR)
                ENDIF

              ELSE
     
                IF(NC.GT.0) THEN       

                  DO I=1,NC
                    NP    = 0
                    ICODE = IC_CODE(I)
                    DO J=1,N
                      IF(IN_PLAN(J).GT.0) THEN
                      DO K=1,IN_PLAN(J)
                        IF(ICORR(K,J).EQ.0.OR.ICORR(K,J).EQ.ICODE
     *                            .AND.IA_PLAN_A(K,J).GT.0 ) THEN
                          NP             = NP + 1
                          DEV(NP)        = DEV_PLAN(J)
                          IATM  (NP)     = IA_PLAN  (K,J)
                          IGLB  (NP)     = IA_GLOB  (K,J)
                          IATM_A(NP)     = IA_PLAN_A(K,J)
                          XXX     (1,NP) = XX  (1,K,J)
                          XXX     (2,NP) = XX  (2,K,J)
                          XXX     (3,NP) = XX  (3,K,J)
                          GO TO 400
                        ENDIF
                      ENDDO
                      ENDIF
  400                 CONTINUE
                    ENDDO
                    IF(NP.GE.4) THEN

                      IF(LIST.EQ.'T') THEN
                        CALL MSGDOC(MDOC,' --dl plan 2')
                      ENDIF
 
                     CALL CALC_IPLDEV_L(MDOC,LIST,NP
     *                ,IATM,IATM_A,XXX,DOBS)
                      CALL WPRSTR_LN(MDOC,LLP_LABEL(IP),NP
     *                ,DEV,DOBS,IATM,IATM_A,IGLB,C1_IGLOBAL,C2_IGLOBAL
     *                ,LID,IERR)
                    ENDIF
                  ENDDO

                ENDIF       

                IF(NA.GT.0) THEN  

                  DO I=1,NA
                    NP    = 0
                    ICODE = IA_CODE(I)
                    DO J=1,N
                      IF(IN_PLAN(J).GT.0) THEN
                        DO K=1,IN_PLAN(J)
                        IF(ICORR(K,J).EQ.0.OR.ICORR(K,J).EQ.ICODE
     *                            .AND.IA_PLAN_A(K,J).GT.0 ) THEN
                          NP             = NP + 1
                          DEV   (NP)     = DEV_PLAN(J)
                          IATM  (NP)     = IA_PLAN  (K,J)
                          IGLB  (NP)     = IA_GLOB  (K,J)
                          IATM_A(NP)     = IA_PLAN_A(K,J)
                          XXX     (1,NP) = XX  (1,K,J)
                          XXX     (2,NP) = XX  (2,K,J)
                          XXX     (3,NP) = XX  (3,K,J)
                          GO TO 500
                        ENDIF
                        ENDDO
                      ENDIF
  500                 CONTINUE
                    ENDDO
                    IF(NP.GE.4) THEN

                      IF(LIST.EQ.'T') THEN
                        CALL MSGDOC(MDOC,' --dl plan 3 ')
                      ENDIF

                      CALL CALC_IPLDEV_L(MDOC,LIST,NP
     *                ,IATM,IATM_A,XXX,DOBS)
                      CALL WPRSTR_LN(MDOC,LLP_LABEL(IP),NP
     *                ,DEV,DOBS,IATM,IATM_A,IGLB,C1_IGLOBAL,C2_IGLOBAL
     *                ,LID,IERR)
                    ENDIF
                  ENDDO
                ENDIF       
              ENDIF
            ENDIF

          ELSE
C ???
c            LLP_NATOM(IP) = 0
          ENDIF

          ENDIF

        ENDDO      
      ENDIF

      RETURN
      END

