program mmmcif_reader_main
  use mmcif_reader
  implicit none

  integer nc_arg
  nc_arg = iargc()
  
  call ugtenv('HKLIN',file_in)
  call ugtenv('HKLOUT',file_out)

  call open_form_file(ifile_in,file_in,ierr)
  if(ierr.gt.0) stop 1
  read(ifile_in,'(a)',iostat=ist)string
  do while(ist.eq.0)
     if(adjustl(string)(1:4).eq.'data') exit
  endif
  stop

  call mmccif_read_cell(cell,file_in,ierr)
  if(ierr.gt.0) then
     write(*,*)'Error==> There is no cell parameters in the input file'
     stop
  endif
  call mmcif_read_symm(ispgno,sgnam,maxsym,nsym,nsymp,rot,tr,pgna,ierr)
  if(ierr.gt.0) then
     write(*,*)'Error==> There are no symmetry elements in the input file'
     stop
  endif
  call mmcif_read_refl_sizes(ncomp,nobs,file_in,ierr)
  if(ierr.gt.0) then
     write(*,*)'Error==> Prblem with reading mmcif file'
     stop
  endif

  allocate(nref_comp(nobs))
  allocate(iobs(2,nobs))
  allocate(hkl_comp(3,ncomp))
  allocate(comp_numb(ncomp))
  allocate(obs_block(nobs))

  call mmcif_read_refl(ncomp,nobs,nref_comp,comp_numb,hkl_comp,iobs,obs_block,file_in,ierr)
  
end program mmmcif_reader
!
!
subroutine mmcif_reader_cell(cell,file_mmcif,ierr)
  use parser_things
  use mmcif_things
  real, intent(out) :: cell(6)
  character(len=*), intent(in) :: file_mmcif
  integer ierr

  integer i
  real rtodeg

  rtodeg = 180.0/(4.0*atan(1.0))
  ! 
  call open_form_file(ifile,file_mmcif,ierr)
  if(ierr.gt.0) return

  ist = 0
  cell_flag(1:6) = 0
  found_all = .FALSE.
  do while(ist.eq.0.and..not.found_all)
     read(ifile,'(a)',iostat=ist)line
     call parser(line,)
     do i=1,6
        if(line(ibeg(1):iend(1)).eq.cell_items(i)) then
           cell(i) = fvalue(2)
           cell_flag(i) = 1
           exit
        endif
     enddo

     if(sum(cell_flag(1:6)).eq.6) found_all = .TRUE.
  enddo
  if(maxval(cell(4:6)).le.4.0) then
     cell(4:6) = cell(4:6)*rtodeg
  endif

  return
end subroutine mmcif_reader_cell

subroutine mmcif_read_twin_opers

end subroutine mmcif_read_twin_opers

subroutine mmcif_reader_symmetry(nsym,sgnm,file_mmcif,ierr)

end subroutine mmcif_reader_symmetry
!
subroutine mmcif_read_refl_size(ncomp,nobs,file_mmcif,ierr)
  use mmcif_things
  use parser_things

  cif_items_prev = ' '
  group_refln_num = 0
  group_obs_num = 0
  start_group_refln = .FALSE.
  start_group_obs = .FALSE.

  call parse_cif()

  do while(.not.eof..and.iread.gt.1.and.group_refln_num+group_obs_num.lt.2)
     iread = 0
     if(cif_items_ref.eq.'_group_refln') then
        if(cif_items_prev.ne.'_group_refln'.and..not.start_group_refln) group_refln_num = group_refln_num + 1
        cif_items_prev = cif_items_ref
        if(group_refln_num.gt.1) then
           write(*,*)'Error==> Problem with mmcif. _group_refln has been defined more than once'
           stop
        endif
        iread = iread+1
        start_group_refln = .TRUE.
        icomp = icomp + 1
        do i=1,n_items
           if(cif_items_elems(i).eq.'id') then
              
           else if(cif_items_elems(i).eq.'index_h') then
              
           else if(cif_items_elems(i).eq.'index_k') then
              
           else if(cif_items_elems(i).eq.'index_l') then
              
           else if(cif_items_elems(i).eq.'comp_id') then
              
           else if(cif_items_elems(i).eq.'group_obs_id') then
              
           endif
        enddo
     else if(cif_items_ref.eq.'_group_obs') then
        if(cif_items_prev.ne.'_group_obs'.and..not.start_group_refln) group_obs_num = group_obs_num + 1
        if(group_obs_num.gt.1) then
           write(*,*)'Error==> Problem with mmcif. _group_obs has been defined more than once'
           stop
        endif
        iread = iread + 1
        cif_items_prev = cif_items_ref
        io = io + 1
        do i=1,n_items
           
           if(cif_items_elems(i).eq.'id') then
              
           else if(cif_items_elems(i).eq.'intensity_meas') then
              
           else if(cif_items_elems(i).eq.'intensity_sigma') then
              
           else if(cif_items_elems(i).eq.'refinement_status') then
              
           else if(cif_items_elems(i).eq.'block_id') then
              
           endif
        enddo
     endif
     call parse_cif()
  enddo

  do i=1,n_items
     
     if(cif_items(i).eq.'_cell.length_a') then
        cell(i) = cif_value_r(i)
     elseif(cif_items(i).eq.'_cell.length_b') then
        
     elseif(cif_items(i).eq.'_cell_length_c') then
        
  if(ll.gt.0) then
  if(cif_items(1:
  do while(ist.eq.0.or.things_to_do)
     if(line(ibeg(1):iend(1)).eq.'loop_') then
        read(ifile_in,'(a)')line
        call parser()
        if(line(ibeg(1):ibeg(1)).eq.'_') then

        endif
     endif

  enddo


end subroutine mmcif_read_refl_size

subroutine mmcif_reader_obsall_sizes



end subroutine mmcif_reader_obsall_sizes

subroutine mcif_reader_obsall

end subroutine mcif_reader_obsall
