module read_residue_pairs
  use residue_pairs

contains

  subroutine define_and_read_residue_pairs
    use parser
    implicit none

    type (res_pairs), allocatable :: linked_pairs(:)
    
    character key*4
    character cvalue(500)*4
    logical eof
    
    call parser(key,cvalue,eof)
    
    eof = .FALSE.
    do while(.not.eof)
       
       if(cvalue(1)(1:3).ne.'DEF'.or.cvalue(2)(1:4).ne.'PAIR') then
          ip = ip + 1
          cycle
       else
          call parser_flex(key,cvalue,eof)
          do while(eof.and.(cvalue(1:3).ne.'END'.or.cvalue(2)(1:3).ne.'DEF'))
             if(cvalue(1).eq.'DIST') then
                jb = jb + 1
                linked_pairs(ip)%bonds(jb)%atom1 = line(ibeg(itk):iend(itk))
                itk = itk + 1
                linked_pairs(ip)%bonds(jb)%atom2 = line(ibeg(itk):iend(itk))
                itk = itk + 1
                if(itk.le.ntok) then
                   linked_pairs(ip)%bonds(jb)%value = fvalue(itk)
                   itk = itk + 1
                   if(itk.le.ntok) then
                      linked_pairs(ip)%bonds(jb)%sigma = fvalue(itk)
                   endif
                endif
             else if(cvalue(1).eq.'ANGL') then
                ja = ja + 1
             else if(cvalue(1).eq.'TORS') then

             else if(cvalue(1).eq.'CHIR') then

             endif
             call parser_flex(key,cvalue,eof)
          enddo
          if(eof) cycle
       endif
       call parser_flex(key,cvalue,eof)
    enddo

  end subroutine define_and_read_residue_pairs
  
  subroutine apply_residue_pairs(keyword_file)
    use residue_pairs
    implicit none

    integer npairs
    type (res_pairs) :: linked_pairs(:)
    character keyword_file

    integer isrck,ierr
    logical eof
    ! 
    ! Open keywords' file
    !

    if(npairs.le.0) return
    call open_form_file(iscrk,keyword_file,ierr)

    ! 
    ! Open all restraint files and read them till the end
    !

    call parse_flexible(key,cvalue,eof)
    
    do while(.not.eof)
       if(cvalue(1).eq.'APPLY'.and.cvalue(2).eq.'PAIR') then
          act_pair = line(ibeg(3):iend(3))
          !
          !---Read info about residues where it should be applied and make a list
          itk = 4
          do ip=1,npairs
             if(act_pair.eq.linked_pairs(ip)%name) then
                do ir=1,res_pair_apply
                   ir1 = res_pair_num(1,ir)
                   ir2 = res_pair_num(2,ir)
                   mon1 = res_name(ir1)
                   mon2 = res_name(ir2)
                   if(mon1.eq.linked_pairs(ip)%res1.and.mon2.eq.linked_pairs(ip)%res2) then
                      do ib=1,linked_pairs(ip)%nbonds
                         at1 = linked_pairs(ip)%aname1
                         at2 = linked_pairs(ip)%aname2
                         do iat=atoms_in_res1
                            if(at1.eq.aname1) then
                               do iat=atoms_in_res2
                                  if(at2.eq.aname2) then
                                     rs_value(1) = linked_pairs(ip)%bonds(ib)%value
                                     rs_value(2) = linked_pairs(ip)%bonds(ib)%sigma
                                     write(ibondf)iat1,iat2,rs_value(1:2)
                                  endif
                               enddo
                            endif
                         enddo
                      enddo
                   endif
                enddo
             endif
          enddo
       endif
       call parse_flexible(key,cvalue,eof)
    enddo

  end subroutine apply_residue_pairs
end module read_residue_pairs
