C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE LSQ_COEF(NREF,ndens,hkl_asym,FO,SIGO,fwt,
     &     FC,PHASE,FREER)
      use weights
      use agreem
      use rharvest
      use CellAndSymmetry
      use refi_flags
c
c----Subroutine to calculate coefficients for fourie transformation
c----for gradient calculation for minimisation function
c-----                       sum(w(fo-fc)**2)
C-----  FC and PHASE will contain coefficients for FFT for gradient calc
C-----  FO           will contain coefficients for FFT for Hessian calc
C-----  SIGO         will be 0
c
      IMPLICIT NONE
      INTEGER NREF,ndens
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real fwt(*)
      INTEGER hkl_asym(3,*)
c
c----Values inbins for agreements
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
C
      REAL DFA(NMAXPART),DFB(NMAXPART),D2FDA2(NMAXPART),D2FDB2(NMAXPART)

      INTEGER I,J,JMN,IFREE,NB1,IMODE,NREFMNPAR 
      INTEGER IHH(3),N_REFINED_ATOMS
      REAL    SO,SIGEXPER,SIGAPP,YO,SQRTW,RSQ,RHO,YOS,YC_ALL,
     &        PHASE_ALL,SIGOS,DY,WDY,DENOM1,COMPL,F_VALUE_C
      REAL LSTLSQ
      EXTERNAL LSTLSQ
C
C----Initialize
                                !  nrefm and nrefa have already been calculated
                                !  in refmac_completeness
      HNSHELL = NBIN
      NB1 = NBIN+1
      DO    I=1,NB1
        DO   IFREE = 1,2
          AFOMFC(IFREE,I) = 0.0
                                !          NREFM(IFREE,I)  = 0
                                !          NREFA(IFREE,I)  = 0
          ASIG(IFREE,I)   = 0.0
          WFOMFC(IFREE,I) = 0.0
          AFOFO(IFREE,I)  = 0.0
          AFCFC(IFREE,I)  = 0.0
          AFOFC(IFREE,I)  = 0.0
          AFC(IFREE,I)    = 0.0
          AFO(IFREE,I)    = 0.0
          WFO(IFREE,I)    = 0.0
          WFOFO(IFREE,I)  = 0.0
          wfomfc2(ifree,i) = 0.0
        ENDDO
      ENDDO
      FXRAY  = 0.0
      FXFREE = 0.0
c
c---Loop over reflections
      IMODE = 0
      IF(LREFIN.AND.REFS.EQ.'LSQF') IMODE = 2
      CALL FIND_NREFINED_ATOMS(N_REFINED_ATOMS)
      DO     I=1,NREF
        YO  = FO(I)
        SO  = SIGO(I)
        JMN = 0
        IF(SO.LE.0.0)  JMN = 1

        IFREE  = 1
        IF(FREER_FLAG )THEN
          IF( ABS(FREER(I) - LFreeRexcludeVal) .LT.0.01)  IFREE = 2
        END IF
        ihh(1:3) = hkl_asym(1:3,i)
        RSQ   = LSTLSQ(1,IHH(1),IHH(2),IHH(3))
        RHO   = SQRT(RSQ)
        IF(SO.GT.0.0)CALL SUMSFS_LS_DERIV(I,NREF,ndens,hkl_asym,
     &       FO,SIGO,FC,
     &           PHASE,YOS,YC_ALL,PHASE_ALL,SIGOS,DFA,DFB,D2FDA2,D2FDB2,
     &           F_VALUE_C,IMODE)
        DY    = 0.0
        IF(SO.GT.0.0) THEN
          SIGEXPER = SIGOS
          IF(.NOT.LEXPUSE) SIGEXPER = 1.0
          SIGAPP = SIGEXPER
          SQRTW  = 1.0/SIGAPP
          DY     = YOS-YC_ALL
          WDY    = SQRTW*DY
        ENDIF
C
C---  Resolution ranges:
        DO     J=1,NBIN
          IF(RHO.GE.SMINB(J).AND.RHO.LE.SMAXB(J)) THEN
c     NREFM(IFREE,J)  = NREFM(IFREE,J) + JMN
            IF(SO.LE.0.0)  GO TO 100
            AFOMFC(IFREE,J) = AFOMFC(IFREE,J) + ABS(DY)
            AFOFO(IFREE,J)  = AFOFO(IFREE,J)  + YOS*YOS
            AFOFC(IFREE,J)  = AFOFC(IFREE,J)  + YOS*YC_ALL
            AFCFC(IFREE,J)  = AFCFC(IFREE,J)  + YC_ALL*YC_ALL
            AFC(IFREE,J)    = AFC(IFREE,J)    + YC_ALL
            AFO(IFREE,J)    = AFO(IFREE,J)    + YOS
c     NREFA(IFREE,J)  = NREFA(IFREE,J)  + 1
            ASIG(IFREE,J)   = ASIG(IFREE,J)   + SIGOS
            WFOMFC(IFREE,J) = WFOMFC(IFREE,J) + ABS(WDY)
            wfomfc2(ifree,j) = wfomfc2(ifree,j) + wdy**2
            WFO(IFREE,J)    = WFO(IFREE,J)    + SQRTW*YOS
            WFOFO(IFREE,J)  = WFOFO(IFREE,J)  + (SQRTW*YOS)**2
            GOTO 100
          ENDIF
        ENDDO
        GOTO 101
100     CONTINUE
c        NREFM(IFREE,NB1) = NREFM(IFREE,NB1) + JMN
        IF(SO.LE.0.0) GOTO 101
C
C---  Totals
        AFOMFC(IFREE,NB1) = AFOMFC(IFREE,NB1) + ABS(DY)
        AFOFO(IFREE,NB1)  = AFOFO(IFREE,NB1)  + YOS*YOS
        AFOFC(IFREE,NB1)  = AFOFC(IFREE,NB1)  + YOS*YC_ALL
        AFCFC(IFREE,NB1)  = AFCFC(IFREE,NB1)  + YC_ALL*YC_ALL
        AFC(IFREE,NB1)    = AFC(IFREE,NB1)    + YC_ALL
        AFO(IFREE,NB1)    = AFO(IFREE,NB1)    + YOS
c        NREFA(IFREE,NB1)  = NREFA(IFREE,NB1)  + 1
        ASIG(IFREE,NB1)   = ASIG(IFREE,NB1)   + SIGOS
C
C---  Calculate agreement factors
        WFOMFC(IFREE,NB1) = WFOMFC(IFREE,NB1) + ABS(WDY) 
        wfomfc2(ifree,nb1) = wfomfc2(ifree,nb1) + wdy**2
        WFO(IFREE,NB1)    = WFO(IFREE,NB1)    + SQRTW*YOS
        WFOFO(IFREE,NB1)  = WFOFO(IFREE,NB1)  + (SQRTW*YOS)**2
C
C---  Coefficients for gradient and second derivative calculation
        IF(IFREE.EQ.1) THEN
          FXRAY = FXRAY + WDY**2
        ELSE
          FXFREE = FXFREE + WDY**2
        ENDIF
C
        IF(IMODE.EQ.2) THEN
          IF(IFREE.EQ.1) THEN
            FC(I,1)    = -WDY
            PHASE(I,1) = 0.0
            IF(ABS(FC(I,1)).NE.0.0)PHASE(I,1)=PHASE_ALL
            FO(I)  =
     +        (D2FDA2(NPART+1)+D2FDB2(NPART+1))/2.0*NSMULT*IFACTOR_CC
            SIGO(I)  = 0.0
          ELSE
            FC(I,1)    = 0.0
            PHASE(I,1) = 0.0
            SIGO(I)  = 0.0
            FO(I)    = 0.0
          ENDIF
        ENDIF
 101    CONTINUE
      ENDDO

C
c---Compile statistic
      DO     I=1,NB1
        HD_SHELL_HIGH(I) = 0.5/SMAXB(I)
        HD_SHELL_LOW(I)  = 0.5/SMINB(I)
c        HNREF_SHELL_WORK(I) = NREFA(1,I)
c        HNREF_SHELL_FREE(I) = NREFA(2,I)
        !write(*,*)hnref_shell_work(i),hnref_shell_free(i)
c        HNREF_SHELL_OBS(I)  = NREFA(1,I) + NREFA(2,I)
c        HNREF_SHELL_ALL(I)  = NREFM(1,I) + NREFM(2,I) + 
c     &                           HNREF_SHELL_OBS(I)
        HPERC_SHELL_REFL(I) = 100.0
        IF(HNREF_SHELL_ALL(I).GT.0) 
     &     HPERC_SHELL_REFL(I) = FLOAT(HNREF_SHELL_OBS(I))/
     &                           FLOAT(HNREF_SHELL_ALL(I))*100.0

C
        IF(NREFA(1,I).GT.0) THEN
          HRFAC_SHELL_WORK(I)  = AFOMFC(1,I)/AFO(1,I)
          HRFAC_SHELL_ALL(I)   = (AFOMFC(1,I) + AFOMFC(2,I))/
     &                           (AFO(1,I)+AFO(2,I))
          HRFAC_SHELL_OBS(I)   = HRFAC_SHELL_ALL(I)

          HWRFAC_SHELL_WORK(I)  = WFOMFC(1,I)/WFO(1,I)
          HWRFAC_SHELL_ALL(I)   = (WFOMFC(1,I) + WFOMFC(2,I))/
     &                            (WFO(1,I)+WFO(2,I))
          HWRFAC_SHELL_OBS(I)   = HWRFAC_SHELL_ALL(I)

          hwr2fac_shell_work(i) = sqrt(wfomfc2(1,i)/wfofo(1,i))
          hwr2fac_shell_all(i) = sqrt((wfomfc2(1,i)+wfomfc2(2,i))/
     &                             (wfofo(1,i)+wfofo(2,i)))
          hwr2fac_shell_obs(i) = hwr2fac_shell_all(i)

          AFC(1,I)   = AFC(1,I)/NREFA(1,I)
          AFO(1,I)   = AFO(1,I)/NREFA(1,I)
          AFOFO(1,I) = AFOFO(1,I)/NREFA(1,I)
          AFOFC(1,I) = AFOFC(1,I)/NREFA(1,I)
          AFCFC(1,I) = AFCFC(1,I)/NREFA(1,I)
          ASIG(1,I)  = ASIG(1,I)/NREFA(1,I)
        END IF
        IF(NREFA(2,I).GT.0) THEN
          HRFAC_SHELL_FREE(I)  = AFOMFC(2,I)/AFO(2,I)
          HWRFAC_SHELL_FREE(I)  = WFOMFC(2,I)/WFO(2,I)
          hwr2fac_shell_free(i) = sqrt(wfomfc2(2,i)/wfofo(2,i))

          AFC(2,I)   = AFC(2,I)/NREFA(2,I)
          AFO(2,I)   = AFO(2,I)/NREFA(2,I)
          AFOFO(2,I) = AFOFO(2,I)/NREFA(2,I)
          AFOFC(2,I) = AFOFC(2,I)/NREFA(2,I)
          AFCFC(2,I) = AFCFC(2,I)/NREFA(2,I)
          ASIG(2,I)  = ASIG(2,I)/NREFA(2,I)
        END IF
      ENDDO
C
      HD_HIGH = 0.5/SMAXB(NBIN)
      HD_LOW  = 0.5/SMINB(1)
      hd_low  = 0.5/smin_data
      NREFMNPAR = NREFA(1,NB1) - NREF_PARS
      COMPL     = FLOAT(NREFA(1,NB1))/FLOAT((NREFA(1,NB1)+
     +            NREFM(1,NB1)+NREFA(2,NB1)+NREFM(2,NB1)))
C
      HESU_CRUIC = 0.0
      IF(NREFMNPAR.GT.0) THEN
        HESU_CRUIC = SQRT(FLOAT(N_REFINED_ATOMS)/FLOAT(NREFMNPAR))*
     +              COMPL**(-0.333333)*HD_HIGH*HRFAC_SHELL_WORK(NB1)
      ENDIF
C
      IF(FREER_FLAG.AND.NREFA(2,NBIN+1).GT.0) THEN
        HESU_FREE = SQRT(FLOAT(N_REFINED_ATOMS)/FLOAT(NREFA(1,NB1)))*
     +        COMPL**(-0.333333)*HD_HIGH*HRFAC_SHELL_FREE(NB1)
      ENDIF
C
      HCORR_FOFC  = 0.0
      DENOM1       = (AFOFO(1,NB1) - AFO(1,NB1)*AFO(1,NB1))*
     &              (AFCFC(1,NB1) - AFC(1,NB1)*AFC(1,NB1))
      IF(DENOM1.GT.0.0)
     &           HCORR_FOFC=(AFOFC(1,NB1)-AFO(1,NB1)*AFC(1,NB1))/
     &                      SQRT(DENOM1)
      IF(FREER_FLAG) THEN
        DENOM1 =     (AFOFO(2,NB1) - AFO(2,NB1)*AFO(2,NB1))*
     &              (AFCFC(2,NB1) - AFC(2,NB1)*AFC(2,NB1))
        IF(DENOM1.GT.0.0)HCORR_FOFC_FREE = 
     &           (AFOFC(2,NB1)-AFO(2,NB1)*AFC(2,NB1))/
     &           SQRT(DENOM1)
      ENDIF
C
C---Save for harvesting. It could be used for monitoring statistics
C---outside this routine
c      NHREFL_WORK       = NREFA(1,NB1)
      RFACTOR_WORK      = HRFAC_SHELL_WORK(NB1)
      RWFACTOR_WORK     = HWRFAC_SHELL_WORK(NB1)
      r2wfactor_work    = hwr2fac_shell_work(nb1)
      PERC_FREE         = 0.0
      IF(FREER_FLAG.AND.NREFA(2,NB1).GT.0) THEN
         NHREFL_FREE     = NREFA(2,NB1)
         RFACTOR_FREE    = HRFAC_SHELL_FREE(NB1)
         RWFACTOR_FREE   = HWRFAC_SHELL_FREE(NB1)
         r2wfactor_free = hwr2fac_shell_free(nb1)
         IF(NHREFL_WORK+NHREFL_FREE.GT.0)
     &        PERC_FREE       = 
     &        FLOAT(NHREFL_FREE)/FLOAT(NHREFL_WORK+NHREFL_FREE)*100.0
      ENDIF
C
C-----
      !stop
      RETURN
      END
C
      SUBROUTINE ML1CF(NREF,ndens,hkl_asym,FO,SIGO,H_A,H_B,fwt,FC,PHASE,
     &                 FREER)
      use weights
      use agreem
      use rharvest
      use solvent_all
      use CellAndSymmetry
      use refi_flags
C
C----Subroutine to calculate coefficients for fourie transformation
C----for gradient calculation for Maximization likelihood without
C----phase information
C----
C----In the absence of phase information likelihood function becomes 
C----very simple (see Theory.doc and references from there
C
C-----  FC and PHASE will contain coefficients for FFT for gradient calc
C-----  FO           will contain coefficients for FFT for Hessian calc
C-----  SIGO         will contain coefficients for FFT for f'' contributions to Hessian 
C-----  FREER        flag for free_R calculation
C
c----   FO(IR+i*NOBS) and SIGO(IR+i*NOBS) will contain coefficients for FFT for i-th model
C
      IMPLICIT NONE
      REAL FO(*),SIGO(*),FREER(*)
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      REAL H_A(*),H_B(*)
      real fwt(*)
      INTEGER hkl_asym(3,*),ndens
C
C----Values inbins for agreements
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      include 'anom.fh'
C
      INTEGER NREF
      INTEGER IHH(3),IBBB,NFREE,IFREE,I,IR,ICENT,ISYSAB,IBIN,IB,I_INTER,
     &        NPART1,NPART2,j,i_max,ID
      integer nref_used, ibin_ml, ibbb_ml, calcABCD, adn, hm, mod2, 
     &        ibin_mlsc
      real w_h
      real rsq1
      REAL    HH(3),RSQ,RHO,EPSI,EXPAN,SBS,YO,YC,PHCC,
     &        SIGMA,DFDA,DFDB,DFDAA,SCALE_P,SCALE_NOW,A_ALL,B_ALL,
     &        DFDBB,FVALUE,FOM,SIGMAA,DFDA1,DFDB1,DFDAB,WT1,SIGMA_IN,
     &        STL_C,PH,PHIB, HL(4)
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART), a_extra,b_extra
      REAL SIGN_NOW, SIGP_NOW, SIGN2_NOW, SIGN2P_NOW, YOP,YOM,SIGP12_NOW
      REAL DSIGP2_NOW, sigi_now, is, SIGH_NOW
      real SIGP2_NOW(NMAXPART),SIGP2P_NOW, D_A, D_B, D_PAR(NMAXPART*2+2)
      real SP_NOW(NMAX_SIG),SN_NOW(NMAX_SIG)
      real DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,DFDAApp,DFDBBpp,
     &     DFDABpp,DFDAppB, YON,YOD,SIGON,SIGOD,SIGOPL,SIGOMI,SIGOP2,
     &     SIGOM2, DFDAp,DFDBp,dfdapbp,dfdapap,dfdbpbp
      real der2_now(2*maxn_models), w_aver(maxbin,2*maxn_models)
      real SMEANB(maxbin), temp, consts, fomml(maxbin)
      real sigaa, sigaa_aver, d_aver,d_aver2, sigaa2,sigaa2_aver
      real hlout(4)
      integer w_arr(maxbin),dimen,dnum,num4phib,i2,nref_mlsc(maxbin)
      logical process, rice_bin, observed_refl
c may make this a ("secret") option if it turns out useful
      logical nofisher_flag
      CHARACTER FILE_NAME*256
      INTEGER OMP_GET_THREAD_NUM
      integer ipos
      real abcd(4)
      REAL LSTLSQ
      EXTERNAL LSTLSQ
      nofisher_flag = .false.
      if (.not.DPPI_no) then
        call return_mat_dim(dimen)
        if (DPPI_sad.or.DPPI_sadh.or.DPPI_pl.or.DPPI_sir.or.DPPI_hldm)
     &     i_max=2 
        if (DPPI_sras) i_max=3
        if (DPPI_mad) i_max=6
        if (dm_flag) i_max=i_max+1
      endif
      call num_inp_mod(mod2)
      do IB=1,NBIN_ML
        fomml(ib)=0.
        nref_mlsc(ib)=0
      enddo
      do IB=1,NBIN
        w_aver(IB,1:ndens) = 0.
        w_arr(IB) = 0
        SMEANB(IB) = (SMINB(IB)+SMAXB(IB))/2
      enddo
      SP_NOW(1:NMAX_SIG)=0.
      SN_NOW(1:NMAX_SIG)=0.
      hl(1:4)=0.
cd      SAVE /BINS_NUM/
C
      do i=1,nform_ano
        derfpp(i)=0.
        der2fpp(i)=0.
      enddo
c
      NPART1 = NPART + 1
      NPART2 = NPART + 2
      NBIN_ML1 = NBIN_ML + 1
c
      if (dm_flag) then
        scale_ml2(1:nbin_ml2,2)=scale_ml2(1:nbin_ml2,2)*dm_d_blur
      endif
      if (VERBREF_5N) then
        write(*,'(A,i3,A)') 'There is ',n_atom_ano,' anomalously '//
     +    'scattering/heavy atoms.'
        write(*,*) 'HEAVY ATOMS PARAMATERS: '
        hm=1
        if (DPPI_sras.or.DPPI_sir) hm=2
        do i = 1, N_ATOM_mod(hm)
          if (cs_anom(ID_SF_mod(i,hm))) then 
            write(*,'(i5,A,A5,f8.3,f8.3,f8.3,f6.2,f6.3)') 
c            write(*,'(i5,A,A5,f8.3,f8.3,f8.3,f6.2,f6.3,f6.2,f6.2)') 
     +        i,' ',cs_element(id_sf_mod(i,hm)),XYZ_CRD_mod(1,i,hm),
     +        XYZ_CRD_mod(2,i,hm),XYZ_CRD_mod(3,i,hm),
     +        (U_ANISO_mod(1,i,hm)-u_add_loc)*PISQ8,OCCUP_mod(i,hm)
c     +        ,(U_ANISO_mod(2,i,hm)-u_add_loc)*PISQ8,
c     +        (U_ANISO_mod(3,i,hm)-u_add_loc)*PISQ8
          endif
        enddo
      endif
      if (VERBREF_5N) then
        if (.not.DPPI_no) then
          write(*,*) 'IBIN,   SIGN1,   SIGN2,    SIGN3,     SIGP1,  '//
     +     '    SIGP2,    SIGP3,   D_1,  D_2,  D_3,  D_4,  D_5'
          do IBIN = 1,NBIN_ML2
            write(*,822)IBIN,sigm_N(IBIN,1),sigm_N(IBIN,2),
     +	      sigm_N(IBIN,3),sigm_P(IBIN,1),sigm_P(IBIN,2),
     +        sigm_P(IBIN,3),SCALE_ML2(IBIN,1),SCALE_ML2(IBIN,2),
     +        SCALE_ML2(IBIN,3),SCALE_ML2(IBIN,4),SCALE_ML2(IBIN,5),
     +        SCALE_ML2(IBIN,6),SCALE_ML2(IBIN,7)
  822      format(i3,f11.0,f11.0,f11.0,f11.0,f11.0,f11.0,f6.3,f6.3,f6.3,
     +            f6.3,f6.3,f6.3,f6.3)
          enddo
        endif
ccb      call flush(6)
      endif
      if (dm_flag) then
        nref_used=0
        sigaa_aver=0.
        sigaa2_aver=0.
        d_aver=0.
        d_aver2=0.
        i2=6
        if (dppi_sras) i2=7
        do IBIN = 1,NBIN_ML2
         if (sigm_N(ibin,1).gt.0..or.SIGN(ibin).gt.0) then
           sigaa=SCALE_ML2(IBIN,2)*
     &       sqrt(sigm_P(ibin,i_max)*scale_ml2(ibin,5)/sigm_N(ibin,1))
           sigaa2=SCALE_ML2(IBIN,i2)*
     &       sqrt(sigm_P(ibin,1)*scale_ml2(ibin,1)/sigm_N(ibin,1))
           sigaa_aver=sigaa_aver+sigaa
           sigaa2_aver=sigaa2_aver+sigaa2
           d_aver=d_aver+SCALE_ML2(IBIN,2)
           d_aver2=d_aver2+SCALE_ML2(IBIN,i2)
           nref_used=nref_used+1
         endif
        enddo
        sigaa_aver=sigaa_aver/nref_used
        sigaa2_aver=sigaa2_aver/nref_used
        d_aver=d_aver/nref_used
        d_aver2=d_aver2/nref_used
        write(*,823)'Overall sigmaa is',sigaa_aver
        if(dm_model_flag)write(*,823)'Overall sigmaa2 is',sigaa2_aver
        write(*,823)'Overall Luzzati D is',d_aver
        if(dm_model_flag)write(*,823)'Overall Luzzati D2 is',d_aver2
  823   format(A,f7.3)
      endif
C
      NFREE = 1
      IF(FREER_FLAG) NFREE = 2
      FXRAY = 0.0
      FXFREE = 0.0
C
C---Initialize 
      DO   I=1,NBIN
        DO   IFREE = 1,NFREE
C
C---Acentric reflections
          NREFA(IFREE,I)   = 0
          FOMAVA(IFREE,I)  = 0.0
C
C----Centric reflections
          NREFC(IFREE,I)   = 0
          FOMAVC(IFREE,I)  = 0.0
          D_ML(IFREE,I)   = 0.0
        ENDDO
      ENDDO

C
      w_ave = 0.0
      nref_used = 0
      I_INTER = -1
      DO    IR=1,NREF
        observed_refl = .false.
        if (SIGO(IR)*fwt(ir).gt.0.0) observed_refl=.true.
        if (.not.observed_refl.and..not.dppi_no) then
          do i=1,dataset_num_tot-1
            if (.not.observed_refl.and.SIGO(IR+i*NOBS)*fwt(ir).gt.0.0) 
     &      then
              observed_refl=.true.
              FO(ir) = FO(IR+i*NOBS)
              SIGO(ir) = SIGO(IR+i*NOBS)
            endif
          enddo
        endif
        IF(.not.observed_refl.AND.LREFIN) THEN
           FO(IR)    = 0.0
           SIGO(IR)  = 0.0
           if (DPPI_sras) then
             FO(IR+nref)    = 0.0
             SIGO(IR+nref)  = 0.0
           endif
           FC(IR,1:ndens)    = 0.0
           PHASE(IR,1:ndens) = 0.0
           GOTO 120
        ENDIF
        if(.not.observed_refl .and..NOT.LREFIN) GOTO 120
        if(fwt(ir).le.0.0.and. .not.LREFIN) goto 120
        IFREE = 1
        IF(FREER_FLAG)THEN 
          IF((ABS(FREER(IR)-LFreeRexcludeVal).LT.0.01)) IFREE = 2
        END IF
        ihh(1:3) = hkl_asym(1:3,ir)
        RSQ =  LSTLSQ(1,IHH(1),IHH(2),IHH(3))
        HH(1) = FLOAT(IHH(1))
        HH(2) = FLOAT(IHH(2))
        HH(3) = FLOAT(IHH(3))
        RHO = SQRT(RSQ)
        STL_C = 2.0*RHO
        CALL CENTR(IHH,ICENT)
        CALL EPSLON(IHH,EPSI,ISYSAB)
        EXPAN = EXP(-RSQ*B_LS_OVER) 
C
C---Find bin number
        IBIN = 0
        DO  IBBB=1,NBIN
          IF(RHO.GE.SMINB(IBBB).AND.RHO.LE.SMAXB(IBBB)) 
     &             IBIN = IBBB
        ENDDO
        if (.not.dppi_no) then
          IBIN_ml = 0
          do ibbb_ml=1,NBIN_ML2
            IF ( STL_C.LE.SMAXB_ML2(IBbb_ml).AND.
     &           STL_C.GT.SMINB_ML2(IBbb_ml)  )   ibin_ml = ibbb_ml
          enddo
          IBIN_mlsc = 0
          do ibbb_ml=1,NBIN_ML
           IF(STL_C.LE.SMAXB_ML(Ibbb_ml).AND.STL_C.GT.SMINB_ML(IBbb_ml))
     &        ibin_mlsc = ibbb_ml
          enddo
          call useorigrice(i_max,ibin_ml,rice_bin)
        endif

        IF(LREFIN.AND.IBIN.LE.0.OR.
     &     (.not.dppi_no.and.IBIN_ml.LE.0) .OR. 
     &     STL_C.LT.SMINB_ML(1).OR.STL_C.GT.SMAXB_ML(NBIN_ML)) THEN
          FC(IR,1:ndens)     = 0.0
          PHASE(IR,1:ndens)  = 0.0
          SIGO(IR)   = 0.0
          FO(IR)     = 0.0
          if (DPPI_sras) then
            FO(IR+nref)    = 0.0
            SIGO(IR+nref)  = 0.0
          endif
          GOTO 120
        ENDIF
20      CONTINUE
C
        YO    = FO(IR)
        CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
        a_extra=0.
        b_extra=0.
        hl(1:4)=0.
        if (dm_flag) then
c check for NaN, get A_DM, B_DM
          if (fc(ir,ndens).ne.fc(ir,ndens)) goto 120
          if (phase(ir,ndens).ne.phase(ir,ndens)) goto 120
          a_extra=fc(ir,ndens)*cos(phase(ir,ndens))
          b_extra=fc(ir,ndens)*sin(phase(ir,ndens))
        endif
        if (DPPI_no) then
          WT1 = REAL(1+ICENT)*EPSI
        else
          wt1 = epsi
        endif
        IF(SIGMA_REFINE_STYLE.EQ.'BINS') THEN
          A_ALL = 0.0
          B_ALL = 0.0
          IF(NPART.GT.0) THEN
            DO  I=1,NPART
            CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,I),STL_C,
     &                              I_INTER,SCALE_NOW)
              if (DPPI_no) then
                A_ALL = A_ALL + A_CALCS(I)*SCALE_NOW
                B_ALL = B_ALL + B_CALCS(I)*SCALE_NOW
              else
                A_ALL = A_ALL + A_CALCS(I)
                B_ALL = B_ALL + B_CALCS(I)
              endif
            ENDDO
          ENDIF
          CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,NPART1),
     &                              STL_C,I_INTER,SCALE_P)
          if (.not.dppi_no) then
            call return_Dnum(Dnum)
            D_PAR(1:Dnum) = SCALE_ML2(Ibin_ml,1:Dnum)
            SCALE_P = D_PAR(2)
          endif
          if (DPPI_no) then
            A_ALL = A_ALL + A_CALCS(NPART1)*SCALE_P
            B_ALL = B_ALL + B_CALCS(NPART1)*SCALE_P
          else
            A_ALL = A_ALL + A_CALCS(NPART1)
            B_ALL = B_ALL + B_CALCS(NPART1)
          endif
          if ((dppi_sras.or.dppi_sir).and.mod2.lt.2) then
            A_ALL=0
            B_ALL=0
          endif
          if (DPPI_no) then
            CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGMA_ML,STL_C,
     &                              I_INTER,SIGMA_IN)
          else
            CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGN,STL_C,
     &                              I_INTER,SIGN_NOW)  
            SIGN_NOW = SIGN_NOW*WT1
            CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP,STL_C,
     &                              I_INTER,SIGP_NOW)  
      	    SIGP_NOW = SIGP_NOW*WT1
            if (.not.DPPI_pl) then
            CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP2(1,1),STL_C,
     &                              I_INTER,SIGP2_NOW(1))
      	    SIGP2_NOW(1) = SIGP2_NOW(1)*WT1
            endif
            CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP2(1,2),STL_C,
     &                              I_INTER,SIGP2_NOW(2))
      	    SIGP2_NOW(2) = SIGP2_NOW(2)*WT1
            CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP2(1,3),STL_C,
     &                              I_INTER,SIGP2_NOW(3))
      	    SIGP2_NOW(3) = SIGP2_NOW(3)*WT1
            sigi_now = 0.
c add mad
            if (DPPI_sad.or.DPPI_sadh) then
              YOP  = FO(dataset_order(1)*NOBS+IR)
              YOM  = FO(dataset_order(2)*NOBS+IR)
              SIGOPL = SIGO(dataset_order(1)*NOBS+IR)
              SIGOMI = SIGO(dataset_order(2)*NOBS+IR)
            else  if (DPPI_sir.or.DPPI_mldr.or.DPPI_pl) then
              YON  = FO(dataset_order(1)*NOBS+IR)
              YOD  = FO(dataset_order(2)*NOBS+IR)
              SIGON = SIGO(dataset_order(1)*NOBS+IR)
              SIGOD = SIGO(dataset_order(2)*NOBS+IR)
            else  if (DPPI_sras) then
              YON  = FO(dataset_order(1)*NOBS+IR)
              SIGON  = SIGO(dataset_order(1)*NOBS+IR)
              YOP  = FO(dataset_order(2)*NOBS+IR)
              YOM  = FO(dataset_order(3)*NOBS+IR)
              SIGOPL  = SIGO(dataset_order(2)*NOBS+IR)
              SIGOMI  = SIGO(dataset_order(3)*NOBS+IR)
            else if (DPPI_hldm) then
              HL(1)  = phase(nobs*(npart+1)+IR,1)
              HL(2)  = phase(nobs*(npart+2)+IR,1)
              HL(3)  = phase(nobs*(npart+3)+IR,1)
              HL(4)  = phase(nobs*(npart+4)+IR,1)
            endif
            do i=1,i_max
              SN_NOW(i) = sigm_N(IBin_ml,i)*WT1
              SP_NOW(i) = sigm_P(IBin_ml,i)*WT1
C this can happen for instance if datasets are of different resolution
              if (SN_NOW(i).lt.0.001) SN_NOW(i) = 0.
              if (SP_NOW(i).lt.0.001) SP_NOW(i) = 0.
c       write(*,*) 'after:',SN_NOW(i),SP_NOW(i)
            enddo
            SIGN_NOW = SIGN(IBin_ml)*wt1
            SIGP_NOW = SIGP(IBin_ml)*wt1
c              write(*,*) 'sp_values: ',ir,SP_NOW(1),SP_NOW(2),SP_NOW(3)
c              write(*,*) 'sn_values: ',ir,Sn_NOW(1),Sn_NOW(2),Sn_NOW(3)
c
ccc          ID = OMP_GET_THREAD_NUM()
            ID = 1
            calcABCD=0
            num4phib=-1;
            if (DPPI_sad.or.DPPI_sadh.or.DPPI_hldm) then
        call SAD_DMYFUNCDAB_ML(ICENT,SIGN_NOW,SN_NOW(1),SP_NOW(1),
     +  SIGP_NOW,SIGP2_NOW(1),SIGO(IR),SIGOPL,SIGOMI, YO,YOP,YOM,
     +	A_ALL,B_ALL,H_A(ir),H_B(ir),A_extra,B_extra, IR,PHASE,
     +  D_PAR(1),DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM,PHIB,HL(1),
     +  sigi_now,sigp12_now,DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,
     +  DFDAApp,DFDBBpp,DFDABpp,DFDAppB,ID,VERBREF_5N,calcABCD)
c      write(*,*) 'reflexion',ir,ihh(1),ihh(2),ihh(3),icent,ibin_ml,ibin
c      write(*,*)  YOP,YOM,SIGOPL,SIGOmi,sqrt(A_ALL**2+B_ALL**2),
c     +  atan2(B_ALL,A_ALL),sqrt((H_A(ir))**2+(H_B(ir))**2),
c     +  atan2((H_B(ir)),(H_A(ir)))
c      write(*,*) SN_NOW(1),SN_NOW(2),SP_NOW(1),SP_NOW(2)
c      write(*,*) fvalue,DFDA,DFDB,DFDAA,DFDBB,DFDApp,DFDBpp,
c     +  DFDAppApp,DFDBppBpp,PHIB
            else if (DPPI_sir.or.DPPI_mldr.or.DPPI_pl) then
        call SIR_DMYFUNCDAB_ML(ICENT,SIGN_NOW,SIGN2_NOW,SIGN2P_NOW,
     +  SN_NOW(1),SP_NOW(1),sigp_now,SIGP2_NOW(1),SIGP2P_NOW,SIGO(IR),
     +	SIGON,SIGOD,YO,YON,YOD,A_ALL,B_ALL,H_A(ir),H_B(ir),IR,PHASE,
     +  D_PAR(1),DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM,PHIB,HL,
     +  sigp12_now,sigh_now,DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,
     +  DFDAApp,DFDBBpp,DFDABpp,DFDAppB,ligin1, num4phib,ID)
            else if (DPPI_sras) then
c        if (substruct_flag.and.SP_NOW(2).gt.0.) SIGP_NOW = SP_NOW(2)
        call SIRAS_DMYFUNCDAB_ML(ICENT,SN_NOW(1),SP_NOW(1),SIGN_NOW,
     +  SIGP_NOW,SIGP2_NOW(1),SIGON,SIGOPL,SIGOMI,YON,YOP,YOM,
     +	A_ALL,B_ALL,H_A(ir),H_B(ir),H_A(ir+NOBS),H_B(ir+NOBS),a_extra,
     +  b_extra,IR,PHASE,D_PAR(1),DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,
     +  FOM,PHIB,HL,sigp12_now,sigh_now,DFDAp,DFDBp,DFDApp,DFDBpp,
     +  DFDApAp,DFDBpBp,DFDAppApp,DFDBppBpp, num4phib,ID)
cc              if (ir.lt.00000.and.ppi.eq.'sras') then
c          write(*,*) 'fvalue,dfda,dfdb',ir,fvalue,dfda,dfdb,dfdaa,dfdbb
cc              endif
cc              flush(6)
            endif
            if (FVALUE.ge.100.and.lrefin) then
c          if (.not.dppi_no.and.FVALUE.ge.1000000.and.lrefin) then
              FO(IR)    = 0.0
              SIGO(IR)  = 0.0
              if (DPPI_sras) then
                FO(IR+nref)    = 0.0
                SIGO(IR+nref)  = 0.0
              endif
              FC(IR,1:ndens)    = 0.0
              PHASE(IR,1:ndens) = 0.0
              if (verbref_5N) write(*,*)'Too big function value',fvalue,
     +         'for reflection',ir,'with indices',ihh(1:3),icent,ibin_ml
              goto 120
            endif	  	  
          endif
        ELSE
          rsq1 = 4.0*rsq
          CALL CALC_ASANDBS_MLGAUSS(RSQ1,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
          CALL CALC_SCALE_P(RSQ1,SCALE_P)

          SIGMA_IN  = 0.0
          SIGMA_IN  = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                                 SIGMA_ML_B_OVER*RSQ
     &                               + SIGMA_ML_B1_OVER*RSQ*RSQ
          SIGMA_IN = SIGMA_IN        + SIGMA_ML_B2_OVER*RSQ*RSQ*RSQ
          SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))
        ENDIF
        if (DPPI_no) then 
          SIGMA_IN = SIGMA_IN*WT1
          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
          CALL DFUNCDAB_ML(ndens,ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,
     &                     DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,hlout,FOM)
C
          abcd(1:4) = 0.0
          if(MIR_FLAG) then
             ipos = (npart+1)*nobs + ir
             abcd(1) = phase(ipos,1)
             ipos = ipos+nobs
             abcd(2) = phase(ipos,1)
             ipos = ipos + nobs
             abcd(3) = phase(ipos,1)
             ipos = ipos + nobs
             abcd(4) = phase(ipos,1)
          endif
          CALL INTEGRATE_INFO(ndens,icent,sigma,yo,a_all,b_all,abcd,
     &                        w_h)
           if (.not.dppi_no) then
             dfdap = 0.
             dfdbp = 0.
             dfdapp = 0.
             dfdbpp = 0.
             dfdapap = 0.
             dfdbpbp = 0.
             dfdappapp = 0.
             dfdbppbpp = 0.
           endif
        endif
        yc = sqrt(a_all**2+b_all**2)
c
        IF(LREFIN) THEN
          IF(IFREE.EQ.1) THEN
            if (DPPI_no) then 
              DFDA      = DFDA*SCALE_P
              DFDB      = DFDB*SCALE_P
            endif 
            do i=1,ndens
              FC(IR,i)    = 0.0
              PHASE(IR,i) = 0.0
            enddo
            FC(IR,1)    = fwt(ir)*(-SQRT(DFDA**2+DFDB**2)/(2.0)*EXPAN)
            IF(ABS(FC(IR,1)).NE.0.0) PHASE(IR,1) = ATAN2(DFDB,DFDA)
            if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras) then 
              adn=2
              if (DPPI_sras) then
                FC(IR,3) =fwt(ir)*(-SQRT(DFDAp**2+DFDBp**2)/(2.0)*EXPAN)
                IF(ABS(FC(IR,3)).NE.0.0) PHASE(IR,3)=ATAN2(DFDBp,DFDAp)
                adn=4
              endif
              FC(IR,adn)=fwt(ir)*(-SQRT(DFDApp**2+DFDBpp**2)/2.*EXPAN)
              IF(ABS(FC(IR,adn)).NE.0.0) 
     &          PHASE(IR,adn) = ATAN2(-DFDApp,DFDBpp)
cd     &          PHASE(IR,2) = ATAN2(DFDBpp,DFDApp)
c             write(*,*)DFDAp,DFDBp,DFDApp,DFDBpp
c             call flush(6)
            endif
          	if ((DPPI_pl.and.dimen.eq.4).or.DPPI_sir) then
          	  FC(IR,2) = fwt(ir)*(-SQRT(DFDApp**2+DFDBpp**2)/2.0*EXPAN)
          	  IF(ABS(FC(IR,2)).NE.0.0)PHASE(IR,2) = ATAN2(DFDBpp,DFDApp)
            endif
            nref_used = nref_used + nint(fwt(ir)*(1+icent))
            if (DPPI_no) then
              w_ave = w_ave + fwt(ir)*w_h
              FO(IR)   =  fwt(ir)*(1.0/sigma*SCALE_P**2*
     &                 real(NSMULT)*IFACTOR_CC*EXPAN**2)
              sigo(ir) = 0.
              if (nofisher_flag) then
                FO(IR)   =  abs(dfdaa + dfdbb)*SCALE_P**2
              endif
              if (dppi_sras) then
                FO(IR+nobs) = 0.
                SIGO(IR+nobs) = 0.
              endif
            else
              adn=adn/2-1
              if ( der2der1_flag ) then
c not adding fwt here, they will be added later in this routine.
                FO(IR) = (dfda**2 + dfdb**2)
                if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras) then 
                  SIGO(IR+adn*nref) = (dfdapp**2 + dfdbpp**2)
                  if (DPPI_sras) then
                    FO(IR+nref) = (dfdap**2 + dfdbp**2)
                    SIGO(IR) = 0.
                  endif
                endif
                if ((DPPI_pl.and.dimen.eq.4).or.DPPI_sir) then
                  FO(IR+nref) = abs(dfdApp**2+dfdBpp**2)
                  SIGO(IR) = 0.
                  SIGO(IR+nref) = 0.
                endif
              else 
                FO(IR) = abs(dfdaa + dfdbb)
                if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras) then 
                  SIGO(IR+adn*nref) = abs(dfdAppApp + dfdBppBpp)
                  if (DPPI_sras) then
                    FO(IR+nref) = abs(dfdApAp+dfdBpBp)
                    SIGO(IR) = 0.
                  endif
                endif
                if ((DPPI_pl.and.dimen.eq.4).or.DPPI_sir) then
                  FO(IR+nref) = abs(dfdAppApp+dfdBppBpp)
                  SIGO(IR) = 0.
                endif
c                FO(IR) = max(0.0,dfdaa + dfdbb)
c                SIGO(IR) = max(0.0,dfdAppApp + dfdBppBpp)
              endif
            endif
          ELSE
            FC(IR,1:ndens)    = 0.0
            PHASE(IR,1:ndens) = 0.0
            SIGO(IR)  = 0.0
            FO(IR)    = 0.0
            if (DPPI_sras) then
              FO(IR+nref)    = 0.0
              SIGO(IR+nref)  = 0.0
            endif
          ENDIF
        ENDIF
C>IJT
C
        IF (IFREE.EQ.1) THEN
          FXRAY = FXRAY + FVALUE
        ELSE
          FXFREE = FXFREE + FVALUE
        ENDIF
C<IJT
C
C---Some statistics. This part should be removed
        if(ibin.gt.0) then
         IF(ICENT.EQ.0) THEN
           FOMAVA(IFREE,IBIN)  = FOMAVA(IFREE,IBIN) + fwt(ir)*FOM
           NREFA(IFREE,IBIN)   = NREFA(IFREE,IBIN)  + nint(fwt(ir))
         ELSE
           FOMAVC(IFREE,IBIN)  = FOMAVC(IFREE,IBIN) + fwt(ir)*FOM
           NREFC(IFREE,IBIN)   = NREFC(IFREE,IBIN)  + nint(fwt(ir))
         ENDIF
         D_ML(IFREE,IBIN) = D_ML(IFREE,IBIN) + fwt(ir)*SCALE_P
        endif
        if(dm_flag.and.ibin_mlsc.gt.0) then
          FOMML(IBIN_mlsc) = FOMML(IBIN_mlsc) + fwt(ir)*FOM
          nref_mlsc(IBIN_mlsc) = nref_mlsc(IBIN_mlsc) + fwt(ir)
        endif
120      CONTINUE

      ENDDO
c
      if(LREFIN) THEN
        if (nref_used.gt.0) w_ave = w_ave/float(nref_used)
        der2_now(1:ndens) = 0.
        do   ir=1,nref
           ihh(1:3) = hkl_asym(1:3,ir)
          RSQ =  LSTLSQ(1,IHH(1),IHH(2),IHH(3))
          RHO = SQRT(RSQ)
          if (.not.dppi_no) then
            STL_C = 2.0*RHO
            IBIN_ml = 0
            do ibbb_ml=1,NBIN_ML2
              IF ( STL_C.LE.SMAXB_ML2(IBbb_ml).AND.
     +           STL_C.GT.SMINB_ML2(IBbb_ml)  )   ibin_ml = ibbb_ml
            enddo
            if (ibin_ml.ne.0) 
     &        call useorigrice(i_max,ibin_ml,rice_bin)
          endif
          if ((DPPI_no).and..not.nofisher_flag) then 
            fo(ir) = 2.0*w_ave*fo(ir)
          else
            process=.false.
            if (fwt(ir)*sigo(ir).gt.0..or.fo(ir)*fwt(ir).gt.0.) 
     +        process=.true.
            if (dppi_sras.or.dppi_sir) then 
              if (fwt(ir)*fo(ir+nobs).gt.0.)  process=.true.
            endif
            if (process) THEN
              DO  ibin=1,NBIN
                if (RHO.GE.SMINB(ibin).AND.RHO.LT.SMAXB(ibin)) then
                  w_aver(ibin,1) = w_aver(ibin,1) + fo(ir)
                  w_aver(ibin,2) = w_aver(ibin,2) + sigo(ir)
                  if (DPPI_sras) then
                    w_aver(ibin,3) = w_aver(ibin,3) + fo(ir+nref)
                    w_aver(ibin,4) = w_aver(ibin,4) + sigo(ir+nref)
                  endif
                  w_arr(ibin) = w_arr(ibin) + 1
                endif
              ENDDO
            endif
          endif
        enddo
        if ((.not.DPPI_no).or.nofisher_flag) then 
          temp = 0
          do ib = 1, NBIN
      	    if ( der2equal_flag ) then
              temp = temp + w_arr(ib)
              der2_now(1:ndens) = der2_now(1:ndens) + w_aver(ib,1:ndens)
            else 
              w_aver(ib,1:ndens) = w_aver(ib,1:ndens) / w_arr(ib)
            endif
          enddo
          if ( der2equal_flag ) then
            der2_now(1:ndens) = der2_now(1:ndens) / temp 
c          write(6,*) 'All equal to ', der2_now
          endif
          do   ir=1,nref
             ihh(1:3) = hkl_asym(1:3,ir)
            RSQ =  LSTLSQ(1,IHH(1),IHH(2),IHH(3))
            RHO = SQRT(RSQ)
            if (.not.dppi_no) then
              STL_C = 2.0*RHO
              IBIN_ml = 0
              do ibbb_ml=1,NBIN_ML2
                IF ( STL_C.LE.SMAXB_ML2(IBbb_ml).AND.
     +            STL_C.GT.SMINB_ML2(IBbb_ml)  )   ibin_ml = ibbb_ml
              enddo
              call useorigrice(i_max,ibin_ml,rice_bin)
            endif
              if ( .not.der2equal_flag ) then
                do i=1,ndens
                  CALL  LINTER_VALUE2(NBIN,SMEANB,w_aver(1,i),RHO,
     &                              I_INTER,der2_now(i))
                enddo
              endif
              process=.false.
              if (fwt(ir)*sigo(ir).gt.0..or.fo(ir)*fwt(ir).gt.0.) 
     +          process=.true.
              if (dppi_sras.or.dppi_sir) then 
                if (fwt(ir)*fo(ir+nobs).gt.0.)  process=.true.
              endif
              if (process) THEN
      	        EXPAN = EXP(-RSQ*B_LS_OVER) 
c               FO(IR)   =  (DFDA*DFDA+DFDB*DFDB) *
c     &                   real(NSMULT)*IFACTOR_CC*EXPAN**2
                consts = fwt(ir)*real(NSMULT)*IFACTOR_CC*EXPAN**2 /2.
                FO(IR)   = consts*der2_now(1)
                SIGO(IR) = consts*der2_now(2)
                if (DPPI_sras) then
                  FO(IR+nref) = consts*der2_now(3)
                  SIGO(IR+nref) = consts*der2_now(4)
                endif
              else
                FO(IR)   = 0.
                SIGO(IR)   = 0.
                if (DPPI_sras) then
                  FO(IR+nref) = 0.
                  sigO(IR+nref) = 0.
                endif
              endif
c            if (.not.der2der1_flag ) FO(IR)   =  FO(IR) / 2.
c            if (.not.der2der1_flag ) SIGO(IR) =  SIGO(IR) / 2.
c            if (DPPI_sras) then
c              if (.not.der2der1_flag ) FO(IR+nref)   = FO(IR+nref) /2.
c              if (.not.der2der1_flag ) SIGO(IR+nref) = SIGO(IR+nref) /2.
c            endif
          enddo
c
        endif
      endif
C
C---Report statistics
      DO   IFREE = 1,NFREE
         NREFOVERA(IFREE) = 0
         NREFOVERC(IFREE) = 0
         NREFOVERT(IFREE) = 0
         FOMOVERA(IFREE)  = 0.0
         FOMOVERC(IFREE)  = 0.0
         FOMOVERT(IFREE)  = 0.0
      ENDDO 
      DO    IB=1,NBIN
C
C---Statistics for acentric reflection
        DO    IFREE=1,NFREE
          IF(NREFA(IFREE,IB).GT.0) THEN
            FOMOVERA(IFREE)   = FOMOVERA(IFREE)+FOMAVA(IFREE,IB)
            FOMAVA(IFREE,IB)  = FOMAVA(IFREE,IB)/REAL(NREFA(IFREE,IB))
            NREFOVERA(IFREE) = NREFOVERA(IFREE)+NREFA(IFREE,IB)
          ENDIF
C
C---Centric reflections
          IF(NREFC(IFREE,IB).GT.0) THEN
            FOMOVERC(IFREE)   = FOMOVERC(IFREE)+FOMAVC(IFREE,IB)
            FOMAVC(IFREE,IB)  = FOMAVC(IFREE,IB)/REAL(NREFC(IFREE,IB))
            NREFOVERC(IFREE) = NREFOVERC(IFREE)+NREFC(IFREE,IB)
          ENDIF
          IF(NREFA(IFREE,IB)+NREFC(IFREE,IB).GT.0) THEN
            D_ML(IFREE,IB) = D_ML(IFREE,IB)/
     &        REAL(NREFA(IFREE,IB)+NREFC(IFREE,IB))
          ENDIF
        ENDDO
      ENDDO
c      if (dm_flag.and.write_luzzd_flag) then
c        do IB=1,NBIN_ML
c          SCALE_ML(IB,2) = FOMML(IB)/NREF_MLSC(IB)
c        enddo
c        call write_luzzd(scale_ml,Dnum,nbin_ml,MAXBIN+1,NMAXP1+1)
c      endif
      DO    IFREE = 1,NFREE
        NREFOVERT(IFREE) = NREFOVERA(IFREE)+NREFOVERC(IFREE)
        IF(NREFOVERT(IFREE).GT.0) THEN
           FOMOVERT(IFREE) = (FOMOVERA(IFREE)+FOMOVERC(IFREE))/
     +                        REAL(NREFOVERT(IFREE))
        ENDIF
        IF(NREFOVERA(IFREE).GT.0) THEN
          FOMOVERA(IFREE) = FOMOVERA(IFREE)/REAL(NREFOVERA(IFREE))
        ENDIF
        IF(NREFOVERC(IFREE).GT.0) THEN
          FOMOVERC(IFREE) = FOMOVERC(IFREE)/REAL(NREFOVERC(IFREE))
        ENDIF
      ENDDO
c      write(6,*) 'Total Function value : ', FXRAY
C
      RETURN
      END
C
      subroutine integrate_info(ndens,icent,sigma,yo,a_all,b_all,
     &        abcd,w_h)
      use refi_flags
      implicit none
      integer icent,ir,ndens
      real abcd(4)
      real sigma,yo,a_all,b_all,w_h
      real phase(nobs,ndens)
C
      integer i
      integer ipos
      integer npoint_int
      real yo1,yc,yc1,yc2,sigma1
      real alpha
      real ha,hb,hc,hd
      real sqrt2
      real small_value
      real x_1,xx,xx1,xx2,xx3,t1
      real fom
      real w_h1
      real sum1,cosa0,sina0
      real w_n(64),x_n(64)
      real x_n0,y_cs,y_cc,x_m1,x_m2,x_m12,arg_subtr,w_n0,expp
      real arg_max
      real exp_r
      external exp_r
      data arg_max/50.0/,small_value/1.0E-7/
C
      yc = sqrt(a_all*a_all+b_all*b_all)
C
c---  Do normalisation. Epsilon has already been applied. centrosymmeticity
C---  also has been added to sigma.
C
      sigma1 = sqrt(sigma)
      yo1 = yo/sigma1
      yc1 = yc/sigma1
      yc2 = yc1
C
C--if yc is very small then take small value
C
      if(yc1.le.0.0001)then
        w_h  = small_value
        return
      endif
      if(yc1.gt.20.0) then
        if(icent.eq.0) then
          w_h = 0.5
        else
          w_h = 1.0
        endif
      endif
C
C---calculate phases if we need them
      alpha = 0.0
      if(MIR_FLAG) THEN
        if(yc.gt.0.0) alpha = atan2(b_all,a_all)
        ha   = abcd(1)
        hb   = abcd(2)
        hc   = abcd(3)
        hd   = abcd(4)
      else
        ha = 0.0
        hb = 0.0
        hc = 0.0
        hd = 0.0
      endif

C
C---start integration
      w_h = 0.0
      w_h1 = 0.0
      sum1 = 0.0
      sqrt2 = sqrt(2.0)
      call get_integr_points(npoint_int,yc1*sqrt2,w_n,x_n)
cd      npoint_int = 4
cd      call GAUSS_COEF_TAB_A2INF(npoint_int,yc1*sqrt2,
cd     &        x_n,w_n)
cd      do i=1,npoint_int
cd        x_n(i) = x_n(i)/sqrt2
cd        w_n(i) = w_n(i)*sqrt2
cd      enddo
cd      write(*,*)yc1,icent
cd      do i=1,npoint_int
cd         write(*,*)w_n(i),x_n(i)
cd      enddo
      cosa0 = cos(alpha)
      sina0 = sin(alpha)

      arg_subtr = 0.0
      if(icent.eq.0) then
        do  i=1,npoint_int
          x_n(i) = x_n(i)/sqrt2
          w_n0 = alog(w_n(i)*sqrt2)
          x_1 = yc1 + x_n(i)
          xx = 2.0*x_1*yc1
C
C---  We need fom and value of I0 or corresponding function from
C---  phased distribution
C
          call calc_fom_acent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
          xx3 = xx2 - xx + w_n0 + log(xx1)
C
C---Stabilise by rescaling
C
          if(i.eq.1) then
            if(abs(xx3).gt.arg_max) then
              arg_subtr = xx3
              xx3 = 0.0
              t1 = x_1
            else
              arg_subtr = 0.0

              t1 = x_1*exp(xx3)
cd              write(*,*)xx3,exp_r(xx3)
            endif
            sum1 = t1
            w_h = (fom*x_1-yc1)**2*t1
          else
            xx3 = xx3 - arg_subtr
            if(xx3.gt.arg_max) then
              arg_subtr = xx3 - arg_max
              xx3 = xx3 - arg_subtr
              if(arg_subtr.gt.arg_max) then
                sum1 = 0.0
                w_h  = 0.0
              else
                expp = exp(-arg_subtr)
                sum1 = sum1*expp
                w_h  = w_h*expp
              endif
            endif
            t1   = x_1*exp(xx3)
            sum1 = sum1 + t1
            w_h = w_h + (fom*x_1-yc1)**2*t1
          endif
cd          w_h1 = w_h1 + (1.0-x_1**2*(1.0-fom**2))*t1
        enddo
        w_h = amin1(0.5,w_h/sum1)

      else
        yc2 = yc1*sqrt2
        do   i=1,npoint_int
cd          x_n(i) = x_n(i)
          w_n0 = alog(w_n(i))
          x_1 = yc2 + x_n(i)
          xx = x_1*yc2
C
C---  We need fom and value of I0 or corresponding function from
C---  phased distribution
C
          call calc_fom_cent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
cd          write(*,*)fom,xx,xx1,xx2
          xx3 = xx2 - xx + w_n0 + log(xx1)

C
C---Stabilise by rescaling
C
          if(i.eq.1) then
            if(abs(xx3).gt.arg_max) then
              arg_subtr = xx3
              xx3 = 0.0
              t1 = 1.0
             else
               t1 = exp(xx3)
            endif
            sum1 = t1
            w_h = (fom*x_1-yc2)**2*t1
          else
            xx3 = xx3 - arg_subtr
            if(xx3.gt.arg_max) then
              arg_subtr = xx3 - arg_max
              xx3 = xx3 - arg_subtr
              if(arg_subtr.gt.arg_max) then
                sum1 = 0.0
                w_h  = 0.0
              else
                expp = exp(-arg_subtr)
                sum1 = sum1*expp
                w_h  = w_h*expp
              endif
            endif
            t1   = exp(xx3)
            sum1 = sum1 + t1
            w_h = w_h + (fom*x_1-yc2)**2*t1
          endif
cd          xx3 = xx2 - xx
cd          t1  = xx1*exp(xx3)
cd          sum1 = sum1 + t1
cd          w_h  = w_h  + (fom*x_1-yc2)**2*t1

        enddo
        w_h = amin1(1.0,w_h/sum1)
      endif
cd      if(w_h.gt.1.0) then
cd         write(*,*)w_h,icent,arg_subtr,yo1,yc1
cd         stop
cd      endif
cd      w_h1 = w_h1/sum1
cd      if(icent.eq.0) then
cd        write(*,*)w_h,w_h1,sum1
cd        stop
cd      endif
C
cd      write(51,*)icent,w_h,sum1,yo1,yc1,ha,hb,hc,hd
      return
      end
C
      subroutine get_integr_points(npoint,yc2,w_n,x_n)
      implicit none
      include 'gaussian.fh'
      integer npoint
      real yc2
      real w_n(*),x_n(*)
C
      integer i,i_access
C
      i_access = max(1,min(ntab_integr,
     &         int((yc2-x_0_integr)/delta_integr)+1))
      npoint = npoint_int
      do   i=1,npoint
        x_n(i) = x_points_int(i,i_access)
        w_n(i) = w_points_int(i,i_access)
      enddo

      return
      end
C
      subroutine calc_fom_acent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
      use refi_flags
      implicit none
      real cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2

      real ha1,hb1,cosaa,sinaa
      real sim
      external sim

      if(MIR_FLAG) THEN
C
C--we have phases. Do numerical integration
        ha1 = ha + cosa0*xx
        hb1 = hb + sina0*xx
        call phprob_2(ha1,hb1,hc,hd,cosaa,sinaa,xx1,xx2)
        fom = sqrt(cosaa*cosaa+sinaa*sinaa)
        
      else
        fom = sim(xx)
        call bessi0(xx,xx1,xx2)
      endif
      return
      end
C
      subroutine calc_fom_cent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
      use refi_flags
      implicit none
      real cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2
C
      real ha1,hb1
      real xx0

      if(MIR_FLAG) THEN
C
C--we have phases. Use them
C
         ha1 = ha + cosa0*xx
         hb1 = hb + sina0*xx
         xx0 = sqrt(ha1*ha1+hb1*hb1)
         if(xx0.gt.50.0) then
           fom = 1.0
           xx1 = 0.5
           xx2 = xx0
         else
           fom = tanh(xx0)
           xx1 = cosh(xx0)
           xx2 = 0.0
         endif
cd         write(52,*)xx,xx0,xx1,fom,ha,hb,ha1,hb1
      else
        if(xx.gt.50.0) then
          fom = 1.0
          xx1 = 0.5
          xx2 = xx
        else
          fom = tanh(xx)
          xx1 = cosh(xx)
          xx2 = 0.0
        endif
      endif
      return
      end
C
      SUBROUTINE INDTORS(hkl,RSQ)
      implicit none
      integer hkl(3)
      real rsq
      REAL LSTLSQ
      EXTERNAL  LSTLSQ
      RSQ =  4.0 * LSTLSQ(1,hkl(1),hkl(2),hkl(3))
      RETURN
      END

      subroutine aniso_contrs_notwin(nref,hkl_asym,aniso_contrs)
      use agreem
      use CellAndSymmetry
      implicit none
                                !
                                !   body      
      integer nref
      integer hkl_asym(3,*)
      real aniso_contrs(*)
                                !locals
      integer ir
      integer hkl(3)
      real s1,s2,s3,sbs

      do ir=1,nref
         hkl(1:3) = hkl_asym(1:3,ir)
         s1 = float(hkl(1))*rcell(1)
         s2 = float(hkl(2))*rcell(2)
         s3 = float(hkl(3))*rcell(3)
      
         sbs              = s1*(b_ls_aniso_over(1)*s1+
     &                      2.0*b_ls_aniso_over(4)*s2+
     &                      2.0*b_ls_aniso_over(5)*s3)  +
     &                      s2*(b_ls_aniso_over(2)*s2+
     &                      2.0*b_ls_aniso_over(6)*s3) +
     &                       s3*b_ls_aniso_over(3)*s3
         if(sbs.gt.89.0) then
            aniso_contrs(ir) = 0.0
         else
            aniso_contrs(ir) = exp(-sbs)
         endif
      enddo


      end


