
module weights
  !
  !---Common blocks for weighting different residuals
  !
  ! depends on models.fh 
  !
  ! WDSKAL      overall weight for distances
  ! SIGD        overall sigma for bond distances
  !....
  !------------------------------------------------------
  real sigb_kl(6),sigr_kl(6)
  REAL DVDW_CUT_MIN,DVDW_CUT_MIN_X
  real sd_ext_min,sd_ext_cut
  real delta_ext,dmax_ext,dmin_ext
  real sigx_ncs_local,dmax_ncs_local,diffmax_ncs_local
  REAL WDSKAL,WDSKAL2,WBSKAL,SIGSPH,WPSKAL,WBS_RIGID_B,SIG_RIGID_B
  real WCSKAL,WVSKAL,WTSKAL,WSSKAL,SIGC,SIGPP,SIGPA,WASKAL
  real DINC_DUMMY,VDW_SDI_DUMMY
  real :: w_gm_in=1.0e-3
  REAL SIGD(9),SIGT(4),SIGB(8),SIGS(6),VDW_SDI_VDW,VDW_SDI_TORSION
  real VDW_SDI_HBOND,VDW_SDI_METAL,HBOND_DINC_AD,HBOND_DINC_AH
  real DINC_TORSION,DINC_TORSION_O,DINC_TORSION_N,DINC_TORSION_C,DINC_TORSION_ALL
  !
  !---Weights for x_ray functional
  !
  ! NSIGMA      number of bins where differebt weights should be applied
  ! ALPHEXP     SIGMEXP  = ALPHEXP*SIGEST
  ! ALPHCH      SIGEST should be changed if current sigest is less than
  !             sigestold*(1-ALPHCH).
  ! SIGEXP      expected sigma
  ! SIGEST      estimated sigma
  !
  INTEGER MAXBIN
  PARAMETER (MAXBIN =500)
  INTEGER MAXBIN_2
  PARAMETER (MAXBIN_2 = 56)
  INTEGER NMAXP1
  PARAMETER (NMAXP1 = 10)
  INTEGER NMAX_SIG
  PARAMETER (NMAX_SIG = 10)
  integer MAXN_MODEL_secder
  parameter (MAXN_MODEL_secder = 4)
  ! warning: another MAXN_MODELS is defined in weights.fh (these two should be identical though)
  REAL            WEIGHTXMAT,WEIGHTAUTO
  real zb_mx,zb_mn,zb_reduce,zb_increase
  LOGICAL  LEXPUSE,MLEXPUSE
  CHARACTER WEIGHT*4
  CHARACTER SIGMA_REFINE_STYLE*4
  character weight_adjust*4
  !
  !---
  CHARACTER BINT*4,REFS*4
  REAL PDEL,BDEL,QDEL,PRADIUS,BRADIUS,QRADIUS
  INTEGER NBIN,NBIN_ML,NREF_ML(MAXBIN+1), NBIN_ML2
  INTEGER NBIN_RAD
  REAL SMINB(MAXBIN+1),SMAXB(MAXBIN+1),SMINB_ML(MAXBIN+1),SMAXB_ML(MAXBIN+1),SIGMA_ML(MAXBIN+1)
  real SCALE_ML(MAXBIN+1,NMAXP1+1), SMEANB_ML(MAXBIN+1),SIGMA_ML1(MAXBIN+1),S_RAD,B_RAD,SMEANB2_ML(MAXBIN+1)
  REAL SMINB_ML2(MAXBIN_2+1),SMAXB_ML2(MAXBIN_2+1),SMEANB_ML2(MAXBIN_2+1),SCALE_ML2(MAXBIN_2+1,NMAXP1+1)
  REAL SMEANB_RAD(MAXBIN+1)
  REAL RESMAX,RESMIN,SMINS,SMAXS,BINSIZE_ML,STLMIN_ML,STLMAX_ML
  INTEGER NBIN_ML1
  REAL KERNEL_G,KERNEL_G_RAD
  real sigma_ml_bin(maxbin+1)
  !
  REAL D_ML_SCALE_OVER,D_ML_B_OVER,D_ML_SCALE_BBULK,D_ML_B_BBULK
  REAL D_ML_SCALE_PART(NMAXP1),D_ML_B_PART(NMAXP1)
  REAL SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER,SIGMA_ML_B1_OVER
  REAL SIGMA_ML_B2_OVER
  REAL SIGMA_ML_SCALE_BBULK,SIGMA_ML_B_BBULK
  REAL SMIN_TCH,SMAX_TCH
  REAL SCALE_SEC,B_SEC,B1_SEC,B2_SEC
  INTEGER N_POINTS_TABLE_S
  REAL DELTA_S_TABLE
  real SEC_TABLE_SMOOTH(10000,MAXN_MODEL_secder)
  real SEC_TABLE_SMOOTH_pp(10000,MAXN_MODEL_secder)
  !
  LOGICAL ML_BULK_REFINE_FLAG,ML_PART_REFINE_FLAG(NMAXP1)
  LOGICAL ML_SIGMA_BULK_REFINE_FLAG

  !
  !---Factor for Tasos to test
  !
  REAL TASOSFACTOR
!
  real SEC_DER_BIN(MAXBIN+1,MAXN_MODEL_secder)
  real SEC_DER_BIN_pp(MAXBIN+1,MAXN_MODEL_secder)
  INTEGER NREF_SEC_BIN(MAXBIN+1,MAXN_MODEL_secder)
  real w_ave
  !
  REAL SIGN(MAXBIN),SIGP(MAXBIN),SIGN2(MAXBIN),SIGN2P(MAXBIN)
  real DSIGP2(MAXBIN),SIGi(MAXBIN),SIGP12(MAXBIN),SIGH(MAXBIN)
  REAL SIGP2(MAXBIN,NMAXP1), MAX_SC_ML, MIN_SC_ML, SIGP2P(MAXBIN)
  real  SIGM_N(MAXBIN_2,NMAX_SIG), SIGM_P(MAXBIN_2,NMAX_SIG)
  !
  !  parameters for some of the restraints
  logical :: harm_bweight=.FALSE.

end module weights
