c
c---set of subroutines dealing with various operation using cell and symmetry.
c
      SUBROUTINE GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      IMPLICIT NONE
      REAL CELL(6),FRAC_XYZ(3)
C
c---Real local arrays
      REAL ALPHA,BETA,GAMMA,COSA,SINA,COSB,SINB,COSG,SING,
     +     VOLUME
C
C---Cell dimensions are assumed to be in radians
      ALPHA = CELL(4)
      BETA  = CELL(5)
      GAMMA = CELL(6)

      COSA = COS(ALPHA)
      SINA = SIN(ALPHA)
      COSB = COS(BETA)
      SINB = SIN(BETA)
      COSG = COS(GAMMA)
      SING = SIN(GAMMA)
      VOLUME = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
C
C----Output brick size
      FRAC_XYZ(1) = SINA/VOLUME
      FRAC_XYZ(2) = SINB/VOLUME
      FRAC_XYZ(3) = SING/VOLUME
C
      RETURN
      END
c
      subroutine calc_ort_etc(cell,frac2ort,ort2frac,ro_unit,rfr_unit)
      implicit none
c
c---  Calculate ortogonalisation and fractionalisation matrices in cell and unit
c---  units
      real cell(6)
c
c---  outputs
      real frac2ort(3,3),ort2frac(3,3),ro_unit(3,3),rfr_unit(3,3)
c
c---  locals
      integer ierror
c
c---  body
      call nb_frorth_r(cell(1),cell(2),cell(3),cell(4),
     &     cell(5),cell(6),frac2ort,ort2frac,ierror)
      call calc_unit_frac(frac2ort,cell,ro_unit)     
      call matinv3_r(ro_unit,rfr_unit)

      return
      end
c
      SUBROUTINE get_grid_spacing_r(fshann,maxsym,nsym,cell,stlmax,
     &     rot,tr,ngrid) 
      implicit none
C
c---Calculates grid spacing using CELL, resolution, symmetry and  shannon's 
c---rate
C
c---Input
      real fshann
      integer maxsym,nsym
      real stlmax
      real cell(6)
      real rot(3,3,maxsym),tr(3,maxsym)
c
c---Output
      integer ngrid(3)
c
c----locals
      INTEGER HMAX,KMAX,LMAX
      integer ngx,ngy,ngz
      integer ipx,ipy,ipz,nmfour
      real smax
      real shh,skk,sll
      real rh0max,rk0max,rl0max
c
c---
      SMAX   = STLMAX

      SHH    = 1.0/CELL(1)**2
      SKK    = 1.0/CELL(2)**2
      SLL    = 1.0/CELL(3)**2
      HMAX   = INT(CELL(1)*SMAX)
      KMAX   = INT(CELL(2)*SMAX)
      LMAX   = INT(CELL(3)*SMAX)
C
C---SZ is size for Structure factors and so on
      RH0MAX = SMAX*CELL(1)
      RK0MAX = SMAX*CELL(2)
      RL0MAX = SMAX*CELL(3)
      NGX    = INT(RH0MAX+SQRT(.25/SHH+RH0MAX**2))+1
      NGY    = INT(RK0MAX+SQRT(.25/SKK+RK0MAX**2))+1
      NGZ    = INT(RL0MAX+SQRT(.25/SLL+RL0MAX**2))+1
C
C----If number of grids were not given calculate them
      CALL ASYLIM_r(maxsym,nsym,rot,tr,IPX,IPY,IPZ,NMFOUR)
      ngrid(1) = INT(NGX*FSHANN)
      ngrid(2) = INT(NGY*FSHANN)
      ngrid(3) = INT(NGZ*FSHANN)
C
C---Now find best numbers
      CALL NXYZ235(ngrid(1),NMFOUR)
      CALL NXYZ235(ngrid(2),NMFOUR)
      CALL NXYZ235(ngrid(3),NMFOUR)
      RETURN
      END
c
      subroutine calc_unit_frac(frac2ort,cell,frac2ort_unit)
      implicit none
      real frac2ort(3,3)
      real cell(6)
      real frac2ort_unit(3,3)
c
c---calcuates unit fractionalisation matrix using frctionalisation matrix
c---and the unit cell 

      frac2ort_unit(1,1) = frac2ort(1,1)/cell(1)
      frac2ort_unit(1,2) = frac2ort(1,2)/cell(2)
      frac2ort_unit(1,3) = frac2ort(1,3)/cell(3)
      frac2ort_unit(2,2) = frac2ort(2,2)/cell(2)
      frac2ort_unit(2,3) = frac2ort(2,3)/cell(3)
      frac2ort_unit(3,3) = frac2ort(3,3)/cell(3)
      frac2ort_unit(2,1) = 0.0
      frac2ort_unit(3,1) = 0.0
      frac2ort_unit(3,2) = 0.0 
      return
      end
c
      subroutine calc_cosa_etal(cell,cosa,cosb,cosg,sina,sinb,sing)
      implicit none
c
c---calculates cos(alpha) and others. Simple enough subroutine
c
      real cell(6)
      real cosa,cosb,cosg,sina,sinb,sing

      cosa = cos(cell(4))
      sina = sin(cell(4))
      cosb = cos(cell(5))
      sinb = sin(cell(5))
      cosg = cos(cell(6))
      sing = sin(cell(6))

      return
      end
c
      subroutine asymlim_frac_r(cell,maxsym,nsym,rot,tr,d1,
     &     xyzlow,xyzupper)
      implicit none
c
c--Using symmetry and radius of atoms find extensions to asymmetric unit
c
c
c---inputs
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      real d1
c
c---output
      real xyzlow(3),xyzupper(3)
c
c--locals
      real twopi
      real dlm
      real v
      real cosa(3),sina(3)
      integer ipxyz(3)
      integer nmfour
      integer i
c
      call calc_cosa_etal(cell,cosa(1),cosa(2),cosa(3),sina(1),sina(2),
     &     sina(3))
      call asylim_r(maxsym,nsym,rot,tr,ipxyz(1),ipxyz(2),ipxyz(3),
     &    nmfour)

      v = sqrt(1-cosa(1)**2+cosa(2)**2-cosa(3)**2+
     &     2.0*cosa(1)*cosa(2)*cosa(3))
      twopi = 8.0*atan2(1.0,1.0)
      dlm = sqrt(60.0*d1)/twopi
      do  i=1,3
        xyzlow(i) =                    -dlm*sina(i)/(v*cell(i))
        xyzupper(i) = (cell(i)/ipxyz(i)+dlm*sina(i)/v)/cell(i)
      enddo
      
      return
      end
c
      subroutine take_noncub(maxsym,nsym,nsym_non,rot,tr,
     &     rot_non,tr_non)
      implicit none
c
c--finds number of non cubic symmetries. In a way it finds number of symmeties
c--for which z is transformed to z only.
c
c---inputs
      integer maxsym
      integer nsym
      real rot(3,3,maxsym),tr(3,maxsym)
c
c---outputs
      integer nsym_non
      real rot_non(3,3,maxsym),tr_non(3,maxsym)
c
c---locals
      integer is,i,j
      real eps_loc
      data eps_loc/1.0E-6/
      
      nsym_non = 0
      do  is=1,nsym
        if(abs(rot(3,3,is)).gt.1.0-eps_loc.and.
     &        abs(rot(3,1,is)).le.eps_loc.and.
     &        abs(rot(3,2,is)).le.eps_loc) then
           nsym_non = nsym_non + 1
           do  i=1,3
              do  j=1,3
                 rot_non(i,j,nsym_non) = rot(i,j,is)
              enddo
              tr_non(i,nsym_non) = tr(i,is)
           enddo
        endif
      enddo
      return
      end
C
      subroutine asylim_r(maxsym,nsym,rot,tr,ipx,ipy,ipz,nmfour)
c
      implicit none
      integer maxsym,nsym
      integer nmfour
      integer ipx,ipy,ipz
      real rot(3,3,maxsym),tr(3,maxsym)
c
c--This routine finds limits of asymmetric unit using symmetry operators
c--It finds minimum box along z.
c--It also find multiplicity of grid using symmetry operators
c
      integer factor
      integer i,j,is
      real trmin
      integer maxsym_l
      parameter (maxsym_l = 192)
      integer orders(maxsym_l)
      real tr_loc(3,maxsym_l)
      real rot_loc(3,3),rot_loc1(3,3)
      real eps_loc
      real psi,phi,chi
c
      eps_loc = 1.0e-4
      do  is=1,nsym
        do  i=1,3
          tr_loc(i,is) = tr(i,is)
          do while(tr_loc(i,is).gt.1.0+eps_loc)
             tr_loc(i,is) = tr_loc(i,is)-1.0
          enddo
          do while(tr_loc(i,is).lt.-eps_loc)
             tr_loc(i,is) = tr_loc(i,is) + 1.0
          enddo
        enddo
      enddo
c
c--Find symmetry operators where z does not change its sign.
c
      factor = 1
      trmin = 1.0
      do   is=1,nsym
        if(abs(nint(rot(3,3,is))).eq.1.and.nint(rot(3,2,is)).eq.0.and.
     &         nint(rot(3,1,is)).eq.0) then
c
c--It is a non cube symmetry. Analyse it
          if(nint(rot(3,3,is)).le.1.0.and.
     &          abs(tr(3,is)).gt.eps_loc)then
            trmin = min(trmin,tr_loc(3,is))
          endif
          if(nint(rot(3,3,is)).eq.-1.0.and.
     &             abs(tr_loc(3,is)).le.eps_loc) then
            factor = 2
          endif
        endif
      enddo
c
      ipx = 1
      ipy = 1
      ipz = factor*nint(1/trmin)
C
C--Find multiplicity. First find the order of all symmetry operators
c
      nmfour = 2
      do  is=1,nsym
        if(abs(nint(rot(3,3,is))).eq.1.and.
     &         nint(rot(3,2,is)).eq.0.and.
     &         nint(rot(3,1,is)).eq.0) then
          call polar(rot(1,1,is),psi,phi,chi)
          do while(chi.ge.360.0+eps_loc)
            chi = chi - 360.0
          enddo
          do while(chi.le.eps_loc) 
            chi = chi + 360.0
          enddo
          if(chi.le.180.0+eps_loc) then
            orders(is) = nint(360.0/chi)
          else
            orders(is) = 1
          endif
        else
          orders(is) = 1
        endif
      enddo
      do  is=1,nsym
        if(orders(is).eq.6) then
          nmfour = 6
          goto 10
        endif
      enddo
      do  is=1,nsym
        if(orders(is).eq.4) then
          nmfour = 4
          goto 5
        endif
      enddo
 5    continue
      do  is=1,nsym
        if(orders(is).eq.3) then
          nmfour = nmfour*3
          goto 10
        endif
      enddo
 10   continue
      nmfour = max(nmfour,ipz)
c     
      return
      end
c
      SUBROUTINE NXYZ235(NX,NM)
      IMPLICIT NONE
      INTEGER NX,NM
c
c-----This subroutine changes NX so that NM becames multiplier of NX
c-----and other multipliers are 2,3,5 and returns new value of NX 
c----Make sure NM is multiplier of NX
      INTEGER N1
      INTEGER IPR,NPR
      INTEGER PRIMES(3)
cd      DATA PRIMES/2,3,5,7,11,13,17,19/
      DATA PRIMES/2,3,5/
      DATA NPR/3/

      IF(MOD(NX,NM).NE.0) NX = NX-MOD(NX,NM)+NM
1     CONTINUE
      N1 = NX/NM
2     CONTINUE
c
c-----Chek if 2,3,5 is multiplier of NX if there is another multiplier then
c-----change NX and check again
c
      IF(N1.EQ.1)RETURN
      DO  IPR=1,NPR
         IF(MOD(N1,PRIMES(IPR)).EQ.0) THEN
             N1 = N1/PRIMES(IPR)
             GOTO 2
         ENDIF
      ENDDO
      NX = NX + NM
      GOTO 1
      END 
c
      subroutine calc_epsls_centrs(nasym,maxsym,nsym,rot,hkl,epsls,
     &     centrs)
      implicit none
c
c---inputs
      integer nasym,maxsym,nsym
      integer hkl(3,nasym)
      real rot(3,3,maxsym)
c
c---outputs
      real epsls(nasym),centrs(nasym)
c
c--locals
      integer i,isysab,icent
      real eps1
      integer maxsym_l
      integer irot(3,3,192)
c
c---body
      maxsym_l = 192
      irot(1:3,1:3,1:nsym) = nint(rot(1:3,1:3,1:nsym))
      do  i=1,nasym
         call geneps_centr(hkl(1,i),maxsym_l,nsym,irot,epsls(i),icent)
         centrs(i) = real(icent)
      enddo
      return
      end
c
      subroutine geneps_centr(hkl,maxsym,nsym,irot,eps1,icent)
      implicit none
c
c--   generate epsilon and centrosymmetricity for a given hkl
      integer maxsym,nsym
      integer hkl(3),irot(3,3,maxsym)
c
c--   outputs
      real eps1
      integer icent
c
c--   locals
      integer is
      integer h0(3),h1(3),h2(3)
      logical error
c
c---  body
      eps1 = 1.0
      icent = 0
      if(nsym.gt.1) then
         call imat2vect(3,3,irot(1,1,1),hkl,h0,error)
         do   is=2,nsym
            call imat2vect(3,3,irot(1,1,is),hkl,h1,error)
            if(h0(1).eq.h1(1).and.h0(2).eq.h1(2).and.
     &           h0(3).eq.h1(3)) eps1=eps1+1.0
            h2(1:3) = h0(1:3) + h1(1:3)
            if(h2(1).eq.0.and.h2(2).eq.0.and.h2(3).eq.0) then
               icent = 1
            endif
         enddo
      endif
      return
      end
c
      subroutine define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      implicit none
      real cell(6)
      real ast,bst,cst,cosast,cosbst,coscst
C
C---Cell angles must be in radians
      real vol,volunit
      real cosa,cosb,cosc,sina,sinb,sinc

      cosa = cos(cell(4))
      cosb = cos(cell(5))
      cosc = cos(cell(6))
      sina = sin(cell(4))
      sinb = sin(cell(5))
      sinc = sin(cell(6))
      volunit = sqrt(1.0-cosa**2-cosb**2-cosc**2+2.0*cosa*cosb*cosc)
      vol = cell(1)*cell(2)*cell(3)*volunit
      ast = cell(2)*cell(3)*sina/vol
      bst = cell(1)*cell(3)*sinb/vol
      cst = cell(1)*cell(2)*sinc/vol
      cosast = (cosb*cosc-cosa)/(sinb*sinc)
      cosbst = (cosa*cosc-cosb)/(sina*sinc)
      coscst = (cosa*cosb-cosc)/(sina*sinb)
      return
      end
C
      subroutine define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
      implicit none
      integer h,k,l
      real ast,bst,cst,cosast,cosbst,coscst
      real rsq

      rsq = h*ast*(h*ast+2.0*(k*bst*coscst+l*cst*cosbst)) +
     &      k*bst*(k*bst+2.0*l*cst*cosast) + 
     &      l*l*cst*cst

      return
      end
C
      subroutine sysabs_symm_r(maxsym,nsym,rot,tr,h,k,l,isysabs)
      implicit none
      integer isysabs
      integer h,k,l
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
C
      integer hnew,knew,lnew
      integer is
      real del
C
      isysabs = 1
      do  is = 1,nsym
        hnew = nint(h*rot(1,1,is) + k*rot(2,1,is) + l*rot(3,1,is))
        if(hnew.ne.h) goto 200
        knew = nint(h*rot(1,2,is) + k*rot(2,2,is) + l*rot(3,2,is))
        if(knew.ne.k) goto 200
        lnew = nint(h*rot(1,3,is) + k*rot(2,3,is) + l*rot(3,3,is))
        if(lnew.ne.l) goto 200
        del = h*tr(1,is) + k*tr(2,is) + l*tr(3,is)
        if(abs(del-float(nint(del))).gt.0.05) return
 200  continue
      enddo

      isysabs = 0
      return
      end
c
      subroutine symm2int_by12_1(maxsym,nsym,sym_in,trans_in,
     &  sym_out,trans_out)
C
C---Converts rotation and translation operator to integer after
C---multiplying by 12
C
      implicit none
      integer maxsym,nsym
      real sym_in(3,3,maxsym),trans_in(3,maxsym)
      integer sym_out(3,3,maxsym),trans_out(3,maxsym)
C
      integer i,j,is
C
      do   is=1,nsym
         do  i=1,3
           do  j=1,3
              sym_out(i,j,is) = nint(sym_in(i,j,is))
           enddo
           trans_out(i,is) = nint(trans_in(i,is)*12.0)
         enddo
      enddo
      return
      end
c
      SUBROUTINE SYM_FIND_r0(MAXSYM_IN,NumSymmetry,RealSymmMatrx,ISYM1,
     +                   ISYM2,ITX1,ISYM_OUT,ITX_OUT,FIRST)
C
      IMPLICIT NONE
Cc
c----This routine prepares table for inversion and multiplaction of
C----symmetry matrices. Idea is that symmetry is group. So inversion
C----and multiplicaion of two elements should belong to that group also.
C----complication arises when translation is involved. In this case
C----I don't know how to tabulate (yet). At the moment routine could be used
C----for multiplication of inversion of one symmetry operator with 
C----another symmetry operator. It could easily be extended to finding
C----inversion or multiplication of symmetry operators also.
C
C----If symmetry is (R1,T1) then its inversion is (R2,T2) Where R2 is
C----symmetry operator and T2 is -R1^(-1) T2. In last operation translational
C----part of symmetry has been removed
c
c----If R1,T1 and R2,T2 are symmetry operators then multiplication of them
C----is R3,T3, Where R3 is one of symmetry operators and T3 = R1 T2 + T1
C----In all cases care should be taken in cases of screw axis
C
c----Integer arguments
      INTEGER MAXSYM_IN,NumSymmetry
      REAL    RealSymmMatrx(4,4,MAXSYM_IN)

      INTEGER MAXSYM
      PARAMETER (MAXSYM = 192)
      INTEGER ISYM1,ISYM2,ITX1(3),ISYM_OUT,ITX_OUT(3)

      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_LOCAL(3,3,MAXSYM),TRANS_LOCAL(3,MAXSYM),
     +     SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
      REAL EPS_LOCAL

      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      DATA EPS_LOCAL/1.0E-3/
      SAVE   /SYMM_INV/


      IF(FIRST.EQ.0) THEN
        FIRST = 1
        DO   IS=1,NumSymmetry
          DO   J=1,3
            DO   I=1,3
              SYMM_LOCAL(I,J,IS) = RealSymmMatrx(I,J,IS)
            ENDDO
            TRANS_LOCAL(J,IS) = RealSymmMatrx(J,4,IS)
          ENDDO
        ENDDO
        DO    IS=1,NumSymmetry
           CALL MATINV3_R(SYMM_LOCAL(1,1,IS),SYMM_INVERS(1,1,IS))
           CALL MAT2VEC(3,3,SYMM_INVERS(1,1,IS),TRANS_LOCAL(1,IS),
     +                  TRANS_OUT,ERROR)
          DO   I=1,3
             TRANS_OUT(I) = -TRANS_OUT(I)
          ENDDO
          
          IF(ERROR) then
             write(*,*)'In SYM_FIND after calling MATINV3'
             stop
          endif
          DO   IS1=1,NumSymmetry
            DELTA = 0.0
            DO   J=1,3
              DO   I=1,3
                DELTA = DELTA + 
     +              ABS(SYMM_INVERS(I,J,IS)-SYMM_LOCAL(I,J,IS1))
              ENDDO
            ENDDO
            IF(DELTA.LT.EPS_LOCAL) THEN
              DELTA1 = 0.0
              TTX     = TRANS_OUT(1)-TRANS_LOCAL(1,IS1)
              ITTX    = NINT(TTX)
              DELTA1  = ABS(TTX-FLOAT(ITTX))
              TTY     = TRANS_OUT(2)-TRANS_LOCAL(2,IS1)
              ITTY    = NINT(TTY)
              DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
              TTZ     = TRANS_OUT(3)-TRANS_LOCAL(3,IS1)
              ITTZ    = NINT(TTZ)
              DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
              IF(DELTA1.LT.EPS_LOCAL) THEN
                ISYM_INV(IS)     = IS1
                ITRANS_INV(1,IS) = ITTX
                ITRANS_INV(2,IS) = ITTY
                ITRANS_INV(3,IS) = ITTZ
                GOTO 10
              ENDIF
            ENDIF
          ENDDO
 10       CONTINUE
          DO   IS1=1,NumSymmetry
            CALL MAT2MAT(3,3,SYMM_LOCAL(1,1,IS),SYMM_LOCAL(1,1,IS1),
     +           SYMM_OUT,ERROR)
            CALL MAT2VEC(3,3,SYMM_LOCAL(1,1,IS),TRANS_LOCAL(1,IS1),
     +           TRANS_OUT,ERROR)
            DO   I=1,3
              TRANS_OUT(I) = TRANS_OUT(I) + TRANS_LOCAL(I,IS)
            ENDDO
            DO   IS2=1,NumSymmetry
              DELTA = 0.0
              DO   J=1,3
                DO   I=1,3
                  DELTA = DELTA + ABS(SYMM_OUT(I,J)-SYMM_LOCAL(I,J,IS2))
                ENDDO
              ENDDO
              IF(DELTA.LT.EPS_LOCAL) THEN
                DELTA1 = 0.0
                TTX     = TRANS_OUT(1)-TRANS_LOCAL(1,IS2)
                ITTX    = NINT(TTX)
                DELTA1  = ABS(TTX-FLOAT(ITTX))
                TTY     = TRANS_OUT(2)-TRANS_LOCAL(2,IS2)
                ITTY    = NINT(TTY)
                DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
                TTZ     = TRANS_OUT(3)-TRANS_LOCAL(3,IS2)
                ITTZ    = NINT(TTZ)
                DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
                IF(DELTA1.LT.EPS_LOCAL) THEN
                  SYMM_MULT(IS,IS1)         = IS2
                  SYMM_MULT_TRANS(1,IS,IS1) = ITTX
                  SYMM_MULT_TRANS(2,IS,IS1) = ITTY
                  SYMM_MULT_TRANS(3,IS,IS1) = ITTZ
                  GOTO 20
                ENDIF
              ENDIF     
            ENDDO
 20         CONTINUE
          ENDDO
        ENDDO
      ENDIF
C
C---find multiplicatation of inverse of symmetry with symmetry.
C---If symmetr is (R,T) then (R1,T1)^1 (R2,T2) = (R3,T3). 
C---Where T3 = R1^1(T2-T1)
C
C---First find Inversion matrix
      IF(ISYM1.EQ.ISYM2.AND.ITX1(1).EQ.0.AND.
     +                      ITX1(2).EQ.0.AND.
     +                      ITX1(3).EQ.0) THEN
         ISYM_OUT   = SYMM_MULT(ISYM_INV(ISYM1),ISYM2)
         ITX_OUT(1) = 0
         ITX_OUT(2) = 0
         ITX_OUT(3) = 0
         RETURN
      ENDIF
      ISYM_INV_OUT = ISYM_INV(ISYM1)

      DO    I = 1,3
        IS_TRANS(I) = ITRANS_INV(I,ISYM1)
      ENDDO
C
c---Inverse of symmetry sym1 is ISYM_INV_OUT and corresponding translation
C---is IS_TRANS
c
c---Multiply ISYM_INV_OUT to ISYM2
      ISYM_OUT = SYMM_MULT(ISYM_INV_OUT,ISYM2)
      DO    I=1,3
        IS_TRANS2(I) = SYMM_MULT_TRANS(I,ISYM_INV_OUT,ISYM2)
      ENDDO
C
c---Now find translations
      DO   I=1,3
        TR_OUT(I) = FLOAT(IS_TRANS(I) + IS_TRANS2(I))
        DO   J=1,3
           TR_OUT(I) = TR_OUT(I) + RealSymmMatrx(I,J,ISYM_INV_OUT)*
     +         FLOAT(ITX1(J)) 
         ENDDO
         ITX_OUT(I) = NINT(TR_OUT(I))
         IF(ABS(FLOAT(ITX_OUT(I))-TR_OUT(I)).GT.EPS_LOCAL) THEN
           WRITE(*,*)'ISYM1',ISYM1,ISYM2,ISYM_OUT
           WRITE(*,*)ITX1
           WRITE(*,*)TR_OUT  
           write(*,*)'Problems in SYMM_FIND'
           stop
         ENDIF
      ENDDO
      RETURN
      END
c
      SUBROUTINE SYM_FIND_r(MAXSYM_in,nsym,rot,tr,ISYM1,
     +                   ISYM2,ITX1,ISYM_OUT,ITX_OUT,FIRST)
C
      IMPLICIT NONE
Cc
c----This routine prepares table for inversion and multiplaction of
C----symmetry matrices. Idea is that symmetry is group. So inversion
C----and multiplicaion of two elements should belong to that group also.
C----complication arises when translation is involved. In this case
C----I don't know how to tabulate (yet). At the moment routine could be used
C----for multiplication of inversion of one symmetry operator with 
C----another symmetry operator. It could easily be extended to finding
C----inversion or multiplication of symmetry operators also.
C
C----If symmetry is (R1,T1) then its inversion is (R2,T2) Where R2 is
C----symmetry operator and T2 is -R1^(-1) T2. In last operation translational
C----part of symmetry has been removed
c
c----If R1,T1 and R2,T2 are symmetry operators then multiplication of them
C----is R3,T3, Where R3 is one of symmetry operators and T3 = R1 T2 + T1
C----In all cases care should be taken in cases of screw axis
C
c----Integer arguments
      INTEGER maxsym_in,nsym
      REAL    rot(3,3,maxsym_in),tr(3,maxsym_in)

      INTEGER MAXSYM
      PARAMETER (MAXSYM = 192)
      INTEGER ISYM1,ISYM2,ITX1(3),ISYM_OUT,ITX_OUT(3)

      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
      REAL EPS_LOCAL

      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      DATA EPS_LOCAL/1.0E-3/
      SAVE   /SYMM_INV/


      if(FIRST.EQ.0) then
        FIRST = 1
        call tabulate_symm_inv_mult_r(maxsym,nsym,rot,tr,
     &       symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)
      endif
C     
C---find multiplicatation of inverse of symmetry with symmetry.
C---If symmetr is (R,T) then (R1,T1)^1 (R2,T2) = (R3,T3). 
C---Where T3 = R1^1(T2-T1)
C
C---First find Inversion matrix
      IF(ISYM1.EQ.ISYM2.AND.ITX1(1).EQ.0.AND.
     +                      ITX1(2).EQ.0.AND.
     +                      ITX1(3).EQ.0) THEN
         ISYM_OUT   = SYMM_MULT(ISYM_INV(ISYM1),ISYM2)
         ITX_OUT(1) = 0
         ITX_OUT(2) = 0
         ITX_OUT(3) = 0
         RETURN
      ENDIF
      ISYM_INV_OUT = ISYM_INV(ISYM1)

      is_trans(1:3) = itrans_inv(1:3,isym1)

C
c---Inverse of symmetry sym1 is ISYM_INV_OUT and corresponding translation
C---is IS_TRANS
c
c---Multiply ISYM_INV_OUT to ISYM2
      ISYM_OUT = SYMM_MULT(ISYM_INV_OUT,ISYM2)
      is_trans2(1:3) = symm_mult_trans(1:3,isym_inv_out,isym2)
C
c---Now find translations
      DO   I=1,3
        TR_OUT(I) = FLOAT(IS_TRANS(I) + IS_TRANS2(I))
        DO   J=1,3
           TR_OUT(I) = TR_OUT(I) + rot(I,J,ISYM_INV_OUT)*
     +         FLOAT(ITX1(J)) 
         ENDDO
         ITX_OUT(I) = NINT(TR_OUT(I))
         IF(ABS(FLOAT(ITX_OUT(I))-TR_OUT(I)).GT.EPS_LOCAL) THEN
           WRITE(*,*)'ISYM1',ISYM1,ISYM2,ISYM_OUT
           WRITE(*,*)ITX1
           WRITE(*,*)TR_OUT  
           write(*,*)'Problems in SYMM_FIND'
           stop
         ENDIF
      ENDDO
      RETURN
      END
c
      subroutine symm_mult_r(maxsym_in,nsym,rot,tr,isym1,isym2,
     &     isym_o,ifirst,ierr)
      implicit none
      integer maxsym_in, nsym,ifirst
      real rot(3,3,maxsym_in),tr(3,maxsym_in)
      integer isym1(4),isym2(4),isym_o(4)
      integer ierr
c

      real eps_local
      real tr_out(3)
      integer itx_out(3)
c
      integer i
c
      integer maxsym
      parameter (maxsym=192)
      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM)
      integer SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM)
      integer IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3)
      logical error
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      data eps_local/1.0e-3/
      SAVE   /SYMM_INV/
c
c---  body
      if(ifirst.eq.0) then
         ifirst = 1
         call tabulate_symm_inv_mult_r(maxsym_in,nsym,rot,tr,
     &     symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)
      endif
c
c---  Now use the multiplication table to find the necessary symmetry
c---  operator
      isym_o(1) = symm_mult(isym1(1),isym2(1))
c
c---  Now find translations
      isym_o(2:4) = symm_mult_trans(1:3,isym1(1),isym2(1))+isym1(2:4)
      call mat2vec(3,3,rot(1,1,isym1(1)),float(isym2(2:4)),tr_out,error)
      itx_out(1:3) = nint(tr_out(1:3))
      if(maxval(abs(itx_out(1:3)-tr_out(1:3))).gt.eps_local) then
         write(*,*)isym1
         write(*,*)itx_out,tr_out
         write(*,*)'Problem in symmetry multiplication'
         ierr = 1
         return
      endif
      isym_o(2:4) = isym_o(2:4) + itx_out(1:3)
      return
      end
c
      subroutine symm_inv_r(maxsym_in,nsym,rot,tr,isymin,isymout,
     &     ifirst,ierr)
      implicit none
      integer ifirst
      integer maxsym_in,nsym
      real rot(3,3,maxsym_in),tr(3,maxsym_in)
      integer isymin(4),isymout(4)
      integer ierr
c
      real tr_out(3)
c
      logical error
      real eps_local
      integer maxsym
      parameter (maxsym=192)
      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3)
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      data eps_local/1.0e-3/
      SAVE   /SYMM_INV/

      if(ifirst.eq.0) then
         ifirst = 1
         call tabulate_symm_inv_mult_r(maxsym_in,nsym,rot,tr,
     &     symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)

      endif
c
c---  Use inversion table to the corresponding symmetry
      isymout(1) = isym_inv(isymin(1))
c
c--Take care of translation
      call mat2vec(3,3,rot(1,1,isymout(1)),
     &     float(isymin(2:4)),tr_out,error)
      isymout(2:4) = nint(tr_out(1:3))
      if(maxval(abs(float(isymout(2:4))-tr_out(1:3))).gt.eps_local) then
         write(*,*)'Problem in symmetry inversion'
         ierr = 1
         return
      endif
      isymout(2:4)=itrans_inv(1:3,isymin(1))+isymout(2:4)
      return
      end
c
      subroutine tabulate_symm_inv_mult_r(maxsym_in,nsym,rot,tr,
     &     symm_invers,symm_mult,itrans_inv,symm_mult_trans,isym_inv)
      implicit none
c
      integer maxsym_in,nsym
      real rot(3,3,maxsym_in),tr(3,maxsym_in)
      integer isym_inv(maxsym_in),itrans_inv(3,maxsym_in)
      integer symm_mult(maxsym_in,maxsym_in)
      integer symm_mult_trans(3,maxsym_in,maxsym_in)
      real symm_invers(3,3,maxsym_in)
c
      integer maxsym
      parameter (maxsym=192)
      INTEGER IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
     
      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
c
      real eps_local
      data eps_local/1.0e-3/
c
c---  body
      DO    IS=1,nsym
         CALL MATINV3_R(rot(1,1,IS),SYMM_INVERS(1,1,IS))
         CALL MAT2VEC(3,3,SYMM_INVERS(1,1,IS),tr(1,IS),
     &        TRANS_OUT,ERROR)
         trans_out(1:3) = -trans_out(1:3)         
         IF(ERROR) then
            write(*,*)'In SYM_FIND after calling MATINV3'
            stop
         endif
         DO   IS1=1,nsym
            delta = sum(abs(symm_invers(1:3,1:3,is)-rot(1:3,1:3,is1)))
            IF(DELTA.LT.EPS_LOCAL) THEN
               DELTA1 = 0.0
               TTX     = TRANS_OUT(1)-TR(1,IS1)
               ITTX    = NINT(TTX)
               DELTA1  = ABS(TTX-FLOAT(ITTX))
               TTY     = TRANS_OUT(2)-TR(2,IS1)
               ITTY    = NINT(TTY)
               DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
               TTZ     = TRANS_OUT(3)-TR(3,IS1)
               ITTZ    = NINT(TTZ)
               DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
               IF(DELTA1.LT.EPS_LOCAL) THEN
                  ISYM_INV(IS)     = IS1
                  ITRANS_INV(1,IS) = ITTX
                  ITRANS_INV(2,IS) = ITTY
                  ITRANS_INV(3,IS) = ITTZ
                  GOTO 10
               ENDIF
            ENDIF
         ENDDO
 10      CONTINUE
         DO   IS1=1,nsym
            CALL MAT2MAT(3,3,rot(1,1,IS),rot(1,1,IS1),
     +           SYMM_OUT,ERROR)
            CALL MAT2VEC(3,3,ROT(1,1,IS),TR(1,IS1),
     +           TRANS_OUT,ERROR)
            trans_out(1:3) = trans_out(1:3)+tr(1:3,is)
            DO   IS2=1,nsym
               delta = sum(abs(symm_out(1:3,1:3)-rot(1:3,1:3,is2)))
               IF(DELTA.LT.EPS_LOCAL) THEN
                  DELTA1 = 0.0
                  TTX     = TRANS_OUT(1)-TR(1,IS2)
                  ITTX    = NINT(TTX)
                  DELTA1  = ABS(TTX-FLOAT(ITTX))
                  TTY     = TRANS_OUT(2)-TR(2,IS2)
                  ITTY    = NINT(TTY)
                  DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
                  TTZ     = TRANS_OUT(3)-TR(3,IS2)
                  ITTZ    = NINT(TTZ)
                  DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
                  IF(DELTA1.LT.EPS_LOCAL) THEN
                     SYMM_MULT(IS,IS1)         = IS2
                     SYMM_MULT_TRANS(1,IS,IS1) = ITTX
                     SYMM_MULT_TRANS(2,IS,IS1) = ITTY
                     SYMM_MULT_TRANS(3,IS,IS1) = ITTZ
                     GOTO 20
                  ENDIF
               ENDIF     
            ENDDO
 20         CONTINUE
         ENDDO
      ENDDO
      
      return
      end
c
      subroutine get_symm_from_text(text_in,rot_out,trans_out,ierr)
      implicit none
c
c--Extract symmetry operators from text
      integer ierr
      character text_in*(*)
      real rot_out(3,3)
      real trans_out(3)
c
c---  locals
      integer i,j,l,il,i0,j0
      character text_line(3)*128
c
c---  body
      ierr = 0
      call ccpupc(text_in)
      l=len_trim(text_in)
      il = 0
      i0 = 1
      do i=1,l
         if(text_in(i:i).eq.','.or.text_in(i:i).eq.';'.or.
     &        text_in(i:i).eq.':') then
            il = il + 1
            text_line(il) = text_in(i0:(i-1))
            i0 = i+1
         endif
      enddo
      if(il.ne.3) then
         ierr = 1
         write(*,*)'Problem in get_symm_from_text'
         goto 999
      endif
      rot_out(1:3,1:3) = 0.0
      trans_out(1:3) = 0.0
      do i=1,3
         j0=1
         l = len_trim(text_line(il))
         do j=1,l
            if(text_line(il)(j:j).eq.'*')text_line(il) = ' '
         enddo
         j0=1
         do j=1,l
            if(text_line(il)(j:j).ne.' ') then
               text_line(il)(j0:j0) = text_line(il)(j:j)
               j0 = j0 + 1
            endif
         enddo
         text_line(il)(j0+1:l) = ' '
         l = len_trim(text_line(il))
         j0 = 1
         do j=1,l
            if(text_line(il)(j:j).eq.'H') then
               if(j.eq.1) then
                  rot_out(1,i) = 1.0
               else
                  if(text_line(il)(j-1:j-1).eq.'+') then
                     rot_out(1,i) = 1.0
                  elseif(text_line(il)(j-1:j-1).eq.'-') then
                     rot_out(1,i) = -1.0
                  else
                     read(text_line(il)(j0:j-1),*)rot_out(1,i)
                  endif
               endif
               j0 = j + 1
            else if(text_line(il)(j:j).eq.'K') then
               if(j.eq.1) then
                  rot_out(2,i) = 1.0
               else
                  if(text_line(il)(j-1:j-1).eq.'+') then
                     rot_out(2,i) = 1.0
                  elseif(text_line(il)(j-1:j-1).eq.'-') then
                     rot_out(2,i) = -1.0
                  else
                     read(text_line(il)(j0:j-1),*)rot_out(2,i)
                  endif
               endif
               j0 = j + 1
            else if(text_line(il)(j:j).eq.'L') then
               if(j.eq.1) then
                  rot_out(3,i) = 1.0
               else
                  if(text_line(il)(j-1:j-1).eq.'+') then
                     rot_out(3,i) = 1.0
                  elseif(text_line(il)(j-1:j-1).eq.'-') then
                     rot_out(3,i) = -1.0
                  else
                     read(text_line(il)(j0:j-1),*)rot_out(3,i)
                  endif
               endif
               j0 = j + 1
            endif
         enddo
         if(j0.lt.l) then
            read(text_line(il)(j0:l),*)trans_out(i)
         endif
      enddo
 999  continue
      return
      end
c
      subroutine put_symm_to_text(rot,tr,text_out)
      implicit none
      real rot(3,3),tr(3)
      character text_out*(*)
c
      real eps,tmp,tmp1
      integer i,j,ip,it,k
      character s1*1
      character xyz_c(3)*1,cht*10,cht1*10,cht2*10
      data xyz_c/'H','K','L'/
c
c---  body
      eps = 0.1e-3
      text_out = ' '
      ip = 1
      it = 1
      do i=1,3
         do j=1,3
            if(abs(rot(j,i)).gt.eps) then
               s1 = '-'
               if(rot(j,i).gt.0.0) s1 = '+'
               if(s1.eq.'+'.and.it.eq.1) s1 = ' '
               if(abs(abs(rot(j,i))-1.0).gt.eps) then
                  write(cht,'(f5.3)')rot(j,i)
                  tmp = abs(rot(j,i))
                  do k=2,24
                     tmp1 = tmp*k
                     if(abs(nint(tmp1)-tmp1).lt.eps) then
c                        write(*,*)rot(j,i),
                        write(cht1,'(i2)')nint(tmp1)
                        write(cht2,'(i2)')k
                        cht = trim(adjustl(cht1))//'/'//
     &                       trim(adjustl(cht2))
                        exit
                     endif
                  enddo
                  write(text_out(ip:(ip+7)),'(a1,a,a1)')
     &                 s1,trim(adjustl(cht)),xyz_c(j)
                  ip = len_trim(text_out)+1
               else
                  write(text_out(ip:(ip+1)),'(a1,a1)')s1,xyz_c(j)
                  ip = len_trim(text_out)+1
               endif
               it = 2
            endif
         enddo

         if(abs(tr(i)).gt.eps) then

            s1 = '-'
            if(tr(i).gt.0.0) s1 = '+'
            tmp = abs(tr(i))
            write(cht,'(f5.3)')abs(tr(i))
            do k=2,24
               tmp1 = tmp*real(k)
               if(abs(nint(tmp1)-tmp1).lt.eps) then
                  write(cht1,'(i2)')nint(tmp1)
                  write(cht2,'(i2)')k
                  cht = trim(adjustl(cht1))//'/'//
     &                 trim(adjustl(cht2))
                  exit
               endif
            enddo
            write(text_out(ip:(ip+5)),'(a1,a)')s1,trim(adjustl(cht))
            ip = len_trim(text_out)+1
         endif
         if(i.lt.3) then
            text_out(ip:(ip+1)) = ','
            ip = len_trim(text_out)+2
         endif
         it = 1
      enddo

      return
      end
c
c
      subroutine put_symm_to_text_xyz(rot,tr,text_out)
      implicit none
      real rot(3,3),tr(3)
      character text_out*(*)
c

      real eps,tmp,tmp1
      integer i,j,ip,it,k
      character s1*1
      character xyz_c(3)*1,cht*10,cht1*10,cht2*10
      data xyz_c/'X','Y','Z'/
c
c---  body
      eps = 0.1e-3
      text_out = ' '
      ip = 1
      it = 1
      do i=1,3
         do j=1,3
            if(abs(rot(i,j)).gt.eps) then
               s1 = '-'
               if(rot(i,j).gt.0.0) s1 = '+'
               if(s1.eq.'+'.and.it.eq.1) s1 = ' '
               if(abs(abs(rot(i,j))-1.0).gt.eps) then
                  write(cht,'(f5.3)')rot(i,j)
                  tmp = abs(rot(i,j))
                  do k=2,24
                     tmp1 = tmp*k
                     if(abs(nint(tmp1)-tmp1).lt.eps) then
                        write(cht1,'(i2)')nint(tmp1)
                        write(cht2,'(i2)')k
                        cht = trim(adjustl(cht1))//'/'//
     &                       trim(adjustl(cht2))
                        exit
                     endif
                  enddo
                  write(text_out(ip:(ip+7)),'(a1,a,a1)')
     &                 s1,trim(adjustl(cht)),xyz_c(j)
                  ip = len_trim(text_out)+1
               else
                  write(text_out(ip:(ip+1)),'(a1,a1)')s1,xyz_c(j)
                  ip = len_trim(text_out)+1
               endif
               it = 2
            endif
         enddo

         if(abs(tr(i)).gt.eps) then
            s1 = '-'
            if(tr(i).gt.0.0) s1 = '+'
            tmp = abs(tr(i))
            write(cht,'(f5.3)')abs(tr(i))
            do k=2,24
               tmp1 = tmp*real(k)
               if(abs(nint(tmp1)-tmp1).lt.eps) then
                  write(cht1,'(i2)')nint(tmp1)
                  write(cht2,'(i2)')k
                  cht = trim(adjustl(cht1))//'/'//
     &                 trim(adjustl(cht2))
                  exit
               endif
            enddo
            write(text_out(ip:(ip+5)),'(a1,a)')s1,trim(adjustl(cht))
            ip = len_trim(text_out)+1
         endif

         if(i.lt.3) then
            text_out(ip:(ip+1)) = ','
            ip = len_trim(text_out)+2
         endif
         it = 1
      enddo

      return
      end
c
      real function lstlsq_r(k,hkl)
      implicit none
      integer k
      integer hkl(3)
      real lstlsq
      external lstlsq

      lstlsq_r = lstlsq(k,hkl(1),hkl(2),hkl(3))

      end
c
      subroutine find_prim_symm(maxsym,nsym,nprim_symm,rot,tr,
     &     rot_p,tr_p)
      implicit none
      integer maxsym
      integer nsym
      real rot(1:3,1:3,maxsym),tr(3,maxsym)
      integer nprim_symm
      real rot_p(1:3,1:3,maxsym),tr_p(3,maxsym)
c
      integer is,is1
      real eps_l
      logical it_exists
c
      eps_l = 1.0e-6

      nprim_symm = 1
      rot_p(1:3,1:3,1) = rot(1:3,1:3,1)
      tr_p(1:3,1) = tr(1:3,1)
      if(nsym.le.1) return

      do is=2,nsym
         it_exists = .FALSE.
         is1 = 0
         do while(is1.lt.nprim_symm.and..not.it_exists)
            is1 = is1 + 1
            if(sum((rot(1:3,1:3,is)-
     &           rot_p(1:3,1:3,is1))**2).lt.eps_l) then
               it_exists = .TRUE.
            endif
         enddo

         if(.not.it_exists) then
            nprim_symm = nprim_symm + 1
            rot_p(1:3,1:3,nprim_symm) = rot(1:3,1:3,is)
            tr_p(1:3,nprim_symm) = tr(1:3,is)
         endif
      enddo

      return
      end
c
      subroutine find_ort_symm(cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &     rsymm_ort)
      implicit none
c
c---  Calculate symmetry operators for orthogonal system
      integer cs_nsym
      real cs_m_cs(3,3,cs_nsym),cs_v_cs(3,cs_nsym)
      real cs_cell(6)
      real rsymm_ort(3,3,cs_nsym)
c
c---  locals
      integer is,ierror
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      real ro_unit(3,3),rfr_unit(3,3),tmp(3,3)
c
c---  body
      call nb_frorth_r(cs_cell(1),cs_cell(2),cs_cell(3),cs_cell(4),
     &     cs_cell(5),cs_cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call calc_unit_frac(cs_frac_to_ort,cs_cell,ro_unit)     
      call matinv3_r(ro_unit,rfr_unit)
      do is=1,cs_nsym
         tmp = matmul(cs_m_cs(1:3,1:3,is),rfr_unit)
         rsymm_ort(1:3,1:3,is) = matmul(ro_unit,tmp)
      enddo

      return
      end
c
      SUBROUTINE NB_FRORTH_R(A,B,C,ALPHA,BETA,GAMMA,FRTOCR,CRTOFR,IERR)
C
C -P- FRORTH - calc transformation to orthogonal angstroms from fractional
C -P-          cell FRTOCR and back - CRTOFR
C
C       ALPHA,BETA,GAMMA - in radian
C
C       orthog axes are defined to have
C       A parallel to XO   Cstar parallel to ZO
C
C                                 ! 11 21 31 !
C            Xo=[FRTOCR] Xf    RO=! 12 22 32 !
C                                 ! 13 23 33 !
C
C            Xf=[CRTOFR] Xo
C
      REAL FRTOCR(3,3),CRTOFR(3,3)
      INTEGER IERR
C ******
      IERR  = 0
C --
      SINA  = SIN(ALPHA)
      COSA  = COS(ALPHA)
      SINB  = SIN(BETA)
      COSB  = COS(BETA)
      SING  = SIN(GAMMA)
      COSG  = COS(GAMMA)
      COSBS = (COSA*COSG-COSB)/(SINA*SING)
      SINBS = SQRT(ABS(1.-COSBS*COSBS))
      COSAS = (COSG*COSB-COSA)/(SINB*SING)
      SINAS = SQRT(ABS(1.-COSAS*COSAS))
      COSGS = (COSA*COSB-COSG)/(SINA*SINB)
      SINGS = SQRT(ABS(1.-COSGS*COSGS))
C
      DO     I=1,3
      DO     J=1,3
        FRTOCR(I,J) = 0.0
      ENDDO
      ENDDO
C
      FRTOCR(1,1) = A
      FRTOCR(1,2) = B*COSG
      FRTOCR(1,3) = C*COSB
      FRTOCR(2,1) = 0.0
      FRTOCR(2,2) = B*SING
      FRTOCR(2,3) =-C*SINB*COSAS
      FRTOCR(3,1) = 0.0
      FRTOCR(3,2) = 0.0
      FRTOCR(3,3) = C*SINB*SINAS
      CALL NB_INVERT_R(FRTOCR,CRTOFR,IERR)
      RETURN
      END
C -I-
      SUBROUTINE NB_INVERT_R(S,SS,IERR)
C
C -P- NB_INVERT - invertion matrix S(3,3) , result marix SS(3,3)
C
C -------------
      REAL S(3,3),SS(3,3)
      INTEGER IERR
C -I-
C -------------------------------
      IERR=0
      DO    I=1,3
      DO    J=1,3
        SS(I,J) = 0.
      ENDDO
      ENDDO
C
      DET = 0.0

      DO    J=1,3
      DO    I=1,3
        IF(I.EQ.1) THEN
          I1=2
          I2=3
        ELSE IF(I.EQ.2) THEN
          I1=1
          I2=3
        ELSE
          I1=1
          I2=2
        ENDIF
        IF(J.EQ.1) THEN
          J1=2
          J2=3
        ELSE IF(J.EQ.2) THEN
          J1=1
          J2=3
        ELSE
          J1=1
          J2=2
        ENDIF
        SS(I,J) = (-1)**(I+J)*( S(J1,I1)*S(J2,I2)-
     *                          S(J2,I1)*S(J1,I2) )
      ENDDO
      ENDDO

      DET = S(1,1)*SS(1,1)+S(1,2)*SS(2,1)+S(1,3)*SS(3,1)

      IF(ABS(DET).LT.1.0E-30) THEN
        IERR = 1
        DET  = 0.0
      ELSE
        DET = 1./DET
      ENDIF
      DO    I=1,3
      DO    J=1,3
        SS(I,J) = DET*SS(I,J)
      ENDDO
      ENDDO

      RETURN
      END
c
      subroutine find_int_symm(cs_nsym,cs_m_cs,cs_v_cs,nx,ny,nz,
     &     irot,itr)
      implicit none
c
c---  convert symmetries to integers. For translation we assume nx,ny,nz
c---  along x,y,z respectively. it is important that factor of nx,ny,nz obey
c--   symmetry requirements. Minimum such number is 12. So if nx,ny,nz are 
c---  divisible by 12 then everything should work fine
      integer cs_nsym
      real cs_m_cs(3,3,cs_nsym),cs_v_cs(3,cs_nsym)
      integer nx,ny,nz
      integer irot(3,3,cs_nsym),itr(3,cs_nsym)

      irot(1:3,1:3,1:cs_nsym)=nint(cs_m_cs(1:3,1:3,1:cs_nsym))
      itr(1,1:cs_nsym) = nint(cs_v_cs(1,1:cs_nsym)*nx)
      itr(2,1:cs_nsym) = nint(cs_v_cs(2,1:cs_nsym)*ny)
      itr(3,1:cs_nsym) = nint(cs_v_cs(3,1:cs_nsym)*nz)

      return
      end
c
      subroutine find_min_symm(x1,x2,maxsym,nsym,rot,trans,frac,ort,
     &     is,tx,dist)
      implicit none
c
c---  Find symmetry that would give minimal distance between two atoms
      integer maxsym,nsym
      real rot(3,3,maxsym),trans(3,maxsym)
      real ort(3,3),frac(3,3)
      real x1(3),x2(3)
      real tx_prev(3)
      
      integer is
      real tx(3)
      real dist

      integer i
      real tmp(3),tmp1(3),tmp3(3),tt(3),tt0(3)
      real dist_prev,dist_cur,tt1
c
c---  body
      tmp3(1:3) = matmul(frac,x1)
      tmp(1:3) = matmul(frac,x2)
      is = 0
      dist_prev = 1.0e32
      tx_prev(1:3) = 0.0
      do i=1,nsym
         tmp1 = matmul(rot(1:3,1:3,i),tmp) + trans(1:3,i)
         tx(1) = 0.0
         do while(tmp1(1)-tmp3(1).le.0.)
            tmp1(1) = tmp1(1) + 1.0
            tx(1) = tx(1) + 1.0
         enddo
         do while(tmp1(1)-tmp3(1).gt.0.)
            tmp1(1) = tmp1(1) - 1.0
            tx(1) = tx(1) - 1.0
         enddo
         tt(1) = tmp1(1) - tmp3(1)
         tt1 = tt(1) + 1.0
         if(abs(tt(1)).gt.abs(tt1)) then
            tx(1)=tx(1)+1.0
            tt(1) = tt1
         endif
c     
c---  y coordinate
         tx(2) = 0.0
         do while(tmp1(2)-tmp3(2).le.0.)
            tmp1(2) = tmp1(2) + 1.0
            tx(2) = tx(2) + 1.0
         enddo
         do while(tmp1(2)-tmp3(2).gt.0.)
            tmp1(2) = tmp1(2) - 1.0
            tx(2) = tx(2) - 1.0
         enddo
         tt(2) = tmp1(2) - tmp3(2)
         tt1 = tt(2) + 1.0
         if(abs(tt(2)).gt.abs(tt1)) then
            tx(2)=tx(2)+1.0
            tt(2) = tt1
         endif
c     
c---  z coordinate
         tx(3) = 0.0
         do while(tmp1(3)-tmp3(3).le.0.)
            tmp1(3) = tmp1(3) + 1.0
            tx(3) = tx(3) + 1.0
         enddo
         do while(tmp1(3)-tmp3(3).gt.0.)
            tmp1(3) = tmp1(3) - 1.0
            tx(3) = tx(3) - 1.0
         enddo
         tt(3) = tmp1(3) - tmp3(3)
         tt1 = tt(3) + 1.0
         if(abs(tt(3)).gt.abs(tt1)) then
            tx(3)= tx(3)+1.0
            tt(3) = tt1
         endif
         tt0 = matmul(ort,tt)
         dist_cur = sum(tt0**2)
         if(dist_prev.gt.dist_cur) then
            is = i
            dist_prev = dist_cur
            tx_prev(1:3) = tx(1:3)
         endif
      enddo
      dist = sqrt(dist_prev)
      tx(1:3) = tx_prev(1:3)
      if(is.eq.1.and.maxval(abs(tt(1:3))).le.0.1) then
         is = 0
         tt(1:3) = 0.0
         dist = 0.0
      endif
      
      return
      end
c
      SUBROUTINE FIND_CONV_MATRIX(R_IN,R_OUT)
C
C----Calculates conversion matrix for anisotropic u corresbonding
C----to coordinate conversion matrix R_in
      REAL R_IN(3,3),R_OUT(6,6)
C
      INTEGER II,JJ

      DO   II=1,3
        DO  JJ = 1,3
          R_OUT(II,JJ) = R_IN(JJ,II)*R_IN(JJ,II)
        ENDDO
        R_OUT(4,II) = 2.0*R_IN(II,1)*R_IN(II,2)
        R_OUT(5,II) = 2.0*R_IN(II,1)*R_IN(II,3)
        R_OUT(6,II) = 2.0*R_IN(II,2)*R_IN(II,3)
        R_OUT(II,4) =     R_IN(1,II)*R_IN(2,II)
        R_OUT(II,5) =     R_IN(1,II)*R_IN(3,II)
        R_OUT(II,6) =     R_IN(2,II)*R_IN(3,II)
      ENDDO

      R_OUT(4,4) = R_IN(1,1)*R_IN(2,2) + R_IN(1,2)*R_IN(2,1)
      R_OUT(4,5) = R_IN(1,1)*R_IN(3,2) + R_IN(1,2)*R_IN(3,1)
      R_OUT(4,6) = R_IN(2,1)*R_IN(3,2) + R_IN(2,2)*R_IN(3,1)

      R_OUT(5,4) = R_IN(1,1)*R_IN(2,3) + R_IN(1,3)*R_IN(2,1)
      R_OUT(5,5) = R_IN(1,1)*R_IN(3,3) + R_IN(1,3)*R_IN(3,1)
      R_OUT(5,6) = R_IN(2,1)*R_IN(3,3) + R_IN(2,3)*R_IN(3,1)

      R_OUT(6,4) = R_IN(1,2)*R_IN(2,3) + R_IN(1,3)*R_IN(2,2)
      R_OUT(6,5) = R_IN(1,2)*R_IN(3,3) + R_IN(1,3)*R_IN(3,2)
      R_OUT(6,6) = R_IN(2,2)*R_IN(3,3) + R_IN(2,3)*R_IN(3,2)
C
      RETURN
      END
c
      SUBROUTINE ASYLIM(ISNO,IPX,IPY,IPZ,NM)
C
C---limits of asymmetric unit for different space groups
C---For some space groups it is more than one symmetric unit
C---Also gives multiplicity for grid sampling
      INTEGER ASULIM(4,243),ISPG(243)
      DATA ((ASULIM(JJ,II),JJ=1,4),II=1,243) /
C      1 P1          2 P-1        3  P2          1003 P2      
     + 1,1,1,2,      1,1,2,2,     1,1,2,2,       1,2,1,2,    
C      4 P21         3004 I21     1004 P1121     2005 A2
     + 1,1,2,2,      1,1,4,4,     1,1,2,2,       1,1,4,4,      
C      5 C2          1005 C21     6    Pm        7 Pc       
     + 1,2,2,2,      1,2,2,2,     1,2,1,2,       1,1,2,2,   
C      8    Cm       9   Cc       10  P2/m       11 P21/m 
     + 1,4,1,4,      1,2,2,2,     1,2,2,2,       1,2,2,2, 
C      12 C2/m       13  P2/c   
     + 1,4,2,4,      1,1,4,4,  
C      14 P21/c      15 C2/c      16 P222        17  P2221 
     + 1,1,4,4,      1,2,4,4,     1,2,2,2,       1,1,4,4,
C      18 P21212     1018 P21212a 19 P212121     20 C2221  
     + 1,2,2,2,      1,1,2,2,     1,1,4,4,       1,2,4,4,   
C      1020 C2221a   21 C222      1021 C222a     22 F222
     + 1,2,4,4,      1,4,2,4,     1,2,2,2,       1,2,4,4,
C      1022 F222a    23 I222      1023 I222a     24 I212121  
     + 1,4,4,4,      1,2,4,4,     1,1,4,4,       1,1,4,4,   
C      25 Pmm2       26 Pmc21     27 Pcc2        28 Pma2      
     + 1,2,1,2,      1,1,2,2,     1,2,2,2,       1,2,1,2,
C      29 Pca21      30 Pnc2      31 Pmn21       32 Pba2
     + 1,2,2,2,      1,2,2,2,     1,1,2,2,       1,4,1,4,
C      33 Pna21      34 Pnn2      35 Cmm2        36 Cmc21   
     + 1,1,2,2,      1,2,2,2,     1,4,1,4,       1,2,2,2,   
C      37 Ccc2       38 Amm2      39 Abm2        40 Ama2 
     + 1,2,2,2,      1,2,2,2,     1,4,2,4,       1,2,2,2,
C      41 Aba2       42 Fmm2      43 Fdd2        44 Imm2    
     + 1,4,2,4,      1,4,2,4,     1,2,4,4,       1,2,2,2,  
C      45 Iba2       46 Ima2      47 Pmmm        48 Pnnn 
     + 1,4,2,4,      1,2,2,2,     2,2,2,2,       1,2,4,4,
C      49 Pccm       50 Pban      51 Pmma        52 Pnna    
     + 1,2,4,4,      1,4,2,4,     1,2,2,2,       1,2,4,4,   
C      53 Pmna       54 Pcca      55 Pbam        56 Pccn      
     + 1,1,4,4,      1,2,4,4,     1,4,2,4,       1,1,4,4,   
C      57 Pbcm       58 Pnnm      59 Pmmn        1059 Pmmn2 
     + 1,2,4,4,      1,2,4,4,     1,2,2,2,       1,1,2,2,
C      60 Pbcn       61 Pbca      62 Pnma        63 Cmcm    
     + 1,2,4,4,      1,2,4,4,     1,1,4,4,       1,2,4,4,  
C      64 Cmca       65 Cmmm      66 Cccm        67 Cmma 
     + 1,2,4,4,      1,4,2,4,     1,4,4,4,       1,4,2,4,     
C      68 Ccca       69 Fmmm      70 Fddd        71 Immm 
     + 1,4,4,4,      1,4,4,4,     1,4,8,8,       1,2,4,4, 
C      72 Ibam       73 Ibca      74 Imma        75 P4      
     + 1,4,4,4,      1,4,4,4,     1,1,4,4,       1,2,1,2,   
C      76 P41        77 P42       78 P43         79 I4   
     + 1,1,4,4,      1,2,2,2,     1,1,4,4,       1,2,2,2, 
C      80 I41        81 P-4       82 I-4         83 P4/m       
     + 1,2,4,4,      1,2,2,2,     1,2,4,4,       1,2,2,2,   
C      84 P42/m      85 P4/n      86 P42/n       87 I4/m
     + 1,2,4,4,      1,2,2,2,     1,2,4,4,       1,2,4,4, 
C      88 I41/a      89 P422      90 P4212       91 P4122   
     + 1,2,8,8,      1,2,2,2,     1,2,2,2,       1,1,8,8,   
C      92 P41212     93 P4222     94 P42212      1094 P42212a
     + 1,1,8,8,      1,2,4,4,     1,2,4,4,       1,1,4,4,     
C      95 P4322      96 P43212    97 I422        98 I4122 
     + 1,1,8,8,      1,1,8,8,     1,2,4,4,       1,2,8,8, 
C      99 P4mm       100 P4bm     101 P42cm      102 P42nm 
     + 1,2,1,2,      1,4,1,4,     1,2,2,2,       1,2,2,2, 
C      103 P4cc      104 P4nc     105 P42mc      106 P42bc 
     + 1,2,2,2,      1,2,2,2,     1,2,2,2,       1,4,2,4, 
C      107 I4mm      108 I4cm     109 I41md      110 I41cd   
     + 1,2,2,2,      1,4,2,4,     1,2,4,4,       1,2,4,4,  
C      111 P-42m     112 P-42c    113 P-421m     114 P-421c
     + 1,2,2,2,      1,2,4,4,     1,2,2,2,       1,2,4,4,
C      115 P-4m2     116 P-4c2    117 P-4b2      118 P-4n2   
     + 1,2,2,2,      1,2,4,4,     1,4,2,4,       1,2,4,4,  
C      119 I-4m2     120 I-4c2    121 I-42m      122 I-42d    
     + 1,2,4,4,      1,4,4,4,     1,2,4,4,       1,2,8,8,  
C      123 P4/mmm    124 P4/mcc   125 P4/nbm     126 P4/nnc 
     + 1,2,2,2,      1,2,4,4,     1,4,2,4,       1,2,4,4,   
C      127 P4/mbm    128 P/mnc    129 P4/nmm     130 P4/ncc 
     + 1,4,2,2,      1,2,4,4,     1,2,2,2,       1,2,4,4,   
C     131 P42/mmc    132 P42/mcm  133 P42/nbc    134 P42/nnm  
     + 1,2,4,4,      1,2,4,4,     1,2,4,4,       1,2,4,4,   
C      135 P42/mbc   136 P42/mnm  137 P42/nmc    138 P42/ncm 
     + 1,2,4,4,      1,2,4,4,     1,2,4,4,       1,2,4,4,    
C      139 I4/mmm    140 I4/mcm   141 I41/amd    142 I41/acd 
     + 1,2,4,4,      1,4,4,4,     1,2,8,8,       1,2,8,8,
C      143 P3        144 P31      145 P32        146 R3     
     + 1,1,1,6,      1,1,3,6,     1,1,3,6,       1,1,3,6, 
C      147 P-3       148 R-3      149 P312       150 P321    
     + 1,1,2,6,      1,1,6,6,     1,1,2,6,       1,1,2,6, 
C      151 P3112     152 P3121    153 P3212      154 P3221   
     + 1,1,6,6,      1,1,6,6,     1,1,6,6,       1,1,6,6,  
C      155 R32,      156 P3m1     157 P31m       158 P3c1    
     + 1,1,6,6,      1,1,1,6,     1,1,1,6,       1,1,2,6,   
C      159 P31c      160 R3m      161 R3c        162 P-31m  
     + 1,1,2,6,      1,1,3,6,     1,1,6,6,       1,1,2,6,   
C      163 P-31c     164 P-3m1    165 P-3c1      166 R-3m    
     + 1,1,4,12,     1,1,2,6,     1,1,4,12,      1,1,6,6,   
C      167 R-3c      168 P6       169 P61        170 P65
     + 1,1,12,12,    1,1,1,6,     1,1,6,6,       1,1,6,6,
C      171 P62       172 P64      173 P63        174 P-6    
     + 1,1,3,6,      1,1,3,6,     1,1,2,6,       1,1,2,6,  
C      175 P6/m      176 P63/m    177 P622       178 P6122   
     + 1,1,2,6,      1,1,4,12,    1,1,2,6,       1,1,12,12,
C      179 P6522     180 P6222    181 P6422      182 P6322   
     + 1,1,12,12,    1,1,6,6,     1,1,6,6,       1,1,4,12,
C      183 P6mm      184 P6cc     185 P63cm      186 P63mc   
     + 1,2,1,6,      1,1,2,6,     1,1,2,6,       1,1,2,6,    
C      187 P-6m2     188 P-6c2    189 P-62m      190 P-62c   
     + 1,1,2,6,      1,1,4,12,    1,2,2,6,       1,1,4,12,   
C      191 P6/mmm    192 P6.mcc   193 P63/mcm    194 P63/mmc 
     + 1,2,2,6,      1,1,4,12,    1,1,4,12,      1,1,4,12,   
C      195 P23       196 F23      197 I23        11197 I23a
     + 1,2,2,2,      1,4,4,4,     1,2,4,4,       1,1,4,4, 
C      198 P213      199 I213     200 Pm-3       201 Pn-3   
     + 1,1,4,4,      1,1,4,4,     1,2,2,2,       1,2,4,4, 
C      202 Fm-3      203 Fd-3     204 Im-3       205 Pa-3 
     + 1,4,4,4,      1,4,8,8,     1,2,4,4,       1,1,4,4,
C      206 Ia-3      207 P432     208 P4232      209 F432    
     + 1,4,4,4,      1,2,2,2,     1,2,4,4,       1,4,4,4, 
C      210 P4132     211 I432     212 P4332      213 P4132    
     + 1,4,8,8,      1,2,4,4,     1,1,8,8,       1,1,8,8,    
C      214 I4132     215 P-43m    216 F-43m      217 I-43m   
     + 1,1,8,8,      1,2,2,2,     1,4,4,4,       1,2,4,4, 
C      218 P-43n     219 F-43c    220 I-43d      221 Pm-3m   
     + 1,2,4,4,      1,4,4,4,     1,1,8,8,       1,2,2,2,    
C      222 Pn-3n     223 Pm-3n    224 Pn-3m      225 Fm-3m 
     + 1,2,2,2,      1,2,4,4,     1,2,4,4,       1,4,4,4,
C      226 Fm-3c     227 Fd-3m    228 Fd-3c      229 Im-3m  
     + 1,4,4,4,      1,2,8,8,     1,4,8,8,       1,2,4,4,     
C       230 Ia-3d 
     +  1,4,8,8 /
C
      DATA ISPG /
C      1 P1          2 P-1        3  P2          1003 P2      
     + 1,            2,           3,             1003,       
C      4 P21         3004 I21     1004 P1121     2005 A2
     + 4,            3004,        1004,          2005,         
C      5 C2          1005 C21     6    Pm        7 Pc       
     + 5,            1005,        6,             7,         
C      8    Cm       9   Cc       10  P2/m       11 P21/m 
     + 8,            9,           10,            11,      
C      12 C2/m       13  P2/c   
     + 12,           13,       
C      14 P21/c      15 C2/c      16 P222        17  P2221 
     + 14,           15,          16,            17,        
C      18 P21212     1018 P21212a 19 P212121     20 C2221  
     + 18,           1018,        19,            20,        
C      1020 C2221a   21 C222      1021 C222a     22 F222
     + 1020,         21,          1021,          22,        
C      1022 F222a    23 I222      1023 I222a     24 I212121  
     + 1022,         23,          1023,          24,        
C      25 Pmm2       26 Pmc21     27 Pcc2        28 Pma2      
     + 25,           26,          27,            28,      
C      29 Pca21      30 Pnc2      31 Pmn21       32 Pba2
     + 29,           30,          31,            32,    
C      33 Pna21      34 Pnn2      35 Cmm2        36 Cmc21   
     + 33,           34,          35,            36,        
C      37 Ccc2       38 Amm2      39 Abm2        40 Ama2 
     + 37,           38,          39,            40,     
C      41 Aba2       42 Fmm2      43 Fdd2        44 Imm2    
     + 41,           42,          43,            44,       
C      45 Iba2       46 Ima2      47 Pmmm        48 Pnnn 
     + 45,           46,          47,            48,     
C      49 Pccm       50 Pban      51 Pmma        52 Pnna    
     + 49,           50,          51,            52,        
C      53 Pmna       54 Pcca      55 Pbam        56 Pccn      
     + 53,           54,          55,            56,        
C      57 Pbcm       58 Pnnm      59 Pmmn        1059 Pmmn2 
     + 57,           58,          59,            1059,    
C      60 Pbcn       61 Pbca      62 Pnma        63 Cmcm    
     + 60,           61,          62,            63,       
C      64 Cmca       65 Cmmm      66 Cccm        67 Cmma 
     + 64,           65,          66,            67,          
C      68 Ccca       69 Fmmm      70 Fddd        71 Immm 
     + 68,           69,          70,            71,      
C      72 Ibam       73 Ibca      74 Imma        75 P4      
     + 72,           73,          74,            75,        
C      76 P41        77 P42       78 P43         79 I4   
     + 76,           77,          78,            79,      
C      80 I41        81 P-4       82 I-4         83 P4/m       
     + 80,           81,          82,            83,        
C      84 P42/m      85 P4/n      86 P42/n       87 I4/m
     + 84,           85,          86,            87,      
C      88 I41/a      89 P422      90 P4212       91 P4122   
     + 88,           89,          90,            91,        
C      92 P41212     93 P4222     94 P42212      1094 P42212a
     + 92,           93,          94,            1094,        
C      95 P4322      96 P43212    97 I422        98 I4122 
     + 95,           96,          97,            98,      
C      99 P4mm       100 P4bm     101 P42cm      102 P42nm 
     + 99,           100,         101,           102,     
C      103 P4cc      104 P4nc     105 P42mc      106 P42bc 
     + 103,          104,         105,           106,     
C      107 I4mm      108 I4cm     109 I41md      110 I41cd   
     + 107,          108,         109,           110,      
C      111 P-42m     112 P-42c    113 P-421m     114 P-421c
     + 111,          112,         113,           114,    
C      115 P-4m2     116 P-4c2    117 P-4b2      118 P-4n2   
     + 115,          116,         117,           118,      
C      119 I-4m2     120 I-4c2    121 I-42m      122 I-42d    
     + 119,          120,         121,           122,      
C      123 P4/mmm    124 P4/mcc   125 P4/nbm     126 P4/nnc 
     + 123,          124,         125,           126,       
C      127 P4/mbm    128 P/mnc    129 P4/nmm     130 P4/ncc 
     + 127,          128,         129,           130,       
C      131 P42/mmc   132 P42/mcm  133 P42/nbc    134 P42/nnm  
     + 131,          132,         133,           134,       
C      135 P42/mbc   136 P42/mnm  137 P42/nmc    138 P42/ncm 
     + 135,          136,         137,           138,        
C      139 I4/mmm    140 I4/mcm   141 I41/amd    142 I41/acd 
     + 139,          140,         141,           142,    
C      143 P3        144 P31      145 P32        146 R3     
     + 143,          144,         145,           146,     
C      147 P-3       148 R-3      149 P312       150 P321    
     + 147,          148,         149,           150,     
C      151 P3112     152 P3121    153 P3212      154 P3221   
     + 151,          152,         153,           154,      
C      155 R32,      156 P3m1     157 P31m       158 P3c1    
     + 155,          156,         157,           158,       
C      159 P31c      160 R3m      161 R3c        162 P-31m  
     + 159,          160,         161,           162,       
C      163 P-31c     164 P-3m1    165 P-3c1      166 R-3m    
     + 163,          164,         165,           166,       
C      167 R-3c      168 P6       169 P61        170 P65
     + 167,          168,         169,           170,     
C      171 P62       172 P64      173 P63        174 P-6    
     + 171,          172,         173,           174,      
C      175 P6/m      176 P63/m    177 P622       178 P6122   
     + 175,          176,         177,           178,      
C      179 P6522     180 P6222    181 P6422      182 P6322   
     + 179,          180,         181,           182,      
C      183 P6mm      184 P6cc     185 P63cm      186 P63mc   
     + 183,          184,         185,           186,        
C      187 P-6m2     188 P-6c2    189 P-62m      190 P-62c   
     + 187,          188,         189,           190,        
C      191 P6/mmm    192 P6.mcc   193 P63/mcm    194 P63/mmc 
     + 191,          192,         193,           194,        
C      195 P23       196 F23      197 I23        1197 I23a
     + 195,          196,         197,           1197,   
C      198 P213      199 I213     200 Pm-3       201 Pn-3   
     + 198,          199,         200,           201,    
C      202 Fm-3      203 Fd-3     204 Im-3       205 Pa-3 
     + 202,          203,         204,           205,    
C      206 Ia-3      207 P432     208 P4232      209 F432    
     + 206,          207,         208,           209,     
C      210 P4132     211 I432     212 P4332      213 P4132    
     + 210,          211,         212,           213,        
C      214 I4132     215 P-43m    216 F-43m      217 I-43m   
     + 214,          215,         216,           217,     
C      218 P-43n     219 F-43c    220 I-43d      221 Pm-3m   
     + 218,          219,         220,           221,        
C      222 Pn-3n     223 Pm-3n    224 Pn-3m      225 Fm-3m 
     + 222,          223,         224,           225,    
C      226 Fm-3c     227 Fd-3m    228 Fd-3c      229 Im-3m  
     + 226,          227,         228,           229,         
C       230 Ia-3d 
     +  230/
       IPX = 1
       IPY = 1
       IPZ = 1
       NM  = 2
       DO    I=1,243
         IF(ISNO.EQ.ISPG(I)) THEN
cd           IPX = ASULIM(1,I)
cd           IPY = ASULIM(2,I)
           IPZ = ASULIM(3,I)
           NM  = ASULIM(4,I)
           GOTO 100
         ENDIF
       ENDDO
       write(*,*)'Warning==> No such space group in ASYLIM.'
100    RETURN
      END
C
      SUBROUTINE NXYZ235_old(NX,NM)
      IMPLICIT NONE
      INTEGER NX,NM
c
c-----This subroutine changes NX so that NM becames multiplier of NX
c-----and other multipliers are 2,3,5 and returns new value of NX 
c----Make sure NM is multiplier of NX
      INTEGER N1
      INTEGER IPR,NPR
      INTEGER PRIMES(8)
      DATA PRIMES/2,3,5,7,11,13,17,19/
      DATA NPR/8/

      IF(MOD(NX,NM).NE.0) NX = NX-MOD(NX,NM)+NM
1     CONTINUE
      N1 = NX/NM
2     CONTINUE
c
c-----Chek if 2,3,5 is multiplier of NX if there is another multiplier then
c-----change NX and check again
c
      IF(N1.EQ.1)RETURN
      DO  IPR=1,NPR
         IF(MOD(N1,PRIMES(IPR)).EQ.0) THEN
             N1 = N1/PRIMES(IPR)
             GOTO 2
         ENDIF
      ENDDO
      NX = NX + NM
      GOTO 1
      END 
