module GlebSasha
  use CellAndSymmetry
  use agreem
  use NumIntegrate
  use gibbs_gm

  implicit none

  logical, private :: ideal_wilson_read_flag=.FALSE.
  integer, private :: nwilson
  real, private, allocatable :: IdealWilson(:,:)

  real, private :: B_iso_GS=0.0,scale_GS=1.0
  real, private :: u_aniso_GS(6)=0.0
  integer, private :: icycle,nmax_cycle=50

  real, private :: gm_wilson_scale_outlier=0.01,B_res=30.0,deltaB_res=5.0
  real, private :: pi=4.0*atan(1.0)


contains
  subroutine scale_GlebSasha_I(hkl_asym,io)
    !
    !   Scale using Gleb & Sasha intenisity curves.
    !   We may need to use a family of curves and select best fitting
    !   Or we can parameterise curves and find the best fit using regression
    !
    integer, intent(in) :: hkl_asym(:,:)
    real, intent(in) :: io(:,:)
    !
    !  locals
    integer nref,ndata

    integer i,j,ip,ir,ierr
    !
    integer isysab
    real s1,s2,s3,rsq1
    real cc,i1
    !
    !   allocatables
    real, allocatable :: epsi(:)
    integer, allocatable :: icentr(:)
    real, allocatable :: ssq(:),ss(:,:)
    real, allocatable :: w_robust(:)

    integer npar
    real*8 :: toler = 0.5d-8
    real*8 dsdp(8)
    real*8 dfds,d2fds21,d2fds22
    real*8 dev
    real*8, allocatable :: d2fdp2(:,:),d2fdp22(:,:),dfdp(:),shifts(:)
    real*8 dsigmadk,dsigmadb,dsigmadu(6)
    !
    real*8 sus,Sigma,SigmaEps,SigmaTot, DeltaSig
    real scale_GS_save,B_iso_GS_save
    real U_aniso_GS_save(6)
    real alpha
    real t0,tadd
    real exp_part0,exp_part1,exp_part2,rem_part0,rem_part1,rem_part2
    real an_vec(3),rem_part_vec(3),exp_part_vec(3)
    real an0,an1,an2,I_exp,I2_exp
    real fvalue,fvalue_old
    integer i_inter
    real GS_value,scale_gs_log
    real lstlsq
    !
    !  Body

    nref = size(io(1,:))
    ndata = size(io(:,1))

    if(ndata.gt.2) then
       stop 'Problem: We cannot deal with multiple data at the moment'
    endif

    write(*,*)'Number of obs    = ',nref
    write(*,*)'Number of colums = ',ndata
    if(.not.ideal_Wilson_read_flag) then
       call read_ideal_wilson
    endif
    write(*,*)'Number of sample points for Wilson curve = ',nwilson
    !
    !   Start normalisation. First step: log scaling
    write(*,*)
    write(*,'(20x,a)')'Ideal Wilson scale, step 1: Log scaling'
    write(*,*)
    call log_scale_GS(hkl_asym,io)
    write(*,*)'Scale value = ',scale_GS
    write(*,*)'B value     = ',B_iso_GS
    write(*,*)'U aniso     = ',U_aniso_GS(1:6)
    !
    !  The second step: proper scaling
    write(*,*)
    write(*,'(20x,a)')'Ideal Wilson scale, step 2: ML scaling'
    write(*,*)
    !
    !  Precalculate s, si sj,epsi,centr and all that
    allocate(epsi(nref))
    allocate(icentr(nref))
    allocate(ssq(nref))
    allocate(ss(6,nref))
    do ir=1,nref
       call centr(hkl_asym(1:3,ir),icentr(ir))
       call epslon(hkl_asym(1:3,ir),epsi(ir),isysab)
       ssq(ir) = lstlsq(1,hkl_asym(1,ir),hkl_asym(2,ir),hkl_asym(3,ir)) 
       !
       !  calculate ss(i)
       s1 = float(hkl_asym(1,ir))*rcell(1)
       s2 = float(hkl_asym(2,ir))*rcell(2)
       s3 = float(hkl_asym(3,ir))*rcell(3)
       ss(1,ir) = s1*s1
       ss(2,ir) = s2*s2
       ss(3,ir) = s3*s3
       ss(4,ir) = 2.0*s1*s2
       ss(5,ir) = 2.0*s1*s3
       ss(6,ir) = 2.0*s2*s3
       ss(1:6,ir) = ss(1:6,ir)/4.0
    enddo
    !
    if(.not.eigen_aniso_flag) call aniso_eigens
    write(*,*)
    write(*,*)'Anisotropic U values should obey crystal symmetry - R^T U R = U and tr(U) = 0'
    write(*,*)'Number of independent aniso directions ',n_eigen_aniso

    npar = 2 + n_eigen_aniso
    allocate(d2fdp2(npar,npar))
    allocate(d2fdp22(npar,npar))
    allocate(dfdp(npar))
    allocate(shifts(npar))
    allocate(w_robust(nref))
    i_inter = -1
    fvalue_old = 1.0e32

    !
    !  Use gaussian approximation for initial esitmation. <Io> = Sigma, <Io^2>-<Io>^2 = 
    !  sum( 0.5*log(SigmaTot) + (SigmaEps-Io(1,ir))**2/(2.0*SigmaTot))
    !  SigmaTot = (eps*Sigma)**2 + sigma_obs**2
    scale_gs_log = log(scale_gs)
    do icycle =1,nmax_cycle
       fvalue = 0.0
       dfdp(1:npar) = 0.0d0
       d2fdp2(1:npar,1:npar) = 0.0d0
       d2fdp22(1:npar,1:npar) = 0.0d0
       do ir=1,nref
          if(io(2,ir).le.0.0) cycle
          sus = sum(ss(1:6,ir)*u_aniso_gs(1:6))
          rsq1 = 4.0*ssq(ir)
          if(1.0/sqrt(rsq1).gt.12.0) cycle
          call linter_value2(nwilson,IdealWilson(1,1:nwilson),IdealWilson(2,1:nwilson),rsq1,i_inter,GS_value)
          Sigma = exp(scale_gs_log-dble(b_iso_GS*ssq(ir))-sus)*GS_value
          SigmaEps = epsi(ir)*Sigma
          DeltaSig = SigmaEps-Io(1,ir)
          SigmaTot = SigmaEps**2 + Io(2,ir)**2
          !
          !  0.5*log(SigmaTot) + (SigmaEps-Io(1,ir))**2/(2.0*SigmaTot)
          dfds = epsi(ir)*(SigmaEps/SigmaTot + DeltaSig/SigmaTot - SigmaEps*DeltaSig**2/SigmaTot**2)
          d2fds21 = epsi(ir)**2*(                                                                                        &
               2.0/SigmaTot - 2.0*SigmaEps**2/SigmaTot**2  -   4.0*SigmaEps*DeltaSig/SigmaTot**2 -DeltaSig**2/SigmaTot**2 &
               +4.0*SigmaEps**2*DeltaSig**2/SigmaTot**3)
          d2fds22 = epsi(ir)**2/SigmaTot

          fvalue = fvalue + 0.5*log(Sigmatot) + DeltaSig**2/(2.0*SigmaTot)
          !write(*,*)fvalue,SigmaTot,DeltaSig,io(1:2,ir)

          !dfds   =  1.0/(cc*Sigma) - 1.0/(cc*epsi(ir)*Sigma**2)*I_exp
          !d2fds21 = -1.0/(cc*Sigma**2) + 2.0/(cc*epsi(ir)*Sigma**3)*I_exp+1.0/(cc*epsi(ir)*Sigma**2)**2*(I2_exp-I_exp**2)
          !d2fds22 = 1.0/(cc*SigmaEps**2)
          !
          !  Add weights. If I is too big or too small its contribution should be 
          !  downweigthed
          !dev = 1.0-1.0/(cc*epsi(ir)*Sigma)*I_exp
          !w_robust(ir) = 1.0/(1+gm_wilson_scale_outlier*dev**2)**2
          w_robust(ir) = 1.0
          !w_robust(ir) = exp(-b_res*ssq(ir))
          !if(icycle.eq.5) write(*,*)t0,Sigma,exp_part0,tadd,rem_part0
          !fvalue = fvalue + w_robust(ir)*(log(Sigma)/cc + exp_part0 +tadd - log(rem_part0))
          !
          !  Derivativs of sigma wrt parameters.
          dfds   = w_robust(ir)*dfds
          d2fds21 = w_robust(ir)*d2fds21
          d2fds22 = w_robust(ir)*d2fds22
          
          dsigmadk = Sigma
          dsigmadb = -ssq(ir)*Sigma
          !
          !   For aniso U value use direction where they can change (U obeys symmety and tr(U) = 0
          do i=1,6
             dsigmadu(i) = -ss(i,ir)*Sigma
          enddo

          dsdp(1) = dsigmadk
          dsdp(2) = dsigmadb
          do ip=1,n_eigen_aniso
             dsdp(2+ip) = sum(dsigmadu(1:6)*eigen_aniso(ip,1:6))
          enddo
          !  
          !   Collect derivatise of the likelihood wrt parameters
          dfdp(1:npar) = dfdp(1:npar) + dfds*dsdp(1:npar)
          do j=1,npar
             d2fdp2(1:npar,j) = d2fdp2(1:npar,j) + d2fds21*dsdp(1:npar)*dsdp(j)
          enddo
          do j=1,npar
             d2fdp22(1:npar,j) = d2fdp22(1:npar,j) + d2fds22*dsdp(1:npar)*dsdp(j)
          enddo
       enddo
       !write(*,*)fvalue
       !stop
       !
       !   Primitive minimisers
       write(*,*)fvalue,fvalue_old

       if(fvalue.le.fvalue_old) then
          scale_GS_save = scale_GS_log
          B_iso_GS_save = B_iso_GS
          u_aniso_GS_save(1:6) = u_aniso_GS(1:6)
          !
          !write(*,*)fvalue,fvalue_old
          

          fvalue_old = fvalue
          !  Solve the equation
          !call deigen_filter_r90(toler,d2fdp2(1:npar,1:npar),npar,npar,dfdp(1:npar),shifts(1:npar),ierr)
          !if(maxval(abs(shifts(1:npar))).le.0.0) then
             
          call deigen_filter_r90(toler,d2fdp22(1:npar,1:npar),npar,npar,dfdp(1:npar),shifts(1:npar),ierr)
          !endif
          !write(*,*)'Shifts ',alpha,shifts(1:npar)
          !
          !    Do not allow excessive shifts that would make scale negative or B values too large
          alpha = 1.0
          do while(abs(alpha*shifts(2)).gt.20.0)
             alpha = alpha/2.0
          enddo
          do while (maxval(abs(alpha*shifts(3:npar))).gt.20.0) 
             alpha = alpha/2.0
          enddo
       else
          alpha = alpha*0.5
          scale_GS_log = scale_GS_save
          scale_gs = exp(scale_gs_log)
          B_iso_GS = B_iso_GS_save
          u_aniso_GS(1:6) = u_aniso_GS_save(1:6)
       endif
       scale_gs_log = scale_GS_log - alpha*shifts(1)
       scale_gs = exp(scale_gs_log)
       B_iso_GS = max(0.0,B_iso_GS - alpha*shifts(2))
       do ip=1,6
          u_aniso_GS(ip) = u_aniso_GS(ip) - alpha*sum(shifts(3:npar)*eigen_aniso(1:n_eigen_aniso,ip))
       enddo
       !write(*,*)'LS cycle  ',icycle,b_res
       !write(*,*)'fvalue ',fvalue
       !write(*,*)'Scale and B value ',scale_GS,B_iso_GS
       !write(*,*)'Aniso U values    ',u_aniso_GS
       !if(icycle.eq.5) stop
       !
       !   line minimisation??? For quick result use the simplest line minimisers. Half shifts if they are too large.
       !   Robustness weights should be here
       !stop
    enddo

    write(*,*)'After Gaussian '
    write(*,*)'Scale value = ',scale_GS
    write(*,*)'B value     = ',B_iso_GS
    write(*,*)'U aniso     = ',U_aniso_GS(1:6)
    write(*,*)
    !U_aniso_GS = 0.0
    !stop
    !
    !   Ml estimation: We may not need this part at all 
    fvalue_old = 1.0e32
    do icycle=1,nmax_cycle
    !do icycle=1,50
       fvalue = 0.0
       dfdp(1:npar) = 0.0d0
       d2fdp2(1:npar,1:npar) = 0.0d0
       d2fdp22(1:npar,1:npar) = 0.0d0
       do ir=1,nref
          if(io(2,ir).le.0.0) cycle
          sus = sum(ss(1:6,ir)*u_aniso_gs(1:6))
          rsq1 = 4.0*ssq(ir)
          if(1.0/sqrt(rsq1).gt.12.0) cycle
          call linter_value2(nwilson,IdealWilson(1,1:nwilson),IdealWilson(2,1:nwilson),rsq1,i_inter,GS_value)
          Sigma = exp(scale_gs_log-dble(b_iso_GS*ssq(ir))-sus)*GS_value
          !if(dble(b_iso_GS*ssq(ir)+sus).gt.30.0) write(*,*)ssq(ir),b_iso_GS,sus,exp(-dble(b_iso_GS*ssq(ir))-sus)
          SigmaEps = epsi(ir)*Sigma
          !
          !   We need unnormalised P(F;Fo,Sigma) and expected values of 
          !   I and I^2
          if(icentr(ir).eq.1) then
             cc  = 2.0
             an0 = -0.5
             an1 = 0.5
             an2 = 1.5
          else
             cc  = 1.0
             an0 = 0.0
             an1 = 1.0
             an2 = 2.0
          endif
          t0 = (Io(1,ir) -Io(2,ir)**2/(cc*SigmaEps))/Io(2,ir)
          an_vec(1) = an0
          an_vec(2) = an1
          an_vec(3) = an2
          !
          !   calculate integrals int_{t0}^{infinity} (t+t0)^an exp(-t^2/2) dt
          call t02inf_laplace_mc(t0,3,an_vec,exp_part_vec,rem_part_vec)
          rem_part0 = rem_part_vec(1)
          exp_part0 = exp_part_vec(1)
          rem_part1 = rem_part_vec(2)
          exp_part1 = exp_part_vec(2)
          rem_part2 = rem_part_vec(3)
          exp_part2 = exp_part_vec(3)

          rem_part0 = rem_part0*Io(2,ir)**(an0+1)
          rem_part1 = rem_part1*Io(2,ir)**(an1+1)
          rem_part2 = rem_part2*Io(2,ir)**(an2+1)

          tadd = Io(1,ir)/(cc*SigmaEps) - Io(2,ir)**2/(2.0*(cc*SigmaEps)**2)
          
          I_exp  = exp(-exp_part1+exp_part0)*rem_part1/rem_part0
          I2_exp = exp(-exp_part2+exp_part0)*rem_part2/rem_part0
          if(exp_part1-exp_part0.gt.30.0) then
             write(*,*)cc,exp_part1,exp_part0,exp_part2,t0,SigmaEps,I_exp,I2_exp
          endif
          !
          !  Collect derivatives of the likelihood wrt sigma
          dfds   =  1.0/(cc*Sigma) - 1.0/(cc*epsi(ir)*Sigma**2)*I_exp
          d2fds21 = -1.0/(cc*Sigma**2) + 2.0/(cc*epsi(ir)*Sigma**3)*I_exp+1.0/(cc*epsi(ir)*Sigma**2)**2*(I2_exp-I_exp**2)
          d2fds22 = 1.0/(cc*SigmaEps**2)
          !
          !  Add weights. If I is too big or too small its contribution should be 
          !  downweigthed
          dev = 1.0-1.0/(cc*epsi(ir)*Sigma)*I_exp
          w_robust(ir) = 1.0/(1+gm_wilson_scale_outlier*dev**2)**2
          w_robust(ir) = 1.0
          !w_robust(ir) = exp(-b_res*ssq(ir))
          !if(icycle.eq.5) write(*,*)t0,Sigma,exp_part0,tadd,rem_part0
          fvalue = fvalue + w_robust(ir)*(log(Sigma)/cc + exp_part0 +tadd - log(rem_part0))
          !
          !  Derivativs of sigma wrt parameters.
          dfds   = w_robust(ir)*dfds
          d2fds21 = w_robust(ir)*d2fds21
          d2fds22 = w_robust(ir)*d2fds22
          
          dsigmadk = Sigma
          dsigmadb = -ssq(ir)*Sigma
          !
          !   For aniso U value use direction where they can change (U obeys symmety and tr(U) = 0
          do i=1,6
             dsigmadu(i) = -ss(i,ir)*Sigma
          enddo

          dsdp(1) = dsigmadk
          dsdp(2) = dsigmadb
          do ip=1,n_eigen_aniso
             dsdp(2+ip) = sum(dsigmadu(1:6)*eigen_aniso(ip,1:6))
          enddo
          !  
          !   Collect derivatise of the likelihood wrt parameters
          dfdp(1:npar) = dfdp(1:npar) + dfds*dsdp(1:npar)
          do j=1,npar
             d2fdp2(1:npar,j) = d2fdp2(1:npar,j) + d2fds21*dsdp(1:npar)*dsdp(j)
          enddo
          do j=1,npar
             d2fdp22(1:npar,j) = d2fdp22(1:npar,j) + d2fds22*dsdp(1:npar)*dsdp(j)
          enddo
       enddo
       !
       !   Primitive minimisers

       write(*,*)fvalue,fvalue_old
       if(fvalue.le.fvalue_old) then
          scale_GS_save = scale_GS_log
          B_iso_GS_save = B_iso_GS
          u_aniso_GS_save(1:6) = u_aniso_GS(1:6)          
          fvalue_old = fvalue
          !  Solve the equation
          call deigen_filter_r90(toler,d2fdp2(1:npar,1:npar),npar,npar,dfdp(1:npar),shifts(1:npar),ierr)
          !if(maxval(abs(shifts(1:npar))).le.0.0) then
             
          !call deigen_filter_r90(toler,d2fdp22(1:npar,1:npar),npar,npar,dfdp(1:npar),shifts(1:npar),ierr)
          !endif
          !write(*,*)'Shifts ',alpha,shifts(1:npar)
          !
          !    Do not allow excessive shifts that would make scale negative or B values too large
          alpha = 1.0
          write(*,*)'alpha ',alpha,shifts
          do while(abs(alpha*shifts(2)).gt.20.0)
             alpha = alpha/2.0
          enddo
          do while (maxval(abs(alpha*shifts(3:npar))).gt.20.0) 
             alpha = alpha/2.0
          enddo
          write(*,*)'alpha ',alpha
       else
          alpha = alpha*0.5
          scale_GS_log = scale_GS_save
          scale_gs = exp(scale_gs)
          B_iso_GS = B_iso_GS_save
          u_aniso_GS(1:6) = u_aniso_GS_save(1:6)
       endif
       scale_GS_log =scale_GS_log - alpha*shifts(1)
       scale_gs = exp(scale_gs_log)
       B_iso_GS = max(0.0,B_iso_GS - alpha*shifts(2))
       do ip=1,6
          u_aniso_GS(ip) = u_aniso_GS(ip) - alpha*sum(shifts(3:npar)*eigen_aniso(1:n_eigen_aniso,ip))
       enddo
       !write(*,*)'ML cycle  ',icycle,b_res
       !write(*,*)'fvalue ',fvalue
       !write(*,*)'Scale and B value ',scale_GS,B_iso_GS
       !write(*,*)'Aniso U values    ',u_aniso_GS
       !if(icycle.eq.5) stop
       !
       !   line minimisation??? For quick result use the simplest line minimisers. Half shifts if they are too large.
       !   Robustness weights should be here
       !stop
    enddo
    !u_aniso_GS = u_aniso_GS/100.0
    deallocate(d2fdp2)
    deallocate(d2fdp22)
    deallocate(dfdp)
    deallocate(shifts)
    deallocate(w_robust)
    write(*,*)'After ML/Bayesian'
    write(*,*)'Scale value = ',scale_GS
    write(*,*)'B value     = ',B_iso_GS
    write(*,*)'U aniso     = ',U_aniso_GS(1:6)
    write(*,*)
    !stop
    !
    !  Print out reflections with low weight (< 0.5?)
  end subroutine scale_GlebSasha_I

  subroutine random_generate_chisq(hkl_asym,fo)
    integer, intent(in) :: hkl_asym(:,:)
    real, intent(inout) :: fo(:,:)

    integer i,no,i_inter,isysab
    real sus,s1,s2,s3,ss(6)
    real GS_value
    real rand_gauss(2),ff_rand,rchisq
    real rsq,rsq1,epsl,sigma_id,scale
    integer icent
    real lstlsq

    no = size(fo(1,:))

    i_inter = -1
    do i=1,no
       if(fo(2,i).gt.0.0) cycle
       call centr(hkl_asym(1:3,i),icent)
       call epslon(hkl_asym(1:3,i),epsl,isysab)
       rsq = lstlsq(1,hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)) 
       !
       !  calculate ss(i)
       s1 = float(hkl_asym(1,i))*rcell(1)
       s2 = float(hkl_asym(2,i))*rcell(2)
       s3 = float(hkl_asym(3,i))*rcell(3)
       ss(1) = s1*s1
       ss(2) = s2*s2
       ss(3) = s3*s3
       ss(4) = 2.0*s1*s2
       ss(5) = 2.0*s1*s3
       ss(6) = 2.0*s2*s3
       ss(1:6) = ss(1:6)/4.0

       sus = sum(ss(1:6)*u_aniso_gs(1:6))       

       call random_vector_gauss(2,rand_gauss)
       rsq1 = 4.0*rsq
       call linter_value2(nwilson,IdealWilson(1,1:nwilson),IdealWilson(2,1:nwilson),rsq1,i_inter,GS_value)
       
       scale = scale_GS*exp(-B_iso_GS*rsq-sus)
       sigma_id = scale*GS_value*epsl
       if(icent.eq.1) then
          rchisq = rand_gauss(1)**2
          fo(1,i) = sqrt(rchisq*sigma_id)
          fo(2,i) = sqrt(sigma_id*(pi-2.0)/pi)
       else
          rchisq = rand_gauss(1)**2+rand_gauss(2)**2
          fo(1,i) = sqrt(rchisq*sigma_id/2.0)
          fo(2,i) = sqrt(sigma_id*(4.0-pi)/4)
       endif
    enddo

  end subroutine random_generate_chisq

  subroutine expected_value_chisq(hkl_asym,fo)

    integer, intent(in) :: hkl_asym(:,:)
    real, intent(inout) :: fo(:,:)
    !
    !   Calculate expected values and the second central moments for
    !   those reflections that do not have observations for.
    !
    !  locals
    integer i_inter
    integer nref,i
    real sus,s1,s2,s3,ss(6)
    real GS_value,scale
    real rsq,rsq1,sigma_id
    !
    integer icent,isysab
    real epsl
    real lstlsq
    !
    !   Body
    nref = size(fo(1,:))
    i_inter = -1
    do i=1,nref
       if(fo(2,i).gt.0.0) cycle
       call centr(hkl_asym(1:3,i),icent)
       call epslon(hkl_asym(1:3,i),epsl,isysab)
       rsq = lstlsq(1,hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)) 
       !
       !  calculate ss(i)
       s1 = float(hkl_asym(1,i))*rcell(1)
       s2 = float(hkl_asym(2,i))*rcell(2)
       s3 = float(hkl_asym(3,i))*rcell(3)
       ss(1) = s1*s1
       ss(2) = s2*s2
       ss(3) = s3*s3
       ss(4) = 2.0*s1*s2
       ss(5) = 2.0*s1*s3
       ss(6) = 2.0*s2*s3
       ss(1:6) = ss(1:6)/4.0
       sus = sum(ss(1:6)*u_aniso_gs(1:6))   
       rsq1 = 4.0*rsq
       call linter_value2(nwilson,IdealWilson(1,1:nwilson),IdealWilson(2,1:nwilson),rsq1,i_inter,GS_value)
       scale = scale_GS*exp(-B_iso_GS*rsq-sus)
       sigma_id =GS_value*epsl*scale
       if(icent.eq.1) then
          !fo(1,i) = sqrt(sigma_id)
          fo(1,i) = sqrt(sigma_id*2.0/pi)
          fo(2,i) = sqrt(sigma_id*(pi-2.0)/pi)
       else
          !fo(1,i) = sqrt(sigma_id)
          fo(1,i) = sqrt(sigma_id*pi/4.0)
          fo(2,i) = sqrt(sigma_id*(4.0-pi)/4)
       endif
    enddo
  end subroutine expected_value_chisq

  subroutine log_scale_GS(hkl_asym,io)
    !
    !   log scaling: to get things started
    integer, intent(in) :: hkl_asym(:,:)
    real, intent(in) :: io(:,:)
    !
    !
    integer no
    integer i,ierr
    real ff,ff1,rsq
    real*8 df(2),d2f(2,2),shifts(2)
    real*8 :: toler=1.0d-8
    integer i_inter
    real GS_value,rmax_l,rsq1
    real lstlsq
    !
    df  = 0.0
    d2f = 0.0

    no = size(io(1,:))
    i_inter = -1
    rmax_l = -1.e32
    open(41)
    do i=1,no
       if(io(2,i).le.0.0 .or. io(1,i).le.0.0) cycle
       rsq = 4.0*lstlsq(1,hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)) 
       rmax_l = max(rmax_l,rsq)
       call linter_value2(nwilson,IdealWilson(1,1:nwilson),IdealWilson(2,1:nwilson),rsq,i_inter,GS_value)
       ff = io(1,i)/GS_value
       !       write(41,*)rsq,ff,GS_value
       rsq1 = rsq/4.0
       ff1 = log(ff)
       df(1) = df(1) + ff1
       df(2) = df(2) - rsq1*ff1
       d2f(1,1) = d2f(1,1) + 1.0
       d2f(1,2) = d2f(1,2) - rsq1
       d2f(2,2) = d2f(2,2) + rsq1*rsq1
    enddo
    d2f(2,1) = d2f(1,2)
    call deigen_filter_r90(toler,d2f,2,2,df,shifts,ierr)
    scale_GS = exp(shifts(1))
    B_iso_GS = shifts(2)
 
  end subroutine log_scale_GS

  subroutine convert_I2F(hkl_asym,io,fo)

    integer, intent(in) :: hkl_asym(:,:)
    real, intent(in) :: io(:,:)
    real, intent(out) :: fo(:,:)
    integer nref

    integer ir,no
    integer icent,isysab
    real epsl,rsq,rsq1,s1,s2,s3,ss(6)
    real cc,t0,an0,an1,an2,F_exp,F2_exp
    real exp_part0,exp_part1,exp_part2,rem_part0,rem_part1,rem_part2
    !
    real sus,Sigma,SigmaEps,sigo
    integer i_inter
    real GS_value,an_vec(3),rem_part_vec(3),exp_part_vec(3)
    real lstlsq
    !
    !  body
    nref = size(io(1,:))
    i_inter = -1
    !write(*,*)nref
    open(44)
    do ir=1,nref
       if(io(2,ir).le.0.0) cycle
       call centr(hkl_asym(1:3,ir),icent)
       call epslon(hkl_asym(1:3,ir),epsl,isysab)
       rsq = lstlsq(1,hkl_asym(1,ir),hkl_asym(2,ir),hkl_asym(3,ir)) 
       !
       !  calculate ss(i)
       s1 = float(hkl_asym(1,ir))*rcell(1)
       s2 = float(hkl_asym(2,ir))*rcell(2)
       s3 = float(hkl_asym(3,ir))*rcell(3)
       ss(1) = s1*s1
       ss(2) = s2*s2
       ss(3) = s3*s3
       ss(4) = 2.0*s1*s2
       ss(5) = 2.0*s1*s3
       ss(6) = 2.0*s2*s3
       ss(1:6) = ss(1:6)/4.0

       sus = sum(ss(1:6)*u_aniso_GS(1:6))
       rsq1 = 4.0*rsq
       call linter_value2(nwilson,IdealWilson(1,1:nwilson),IdealWilson(2,1:nwilson),rsq1,i_inter,GS_value)
       Sigma = scale_GS*exp(-b_iso_GS*rsq-sus)*GS_value
       SigmaEps = epsl*Sigma
       !SigmaEps = 8.0*SigmaEps
       if(icent.eq.1) then
          cc  = 2.0
          an0 = -0.5
          an1 = 0.0
          an2 = 0.5
       else
          cc  = 1.0
          an0 = 0.0
          an1 = 0.5
          an2 = 1.0
       endif
       sigo = io(2,ir)
       t0 = (io(1,ir) - sigo**2/(cc*SigmaEps))/sigo

       an_vec(1) = an0
       an_vec(2) = an1
       an_vec(3) = an2
       call t02inf_laplace_mc(t0,3,an_vec,exp_part_vec,rem_part_vec)
       rem_part0 = rem_part_vec(1)
       exp_part0 = exp_part_vec(1)
       rem_part1 = rem_part_vec(2)
       exp_part1 = exp_part_vec(2)
       rem_part2 = rem_part_vec(3)
       exp_part2 = exp_part_vec(3)

       rem_part0 = rem_part0*sigo**(an0+1.0)
       rem_part1 = rem_part1*sigo**(an1+1.0)
       rem_part2 = rem_part2*sigo**(an2+1.0)
       F_exp  = exp(-exp_part_vec(2)+exp_part_vec(1))*rem_part1/rem_part0
       F2_exp = exp(-exp_part_vec(3)+exp_part_vec(1))*rem_part2/rem_part0       
       !write(*,*) cc,t0,io(1:2,ir),F_exp,F2_exp,SigmaEps,sqrt(SigmaEps*pi/4.0),exp_part0,exp_part1,exp_part2
       !write(*,*)t0,rem_part0,rem_part1,rem_part2
       !write(*,*)F2_exp-F_exp**2
       !fo(1,ir) = sqrt(F2_exp)
       fo(1,ir) = F_exp
       fo(2,ir) = sqrt(F2_exp-F_exp**2)
       !write(44,*)icent,rsq1,epsl,Sigma,SigmaEps,io(1:2,ir),fo(1:2,ir)
    enddo
    !stop
  end subroutine convert_I2F
       
  subroutine scale_GS_cleanup
    
    if(allocated(IdealWilson)) deallocate(IdealWilson)
    
  end subroutine scale_GS_cleanup

  subroutine read_ideal_wilson

    integer i
    real i1,s1
    logical lexists
    integer in,ierr,ios
    character(len=512) :: file_local=' '
    !
    !
    call ugtenv('IDEALW',file_local)
    if(len_trim(file_local).le.0.or.trim(file_local).eq.'IDEALW') then
       call ugtenv('CLIBD',file_local)
       file_local = trim(file_local)//'/ideal_wilson.txt'
    endif
    inquire(file=file_local,exist=lexists)
    write(*,*)trim(file_local),lexists
    if(len_trim(file_local).le.0 .or. .not.lexists) then
       write(*,*)'File for "ideal wilson curve" could not be found'
       call ccperr(1,'Fatal error: Intensity curve is missing')
    endif
    call open_form_file(in,file_local,ierr)

    nwilson = 0
    ios = 0
    do while(ios.eq.0) 
       read(in,*,iostat=ios)s1,i1
       if(ios.eq.0) then
          nwilson = nwilson + 1
       endif
    enddo

    write(*,*)nwilson
    if(nwilson.le.0) then
       write(*,*)'Problem with ideal wilson: number of sample points = ',nwilson
       call ccperr(1,'Fatal error: problem in ideal wilson curve')
    endif
    allocate(IdealWilson(2,nwilson))

    rewind(in)
    do i=1,nwilson
       read(in,*)IdealWilson(1:2,i)
    enddo
    close(in)
    
  end subroutine read_ideal_wilson

end module GlebSasha
