module CellAndSymmetry
  implicit none
  !
  !---Cell parameters ROR orthogonolization RFR deorthogonolization 
  !---matrices
  !---Symmetry
  !
  !---Cell parameters, orthogonoliazation and deorthogonolization matrices
  !---
  integer, parameter :: MaxSym = 192
  integer NumSymmetry, NumPrimSymm,NumSymmRFT,NumSpaceGroup,NonCubSym,NonCubPrim
  integer LsymmFlags(MaxSym),isort(5)
  real cell(6),rcell(6),ror(3,3),rfr(3,3),RealSymmMatrx(4,4,Maxsym)
  real RealSymmRFT(4,4,Maxsym),RecipSymmMatrx(4,4,Maxsym),PremutRecipSymm(4,4)
  real rot(3,3,maxsym),tr(3,maxsym),rotr(3,3,maxsym),trr(3,maxsym),asi(3,3,maxsym)
  integer ifactor_cc
  character ltype*1,PointGroupName*10,SpaceGroupName*20
  integer NumLaueSymm
  CHARACTER LaueGroupName*10

  real vol,rvol
  integer nx,ny,nz,n1,n2,n3,ipx,ipy,ipz,ispno
  real cosa,cosb,cosg,sina,sinb,sing,cosz,cosast,volume
  real rsymfrac(3,3,maxsym)
  integer nsmult,nsym
  !
  !   For aniso
  real dcosa,dcosb,dcosg,dsina,dsinb,dsing,dcosz
  real :: ro_unit(3,3)=0.0,rfr_unit(3,3)=0.0,uucell2orth(6,6)=0.0,uuorth2cell(6,6)=0.0
  real :: rmatr_ort2cell(3,3)=0.0
  real :: RealSymm_Aniso(6,6,maxsym)=0
  logical :: eigen_aniso_flag=.FALSE.
  real eigen_aniso(6,6)
  integer :: n_eigen_aniso=0

contains
  subroutine aniso_eigens
    !
    !---Finds directions in 6 dimensional space along which overall
    !---anisotropic U values could be refined. If changes to anisotropic
    !---U values will be applied along these directions only then 
    !---resulting aniso should obey symmetry and trU = 0 (providing that
    !---initial U obeys these conditions)
    !
    !   Locals
    !
    real*8 uc2o(6,6)
    REAL*8 R_MAT1(6,6),R_MAT2(6,6),R_DERIV2(6,6),R_DERIV1(6,6)
    real*8 r_deriv3(6,6),evalue(6),workspace(40)
    real*8 work1(40),evalue1(6)
    INTEGER I,J,IS,I_DERIV,LWORK,INFO
    CHARACTER LINE*128
    LOGICAL ERROR
    !
    !----Initialise
    if(sum(uucell2orth(1:6,1:6)).le.0.0) then
       call calc_unit_transforms
       call find_conv_matrix(ro_unit,uucell2orth)
       call find_conv_matrix(rfr_unit,uuorth2cell)
    endif

    LWORK = 40
    r_deriv3(1:6,1:6) = 0.0d0
    !
    DO   IS=1,NumSymmetry
       !
       !---Add derivatives due to symmetry restrictions. Storage is colimnwise
       r_mat1(1:6,1:6) = ReaLSymm_Aniso(1:6,1:6,is)
       DO   I=1,6
          R_MAT1(I,I) = R_MAT1(I,I)-1.0
       ENDDO
       r_mat2(1:6,1:6) = matmul(r_mat1(1:6,1:6),transpose(r_mat1(1:6,1:6)))
       r_deriv3(1:6,1:6) = r_deriv3(1:6,1:6) + r_mat2(1:6,1:6)
    ENDDO
    !
    !---Add contribution from (trU)^2
    r_deriv2(1:6,1:6) = 0.0
    DO   J=1,3
       DO   I=1,3
          R_DERIV2(I,J) = 1.0
       ENDDO
    ENDDO
    !

    uc2o(1:6,1:6) = dble(uucell2orth(1:6,1:6))
    r_mat1(1:6,1:6) = matmul(r_deriv2(1:6,1:6),transpose(uc2o(1:6,1:6)))
    r_mat2(1:6,1:6) = matmul(uc2o(1:6,1:6),r_mat1(1:6,1:6))
    I_DERIV = 0
    r_deriv3(1:6,1:6) = r_deriv3(1:6,1:6) + r_mat2(1:6,1:6)
    CALL DSYEV_MO('V','U',6,R_DERIV3,6,EVALUE,WORKSPACE,LWORK,INFO)
    
    if(info.gt.0) then
       write(*,*)'Problem in aniso_eigens',info
       stop
    endif
    !
    !---Now select directions according to eigenvalues.
    I_DERIV = 0
    DO  I=1,6
       IF(EVALUE(I).gt.0.001) cycle
       I_DERIV = I_DERIV + 1
       DO   J=1,6
          EIGEN_ANISO(I_DERIV,J) = R_DERIV3(J,I)
       ENDDO
    ENDDO
    
    N_EIGEN_ANISO = I_DERIV
    IF(N_EIGEN_ANISO.LE.0) THEN
       write(*,*)'Warning==> No anisotropic scale factor for this space group'
    ENDIF
    eigen_aniso_flag = .TRUE.
    RETURN

  end subroutine aniso_eigens
  
  subroutine calc_unit_transforms
    !
    !   Calculate some of the transformation matrices for future use
    integer ii,jj,isym,ierr
    real s,a1,a2,a3,alpha,beta,gamma,det
    real rs(3,3),rs_conv(3,3)

    real :: degtor = 4.0*atan(1.0)/180.0

    a1 = cell(1)
    a2 = cell(2)
    a3 = cell(3)
    if(cell(4).le.5.0.or.cell(5).le.5.0.or.cell(6).le.5.0)then
       alpha = cell(4)
       beta  = cell(5)
       gamma = cell(6)
    else
       alpha = cell(4)*degtor
       beta  = cell(5)*degtor
       gamma = cell(6)*degtor
    endif
    call nb_frorth_r(a1,a2,a3,alpha,beta,gamma,ror,rfr,ierr)

    !
    !----Unit ortogonolisation matrox
    RO_UNIT(1,1) = ror(1,1)/A1
    RO_UNIT(1,2) = ror(1,2)/A2
    RO_UNIT(1,3) = ror(1,3)/A3
    RO_UNIT(2,2) = ror(2,2)/A2
    RO_UNIT(2,3) = ror(2,3)/A3
    RO_UNIT(3,3) = ror(3,3)/A3
    RO_UNIT(2,1) = 0.0
    RO_UNIT(3,1) = 0.0
    RO_UNIT(3,2) = 0.0

    !
    DO     ISYM=1,NumSymmetry
       CALL FIND_CONV_MATRIX(RealSymmMatrx(1:3,1:3,isym),RealSymm_Aniso(1:6,1:6,isym))
    ENDDO

  end subroutine calc_unit_transforms

end module CellAndSymmetry

