program mi_generate
  implicit none

  integer i,j
  logical ccp4_style,input_defined,output_defined
  !
  !  program arguments
  integer narg
  character*512 argc,prog_name
  !
  !   Files
  logical eof
  character(len=512) :: file_in=' ',file_out=' '

  real cell(6)
  character(len=32) :: spgroup
  real resmax,resmin,stlmax,stlmin
  real resmx,resmn
  real rs

  !
  !---Things for parser
  logical eokey,ccp4_key
  character line*512
  logical   lprint,lend
  real      fvalue(500)
  integer   ntok
  integer   ibeg(500),iend(500),ityp(500),idec(500)
  character key*4
  character cvalue(500)*4
  !
  ! command line interpretation
  integer ncommand
  !
  !  symmetry
  integer is
  integer maxsym
  integer isysabs
  parameter (maxsym=192)
  integer isym_unit,nsymp
  integer NumSpaceGroup,NumPrimSymm
  integer NumSymmetry,nsym
  real RealSymmMatrx(4,4,maxsym)
  real rot(3,3,maxsym),tr(3,maxsym)
  integer sym_to_a(3,3,maxsym),trans_to_a(3,maxsym)
  integer nospgr,ispno
  character ltype*1
  character(len=32) :: SpaceGroupName,namspg_cifs,nampg,pgnam,PointGroupName,sgnm
  !
  ! mtz things
  integer iprint,ifail
  integer mtzin,mtzout
  real smn,smx
  real celmtz(6)

  integer ncol
  character ctyps(200)*1,clabs(200)*30

  integer nref_mtz,nfree
  !
  !
  logical keep_free
  integer ih,ik,il,h,k,l,hhh(3),hkl_l(3)
  integer hmax,kmax,lmax
  integer hkl_in(3)
  real    hkl_in1(3)
  integer hkl_new(3),hkl_sym(3)
  real ast,bst,cst,cosast,cosbst,coscst,rsq
  integer, allocatable :: freer_all(:,:,:)
  !
  !  twin (or something else)
  integer ioutput
  integer it,itw
  integer n_twins,n_twins2
  integer sym_tw(3,3,maxsym)
  real*8 score_tw(maxsym)
  real*8 cell_a(6)
  real*8 tol_a
  !
  !  final hkl
  integer iappnd
  integer maxprgo,nlprgo
  parameter (maxprgo = 30)
  character lsprgo(maxprgo)*30,ctprgo(maxprgo)*1
  integer nmax_refl,nrefl_l,nfreer,ifree
  real fraction
  real bdata(20),adata(200)
  integer, allocatable :: hkl_list(:,:)
  integer, allocatable :: freer_list(:)
  !
  !
  !  random numbers and other temporary variables
  real pi,degtor
  real cell_l(6)
  integer freer_now
  integer irfrac,itk,itemp,ll
  integer irand,nrand
  real rvec(1000)
  !----------------------------------------------------------
  keep_free=.FALSE.
  nrand = 1000
  mtzin = 1
  mtzout = 2
  ccp4_style = .FALSE.
  input_defined = .FALSE.
  output_defined = .FALSE.
  call ugtenv('HKLIN',file_in)
  ccp4_key = .FALSE.
  if(trim(file_in).eq.'HKLIN'.or.len_trim(file_out).le.0) then
     file_in = ' '
  else
     ccp4_key = .TRUE.
  endif
  call ugtenv('HKLOUT',file_out)
  if(trim(file_out).eq.'HKLOUT'.or.len_trim(file_out).le.0) then
     file_out = ' '
  else
     ccp4_key = .TRUE.
  endif

  !
  !  read as a standard linux command
  narg = iargc()
  i = 1
  call getarg(0,argc)
  prog_name = trim(argc)
  argc = ' '
  if(narg.le.0) then
     call print_command_line_summary(argc,prog_name)
     stop
  endif
  refl_increse = 3.0
  fraction = 0.05
  resmax = 1.0e32
  do while(i.le.narg)
     call getarg(i,argc)
     if(trim(argc).eq.'-i'.or.trim(argc).eq.'--input') then
        i = i + 1
        if(i.le.narg) then
           call getarg(i,argc)
           file_in = trim(argc)
           i = i + 1
        endif
     elseif(trim(argc).eq.'-o'.or.trim(argc).eq.'--output') then
        i = i + 1
        if(i.le.narg) then
           call getarg(i,argc)
           file_in = trim(argc)
           i = i + 1
        endif
     elseif(trim(argc).eq.'-c'.or.trim(argc).eq.'--cell') then
        i = i + 1
        if(i.le.narg-5) then
           do j=1,6
              call getarg(i,argc)
              read(argc,*)cell(j)
              i=i+1
           enddo
        endif
     elseif(trim(argc).eq.'-s'.or.trim(argc).eq.'--spacegroup') then
        i = i + 1
        call getarg(i,argc)
        i = i + 1
        spgroup = trim(argc)
     elseif(trim(argc).eq.'-r'.or.trim(argc).eq.'--resolution') then
        i = i + 1
        call getarg(i,argc)
        i = i + 1
        read(argc,*)resmax
        resmax = 1.0/resmax
     elseif(trim(argc).eq.'-e'.or.trim(argc).eq.'--extend') then
        i = i + 1
        call getarg(argc)
        read(argc,*)ref_extend
        i = i + 1
     else if(trim(argc).eq.'-f'.or.trim(argc).eq.'--fraction'.or.trim(argc).eq.'-p') then
        i = i +1
        call getarg(i,argc)
        i = i + 1
        read(argc,*)fraction
        if(fraction.le.0.0) fraction = 0.05
        if(fraction.gt.1.0) fraction = fraction/100.0
     else if(trim(argc).eq.'-k'.or.trim(argc).eq.'--keepfree') then
        i = i +1
        keep_free = .TRUE.
     else
        call print_command_line_summary(argc,prog_name)
        stop
     endif
  enddo

  iprint = 0
  ifail  = -1
  if(len_trim(file_in).gt.0) then
     call lropen(1,file_in,iprint,ifail)
     CALL LRSYMI(MTZIN,NumPrimSymm,ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
     CALL LRRSOL(MTZIN,SMN,SMX)
     resmax = min(resmax,sqrt(smx))
     call lrcell(mtzin,celmtz)
     cell = celmtz
     spgroup = SpaceGroupName
  endif
 

  if(len_trim(file_out).le.0) then
     if(len_trim(file_in).gt.0) then
        ll = len_trim(file_in)
        if(ll.gt.4) then
           if(file_in(ll-2:ll).eq.'mtz'.and.file_in(ll-3:ll-3).eq.'.') then
              file_out = file_in(1:ll-4)//'_unique.mtz'
           else
              file_out = trim(file_in)//'_unique.mtz'
           endif
        else
           file_out = trim(file_in)//'_unique.mtz'
        endif
     else
        file_out = 'free_unique.mtz'
     endif
  endif
  !
  !   Use ccp4 style keyword interpreation
  eokey= .FALSE.
  do while(.not.eokey.and.ccp4_key) 
     call parser(key,line,ibeg,iend,ityp,fvalue,cvalue, idec,ntok,lend,lprint)
     call ccpupc(key)
     if(lend) then 
        eokey=.TRUE.
     else if(key.eq.'CELL') then
        itk = 2
        CALL RDCELL(itk,ITYP,FVALUE,NTOK,CELL)
     else if(key.eq.'SPGR'.or.key.eq.'SPAC') then
        CALL RDSYMM(itk,LINE,IBEG,IEND,ITYP,FVALUE,NTOK,SGNM,ISPNO,PGNAM,NSYM,NumSymmetry,RealSymmMatrx)
     else if(key.eq.'RESO') then
        itk = 2
        CALL RDRESO(itk,ITYP,FVALUE,NTOK,ResMin,ResMax,STLMIN,STLMAX)
     else if(key.eq.'KEEP') then
        keep_free=.TRUE.
     else if(key.eq.'END') then
        eokey = .TRUE.
     endif
  enddo
  if(resmax .gt. 10000.0)resmax = 2.0
  !
  !  Now take symm operators
  isym_unit = 0
  !  namspg_cifs = spgroup
  namspg_cifs = ' '
  nampg = ' '
  nsymp = 0
  NumSymmetry = 0
  nospgr = 0
  CALL MSYMLB3(ISYM_UNIT,NOSPGR,spgroup,NAMSPG_CIFS,NAMPG,NSYMP,NumSymmetry,RealSymmMatrx)
  rot(1:3,1:3,1:NumSymmetry) = RealSymmMatrx(1:3,1:3,1:NumSymmetry)
  tr(1:3,1:NumSymmetry) = RealSymmMatrx(1:3,4,1:NumSymmetry)
  nsym = NumSymmetry
  !  stop
  !
  !   Find potential twin operators (coset decomposition of lattice symmetry by the crystal symmetry
  call symm2int_by12_1(maxsym,nsym,rot,tr,sym_to_a,trans_to_a)
  ioutput = 0
  cell_a  = cell
  tol_a   = 0.03
  call yyy_cell2tg(cell_a,tol_a,nsym,sym_to_a,trans_to_a,maxsym,n_twins,n_twins2,sym_tw,score_tw,ioutput)

  cell_l = cell
  pi = 4.0*atan(1.0)
  degtor = pi/180.0
  if(maxval(abs(cell_l(4:6))).gt.pi) then
     cell_l(4:6) = cell_l(4:6)*degtor
  endif
  call define_res_pars(cell_l,ast,bst,cst,cosast,cosbst,coscst)
  stlmax = 1.0/(2.0*resmax)
  call find_max_hkl(stlmax,cell_l,hmax,kmax,lmax)

  allocate(freer_all(-hmax:hmax,-kmax:kmax,-lmax:lmax))
  freer_all = 0

  if(len_trim(file_in).gt.0) then
     if(keep_free) then
        call lrclab(mtzin,clabs,ctyps,ncol)
        ifree = 0
        do i=1,ncol
           if(ctyps(i).eq.'I') then
              ifree = i
           endif
        enddo
        if(ifree.le.0) then
           write(*,*)'Warning==> There is no free flags in the input file. '
           write(*,*)'Warning==> The list of new free reflections will be generated'
           keep_free = .FALSE.
        else
           eof = .FALSE.
           nref_mtz = nref_mtz + 1
           nfree = 0
           do while(.not.eof)
              call lrrefl(mtzin,rsq,adata,eof)
              hkl_in(1:3) = adata(1:3)
              if(nint(adata(ifree)).eq.0) nfree=nfree+1
              nref_mtz = nref_mtz + 1
              do is=1,nsym
                 hkl_sym = nint(matmul(transpose(rot(1:3,1:3,is)),hkl_in))
                 freer_all(hkl_sym(1),hkl_sym(2),hkl_sym(3)) = adata(ifree)
                 freer_all(-hkl_sym(1),-hkl_sym(2),-hkl_sym(3)) = adata(ifree)
              enddo
           enddo
           fraction = float(nfree)/float(nref_mtz)
           write(*,'(a)')'Free flags will be copied from the input mtz file.'
           write(*,'(a,f10.4)')'Fraction of free reflections in the input file = ',fraction
        endif
     endif
     call lrclos(mtzin)
  endif

  write(*,'(a,a)')     'file_in          ',trim(file_in)
  write(*,'(a,a)')     'file_out         ',trim(file_out)
  write(*,'(a,6f10.4)')'cell parameters  ',cell
  write(*,'(a,a)')     'space group      ',trim(spgroup)
  write(*,'(a,f10.4)') 'fraction         ',fraction
  write(*,'(a,f10.4)') 'resolution       ',resmax

  write(*,*)'Number of potential twin operators ',n_twins
  
  write(*,*)'Potential twin operators'
  do i=1,n_twins
     do j=1,3
        write(*,*)float(sym_tw(1:3,j,i))/12.0
     enddo
     write(*,*)
  enddo

  nmax_refl = nint(2.0*(2*hmax+1)*(2*kmax+1)*(2*lmax+1)/nsym)
  allocate(hkl_list(3,nmax_refl))
  allocate(freer_list(nmax_refl))

  call ranmar(rvec,nrand)
  irand = 0
  irfrac = nint(1.0/fraction)
  do ih=-hmax,hmax
     do ik=-kmax,kmax
        do il=-lmax,lmax
           if(freer_all(ih,ik,il).ne.0) cycle
           irand = irand + 1
           if(irand.gt.nrand) then
              call ranmar(rvec,nrand)
              irand = 1
           endif
           !
           !   If we already have free assigned then use it. Use only the first among all symmetry and twin
           !   related reflections
           freer_now = max(0,min(irfrac-1,int(irfrac*rvec(irand))))+1
           loop1: do it=1,n_twins
              hkl_in1 = float(matmul(sym_tw(1:3,1:3,it),hkl_in))/12
              do is=1,nsym
                 hkl_new = nint(matmul(rot(1:3,1:3,is),hkl_in1))
                 if(freer_all(hkl_new(1),hkl_new(2),hkl_new(3)).ne.0) then
                    freer_now = freer_all(hkl_new(1),hkl_new(2),hkl_new(3))
                    exit loop1
                 endif
              enddo
           enddo loop1
           hkl_in(1) = ih
           hkl_in(2) = ik
           hkl_in(3) = il
           do it=1,n_twins
              hkl_in1 = float(matmul(sym_tw(1:3,1:3,it),hkl_in))/12
              do is=1,nsym
                 hkl_new = nint(matmul(rot(1:3,1:3,is),hkl_in1))
                 freer_all(hkl_new(1),hkl_new(2),hkl_new(3)) = freer_now
              enddo
           enddo
           hkl_in(1) = -ih
           hkl_in(2) = -ik
           hkl_in(3) = -il
           do it=1,n_twins
              hkl_in1 = float(matmul(sym_tw(1:3,1:3,it),hkl_in))/12.0
              do is=1,nsym
                 hkl_new = nint(matmul(rot(1:3,1:3,is),hkl_in1))
                 freer_all(hkl_new(1),hkl_new(2),hkl_new(3)) = freer_now
              enddo
           enddo
        enddo
     enddo
  enddo
  freer_all = freer_all-1
  resmx = -1.0e32
  resmn = 1.0e32
  nrefl_l = 0
  lloop: do   l=-lmax,lmax
     kloop: do  k=-kmax,kmax
        hloop: do   h=-hmax,hmax
           !
           !--If this reflection is inside resolution limit and 
           !--it is present by symmetry then account it
           !
             if(h.eq.0.and.k.eq.0.and.l.eq.0) cycle
             hhh(1) = h
             hhh(2) = k
             hhh(3) = l
             call define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
             rs = sqrt(rsq)/2.0
             if(rs.gt.stlmax) cycle hloop

             call sysabs_symm_r(maxsym,nsym,rot,tr,h,k,l,isysabs)
             if(isysabs.eq.1) cycle hloop
             do is = 1,nsym
                hkl_l(3)=nint(rot(1,3,is)*h+ rot(2,3,is)*k+rot(3,3,is)*l) 
                !
                !---If at least one of the symmety related is greater than this 
                !   reflection 
                !---then go out of the symmetry loop and do not take this reflection 
                !---into account
               if(hkl_l(3).gt.l) then
                  cycle hloop
               else if(hkl_l(3).eq.l) then
                  hkl_l(2)=nint(rot(1,2,is)*h+ rot(2,2,is)*k+ rot(3,2,is)*l)
                  if(hkl_l(2).gt.k) then
                     cycle hloop
                  else if(hkl_l(2).eq.k) then
                     hkl_l(1)=nint(rot(1,1,is)*h+rot(2,1,is)*k+ rot(3,1,is)*l)
                     if(hkl_l(1).gt.h) then
                        cycle hloop
                     endif
                  endif
               endif
               !
               !---consider -h,-k,-l
               hkl_l(3)=-nint(rot(1,3,is)*h+rot(2,3,is)*k+rot(3,3,is)*l) 
               !
               !---If at least one of the symmety related is less than this reflection 
               !---then go out oof the symmetry loop and do not take this reflection 
               !---into account
               !
               if(hkl_l(3).gt.l) then
                  cycle hloop
               else if(hkl_l(3).eq.l) then
                  hkl_l(2)=-nint(rot(1,2,is)*h+rot(2,2,is)*k+  rot(3,2,is)*l)
                  if(hkl_l(2).gt.k) then
                     cycle hloop
                  else if(hkl_l(2).eq.k) then
                     hkl_l(1)=-nint(rot(1,1,is)*h+rot(2,1,is)*k+ rot(3,1,is)*l)
                     if(hkl_l(1).gt.h) then
                        cycle hloop
                     endif
                  endif
               endif
            enddo
            !
            !--this reflection is maximum among all symmetry related. Take it.
            ! 
            nrefl_l = nrefl_l + 1
            hkl_list(1,nrefl_l) = h
            hkl_list(2,nrefl_l) = k
            hkl_list(3,nrefl_l) = l
            freer_list(nrefl_l) = freer_all(h,k,l)
            !--Do we need to add centricity and epslon into this array?
            call define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
            resmx = max(resmx,sqrt(rsq)/2.0)
            resmn = min(resmn,sqrt(rsq)/2.0)

         enddo hloop
      enddo kloop
   enddo lloop

   call lwopen(mtzout,file_out)
   call lwtitl(mtzout,' Unique free reflections',1)
   iappnd = 0
   lsprgo(1) = 'H'
   ctprgo(1) = 'H'
   lsprgo(2) = 'K'
   ctprgo(2) = 'H'
   lsprgo(3) = 'L'
   ctprgo(3) = 'H'
   lsprgo(4) = 'FreeR_flag'
   ctprgo(4) = 'I'
   nlprgo = 4

   call lwassn(mtzout,lsprgo,nlprgo,ctprgo,iappnd)
   call lwclab(mtzout,lsprgo,nlprgo,ctprgo,iappnd)
   call lwcell(mtzout,cell)
   !   call lwsort(mtzout,isort)
   call lwsymm(mtzout,NumSymmetry,NumPrimSymm,RealSymmMatrx,ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
   nfreer = 0
   do i=1,nrefl_l
      bdata(1:3) = float(hkl_list(1:3,i))
      bdata(4) = float(freer_list(i))
      if(freer_list(i).eq.0) nfreer = nfreer + 1
      call lwrefl(mtzout,bdata)
   enddo

   call lwclos(mtzout,0)

end program freer_with_rotation


subroutine print_command_line_summary(argc,prog_name)

  character(len=*) :: argc,prog_name

  write(*,*)'-------------------------------------------------------------------------------'
  write(*,*)'Usage: ',trim(prog_name),' command value'
  write(*,*)'command is one or more of the followings:'
  write(*,*)' -i or --input               - input mtz file'
  write(*,*)' -o or --output              - output mtz with only freeR flag'
  write(*,*)' -s or --spacegroup          - space group'
  write(*,*)' -f or -p or --fraction      - freeR fraction'
  write(*,*)' -r or --resolution          - maximum resolution'
  write(*,*)' -c or --cell                - cell parameters'
  write(*,*)' -k ir --keep  without value - keep free R from the input file. It will owerride -f option and'
  write(*,*)'                               free R fraction will be calculated from the existing freeR'
  write(*,*)
  write(*,*)'The program will create list of reflections up maximum resolution and'
  write(*,*)'assign free flags accounting for potential twin/pseudo symmetry '
  write(*,*)'FreeR flags assigned in highest possible point of the crystal lattice group'
  write(*,*)'If input mtz file is defined then all other info - space group resolution, cell '
  write(*,*)'are taken from this file. Defualt output file corresponds to the input file'
  write(*,*)'     input:   in.mtz  ---> output:  in_unique.mtz'
  write(*,*)'If no input or output file is defined then the output file is: freer_unique.mtz'
  write(*,*)'-------------------------------------------------------------------------------'
  
end subroutine print_command_line_summary
