module solvent_all      
  real :: prob_vdw_init=0.9,prob_vdw_end=1.6,prob_vdw_delta=0.1
  real :: prob_ion_init=0.6,prob_ion_end=1.1,prob_ion_delta=0.1
  real :: radii_shrink_init=0.5,radii_shrink_end=1.1,radii_shrink_delta=0.1
  real :: prob_vdw = 1.2,prob_ion=0.8,prob_dum=0.8,radii_shrink=0.8
  real :: scale_ls_sol_m=0.35,b_ls_sol_m=70.0

  real :: rfree_prev=1.0e32,rfact_prev=1.0e32
  real :: prob_vdw_rfactor=1.2,prob_ion_rfactor=0.8,radii_shrink_rfactor=0.8
  real :: prob_vdw_rfree=1.2,prob_ion_rfree=0.8,radii_shrink_rfree=0.8

  !
  !
  logical :: solvent_flag=.TRUE.,solvent_write_flag=.FALSE.,b_ls_solvent_mask_flag=.TRUE.
  logical :: scale_ls_solvent_mask_flag=.TRUE.
  logical :: solvent_optimise=.FALSE.
  logical :: solvent_remove_islands = .TRUE.
  logical :: solvent_ignore_dum = .FALSE.

contains
  subroutine optimise_solvent_all
    use atomcom
    use agreem
    use twin_refmac
    use rharvest
    use refi_flags
    implicit none
    !
    !   Optimisation of solvent parameters (vdw probe, ion probe and shrinkage) for standard cases
    !
    integer nasym
    integer, allocatable :: hkl_asym(:,:)
    real, allocatable :: freer(:)
    real, allocatable :: fo(:)
    real, allocatable :: sigo(:)
    real, allocatable :: fcalc(:,:,:)
    real, allocatable :: fpart(:,:,:)
    real, allocatable :: fc_all(:,:)
    real, allocatable :: phase_all(:,:)
    real, allocatable :: fwt(:)
    
    !
    !---Observations
    integer nref
    integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
    integer num_list
  
    !
    
    integer ihh(3)
    integer i,ii
    integer npart_act
    integer jnum_o
    integer ndens,nasym1,nmodel
    real pisq8_l
    !
    logical scale_ls_part_refine_flag_save(nmaxpart),b_ls_part_refine_flag_save(nmaxpart)
    real b_ls_part_save(nmaxpart),scale_ls_part_save(nmaxpart)

    !
    !  Solvent optimisation parameters
    integer nvdw_prob_num,nion_prob_num,nshrink_num
    !
    !
    integer irsh,iv
    !
    !---  Scaling, stat calculation, gradients secders for twin refinement
    ndens = 1
    nmodel = 1
    npart_act = 1
    npart = 1
    call read_nrefl(nref)
    nobs = nref

    allocate(fo(nref))
    allocate(sigo(nref))
    allocate(freer(nref))
    allocate(hkl_asym(3,nref))
    call rdind(nref,fo,sigo,freer,hkl_asym)
    allocate(fwt(nref))
    fwt(1:nref) = 1.0
    !
!    allocate(fpart(npart_act,2,nref))
!    call solvent_twin(nref,ndens,nmodel,hkl_asym,fpart(npart_act:npart_act,1:2,1:nref))
!    do i=1,100
!       write(*,*)'solvent',fpart(1,1:2,i)
!    enddo
    allocate(fcalc(2,nref,ndens))
    call fs_from_crd(nref,ndens,nmodel,hkl_asym,fcalc)

    !    pisq8_l = 128.0*atan2(1.0,1.0)**2
    !b_ls_over = uover_atom*pisq8_l
    !
    call header('Optimisation of solvent parameters: grid search')
    write(*,'(a)')' --------------------- -------------------------------------------------'
    write(*,'(a)')' :   VDW probe  :  ION probe :   Shrinkage :    Rfactor  :     Rfree   :'
    !
    !   Add a loop for Babinet's bulk solvent yes/no also
    allocate(fpart(1,2,nref))

    allocate(fc_all(nref*(npart+1),ndens))
    allocate(phase_all(nref*(npart+5),ndens))
    !
    !  Calculate initial scales etc
    call solvent_twin(nref,ndens,nmodel,hkl_asym,fpart(1:1,1:2,1:nref))
    phase_all = 0.0
             
    do i=1,nref
       fc_all(i,1) = sqrt(fpart(1,1,i)**2+fpart(1,2,i)**2)
       phase_all(i,1) = 0.0
       if(fc_all(i,1).gt.0.0) phase_all(i,1) = atan2(fpart(1,2,i),fpart(1,1,i))
       fc_all(nref+i,1) = sqrt(fcalc(1,i,1)**2+fcalc(2,i,1)**2)
       phase_all(nref+i,1) = 0.0
       if(fc_all(nref+i,1).gt.0.0) phase_all(nref+i,1) = atan2(fcalc(2,i,1),fcalc(1,i,1))
    enddo
    call log_scaling(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all(nref*npart+1,1),freer)
    b_ls_over0 = 0.0
    do i=1,npart
       b_ls_part_refine_flag_save(i) = b_ls_part_refine_flag(i)
       b_ls_part_refine_flag(i) = .FALSE.
       scale_ls_part_refine_flag_save(i) = scale_ls_part_refine_flag(i)
       scale_ls_part_refine_flag(i) = .FALSE.
       scale_ls_part_save(i) = scale_ls_part(i)
       scale_ls_part(i) = 0.0
       b_ls_part_save(i) = b_ls_part(i)
       b_ls_part(i) = 0.0
    enddo

    call ls_scaling(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all,phase_all,freer)

    call lsq_coef(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all,phase_all,freer)
    do i=1,npart
       b_ls_part_refine_flag(i) = b_ls_part_refine_flag_save(i)
       scale_ls_part_refine_flag(i) = scale_ls_part_refine_flag_save(i)
       scale_ls_part(i) = scale_ls_part(i)
       b_ls_part(i) = b_ls_part_save(i)
    enddo
    call ls_scaling(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all,phase_all,freer)
    call lsq_coef(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all,phase_all,freer)
    write(*,'(5(a2,f12.5),a2)')' :',prob_vdw,' :',prob_ion,' :',radii_shrink,                     &
         ' :',rfactor_work,' :',rfactor_free,' :'

    prob_vdw = prob_vdw_init
    prob_ion=prob_ion_init
    radii_shrink = radii_shrink_init
    nvdw_prob_num = nint((prob_vdw_end-prob_vdw_init)/prob_vdw_delta) + 1
    nion_prob_num = nint((prob_ion_end-prob_ion_init)/prob_ion_delta) + 1
    nshrink_num = nint((radii_shrink_end-radii_shrink_init)/radii_shrink_delta)
    
    do iv=1,nvdw_prob_num
       prob_vdw = prob_vdw + prob_vdw_delta
       prob_ion = prob_ion_init
       do ii=1,nion_prob_num
          prob_ion = prob_ion + prob_ion_delta
          radii_shrink = prob_ion
          !          radii_shrink = radii_shrink_init
          !          if(prob_ion.gt.prob_vdw) exit
          !          do irsh=1,nshrink_num
          !            radii_shrink = radii_shrink + radii_shrink_delta
          if(radii_shrink.gt.prob_vdw) exit
          call solvent_twin(nref,ndens,nmodel,hkl_asym,fpart(npart_act:npart_act,1:2,1:nref))
          phase_all = 0.0
          
          do i=1,nref
             fc_all(i,1) = sqrt(fpart(1,1,i)**2+fpart(1,2,i)**2)
             phase_all(i,1) = 0.0
             if(fc_all(i,1).gt.0.0) phase_all(i,1) = atan2(fpart(1,2,i),fpart(1,1,i))
             fc_all(nref+i,1) = sqrt(fcalc(1,i,1)**2+fcalc(2,i,1)**2)
             phase_all(nref+i,1) = 0.0
             if(fc_all(nref+i,1).gt.0.0) phase_all(nref+i,1) = atan2(fcalc(2,i,1),fcalc(1,i,1))
          enddo
          
          !             call log_scaling(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all((nref+1):(2*nref),1),freer)
          call ls_scaling(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all,phase_all,freer)
          call lsq_coef(nref,ndens,hkl_asym,fo,sigo,fwt,fc_all,phase_all,freer)
          write(*,'(5(a2,f12.5),a2)')' :',prob_vdw,' :',prob_ion,' :',radii_shrink,                     &
               ' :',rfactor_work,' :',rfactor_free,' :'
          if(rfactor_free.lt.rfree_prev) then
             prob_vdw_rfree  = prob_vdw 
             prob_ion_rfree = prob_ion
             radii_shrink_rfree = radii_shrink
             rfree_prev = rfactor_free
          endif
          if(rfactor_work.lt.rfact_prev) then
             prob_vdw_rfactor  = prob_vdw 
             prob_ion_rfactor = prob_ion
             radii_shrink_rfactor = radii_shrink
             rfact_prev = rfactor_work
          endif
          !enddo
       enddo
    enddo
    write(*,*) ' -----------------------------------------------------------------------'
    write(*,*)
    call header('Minimum R factor and corresponding solvent parameters')
    write(*,*)'   Rfactor   =',rfact_prev
    write(*,*)'   VDW probe =',prob_vdw_rfactor
    write(*,*)'   ION probe =',prob_ion_rfactor
    write(*,*)'   Shrinkage =',radii_shrink_rfactor
    
    write(*,*)
    call header('Minimum R free and corresponding solvent parameters')
    write(*,*)'   Rfree     =',rfree_prev
    write(*,*)'   VDW probe =',prob_vdw_rfree
    write(*,*)'   ION probe =',prob_ion_rfree
    write(*,*)'   Shrinkage =',radii_shrink_rfree
    write(*,*) '------------------------------------------------------------------'


    deallocate(fo)
    deallocate(sigo)
    deallocate(fc_all)
    deallocate(phase_all)
    deallocate(freer)
    deallocate(hkl_asym)
    deallocate(fpart)
    deallocate(fcalc)
    
    return
  end subroutine optimise_solvent_all
  !
  subroutine optimise_solvent_twin(refl_asym,refl_file)
    use atomcom
    use agreem
    use twin_refmac
    use rharvest
    implicit none
    !
    !   Optimisation of solvent parameters (vdw probe, ion probe and shrinkage) for twin cases
    !
    character(len=*), intent(in) :: refl_asym,refl_file
    integer nasym
    integer, allocatable :: hkl_asym(:,:)
    real, allocatable :: hl_abcd(:,:)
    real, allocatable :: fsolvent(:,:,:)
    real, allocatable :: fcalc(:,:,:)
    real, allocatable :: fpart(:,:,:)
    
    !
    !---Observations
    integer nobs,npart
    integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
    integer num_list
    integer, allocatable :: block_start(:)
    integer, allocatable :: ref_2_asym_start(:)
    integer, allocatable :: obs_start(:)
    integer, allocatable :: comp_numb(:)
    integer, allocatable :: ref_2_asym(:)
    integer, allocatable :: ref_2_symm(:)
    integer, allocatable :: block_2_asym(:)
    integer, allocatable :: freer(:)
    real, allocatable :: weights_b(:)
    real, allocatable :: iobs(:,:)
    !
    integer in_file,ierr
    integer iobs_file
    integer i,ii,j,jj,k,kk,io,io1,jo1,ko1,ib,o_s,o_f
    integer npart_act
    integer jnum_o
    integer ndens,nasym1,nmodel
    real pisq8_l
    !
    !  Solvent optimisation parameters
    integer nvdw_prob_num,nion_prob_num,nshrink_num
    !
    !
    integer irsh,iv
    !
    !---  Scaling, stat calculation, gradients secders for twin refinement
    ndens = 1
    nmodel = 1
    call open_unform_file(in_file,refl_asym,ierr)
    read(in_file)nasym
    allocate(hkl_asym(3,nasym))
    
    !--If phase info is available then use it also. We could make it as if
    !--it is always present. Perhaps it is better way of dealing with this problem
    !--
    !
    do  i=1,nasym
       read(in_file)hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)
    enddo
    close(in_file)
    npart_act = 1
    npart = 1
    allocate(fpart(npart_act,2,nasym))
    !
    !---  Exclude atoms from refinement 
    
    !
    !---Structure factors from coordinates
    allocate(fcalc(2,nasym,1))
    call fs_from_crd(nasym,ndens,nmodel,hkl_asym,fcalc)
    !
    !---read observations
    call open_unform_file(in_file,refl_file,ierr)
    read(in_file)nobs,ncomp,num_blocks,num_asym_ref
    !    
    !---  We need to define memories
    allocate(freer(num_blocks))
    allocate(weights_b(num_blocks))
    allocate(block_start(num_blocks+1))
    allocate(ref_2_asym_start(num_blocks+1))
    allocate(iobs(2,nobs))
    allocate(obs_start(nobs+1))
    allocate(comp_numb(ncomp))
    allocate(ref_2_asym(ncomp))
    allocate(ref_2_symm(ncomp))
    allocate(block_2_asym(num_asym_ref))
    allocate(hl_abcd(4,nasym))
    num_list = num_blocks
    !
    !--   read abcd       
    !
    !---  How many fractions do we have. Need to be stored somewhere.
    block_start(1) = 0
    obs_start(1) = 0
    io1 = 1
    ref_2_asym_start(1) = 0
    ii = 0
    do  ib=1,num_blocks
       read(in_file)num_obs,jsym,freer(ib),weights_b(ib)
       block_start(ib+1) = block_start(ib) + num_obs
       do   io=1,num_obs
          ii = ii + 1
          read(in_file)jnum_o
          obs_start(io1+1) = obs_start(io1) + jnum_o
          jo1 = obs_start(io1)
          read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
          io1 = io1 + 1
       enddo
       ko1 = ref_2_asym_start(ib)
       read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
       ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
    enddo
    close(in_file)
    !
    do i=1,num_blocks
       o_s = block_start(i)+1
       o_f = block_start(i+1)
       do j=o_s,o_f
          iobs(1:2,j) = iobs(1:2,j)/scale_ls_init
       enddo
    enddo
    pisq8_l = 128.0*atan2(1.0,1.0)**2
    b_ls_over = uover_atom*pisq8_l
    !

    prob_vdw = prob_vdw_init
    prob_ion=prob_ion_init
    radii_shrink = radii_shrink_init
    nvdw_prob_num = nint((prob_vdw_end-prob_vdw_init)/prob_vdw_delta) + 1
    nion_prob_num = nint((prob_ion_end-prob_ion_init)/prob_ion_delta) + 1
    nshrink_num = nint((radii_shrink_end-radii_shrink_init)/radii_shrink_delta)
    
    call header('Optimisation of solvent parameters: grid search')
    write(*,'(a)')' ---------------------------------------------------------------------'
    write(*,'(a)')' : VDW probe   :  ION probe  :  Shrinkage  :   Rfactor   :    Rfree   :'
    !
    !   Add a loop for Babinet's bulk solvent yes/no also
    do iv=1,nvdw_prob_num
       prob_vdw = prob_vdw + prob_vdw_delta
       prob_ion = prob_ion_init
       do ii=1,nion_prob_num
          prob_ion = prob_ion + prob_ion_delta
          radii_shrink = prob_ion
          if(prob_ion.gt.prob_vdw) exit
          call solvent_twin(nasym,ndens,nmodel,hkl_asym,fpart(npart_act:npart_act,1:2,1:nasym))
          call init_ls_params(nasym,hkl_asym,fcalc,npart_act,fpart,num_blocks,block_start,ref_2_asym_start,      &
               nobs,iobs,obs_start,ncomp,comp_numb,ref_2_asym,ref_2_symm,num_asym_ref,block_2_asym,ierr)
          call refine_ls_parameters(nasym,hkl_asym,fcalc,npart_act,fpart,num_blocks,                 &
               block_start,ref_2_asym_start,nobs,iobs,obs_start,ncomp,comp_numb,ref_2_asym,          &
               ref_2_symm,num_asym_ref,block_2_asym,ierr)
          call calc_ls_stat(nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,num_blocks,         &
               block_start,ref_2_asym_start,nobs,iobs,obs_start,ncomp,comp_numb,ref_2_asym,          &
               ref_2_symm,num_asym_ref,block_2_asym,ierr)
          write(*,'(5(a2,f12.5),a2)')' :',prob_vdw,' :',prob_ion,' :',radii_shrink,                     &
               ' :',rfactor_all,' :',rfactor_free,' :'
          if(rfactor_free.lt.rfree_prev) then
             prob_vdw_rfree  = prob_vdw 
             prob_ion_rfree = prob_ion
             radii_shrink_rfree = radii_shrink
             rfree_prev = rfactor_free
          endif
          if(rfactor_all.lt.rfact_prev) then
             prob_vdw_rfactor  = prob_vdw 
             prob_ion_rfactor = prob_ion
             radii_shrink_rfactor = radii_shrink
             rfact_prev = rfactor_all
          endif
       enddo
    enddo
    write(*,*) ' ---------------------------------------------------------------------'
    write(*,*)
    call header('Minimum R factor and corresponding solvent parameters')
    write(*,*)'   Rfactor   =',rfact_prev
    write(*,*)'   VDW probe =',prob_vdw_rfactor
    write(*,*)'   ION probe =',prob_ion_rfactor
    write(*,*)'   Shrinkage =',radii_shrink_rfactor

    write(*,*)
    call header('Minimum R ffree and corresponding solvent parameters')
    write(*,*)'   Rfree     =',rfree_prev
    write(*,*)'   VDW probe =',prob_vdw_rfree
    write(*,*)'   ION probe =',prob_ion_rfree
    write(*,*)'   Shrinkage =',radii_shrink_rfree
    write(*,*) '------------------------------------------------------------------'


    deallocate(freer)
    deallocate(weights_b)
    deallocate(block_start)
    deallocate(ref_2_asym_start)
    deallocate(iobs)
    deallocate(obs_start)
    deallocate(comp_numb)
    deallocate(ref_2_asym)
    deallocate(ref_2_symm)
    deallocate(block_2_asym)
    deallocate(hkl_asym)
    deallocate(fpart)
    deallocate(fcalc)
    
    return
  end subroutine optimise_solvent_twin
end module solvent_all
