      subroutine refpre_twin
      use weights
      use coords
      use automorphism
      use restr_files
      use CellAndSymmetry
      use refi_flags
      implicit none
      include 'twin_refmac.fh'
                                !
      integer reindex_flag
      real twin_reindex_op(4,4)
      character twin_text*128
      integer nasym
      integer i,nobs1,nobs2,isysabs
      character in_refl_file*512
      integer iout,ierr,imsg
      real ssqmin,ssqmax
      real res_max
c
      real, allocatable :: iobs(:,:)
      integer, allocatable :: hkl_list(:,:)
      integer, allocatable :: hkl_asym(:,:)
      integer, allocatable :: freer(:)
c
      integer freesum
      real stlmin0,stlmax0,res_max_out,res_min_out
      character refl_type*4
      integer ifile
      real eps_l
c
c---  body
c
c--   The list of reflections in asymmetric unit
      eps_l = 1.0e-5
c      res_max = stlmax*(1.0+twin_toler+eps _l)
      res_max = stlmax + eps_l
c
      if(reftyp.eq.'HKL') then
         call getenv('HKLIN',in_refl_file)
      else if(reftyp.eq.'MTZ') then
         call find_unique_file_name(in_refl_file,'refl.inter')
         input_orig_data = in_refl_file
         call open_unform_file(iout,in_refl_file,ierr)
c     
c---  Sot out resolution, bins, read mtz file and write to another file
c---  Here we read only I and sigI. No partials, phases or any other things.
c---  But be careful. Later we may want I+, I-, phases etc.
         call mtz_refl_size(nobs,stlmin0,stlmax0)
         nobs1 = nobs
         allocate(iobs(2,nobs))
         allocate(hkl_list(3,nobs))
         allocate(freer(nobs))
         call mtz_refl_read_int(nobs1,hkl_list,iobs,freer)
         nobs2 = 0
         do i=1,nobs1
            if(hkl_list(1,i).ne.0.or.hkl_list(2,i).ne.0
     &           .or.hkl_list(3,i).ne.0) then
               call sysabs_symm_r(maxsym,nsym,rot,tr,hkl_list(1,i),
     &              hkl_list(2,i),hkl_list(3,i),isysabs)
               if(isysabs.eq.0) then
                  nobs2 = nobs2 + 1
                  hkl_list(1:3,nobs2) = hkl_list(1:3,i)
                  iobs(1:2,nobs2) = iobs(1:2,i)
                  freer(nobs2) = freer(i)
               endif
            endif
         enddo
         nobs1 = nobs2
         call header('Info from mtz')
         freesum = nobs2 - sum(freer(1:nobs2))
         write(*,'(a,i10)')'free R flag                  ',
     &        LFreeRexcludeVal
         write(*,'(a,i10)')'Number of "free" reflections ',freesum
         write(*,'(a,i10)')'Number of   all  reflctions  ',nobs2
         if(freesum.gt.nobs2/2) then
            write(*,*)'Warning ==> Number of free refletions is ',
     &           ' more than half all reflections '
            if(LFreeRexcludeVal.eq.0) then
               write(*,*)'Warning ==> Switching to free R flag = 1'
               LfreeRexcludeVal = 1
               freer(1:nobs2) = 1-freer(1:nobs2)
            else
               write(*,*)'Error ==> Cannot switch free R flag '
               write(*,*)'Error ==> It is likely that this flag ',
     &              'has been defined by user '
               call ccperr(1,'Problem with free R flag')
            endif
         endif
         write(*,'(120a1)')('-',i=1,80)
c
c---  Find maximum resolution accounting for twin

         call twin_max_reso(maxsym,nsym,rot,tr,ntwin_domain,twin_oper,
     &        cell,res_max_out,res_min_out,nobs1,hkl_list(1:3,1:nobs1))
         res_max = res_max_out + eps_l

         res_max = res_max*rand_extend
         stlmax = res_max
         stlmin_data = res_min_out
c         stop
         write(iout)nobs1
         do i=1,nobs1
            write(iout)hkl_list(1:3,i),iobs(1:2,i),freer(i)
         enddo
         close(iout)
         deallocate(iobs)
c         deallocate(hkl_list)
         deallocate(freer)
      endif
      call asym_list_size(maxsym,nsym,rot,tr,cell,nasym,res_max)
      allocate(hkl_asym(3,nasym))
      call asym_list(maxsym,nsym,rot,tr,cell,nasym,
     &     res_max,hkl_asym)
c
      call find_unique_file_name(refl_asym,'refl.asym')
      call open_unform_file(ifile,refl_asym,ierr)
      write(ifile)nasym
      do i=1,nasym
         write(ifile)hkl_asym(1:3,i)
      enddo
      deallocate(hkl_asym)
      close(ifile)
      call reorganise_all_data(in_refl_file)
c     
      call genpre
      call decide_twin_opers_fcalc(reindex_flag,twin_reindex_op)
      if(reindex_flag.eq.1.and.twin_reindex_transform.eq.'C') then
         call header('Coordinate transformation')
         imsg = 0
         call t4twinop(RealSymmMatrx(1:4,1:4,1:nsym),twin_reindex_op,
     &        imsg,ierr)
         if(ierr.gt.0) then
            write(*,*)'Problem in t4twinop'
            write(*,*)
     &           'You may need to reindex your data using pointless'
            ierr = 0
            call write_xml(ierr,'Premature termination: reindex')
            call refmac_clean_up_files
            call ccperr(0,'End of refmac')
         else
            write(*,'(90a)')('-',i=1,80)
            write(*,*)'Coordinates will be transformed to make '//
     &           'the major domain as the first domain'
            write(*,*)'It is not a recommended option. '//
     &           'It is better to reindex using pointless/scala'
            call header('Transformation operator')
            call put_symm_to_text(twin_reindex_op(1:3,1:3),
     &           twin_reindex_op(1:3,4),twin_text)
            write(*,*)'Transformation operator: ',trim(twin_text)
            write(*,'(90a)')('-',i=1,80)
         endif
         call apply_transform_coord(twin_reindex_op)
         twin_frac(1:ntwin_domain) = 1.0/float(ntwin_domain)

         call decide_twin_opers_fcalc(reindex_flag,twin_reindex_op)
         if(reindex_flag.eq.1) then
            write(*,'(a80)')'Now!! It is silly.'
            stop
         endif
      elseif(reindex_flag.eq.1.and.twin_reindex_transform.eq.'D') then
         ierr = 0
         write(*,*)'Data need to be reindexed using coordinates as'//
     &        ' reference'
         write(*,*)'You can use pointless for this purpose with the'//
     &        ' following command'
         write(*,*)'pointless hklin <mtzfile> xyzin <crdfile> hklout'//
     &        '<output.mtz'
         call write_xml(ierr,'Premature termination: reindex')
         call refmac_clean_up_files
         call ccperr(1,'End of refmac')
      endif

      call twin_max_reso(maxsym,nsym,rot,tr,ntwin_domain,twin_oper,
     &     cell,res_max_out,res_min_out,nobs1,hkl_list(1:3,1:nobs1))
      res_max = res_max_out + eps_l
      stlmax = res_max
      stlmin_data = res_min_out
      res_max = res_max*rand_extend
      stlmax_rand = res_max
      if(allocated(hkl_list))deallocate(hkl_list)
c
c--   Now we have the reorgised data
c---  Make decisions about resolution bins etc
      call twin_define_reso_bins_etc
c
c---  Sort out phase information here
      call read_and_write_abcd

c      if(reftyp(1:3).eq.'MTZ') then
c         call open_unform_file(ifile,in_refl_file,ierr)
c         close(ifile,status='DELETE')
c      endif
c--   
c      stop
      return
      end
c     
      subroutine read_and_write_abcd
      use agreem
      use restr_files
      use CellAndSymmetry
      use refi_flags
      use mtz_things
      implicit none
c
c---
      integer ifile,ierr
      integer nasym
      integer, allocatable :: hkl_asym(:,:)
      integer, allocatable :: hkl_obs(:,:)
      integer, allocatable :: index(:)
      real, allocatable :: abcd(:,:)
      
      integer ir,is,irs,iro,ii,isc,it,nabcd
      integer icent
      integer hc(3),hkl_s(3),hkl_l(3)
      real twopi,sin1,cos1,sin2,cos2,fom,phase,trr_l,blur_factor
      real rsq,ssq,stl
      real abcd_l(4),tr_l(3)
      real lstlsq
      external lstlsq
      logical eof
c
c---  body
      if(.not.MIR_FLAG.and..not.PHASE_FLAG) return
      if(len_trim(refl_asym).le.0) return
      call open_unform_file(ifile,refl_asym,ierr)
      read(ifile)nasym
      if(nasym.le.0) then
         close(ifile)
         return
      endif
      twopi = 8.0*atan(1.0)
      allocate(hkl_asym(3,nasym))
      do ir=1,nasym
         read(ifile)hkl_asym(1:3,ir)
      enddo
      close(ifile)
c
      allocate(hkl_obs(3,nasym))
      allocate(abcd(4,nasym))
      abcd(1:4,1:nasym) = 0.0
      call lrrewd(mtzin)
      call lrrefl(mtzin,ssq,adata,eof)
      call lrrefm(mtzin,logmss)
      stl = sqrt(ssq)
      ii = 0
      do while(.not.eof)
         if(stl.le.2.0*stlmax) then
            ii = ii + 1
            hkl_l(1:3) = nint(adata(1:3))
            call centr(hkl_l(1:3),icent)
            abcd_l(1:4) = 0.0
            if(MIR_FLAG) then
               if(.not.logmss(ihla)) abcd_l(1) = adata(ihla)
               if(.not.logmss(ihlb)) abcd_l(2) = adata(ihlb)
               if(.not.logmss(ihlc)) abcd_l(3) = adata(ihlc)
               if(.not.logmss(ihld)) abcd_l(4) = adata(ihld)
            elseif(PHASE_FLAG) then
               fom = 1.0
               if(.not.logmss(ifom)) fom = adata(ifom)
               phase = 0.0
               if(.not.logmss(ipb)) phase = adata(ipb)
               call fomphase2ab(icent,fom,phase,abcd_l(1),abcd_l(2))
            endif
c     
c---  blur phases now????
            rsq = lstlsq(mtzin,hkl_l(1),hkl_l(2),hkl_l(3))
            blur_factor = phas_blur_scal*exp(-rsq*phas_blur_bval)
            abcd_l(1:4) = abcd_l(1:4)*blur_factor
c
c---  Bring to the asymmetric unit
            hc(1:3) =hkl_l(1:3)
            isc = 1
            do is=1,nsym
               hkl_s = matmul(nint(transpose(rot(1:3,1:3,is))),hkl_l)
               if(hkl_s(3).lt.hc(3)) then
                  hc(1:3) = hkl_s(1:3)
                  isc = is
               else if(hkl_s(3).eq.hc(3)) then
                  if(hkl_s(2).gt.hc(2)) then
                     hc(1:3) = hkl_s(1:3)
                     isc = is
                  else if(hkl_s(2).eq.hc(2)) then
                     if(hkl_s(1).gt.hc(1)) then
                        hc(1:3) = hkl_s(1:3)
                        isc = is
                     endif
                  endif
               endif
               hkl_s(1:3) = -hkl_s(1:3)
               if(hkl_s(3).lt.hc(3)) then
                  hc(1:3) = hkl_s(1:3)
                  isc = -is
               else if(hkl_s(3).eq.hc(3)) then
                  if(hkl_s(2).gt.hc(2)) then
                     hc(1:3) = hkl_s(1:3)
                     isc = -is
                  else if(hkl_s(2).eq.hc(2)) then
                     if(hkl_s(1).gt.hc(1)) then
                        hc(1:3) = hkl_s(1:3)
                        isc = -is
                     endif
                  endif
               endif
            enddo
            hkl_obs(1:3,ii) = hc(1:3)
            tr_l(1:3) = tr(1:3,abs(isc))
c            if(isc.le.0) tr_l(1:3) = -tr_l(1:3)
            if(isc.lt.0) then
               abcd_l(2) = -abcd_l(2)
               abcd_l(4) = -abcd_l(4)
            endif
            trr_l = twopi*sum(tr_l(1:3)*real(hkl_l(1:3)))
            cos1 = cos(trr_l)
            sin1 = sin(trr_l)
            cos2 = cos(2.0*trr_l)
            sin2 = sin(2.0*trr_l)

            abcd(1,ii) = abcd_l(1)*cos1-abcd_l(2)*sin1
            abcd(2,ii) = abcd_l(1)*sin1+abcd_l(2)*cos1
            abcd(3,ii) = abcd_l(3)*cos2-abcd_l(4)*sin2
            abcd(4,ii) = abcd_l(3)*sin2+abcd_l(4)*cos2
         endif
         call lrrefl(1,ssq,adata,eof)
         stl = sqrt(ssq)
         call lrrefm(1,logmss)
      enddo  
c
c---  sort and make correspondence with the asymmetric unit reflections.
c---  If there are more than one representative then average abcds (it may 
c---  not be valid procedure but I do not have any other idea at the moment)
      allocate(index(nasym))
      do ir=1,nasym
         index(ir) = ir
         it = hkl_obs(3,ir)
         hkl_obs(3,ir) = hkl_obs(1,ir)
         hkl_obs(1,ir) = it
      enddo
      call iheap_sort_r(nasym,3,hkl_obs,index)
      do ir=1,nasym
         it = hkl_obs(3,ir)
         hkl_obs(3,ir) = hkl_obs(1,ir)
         hkl_obs(1,ir) = it
      enddo

      if(len_trim(abcd_file).le.0) then
         call find_unique_file_name(abcd_file,'.abcd')
      endif
      call open_unform_file(ifile,abcd_file,ierr)

      write(ifile)nasym
      iro = 1
      do irs=1,nasym
         abcd_l(1:4) = 0.0
         nabcd = 0
         do while(hkl_obs(3,iro).le.hkl_asym(3,irs).and.
     &        hkl_obs(2,iro).le.hkl_asym(2,irs).and.
     &        hkl_obs(1,iro).le.hkl_asym(1,irs))
            if(hkl_obs(3,iro).lt.hkl_asym(3,irs)) then
               iro = iro + 1
            else
               if(hkl_obs(2,iro).lt.hkl_asym(2,irs)) then
                  iro = iro + 1
               else
                  if(hkl_obs(1,iro).lt.hkl_asym(1,irs)) then
                     iro = iro + 1
                  else if(sum(abs(hkl_obs(1:3,iro)-
     &                    hkl_asym(1:3,irs))).eq.0) then
                     abcd_l(1:4) = abcd_l(1:4) + abcd(1:4,iro)
                     nabcd = nabcd + 1
                     iro = iro + 1
                  endif
               endif
            endif
         enddo
         if(nabcd.gt.1) then
            abcd_l(1:4) = abcd_l(1:4)/nabcd
         endif
         write(ifile)abcd_l(1:4)
      enddo
      
      close(ifile)
      call lrrewd(mtzin)
c
      deallocate(index)
      deallocate(hkl_asym)
      deallocate(hkl_obs)
      deallocate(abcd)

      return
      end
c
      subroutine mtz_refl_size(nobs1,stlmin_o,stlmax_o)
      use agreem
      use refi_flags
      use mtz_things
      implicit none
      integer nobs1
      real stlmax_o,stlmin_o
c
c---  locals
      real    ssq,stl
      logical eof
c
c---  more mtz
c
c---  body
      stlmax_o = -1.0e32
      stlmin_o =  1.0e32
      call lrrewd(1)
      call lrrefl(1,ssq,adata,eof)
      call lrrefm(1,logmss)
      stl = sqrt(ssq)/2.0
      nobs1 = 0
      do while(.not.eof) 
         if(i_int_o.gt.0) then
            if(.not.logmss(i_int_o)) then
c         if( (i_int_sig_o.gt.0.and.adata(i_int_sig_o).gt.0.0) .or.
c     &       (iso.gt.0.and.adata(iso).gt.0.0) )  then
               if(stl.le.stlmax) nobs1 = nobs1 + 1
               stlmax_o = max(stl,stlmax_o)
               stlmin_o = min(stl,stlmin_o)
            endif
         elseif(ifo.gt.0.and.iso.gt.0) then
            if(.not.logmss(ifo).or..not.logmss(iso)) then
               if(stl.le.stlmax) nobs1 = nobs1 + 1
               stlmax_o = max(stl,stlmax_o)
               stlmin_o = min(stl,stlmin_o)
            endif
         endif
         call lrrefl(1,ssq,adata,eof)
         call lrrefm(1,logmss)
         stl = sqrt(ssq)/2.0
      enddo
      nobs = nobs1
      call lrrewd(mtzin)
c
      return
      end
c
      subroutine mtz_refl_read_int(nobs1,hkl,iobs,freer)
      use agreem
      use refi_flags
      use mtz_things
      implicit none
C
      integer nobs1
      integer hkl(3,nobs)
      real iobs(2,nobs)
      integer freer(nobs)
c
      integer i,itake
      real stl,ssq
      real fobs,sigf
      logical eof
c
c--   more mtz
c
      if(nobs1.le.0.or.nobs.le.0) then
         write(*,*)'Error==> array size in mtz_refl_read_int'
         call ccperr(1,'Problem with array sizes')
      endif
      call lrrefl(mtzin,ssq,adata,eof)
      call lrrefm(mtzin,logmss)
      stl = sqrt(ssq)
      i = 0
      do while(.not.eof)
         if(stl.le.2.0*stlmax) then
            itake = 0
            if(i_int_o.gt.0) then
               if(.not.logmss(i_int_o)) then
                  i = i + 1
                  hkl(1:3,i) = nint(adata(1:3))
                  iobs(1,i) = adata(i_int_o)
                  if(i_int_sig_o.gt.0) then
                     iobs(2,i) = adata(i_int_sig_o)
                  else
                     if(iobs(1,i).gt.0.0) then
                        iobs(2,i) = 0.02*iobs(1,i)
                     else
                        iobs(2,i) = max(3.0,3.0*abs(iobs(1,i)))
                     endif
                  endif
                  itake = 1
               endif
            elseif(ifo.gt.0.and.adata(ifo).gt.0.0) then
               if(adata(iso).gt.0.0) then
                  i = i + 1
                  hkl(1:3,i) = nint(adata(1:3))
                  fobs = adata(ifo)
                  sigf = adata(iso)
                  iobs(1,i) = fobs**2
                  iobs(2,i) = 2*fobs*sigf+sigf**2
                  itake = 1
               endif
            endif
            if(itake.eq.1) then
               if(ifree_o.gt.0) then
                  freer(i) = nint(adata(ifree_o))
                  if(freer(i).eq.LFreeRexcludeVal) then
                     freer(i) = 0
                  else
                     freer(i) = 1
                  endif
               else
                  freer(i) = 1
               endif                  
            endif
         endif
         call lrrefl(mtzin,ssq,adata,eof)
         call lrrefm(mtzin,logmss)
         stl = sqrt(ssq)
      enddo
      call lrrewd(mtzin)
      call lrclos(mtzin)
      nobs1 = i
      return
      end
c
      subroutine cif_ref_size(nobs)
      implicit none
      integer nobs

      return
      end
c
      subroutine cif_refl_read(nobs,hkl,iobs)
      implicit none
      integer nobs
      integer hkl(2,nobs)
      real iobs(2,nobs)

      return
      end
c
      subroutine scalepack_ref_size(nobs)
      implicit none
      integer nobs

      return
      end
c
      subroutine scalepack_refl_read(nobs,hkl,iobs)
      implicit none
      integer nobs
      integer hkl(2,nobs)
      real iobs(2,nobs)
c

      return
      end
c
      subroutine twin_define_reso_bins_etc
      use weights
      use agreem
      use restr_files
      use CellAndSymmetry
      use refi_flags
      implicit none
      include 'twin_refmac.fh'
c
c---Observations
      integer nasym
      integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: hkl_asym(:,:)
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      real, allocatable :: weights_b(:)
      integer, allocatable :: list_2_blocks(:)
      real, allocatable :: iobs(:,:)
c
c---  
      integer jnum_o
      integer in_file,ierr
      integer i,io,iref,ib,io1,jo1,ko1,ko2,ii,jj
      integer kk
      logical freerchk
c
      integer nmin_ref_in_bins,nref_all
      real binsize_ml_delta
      real rsq,stl_c,stlmax_io,stlmin_io
      real lstlsq
      character line*512
      real lstlsq_r
      external lstlsq_r
c---Read the list of reflections in the asymmetric unit

      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
   
c--If phase info is available then use it also. We could make it as if
c--it is always present. Perhaps it is better way of dealing with this problem
c--
      do  i=1,nasym
        read(in_file)hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)
      enddo
      close(in_file)
c
c---  read the observed reflections with their organisations
      call open_unform_file(in_file,refl_file,ierr)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c
c---  We need to define memories
      allocate(freer(num_blocks))
      allocate(weights_b(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(obs_start(nobs+1))
      allocate(iobs(2,nobs))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(list_2_blocks(num_blocks))
      do  ib=1,num_blocks
         list_2_blocks(ib) = ib
      enddo
c
      block_start(1) = 0
      obs_start(1) = 0
      io1 = 1
      ref_2_asym_start(1) = 0
      ii = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib),weights_b(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
      enddo
      close(in_file)
c
c---Define bins and make sure that each bin contain not less than certain number of blocks
c
      stlmin_ml = 2.0*stlmin
      stlmax_ml = 2.0*stlmax
      stlmin_io = 1.0e32
      stlmax_io = -1.0e32
      do ib=1,num_blocks
         ko1 = ref_2_asym_start(ib)+1
         ko2 = block_2_asym(ko1)
         rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,ko2))
         stl_c = sqrt(rsq)
         stlmin_io = min(stlmin_io,stl_c)
         stlmax_io = max(stlmax_io,stl_c)
      enddo
      stlmin_ml = max(stlmin_io,stlmin_ml-1.0e-5)
      stlmax_ml = min(stlmax_io,stlmax_ml+1.0e-5)
      if(mlusework) then
         nmin_ref_in_bins = 100
      else
         nmin_ref_in_bins = 30
      endif
 1    continue
      binsize_ml = 0.0005
      nbin_ml = max(1,min(maxbin,
     &     int(((stlmax_ml**3-stlmin_ml**3)/binsize_ml))+1))
      nbin_ml = max(1,min(30,nbin_ml))
      binsize_ml = (stlmax_ml**3-stlmin_ml**3)/nbin_ml
      binsize_ml_delta = binsize_ml/5.0
c      nbin_ml = maxbin
 9    continue
      sminb_ml(1) = stlmin_ml
      do i=2,nbin_ml
         sminb_ml(i) = (sminb_ml(i-1)**3+binsize_ml)**(1.0/3.0)
         smaxb_ml(i-1) = sminb_ml(i)
      enddo
      smaxb_ml(nbin_ml) = stlmax_ml + 0.1e-6
      sminb_ml(1) = max(0.0,sminb_ml(1)-0.1e-6)
      nref_ml(1:nbin_ml) = 0
      nref_all = 0
      do ib=1,num_blocks
         freerchk = .FALSE.
         if(freer_flag) then
            if((.not.mlusework).and.
     &           freer(ib).eq.0) freerchk = .TRUE.
            if(mlusework.and.freer(ib).ne.0) freerchk=.TRUE.
         endif
         if(.not.freer_flag .or.freerchk) then
            ko1 = ref_2_asym_start(ib)+1
            ko2 = block_2_asym(ko1)
            rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,ko2))
            stl_c = sqrt(rsq)
            do i=1,nbin_ml
               if(stl_c.le.smaxb_ml(i).and.stl_c.ge.sminb_ml(i)) then
                  nref_ml(i) = nref_ml(i) + 1
                  nref_all = nref_all + 1
               endif
            enddo
         endif
      enddo
      if(nbin_ml.eq.1.and..not.mlusework.and.
     &     nref_all.le.nmin_ref_in_bins.and.freer_flag) then
         call errwrt(0,
     &   'The number of reflections for ML parameters is not enough')
         write(line,'(a,i6)')
     &    'The number of reflections for ML = ',nref_all
         call errwrt(0,line)
         call errwrt(0,'Switching to option "SCALE MLSCALE WORKS"')
         call errwrt(0,'I.e. use working reflections for ML estimation')
         mlusework = .TRUE.
         nmin_ref_in_bins = 100
         goto 1
      else if(nbin_ml.eq.1) then
         goto 100
      else
         do ib=1,nbin_ml
            if(nref_ml(ib).lt.nmin_ref_in_bins) then
               binsize_ml = binsize_ml + binsize_ml_delta
               nbin_ml = max(1,min(nbin_ml-1,int(((stlmax_ml**3-
     &              stlmin_ml**3)/binsize_ml))+1))
               binsize_ml = (stlmax_ml**3-stlmin_ml**3)/nbin_ml
               goto 9
            endif
         enddo
      endif
 100  continue
      KERNEL_G = (SMAXB_ML(1)**3-SMINB_ML(1)**3)/2.0
      KERNEL_G_RAD = KERNEL_G
      NBIN_ML1 = NBIN_ML+1
      DELTA_S_TABLE = 0.0005
      N_POINTS_TABLE_S = INT((STLMAX_ML**3-STLMIN_ML**3)/DELTA_S_TABLE)
      N_POINTS_TABLE_S = MAX(20,MIN(2000,N_POINTS_TABLE_S))
      DELTA_S_TABLE = (STLMAX_ML**3-STLMIN_ML**3)/N_POINTS_TABLE_S
cd      WRITE(*,*)'tables ',N_POINTS_TABLE_S,DELTA_S_TABLE
      SMEANB_ML(1) = SMINB_ML(1)
      SMEANB_RAD(1) = SMINB_ML(1)**3
      IF(NBIN_ML.GT.1) THEN
        DO   I=2,NBIN_ML
          SMEANB_RAD(I) = SMINB_ML(I)**3
          SMEANB_ML(I) = (SMINB_ML(I)+SMAXB_ML(I)*3.0)/4.0
        ENDDO
      ENDIF
      SMEANB_ML(NBIN_ML1) = SMAXB_ML(NBIN_ML)
      SMEANB_RAD(NBIN_ML1) = SMAXB_ML(NBIN_ML)**3
      sigma_refine_style = 'BINS'
C
C---If MLUSEWORK is .false. then define different bins for sec.der.
      NBIN_RAD = NBIN_ML
      IF(.NOT.MLUSEWORK) THEN
         NMIN_REF_IN_BINS = 200
 101     continue
         BINSIZE_ML = 0.0005
         NBIN_RAD = MAX(1,MIN(30,
     &        INT(((STLMAX_ML**3-STLMIN_ML**3)/BINSIZE_ML)) 
     &        + 1))
         NBIN_RAD = MAX(1,MIN(30,NBIN_RAD))
         BINSIZE_ML = 
     &        ((STLMAX_ML**3-STLMIN_ML**3)/NBIN_RAD)
         BINSIZE_ML_DELTA = BINSIZE_ML/5.0
C
 109     CONTINUE
         SMEANB_RAD(1) = STLMIN_ML
         DO   I=2,NBIN_RAD
            SMEANB_RAD(I) = (SMEANB_RAD(I-1)**3+BINSIZE_ML)**(1.0/3.0)
         ENDDO
C
C---  Now check if there are enough reflections in each bin
C
C---- Find the number of reflections in the resolution bins
         smeanb_rad(nbin_rad+1) = stlmax_ml
         nref_ml(1:nbin_rad) = 0
         nref_all = 0
         do ib=1,num_blocks
            freerchk = .TRUE.
            if(freer_flag) then
               if(freer(ib).eq.0) freerchk = .FALSE.
            endif
            if(freerchk) then
               ko1 = ref_2_asym_start(ib)+1
               ko2 = block_2_asym(ko1)
               rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,ko2))
               stl_c = sqrt(rsq)
               do i=1,nbin_rad
                  if(stl_c.le.smeanb_rad(i+1).and.
     &                 stl_c.ge.smeanb_rad(i)) then
                     nref_ml(i) = nref_ml(i) + 1
                     nref_all = nref_all + 1
                  endif
               enddo
            endif
         enddo
C
C---- Check if there are enough reflection in each bin. 
         IF(NBIN_RAD.EQ.1) THEN 
            GOTO 200
         ELSE
            DO  IB=1,NBIN_RAD
               IF(NREF_ML(IB).LT.NMIN_REF_IN_BINS) THEN
C     
C---  Increase the bin size
                  BINSIZE_ML = BINSIZE_ML + BINSIZE_ML_DELTA           
                  NBIN_RAD = MAX(1,MIN(NBIN_RAD-1,
     &                 INT(((STLMAX_ML**3-STLMIN_ML**3)/BINSIZE_ML)) 
     &                 + 1))
                  BINSIZE_ML = 
     &                 ((STLMAX_ML**3-STLMIN_ML**3)/NBIN_RAD)
cd            WRITE(*,*)BINSIZE_ML,NBIN_ML
                  GOTO 109
               ENDIF
            ENDDO
         ENDIF
C
 200     CONTINUE
         DO   I=1,NBIN_RAD+1
            SMEANB_RAD(I) = SMEANB_RAD(I)**3
         ENDDO
      ENDIF
      KERNEL_G_RAD = (SMEANB_RAD(2)-SMEANB_RAD(1))/2.0
      KERNEL_G_RAD = (SMEANB_RAD(2)-SMEANB_RAD(1))/2.0
c      stop
c
      binsize = (stlmax**2-stlmin**2)/nbin
      sminb(1) = stlmin
      do i=2,nbin
         sminb(i) = sqrt(sminb(i-1)**2+binsize)
         smaxb(i-1) = sminb(i)
      enddo
      smaxb(nbin) = stlmax+1.0e-6
      sminb(1) = sminb(1)-1.0e-6
      smaxb(nbin+1) = smaxb(nbin)
      sminb(nbin+1) = sminb(1)
      deallocate(hkl_asym)
      deallocate(freer)
      deallocate(weights_b)
      deallocate(block_start)
      deallocate(obs_start)
      deallocate(iobs)
      deallocate(comp_numb)
      deallocate(ref_2_asym)
      deallocate(ref_2_symm)
      deallocate(block_2_asym)
      deallocate(ref_2_asym_start)
      deallocate(list_2_blocks)

      return
      end
c
      subroutine bootsrap_sample_twin
      use restr_files
      use refi_flags
      implicit none
c
c---  Bootsrap sampling of all reflections. Only list of blocks
c---  are resampled with replacement and for each block a weight corresponding
c---  to the number of occurancies of this block is assigned

      integer i_rand
      real, allocatable :: randoms(:)
c
c---Observations
      integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      real, allocatable :: weights_b(:)
      real, allocatable :: iobs(:,:)
c
      integer i,ii,j,jj,k,kk,io,io1,jo1,ko1,ib,o_s,o_f
      integer jnum_o
      integer in_file,ierr
c
c---body
c
c---read observations
      call open_unform_file(in_file,refl_file,ierr)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c     
c---  We need to define memories
      allocate(randoms(num_blocks))

      allocate(freer(num_blocks))
      allocate(weights_b(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(iobs(2,nobs))
      allocate(obs_start(nobs+1))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      num_list = num_blocks
c
c---  How many fractions do we have. Need to be stored somewhere.
      block_start(1) = 0
      obs_start(1) = 0
      ref_2_asym_start(1) = 0
      io1 = 1
      ii = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib),weights_b(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
c            iobs(1:2,ii) = iobs(1:2,ii)/scale_ls_init
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
      enddo
      close(in_file)
c
c---Generate random numbers
      call random_number(randoms)
      weights_b(1:num_blocks) = 0.0
c
c---- Take a sample size of n from  1..n with replacement. Effect in our case
c---- adding weights to each block of reflections. Weight is the number of 
c---- occurence of that block 
      do ib=1,num_blocks
         i_rand = int(randoms(ib)*num_blocks)+1
         weights_b(i_rand) = weights_b(i_rand) + 1
      enddo
      i_rand = 0
      do ib=1,num_blocks
         if(weights_b(ib).gt.0.0) i_rand=i_rand+1
      enddo
c
c
c---read observations
      call open_unform_file(in_file,refl_file,ierr)
      write(in_file)nobs,ncomp,num_blocks,num_asym_ref

      num_list = num_blocks
      io1 = 1
      ii  = 0
      do  ib=1,num_blocks
         num_obs = block_start(ib+1)-block_start(ib)
         jsym = ref_2_asym_start(ib+1)-ref_2_asym_start(ib)
         write(in_file)num_obs,jsym,freer(ib),weights_b(ib)
         do   io=1,num_obs
            ii = ii + 1
            jnum_o = obs_start(io1+1) - obs_start(io1)
            write(in_file)jnum_o
            jo1 = obs_start(io1)
            write(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         write(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
      enddo
      close(in_file)
c
      deallocate(randoms)
      deallocate(freer)
      deallocate(weights_b)
      deallocate(block_start)
      deallocate(ref_2_asym_start)
      deallocate(iobs)
      deallocate(obs_start)
      deallocate(comp_numb)
      deallocate(ref_2_asym)
      deallocate(ref_2_symm)
      deallocate(block_2_asym)

      return
      end
                                !
      subroutine wilson_scale_extend
      use weights
      use agreem
      use restr_files
      use CellAndSymmetry
      use GlebSasha
      use refi_flags
      implicit none
      include 'twin_refmac.fh'
c
c---Observations
      integer nasym
      integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: hkl_asym(:,:)
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      real, allocatable :: weights_b(:)
      integer, allocatable :: list_2_blocks(:)
      real, allocatable :: iobs(:,:)
                                !
      integer, allocatable :: freer_asym(:)
      real, allocatable :: io_asym(:,:)
c
c---  
      integer is
      integer jnum_o
      integer in_file,ierr
      integer i,io,iref,ib,io1,jo1,ko1,ko2,ii,jj
      integer kk
      logical freerchk
c
      integer nmin_ref_in_bins,nref_all
      real binsize_ml_delta
      real rsq,stl_c,stlmax_io,stlmin_io
      real lstlsq
      character line*512
      real lstlsq_r
      external lstlsq_r
c---Read the list of reflections in the asymmetric unit

      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
   
c--If phase info is available then use it also. We could make it as if
c--it is always present. Perhaps it is better way of dealing with this problem
c--
      do  i=1,nasym
        read(in_file)hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)
      enddo
      close(in_file)
c
c---  read the observed reflections with their organisations
      call open_unform_file(in_file,refl_file,ierr)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c

      allocate(io_asym(2,nasym))
      allocate(freer_asym(nasym))
      freer_asym(1:nasym) = -1
      io_asym(1:2,1:nasym) = 0.0
c
c---  We need to define memories
      allocate(freer(num_blocks))
      allocate(weights_b(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(obs_start(nobs+1))
      allocate(iobs(2,nobs))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(list_2_blocks(num_blocks))
      do  ib=1,num_blocks
         list_2_blocks(ib) = ib
      enddo
c
      block_start(1) = 0
      obs_start(1) = 0
      io1 = 1
      ref_2_asym_start(1) = 0
      ii = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib),weights_b(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
         is = block_2_asym(ko1+1)
         io_asym(1,is) = iobs(1,ii)
         io_asym(2,is) = iobs(2,ii)
         freer_asym(is) = freer(ib) 
      enddo
      close(in_file)
                                !
                                !   Deallocate all unnecessary things

                                !
                                !   Add freeR flag to reflections without that

      call scale_GlebSasha_I(hkl_asym,io_asym)

      end
