module AsymList
  implicit none

contains
  subroutine asym_list(maxsym,nsym,rot,tr,cell,nrefl,res_max,hkl_list)
    implicit none
    !
    integer maxsym,nsym,nsym_l
    real rot(3,3,maxsym),tr(3,maxsym)
    real cell(6)
    integer nrefl
    real res_max
    integer hkl_list(3,nrefl)
    !
    !--local parameters
    integer hmax,kmax,lmax
    integer h,k,l,is
    integer hhh(3),hkl_l(3)
    integer isysabs,icent
    real ast,bst,cst,cosast,cosbst,coscst
    real rs,rsq,epsl,epsi
    real degtor,cell_l(6)
    real lstlsq
    external lstlsq
    integer i,nrefl_l
    integer itemp
    integer hsym,ksym,lsym,hcur,kcur,lcur
    integer ir
    real resmx,resmn
    !--Make sure cell angles are in radians
    !
    degtor = 4.0*atan2(1.0,1.0)/180.0
    cell_l = cell
    if(maxval(cell(4:6)).gt.4.0) then 
       cell_l(4:6) = cell(4:6)*degtor
    endif
    !
    call define_res_pars(cell_l,ast,bst,cst,cosast,cosbst,coscst)
    call find_max_hkl(res_max,cell_l,hmax,kmax,lmax)
    !
    nrefl_l = 0
    !
    !---loop over sphere and take only unique reflections
    resmx = -1.0e32
    resmn = 1.0e32
    do   l=-lmax,lmax
       do  k=-kmax,kmax
          do   h=-hmax,hmax
             !
             !--If this reflection is inside resolution limit and 
             !--it is present by symmetry then account it
             !
             if(h.eq.0.and.k.eq.0.and.l.eq.0) goto 200
             hhh(1) = h
             hhh(2) = k
             hhh(3) = l
             call define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
             rs = sqrt(rsq)/2.0
             if(rs.gt.res_max) goto 200
             
             call sysabs_symm_r(maxsym,nsym,rot,tr,h,k,l,isysabs)
             if(isysabs.eq.1) goto 200
             do is = 1,nsym
                hkl_l(3)=nint(rot(1,3,is)*h+ rot(2,3,is)*k+rot(3,3,is)*l) 
                !
                !---If at least one of the symmety related is greater than this 
                !   reflection 
                !---then go out of the symmetry loop and do not take this reflection 
                !---into account
                if(hkl_l(3).gt.l) then
                   goto 200
                else if(hkl_l(3).eq.l) then
                   hkl_l(2)=nint(rot(1,2,is)*h+rot(2,2,is)*k+rot(3,2,is)*l)
                   if(hkl_l(2).gt.k) then
                      goto 200
                   else if(hkl_l(2).eq.k) then
                      hkl_l(1)=nint(rot(1,1,is)*h+rot(2,1,is)*k+rot(3,1,is)*l)
                      if(hkl_l(1).gt.h) then
                         goto 200
                      endif
                   endif
                endif
                !
                !---consider -h,-k,-l
                hkl_l(3)=-nint(rot(1,3,is)*h+rot(2,3,is)*k+rot(3,3,is)*l) 
                !
                !---If at least one of the symmety related is less than this reflection 
                !---then go out oof the symmetry loop and do not take this reflection 
                !---into account
                !
                if(hkl_l(3).gt.l) then
                   goto 200
                else if(hkl_l(3).eq.l) then
                   hkl_l(2)=-nint(rot(1,2,is)*h+rot(2,2,is)*k+rot(3,2,is)*l)
                   if(hkl_l(2).gt.k) then
                      goto 200
                   else if(hkl_l(2).eq.k) then
                      hkl_l(1)=-nint(rot(1,1,is)*h+rot(2,1,is)*k+rot(3,1,is)*l)
                      if(hkl_l(1).gt.h) then
                         goto 200
                      endif
                   endif
                endif
             enddo
             !
             !--this reflection is maximum among all symmetry related. Take it.
             ! 
             nrefl_l = nrefl_l + 1
             hkl_list(1,nrefl_l) = h
             hkl_list(2,nrefl_l) = k
             hkl_list(3,nrefl_l) = l
             
             !--Do we need to add centricity and epslon into this array?
             !
             call define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
             resmx = max(resmx,sqrt(rsq)/2.0)
             resmn = min(resmn,sqrt(rsq)/2.0)
             
200          continue
          enddo
       enddo
    enddo
    !
    !     Do we need sorting. By nature of
    !     generation of the list it has the required sorting order (h fastest, 
    !     k second and l slowest)
    do  i=1,nrefl_l
       itemp = hkl_list(3,i)
       hkl_list(3,i) = hkl_list(1,i)
       hkl_list(1,i) = itemp
    enddo
    call  iheap_sort_0(nrefl_l,3,hkl_list)
    !      do i=1,nrefl_l-1
    !         if(sum(abs(hkl_list(1:3,i)-hkl_list(1:3,i+1))).eq.0) then
    !            write(*,*)'redundant reflection'
    !         endif
    !      enddo
    
    do  i=1,nrefl_l
       itemp = hkl_list(3,i)
       hkl_list(3,i) = hkl_list(1,i)
       hkl_list(1,i) = itemp
    enddo
    return
  end subroutine asym_list
  !
  subroutine asym_list_size(maxsym,nsym,rot,tr,cell,nrefl,res_max)
    implicit none
    !
    real res_max
    integer nrefl
    integer maxsym,nsym
    real rot(3,3,maxsym),tr(3,maxsym)
    real cell(6)
    !
    !--   local parameters
    integer hmax,kmax,lmax
    integer h,k,l,is
    integer i,j
    integer hhh(3),hkl_l(3)
    integer isysabs,icent
    real ast,bst,cst,cosast,cosbst,coscst
    real rs,rsq,epsl,epsi
    real degtor
    real cell_l(6)
    real lstlsq
    external lstlsq
    !
    !--Make sure cell angles are in radians
    !
    degtor = 4.0*atan2(1.0,1.0)/180.0
    cell_l = cell
    if(maxval(cell(4:6)).gt.4.0) then 
       cell_l(4:6) = cell(4:6)*degtor
    endif
    !
    call define_res_pars(cell_l,ast,bst,cst,cosast,cosbst,coscst)
    call find_max_hkl(res_max,cell_l,hmax,kmax,lmax)
    !
    nrefl = 0
    !
    !---loop over hemisphere and take only unique reflections
    !
    do   l=-lmax,lmax
       do  k=-kmax,kmax
          do   h=-hmax,hmax
             !
             !--If this reflection is inside resolution limit and 
             !--it is present by symmetry then account itt
             !
             if(h.eq.0.and.k.eq.0.and.l.eq.0) goto 200
             hhh(1) = h
             hhh(2) = k
             hhh(3) = l
             call define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
             rs = sqrt(rsq)/2.0
             if(rs.gt.res_max) goto 200
             call sysabs_symm_r(maxsym,nsym,rot,tr,h,k,l,isysabs)
             if(isysabs.eq.1) goto 200
             do is = 1,nsym
                hkl_l(3)=nint(rot(1,3,is)*h+rot(2,3,is)*k+rot(3,3,is)*l) 
                !
                !---If at least one of the symmety related is less than this reflection 
                !---then go out oof the symmetry loop and do not take this reflection 
                !---into account
                !
                if(hkl_l(3).gt.l) then
                   goto 200
                else if(hkl_l(3).eq.l) then
                   hkl_l(2)=nint(rot(1,2,is)*h+rot(2,2,is)*k+rot(3,2,is)*l)
                   if(hkl_l(2).gt.k) then
                      goto 200
                   else if(hkl_l(2).eq.k) then
                      hkl_l(1)=nint(rot(1,1,is)*h+rot(2,1,is)*k+rot(3,1,is)*l)
                      if(hkl_l(1).gt.h) then
                         goto 200
                      endif
                   endif
                endif
                !
                !---consider -h,-k,-l
                hkl_l(3)= -nint(rot(1,3,is)*h+rot(2,3,is)*k+rot(3,3,is)*l) 
                !
                !---If at least one of the symmety related is less than this reflection 
                !---then go out oof the symmetry loop and do not take this reflection 
                !---into account
!
                if(hkl_l(3).gt.l) then
                   goto 200
                else if(hkl_l(3).eq.l) then
                   hkl_l(2)=-nint(rot(1,2,is)*h+rot(2,2,is)*k+rot(3,2,is)*l)
                   if(hkl_l(2).gt.k) then
                      goto 200
                   else if(hkl_l(2).eq.k) then
                      hkl_l(1)=-nint(rot(1,1,is)*h+rot(2,1,is)*k+rot(3,1,is)*l)
                      if(hkl_l(1).gt.h) then
                         goto 200
                      endif
                   endif
                endif
             enddo
             !
             !--this reflection is minimum among all symmetry related. Take it.
             ! 
             nrefl = nrefl + 1
200          continue
          enddo
       enddo
    enddo
    
    return
  end subroutine asym_list_size
  !
  subroutine abcd_2_asym(nasym,hkl_asym,abcd_file)
    !
    implicit none
    integer nasym
    integer hkl_asym(3,nasym)
    !
    character abcd_file*(*)
!
    real, allocatable :: abcd(:,:)
    integer, allocatable :: hkl_l(:,:)
    
    integer nph_refl
    integer i,j,k
    integer ifail,ll,in_file
    
    ifail = -1
    in_file = 0
    ll = 0
    call ccpdpn(in_file,abcd_file,'UNKOWN','U',ll,ifail)
    !
    read(in_file)nph_refl
    if(.not.allocated(abcd)) allocate(abcd(4,nph_refl))
    if(.not.allocated(hkl_l)) allocate(hkl_l(3,nph_refl))
    
    do   i=1,nph_refl
       read(in_file)(hkl_l(j,i),j=1,3),(abcd(k,i),k=1,4)
    enddo
    !
    !   Now find reference to the asymmetric unit
    !
    do  i=1,nph_refl
       
    enddo
    deallocate(abcd)
    deallocate(hkl_l)
    return
  end subroutine abcd_2_asym
  !

  subroutine find_max_hkl(res_max,cell,hmax,kmax,lmax)
    implicit none
    !
    !--Input parameters
    !    res_max = maximum resolution as 2sin(theta)/lambda
    !    hmax
    !    kmax
    !    lmax      maximum miller indices
    !    ast
    !    bst
    !    cst
    !    cosast
    !    cosbst
    !    coscst   reciprocal space cell parameters and their cosines
    !
    real res_max
    real cell(6)
    real sina,cosa,sinb,cosb,sinc,cosc
    real vol,volunit
    real ast,bst,cst,cosast,cosbst,coscst,sinast,sinbst,sincst
    real coshst,coskst,coslst
    integer hmax,kmax,lmax
    !
    cosa = cos(cell(4))
    cosb = cos(cell(5))
    cosc = cos(cell(6))
    sina = sin(cell(4))
    sinb = sin(cell(5))
    sinc = sin(cell(6))
    volunit = sqrt(1.0-cosa**2-cosb**2-cosc**2+2.0*cosa*cosb*cosc)
    vol = cell(1)*cell(2)*cell(3)*volunit
    ast = cell(2)*cell(3)*sina/vol
    bst = cell(1)*cell(3)*sinb/vol
    cst = cell(1)*cell(2)*sinc/vol
    cosast = (cosb*cosc-cosa)/(sinb*sinc)
    cosbst = (cosa*cosc-cosb)/(sina*sinc)
    coscst = (cosa*cosb-cosc)/(sina*sinb)
    sinast = vol/(cell(1)*cell(2)*cell(3)*sinb*sinc)
    sinbst = vol/(cell(1)*cell(2)*cell(3)*sina*sinc)
    sincst = vol/(cell(1)*cell(2)*cell(3)*sina*sinb)
    coslst = sqrt(1-cosast**2-cosbst**2-coscst**2+2.0*cosast*cosbst*coscst)/sincst
    coskst = sqrt(1-cosast**2-cosbst**2-coscst**2+2.0*cosast*cosbst*coscst)/sinbst
    coshst =  sqrt(1-cosast**2-cosbst**2-coscst**2+2.0*cosast*cosbst*coscst)/sinast
    !
    hmax = nint(2.0*res_max/(ast*coshst)) + 1
    kmax = nint(2.0*res_max/(bst*coskst)) + 1
    lmax = nint(2.0*res_max/(cst*coslst)) + 1
!
    return
  end subroutine find_max_hkl
!
  subroutine hkl_2_asym(hkl_in,hkl_out)
    use CellAndSymmetry
    implicit none

    integer hkl_in(3)
    integer hkl_out(3)
    !
    integer is
    integer hsym,ksym,lsym,hcur,kcur,lcur
    !
    hcur = hkl_in(1)
    kcur = hkl_in(2)
    lcur = hkl_in(3)
    
    do is=1,nsym
       lsym = nint(rot(1,3,is)*hkl_in(1)+rot(2,3,is)*hkl_in(2)+rot(3,3,is)*hkl_in(3))
       ksym = nint(rot(1,2,is)*hkl_in(1)+rot(2,2,is)*hkl_in(2)+rot(3,2,is)*hkl_in(3))
       hsym = nint(rot(1,1,is)*hkl_in(1)+ rot(2,1,is)*hkl_in(2)+rot(3,1,is)*hkl_in(3))
       if(lsym.gt.lcur) then
          hcur = hsym
          kcur = ksym
          lcur = lsym
       else if(lsym.eq.lcur) then
          if(ksym.gt.kcur) then
             hcur = hsym
             kcur = ksym
             lcur = lsym
          else if(ksym.eq.kcur) then
             if(hsym.gt.hcur) then
                hcur = hsym
                kcur = ksym
                lcur = lsym
             endif
          endif
       endif
       hsym = -hsym
       ksym = -ksym
       lsym = -lsym
       if(lsym.gt.lcur) then
          hcur = hsym
          kcur = ksym
          lcur = lsym
       else if(lsym.eq.lcur) then
          if(ksym.gt.kcur) then
             hcur = hsym
             kcur = ksym
             lcur = lsym
          else if(ksym.eq.kcur) then
             if(hsym.gt.hcur) then
                hcur = hsym
                kcur = ksym
                lcur = lsym
             endif
          endif
       endif
    enddo
    hkl_out(1) = hcur
    hkl_out(2) = kcur
    hkl_out(3) = lcur
    return
  end subroutine hkl_2_asym
  !
  subroutine twin_max_reso(maxsym,nsym,rot,tr,ntwin_domain,twin_oper,cell,res_max_out,nobs,hkl_list)
    implicit none
    integer maxsym,nsym
    real rot(3,3,maxsym),tr(3,maxsym)
    real cell(6)
    integer ntwin_domain
    integer twin_oper(3,3,*)
    integer nobs
    integer hkl_list(3,nobs)
    real res_max_out
    !
    !---  locals
    integer ir,itw
    integer h,k,l
    integer hkl_out(3)
    real degtor
    real ast,bst,cst,cosast,cosbst,coscst
    real res_loc,rsq
    !
    !---  body
    !
    !--Make sure cell angles are in radians
    !
    degtor = 4.0*atan2(1.0,1.0)/180.0
    if(cell(4).gt.4.0.and.cell(5).gt.4.0.and.cell(6).gt.4.0) then
       cell(4) = cell(4)*degtor
       cell(5) = cell(5)*degtor
       cell(6) = cell(6)*degtor
    endif
    call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
    
    res_max_out = 0.0

    do ir=1,nobs
       do itw=1,ntwin_domain
          hkl_out(1:3)= matmul(transpose(twin_oper(1:3,1:3,itw)),hkl_list(1:3,ir))/12
          h = hkl_out(1)
          k = hkl_out(2)
          l = hkl_out(3)
          call define_res(h,k,l,ast,bst,cst,cosast,cosbst,coscst,rsq)
          res_loc = sqrt(rsq)/2.0
          res_max_out = max(res_max_out,res_loc)
       enddo
    enddo
    return
  end subroutine twin_max_reso
  !
  subroutine find_refer2asym(maxsym,nsym,rot,tr,ncomp,hkl_comp,refer_2_asym,refer_2_symm,nasym,hkl_asym,ierr)
    !
    !--This subroutine find reference to asymmetric unit (defined by hkl_asym) from
    !--hkl_in. It also remember what was symmetry that was used to bring the reflection
    !--from the list hkl_in to asymmetric unit. This subroutine assumes that 
    !--reflceions in asymmetric unit have been sorted using iheap_sort.
    !
    implicit none
    !
    !---  Inputs
    integer maxsym,nsym
    real rot(3,3,maxsym)
    real tr(3,maxsym)
    integer nasym,ncomp
    !
    !--outputs
    integer ierr
    integer hkl_comp(3,ncomp)
    integer hkl_asym(3,nasym)
    integer refer_2_asym(ncomp),refer_2_symm(ncomp)
    !
    !----locals
    integer, allocatable :: index(:)
    !
    integer irot(3,3,192)
    integer ir,is,ia,i
    integer isysabs
    integer hcur,kcur,lcur
    integer hsym,ksym,lsym
    integer iscur
    integer itemp
    !---Bring to asymmetric unit. Take into account friedel pairs also

    !
    irot(1:3,1:3,1:nsym) = nint(rot(1:3,1:3,1:nsym))
    !
    !   Bring to our asym unit
    call to_asym_unit(hkl_comp)

    !
    allocate(index(ncomp))
    
    do ir=1,ncomp
       index(ir) = ir
    enddo
    do  ir=1,ncomp
       itemp          = hkl_comp(3,ir)
       hkl_comp(3,ir) = hkl_comp(1,ir)
       hkl_comp(1,ir) = itemp
    enddo
    call iheap_sort_r(ncomp,3,hkl_comp,index)
    do  ir=1,ncomp
       itemp          = hkl_comp(3,ir)
       hkl_comp(3,ir) = hkl_comp(1,ir)
       hkl_comp(1,ir) = itemp
    enddo
    !
    !---  Find references to the asymmetric unit
    do   ir=1,ncomp
       refer_2_asym(ir) = 0
    enddo
    !      stop
    
    ir = 1
    ia = 1
    !
    do while(ir.le.ncomp.and.ia.le.nasym)
       !
       if(hkl_comp(3,ir).lt.hkl_asym(3,ia)) then
          ir = ir + 1
       else if(hkl_comp(3,ir).gt.hkl_asym(3,ia)) then
          ia = ia + 1
       else
          if(hkl_comp(2,ir).lt.hkl_asym(2,ia)) then
             ir = ir + 1
          else if(hkl_comp(2,ir).gt.hkl_asym(2,ia)) then
             ia = ia + 1
          else
             if(hkl_comp(1,ir).lt.hkl_asym(1,ia)) then
                ir = ir + 1
             else if(hkl_comp(1,ir).gt.hkl_asym(1,ia)) then
                ia = ia + 1
             else
                if(refer_2_asym(index(ir)).gt.0) then
                   
                   write(*,*) 'The same reflection have more than one reference to the asymmetric unit'
                   write(*,*)(hkl_comp(i,index(ir)),i=1,3)
                   stop
                else
                   refer_2_asym(index(ir)) = ia
                   ir = ir + 1
                endif
             endif
          endif
       endif
    enddo
    !
    !--   Remove reflections that do not have reference to asymmetric unit  
    do   ir=1,ncomp
       if(refer_2_asym(index(ir)).le.0) then
          write(*,*)nasym,ir,(hkl_comp(i,ir),i=1,3),refer_2_asym(index(ir))
          call sysabs_symm_r(maxsym,nsym,rot,tr,hkl_comp(1,ir),hkl_comp(2,ir),hkl_comp(3,ir),isysabs)
          write(*,*)'Not all observation have reference to asymmetric unit'
          stop
       endif
    enddo
    deallocate(index)
    return
  end subroutine find_refer2asym
  !
  subroutine find_max_reso(nr,hkl,cell,res_min,res_max)
    implicit none
    !
    !  Find maximum resolution for given hkl
    integer nr
    integer hkl(3,nr)
    real cell(6)
    real res_min,res_max
    !
    !---  locals
    integer i
    real ast,bst,cst,cosast,cosbst,coscst
    real cell_l(6)
    real degtor,rsq
    !
    !---  body
    degtor = 4.0*atan(1.0)/180.0
    cell_l(1:6) = cell(1:6)
    if(maxval(cell_l(4:6)).gt.4.0) then
       cell_l(4:6) = cell_l(4:6)*degtor
    endif
    call define_res_pars(cell_l,ast,bst,cst,cosast,cosbst,coscst)
    
    res_max = -1.e32
    res_min = 1.e32
    do i=1,nr
       call define_res(hkl(1,i),hkl(2,i),hkl(3,i),ast,bst,cst,cosast,cosbst,coscst,rsq)
       rsq = sqrt(rsq)/2.0
       res_max = max(rsq,res_max)
       res_min = min(rsq,res_min)
    enddo
    
    return
  end subroutine find_max_reso

  subroutine to_asym_unit(hkl_list)
    implicit none
    
    !
    !   Bring hkl to the "asymmetric" unit. The same asymmetric is used by asym_list
    !   This subroutine does not consider systematic absences or any fancy things happening
    !   due to the space group symmetries (eps, centricity etc)
    integer, intent(inout) :: hkl_list(:,:)
    
    integer nsym,nasym
    integer hcur,kcur,lcur,hsym,ksym,lsym,iscur
    integer ir,is
    integer hkl_out(3)
    !
    !  body
    nasym = size(hkl_list(1,:))
    
    do  ir=1,nasym
       call hkl_2_asym(hkl_list(1:3,ir),hkl_out)
       hkl_list(1:3,ir) = hkl_out(1:3)
    enddo
    
  end subroutine to_asym_unit

end module AsymList
