module coords
  use atomcom
  !include 'atom_com.fh'

contains
  subroutine apply_transform_coord(matin)
    implicit none
    real, intent(in) ::  matin(4,4)
    !
    !  Transform input coordinates using the matrix matin
    integer n_atom
    integer i
    real xyz1(3),xyz2(3)
    real u33(3,3),u331(3,3)
    real ran(3,3)
    !
    !
    n_atom = size(xyz_crd(1,:))
    do i=1,4
       write(*,*)matin(1:4,i)
    enddo
    ran = matmul(matmul(cs_frac_to_ort,matin(1:3,1:3)),cs_ort_to_frac)
    
    if(n_atom.le.0) return
    write(*,*)n_atom
    do i=1,n_atom
       xyz1 = matmul(cs_ort_to_frac,xyz_crd(1:3,i))
       xyz2 = matmul(matin(1:3,1:3),xyz1) + matin(1:3,4)
       xyz_crd(1:3,i) = matmul(cs_frac_to_ort,xyz2)

       xyz1 = matmul(cs_ort_to_frac,xyz_crd_mod(1:3,i,1))
       xyz2 = matmul(matin(1:3,1:3),xyz1) + matin(1:3,4)
       xyz_crd_mod(1:3,i,1) = matmul(cs_frac_to_ort,xyz2)

       if(u_aniso(2,i).gt.0.0) then
          call aniso_vect2mat(u_aniso(1:6,i),u33)
          u331 = matmul(matmul(ran,u33),transpose(ran))
          call aniso_mat2vec(u331,u_aniso(1:6,i))

          call aniso_vect2mat(u_aniso_mod(1:6,i,1),u33)
          u331 = matmul(matmul(ran,u33),transpose(ran))
          call aniso_mat2vec(u331,u_aniso_mod(1:6,i,1))

       endif
    enddo
    !
    !  How about TLS?
    
  end subroutine apply_transform_coord
end module coords
