module NumIntegrate
  use gibbs_gm
  implicit none

  integer, private :: n_ints,n_int_tabs
  real, private :: tabmin=-20.0,tabmax=5.0,delta_l=0.1
  logical, private :: tab_flag = .FALSE.
  real, private :: int_powers(5)
  real, private, allocatable :: t0_lims(:)
  real, private, allocatable :: t1e(:,:)
  integer, private :: i_inter



contains
  subroutine t02inf_tabulate_mc
    !
    !    Tabulate int_(-t0)^(infinity) (t+t0)^k exp(-t^2/2) dt
    !    for various values of t0 (-10,5)
    !
    !   locals
    integer i,j
    real, allocatable :: rvec1(:)
    !
    !   body
    n_ints = 5
    int_powers(1) = -0.5
    int_powers(2) = 0.5
    int_powers(3) = 1.0
    int_powers(4) = 1.5
    int_powers(5) = 2.0

    
    n_int_tabs = int((tabmax-tabmin)/delta_l) + 1
    allocate(t0_lims(n_int_tabs))
    allocate(t1e(5,n_int_tabs))

    t0_lims(1) = tabmin
    do i=2,n_int_tabs
       t0_lims(i) = t0_lims(i-1) + delta_l
    enddo
    !open(42)
    allocate(rvec1(10000))
    do i=1,n_int_tabs
       call random_truncated_gauss(-t0_lims(i),rvec1)
       do j=2,n_ints
           t1e(j,i) = sum(((rvec1(1:10000)+t0_lims(i))**int_powers(j)))/10000.0
       enddo
       if(t0_lims(i).le.0.0) then
          t1e(1,i) = 2.0*(t1e(4,i) - t0_lims(i)*t1e(2,i))
       else
          t1e(1,i) = sum(((rvec1(1:10000)+t0_lims(i))**int_powers(1)))/10000.0
       endif
    enddo
!    do i=1,n_int_tabs
!       t1e(1,i) = 2.0*(t1e(4,i) - t0_lims(i)*t1e(2,i))
!    enddo

    tab_flag = .TRUE.
    !write(*,*)int_powers
    !do i=1,n_int_tabs
    !   write(42,*)t0_lims(i),t1e(1:n_ints,i)
    !enddo
    !stop

    return
  end subroutine t02inf_tabulate_mc
  
  subroutine laplace_t02inf(t0,n,exp_part,rem_part)
    !
    !   integrate int_{-t0}^{infinity} (t+t_0)^n exp(-t^2/2) dt
    !   Result is in two parts. Exponential part and remaining part
    !   Final result have the form exp(-exp_part)*rem_part
    real, intent(in) :: t0,n
    real, intent(out) :: exp_part,rem_part
    !
    !   Locals
    logical recurse_this
    integer k
    real*8 k1,k2,t1,t10,t02,r1,r2,f2prime,tt
    real*8 exp_part1,rem_part1,rem_part3
    real*8 :: pi=4.0*tan(1.0)

    recurse_this = .FALSE.

    if(t0.lt.0.0) then
       stop 'laplace_t02inf: t0 is negative'
    endif
    k = 0
    t02 = t0**2
    !do while(n+float(k).lt.0.0)
    !   k = k + 1
    !enddo
    k1 = n+float(k)
    !if(t0.le.0.0) then
    !   do while(k1.le.0.0)
    !      k = k + 1
    !      k1 = n+float(k)
    !   enddo
    !endif
    if(k.gt.0) recurse_this = .TRUE.

    t1 = (-t0+sqrt(t02+4.0*k1))/2.0

    t10 = t1+t0
    exp_part = t1**2/2.0-k1*log(t10)
    f2prime  = 1.0+k1/t10**2
    tt = sqrt(f2prime/2.0)*t10
    rem_part = sqrt(2.0*pi/f2prime)*erfc(-tt)
    !
    !  Use recursion
    !  This recursion is not stable. So k should be very small.

    !if(recurse_this) then
    !   k2 = k1 + 1.0
    !   t1 = (-t0+sqrt(t02+4.0*k2))/2.0
    !   t10 = t1+t0
    !   exp_part1 = t1**2/2.0-k2*log(t10)

    !   f2prime   = 1+k2/t10**2
    !   tt        = sqrt(f2prime/2.0)*t10
    !   rem_part1 = sqrt(pi/(2.0*f2prime))*erfc(-tt)
    !   r2 = rem_part1
    !   r1 = rem_part*exp(-exp_part + exp_part1)
    !   exp_part = exp_part1

    !   do while(k.gt.0)
    !      rem_part = ( r2 - t0*r1)/k1
    !      r2 = r1 
    !      r1 = rem_part
    !      k = k-1
    !      k1 = k1-1
    !   enddo
    !endif
    if(t0 <= -1000.0) then
       !write(*,*)recurse_this,exp_part,rem_part,k1,n,k,t10,t1,t0,(-t0+sqrt(t0**2+4.0*(k1+1.0)))/2.0
    endif
    return
  end subroutine laplace_t02inf

  subroutine laplace_t02inf1(t0,n,exp_part,rem_part)
    !
    !   integrate int_{-t0}^{infinity} (t+t_0)^n exp(-t^2/2) dt
    !   Result is in two parts. Exponential part and remaining part
    !   Final result have the form exp(-exp_part)*rem_part

    real, intent(in) :: t0,n
    real, intent(out) :: exp_part,rem_part
    !
    !   Locals
    logical recurse_this
    integer k
    real*8 k1,k2,t1,t10,t02,r1,r2,f2prime,tt
    real*8 exp_part1,rem_part1,rem_part3
    real*8 :: pi=4.0*tan(1.0)

    recurse_this = .FALSE.

    k = 0
    t02 = t0**2
    do while(n+float(k).lt.2.0)
       k = k + 1
    enddo
    k1 = n+float(k)
    if(t0.le.0.0) then
       do while(k1.le.0.0)
          k = k + 1
          k1 = n+float(k)
       enddo
    endif
    if(k.gt.0) recurse_this = .TRUE.

    t1 = (-t0+sqrt(t02+4.0*k1))/2.0

    t10 = t1+t0
    exp_part = t1**2/2.0-k1*log(t10)
    f2prime  = 1.0+k1/t10**2
    tt = sqrt(f2prime/2.0)*t10
    rem_part = sqrt(pi/(2.0*f2prime))*erfc(-tt)
    !
    !  Use recursion
    !  This recursion is not stable. So k should be very small.
    !write(*,*)n,k,recurse_this,exp_part,rem_part
    if(recurse_this) then
       k2 = k1 + 1.0
       t1 = (-t0+sqrt(t02+4.0*k2))/2.0
       t10 = t1+t0
       exp_part1 = t1**2/2.0-k2*log(t10)

       f2prime   = 1+k2/t10**2
       tt        = sqrt(f2prime/2.0)*t10
       rem_part1 = sqrt(pi/(2.0*f2prime))*erfc(-tt)
       r2 = rem_part1
       r1 = rem_part*exp(-exp_part + exp_part1)
       exp_part = exp_part1

       do while(k.gt.0)
          rem_part = ( r2 - t0*r1)/k1
          r2 = r1 
          r1 = rem_part
          k = k-1
          k1 = k1-1
       enddo
    endif
    if(t0.le.-1000.0) then
       !write(*,*)recurse_this,exp_part,rem_part,k1,n,k,t10,t1,t0,(-t0+sqrt(t0**2+4.0*(k1+1.0)))/2.0
    endif
    return
  end subroutine laplace_t02inf1

  subroutine t02inf_laplace_mc(t0,k,n_v,output_exp_part_v,output_v)
    !
    !   integrate int_{-t0}^{infinity} (t+t_0)^n exp(-t^2/2) dt
    !   Result is in two parts. Exponential part and remaining part
    !   Final result have the form exp(-exp_part)*rem_part
    integer k
    real, intent(in) :: t0,n_v(:)
    !real, intent(out) :: exp_part,rem_part
    real, intent(out) :: output_v(:),output_exp_part_v(:)
    !
    !   Locals
    real t01,an0
    real exp_part,rem_part
    real :: pi=4.0*tan(1.0)
    real*8 erf1
    integer i,j
    integer int_method
    !
    !   Body
    output_v(1:k) = 1.0
    if(t0.gt.tabmax) then
       int_method = 1
       !
       !   Use Laplace integration
       do i=1,k
          an0 = n_v(i)
          call laplace_t02inf(t0,an0,exp_part,rem_part)
          output_exp_part_v(i) = exp_part
          output_v(i) = rem_part
       enddo
    else
       int_method = 2
       if(.not.tab_flag) call t02inf_tabulate_mc
       t01 = max(t0,tabmin)
       do i=1,k
          do j=1,n_ints
             if(n_v(i).eq.int_powers(j)) then
                call linter_value2(n_int_tabs,t0_lims,t1e(j,:),t01,i_inter,output_v(i))
                exit
             endif
          enddo
       enddo
       erf1 = erfc(-dble(t01)/sqrt(2.0d0))*sqrt(2.0*pi)
       output_exp_part_v(1:k) = -log(erf1)
    endif

    return
  end subroutine t02inf_laplace_mc

  subroutine laplace_t02inf_mc(t0,k,n_v,output_v)
    !
    !   integrate int_{-t0}^{infinity} (t+t_0)^n exp(-t^2/2) dt
    !   Result is in two parts. Exponential part and remaining part
    !   Final result have the form exp(-exp_part)*rem_part

    real, intent(in) :: t0,n_v(:)
    !real, intent(out) :: exp_part,rem_part
    real, intent(out) :: output_v(:)
    !
    !   Locals
    logical recurse_this
    integer k
    real*8 k1,k2,t1,t10,t02,r1,r2,f2prime,tt
    real*8 exp_part1,rem_part1,rem_part3
    real*8 :: pi=4.0*tan(1.0)
    real :: rvec(10000),rvec1(10000)
    integer i,iv

    !write(*,*)t0,n,'To random_truncated_gauss'
    call random_truncated_gauss(-t0,rvec1)
    do i=1,k
       output_v(i) = sum(((rvec1(1:10000)+t0)**n_v(i)))/10000.0
    enddo
    !write(*,*)'output =',output
    !stop
    return
  end subroutine laplace_t02inf_mc

  subroutine lablace_t02inf_ratio(t0,n1,n2,res_all)

    real, intent(in) :: t0,n1,n2
    real, intent(out) :: res_all


  end subroutine lablace_t02inf_ratio

end module NumIntegrate
