program MultImp_collect
  use mtz_things_for_int
  use CellAndSymmetry
  use parser_things
  implicit none

  integer ifile
  character(len=3) :: ch3
  logical lexists
  integer i_fwt,i_delfwt,i_phwt,i_phdelwt,i_phic_all,i_fc_all,i_phic_all_ls,i_fc_all_ls,i_fobs,i_sig,iobs_flag
  integer, allocatable :: hkl_all(:,:)
  real, allocatable :: twofofc(:,:),fofc(:,:),wfofc(:,:),w2fofc(:,:),fcall_mean(:,:),cosp_all(:),sinp_all(:)
  real, allocatable :: twofofc_ls(:,:),fofc_ls(:,:),fcall_mean_ls(:,:),fom_all_ls(:)
  integer, allocatable :: fo_observed_flag(:)
  character(len=512) :: labin_c=' ',labout_c=' '
  integer nfile
  character(len=512) :: file_root
  character(len=512) :: file_l
  real, parameter ::  pi=4.0*atan(1.0)
  real, parameter :: rtodeg=180.0/pi,degtor=pi/180

  integer nref

  !pi = 4.0*atan(1.0)
  !rtodeg = 180.0/pi
  !degtor = pi/180.0
  !
  !   body
  CALL CCP4_PROG_VERSION('MultImp_collect',0)
  CALL CCPFYP
  CALL MTZINI
  !
  !   Instructions
  call read_instrs
  !
  !  Check existence of files
  if(len_trim(file_root).le.0.0) call ccperr(1,'File name is empty')
  write(*,*)
  write(*,*)' The number of input files = ',nfile
  do ifile=1,nfile
     write(ch3,'(i3)')ifile
     file_l =trim(file_root)//trim(adjustl(ch3))//'.mtz'
     write(*,'(a,i3,a,a)')'File no ',ifile,': file name :',trim(file_l)
     inquire(file=file_l,exist=lexists)
     if(.not.lexists) then
        write(*,*)'File: ',trim(file_l),' does not exist'
        call ccperr(1,'Fatal error')
     endif
  enddo
  write(*,*)
  !
  !   Read Sizes of files. In fact it is assumed that all files have 
  !
  call read_size
  if(nref.le.0) then
     write(*,*)'There is no reflection in files. File 1: ',trim(file_root)//'1.mtz'
     call ccperr(1,'Fatal error')
  endif
  write(*,*)'Number of reflections in each file ',nref

  allocate(hkl_all(3,nref))
  allocate(twofofc(2,nref))
  allocate(fofc(2,nref))
  allocate(twofofc_ls(2,nref))
  allocate(fofc_ls(2,nref))
  allocate(fcall_mean(2,nref))
  allocate(fcall_mean_ls(2,nref))
  allocate(fom_all_ls(nref))
  allocate(fo_observed_flag(nref))

  call read_all_collect

  call write_mtz

  deallocate(hkl_all)
  deallocate(twofofc)
  deallocate(fofc)
  deallocate(twofofc_ls)
  deallocate(fofc_ls)
  deallocate(fcall_mean)
  deallocate(fcall_mean_ls)
  deallocate(fom_all_ls)
  deallocate(fo_observed_flag)

contains  
  subroutine read_instrs
    !
    !   Parse the number of files, labin (default (FWT, PHWT), (DELFWT,PHDELWT))
    !   the number of files, root name for files. All files are assumed to be:
    !   file_root//file_number//'.mtz'
    !   These things should be command line
    !
    integer itk
    !
    !   body
    key = ' '
    line_parse = ' '
    lend = .FALSE.
    file_root = ' '
    do while(key.ne.'END' .and. .not.lend)
       line_parse = ' '
       call parser(key,line_parse,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,lprint)
       write(*,*)trim(line_parse)
       call ccpupc(key)
       do itk=1,ntok
          call ccpupc(cvalue(itk))
       enddo
       if(key.eq.'LABI') then 
          labin_c = line_parse
       elseif(key.eq.'LABO') then
          labout_c = line_parse
       elseif(key.eq.'NFIL') then
          nfile = nint(fvalue(2))
       elseif(key.eq.'ROOT') then
          file_root = line_parse(ibeg(2):iend(2))
       endif
    enddo
    if(len_trim(file_root).le.0) then
       call ugtenv('HKLIN',file_root)
       if(trim(file_root).eq.'HKLIN') file_root = ' '
    endif
    return

  end subroutine read_instrs

  subroutine assign_input_labels
    !
    !    Open mtz file and assign labels. Input labels are FWT etc. Output labes are FWT_tot etc
    !
    !   locals
    integer iprint,ifail,itk
    integer i,icell,ir
    integer ncol
    character*20 ff
    character ip_name*20,sigip_name*20,free_name*20,cl_tmp*20,cl_save*20
    character(len=512) :: file_in
    !
    !   body
    !
    mtzin = 1
    i_fwt     = 4
    i_phwt    = 5
    i_delfwt  = 6
    i_phdelwt = 7
    i_phic_all = 8
    i_fc_all   = 9
    i_phic_all_ls = 10
    i_fc_all_ls   = 11
    i_fobs     = 12
    i_sig      = 13
    iobs_flag  = 14
    iprint =  0
    ifail  = -1

    nlprgi = 9
    lsprgi(1) = 'H'
    ctprgi(1) = 'H'
    lsprgi(2) = 'K'
    ctprgi(2) = 'H'
    lsprgi(3) = 'L'
    ctprgi(3) = 'H'
    lsprgi(4) = 'FWT'
    ctprgi(4) = 'F'
    lsprgi(5) = 'PHWT'
    ctprgi(5) = 'P'
    lsprgi(6) = 'DELFWT'
    ctprgi(6) = 'F'
    lsprgi(7) = 'PHDELWT'
    ctprgi(7) = 'P'
    lsprgi(8) = 'PHIC_ALL'
    ctprgi(8) = 'P'
    lsprgi(9) = 'FC_ALL'
    ctprgi(9) = 'F'
    lsprgi(10) = 'PHIC_ALL_LS'
    ctprgi(10) = 'P'
    lsprgi(11) = 'FC_ALL_LS'
    ctprgi(11) = 'F'
    lsprgo(12) = 'FP'
    ctprgi(12) = 'F'
    lsprgi(13) = 'SIGFP'
    ctprgi(13) = 'Q'
    lsprgi(14) = 'OBSD'
    ctprgi(14) = 'I'

    if(len_trim(labin_c).le.0) then
       labin_c = 'LABIN FWT=FWT PHWT=PHWT DELFWT=DELFWT PHDELWT=PHDELWT FC_ALL=FC_ALL_LS'
       labin_c=trim(labin_c)//' PHIC_ALL=PHIC_ALL_LS FP=FP SIGFP=SIGFP OBSD=OBSD'
    endif

    file_in = trim(file_root)//'1.mtz'
    call lropen(mtzin,file_in,iprint,ifail)

    call parser(key,labin_c,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,lprint)
    call lkyin(mtzin,lsprgi,nlprgi,ntok,labin_c,ibeg,iend)
    call lrassn(mtzin,lsprgi,nlprgi,lookup,ctprgi)

    if(lookup(i_fwt).le.0 .or. lookup(i_phwt).le.0 .or. lookup(i_delfwt).le.0.or.lookup(i_phdelwt).le.0) then
       call ccperr(1,'Fatal error: intensities, sigmas or freeR are absent from the input file')
    endif
    !
    !   Take datasets name 
    ndatasets = msets
    CALL LRIDX(MTZIN,PNAME,XNAME,DNAME,ISETS,DATCELL,DATWAVE,NDATASETS)
    IF (NDATASETS.GT.0) CALL LRCLID(MTZIN,CSETID,NCOL)
    setid = 0
    if(LookUp(i_fwt).ne.0) then
       setid = csetid(lookup(i_fwt))
    endif
    call lrclos(mtzin,0)


    return

  end subroutine assign_input_labels

  subroutine read_mtz_info
    
    integer i,j,is,isym_unit,nospgr,nsymp
    character namspg_cifs*20,nampg*20
    character text_now*128
    !
    integer temp_c
    real rrr(3,3,6)
    real res_max_mtz_1,res_min_mtz_1
    real, parameter :: pi = 4.0*atan(1.0)
    real, parameter :: rtodeg = 180.0/pi
    integer iprint,ifail

    character(len=512) :: file_in
    !
    !   body
    !
    !  Take all info from the mtz file

    file_in =trim(file_root)//'1.mtz'
    iprint = 0
    ifail = 01
    call lropen(mtzin,file_in,iprint,ifail)
    call lrsort(mtzin,isort)
    IF (NDATASETS.GT.0.and.setid.gt.0) THEN
       pname_out(1) = pname(1)
       dname_out(1) = dname(1)
       xname_out(1) = xname(1)
       datwave_out(1) = datwave(1)
       datcell_out(1:6,1) = datcell(1:6,1)
       csetout(4:nlprgo) = 1
       csetout(1:5) = csetid(lookup(1))

       i = 1
       do while(i.le.ndatasets.and.isets(i).ne.setid)
          i = i + 1
       enddo
       if (i.le.ndatasets) then
          pname_out(2) = pname(i)
          dname_out(2) = dname(i)
          xname_out(2) = xname(i)
          datwave_out(2) = datwave(i)
          datcell_out(1:6,2) = datcell(1:6,i)
          ndatasets_out = 2
          cell_mtz(1:6) = datcell(1:6,i)
       else
          call ccperr(1,'Problem accessing datasets in mtz')
       endif
    endif
    if (minval(cell_mtz(1:6)).le.0.0.or.setid.le.0.or.ndatasets.le.0) then
       call lrcell(mtzin,cell_mtz)
    endif
    cell(1:6) = cell_mtz(1:6)

    isym_unit = 0
    call msymlb3(isym_unit,nospgr,SpaceGroupName,namspg_cifs,nampg,nsymp,NumSymmetry,RealSymmMatrx)

    NumSpaceGroup = nospgr
    call lrsymi(mtzin,NumPrimSymm,Ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
    !CALL PGDEFN(PointGroupName,NumPrimSymm,NumSymmetry,RealSymmMatrx,LPRINT)
    !CALL PGNLAU(PointGroupName,NumLaueSymm,LaueGroupName)

    if(len_trim(SpaceGroupName).le.1)  nospgr = NumSpaceGroup
    if(trim(SpaceGroupName).eq.'R 3'.or. trim(SpaceGroupName).eq.'R3') then
       if(cell(6).le.5.0) then
          temp_c = nint(cell(6)*rtodeg)
       else
          temp_c = nint(cell(6))
       endif
       if(cell(1).eq.cell(2).and.temp_c.eq.120) then
          SpaceGroupName = 'H3'
       endif
    else if(trim(SpaceGroupName).eq.'H 3'.or.trim(SpaceGroupName).eq.'H3') then
       if(cell(1).eq.cell(2).and.cell(1).eq.cell(3).and.cell(4).eq.cell(6).and.cell(4).eq.cell(6)) then
          SpaceGroupName = 'R3'
       endif
    endif
    if(trim(SpaceGroupName).eq.'R 3 2'.or.trim(SpaceGroupName).eq.'R32') then
       if(cell(6).le.5.0) then
          temp_c = nint(cell(6)*rtodeg)
       else
          temp_c = nint(cell(6))
       endif
       if(cell(1).eq.cell(2).and.temp_c.eq.120) then
          SpaceGroupName = 'H32'
       endif
    else if(trim(SpaceGroupName).eq.'H 3 2'.or.trim(SpaceGroupName).eq.'H32') then
       if(cell(1).eq.cell(2).and.cell(1).eq.cell(3).and. cell(4).eq.cell(6).and.cell(4).eq.cell(6)) then
          SpaceGroupName = 'R32'
       endif
    endif

    call msymlb3(isym_unit,nospgr,SpaceGroupName,namspg_cifs,nampg,nsymp,NumSymmetry,RealSymmMatrx)
    
    NumSpaceGroup = nospgr
    call lrsymm(mtzin,NumSymmetry,RealSymmMatrx)
    write(*,*)
    write(*,*)'Space group                  = ',SpaceGroupName
    write(*,*)'Space group number           = ',nospgr
    write(*,*)'Number of symmetry operators = ',NumSymmetry
    write(*,*)'Space group elements '
    do is=1,NumSymmetry
       call put_symm_to_text(RealSymmMatrx(1:3,1:3,is),RealSymmMatrx(1:3,4,is),text_now)
       write(*,'(i5,2x,a)')is,trim(text_now)
    enddo
    write(*,*)
    call lrclos(mtzin,0)
    call epsln(NumSymmetry,NumPrimSymm,RealSymmMatrx)
    call centr(NumSymmetry,RealSymmMatrx,0)
    return

  end subroutine read_mtz_info


  subroutine read_size
    !
    !   Read the size: it is assumed that all files have the same size
    real ssq,adata(200)
    integer iref
    integer iprint,ifail
    logical eof
    character(len=512) :: file_l

    file_l = trim(file_root)//'1.mtz'
    iprint = 0
    ifail  = -1
    mtzin = 1
    call lropen(mtzin,file_l,iprint,ifail)
    call lrnref(mtzin,nref)
    write(*,*)mtzin,iprint,ifail,nref,trim(file_l)

    nref = 0
    call lrrefl(mtzin,ssq,adata,eof)
    do while(.not.eof)
       nref = nref + 1
       call lrrefl(mtzin,ssq,adata,eof)
    enddo
    call lrclos(mtzin,0)
    return

  end subroutine read_size

  subroutine read_all_collect
    !
    !   Read and average map coefficients. It is assumed that all files have a uniform shape,
    !   origin and hand of all phases are the same. So we only need to average.
    !   we need another routine to bring all of them to the same origin and hand
    real tmp,angle
    real ssq
    integer icentr,isysab
    real epsi
    integer hkl_l(3)
    integer iref,ifile,iprint,ifail
    logical eof
    character(len=512) :: file_l
    integer icent
    real aobs(2)
    real fwt,delfwt,phiwt,phidelwt,sinp,cosp,sinp_ls,cosp_ls,fcall,phicall_ls,fcall_ls,sigm,phicall
    real fom,fom1,sigma,xx
    real, allocatable :: fobs(:),sig_obs(:),fofc_var(:,:)
    real, allocatable :: cosp_all_ls(:),sinp_all_ls(:)
    
    !   body    
    write(*,*)'To assign_input_labels'
    call assign_input_labels
    call read_mtz_info

    write(*,*)'After read_mtz_info',i_fwt,i_phwt,i_delfwt,i_phdelwt
    allocate(fobs(nref))
    allocate(sig_obs(nref))
    allocate(cosp_all_ls(nref))
    allocate(sinp_all_ls(nref))
    allocate(fofc_var(2,nref))
    twofofc(1:2,1:nref) = 0.0
    fofc(1:2,1:nref) = 0.0
    twofofc_ls(1:2,1:nref) = 0.0
    fofc_ls(1:2,1:nref) = 0.0
    fcall_mean(1:2,1:nref) = 0.0
    mtzin = 1
    do ifile=1,nfile
       write(ch3,'(i3)')ifile
       file_l = trim(file_root)//trim(adjustl(ch3))//'.mtz'
       write(*,*)trim(file_l)

       iprint = 0
       ifail = -1
       call lropen(mtzin,file_l,iprint,ifail)
       iref = 0
       call lrrefl(mtzin,ssq,adata,eof)
       write(*,*)
       do while(.not.eof)
          iref = iref + 1
          if(iref.gt.nref) then
             write(*,*)
             write(*,*)'File no: ',ifile,' File name: ',trim(file_l)
             stop 'Error==> Too many reflections in one file'
          endif
          hkl_l = nint(adata(1:3))
          if(ifile.eq.1) then
             hkl_all(1:3,iref) = hkl_l
          elseif(maxval(abs(hkl_l-hkl_all(1:3,iref))).gt.0) then
             stop
          endif
          fwt      = adata(lookup(i_fwt))
          phiwt    = adata(lookup(i_phwt))
          delfwt   = adata(lookup(i_delfwt))
          phidelwt = adata(lookup(i_phdelwt))
          phicall  = adata(lookup(i_phic_all))
          fcall    = adata(lookup(i_fc_all))
          phicall_ls = adata(lookup(i_phic_all_ls))
          fcall_ls   = adata(lookup(i_fc_all_ls))
          fobs(iref)    = fobs(iref) + adata(lookup(i_fobs))
          sig_obs(iref) = sig_obs(iref) + adata(lookup(i_sig))

          cosp = cos(degtor*phicall)
          sinp = sin(degtor*phicall)
          cosp_ls = cos(degtor*phicall_ls)
          sinp_ls = sin(degtor*phicall_ls)

          fo_observed_flag(iref) = nint(adata(iobs_flag))
          cosp_all(iref) = cosp_all(iref) + cosp
          sinp_all(iref) = sinp_all(iref) + sinp
          cosp_all_ls(iref) = cosp_all_ls(iref) + cos(degtor*phicall_ls)
          sinp_all_ls(iref) = sinp_all_ls(iref) + sin(degtor*fcall_ls)
          !
          !   For 2fofc map we need to consider cases when we do not observations and we want to restore
          !   map coeffcients for them
          !if(fo_observed_flag(iref).eq.1) then
          !   twofofc_ls(1,iref) = w2fofc(1,iref) + (2.0*fobs-fcall)*cosp
          !   twofofc_ls(2,iref) = w2fofc(2,iref) + (2.0*fobs-fcall)*sinp
          !   fofc_ls(1,iref)  = wfofc(1,iref) + (fobs-fcall)*cosp
          !   fofc_ls(2,iref)  = wfofc(2,iref) + (fobs-fcall)*sinp            
          !else
          !   twofofc_ls(1,iref) = twofofc_ls(1,iref) + fcall*cosp
          !   twofofc_ls(2,iref) = twofofc_ls(2,iref) + fcall*sinp
          !endif
          !
          !   Mean 2mfodf and mfodfc maps
          twofofc(1,iref) = twofofc(1,iref) + fwt*cos(degtor*phiwt)
          twofofc(2,iref) = twofofc(2,iref) + fwt*sin(degtor*phiwt)
          fofc(1,iref) = fofc(1,iref) + delfwt*cos(degtor*phidelwt)
          fofc(2,iref) = fofc(2,iref) + delfwt*sin(degtor*phidelwt)
          !
          !   average fall with ML scaling
          fcall_mean(1,iref) = fcall_mean(1,iref) + fcall*cosp
          fcall_mean(2,iref) = fcall_mean(2,iref) + fcall*sinp
          !
          !   average fall with ls scaling
          fcall_mean_ls(1,iref) = fcall_mean_ls(1,iref) + fcall_ls*cosp_ls
          fcall_mean_ls(2,iref) = fcall_mean_ls(2,iref) + fcall_ls*sinp_ls
          !
          !    average cos and sin for ls scaled phases
          cosp_all_ls(iref) = cosp_all_ls(iref) + cosp_ls
          sinp_all_ls(iref) = sinp_all_ls(iref) + sinp_ls
          !
          !   meand and variance for ls scaled structure factors
          if(fo_observed_flag(iref).eq.1) then
             fofc_ls(1,iref) = fofc_ls(1,iref) + (fobs(iref)-fcall_ls)*cosp_ls
             fofc_ls(2,iref) = fofc_ls(2,iref) + (fobs(ireF)-fcall_ls)*sinp_ls
             fofc_var(1,iref) = fofc_var(1,iref) + ((fobs(iref)-fcall_ls)*cosp_ls)**2
             fofc_var(2,iref) = fofc_var(2,iref) + ((fobs(iref)-fcall_ls)*sinp_ls)**2
          endif
          call lrrefl(mtzin,ssq,adata,eof)
       enddo
       call lrclos(mtzin,0)
    enddo
    twofofc(1:2,1:nref) = twofofc(1:2,1:nref)/nfile
    fofc(1:2,1:nref)    = fofc(1:2,1:nref)/nfile
    w2fofc(1:2,1:nref) = w2fofc(1:2,1:nref)/nfile
    wfofc(1:2,1:nref) = wfofc(1:2,1:nref)/nfile
    fofc_ls(1:2,1:nref) = fofc_ls(1:2,1:nref)/nfile
    fofc_var(1:2,1:nref) = fofc_var(1:2,1:nref)/nfile
    fofc_var(1:2,1:nref) = fofc_var(1:2,1:nref) - fofc_ls(1:2,1:nref)**2
    cosp_all_ls(1:nref) = cosp_all_ls(1:nref)/nfile
    cosp_all_ls(1:nref) = sinp_all_ls(1:nref)/nfile
    fobs(1:nref)  = fobs(1:nref)/nfile
    sig_obs(1:nref) = sig_obs(1:nref)/nfile
    do iref=1,nref
       call epslon(hkl_all(1:3,iref),epsi,isysab)
       call centr(hkl_all(1:3,iref),icentr)
       !
       !   <2mfodfc>
       call ab_to_fandphase(twofofc(1,iref),twofofc(2,iref),tmp,angle)
       twofofc(1,iref) = tmp
       twofofc(2,iref) = angle
       call ab_to_fandphase(fofc(1,iref),fofc(2,iref),tmp,angle)
       !  
       !  <mfodfc>
       fofc(1,iref) = tmp
       fofc(2,iref) = angle
       !call ab_to_fandphase(w2fofc(1,iref),w2fofc(2,iref),tmp,angle)
       !w2fofc(1,iref) = tmp
       !w2fofc(2,iref) = angle
       !call ab_to_fandphase(wfofc(1,iref),wfofc(2,iref),tmp,angle) 
       !wfofc(1,iref) = tmp
       !wfofc(2,iref) = angle
       !
       !   mean fall
       call ab_to_fandphase(fcall_mean(1,iref),fcall_mean(2,iref),tmp,angle) 
       fcall_mean(1,iref) = tmp
       fcall_mean(2,iref) = angle

       !
       !    "figure of merit" based on calculated structur factors
       fom1 = sqrt(cosp_all_ls(iref)**2 + sinp_all_ls(iref)**2)
       !
       !   figure of merit based on variation of fobs and fcalc
       if(fo_observed_flag(iref).eq.1) then
          sigma = sig_obs(iref)**2  + epsi*(fofc_var(1,iref)+fofc_var(2,iref))
          xx = fobs(iref)*sqrt(fcall_mean_ls(1,iref)**2+fcall_mean_ls(2,iref)**2)/sigma
          if(icentr.eq.1) then
             fom = sim(xx)
          else
             fom = tanh(xx)
          endif
       else
          fom = 0.0
       endif
       if(fom1.gt.0.0) then
          aobs(1) = fobs(iref)*cosp_all_ls(iref)/fom1
          aobs(2) = fobs(iref)*sinp_all_ls(iref)/fom1
          twofofc_ls(1:2,iref) = fcall_mean_ls(1:2,iref) + 2.0*fom*(aobs(1:2)-fcall_mean_ls(1:2,iref)/fom1)
       else
          twofofc_ls(1:2,iref) = fcall_mean_ls(1:2,iref)
       endif
       call ab_to_fandphase(twofofc_ls(2,iref),twofofc_ls(1,iref),tmp,angle)
       twofofc_ls(1,iref) = tmp
       twofofc_ls(2,iref) = angle
       fofc_ls(1:2,iref) =fom*( aobs(1:2)-fcall_mean_ls(1:2,iref)/fom1)
       call ab_to_fandphase(fofc_ls(2,iref),fofc_ls(1,iref),tmp,angle)
       fofc_ls(1,iref) = tmp
       fofc_ls(2,iref) = angle
       fom_all_ls(iref) = fom
       !write(*,*)hkl_all(1:3,iref),twofofc(1:2,iref),fofc(1:2,iref)
    enddo
    deallocate(fobs)
    deallocate(sig_obs)
    deallocate(cosp_all_ls)
    deallocate(sinp_all_ls)
    deallocate(fofc_var)
    return
  end subroutine read_all_collect

  subroutine ab_to_fandphase(a,b,f,phase)

    real a,b,f,phase

    f = sqrt(a**2+b**2)
    phase = 0
    if(f.gt.0.0) phase = rtodeg*atan2(b,a)

    return
  end subroutine ab_to_fandphase

  subroutine write_mtz

    real bdata(200)
    integer iref

    call write_mtz_info

    write(*,*)'Aftet mtz info'
    do iref=1,nref
       call equal_magic(mtzout,bdata,nlprgo)
       bdata(1:3) = hkl_all(1:3,iref)
       bdata(4)  = twofofc(1,iref)
       bdata(5)  = twofofc(2,iref)
       bdata(6)  = fofc(1,iref)
       bdata(7)  = fofc(2,iref)

       bdata(8)  = twofofc_ls(1,iref)
       bdata(9)  = twofofc_ls(2,iref)
       bdata(10) = fofc_ls(1,iref)
       bdata(11) = fofc_ls(2,iref)

       bdata(12) = fcall_mean(1,iref)
       bdata(13) = fcall_mean(2,iref)
       bdata(14) = fcall_mean_ls(1,iref)
       bdata(15) = fcall_mean_ls(2,iref)
       bdata(16) = fom_all_ls(iref)
       call lwrefl(mtzout,bdata)
    enddo
    call lwclos(mtzout,0)

  end subroutine write_mtz

  subroutine write_mtz_info
    !
    !   locals
    integer i
    integer isetid
    integer :: iappnd = 0
    integer icol
    !
    !   body
    !
    !   Sort out output file. We will write 21 output files
    ctprgo(1:3) = 'H'
    lsprgo(1) = 'H'
    lsprgo(2) = 'K'
    lsprgo(3) = 'L'

    lsprgo(4) = 'FWT_tot'
    ctprgo(4) = 'F'
    lsprgo(5) = 'PHWT_tot'
    ctprgo(5) = 'P'
    lsprgo(6) = 'DELFWT_tot'
    ctprgo(6) = 'F'
    lsprgo(7) = 'PHDELWT_tot'
    ctprgo(7) = 'P'

    lsprgo(8) = 'W2FOFC'
    ctprgo(8) = 'F'
    lsprgo(9) = 'PHW2FOFC'
    ctprgo(9) = 'P'
    lsprgo(10) = 'WFOFC'
    ctprgo(10) = 'F'
    lsprgo(11) = 'PHWFOFC'
    ctprgo(11) = 'P'

    lsprgo(12) = 'FC_ALL'
    ctprgo(12) = 'F'
    lsprgo(13) = 'PHIC_ALL'
    ctprgo(13) = 'P'
    lsprgo(14) = 'FC_ALL_LS'
    ctprgo(14) = 'F'
    lsprgo(15) = 'PHIC_ALL_LS'
    ctprgo(15) = 'P'
    lsprgo(16) = 'FOM_ALL_LS'
    ctprgo(16) = 'W'

    write(*,*)trim(labout_c)
    if(len_trim(labout_c).le.0) then
       labout_c = 'LABOUT'
       labout_c = trim(labout_c)//' FWT_tot=FWT_tot PHWT_tot=PHWT_tot'
       labout_c = trim(labout_c)//' DELFWT_tot=DELFWT_tot PHDELWT_tot=PHDELWT_tot'
       labout_c = trim(labout_c)//' FC_ALL=FC_ALL PHIC_ALL=PHIC_ALL WFOFC=WFOFC PHWFOFC=PHWFOFC'
       labout_c = trim(labout_c)//' W2FOFC=W2FOFC PHW2FOFC=PHW2FOFC PHIC_ALL_LS=PHIC_ALL_LS FC_ALL_LS=FC_ALL_LS'
       labout_c = trim(labout_c)//' FOM_ALL_LS=FOM_ALL_LS'
    endif

    write(*,*)mtzout,' open'
    call lwopen(mtzout,'HKLOUT')
    ntok  = 200
    write(*,*)'To parser',trim(labout_c)
    call parser(key,labout_c,ibeg,iend,ityp,fvalue,cvalue,idec,ntok,lend,.FALSE.)
    nlprgo = 16
    write(*,*)'lkyout',nlprgo
    call lkyout(mtzout,lsprgo,nlprgo,ntok,labout_c,ibeg,iend)
    do i=1,nlprgo
       write(*,*)lsprgo(i)
    enddo
    write(*,*)'After lkyout '
    call lwassn(mtzout,lsprgo,nlprgo,ctprgo,0)
    write(*,*)'After lwassn'
    call lwclab(mtzout,lsprgo,nlprgo,ctprgo,0)

    write(*,*)mtzout,cell,isort

    CALL LWCELL(MTZOUT,CELL)
    CALL LWSORT(MTZOUT,ISORT)
    write(*,*)'lwsort '
    !
    !NumPrimSymm = NumSymmetry/NSMULT
    !            ******************************
    CALL LWSYMM(MTZOUT,NumSymmetry,NumPrimSymm,RealSymmMatrx,Ltype,NumSpaceGroup,SpaceGroupName,PointGroupName)
    ! Store the project name and dataset name in the mtz header:
    write(*,*)'After lwsymm'
    IF (NDATASETS_out.GT.0) THEN
       DO ISET = 1,NDATASETS_out
          CALL LWIDX(MTZOUT,PNAME_out(ISET),XNAME_out(ISET),DNAME_out(ISET),DATCELL_out(1,ISET),DATWAVE_out(ISET))
       ENDDO
       do  icol=1,nlprgo
          isetid = csetout(icol)+1
          xname_col(icol) = xname_out(isetid)
          dname_col(icol) = dname_out(isetid)
       enddo
       CALL LWIDASX(MTZOUT,NLPRGO,XNAME_col,DNAME_col,0)
    ENDIF
    write(*,*)'End of write_mtz_info'
  end subroutine write_mtz_info

  REAL FUNCTION SIM(X)
    !    ====================
    !
    !-----extracted from R.Reads sigmaa.
    !
    !---- Calculate sim and srinivasan non-centric figure of merit
    !     as i1(x)/i0(x), where i1 and i0 are the modified 1st and zero
    !     order bessel functions.
    !     references: sim, g. a. (1960) acta cryst. 13, 511-512;
    !       srinivasan, r. (1966) acta cryst. 20, 143-144;
    !       abramowitz & stegun, handbook of mathematical functions, 378.
    !     this routine was obtained from w. kabsch.
    !
    !
    !
    !
    !     .. Scalar Arguments ..
    REAL X
    !     ..
    !     .. Local Scalars ..
    REAL T
    !     ..
    !     .. Intrinsic Functions ..
    INTRINSIC ABS,SIGN
    !     ..
    !     .. Save statement ..
    SAVE
    !     ..
    !
    T = ABS(X)/3.75
    !
    IF (T.GT.1.0) THEN
       T = 1.0/T
       SIM = ((((((((0.01787654-T*0.00420059)*T+ (-0.02895312))*T+             &
            0.02282967)*T+ (-0.01031555))*T+0.00163801)*T+                     &
            (-0.00362018))*T+ (-0.03988024))*T+0.39894228)*                    &
            SIGN(1.0,X)/ ((((((((-0.01647633+T*0.00392377)*T+                  &
            0.02635537)*T+ (-0.02057706))*T+0.00916281)*T+                     &
            (-0.00157565))*T+0.00225319)*T+0.01328592)*T+0.39894228)
    ELSE
       T = T*T
       SIM = ((((((T*0.00032411+0.00301532)*T+0.02658733)*T+                    &
            0.15084934)*T+0.51498869)*T+0.87890594)*T+0.5)*X/                   &
            ((((((T*0.0045813+0.0360768)*T+0.2659732)*T+1.2067492)*T+           &
            3.0899424)*T+3.5156229)*T+1.0)
    ENDIF
  END FUNCTION SIM
  
end program MultImp_collect
  
