program header2opers
  implicit none
  
  character*256 file_in,file_out
  character argc*512,prog_name*512
  
  real rot(3,3,999),trans(3,999)
  
  integer i,n_ncs,ig,in
  real rr(3),tr(3)
  real alpha,beta,gamma
  real psi,phi,chi
  real radtodeg
  integer infile,out1,out2,out3
  character line*256
  integer ios
  logical eof

  call getarg(0,argc)
  prog_name = trim(argc)
  call getarg(1,argc)
  if(len_trim(argc).gt.0) then
     file_in = trim(argc)
  else
     
  endif
  call getarg(2,argc)
  file_out = argc
  !
  infile = 10
  out1 = 11
  out2 = 12
  out3 = 13
  open(infile,file=file_in)
  if(len_trim(file_out).le.0) file_out = 'keyw'
  open(out1,file=trim(file_out)//'_matr.dat')
  open(out2,file=trim(file_out)//'_euler.dat')
  open(out3,file=trim(file_out)//'_polar.dat')
  write(*,*)
  write(*,*)'-------------------------------------------------------------------------------------'
  write(*,*)'From input pdb file ',trim(file_in),' three output keywords files generated'
  write(*,*)trim(file_out)//'_matr.dat ',' - ncs constraints in matrix and vector form'
  write(*,*)trim(file_out)//'_euler.dat',' - ncs constraints in euler angles and translations'
  write(*,*)trim(file_out)//'_polar.dat',' - ncs constraints in polar angles and translations'
  write(*,*)'-------------------------------------------------------------------------------------'
  write(*,*)

  line = ' '
  do while(line(1:5).ne.'MTRIX')
     read(infile,'(a)',iostat=ios)line
     if(ios.ne.0) exit
  enddo
  n_ncs = 0

  do while(line(1:5).eq.'MTRIX')
     read(line,'(5x,i1,1x,i3,3f10.6,5x,f10.5,4x,i1)')i,in,rr(1:3),tr(1),ig
     rot(i,1:3,in) = rr(1:3)
     trans(i,in) = tr(1)
     n_ncs = max(n_ncs,in)
     read(infile,'(a)',iostat=ios)line
     if(ios.ne.0.or.line(1:3).eq.'END') exit
  enddo
  close(infile)
  
  radtodeg = 45.0/atan(1.0)
  if(n_ncs.gt.0) then
     do i=1,n_ncs
        if(maxval(abs(rot(1:3,1:3,i))).gt.0.0) then
           write(out1,*)'ncscons matrix -'
           write(out1,*)rot(1,1:3,i),' -'
           write(out1,*)rot(2,1:3,i),' -'
           write(out1,*)rot(3,1:3,i),' -'
           write(out1,*)trans(1:3,i)
           
           call matr2eul(rot(1:3,1:3,i),alpha,beta,gamma)
           write(out2,*)'ncsconst euler ',alpha*radtodeg,beta*radtodeg,gamma*radtodeg,trans(1:3,i)
           call polar(rot(1:3,1:3,i),psi,phi,chi)
           write(out3,*)'ncsconst polar ',psi,phi,chi,trans(1:3,i)
        endif
     enddo
  endif
  
  close(out1); close(out2); close(out3)
 
end program header2opers

 
  SUBROUTINE MATR2EUL(R,AL1,AL2,AL3)
    !     ========================
    !
    !-- This s/r works out Euler rotation angles from a given rotation matrix.
    !
    REAL AL1,AL2,AL3
    REAL R(3,3)
    !
    REAL EPS_LOC
    DATA EPS_LOC/1.0E-8/
    !
    IF(SQRT(ABS(R(3,1)**2+R(3,2)**2)).LT.EPS_LOC) THEN
       !
       !---AL2 = 0.0 or pi. Either AL1+AL3 or AL1 - AL3 can be defined
       IF(R(3,3).GT.0.5) THEN
          AL2 = 0.0
       ELSE
          AL2 = 4.0*ATAN2(1.0,1.0)
       ENDIF
       AL3 = 0.0
       AL1 = ATAN2(R(2,1),R(1,1))
    ELSE
       AL3 = ATAN2(R(3,2),-R(3,1))
       IF(ABS(R(3,1)).GT.EPS_LOC) THEN
          AL2 = ATAN2(-R(3,1)/COS(AL3),R(3,3))
       ELSE
          AL2 = ATAN2(R(3,2)/SIN(AL3),R(3,3))
       ENDIF
       AL1 = ATAN2(R(2,3),R(1,3))
    ENDIF
    
    RETURN
  END SUBROUTINE MATR2EUL

  SUBROUTINE POLAR(TRMAT,OMEGA,PHI,CHI)
    !    ========================
    !
    !-- This s/r works out various rotation angles corresponding
    !     to a given rotation matrix.
    !     It could easily be extended to give other sets.
    !
    !     .. Array Arguments ..
    REAL TRMAT(3,3)
    !     ..
    !     .. Local Scalars ..
    REAL CHI,CHK,COSCHI,OMEGA,PHI,R13,R23,R31,R32,SINCHI,SOMEGA
    real THETA1,THETA2,THETA3,TRACE
    !     ..
    !     .. Local Arrays ..
    REAL DC(5)
    !     ..
    CHI = 0.0
    OMEGA = 0.0
    PHI = 0.0
    
    rtodeg = 45.0/atan(1.0)
    TRACE = TRMAT(1,1) + TRMAT(2,2) + TRMAT(3,3)
    IF (TRACE.LT.3.0) THEN
       IF (TRMAT(3,3).LT.0.99999) THEN
          IF (TRMAT(3,3).GT.-0.999999) THEN
             THETA2 = ACOS(AMAX1(-1.0,AMIN1(1.0,TRMAT(3,3))))*RTODEG
             R13 = TRMAT(1,3)
             R23 = TRMAT(2,3)
             R31 = TRMAT(3,1)
             R32 = TRMAT(3,2)
             IF (R23.LT.0.0) THEN
                R13 = -R13
                R23 = -R23
                R31 = -R31
                R32 = -R32
                THETA2 = -THETA2
             END IF
             THETA3 = 0.0
             THETA1 = 0.0
             IF(R32**2+R31**2.NE.0.0) THETA3 = ATAN2(R32,-R31)*RTODEG
             IF(R23**2+R13**2.NE.0.0) THETA1 = ATAN2(R23,R13)*RTODEG
             !
             !---- Spherical polars ref patterson int tab vol2 p59
             DC(1) = 0.0
             DC(2) = 0.0
             DC(3) = 0.0
             COSCHI = TRACE/2.0 - 0.5
             SINCHI = SQRT(ABS(1.0-COSCHI*COSCHI))
             CHI = 0.0
             IF(SINCHI**2+COSCHI**2.NE.0.0) CHI = ATAN2(SINCHI,COSCHI)*RTODEG
             CHK = ABS(CHI)
             IF (CHK.GT.179.5) THEN
                GO TO 10
             ELSE
                DC(1) = (TRMAT(3,2)-TRMAT(2,3))/ (2.0*SINCHI)
                DC(2) = (TRMAT(1,3)-TRMAT(3,1))/ (2.0*SINCHI)
                DC(3) = (TRMAT(2,1)-TRMAT(1,2))/ (2.0*SINCHI)
                CHK = DC(1)**2 + DC(2)**2 + DC(3)**2
                IF (CHK.GT.0.8) THEN
                   GO TO 20
                ELSE
                   GO TO 10
                END IF
             END IF
          END IF
       END IF
       !
       !---- U_ANISO =0 or 180  can only find alpha + or - gamma.
       THETA2 = 0.0
       IF (TRMAT(3,3).LT.0.0) THETA2 = 180.0
       THETA3 = 0.0
       IF(TRMAT(2,1)**2+TRMAT(2,2)**2.NE.0.0) THETA3 = ATAN2(TRMAT(2,1),TRMAT(2,2))*RTODEG
       THETA1 = 0.0
       IF (THETA2.EQ.0) CHI = THETA3
       IF (THETA2.EQ.180.0) CHI = 180.0
       !
       !---- IF CHI =180  COSCHI=-1,SINCHI=0
10     DC(1) = SQRT(ABS(TRMAT(1,1)*0.5+0.5))
       DC(2) = SQRT(ABS(TRMAT(2,2)*0.5+0.5))
       DC(3) = SQRT(ABS(TRMAT(3,3)*0.5+0.5))
       !
       !---- Assume dc(1) positive
       IF (DC(1).NE.0.0) THEN
          IF (DC(2).NE.0.0) DC(2) = DC(2)*SIGN(1.0,TRMAT(1,2))
          IF (DC(3).NE.0.0) DC(3) = DC(3)*SIGN(1.0,TRMAT(1,3))
       ELSE IF (DC(2).NE.0.0) THEN
          IF (DC(3).NE.0.0) DC(3) = SIGN(1.0,TRMAT(2,3))*DC(3)
       END IF
20     DC(4) = DC(1)
       DC(5) = DC(2)
       !
       SOMEGA = SQRT(ABS(1.0-DC(3)*DC(3)))
       OMEGA = 0.0
       IF(SOMEGA**2+DC(3)**2.NE.0.0)  OMEGA = ATAN2(SOMEGA,DC(3))*RTODEG
       CHK = DC(2)*DC(2) + DC(1)*DC(1)
       PHI = 999
       IF (CHK.GT.0.0) PHI = RTODEG*ATAN2(DC(2),DC(1))
    END IF
  END SUBROUTINE POLAR
