c
      subroutine molfile_2_dict(mdoc,list,natommax,natom,latom_charge
     &     ,latom_nhydr,latom_weight,xyz_sdf,latom_name,latom_symb
     &     ,latom_chiral
     &     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors,mon,file_sdf
     &     ,nameo,ierr)
      use odbfiles
      implicit none
      include 'crd_com.fh'
c
c---  Read sdf mol files version v2000, v3000 and sybil mol2 file
c
c---  inputs
      integer   mdoc
      character file_sdf*(*),nameo*(*)
      character mon*(*),list*(*)
      integer   natommax,natom
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      real      xyz_sdf(3,natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      character latom_symb(natommax)*2
      integer   ntorsmax
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(2,ntorsmax)
c
c---  outputs
      integer ierr
c
c---  locals
      integer nbondmax,nbond
      parameter (nbondmax = 1000)
      integer   lbond1(nbondmax),lbond2(nbondmax)
      integer lbond_flag(nbondmax)
      real lbond_val(2,nbondmax)
      character lbond_order(nbondmax)*8
      integer nanglemax,nangle
      parameter (nanglemax = 1000)
      integer langle(3,nanglemax)
      real langle_val(2,nanglemax)
      integer nchirmax,nchir
      parameter (nchirmax=200)
      integer lchir_atom(9,nchirmax)
      character lchir_sign(nchirmax)*6
c
      integer iun,m,imode,len,l,ll,iend,jp,ip
      integer iv2000,iv3000
      character line_in*80
      integer hydro_at,ster_at,ster_bond,valence_at,charge_at
      integer bond_order,bond_stereo
      integer i,j,is,is1,ia,ib
      integer ia1,ia2
      character err_message*80
      character file_type*3

      character path*80,ext*80
c
c---body
      ierr = 0
      m    = 0
      path  = ' '
      ext   = ' '
      iun   = cro_iun
      call openfr(iun,m,path,file_sdf,ext,ierr)
      if(ierr.gt.0) then
         ierr = 1
         call msgerr(mdoc,' ERROR: open input_SDF_file')
         goto 999
      endif
      call find_molfile_type(m,iun,file_type,ierr)
      if(ierr.gt.0) then
         err_message = 'Problem in defining mol file type'
         ierr = 1
         goto 999
      endif
c
      if(file_type.eq.'SV2') then
         write(*,*)'  File type: SDF'
         call read_sdfv2000_file(mdoc,iun,list,natommax,natom
     &     ,latom_charge
     &     ,latom_nhydr,latom_weight,xyz_sdf,latom_name,latom_symb
     &     ,latom_chiral
     &     ,nbondmax,nbond
     &     ,lbond1,lbond2,lbond_order,lbond_flag
     &     ,nchirmax,nchir,lchir_atom,lchir_sign
     &     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors,mon
     &     ,ierr)
      elseif(file_type.eq.'ML2') then
         write(*,*)'  File type: MOL2 (SYBIL)'
         call read_mol2_file(mdoc,iun,list,natommax,natom
     &     ,latom_charge
     &     ,latom_nhydr,latom_weight,xyz_sdf,latom_name,latom_symb
     &     ,latom_chiral
     &     ,nbondmax,nbond
     &     ,lbond1,lbond2,lbond_order,lbond_flag
     &     ,nchirmax,nchir,lchir_atom,lchir_sign
     &     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors,mon
     &     ,ierr)

      elseif(file_type.eq.'SV3') then
         write(*,*)'  File type: SDF (3D. It has not been tested yet'
         call read_sdfv3000_file(mdoc,iun,list,natommax,natom
     &     ,latom_charge
     &     ,latom_nhydr,latom_weight,xyz_sdf,latom_name,latom_symb
     &     ,latom_chiral
     &     ,nbondmax,nbond
     &     ,lbond1,lbond2,lbond_order,lbond_flag
     &     ,nchirmax,nchir,lchir_atom,lchir_sign
     &     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors,mon
     &     ,ierr)
      elseif(file_type.eq.'ODB') then
         write(*,*)'  File type: O odb'
         call read_and_sort_odb_file(mdoc,iun,list,natommax,natom,
     &        latom_name,latom_symb,nbondmax,nbond,lbond1,lbond2,
     &        lbond_val,lbond_order,nanglemax,nangle,langle,langle_val,
     &        ntorsmax,ntors,ltors_atom,ltors,mon,ierr)

         if(ntors.gt.0) ltors_period(1:ntors) = 0
         ltors_period(1:ntorsmax) = 0
         latom_charge(1:natommax) = 0
         xyz_sdf(1:3,1:natommax) = 0.0
         lchir_atom(1:9,1:nchirmax) = 0
         latom_chiral(1:natom) = ' '
      else
         err_message = 'Wrong mol file type'
         ierr = 1
         goto 999
      endif
      close(iun)
c     
c--   Coount number of hydrogens on each atom
      do ia=1,natom
         latom_nhydr(ia) = 0
      enddo
      do ib=1,nbond
         ia1 = lbond1(ib)
         ia2 = lbond2(ib)
         if(  latom_symb(ia1).eq.'H   '.and.
     &        latom_symb(ia2).ne.'H   ') then
            latom_nhydr(ia2) = latom_nhydr(ia2) + 1
         elseif( latom_symb(ia2).eq.'H   '.and.
     &           latom_symb(ia1).ne.'H   ') then
            latom_nhydr(ia1) = latom_nhydr(ia1) + 1
         endif
      enddo
c
c---  Add hydrogens in their riding positions. Later
c      call add_riding_hydr
c
c---  Define atom names
      call set_atom_name(natom,natommax,latom_name,latom_nhydr,ierr)
      if(ierr.gt.0) then
         err_message = 'wrong atom name setting'
         goto 999
      endif
c
      do  ib=1,nbond
         lbond_flag(ib) = 0
      enddo
      call get_chiralities(natom,natommax,latom_name
     *      ,latom_chiral,nbond,lbond_flag
     *     ,lbond1,lbond2,nchir,nchirmax,lchir_atom,lchir_sign
     *     ,err_message,ierr)
c
      if(ierr.gt.0) then
         write(*,'(a)')err_message
         err_message = 'Problem in get_chiralities'
         goto 999
      endif
      call lenstr_bl(nameo,l)
      if(l.gt.0.and.nameo(1:1).ne.' '.and.nameo(1:1).ne.',') then
      else
         nameo = 'libcheck.lib'
      endif
      path = ' '
      ext  = ' '
      iun  = cro_iun
      m  = 99
      call openfw(iun,m,path,nameo,ext,ierr)
      if(ierr.ne.0) then
         ierr = 1
         err_message = ' ERROR: open output_file_sdf'
         goto 999
      endif
c
      call write_mol2min(MDOC,IUN,mon
     * ,natom,latom_name,latom_symb,latom_charge,latom_weight
     * ,xyz_sdf,nbond,lbond1,lbond2,lbond_order
     * ,ntors,ltors_atom,ltors_period,ltors
     * ,nchir,lchir_atom,lchir_sign,IERR)


      if(ierr.gt.0) then
         err_message = 'Problem in write_mol2min'
      endif
c     
 999  continue
      if(ierr.gt.0) then
         call msgerr(mdoc,err_message)
         return
      endif
      return
      end
c
      subroutine find_molfile_type(mdoc,iun,file_type,ierr)
      implicit none
c
c---  inputs
      integer mdoc,iun
c
c---  outputs
      integer ierr
      character file_type*(*)
c     
c---  locals
      character line_in*256

      integer maxitems,nitems
      parameter (maxitems = 200)
      integer ibeg(maxitems),iend(maxitems)
      character key*20

c
c---  body
      ierr = 0
c
c--Is it sdf v3000 or v2000 file.The fourth line must contain versions stamp
      read(iun,'(a)')line_in
      read(iun,'(a)')line_in
      read(iun,'(a)')line_in
      read(iun,'(a)')line_in
      if(index(line_in,'V3000').gt.0
     &     .or.index(line_in,'v3000').gt.0) then
         file_type = 'SV3'
         return
      elseif(index(line_in,'V2000').gt.0.or.
     &       index(line_in,'v2000').gt.0) then
         file_type = 'SV2'
         return
      endif
c
c--Is it SYBIL mol2 file. It must contain @TRIPOS in the beginning of lines
      rewind(iun)
 10   continue
      read(iun,'(a)',err=300,end=300)line_in
      if(line_in(1:9).eq.'@<TRIPOS>') then
         file_type = 'ML2'
         return
      else
         call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
         key = line_in(ibeg(1):iend(1))
         call ccpupc(key)
         if(key(1:4).eq.'RESI') then
            file_type ='ODB'
            rewind(iun)
            return
         endif
      endif
      goto 10
 300  continue
      ierr = 1
      return
      end
c
      subroutine read_mol2_file(mdoc,iun,list,natommax,natom
     &     ,latom_charge
     &     ,latom_nhydr,latom_weight,xyz_sdf,latom_name,latom_symb
     &     ,latom_chiral
     &     ,nbondmax,nbond
     &     ,lbond1,lbond2,lbond_order,lbond_flag
     &     ,nchirmax,nchir,lchir_atom,lchir_sign
     &     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors,mon
     &     ,ierr)
      implicit none
c
c---  Read atom positions and bond orders from mol2 file
c
c---  inputs
      integer mdoc,iun
      character mon*16,list*1
      integer   natommax,natom
      integer   ntorsmax
      integer nbondmax,nbond
      integer nchirmax,nchir
c
c---  outputs
      integer   ierr
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      real      xyz_sdf(3,natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      character latom_symb(natommax)*2
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(ntorsmax)

      integer   lbond1(nbondmax),lbond2(nbondmax)
      integer lbond_flag(nbondmax)
      character lbond_order(nbondmax)*8
      integer lchir_atom(9,nchirmax)
      character lchir_sign(nchirmax)*6
c
c---  locals
      integer i,j,ib,ib0,ia,ia1,ia2,l
      integer maxitems,nitems
      parameter (maxitems = 200)
      integer ibeg(maxitems),iend(maxitems)
      character line_in*256
      character key*20
      character bond_order*4
      character atype_loc*6
      character index_at(500)*4
c
c---  body
      rewind(iun)
      ierr = 0
c
c---  molecule
 10   continue
      call read_mol2_line(mdoc,iun,line_in,ierr)
      if(ierr.gt.0) goto 999
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      key = line_in(ibeg(1):iend(1))
      call check_line(1,key)
      if(key.eq.'@<TRIPOS>MOLECULE') then
c
c---  If it is info about molecule process it
         call read_mol2_line(mdoc,iun,line_in,ierr)
         if(ierr.gt.0) goto 999
         call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
         if(ierr.gt.0) goto 999
         if(len_trim(mon).le.0) mon=line_in(ibeg(1):iend(1))
         call read_mol2_line(mdoc,iun,line_in,ierr)
         if(ierr.gt.0) goto 999
         call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
         if(ierr.gt.0) goto 999
         read(line_in(ibeg(1):iend(1)),*)natom
         read(line_in(ibeg(2):iend(2)),*)nbond
         goto 20
      else
         goto 10
      endif
c
c---  atoms
 20   continue
      call read_mol2_line(mdoc,iun,line_in,ierr)
      if(ierr.gt.0) goto 999
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      key = line_in(ibeg(1):iend(1))
      call check_line(1,key)
      if(key.eq.'@<TRIPOS>ATOM') THEN
c
c---  If we are dealing with atoms process it
         do  ia=1,natom
            call read_mol2_line(mdoc,iun,line_in,ierr)
            if(ierr.gt.0) goto 999
            call parse_items(mdoc,maxitems,nitems,line_in,
     &           ibeg,iend,ierr)
            if(ierr.gt.0) goto 999
            index_at(ia) = line_in(ibeg(1):iend(1))
            latom_name(ia) = line_in(ibeg(2):iend(2))
            read(line_in(ibeg(3):iend(3)),*)xyz_sdf(1,ia)
            read(line_in(ibeg(4):iend(4)),*)xyz_sdf(2,ia)
            read(line_in(ibeg(5):iend(5)),*)xyz_sdf(3,ia)
            atype_loc = line_in(ibeg(6):iend(6))
            call check_line(1,atype_loc)
            l = index(atype_loc,'.')
            if(l.le.0) then
               latom_symb(ia) = atype_loc
            else
               latom_symb(ia) = atype_loc(1:l-1)
            endif
            if(nitems.ge.9) 
     &           read(line_in(ibeg(9):iend(9)),*)latom_charge(ia)
         enddo
      else
         goto 20
      endif
c
c---  bonds
 30   continue
      call read_mol2_line(mdoc,iun,line_in,ierr)
      if(ierr.gt.0) goto 999
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      key = line_in(ibeg(1):iend(1))
      call check_line(1,key)
      if(key.eq.'@<TRIPOS>BOND') then
c
c--   If it is about bonds process it
         ib = 0
         do ib0=1,nbond
            call read_mol2_line(mdoc,iun,line_in,ierr)
            if(ierr.gt.0) goto 999
            call parse_items(mdoc,maxitems,nitems,line_in,
     &           ibeg,iend,ierr)
            if(ierr.gt.0) goto 999
            bond_order = line_in(ibeg(4):iend(4))
            do ia=1,natom
               call lenstr_bl(index_at(ia),j)
               if(line_in(ibeg(2):iend(2)).eq.index_at(ia)(1:j)) then
                  ia1 = ia
                  goto 40
               endif
            enddo
            goto 60
 40         continue
            do ia=1,natom
               call lenstr_bl(index_at(ia),j)
               if(line_in(ibeg(3):iend(3)).eq.index_at(ia)(1:j)) then
                  ia2 = ia
                  goto 50
               endif
            enddo
            goto 60
 50         continue
            if(bond_order.eq.'1') then
               ib=ib+1
               lbond_order(ib) = 'single'
               lbond1(ib) = ia1
               lbond2(ib) = ia2
            elseif(bond_order.eq.'2') then
               ib = ib+1
               lbond_order(ib) = 'double'
               lbond1(ib) = ia1
               lbond2(ib) = ia2
            elseif(bond_order.eq.'3') then
               ib = ib+1
               lbond_order(ib) = 'triple'
               lbond1(ib) = ia1
               lbond2(ib) = ia2
            elseif(bond_order.eq.'am') then
               ib = ib + 1
               lbond_order(ib) = 'single'
               lbond1(ib) = ia1
               lbond2(ib) = ia2
            elseif(bond_order.eq.'ar') then
               ib = ib + 1
               lbond_order(ib) = 'aromatic'
               lbond1(ib) = ia1
               lbond2(ib) = ia2
            elseif(bond_order.eq.'un') then
               ib = ib+1
               lbond_order(ib) = '.'
               lbond1(ib) = ia1
               lbond2(ib) = ia2
            else
               goto 300
            endif
 300        continue
 60         continue
         enddo
         nbond = ib
      else
         goto 30
      endif
      do ia=1,natom
         latom_chiral(ia) = ' '
      enddo
 999  continue
c
c---  Error return
      if(ierr.gt.0) then
         call msgerr(mdoc,'Problem in read_mol2_file')
         ierr = 1
      endif
      return
      end
c
      subroutine read_mol2_line(mdoc,iun,line_out,ierr)
      implicit none
c
c---read mol2 line. Take care the fact that symbol \ is line continuation
c
c---  inputs
      integer mdoc,iun
c
c---outputs
      integer ierr
      character line_out*(*)
c
c---locals
      integer l,l1
      character line_loc*256
c
      line_out = ' '
 10   continue
      read(iun,'(a)',err=20,end=30) line_out
      return
 20   continue
      call msgerr(mdoc,'Problem in reading mol2 line')
      ierr = 1
      return
 30   continue
      call msgerr(mdoc,'Premature end of mol2 line')
      ierr = 1
      return
      end
c
      SUBROUTINE WRITE_mol2min(MDOC,IUN,COMP_ID
     * ,natom,latom_name,latom_symb,latom_charge,latom_weight
     * ,xyz_sdf,nbond,lbond1,lbond2,lbond_order
     * ,ntors,ltors_atom,ltors_period,ltors
     * ,nchir,lchir_atom,lchir_sign,IERR)
c -------------------------
      implicit none
      INTEGER   MDOC,IUN,IERR
      integer   natom
      real      latom_charge(*)
      real      latom_weight(*)
      real      xyz_sdf(3,*)
      character latom_name(*)*4,latom_symb(*)*2
      integer   nbond,lbond1(*),lbond2(*)
      character lbond_order(*)*8
      integer   ntors,ltors_atom(4,*),ltors_period(*)
      real      ltors(2,*)
      integer   nchir,lchir_atom(9,*)
      character lchir_sign(*)*8
      INTEGER   I,J,ICROSS
      CHARACTER LINE*256,COMP_ID*16,SYMB*4,CH1*1,CH2*2,CHAR8*16
      CHARACTER ATOM(9)*4
c -------------------------

      WRITE(LINE,'(''data_comp_list'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.id'')')
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c      WRITE(LINE,'(''_chem_comp.three_letter_code'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.name'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.group'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C      WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp.desc_level'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      WRITE(LINE,100)
     *         COMP_ID,'.','.',natom,'M'

      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  100 FORMAT(A8,1X,A1,1X,A1,1X,I4,1X,A1)

C ------------

      WRITE(LINE,'(''data_comp_'',A8)') COMP_ID
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.comp_id'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.atom_id'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.type_symbol'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      write(line,'(''_chem_comp_atom.x'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      write(line,'(''_chem_comp_atom.y'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      write(line,'(''_chem_comp_atom.z'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_atom.partial_charge'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      DO I=1,natom
        WRITE(LINE,500) 
     *                COMP_ID,latom_name(I),latom_symb(i)
     *               ,xyz_sdf(1,i),xyz_sdf(2,i),xyz_sdf(3,i)
     &               ,latom_charge(I)

        CALL WRTSTR(IUN,MDOC,LINE,IERR)
  500   FORMAT(1X,A8,6X,A4,1X,A4,3X,3f10.4,F8.3)
      ENDDO 
C ------------
      IF(nbond.LE.0) go to 2000
      
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.comp_id'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.atom_id_1'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.atom_id_2'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      WRITE(LINE,'(''_chem_comp_bond.type'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      DO I=1,nbond
        WRITE(LINE,701) 
     *    COMP_ID
     *   ,latom_name(lbond1(I)),latom_name(lbond2(I))
     *   ,lbond_order(I)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
 701    FORMAT(1X,A8,1X,A4,1X,A4,4X,A8)
      ENDDO
C ------------
      IF(ntors.GT.0) THEN

        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.comp_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_1'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_2'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_3'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.atom_id_4'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.value_angle'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.value_angle_esd'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_tor.period'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        
        DO I=1,ntors

          WRITE(CH2,'(I2)') I
          IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
          CHAR8='CONST_'//CH2

          WRITE(LINE,900) 
     *      COMP_ID,CHAR8
     *     ,latom_name(ltors_atom(1,I)),latom_name(ltors_atom(2,I))
     *     ,latom_name(ltors_atom(3,I)),latom_name(ltors_atom(4,I))
     *     ,ltors(1:2,I),ltors_period(I)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
  900     FORMAT(1X,A16,1X,A8,1X,A4,1X,A4,1X,A4,1X,A4,2X
     *              ,2(F8.3,1X),I3)
        ENDDO
      ENDIF
C ------------
      IF(nchir.GT.0) THEN 

        ICROSS = 0
        DO I=1,nchir
          IF(lchir_sign(I)(1:6).EQ.'cross3'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross4'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross5'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross6'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross7'.OR.
     *       lchir_sign(I)(1:6).EQ.'cross8'    ) ICROSS = 1
        ENDDO

        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.comp_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_centre'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_1'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_2'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.atom_id_3'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_chir.volume_sign'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(ICROSS.EQ.1) THEN
          WRITE(LINE,'(''_chem_comp_chir.atom_id_4'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_5'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_6'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_7'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_chir.atom_id_8'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

        DO I=1,nchir

          DO J=1,9
            IF(lchir_atom(J,I).LE.0) THEN
              ATOM(J) = '.'
            ELSE
              ATOM(J) = latom_name(lchir_atom(J,I))
            ENDIF
          ENDDO

          WRITE(CH2,'(I2)') I
          IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
          CHAR8='chir_'//CH2  
          WRITE(LINE,1000) 
     *      COMP_ID,CHAR8
     *     ,ATOM(1),ATOM(2),ATOM(3),ATOM(4)
     *     ,lchir_sign(I)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1000     FORMAT(1X,A8,1X,A8,1X,A4,1X,A4,1X,A4,1X,A4,4X,A8)
          IF(ICROSS.EQ.1) THEN
            WRITE(LINE,1001) 
     *      ATOM(5),ATOM(6),ATOM(7),ATOM(8),ATOM(9)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1001       FORMAT(19X,A4,1X,A4,1X,A4,1X,A4,1X,A4)
          ENDIF
        ENDDO
      ENDIF
C ------------
 2000 CONTINUE          
      END FILE IUN
      CLOSE(IUN)
C ------------

      RETURN
      END

