module mtz_things
  integer, parameter :: mcols = 200
  integer, parameter :: msets=mcols
  integer lookup(mcols)
  logical logmss(mcols)
  real adata(mcols)

  integer mtzin
  integer nlprgi,nlprgo
  integer, parameter :: prgo = 100
  CHARACTER LSPRGO(PRGO)*30,CTPRGO(PRGO)*1
  !
  REAL DATCELL(6,msets),DATWAVE(msets),datcell_out(6,msets),datwave_out(msets)
  INTEGER NDATASETS,ISETS(MSETS),ISET,CSETID(MCOLS),CSETOUT(MCOLS),SETID
  integer ndatasets_out

  CHARACTER*64 PNAME(MSETS),XNAME(MSETS),DNAME(MSETS),PNAME_OUT(MCOLS)
  character*64 XNAME_OUT(MCOLS),DNAME_OUT(MCOLS)
  !
  character Clabs(Mcols)*30,Ctyps(Mcols)*1
  character LSPRGI(MCOLS)*30,CTPRGI(MCOLS)*1
  character LSUSRJ(MCOLS)*30
  !
  !---  Columns to read and write
  integer, parameter :: nmaxpart_mtz=3
  integer ifree_o 
  integer ifo,iso,ifoall(100),isoall(100)
  integer ifpart(nmaxpart_mtz),iapart(nmaxpart_mtz)
  integer ihla,ihlb,ihlc,ihld,ifom,ipb
  integer ifo_map,isigo_map,ifo_weight
  integer i_int_o,i_int_sig_o,i_intm_o,i_intp_o
  integer i_intm_sig_o,i_intp_sig_o

  !--- input labels integer assignments 
  !  (should emulate enumaration without explicit tyope - fortran has no real enumeration...)
  integer,parameter :: i_H=1,i_K=2,i_L=3, i_FP=4,i_SIGFP=5, i_FREE=6
  integer,parameter :: i_FPART1=7,i_PHIP1=8, i_FPART2=9,i_PHIP2=10,i_FPART3=11,i_PHIP3=12
  integer,parameter :: i_HLA=13,i_HLB=14,i_HLC=15,i_HLD=16
  integer,parameter :: i_FOM=17,i_PHIB=18
  integer,parameter :: i_FP_MAP=19, i_SIGFP_MAP=20, i_W=21
  integer,parameter :: i_FN=22, i_SIGFN=23
  integer,parameter :: i_FPL=24,i_SIGFPL=25, i_FMI=26,i_SIGFMI=27
  integer,parameter :: i_F3=28,i_SIGF3=29, i_F4=30,i_SIGF4=31
  integer,parameter :: i_IP=32,i_SIGIP=33, i_IPL=34,i_SIGIPL=35,i_IMI=36,i_SIGIMI=37
  integer, parameter :: i_OBSD=38

  !-- output label class.
  ! members:  
  ! LSPRGO,CTPRGO - label name and type
  ! use - whether label is to be written to mtz or not
  ! val - storing the value for actual reflection
  TYPE labout
     SEQUENCE
     real val
     logical use
     CHARACTER LSPRGO*30
     CHARACTER CTPRGO*1
  END TYPE labout
      
  TYPE(labout), target :: labouts(PRGO)
  ! oc_* pointers for convenient access to labouts (o stands for output and c for class)
  TYPE(labout), pointer :: oc_H,oc_K,oc_L,oc_FP,oc_SIGFP,oc_FREE,        &
       oc_FC,oc_PHIC,oc_FC_ALL,oc_PHIC_ALL,oc_FWT,oc_PHWT,               &
       oc_DELFWT,oc_PHDELWT,oc_FOM,oc_PHCOMB,oc_FB,oc_PHIB,              &
       oc_HLACOMB,oc_HLBCOMB,oc_HLCCOMB,oc_HLDCOMB,                      &
       oc_HLA,oc_HLB,oc_HLC,oc_HLD,oc_F1,oc_SIGF1,oc_F2,oc_SIGF2,        & 
       oc_F3,oc_SIGF3,oc_F4,oc_SIGF4,                                    &
       oc_F_USER,oc_PHI_USER,oc_FAN,oc_PHAN,oc_DELFAN,oc_PHDELAN,        &
       oc_FC_ALL_LS,OC_PHIC_ALL_LS,oc_OBSD
  CHARACTER LABOUT_SAVE*600
end module mtz_things
