C
C
C     This code is sdistributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      subroutine rcard
      use restr_files
      implicit none

      integer   ierr
c
      integer   l
      integer   iscrk
c
c---Things for parser
      character line*512
      logical   lprint,lend
      real      fvalue(500)
      integer   ntok
      integer   ibeg(500),iend(500),ityp(500),idec(500)
      character key*4
      character cvalue(500)*4
      character file_name_loc*512
      integer ios
      integer nstack,iscrk_t(20)
c
c---  body
      iscrk_t(1:20) = 0
      call find_unique_file_name(keywords_file,'.txt')
      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.gt.0) then
         write(*,*)'Error ==> Problem with keyword file'
         ierr = 1
         return
      endif
      line = ' '
      lend = .FALSE.
c
c---  read keywords and write them to a file for future use
      key = ' '
      nstack = 0
      do while(.not.lend.and.key(1:3).ne.'END'.or.nstack.gt.0)
         if((lend.or.key(1:3).eq.'END').and.nstack.gt.0) then
            close(iscrk_t(nstack))
            iscrk_t(nstack) = 0
            nstack = nstack - 1
         endif
         line = ' '
         if(nstack.gt.0) then
            read(iscrk_t(nstack),'(a)',iostat = ios) line
            if(ios.ne.0) then
               lend = .TRUE.
               key = 'END'
               cycle
            endif
         endif
         lprint = .FALSE.
         ntok = 500
         call parser(key,line,ibeg,iend,ityp,fvalue,cvalue,
     &        idec,ntok,lend,lprint)
         if(lend.or.key(1:3).eq.'END') cycle
         line = trim(adjustl(line))
         if(line(1:1).eq.'@') then
            nstack = nstack + 1
            if(nstack.gt.10) then
               write(*,*)
     &            'Problem with keywords file: Too many files in files'
               call errwrt(1,'Problem with keywords file')
            endif
            file_name_loc = trim(line(2:))
            call open_form_file(iscrk_t(nstack),file_name_loc,ierr)
            write(iscrk,'(a,a)')'file ',trim(file_name_loc)
         else
            if(len_trim(line).gt.0) then
               write(iscrk,'(a)') trim(line)
            endif
         endif
      enddo
      write(iscrk,'(a3)')'END'
      close(iscrk)
      call rcard_interprete
      return
      end
c
c
      SUBROUTINE rcard_interprete
      use weights
      use agreem
      use rharvest
      use map_routines
      use ridge
      use local_tls
      use solvent_all
      use restr_files
      use CellAndSymmetry
      use refi_flags
      use signals_refmac
      use mtz_things
C
C---Read instructions and save them in common blocks for future use
      INCLUDE 'atom_com.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif.fh'
      include 'restr_params.fh'
      include 'twin_refmac.fh'
      include 'anom.fh'
      PARAMETER (NPARS = 200)
c      INTEGER MCOLS
c      PARAMETER (MCOLS = 200)
c      INTEGER MSETS
c      PARAMETER (MSETS=MCOLS)
C
c---Things for parser
      CHARACTER LINE*600,KEY*4,CVALUE(NPARS)*4
      INTEGER IBEG(NPARS),IEND(NPARS),IDEC(NPARS),ITYP(NPARS)
      REAL FVALUE(NPARS)
      LOGICAL LEND
C
      INTEGER NERROR,INCS_R,INCS_C
      LOGICAL LPRINT
      CHARACTER LABIN_SAVE*600
c      ,LABOUT_SAVE*600
C 
      character file_this*256
C----Harvesting stuff
C
c      INTEGER NDATASETS,ISETS(MSETS),ISET,CSETID(MCOLS),CSETOUT(MCOLS),
c     +          SETID
c      REAL DATCELL,DATWAVE
c      CHARACTER*64 PNAME,XNAME,DNAME,PNAME_OUT,XNAME_OUT,DNAME_OUT
c      COMMON /MTZSET/ NDATASETS,PNAME(MSETS),XNAME(MSETS),DNAME(MSETS),
c     +         PNAME_OUT(MCOLS),XNAME_OUT(MCOLS),DNAME_OUT(MCOLS),
c     +         DATCELL(6,MSETS),DATWAVE(MSETS)
c
      integer iscrk
      INTEGER ITOK,ITK
c
      integer ierr
c
c---  some parsing logic
      logical ok1,ok2,all_done
C
C---
      NERROR = 0
      NSMULT = 1
C
      LABIN_SAVE = ' '
      LABOUT_SAVE = ' '
      NUNREC = 0
      INCS_R  = 0
      INCS_C  = 0
C
C--- PARSER
      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.gt.0) then
         ierr = 1
         return
      endif

 10   CONTINUE
      read(iscrk,'(a)',end=999)line
      IERROR = 0
      KEY    = ' '
      NTOK   = NPARS
      lprint = .FALSE.

      CALL PARSER(KEY,LINE,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,NTOK,LEND,
     +            LPRINT)
C
C---Print instruction line with hyper link if necessary
C
c---Convert all CVALUEs to uppercase
      CALL CCPUPC(KEY)

      if(key.ne.'EXTE') then
         write(*,*)' Data line--- ',trim(line)
      endif

      DO    IKEY=2,NTOK
         CALL CCPUPC(CVALUE(IKEY))
      ENDDO
c
C---Start interpretation of keywords
C
C---Harvesting first
C===========================================================
C
C---- harvest
C
C---- PRIVATE   [priv]   flag only
C     =======
C                 if present sets dir access for first
C                 open of $HOME/DepositFiles to    drwx------
C                                       default is drwxr-xr-x 
C
C
      if(key.eq.'EXTE'.or.key.eq.'OCCU'.or.key.eq.'BREF') then
         goto 10
      else if (KEY .eq. 'PRIV') THEN
        PRIVATE = .true.
        GO TO 10
C
C---- USECWD [usec]   Flag only
C     ======
C                 if present file is opened in current working directory
C                 default is o/p file to
C                 $HOME/DepositFiles/ProjectName/DataSetName.ProgramName
C
      ELSE IF (KEY .eq. 'USEC') THEN
        USECWD = .true.
        GO TO 10
C
C---- PROJECTNAME [pname]  <string>
C     ===========
C     
C             if given with DATASET then harvest will o/p a file
C             this project_name should be always used for the
C             one structure determination
C             no default
C
      ELSE IF (KEY .eq. 'PNAM') THEN
        PNAME_KEYWRD = LINE(IBEG(2) :IEND(2))
        got_pname = .true.
        GO TO 10
C
C---- DATASETNAME  [dname]  <string>
C     ===========
C     
C             if given with PROJECT then harvest will o/p a file
C             this dataset_name is the name of one of the diffraction
C             data sets used in a particular project
C             no default
C
      ELSE IF (KEY .eq. 'DNAM') THEN
        DNAME_KEYWRD = LINE(IBEG(2) :IEND(2))
        got_dname = .true.
        GO TO 10
C
C---- ROWLIMIT   [rsize]  <int>
C     ========
C     
C              if given sets the number of characters in a row
C              for the output file, default is 132
C              TRUE mmcif default is 80
C
      ELSE IF (KEY .eq. 'RSIZ') THEN
        NROWLIMIT = 132
        IF (NTOK.GE.2) CALL GTNINT(2,1,NROWLIMIT,NTOK,ITYP,FVALUE)
        GO TO 10
C
C---- NOHARVEST
C     ========
C
C              disable writing of harvest files
C
      ELSE IF (KEY .eq. 'NOHA') THEN
        NOHARVEST = .true.
        GO TO 10
C
C---- harvest
      ELSEIF(KEY.EQ.'MODE') THEN
C
c----'MODE" Read action mode. Default is individual atomic reifnement
         CALL CCPUPC(LINE)
         MODE = 'HKRF'
         IF(NTOK.GE.2) MODE = LINE (IBEG(2):IEND(2))
         IF(MODE.EQ.'RIGI'.OR.MODE.EQ.'TLSR'.or.MODE.EQ.'OCCU'.or.
     &        mode.eq.'SFCA') REFID = 'UNRE'
         GOTO 10
      elseif(key.eq.'TEST') then
         if(cvalue(2)(1:2).eq.'DB') refmac_tests = 'DBASE'
         if(cvalue(2)(1:4).eq.'VDWW') vdw_write_flag = .TRUE.
         goto 10 
      ELSEIF(KEY.EQ.'TITL') THEN
         GOTO 10
C
c---Parameters controlling phased refinement
      ELSEIF(KEY.EQ.'PHAS') THEN
        ITOK = 2
        CALL READ_PHFACTORS(NTOK,ITOK,CVALUE,ITYP,FVALUE)
        GOTO 10
      ELSEIF(KEY.EQ.'FREE') THEN
C
C---Alternative flag for free reflections. Default is 0
        IF(NTOK.LT.2) THEN
          LFreeRexcludeVal   = 0
          GOTO 10
        ENDIF
        CALL GTNINT(2,1,LFreeRexcludeVal,NTOK,ITYP,FVALUE)          
        GOTO 10
      ELSEIF (KEY.EQ.'MAPC') THEN
         IF(NTOK.LT.2) GOTO 10
         itk = 2
         do while(itk.le.ntok)
            if(cvalue(itk).eq.'FREE') then
               itk = itk + 1
               if(itk.gt.ntok) goto 10
               if(cvalue(itk).eq.'INCL') then
                  free_for_map = 'I'
                  itk = itk + 1
               else if(cvalue(itk).eq.'EXCL') then
                  free_for_map = 'E'
                  itk = itk + 1
               elseif(cvalue(itk).eq.'REST') then
                  free_for_map = 'R'
                  itk = itk + 1
               endif
            elseif(cvalue(itk).eq.'METH') then
               itk = itk + 1
               sharp_map_method = 'I'
               if(cvalue(itk)(1:1).eq.'I') then
                  sharp_map_method = 'I'
                  itk = itk + 1
               else
                  sharp_map_method = 'S'
                  itk = itk + 1
               endif
            elseif(cvalue(itk).eq.'OPTI') then
               itk = itk + 1
               sharp_map_options = 1
               if(ityp(itk).eq.2) then
                  sharp_map_options = nint(fvalue(itk))
                  itk = itk + 1
                  sharp_map_options = max(1,min(4,sharp_map_options))
               endif
            elseif(cvalue(itk).eq.'COEF') then
               itk = itk + 1
               if(itk.le.ntok) then
                  call gtnrea(itk,1,scale_map_obs,ntok,ityp,fvalue)
                  itk = itk + 1
                  if(itk.le.ntok) then
                     call gtnrea(itk,1,scale_map_calc,ntok,ityp,fvalue)
                     itk = itk + 1
                  endif
               endif
            elseif(cvalue(itk).eq.'REMO') then
               itk = itk + 1
               if(cvalue(itk).eq.'DPAR') then
                  itk = itk + 1
                  mapc_remove_dpar = .TRUE.
               endif
            elseif(cvalue(itk).eq.'SHAR') then
               sharp_map_flag = .TRUE.
               itk = itk + 1
               if(ityp(itk).eq.2) then
                  b_sharp_map = fvalue(itk)
                  itk = itk + 1
               endif
               do while(itk.le.ntok.and.
     &              (cvalue(itk).eq.'BVAL'.or.cvalue(itk).eq.'ALPH'.or.
     &              cvalue(itk).eq.'FRAC'.or.cvalue(itk).eq.'OPTI'.or.
     &              cvalue(itk).eq.'METHO'))
                  if(cvalue(itk).eq.'BVAL') then
                     itk = itk + 1
                     b_sharp_map = fvalue(itk)
                     itk = itk + 1
                  elseif(cvalue(itk).eq.'ALPH') then
                     itk = itk + 1
                     if(ityp(itk).eq.2) then
                        sharp_regul_opt = .FALSE.
                        sharp_map_method = 'S'
                        alpha_sharp_map = fvalue(itk)
                        itk = itk + 1
                     else
                        if(cvalue(itk)(1:3).eq.'OPT') then
                           sharp_regul_opt = .TRUE.
                           sharp_map_method = 'S'
                           itk = itk + 1
                        else
                           sharp_regul_opt = .FALSE.
                           alpha_sharp_map = fvalue(itk)
                           itk = itk + 1
                        endif
                     endif
                  elseif(cvalue(itk).eq.'FRAC') then
                     itk = itk + 1
                     fraction_sharp_map = fvalue(itk)
                     write(*,*)'Here ',fraction_sharp_map
                     itk = itk + 1
                 
                  elseif(cvalue(itk).eq.'METH') then
                     itk = itk + 1
                     sharp_map_method = 'I'
                     if(cvalue(itk)(1:1).eq.'I') then
                        sharp_map_method = 'I'
                        itk = itk + 1
                     else
                        sharp_map_method = 'S'
                        itk = itk + 1
                     endif
                  elseif(cvalue(itk).eq.'OPTI') then
                     itk = itk + 1
                     sharp_map_options = 1
                     if(ityp(itk).eq.2) then
                        sharp_map_options = nint(fvalue(itk))
                        itk = itk + 1
                        sharp_map_options = 
     &                       max(1,min(4,sharp_map_options))
                     endif
                  endif
               enddo
            elseif(cvalue(itk).eq.'EXTE') then
               map_extend_flag = .TRUE.
               itk = itk + 1
            else
               itk = itk + 1
            endif
         enddo
         write(*,*)alpha_sharp_map,b_sharp_map
         GOTO 10
      ELSEIF(KEY.EQ.'SET') THEN
c---  Should be added. Setting of some parameters like tolerances and 
C---  so on
         CALL ERRWRT(0,'This part of the program is not ready')
         GOTO 10
      ELSEIF(KEY.EQ.'NCYC') THEN
C
C---Number of refinement cycles. Default 5.
        IF(NTOK.LT.2) THEN
          NCCREF = 5
          GOTO 10
        ENDIF
        ncyc_set_by_user_flag = .true.
        CALL GTNINT(2,1,NCCREF,NTOK,ITYP,FVALUE)
        GOTO 10
      ELSEIF(KEY.EQ.'ANOM') THEN
c
c----Using anomalous scattering
         itok = 2
         call read_anom_params(ntok,itok,line,ibeg,iend,ityp,fvalue,
     &        cvalue,ierror)
c         CALL ERRWRT(0,'This part of the program is not ready')
         GOTO 10
      else if(key.eq.'TWIN') then
         itok = 2
         call read_twin_params(ntok,itok,line,ibeg,iend,ityp,fvalue,
     &        cvalue,ierror)

         goto 10
      else if(key.eq.'FORM') then
         goto 10
c      elseif(key.eq.'OCCU') then
c         itk = 2
c         call read_occupancy_params(ntok,itok,line,ibeg,iend,ityp,
c     &        fvalue,cvalue,ierror)
c         goto 10
      ELSEIF(KEY.EQ.'SYMM') THEN
C
C---Read symmetry and process it
        ITOK = 2
        CALL READ_SYMM_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,
     &           FVALUE)
        GOTO 10
      ELSEIF(KEY.EQ.'MONI') THEN
c
c---For monitoring some statistic
         ITOK   = 2
         IERROR = 0
         CALL MONITOR_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &        CVALUE,IERROR)
         NERROR = NERROR + IERROR
         GOTO 10
      ELSEIF(KEY.EQ.'CELL') THEN
C           
C---Read cell parameters. Usually should not be used. In some
C---cases could be useful. It has highes priority.
        ITOK = 2
        CALL RDCELL(ITOK,ITYP,FVALUE,NTOK,CELL)
        GOTO 10
      ELSEIF(KEY.EQ.'WRIT') THEN
         DO   ITK =2,NTOK
           IF(CVALUE(ITK).EQ.'MASK') THEN
             SOLVENT_WRITE_FLAG = .TRUE.
           ENDIF
         ENDDO
         GOTO 10
      ELSEIF(KEY.EQ.'SHAN') THEN
      
C
c----Read shannon factor for grid spacing. Fshann is factor by which 
C----Niquist spacing is increased. Default is 1.3
        FSHANN = 1.5
        IF(NTOK.GE.2) THEN
          CALL GTNREA(2,1,FSHANN,NTOK,ITYP,FVALUE)
          IF(FSHANN.LE.0.0) THEN
            FSHANN = 1.5
          ELSEIF(FSHANN.LE.1.0) THEN
            FSHANN = 1.0/FSHANN
          ENDIF
        ENDIF
        GOTO 10
      ELSEIF(KEY.EQ.'SOLV') THEN
        CALL SOLVENT_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,CVALUE,
     &      IERROR)
        GOTO 10
      ELSEIF(KEY.EQ.'RESO') THEN
        ITOK = 2
        CALL RDRESO(ITOK,ITYP,FVALUE,NTOK,ResMin,ResMax,STLMIN,STLMAX)
        SMN = STLMIN
        STLMIN = SQRT(STLMIN)/2.0
        STLMAX = SQRT(STLMAX)/2.0
        ITK = 2
        GOTO 10
       ELSEIF (KEY.EQ.'RANG' .OR. KEY.EQ.'BINS') THEN
         NBIN = 20
         IF (NTOK.GT.1) THEN
C              ************************************
           CALL GTNREA(2,1,RANGE,NTOK,ITYP,FVALUE)

C  If range > 1 this gives the number of bins
          IF (RANGE .GT. 1.0) THEN
            NBIN = MIN(NBM-1,NINT(RANGE))
            RANGE = -1
          ENDIF
          if(ntok.gt.2) then
             bint = cvalue(3)
             if(bint.ne.'REFL') then
                call errwrt(0,'Wrong subkeyword of bins')
             endif
          endif
        END IF
        GO TO 10
      ELSEIF(KEY.EQ.'WEIG') THEN
C
C---Weighting scheme.
        ITOK = 2
        CALL WEIGHT_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,CVALUE,
     &                     IERROR)
        GOTO 10
      ELSEIF(KEY.EQ.'DAMP') THEN
        DAMP_FLAG = .TRUE.
        IF(NTOK.GE.2) CALL  GTNREA(2,1,PDAMP,NTOK,ITYP,FVALUE)
        IF(NTOK.GE.3) CALL  GTNREA(3,1,BDAMP,NTOK,ITYP,FVALUE)
        IF(NTOK.GE.4) CALL  GTNREA(4,1,QDAMP,NTOK,ITYP,FVALUE)
        GOTO 10

       ELSEIF(KEY.EQ.'DIST') THEN
C
C----Distance restrants
          IF(NTOK.GE.2.and.ityp(2).eq.2) then
             CALL GTNREA(2,1,WDSKAL,NTOK,ITYP,FVALUE)
             if(ntok.ge.3) call gtnrea(3,1,wdskal2,ntok,ityp,fvalue)
          elseif(cvalue(2).eq.'SDEX') then
             call gtnrea(3,1,sd_ext_min,ntok,ityp,fvalue)
          elseif(cvalue(2).eq.'EXCU') then
             call gtnrea(3,1,sd_ext_cut,ntok,ityp,fvalue)
          elseif(cvalue(2).eq.'DELE') then
             call gtnrea(3,1,delta_ext,ntok,ityp,fvalue)
          elseif(cvalue(2).eq.'DMXE') then
             call gtnrea(3,1,dmax_ext,ntok,ityp,fvalue)
          elseif(cvalue(2).eq.'DMNE') then
             call gtnrea(3,1,dmin_ext,ntok,ityp,fvalue)
          endif
          GOTO 10
       elseif(key.eq.'RIDG') then
          call read_ridge_params(ntok,itok,line,ibeg,iend,ityp,fvalue,
     &         cvalue,ierror)

          goto 10
       ELSEIF(KEY.EQ.'ANGL') THEN
C
C----Bond angle restrants
          IF(NTOK.GE.2) CALL GTNREA(2,1,WASKAL,NTOK,ITYP,FVALUE)
          GOTO 10
C
C===========================================================
       ELSEIF(KEY.EQ.'TORS') THEN
C
C----Torsion restrants
          IF(NTOK.GE.2) CALL GTNREA(2,1,WTSKAL,NTOK,ITYP,FVALUE)
          GOTO 10
C
C===========================================================
       ELSEIF(KEY.EQ.'BFAC'.OR.KEY.EQ.'TEMP') THEN
c
c---Restraint on B-factors
          ITOK = 2
          CALL READ_BFAC_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                     CVALUE,IERROR)
          GOTO 10
       ELSEIF(KEY.EQ.'SPHE') THEN
C
C----Restraint for sphericity of anisotropic U values
         IF(NTOK.GE.2) CALL GTNREA(2,1,SIGSPH,NTOK,ITYP,FVALUE)
         GOTO 10
C
C===========================================================
       ELSEIF(KEY.EQ.'RBON') THEN
C
C----Restraint on rigid bond
         IF(NTOK.GE.2.and.ityp(2).eq.2) then
            sigr_kl(1) = fvalue(2)
            if(ntok.ge.3.and.ityp(3).eq.2) then
               sigr_kl(2) = fvalue(3)
               if(ntok.ge.4.and.ityp(4).eq.2) then
                  sigr_kl(3) = fvalue(4)
                  if(ntok.ge.5.and.ityp(5).eq.2) then
                     sigr_kl(4) = fvalue(5)
                  endif
               endif
            endif
         endif
         GOTO 10
       ELSEIF(KEY.EQ.'PLAN') THEN
c
c---Restraints on planes and so on
          IF(NTOK.GE.2) CALL GTNREA(2,1,WPSKAL,NTOK,ITYP,FVALUE)
          GOTO 10
C
C===========================================================
       ELSEIF(KEY.EQ.'CHIR') THEN
          IF(NTOK.GE.2) CALL GTNREA(2,1,WCSKAL,NTOK,ITYP,FVALUE)
          GOTO 10
C
C===========================================================
       ELSEIF(KEY.EQ.'VDWR'.OR.KEY.EQ.'VAND'.OR.KEY.EQ.'NONB') THEN
          ITOK = 2
          CALL READ_NBOND_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                     CVALUE,IERROR)
          GOTO 10
       ELSEIF(KEY.EQ.'REST') THEN
         ITOK = 2
         CALL READ_RESTR_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                     CVALUE,IERROR)
         GOTO 10
       ELSEIF(KEY.EQ.'BLIM') THEN
        IF(NTOK.GE.2) THEN
          CALL GTNREA(2,1,BResetMin,NTOK,ITYP,FVALUE)
          BResetMin = BResetMin/PISQ8
          BResetmin = max(BResetMin,0.0001/PISQ8)
        ENDIF
        IF(NTOK.GE.3) THEN
           CALL GTNREA(3,1,BResetMax,NTOK,ITYP,FVALUE)
           BResetMax = BResetMax/PISQ8
        ENDIF

        GOTO 10 
      ELSEIF(KEY.EQ.'NCSR'.OR.KEY.EQ.'NONX') THEN
C
C----Non cryst symmetry restraints
        ITOK = 2
        CALL NCSR_PARAMS(NTOK,ITOK,IBEG,IEND,ITYP,FVALUE,CVALUE,LINE,
     &       IERROR)
        NERROR = NERROR + IERROR 
        GOTO 10
      ELSEIF(KEY.EQ.'NCSC') THEN

C
C---Non cryst symmetry constraints
        ITOK = 2
        CALL NCSC_PARAMS(NTOK,ITOK,IBEG,IEND,ITYP,FVALUE,CVALUE,
     &       line,IERROR)
        NERROR = NERROR + IERROR 
        GOTO 10
      ELSEIF(KEY.EQ.'HOLD') THEN
C
C---This value can make refinement stable but slow. See document
        IF(NTOK.GE.2) CALL GTNREA(2,1,PDEL,NTOK,ITYP,FVALUE)
        IF(NTOK.GE.3) CALL GTNREA(3,1,BDEL,NTOK,ITYP,FVALUE)
        BDEL = BDEL/PISQ8
        IF(NTOK.GE.4) CALL GTNREA(4,1,QDEL,NTOK,ITYP,FVALUE)
        GOTO 10
C
      ELSEIF(KEY.EQ.'SCAL') THEN
c
C---Read parameters for scaling
        ITOK = 2
        CALL SCALE_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,CVALUE,
     &                    IERROR)
        GOTO 10
      ELSEIF(KEY.EQ.'SCPA') THEN
C
        ITOK = 2
        IF(NTOK.LT.2) GOTO 10
        DO    ITOK=2,NTOK
C   Scale these PARTial contributions independently of FC
          CALL GTNINT(ITOK,1,NSCLSEP,NTOK,ITYP,FVALUE)
          IF(NSCLSEP.GT.NMAXPART)
     +         CALL ERRWRT(-1,' Only 9 FPART terms allowed')
          IF(NSCLSEP.GT.NMAXPART) NERROR = NERROR + 1
          ISCPART(NSCLSEP) = 1
        ENDDO   
        GOTO 10 
      ELSEIF(KEY.EQ.'MAKE') THEN
c
C---Read parameters for makeicf which makes restraints
        ITOK = 2
        CALL MAKE_REST_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &  CVALUE,IERROR)
        GOTO 10
      ELSEIF(KEY.EQ.'LABI') THEN
C
C---Save line for further treatment.. Input mtz labels
        LABIN_SAVE = LINE
        GOTO 10
      ELSEIF(KEY.EQ.'LABO') THEN
c
c---Output mtz labels. Save line for further treatment.
        LABOUT_SAVE = LINE
        GOTO 10
      ELSEIF(KEY.EQ.'REFI') THEN
C
C---Read parameters for refinement. 
        ITOK = 2
        IERROR = 0
        CALL REFI_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &           CVALUE,IERROR)
        GOTO 10
      else if(key.eq.'RAND') then
         itk = 1
         write(*,*)trim(line)
         write(*,*)cvalue(1:ntok)
         rand_ref_flag = .TRUE.
         do while(ntok.gt.itk)
            itk = itk + 1
            if(ntok.ge.itk) then
               if(cvalue(itk).eq.'GIBB') then
                  gibbs_sample_flag = .TRUE.
               elseif(cvalue(itk).eq.'CYCL') then
                  nrandom_cycle = 100
                  itk = itk + 1
                  if(ntok.ge.itk) then
                     call gtnint(itk,1,nrandom_cycle,ntok,ityp,fvalue)
                  endif
               else if(cvalue(itk).eq.'MAXS') then
                  rshift_max = 2.0
                  itk = itk + 1
                  if(ntok.ge.itk) then
                     call gtnrea(itk,1,rshift_max,ntok,ityp,fvalue)
                  endif
               else if(cvalue(itk).eq.'EXTE') then
                  rand_extend = 1.3
                  itk = itk + 1
                  if(ntok.ge.itk) then
                     call gtnrea(itk,1,rand_extend,ntok,ityp,fvalue)
                  endif
               endif
            endif
         enddo
         goto 10
      ELSEIF(KEY.EQ.'RIGI') THEN
C
C---Read rigid body parameters
        ITOK = 1
        CALL READ_RBODY_PARS(NERROR,NTOK,ITOK,line,CVALUE,
     &       ibeg,iend,ityp,FVALUE)
        GOTO 10
C
C---Hydrogens
      ELSEIF(KEY.EQ.'HYDR') THEN
        ITOK = 1
        CALL READ_HYDROGEN_PARS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &           CVALUE,IERROR)
        GOTO 10
      ELSEIF(KEY.EQ.'TLSC') THEN 
C
C---Number of cycles of TLS refinement. Implies MODE is 'TLSR'.
         MODE  = 'TLSR'
         REFID = 'UNRE'
         IF(NTOK.GE.2) CALL GTNINT(2,1,NTLS_CYCLE,NTOK,ITYP,FVALUE)
         GOTO 10
       else if (key.eq.'TLSO') then
         if(ntok.ge.2) then
            if(CVALUE(2).eq.'ADDU') THEN
               tls_add_atoms = .TRUE.
            else if(CVALUE(2).eq.'NOAD') then
               tls_add_atoms = .FALSE.
            endif
         endif
         goto 10
      else if(key.eq.'TLSD') then
         if(ntok.gt.2) then
            if(cvalue(2).eq.'WATE') then
               if(cvalue(3).eq.'ADD') then
                  waters2tls = 'ADD'
               else
                  waters2tls = 'EXC'
               endif
            endif
         endif
         goto 10
      elseif(key.eq.'TLSL') then
         local_tls_pairs = 1
         local_tls_dist = 6.0
         local_tls_weight = 1.0
         if(cvalue(2).eq.'DIST') then
            if(ityp(3).eq.2) local_tls_dist = fvalue(3)
         elseif(cvalue(2).eq.'WEIG') then
            if(ityp(3).eq.2) local_tls_weight = fvalue(3)
         endif
         goto 10
      elseif(key.eq.'PDBO') then
         itk = 2
         if(cvalue(itk).eq.'COPY') then
            itk = itk + 1
            if(cvalue(itk).eq.'REMA') then
               itk = itk + 1
               do it = itk,ntok
                  if(ityp(it).eq.2) then
                     nrem_copy = nrem_copy + 1
                     if(nrem_copy.le.nmax_rem_copy) then
                        remark_copy(nrem_copy) = nint(fvalue(it))
                     else
                        write(*,*)
     &                       'Error: Number of copied remarks exceeds'//
     &                       ' maximum allowed -- ',nmax_rem_copy
                        call errwrt(1,'Problem with PDBOUT instruction')
                     endif
                  endif
               enddo
            endif
         elseif(cvalue(itk).eq.'FORM') then
            itk = itk + 1
            if(cvalue(itk).eq.'MMCI') then
               pdb_out_format = 'C'
            else
               pdb_out_format = 'P'
            endif
            itk = itk + 1
         endif
         goto 10
      elseif(KEY.EQ.'PHOU') then
        out_distrib_flag = .true.
        goto 10
c perhaps improve the input keyword organisation for dm, especially if more keywords are needed.
      elseif(KEY.EQ.'DM') then
        dm_flag = .true.
        goto 10
      elseif(KEY.EQ.'DM2') then
        dm_flag = .true.
        dm_model_flag = .true.
        goto 10
      elseif(KEY.EQ.'DMBL') then
        dm_d_blur = fvalue(2)
        itok = 1
        goto 10
      elseif(key.eq.'KILL') then
         if(ntok.le.1) then
            kill_signal_flag = .FALSE.
            kill_signal_file = ' '
         else
            kill_signal_flag = .TRUE.
            kill_signal_file = line(ibeg(2):iend(2))
         endif
       ELSEIF(KEY.EQ.'DATA') THEN
C
C---Read information about datasets. 
        ITOK = 1
        IERROR = 0
        CALL DATASET_INFO(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &           CVALUE,IERROR)
        GOTO 10
       ELSEIF(KEY.EQ.'END') THEN
C       ICONTINUE = 0
        GOTO 999
       ELSEIF(KEY.EQ.'QUIT'.OR.KEY.EQ.'STOP') THEN
C       ICONTINUE = -1
        GOTO 999
       ELSEIF(KEY.EQ.'GO') THEN
C
C----If icontinue = 1 program will come back to this subroutine again
C----                 after perfomring given instructions
C----   icontinue = 0 program will finish its work after performing
C----                 given instructions
C----              -1 no instructions will be perfomed.
C
C        ICONTINUE = 1
         GOTO 999
      ELSE
        NUNREC = NUNREC + 1
        IF(NUNREC.GT.50)CALL ERRWRT(1,' It is not command file')
        CALL ERRWRT(0,'Unrecognized keyword: '//KEY)
        GOTO 10
      ENDIF
c
c----Normal return from subroutine RCARD. 
999   CONTINUE
      close(iscrk)
c
c---If gibbs sampling or something likes has been defined and no twin option is
c---defined then set twin_flag to true and rmerge_filer flag to 0
      if(gibbs_sample_flag.and..not.twin_flag) then
         rmerge_filter = 0.0
         twin_flag = .TRUE.
      endif
      if(mode.eq.'SFCA') then
         rmerge_filter  = 0.0
         twin_flag = .TRUE.
      endif

      call getenv('HKLIN',file_this)
c check given datasets/target - using DATA and/or F_i,SIGF_i keywords (general approach)
c if target not determined here than either no direct PPI is used (Rice/HL/PHIB+FOM) or 
c SAD/SIRAS target can be detected in MTZ_PARAMS if F+,F-,SIGF+,SIGF- has been set
      call check_datasets
      if(len_trim(file_this).le.0) then
        if(REFID.ne.'IDEA'.or.mode.ne.'HKRF') then
          CALL ERRWRT(0,'Reflections file has not been defined') 
          call errwrt(0,'Switching to the idealisation mode') 
        endif
        REFID = 'IDEA'
      elseif(refid.ne.'IDEA'.or.mode.ne.'HKRF') then
        IERROR = 0
        CALL MTZ_PARAMS(LABIN_SAVE,LABOUT_SAVE,IERROR)
        NERROR = NERROR + IERROR
      ENDIF
      if(refid.eq.'IDEA') twin_flag = .FALSE.
      CALL CHECK_ALL_PARAMS(IERROR)
      NERROR = NERROR + IERROR
      IF( NERROR .GT.50 )
     &   CALL ERRWRT(1,' Too many errors in input cards - '//
     &         'check messages above.')

      CALL REPORT_OPTIONS

      call getenv('XYZIN',input_pdb_file)
cd      CALL ERRWRT(1,'end of card')
      RETURN
      END
c
      subroutine set_datasets_for_target(target)
      use refi_flags
      character target*4
c
      if (target.eq.'sad'.or.target.eq.'sadh') then
          dataset_num_tot = 2
          dataset_wavenum_tot = 1
          dataset_wavenum(1) = 1
          dataset_wavenum(2) = 1
          dataset_dernum(2) = dataset_dernum(1)
          dataset_PM(1) = 1
          dataset_PM(2) = -1
      elseif (target.eq.'sras') then
          dataset_num_tot = 3
          dataset_wavenum_tot = 1
          dataset_wavenum(1) = 1
          dataset_wavenum(2) = 1
          dataset_wavenum(3) = 1
          dataset_dernum(2) = dataset_dernum(1)+1
          dataset_dernum(3) = dataset_dernum(2)
          dataset_PM(2) = 0
          dataset_PM(2) = 1
          dataset_PM(3) = -1
      elseif (target.eq.'sir'.or.target.eq.'p+l') then
          if (dataset_num_tot.ne.2) dataset_num_tot = 2
          if (dataset_dernum(1).eq.dataset_dernum(2)) then
            if (dataset_dernum(1).le.0) dataset_dernum(1) = 1
            dataset_dernum(2) = dataset_dernum(1)+1
          endif
          if (dataset_PM(1).ne.0.or.dataset_PM(2).ne.0) then
            dataset_PM(1) = 0
            dataset_PM(2) = 0
          endif
          dataset_wavenum_tot = 1
          dataset_wavenum(1) = 1
          dataset_wavenum(2) = 1
      elseif ( target.eq.'no' .or. target.eq.'hldm' ) then
      else 
          call ERRWRT(1,'The specified target '//target//' is not '//
     &  	   'supported or recognized.')
      endif
      return
      end
c
      subroutine check_datasets
      use refi_flags
C---- check datasets
      IMPLICIT NONE
      INTEGER IERROR
      include 'atom_com.fh'
      INCLUDE 'anom.fh'
c
      INTEGER IP,actdernum,change,IP2
      LOGICAL ERROR
      character target*4
c
      actdernum = 0
c if info not given
      do IP=1,dataset_num_tot
        if ( dataset_dernum(IP).eq.-10 )  then
          dataset_dernum(IP) = actdernum
        else
          actdernum = dataset_dernum(IP)
        endif
        if ( dataset_PM(IP).eq.-10 )  then
          dataset_PM(IP) = 0
        endif
        if ( dataset_wavenum(IP).eq.-10 )  then
          dataset_wavenum(IP) = 1
        endif
      enddo
      if (verbref_5n) then
        write(*,*)
        write(*,*)'The following information about datasets was found:'
        call report_dataset_info
      endif
c
C automatic determination of target based on the given information about datasets
c attention: the datasets can be given in any order 
c the dataset_order array will contain the assignment to default order for every experiment ( dataset_order(default_i)=given_j )
      call autodetect_target(target)
      if ( PPI.eq.'auto' ) then 
        if (target.eq.'????') then
c I could change this to use just that data for which the target is available later?
          call ERRWRT(1,'The target for given datasets is not '//
     &    'available. Please check the latest version of program '//
     &    'or adjust the datasets info given by DATA keywords.')
        else if (target.eq.'mras') then
          call ERRWRT(1,'The MIRAS datasets were supplied but the '//
     &    'MIRAS target is not available. ')
        else
          PPI = target
        endif
      else
c use default datasets info if given info does not correspond to required target
c ie if target was specified but not detected from the datasets info
        if ( PPI.ne.target ) then
          call set_datasets_for_target(PPI)
c for SAD, SIR or SIRAS, just warning is printed and default order assumed
c          write(*,*)'WARNING: The supplied information about dataset'//
          call ERRWRT(0,'The supplied information about dataset types'//
     &       ' (if any) does not match the specified target '//PPI//
     &       '. The following assumptions will be used :')
          call report_dataset_info
        endif
      endif
      return
      end
C
      SUBROUTINE CHECK_ALL_PARAMS(IERROR)
      use weights
      use agreem
      use ncs_rest
      use CellAndSymmetry
      use refi_flags
      use mtz_things
C
C---checks all input parameters and tries to make them consistent and 
c---conflict free
      IMPLICIT NONE
      INTEGER IERROR
      INCLUDE 'atom_com.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'anom.fh'
      INCLUDE 'const.fh'
      include 'twin_refmac.fh'
      include 'occupancy_params.fh'

      integer i,j,k
      integer ifatal_err,ierr
      character line_loc*512
      CHARACTER FILE_NAME_HERE*256
      REAL RSSCMN,RSSCMX
      INTEGER IP,II,HMAX,KMAX,LMAX,L_F,actdernum,change,IP2
      LOGICAL ERROR,LEXISTS
      character target*4
      INTEGER omp_get_max_threads
c
      character text_loc
      character str*7
      real rot_l(3,3),tr_l(3)
C
C---Change mode and REFID to make consistent with further works
      ifatal_err = 0
      IERROR = 0
      IF(REFID.EQ.'RIGI') MODE = 'RIGI'
      IF(REFID.EQ.'TLSR') MODE = 'TLSR'
      IF(MODE.EQ.'TLSR'.AND.NTLS_CYCLE.LE.0) NTLS_CYCLE = 20
      IF(MODE.EQ.'RIGI') REFID = 'UNRE'
      IF(MODE.EQ.'TLSR') REFID = 'UNRE'
      if(REFID.EQ.'OCCU') MODE = 'OCCU'
      !if(MODE.eq.'RAND') refid = 'IDEA'
      IF(MODE.EQ.'NEWE') THEN
        REFID = 'IDEA'
        MAKE_HFLAG_O = 'Y'
      ENDIF
      IF(REFID.EQ.'IDEA') THEN
        REFUSE = .FALSE.
cd        IF(MAKE_CHECK.NE.'Y') MAKE_CHECK = '0'
      ENDIF
      IF(WEIGHT.EQ.' ') WEIGHT = 'AUTO'
cd      IF(REFID.EQ.'UNRE') ITEMP = 0
c
c---If maximum likelihood then use normalisation.
      IF(REFS.EQ.'MLKF') THEN
        LNORMAL  = .TRUE.
        NRESIOPT = 1
        NSIGOPT  = 1
      ENDIF        
c
c---Estimate maximum number of possible reflections. This estimate gives
C---upper limit.
      IF(REFUSE) THEN
C   Find a reasonable upper limit for number of reflections to include.
        REsmin = 0.5/STLMIN
        REsmax = 0.5/STLMAX
        HMAX = INT(CELL(1)/RESMAX)
        KMAX = INT(CELL(2)/RESMAX)
        LMAX = INT(CELL(3)/RESMAX)
C        SZ = INT(1.2*(2+HMAX)*(2+KMAX)*(2+LMAX)*2*3.20/(3*NSYM))
         CALL FIND_CENTR_SYM(NumSymmetry,MaxSym,RealSymmMatrx,
     +     IFACTOR_CC,ERROR)
        NOBS = IFACTOR_CC*
     +      INT(1.2*(1.0+REAL(HMAX))*(1.0+REAL(KMAX))*
     *         (1.0+REAL(LMAX))*2*3.20/(3.0*REAL(NSYM)))
      ENDIF
C
c---find number of partial structures
      NSCPART = 0
      IF(FPART_FLAG) THEN
        DO    IP=1,NMAXPART
           IF(ISCPART(IP).EQ.1) NSCPART = NSCPART + 1
        ENDDO
      ENDIF
C
      RSSCMN = 0.5/SMINS
      RSSCMX = 0.5/SMAXS
C----Change default damping factor if they have not been set specifacly
      IF(.NOT.DAMP_FLAG) THEN
C
C----Change damping factors if resolution is less than 2.5
cd        IF( RSSCMX .GT. 2.5) THEN
cd          PDAMP = 0.5
cd          BDAMP = 0.5
cd        ENDIF
C
C----Change damping factor for unrestrained but not rigid body refinement
cd        IF(REFID.EQ.'UNRE'.AND.MODE.NE.'RIGI') THEN
cd          PDAMP = 0.3
cd          BDAMP = 0.3
cd        ENDIF
      END IF
C
      NDOMAIN = 0
      DO   II=1,MAXDOMAIN
        IF(IDOMAIN_PIECES(II).GT.0) NDOMAIN = NDOMAIN+1
      ENDDO
C
C----NCS restraints here
C
C---Tls parameters should be read if number of cycles has not been defined
      TLS_FILE_FLAG = .FALSE.
      IF(NTLS_CYCLE.GT.0) THEN
        TLS_FILE_FLAG = .TRUE.
      ELSE
        CALL GETENV('TLSIN',FILE_NAME_HERE)
        IF(len_trim(file_name_here).LE.0) THEN
          TLS_FILE_FLAG = .FALSE.
        ELSE
          IF(trim(FILE_NAME_HERE).NE.'TLSIN') THEN
            INQUIRE(FILE=FILE_NAME_HERE,EXIST=LEXISTS)
            IF(LEXISTS) TLS_FILE_FLAG = .TRUE.
          ENDIF
        ENDIF
      ENDIF
C
c
      if (PPI.ne.'no'.and.PPI.ne.'hldm'.and.(phase_flag.or.mir_flag)) 
     &then
        call errwrt(0,'The target for direct use of prior phases '//
     +    'cannot be combined with other indirect source of prior '//
     +    'phases at the moment - only the direct target will be used')
        phase_flag = .false.
        mir_flag = .false.
      endif
      if (PPI.eq.'sad'.or.PPI.eq.'sadh'.or.PPI.eq.'sir'.or.PPI.eq.'p+l')
     &then
        heavy_sf_model_num = 1
      elseif (PPI.eq.'sras') then
        heavy_sf_model_num = 2
      elseif (PPI.eq.'mad') then
c can be 4 if there is no external heavy atom input file
        heavy_sf_model_num = 5
      elseif (PPI.eq.'no'.or.PPI.eq.'hldm') then
        heavy_sf_model_num = 0        
      else
        call errwrt(1,'The specified target is currently not supported')
      endif
      if (PPI.eq.'sras'.or.PPI.eq.'mad') then
        if ( .not.der2der1_flag.or..not.derD2der1_flag.or.
     +       .not.der2heavyder1_flag ) then
c          call errwrt(-1,'(Some) second derivatives not supported for '//
c     +     'SIRAS or MAD - using first derivatives ')
          if (PPI.ne.'sras') der2der1_flag = .true.
c          der2der1_flag = .true.
          derD2der1_flag = .true.
        endif        
      endif
c
      IF (PPI.ne.'no') THEN
c this seems to be better in practice if not using XNON NO
c however using XNON NO is best!
        if (XNONDIAG_FLAG.neqv..FALSE.) then
          der2equal_flag = .true.
          freeDref_flag = .false.
        endif
      ENDIF      
c sign_calc = 2 seems to be better for SIRAS and sign_calc for sad (?)
      IF (PPI.eq.'sad') sigN_calc = 1
      IF (PPI.eq.'sir') sigN_calc = 1
c      IF (PPI.eq.'sir') sigP_calc = 1
c      IF (PPI.eq.'sras') sigN_calc = 1
c      IF (PPI.eq.'sras') sigP_calc = 1
      if (PPI.eq.'p+l') sigN_calc = 1
      if (PPI.eq.'p+l') sigP_calc = 1
c--- rewriting the information from character PPI to logical DPPI's to save time 
c--- (see remark about this somewhere below - this should be temporary solution, 
c--- only logical PPI's should be used later )
      if (PPI.ne.'no') then
        DPPI_no = .false.
        if (PPI.eq.'sad')   DPPI_sad  = .true.
        if (PPI.eq.'sadh')  DPPI_sadh = .true.
        if (PPI.eq.'sir')   DPPI_sir  = .true.
        if (PPI.eq.'p+l')   DPPI_pl   = .true.
        if (PPI.eq.'mldr')  DPPI_mldr = .true.
        if (PPI.eq.'sras')  DPPI_sras = .true.
        if (PPI.eq.'mad')   DPPI_mad  = .true.
        if (PPI.eq.'hldm')  DPPI_hldm = .true.
      endif
      if (dm_flag) mlusework=.true.
c in phasing we start by refining occupancies only
      if (substruct_flag.and..not.dm_flag) exclude_occ_b=.true.
C
c--- allowing occupancies of anomalous atoms to be refined for anomalous targets
      if ( (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad) .and.
     &     .not.OCCUP_set_by_user_FLAG ) then
        OCCUP_REF_FLAG = .true.
        OCCUP_REF_ANOMONLY_FLAG = .true.
      endif
c--- set phout if phcomb or hlicomb exists in labout. 
c--- this is just a hack in order to keep compatibility with some older versions...
      if (.not.out_distrib_flag) then
        do i=1,len_trim(labout_save)
          str=labout_save(i:i+5)
          if ( str.eq.'phcomb'.or.str.eq.'PHCOMB'.or.
     &         str.eq.'hlacom'.or.str.eq.'HLACOM' ) then
            out_distrib_flag = .true.
            oc_PHCOMB%use = .true.
            oc_HLACOMB%use = .true.
            oc_HLBCOMB%use = .true.
            oc_HLCCOMB%use = .true.
            oc_HLDCOMB%use = .true.
          endif
        enddo
      endif
c
c---Make sure ncs restraint instructions are correct
      if(number_ncsr.gt.0) then
         do  i=1,number_ncsr
            if(ncs_equiv_num(i).le.0) then
               call errwrt(-1,'Number of equivalent groups for ncs id '
     &              //ncs_ids(i)//' is 0')
               ifatal_err = ifatal_err + 1
            endif
            if(ncs_chain_num(i).le.0) then
               call errwrt(-1,'Number of chains in the ncs group '//
     &              ncs_ids(i)//' is 0')
               ifatal_err = ifatal_err + 1
            endif
            do j=1,ncs_equiv_num(i)
               do k=1,ncs_chain_num(i)
                  if(ncs_equiv_ch(k,j,i).eq.' ') then
                     call errwrt(-1,'Problem with ncs definitions')
                     write(line_loc,'(a,i3,a,i3,a)')
     &                    'In ncs id: '//ncs_ids(i)//
     &                    ' in the equivalent group ',j,
     &                    ' chain number ',k,
     &                    ' is empty.'
                     call errwrt(-1,line_loc)
                     ifatal_err = ifatal_err + 1
                  endif
               enddo
            enddo
         enddo
      endif
c
c--   If twin then prepare operators etc.
c      write(*,*)'Before twin prepare'
      call twin_prepare(ierr)
c      write(*,*)'After twin prepare'
      ifatal_err = ifatal_err + ierr

      if(ifatal_err.gt.0) then
         call errwrt(1,'Problem in some of the instructions')
      endif
      RETURN
      END
C
c detects the target based on the info about datasets and 
c gives the link to the default order for given target via dataset_order
      subroutine autodetect_target(target)
      use refi_flags
      implicit none
      integer i,j,nat,der_F1,der_F2,new_der
      integer wave1_F1,wave1_F2,wave2_F1,wave2_F2,new_wave
      character target*4
      target = '????'
      do i=1,MAX_DATASETS
        dataset_order(i)=i
      enddo
c count the number of different derivatives and wavelengths
      dataset_dernum_tot = 0
      dataset_wavenum_tot = 0
      do i=1,dataset_num_tot
        new_der=1
        new_wave=1
        do j=1,i-1
          if (dataset_dernum(i).eq.dataset_dernum(j)) new_der=0
          if (dataset_wavenum(i).eq.dataset_wavenum(j)) new_wave=0
        enddo
        if (new_der.eq.1) dataset_dernum_tot=dataset_dernum_tot+1
        if (new_wave.eq.1) dataset_wavenum_tot=dataset_wavenum_tot+1
      enddo          
      if ( dataset_num_tot.ge.2 ) then
        if (dataset_num_tot.eq.2) then
c SIR detection
          if (dataset_dernum(1).ne.dataset_dernum(2)) then
            target = 'sir'
            if (dataset_dernum(1).gt.dataset_dernum(2)) then
              dataset_order(1)=2
              dataset_order(2)=1
            endif
c SAD detection
          else if (dataset_dernum(1).eq.dataset_dernum(2).and.
     &             dataset_PM(1).ne.dataset_PM(2).and.
     &             dataset_PM(1).ne.0.and.dataset_PM(2).ne.0) then
            target = 'sad'
            if (dataset_PM(1).lt.0) then
              dataset_order(1)=2
              dataset_order(2)=1
            endif
          endif
        else if (dataset_num_tot.eq.3) then
c SIRAS and 2-deriv. MIR with one AS detection (at the moment, the latter one has no working target!)
          if (dataset_dernum_tot.eq.2) then
            if (dataset_dernum(1).eq.dataset_dernum(2)) then 
              der_F1=1
              der_F2=2
              nat = 3
            else if (dataset_dernum(1).eq.dataset_dernum(3)) then
              der_F1=1
              der_F2=3
              nat = 2
            else if (dataset_dernum(2).eq.dataset_dernum(3)) then
              der_F1=2
              der_F2=3
              nat = 1
            endif
            if (dataset_PM(der_F1).ne.dataset_PM(der_F2).and.
     &          dataset_PM(der_F1).ne.0.and.dataset_PM(der_F2).ne.0)then
              if (dataset_dernum(nat).eq.0) then
                target = 'sras'
              else
c MIRAS not working at the moment!
                target = 'mras'
              endif
              dataset_order(1)=nat
              if (dataset_PM(der_F1).lt.0) then 
                dataset_order(2)=der_F2
                dataset_order(3)=der_F1
              else
                dataset_order(2)=der_F1
                dataset_order(3)=der_F2
              endif
            endif
          endif
        else if (dataset_num_tot.eq.4) then
c MAD detection (no other targets using 4 datasets are either detected or supported at the moment)
          if (dataset_wavenum_tot.eq.2) then
            wave1_F1=1
            wave2_F1=0
            if (dataset_wavenum(1).eq.dataset_wavenum(2).and.
     &          dataset_wavenum(3).eq.dataset_wavenum(4)) then 
              wave1_F2=2
              wave2_F1=3
              wave2_F2=4
            else if (dataset_wavenum(1).eq.dataset_wavenum(3).and.
     &               dataset_wavenum(2).eq.dataset_wavenum(4)) then 
              wave1_F2=3
              wave2_F1=2
              wave2_F2=4
            else if (dataset_wavenum(1).eq.dataset_wavenum(4).and.
     &               dataset_wavenum(2).eq.dataset_wavenum(3)) then 
              wave1_F2=4
              wave2_F1=2
              wave2_F2=3
            endif
            if (dataset_PM(wave1_F1).ne.dataset_PM(wave1_F2).and.
     &          dataset_PM(wave2_F1).ne.dataset_PM(wave2_F2).and.
     &          dataset_PM(wave1_F1).ne.0.and.dataset_PM(wave1_F2).ne.0
     &     .and.dataset_PM(wave2_F1).ne.0.and.dataset_PM(wave2_F2).ne.0
     &          .and.wave2_F1.ne.0 ) then
              target = 'mad'
              if (dataset_PM(wave1_F1).lt.0) then 
                dataset_order(1)=wave1_F2
                dataset_order(2)=wave1_F1
              else
                dataset_order(1)=wave1_F1
                dataset_order(2)=wave1_F2
              endif
              if (dataset_PM(wave2_F1).lt.0) then 
                dataset_order(3)=wave2_F2
                dataset_order(4)=wave2_F1
              else
                dataset_order(3)=wave2_F1
                dataset_order(4)=wave2_F2
              endif
            endif
          endif
        endif
      else
        target = 'no'
      endif      
      end
C
      subroutine report_dataset_info
      use refi_flags
      character tempinfo*5
c      
      if (dataset_num_tot.eq.0) write(*,*) 'No information.'
      do IP=1,dataset_num_tot
        if ( dataset_PM(IP).lt.0 ) then 
          tempinfo = 'minus'
        elseif ( dataset_PM(IP).gt.0 ) then 
          tempinfo = 'plus'
        else
          tempinfo = 'mean'
        endif
        write(*,*) 'dataset',IP,' : ','der.number ',dataset_dernum(IP),
     +             ', ',tempinfo
      enddo      
      return
      end
C
C
      SUBROUTINE DEFLTS
      use weights
      use agreem
      use solvent_all
      use restr_files
      use ncs_rest
      use CellAndSymmetry
      use refi_flags
c
c---Subroutine ofr assigning default values for some parameters of refinement
      INCLUDE 'atom_com.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'expcost.fh'
      INCLUDE 'occupancy_params.fh'
      INCLUDE 'restr_params.fh'
      INCLUDE 'anom.fh'
      include 'twin_refmac.fh'
C
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
c
      integer i,j,k,is

C
C---Some initialisation

c---  path for temporary files
      call getenv('SCRREF',scratch_files)
      if(len_trim(scratch_files).le.0) then
         call getenv('TEMP1',scratch_files)
      endif
      if(len_trim(scratch_files).le.0) scratch_files='local_ref'
      epsch1 = 0.1
      epscomp = 1.0e-32
      ftol    = 1.0e-8
      gold = (sqrt(5.0)+1)/2
      cgold = 2.0-gold
      zeps  = 1.0e-10
      tol = 1.0e-8
      do i=1,6
         cell(i) = 0.0
      enddo
      do i=1,3
         do j=1,3
            ror(i,j) = 0.0
            rfr(i,j) = 0.0
         enddo
      enddo
      do is=1,maxsym
         do i=1,3
            do j=1,3
               rot(i,j,is) = 0.0
               rotr(i,j,is) = 0.0
            enddo
            tr(i,is) = 0.0
         enddo
      enddo
      
      PID    = ATAN2(1.0,1.0)*4.0
      PIDSQ  = PID*PID
      PIDSQ4 = PIDSQ*4.0
      PIDSQ8 = PIDSQ*8.0
      TWOPID = PID*2.0
      FOURPID = PID*4.0
C
C---Constants. Single precision
      PI     = ATAN2(1.0,1.0)*4.0
      PISQ   = PI*PI
      PISQ4  = PISQ*4.0
      PISQ8  = PISQ*8.0
      TWOPI  = PI*2.0
      TWOPI_INV  = 1/TWOPI
      FOURPI = PI*4.0   
      RTODEG = 180.0/PI
      DEGTOR = PI/180.0
C
C---Shannon factor. I.e. how much more grid extra spacing is needed.
C---1.3 means 50% more than Niquist spacing
      FSHANN = 1.5
C
C----Default refinement type
      REFUSE = .TRUE.
      CRDUSE = .TRUE.
      REFTYP = 'MTZ '
      CRDTYP = 'PDB '
C
C---Radii for modelling of atomic density for electron density
C---gradient and second derivative calculations
      DDLIM = 5.0
      DGLIM = 5.0
      DHLIM = 8.0      
C
C  Default P1 symmetry
      LTYPE = 'P'
      SpaceGroupName = 'P1'
      PointGroupName = 'PG1'
      ISPNO = 0
      NumSpaceGroup = 1
      NSYM = 1
      NPSYM = 1
      NumSymmetry = 1
      NumPrimSymm = 1
      DO    I=1,3
        DO    J=1,3
          ROT(I,J,1)            = 0.0
          RealSymmMatrx(I,J,1)  = 0.0
          RealSYMMRFT(I,J,1)    = 0.0
          RecipSymmMatrx(I,J,1) = 0.0
        ENDDO
        ROT(I,I,1)            = 1.0
        RealSymmMatrx(I,I,1)  = 1.0
        RealSYMMRFT(I,I,1)    = 1.0
        RecipSymmMatrx(I,I,1) = 1.0
C
        RecipSymmMatrx(I,4,1) = 0.0
        RealSymmMatrx(I,4,1)  = 0.0
        RealSYMMRFT(I,4,1)    = 0.0
        RecipSymmMatrx(4,I,1) = 0.0
        RealSymmMatrx(4,I,1)  = 0.0
        RealSYMMRFT(4,I,1)    = 0.0
        TR(I,1)               = 0.0
      ENDDO
      NX   = 0
      NY   = 0
      NZ   = 0
C
C
C----Default sort order for HKLOUT
      ISORT(1) = 1
      ISORT(2) = 2
      ISORT(3) = 3
      ISORT(4) = 0
      ISORT(5) = 0
c
c-----Mode of action
      MODE         = 'HKRF'
      ITEMP        = 1
      ICCUP        = 0
      bref_type = 'ISOT'
      uval_estim_flag = .FALSE.
      NANISO_ATOMS = 0
C
c--Convergence
      EPS_CONV_X = 0.000001
      EPS_CONV_B = 0.000001
C
c--Shifts
      DAMP_FLAG         = .FALSE.
      PDAMP             = 1.0
      BDAMP             = 1.0
      QDAMP             = 1.0
      BResetMin         = 2.0/PISQ8
      BResetMax         = 500.0/PISQ8
      BSET_DEFAULT_FLAG = .FALSE.
      UDefault_Ind      = 0.25
C
C------Number of cycles and so on
      NCYCCG         = 50
      NCYCLE_OVERALL = 0 
      NCCREF         = 5
      NCYC_set_by_user_flag = .false.
      NONSYM         = 2
C
C---Refinement style
      REFID  = 'REST'
      refmac_tests = 'NONE'

      vdw_write_flag = .FALSE.
      bint   = 'STL2'
      IANISB = 0
      NBIN   = 20
      RANGE  = -1.0
c
c---Monitoring
      MON_STYLE = 'MEDI'
      TORCUT   = 10.0 
      CHICUT   = 10.0 
      DSCUT    = 10.0
      ANGLCUT  = 10.0
      PLCUT    = 10.0
      BADVDW   = 10.0
      BFAC_CUT = 10.0
      RBON_CUT = 10.0
      BSPH_CUT = 10.0
      NCSR_CUT = 20.0
      BAD_CONT =  1.0
      badint   = 10.0

C
C---Weights for structure factor terms
      KFWGT = 1 
      WEIGHT = 'AUTO'
      weight_adjust = 'YES'
      WEIGHTXMAT = 0.5
C>IJT Allow WEIGHT AUTO to specify weight parameter (default = 10).
      WEIGHTAUTO = 10.0
      zb_mx      = 0.9
      zb_mn      = 0.6
      zb_reduce  = 0.8
      zb_increase= 1.2
C<IJT

C
C---Weights for torsion angles
      WTSKAL  = 1.00
      SIGT(1) = 15.0
      SIGT(2) = 5.0
      SIGT(3) = 10.00
      SIGT(4) = 20.00
C
C---Weights for distances
      WDSKAL   = 1.00
      w_gm_in  = -1.0
      sd_ext_min = 0.01
      sd_ext_cut = 50.0
      delta_ext = 1.5
      dmax_ext  = 4.5
      dmin_ext  = 2.6
      wdskal2  = 1.0
      SIGD(1)  = 0.02
      SIGD(2)  = 0.04
      SIGD(3)  = 0.05
      SIGD(4)  = 0.050
      SIGD(5)  = 0.020
      SIGD(6)  = 0.020
      SIGD(7)  = 0.020
C
c---Weight for angle restraints
      WASKAL   = 1.0
C
c----Weights for b-factors
      WBSKAL   = 1.00
      SIGB(1)  = 1.50
      SIGB(2)  = 2.00
      SIGB(3)  = 3.00
      SIGB(4)  = 4.50
      SIGB(5)  = 6.000
      SIGB(6)  = 2.0
      SIGB(7)  = 2.00
      SIGB(8)  = 0.00

      sigb_kl(1) = 0.1
      sigb_kl(2) = 0.15
      sigb_kl(3) = 0.3
      sigb_kl(4) = 1.0

      sigr_kl(1) = 0.1
      sigr_kl(2) = 0.3
      sigr_kl(3) = 0.5
      sigr_kl(4) = 0.7
C
C---Some other default restraint parameters
C
      NCIS_TRANS_RES = 0
      NCHIR_REPLACE  = 0
C
C---Weights for sphericity of aniso U values
      SIGSPH   = 5.0
C
C---Weights on rigid bond
      SIG_RIGID_B = 3.0
      WBS_RIGID_B = 1.0
C
C---Weights for Planes
      WPSKAL = 1.00
C
C---Weights for Chirality
      WCSKAL = 1.00
C
C---Weights for Vdw
      WVSKAL          = 1.00
      VDW_SDI_VDW     = 0.2
      VDW_SDI_TORSION = 0.2
      VDW_SDI_HBOND   = 0.2
      VDW_SDI_METAL   = 0.2
      HBOND_DINC_AD   = -0.3
      HBOND_DINC_AH   = 0.1
      DINC_TORSION    = -0.3
      DINC_TORSION_O  = -0.1
      DINC_TORSION_N  = -0.1
      DINC_TORSION_C  = -0.15
      DINC_TORSION_ALL= -0.15
      DINC_DUMMY      = -0.7
      VDW_SDI_DUMMY   = 0.3
      DVDW_CUT_MIN    = 1.75
      DVDW_CUT_MIN_X  = 1.75
C
C---Weight on positions
      PDEL   = 0.00
      BDEL   = 0.000
      QDEL   = 0.000
c
C---Weights for NCS
      WSSKAL  = 1.000
      SIGS(1) = 0.050
      SIGS(2) = 0.500
      SIGS(3) = 5.000
      SIGS(4) = 0.500
      SIGS(5) = 2.000
      SIGS(6) = 10.000
      ncsr_use = 'H'
      do  i=1,max_ncs
         sigx_ncs(i) = 0.05
         sigb_ncs(i) = 0.5
         do  j=1,max_ncs_span
            ncs_icode(j,i) = 1
            ncs_equiv_res(1,j,i)=-99999
            ncs_equiv_res(2,j,i)= 99999
         enddo
      enddo
      sigx_ncs_local = 0.05
      dmax_ncs_local = 4.2
      diffmax_ncs_local = 1.0
      ncsr_flag = .FALSE.
      ncsr_level = 0.8
      align_rms_level = 2.0
      gm_ncsr_simil_param = 1.0e-1
      align_iter_flag = 'N'
      ncsr_neigb_include = 'N'
C
C---Some more restraint info. Info for restrainable torsions
      N_RESTRAIN_TORS = 10
      RES_NAME_TORS_RESTR(1) = '.'
      GROUP_NAME_TORS_RESTR(1) = 'L-peptid'
      LINK_NAME_TORS_RESTR(1)  = '.'
      RES_NAME_TORS_NAME(1)    = 'chi1'
      RES_NAME_TORS_PERIOD(1)  = -1
      RES_NAME_TORS_VALUE(1)   = -1.0E32
      RES_NAME_TORS_SIGMA(1)   = -0.1

      RES_NAME_TORS_RESTR(2) = '.'
      GROUP_NAME_TORS_RESTR(2) = 'L-peptid'
      LINK_NAME_TORS_RESTR(2)  = '.'
      RES_NAME_TORS_NAME(2)    = 'chi2'
      RES_NAME_TORS_PERIOD(2)  = -1
      RES_NAME_TORS_VALUE(2)   = -1.0E32
      RES_NAME_TORS_SIGMA(2)   = -0.1

      RES_NAME_TORS_RESTR(3) = '.'
      GROUP_NAME_TORS_RESTR(3) = 'L-peptid'
      LINK_NAME_TORS_RESTR(3)  = '.'
      RES_NAME_TORS_NAME(3)    = 'chi3'
      RES_NAME_TORS_PERIOD(3)  = -1
      RES_NAME_TORS_VALUE(3)   = -1.0E32
      RES_NAME_TORS_SIGMA(3)   = -0.1

      RES_NAME_TORS_RESTR(4) = '.'
      GROUP_NAME_TORS_RESTR(4) = 'L-peptid'
      LINK_NAME_TORS_RESTR(4)  = '.'
      RES_NAME_TORS_NAME(4)    = 'chi'
      RES_NAME_TORS_PERIOD(4)  = -1
      RES_NAME_TORS_VALUE(4)   = -1.0E32
      RES_NAME_TORS_SIGMA(4)   = -0.1

      RES_NAME_TORS_RESTR(5) = '.'
      GROUP_NAME_TORS_RESTR(5) = 'L-peptid'
      LINK_NAME_TORS_RESTR(5)  = '.'
      RES_NAME_TORS_NAME(5)    = 'chi4'
      RES_NAME_TORS_PERIOD(5)  = -1
      RES_NAME_TORS_VALUE(5)   = -1.0E32
      RES_NAME_TORS_SIGMA(5)   = -0.1

      RES_NAME_TORS_RESTR(6) = '.'
      GROUP_NAME_TORS_RESTR(6) = 'L-peptid'
      LINK_NAME_TORS_RESTR(6)  = '.'
      RES_NAME_TORS_NAME(6)    = 'chi5'
      RES_NAME_TORS_PERIOD(6)  = -1
      RES_NAME_TORS_VALUE(6)   = -1.0E32
      RES_NAME_TORS_SIGMA(6)   = -0.1

      RES_NAME_TORS_RESTR(7) = '.'
      GROUP_NAME_TORS_RESTR(7) = '.'
      LINK_NAME_TORS_RESTR(7)  = 'TRANS'
      RES_NAME_TORS_NAME(7)    = 'omega'
      RES_NAME_TORS_PERIOD(7)  = -1
      RES_NAME_TORS_VALUE(7)   = -1.0E32
      RES_NAME_TORS_SIGMA(7)   = -0.1

      RES_NAME_TORS_RESTR(8) = '.'
      GROUP_NAME_TORS_RESTR(8) = '.'
      LINK_NAME_TORS_RESTR(8)  = 'PTRANS'
      RES_NAME_TORS_NAME(8)    = 'omega'
      RES_NAME_TORS_PERIOD(8)  = -1
      RES_NAME_TORS_VALUE(8)   = -1.0E32
      RES_NAME_TORS_SIGMA(8)   = -0.1

      RES_NAME_TORS_RESTR(9) = '.'
      GROUP_NAME_TORS_RESTR(9) = '.'
      LINK_NAME_TORS_RESTR(9)  = 'CIS'
      RES_NAME_TORS_NAME(9)    = 'omega'
      RES_NAME_TORS_PERIOD(9)  = -1
      RES_NAME_TORS_VALUE(9)   = -1.0E32
      RES_NAME_TORS_SIGMA(9)   = -0.1

      RES_NAME_TORS_RESTR(10) = '.'
      GROUP_NAME_TORS_RESTR(10) = '.'
      LINK_NAME_TORS_RESTR(10)  = 'PCIS'
      RES_NAME_TORS_NAME(10)    = 'omega'
      RES_NAME_TORS_PERIOD(10)  = -1
      RES_NAME_TORS_VALUE(10)   = -1.0E32
      RES_NAME_TORS_SIGMA(10)   = -0.1

      DO   I=11,NMAX_RESTRAIN_TORS
        RES_NAME_TORS_RESTR(I)   = '.'
        GROUP_NAME_TORS_RESTR(I) = '.'
        RES_NAME_TORS_NAME(I)    = '.'
        RES_NAME_TORS_PERIOD(I)  = -1
        RES_NAME_TORS_VALUE(I)   = -0.1
        RES_NAME_TORS_SIGMA(I)   = -0.1
      ENDDO
C
      N_RESTRAIN_TORS_E = 3
      RES_NAME_TORS_RESTR_E(1) = 'PRO'
      GROUP_NAME_TORS_RESTR_E(1) = '.'
      LINK_NAME_TORS_RESTR_E(1)  = '.'
      RES_NAME_TORS_NAME_E(1)    = 'chi1'

      RES_NAME_TORS_RESTR_E(2) = 'PRO'
      GROUP_NAME_TORS_RESTR_E(2) = '.'
      LINK_NAME_TORS_RESTR_E(2)  = '.'
      RES_NAME_TORS_NAME_E(2)    = 'chi2'

      RES_NAME_TORS_RESTR_E(3) = 'PRO'
      GROUP_NAME_TORS_RESTR_E(3) = '.'
      LINK_NAME_TORS_RESTR_E(3)  = '.'
      RES_NAME_TORS_NAME_E(3)    = 'chi3'
C
C---Exclude some residues (PRO) from the restraint list.
      NUMBER_NCSR = 0
      ncs_inst_option = '?'
      ncsr_use        = 'H'
      do  i=1,number_ncsr
         ncs_point_group(i) = ' '
         ncs_ids(i)        = ' '
         ncs_complete(i)   = ' '
         ncs_equiv_num(i)  = 0
         ncs_chain_num(i)  = 0
         sigx_ncs(i)       = 0.05
         sigb_ncs(i)       = 0.5
         do  j=1,max_ncs_span
            ncs_equiv_res(1,j,i) = -9999
            ncs_equiv_res(2,j,i) =  9999
            do  k=1,max_ncs_chain
               ncs_equiv_ch(k,j,i)    = ' '
            enddo
         enddo
      enddo
C
C---CIF 
      CIFOUT = 'NONE'
C
C---Channel numbers
      ISYSR = 5
      ISYSW = 6
      IFOFC = 0
      IATMR = 0
Cejd - IDISK not used ICNTS not set - change ICNTS to IDISK?
      IDISK = 0
      JDISK = 0 
      NEWFIL= 0 
      INXYZ = 0 
      IOUTX = 0 
      ISCRF = 0 
      MTZIN = 1
C dataset and wavelelngth initializing
      dataset_num_tot = 0
      dataset_dernum_tot = 0
      nform_ano = 0
      do i=1,maxwavel
        wavelength(i) = -1.
      enddo
C
C---LS scaling. Set initial values and flags for scale parameters
      SCALE_LS_OVER         = 1.0
      scale_ls_init         = 1.0
      SCALE_Llh_OVER        = 1.0
      B_LS_OVER             = 0.0
      B_LS_OVER_FLAG        = .TRUE.
      B_LS_OVER_REFINE_FLAG = .TRUE.
      ALL_SCALES_FLAG       = .TRUE.
      LS_SCALE_FLAG         = .TRUE.
      ML_SCALE_FLAG         = .TRUE.
      DO   IAN=1,6
        B_LS_ANISO_OVER(IAN) = 0.0
      ENDDO
      DO    IAN=1,6
        DO   IAN1 = 1,6
          EIGEN_ANISO(IAN,IAN1) = 0.0
          IF(IAN.EQ.IAN1) EIGEN_ANISO(IAN,IAN) = 1.0
        ENDDO
      ENDDO
      B_LS_ANISO_OVER_FLAG        = .TRUE.
      B_LS_ANISO_OVER_REFINE_FLAG = .TRUE.
      BULK_LS_FLAG                = .FALSE.
      B_LS_BULK_REFINE_FLAG       = .TRUE.
      B_LS_BULK                   = 200.0
      SCALE_LS_BULK_REFINE_FLAG   = .TRUE.
      SCALE_LS_BULK               = 0.75
      DO   IP=1,NMAXPART
        B_LS_PART_REFINE_FLAG(IP)     = .TRUE.
        B_LS_PART(IP)                 = 100.0
        SCALE_LS_PART_REFINE_FLAG(IP) = .TRUE.
        SCALE_LS_PART(IP)             = 0.3
      ENDDO
C
      BINSCALE = 0

      NGRCYCL     = 5 
      NPARCYCL    = 4
C
C---ML scale parameters
      D_ML_SCALE_OVER = 1.0
      D_ML_B_OVER     = 0.0
      D_ML_SCALE_BBULK = 0.0
      D_ML_B_BBULK     = 100.0
      ML_BULK_REFINE_FLAG = .TRUE.
      DO   I=1,NMAXPART
        D_ML_SCALE_PART(I) = 1.0
        D_ML_B_PART(I)     = 70.0
        ML_PART_REFINE_FLAG(I) = .TRUE.
      ENDDO
      SIGMA_ML_SCALE_OVER = 1.0
      SIGMA_ML_B_OVER     = 40.0
      SIGMA_ML_SCALE_BBULK = 0.4
      SIGMA_ML_B_BBULK     = 100.0
      ML_SIGMA_BULK_REFINE_FLAG = .TRUE.
        
C  Set ISCPART(i) = 0; ie Add all partial terms to FC before scaling
      DO I = 1,NMAXPART
       ISCPART(I) = 0
      ENDDO 
C  Set free R exclusion flag
      LFreeRexcludeVal   = -999
C
C----Default refinement flags
      XNONDIAG_FLAG  = .FALSE.
      OCCUP_REF_FLAG = .false.
      occup_refine_flag = .FALSE.
      OCCUP_REF_ANOMONLY_FLAG = .false.
      OCCUP_set_by_user_FLAG = .false.
      OCCUP_ref_anom_type_num = 0
      separate_anom_occ = .false.
      POS_REF_FLAG   = .TRUE.
c      EXCLUDE_OCC_B  = .TRUE.
      EXCLUDE_OCC_B  = .false.
      NCYCLE_OCC     = 2
      ncycle_occup = 1
      DIS_FLAG   = .TRUE.
      ANGL_FLAG  = .TRUE.
      PLANE_FLAG = .TRUE.
      VDW_FLAG   = .TRUE.
      TOR_FLAG   = .TRUE.
      SYM_FLAG   = .TRUE.
      CHI_FLAG   = .TRUE.
      B_FLAG1    = .TRUE.
      GRADC      = .TRUE.
      HCALC      = .TRUE.
      FREER_FLAG = .FALSE.
      FPART_FLAG = .FALSE.
      MIR_FLAG   = .FALSE.
      PHASE_FLAG = .FALSE.
      fomap_flag = .FALSE.
      obsd_flag  = .FALSE.
      map_extend_flag = .FALSE.
      out_distrib_flag = .false.
      intens_flag = .FALSE.
      PHASE_SIGMAA_FLAG = .FALSE.
      HREF_FPP_FLAG = .FALSE.
      derD2der1_flag = .false.
      der2der1_flag = .false.
ccc!!!      der2equal_flag = .true.
      der2equal_flag = .false.
      der2heavyder1_flag = .true.
      freeDref_flag = .true.
      read_anom_occ_flag = .false.
      read_luzzd_flag = .false.
      write_luzzd_flag = .false.
C the sigN_calc, sigP_calc values specify how is the cov. matrix calculated - especially the primed terms,ie 
c terms which carry the "essential info" (EI = anomalous f'' info for SAD/MAD/SIRAS, heavy atom info for SIR/SIRAS)
c 0=calculation of EI from atomic parameters, the same EI assumed for both calculated and observed terms (used in BP3)
c 1=calculation of EI as difference between <F1*F1> and <F1*F2*cos(pi-pj)>, where F's are calculated/observed 
c     and cos is always calculated
c 2=calculation of EI as difference between <F1*F1> and <F1*F2*cos(pi-pj)> for calculated terms 
c     and the same EI assumed also for observed terms 
c 3=the EI for observed is neglected completely, ie just <F1*F2> is used
c sigN is different for 0-3, for sigP 1-3 is the same (ie just 0-1 options for sigP)
      sigN_calc = 0
      sigP_calc = 0
c      sigN_calc = 2
c      sigP_calc = 0
      dm_d_blur = 1.
      dm_flag = .false.
      dm_model_flag = .false.
      substruct_flag = .false.
      substruct_determine = .true.
      anom_maponly_flag = .false.
      VERBREF_5N = .false.
      fomap_file = ' '
      interval_file = ' '
      harmonic_file = ' '
      input_orig_data = ' '
      PHAS_BLUR_SCAL  = 1.0
      PHAS_BLUR_BVAL  = 0.0
      NTRIGINC        = 12
      NINTEGRSTEP     = 360
      ARGMAX          = 59.0
C
      LEXPUSE     = .TRUE.
      LSEXPUSE    = .FALSE.
      MLEXPUSE    = .TRUE.
c
      vdwr_exclude_flag = .FALSE.

C
C---Residual is amplitude based LS
      LREFIN = .TRUE.
      REFS = 'MLKF'
      PPI = 'no'
c---The PPI string variable should be replaced by logical variables below because
c---it turned out that comparison of PPI strings inside the deepest loops may be very
c---time-consuming (at least with gfortran it really is unbelievably time-consuming)
c---Only replaced it inside important loops so far, the rest can be done later, more 
c---important things have to be done here in York now...
      DPPI_no = .true.
      DPPI_sad = .false.
      DPPI_sadh = .false.
      DPPI_sir = .false.
      DPPI_pl = .false.
      DPPI_mldr = .false.
      DPPI_sras = .false.
      DPPI_hldm = .false.
      DPPI_mad = .false.
      DPPI_wsad_hack = .false.
      LNORMAL = .FALSE.
      NPART   = 0
      NPARTALL = 0
      NSCPART = 0
      NOBS    = 0
      LSTAT = .TRUE.
      LSUSEWORK = .TRUE.
      MLUSEWORK = .FALSE.
      LINIT     = .FALSE.
      MLINIT    = .FALSE.
      NLSCYCL   = 50
      NMLCYCL   = 10
      NRESIOPT = 1
      NSCOPT   = 1
      NSIGOPT  = 0
C
C----Scling type. Aniso or iso
      IMLSCALTYPOV = 0
      ILSSCALTYPOV = 0
      MLSCALTYPE = 'ISOTR'
      LSSCALTYPE = 'ISOTR'
      DO     I=1,NMAXPART
        IMLSCALTYP(I) = 0
        ILSCALTYP(I)  = 0
      ENDDO
      DO     I=1,NMAXPAR
        ILSFIX(I) = 0
        IMLFIX(I) = 0
      ENDDO
      LSSCFIX = .FALSE.
      LSBFIX  = .FALSE.
      MLSCFIX = .FALSE.
      MLBFIX  = .FALSE.
      BLS_DEFINED  = 200.0
      SCLS_DEFINED = -0.3
      BML_DEFINED  = 150.0
      SCML_DEFINED = -0.3
      BAVER_MOLEC  = -100.0
      UAVER_MOLEC  = BAVER_MOLEC/PISQ8
C
C---Minimization method
      SOLVMIN = 'CGMAT'
c      SOLVMIN = 'CGMA'
      NESTIM  = 1
      STLMIN = 0.0000001
      STLMAX = 10.0
      SMINS = 0.04
      SMAXS = 1.0
C
C--Aniso scaling. Apply to calculated (default)
      APPLY_SCALE_TO = 'CALC'
C
C---Rigid body defaults
      DO    IDOMAIN=1,MAXDOMAIN
        IDOMAIN_PIECES(IDOMAIN) = 0
        DO   IPIECE=1,MAXPIECES
          IDOMAIN_CHN(IPIECE,IDOMAIN)    = ' '
          IDOMAIN_FROM(IPIECE,IDOMAIN) = -1
          IDOMAIN_TO(IPIECE,IDOMAIN)   = -1
        ENDDO
        DO  IX=1,3
          TRANS_INIT_RIGID(IX,IDOMAIN) = 0.0
          EULER_INIT_RIGID(IX,IDOMAIN) = 0.0 
        ENDDO
        EXCLUDE_DOMAIN(IDOMAIN) = 'NONE'
      ENDDO
      NDOMAIN      = 1
      NRIGID_CYCLE = 20
      EULER_PRINT_RIGID  = .TRUE.
      MATRIX_PRINT_RIGID = .TRUE. 
      POLAR_PRINT_RIGID  = .TRUE. 
      rigid_auto = .TRUE.
C
C---TLS defaults
      DO    ITLSGRP=1,MAXTLSGRP
        ITLSGRP_PIECES(ITLSGRP) = 0
        TLSGRP_TITLE(ITLSGRP)    = 'From REFMAC'
        DO   IPIECE=1,MAXPIECES_TLS
          TLSGRP_CHN(IPIECE,ITLSGRP)    = ' '
          ITLSGRP_FROM(IPIECE,ITLSGRP) = -1
          ITLSGRP_TO(IPIECE,ITLSGRP)   = -1
          DO ISEL = 1,MAXSELECT
            TLSGRP_SELECT(ISEL,IPIECE,ITLSGRP) = ' '
          ENDDO
        ENDDO
      ENDDO

      NTLSGRP    = 0
      NTLS_CYCLE = 0
      PRINT_TLSPARS  = .TRUE.
      TLS_FILE_FLAG  = .FALSE.
      TLS_ADD_ATOMS  = .FALSE.
      waters2tls     = 'EXC'
C
C---Map parameters
      !FREE_FOR_MAP = 'R'
      !scale_map_calc = 0.0
      !scale_map_obs  = 0.0
      !b_sharp_map    = 0.0
      !alpha_sharp_map = 0.0
      !sharp_regul_opt = .TRUE.
      !sharp_map_flag  = .FALSE.
C
C---Parameters for makecif
      MAKE_HFLAG         = 'A'
      MAKE_HFLAG_O       = 'N'
      MAKE_RFLAG         = 'N'
      MAKE_LNK_FLAG      = 'N'
      MAKE_CHECK_SPEC    = 'N'
      MAKE_FORM          = 'U'
      MAKE_PEPT_FLAG     = 'N'
      MAKE_CONN_FLAG     = 'N'
      MAKE_SYMM_FLAG     = 'Y'
      MAKE_CHAIN_FLAG    = 'N'
      MAKE_SS_FLAG       = 'Y'
      MAKE_CIS_FLAG      = 'Y'
      MAKE_SUGAR_FLAG    = 'S'
      MAKE_EXIT          = 'N'
      MAKE_CHECK         = 'N'
      MAKE_LIGAND_LEVEL_FLAG = 'H'
      MAKE_NEWL_VALUE_FLAG   = 'N'
      MAKE_NEW_FLAG      = 'N'
      MAKE_SRCH_FLAG     = 'N'
      make_segid_in_flag = 'N'
      make_segid_out_flag= 'N'
      MAKE_LIBS_PATH     = ' '
      MAKE_LIBS_NAME     = ' '
      MAKE_LIBS_EXT      = ' '
      MAKE_PROG_LIB_PATH = ' '
      MAKE_OUT_FILE      = ' '
      MAKE_FILE_LIB2     = ' '
      MAKE_CUTOFF        = 0.0
      MAKE_DMIN_SPEC     = 0.3
C
C---Hydrogen refinement parameters
      HYDROGEN_REFINE_FLAG = .FALSE.
      HYDROGEN_BVALUE      = 'ANIS'
C
c---File names
      STRUCT_FILE    = ' '
      COORD_FILE     = ' '
      RESTRAINT_FILE = ' '
      BOND_FILE      = ' '
      ANGLE_FILE     = ' '
      VDW_FILE       = ' '
      CHIR_FILE      = ' '
      TORS_FILE      = ' '
      NCSR_FILE_NAME = ' '
      ncs_simil_file = ' '
      NCSC_FILE_NAME = ' '
      PLANE_FILE     = ' '
      refl_file      = ' '
      refl_asym      = ' '
      fobs_appr_file = ' '
      all_pairs_file = ' '
      abcd_file      = ' '
      all_contacts_file = ' '
C
c--exclusions
      excl_refi_flag = .FALSE.
      excl_refi_num  = 0
c
c--occupancy parameters
      natom_occup_refine = 0
      occup_ref_atoms = 'ALL'
      
      atom_sigma(1:maxatom) = 0.0
c
c---Sharpen the data before refinement
c
      scale_sharp    = 1.0
      b_sharp_refine = 0.0
c
c
c---  Twin things
      twin_flag = .FALSE.
      twin_reindex_transform = 'N'
      itw_count = 0
      ntwin_domain = 1
      twin_frac(1) = 1.0
      twin_oper(1:3,1:3,1) = 0
      twin_score(1)  = 0.0
      twin_oper(1,1,1) = 12
      twin_oper(2,2,1) = 12
      twin_oper(3,3,1) = 12
      small_twin_frac  = 0.07
      twin_toler       = 5.0
      rmerge_filter    = 0.44
      twin_frac_set = .FALSE.
      twin_oper_set = .FALSE.
      twin_user_flag = .FALSE.
      twin_ls_scale_init = .FALSE.
      twin_frac(1:maxtwin) = 0.0
      twin_refine_func = 'DTML'
c
c---  Parameters for randomised refinement
      nrandom_cycle = 0
      rshift_max    = 0.0
      rand_extend   = 1.0
      rand_ref_flag = .FALSE.
      gibbs_sample_flag = .FALSE.
      zbond_exit = .FALSE.
      zbond_limit = 0.0
c
c-- input/output pdb formats
      pdb_out_format = ' '
      pdb_in_format = ' '
      RETURN
      END
C
      SUBROUTINE TKNONCUB
      use CellAndSymmetry
      implicit none
C
C---Takes from symmetry operators noncubic ones and
C---assigns to ROTR,TRR
      integer i,j,is
C---
C
      NonCubSym = 0
      Nsmult = NumSymmetry/NumPrimSymm
      DO    IS=1,NumSymmetry
        IF(ABS(RealSymmMatrx(3,3,IS)).EQ.1.0 .AND. 
     +         RealSymmMatrx(3,1,IS).EQ.0.0  .AND. 
     +         RealSymmMatrx(3,2,IS).EQ.0.0) THEN
          NonCubSym = NonCubSym + 1
          DO   I=1,3
            DO    J=1,3
              ROTR(I,J,NonCubSym) = RealSymmMatrx(I,J,IS)
            ENDDO
            TRR(I,NonCubSym) = RealSymmMatrx(I,4,IS)
          ENDDO
        ENDIF
      ENDDO
      NonCubPrim = NonCubSym/Nsmult
      RETURN
      END

      SUBROUTINE REPORT_OPTIONS
      use weights
      use agreem
      use ridge
      use solvent_all
      use ncs_rest
      use dnarna
      use map_routines
      use CellAndSymmetry
      use refi_flags
      use signals_refmac
      implicit none
C
C---Reports current parameters of refinement
C
      INCLUDE 'rigid_body.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'anom.fh'
      include 'twin_refmac.fh'

      integer ll,ll_max
      INTEGER  HMAX,KMAX,LMAX
      integer isysr,isysw,ifofc,iscrf,iatmr,idisk,jdisk,newfil,
     &     inxyz,ioutx
      integer mtzin
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,mtzin

      REAL CELL_REPORT(6)
      LOGICAL ERROR,LEXISTS
      CHARACTER LINE*512,ALL_CHAINS*120,FILE_NAME_HERE*128,
     &         DICT_PATH*250
c
      real rot_l(3,3),tr_l(3)
      character text_loc*256
      integer i,ii,iii,in,incs,ip,j
      real rsscmn,rsscmx
cpjx  Don't use temp_makecif_path.fh - it's not portable!
cpjx      INCLUDE 'temp_makecif_path.fh'      
C
C--Start reporting
C
      CALL HEADER('Input and Default parameters#')
      CALL ERRWRT(-1,' ')
      CALL GETENV('XYZIN',FILE_NAME_HERE)
      IF(FILE_NAME_HERE(1:1).NE.' ') THEN
      WRITE(LINE,'(A)')'Input coordinate file.  Logical name - XYZIN'//
     & ' actual file name  - '//trim(FILE_NAME_HERE)
      ELSE
      WRITE(LINE,'(A)')'Input coordinate file.  Logical name - XYZIN'//
     & ' actual file name  - XYZIN'
      ENDIF
      CALL ERRWRT(-1,LINE)

      CALL GETENV('XYZOUT',FILE_NAME_HERE)
      IF(FILE_NAME_HERE.EQ.' ') FILE_NAME_HERE = 'XYZOUT'
      WRITE(LINE,'(A)')'Output coordinate file. Logical name - XYZOUT'//
     &  ' actual file name - '//trim(FILE_NAME_HERE)
      CALL ERRWRT(-1,LINE)
      IF(REFUSE) THEN
        CALL  GETENV('HKLIN',FILE_NAME_HERE)
        IF(FILE_NAME_HERE(1:1).NE.' ') THEN
          WRITE(LINE,'(A)')
     &                 'Input reflection file.  Logical name - HKLIN'//
     & ' actual file name  - '//trim(FILE_NAME_HERE)
        ELSE
          WRITE(LINE,'(A)') '==> WARNING:  HKLIN has not been defined'
        ENDIF
        CALL ERRWRT(-1,LINE)
        CALL  GETENV('HKLOUT',FILE_NAME_HERE)
        IF(FILE_NAME_HERE.EQ.' ') FILE_NAME_HERE = 'HKLOUT'
        WRITE(LINE,'(A)')
     &                 'Output reflection file. Logical name - HKLOUT'//
     &  ' actual file name - '//trim(FILE_NAME_HERE)
        CALL ERRWRT(-1,LINE)
        CELL_REPORT(1) = CELL(1)
        CELL_REPORT(2) = CELL(2)
        CELL_REPORT(3) = CELL(3)
        CELL_REPORT(4) = CELL(4)
        CELL_REPORT(5) = CELL(5)
        CELL_REPORT(6) = CELL(6)
       
        IF(CELL(4).LE.5.0.OR.CELL(5).LE.5.0
     &                    .OR.CELL(6).LE.5.0) THEN
          CELL_REPORT(4) = CELL(4)/DEGTOR
          CELL_REPORT(5) = CELL(5)/DEGTOR
          CELL_REPORT(6) = CELL(6)/DEGTOR
        ENDIF
        CALL ERRWRT(-1,' ')
        WRITE(LINE,'(A,6F10.3)')'Cell from mtz :',CELL_REPORT
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,I4,A,A)')'Space group from mtz:'//
     &                                     ' number - ',NumSpaceGroup,
     &                                     '; name - ',SpaceGroupName
        CALL ERRWRT(-1,LINE)
      ENDIF
C
C--Find file names and print them out.
      CALL ERRWRT(-1,' ')
      IF(REFID.EQ.'REST') WRITE(LINE,'(A)')
     +        '  Refinement type                        : Restrained'
      IF(REFID.EQ.'UNRE') WRITE(LINE,'(A)')
     +        '  Refinement type                        : Unrestrained'
      IF(REFID.EQ.'IDEA')THEN
        REFUSE = .FALSE.
        ITEMP  = 0
        WRITE(LINE,'(A)')
     +        '  Refinement type                        : Idealisation'
      ENDIF
      IF(MODE.EQ.'RIGI') WRITE(LINE,'(A)')
     +        '  Refinement type                        : Rigid Body'
      IF(MODE.EQ.'TLSR') WRITE(LINE,'(A)')
     +        '  Refinement type                        : TLS'
      if(mode.eq.'SFCA')  WRITE(LINE,'(A)')
     +        '  Refinement type                        : NONE'
      CALL ERRWRT(-1,LINE)
      CALL ERRWRT(-1,' ')
C
      IF(BSET_DEFAULT_FLAG) THEN
        CALL ERRWRT(-1,' ')
        WRITE(LINE,'(A,F10.3)')'Initial B values of all atoms '//
     &             'will be set to ',UDefault_Ind*PISQ8
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(-1,' ')
      ENDIF
      IF(REFID.NE.'UNRE') THEN
C
C--Makecif parameters
      CALL HEADER('Makecif parameters')
      call getenv('LIB_BALBES',DICT_PATH)
      if(dict_path.eq.' ') CALL GETENV('CLIBD_MON',DICT_PATH)
      IF(DICT_PATH.EQ.' ') CALL GETENV('CDIC_REFMAC',DICT_PATH)
      IF(DICT_PATH.NE.' ') THEN
        INQUIRE (FILE=trim(DICT_PATH)//'ener_lib.cif', EXIST=LEXISTS)
        IF(.NOT.LEXISTS) THEN
          CALL ERRWRT(-1,' ')
          CALL ERRWRT(-1,'Dictionary path has not been defined')
          CALL ERRWRT(-1,'Check the environment variable CLIBD_MON')
          CALL ERRWRT(-1,'Current value of CLIBD_MON is '//DICT_PATH)
          CALL ERRWRT(-1,'It should be set to wherever_dict/dic/')
          CALL ERRWRT(1,'Wrong path for the dictionary files')
        ENDIF
        CALL ERRWRT(-1,'Dictionary files for restraints : '//
     &                trim(DICT_PATH)//'mon*cif')
        CALL ERRWRT(-1,'Parameters for new entry and VDW: '//
     &          trim(DICT_PATH)//'ener_lib.cif')
        if(len_trim(file_basepairs_dict).gt.0.or.
     &     len_trim(user_basepair_file).gt.0) then
           call header('Basepair files')
           if(len_trim(file_basepairs_dict).gt.0) then
              call errwrt(-1,'Standard basepairs file    : '//
     &             trim(file_basepairs_dict))
           endif
           if(len_trim(user_basepair_file).gt.0) then
              call errwrt(-1,'User defined basepairs file: '//
     &             trim(user_basepair_file))
           endif
           write(*,*)
        endif

      ELSE
cpjx  MAKECIFLIB would be set in temp_makecif_path.fh
cpjx  but this is unsafe e.g. portability problems.
cpjx        CALL ERRWRT(-1,'Dictionary files for restraints : '//
cpjx     &                trim(MAKECIFLIB)//'mon*cif')
cpjx        CALL ERRWRT(-1,'Parameters for new entry and VDW: '//
cpjx     &          trim(MAKECIFLIB)//'ener_lib.cif')
cpjx    Fail if the dictionary path isn't set
        CALL errwrt(1,'No path for dictionary files!')
      ENDIF
C
      CALL GETENV('LIBIN',MAKE_FILE_LIB2)
      IF(MAKE_FILE_LIB2.EQ.' ') CALL GETENV('LIB_IN',MAKE_FILE_LIB2)
        IF(MAKE_FILE_LIB2.NE.' ') THEN
C
C---Check if it is a file
          INQUIRE (FILE=MAKE_FILE_LIB2,EXIST=LEXISTS)
          IF(LEXISTS) THEN
            CALL ERRWRT(-1,'User supplied dictionary entries: '//
     &         trim(MAKE_FILE_LIB2))
          ELSE
            CALL ERRWRT(0,
     &        'LIBIN has been defined but it is not a file')
            MAKE_FILE_LIB2 = ' '
          ENDIF
        ENDIF
        IF(MAKE_CHECK.EQ.'Y') THEN
          CALL ERRWRT(-1,
     &    '    Program will check all entries against dictionary')
        ELSEIF(MAKE_CHECK.EQ.'0') THEN
          CALL ERRWRT(-1,
     &  '    Program will rely on residue and atom names. No checking')
          CALL ERRWRT(-1,
     &  '    If this option is used then monomers should be checked'
     &  //' carefully before using')
        ELSEIF(MAKE_CHECK.EQ.'N') THEN
          CALL ERRWRT(-1,
     &  '    Apart from amino acids and DNA/RNA all monomers will be '
     &  //'checked to see if atom names and connectivity is correct')
        ENDIF

        IF(MAKE_HFLAG.EQ.'A') THEN 
          CALL ERRWRT(-1,
     &    '    Hydrogens will be restored in their riding positions')
        ELSEIF(MAKE_HFLAG.EQ.'Y') THEN
          CALL ERRWRT(-1,
     &    '    Hydrogens in input coordinate file will be kept')
        ELSEIF(MAKE_HFLAG.EQ.'N') THEN
          CALL ERRWRT(-1,
     &    '    Hydrogens will not be written to the output file')
        ENDIF
        IF(MAKE_HFLAG_O.EQ.'Y') THEN
          CALL ERRWRT(-1,
     &    '    hydrogens will be written to the output file')
        ENDIF
        IF(MAKE_RFLAG.EQ.'Y') 
     &    CALL ERRWRT(-1,
     &    '    Missing atoms will be restored')
        IF(MAKE_CHECK_SPEC.EQ.'Y')  THEN
          CALL ERRWRT(-1,
     &    '    Atoms in special positions will be treated')
          WRITE(LINE,'(A,F10.3)')
     &    '    Minimum distance for special position crieteria ',
     &         MAKE_DMIN_SPEC
          CALL ERRWRT(-1,LINE)
        ENDIF
        IF(MAKE_PEPT_FLAG.EQ.'Y') 
     &    CALL ERRWRT(-1,
     &    '    L-D peptides will be checked and corrected')
        IF(MAKE_LNK_FLAG.EQ.'Y'.OR.MAKE_LNK_FLAG.EQ.'D') THEN
         CALL ERRWRT(-1,
     &    '    Links between monomers will be checked and corrected')
        ELSE
         CALL ERRWRT(-1,
     &    '    Links between monomers will be checked. Only those links'
     &     //' present in the coordinate file will be used')
        ENDIF
        IF(MAKE_SUGAR_FLAG.EQ.'Y') THEN
         CALL ERRWRT(-1,
     &    '    All links to sugar will be analysed and used')
        ELSEIF(MAKE_SUGAR_FLAG.EQ.'S') THEN
         CALL ERRWRT(-1,
     &    '    Standard sugar links will be analysed and used')
        ELSEIF(MAKE_SUGAR_FLAG.EQ.'N') THEN
         CALL ERRWRT(-1,
     &    '    Sugar links present in the input file will used')
        ELSEIF(MAKE_SUGAR_FLAG.EQ.'D') THEN
         CALL ERRWRT(-1,
     &    '    Sugar links in the input file will be ignored. '
     &    //'Coordinates will be analysed for sugar links and'
     &    //' used if found')
        ENDIF
        IF(MAKE_NEWL_VALUE_FLAG.EQ.'Y') THEN
         CALL ERRWRT(-1,
     &    '    For new ligands "ideal restraint" value will be taken'
     &    //' the input coordinates')
        ELSE
         CALL ERRWRT(-1,
     &    '    For new ligands "ideal restraint" values will be taken'
     &    //' from the energetic libary ener_lib.cif')
        ENDIF        
        IF(MAKE_CONN_FLAG.EQ.'Y') THEN
        
        ELSE

        ENDIF
        IF(MAKE_SYMM_FLAG.EQ.'Y') THEN
          CALL ERRWRT(-1,
     & '    Symmetry related links will be analysed and used')
        ELSE
          CALL ERRWRT(-1,
     & '    Symmetry related links will not be analysed') 
        ENDIF
        IF(MAKE_CHAIN_FLAG.EQ.'Y') THEN
        ELSE
        ENDIF
        IF(MAKE_CIS_FLAG.EQ.'Y') THEN
          CALL ERRWRT(-1,
     &    '    Cis peptides will be found and used automatically')
        ELSE 
          CALL ERRWRT(-1,
     &    '    Cis peptides will be found and used if they are present'
     &    //' in the  coordinate file')
        ENDIF

        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' ')
      ENDIF
c
C---Solvent parameters
      IF(SOLVENT_FLAG) THEN

      ENDIF
C  List rigid bodies:
      IF(MODE.EQ.'RIGI') THEN
        CALL HEADER('Domain Definition')
        IF(NDOMAIN.LE.0) THEN
          WRITE(LINE,'(A)')'  No domains have been defined. '
     &          //'All atoms will be refined as one rigid body'
          CALL ERRWRT(-1,LINE)
        ELSE
          DO II = 1,NDOMAIN
            WRITE(LINE,'(A,I4,A,I4)')'  Group:',II, 
     +        ':    No. of pieces:',IDOMAIN_PIECES(II)
            CALL ERRWRT(-1,LINE)
            DO III = 1,IDOMAIN_PIECES(II)
              IF( EXCLUDE_DOMAIN(II) .EQ. 'NONE')
     +        WRITE(LINE,'(A,A,A,2I5,A)') ' Chain:  ',
     &            IDOMAIN_CHN(iii,ii),
     +            ' Span:',IDOMAIN_FROM(III,II),IDOMAIN_TO(III,II),
     +            ' ** All atoms **'
              IF( EXCLUDE_DOMAIN(II) .EQ. 'SCHA')
     +        WRITE(LINE,'(A,A,A,2I5,A)') ' Chain:  ',
     &              IDOMAIN_CHN(iii,ii),
     +             ' Span:',IDOMAIN_FROM(III,II),IDOMAIN_TO(III,II) ,
     +             ' ** Mainchain only **'
              IF( EXCLUDE_DOMAIN(II) .EQ. 'MCHA')
     +          WRITE(LINE,'(A,A,A,2I5,A)') ' Chain:  ',
     &              IDOMAIN_CHN(iii,ii),
     +              ' Span:',IDOMAIN_FROM(III,II),IDOMAIN_TO(III,II) ,
     +             ' ** Sidechain only **'
                CALL ERRWRT(-1,LINE)
            ENDDO
            CALL ERRWRT(-1,' ')
          ENDDO
        END IF
      END IF
C
      IF(REFID.NE.'IDEA') THEN
        IF(REFS.EQ.'LSQF') WRITE(LINE,'(A)')
     +'  Residual                               : Least Squares for Fs'
        IF(REFS.EQ.'LSQI') WRITE(LINE,'(A)')
     +'  Residual                               : Least Squares for Is'
        if(REFS.eq.'MLKF'.and.PPI.eq.'sad') then
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' SAD Direct Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
        else if(REFS.eq.'MLKF'.and.PPI.eq.'sadh') then
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' SAD(H) Direct Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
        else if(REFS.eq.'MLKF'.and.PPI.eq.'sir') then
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' SIR Direct Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
        else if(REFS.eq.'MLKF'.and.PPI.eq.'p+l') then
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' Protein&Ligand Direct Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
        else if(REFS.eq.'MLKF'.and.PPI.eq.'sras') then
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' SIRAS Direct Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
        else if(REFS.eq.'MLKF'.and.PPI.eq.'hldm') then
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' Phase modified Maximum Likelihood with DM model for Fs'
           CALL ERRWRT(-1,LINE)
        else if(REFS.eq.'MLKF'.and.PPI.eq.'mad') then
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' MAD Direct Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
        else IF(REFS.EQ.'MLKF'.AND. .NOT. (MIR_FLAG.OR.PHASE_FLAG)) THEN
        WRITE(LINE,'(A,A)')'  Residual                               :',
     +     ' Rice Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
        ELSE IF(REFS.EQ.'MLKF'.AND.(MIR_FLAG .OR. PHASE_FLAG) ) THEN
        WRITE(LINE,'(A,A)')
     &'  Residual                               :',
     +' Phase modified Maximum Likelihood for Fs'
           CALL ERRWRT(-1,LINE)
           WRITE(LINE,'(A,2F8.2)')
     +' Phase Blurred by  Scale*Exp(-B s**2)    :',
     +     PHAS_BLUR_SCAL,PHAS_BLUR_BVAL
          CALL ERRWRT(-1,LINE)
        ENDIF
        CALL HEADER('Least-square scaling parameters')
        CALL ERRWRT(-1,'Overall scale')
        IF(B_LS_OVER_FLAG) CALL ERRWRT(-1,'Overall B value')
        IF(B_LS_ANISO_OVER_FLAG) 
     &     CALL ERRWRT(-1,'Overall anisotropic B with tr(B) = 0.0')
        IF(BULK_LS_FLAG) CALL ERRWRT(-1,'Bulk solvent based on'//
     &                   ' Babinet"s principle')
        IF(SOLVENT_FLAG) THEN
          CALL ERRWRT(-1,'Constant bulk solvent in non protein region')
          WRITE(LINE,'(A,F8.3)')'Probe radii for non-ions  ',PROB_VDW
          CALL ERRWRT(-1,LINE)
          WRITE(LINE,'(A,F8.3)')'Probe radii for ions      ',PROB_ION
          CALL ERRWRT(-1,LINE)
           WRITE(LINE,'(A,F8.3)')'Shrinkage of the mask  by ',
     &                         RADII_SHRINK
          CALL ERRWRT(-1,LINE)         
        ENDIF
        if (dm_flag) then
          call errwrt(-1,
     & 'External model (eg from dm) will be used for phase combination')
        endif
        CALL ERRWRT(-1,' ')
        call header('Map sharpening parameters and methods')
        if(.not.sharp_map_flag) then
           call errwrt(-1,'No map sharpening will be performed')
           write(*,*)
        else
           write(*,'(a,i1)')'Map sharpening option :',sharp_map_options
           write(*,'(a,a)')'Option 1: ',
     &     'Minimise 0.5sum(|K(s)F_0-F|^2 + 0.5alpha|s|^2|F_0|^2)'
           write(*,'(a,a)')'Option 2: ',
     &     'Minimise 0.5sum(K(s)F_{0}^2   + 0.5alpha|s|^2|F_0|^2)'
           write(*,'(a,a)')'Option 3: ',
     &     'Minimise 0.5sum(|K(s)F_0-F|^2 + 0.5alpha|F_0|^2)'
           write(*,'(a,a)')'Option 4: ',
     &     'Minimise 0.5sum(|K(s)F_0-F|^2 + 0.5alpha(1_+|s|^2)|F_0|^2)'
           write(*,*)
           write(*,'(a,a1)')'Map sharpening method :',sharp_map_method
           write(*,'(a,a)')'Method I: ',
     &          'Integrate over alpha and B '
           write(*,'(a,a)')'Method S: ',
     &          'Calculate map sharpening for single alpha and B'
           write(*,*)
           write(*,*)
           write(*,*)'B value for sharpening   ',b_sharp_map
           write(*,'(a,a)')'If B value is non-positive then it is ',
     &          ' caculated using coordinates'
           write(*,*)
           write(*,*)'Regularusation parameter ',alpha_sharp_map
           write(*,'(a,a)')'If alpha is non-positive then it is ',
     &          ' caculated using degrees of freedom'
           write(*,*)
           write(*,*)'Degrees of freedom       ',fraction_sharp_map
           write(*,*)'This parameter is used to calculate alpha'
           write(*,*)
           if(sharp_regul_opt) then
              write(*,*)'Optimise regularisation parameter '
           else
              write(*,*)'Regularisation parameter is given by user'
           endif
           write(*,*)
        endif
      ENDIF
C
      IF(MODE.EQ.'HKRF') THEN
        IF(SOLVMIN.EQ.'CGMA') WRITE(LINE,'(A)')
     +  '  Method of minimisation                 : Sparse Matrix '
        IF(SOLVMIN.EQ.'CGRA') WRITE(LINE,'(A)')
     +  '  Method of minimisation                 : Conjugate Gradient'
        IF(SOLVMIN.EQ.'CDIR') WRITE(LINE,'(A)')
     +  '  Method of minimisation                 : Conjugate Direction'
        CALL ERRWRT(-1,LINE)
      ENDIF
C
      IF( REFID.NE.'IDEA'.AND.LEXPUSE) THEN
        WRITE(LINE,'(A)')'  Experimental sigmas used for weighting'
        CALL ERRWRT(-1,LINE)
      END IF
C
      IF( REFID.NE.'IDEA' ) THEN
C   Find a reasonable upper limit for number of reflections to include.
        REsmin = 0.5/STLMIN
        REsmax = 0.5/STLMAX
        HMAX = INT(CELL(1)/RESMAX)
        KMAX = INT(CELL(2)/RESMAX)
        LMAX = INT(CELL(3)/RESMAX)
C        SZ = INT(1.2*(2+HMAX)*(2+KMAX)*(2+LMAX)*2*3.20/(3*NSYM))
         CALL FIND_CENTR_SYM(NumSymmetry,MaxSym,RealSymmMatrx,
     +     IFACTOR_CC,ERROR)
        NOBS = IFACTOR_CC*
     +      INT(1.2*(1.0+REAL(HMAX))*(1.0+REAL(KMAX))*
     &              (1.0+REAL(LMAX))*2*3.50/(3.0*REAL(NSYM)))

        IF( .NOT.LEXPUSE) THEN 
          WRITE(LINE,'(A)')
     +      '  Experimental sigmas not used for weighting:'
          CALL ERRWRT(-1,LINE)
        END IF
        WRITE(LINE,'(A,3X,I3,5x,F8.4)')
     +   '  Number of Bins and width:',NBIN, RANGE
        CALL ERRWRT(-1,LINE)
      ENDIF
      IF(MODE.EQ.'HKRF'.AND.REFID.NE.'IDEA') THEN
        IF(ITEMP.EQ.1.OR.ITEMP.EQ.-1)  WRITE(LINE,'(A)')
     +      '  Refinement of individual isotropic Bfactors'
        IF(ITEMP.EQ.2)  WRITE(LINE,'(A)')
     +      '  Refinement of individual anisotropic Bfactors'
        IF(ITEMP.EQ.0)  WRITE(LINE,'(A)')
     +      '  Refinement of one overall Bfactor'
        IF(ITEMP.EQ.3)  WRITE(LINE,'(A)')
     +      '  Refinement of mixed isotropic and anisotropic Bfactors'
        CALL ERRWRT(-1,LINE)
        REsmin = 0.5/STLMIN
        REsmax = 0.5/STLMAX
        WRITE(LINE,'(A,3x,2F8.4)')
     +   '  Refinement resln        :',ResMin,ResMax
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3X,I8)')
     +'  Estimated number of reflections :',NOBS
        CALL ERRWRT(-1,LINE)
        IF ( LFreeRexcludeVal .NE.-999) THEN
          WRITE(LINE,'(A,3X,I3)')
     +       '  Free R exclusion - flag equals:',LFreeRexcludeVal
          CALL ERRWRT(-1,LINE)
        END IF 
      END IF
C
      IF(MODE.EQ.'HKRF'.AND.REFID.NE.'IDEA') THEN
         IF(WEIGHT.EQ.'MATR') THEN
            WRITE(LINE,'(A)') 
     +          '  Weighting by comparison of trace of matrix'
         ELSEIF(WEIGHT.EQ.'AUTO') THEN
           WRITE(LINE,'(A)')'  Auto weighting. An attempt'
         ELSE
           WRITE(LINE,'(A)') '  Weighting by comparison of gradients'
         ENDIF
         CALL ERRWRT(-1,LINE)
         IF(WEIGHT.NE.'AUTO') THEN
           WRITE(LINE,'(A,3X,2F8.4)')
     +        '  Weighting parameters   :',WEIGHTXMAT
           CALL ERRWRT(-1,LINE)
         ENDIF
         WRITE(LINE,'(A,3X,I3)')
     +       '  Refinement cycles       :', NCCREF
         CALL ERRWRT(-1,LINE)
      ENDIF
      IF(REFID.NE.'IDEA') THEN
C
        WRITE(LINE,'(A)')'  Scaling type                           :'
         CALL ERRWRT(-1,LINE)
C
        IF(NSCOPT.EQ.0 ) WRITE(LINE,'(A)')
     +         '          Wilson using 1 Gaussian '
        IF(NSCOPT.EQ.1 ) WRITE(LINE,'(A)')
     +         '          Bulk solvent using using Babinet principle'
         CALL ERRWRT(-1,LINE)
c remove this completely???
c        IF(.NOT.LSUSEWORK .AND. LSEXPUSE) WRITE(LINE,'(A)')
c     +      '  using free set of reflns  and experimental sigmas'
c        IF(.NOT.LSUSEWORK .AND. .NOT.LSEXPUSE) WRITE(LINE,'(A)')
c     +      '  using free set of reflns  but not experimental sigmas'
c        IF(LSUSEWORK .AND. LSEXPUSE) WRITE(LINE,'(A)')
c     +      '  using working set of reflns and experimental sigmas'
c        IF(LSUSEWORK .AND. .NOT.LSEXPUSE) WRITE(LINE,'(A)')
c     +  '  using working set of reflns but not experimental sigmas'
c         CALL ERRWRT(-1,LINE)
      ENDIF
C

      CALL ERRWRT(-1,' ')
      IF(REFID.NE.'IDEA'.AND.REFS.EQ.'MLKF') THEN
        WRITE(LINE,'(A)')'  Estimation of D/Sigma in resolution bins '
         CALL ERRWRT(-1,LINE)
        IF(.NOT.MLUSEWORK .AND.MLEXPUSE ) WRITE(LINE,'(A)')
     +     '  using  free set of reflns with experimental sigmas'
        IF(.NOT.MLUSEWORK .AND..NOT. MLEXPUSE ) WRITE(LINE,'(A)')
     +     '  using  free set of reflns without experimental sigmas'
        IF(MLUSEWORK .AND.MLEXPUSE ) WRITE(LINE,'(A)')
     +     '  using  working set of reflns with experimental sigmas'
        IF(MLUSEWORK .AND..NOT. MLEXPUSE ) WRITE(LINE,'(A)')
     +     '  using  working set of reflns without experimental sigmas'
        CALL ERRWRT(-1,LINE)
      ENDIF
C
      IF(REFID.NE.'IDEA') THEN
        IF(.NOT. PHASE_SIGMAA_FLAG .AND.(MIR_FLAG.OR.PHASE_FLAG))
     +    WRITE(LINE,'(A)')
     +      '  Input phases not used in SigmaA estimation'
        IF( PHASE_SIGMAA_FLAG .AND.(MIR_FLAG.OR.PHASE_FLAG))
     +     WRITE(LINE,'(A)')
     +         '  Input phases used in SigmaA estimation'
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(-1,' ')
      ENDIF
      IF(NPART.GT.0.AND.REFID.NE.'IDEA') THEN
         WRITE(LINE,'(A,I4)')'  Number of external partial structures',
     +      NPART
         CALL ERRWRT(-1,LINE)
      ENDIF
      NSCPART = 0
      IF(FPART_FLAG.AND.REFID.NE.'IDEA') THEN
        DO    IP=1,NMAXPART
           IF(ISCPART(IP).EQ.1) NSCPART = NSCPART + 1
        ENDDO
      ENDIF
      IF(NSCPART.GT.0.AND.REFID.NE.'IDEA') THEN
         WRITE(LINE,'(A)')
     + ' Partial structures flagged 1 scaled independently from FC'
         CALL ERRWRT(-1,LINE)
      ENDIF
      IF(REFID.NE.'IDEA') THEN
        RSSCMN = 0.5/SMINS
        RSSCMX = 0.5/SMAXS
        WRITE(LINE,'(A,3X,2F8.4)')'  Scaling and SigmaA resln:',
     +         RSSCMN,RSSCMX
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(-1,' ')
      ENDIf
C---  Write out damping factors
C
      IF(MODE.EQ.'HKRF') THEN
        WRITE(LINE,'(A,3X,2F8.4)')'  Damping factors:',
     +   PDAMP,BDAMP
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(-1,' ')
      ENDIF
C---  Write out restraint information here.


C---- Geometrical Restraints + Temp + Occ
C
      IF(MODE.EQ.'HKRF'.AND.REFID.NE.'UNRE') THEN
        CALL HEADER('Geometry restraints and weights')
C
        CALL ERRWRT(-1,' ')
        WRITE(LINE,'(46X,A)')'Sigma:'
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(-1,' Bonding distances')
        WRITE(LINE,'(10X,A,F5.2)')'Weight = ',WDSKAL
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' Bond angles')
        WRITE(LINE,'(10X,A,F5.2)')'Weight = ',WASKAL
        CALL ERRWRT(-1,LINE)
C
        CALL ERRWRT(-1,' ')
        WRITE (ISYSW, '(A)')' Planar groups'
        WRITE(ISYSW, '(10X,A,F5.2)')'WEIGHT=',WPSKAL
C
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' Chiral centers')
        WRITE(LINE,'(10X,A,F5.2)')'Weight=', WCSKAL
        CALL ERRWRT(-1,LINE)
C
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' NON-BONDED CONTACTS')
        WRITE(LINE,'(10X,A,F5.2)')
     &    'Overall weight                          = ',WVSKAL
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2)')
     &    'Sigma for simple VDW                    = ',VDW_SDI_VDW
        CALL ERRWRT(-1,LINE)        
        WRITE(LINE,'(10X,A,F5.2)')
     &    'Sigma for VDW trhough torsion angle     = ',VDW_SDI_TORSION
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2)')
     &    'Sigma for HBOND                         = ',VDW_SDI_HBOND
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2)')
     &    'Sigma for metal-ion                     = ',VDW_SDI_METAL
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2)')
     &    'Sigma for DUMMY and other atom          = ',VDW_SDI_DUMMY
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2,A)')
     &    'Distance for donor-accepetor = vdw1+vdw2+(',HBOND_DINC_AD,')'
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2,A)')
     &    'Distance for acceptor - H    = vdw1+     (',HBOND_DINC_AH,')'
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2,A)')
     &    'VDW distance through torsion = vdw1+vdw2+(',DINC_TORSION,')'
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(10X,A,F5.2,A)')
     &    'Distance for DUMMY-others    = vdw1+vdw2+(',DINC_DUMMY,')'
        CALL ERRWRT(-1,LINE)
C
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' TORSION ANGLES')
        WRITE(LINE,'(10X,A,F5.2)')'Weight=',WTSKAL
        CALL ERRWRT(-1,LINE)
C
        IF (ITEMP.GT.0) THEN
          CALL ERRWRT(-1,' ')
          CALL ERRWRT(-1,' THERMAL FACTORS')
          WRITE(ISYSW,'(10X,A,F5.2)')'Weight=',WBSKAL
C>IJT Format: SIGB(i) may be < 0 now.
          WRITE(ISYSW,'(5X,A,T45,F5.1,A)')
     +      'Main chain bond (1-2 neighbour)',SIGB(1),'A**2'
          WRITE(ISYSW,'(5X,A,T45,F5.1,A)')
     +      'Main chain angle (1-3 neighbour)',SIGB(2),'A**2'
          WRITE(ISYSW,'(5X,A,T45,F5.1,A)')
     +      'Side chain bond',SIGB(3),'A**2'
          WRITE(ISYSW,'(5X,A,T45,F5.1,A)')
     +      'Side chain angle',SIGB(4),'A**2'
C<IJT
        END IF
C
c---  ncs parameters
        IF (NUMBER_NCSR.GT.0.AND.MODE.EQ.'HKRF') THEN
          CALL HEADER('NCS restraints parameters')
          CALL ERRWRT(-1,' ')
          WRITE(LINE,'(A,I5)')
     +     ' Number of different NCS restraints ',NUMBER_NCSR
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,' ')
          DO    INCS=1,NUMBER_NCSR
            WRITE(LINE,'(A,I5)')'NCS restraint       :',INCS
            CALL ERRWRT(-1,LINE)
            WRITE(LINE,'(A,I5)')'Number of chains    :',
     &                 ncs_chain_num(incs)
            CALL ERRWRT(-1,LINE)
            write(line,'(a,i5)')'Number of pieces    :',
     &           ncs_equiv_num(incs)
            call errwrt(-1,line)
            write(line,'(a,f6.3,a,f6.3)')
     &           'Weights for this ncs: on positional - ',
     &           sigx_ncs(incs),' and on thermal - ',sigb_ncs(incs)
            call errwrt(-1,line)
            do j=1,ncs_equiv_num(incs)
               write(line,'(a,i6,a,i6)')
     &              'Residues from ',ncs_equiv_res(1,j,incs),
     &              ' to ',ncs_equiv_res(2,j,incs)
               call errwrt(-1,line)
               all_chains = ' '
               do  in=1,ncs_chain_num(incs)
                  if(len_trim(all_chains).gt.0) then
                     all_chains = trim(all_chains)//' '
     &                    //ncs_equiv_ch(in,j,incs)
                  else
                     all_chains = ' '//ncs_equiv_ch(in,j,incs)
                  endif
               enddo
               if(len_trim(all_chains).gt.0) then
                  call errwrt(-1,'Chain names      :'//all_chains)
               else
                  call errwrt(1,
     &                 'NCS chain definitions. Check NCSR/NONX')
               endif
            enddo
          ENDDO
          call errwrt(-1,' ')
          call errwrt(-1,'Old ncs restraints weighting scheme')
          call errwrt(-1,' ')
          WRITE(ISYSW,'(10X,A,F5.2)')'Weight=',WSSKAL
          WRITE(ISYSW,'(5X,A,T45,F5.2,A)')
     +     'Positional, tight class', SIGS(1),'A'
          WRITE(ISYSW,'(5X,A,T45,F5.2,A)')
     +     'Positional, medium class', SIGS(2),'A'
          WRITE(ISYSW,'(5X,A,T45,F5.2,A)')
     +     'Positional, weak class', SIGS(3),'A'
          WRITE(ISYSW,'(5X,A,T45,F5.2,A)')
     +     'Thermal, tight class', SIGS(4),'A**2'
          WRITE(ISYSW,'(5X,A,T45,F5.2,A)')
     +     'Thermal, medium class', SIGS(5),'A**2'
          WRITE(ISYSW,'(5X,A,T45,F5.2,A)')
     +     'Thermal, weak class', SIGS(6),'A**2'
cd          CALl ERRWRT(1,'After NCS report')

        END IF
        if(ncsr_flag.and.number_ncsr.le.0) then
           write(*,*)
           write(*,*)'NCS will defined automatically and applied'
           call header('Alignment parameters')
           write(*,'(5x,a14,18x,f7.3,a1)')'Alignment level ',
     &          ncsr_level*100,'%'
           write(*,'(5x,a12,20x,f5.3,a1)')'Aligment cut',
     &          align_rms_level,'A'
           write(*,'(5x,a19,13x,a1)')   'Iterative aligment ',
     &          align_iter_flag
        endif
        if(ncsr_use.eq.'S') then
           call header('Local NCS parameters')
           write(*,'(5x,a16,16x,f7.4,a)')'Maximum distance',
     &          dmax_ncs_local,'A'
           write(*,'(5x,a31,1x,f7.4,a)')
     &          'Maximum difference of distances',
     &          diffmax_ncs_local,'A'
           write(*,'(5x,a23,9x,f7.4)')'Geman-Mcclure parameter',
     &          gm_ncsr_simil_param
           write(*,'(5x,a)')'Weights'
           write(*,'(10x,a20,f8.4,a)')'sigx = ',sigx_ncs_local,
     &          '                         if dist1+dist2<8.0'
           write(*,'(10x,a20,f8.4,a)')'sigx = ',sigx_ncs_local,
     &          '*sqrt((dist1+dist2)/8.0) if dist1+dist2>=8.0'
        endif
C
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' RESTRAINTS AGAINST EXCESSIVE SHIFTS')
        WRITE(LINE,'(5x,A,T45,F5.2,A)')
     +    'Positional parameters',PDEL,'A'
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(5x,A,T45,F5.2,A)')
     +    'Thermal parameters',BDEL*PISQ8,'A'
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(5x,A,T45,F5.2)')
     +    'Occupancy parameters',QDEL
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' RADIUS OF CONFIDENCE')
        WRITE(LINE,'(5x,A,F5.2,A)')
     +    'Positional parameters',PRADIUS,'A'
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(5x,A,F5.2,A)')
     +    'Thermal parameters   ',BRADIUS,'A**2'
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(5x,A,F5.2)')
     +    'Occupancy parameters ',QRADIUS
        CALL ERRWRT(-1,LINE)
      ENDIF
c
c---  
      if(sigma_dist_r.gt.0.0) then
         call errwrt(-1,' ')
         call errwrt(-1,'Restraints on changes of interatomic distances'
     &        //' is appplied')
         call header('Distance shift penlty parameters')
         write(*,'(5x,a,f6.4)')'Sigma:           ',sigma_dist_r
         write(*,'(5x,a,f6.4)')'Maximum distance ',dmax_dist_r
      endif
         
C  
C----Monitoring parameters
      CALL ERRWRT(-1,' ')
      IF(MON_STYLE.EQ.'NONE') THEN
         CALL ERRWRT(-1,'Monitoring style is "NONE". No information'
     &                   //' will be printed out')
      ENDIF
      IF(MON_STYLE.EQ.'FEW') THEN
         CALL ERRWRT(-1,'Monitoring style is "FEW". Minimum information'
     &                   //' will be printed out')
      ENDIF
      IF(MON_STYLE.EQ.'MEDI') THEN
         CALL ERRWRT(-1,'Monitoring style is "MEDIUM". Complete'
     &                //' information will be printed out in the')
         CALL ERRWRT(-1,'first and last cycle. In all other cycles'
     &               //' minimum information will be printed out')
      ENDIF
      IF(MON_STYLE.EQ.'MANY') THEN
         CALL ERRWRT(-1,'Monitoring style is "MANY". Complete'
     &          //' information will be printed out in all cycles')
      ENDIF
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY'.AND.
     &                                      REFID.EQ.'REST') THEN
         CALL ERRWRT(-1,'Sigma cutoffs for printing out outliers')
         CALL ERRWRT(-1,'If deviation of restraint parameter >' 
     &           //' alpha*sigma then information will be printed out')
         WRITE(LINE,'(A,F6.3)') 'Distance outliers      ',DSCUT
         CALL ERRWRT(-1,LINE)
         WRITE(LINE,'(A,F6.3)') 'Angle outliers         ',ANGLCUT
         CALL ERRWRT(-1,LINE)
         WRITE(LINE,'(A,F6.3)') 'Torsion outliers       ',TORCUT
         CALL ERRWRT(-1,LINE)
         WRITE(LINE,'(A,F6.3)') 'Chiral volume outliers ',CHICUT
         CALL ERRWRT(-1,LINE)
         WRITE(LINE,'(A,F6.3)') 'Plane outliers         ',PLCUT
         CALL ERRWRT(-1,LINE)
         WRITE(LINE,'(A,F6.3)') 'Non-bonding outliers   ',BADVDW
         CALL ERRWRT(-1,LINE)
         
         IF(ITEMP.GT.0) THEN
           WRITE(LINE,'(A,F6.3)') 'B value  outliers      ',BFAC_CUT
           CALL ERRWRT(-1,LINE)
           IF(ITEMP.GT.1) THEN
             WRITE(LINE,'(A,F6.3)') 'Rigid bond outliers    ',RBON_CUT
             CALL ERRWRT(-1,LINE)
             WRITE(LINE,'(A,F6.3)') 'Sphericity outliers    ',BSPH_CUT
             CALL ERRWRT(-1,LINE)
           ENDIF
         ENDIF
         IF(NUMBER_NCSR.GT.0) THEN
           WRITE(LINE,'(A,F6.3)') 'NCS outliers           ',NCSR_CUT
           CALL ERRWRT(-1,LINE)
         ENDIF 
         IF(ITEMP.GT.1) THEN
         ENDIF
      ENDIF
c
c---Twins
      if(twin_flag) then
c
c---  report twin info
         write(*,*)
         write(*,'(a,i4)')'The number of potential twin domains = ',
     &        ntwin_domain
         if(reftyp.ne.'HKL') then
            write(*,*)'Twin domains ((pseudo)merohedral only):'
            write(*,*)'Non-zero obliquity may mean that some of the '//
     &           'reflections at high resolution are split'
            write(*,*)'In these cases you should check images'
            ll_max = 0
            do i=1,ntwin_domain
               rot_l(1:3,1:3) = float(twin_oper(1:3,1:3,i))/12.0
               tr_l(1:3) = 0.0
               call put_symm_to_text(rot_l,tr_l,text_loc)
               ll_max = max(ll_max,len_trim(text_loc))
            enddo
            do i=1,ntwin_domain
               rot_l(1:3,1:3) = float(twin_oper(1:3,1:3,i))/12.0
               tr_l(1:3) = 0.0
               call put_symm_to_text(rot_l,tr_l,text_loc)
               write(line,'(a,i3,a,a,a,F5.3)')
     &              ' Potential twin domain ',i,' with  operator: '
               ll = len_trim(line)+1
               write(line(ll:),'(a)')trim(text_loc)
               ll = ll + ll_max + 1
               write(line(ll:),'(a,f5.3)')', obliquity(deg) ',
     &              twin_score(i)
               write(*,'(a)')trim(line)
            enddo
         else
            write(*,*)'The twin operators defined in the design '//
     &           'of HKLF 5 file'
            do i=1,ntwin_domain
               write(*,*)'Twin domain ',i,
     &              ', with initial fraction = ',twin_frac(i)
            enddo
         endif
      endif
c
c---info about signals
      if(kill_signal_flag) then
         call header('Signals to refmac')
         write(*,*)'Signals to refmac will be read from the file ',
     &        trim(kill_signal_file)
      endif
         
      CALL ERRWRT(-1,
     &'---------------------------------------------------------------')
      CALL ERRWRT(-1,' ')
      RETURN
      END
C
      SUBROUTINE READ_BFAC_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                     CVALUE,IERROR)
      use weights
      use refi_flags
C
C---Reads parameters relevant to Bvalues
      IMPLICIT NONE
      INCLUDE 'const.fh'
C
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
C
      integer ii
      INTEGER ITK
      REAL BDefault_Ind
C
      ITK = ITOK
      IF(NTOK.LT.ITOK) RETURN
      IF(ITYP(ITK).EQ.2) THEN
         CALL GTNREA(ITK,1,WBSKAL,NTOK,ITYP,FVALUE)
         ITK = ITK + 1
      ELSE
        GOTO 100
      ENDIF
      IF(NTOK.LT.ITK) RETURN
      IF(ITYP(ITK).EQ.2) THEN
         CALL GTNREA(ITK,1,SIGB(1),NTOK,ITYP,FVALUE)
         sigb_kl(1) = 0.1*sigb(1)/1.5
         ITK = ITK + 1
      ELSE
        GOTO 100
      ENDIF
      IF(NTOK.LT.ITK) RETURN
      IF(ITYP(ITK).EQ.2) THEN
         CALL GTNREA(ITK,1,SIGB(2),NTOK,ITYP,FVALUE)
         sigb_kl(2) = 0.15*sigb(2)/2.0
         ITK = ITK + 1
      ELSE
        GOTO 100
      ENDIF
      IF(NTOK.LT.ITK) RETURN
      IF(ITYP(ITK).EQ.2) THEN
         CALL GTNREA(ITK,1,SIGB(3),NTOK,ITYP,FVALUE)
         sigb_kl(3) = 0.3*sigb(3)/3.0
         ITK = ITK + 1
      ELSE
        GOTO 100
      ENDIF
      IF(NTOK.LT.ITK) RETURN
      IF(ITYP(ITK).EQ.2) THEN
         CALL GTNREA(ITK,1,SIGB(4),NTOK,ITYP,FVALUE)
         sigb_kl(4) = 0.5*sigb(4)/4.5
         ITK = ITK + 1
      ELSE
        GOTO 100
      ENDIF
 100  CONTINUE
      IF(NTOK.LT.ITK) RETURN
      IF(ITYP(ITK).EQ.1) THEN
         IF(CVALUE(ITK)(1:3).EQ.'SET') THEN
            ITK = ITK + 1
            IF(NTOK.GE.ITK) CALL GTNREA(ITK,1,BDefault_Ind,NTOK,ITYP,
     &           FVALUE)
            IF(Bdefault_Ind.GT.0.0) THEN
               BSET_DEFAULT_FLAG = .TRUE.
               UDefault_Ind = BDefault_Ind/PISQ8
            ENDIF
         elseif(cvalue(itk).eq.'KLDI') then
            itk = itk + 1
            do ii=1,6
               if(ntok.ge.itk) then
                  if(ityp(itk).eq.2) then
                     if(fvalue(itk).gt.0.0) sigb_kl(ii) = fvalue(itk)
                     itk = itk + 1
                  else
                     goto 110
                  endif
               endif
            enddo
         elseif(cvalue(itk).eq.'DMAX') then
            itk = itk + 1
            dmax_brest = max(0.0,fvalue(itk))
         ENDIF
      ENDIF
 110  continue
      RETURN
      END
C
      SUBROUTINE READ_OCCUP_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                     CVALUE,IERROR)
      use weights
      use refi_flags
C
C---Reads parameters relevant to Bvalues
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'occupancy_params.fh'
      INCLUDE 'const.fh'
C
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
C
      INTEGER ITK
      REAL BDefault_Ind
C
      ITK = ITOK

      IF(NTOK.LT.ITK) RETURN
      IF(CVALUE(ITK)(1:4).EQ.'REFI') THEN
        OCCUP_REF_FLAG = .TRUE.
        ITK = ITK + 1
      ELSE IF(CVALUE(ITK).EQ.'EVER') THEN
        ITK = ITK + 1
        CALL GTNINT(ITK,1,NCYCLE_OCC,NTOK,ITYP,
     &                    FVALUE)
        ITK = ITK + 1
      ELSE IF(CVALUE(ITK).EQ.'BVAL') THEN
        ITK = ITK + 1
        IF(CVALUE(ITK).EQ.'EXCL') THEN
          EXCLUDE_OCC_B = .TRUE.
          ITK = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'NOEX') THEN
          EXCLUDE_OCC_B = .FALSE.
          ITK = ITK + 1
        ELSE
          CALL ERRWRT(0,'Wrong subkeywrod of "OCCUPancy BVALue')
          CALL ERRWRT(0,'Allowed subkeywrods are EXCLUDE/NOEXCLUDE')
        ENDIF
      ELSE
        CALL ERRWRT(0,'Wrong subkeywords of OCCUPancy')
        CALL ERRWRT(0,'Allowed subkeywords are "REFIne EVERy BVALue')
      ENDIF
      RETURN
      END
C
      SUBROUTINE READ_NBOND_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                     CVALUE,IERROR)
      use weights
      use refi_flags
C
C---Reads parameters relevant to Bvalues
      IMPLICIT NONE
      INCLUDE 'const.fh'
C
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
C
      INTEGER ITK
C
      IERROR = 0
      ITK = ITOK
      IF(NTOK.LT.ITOK) GOTO 200
      IF(ITYP(ITK).EQ.2) THEN
         CALL GTNREA(ITK,1,WVSKAL,NTOK,ITYP,FVALUE)
         ITK = ITK + 1
      ENDIF
 100  CONTINUE
C
C---  First try to read overall weighting factor for non-bonding ineteractions
      IF(ITK.GE.NTOK) GOTO 200
      IF(CVALUE(ITK).NE.'OVER'.AND.CVALUE(ITK).NE.'SIGM'.AND.
     &     CVALUE(ITK).NE.'INCR'.AND.CVALUE(ITK).NE.'CHAN'.AND.
     &     CVALUE(ITK).NE.'VDWC'.and.cvalue(itk).ne.'EXCL'   ) THEN
         IERROR = IERROR + 1
         CALL ERRWRT(-1,'Wrong subkeyword of VDWR/VAND/NONB keyword')
         CALL ERRWRT(-1,'Allowed subkeywords -'//
     &        ' OVERall/SIGMa/INCRement/CHANge/EXCL')
         CALL ERRWRT(0,'Keyword interpretation has failed')
         IERROR = 1
         GOTO 200
      ENDIF
      IF(CVALUE(ITK).EQ.'OVER') THEN
         IF(ITK.LT.NTOK) THEN
            ITK = ITK + 1
            IF(ITYP(ITK).NE.2) THEN
               IERROR = IERROR + 1
               CALL ERRWRT(-1,'Wrong parameter for VDW/VAND/NBOND OVER')
               CALL ERRWRT(-1,'Program expects number')
               CALL ERRWRT(0,'Keyword interpretation has failed')
               GOTO 200
            ENDIF
            IF(ITK.GE.NTOK) GOTO 200
            CALL GTNREA(ITK,1,WVSKAL,NTOK,ITYP,FVALUE)
            ITK = ITK + 1
         ENDIF
      ENDIF
C
C---Read sigmas for nonbonding interactions
      IF(CVALUE(ITK).EQ.'SIGM') THEN
        ITK = ITK + 1
 150    CONTINUE
        IF(ITK.GE.NTOK) GOTO 200
        IF(CVALUE(ITK).EQ.'SIGM'.OR.CVALUE(ITK).EQ.'OVER'.OR.
     &     CVALUE(ITK).EQ.'INCR'.OR.CVALUE(ITK).EQ.'CHAN'.or.
     &     cvalue(itk).eq.'EXCL') GOTO 100

        IF(CVALUE(ITK)(1:3).NE.'VDW' .AND.CVALUE(ITK).NE.'HBON'.AND.
     &       CVALUE(ITK)   .NE.'META'.AND.CVALUE(ITK).NE.'TORS'.AND.
     &       CVALUE(ITK)   .NE.'DUMM'.and.cvalue(itk).ne.'EXCL') THEN
            CALL ERRWRT(-1,'Wrong subkeyword of VDW/VAND/NBON SIGMa')
            CALL ERRWRT(-1,
     &           'Allowed subkeywords - VDW/HBON/METAl/TORS/DUMM/EXCL')
            CALL ERRWRT(0,'Keyword interpretation has failed')
            GOTO 200
        ENDIF
        IF(ITK.GE.NTOK) GOTO 200
        IF(ITYP(ITK+1).NE.2) THEN
          CALL ERRWRT(-1,'Wrong parameter field. Expecting a number')
          CALL  ERRWRT(0,'Keyword interpretation  failed')
          GOTO 200
        ENDIF
        IF(CVALUE(ITK)(1:3).EQ.'VDW') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,VDW_SDI_VDW,NTOK,ITYP,FVALUE)
          ITK = ITK + 1
          GOTO 150
        ELSEIF(CVALUE(ITK).EQ.'HBON') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,VDW_SDI_HBOND,NTOK,ITYP,FVALUE)
          ITK = ITK + 1
          GOTO 150
        ELSEIF(CVALUE(ITK).EQ.'META') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,VDW_SDI_METAL,NTOK,ITYP,FVALUE)
          ITK = ITK + 1
          GOTO 150
        ELSEIF(CVALUE(ITK).EQ.'TORS') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,VDW_SDI_TORSION,NTOK,ITYP,FVALUE)
          ITK = ITK + 1
          GOTO 150
        ELSEIF(CVALUE(ITK).EQ.'DUMM') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,VDW_SDI_DUMMY,NTOK,ITYP,FVALUE)
          ITK = ITK + 1
          GOTO 150
        ENDIF
      ENDIF
C
C---Incrementation parameters
      IF(CVALUE(ITK).EQ.'INCR') THEN
        ITK = ITK + 1
 170    CONTINUE
        IF(ITK.GT.NTOK) GOTO 200
        IF(CVALUE(ITK).EQ.'SIGM'.OR.CVALUE(ITK).EQ.'OVER'.OR.
     &     CVALUE(ITK).EQ.'INCR'.OR.CVALUE(ITK).EQ.'CHAN') GOTO 100

        IF(CVALUE(ITK).NE.'TORS'.AND.CVALUE(ITK).NE.'ADHB'.AND.
     &     CVALUE(ITK).NE.'AHHB'.AND.CVALUE(ITK).NE.'DUMM') THEN
            CALL ERRWRT(-1,'Wrong subkeyword of VDW/VAND/NBON INCR')
            CALL ERRWRT(-1,'Allowed subkeywords - TORS/ADHB/AHHB/DUMM')
            CALL ERRWRT(0,'Keyword interpretation has failed')
            GOTO 200
        ENDIF
        IF(ITK.GE.NTOK) GOTO 200
        IF(ITYP(ITK+1).NE.2) THEN
          CALL ERRWRT(-1,'Wrong parameter field. Expecting number')
          CALL  ERRWRT(0,'Keyword interpretation has failed')
          GOTO 200
        ENDIF
        IF(CVALUE(ITK).EQ.'TORS') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,DINC_TORSION,NTOK,ITYP,FVALUE)
          DINC_TORSION = -ABS(DINC_TORSION)
          ITK = ITK + 1
          GOTO 170
        ELSEIF(CVALUE(ITK).EQ.'ADHB') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,HBOND_DINC_AD,NTOK,ITYP,FVALUE)
          HBOND_DINC_AD = -ABS(HBOND_DINC_AD)
          ITK = ITK + 1
          GOTO 170
        ELSEIF(CVALUE(ITK).EQ.'AHHB') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,HBOND_DINC_AH,NTOK,ITYP,FVALUE)
          HBOND_DINC_AH = ABS(HBOND_DINC_AH)
          ITK = ITK + 1
          GOTO 170
        ELSEIF(CVALUE(ITK).EQ.'DUMM') THEN
          ITK = ITK + 1
          CALL GTNREA(ITK,1,DINC_DUMMY,NTOK,ITYP,FVALUE)
          DINC_DUMMY = -ABS(DINC_DUMMY)
          ITK = ITK + 1
          GOTO 170
        ENDIF
      ENDIF
C
      IF(CVALUE(ITK).EQ.'CHAN') THEN
        IF(ITK.GE.NTOK) GOTO 200
        ITK = ITK + 1
      ENDIF
      IF(CVALUE(ITK).EQ.'VDWC') THEN
        IF(ITK.GE.NTOK) GOTO 200
        ITK = ITK+1
        IF(ITYP(ITK).EQ.2) THEN
          CALL GTNREA(ITK,1,DVDW_CUT_MIN,NTOK,ITYP,FVALUE)
          IF(DVDW_CUT_MIN.LT.0.0) THEN
            CALL ERRWRT(0,'Wrong vdw cut radius. Reset to 2.0')
            DVDW_CUT_MIN = 2.0
          ENDIF
          DVDW_CUT_MIN_X = DVDW_CUT_MIN
          ITK = ITK + 1
        ENDIF
      ENDIF

      if(cvalue(itk).eq.'EXCL') then
         itk = itk + 1
         vdwr_exclude_flag = .TRUE.
         goto 200
      endif

      GOTO 100
 200  CONTINUE

      RETURN
      END
C
      SUBROUTINE READ_RESTR_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,
     &                     FVALUE,CVALUE,IERROR)
      use weights
      use dnarna
      use refi_flags
C
C---Reads parameters relevant to B_values
      IMPLICIT NONE
      INCLUDE 'const.fh'
      INCLUDE 'restr_params.fh'
C
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
      CHARACTER RES_NAME_RESTR_INP*16,GROUP_NAME_RESTR_INP*16
      CHARACTER LINK_NAME_INP*16,RES_NAME_TORS_INP*16,FLAG_TORS*1
      character tmp_file*512
C
      REAL    TORS_VALUE_INP,TORS_SIGMA_INP
      INTEGER TORS_PERIOD_INP
C
      logical lexists
      INTEGER ITK,IRESID,ITORS_REST,I_T,I
      INTEGER ERROR_RESTR
      EXTERNAL ERROR_RESTR
C
      IERROR = 0
      ITK = ITOK
      IF(NTOK.LT.ITOK) GOTO 200
      if(cvalue(2)(1:2).eq.'BP'.or.cvalue(2).eq.'PAIR'.or.
     &     cvalue(2).eq.'BASEP') then
         basepair_flag = .TRUE.
C
C---define basepair files
         file_basepairs_dict= ' '
         call getenv('CLIBD_MON',tmp_file)
         file_basepairs_dict=trim(tmp_file)//'dnarna_basepairs.txt'
         inquire(file=file_basepairs_dict,exist=lexists)
         if(.not.lexists) file_basepairs_dict=' '
         call ugtenv('basepairs',user_basepair_file)
         inquire(file=user_basepair_file,exist=lexists)
         if(.not.lexists)user_basepair_file = ' '
         write(*,*)basepair_flag
         return
      endif
      IF(CVALUE(2)(1:4).EQ.'TORS') THEN
C
C--Read info about restrainable torsions and write them to some 
C--file. Syntax: 
C---RESTraint TORSion RESIdue <name> NAME <name> VALUe <value> PERIod <period>
C--
C
C---Next key should be RESI
        ITK = ITK + 1
        IF(ITK.GT.NTOK) GOTO 200
        if(cvalue(itk).eq.'FBAS') then
           itk = itk + 1
           user_basepair_file = line(ibeg(itk):iend(itk))
           inquire(file=user_basepair_file,exist=lexists)
           if(.not.lexists)user_basepair_file = ' '           
           itk = itk + 1
        elseif(CVALUE(ITK).EQ.'INCL') THEN
          ITK = ITK + 1
          CALL READ_TORS_PARAMS_CARD(ITK,NTOK,CVALUE,
     &           LINE,IBEG,IEND,
     &           FVALUE,RES_NAME_RESTR_INP,GROUP_NAME_RESTR_INP,
     &           LINK_NAME_INP,RES_NAME_TORS_INP,
     &           TORS_VALUE_INP,TORS_SIGMA_INP,TORS_PERIOD_INP,
     &           FLAG_TORS)
          IF(FLAG_TORS.EQ.'N') THEN
            N_RESTRAIN_TORS = 0
            GOTO 200
          ELSE
C
c---Check if this particular torsion is in the list. If yes replace
C---replace it.
            IF(N_RESTRAIN_TORS.GT.0) THEN
              DO   I=1,N_RESTRAIN_TORS
                IF(RES_NAME_TORS_RESTR(I).EQ.RES_NAME_RESTR_INP.AND.
     &             GROUP_NAME_TORS_RESTR(I).EQ.GROUP_NAME_RESTR_INP.AND.
     &             LINK_NAME_TORS_RESTR(I).EQ.LINK_NAME_INP.AND.
     &             RES_NAME_TORS_NAME(I).EQ.RES_NAME_TORS_INP) THEN
                   I_T = I
                   GOTO 50
                 ENDIF
              ENDDO
            ENDIF
            N_RESTRAIN_TORS = N_RESTRAIN_TORS + 1
            I_T             =  N_RESTRAIN_TORS
 50         CONTINUE
            RES_NAME_TORS_RESTR(I_T)   = RES_NAME_RESTR_INP
            GROUP_NAME_TORS_RESTR(I_T) = GROUP_NAME_RESTR_INP
            LINK_NAME_TORS_RESTR(I_T)  = LINK_NAME_INP
            RES_NAME_TORS_NAME(I_T)    = RES_NAME_TORS_INP
            RES_NAME_TORS_VALUE(I_T)   = TORS_VALUE_INP
c            WRITE(*,*) TORS_VALUE_INP
            RES_NAME_TORS_SIGMA(I_T)   = TORS_SIGMA_INP
            RES_NAME_TORS_PERIOD(I_T)  = TORS_PERIOD_INP
            GOTO 200
          ENDIF
        ELSE IF(CVALUE(ITK).EQ.'EXCL') THEN
          ITK = ITK + 1
          CALL READ_TORS_PARAMS_CARD(ITK,NTOK,CVALUE,
     &           LINE,IBEG,IEND,
     &           FVALUE,RES_NAME_RESTR_INP,GROUP_NAME_RESTR_INP,
     &           LINK_NAME_INP,RES_NAME_TORS_INP,
     &           TORS_VALUE_INP,TORS_SIGMA_INP,TORS_PERIOD_INP,
     &           FLAG_TORS)
          IF(FLAG_TORS.EQ.'N') THEN
            N_RESTRAIN_TORS_E = 0
            GOTO 200
          ELSE
            IF(N_RESTRAIN_TORS_E.GT.0) THEN
              DO   I=1,N_RESTRAIN_TORS_E
                IF(RES_NAME_TORS_RESTR_E(I).EQ.RES_NAME_RESTR_INP.AND.
     &           GROUP_NAME_TORS_RESTR_E(I).EQ.GROUP_NAME_RESTR_INP.AND.
     &             LINK_NAME_TORS_RESTR_E(I).EQ.LINK_NAME_INP.AND.
     &             RES_NAME_TORS_NAME_E(I).EQ.RES_NAME_TORS_INP) THEN
                   I_T = I
                   GOTO 60
                 ENDIF
              ENDDO
            ENDIF
            N_RESTRAIN_TORS_E = N_RESTRAIN_TORS_E + 1
            I_T               = N_RESTRAIN_TORS_E
 60         CONTINUE
            RES_NAME_TORS_RESTR_E(I_T) = RES_NAME_RESTR_INP
            GROUP_NAME_TORS_RESTR_E(I_T) = GROUP_NAME_RESTR_INP
            LINK_NAME_TORS_RESTR_E(I_T) = LINK_NAME_INP
            RES_NAME_TORS_NAME_E(I_T)   =  RES_NAME_TORS_INP
            GOTO 200
          ENDIF
        ENDIF
      ENDIF
C
      IF(CVALUE(2)(1:4).EQ.'RESI') THEN
        ITK = ITK + 1
        IF(NTOK.LE.ITK) GOTO 100
        NCIS_TRANS_RES = NCIS_TRANS_RES + 1
        CALL GTNINT(ITK,1,IRESID,NTOK,ITYP,FVALUE)
        CIS_TRANS_RES(NCIS_TRANS_RES) = IRESID
        ITK = ITK + 1
        IF(NTOK.LE.ITK) GOTO 100
        CIS_TRANS_CHAIN(NCIS_TRANS_RES) = CVALUE(ITK)
        ITK = ITK + 1
        IF(NTOK.LT.ITK) GOTO 100
        IF(CVALUE(ITK)(1:3).EQ.'ALT') THEN
          ITK = ITK + 1
          IF(NTOK.LE.ITK) GOTO 100
          CIS_TRANS_ALT(NCIS_TRANS_RES) = CVALUE(ITK)(1:1)
          ITK = ITK + 1
        ELSE
          CIS_TRANS_ALT(NCIS_TRANS_RES) = '.'
        ENDIF
        CIS_TRANS_VALUE(NCIS_TRANS_RES) = CVALUE(ITK)(1:3)
      ELSEIF(CVALUE(itk).EQ.'CHIR') THEN
         itk = itk + 1
         IF(CVALUE(ITK).EQ.'REPL') THEN
            itk = itk + 1
            nchir_replace = nchir_replace + 1
            chir_repl_alt(nchir_replace) = '.'
            do while(itk.lt.ntok)
               if(cvalue(itk).eq.'RESI') then
                  itk = itk + 1
                  call gtnint(itk,1,iresid,ntok,ityp,fvalue)
                  chir_repl_res(nchir_replace) = iresid
                  itk = itk + 1
               else if(cvalue(itk).eq.'CHAI') then
                  itk = itk + 1
                  chir_repl_chain(nchir_replace) = cvalue(itk)
                  itk = itk + 1
               else if(cvalue(itk).eq.'ATOM') then
                  itk = itk + 1
                  chir_repl_atom(nchir_replace) = cvalue(itk)
                  itk = itk + 1
               else if(cvalue(itk)(1:3).eq.'ALT') then
                  itk = itk + 1
                  chir_repl_alt(nchir_replace) = cvalue(itk)(1:1)
                  itk = itk + 1
               else if(cvalue(itk).eq.'SIGN') then
                  itk = itk + 1
                  chir_repl_sign(nchir_replace) = cvalue(itk)(1:1)
                  itk = itk + 1
               else
                  goto 150
               endif
            enddo
         ENDIF
      ENDIF
      GOTO 200
 100  CONTINUE
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'Wrong instructions for CIS/TRANS')
      CALL ERRWRT(-1,'Valid instruction is:')
      CALL ERRWRT(-1,
     &    'RESTraint RESIdue <number> <chain> ALT <alt> CIS/TRANS')
      CALL ERRWRT(-1,'<alt> is optional. All others are compolsury')
      CALL ERRWRT(1,'Severe problem in keyword interpretation')
C
 150  CONTINUE
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'Wrong instructions for RESTR CHIRAL REPLACE')
      CALL ERRWRT(-1,'Valid instruction is:')
      CALL ERRWRT(-1,
     &  'RESTraint CHIRal REPLace RESI <residue> CHAIN <chain> ATOM '//
     &     '<atom> ALT <alt> SIGN <sign>')
      CALL ERRWRT(-1,'<alt> is optional. All others are compolsury')
      CALL ERRWRT(1,'Severe problem in keyword interpretation')
 200  CONTINUE
      RETURN
      END
C
      INTEGER FUNCTION ERROR_RESTR(ITK,NTOK)
      IMPLICIT NONE
      INTEGER ITK,NTOK
C
      ERROR_RESTR = 0
      IF(ITK.GT.NTOK) THEN
        CALL ERRWRT(0,'Incomplete keyword for torsion restraints')
        CALL ERRWRT(0,'Valid form is:')
        ERROR_RESTR = 1
      ENDIF
      RETURN
      END
C
      subroutine read_mapcalculate_params()
      implicit none

      return
      end
c
      SUBROUTINE READ_TORS_PARAMS_CARD(ITK,NTOK,CVALUE,
     *           LINE,IBEG,IEND,
     &           FVALUE,RES_NAME_TORS_RESTR_O,GROUP_NAME_TORS_RESTR_O,
     &           LINK_NAME_TORS_RESTR_O,RES_NAME_TORS_NAME_O,
     &           RES_NAME_TORS_VALUE_O,RES_NAME_TORS_SIGMA_O,
     &           RES_NAME_TORS_PERIOD_O,FLAG_TORS)
      IMPLICIT NONE
C
C--Reads from card necessary information about torsion to be restrained
C--or excluded. Residue range should be added also.
C 
      INTEGER ITK,NTOK,N_RESTRAIN_O,RES_NAME_TORS_PERIOD_O
      INTEGER IBEG(*),IEND(*)
      REAL    RES_NAME_TORS_VALUE_O,RES_NAME_TORS_SIGMA_O
      REAL    FVALUE(*)
      CHARACTER CVALUE(*)*4,LINE*(*)
      CHARACTER RES_NAME_TORS_RESTR_O*(*),GROUP_NAME_TORS_RESTR_O*(*)
      CHARACTER LINK_NAME_TORS_RESTR_O*(*),RES_NAME_TORS_NAME_O*(*)
      CHARACTER FLAG_TORS
C
      INTEGER ERROR_RESTR,I_T
      EXTERNAL ERROR_RESTR
C
      FLAG_TORS = 'Y'
      RES_NAME_TORS_VALUE_O = -1.0E32
      RES_NAME_TORS_SIGMA_O = -0.1
      RES_NAME_TORS_PERIOD_O = -1
      RES_NAME_TORS_RESTR_O = '.'
      GROUP_NAME_TORS_RESTR_O = '.'
      RES_NAME_TORS_NAME_O    = '.'
      LINK_NAME_TORS_RESTR_O = '.'

      IF(CVALUE(ITK).EQ.'NONE') THEN
        FLAG_TORS = 'N'
        ITK             = ITK + 1
        GOTO 200
      ELSE
        IF(CVALUE(ITK).EQ.'RESI') THEN
          ITK = ITK + 1
         IF(ERROR_RESTR(ITK,NTOK).GT.0) GOTO 200
         RES_NAME_TORS_RESTR_O =  LINE(IBEG(ITK):IEND(ITK))
         ITK = ITK + 1
c         IF(ERROR_RESTR(ITK,NTOK).GT.0) GOTO 200
       ELSEIF(CVALUE(ITK).EQ.'GROU') THEN
         ITK = ITK + 1
         IF(ERROR_RESTR(ITK,NTOK).GT.0) GOTO 200
         GROUP_NAME_TORS_RESTR_O =  LINE(IBEG(ITK):IEND(ITK))
         ITK = ITK + 1
c         IF(ERROR_RESTR(ITK,NTOK).GT.0) GOTO 200
       ELSE IF(CVALUE(ITK).EQ.'LINK') THEN
C
C---It is about links.
         ITK = ITK + 1
         IF(ERROR_RESTR(ITK,NTOK).GT.0) GOTO 200
         LINK_NAME_TORS_RESTR_O = LINE(IBEG(ITK):IEND(ITK))
         ITK = ITK + 1
c         IF(ERROR_RESTR(ITK,NTOK).GT.0) GOTO 200
       ELSE
         I_T = ERROR_RESTR(ITK,NTOK)
         GOTO 200
       ENDIF
C
C--
 20    CONTINUE
       IF(ITK.GT.NTOK) THEN
         GOTO 200
       ENDIF
       IF(CVALUE(ITK).EQ.'NAME') THEN
         ITK = ITK + 1
         RES_NAME_TORS_NAME_O = LINE(IBEG(ITK):IEND(ITK))
       ELSE IF(CVALUE(ITK).EQ.'VALU') THEN
         ITK = ITK + 1
         RES_NAME_TORS_VALUE_O = FVALUE(ITK)
       ELSE IF(CVALUE(ITK).EQ.'SIGM') THEN
         ITK = ITK + 1
         RES_NAME_TORS_SIGMA_O = FVALUE(ITK)
       ELSE IF(CVALUE(ITK).EQ.'PERI') THEN
         ITK = ITK + 1
         RES_NAME_TORS_PERIOD_O = NINT(FVALUE(ITK))
       ENDIF
       IF(ERROR_RESTR(ITK,NTOK).GT.0) GOTO 200   
       ITK = ITK + 1
       GOTO 20
      ENDIF
 200  CONTINUE
      RETURN
      END
C
      SUBROUTINE READ_SYMM_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,
     &           FVALUE)
      use CellAndSymmetry
c
c---Reads keyword for symmetry
      IMPLICIT NONE
C
      CHARACTER LINE*(*)
      CHARACTER SGNM*10,PGNAM*10
      REAL FVALUE(*)
      INTEGER NTOK,ITOK
      INTEGER IBEG(*),IEND(*),ITYP(*)
      INTEGER NPSYM
      REAL RT(4,4,192)
C
      INTEGER NSYM_L
      INTEGER IERROR
C
      CALL CCPUPC(LINE)
      CALL RDSYMM(ITOK,LINE,IBEG,IEND,ITYP,FVALUE,NTOK,SGNM,ISPNO,
     +            PGNAM,NSYM_L,NumSymmetry,RealSymmMatrx)
C
      CALL CHECK_SYMMETRY4(SGNM,ISPNO,NSYM_L,RT,IERROR)
C
      RETURN
      END
C
      SUBROUTINE CHECK_SYMMETRY4(SPGRP,NSPGRP,NSYM_IN,ROT_IN,IERROR)
      use CellAndSymmetry
c
c---It checks. If symmetry has been defined previously (space group number 
C---is more than 1) then it uses that symmetry. If it has not been defined
C---then new symmetry is used. space group number is important. It might
c---be weekness of this routine
      IMPLICIT NONE
      INTEGER NSPGRP,IERROR,NSYM_IN
      REAL ROT_IN(4,4,*)
      CHARACTER SPGRP*(*)

      INTEGER I,J,IS

      IERROR = 0
C
C--First check if space group numbers are same
      IF(ISPNO.LE.1.AND.NSPGRP.GT.1) THEN
C
C---Symmetry has not been defined previously. Use new symmetry
        DO    IS=1,NSYM_IN
          DO   J=1,4
            DO   I=1,4
              RealSymmMatrx(I,J,IS) = ROT_IN(I,J,IS)
            ENDDO
          ENDDO
        ENDDO
        NumSymmetry = NSYM_IN
        ISPNO = NSPGRP
        IF(len_trim(SPGRP).GT.0) THEN
          SpaceGroupName = trim(SPGRP)
        ELSE
          SpaceGroupName = ' '
        ENDIF
        IERROR = 0
        RETURN
      ELSEIF(ISPNO.GT.1.AND.NSPGRP.LE.1) THEN
C
C---There is no new symmetry. But old symmetry has been defined. Use old
C---symmetry
        DO   IS=1,NumSymmetry
          DO    J=1,4
            DO   I=1,4
              ROT_IN(I,J,IS) = RealSymmMatrx(I,J,IS)
            ENDDO
          ENDDO
        ENDDO
        NSYM_IN = NumSymmetry
        NSPGRP = ISPNO
        IF(len_Trim(SpaceGroupName).GT.0) THEN
          SPGRP  = trim(SpaceGroupName)
        ELSE
          CALL ERRWRT(-1,'Space group name has not been defined')
        ENDIF
        IERROR = 1
        RETURN
      ELSEIF(ISPNO.NE.NSPGRP) THEN
C
C---Space group names are different. It is serious error
        IERROR = 2
        RETURN
      ELSE
C
C---Space group number is same. Check and make other parameters
c---of symmetry consistent with each other

      ENDIF

      END
C
      SUBROUTINE SOLVENT_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &      CVALUE,IERROR)
      use solvent_all
      IMPLICIT NONE
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
c
c---Local variables
      INTEGER ITTB,ITT
C
      IERROR = 0
      ITTB   = 2
      IF(CVALUE(2).EQ.'NO') THEN
        SOLVENT_FLAG = .FALSE.
        ITTB = 3
        RETURN
      ELSEIF(CVALUE(2).EQ.'YES') THEN
        SOLVENT_FLAG = .TRUE.
        ITTB = 3
      elseif(cvalue(2).eq.'OPTI') then
         solvent_flag = .TRUE.
         solvent_optimise = .TRUE.
         ittb = 3
      ENDIF
      if(cvalue(ittb).eq.'PROC') then
         ittb = ittb + 1
         if(cvalue(ittb).eq.'ISLA') then
            ittb = ittb + 1
            if(cvalue(ittb).eq.'REMO') then
               solvent_remove_islands = .TRUE.
               ittb = ittb + 1
            else if(cvalue(ittb).eq.'NORE') then
               solvent_remove_islands = .FALSE.
               ittb = ittb + 1
            endif
         endif
      endif

      if(cvalue(ittb).eq.'EXCL') then
         ittb = ittb + 1
         if(cvalue(ittb)(1:3).eq.'DUM') then
            solvent_ignore_dum = .TRUE.
         endif
      endif

      DO    ITT = ITTB,NTOK,2
        IF(CVALUE(ITT).EQ.'VDWP') THEN
          IF(ITYP(ITT+1).EQ.2)
     &        CALL GTNREA(ITT+1,1,PROB_VDW,NTOK,ITYP,FVALUE)
        ELSEIF(CVALUE(ITT).EQ.'IONP') THEN
          IF(ITYP(ITT+1).EQ.2)
     &        CALL GTNREA(ITT+1,1,PROB_ION,NTOK,ITYP,FVALUE)
       elseif(cvalue(itt).eq.'DUMP') then
          if(ityp(itt+1).eq.2) 
     &         call gtnrea(itt+1,1,prob_dum,ntok,ityp,fvalue)
        ELSEIF(CVALUE(ITT).EQ.'RSHR') THEN
          IF(ITYP(ITT+1).EQ.2)
     &        CALL GTNREA(ITT+1,1,RADII_SHRINK,NTOK,ITYP,FVALUE)
        ELSE IF(CVALUE(ITT).EQ.'BFIX') THEN
          B_LS_SOLVENT_MASK_FLAG = .FALSE.
          IF(ITYP(ITT+1).EQ.2) THEN
            CALL GTNREA(ITT+1,1,B_LS_SOL_M,NTOK,ITYP,FVALUE)
          ENDIF
        ELSE IF(CVALUE(ITT).EQ.'SCFI') THEN
          SCALE_LS_SOLVENT_MASK_FLAG = .FALSE.
          IF(ITYP(ITT+1).EQ.2) THEN
            CALL GTNREA(ITT+1,1,SCALE_LS_SOL_M,NTOK,ITYP,FVALUE)
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END
C
      SUBROUTINE  MONITOR_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                           CVALUE,IERROR)
c
c---Reads and processes keywords relevant to monitoring of statistics 
C---during work of program
      IMPLICIT NONE
      INCLUDE 'monitor.fh'
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
c
c---Local variables
      INTEGER ITTB,ITT
C
C---First check if second key is 'MANY', 'FEW' or 'MEDI'. Onlyy FEW and MEDI
C---are important.
      IERROR = 0
      ITTB = 2
      IF(CVALUE(2).EQ.'FEW' .OR.CVALUE(2).EQ.'MANY'.OR.
     +   CVALUE(2).EQ.'MEDI'.OR.CVALUE(2).EQ.'TEST') THEN
         MON_STYLE = CVALUE(2) 
         ITTB = 3
      ENDIF
      DO    ITT = ITTB,NTOK,2
         IF(CVALUE(ITT).EQ.'TORS')THEN
            IF(ITYP(ITT+1).EQ.2) 
     &           CALL GTNREA(ITT+1,1,TORCUT,NTOK,ITYP,FVALUE)
         ELSEIF(CVALUE(ITT).EQ.'CHIR') THEN
            IF(ITYP(ITT+1).EQ.2) 
     &           CALL GTNREA(ITT+1,1,CHICUT,NTOK,ITYP,FVALUE)        
         ELSEIF(CVALUE(ITT).EQ.'DIST') THEN
            IF(ITYP(ITT+1).EQ.2) 
     &           CALL GTNREA(ITT+1,1,DSCUT,NTOK,ITYP,FVALUE)
         ELSEIF(CVALUE(ITT).EQ.'ANGL') THEN
            IF(ITYP(ITT+1).EQ.2)
     &           CALL GTNREA(ITT+1,1,ANGLCUT,NTOK,ITYP,FVALUE)
         ELSEIF(CVALUE(ITT).EQ.'PLAN') THEN
            IF(ITYP(ITT+1).EQ.2)
     &           CALL GTNREA(ITT+1,1,PLCUT,NTOK,ITYP,FVALUE)
         ELSEIF(CVALUE(ITT)(1:3).EQ.'VDW'.OR.
     &           CVALUE(ITT)(1:3).EQ.'VAN'.OR.
     &           CVALUE(ITT).EQ.'NBON') THEN
          IF(ITYP(ITT+1).EQ.2)
     &      CALL GTNREA(ITT+1,1,BADVDW,NTOK,ITYP,FVALUE)
        ELSEIF(CVALUE(ITT).EQ.'BSPH') THEN
          IF(ITYP(ITT+1).EQ.2) 
     &      CALL GTNREA(ITT+1,1,BSPH_CUT,NTOK,ITYP,FVALUE)
        ELSEIF(CVALUE(ITT).EQ.'RBON') THEN
          IF(ITYP(ITT+1).EQ.2) 
     &      CALL GTNREA(ITT+1,1,RBON_CUT,NTOK,ITYP,FVALUE)
        ELSEIF(CVALUE(ITT).EQ.'BFAC') THEN
          IF(ITYP(ITT+1).EQ.2) 
     &      CALL GTNREA(ITT+1,1,BFAC_CUT,NTOK,ITYP,FVALUE)
        ELSEIF(CVALUE(ITT).EQ.'NCSR') THEN
          IF(ITYP(ITT+1).EQ.2) 
     &      CALL GTNREA(ITT+1,1,NCSR_CUT,NTOK,ITYP,FVALUE)
        ELSEIF(CVALUE(ITT).EQ.'BADC') THEN
          IF(ITYP(ITT+1).EQ.2) 
     &      CALL GTNREA(ITT+1,1,BAD_CONT,NTOK,ITYP,FVALUE)
        ELSE
           WRITE(*,*)CVALUE(ITT),CVALUE(ITT-1)
           CALL ERRWRT(0,' Unknown subkeyword of MONI ')
           CALL ERRWRT(0,' ????? '//CVALUE(ITT)//' ????? ')
           IERROR = IERROR + 1
        ENDIF
      ENDDO
      IF(DSCUT.LT.0.0  ) DSCUT = 10.0
      IF(ANGLCUT.LT.0.0) ANGLCUT = 10.0
      IF(TORCUT.LT.0.0 ) TORCUT = 10.0
      IF(CHICUT.LT.0.0 ) CHICUT = 10.0
      IF(PLCUT.LT.0.0  ) PLCUT  = 10.0
      IF(BADVDW.LT.0.0 ) BADVDW = 3.0
      IF(BAD_CONT.LT.0.0) BAD_CONT = 1.0
      IF(BSPH_CUT.LT.0.0) BSPH_CUT = 10.0
      IF(RBON_CUT.LT.0.0) RBON_CUT = 10.0
      IF(BFAC_CUT.LT.0.0) BFAC_CUT = 10.0
      IF(NCSR_CUT.LT.0.0) NCSR_CUT = 10.0

      RETURN
      END
C
      SUBROUTINE WEIGHT_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                         CVALUE,IERROR)
      use weights
c
c---Read parameters relevant to weighting X-ray and geometry
      IMPLICIT NONE
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL    FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
C
      integer nvalue
      INTEGER ITT,ITK
C
      IERROR = 0
      IF(NTOK.LT.2) RETURN
      ITK = ITOK
      DO    ITT=ITOK,NTOK
        IF(CVALUE(ITK).EQ.'NOEX')THEN
          LEXPUSE = .FALSE.
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'EXPE') THEN
          LEXPUSE = .TRUE.
          ITK     = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'AUTO') THEN
          WEIGHT = 'AUTO'
          ITK    = ITK + 1
c          ITK    = ITK + 1
C>IJT
c          WEIGHTAUTO = 10.
          IF(NTOK.GE.ITK)THEN
             if(ityp(itk).eq.2) then
                CALL GTNREA(ITK,1,WEIGHTAUTO,NTOK,ITYP,FVALUE)
                ITK = ITK+1
                goto 100
             endif
             if(cvalue(itk).eq.'VALU') then
                itk = itk + 1
                call gtnrea(itk,1,weightauto,ntok,ityp,fvalue)
                itk = itk + 1
             else if(cvalue(itk).eq.'ADJU') then
                itk = itk + 1
                if(cvalue(itk)(1:3).eq.'YES') then
                   itk = itk + 1
                   weight_adjust = 'YES'
                else
                   itk = itk + 1
                   weight_adjust = 'NO'
                endif
                do while(itk.lt.ntok.or.nvalue.eq.4) 
                   if(cvalue(itk).eq.'ZMIN') then
                      itk = itk + 1
                      nvalue = nvalue +  1
                      zb_mn = fvalue(itk)
                      itk = itk + 1
                   else if(cvalue(itk).eq.'ZMAX') then
                      itk = itk + 1
                      nvalue = nvalue + 1
                      zb_mx = fvalue(itk)
                      itk = itk + 1
                   else if(cvalue(itk).eq.'ZINC') then
                      itk = itk + 1
                      nvalue = nvalue + 1
                      zb_increase = fvalue(itk)
                      itk = itk + 1
                   else if(cvalue(itk).eq.'ZRED') then
                      itk = itk + 1
                      nvalue = nvalue + 1
                      zb_reduce = fvalue(itk)
                      itk = itk + 1
                   endif
                enddo
             endif
          ENDIF
C<IJT

        ELSEIF(CVALUE(ITK).EQ.'MATR') THEN
          WEIGHT = 'MATR'
          ITK    = ITK+1
          WEIGHTXMAT = 0.5
          IF(NTOK.GE.ITK)THEN
            CALL GTNREA(ITK,1,WEIGHTXMAT,NTOK,ITYP,FVALUE)
            ITK = ITK+1
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'GRAD') THEN
          WEIGHT     = 'GRAD'
          WEIGHTXMAT = 1.0
          ITK        = ITK+1
          IF(NTOK.GE.ITK)THEN
            CALL GTNREA(ITK,1,WEIGHTXMAT,NTOK,ITYP,FVALUE)
            ITK = ITK+1
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'SIGM') THEN
          CALL ERRWRT(-1,'This is an out of date weighting scheme')
          CALL ERRWRT(-1,'Use WEIGht MATRix <number> instead')
          CALL ERRWRT(-1,'Starting value for <number> is 0.5')
          CALL ERRWRT
     +    (1,'I suspect you are using an old script with a new version')
        ELSE
          CALL ERRWRT(-1,' ')
          CALL ERRWRT(0,'No such weighting scheme '//CVALUE(1)
     &             //CVALUE(ITK))
          CALL ERRWRT(-1,' ')
          IERROR = IERROR + 1
        ENDIF
        IF(ITK.GT.NTOK) RETURN
      ENDDO
 100  continue
C
      RETURN
      END
C
      SUBROUTINE SCALE_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &                   CVALUE,IERROR)
      use weights
      use agreem
      IMPLICIT NONE
      INCLUDE 'const.fh'
C
C---Reads keywords relevant to scaling of obsreved and calculated
C---structure factors
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL    FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4

      REAL RSSCMN,RSSCMX,SSSCMN,SSSCMX
      INTEGER ITT,ITK
      CHARACTER SCKEY*4
C
      IERROR = 0
      ITK=ITOK
      IF(NTOK.LE.ITOK) RETURN
      DO    ITT=ITOK,NTOK-1
        IF(CVALUE(ITK).EQ.'BAVE') THEN
C
C---Keep Average B-value of molecule BAVER_MOLEC. Could be usefull 
C---for low res refinement
          BAVER_MOLEC = -100.0
          IF(NTOK.GT.ITK) THEN
            ITK = ITK+1
             CALL GTNREA(ITK,1,BAVER_MOLEC,NTOK,ITYP,FVALUE) 
             UAVER_MOLEC = BAVER_MOLEC/PISQ8
          ENDIF
C  Allow these scaling types: BULK or SIMPLE
        ELSEIF(CVALUE(ITK).EQ.'TYPE') THEN
          ITK   = ITK+1
          SCKEY = CVALUE(ITK)(1:4)
          IF(SCKEY.NE.'BULK'.AND.SCKEY.NE.'SIMP') THEN
            CALL ERRWRT(-1,' Wrong Scaling type option')
            IERROR = IERROR + 1
          ENDIF
          IF(SCKEY.EQ.'BULK') THEN
            BULK_LS_FLAG              = .TRUE.
            ML_BULK_REFINE_FLAG       = .TRUE.
cd            D_ML_SCALE_BBULK          = 0.1
            D_ML_B_BBULK              = 100.0
            NSCOPT = 1
          ENDIF
          IF(SCKEY.EQ.'SIMP') THEN
            BULK_LS_FLAG = .FALSE.
            ML_BULK_REFINE_FLAG = .FALSE.
            D_ML_SCALE_BBULK    = 0.0
            D_ML_B_BBULK        = 100.0
            NSCOPT       = 0
          ENDIF
          ITK = ITK+1
        ELSEIF(CVALUE(ITK).EQ.'LSSC') THEN
C
C---For LS scaling
          ITK = ITK + 1
          IF(CVALUE(ITK).NE.'FREE'.AND.CVALUE(ITK).NE.'NCYC'.AND.
     &       CVALUE(ITK).NE.'EXPE'.AND.CVALUE(ITK).NE.'ANIS'.AND.
     +       CVALUE(ITK).NE.'ISOT'.AND.CVALUE(ITK).NE.'FIXB'.AND.
     +       CVALUE(ITK).NE.'APPL'.AND.CVALUE(ITK).NE.'TYPE') THEN
            CALL ERRWRT(-1,
     +              'Wrong option for scaling SCAL LSSC'//CVALUE(ITK))
            IERROR = IERROR + 1
          END IF
C Need to worry about either order..
 666      CONTINUE
          IF(ITK.GT.NTOK) RETURN
          IF(CVALUE(ITK).EQ.'FIXB') THEN
            ITK = ITK+1
 667        CONTINUE
            IF(CVALUE(ITK)(1:1).EQ.'B') THEN
              ITK = ITK+1
              IF(NTOK.GE.ITK) THEN
                CALL GTNREA(ITK,1,BLS_DEFINED,NTOK,ITYP,FVALUE)
                B_LS_BULK_REFINE_FLAG = .FALSE.
                B_LS_BULK             = ABS(BLS_DEFINED)
                ITK                   = ITK+1
              ENDIF
              GOTO 667
            ELSEIF(CVALUE(ITK)(1:1).EQ.'S') THEN
              ITK = ITK+1
              IF(NTOK.GE.ITK) THEN
                CALL GTNREA(ITK,1,SCLS_DEFINED,NTOK,ITYP,FVALUE)
                SCALE_LS_BULK             = ABS(SCLS_DEFINED)
                SCALE_LS_BULK_REFINE_FLAG = .FALSE.
                ITK                       = ITK+1
              ENDIF
              GOTO 667
            END IF
            GOTO 666
          END IF
          IF(CVALUE(ITK).EQ.'ANIS') THEN
            B_LS_ANISO_OVER_FLAG        = .TRUE.
            B_LS_ANISO_OVER_REFINE_FLAG = .TRUE.
            ILSSCALTYPOV                = 1
            LSSCALTYPE                  = 'ANISO'
            ITK                         = ITK+1
C
C---Aniso scale. Apply to observed 'OBSE', to calculated (default) 'CALC'
            IF(ITK+1.LE.NTOK) THEN
              IF(CVALUE(ITK).EQ.'APPL') THEN
                IF(CVALUE(ITK+1).EQ.'OBSE') THEN
                  APPLY_SCALE_TO = 'OBSE'
                ELSE
                  APPLY_SCALE_TO = 'CALC'
                ENDIF
                ITK = ITK+2
              ENDIF
            ENDIF
            GOTO 666
          ENDIF
          IF(CVALUE(ITK).EQ.'ISOT') THEN
            B_LS_ANISO_OVER_FLAG        = .FALSE.
            B_LS_ANISO_OVER_REFINE_FLAG = .FALSE.
            ILSSCALTYPOV                = 0
            LSSCALTYPE                  = 'ISOTR'
            ITK                         = ITK+1
C
C---iso scale. It has no effect. It is for just reducing user dependent error
            IF(ITK+1.LE.NTOK) THEN
              IF(CVALUE(ITK).EQ.'APPL') THEN
                IF(CVALUE(ITK+1).EQ.'OBSE') THEN
                  APPLY_SCALE_TO = 'OBSE'
                ELSE
                  APPLY_SCALE_TO = 'CALC'
                ENDIF
                ITK = ITK+2
              ENDIF
            ENDIF
            GOTO 666
          ENDIF
C  Maybe next word is NCYC?
          IF(CVALUE(ITK).EQ.'NCYC') THEN
            CALL GTNINT(ITK+1,1,NLSCYCL,NTOK,ITYP,FVALUE)
            ITK = ITK+2
            GO TO 666
          END IF
          IF(CVALUE(ITK).EQ.'EXPE') THEN
            ITK       = ITK+1
            LSEXPUSE = .TRUE.
            GO TO 666
          END IF
          IF(CVALUE(ITK).EQ.'TYPE') THEN
            ITK  = ITK+1
            SCKEY = CVALUE(ITK)(1:4)
            IF(SCKEY.NE.'BULK'.AND.SCKEY.NE.'SIMP') THEN
              CALL ERRWRT(-1,' Wrong Scaling type option')
              IERROR = IERROR + 1
            ENDIF
            IF(SCKEY.EQ.'BULK') THEN
              BULK_LS_FLAG              = .TRUE.
            ENDIF
            IF(SCKEY.EQ.'SIMP') THEN
              BULK_LS_FLAG = .FALSE.
            ENDIF
            ITK = ITK+1
          ENDIF
C
        ELSEIF(CVALUE(ITK).EQ.'MLSC') THEN
          ITK = ITK + 1
          IF(CVALUE(ITK).NE.'WORK' .AND. CVALUE(ITK).NE.'NCYC'
     +     .AND.CVALUE(ITK).NE.'NOEX'.AND.CVALUE(ITK).NE.'ANIS'.AND.
     +      CVALUE(ITK).NE.'ISOT'.AND.CVALUE(ITK).NE.'FIXB') THEN
       CALL ERRWRT(-1,'Wrong option for scaling SCAL MLSC'//CVALUE(ITK))
            IERROR = IERROR + 1
          END IF
C Need to worry about either order..
 777      CONTINUE
          IF(CVALUE(ITK).EQ.'FIXB') THEN
             ITK = ITK+1
 778         CONTINUE
             IF(CVALUE(ITK)(1:1).EQ.'B') THEN
               ITK = ITK+1
               IF(NTOK.GE.ITK) THEN
                 CALL GTNREA(ITK,1,BML_DEFINED,NTOK,ITYP,FVALUE)
                 MLBFIX = .TRUE.
                 ITK    = ITK+1
               ENDIF
               GOTO 778
             ELSEIF(CVALUE(ITK)(1:1).EQ.'S') THEN
               ITK = ITK+1
               IF(NTOK.GE.ITK) THEN
                 CALL  GTNREA(ITK,1,SCML_DEFINED,NTOK,ITYP,FVALUE)
                 MLSCFIX = .TRUE.
                 ITK     = ITK+1
               ENDIF
               GOTO 778
             ENDIF
             GOTO 777
           END IF         
           IF(CVALUE(ITK).EQ.'WORK') THEN
             MLUSEWORK = .TRUE.
             ITK = ITK+1
             GO TO 777
           END IF
           IF(CVALUE(ITK).EQ.'ANIS') THEN
             IMLSCALTYPOV = 1
             MLSCALTYPE = 'ANISO'
             ITK=ITK+1
             GOTO 777
           ENDIF
           IF(CVALUE(ITK).EQ.'ISOT') THEN
             IMLSCALTYPOV = 0
             MLSCALTYPE = 'ISOTR'
             ITK=ITK+1
             GOTO 777
           ENDIF
C  Maybe next word is NCYC?
           IF(CVALUE(ITK).EQ.'NCYC') THEN
             CALL GTNINT(ITK+1,1,NMLCYCL,NTOK,ITYP,FVALUE)
             ITK = ITK+2
             GO TO 777
           END IF
           IF(CVALUE(ITK).EQ.'NOEX') THEN
             ITK = ITK+1
             MLEXPUSE = .FALSE.
             GO TO 777
           END IF
C---Scaling type: Isotropic or anisotropic
         ELSEIF(CVALUE(ITK).EQ.'ALLS') THEN
           ITK = ITK + 1
           IF(CVALUE(ITK).EQ.'ANIS') THEN
             IMLSCALTYPOV = 1
             ILSSCALTYPOV = 1
             MLSCALTYPE = 'ANISO'
             LSSCALTYPE = 'ANISO'
           ELSEIF(CVALUE(ITK).EQ.'ISOT') THEN
             IMLSCALTYPOV = 0
             ILSSCALTYPOV = 0
             MLSCALTYPE = 'ISOTR'
             LSSCALTYPE = 'ISOTR'
           ENDIF
C---Resolution limits for scaling
         ELSEIF(CVALUE(ITK).EQ.'RESO') THEN
           ITK = ITK + 1
           CALL RDRESO(ITK,ITYP,FVALUE,NTOK,RSSCMN,RSSCMX,SSSCMN,
     +                SSSCMX)
           SMINS = SQRT(SSSCMN)/2.0
           SMAXS = SQRT(SSSCMX)/2.0
           ITK = ITK+2
          ELSEIF(CVALUE(ITK).EQ.'APPL') THEN
C
C---Apply overall B-value to observed or calculated str.factors
          ITK = ITK+1
          IF(CVALUE(ITK).EQ.'OBSE') THEN
            APPLY_SCALE_TO = 'OBSE'
            ITK = ITK+1
          ELSE
            APPLY_SCALE_TO = 'CALC'
            ITK = ITK+1
          ENDIF
        ELSE
          CALL ERRWRT(-1,' Unknown subkeyword of SCAL ')
          CALL ERRWRT(-1,' ????? '//CVALUE(ITK)//' ????? ')
          IERROR = IERROR + 1
        ENDIF
        IF(ITK.GE.NTOK) RETURN
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE READ_HYDROGEN_PARS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,
     &           FVALUE,CVALUE,IERROR)
      use weights
      use refi_flags
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'vitals.fh'
C
C---Input and output parameters
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER CVALUE(*)*4,LINE*(*)
C
c---Local parameters
      INTEGER ITK
C
      IERROR = 0
      ITK    = ITOK+1
 10   CONTINUE
      IF(CVALUE(ITK).EQ.'REFI'.OR.CVALUE(ITK).EQ.'NORE'.OR.
     &   CVALUE(ITK).NE.'BVAL') THEN
        IF(CVALUE(ITK).EQ.'REFI') THEN
          HYDROGEN_REFINE_FLAG = .TRUE.
          ITK = ITK + 1
          GOTO 10
        ELSEIF(CVALUE(ITK).EQ.'NORE') THEN
          HYDROGEN_REFINE_FLAG = .FALSE.
          ITK = ITK + 1
          GOTO 10
        ELSEIF(CVALUE(ITK).EQ.'BVAL') THEN
          ITK = ITK + 1
          IF(ITK.GT.NTOK) GOTO 100
          IF(CVALUE(ITK).EQ.'ISOT') THEN
            HYDROGEN_BVALUE = 'ISOT'
          ELSEIF(CVALUE(ITK).EQ.'ANIS') THEN
            HYDROGEN_BVALUE = 'ANIS'
          ELSE
            CALL ERRWRT(0,'Wrong subkeyword for REFI BVAL')
            CALL ERRWRT(0,'Acceptable subkeywords are:')
            CALL ERRWRT(0,'ISOT - isotropic refinement')
            CALL ERRWRT(0,'ANIS - Bvalue as of parent atom')
            IERROR = 1
            GOTO 100
          ENDIF
          GOTO 10
        ENDIF
      ELSE
        CALL ERRWRT(0,'Wrong subkeyword of HYDRogens')
        CALL ERRWRT(0,'Acceptable subkeywords are:')
        CALL ERRWRT(0,'REFI - refine hydrogens')
        CALL ERRWRT(0,'NORE - Use hydrogens for idealisation and'//
     &        ' structure factors calculation only')
        CALL ERRWRT(0,'BVAL - style for B value refinement')
        IERROR = 1
      ENDIF
 100  CONTINUE
      RETURN
      END
C
      SUBROUTINE REFI_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &           CVALUE,IERROR)
      use weights
      use refi_flags
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'anom.fh'
c
      INTEGER NTOK,ITOK,IERROR,ierr
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
C     
      INTEGER I,wave_now
      INTEGER IFIRST,ILAST
      CHARACTER CHNID*4
      REAL SMN
      INTEGER ITK
c
C   Set defaults
      ITK=ITOK
      IF(NTOK.LT.ITOK) RETURN
      DO    ITOK=2,NTOK
C  Allow these refinement types: RESTrained, UNREstrained, IDEAlise RIGId
        IF(CVALUE(ITK).EQ.'TYPE') THEN
          ITK = ITK+1
          IF(CVALUE(ITK).EQ.'IDEA') REFUSE = .FALSE.
          REFID = CVALUE(ITK)(1:4) 
          IF ( REFID.NE.'REST'.AND.REFID.NE.'UNRE'.AND.
     &         REFID.NE.'IDEA'.AND.REFID.NE.'RIGI'.AND.
     &         REFID.NE.'OCCU')   THEN 
             CALL ERRWRT(-1,' Wrong refinement option')
             IERROR = IERROR + 1
          ENDIF
          ITK = ITK + 1
C---Type of residuals
        ELSEIF(CVALUE(ITK).EQ.'RESI') THEN
          ITK = ITK+1
          REFS = CVALUE(ITK)
          IF ( REFS.NE.'LSQF'.AND.REFS.NE.'LSQI'.AND.
     &         REFS.NE.'MLKF') THEN
            CALL ERRWRT(-1,' Wrong residual option')
            IERROR = IERROR + 1
          ENDIF
          ITK = ITK+1
C---Resolution limits for refinement
        ELSEIF(CVALUE(ITK).EQ.'RESO') THEN
          ITK = ITK+1
          CALL RDRESO(ITK,ITYP,FVALUE,NTOK,ResMin,ResMax,STLMIN,
     +                     STLMAX)
          SMN = STLMIN
          STLMIN = SQRT(STLMIN)/2.0
          STLMAX = SQRT(STLMAX)/2.0
          ITK = ITK+2
        ELSEIF(CVALUE(ITK).EQ.'BREF') THEN
          ITK   = ITK+1
          ITEMP = 1
          bref_type = 'ISOT'
          IF(CVALUE(ITK).EQ.'ISOT') then
             ITEMP = 1
             bref_type = 'ISOT'
          elseif(CVALUE(ITK).EQ.'ANIS') then
             ITEMP = 2
             bref_type = 'ANIS'
          elseif(CVALUE(ITK).EQ.'OVER') then
             ITEMP = 0
             bref_type = 'OVER'
          elseif(CVALUE(ITK).EQ.'MIXE') then
             ITEMP = 3
             bref_type = 'MIXE'
          elseif(CVALUE(ITK).EQ.'ONLY') then
             ITEMP = -1
             bref_type = 'ONLY'
          elseif(cvalue(itk).eq.'UEST') then
             itemp = 1
             uval_estim_flag = .TRUE.
             if(nrandom_cycle.le.0) nrandom_cycle = 500
          else
             itemp = 1
             bref_type = 'ISOT'
          endif
          ITK = ITK+1
       elseif(cvalue(itk).eq.'BONL') then
          itk = itk + 1
          bref_type = 'ONLY'
       ELSEIF(CVALUE(ITK).EQ.'OREF') THEN
          ITK   = ITK+1
          if (CVALUE(ITK).EQ.'ALL') then
             OCCUP_REF_FLAG = .true. 
             OCCUP_REF_ANOMONLY_FLAG = .false. 
             OCCUP_set_by_user_FLAG = .true.
          elseif(CVALUE(ITK).EQ.'ANOM') then
             OCCUP_REF_FLAG = .true.
             OCCUP_REF_ANOMONLY_FLAG = .true.
             OCCUP_set_by_user_FLAG = .true.
          elseif(CVALUE(ITK).EQ.'NO') then
             OCCUP_REF_FLAG = .false.
             OCCUP_REF_ANOMONLY_FLAG = .false.
             OCCUP_set_by_user_FLAG = .true.
          else 
            OCCUP_REF_FLAG = .true.
            OCCUP_REF_ANOMONLY_FLAG = .true.
            OCCUP_set_by_user_FLAG = .true.
            occup_ref_anom_type_num = occup_ref_anom_type_num+1
            occup_ref_anom_type_lst(occup_ref_anom_type_num)=CVALUE(ITK)
          endif
          ITK = ITK+1
       ELSEIF(CVALUE(ITK).EQ.'METH') THEN
          ITK = ITK+1
          SOLVMIN = CVALUE(ITK)(1:4)
          IF(SOLVMIN.NE.'CGMA'.AND.SOLVMIN.NE.'CGRA'.AND.
     +         SOLVMIN.NE.'CDIR') THEN
             CALL ERRWRT(0,' Unknown method:'//SOLVMIN//
     +            ' reset to CGMA')
             SOLVMIN = 'CGMA'
          ENDIF
          ITK = ITK+1
       ELSEIF(CVALUE(ITK).EQ.'BFGS') THEN
          ITK = ITK + 1
          BFGS_FLAG = .TRUE.
          LINE_SEARCH_FLAG = .TRUE.
          WRITE(*,*)'In BFGS keywrod'
       ELSEIF(CVALUE(ITK).EQ.'LINE') THEN
          ITK = ITK + 1
          LINE_SEARCH_FLAG = .TRUE.
       ELSEIF(CVALUE(ITK).EQ.'NEST') THEN
          ITK = ITK+1
          CALL GTNINT(ITK,1,NESTIM,NTOK,ITYP,FVALUE)
          ITK = ITK+1
       ELSEIF(CVALUE(ITK).EQ.'WTXR'.OR.CVALUE(ITK).EQ.'SIGM') THEN
          CALL ERRWRT(-1,'This is an out of date weighting scheme')
          CALL ERRWRT(-1,'Use WEIGht MATRix <number> instead')
          CALL ERRWRT(-1,'Starting value for <number> is 0.5')
          CALL ERRWRT
     +    (1,'I suspect you are using an old script with a new version')
       ELSEIF(CVALUE(ITK).EQ.'PHAS') THEN
          ITK = ITK + 1 
          CALL READ_PHFACTORS(NTOK,ITK,CVALUE,ITYP,FVALUE)
       ELSEIF(CVALUE(ITK).EQ.'TLSR') THEN
          ITK = ITK + 1
          MODE  = 'TLSR'
          REFID = 'UNRE'
       ELSEIF(CVALUE(ITK).EQ.'TLSC') THEN
          ITK = ITK + 1
          IF(ITK.GE.NTOK) 
     &        CALL GTNINT(ITK,1,NTLS_CYCLE,NTOK,ITYP,FVALUE)
           IF(ITK.LE.NTOK) THEN
             CALL GTNINT(ITK,1,NTLS_CYCLE,NTOK,ITYP,FVALUE)
             ITK = ITK + 1
          ENDIF
        ELSEIF(CVALUE(ITK)(1:4).EQ.'XNON') THEN
          ITK = ITK + 1
          IF(CVALUE(ITK)(1:3).EQ.'NO') THEN
            XNONDIAG_FLAG = .FALSE.
          ELSE
            XNONDIAG_FLAG = .TRUE.
          ENDIF
          ITK = ITK + 1
        ELSEIF(CVALUE(ITK)(1:4).EQ.'EXCL') THEN
          ITK = ITK + 1
          IF(CVALUE(ITK)(1:3).EQ.'ALL') then
cd.or.
cd     &         CVALUE(ITK).eq.'REST'.or.
cd     &         CVALUE(ITK).eq.'REFI') THEN
            ITK = ITK + 1
            EXCL_REFI_FLAG = .TRUE.
cd            CALL READ_FROMTO(NTOK,ITK,CVALUE,ITYP,FVALUE,IFIRST,
cd     &        ILAST,CHNID)
            call read_fromto1(NTOK,ITK,CVALUE,line,ibeg,iend,ITYP,
     &           FVALUE,IFIRST,ILAST,CHNID,ierr)
            EXCL_REFI_NUM = EXCL_REFI_NUM + 1
            if(excl_refi_num.gt.max_excl_refi) then
               write(*,*)' Too many exclusions from refinement        '
               write(*,*)' Maximum exclusions allowed (refi_flags.fh) ',
     &              MAX_EXCL_REFI
               call errwrt(1,'Too many exclusions')
            endif
            EXCL_REFI_TYPE(EXCL_REFI_NUM)  = 'ALL'
            EXCL_REFI_BEGIN(EXCL_REFI_NUM) = IFIRST
            EXCL_REFI_END(EXCL_REFI_NUM)   = ILAST
            EXCL_REFI_CHN(EXCL_REFI_NUM)   = CHNID
          ENDIF
c new subkeywords
        ELSEIF(CVALUE(ITK).EQ.'AUTO')THEN
          PPI = 'auto'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'SIR')THEN
          PPI = 'sir'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'PL')THEN
          PPI = 'p+l'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'SIRH')THEN
          PPI = 'sirh'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'MLDR')THEN
          PPI = 'mldr'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'SAD') THEN
c          PPI = 'sad'
          PPI = 'sadh'
          ITK     = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'SADH') THEN
          PPI = 'sadh'
          ITK     = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'SRAS')THEN
          PPI = 'sras'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'HLDM')THEN
          PPI = 'hldm'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'WSAD')THEN
          PPI = 'sras'
          DPPI_wsad_hack = .true.
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'MAD')THEN
          PPI = 'mad'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'NO') THEN
          PPI = 'no'
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'SUBS') THEN
          if ( CVALUE(ITK+1).eq.'YES' ) then
            substruct_flag = .true.
            substruct_determine = .false.
          else if ( CVALUE(ITK+1).eq.'NO' ) then
            substruct_flag = .false.
            substruct_determine = .false.
          else if ( CVALUE(ITK+1).eq.'AUTO' ) then
c (default - do nothing)
          else
            CALL ERRWRT(-1,' Unknown subkeyword of REFI SUBS')
            CALL ERRWRT(-1,' ????? '//CVALUE(ITK+1)//' ????? ')
          endif
          if (ITK+1.gt.NTOK) 
     &      CALL  ERRWRT(0,'More input required for REFI SUBS keyword')
          ITK    = ITK + 2
          if ( ITK.le.NTOK) then 
            if ( CVALUE(ITK).eq.'FPP' ) then 
              HREF_FPP_FLAG = .true.
              ITK    = ITK + 1
            endif
          endif
        ELSEIF(CVALUE(ITK).EQ.'WLUZ') THEN
          write_luzzd_flag=.true.
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'RLUZ') THEN
          read_luzzd_flag=.true.
          ITK    = ITK + 1
        ELSEIF(CVALUE(ITK).EQ.'VERB') THEN
          VERBREF_5N = .true.
          ITK    = ITK + 1
        else if(cvalue(itk).eq.'SHAR') then
          itk = itk + 1
          if(itk.le.ntok) then
             if(ityp(itk).eq.2) then
                call gtnrea(itk,1,b_sharp_refine,ntok,ityp,fvalue)
                itk = itk + 1
             else
                do while(itk.lt.ntok) 
                   if(cvalue(itk).eq.'SCAL') then
                      itk = itk + 1
                      call gtnrea(itk,1,scale_sharp,ntok,ityp,fvalue)
                      itk = itk + 1
                   elseif(cvalue(itk).eq.'BVAL') then
                      itk = itk + 1
                      call gtnrea(itk,1,b_sharp_refine,ntok,ityp,fvalue)
                      itk = itk + 1
                   else
                      itk = itk + 1
                   endif
                enddo
             endif
          endif
        ELSE
          CALL ERRWRT(-1,' Unknown subkeyword of REFI ')
          CALL ERRWRT(-1,' ????? '//CVALUE(ITK)//' ????? ')
          IERROR = IERROR + 1
          ITK = ITK+1
        ENDIF
        IF(ITK.GT.NTOK) RETURN
      ENDDO
      RETURN
      END
C
      SUBROUTINE DATASET_INFO(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &           CVALUE,IERROR)
      use weights
      use refi_flags
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'anom.fh'
c
      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
C     
      INTEGER I
      INTEGER IFIRST,ILAST
      CHARACTER CHNID*1
      REAL SMN
      INTEGER ITK, act_dataset
C   Set defaults
      ITK=ITOK
      dataset_num_tot = dataset_num_tot + 1
      act_dataset = dataset_num_tot
      if (act_dataset.gt.MAX_DATASETS) then
        call ERRWRT(1,'The maximum number of datasets exceeded. '//
     &  'Increase MAX_DATASETS variable in refi_flags.fh and recompile')
      endif
cc      write(*,*) 'act_dataset',act_dataset
      dataset_dernum(act_dataset) = -10
      dataset_wavenum(act_dataset) = -10
      dataset_PM(act_dataset) = -10
      ITK = ITK+1
      IF(NTOK.LT.ITOK) RETURN
      DO    ITOK=2,NTOK
C  Number of derivative
        IF(CVALUE(ITK).EQ.'DERI') THEN
          ITK = ITK+1
c          if (FVALUE(ITK).gt.dataset_num) then
c            CALL ERRWRT(-1,' Derivative number is greater than '
c     &      //'total number of datasets ',dataset_num)
c          endif
c      dataset_dernum_tot = dataset_dernum_tot + 1
          dataset_dernum(act_dataset) = FVALUE(ITK)
cc       write(*,*)'dataset_dernum',dataset_dernum(act_dataset)
          ITK = ITK + 1
C Number of wavelength
        ELSEIF(CVALUE(ITK).EQ.'WAVE') THEN
          ITK = ITK+1
          dataset_wavenum(act_dataset) = FVALUE(ITK)
          if (dataset_wavenum(act_dataset).lt.0.or.
     &        dataset_wavenum(act_dataset).gt.MAXWAVEL) 
     &        CALL ERRWRT(1,'DATA WAVE must be between 1 and 4')
          ITK = ITK + 1
C Plus, minus or mean
        ELSEIF(CVALUE(ITK).EQ.'PLUS') THEN
          dataset_PM(act_dataset) = 1
          ITK = ITK+1
        ELSEIF(CVALUE(ITK).EQ.'MINU') THEN
          dataset_PM(act_dataset) = -1
          ITK = ITK+1
        ELSEIF(CVALUE(ITK).EQ.'MEAN') THEN
          dataset_PM(act_dataset) = 0
          ITK = ITK+1
        ELSE
          CALL ERRWRT(-1,' Unknown subkeyword of DATA ')
          CALL ERRWRT(-1,' ????? '//CVALUE(ITK)//' ????? ')
          IERROR = IERROR + 1
          ITK = ITK+1
        ENDIF
cc       write(*,*)'dataset_PM',dataset_PM(act_dataset)
        IF(ITK.GT.NTOK) RETURN
      ENDDO
      RETURN
      END
C

      SUBROUTINE MAKE_REST_PARAMS(NTOK,ITOK,LINE,IBEG,IEND,ITYP,FVALUE,
     &              CVALUE,IERROR)
      IMPLICIT NONE
      INCLUDE 'makecif.fh'

      INTEGER NTOK,ITOK,IERROR
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER LINE*(*),CVALUE(*)*4
C
      INTEGER ITK
C
      IERROR = 0

      DO  ITK = ITOK,NTOK,2
        IF(CVALUE(ITK).EQ.'HYDR') THEN
          MAKE_HFLAG = 'A'
          IF(ITK+1.LE.NTOK) THEN
           IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.CVALUE(ITK+1)(1:1).EQ.'N'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'A') THEN
               MAKE_HFLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &          'Wrong option for hydrogen generations '//CVALUE(ITK+1))
              CALL ERRWRT(0,'A, Y or N are allowed')
            ENDIF
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'HOUT') THEN
          MAKE_HFLAG_O = 'N'
          IF(ITK+1.LE.NTOK) THEN
            MAKE_HFLAG_O = CVALUE(ITK+1)(1:1)
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'VALU') THEN
          MAKE_NEWL_VALUE_FLAG = 'N'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'C') MAKE_NEWL_VALUE_FLAG = 'Y'
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'CHEC') THEN
          IF(CVALUE(ITK+1).EQ.'NONE'.OR.CVALUE(ITK+1)(1:1).EQ.'0') THEN
            MAKE_CHECK = '0'
          ELSEIF(CVALUE(ITK+1).EQ.'LIGA'.OR.
     &                 CVALUE(ITK+1)(1:1).EQ.'N') THEN
            MAKE_CHECK = 'N'
          ELSEIF(CVALUE(ITK+1)(1:3).EQ.'ALL'.OR.
     &                CVALUE(ITK+1)(1:1).EQ.'Y') THEN
            MAKE_CHECK = 'Y'
          ELSE
            CALL ERRWRT(0,'Wrong option of MAKE CHECK')
            CALL ERRWRT(0,'Possible options are NONE/LIGAnd/ALL')
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'NEWL') THEN
           IF(ITK+1.LE.NTOK) THEN
             IF(CVALUE(ITK+1)(1:1).EQ.'E') MAKE_LIGAND_LEVEL_FLAG='H'
             if(cvalue(itk+1)(1:1).eq.'C') MAKE_LIGAND_LEVEL_FLAG='Y'
             if(cvalue(itk+1)(1:1).eq.'Y') MAKE_LIGAND_LEVEL_FLAG='Y'
             if(cvalue(itk+1)(1:4).eq.'NOEX') make_ligand_level_flag='Y'
           ENDIF
        ELSEIF(CVALUE(ITK).EQ.'LIBR') THEN
          MAKE_FILE_LIB2 = LINE(IBEG(ITK+1):IEND(ITK+1))
          
        ELSEIF(CVALUE(ITK).EQ.'SPEC') THEN
          MAKE_CHECK_SPEC = 'N'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N') THEN
              MAKE_CHECK_SPEC = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &           'Wrong option for special positions '//CVALUE(ITK+1))
              CALL ERRWRT(0,'Y or N are allowed')
            ENDIF
          ENDIF 
        ELSEIF(CVALUE(ITK).EQ.'BUIL') THEN
          MAKE_RFLAG = 'N'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N') THEN
              MAKE_RFLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for rebuilding absent atoms '//CVALUE(ITK+1))
              CALL ERRWRT(0,'Y or N are allowed')
            ENDIF
          ENDIF  
        ELSEIF(CVALUE(ITK).EQ.'FORM') THEN
          MAKE_FORM = 'U'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'U'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'F') THEN
              MAKE_FORM = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for file formats '//CVALUE(ITK+1))
              CALL ERRWRT(0,'U or F are allowed')
            ENDIF
          ENDIF  
        ELSEIF(CVALUE(ITK).EQ.'PEPT') THEN
          MAKE_PEPT_FLAG = 'Y'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N') THEN
              MAKE_PEPT_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for peptide flag '//CVALUE(ITK+1))
              CALL ERRWRT(0,'U or F are allowed')
            ENDIF
          ENDIF  
        ELSEIF(CVALUE(ITK).EQ.'LINK') THEN
          MAKE_LNK_FLAG = 'Y'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'D'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'0') THEN
              MAKE_LNK_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for link corretions '//CVALUE(ITK+1))
              CALL ERRWRT(0,'Y, N, D or o are allowed')
            ENDIF
          ENDIF          
        ELSEIF(CVALUE(ITK).EQ.'SUGA') THEN
          MAKE_SUGAR_FLAG = 'Y'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'D'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'S') THEN
              MAKE_SUGAR_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for link corretions '//CVALUE(ITK+1))
              CALL ERRWRT(0,'Y, N or D are allowed')
            ENDIF
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'CONN') THEN
          MAKE_CONN_FLAG = 'N'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'D'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'0') THEN
              MAKE_CONN_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for connectivity corretions '//CVALUE(ITK+1))
              CALL ERRWRT(0,'Y, N, D or 0 are allowed')
            ENDIF
          ENDIF               
        ELSEIF(CVALUE(ITK).EQ.'SYMM') THEN
          MAKE_SYMM_FLAG = 'Y'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'C') THEN
              MAKE_SYMM_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for bonds between symmetric atoms '
     &                //CVALUE(ITK+1))
              CALL ERRWRT(0,'Y, N or C are allowed')
            ENDIF
          ENDIF                   
        ELSEIF(CVALUE(ITK).EQ.'CHAI') THEN
          MAKE_CHAIN_FLAG = 'Y'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N') THEN
              MAKE_CHAIN_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for chain correction '
     &                //CVALUE(ITK+1))
              CALL ERRWRT(0,'Y or N are allowed')
            ENDIF
          ENDIF  
        ELSEIF(CVALUE(ITK).EQ.'CISP') THEN
          MAKE_CIS_FLAG = 'Y'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N') THEN

              MAKE_CIS_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for cis/trans correction '
     &                //CVALUE(ITK+1))
              CALL ERRWRT(0,'Y or N are allowed')
            ENDIF
          ENDIF  
        ELSEIF(CVALUE(ITK)(1:2).EQ.'SS') THEN
          MAKE_SS_FLAG = 'Y'
          IF(ITK+1.LE.NTOK) THEN
            IF(CVALUE(ITK+1)(1:1).EQ.'Y'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'D'.OR.
     &         CVALUE(ITK+1)(1:1).EQ.'N') THEN

              MAKE_SS_FLAG = CVALUE(ITK+1)(1:1)
            ELSE
              IERROR = IERROR + 1
              CALL ERRWRT(0,
     &       'Wrong option for SSbridge correction '
     &                //CVALUE(ITK+1))
              CALL ERRWRT(0,'Y, N or D are allowed')
            ENDIF
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'SDMI') THEN
          MAKE_DMIN_SPEC = 0.5
          IF(ITYP(ITK+1).EQ.2) THEN
            CALL GTNREA(ITK+1,1,MAKE_DMIN_SPEC,NTOK,ITYP,FVALUE)
            IF(MAKE_DMIN_SPEC.LT.0.0) MAKE_DMIN_SPEC = 0.0
          ELSE
            CALL ERRWRT(0,'Wrong option for special position check')
            CALL ERRWRT(0,'Only number is allowed')
            IERROR = IERROR + 1
          ENDIF
       ELSEIF(CVALUE(ITK).EQ.'EXIT') THEN
          IF(ITK.LE.NTOK) THEN
            MAKE_EXIT = 'Y'
          ELSE
            MAKE_EXIT = 'N'
            IF(CVALUE(ITK+1)(1:1).EQ.'Y') MAKE_EXIT = 'Y'
          ENDIF
       elseif(cvalue(itk).eq.'SEGI') then
          
          if(itk.gt.ntok) then
             make_segid_in_flag = 'N'
             make_segid_out_flag= 'N'
          else
             make_segid_in_flag = 'N'
             make_segid_out_flag= 'N'
             if(cvalue(itk+1)(1:1).eq.'Y') then
                make_segid_in_flag = 'Y'
                make_segid_out_flag= 'Y'
             elseif(cvalue(itk+1)(1:1).eq.'O') then
                make_segid_out_flag='Y'
             endif
          endif
          write(*,*)'segid ',make_segid_in_flag
        ELSE
          CALL ERRWRT(0,'Wrong option for make restraints '
     &            //CVALUE(ITK))
          IERROR = IERROR + 1
          RETURN
        ENDIF
      ENDDO

      RETURN
      END
C
      subroutine mtz_params(labin_c,labout_c,ierror)
      use refi_flags
      implicit none
      include 'twin_refmac.fh'
      integer ierror
      character labin_c*(*),labout_c*(*)
c
      character refl_type*4
c
c---  body
      call identify_data_type
c
      if(reftyp(1:3).eq.'MTZ') then
         call mtz_params1(labin_c,labout_c,ierror)
      endif
      return
      end
c
      subroutine identify_data_type
      use refi_flags
      implicit none
      include 'twin_refmac.fh'
c
      integer ierr
      integer in_file
      character input_file*512
      character char4*4

      call getenv('HKLIN',input_file)
      call open_form_file(in_file,input_file,ierr)
      if(ierr.gt.0) then
         write(*,*)'Problem in input reflection file'
         call errwrt(1,'Cannot continue')
      endif
      read(in_file,'(a4)') char4
      if(char4(1:3).eq.'MTZ') then
         reftyp = 'MTZ'
      else if(char4(1:4).eq.'HKLF') then
         reftyp = 'HKL'
      else

      endif
      close(in_file)

      return
      end
c
      subroutine make_BDATA_OUT(BDATA,bdata_num,labout_map)
      use agreem
      use mtz_things
c prepares BDATA for the output mtz for a reflection (ccp4's lwrefl) by copying values from labouts
      implicit none
      integer bdata_num,i
      real bdata(bdata_num)
      integer labout_map(prgo)
c
      bdata(1:nlprgo) = labouts(labout_map(1:nlprgo))%val
      return
      end
c      
      subroutine make_PRGO(labout_map)
      use agreem
      use mtz_things
c rewrites the output labels in LSPRGO,CTPRGO and NLPRGO based on information in labouts
c returns a list with order numbers of columns to be used (in labout_map)
c (should be enogh to be called just once before mtz writing but can be called many times without problems)
      implicit none
      integer il,nlprgo_save
      integer labout_map(prgo)
c
      nlprgo=0
      do il=1,prgo
        if (labouts(il)%use) then
          nlprgo = nlprgo + 1
          LSPRGO(nlprgo) = labouts(il)%LSPRGO
          CTPRGO(nlprgo) = labouts(il)%CTPRGO
          labout_map(nlprgo) = il
        endif
      enddo

      return
      end
c
c
      SUBROUTINE MTZ_PARAMS1(LABIN_C,LABOUT_C,IERROR)
      use weights
      use agreem
      use map_routines
      use CellAndSymmetry
      use refi_flags
      use mtz_things
C
C---Reads relevant keywords for mtz file. Opens and reads 
C---some info from mtz file.
      IMPLICIT NONE
      include 'atom_com.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      include 'anom.fh'
      include 'twin_refmac.fh'

      CHARACTER LABIN_C*(*),LABOUT_C*(*)
      INTEGER IERROR


      INTEGER MPARS
      PARAMETER (MPARS = 200)
      INTEGER IBEG(MPARS),IEND(MPARS),IDEC(MPARS),ITYP(MPARS)
      REAL FVALUE(MPARS)
      CHARACTER CVALUE(MPARS)*4
C

      character lsprgo_prg(PRGO)*30
  
      INTEGER ILMAX,ILPRGO,NFPART,NAPART,ITOK,IP,NTOK,I,J,IS
      INTEGER JDO115,MTZOUT,IFAIL,NCOL,ILAB
      INTEGER IPRINT
      REAL SSTL,SMN,SMX
      REAL RRR(3,3,6),CELMTZ(6),CELL_T(6)
      CHARACTER KEY*4
      CHARACTER LINE1*128
      LOGICAL LPRINT,LEND,found
C 
C----Harvesting stuff

      integer ilprgo_start, lab_num_in, lab_num_out
      character string_i*3, ch

      character fp_name*30,cl_save*30,cl_tmp*30
      integer lc,lc_fp,ifirst_attempt
      integer fp,sfp,fm,sfm,numg,numl,fn,sfn,f,sf

      integer isym_unit,nospgr,nsymp
      CHARACTER NAMSPG_CIFS*20,NAMPG*20
      integer labout_map(prgo)
      integer temp_c
c
      lookup(1:3) = -1
      lookup(4:mcols) = 0

      lsprgi(1:mcols) = ' '
      ctprgi(1:mcols) = ' '

      nlprgi = 38
      lsprgi(i_H) = 'H'
      ctprgi(i_H) = 'H'
      lsprgi(i_K) = 'K'
      ctprgi(i_K) = 'H'
      lsprgi(i_L) = 'L'
      ctprgi(i_L) = 'H'
      lsprgi(i_FP) = 'FP'
      ctprgi(i_FP) = 'F'
      lsprgi(i_SIGFP) = 'SIGFP'
      ctprgi(i_SIGFP) = 'Q'
      lsprgi(i_FREE) = 'FREE'
      ctprgi(i_FREE) = 'I'
      lsprgi(i_FPART1) = 'FPART1'
      ctprgi(i_FPART1) = 'F'
      lsprgi(i_PHIP1) = 'PHIP1'
      ctprgi(i_PHIP1) = 'P'
      lsprgi(i_FPART2) = 'FPART2'
      ctprgi(i_FPART2) = 'F'
      lsprgi(i_PHIP2) = 'PHIP2'
      ctprgi(i_PHIP2) = 'P'
      lsprgi(i_FPART3) = 'FPART3'
      ctprgi(i_FPART3) = 'F'
      lsprgi(i_PHIP3) = 'PHIP3'
      ctprgi(i_PHIP3) = 'P'
      lsprgi(i_HLA) = 'HLA'
      ctprgi(i_HLA) = 'A'
      lsprgi(i_HLB) = 'HLB'
      ctprgi(i_HLB) = 'A'
      lsprgi(i_HLC) = 'HLC'
      ctprgi(i_HLC) = 'A'
      lsprgi(i_HLD) = 'HLD'
      ctprgi(i_HLD) = 'A'
      lsprgi(i_FOM) = 'FOM'
      ctprgi(i_FOM) = 'W'
      lsprgi(i_PHIB) = 'PHIB'
      ctprgi(i_PHIB) = 'P'
c--
      lsprgi(i_FP_MAP) = 'FP_MAP'
      ctprgi(i_FP_MAP) = 'F'
      lsprgi(i_SIGFP_MAP) = 'SIGFP_MAP'
      ctprgi(i_SIGFP_MAP) = 'Q'
      lsprgi(i_W) = 'W'
      ctprgi(i_W) = 'I'
      lsprgi(i_OBSD) = 'OBSD'
      ctprgi(i_OBSD) = 'I'
c--
c--- native F (for SIRAS). The same meaning as F but has to be different at input to distinguish SIRAS from SAD with F inputted.
      lsprgi(i_FN) = 'FN'
      ctprgi(i_FN) = 'F'
      lsprgi(i_SIGFN) = 'SIGFN'
      ctprgi(i_SIGFN) = 'Q'
c--- F+,F-
      lsprgi(i_FPL) = 'F+'
      ctprgi(i_FPL) = 'G'
      lsprgi(i_SIGFPL) = 'SIGF+'
      ctprgi(i_SIGFPL) = 'L'
      lsprgi(i_FMI) = 'F-'
      ctprgi(i_FMI) = 'G'
      lsprgi(i_SIGFMI) = 'SIGF-'
      ctprgi(i_SIGFMI) = 'L'
c
c---  Intensities
      lsprgi(i_IP) = 'IP'
      ctprgi(i_IP) = 'J'
      lsprgi(i_SIGIP) = 'SIGIP'
      ctprgi(i_SIGIP) = 'Q'
      lsprgi(i_IPL) = 'I+'
      ctprgi(i_IPL) = 'J'
      lsprgi(i_SIGIPL) = 'SIGI+'
      ctprgi(i_SIGIPL) = 'Q'
      lsprgi(i_IMI) = 'I-'
      ctprgi(i_IMI) = 'J'
      lsprgi(i_SIGIMI) = 'SIGI-'
      ctprgi(i_SIGIMI) = 'Q'

c
c---  output labels
      oc_H          => labouts(1)
      oc_K          => labouts(2)
      oc_L          => labouts(3)
      oc_FREE       => labouts(4)
      oc_FP         => labouts(5)
      oc_SIGFP      => labouts(6)
      oc_FC         => labouts(7)
      oc_PHIC       => labouts(8)
      oc_FC_ALL     => labouts(9)
      oc_PHIC_ALL   => labouts(10)
      oc_FWT        => labouts(11)
      oc_PHWT       => labouts(12)
      oc_DELFWT     => labouts(13)
      oc_PHDELWT    => labouts(14)
      oc_FOM        => labouts(15)
      oc_PHCOMB     => labouts(16)
      oc_FB         => labouts(17)
      oc_PHIB       => labouts(18)
      oc_HLA        => labouts(19)
      oc_HLB        => labouts(20)
      oc_HLC        => labouts(21)
      oc_HLD        => labouts(22)
      oc_F1         => labouts(23)
      oc_SIGF1      => labouts(24)
      oc_F2         => labouts(25)
      oc_SIGF2      => labouts(26)
      oc_F3         => labouts(27)
      oc_SIGF3      => labouts(28)
      oc_F4         => labouts(29)
      oc_SIGF4      => labouts(30)
      oc_F_user     => labouts(31)
      oc_PHI_user   => labouts(32)
      oc_FAN        => labouts(33)
      oc_PHAN       => labouts(34)
      oc_DELFAN     => labouts(35)
      oc_PHDELAN    => labouts(36)
      oc_HLACOMB    => labouts(37)
      oc_HLBCOMB    => labouts(38)
      oc_HLCCOMB    => labouts(39)
      oc_HLDCOMB    => labouts(40)
      oc_FC_ALL_LS  => labouts(41)
      oc_PHIC_ALL_LS => labouts(42)
      oc_OBSD       => labouts(43)
      labouts(44)%lsprgo = 'end'
c
c all output labels are initialized to false
      labouts(1:PRGO)%use = .false.
c
      oc_H%lsprgo = 'H'
      oc_H%ctprgo = 'H'
      oc_H%use = .true.
      oc_K%lsprgo = 'K'
      oc_K%ctprgo = 'H'
      oc_K%use = .true.
      oc_L%lsprgo = 'L'
      oc_L%ctprgo = 'H'
      oc_L%use = .true.
      oc_FREE%lsprgo = 'FREE'
      oc_FREE%ctprgo = 'I'
      oc_FREE%use = .true.
c
      oc_FP%lsprgo = 'FP'
      oc_FP%ctprgo = 'F'
      oc_FP%use = .true.
      oc_SIGFP%lsprgo = 'SIGFP'
      oc_SIGFP%ctprgo = 'Q'
      oc_SIGFP%use = .true.
c
      oc_FC%lsprgo = 'FC'
      oc_FC%ctprgo = 'F'
      oc_FC%use = .true.
      oc_PHIC%lsprgo = 'PHIC'
      oc_PHIC%ctprgo = 'P'
      oc_PHIC%use = .true.
C>IJT Add FC_ALL PHIC_ALL columns
      oc_FC_ALL%lsprgo = 'FC_ALL'
      oc_FC_ALL%ctprgo = 'F'
      oc_FC_ALL%use = .true.
      oc_PHIC_ALL%lsprgo = 'PHIC_ALL'
      oc_PHIC_ALL%ctprgo = 'P'
      oc_PHIC_ALL%use = .true.
      oc_FC_ALL_LS%lsprgo = 'FC_ALL_LS'
      oc_FC_ALL_LS%ctprgo = 'F'
      oc_FC_ALL_LS%use       = .true.
      oc_PHIC_ALL_LS%lsprgo = 'PHIC_ALL_LS'
      oc_PHIC_ALL_LS%ctprgo = 'P'
      oc_PHIC_ALL_LS%use    = .true.
                                !      if(twin_flag) then
                                !         oc_FC_ALL_LS%use   = .FALSE.
                                !         oc_PHIC_ALL_LS%use = .FALSE.
                                !      endif
      oc_FWT%lsprgo = 'FWT'
      oc_FWT%ctprgo = 'F'
      oc_FWT%use = .true.
      oc_PHWT%lsprgo = 'PHWT'
      oc_PHWT%ctprgo = 'P'
      oc_PHWT%use = .true.
      oc_DELFWT%lsprgo = 'DELFWT'
      oc_DELFWT%ctprgo = 'F'
      oc_DELFWT%use = .true.
      oc_PHDELWT%lsprgo = 'PHDELWT'
      oc_PHDELWT%ctprgo = 'P'
      oc_PHDELWT%use = .true.
c
      oc_FOM%lsprgo = 'FOM'
      oc_FOM%ctprgo = 'W'
      oc_FOM%use = .true.
      oc_PHCOMB%lsprgo = 'PHCOMB'
      oc_PHCOMB%ctprgo = 'P'
      oc_PHCOMB%use = .true.
      oc_HLACOMB%lsprgo = 'HLACOMB'
      oc_HLACOMB%ctprgo = 'A'
      oc_HLACOMB%use = .true.
      oc_HLBCOMB%lsprgo = 'HLBCOMB'
      oc_HLBCOMB%ctprgo = 'A'
      oc_HLBCOMB%use = .true.
      oc_HLCCOMB%lsprgo = 'HLCCOMB'
      oc_HLCCOMB%ctprgo = 'A'
      oc_HLCCOMB%use = .true.
      oc_HLDCOMB%lsprgo = 'HLDCOMB'
      oc_HLDCOMB%ctprgo = 'A'
      oc_HLDCOMB%use = .true.


C<IJT
c--
      oc_FB%lsprgo = 'FB'
      oc_FB%ctprgo = 'F'
      oc_PHIB%lsprgo = 'PHIB'
      oc_PHIB%ctprgo = 'P'
      oc_HLA%lsprgo = 'HLA'
      oc_HLA%ctprgo = 'A'
      oc_HLB%lsprgo = 'HLB'
      oc_HLB%ctprgo = 'A'
      oc_HLC%lsprgo = 'HLC'
      oc_HLC%ctprgo = 'A'
      oc_HLD%lsprgo = 'HLD'
      oc_HLD%ctprgo = 'A'
c     
      oc_F1%lsprgo = 'F+'
      oc_F1%ctprgo = 'G'
      oc_SIGF1%lsprgo = 'SIGF+'
      oc_SIGF1%ctprgo = 'L'
      oc_F2%lsprgo = 'F-'
      oc_F2%ctprgo = 'G'
      oc_SIGF2%lsprgo = 'SIGF-'
      oc_SIGF2%ctprgo = 'L'
c
      oc_F_user%lsprgo = 'F_user'
      oc_F_user%ctprgo = 'F'
      oc_phi_user%lsprgo = 'PHI_user'
      oc_phi_user%ctprgo = 'P'
      oc_FAN%lsprgo = 'FAN'
      oc_FAN%ctprgo = 'F'
      oc_PHAN%lsprgo = 'PHAN'
      oc_PHAN%ctprgo = 'P'
      oc_DELFAN%lsprgo = 'DELFAN'
      oc_DELFAN%ctprgo = 'F'
      oc_PHDELAN%lsprgo = 'PHDELAN'
      oc_PHDELAN%ctprgo = 'P'
      oc_HLACOMB%lsprgo = 'HLACOMB'
      oc_HLACOMB%ctprgo = 'A'
      oc_OBSD%lsprgo = 'OBSD'
      oc_OBSD%ctprgo = 'I'
c
      lsprgo_prg(1:PRGO) = labouts(1:PRGO)%lsprgo
c
c  assign correct labels and types to LSPRGI/CTPRGI and *O for datasets
c (F_1,...F_n,SIGF_1,...,SIGF_n)
c (this is the general approach - for SAD/SIRAS it can also be assigned separately)
      if (dataset_num_tot.gt.4) 
     &     call errwrt(1,'At most 4 DPPI datasets supported')
      lab_num_in = i_FPL
      if (ppi.eq.'sras')  lab_num_in = i_FN
      lab_num_out = 0
C
      i=1
      do while (labouts(i)%LSPRGO.ne.'end'.and.lab_num_out.eq.0)
         if (labouts(i)%LSPRGO.eq.'F+') lab_num_out = i
         i=i+1
      enddo
      if (lab_num_out.eq.0) call errwrt(1,'Unexptected error in rcard')
      do i = 1, dataset_num_tot
         call itoa(i,string_i,3)
         LSPRGI(lab_num_in) = 'F_'//trim(string_i)
         labouts(lab_num_out)%LSPRGO = 'F_'//trim(string_i)
         if ( dataset_PM(i).eq.0 ) then
            CTPRGI(lab_num_in)='F'
            labouts(lab_num_out)%CTPRGO = 'F'
         else
            CTPRGI(lab_num_in)='G'
            labouts(lab_num_out)%CTPRGO = 'G'
         endif
         lab_num_in = lab_num_in + 1
         lab_num_out = lab_num_out + 1
         LSPRGI(lab_num_in) = 'SIGF_'//trim(string_i)
         labouts(lab_num_out)%LSPRGO = 'SIGF_'//trim(string_i)
         if ( dataset_PM(i).eq.0 ) then
            CTPRGI(lab_num_in)='Q'
            labouts(lab_num_out)%CTPRGO = 'Q'
         else
            CTPRGI(lab_num_in)='L'
            labouts(lab_num_out)%CTPRGO = 'L'
         endif
         lab_num_in = lab_num_in + 1
         lab_num_out = lab_num_out + 1
      enddo
c
      celmtz(1:6) = 0.0
      MTZIN  = 1
      NTOK = MPARS
c
      LPRINT = .FALSE.
      IPRINT = 0
      IFAIL  = -1
      call lropen(1,'HKLIN',iprint,ifail)
      clabs(1:mcols) = ' '
      ctyps(1:mcols) = ' '
      call lrclab(1,clabs,ctyps,ncol)
c
c--   Take default labins
      if(labin_c.eq.' ') then
         labin_c = 'LABIN'
         if (PPI.eq.'sad'.or.PPI.eq.'sadh') goto 11
c     
c---  If twin defined then use intensities if available
c---  if only intensities available use them.
c---  Problem: When intensities and F available what to do?
         do  i=1,ncol
            if(ctyps(i).eq.'F') then
               labin_c = trim(labin_c)//' FP='//trim(clabs(i))
               fp_name = trim(clabs(i))
               goto 10
            endif
         enddo
         call errwrt(-1,' ')
         call errwrt(-1,'There is no structure factor amplitudes'//
     &        ' in the file.')
         call errwrt(-1,'Please check your mtz file. It may contain'//
     &        ' only intensities.')
         call errwrt(1,'Fatal error. Stopping now')
 10      continue
         lc_fp = len_trim(fp_name)
         ifirst_attempt = 0
         do  i=1,ncol
            if(ctyps(i).eq.'Q') then
c
c--Keep the first one just in case
               if(ifirst_attempt.eq.0) then
                  cl_save = clabs(i)
                  ifirst_attempt = 1
               endif
               cl_tmp = clabs(i)
               call ccpupc(cl_tmp(1:3))
               if(trim(cl_tmp).eq.'SIG'//trim(fp_name)) then
                  labin_c = trim(labin_c)//' SIGFP='//trim(clabs(i))
                  exit
               endif
            endif
         enddo
         labin_c = trim(labin_c)//' SIGFP='//trim(cl_save)
 11      continue
         do  i=1,ncol
            if(ctyps(i).eq.'I') then
               labin_c = trim(labin_c)//' FREE='//trim(clabs(i))
               exit
            endif
         enddo
         if(.not.twin_flag) then
            do i=1,ncol
               if(ctyps(i).eq.'I'.and.clabs(i).eq.'OBSD') then
                  labin_c = trim(labin_c)//' OBSD='//trim(clabs(i))
                  oc_OBSD%use = .TRUE.
                  exit
               endif
            enddo
         endif
c if DPPI target specified but none of f+ etc supplied then try to assign them automatically
c we have to rely here on +,- etc symbols in the name of the labels
c only implemented for sad, it is hard to do for siras.
c         if(len_trim(labout_c).le.0) then
c            labout_c = labin_c
c         endif
c
         if (PPI.eq.'sad'.or.PPI.eq.'sadh') then
            numg=0
            numl=0
            do  i=1,ncol
               lc = len_trim(clabs(i))
               found=.false.
               if(ctyps(i).eq.'G'.or.ctyps(i).eq.'L') then
                  do j=1,lc
                     if ( clabs(i)(j:j).eq.'+' .or.
     &                    (j+1.le.lc.and.clabs(i)(j:j+1).eq.'PL') ) then
                        found=.true.
                     endif
                  enddo
                  if (found) then
                    if(ctyps(i).eq.'G') then
                       numg=numg+1
                       labin_c = trim(labin_c)//' F_1='//trim(clabs(i))
                    else
                     numl=numl+1
                     labin_c = trim(labin_c)//' SIGF_1='//trim(clabs(i))
                   endif
                 else
                    do j=1,lc
                       if ( clabs(i)(j:j).eq.'-' .or.
     &                   (j+1.le.lc.and.clabs(i)(j:j+1).eq.'MI') ) then
                          found=.true.
                       endif
                    enddo
                    if (found) then
                       if(ctyps(i).eq.'G') then
                         numg=numg+1
                         labin_c =trim(labin_c)//' F_2='//trim(clabs(i))
                       else
                          numl=numl+1
                          labin_c = 
     &                         trim(labin_c)//' SIGF_2='//trim(clabs(i))
                       endif
                    endif
                 endif
              endif
           enddo
           if (numg.ne.2.or.numl.ne.2)call errwrt(1,'Refmac could not'//
     &  'assign F+ and F- automatically, please specify them by LABIN')
        endif
c
c---Phases may need to be added

c
c---If intensities they may need to be used
      endif      
c
c---  If labin is still empty then fail
      if(len_trim(labin_c).le.0) call errwrt(1,
     &     'Input does not seem to be correct mtz file')
      CALL PARSER(KEY,LABIN_C,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,NTOK,
     &     LEND,LPRINT)
      CALL LKYIN(1,LSPRGI,NLPRGI,NTOK,LABIN_C,IBEG,IEND)
      ITOK = 2
      lsusrj(1:mcols) = ' '
      CALL LKYSET(LSPRGI,NLPRGI,LSUSRJ,LOOKUP,ITOK,NTOK,LABIN_C,IBEG,
     &     IEND)
c
c---  Take lookup values
      NFPART  = 0
      NAPART  = 0 
      NPART   = 0
      NSCPART = 0
c
c---Free_R factor
      IF (LOOKUP(i_FREE).NE.0) THEN
         FREER_FLAG = .TRUE.
C  Has Free R exclusion been set to something other than 0
         IF ( LFreeRexcludeVal .EQ.-999) LFreeRexcludeVal = 0
      else
         MLUSEWORK = .TRUE.
      END IF
      if(lookup(i_OBSD).ne.0) obsd_flag = .TRUE.

c
c---Fpart input?
      if (nmaxpart.gt.3) call errwrt(1,'Up to 3 partials supported')
      DO    IP=0,NMAXPART-1
         IF ( LOOKUP(i_FPART1+2*ip).NE.0 .AND.
     &        LOOKUP(i_PHIP1+2*ip).NE.0 ) THEN
            FPART_FLAG = .TRUE.
            NPART      = NPART + 1
            IF( ISCPART(IP+1) .NE.0) NSCPART = NSCPART + 1
C  But this is not output - overwritten by map coefficients
         ELSEIF( ( LOOKUP(i_FPART1+2*ip).NE.0.AND.
     &           LOOKUP(i_PHIP1+2*ip).EQ.0 ) .OR.
     &           ( LOOKUP(i_FPART1+2*ip).EQ.0.AND.
     &           LOOKUP(i_PHIP1+2*ip).NE.0 ) ) THEN
            WRITE(LINE1,'(A,I5,A)')' Amplitudes or phases for partial ',
     +        IP,' structure has not been assigned. Please correct'//
     +        'your input and rerun'
            CALL ERRWRT(1,LINE1)
         END IF
      ENDDO
      IF(LOOKUP(i_HLA).NE.0.and.LOOKUP(i_HLB).NE.0) then
         MIR_FLAG = .TRUE.
      ELSEIF( (LOOKUP(i_HLA).EQ.0.AND.LOOKUP(i_HLB).NE.0) .or.
     +        (LOOKUP(i_HLA).NE.0.AND.LOOKUP(i_HLB).EQ.0) )THEN
         WRITE(LINE1,'(A)')' A or B for MIR/MAD has not been '//
     +        'assigned. Please correct your input and rerun.'
         CALL ERRWRT(1,LINE1)
      ENDIF
      IF(LOOKUP(i_FOM).NE.0.AND.LOOKUP(i_PHIB).NE.0) THEN
         PHASE_FLAG = .TRUE.
      ELSEIF(LOOKUP(i_FOM).EQ.0.AND.LOOKUP(i_PHIB).NE.0) THEN
         PHASE_FLAG = .TRUE.
         CALL ERRWRT(0,
     +        'Figure of merit of phases has not been assigned')
         CALL ERRWRT(0,'They will be assumed to be equal to 1.0')
      ENDIF
c
      if(lookup(i_FP_MAP).ne.0.and.lookup(i_SIGFP_MAP).ne.0) then
         fomap_flag = .TRUE.
      endif
      if(lookup(i_W).ne.0)then
         foweight_flag = .TRUE.
      endif
      f=lookup(i_FP)
      sf=lookup(i_SIGFP)
      fn=lookup(i_FN)
      sfn=lookup(i_SIGFN)
      fp=lookup(i_FPL)
      sfp=lookup(i_SIGFPL)
      fm=lookup(i_FMI)
      sfm=lookup(i_SIGFMI)
c if dppi not sppecified by target but f+ etc supplied then DPPI is used
      if ( (fp.ne.0.or.sfp.ne.0.or.fm.ne.0.or.sfm.ne.0.) 
     +     .and. (PPI.eq.'no') )  then
        if (fn.ne.0.or.sfn.ne.0) then
          PPI = 'sras'
          if (f.eq.0.or.sf.eq.0) then
            labin_c = trim(labin_c)//' FP='//trim(lsusrj(i_fn))
            labin_c = trim(labin_c)//' SIGFP='//trim(lsusrj(i_sigfn))
            CALL PARSER(KEY,LABIN_C,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,
     &        NTOK,LEND,LPRINT)
            CALL LKYIN(1,LSPRGI,NLPRGI,NTOK,LABIN_C,IBEG,IEND)
            ITOK = 2
            CALL LKYSET(LSPRGI,NLPRGI,LSUSRJ,LOOKUP,ITOK,NTOK,LABIN_C,
     &        IBEG,IEND)
            f=lookup(i_FP)
            sf=lookup(i_SIGFP)
          endif
        else
          PPI = 'sadh'
        endif
        call set_datasets_for_target(PPI)
        if (anom_maponly_flag)  PPI='no'
      endif
c
c---  SAD etc
      if (PPI.ne.'no') then
        oc_FB%use = .true.
        oc_PHIB%use = .true.
        oc_HLA%use = .true.
        oc_HLB%use = .true.
        oc_HLC%use = .true.
        oc_HLD%use = .true.
      endif
      if (PPI.eq.'sad'.or.PPI.eq.'sadh'.or.PPI.eq.'sras'.or.
     &  anom_maponly_flag)  then
        if (PPI.ne.'sras') lookup(4:5) = 0
        oc_FAN%use = .true.
        oc_PHAN%use = .true.
        oc_DELFAN%use = .true. 
        oc_PHDELAN%use = .true.
          if (fp.eq.0.or.sfp.eq.0.or.fm.eq.0.or.sfm.eq.0.)   then
              WRITE(LINE1,'(A)')'At least one of F+,F-,SIGF+ or SIGF-'//
     +          ' has not been assigned. '
              CALL ERRWRT(0,LINE1)
        endif
      endif
      if ((lookup(i_IP).ne.0.or.lookup(i_SIGIP).ne.0) .and.
     &    (ctprgi(i_SIGIP).eq.'J') .and. PPI.eq.'no' )then
        intens_flag = .TRUE.
      endif

 500  CONTINUE
      IF(IFAIL.GT.0) CALL ERRWRT(1,' Reflection file ')
      NDATASETS = MSETS
      CALL LRASSN(MTZIN,LSPRGI,NLPRGI,LOOKUP,CTPRGI)
c
CMDW-4.2      CALL LRID(MTZIN,PNAME,DNAME,ISETS,NDATASETS)
C     Notify available space
      call refmac_mtz_lookup

      CALL LRIDX(MTZIN,PNAME,XNAME,DNAME,ISETS,
     +             DATCELL,DATWAVE,NDATASETS)
C
C---- Get dataset ID for column and match to dataset header info.
      IF (NDATASETS.GT.0) CALL LRCLID(MTZIN,CSETID,NCOL)
C
C---- Copy over FP SIGFP information for output if required 
      if (LookUp(4).ne.0.and.LookUp(5).ne.0) then
       labouts(5:6)%LSPRGO = clabs(lookup(4:5))
        labouts(5:6)%CTPRGO = ctyps(lookup(4:5))
      endif
c
C----   Is FreeRFlag  set
      IF (LookUp(i_FREE).NE.0) THEN
        oc_FREE%LSPRGO = CLABS(LookUp(i_FREE))
        oc_FREE%CTPRGO = CTYPS(LookUp(i_FREE))
C  The FreeRflag should belong to the base data set
        IF (NDATASETS.GT.0) CSETOUT(4) = CSETID(LookUp(1))
      END IF
C
C-----Knock off the PHICOMB label
c      ENDIF
        if(.not.mir_flag.and..not.phase_flag.and.
     &     .not.out_distrib_flag) then
           oc_PHCOMB%use = .false.
        endif
      if (.not.out_distrib_flag) then
c        oc_PHCOMB%use = .false.
        oc_HLACOMB%use = .false.
        oc_HLBCOMB%use = .false.
        oc_HLCCOMB%use = .false.
        oc_HLDCOMB%use = .false.

      endif

C
C---Add users coefficients.
      if(scale_map_calc.gt.0.0.or.scale_map_obs.gt.0.0) then
        oc_F_user%use = .true.
        oc_PHI_user%use = .true.
      endif
C
C---- Move  FC PHIC WWT DELFWT PHICOMB labels if No FreeRflag
      ilprgo_start = 7
      IF (LookUp(i_FREE).EQ.0) THEN
        ilprgo_start = 6
        oc_FREE%use = .false.
      END IF 
c

C
C----In case LSQ we have only 7 or 8 output labels
      IF(REFS.EQ.'LSQF') THEN
         do i=9,PRGO
            labouts(i)%use = .false.
         enddo
      ENDIF
      NTOK = MPARS
      CALL PARSER(KEY,labin_c,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,
     &     NTOK,LEND,.FALSE.)

      do i=1,ntok
         LINE1=labin_c(ibeg(i):iend(i))
c         if(trim(LINE1).eq.trim(oc_SIGF1%lsprgo)) oc_SIGF1%use=.true.
c         if(trim(LINE1).eq.trim(oc_F1%lsprgo)  )  oc_F1%use=.true.
c         if(trim(LINE1).eq.trim(oc_SIGF2%lsprgo)) oc_SIGF2%use=.true.
c         if(trim(LINE1).eq.trim(oc_F2%lsprgo))    oc_F2%use=.true.
      enddo
C
c--- make initial prgo. Final version in oppro right before output
c       (when we have all the necessary information)
      call make_PRGO(labout_map)

c
c---All output labels inherit FP or F+ or IP dataset ids
      setid = 0
      if (LookUp(i_FP).ne.0) then
         setid = csetid(lookup(i_FP))
      elseif (LookUp(i_FPL).ne.0) then
         setid = csetid(lookup(i_FPL))
      elseif(LookUp(i_IP).ne.0) then
         setid = csetid(lookup(i_IP))
      endif
c     
c---  Sort these out properly soon. We have only two datasets: Base dataset and
c---  crystal dataset. Crystal dataset inherits everything from FP, F+ or IP
      ndatasets_out = 0
      IF (NDATASETS.GT.0.and.setid.gt.0) THEN
         pname_out(1) = pname(1)
         dname_out(1) = dname(1)
         xname_out(1) = xname(1)
         datwave_out(1) = datwave(1)
         datcell_out(1:6,1) = datcell(1:6,1)
         csetout(5:nlprgo) = 1
         csetout(1:3) = csetid(lookup(1))
         if(freer_flag) then
            CSETOUT(4) = CSETID(LookUp(1))
         else
            csetout(4) = 1
         endif
         i = 1
         do while(i.le.ndatasets.and.isets(i).ne.setid)
            i = i + 1
         enddo
         if (i.le.ndatasets) then
            pname_out(2) = pname(i)
            dname_out(2) = dname(i)
            xname_out(2) = xname(i)
            datwave_out(2) = datwave(i)
            datcell_out(1:6,2) = datcell(1:6,i)
            ndatasets_out = 2
            celmtz(1:6) = datcell(1:6,i)
c--   Take wavelength from dataset info. Based on FP or IP or F+ for SAD 
c--   todo: more wavelengths (SIRAS etc)
c--   If user has defined wavelength use it. 
            if(wavelength(1).le.0.0) wavelength(1) = datwave(i)
         else
            call errwrt(0,'Problem accessing datasets in mtz')
         endif
      endif
c     
      CALL LRSORT(MTZIN,ISORT)
c--   
c--   Cell is selected from datasets, see above. Just use lrcell in case
c--   no dataset information.
      if (minval(celmtz(1:6)).le.0.0.or.setid.le.0.or.
     &     ndatasets.le.0) then
         call lrcell(mtzin,celmtz)
      endif
C
C---  If cell dimensions are different keep old cells
C---  If there were no cells take new one)
      DO    I=1,6
         CELL_T(I) = CELMTZ(I)
      ENDDO
      CALL CHECK_CELL(CELL_T,IERROR)
      IF(IERROR.EQ.3) THEN
         CALL ERRWRT(1,'Difference between cells from mtz and previous'
     &        //' ones is more than 10% ' )
      ENDIF
      CALL LSTRSL(MTZIN,CELMTZ(1),CELMTZ(2),CELMTZ(3),
     +     CELMTZ(4),CELMTZ(5),CELMTZ(6))
C
C     Return CELL volume, and reciprocal cell for celsym.f90
      DO   I=1,6
         CELL_T(I) = CELL(I)
      ENDDO

      IF(CELL(4).LE.5.0.AND.CELL(5).LE.5.0.AND.CELL(6).LE.5.0) THEN
         cell_t(4:6) = cell(4:6)*rtodeg
      ENDIF
c
c---- IT should be outside of this routine
      CALL RBFRO1(CELL_T,VOLUME,RRR)
      CALL RBRCEL(RCELL,RVOL)
C
C---  Read resolution
      CALL LRRSOL(MTZIN,SMN,SMX)
      SMN = SQRT(SMN)/2.0
      SMX = SQRT(SMX)/2.0
      IF(STLMIN.LE.0.0) STLMIN = SMN
      IF(STLMIN.LT.SMN) STLMIN = SMN
      IF(STLMAX.LE.0.0) STLMAX = SMX
      IF(STLMAX.GT.SMX) STLMAX = SMX
C     Scaling resolution: if not set on data line use full resolution range. The following should be banned
      IF(SMINS.EQ.0.04 .AND. SMAXS .EQ.1.0) THEN
         SMINS = STLMIN
         SMAXS = STLMAX
      END IF
      stlmin_input = stlmin
      stlmax_input = stlmax
C     If a Range set for analysis, work out the number of bins now.
      SSTL = 4.0*STLMAX*STLMAX
      IF(RANGE.LT.-0.5) THEN
         RANGE = SSTL/NBIN
      END IF
C
C---  Read symmetry and check against old symmetry. MTZ symmetry has 
C---  highest priorety
      ISPNO = 1
      LPRINT = .FALSE.
      CALL LRSYMI(MTZIN,NumPrimSymm,Ltype,NumSpaceGroup,
     +     SpaceGroupName,PointGroupName)

      nospgr = 0
      if(len_trim(SpaceGroupName).le.1) then
         SpaceGroupName = ' '
         nospgr = NumSpaceGroup
      endif
      if(NumSpaceGroup.eq.1018) SpaceGroupName = 'P 21 21 2 (a)'
c
c---Add R3 and all other rubbish here.
      if(trim(SpaceGroupName).eq.'R 3'.or.
     &     trim(SpaceGroupName).eq.'R3') then
         if(celmtz(6).le.5.0) then
            temp_c = nint(celmtz(6)*rtodeg)
         else
            temp_c = nint(celmtz(6))
         endif
         if(celmtz(1).eq.celmtz(2).and.temp_c.eq.120) then
            SpaceGroupName = 'H3'
         endif
      else if(trim(SpaceGroupName).eq.'H 3'.or.
     &        trim(SpaceGroupName).eq.'H3') then
         if(celmtz(1).eq.celmtz(2).and.celmtz(1).eq.celmtz(3).and.
     &        celmtz(4).eq.celmtz(6).and.
     &        celmtz(4).eq.celmtz(6)) then
            SpaceGroupName = 'R3'
         endif
      endif
      if(trim(SpaceGroupName).eq.'R 3 2'.or.
     &     trim(SpaceGroupName).eq.'R32') then
         if(celmtz(6).le.5.0) then
            temp_c = nint(celmtz(6)*rtodeg)
         else
            temp_c = nint(celmtz(6))
         endif
         if(celmtz(1).eq.celmtz(2).and.temp_c.eq.120) then
            SpaceGroupName = 'H32'
         endif
      else if(trim(SpaceGroupName).eq.'H 3 2'.or.
     &        trim(SpaceGroupName).eq.'H32') then
         if(celmtz(1).eq.celmtz(2).and.celmtz(1).eq.celmtz(3).and.
     &        celmtz(4).eq.celmtz(6).and.
     &        celmtz(4).eq.celmtz(6)) then
            SpaceGroupName = 'R32'
         endif
      endif
c      stop
c      nospgr = 0
      isym_unit = 0
      CALL MSYMLB3(ISYM_UNIT,NOSPGR,SpaceGroupName,NAMSPG_CIFS,
     +     NAMPG,NSYMP,NumSymmetry,RealSymmMatrx)
      NumSpaceGroup = nospgr
c
      CALL LRSYMM(MTZIN,NumSymmetry,RealSymmMatrx)
      CALL PGDEFN(PointGroupName,NumPrimSymm,NumSymmetry,
     +     RealSymmMatrx,LPRINT)
      CALL PGNLAU(PointGroupName,NumLaueSymm,LaueGroupName)
C
C---- Now set up the extinction check for soutfC
      CALL EPSLN(NumSymmetry,
     +     NumPrimSymm,
     +     RealSymmMatrx,
     +     0)
      CALL CENTRIC(NumSymmetry,
     +     RealSymmMatrx,
     +     0)
      NSMULT = NumSymmetry/NumPrimSymm
C
C---Compare symmetry
      IF(ISPNO.GT.1) THEN
         IF(ISPNO.NE.NumSpaceGroup) THEN
            CALL ERRWRT(0,'Space group from mtz is different ')
         ENDIF
      ELSE
         rot(1:3,1:3,1:numsymmetry)=realsymmmatrx(1:3,1:3,1:numsymmetry)
         tr(1:3,1:numsymmetry)=realsymmmatrx(1:3,4,1:numsymmetry)
         NSYM  = NumSymmetry
         ISPNO = NumSpaceGroup
      END IF
      CALL TKNONCUB
c
c---If twin refinement then change output labels
c      if(twin_flag) then
c         oc_FP%lsprgo = 'Fout_refmac'
c         oc_SIGFP%lsprgo = 'SIGFout_refmac'
c      endif

      RETURN
      END
c
      subroutine refmac_mtz_lookup
      use agreem
      use mtz_things
      implicit none
c
c---  locals
      integer ip
c
c---  body
      ifo = lookup(4)
      iso = lookup(5)
      ifree_o = lookup(i_FREE)
      do ip=0,nmaxpart-1
         ifpart(ip+1) = lookup(i_FPART1+2*ip)
         iapart(ip+1) = lookup(i_PHIP1+2*ip)
      enddo
      ihla = lookup(i_HLA)
      ihlb = lookup(i_HLB)
      ihlc = lookup(i_HLC)
      ihld = lookup(i_HLD)
      ipb = lookup(i_PHIB)
      ifom = lookup(i_FOM)
      ifo_map = lookup(i_FP_MAP)
      isigo_map = lookup(i_SIGFP_MAP)
      ifo_weight = lookup(i_W)
c
c---  sad things
      ifoall(1) = lookup(i_FPL)
      isoall(1) = lookup(i_SIGFPL)
      ifoall(2) = lookup(i_FMI)
      isoall(2) = lookup(i_SIGFMI)
c
c---  intensity things
      i_int_o = lookup(i_IP)
      i_int_sig_o = lookup(i_SIGIP)

      return
      end
c
      subroutine refmac_generate_labout(labout_c)
      implicit none
      character labout_c*(*)
c
c---- body

      return
      end
c
      SUBROUTINE NCSR_PARAMS(NTOK,ITOK_IN,IBEG,IEND,ITYP,FVALUE,CVALUE,
     &                 LINE_IN,IERROR)
      use weights
      use ncs_rest
C
C---Reads relevant keywords for NCS restraints
      IMPLICIT NONE
      INTEGER IERROR,ITOK_IN
      INTEGER INCS
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER CVALUE(*)*4
      CHARACTER LINE_IN*(*)
      integer ich,ie
      INTEGER NTOK,ITK,ITK1,ITK2,ICHAIN,NCS_FIRST,NCS_LAST,
     &       NCS_ICODE_L,NCS_N_CHAIN_T,NCS_SPAN_T,III
      CHARACTER LINE*132
c
      logical lcont
      integer i,nkeys
      character*4 local_keys(100)
      data local_keys(1:11)/'SOFT','LOCA','HARD','ALIG','NEIG','GMPA',
     &     'GROU','NCHA','DMAX','DIFF','GLOB'/
C
c---  body
      nkeys = 11
      ncsr_flag = .TRUE.
      IERROR = 0
      INCS = NUMBER_NCSR
      IF(NTOK.LE.1) RETURN

      lcont = .FALSE.
      itk = itok_in
      do i=1,nkeys
         if(cvalue(itk).eq.local_keys(i)) then
            lcont = .TRUE.
            exit
         endif
      enddo
      lcont = lcont.or.(ityp(itk).eq.2)
      if(.not.lcont) then
         write(*,*)'Wrong keywords for ncs restraint definitions'
         write(*,*)trim(line_in)
         stop
      endif
C
C---Check and take if following fields are relevant for the weighting
      if(cvalue(itk).eq.'SOFT'.or.cvalue(itk).eq.'LOCA') then
         ncsr_use = 'S'
         return
      elseif(cvalue(itk).eq.'HARD'.or.cvalue(itk).eq.'GLOB') then
         ncsr_use = 'H'
         return
      endif
      if(cvalue(itk).eq.'WRIT'.or.cvalue(itk).eq.'DEPO') then
         ncsr_write_pdb = 'Y'
      elseif(cvalue(itk).eq.'NOPD'.or.cvalue(itk).eq.'NOWR') then
         ncsr_write_pdb = 'N'
      endif
      itk1 = itk
      if(cvalue(itk1).eq.'ALIG') then
         do while(itk1.lt.ntok-1)
            itk1 = itk1 + 1
            if(itk1.le.ntok-1) then
               if(cvalue(itk1).eq.'LEVE') then
                  itk1 = itk1 + 1
                  call gtnrea(itk1,1,ncsr_level,ntok,ityp,fvalue)
                  itk1 = itk1 + 1
               else if(cvalue(itk1).eq.'ITER') then
                  itk1 = itk1 + 1
                  if(cvalue(itk1)(1:3).eq.'YES') then
                     itk1 = itk1 + 1
                     align_iter_flag = 'Y'
                  else
                     align_iter_flag = 'N'
                     itk1 = itk1 + 1
                  endif
               else if(cvalue(itk1).eq.'RMSL') then
                  itk1 = itk1 + 1
                  call gtnrea(itk1,1,align_rms_level,ntok,ityp,fvalue)
                  itk1 = itk1 + 1
               else
                  cycle
               endif
            endif
         enddo
         return
      elseif(cvalue(itk1).eq.'DMAX') then
         itk1 = itk1 + 1
         if(ityp(itk1).eq.2) then
            dmax_ncs_local = fvalue(itk1)
            itk1 = itk1 + 1
         endif
      elseif(cvalue(itk1).eq.'DIFF') then
         itk1 = itk1 + 1
         if(ityp(itk1).eq.2) then
            diffmax_ncs_local = fvalue(itk1)
            itk1 = itk1 + 1
         endif
      else if(cvalue(itk1).eq.'NEIG') then
         itk1 = itk1 + 1
         if(cvalue(itk1).eq.'INCL') then
            itk1 = itk1 + 1
            ncsr_neigb_include = 'Y'
         else
            itk1 = itk1 + 1
            ncsr_neigb_include = 'N'
         endif
         return
      else if(cvalue(itk1).eq.'GMPA') then
         itk1 = itk1 + 1
         call gtnrea(itk1,1,gm_ncsr_simil_param,ntok,ityp,fvalue)
         itk1 = itk1 + 1
         return
      endif
      if(cvalue(itk).eq.'GROU') then
         ncs_inst_option = 'G'
         call ncsr_inst_interp(ntok,itk,ibeg,iend,ityp,fvalue,
     &        cvalue,line_in,ierror)
         return
      endif
c
      itk = itk1
      if(ncs_inst_option.eq.'G') then
         call errwrt(-1,'Conflict between ncs instructions')
         call errwrt(-1,'You should use GROUP instructions')
         call errwrt(1,'Problem with NCS instructions')
      endif
c
c      write(*,*)itk,itk1,ntok
      IF(ITYP(ITK).EQ.2.AND.ITK.LE.NTOK) THEN 
        CALL GTNREA(ITK,1,WSSKAL,NTOK,ITYP,FVALUE)
        ITK = ITK + 1
      ELSE
        GOTO 500
      ENDIF
      IF(ITYP(ITK).EQ.2.AND.ITK.LE.NTOK) THEN
        CALL GTNREA(ITK,1,SIGS(1),NTOK,ITYP,FVALUE)
        ITK = ITK + 1
      ELSE
        GOTO 500
      ENDIF
      IF(ITYP(ITK).EQ.2.AND.ITK.LE.NTOK) THEN
        CALL GTNREA(ITK,1,SIGS(2),NTOK,ITYP,FVALUE)
        ITK = ITK + 1
      ELSE
        GOTO 500
      ENDIF
      IF(ITYP(ITK).EQ.2.AND.ITK.LE.NTOK) THEN
        CALL GTNREA(ITK,1,SIGS(3),NTOK,ITYP,FVALUE)
        ITK = ITK + 1
      ELSE
        GOTO 500
      ENDIF
      IF(ITYP(ITK).EQ.2.AND.ITK.LE.NTOK) THEN
        CALL GTNREA(ITK,1,SIGS(4),NTOK,ITYP,FVALUE)
        ITK = ITK + 1
      ELSE
        GOTO 500
      ENDIF
      IF(ITYP(ITK).EQ.2.AND.ITK.LE.NTOK) THEN
        CALL GTNREA(ITK,1,SIGS(5),NTOK,ITYP,FVALUE)
        ITK = ITK + 1
      ELSE
        GOTO 500
      ENDIF
      IF(ITYP(ITK).EQ.2.AND.ITK.LE.NTOK) THEN
        CALL GTNREA(ITK,1,SIGS(6),NTOK,ITYP,FVALUE)
        ITK = ITK + 1
      ELSE
        GOTO 500
      ENDIF
C
 500  CONTINUE
      IF(ITK.GT.NTOK-1) RETURN
C
C---First check if we have number of ncs chains. It is compulsory
      itk1 = itk
      do while(itk1.le.ntok-1)
         IF(CVALUE(ITK1).EQ.'NCHA') THEN
            IF(ITYP(ITK1+1).EQ.2) THEN
               CALL GTNINT(ITK1+1,1,NCS_N_CHAIN_T,NTOK,ITYP,FVALUE)
               IF(NCS_N_CHAIN_T.LE.1.OR.
     &              NCS_N_CHAIN_T.GT.MAX_NCS_CHAIN) THEN
                  CALL ERRWRT(-1,
     &                 'Number of NCS chains is out of allowed range')
                  CALL ERRWRT(-1,'No NCS for these chains will be used')
                  WRITE(LINE,'(A,I5)')'Allowed range is from 2 to ',
     &                 MAX_NCS_CHAIN
                  CALL ERRWRT(-1,LINE)
                  CALL ERRWRT(-1,' ')
                  GOTO 900
               ENDIF
               INCS = INCS + 1
               IF(INCS.GT.MAX_NCS) THEN
                  CALL ERRWRT(-1,'Too many NCS restraints')
                  GOTO 900
               ENDIF
               write(ncs_ids(incs),'(i4)')incs
               NCS_N_CHAIN(INCS) = NCS_N_CHAIN_T
               ncs_chain_num(incs) = ncs_n_chain_t
               GOTO 700
            ENDIF
         ENDIF
      ENDDO
      CALL ERRWRT(-1,
     &         'Number of chains for NCS have not been defined')
      CALL ERRWRT(-1,'No NCS will be used for these chains')
      GOTO 900
 700  CONTINUE
C
c---Now find chain names. This is compulsory
      DO   ITK1=ITK,NTOK
        IF(CVALUE(ITK1).EQ.'CHAI'.OR.CVALUE(ITK1).EQ.'CHNI') THEN
          IF(ITK+NCS_N_CHAIN(INCS).GT.NTOK) THEN
            CALL ERRWRT(-1,'Not enough information for NCS chains')
            WRITE(LINE,'(A,I5)')
     &              'Number of chain names program expects is ',
     &                  NCS_N_CHAIN(INCS)
            CALL ERRWRT(-1,LINE)
            CALL ERRWRT(-1,'No NCS for these chains will be used')
            GOTO 900
          ENDIF
          ICH = 1
          DO   ITK2=ITK1+1,ITK1+NCS_N_CHAIN_T
            NCS_CHAINS(ICH,INCS) = LINE_IN(IBEG(ITK2):IEND(ITK2))
            ncs_equiv_ch(ich,1,incs) = line_in(ibeg(itk2):iend(itk2))
            ICH = ICH + 1
          ENDDO
          GOTO 750
        ENDIF
      ENDDO
      CALL ERRWRT(-1,'Chain names for NCS have not been defined')
      CALL ERRWRT(-1,'No NCS will be used')
      GOTO 900
 750  CONTINUE
C
c---Now find spans. It is not compulsory. Default is NSPAN = 1.
C---All residues in the given chains and weighting 1
      ncs_equiv_num(incs) = 1
      ncs_equiv_res(1,1,incs) = -99999
      ncs_equiv_res(2,1,incs) =  99999

      NCS_SPANS(INCS) = 1
      NCS_IRES_FIRST(1,INCS) = -99999
      NCS_IRES_LAST(1,INCS)  =  99999
      DO   ITK1 = ITK,NTOK-3
        IF(CVALUE(ITK1).EQ.'NSPA') THEN
           IF(ITYP(ITK1+1).EQ.2) THEN
             CALL GTNINT(ITK1+1,1,NCS_SPAN_T,NTOK,ITYP,FVALUE)
             IF(NCS_SPAN_T.GT.MAX_NCS_SPAN) THEN
               CALL ERRWRT(-1,'Too many spans for this NCS')
               WRITE(LINE,'(A,I5)')'Maximum allowed is',
     &                  MAX_NCS_SPAN
               CALL ERRWRT(-1,LINE)
               CALL ERRWRT(-1,
     &                 'No NCS will be used for these chains')
               GOTO 900
             ENDIF
             IF(NCS_SPAN_T.LE.0) THEN
               NCS_SPANS(INCS) = 1
               NCS_IRES_FIRST(1,INCS) = -99999
               NCS_IRES_LAST(1,INCS)  =  99999
               ncs_equiv_res(1,1,incs)= -99999
               ncs_equiv_res(2,1,incs)=  99999
               GOTO 800
             ELSE
               NCS_SPANS(INCS) = NCS_SPAN_T
               ncs_equiv_num(incs) = ncs_span_t
               do ich=1,ncs_n_chain_t
                  do  ie=1,ncs_span_t
                     ncs_equiv_ch(ich,ie,incs) = 
     &                    ncs_equiv_ch(ich,1,incs)
                  enddo
               enddo
             ENDIF
             IF(ITK1+3*NCS_SPANS(INCS).GT.NTOK) THEN
               CALL ERRWRT(-1,
     &                 'Not enough information for NCS spans')
               WRITE(LINE,'(A,I5)')'Number of expected spans is',
     &                  NCS_SPANS(INCS)
               CALL ERRWRT(-1,LINE)
               CALL ERRWRT(-1,
     &                 'No NCS will be used for these chains')
               GOTO 900
             ENDIF
             ITK2 = ITK1+2
             DO   III=1,NCS_SPANS(INCS)
                ie = iii
               CALL GTNINT(ITK2,1,NCS_FIRST,NTOK,ITYP,FVALUE)
               ITK2 = ITK2 + 1
               CALL GTNINT(ITK2,1,NCS_LAST,NTOK,ITYP,FVALUE)
               IF(NCS_FIRST.LE.NCS_LAST) THEN
                  ncs_equiv_res(1,ie,incs) = ncs_first
                  ncs_equiv_res(2,ie,incs) = ncs_last
                  NCS_IRES_FIRST(III,INCS) = NCS_FIRST
                  NCS_IRES_LAST(III,INCS) = NCS_LAST
               ELSE
                  ncs_equiv_res(1,ie,incs) = ncs_last
                  ncs_equiv_res(2,ie,incs) = ncs_first
                 NCS_IRES_FIRST(III,INCS) = NCS_LAST
                 NCS_IRES_LAST(III,INCS) = NCS_FIRST
               ENDIF
               ITK2 = ITK2 + 1
               if(itk2.le.ntok) then
                  CALL GTNINT(ITK2,1,NCS_ICODE_L,NTOK,ITYP,FVALUE)
                  IF(NCS_ICODE_L.LE.0.OR.NCS_ICODE_L.GT.6) 
     &                 NCS_ICODE_L = 1
                  NCS_ICODE(III,INCS) = NCS_ICODE_L
                  ITK2 = ITK2 + 1
               else
                  ncs_icode(iii,incs) = 1
               endif
             ENDDO
           ENDIF                 
        ENDIF
      ENDDO
 800    CONTINUE
        GOTO 910
 900   CONTINUE
       CALL ERRWRT(1,
     &      'Problem with keywords relevant to the NCS restraints')
 910   CONTINUE
      
      NUMBER_NCSR = INCS
      RETURN
      END
C
      subroutine ncsr_inst_interp(ntok,itok_in,ibeg,iend,ityp,
     &     fvalue,cvalue,line_in,ierror)
      use ncs_rest
      implicit none
c
c--Read and interpret ncs restraints instructions
c
c---inputs
      integer ntok,itok_in
      integer ibeg(*),iend(*),ityp(*)
      real fvalue(*)
      character cvalue(*)*4
      character line_in*(*)
c
c--   outputs
      integer ierror,itok_out
c
c--   locals
      integer ierr
      integer itk1,itk2,i,res_beg,res_end,ncs_cur,icc
      integer ncs_chain_cur,ncs_equiv_cur
      character ncs_id_local*10
      character chain_current*25,chain_loc*4
      character line_loc*512
c
c---  body
      itk1 = itok_in
c
      ierror = 0
      if(cvalue(itk1).ne.'GROU') then
         call errwrt(0,'Wrong instruction for ncs groups')
         ierror = 1
         return
      endif
c
c--   Take ncs id
      itk1 = itk1 + 1
      if(itk1.gt.ntok) return
      ncs_id_local = line_in(ibeg(itk1):iend(itk1))
      itk1 = itk1 + 1
      if(number_ncsr.le.0) then
         number_ncsr = 1
         ncs_cur     = 1
         ncs_ids(ncs_cur) = ncs_id_local
      else
         do   i=1,number_ncsr
            if(ncs_id_local.eq.ncs_ids(i)) then
               ncs_cur = i
               goto 10
            endif
         enddo
         number_ncsr = number_ncsr+1
         if(number_ncsr.gt.max_ncs) then
            call errwrt(-1,'Too many ncs groups for groups')
            write(line_loc,'(a,i4)')
     &           'Maximum number ncs groups allowed is '//ncs_id_local
            call errwrt(-1,line_loc)
            call errwrt(1,'Problem with ncs instructions')
         endif
         ncs_cur = number_ncsr
         ncs_ids(ncs_cur) = ncs_id_local
      endif
 10   continue
      do while(itk1.lt.ntok)
         if(cvalue(itk1).eq.'NCHA') then
            itk1 = itk1 + 1
            if(itk1.gt.ntok) return
            call gtnint(itk1,1,ncs_chain_cur,ntok,ityp,fvalue)
            ncs_chain_num(ncs_cur) = ncs_chain_cur
            itk1 = itk1 + 1
c     
c---  Take other info about ncs
         elseif(cvalue(itk1).eq.'CHAI') then
            itk1  = itk1 + 1
c
c--   New span or equivalence
            if(itk1.gt.ntok) return
            ncs_equiv_num(ncs_cur) = ncs_equiv_num(ncs_cur) + 1
            ncs_equiv_cur = ncs_equiv_num(ncs_cur)
            if(ncs_equiv_cur.gt.max_ncs_span) then
               call errwrt(-1,'Too many equivalence in ncs group '
     &              //ncs_id_local)
               write(line_loc,'(a,i4)')'Maximum ncs equiv allowed =',
     &              max_ncs_span
               call errwrt(-1,line_loc)
               call errwrt(1,'Problem with ncs instructions')
            endif
            if(itk1+ncs_chain_cur-1.gt.ntok) then
               call errwrt(1,'Number of ncs_chains for group '
     &              //ncs_ids(ncs_cur)//' is incorrect')
            endif
            do  i=1,ncs_chain_cur
               ncs_equiv_ch(i,ncs_equiv_cur,ncs_cur)=
     &              line_in(ibeg(itk1):iend(itk1))
               itk1 = itk1 + 1
            enddo
         elseif(cvalue(itk1).eq.'RESI') then
            itk1 = itk1 + 1
            if(itk1.gt.ntok) return
            if(ityp(itk1).eq.2) then
               call gtnint(itk1,1,icc,ntok,ityp,fvalue)
               ncs_equiv_res(1,ncs_equiv_cur,ncs_cur)=icc
               itk1 = itk1 + 1
               if(itk1.le.ntok.and.ityp(itk1).eq.2) then
                  call gtnint(itk1,1,icc,ntok,ityp,fvalue)
                  ncs_equiv_res(2,ncs_equiv_cur,ncs_cur)=icc
                  itk1 = itk1 + 1
               else
                  ncs_equiv_res(2,ncs_equiv_cur,ncs_cur)=
     &                 ncs_equiv_res(1,ncs_equiv_cur,ncs_cur)
               endif
            endif
         elseif(cvalue(itk1).eq.'CODE') then
            itk1 = itk1 + 1
            call gtnint(itk1,1,icc,ntok,ityp,fvalue)
            itk1 = itk1 + 1
            if(icc.le.0) icc = 1
            if(icc.ge.6) icc = 6
            ncs_icode(ncs_equiv_cur,ncs_cur) = icc
         elseif(cvalue(itk1).eq.'PGRO') then
            itk1 = itk1 + 1
            ncs_point_group(ncs_cur)=cvalue(itk1)
c
c---point group needs to be checked for validity
            itk1 = itk1 + 1
         elseif(cvalue(itk1).eq.'SIGX') then
            itk1 = itk1 + 1
            call gtnrea(itk1,1,sigx_ncs(ncs_cur),ntok,ityp,fvalue)
            itk1 = itk1 + 1
         elseif(cvalue(itk1).eq.'SIGB') then
            itk1 = itk1 + 1
            call gtnrea(itk1,1,sigb_ncs(ncs_cur),ntok,ityp,fvalue)
            itk1 = itk1 + 1
         elseif(cvalue(itk1).eq.'COMP') then
            ncs_complete(ncs_cur) = 'Y'
         else
            call errwrt(-1,'Wrong ncs group instruction')
            ierror = 1
            return
         endif
 50      continue
      enddo
 100  continue
      return
 200  continue
c
c--Process final errors

      end
c
      subroutine get_chain_residue_sel(chain_current,chain_loc,
     &              res_beg,res_end,ierr)
      implicit none
c
c--inputs
      character chain_current*(*),chain_loc*4
      integer res_beg,res_end
c
c--outputs
      integer ierr
c
c--locals
      integer icolon,icolon1,l
      integer index
      character char_loc*1
c
      ierr = 0
      icolon = index(chain_current,':')
      if(icolon.eq.0) then
         chain_loc = chain_current(1:4)
         res_beg = -9999
         res_end =  9999
         return
      endif
      chain_loc = chain_current(1:icolon-1)
      char_loc = chain_current(icolon+1:icolon+1)
      call ccpupc(char_loc)
      if(char_loc.eq.'A') then
         res_beg = -9999
         res_end =  9999
         return
      endif
      l = len_trim(chain_current)
      icolon1 = index(chain_current(icolon+1:l),':')
      if(icolon1.eq.0) then
c
c--Check if it is an integer
         call get_integer_from_char(chain_current(icolon+1:l),
     &        res_beg,ierr)
         if(ierr.gt.0) return
         res_end = res_beg
      else
         call get_integer_from_char(chain_current(icolon+1:icolon1-1),
     &        res_beg,ierr)
         if(ierr.gt.0) return
         call get_integer_from_char(chain_current(icolon1+1:l),
     &        res_end,ierr)
         if(ierr.gt.0) return
      endif

      return
      end
c
      subroutine get_integer_from_char(char,ival,ierr)
      implicit none
c
c--Check if character contains digits and extract an ineger if it is so

c
c---inptus
      character char*(*)
c
c---Outputs
      integer i,ival,ierr
c
c---locals
      integer l,istart
      character digits*10
c
c---externals
c
c---data
      data digits/'0123456789'/
c
c---  Body
      ierr = 0
      l = len_trim(char)
      if(l.le.0) then
         ierr = 1
         return
      endif
      if(char(1:1).eq.'+'.or.char(1:1).eq.'-') then
         istart = 2
      else
         istart = 1
      endif
      if(istart.le.l) then
         ierr = 1
         return
      endif
      do  i=istart,l
         if(index(digits,char(i:i)).le.0) then
            ierr = 1
            return
         endif
      enddo
      read(char,*)ival
      return
      end
c
      SUBROUTINE NCSC_PARAMS(NTOK,ITOK_IN,IBEG,IEND,ITYP,FVALUE,CVALUE,
     &                 line_in,IERROR)
      use weights
      use ncs_constraints
      use ncs_rest
C
C---Reads relevant keywords for NCS restraints
      IMPLICIT NONE
      INTEGER IERROR,ITOK_IN
      integer i
      INTEGER IBEG(*),IEND(*),ITYP(*)
      REAL FVALUE(*)
      CHARACTER CVALUE(*)*4
      character line_in*(*)
      INTEGER NTOK,ITK,ITK1,ITK2,ICHAIN,NCSC_FIRST,NCSC_LAST,
     &       NCSC_ICODE_L,NCSC_N_CHAIN_T,NCSC_SPAN_T,III
      CHARACTER LINE*132
c
      real alpha,beta,gamma,psi,phi,chi
      real eps,degtor
      real rloc(3,3)

C
C---  body
      ncs_const_flag = .TRUE.
      eps = 6.0e-4
C
      IF(NTOK.LE.1) RETURN
C
      itk = itok_in
      if(cvalue(itk).ne.'MATR'.and.cvalue(itk).ne.'EULE'.and.
     &     cvalue(itk).ne.'POLA'.and.cvalue(itk).ne.'GENE') then
         write(*,*)'Warning==> Wrong instructions for ncs constraints'
         write(*,*)'Warning==> Current version takes only ncs operators'
         write(*,*)'Warning==> Ignoring this instruction'
         return
      endif
      degtor = atan(1.0)/45.0
 500  CONTINUE
      IF(ITK.GT.NTOK-1) RETURN
      if(ntok.ge.8) then
         if(cvalue(itk).eq.'MATR') then
            n_ncs_const = n_ncs_const + 1
            if(all(ityp(3:14).eq.2)) then
               read(line_in(ibeg(3):iend(14)),*)
     &              (ncs_c_rot(i,1:3,n_ncs_const),i=1,3),
     &              ncs_c_tr(1:3,n_ncs_const)
               rloc = matmul(transpose(ncs_c_rot(1:3,1:3,n_ncs_const)),
     &              ncs_c_rot(1:3,1:3,n_ncs_const))
               if(abs(rloc(1,1)-1.0)+abs(rloc(1,2))+abs(rloc(1,3))+
     &              abs(rloc(2,1))+abs(rloc(2,2)-1.0)+abs(rloc(2,3))+
     &              abs(rloc(3,1))+abs(rloc(3,2))+
     &              abs(rloc(3,3)-1.0).gt.eps) then
                  write(*,*)abs(rloc(1,1)-1.0)+
     &                 abs(rloc(1,2))+abs(rloc(1,3))+
     &              abs(rloc(2,1))+abs(rloc(2,2)-1.0)+abs(rloc(2,3))+
     &              abs(rloc(3,1))+abs(rloc(3,2))+
     &              abs(rloc(3,3)-1.0)
                  write(*,*)'Error==> Matrix mustt be a rotation matrix'
                  call errwrt(1,'NCS matrix is not rotation matrix')
C     
C---- Check if the matrix is a rotation matrix
                  itk = itk + 12
               endif
            else
               write(*,*)'Error==>',trim(line_in)
               call errwrt(1,'Problem with ncs operators')
            endif

            call matr2eul_unsafe(ncs_c_rot(1:3,1:3,n_ncs_const),
     &           alpha,beta,gamma)
            write(*,*)'ncsconst euler ',
     &           alpha/degtor,beta/degtor,
     &           gamma/degtor,ncs_c_tr(1:3,n_ncs_const)
            call polar(ncs_c_rot(1:3,1:3,i),psi,phi,chi)
            write(*,*)'ncsconst polar ',psi,phi,chi,
     &           ncs_c_tr(1:3,n_ncs_const)

         elseif(cvalue(itk).eq.'EULE') then
            n_ncs_const = n_ncs_const + 1
            if(all(ityp(3:8).eq.2)) then
               read(line_in(ibeg(3):iend(8)),*)
     &              ncs_c_euler(1:3,n_ncs_const),
     &              ncs_c_tr(1:3,n_ncs_const)
               ncs_c_euler(1:3,n_ncs_const) = 
     &                 ncs_c_euler(1:3,n_ncs_const)*degtor
               call eul2matr(ncs_c_euler(1,n_ncs_const),
     &              ncs_c_euler(2,n_ncs_const),
     &              ncs_c_euler(3,n_ncs_const),
     &              ncs_c_rot(1:3,1:3,n_ncs_const))
               itk = itk + 6
            else
               write(*,*)'Error==>',trim(line)
               call errwrt(1,'Problem with ncs operators')
            endif
         elseif(cvalue(itk).eq.'POLA') then
            n_ncs_const = n_ncs_const + 1
            if(all(ityp(3:8).eq.2)) then
               read(line_in(ibeg(3):iend(8)),*)
     &              ncs_c_polar(1:3,n_ncs_const),
     &              ncs_c_tr(1:3,n_ncs_const)
               ncs_c_polar(1:3,n_ncs_const) = 
     &              ncs_c_polar(1:3,n_ncs_const)*degtor
               call polar2matr(ncs_c_polar(1,n_ncs_const),
     &              ncs_c_polar(2,n_ncs_const),
     &              ncs_c_polar(3,n_ncs_const),
     &              ncs_c_rot(1:3,1:3,n_ncs_const))
               itk = itk + 6
            else
               write(*,*)'Error==>',trim(line)
               call errwrt(1,'Problem with ncs operators')
            endif    
         endif
      endif

      
      RETURN
      END
C         
      SUBROUTINE READ_PHFACTORS(NTOK,ITK,CVALUE,ITYP,FVALUE)
      use refi_flags
C
C---Reads factors for phased refinement, e.g. bluring factors
C
C---Blurring factor will be applied as following
C
C(HLANEW,,) = (HLA,,)*PHAS_BLUR_SCAL*EXP(-(SIN(theta)/lam)**2*PHAS_BLUR_BVAL
C
      REAL      FVALUE(*)
      INTEGER NTOK,ITK
      INTEGER   ITYP(*)
      CHARACTER CVALUE(*)*4

      IF(ITK.GT.NTOK) THEN
        PHAS_BLUR_SCAL = 1.0
        PHAS_BLUR_BVAL = 0.0
      ELSE
10      CONTINUE
C
C---Check for acceptable subkeywords. Now only blurring factors are available
        IF(CVALUE(ITK).NE.'SCBL'.AND.CVALUE(ITK).NE.'BBLU'
     +              .AND.CVALUE(ITK+1).NE.'SIGM') GOTO 20
        IF(CVALUE(ITK).EQ.'SCBL') THEN
           IF(ITK.GT.NTOK) GOTO 20
C
C---Scale for blurring
          ITK = ITK + 1
          IF(ITYP(ITK).EQ.2) THEN
            CALL GTNREA(ITK,1,PHAS_BLUR_SCAL,NTOK,ITYP,FVALUE)
            ITK = ITK + 1
          ELSE
            PHAS_BLUR_SCAL = 1.0
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'BBLU') THEN
C
C----Bvalue for blurring
          ITK = ITK+1
          IF(ITK.GT.NTOK) GOTO 20
          IF(ITYP(ITK).EQ.2) THEN
            CALL GTNREA(ITK,1,PHAS_BLUR_BVAL,NTOK,ITYP,FVALUE)
            ITK = ITK + 1
          ELSE
            PHAS_BLUR_BVAL = 0.0
          ENDIF
        ELSEIF(CVALUE(ITK).EQ.'SIGM') THEN
C
C---Include or not include in sigmaa calculation
          ITK = ITK + 1
          IF(CVALUE(ITK).NE.'NO'.AND.CVALUE(ITK).NE.'YES') THEN
             PHASE_SIGMAA_FLAG=.TRUE.
             ITK = ITK + 1
           ELSEIF(CVALUE(ITK).EQ.'YES') THEN
             PHASE_SIGMAA_FLAG=.TRUE.
             ITK = ITK + 1
           ELSEIF(CVALUE(ITK).EQ.'NO') THEN
             PHASE_SIGMAA_FLAG=.FALSE.
             ITK = ITK + 1
           ENDIF
        ENDIF
        GOTO 10
      ENDIF
20    CONTINUE
      RETURN
      END

      SUBROUTINE 
     +   READ_RBODY_PARS(NERROR,NTOK,ITK,line_in,CVALUE,ibeg,iend,ityp,
     &     FVALUE)
      implicit none
C
C---Reads parameters of rigid body and saves them in  rigid_body.fh
      INCLUDE 'atom_com.fh'
      INCLUDE   'rigid_body.fh'
      INCLUDE   'const.fh'

      integer ntok,itk
      integer ibeg(*),iend(*)
      character line_in*(*)
      CHARACTER  CVALUE(*)*4
      INTEGER    ITYP(*)
      REAL       FVALUE(*)
C
C---Local ariables
      integer ierr
      integer igroup,nerror,ipiece,igr
      INTEGER     IFIRST,ILAST
      real tr_temp,weight_temp
      CHARACTER   CHNID*4,line*256
C
      IGR = 0
      IPIECE = 0
      ITK = ITK + 1
10    CONTINUE
      IF(ITK.GT.NTOK) GOTO 999
      IF(CVALUE(ITK).NE.'GROU'.AND.CVALUE(ITK).NE.'NCYC'
     +     .AND.CVALUE(ITK).NE.'EXCL'.AND.CVALUE(ITK).NE.'WEIG'
     +     .AND.CVALUE(ITK).NE.'PRIN'.and.cvalue(itk).ne.'AUTO') THEN
        NERROR = NERROR + 1
        CALL ERRWRT(0,'Wrong subkeyword of RIGIdbody: '//CVALUE(ITK))
        GOTO 999
      ENDIF
C
      if(cvalue(itk).eq.'AUTO') then
         itk = itk + 1
         rigid_auto = .TRUE.
         if(cvalue(itk)(1:3).eq.'OFF') then
            rigid_auto = .FALSE.
            itk = itk + 1
         elseif(cvalue(itk)(1:2).eq.'ON') then
            rigid_auto = .TRUE.
            itk = itk + 1
         endif
         goto 10
      elseif(cvalue(itk).eq.'GROU') then
         ITK = ITK + 1
C
         IF(ITYP(ITK).NE.2) THEN
           CALL 
     +      ERRWRT(0,'GROUp keyword should be followed by number')
           NERROR = NERROR + 1
           GOTO 999
         ENDIF
C
         CALL GTNINT(ITK,1,IGROUP,NTOK,ITYP,FVALUE)
         IGR = IGROUP
         ITK = ITK + 1
 20      CONTINUE
         IF(ITK.GE.NTOK) GOTO 999
C
         IF(CVALUE(ITK).NE.'FROM'.AND.CVALUE(ITK).NE.'WEIG'.AND.
     +      CVALUE(ITK).NE.'EXCL'.AND.CVALUE(ITK).NE.'TRAN'.AND.
     +      CVALUE(ITK).NE.'EULE') THEN
           NERROR = NERROR + 1
           CALL ERRWRT(0,
     +       'Wrong subkeyword of RIGID GROUP <i> '//CVALUE(ITK))
           GOTO 999
C
        elseif(cvalue(itk).eq.'CHAI') then
           idomain_pieces(igr) = idomain_pieces(igr) + 1
           if(idomain_pieces(igr).gt.maxpieces) then
              WRITE(LINE,'(A,3I10)')
     +             'Maximum number of pieces per domain = ',MAXPIECES,
     +             IDOMAIN_PIECES(IGR),IGR
              CALL ERRWRT(-1,LINE)
              CALL ERRWRT(1,'Too many pieces for one domain')
           endif
           itk = itk + 1
           chnid = line(ibeg(itk):iend(itk))
           ipiece = idomain_pieces(igr)
           idomain_from(ipiece,igr) = -9999
           idomain_to(ipiece,igr) = 9999
           idomain_chn(ipiece,igr) = chnid
           goto 20
         ELSEIF(CVALUE(ITK).EQ.'FROM') THEN
cd            CALL READ_FROMTO(NTOK,ITK,CVALUE,ITYP,FVALUE,IFIRST,
cd     +        ILAST,CHNID)
            call read_fromto1(NTOK,ITK,CVALUE,line_in,ibeg,iend,ITYP,
     &           FVALUE,IFIRST,ILAST,CHNID,ierr)
           IDOMAIN_PIECES(IGR)      = IDOMAIN_PIECES(IGR) + 1
C           WRITE(LINE,'(A,3I10)')
C     +          'Maximum number of pieces per domain = ',MAXPIECES,
C     +          IDOMAIN_PIECES(IGR),IGR
C           CALL ERRWRT(-1,' ')
C           CALL ERRWRT(-1,LINE)
           IF(IDOMAIN_PIECES(IGR).GT.MAXPIECES) THEN
             WRITE(LINE,'(A,3I10)')
     +          'Maximum number of pieces per domain = ',MAXPIECES,
     +          IDOMAIN_PIECES(IGR),IGR
             CALL ERRWRT(-1,LINE)
             CALL ERRWRT(1,'Too many pieces for one domain')
           ENDIF
           IPIECE                   = IDOMAIN_PIECES(IGR)
           IDOMAIN_FROM(IPIECE,IGR) = IFIRST
           IDOMAIN_TO(IPIECE,IGR)   = ILAST
           IDOMAIN_CHN(IPIECE,IGR)  = CHNID
           IF(ITK.GE.NTOK) GOTO 999
           GOTO 20
         ELSEIF(CVALUE(ITK).EQ.'EXCL') THEN
C
C---Excluding criteria for this particular domain
C
           ITK=ITK+1
           IF(CVALUE(ITK).NE.'SCHA'.AND.CVALUE(ITK).NE.'MCHA'.AND.
     +       CVALUE(ITK).NE.'NONE' ) THEN
             NERROR = NERROR + 1
             CALL ERRWRT(0,'EXCL should be followed by MCHA or SCHA'//
     +            ' NONE')
           ENDIF
           EXCLUDE_DOMAIN(IGR) = CVALUE(ITK)
           itk = itk + 1
           GOTO 20
         ELSEIF(CVALUE(ITK).EQ.'WEIG') THEN
C
C---Weighting criteria for this particular domain
           ITK = ITK + 1
           IF(CVALUE(ITK).NE.'SCHA'.AND.CVALUE(ITK).NE.'MCHA') THEN
             NERROR = NERROR + 1
             CALL ERRWRT(0,'WEIG should be followed by MCHA or SCHA')
             GOTO 20
           ENDIF
           WEIGHT_DOMAIN(IGR) = CVALUE(ITK)
           WEIGHT_DOMAIN_VALUE(IGR) = 1.0
           IF(ITYP(ITK+1).EQ.2)THEN
             ITK = ITK + 1
             CALL GTNREA(ITK,1,WEIGHT_TEMP,NTOK,ITYP,FVALUE)
             WEIGHT_DOMAIN_VALUE(IGR) = WEIGHT_TEMP
           ELSE
             CALL ERRWRT(0,'WEIG'//CVALUE(ITK)//
     +              ' should be followed by a number')
           ENDIF
           itk = itk + 1
           GOTO 20
         ELSEIF(CVALUE(ITK).EQ.'TRAN') THEN
           IF(ITYP(ITK+1).NE.2.AND.ITYP(ITK+2).NE.2
     +                        .AND.ITYP(ITK+3).NE.3) THEN
             NERROR = NERROR + 1
             CALL ERRWRT(0,'TRAN should be followed by 3 numbers')
             GOTO 20
           ENDIF
           CALL GTNREA(ITK+1,1,TR_temp,NTOK,ITYP,FVALUE)
           TRANS_INIT_RIGID(1,IGR) = TR_temp  
           CALL GTNREA(ITK+2,1,TR_temp,NTOK,ITYP,FVALUE)
           TRANS_INIT_RIGID(2,IGR) = TR_temp  
           CALL GTNREA(ITK+3,1,TR_temp,NTOK,ITYP,FVALUE)
           TRANS_INIT_RIGID(3,IGR) = TR_temp
           ITK = ITK + 4
           GOTO 20  
         ELSEIF(CVALUE(ITK).EQ.'EULE') THEN
           IF(ITYP(ITK+1).NE.2.AND.ITYP(ITK+2).NE.2
     +                        .AND.ITYP(ITK+3).NE.3) THEN
             NERROR = NERROR + 1
             CALL ERRWRT(0,'EULE should be followed by 3 numbers')
             GOTO 999
           ENDIF
           CALL GTNREA(ITK+1,1,TR_temp,NTOK,ITYP,FVALUE)
           EULER_INIT_RIGID(1,IGR) = TR_temp*DEGTOR  
           CALL GTNREA(ITK+2,1,TR_temp,NTOK,ITYP,FVALUE)
           EULER_INIT_RIGID(2,IGR) = TR_temp*DEGTOR
           CALL GTNREA(ITK+3,1,TR_temp,NTOK,ITYP,FVALUE)
           EULER_INIT_RIGID(3,IGR) = TR_temp*DEGTOR
           ITK = ITK + 4
           GOTO 20  
         ENDIF
         GOTO 10
      ELSEIF(CVALUE(ITK).EQ.'EXCL') THEN
C
c--Get overall exclusion criteria. Now only available options are schain
        GOTO 10
      ELSEIF(CVALUE(ITK).EQ.'WEIG') THEN
C
C---Weighting criteria

        GOTO 10
      ELSEIF(CVALUE(ITK).EQ.'NCYC') THEN
         ITK = ITK + 1
         IF(ITK.LE.NTOK) THEN
           CALL GTNINT(ITK,1,NRIGID_CYCLE,NTOK,ITYP,FVALUE)
           ITK = ITK + 1
         ELSE
           NERROR = NERROR+1
         ENDIF
         GOTO 10
      ELSEIF(CVALUE(ITK).EQ.'PRIN') THEN
 800     CONTINUE
         ITK = ITK + 1
         IF(ITK.LE.NTOK) THEN
           IF(CVALUE(ITK).EQ.'EULE') THEN
             EULER_PRINT_RIGID=.TRUE.
           ELSEIF(CVALUE(ITK).EQ.'MATR') THEN
             MATRIX_PRINT_RIGID=.TRUE.
           ELSE
             CALL ERRWRT(0,'Wrong subkeyword of RIGID PRIN')
             NERROR = NERROR + 1
           ENDIF
           GOTO 800
         ENDIF
         GOTO 10
      ENDIF
 999  CONTINUE 
      RETURN
C
      END
C
      SUBROUTINE READ_FROMTO(NTOK,ITK,CVALUE,ITYP,FVALUE,IFIRST,
     +           ILAST,CHNID)
C
C---Reads residue selection with a format
C  FROM <resumber> <chnid> TO <resnumber <chnid>
C--keyword FROM should be taken before calling this routine.
C
      INTEGER ITYP(*),IFIRST,ILAST,ITK,NTOK
      REAL    FVALUE(*)
      CHARACTER CHNID*4
      CHARACTER CVALUE(*)*4
C
      NERROR = 0
      IFIRST = -1
      ILAST  = -1
      ITK    = ITK + 1
      IF(ITK.GE.NTOK) NERROR = NERROR + 1
      IF(ITYP(ITK).EQ.2) THEN
        CALL GTNINT(ITK,1,IFIRST,NTOK,ITYP,FVALUE)
        ITK   = ITK + 1
        CHNID = CVALUE(ITK)
        ITK   = ITK + 1
        IF(ITK.LT.NTOK.AND.CVALUE(ITK).EQ.'TO') THEN
          ITK = ITK + 1
          CALL GTNINT(ITK,1,ILAST,NTOK,ITYP,FVALUE)
          ITK = ITK + 2
        ELSE
          NERROR = NERROR + 1
        ENDIF
      ELSE
        NERROR = NERROR + 1
      ENDIF
C      WRITE(6,'(/,A,2I10,A)')' IFIRST AND ILAST of CHAIN:',
C     + IFIRST,ILAST,CHNID
      IF(NERROR.GT.0) THEN
        CALL ERRWRT(-1,'Format for selection should be:')
        CALL ERRWRT(-1,
     +       'FROM <resnumber> <chnid> TO <resnumber> <chnid>')
        CALL ERRWRT(1,'In residue selection')
      ENDIF
      RETURN
      END
C
      SUBROUTINE READ_FROMTO1(NTOK,ITK,CVALUE,line,ibeg,iend,ITYP,
     &           FVALUE,IFIRST,ILAST,CHNID,ierr)
C
C---Reads residue selection with a format
C  FROM <resumber> <chnid> TO <resnumber <chnid>
C--keyword FROM should be taken before calling this routine.
C
      integer ierr
      integer ibeg(*),iend(*)
      INTEGER ITYP(*),IFIRST,ILAST,ITK,NTOK
      REAL    FVALUE(*)
      CHARACTER CHNID*4
      CHARACTER CVALUE(*)*4
      character line*(*)
C
      NERROR = 0
      IFIRST = -1
      ILAST  = -1
      ierr = 0
      if(cvalue(itk).ne.'FROM') then
         ierr = 1
         call errwrt(0,'Problem in read_fromto subroutine')
         return
      endif
c
      ITK    = ITK + 1
c      write(*,*)'From to',cvalue(itk:ntok)
      IF(ITK.GE.NTOK) NERROR = NERROR + 1
      IF(ITYP(ITK).EQ.2.or.cvalue(itk).eq.'*') THEN
         if(cvalue(itk).eq.'*') then
            ifirst = -9999
         else
            CALL GTNINT(ITK,1,IFIRST,NTOK,ITYP,FVALUE)
         endif
        ITK   = ITK + 1
        CHNID = line(ibeg(itk):iend(itk))
        ITK   = ITK + 1
        ilast = 9999
        IF(ITK.LT.NTOK.AND.CVALUE(ITK).EQ.'TO') THEN
          ITK = ITK + 1
          if(ityp(itk).eq.2.or.cvalue(itk).eq.'*') then
             if(cvalue(itk).eq.'*') then
                ilast = 9999
             else
                CALL GTNINT(ITK,1,ILAST,NTOK,ITYP,FVALUE)
             endif
          else
             nerror = nerror + 1
          endif
          ITK = ITK + 2
c        ELSE
c          NERROR = NERROR + 1
        ENDIF
      ELSE
        NERROR = NERROR + 1
      ENDIF
C      WRITE(6,'(/,A,2I10,A)')' IFIRST AND ILAST of CHAIN:',
C     + IFIRST,ILAST,CHNID
      IF(NERROR.GT.0) THEN
        CALL ERRWRT(-1,'Format for selection should be:')
        CALL ERRWRT(-1,
     +       'FROM <resnumber> <chnid> TO <resnumber> <chnid>')
        CALL ERRWRT(1,'In residue selection')
      ENDIF
      RETURN
      END
c
      SUBROUTINE FIND_CENTR_SYM(NumSymmetry,MaxSym,RealSymmMatrx,
     +                          IFACTOR,ERROR)
C
C---Finds maximum number of reflections for given HMAX,KMAX,LMAX and symmetry
C---RealSymmMatrx(4,4,MaxSym)
C
      REAL    RealSymmMatrx(4,4,MaxSym)
      LOGICAL ERROR
      IFACTOR = 1
      DO     ISYM=1,NumSymmetry
         DET_SYM = RealSymmMatrx(1,1,ISYM)*
     +        (RealSymmMatrx(2,2,ISYM)*RealSymmMatrx(3,3,ISYM) -
     +        RealSymmMatrx(2,3,ISYM)*RealSymmMatrx(3,2,ISYM))-
     +        RealSymmMatrx(1,2,ISYM)*
     +        (RealSymmMatrx(2,1,ISYM)*RealSymmMatrx(3,3,ISYM) -
     +        RealSymmMatrx(3,1,ISYM)*RealSymmMatrx(2,3,ISYM))+
     +        RealSymmMatrx(1,3,ISYM)*
     +        (RealSymmMatrx(2,1,ISYM)*RealSymmMatrx(3,2,ISYM) -
     +        RealSymmMatrx(3,1,ISYM)*RealSymmMatrx(2,2,ISYM))
         IF(DET_SYM.LT.0.0) IFACTOR = 2
      ENDDO
      RETURN
      END
c
      subroutine read_anom_params(ntok,itok,line,ibeg,iend,ityp,fvalue,
     &     cvalue,ierror)
      use refi_flags
      implicit none
      include 'atom_com.fh'
      include 'anom.fh'
c
c--- read parameters for anomolous scatterers
      integer ntok,itok,wave_now,i,nform_now
      integer ibeg(*),iend(*),ityp(*)
      real fvalue(*)
      character line*(*),cvalue(*)*4,anoelem_now*4
      integer ierror
c
c---  locals
      integer itk1
c
c---  body
      itk1 = itok
      if (CVALUE(itk1).eq.'WVNM') then
        wave_now = FVALUE(itk1+1)
        if (wave_now.lt.1.or.wave_now.gt.maxwavel) 
     &    call ERRWRT(1,'ANOM WVNM must be between 1 and 4')
        itk1  = itk1 + 2
      else
        wave_now = 1
      endif
c reading anom occupancies from file - for testing only
      if (CVALUE(itk1).eq.'RAOC') then
        read_anom_occ_flag = .true.
        itk1  = itk1 + 1
      endif
      do while(itk1.le.ntok)
        if(cvalue(itk1).eq.'MAPO') then
          anom_maponly_flag = .true.
          itk1 = itk1 + 1
        elseif(cvalue(itk1).eq.'WAVE') then
          wavelength(wave_now) = fvalue(itk1+1)
          itk1 = itk1 + 2
        elseif(cvalue(itk1).eq.'FORM') then
           itk1 = itk1 + 1
c          if(itk1+2.gt.ntok) then
c             call errwrt(1,'Not enought items for ANOMalous FORM')
c          endif
           if(itk1+2.le.ntok) then
              anoelem_now = cvalue(itk1)
              itk1 = itk1 + 1
              nform_now = nform_ano + 1
              do i=1,nform_ano
                 if (ano_elem(i).eq.anoelem_now)   nform_now = i
              enddo
              if (nform_now.gt.nform_ano) then
                 nform_ano = nform_now
                 ano_elem(nform_now) = anoelem_now
              endif
              if(ityp(itk1).eq.2.and.ityp(itk1+1).eq.2) then
                 fprime(nform_now,wave_now) = fvalue(itk1)
                 f2prime(nform_now,wave_now) = fvalue(itk1+1)
                 itk1 = itk1 + 2
c     goto 100
              else
                 call errwrt(1,'Type mismatch for f'' and/or f'''' ')
              endif
           endif
        else
           call errwrt(1,'Unknown ANOM or ANOM WVNM subkeyword, only '//
     &          'FORM or WAVE subkeywords allowed')
        endif
      enddo
c
c 100  continue
      return
      end
c
      subroutine read_twin_params(ntok,itok,line,ibeg,iend,ityp,fvalue,
     &     cvalue,ierror)
      use refi_flags
      implicit none
      include 'atom_com.fh'
      include 'twin_refmac.fh'
c
c--- read parameters for twin refinement
      integer ntok,itok
      integer ibeg(*),iend(*),ityp(*)
      real fvalue(*)
      character line*(*),cvalue(*)*4
      integer ierror
c
      integer i,it,itk,itw,ierr
      real fraction
      real rot_loc(3,3),trans_loc(3)
      character text_loc*256
c
      twin_flag = .TRUE.
      itk = itok
      itw = -1
      do while(itk.le.ntok)
         if(cvalue(itk)(1:2).eq.'ON'.or.cvalue(itk)(1:3).eq.'YES') then
            twin_flag = .TRUE.
            itk = itk + 1
            goto 900
         else if(cvalue(itk)(1:2).eq.'OFF'.or.
     &           cvalue(itk)(1:2).eq.'NO') then
            twin_flag = .FALSE.
            goto 999
         else if(cvalue(itk).eq.'FILT') then
            itk = itk + 1
            if(ityp(itk).eq.2) then
               call gtnrea(itk,1,small_twin_frac,ntok,ityp,fvalue)
               itk = itk + 1
               goto 900
            else
               if(cvalue(itk).eq.'RMER') then
                  itk = itk + 1
                  call gtnrea(itk,1,rmerge_filter,ntok,ityp,fvalue)
                  itk = itk + 1
                  goto 900
               endif
            endif
         else if(cvalue(itk).eq.'RMER') then
            itk = itk + 1
            call gtnrea(itk,1,rmerge_filter,ntok,ityp,fvalue)
            itk = itk + 1
            goto 900
         else if(cvalue(itk).eq.'TOLE') then
            itk = itk + 1
            call gtnrea(itk,1,twin_toler,ntok,ityp,fvalue)
            itk = itk + 1
            goto 900
         else if(cvalue(itk).eq.'NDOM') then
            itk = itk + 1
            call gtnint(itk,1,ntwin_domain,ntok,ityp,fvalue)
            itk = itk + 1
            goto 900
         else if(cvalue(itk).eq.'DOMA') then
            itk = itk + 1
            if(itk.le.ntok) then
               call gtnint(itk,1,itw,ntok,ityp,fvalue)
               itk = itk + 1
               if(itk.gt.ntok) then
                  if(cvalue(itk).eq.'FRAC') then
                     twin_frac_set = .TRUE.
                     itk = itk + 1
                     call gtnrea(itk,1,fraction,ntok,ityp,fvalue)
                     twin_frac(itw) = fraction
                  endif
                  if(cvalue(itk).eq.'OPER'.and.itk.gt.ntok) then
                     twin_oper_set = .TRUE.
                     twin_user_flag = .TRUE.
                     itk = itk + 1
                     text_loc = line(ibeg(itk):iend(ntok))
                     call get_symm_from_text(text_loc,rot_loc,
     &                    trans_loc,ierr)
                     if(ierr.eq.0) then
                        twin_oper(1:3,1:3,itw)=nint(12*rot_loc(1:3,1:3))
                        twin_score(itw) = 0.0
                     endif
                     itk = itk + 1
                  endif
               endif
            endif
            goto 900
         else if(cvalue(itk).eq.'FRAC') then
            itk = itk+1
            if(itk.le.ntok) then
               twin_frac_set = .TRUE.
               itw = 0
               do it=itk,ntok
                  call gtnrea(it,1,fraction,ntok,ityp,fvalue)
                  itw = itw + 1
                  if(itw.gt.maxtwin) then
                     write(*,*)
     &                   'Too many twin domains. Maximum allowed is: ',
     &                    maxtwin
                     ierror = 1
                     goto 999
                  endif
                  twin_frac(itw) = fraction
                  itk = itk + 1
               enddo
            endif
            goto 900
         else if(cvalue(itk).eq.'OPER') then
            itk = itk + 1
            if(itk.le.ntok) then
               twin_oper_set = .TRUE.
               itw_count = itw_count + 1
               text_loc = line(ibeg(itk):iend(ntok))
               call get_symm_from_text(text_loc,rot_loc,trans_loc,ierr)
               if(ierr.eq.0) then
                  twin_oper(1:3,1:3,itw_count)=nint(12*rot_loc(1:3,1:3))
               endif
               itk = itk + 1
            endif
            goto 900
         elseif(cvalue(itk).eq.'TRAN') then
            itk = itk + 1
            twin_reindex_transform = cvalue(itk)(1:1)
            itk = itk + 1
            if(twin_reindex_transform.ne.'C'.and.
     &           twin_reindex_transform.ne.'D') then
               twin_reindex_transform='N'
            endif
            goto 900
         else
            write(*,*)'Warning ==> Wrong subkeyword of the keyword TWIN'
            write(*,*)'Allowed subkeywrods are:',
     &           'ON|OFF|YES|NO; FILTer; RMERge; TOLErance; NDOMain;'//
     &           'DOMAin; FRACtion; OPPERator; TRANsform'
            write(*,*)'Current keywords line: ',trim(line)
            itk = itk + 1
         endif
 900     continue
      enddo
c
 999  continue
      return
      end
c

      subroutine read_occupancy_params(ntok,itok,line,ibeg,iend,ityp,
     &     fvalue,cvalue,ierror)
      implicit none
      include 'atom_com.fh'
      include 'occupancy_params.fh'
c
c--- read parameters for anomolous scatterers
      integer ntok,itok
      integer ibeg(*),iend(*),ityp(*)
      real fvalue(*)
      character line*(*),cvalue(*)*4
      integer ierror
c
c---  locals
      integer itk1
      integer l,i
c
c---  body
      itk1 = itok
      if(cvalue(itk1).eq.'ATOM') then
         occup_ref_atoms = 'SEL'
         natom_occup_refine=natom_occup_refine+1
         do while(itk1.lt.ntok)
            itk1 = itk1 + 1
            if(cvalue(itk1).eq.'NAME') then
               itk1 = itk1 + 1
               occup_refine_atom(natom_occup_refine)=
     &              line(ibeg(itk1):iend(itk1))
c
c--Add trailin underscores as makecif does. It may not be good thing but it is
c--how it is.
               l = len_trim(occup_refine_atom(natom_occup_refine))
               if(l.lt.4) then
                  do   i=l+1,4
                     occup_refine_atom(natom_occup_refine)(i:i)='_'
                  enddo
               endif
            elseif(cvalue(itk1).eq.'RESI') then
               itk1 = itk1 + 1
               occup_refine_residue(natom_occup_refine) = 
     &              int(fvalue(itk1))
            elseif(cvalue(itk1).eq.'CHAI') then
               itk1 = itk1 + 1
               occup_refine_chain(natom_occup_refine)=
     &              line(ibeg(itk1):iend(itk1))
            else
               call errwrt(-1,'Wrong subkeyword of OCCUpancy ATOM '
     &              //cvalue(itk1))
               call errwrt(-1,'Allowed subkeywords are:')
               call errwrt(-1,'NAME/RESIdue/CHAIn')
               call errwrt(1,'Wrong subkeyword')
            endif
         enddo
      elseif(cvalue(itk1).eq.'RESI') then
         call errwrt(0,'This part of the program is not ready yet')
      elseif(cvalue(itk1).eq.'ALL') then
         occup_ref_atoms='ALL'
      else
         call errwrt(-1,'Wrong subkeyword of OCUPancy') 
         call errwrt(-1,'Allowed subkewyords are:')
         call errwrt(-1,'ALL/ATOM/RESIdue')
      endif
c
 100  continue
      return
      end
