module refi_flags
!---Flags for various refinement styles
!
!---FOUR    - conventional (CONV) or FFT
!---REFID   - Idealization (IDEA), restrained (REST) unrestrained (UNRE)
!---SOLVMIN - Minimization methods CGMAT (Sparse matrix) CGCLAS (conjugate
!---          gradient  CDDIR  (conjugate directions)
!---OUTPUT_option - Option for coordinate output ALL for all cycles SOME
!--                 each NOUTPUT, LAST only last cycle
!--SOLVMIN  - Methods for function minimization
!
  CHARACTER REFID*4,SOLVMIN*4,MODE*4,WEIGHT_FS*4,BREFINE*4,HYDROGEN_BVALUE*4
  INTEGER NESTIM

!
!---Flags for different type of calculations
!
!    b_hsarp_refine   -   sharpen input data before refinement
!                         i.e. multiply observations by exp(b_sharp_refine*(sin(theta)/lambda)^2)
!
  REAL BResetMin,BResetMax,UDefault_Ind 
  INTEGER IOCCUP
  real scale_sharp,b_sharp_refine
  LOGICAL DIS_FLAG,PLANE_FLAG,VDW_FLAG,TOR_FLAG,B_FLAG1,ANGL_FLAG
  logical SYM_FLAG,CHI_FLAG,GRADC,HCALC,GEOM_FLAG
  logical X_RAY_FLAG,XCALC_FLAG,FREER_FLAG,FPART_FLAG
  logical obsd_flag
  logical MIR_FLAG,PHASE_SIGMAA_FLAG,PHASE_FLAG,DAMP_FLAG
  logical BSET_DEFAULT_FLAG,FPART_FLAG_SAVE,BFGS_FLAG,HCALC_DIAG
  logical LINE_SEARCH_FLAG,OCCUP_REF_FLAG,XNONDIAG_FLAG
  logical POS_REF_FLAG
  logical OCCUP_REF_ANOMONLY_FLAG,occup_set_by_user_flag
  logical ncyc_set_by_user_flag
  logical anom_maponly_flag
  logical fomap_flag
  logical foweight_flag
  logical map_extend_flag
  logical intens_flag
  logical vdwr_exclude_flag
  logical vdw_write_flag
  logical uval_estim_flag
!
!---Blur factor for phases
!
  REAL PHAS_BLUR_BVAL,PHAS_BLUR_SCAL
!
!---Value of functional and its parts (geometry and X_ray)
!
  REAL FGEOM,FXRAY,FXFREE,FGSAVE,FXSAVE,SCALXRAY
!
!---Common block about reflections
!
  logical rand_ref_flag
  logical gibbs_sample_flag
  LOGICAL LNORMAL,LREFIN,ANISO_LOGIC,HYDROGEN_REFINE_FLAG
  INTEGER NOBS,NPART,NPARTALL,LFreeRexcludeVal,NPARTALL_SAVE,NPART_SAVE
  REAL STLMIN,STLMAX,BINSIZE
  real stlmax_rand
  real stlmin_input,stlmax_input
  real stlmin_data,smin_data
  real rshift_max,rand_extend

  INTEGER NCCREF,NCYCCG,NCYCL,nrandom_cycle

  REAL PDAMP,BDAMP,QDAMP
  CHARACTER REFTYP*4,CRDTYP*4,bref_type*4,refmac_tests*4
  LOGICAL REFUSE,CRDUSE
  integer, parameter :: MAX_EXCL_REFI = 100
  integer excl_refi_num
  logical excl_refi_flag
  integer excl_refi_begin(MAX_EXCL_REFI),excl_refi_end(MAX_EXCL_REFI)
  character excl_refi_type(MAX_EXCL_REFI)*4
  character excl_refi_chn(max_excl_refi)*4

  logical der2der1_flag, der2equal_flag, read_anom_occ_flag,            &
       derD2der1_flag, der2heavyder1_flag, VERBREF_5N, freeDref_flag,   &
       read_luzzd_flag, write_luzzd_flag
  integer sigN_calc, sigP_calc

  integer, parameter :: MAX_DATASETS = 9
  integer dataset_num_tot,dataset_dernum_tot,dataset_wavenum_tot,       &
       dataset_dernum(MAX_DATASETS),dataset_PM(MAX_DATASETS),           &
       dataset_wavenum(MAX_DATASETS),dataset_order(MAX_DATASETS),       &
       heavy_sf_model_num

  logical out_distrib_flag
  real dm_d_blur

  logical zbond_exit
  real zbond_limit

end module refi_flags
