module signals_refmac
  implicit none
  !
  !    Signals from outside to refmac
  logical :: kill_signal_flag = .FALSE.
  character(len=1024) :: kill_signal_file = ' '
  real :: signal_rfactor_val = 1000.0
  real :: signal_rfree_val = 1000.0
  real :: signal_deltaR = 1000.0
  real :: signal_deltaRfree = 1000.0
  real :: signal_delta_R_Rfree = 1000.0
  real :: signal_rmsbond = 1000.0


contains
  subroutine read_and_process_signals(signal_out)
    use rharvest
    !
    !
    logical signal_out
    !  local
    logical uncond_signal_out
    logical lexists
    integer isignal_file,ierr
    integer i
    !
    !   things for parser
    integer lend_f
    character line_parse*512
    logical   lprint,lend
    real      fvalue(500)
    integer   ntok
    integer   ibeg(500),iend(500),itype(500),idec(500)
    character key*4
    character cvalue(500)*4

    !
    !   body
    signal_out = .FALSE.
    if(.not.kill_signal_flag) return
    if(len_trim(kill_signal_file).le.0) return
    inquire(file=kill_signal_file,exist=lexists)
    if(.not.lexists) return
    call signal_reset_defaults
    !
    !   Open and read signals and criteria to stop
    isignal_file = 0
    lprint = .FALSE.
    ntok = 500
    lend_f = 0
    call open_form_file(isignal_file,kill_signal_file,ierr)
    uncond_signal_out = .FALSE.
    do while(lend_f.eq.0.and.key.ne.'END') 
       line_parse = ' '

       do while(len_trim(line_parse).le.0.and.lend_f.eq.0)
          read(isignal_file,'(a)',iostat=lend_f) line_parse
       enddo
       key = ' '
       if(lend_f.ne.0) cycle
       call parser(key,line_parse,ibeg,iend,itype,fvalue,cvalue,idec,ntok,lend,lprint)
       call ccpupc(key)
       if(key.eq.'END') cycle
       do i=1,ntok
          call ccpupc(cvalue(i))
       enddo
       if(key.eq.'STOP') then
          uncond_signal_out = .TRUE.
          if(ntok.gt.1) then
             if(trim(adjustl(cvalue(2))).eq.'1'.or.trim(adjustl(cvalue(2))).eq.'T'.or.trim(adjustl(cvalue(2))).eq.'Y') then
                uncond_signal_out = .TRUE.
             else
                uncond_signal_out = .FALSE.
             endif
          endif
       elseif(key.eq.'RFAC') then
          signal_rfactor_val = fvalue(2)
       elseif(key.eq.'RFRE') then
          signal_rfree_val = fvalue(2)
       elseif(key.eq.'DELT') then
          if(cvalue(2).eq.'RFAC') then
             signal_deltaR = fvalue(3)
          elseif(cvalue(2).eq.'RFRE') then
             signal_deltaRfree = fvalue(3)
          elseif(cvalue(2).eq.'RRFR') then
             signal_delta_R_Rfree = fvalue(3)
          endif
       endif
    enddo
    close(isignal_file)
    !
    !   Now compare and make decision
    if(uncond_signal_out) signal_out = .TRUE.
    if(rfactor_all.gt.signal_rfactor_val) signal_out = .TRUE.
    if(rfactor_free.gt.signal_rfree_val) signal_out = .TRUE.
    if(rfactor_free-rfactor_all.gt.signal_delta_R_Rfree) signal_out = .TRUE.
    if(ncycle_overall.gt.1) then
       if(rfactor_vs_cycle(ncycle_overall)-rfactor_vs_cycle(ncycle_overall-1).gt.signal_deltaR) signal_out = .TRUE.
       if(rfree_vs_cycle(ncycle_overall)-rfree_vs_cycle(ncycle_overall-1).gt.signal_deltaRfree) signal_out = .TRUE.
    endif
    if(signal_out) then
       write(*,*)
       write(*,*)' Program termination starts. At least one of the following criteria is fullfilled '
       write(*,*)' Unconditional termination flag          ',uncond_signal_out,' = .TRUE.',uncond_signal_out
       write(*,*)' Value of Rfactor                        ',rfactor_all,' > ',signal_rfactor_val
       write(*,*)' Value of free Rfactor                   ',rfactor_free,' > ',signal_rfree_val
       write(*,*)' Difference between R and Rfree          ',rfactor_free-rfactor_all,' > ',signal_delta_R_Rfree
       write(*,*)' When number of cycles is more than 1 '
       write(*,*)' Difference between R in two cycles      ',rfactor_vs_cycle(ncycle_overall)-rfactor_vs_cycle(ncycle_overall-1),  &
            ' > ',signal_deltaR
       write(*,*)' Difference between Rfree in two cycless ',rfree_vs_cycle(ncycle_overall)-rfree_vs_cycle(ncycle_overall-1),      &
            ' > ',signal_delta_R_Rfree
    endif
    return
  end subroutine read_and_process_signals

  subroutine signal_reset_defaults
    signal_rfactor_val = 1000.0
    signal_rfree_val = 1000.0
    signal_deltaR = 1000.0
    signal_deltaRfree = 1000.0
    signal_delta_R_Rfree = 1000.0
    signal_rmsbond = 1000.0
  end subroutine signal_reset_defaults

end module signals_refmac
