C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE MAKECIF(MDOC,IN_COORD_FILE,OUT_FILE_CIF,FILE_LIB2
     *  ,CUTOFF,DMIN_SPEC,CONN_FLAG,CIS_FLAG,LNK_FLAG,CHAIN_FLAG
     *  ,PEPT_FLAG,CHECK_SPEC,H_FLAG,RFLAG,FORM,SYMM_FLAG,SS_FLAG
     *  ,SUGAR_FLAG,LIST,CHECK,COOR,SRCH,SEG_FLAG
     *  ,PROG_LIB_PATH,LIBS_PATH,LIBS_NAME,LIBS_EXT,PROG_NAME
     *  ,NOSPGR_INPUT,spgr_input,CELL_INPUT,LIB_OUT,NEW,FSTOP,IERR)
C
C    
C -------------------------------------------------------
C 
C   
C    
C                   ---     MAKECIF    ---
C                                             /Vers 4.0.0 22.11.99/
C    
C     MAKECIF -  uses as input CIF or PDB_file and libraries mon_lib.cif,
C                ener_lib.cif, symlib.blc and creates files:
C                1. with atomic coordinates, symmetry and unit cell
C                   parameters. / file extension "crd"/ 
C                2. with chemical structure description and atomic
C                   scattering structure factors. / file extension "str"/
C                3. with restraints: standard values of bonds, angles, 
C                   torsion angles, chirality centres, plan groups, its
C                   actual values in the structure. / file extension "rst"/
C                4. with Van-der-Waals and H_bond restraints: standard values
C                   of distanceis and its actual values in the structure. /file
C                   extension "vdw"/
C    
C                Program can read additional library of monomers.
C                Program rebuilds missing atoms used information from
C                monomer's library.
C                If the description of a monomer is absent in the library
C                program will try to create library description and write
C                it to special file for further inclusion to the library.
C                Program creates PostScript files with the pictures of new
C                monomers.
C                Program can generate hydrogen atoms.
C 
C -------------------------------------------------------
C
C      input:
C
C  for refmac: ( PROG_NAME must be  = 'refmac' , MDOC = -999 )
C 
C  MDOC            -  =999 with  DOC-file: "makecif.doc",  
C                     if = -999 without this file.
C
C                     for subroutine case:
C
C                      MDOC = 999 do not keep old contents
C                      MDOC = 998 keep old contents
C                      MDOC =-999 without DOC-file
C
C                    for refmac ( PROG_NAME = 'refmac') MDOC = -999 
C
C  IN_COORD_FILE   - name of input CIF or PDB_file 
C
C  FILE_LIB2       - additional library, " " means without this file
C
C  OUT_FILE_CIF    - name of output CIFiles /without extention/
C                       if = ' ' to use default name: OUT_FILE_CIF = 'new'
C
C                        output files will be:  
C 
C                            new.crd
C                            new.str
C                            new.rst
C                            new.vdw
C                            new_XXX.ps
C                            new.lib
C
C  CHECK_SPEC <N>/Y - Y - check atoms in special position, N - not use it.
C
C  DMIN_SPEC:<0.5>  - minimal distance to recognize atom in special 
C                       position, -1 means don't check. 
C  H_FLAG  <Y>/A/N  - Y - hydrogen atoms where they are (not create new)
C                     A - with all hydrogen atoms (rebuild all missing H_atoms)
C                     N - without hydrogen atoms (i.e. remove H)
C
C  RFLAG: <N>/Y     - Y - rebuild non-hydrogen atoms
C
C                     restraints will not be created if H_FLAG = "A" or 
C                     RFLAG = "Y"
C
C  PEPT_FLAG        - Y - check and correct AA in PDB file (L or D)
C
C  LNK_FLAG <N>/Y/D - N - only check links between residues.
C                     Y - use new links between residues.
C                     D - use new but ignore user"s definition
C
C  CONN_FLAG <N>/Y/D  N - only check chain"s connection between residues
C                     Y - use new chain"s connection between residues.
C                     D - use new but ignore user"s definition
C
C  CIS_FLAG  <N>/Y  - Y - check and change peptide link
C
C  SYMM_FLAG  <N>/Y - Y - use links between symmetry reated atoms.
C  
C  CHAIN_FLAG       - Y - check and change chain description
C
C  CUT     <0>      - distance cut_off, 0 - means without VDW and H-bond
C                     restraints
C
C  FORM    <F>/U    - format restraint file ( F or U )
C
C  PROG_LIB_PATH    - path to dictionary, i.e ~~~~~/makecif/dic/
C                     main_makecif uses subroutine  GET_PATH :
C                          
C                          CALL GET_PATH(M,'MAKECIF',LINE,IERR)
C                          CALL LENSTR_BL(LINE,LEN)
C                          IF(LEN.GT.0) THEN
C                            PROG_LIB_PATH = LINE(1:LEN)//'/dic/'
C                          ELSE
C                            PROG_LIB_PATH = ' '
C                          ENDIF 
C
C  LIBS_PATH       -  alternative symlib file
C  LIBS_NAME
C  LIBS_EXT
C
C  PROG_NAME       - makecif or refmac
C  
C      output:
C
C  IERR            - signal of error, 0 means OK.
C
C             NEW = Y new description or/and
C                     convert minimal --> complete (for FILE_LIB2 only)
C                     or/and new link description 
C
C                    for refmac only:
C             IERR =10 cell: Input and PDB are different
C             IERR = 9 sp group missing and cell missing
C             IERR = 8 sp group missing , default = 'P1'
C             IERR = 7 cell missing , default = '100,100,100,90,90,90'
C
C ------------------------------------------------------------
C
C   Compilation's command for UNIX:
C                             make makecif
C 
C -S-                       
C -------------------------------------------------------
C
C  for refmac use:
C
C makecif.f 
C make_CIF.f 
C make_PDB.f 
C make_crd.f 
C make_new.f 
C make_rst.f
C make_lib.f 
C make_refmac_dummy.f 
C make_subr_refmac.f 
C make_subr.f
C
C  don't use:
C
C make_subr_2.f
C make_subr_3.f
C make_subr_vdw.f
C
C -------------------------------------------------------
C  MAKECIF - 
C
C
C      SETPARM
C      GETLIB                 --> make_lib.f
C      INITCRD
C
C        for PDB:
C      GET_PDB                --> make_PDB.f (use GET_SYMM_NB from make_subr.f)
C        for CIF
C      READ_ATOMS             --> make_CIF.f (use GET_SYMM_NB from make_subr.f)
C
C      PRE_DESCR              --> make_new.f
C      READ_LIB               --> make_lib.f
C      CHECK_DESCR_STRUCTURE  --> make_crd.f  
C                                                 MODIF       from make_lib.f
C                                                 CREAT_NEW   from make_new.f
C      CREAT_DESCR            --> make_rst.f
C
C      WRT_LIB                --> make_lib.f
C
C -----------------------------------------------------
      INTEGER*4 IERR,MDOC
      INTEGER*4 NOSPGR_INPUT
      REAL      CELL_INPUT(6)
      character spgr_input*(*)
      CHARACTER IN_COORD_FILE*(*),OUT_FILE_CIF*(*),H_FLAG*1,RFLAG*1
      CHARACTER FILE_LIB2*(*),LIB_OUT*(*)
      CHARACTER CONN_FLAG*1,CHECK_SPEC*1,CIS_FLAG*1,LNK_FLAG*1
      CHARACTER CHAIN_FLAG*1,PEPT_FLAG*1,FORM*1,SYMM_FLAG*1,FSTOP*1
      CHARACTER SS_FLAG*1,SUGAR_FLAG*1,LIST*1,CHECK*1,NEW*1,COOR*1
      CHARACTER SEG_FLAG*1
      CHARACTER LIBS_PATH*(*),LIBS_NAME*(*),LIBS_EXT*(*)
      CHARACTER PROG_NAME*(*),PROG_LIB_PATH*(*)
      REAL      DMIN_SPEC,CUTOFF
C -------
      CHARACTER LIBM_PATH*256    ,LIBE_PATH*256 
      CHARACTER LIBM_NAME(20)*256,LIBE_NAME*256
      CHARACTER LIBM_EXT *256    ,LIBE_EXT *256  
      CHARACTER LIB_IND  *256    ,FILE_LIB_OUT*256 

      CHARACTER IN_FILE_PDB*256
      CHARACTER IN_FILE_CIF*256 ,LIB_PATH*256
      CHARACTER IN_FILE_STR*256 ,IN_FILE_RST*256
      CHARACTER OUT_FILE_STR*256,OUT_FILE_RST*256

      CHARACTER RESTR_FLAG*1,EXT*256,DNEW*1,MODE*4,SRCH*1
      CHARACTER FILE_TYPE_FLAG*1,NODIST*1,NEW_FLAG_OUT*1
      CHARACTER NEW_FLAG*1,PATH*256,LINE*80
      CHARACTER HFLAG_REMOVE*1
      INTEGER*4 KERR,M,ICRD,NUMB_LIB,MDOC_C,NMNEW
C ---
      include 'atom_com.fh'
      include 'lib_com.fh'
      INCLUDE 'crd_com.fh'  
      INCLUDE 'makecif_version.fh'
C -----------------------------------------------
      IERR     = 0
      IERR_RST = 0
C -----------------------------
C
      CALL SET_PATH_PROG_PARM(PROG_LIB_PATH,PROG_NAME
     *                         ,LIBS_PATH,LIBS_NAME,LIBS_EXT)
C ========================================================
C
C   -- start: initialization, define DOC and BATCH files
C
C -----------------------------
C     for refmac ( PROG_NAME must be  = 'refmac' , MDOC = -999 )
C
C
C             1. SUBROUTINE SET_UNIT_CORR:
C
C                       used in SUBROUTINE START: after CALL SET_UNIT_NUMBERS  
C                                       in make_subr.f:
C
C             2. SUBROUTINE SET_LINK_CORR
C
C                         used in SUBROUTINE PRE_DESCR  
C                                       in make_crd.f:
C
C             3. SUBROUTINE GET_SYMM_NB_NEW
C
C                            will be used in make_PDB.f and make_CIF.f
C                       
C -----------------------------
      IF(ABS(MDOC).GE.997) THEN
        MDOC_C = 1

        IF(MDOC.LT.0) THEN
          MDOC = 0
        ELSE      
C   
C         MDOC=999
C         IF(MSG.EQ.'Y') MDOC=999 do not keep old contents
C         IF(MSG.EQ.'A') MDOC=998 keep old contents
C         IF(MSG.EQ.'#') MDOC=997 batch mode, "_DOC " will be read
C          
C         for subroutine case:
C
C         MDOC=999 do not keep old contents
C         MDOC=998 keep old contents
C
C         MDOC=-999 without DOC-file
C
        ENDIF
        CALL START(0,MDOC,PROG_NAME)
      ELSE
        MDOC_C=0
      ENDIF
C ====================================================
      IF(LIST.EQ.'s') LIST = 'S' 
      IF(LIST.EQ.'l') LIST = 'L' 
      IF(LIST.EQ.'t') LIST = 'T' 
      IF(LIST.NE.'S'.AND.LIST.NE.'L'.AND.LIST.NE.'T') LIST = 'M'
      MD0 = 0
      M = 0
      IF(LIST.EQ.'S') THEN
C       MD0  = 999
        MDOC = 999
      ENDIF
      IF(PROG_NAME.EQ.'refmac') MD0 = 999

      IF(MDOC.GT.0) THEN
        M = -1
        CALL MSGDOC(M,' ')
        CALL MSGDOC(M,VERSION)
        CALL MSGDOC(M,' ')
      ENDIF
      IF(M.GT.0) CALL CLOSE_BATCH(M)
C ====================================================
C
C     check input parameters
C
      IF(CHECK.EQ.'y') CHECK = 'Y' 
      IF(CHECK.NE.'Y'.AND.CHECK.NE.'0') CHECK = 'N'

      IF(CHECK_SPEC.EQ.'y') CHECK_SPEC = 'Y' 
      IF(CHECK_SPEC.NE.'Y') CHECK_SPEC = 'N'

      IF(RFLAG.EQ.'y') RFLAG = 'Y' 
      IF(RFLAG.NE.'Y') RFLAG = 'N'

      IF(COOR.EQ.'y') COOR = 'Y' 
      IF(COOR.NE.'Y') COOR = 'N'

      IF(FORM.EQ.'u') FORM = 'U' 
      IF(FORM.NE.'U') FORM = 'F'

      IF(PEPT_FLAG.EQ.'y') PEPT_FLAG = 'Y' 
      IF(PEPT_FLAG.NE.'Y') PEPT_FLAG = 'N'

      IF(SEG_FLAG.EQ.'y') SEG_FLAG = 'Y' 
      IF(SEG_FLAG.NE.'Y') SEG_FLAG = 'N'
      CR_SEGFLAG = SEG_FLAG

      IF(SS_FLAG.EQ.'n') SS_FLAG = 'N' 
      IF(SS_FLAG.EQ.'d') SS_FLAG = 'D' 
      IF(SS_FLAG.NE.'N'.AND.SS_FLAG.NE.'D') SS_FLAG = 'Y'

      IF(CHAIN_FLAG.EQ.'y') CHAIN_FLAG = 'Y' 
      IF(CHAIN_FLAG.NE.'Y') CHAIN_FLAG = 'N'
 
      IF(SYMM_FLAG.EQ.'y') SYMM_FLAG = 'Y' 
      IF(SYMM_FLAG.EQ.'c') SYMM_FLAG = 'C' 
      IF(SYMM_FLAG.NE.'Y'.AND.SYMM_FLAG.NE.'C') SYMM_FLAG = 'N'
 
      IF(CONN_FLAG.EQ.'y') CONN_FLAG = 'Y' 
      IF(CONN_FLAG.EQ.'d') CONN_FLAG = 'D' 
      IF(CONN_FLAG.NE.'Y'.AND.CONN_FLAG.NE.'D'.AND.CONN_FLAG.NE.'0') 
     *                     CONN_FLAG = 'N' 

      IF(CIS_FLAG .EQ.'y') CIS_FLAG  = 'Y' 
      IF(CIS_FLAG .NE.'Y') CIS_FLAG  = 'N' 

      IF(SUGAR_FLAG .EQ.'y') SUGAR_FLAG  = 'Y' 
      IF(SUGAR_FLAG .EQ.'d') SUGAR_FLAG  = 'D' 
      IF(SUGAR_FLAG .EQ.'n') SUGAR_FLAG  = 'N' 
      IF(SUGAR_FLAG .NE.'Y'.AND.SUGAR_FLAG .NE.'D'.AND. 
     *                          SUGAR_FLAG .NE.'N') SUGAR_FLAG  = 'S' 

      IF(LNK_FLAG .EQ.'y') LNK_FLAG  = 'Y' 
      IF(LNK_FLAG .EQ.'d') LNK_FLAG  = 'D' 
      IF(LNK_FLAG .NE.'Y'.AND.LNK_FLAG .NE.'D'.AND.LNK_FLAG .NE.'0') 
     *                          LNK_FLAG  = 'N' 

      IF(H_FLAG    .EQ.'n') H_FLAG     = 'N' 
      IF(H_FLAG    .EQ.'a') H_FLAG     = 'A' 
      IF(H_FLAG .NE.'A'.AND.H_FLAG .NE.'N') H_FLAG  = 'Y'
      HFLAG_REMOVE = 'N'
      IF(H_FLAG.EQ.'N') HFLAG_REMOVE = 'Y' 

      IF(SRCH.EQ.'y') SRCH = 'Y' 
      IF(SRCH.EQ.'a') SRCH = 'A' 
      IF(SRCH.EQ.'g') SRCH = 'G' 
      IF(SRCH.NE.'Y'.AND.SRCH.NE.'A'.AND.SRCH.NE.'G') SRCH = 'N'

      IF(ABS(DMIN_SPEC).LT.0.00001) DMIN_SPEC = 0.5

      NMNEW    = 0
      DNEW     = 'N'
      NEW_FLAG = 'N'
      NEW      = 'N'
      FSTOP    = 'N'
      LIB2     = 0
      NEW_FLAG_OUT = 'N'
C ====================================================
C
C     check coord input file format PDB or CIF
C
      MMM = MDOC
      IF(LIST.EQ.'S') MMM = 999

      IN_FILE_PDB = IN_COORD_FILE
      CALL PDB_OR_CIF(MMM,IN_FILE_PDB,FILE_TYPE_FLAG,IERR)
      if(len_trim(pdb_out_format).le.0) then
         pdb_out_format = file_type_flag
      endif
      pdb_in_format = file_type_flag
      IF(IERR.NE.0) GO TO 100

      CALL SETPARM(MMM,IN_FILE_PDB,OUT_FILE_CIF,FORM,IERR)
      IF(IERR.NE.0) GO TO 100

C =====================================================
C  
C     initialization dictionary information
C
C  -------------------------
      LIB_PATH     = PROG_LIB_PATH 
      LIBM_PATH    = LIB_PATH

C --
      LIBE_PATH    = LIB_PATH      

c      LIBE_NAME    = 'ener_lib'
c      LIBE_EXT     = 'cif'

C     FILE_LIB_OUT = OUT_FILE_CIF
      FILE_LIB_OUT = LIB_OUT
C --
      NODIST = 'N'
      CALL GETLIB(MDOC,LIST,NODIST,NUMB_LIB
     *            ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *            ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *            ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *            ,FILE_LIB2,LIB_IND,FILE_LIB_OUT,IERR)

      IF(IERR.NE.0) GO TO 100 

      IF(LIST.EQ.'T') THEN
        CALL WRITE_LIB_RES_TYPE_TAB(MDOC,IERR)
      ENDIF

C ==============================================
C    
C     initialization COMMONs which are in crd-com.fh
C     and puts file's names to common.
C
      IN_FILE_CIF = ' '
      IF(FILE_TYPE_FLAG.EQ.'C') THEN
        IN_FILE_CIF = IN_FILE_PDB
        IN_FILE_PDB = ' '
      ENDIF
      IN_FILE_STR  = ' '
      IN_FILE_RST  = ' '
      OUT_FILE_STR = OUT_FILE_CIF
      OUT_FILE_RST = OUT_FILE_CIF
C -
      RESTR_FLAG = 'A'
      CALL INITCRD(MDOC,IN_FILE_PDB,IN_FILE_CIF,OUT_FILE_CIF
     *    ,IN_FILE_STR,OUT_FILE_STR,IN_FILE_RST,OUT_FILE_RST
     *    ,RESTR_FLAG,H_FLAG,IERR)
      IF(IERR.NE.0) GO TO 100
C =============================================
C
C     read coord input file 
C
      MMM = MDOC
      IF(LIST.EQ.'S') MMM = 999
      IF(FILE_TYPE_FLAG.EQ.'P') THEN
C       ---  read PDB_file.
        CALL MSGDOC(MD0,' I am reading PDB_file')
C       make_PDB.f
        IERR = 1
C       IERR=1 means GET_PDB is called from MAKECIF or LIBCHECK
C       list = 'T' ierr 0 --> 98, ierr = 1 -->99
        IF(LIST.EQ.'T') THEN
          IERR = 99 
        ENDIF
        CALL GET_PDB(MMM,IN_FILE_PDB,NOSPGR_INPUT,spgr_input,
     &       CELL_INPUT,PEPT_FLAG,SEG_FLAG,HFLAG_REMOVE,IERR)  
C       IERR = 9 sp group missing and cell missing
C       IERR = 8 sp group missing , default = 'P1'
C       IERR = 7 cell missing , default = '100,100,100,90,90,90'
        IF(LIST.EQ.'T') THEN
          WRITE(*,*) '--after GET_PDB, ierr=',IERR
        ENDIF    
        IF(IERR.GE.7.AND.PROG_NAME.NE.'refmac') IERR = 0
        IF(IERR.NE.0) GO TO 100
      ELSE
        CALL LENSTR_BL(IN_FILE_CIF,LEN)
        IF(LEN.GT.0.AND.IN_FILE_CIF(1:1).NE.' '.AND.
     *    IN_FILE_CIF(1:1).NE.',') THEN
C          --- read CIFile.
          CALL MSGDOC(MD0,' I am reading CIFile')
          EXT  = ' '
          PATH = ' '
C         read_CIF.f
          IERR = 1
          CALL READ_ATOMS(MMM,PATH,IN_FILE_CIF,EXT    
     *         ,NOSPGR_INPUT,spgr_input,CELL_INPUT,IERR)


C         IERR = 9 sp group missing and cell missing
C         IERR = 8 sp group missing , default = 'P1'
C         IERR = 7 cell missing , default = '100,100,100,90,90,90'
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '--after READ_ATOMS , ierr=',IERR
          ENDIF
     
          IF(IERR.GE.7.AND.PROG_NAME.NE.'refmac') IERR = 0
          IF(IERR.NE.0) GO TO 100
        ENDIF
      ENDIF

      IF(LIST.EQ.'T') THEN
        EXT  = 'crd'
        PATH = ' '
        LINE = 'new_test1'
        CALL WRITE_ATOMS(MDOC,PATH,LINE,EXT,IERR)
      ENDIF
C ================================================
C 
C
C    PRE_DESCR - create/correct res_name, res_type 
C                                (use list of modifications)   
C                create new description of monomer which can not be found
C                                in mon_lib.cif ( type of new monomers is  
C                                                            non-polymer ) 
C ----
C     output:
C             NMNEW    - number of new monomers
C             KERR = 2 - number of monomer in the library = 0
C             KERR = 0 and IERR = 0 - OK
C ----   
C     make_crd.f & make_new.f
C

      CALL PRE_DESCR(MDOC,LIST,CHECK,COOR,SRCH
     *              ,PROG_NAME,NMNEW,NEW_FLAG_OUT,LIB2,KERR,IERR)
      IF(KERR.NE.0.OR.IERR.NE.0) GO TO 100

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' --NMNEW,NEW_FLAG_OUT,LIB2:'
     *  ,NMNEW,NEW_FLAG_OUT,LIB2
        EXT  = 'crd'
        PATH = ' '
        LINE = 'new_test2'
        CALL WRITE_ATOMS(MDOC,PATH,LINE,EXT,IERR)
      ENDIF
C --------------------------------------
C
C     read mon_lib.cif
C
CC      CALL MSGDOC(MDOC,' I am reading library. Please wait.')
CC      CALL MSGDOC(MDOC,'               mon_lib.cif')
CC      MOD = 'M'
CC      CALL READ_LIB(MDOC,MOD,IERR)
CC      IF(IERR.NE.0) GO TO 100

C --------------------------------------

      MMM = MDOC
      IF(LIST.EQ.'S') MMM = 999
      CALL DEF_LINK_MOD(MMM,LIST,DNEW,IERR)

      IF(LIST.EQ.'T') THEN
        EXT  = 'crd'
        PATH = ' '
        LINE = 'new_test3'
        CALL WRITE_ATOMS(MDOC,PATH,LINE,EXT,IERR)
      ENDIF
      
C --------------------------------------
C      CHECK_DESCR_STRUCTURE :
C
C     1. check atoms in special position.
C        ( if DMIN_SPEC > 0 )
C
C     2. check list of links. 
C
C     3. check chain connectivity, set residue"s conn_type
C        check type of peptide link: 'CIS' or 'TRANS' 
C     
C     4. check intra chain links
C        if not in the dictionary: create it /set DNEW='Y'/
C        ( if LNK_FLAG = 'Y' )
C
C     5. check inter chain's connectivity 
C        if not in the dictionary: create it /set DNEW='Y'/
C        check actual distance: if big  - link will be ignored.      
C        ( if CONN_FLAG = 'Y' )
C
C
C     6. create new list of chains and set type of terminus residues.
C
C     7. check completeness of atom's list of residue.
C ---
C  make_crd.f
C
C
      CALL CHECK_DESCR_STRUCTURE(MDOC,LIST,CHECK_SPEC
     * ,DMIN_SPEC,CONN_FLAG,CIS_FLAG,LNK_FLAG,CHAIN_FLAG
     * ,DNEW,NEW_FLAG,SS_FLAG,SUGAR_FLAG,CHECK,COOR,IERR)
      IF(IERR.NE.0) GO TO 100

C 6.04.03 now CHECK_DESCR_STRUCTURE doesn't change NEW_FLAG
C      IF(NEW_FLAG.EQ.'Y') NMNEW = NMNEW+1

C -------------------------------------------------------
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' ==NMNEW,DNEW:',NMNEW,DNEW
        EXT  = 'crd'
        PATH = ' '
        LINE = 'new_test4'
        CALL WRITE_ATOMS(MDOC,PATH,LINE,EXT,IERR)
      ENDIF
C --------------------------------------
      CALL MSGDOC(MD0,' I am creating restraints')
      RESTR_FLAG = 'A'
      IF(RFLAG.EQ.'Y'.OR.H_FLAG.EQ.'A') RESTR_FLAG = 'N' 
C     make_rst.f
      CALL CREAT_DESCR(MDOC,LIST,RESTR_FLAG,CUTOFF,DMIN_SPEC
     *                                ,SYMM_FLAG,H_FLAG,RFLAG,IERR)

      IERR_RST = IERR
      IERR     = 0
C -----------------------------------
C      WRT_LIB - writes library to the file.
C
C     MODE:  TITC - titles only for new
C            TITA - all
C            TITL - 'Y', 'C', except 'N' & '?'
C
 200  CONTINUE

      IF(NMNEW.GT.0.OR.DNEW.NE.'N') THEN
        MMM = MDOC
        IF(LIST.EQ.'T') THEN
          WRITE(*,*) ' --NMNEW,DNEW:',NMNEW,DNEW
        ENDIF
        CALL GET_USER_LIB(NMNEW,DNEW,LIST,IERR)
        IF(IERR.NE.0) GO TO 100    

        IF(LIST.EQ.'S') MMM = 999
        CALL LENSTR_BL(FILE_LIB_OUT,LEN)
        LINE = ' I am writing new library: '
        CALL MSGDOC(MMM,LINE)
        IF(LEN.GT.74) LEN = 74
        IF(LEN.LT. 1) LEN = 1
c        LINE = ' '//FILE_LIB_OUT(1:LEN)//'.lib'
        LINE = ' '//FILE_LIB_OUT(1:LEN)
        CALL MSGDOC(MMM,LINE)
        MODE = 'TITC'
        ICRD = 0
        CALL WRT_LIB(MMM,MODE,ICRD,IERR)
        IF(IERR.NE.0) GO TO 100    
        IF(NMNEW.GT.0) THEN
          MODE = 'MONC'
          ICRD = 0
          CALL WRT_LIB(MMM,MODE,ICRD,IERR)
          IF(IERR.NE.0) GO TO 100    
        ENDIF
        MODE = 'MODC'
        ICRD = 0
        CALL WRT_LIB(MMM,MODE,ICRD,IERR)
        IF(IERR.NE.0) GO TO 100    
        IF(DNEW.NE.'N') THEN
          MODE = 'LINC'
          ICRD = 0
          CALL WRT_LIB(MMM,MODE,ICRD,IERR)
          IF(IERR.NE.0) GO TO 100    
        ENDIF
        MODE = 'STOP'
        ICRD = 0
        CALL WRT_LIB(MMM,MODE,ICRD,IERR)
        IF(IERR.NE.0) GO TO 100    

        CALL LENSTR_BL(FILE_LIB2,LEN)
        IF(LEN.LE.0.OR.FILE_LIB2(1:1).EQ.' '.OR.
     *     FILE_LIB2(1:1).EQ.',') THEN
          CALL LENSTR_BL(FILE_LIB_OUT,LEN)
c         FILE_LIB2 = FILE_LIB_OUT(1:LEN)//'.lib' 
C         FILE_LIB2 = FILE_LIB_OUT(1:LEN) 
        ELSE

        ENDIF
        NEW = 'Y'
C --    6.04.03 IF(LIB2.GT.0) ????
        IF(LIB2.LE.0) THEN
          FSTOP = 'N'
          IF(NEW_FLAG_OUT.EQ.'Y') FSTOP = 'Y' 
        ELSE
          FSTOP = 'Y'
        ENDIF
        IF(DNEW.NE.'N') FSTOP = 'Y'
C --
      ENDIF

C ---------------------------
 100  CONTINUE

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' ==makecif end:FSTOP,IERR,IERR_RST:'
     *  ,FSTOP,IERR,IERR_RST
      ENDIF

      IF(IERR.EQ.0) IERR = IERR_RST

      IF(MDOC_C.EQ.1) CALL FINISH

      RETURN
      END     

      SUBROUTINE GET_USER_LIB(NMNEW,DNEW,LIST,IERR)
C -----------------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
C -----------------------------------------------
      CHARACTER DNEW*1,MOD_R*1,NODIST*1,LIST*1,MON*16
C -----------------------------------------------
      IERR   = 0
      M      = 99
      NODIST = 'N'

      IF(LIST.EQ.'T') THEN
        M = 0
        WRITE(*,*) '---gRD-:',LB_NUMB_LIB,LML_NMON
        DO L=1,LML_NMON
          IF(LML_PASS(L).GT.LB_NUMB_LIB) THEN
            WRITE(*,*) '-gRD:',l,LML_MNAME(l),LML_FUSE(l),LML_PASS(l)
          ENDIF
        ENDDO
        WRITE(*,*) '-----'
      ENDIF

      DO L=1,LML_NMON
        IF(LML_PASS(L).GT.LB_NUMB_LIB) THEN

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '-gRD:',l,LML_MNAME(l),LML_FUSE(l),LML_PASS(l)
          ENDIF

          LLL = L
          IF(LML_FUSE(L).EQ.'N'.AND.LML_MNAME(L).NE.'???') THEN
C           read mon_lib.cif
            LML_FUSE(L) = 'R'
            MOD_R       = 'M'
            MON = LML_MNAME(L) 
            CALL READ_LIB(M,MOD_R,NODIST,LIST,IERR)
            IF(IERR.NE.0) THEN
              CALL MSGERR(M,'ERROR: in GET_USER_LIB') 
              RETURN
            ENDIF

            DO LL=1,LML_NMON
              IF(LML_PASS(LL).GT.LB_NUMB_LIB) THEN
                IF(MON.EQ.LML_MNAME(LL)) THEN
                LLL = LL

                IF(LIST.EQ.'T') THEN
                  WRITE(*,*)'-lRD:',
     *            LLL,LML_MNAME(LLL),LML_FUSE(LLL),LML_PASS(LLL)
                ENDIF

                ENDIF
              ENDIF
            ENDDO
          ENDIF

          IF(NMNEW.LE.0) NMNEW = 1
          LML_FUSE(LLL) = 'C'

        ENDIF
      ENDDO

      IF(LMS_NSYN.GT.0) THEN
        DO L=1,LMS_NSYN
          IF(LMS_FLAG(L).EQ.'N') THEN
            LMS_NEW = 1
          ENDIF
        ENDDO
      ENDIF

      IF(LLL_NLINK.GT.0) THEN
        DO L=1,LLL_NLINK
          IF(LLL_FUSE(L).EQ.'C') DNEW = 'Y'
        ENDDO
      ENDIF
      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD
C         IF(LDL_FUSE(L).EQ.'C') DNEW = 'Y'
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE PDB_OR_CIF(MDOC,IN_FILE_PDB,FLAG,IERR)
      INTEGER*4 MDOC,IERR
      CHARACTER IN_FILE_PDB*(*),FLAG*1
C ******
      CHARACTER LINE*80,PATH*256,EXT*256,STR*80
      INTEGER*4 M,IUN,IFIRST,LEN,I,J,K
C -------------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
c     MD   = -ABS(MDOC)-1
      M    = 99
      IERR = 0
C ----------------
      CALL CLEAR_LINE(IN_FILE_PDB)
      CALL LENSTR_BL(IN_FILE_PDB,LEN)
      IF(LEN.LE.0.OR.IN_FILE_PDB(1:1).EQ.','.OR.
     *               IN_FILE_PDB(1:1).EQ.' ') THEN
        CALL MSGERR(MDOC,' ERROR: can''t open input_coord_file')
        IERR=1
        RETURN
      ENDIF

      IF(LEN.GT.66) LEN = 66
      LINE = 'Input file :'//IN_FILE_PDB(1:LEN)
      CALL MSGDOC(MDOC,LINE)

C ----
C     IUN  = 14
      IUN  = CRI_IUN
      PATH = ' '
      EXT  = ' '
      CALL OPENFR(IUN,M,PATH,IN_FILE_PDB,EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: can''t open input_coord_file')
        RETURN
      ENDIF
      CRI_IUN = IUN
C ----
      FLAG = 'C'
      DO I=1,1000

        READ(IUN,'(A)',ERR=100,END=100) LINE

        IF(LINE(1:4).EQ.'HEAD'.OR.LINE(1:4).EQ.'COMP'.OR.
     *     LINE(1:4).EQ.'REMA'.OR.LINE(1:4).EQ.'CRYS'.OR.
     *     LINE(1:4).EQ.'SCAL'.OR.LINE(1:4).EQ.'ATOM'.OR.
     *     LINE(1:4).EQ.'HETA') THEN
          FLAG = 'P'
          GO TO 100
        ENDIF

        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.GT.4.AND.LINE(1:1).NE.'#') THEN
          IFIRST = 0
          K      = 0
          DO J=1,LEN
            IF(LINE(J:J).EQ.' '.AND.IFIRST.EQ.0) THEN
            ELSE
              IFIRST   = 1
              K        = K+1
              STR(K:K) = LINE(J:J)
            ENDIF
          ENDDO
          IF(STR(1:1).EQ.'_'.OR.STR(1:5).EQ.'data_') THEN
            FLAG = 'C'
            GO TO 100
          ENDIF
        ENDIF

      ENDDO

 100  CONTINUE
      CLOSE(CRI_IUN,ERR=110)
 110  CONTINUE

      RETURN
      END     

C ******
      SUBROUTINE SETPARM(MDOC,IN_FILE_PDB,OUT_FILE_CIF,FORM,IERR)
C -------------------------------------------------------
C -P- SETPARM - 
C -S-
C -------------------------------------------------------
      INCLUDE 'crd_com.fh'
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
     
      CHARACTER IN_FILE_PDB*(*),OUT_FILE_CIF*(*),FORM*1
C ******
      CHARACTER LINE*256
      INTEGER*4 MD,LEN
C -----------------------------------
      MD   = -ABS(MDOC)-1
c     M    = 99
      IERR = 0
C ---
C     initialization names of files
      CRI_PATH  = ' '
      CRI_EXT   = ' '
      CRO_PATH  = ' '
      CRO_EXT   = 'crd'
      CRS_PATH  = ' '
      CRS_EXT   = 'str'
      CRR_PATH  = ' '
      CRR_EXT   = 'rst'
      CRV_PATH  = ' '
      CRV_EXT   = 'vdw'
      CRPS_PATH = ' '
      CRPS_EXT  = 'ps'
C --
C      CRI_IUN  = 0
C      CRO_IUN  = 0
C      CRS_IUN  = 0
C      CRR_IUN  = 0
C      CRV_IUN  = 0
C -----------------------------------
C     open file for read
      LINE=IN_FILE_PDB
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LT.1.OR.LINE(1:1).EQ.','.OR.LINE(1:1).EQ.' ') THEN
        CALL MSGERR(MD,' ERR: WRONG NAME OF INPUT_FILE')
        IERR=1
        RETURN
      ENDIF
      CRI_FILE = IN_FILE_PDB(1:LEN)

C     IUN = 14
C     IUN = CRI_IUN
C      CALL OPENFR(IUN,MD,CRI_PATH,CRI_FILE,CRI_EXT,IERR)
C      IF(IERR.NE.0) THEN
C        CALL MSGERR(MDOC,' ERR: open error intput_PDB_file')  
C        RETURN
C      ENDIF
C      CLOSE(IUN)
C 
      CRS_FILE = CRI_FILE
      CRR_FILE = CRI_FILE
      CRV_FILE = CRI_FILE
C -----------------------------------
C     open files for write
      LINE = OUT_FILE_CIF
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LT.1.OR.LINE(1:1).EQ.','.OR.LINE(1:1).EQ.' ') THEN
        CALL MSGERR(MDOC,' ERR: WRONG NAME OF OUTPUT_FILE')
        IERR=1
        RETURN
      ENDIF
      CRO_FILE = OUT_FILE_CIF(1:LEN)

C     IUN = 15
C     IUN = CRO_IUN
C     CRO_FILE = OUT_FILE_CIF(1:LEN)
C     CALL OPENFW(IUN,MD,CRO_PATH,CRO_FILE,CRO_EXT,IERR)
C     IF(IERR.NE.0) THEN
C       CALL MSGERR(MDOC,' ERR: open error output_CIFile')  
C       RETURN
C     ENDIF
C     CLOSE(IUN)

C ---
      CRSO_FILE = CRO_FILE
      CRRO_FILE = CRO_FILE
      CRVO_FILE = CRO_FILE
      CRPS_FILE = CRO_FILE

      CR_FORM_RST = FORM

C -----------------------------------
      RETURN
      END     

C ******
      SUBROUTINE INITCRD(MDOC,IN_FILE_PDB,IN_FILE_CIF,OUT_FILE_CIF
     *    ,IN_FILE_STR,OUT_FILE_STR,IN_FILE_RST,OUT_FILE_RST
     *    ,RESTR_FLAG,H_FLAG,IERR)
C -------------------------------------------------------
C -P- INITCRD - initialization of common blocks /CRDINF/ /CRDATM/ /CRDMLN/
C -S-
C -------------------------------------------------------
      INCLUDE 'crd_com.fh'
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER IN_FILE_PDB*(*),IN_FILE_CIF*(*)
      CHARACTER OUT_FILE_CIF*(*)
      CHARACTER IN_FILE_STR*(*),IN_FILE_RST*(*)
      CHARACTER OUT_FILE_STR*(*),OUT_FILE_RST*(*)
      CHARACTER H_FLAG*1,RESTR_FLAG*1
C ******
C -----------------------------------
      PI   = 4.0*ATAN(1.0)
      IERR = 0
C ---
      CR_CELL(1)    = 100.0
      CR_CELL(2)    = 100.0
      CR_CELL(3)    = 100.0
      CR_CELL(4)    = PI/2.0
      CR_CELL(5)    = PI/2.0
      CR_CELL(6)    = PI/2.0
      CR_SCALE(1,1) = 1.0
      CR_SCALE(1,2) = 0.0
      CR_SCALE(1,3) = 0.0
      CR_SCALE(2,1) = 0.0
      CR_SCALE(2,2) = 1.0
      CR_SCALE(2,3) = 0.0
      CR_SCALE(3,1) = 0.0
      CR_SCALE(3,2) = 0.0
      CR_SCALE(3,3) = 1.0
      CR_U(1)       = 0.0
      CR_U(2)       = 0.0
      CR_U(3)       = 0.0
C
      CR_ORT_TO_FRAC(1,1) = 1.0
      CR_ORT_TO_FRAC(1,2) = 0.0
      CR_ORT_TO_FRAC(1,3) = 0.0
      CR_ORT_TO_FRAC(2,1) = 0.0
      CR_ORT_TO_FRAC(2,2) = 1.0
      CR_ORT_TO_FRAC(2,3) = 0.0
      CR_ORT_TO_FRAC(3,1) = 0.0
      CR_ORT_TO_FRAC(3,2) = 0.0
      CR_ORT_TO_FRAC(3,3) = 1.0
C
      CR_NAME_PDB = '----'
      CR_DATE_PDB = 'XX-XXX-XX'
      CR_CD_PDB   = 'xxxx'
      CR_TITLE    = '---'
      CR_RFAC_PDB = '.'
      CR_RESL_PDB = '.'
      CR_MODEL_PDB= 0
      CR_NSPGR    = 1
      CR_SETT     = 1
      CR_SPGR     = 'P 1'
      CR_PDB_REC  = ' '
      CR_NSYM     = 1
      CR_NCS      = 0
      CR_SYMOP    = 'X,Y,Z'
      CR_IA       = 0
      CR_IRES     = 0
      CR_IGRES    = 0
      CR_ICH      = 0
      CR_IGROUP   = 0
      CR_B_FLAG   = 0
      CR_RTYPE    = ' '
      CR_ATYPE    = ' '
      CR_TERM     = ' '
      CR_RNAME    = ' '
      CR_ANAME    = ' '
      CR_CHAIN    = '    '
      CR_SEG      = '.       '
      CR_ANAME_INP= ' '
      ST_CHEM     = ' '
      CR_GROUP    = '    '
      RS_NATOM    = 0 
      RS_NBOND    = 0 
      RS_NBNDS    = 0 
      RS_NANGL    = 0 
      RS_NTORS    = 0 
      RS_NCHIR    = 0 
      RS_NPLAN    = 0 
      RS_NVDW     = 0 
      RS_NHB      = 0 
      RSV_NVDW    = 0 
      RSV_NHB     = 0 
c
      CR_MULT_FLAG   = 0
      CR_MULT_FACTOR = 1
C --------------------
      CR_TEMPER     = 0.0
      CR_WAVEL      = 0.0
      CR_RES_MIN    = 0.0
      CR_RES_MAX    = 0.0
      CR_RFAC_ALL   = 0.0
      CR_RFAC_OBS   = 0.0
      CR_SIGMA_I    = 0.0
      CR_SIGMA_F    = 0.0
      CR_CD_NDB     = '?'
      CR_CD_CSD     = '?'
      CR_DATE_NDB   = '?'
      CR_DATE_CREAT = '?'
      CR_PROGRAM    = '?'
      CR_METHOD     = '?'
C ---
      IF(IN_FILE_CIF.NE.' ') THEN
        CRI_FILE = IN_FILE_CIF
        CRI_PATH = ' '
        CRI_EXT  = 'crd'
      ELSE
        CRI_FILE = IN_FILE_PDB
        CRI_PATH = ' '
        CRI_EXT  = ' '
      ENDIF
      CRO_FILE  = OUT_FILE_CIF
      CRO_PATH  = ' '
      CRO_EXT   = 'crd'
      CRRO_FILE = OUT_FILE_RST
      CRRO_PATH = ' '
      CRRO_EXT  = 'rst'
      CRVO_FILE = OUT_FILE_RST
      CRVO_PATH = ' '
      CRVO_EXT  = 'vdw'
      CRSO_FILE = OUT_FILE_STR
      CRSO_PATH = ' '
      CRSO_EXT  = 'str'
      CRS_FILE  = IN_FILE_STR
      CRS_PATH  = ' '
      CRS_EXT   = 'str'
      CRR_FILE  = IN_FILE_RST
      CRR_PATH  = ' '
      CRR_EXT   = 'rst'
      CRV_FILE  = IN_FILE_RST
      CRV_PATH  = ' '
      CRV_EXT   = 'vdw'
      IF(RESTR_FLAG.EQ.'N') THEN
        CRSO_FILE = ' '
        CRRO_FILE = ' '
        CRVO_FILE = ' '
      ELSE IF(RESTR_FLAG.EQ.'Y') THEN
c        CRRO_FILE=' '
      ENDIF

C      CRI_IUN  = 0
C      CRO_IUN  = 0
C      CRS_IUN  = 0
C      CRR_IUN  = 0
C      CRV_IUN  = 0
C      CRSO_IUN = 0
C      CRRO_IUN = 0
C      CRVO_IUN = 0

      CR_HFLAG = H_FLAG


      RETURN
      END     

