module AddRestraints
  use atomcom
  implicit none

  !---  Things for parser
  integer, private :: ntok,itk,itk_in,itk_out,itok
  integer, private,parameter :: maxtok = 500
  integer, private ::  ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
  character, private :: line_parse*600,key*4
  character, private :: cvalue(maxtok)*4
  real, private :: fvalue(maxtok)
  logical, private :: lend,lprint
  integer, private :: iend_r,lend_f
  integer, private :: ios

contains
  subroutine sugar_pucker(ibond_file,iangle_file,itorsion_file,ichiral_file,    &
       nbonds_sp,nangles_sp,ntorsions_sp,nchirals_sp)
    !
    integer ibond_file,iangle_file,itorsion_file,ichiral_file
    integer nbonds_sp,nangles_sp,ntorsions_sp,nchirals_sp

    call read_sugar_pucker_size
    
    if(nmons.le.0) then
       write(*,*)
       write(*,*)'Sugar pucker file is empty'
       call errwrt(1,'Problem with sugar pucker file')
    endif

    allocate(res_mons(nmons))
    allocate(res_labels(nmons))
    allocate(res_groups(nmons))
    allocate(bond_start(nmons+1))
    allocate(bond_start(nmons+1))
    allocate(angle_start(nmons+1))
    allocate(torsion_start(nmons+1))
    
    allocate(bond_atoms(2,nbond_mons))
    allocate(bond_value(2,nbond_mons))
    
    allocate(angle_atoms(3,nangle_mons))
    allocate(angle_value(2,nangle_mons))

    allocate(chiral_atoms(4,nchiral_mons))
    allocate(chiral_value(2,nchiral_mons))

    allocate(torsion_atoms(4,ntorsion_mons))
    allocate(torsion_value(2,ntorsion_mons))

    call sugar_pucker_values

    !
    !   Now read instructions
    !
    call sugar_addrest_instructs

    !
    !  Now apply where it is appropriate

  end subroutine sugar_pucker

  subroutine read_addrest_instructs
    !
    !   Read insructions about additional restraints and find references to the dictionary values

    call open_form_file(iun_p,keywords_file,ierr_l)
    if(ierr_l.ne.0) then
       write(*,*)'Problem with keywords file'
       call errwrt(1,'Can not continue')
    endif

    call open_unform_file(iun_ar,file_basepairs,ierr_l)

    npairs_l = 0
    ios = 0
    line_parse = ' '
    anti_flag = .FALSE.
    call header('Base pair information')
    write(*,*)('-',i=1,100)
    write(*,'(10x,a5,1x,a8,5x,a7,1x,a7,1x,a8)')'Chain','ResName','ResNum','InsCode',,'RestName'
    !
    !   Read users' instructions
    do while(ios.eq.0)
       read(iun_p,'(a)',iostat=ios)line_parse
       if(ios.ne.0) exit
       ntok = 500
       call parser(key,line_parse,ibeg,iend,itype,fvalue,cvalue,idec,ntok,lend,lprint)
       if(len_trim(line_parse).le.0) cycle
       call ccpupc(key)
       if(key.eq.'END') exit
       do  itk=2,ntok
          call ccpupc(cvalue(itk))
       enddo
       itk = 2
       additional_flag = .FALSE.
       sugar_pucker_flag = .FALSE.
       furanose_flag = .FALSE.
       pyranose_flag = .FALSE.
       rnadna_flag = .FALSE.

       if(key.eq.'REST'.and.ntok.ge.2) then
          if(cvalue(2).eq.'ADDR') then
             additional_flag = .TRUE.
          elseif(cvalue(2).eq.'SUGA') then
             sugar_pucker_flag = .TRUE.
          elseif(cvalue(2).eq.'FURA') then
             furanose_flag = .TRUE.
          elseif(cvalue(2).eq.'PYRA') then
             pyranose_flag = .TRUE.
          elseif(cvalue(2).eq.'RNAD') then
             rnadna_flag = .TRUE.
          else
             cycle
          endif
          itk = 3
          ins_ar(1:2,1:2) = '.'
          !
          !   If auto then set auto_ar = TRUE. Remaining basepairs will be defined automatically
          if(ntok.lt.3) then
             auto_rest = .TRUE.
          elseif(cvalue(itk).eq.'AUTO') then
             auto_rest = .TRUE.
          else
             !
             !   Read instructions.
             i1 = 1
             itk = itk+1
             ! 
             !   Next key is dummy. It is just to make instructions human readable
             if(cvalue(itk)(1:3).eq.'FOR') itk = itk + 1
             if(cvalue(itk).eq.'RANG') itk = itk + 1
             if(ntok-itk.ge.10) then
                do while(itk.le.ntok)
                   !
                   !   residue range is defined: from chain <chain> residue <residue> to chain <chain> residue <residue>
                   !   ins code can also be defined
                   if(cvalue(itk).eq.'FROM') then
                      itk = itk+1
                      is = 1
                   elseif(cvalue(itk).eq.'TO') then
                      itk = itk + 1
                      is = 2
                   else if(cvalue(itk).eq.'CHAI') then
                      itk = itk + 1
                      chain_ar(is) = line_parse(ibeg(itk):iend(itk))
                      itk = itk + 1
                   elseif(cvalue(itk).eq.'RESI') then
                      itk = itk + 1
                      res_ar(is) = nint(fvalue(itk))
                      itk = itk + 1
                   elseif(cvalue(itk)(1:3).eq.'INS') then
                      itk = itk + 1
                      ins_ar(is) = line_parse(ibeg(itk):iend(itk))
                      itk = itk + 1
                   elseif(cvalue(itk).eq.'LABE') then
                      itk = itk + 1
                      addr_label = line_parse(ibeg(itk):iend(itk))
                      itk = itk + 1
                   endif
                enddo
             endif
             if(any(chain_ar(1:2).eq.' ').or.any(res_ar(1:2).le.-1000).or.trim(addr_label).le.0) then
                write(*,*)'Error==> Instructions for base pairadditional restraints. Correct syntax is:'
                write(*,*)'rest addr|suga|fura|pyra|rnad for range from chain <chain>'//                 &
                     ' residue <residue> to chain <chain> residue <residue> label <label>'
                write(*,*)'                     or '
                write(*,*)'rest  addr|suga|fura|pyra|rnad auto'
                call errwrt(1,'Invalid additional restraint instruction')
             endif
             ir_s1 = 0
             do ir=1,n_residue
                call get_chain_namepdb(chnnamp,ir)
                ins_code = res_num_pdb(ir)(7:7)
                if(ins_code.eq.' ')ins_code='.'
                if(chnnamp.eq.chain_bp(1)) then
                   read(res_num_pdb(ir)(3:6),'(i5)')res_num
                   if(res_num.eq.res_bp(1)) then
                      if(ins_bp(1).eq.'.'.or.ins_code.eq.ins_bp(1)) then 
                         ir_s1 = ir
                         exit
                      endif
                   endif
                endif
             enddo
             if(ir_s1.le.0) then
                write(*,*)'Starting residue',chain_ar(1,1),res_ar(1),ins_ar(1),' could not be found'
                call errwrt(1,'Problem with additional restraint instruction')
             endif
             do ir1=ir_s1,n_residue
                call get_chain_namepdb(chnnamp,ir1)
                ins_code = res_num_pdb(ir1)(7:7)
                if(ins_code.eq.' ')ins_code='.'
                read(res_num_pdb(ir1)(3:6),'(i5)')res_num
                if(chnnamp.ne.chain_ar(2)) exit
                if(res_num.gt.res_ar(2)) exit
                call get_mon_name(ir1,res_name1)
                !
                !  Is the current residue in the list of residues defined for restraints
                call get_mon_type()
                if(additional_flag.or.pyranose_flag.and.res_type.'PYRA'.or.              &
                     furanose_flag.and.res_type.eq.'FURA'.or.rnadna_flag.or.res_type.eq.'RNAD') then
                   do i=nmons,1,-1
                      if(addr_label.eq.res_label(i)) then
                         if(res_name1.eq.res_mons(i)) then
                            imon = i
                            exit
                         endif
                      endif
                   enddo
                   if(imon.gt.0) then
                      write(*,*)chnnamp,res_name1,res_num,ins_code,res_label(ibase)
                      !
                      !    Find bonds and write to the bond file
                      nbond_s = bond_start(imon)
                      nbond_e = bond_start(imon+1)-1
                      iat_s1 = iratm_first(ir1)
                      iat_e1 = iat_s1 + natm_res(ir1))-1
                      nats = iat_e1-iat_s1+1
                      allocate(visited_this(nats))
                      if(nbond_s.le.nbond_e) then
                         do ip=nbond_s,nbond_e
                            things_to_do = .TRUE.
                            visited_this = 0
                            !
                            !  If there are atoms with alt code then we need to find all potental atom pairs 
                            !  (triplets etc)
                            do while(things_to_do)
                               alt_code_previous = ' '
                               icount = 0
                               do ia=iat_s1,iat_e1
                                  alt_code_this = id_alt(ia)
                                  if(alt_code_this.eq.'.'.or.alt_code_this.eq.'?')alt_code_this = ' '
                                  iaa = ia-iat_s1+1
                                  if(visited_this(iaa).eq.0) then
                                     do k=1,2
                                        if(atm_name(ia).eq.bond_atom(k,ip)) then
                                           if(alt_code_this.eq.' ') then
                                              icount = icount + 1
                                              ia_out(k) = ia
                                           else
                                              visited_this(iaa) = 1
                                              if(alt_code_previous.eq.' ') then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                                 alt_code_previous = alt_code_this
                                              elseif(alt_code_this.eq.alt_code_previous) then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                              endif
                                           endif
                                           exit
                                        endif
                                     enddo
                                  endif
                               enddo
                               if(icount.eq.2) then
                                  nbonds_ar = nbonds_ar + 1
                                  write(ibond_file) 1
                                  write(ibond_file)ia_out(1:2),bond_value(1:2,ibb),is_symm(1:4,1),1,1
                                  if(alt_code_previous.eq.' ') then
                                     things_to_do=.FALSE.
                                  endif
                               else
                                  things_to_do=.FALSE.
                               endif
                            enddo
                         enddo
                      endif
                      !
                      !    Find angles and write to the bond file
                      nangle_s = angle_start(imon)
                      nangle_e = angle_start(imon+1)-1
                      if(nangle_s.le.nangle_e) then
                         do ip=nangle_s,nangle_e
                            things_to_do = .TRUE.
                            visited_this = 0
                            do while(things_to_do)
                               alt_code_previous = ' '
                               icount = 0
                               do ia=iat_s1,iat_e1
                                  alt_code_this = id_alt(ia)
                                  if(alt_code_this.eq.'.'.or.alt_code_this.eq.'?')alt_code_this = ' '
                                  iaa = ia-iat_s1+1
                                  if(visited_this(iaa).eq.0) then
                                     do k=1,3
                                        if(atm_name(ia).eq.angle_atom(k,ip)) then
                                           if(alt_code_this.eq.' ') then
                                              icount = icount + 1
                                              ia_out(k) = ia
                                           else
                                              visited_this(iaa) = 1
                                              if(alt_code_previous.eq.' ') then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                                 alt_code_previous = alt_code_this
                                              elseif(alt_code_this.eq.alt_code_previous) then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                              endif
                                           endif
                                           exit
                                        endif
                                     enddo
                                  endif
                               enddo
                               if(icount.eq.3) then
                                  nangles_ar = nangles_ar + 1
                                  write(iangle_file)ia_out(1:3),(is_symm(1:4,m),m=1,3),angle_value(1:2,ibb),1,1
                                  if(alt_code_previous.eq.' ') then
                                     things_to_do=.FALSE.
                                  endif
                               else
                                  things_to_do=.FALSE.
                               endif
                            enddo
                         enddo
                      endif
                      !
                      !    Find angles and write to the bond file
                      ntorsion_s = torsion_start(imon)
                      ntorsion_e = torsion_start(imon+1)-1
                      if(ntorsion_s.le.ntorsion_e) then
                         do ip=ntorsion_s,ntorsion_e
                            things_to_do = .TRUE.
                            visited_this = 0
                            do while(things_to_do)
                               alt_code_previous = ' '
                               icount = 0
                               do ia=iat_s1,iat_e1
                                  alt_code_this = id_alt(ia)
                                  if(alt_code_this.eq.'.'.or.alt_code_this.eq.'?')alt_code_this = ' '
                                  iaa = ia-iat_s1+1
                                  if(visited_this(iaa).eq.0) then
                                     do k=1,4
                                        if(atm_name(ia).eq.torsion_atom(k,ip)) then
                                           if(alt_code_this.eq.' ') then
                                              icount = icount + 1
                                              ia_out(k) = ia
                                           else
                                              visited_this(iaa) = 1
                                              if(alt_code_previous.eq.' ') then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                                 alt_code_previous = alt_code_this
                                              elseif(alt_code_this.eq.alt_code_previous) then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                              endif
                                           endif
                                           exit
                                        endif
                                     enddo
                                  endif
                               enddo
                               if(icount.eq.3) then
                                  ntorsions_bp = ntorsions_bp + 1
                                  write(itorsion_file)'AddRests',ia_out(1:4),(is_symm(1:4,m),m=1,4),1,torsion_value(1:2,ibb),1,1,1
                                  if(alt_code_previous.eq.' ') then
                                     things_to_do=.FALSE.
                                  endif
                               else
                                  things_to_do=.FALSE.
                               endif
                            enddo
                         enddo
                      endif
                      !
                      !    Find angles and write to the bond file
                      nchiral_s = chiral_start(imon)
                      nchiral_e = chiral_start(imon+1)-1
                      if(nchiral_s.le.nchiral_e) then
                         do ip=nchiral_s,nchiral_e
                            things_to_do = .TRUE.
                            visited_this = 0
                            do while(things_to_do)
                               alt_code_previous = ' '
                               icount = 0
                               do ia=iat_s1,iat_e1
                                  alt_code_this = id_alt(ia)
                                  if(alt_code_this.eq.'.'.or.alt_code_this.eq.'?')alt_code_this = ' '
                                  iaa = ia-iat_s1+1
                                  if(visited_this(iaa).eq.0) then
                                     do k=1,4
                                        if(atm_name(ia).eq.chiral_atom(k,ip)) then
                                           if(alt_code_this.eq.' ') then
                                              icount = icount + 1
                                              ia_out(k) = ia
                                           else
                                              visited_this(iaa) = 1
                                              if(alt_code_previous.eq.' ') then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                                 alt_code_previous = alt_code_this
                                              elseif(alt_code_this.eq.alt_code_previous) then
                                                 icount = icount + 1
                                                 ia_out(k) = ia
                                              endif
                                           endif
                                           exit
                                        endif
                                     enddo
                                  endif
                               enddo
                               if(icount.eq.3) then
                                  nchirals_bp = nchirals_bp + 1
                                  write(ichiral_file)ia_out(1:4),(is_symm(1:4,m),m=1,4),chiral_value(1:2,ibb),0,1,1
                                  if(alt_code_previous.eq.' ') then
                                     things_to_do=.FALSE.
                                  endif
                               else
                                  things_to_do=.FALSE.
                               endif
                            enddo
                         enddo
                      endif
                      deallocate(visited_this)
                   endif
                endif
             enddo

          endif
       enddo
    
  end subroutine read_addrest_instructs

  !
  !   Read values from the libary
  !
  subroutine read_AddRest_size
    !  
    !   This routine read the sizes of basepair bonds, angles etc.
    
    integer ipass

    !
    !  There might be two files. One file is standard file and another one user supplied.
    !
    do ipass=1,2
       if(ipass.eq.2.and.len_trim(user_basepair_file).le.0) then 
          exit
       elseif(ipass.eq.2.and.len_trim(user_addrest_file).gt.0) then
          call open_form_file(iun_l,user_addrest_file,ierr_l)
       else
          call open_form_file(iun_l,file_addrest_dict,ierr_l)
       endif
       if(ierr_l.gt.0) then
          write(*,*)'Problem in opening basepair file'//trim(file_addrest_dict)
          stop
       endif
       nmons = 0
       ios = 0
       do while(ios.eq.0)
          key = ' '
          line_parse=' '
          read(iun_l,'(a)',iostat=ios)line_parse
          if(ios.ne.0) exit
          if(len_trim(line_parse).le.0) cycle
          
          call parser(key,line_parse,ibeg,iend,itype,fvalue,cvalue,idec,ntok,lend,lprint)
          call ccpupc(key)
          if(key.eq.'END') exit
          do  itk=2,ntok
             call ccpupc(cvalue(itk))
          enddo
          
          if(key.eq.'ADDR') then
             nmons = nmons + 1
          elseif(key.eq.'BOND') then
             nbond_mons = nbond_mons + 1
          elseif(key.eq.'ANGL') then
             nangle_mons = nangle_mons + 1
          elseif(key.eq.'CHIR') then
             nchiral_mons = nchiral_mons + 1
          elseif(key.eq.'TORS') then
             ntorsion_mons = ntorsion_mons + 1
          endif
       enddo
       close(iun_l)
    enddo
  end subroutine read_AddRest_size

  subroutine read_AddRest_values
    !
    !    Read information about additional restraints: bonds, angles etc. Instructions are general. 
    !    Although the idea is to restraint sugar puckers restraints for any residue can be added
    integer iun_l,ios
    
    integer ic,ipass
    
    character(len=4) :: atom_l(4)
    character mon1*8,mon2*8
    character c1*8
    real values(2)
    integer irefer(4)
    !
    !   Parser things
    nmons         = 0
    nbond_mons    = 0
    nangle_mons   = 0
    nchiral_mons  = 0
    ntorsion_mons = 0
    !
    !  There might be two files. One file is standard file and another one user supplied.
    !
    do ipass=1,2
       if(ipass.eq.2.and.len_trim(user_addrest_file).le.0) then 
          exit
       elseif(ipass.eq.2.and.len_trim(user_addrest_file).gt.0) then
          call open_form_file(iun_l,user_addrest_file,ierr_l)
       else
          if(len_trim(file_addrest_dict).le.0) cycle
          call open_form_file(iun_l,file_addrest_dict,ierr_l)
       endif
       
       if(ierr_l.gt.0) then
          write(*,*)'Problem in opening basepair file'//trim(file_addrest_dict)
          stop
       endif
       ios = 0
       do while(ios.eq.0)
          line_parse= ' '
          read(iun_l,'(a)',iostat=ios)line_parse
          if(ios.ne.0) exit
          if(len_trim(line_parse).le.0) cycle
          line_parse = adjustl(line_parse)
          key = ' '
          call parser(key,line_parse,ibeg,iend,itype,fvalue,cvalue,idec,ntok,lend,lprint)
          call ccpupc(key)
          do  itk=2,ntok
             call ccpupc(cvalue(itk))
          enddo
          ! 
          !   Instruction about monomers (residue) pairs. Resiude names and label for the pair
          if(key.eq.'ADDR') then
             nmons = nmons + 1
             bond_start(nmons) = nbond_pairs+1
             angle_start(nmons) = nangle_mons+1
             chiral_start(nmons) = nchiral_mons+1
             torsion_start(nmons) = ntorsion_mons+1
             itk=2
             if(ntok.lt.3) then
                write(*,*)'There is a problem in the basepair file'//trim(file_addrest_dict)
                write(*,*)trim(line_parse)
                write(*,*)'Monomer info is not complete. The correct syntax is:'
                write(*,*)'monomer <mon1> <mon2> [label <label>]'
                call errwrt(1,'Problem with the basepair file')
             endif
             res_group(nmons) = '.'
             res_mons(nmons) = '.'
             res_label(nmons) = '.'
             do while(itk.lt.ntok-1)
                if(cvalue(itk).eq.'MONO') then
                   itk = itk + 1
                   res_mons(nmons) = line_parse(ibeg(itk):iend(itk))
                   itk = itk + 1
                elseif(cvalue(itk).eq.'GROU') then
                   itk = itk + 1
                   res_group(nmons) = line_parse(ibeg(itk):iend(itk))
                   itk = itk + 1
                elseif(cvalue(itk).eq.'LABE') then
                   itk = itk + 1
                   res_label(nmons) = line_parse(ibeg(itk):iend(itk))
                endif
             enddo
             if(res_mons(nmons).eq.'.'.and.res_group(nmons).eq.'.') then
                write(*,*)'Problem with additional restraints. Neither monomer nor group is specified'
                write(*,*)trim(line_parse)
                write(*,*)'Syntax of the instructions is:'
                write(*,*)'addrestraint monomer <monomer> group <group> label <label>'
                call errwrt(1,'Problem with additional restraints file')
             endif
             if(res_label(nmons).eq.'.') then
                if(res_mons(nmons).ne.'.') then
                   res_label(nmons) = res_mons(nmons)
                else
                   res_label(nmons) = res_group(nmons)
                endif
             endif
          elseif(key.eq.'BOND') then
             atom_l = ' '
             values = -1
             ic = 0
             itk = 2
             do while(itk.lt.ntok)
                if(cvalue(itk).eq.'ATOM') then
                   itk = itk + 1
                   ic=ic+1
                   atom_l(ic) = line_parse(ibeg(itk):iend(itk))
                   itk = itk + 1
                elseif(cvalue(itk).eq.'VALU') then
                   itk = itk + 1
                   values(1) = fvalue(itk)
                   itk = itk + 1
                elseif(cvalue(itk).eq.'SIGM') then
                   itk = itk + 1
                   values(2) = fvalue(itk)
                   itk = itk + 1
                endif
             enddo
             if(any(atom_l(1:2).eq.' ').or.values(1).lt.0.0.or.values(2).lt.0.0) then
                write(*,*)'Problem in the bond file'//trim(file_adrest_dict)
                write(*,*)trim(line_parse)
                write(*,*)'Bond information is incorrect. The syntax is:'
                write(*,*)'bond atom <atname> <resname> atom <atname> <resname> value <value> sigma <sigma>'
             else
                nbond_mons = nbond_mons + 1
                bond_atoms(1:2,nbond_mons) = atom_l(1:2)
                bond_value(1:2,nbond_mons) = values(1:2)
             endif
          elseif(key.eq.'ANGL') then
             atom_l = ' '
             values = -1
             ic = 0
             itk = 2
             do while(itk.lt.ntok)
                if(cvalue(itk).eq.'ATOM') then
                   itk = itk + 1
                   ic=ic+1
                   atom_l(ic) = line_parse(ibeg(itk):iend(itk))
                   itk = itk + 1
                elseif(cvalue(itk).eq.'VALU') then
                   itk = itk + 1
                   values(1) = fvalue(itk)
                   itk = itk + 1
                elseif(cvalue(itk).eq.'SIGM') then
                   itk = itk + 1
                   values(2) = fvalue(itk)
                   itk = itk + 1
                endif
             enddo
             if(any(atom_l(1:3).eq.' ').or.values(1).lt.0.0.or.values(2).lt.0.0) then
                write(*,*)'Problem in the bond file'//trim(file_addrest_dict)
                write(*,*)trim(line_parse)
                write(*,*)'Angle information is incorrect. The syntax is:'
                write(*,*)'angle atom <atname>   atom <atname>   atom '//     &
                     '<atname>   value <value> sigma <sigma>'
             else
                nangle_mons = nangle_mons + 1
                angle_atoms(1:3,nangle_mons) = atom_l(1:3)
                angle_value(1:2,nangle_mons) = values(1:2)
             endif
          elseif(key.eq.'CHIR') then
             atom_l = ' '
             values = -100.0
             ic = 0
             itk = 2
             do while(itk.lt.ntok)
                if(cvalue(itk).eq.'ATOM') then
                   itk = itk + 1
                   ic=ic+1
                   atom_l(ic) = line_parse(ibeg(itk):iend(itk))
                   itk = itk  + 1
                elseif(cvalue(itk).eq.'VALU') then
                   itk = itk + 1
                   values(1) = fvalue(itk)
                   itk = itk + 1
                elseif(cvalue(itk).eq.'SIGM') then
                   itk = itk + 1
                   values(2) = fvalue(itk)
                   itk = itk + 1
                endif
             enddo
             if(any(atom_l(1:4).eq.' ').or.values(1).lt.-20.0.or.values(2).lt.0.0) then
                write(*,*)'Problem in the base pair'//trim(file_addrest_dict)
                write(*,*)trim(line_parse)
                write(*,*)'Chiral information is incorrect. The syntax is:'
                write(*,*)'chiral atom <atname> atom <atname> '//       &
                     'atom <atname> atom <atname> value <value> sigma <sigma>'
             else
                nchiral_mons = nchiral_mons + 1
                chiral_atoms(1:4,nchiral_mons) = atom_l(1:4)
                chiral_value(1:2,nchiral_mons) = values(1:2)
             endif
          elseif(key.eq.'TORS') then
             irefer = 0
             atom_l = ' '
             values = -1000.0
             ic = 0
             itk = 2
             do while(itk.lt.ntok)
                if(cvalue(itk).eq.'ATOM') then
                   itk = itk + 1
                   ic=ic+1
                   atom_l(ic) = line_parse(ibeg(itk):iend(itk))
                   itk = itk + 1
                elseif(cvalue(itk).eq.'VALU') then
                   itk = itk + 1
                   values(1) = fvalue(itk)
                   itk = itk + 1
                elseif(cvalue(itk).eq.'SIGM') then
                   itk = itk + 1
                   values(2) = fvalue(itk)
                   itk = itk + 1
                endif
             enddo
             if(any(atom_l(1:4).eq.' ').or.values(1).lt.-360.0.or.values(2).lt.0.0) then
                write(*,*)'Problem in the base pair'//trim(file_addrest_dict)
                write(*,*)trim(line_parse)
                write(*,*)'Torsion information is incorrect. The syntax is:'
                write(*,*)'torsion atom <atname>   atom <atname>   '//             &
                     'atom <atname>   atom <atname>   value <value> sigma <sigma>'
             else
                ntorsion_mons = ntorsion_mons + 1
                torsion_atoms(1:4,ntorsion_mons) = atom_l(1:4)
                torsion_value(1:2,ntorsion_mons) = values(1:2)
             endif
          endif
       enddo
       close(iun_l)
    enddo
    if(nmons.le.0) then
       write(*,*)
       write(*,*)
       write(*,*)'There is no basepair file.'
       call errwrt(1,'Problem with the base file(s)')
    endif
    !
    !   Add a dummy number that is one after the last mons
    !
    bond_start(nmons+1) = nbond_mons+1
    angle_start(nmons+1) = nangle_mons+1
    chiral_start(nmons+1) = nchiral_mons+1
    torsion_start(nmons+1) = ntorsion_mons+1


  end subroutine read_AddRest_values




  end subroutine sugar_pucker


end module AddRestraints
