      subroutine sort_out_messy_tls_adp
      implicit none
      include 'atom_com.fh'
      include 'tls.fh'
c
c--   Try and sort out TLS mess
      character coord_file_here*512
      integer in_file,ierr,lend_f
c
      character line*512
      logical is_phenix_w,is_phenix_p,is_pdb,tls_added,tls_added_iso
      logical is_refmac,is_shelx
      character tls_add*3
c
      integer, allocatable :: igroup_l(:)
c
      integer i,j,igrp,igrp1
      real biso,eps_l
      real uaniso_l(6),utls_aniso(6)
      character tls_select*10
c
c---  body
      eps_l = 0.1e-7
      tls_add = 'NO'
      ntlsgrp = 0
      is_phenix_w = .FALSE.
      is_phenix_p = .FALSE.
      is_refmac   = .FALSE.
      is_shelx    = .FALSE.
      is_pdb      = .FALSE.
c
c---  Open the file
      call getenv('XYZIN',coord_file_here)
      if(len_trim(coord_file_here).le.0) coord_file_here='XYZIN'
      call open_form_file(in_file,coord_file_here,ierr)
      if(ierr.ne.0) return
c
c---  If this file is not pdb there is no point of continuing
      read(in_file,'(a)',iostat=lend_f) line
      do while (lend_f.eq.0)
         if(line(1:4).eq.'CRYS'.or.line(1:4).eq.'REMA') then
c
c--   It is very likely to be a pdb file. It is not best way of sorting out
c---  pdb or not pdb but I do not know other ways
            is_pdb = .TRUE.
            goto 20
         endif
         read(in_file,'(a)',iostat=lend_f) line
      enddo
 20   continue
      if(.not.is_pdb) then
         close(in_file) 
         return
      endif
      rewind(in_file)
c
c---  Sort out cause of mess for TLS. Is it phenix or refmac
c---  have TLS been added to aniso U or to iso B values or to both
c---  Decide if it is phenix working format or pdb format (refmac or phenix)
      rewind(in_file)
      read(in_file,'(a)',iostat=lend_f) line
      is_pdb = .FALSE.
      do while (lend_f.eq.0.and.(line(1:4).ne.'ATOM'.or.
     &     line(1:4).ne.'HETA'))
         if(index(line,'REMARK PHENIX refinement').gt.0) then
            is_phenix_w = .TRUE.
            goto 120
         endif
         if(line(1:14).eq.'REMARK 3   PRO') then
            if(index(line,'PHENIX').gt.0) then
               is_phenix_p=.TRUE.
               goto 120
            else if(index(line,'REFMAC').gt.0) then
               is_refmac = .TRUE.
               goto 120
            else if(index(line,'SHELXL').gt.0) then
               is_shelx = .TRUE.
               goto 120
            endif
         endif
         read(in_file,'(a)',iostat=lend_f) line
      enddo
 120  continue
c
c--   If coordinates were not produced by phenix or refmac then
c---  there should not be mess in this part
      if(.not.is_refmac.and..not.is_phenix_w.and..not.is_phenix_p) 
     &     goto 999
c

      rewind(in_file)
      if(is_phenix_w.or.is_phenix_p) then
         tls_add = 'YES'
      else if(is_refmac) then
         read(in_file,'(a)',iostat=lend_f)line
         do while (lend_f.ge.0.and.(line(1:4).eq.'ATOM'.or.
     &        line(1:4).eq.'HETA'))
            if(index(line,
     &         'REMARK   3  U VALUES      : WITH TLS ADDED').gt.0) then
               tls_add = 'yes'
               goto 140
            endif
            if(index(line,
     &        'ATOM RECORD CONTAINS SUM OF TLS AND RESIDUAL B FACTORS')
     &           .gt.0) then
               tls_add = 'yes'
               goto 140
            endif
            read(in_file,'(a)',iostat=lend_f)line
         enddo
      endif
 140  continue
      if(tls_add(1:2).eq.'NO') goto 999

      rewind(in_file)
      igrp = 0
      read(in_file,'(a)',iostat=lend_f)line
      do while(lend_f.eq.0.and.(line(1:4).ne.'ATOM'.or.
     &     line(1:4).eq.'HETA'))
         if(is_phenix_w) then
            if(index(line,'TLS GROUP').gt.0) then
               ntlsgrp = ntlsgrp + 1
               read(line,'(25x,i5)')igrp1
               igrp = igrp + 1
               if(igrp.ne.igrp1) then
c
c--   problem
                  write(*,*)'Problem with tls group number'
                  goto 999
               endif
               read(in_file,'(a)')line
               if(line(26:29).ne.'None') then
                  tls_select = 'None'
               else
c
c---  There must be one tls group that includes all atoms
                  tls_select = 'Something'
               endif
               call read_tls_from_pdb(in_file,tlsorigin(1:3,igrp),
     &              tmat(1:6,igrp),lmat(1:6,igrp),smat(1:8,igrp),ierr)
            endif
         endif
         if(is_refmac.or.is_phenix_p) then
            if(index(line,'TLS DETAILS').gt.0) then
               read(in_file,'(a)') line
               if(index(line,'NUMBER OF TLS GROUPS').gt.0) then
                  read(line,'(37x,i5)')ntlsgrp
               else
                  ierr = 1
                  goto 999
               endif
               read(in_file,'(a)')line
               do i=1,ntlsgrp
                  read(in_file,'(a)')line
                  read(in_file,'(a)')line
                  read(in_file,'(33x,i4)')itlsgrp_pieces(i)
                  read(in_file,'(a)')line
                  do j=1,itlsgrp_pieces(i)
                     read(in_file,'(29x,3x,a4,i6,8x,a4,i6)')
     &                    tlsgrp_chn(j,i),
     &                    itlsgrp_from(j,i),tlsgrp_chn(j,i),
     &                    itlsgrp_to(j,i)
                  enddo
                  call read_tls_from_pdb(in_file,tlsorigin(1:3,igrp),
     &                 tmat(1:6,igrp),lmat(1:6,igrp),
     &                 smat(1:8,igrp),ierr)
               enddo
            endif
         endif
         read(in_file,'(a)',iostat=lend_f)line
      enddo
c
c---  Consider different cases
c
c--Assign groups
      allocate(igroup_l(n_atom))
      igroup_l(1:n_atom) = 0
      do i=1,n_atom
c
c--Group identification
         if(tls_select.eq.'None'.and.ntlsgrp.eq.1) then
            igroup_l(i) = 1
         else
            call identify_tls_group(i,igrp)
            if(igrp.gt.0.and.igrp.le.ntlsgrp) then
               igroup_l(i) = igrp
            endif
         endif
      enddo
c
c--   Try another way of defining groups. If uaniso - utls is isotropic then
c---  then this atom belongs to this tls group. Later.
c
      if(ntlsgrp.gt.0) then
         do i=1,n_atom
            igrp = igroup_l(i)
            if(igrp.gt.0) then
               call tls_contribution(xyz_crd(1:3,i),
     &              tlsorigin(1:3,igrp),tmat(1:6,igrp),
     &              lmat(1:6,igrp),smat(1:8,igrp),utls_aniso)
               uaniso_l(1:6) = u_aniso(1:6,i) - utls_aniso(1:6)
c     
c--   Now it must be isotropic if we have not refined aniso
               write(*,*)'us ',u_aniso(1:6,i),utls_aniso(1:6)
               write(*,*)'xs ',xyz_crd(1:3,i),tlsorigin(1:3,igrp)
               biso = sum(uaniso_l(1:3))/3.0
               if(sum((biso-uaniso_l(1:3))**2).gt.eps_l) then
c     
c--   problem
               endif
               write(*,*)biso,uaniso_l(1:3)
               u_aniso(1,i) = biso
               u_aniso(2:6,i) = 0.0
               stop
            endif
         enddo
      endif
c
 999  continue
      close(in_file)
      stop
      return
      end
c
      subroutine read_tls_from_pdb(in_file,tlsorigin,tmat,lmat,smat,
     &     ierr)
      implicit none
      integer in_file,ierr
      real tlsorigin(3)
      real tmat(6),lmat(6),smat(8)
c
      real s_tens(3,3)
      real pi,radtodeg,rtd2
      character line*512

c
      pi = 4.0*atan2(1.0,1.0)
      radtodeg = 180/pi
      rtd2 = radtodeg**2
c
c
      if(in_file.le.0) then
         ierr = 1
         return
      endif
c
      read(in_file,'(a)')line
      read(line,'(39x,3f9.4)')tlsorigin(1:3)
      read(in_file,'(a)')line
      read(in_file,'(16x,2(5x,f9.4))')tmat(1:2)
      read(in_file,'(16x,2(5x,f9.4))')tmat(3:4)
      read(in_file,'(16x,2(5x,f9.4))')tmat(5:6)
      read(in_file,'(a)')line
      read(in_file,'(16x,2(5x,f9.4))')lmat(1:2)
      read(in_file,'(16x,2(5x,f9.4))')lmat(3:4)
      read(in_file,'(16x,2(5x,f9.4))')lmat(5:6)
      lmat(1:6) = lmat(1:6)/rtd2
      read(in_file,'(a)')line
      read(in_file,'(16x,3(5x,f9.4))')s_tens(1,1:3)
      read(in_file,'(16x,3(5x,f9.4))')s_tens(2,1:3)
      read(in_file,'(16x,3(5x,f9.4))')s_tens(3,1:3)
      s_tens = s_tens/radtodeg
      smat(3) = s_tens(1,2)
      smat(4) = s_tens(1,3)
      smat(5) = s_tens(2,3)
      smat(6) = s_tens(2,1)
      smat(7) = s_tens(3,1)
      smat(8) = s_tens(3,2)
      smat(1) = s_tens(1,1)-s_tens(2,2)
      smat(2) = s_tens(2,2)-s_tens(3,3)

      return
      end
c
      subroutine process_strange_pdb_r(im)
      use refi_flags
      implicit none
      integer im
      include 'atom_com.fh'
      include 'models.fh'
C
c---Process strange pdb files
C
C---if coordinates are 9999.00 then put occupancies to 0
C---if B values are 0 then change them to some small value
C---if cell parameters are equa to 1 then change them to accomodate
C---the molecule
C
      integer ia

      do ia =1,N_ATOM_mod(im)
        if(abs(xyz_crd_mod(1,ia,im)).gt.9998.0.or.
     &     abs(xyz_crd_mod(2,ia,im)).gt.9998.0.or.
     &     abs(xyz_crd_mod(2,ia,im)).gt.9998.0) then
           if (im.eq.1) occup(ia) = 0.0
           occup_mod(ia,im) = 0.0
        endif
        if(u_aniso_mod(2,ia,im).le.0.0) then
          if(u_aniso_mod(1,ia,im).le.0.0.and.im.eq.1) 
     &      u_aniso(1,ia) = BResetMin
          if(u_aniso_mod(1,ia,im).le.0.0) u_aniso_mod(1,ia,im)=BResetMin
        else
          if ( u_aniso_mod(1,ia,im)+u_aniso_mod(2,ia,im)+
     &         u_aniso_mod(3,ia,im).le.0.0 ) then
             if (im.eq.1) then
               u_aniso(1,ia) = BResetMin
               u_aniso(2,ia) = BResetMin
               u_aniso(3,ia) = BResetMin
               u_aniso(4,ia) = 0.0
               u_aniso(5,ia) = 0.0
               u_aniso(6,ia) = 0.0
             endif
             u_aniso_mod(1,ia,im) = BResetMin
             u_aniso_mod(2,ia,im) = BResetMin
             u_aniso_mod(3,ia,im) = BResetMin
             u_aniso_mod(4,ia,im) = 0.0
             u_aniso_mod(5,ia,im) = 0.0
             u_aniso_mod(6,ia,im) = 0.0
          endif
        endif
      enddo

      return
      end
c
      subroutine identify_tls_group(ia,igrp)
      implicit none
      include 'atom_com.fh'
      include 'tls.fh'
c
      integer ia,igrp
c
      integer i,j,k,im,ip,ipiece
      integer jres
      character chnnmp*4
      
      igrp = 0
      im = 1
      call get_chain_namepdb(chnnmp,i_resid(ia))
      read(res_num_pdb(i_resid(ia))(3:6),*)jres

      do j=1,ntlsgrp
         if(itlsgrp_pieces(j).gt.0) then
            ipiece = itlsgrp_pieces(j)
            do ip=1,ipiece
               if(chnnmp.eq.tlsgrp_chn(ip,j).and.
     &              jres.ge.itlsgrp_from(ip,j).and.
     &              jres.le.itlsgrp_to(ip,j)) then
                  igrp = j
               endif
            enddo
         else
            igrp = 1
         endif
      enddo

      return
      end
c

