# Python script
#
# written by P.Emsley. 2004
#
# get a list of files,
# for each file,
#   for each line in a file,
#      pass through a filter (does the line start with a "<")
#   write filtered list to new filename and then move that file
#   to the origin filename

import os
import glob

#cif_files  = glob.glob('*.cif')
cif_files  = glob.glob('*/*.cif')

# A trivial function to determine if this string was an HTML line that
# needs to be stripped (works OK for all refmac dictionary files that I
# have seen).
#
def is_html(file_string):
    if (file_string[0] == '<'):
        return 0
    return 1


# Given a filename, we return a list of filtered strings
def filtered_strings(filename): 
    f = open(filename, 'r')
    return filter(is_html, f.readlines())

# filtered_strings("ALA.cif")


for file in cif_files:
    print "fixing", file
    new_filename = file + ".new"
    fw = open(new_filename, 'w')
    for str in filtered_strings(file):
        fw.write(str)
    fw.close()
    # print "rename", new_filename, file
    os.rename(new_filename, file) 
