C -I-
      SUBROUTINE MODCHECK(MDOC,NAMEC,NAMER,NAMEV,NAMEO,NAMEP,SLIM
     * ,HFLAG,SEG_FLAG
     * ,PROG_LIB_PATH,LIBS_PATH,LIBS_NAME,LIBS_EXT,PROG_NAME,IERR)
C ----------------------------------------------------------
C
C                   ---  MODCHECK ---
C                                             /Vers 1.1 14.02.97/
C
C     MODCHECK - reads CIFiles of coordinates,restraints and VDW_restraints,
C                gives information about restraints (to DOC_file),
C                writes PDB_file or/and CIFile of coordinates.
C
C       It is possible to use subroutine MAKECIF instead of program.
C       Use all subroutines without "main_modcheck.f" which just
C       prepares parameters for subroutine "modcheck".
C
C       SUBROUTINE MODCHECK(MDOC,NAMEC,NAMER,NAMEV,NAMEO,SLIM,IERR)
C 
C  input parameters:
C
C     MDOC /integer*4/ -  =  999  with  DOC-file: "modcheck.doc",  
C                      if = -999  without this file.
C                              
C     NAMEC /character*80/ - name of input file of coordinates
C
C     NAMER /character*80/ - name of input file of restraints
C
C     NAMEC /character*80/ - name of input file of VDW_restraints 
C
C     NAMEO /character*80/ - name of output CIFile of coordinates
C                            if NAMEO = ' ' without this file.
C
C     NAMEP /character*80/ - name of output PDB_file of coordinates
C                            if NAMEP = ' ' without this file.
C
C     SLIM  /real*4 / - level of messages. if abs(Videal-Vobs)/SIG > SLIM ,
C                   the infomation about restraints will be written to DOC_file.
C
C  output:
C
C     IERR /integer*4/ - signal of error, = 0 means OK.
C
C ---------------------------------------------------------------------
C   Create directories:   blanc/make
C                         blanc/dic
C                         blanc/exe
C
C   For compilation you need to have 9 files in the same directory blanc/make:
C
C      atom_com.fh - include file with control memory parameters
C      rstr_com.fh - include file of restraints
C      crd_com.fh  - include file with description common blocks /CR.. /
C      
C      main_modcheck.f   - main program.
C      modcheck.f   - subroutines
C      mod_subr.f   -  ...
C      make_subr.f  -  ...
C      makefile
C
C   Compilation's command for UNIX:
C                             make makecif
C                 programs would be in blanc/exe
C 
C    Program uses the file:  blanc/dic/symlib.blc
C    
C    don't foget set command: "setenv BLANC <path_to_blanc_dir>"
C 
C -S-
C ----------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   NAMEC*(*),NAMEO*(*),NAMEP*(*)
      CHARACTER   NAMER*(*),NAMEV*(*)
      REAL        SLIM
C ----------------------------------------------------------------
      CHARACTER LINE*256,PATH*80,EXT*80,HFLAG*1,DEPOS*1
      CHARACTER SEG_FLAG*1
      CHARACTER PROG_LIB_PATH*80,PROG_NAME*80 
      CHARACTER LIBS_PATH*(*),LIBS_NAME*(*),LIBS_EXT*(*)
      INTEGER*4 NOSPGR_INPUT
      REAL      CELL_INPUT(6)
C     CHARACTER PROG*80
C==================================================================
      INCLUDE 'crd_com.fh'
C ---
      INCLUDE 'modcheck_version.fh'
C -----------------------------------------------
      IERR = 0
      NOSPGR_INPUT = 0
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO
C     PROG = 'modcheck'
C -----------------------------
      CALL SET_PATH_PROG_PARM(PROG_LIB_PATH,PROG_NAME
     *                         ,LIBS_PATH,LIBS_NAME,LIBS_EXT)
C ------------------------------
C ------------------------------
      IF(ABS(MDOC).GE.997) THEN
        MDOC_C=1
        IF(MDOC.LT.0) THEN
          MDOC=0
        ELSE      
C   
C         MDOC=999
C         IF(MSG.EQ.'Y') MDOC=999 do not keep old contents
C         IF(MSG.EQ.'A') MDOC=998 keep old contents
C         IF(MSG.EQ.'#') MDOC=997 batch mode, "_DOC " will be read
C          
C         for subroutine case:
C
C         MDOC=999 do not keep old contents
C         MDOC=998 keep old contents
C
C         MDOC=-999 without DOC-file
C
        ENDIF
        IG = 0
        CALL START(IG,MDOC,PROG_NAME)
      ELSE
        MDOC_C=0
      ENDIF
C ---------------------------
      IF(MDOC.GT.0) THEN
        M=-1
        CALL MSGDOC(M,' ')
        CALL MSGDOC(M,VERSION)
        CALL MSGDOC(M,' ')
      ENDIF
      CALL CLOSE_BATCH(M)
C --------------------------
      MD  = -ABS(MDOC)-1
      M   = 99
C ---
      IF(SLIM.LE.0.0) SLIM = -0.01  
C --------
      EXT  = ' '
      PATH = ' '
      CALL MSGDOC(MDOC,' --- read CRD_file  ---')
      IERR = 0
      CALL READ_ATOMS(MDOC,PATH,NAMEC,EXT
     *               ,NOSPGR_INPUT,CELL_INPUT,IERR)
      IF(IERR.GE.7) IERR = 0
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /crd/ .')
        GO TO 100
      ENDIF
C --------
      CALL LENSTR_BL(NAMER,LEN)
      IF(LEN.GT.0.AND.NAMER(1:1).NE.','.AND.NAMER(1:1).NE.' ') THEN 
        CALL MSGDOC(MDOC,' --- read RST_file / VDW_file  ---')
        EXT  = ' '
        PATH = ' '
        CALL READ_RESTR(MDOC,PATH,NAMER,NAMEV,EXT,SLIM,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /rst/ .')
          GO TO 100
        ENDIF
      ENDIF
C -----------------------------------
      CALL LENSTR_BL(NAMEO,LEN)
      IF(LEN.GT.0.AND.NAMEO(1:1).NE.','.AND.NAMEO(1:1).NE.' ') THEN 
        CALL MSGDOC(MDOC,' --- write CRD_file ---')
C       IOUT=11
        IOUT = CRO_IUN
        PATH = ' '
        EXT  = ' '
        CALL OPENFW(IOUT,M,PATH,NAMEO,EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: OPEN OUTPUT_FILE /crd/ .')
          GO TO 100
        ENDIF
        CLOSE(IOUT) 
C ---
        CALL WRITE_ATOMS(MDOC,PATH,NAMEO,EXT,IERR)
        IF(IERR.NE.0) THEN
          GO TO 100
        ENDIF
C ---
      ENDIF
C -----------------------------------
      CALL LENSTR_BL(NAMEP,LEN)
      IF(LEN.GT.0.AND.NAMEP(1:1).NE.','.AND.NAMEP(1:1).NE.' ') THEN 
        CALL MSGDOC(MDOC,' --- write PDB_file ---')
C       IOUT=11
        IOUT = CRO_IUN
        PATH = ' '
        EXT  = ' '
        CALL OPENFW(IOUT,M,PATH,NAMEP,EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: OPEN OUTPUT_FILE /pdb/ .')
          GO TO 100
        ENDIF
        CLOSE(IOUT) 
C ---
        IF(HFLAG.EQ.'y') HFLAG = 'Y'
        IF(HFLAG.NE.'Y') HFLAG = 'N'
        IF(SEG_FLAG.EQ.'y') SEG_FLAG = 'Y' 
        IF(SEG_FLAG.NE.'Y') SEG_FLAG = 'N'
        DEPOS = 'N'
        CALL WRITE_ATOMS_PDB(MDOC,HFLAG,DEPOS,SEG_FLAG
     *                         ,PATH,NAMEP,EXT,IERR)
        IF(IERR.NE.0) THEN
          GO TO 100
        ENDIF
C ---
      ENDIF
C --------------------------------------
 100  CONTINUE
      IF(MDOC_C.EQ.1) CALL FINISH
      RETURN
      END

C -I-
      SUBROUTINE READ_RESTR(MDOC,PATH,NAMEC,NAMEV,EXT,SLIM,IERR)
C ----------------------------------------------------------
C -P- READ_RESTR - 
C
C    MDOC   - mode of writting messages to DOC-file
C             0 - only terminal , < - 0 only file, 0 < < 99 - both
C             >= 99 - don't write  
C    NAMEC  - name of input file without extention.
C    IERR   - output signal of error / = 1 -error , = 0 - OK / 
C -I-
C ----------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C --------------
      INTEGER     MDOC,IERR
      CHARACTER   NAMEC*(*),NAMEV*(*),LINE*80,EXT*(*),PATH*(*)
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
      REAL        SLIM
      REAL        RMS_B
      INTEGER     NB_GT_1S,NB_GT_3S,NB_GT_10S
      REAL        RMS_A
      INTEGER     NA_GT_1S,NA_GT_3S,NA_GT_10S
      REAL        RMS_T
      INTEGER     NT_GT_1S,NT_GT_3S,NT_GT_10S
      REAL        RMS_C
      INTEGER     NC_GT_1S,NC_GT_3S,NC_GT_10S
      REAL        RMS_P
      INTEGER     NP_GT_1S,NP_GT_3S,NP_GT_10S
      CHARACTER   C_LINE*256
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      IFLAG  = 0
      C_LINE = ' '
C --------
      NB_GT_1S  = 0
      NB_GT_3S  = 0
      NB_GT_10S = 0
      RMS_B     = 0.0
C --------
      NA_GT_1S  = 0
      NA_GT_3S  = 0
      NA_GT_10S = 0
      RMS_A     = 0.0
C --------
      NT_GT_1S  = 0
      NT_GT_3S  = 0
      NT_GT_10S = 0
      RMS_T     = 0.0
C --------
      NC_GT_1S  = 0
      NC_GT_3S  = 0
      NC_GT_10S = 0
      RMS_C     = 0.0
C --------
      NP_GT_1S  = 0
      NP_GT_3S  = 0
      NP_GT_10S = 0
      RMS_P     = 0.0
C --------
C     IN   = 10
      IN   = CRR_IUN
      EXT  = ' '
      PATH = ' '
      CALL ORRST_CIF(MD,IN,PATH,NAMEC,EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE /rst/')
        RETURN
      ENDIF
C --------
      RS_NATOM    = 0
      RS_NBOND    = 0
      RS_NBNDS    = 0
      RS_NANGL    = 0
      RS_NTORS    = 0
      RS_NCHIR    = 0
      RS_NPLAN    = 0
      RS_NUM_OLD  = -1
      IEND        = -1
C --------------------------------
 200  CONTINUE
      CALL RDRST_CIF(M,IN,MODE,IEND,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /rst/')
        RETURN
      ENDIF
      IF(IEND.NE.0) GO TO 300
  
      IF(MODE.EQ.0) THEN

        IA1 = RS_IA1
        IA2 = RS_IA2
        IA3 = RS_IA3
        IA4 = RS_IA4
        IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '     '
          RES1   = '   '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LE.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '     '
          RES2   = '   '
        ENDIF        
        IF(IA3.GT.0.AND.IA3.LE.N_ATOM) THEN
          IR     = I_RESID (IA3 ) 
          ICH    = I_CHAIN (IR) 
          CH3    = GROUP_ID(ICH)(1:1)
          ATOM3  = ATM_NAME(IA3)
          ALT3   = ID_ALT (IA3)
          IRES3  = RES_NUM_PDB(IR)(3:6)
          RES3   = RES_NAME(IR)
        ELSE
          CH3    = ' '
          ATOM3  = '    '
          ALT3   = ' '
          IRES3  = '     '
          RES3   = '   '
        ENDIF        
        IF(IA4.GT.0.AND.IA4.LT.N_ATOM) THEN
          IR     = I_RESID (IA4 ) 
          ICH    = I_CHAIN (IR) 
          CH4    = GROUP_ID(ICH)(1:1)
          ATOM4  = ATM_NAME(IA4)
          ALT4   = ID_ALT (IA4)
          IRES4  = RES_NUM_PDB(IR)(3:6)
          RES4   = RES_NAME(IR)
        ELSE
          CH4    = ' '
          ATOM4  = '    '
          ALT4   = ' '
          IRES4  = '     '
          RES4   = '   '
        ENDIF        
        IF(RS_NAME.EQ.'BOND') THEN

          RS_NBOND=RS_NBOND+1

          CALL CHECK_BOND(MDOC,RS_NAME,RS_NBOND,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,RS_VIDL,RS_SDI,RS_VOBS
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)

        ELSE IF(RS_NAME.EQ.'ANGL') THEN

          RS_NANGL=RS_NANGL+1

          CALL CHECK_ANGLE(MDOC,RS_NAME,RS_NANGL,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *     ,RS_VIDL,RS_SDI,RS_VOBS
     *     ,RMS_A,NA_GT_1S,NA_GT_3S,NA_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)

        ELSE IF(RS_NAME.EQ.'TORS') THEN

          RS_NTORS=RS_NTORS+1

          CALL CHECK_TORS(MDOC,RS_NAME,RS_NTORS,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD
     *     ,RMS_T,NT_GT_1S,NT_GT_3S,NT_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)

        ELSE IF(RS_NAME.EQ.'CHIR') THEN

          RS_NCHIR=RS_NCHIR+1

          CALL CHECK_CHIR(MDOC,RS_NAME,RS_NCHIR,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS
     *     ,RMS_C,NC_GT_1S,NC_GT_3S,NC_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)

        ELSE IF(RS_NAME.EQ.'PLAN') THEN

          IF(RS_NUM_OLD.NE.RS_NUM) THEN
            RS_NPLAN=RS_NPLAN+1
          ENDIF

          CALL CHECK_PLAN(MDOC,RS_NAME,RS_NPLAN,RS_LABEL
     *     ,ATOM1,ALT1,RS_VIDL,RS_VOBS
     *     ,RMS_P,NP_GT_1S,NP_GT_3S,NP_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)

        ENDIF

        RS_NUM_OLD = RS_NUM

      ELSE

C       CR_LINE - string of comments 
c        IF(IFLAG.GT.0) THEN
c          CALL MSGDOC(MD,C_LINE)
c        ENDIF
        C_LINE = CR_LINE
        IFLAG  = 0

      ENDIF      
C ----
      GO TO 200
C --------------------------------------
 300  CONTINUE
C------------------------------ --------
      RSV_NVDW    = 0
      RSV_NHB     = 0
      CALL LENSTR_BL(NAMEV,LEN)
      IF(LEN.LE.0.OR.NAMEV(1:1).EQ.','.OR.NAMEV(1:1).EQ.' ') GO TO 500
C     IN   = 10
      IN   = CRV_IUN
      EXT  = ' '
      PATH = ' '
      CALL ORVDW_CIF(MD,IN,PATH,NAMEV,EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE /vdw/')
        RETURN
      ENDIF
C --------
      RSV_NUM_OLD = -1
      IEND        = -1
      NVDW_GT_1S  = 0
      NVDW_GT_3S  = 0
      NVDW_GT_10S = 0
      RMS_VDW     = 0.0
      NHB_GT_1S   = 0
      NHB_GT_3S   = 0
      NHB_GT_10S  = 0
      RMS_HB      = 0.0
C --------------------------------
 400  CONTINUE
      CALL RDVDW_CIF(M,IN,MODE,IEND,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /vdw/')
        RETURN
      ENDIF
      IF(IEND.NE.0) GO TO 500
  
      IF(MODE.EQ.0) THEN
        IA1 = RSV_IA1
        IA2 = RSV_IA2
        IF(IA1.GT.0.AND.IA1.LT.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '     '
          RES1   = '   '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LT.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '     '
          RES2   = '   '
        ENDIF        
        IF(RSV_NAME.EQ.'VDW ') THEN

          RSV_NVDW = RSV_NVDW+1

          CALL CHECK_VDW(MDOC,RSV_NAME,RSV_NVDW,RSV_SYMM
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)

        ELSE IF(RSV_NAME.EQ.'HB  ') THEN

          RSV_NHB = RSV_NHB+1

          CALL CHECK_HB(MDOC,RSV_NAME,RSV_NHB,RSV_SYMM
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)

        ENDIF

        RSV_NUM_OLD = RSV_NUM

      ELSE

C       CR_LINE - string of comments 
c        IF(IFLAG.GT.0) THEN
c          CALL MSGDOC(MD,C_LINE)
c        ENDIF
        C_LINE = CR_LINE
        IFLAG  = 0

      ENDIF      
C ----
      GO TO 400
C --------------------------------------
 500  CONTINUE
C ---
      CALL MSGDOC(MDOC,'----- ')
      WRITE(LINE,'('' Number of bond restraints    :'',I12)') 
     * RS_NBOND
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     * NB_GT_1S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     * NB_GT_3S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     * NB_GT_10S
      CALL MSGDOC(MDOC,LINE)
      IF(RS_NBOND.GT.0) THEN
        RMS_B=SQRT(RMS_B/RS_NBOND)
        WRITE(LINE,'(''           rms                :'',F12.4)') 
     *  RMS_B
        CALL MSGDOC(MDOC,LINE)
      ENDIF
C ---
      CALL MSGDOC(MDOC,'----- ')
      WRITE(LINE,'('' Number of angle restraints   :'',I8)') 
     * RS_NANGL
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     * NA_GT_1S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     * NA_GT_3S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     * NA_GT_10S
      CALL MSGDOC(MDOC,LINE)
      IF(RS_NANGL.GT.0) THEN
        RMS_A=SQRT(RMS_A/RS_NANGL)
        WRITE(LINE,'(''           rms                :'',F12.4)') 
     *  RMS_A
        CALL MSGDOC(MDOC,LINE)
      ENDIF
C ---
      CALL MSGDOC(MDOC,'----- ')
      WRITE(LINE,'('' Number of torsion restraints :'',I8)') 
     * RS_NTORS
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     * NT_GT_1S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     * NT_GT_3S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     * NT_GT_10S
      CALL MSGDOC(MDOC,LINE)
      IF(RS_NTORS.GT.0) THEN
        RMS_T=SQRT(RMS_T/RS_NTORS)
        WRITE(LINE,'(''           rms                :'',F12.4)') 
     *  RMS_T
        CALL MSGDOC(MDOC,LINE)
      ENDIF
C ---
      CALL MSGDOC(MDOC,'----- ')
      WRITE(LINE,'('' Number of chiralities         :'',I8)') 
     * RS_NCHIR
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     * NC_GT_1S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     * NC_GT_3S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     * NC_GT_10S
      CALL MSGDOC(MDOC,LINE)
      IF(RS_NCHIR.GT.0) THEN
        RMS_C=SQRT(RMS_C/RS_NCHIR)
        WRITE(LINE,'(''           rms                :'',F12.4)') 
     *  RMS_C
        CALL MSGDOC(MDOC,LINE)
      ENDIF
C ---
      CALL MSGDOC(MDOC,'----- ')
      WRITE(LINE,'('' Number of planar groups       :'',I8)') 
     * RS_NPLAN
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     * NP_GT_1S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     * NP_GT_3S
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     * NP_GT_10S
      CALL MSGDOC(MDOC,LINE)
      IF(RS_NPLAN.GT.0) THEN
        RMS_P=SQRT(RMS_P/RS_NPLAN)
        WRITE(LINE,'(''           rms                :'',F12.4)') 
     *  RMS_P
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      IF(RSV_NVDW.GT.0) THEN
        CALL MSGDOC(MDOC,'----- ')
        WRITE(LINE,'('' Number of VDW_contacts        :'',I8)') 
     *   RSV_NVDW
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *   NVDW_GT_1S
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *  NVDW_GT_3S
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NVDW_GT_10S
        CALL MSGDOC(MDOC,LINE)
        IF(RSV_NVDW.GT.0) THEN
          RMS_VDW=SQRT(RMS_VDW/RSV_NVDW)
          WRITE(LINE,'(''           rms                :'',F12.4)') 
     *    RMS_VDW
          CALL MSGDOC(MDOC,LINE)
        ENDIF
      ENDIF
      IF(RSV_NHB.GT.0) THEN
        WRITE(LINE,'('' Number of H_bonds             :'',I8)') 
     *  RSV_NHB
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *  NHB_GT_1S
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *  NHB_GT_3S
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NHB_GT_10S
        CALL MSGDOC(MDOC,LINE)
        IF(RSV_NHB.GT.0) THEN
          RMS_HB=SQRT(RMS_HB/RSV_NHB)
          WRITE(LINE,'(''           rms                :'',F12.4)') 
     *    RMS_HB
          CALL MSGDOC(MDOC,LINE)
        ENDIF
      ENDIF
C ---
      CALL MSGDOC(MDOC,'----- ')
C --------------------------------------
      RETURN
      END
