#include "llhood.h"
#include "covmat.h"
#include "Gauss.h"
#include "machine_.h"
#include <fstream>
#include <iomanip>
#include <math.h>
#include <string>


typedef double Type;

typedef float freal;

likelihood<Type> lF1,lF2,lF3,lF4;
likelihood<Type> lD1,lD2,lD3,lD4; 

using namespace std;

const Type maxa = 500.;

void strncpybc( char* str_out, char* str_in, int num )
{
  int i = -1;
  while ( i++ < num )
  {
	if ( str_in[i] == ' ' || str_in[i] == '\0' )
	{
	  for (int j=i; j<num; j++ ) str_out[j] = '\0';
	  i=num;
	}
	else str_out[i] = str_in[i];
  }
  str_out[num] = '\0';
}


//extern "C" void return_mat_dim_( int* dim )
FORTRAN_SUBR ( RETURN_MAT_DIM, return_mat_dim,    
	(int* dim), (int* dim), (int* dim) )
{
  *dim = lF1.Num;
}

//extern "C" void return_dnum_( int* Dnum )
FORTRAN_SUBR ( RETURN_DNUM, return_dnum, 
	(int* Dnum), (int* Dnum), (int* Dnum) )
{
  *Dnum = lF1.cov->N_part;
}


//extern "C" void activatellhood_( char* PPI, int& der2der1, int& derD2der1, 
//  int& der2heavyder1, int& substruct_flag, freal* expf_arr, freal* trigf_arr, int& nmodel )
FORTRAN_SUBR ( ACTIVATELLHOOD, activatellhood,
	( char* PPI_in, int* der2der1, int* derD2der1, 
	  int* der2heavyder1, int* substruct_flag, int* empty1, int* nmodel, int PPI_len ),
	( char* PPI_in, int* der2der1, int* derD2der1, 
	  int* der2heavyder1, int* substruct_flag, int* empty1, int* nmodel, int PPI_len ),
	( char* PPI_in,  int* der2der1, int* derD2der1, 
	  int* der2heavyder1, int* substruct_flag, int* empty1, int* nmodel, int PPI_len ) )
{
  char PPI_wrk[7];
  strncpybc(PPI_wrk,FTN_STR(PPI_in),4);
  string PPI;
  PPI.reserve(7);
  PPI.assign(PPI_wrk);

  if (*derD2der1) *derD2der1=1;   
  if (*der2heavyder1) *der2heavyder1=1;
  if (*der2der1) *der2der1=1;
//  cout << "*" << PPI << "*"<< PPI_in <<  "*" << endl;
//  cout << " heavyflags:  " << *der2heavyder1 <<  "  " << *der2der1 << " " << 2 - (*der2heavyder1+*der2der1)/2 << endl;
  int Num = 4;
  int N_meas = 2;
  int N_part = 2;
  if ( PPI == "sadh" ) { N_part = 4; /*if (*substruct_flag)  N_part = 3;*/ }
  if ( PPI == "sras" ) { N_meas =3; }
  if ( PPI == "mad" ) { Num = 8;   N_meas =4; }
  if ( PPI == "mldr" ) Num = 3;
  if ( PPI == "p+l" ) { Num = 2+*nmodel;  /*N_part=2**nmodel;*/ N_part=2+*nmodel; }
  int NGauss_D = 25, NGauss_F = 25;
  int NGauss_D_2 = 1, NGauss_F_2 = 1;
  if ( PPI == "sras" ) {
	NGauss_D = 100; NGauss_D_2 = 1000;   NGauss_F = 100;  NGauss_F_2 = 1000; 
	if (!*substruct_flag||!*empty1) 	{ PPI="sras4d"; N_part = 5; Num=6;}
	else 								{ PPI="srasph"; N_part = 4; Num=5;}
  }
  if ( PPI == "sir" ) {
//!!!	if (!*substruct_flag||!*empty1) 	{ N_part = 3; PPI="sir"; }
	if (!*substruct_flag||!*empty1) 	{ N_part = 5; PPI="sirh"; }
	else 								{ PPI="sirph"; N_part = 3; Num=3; }
  }
//!!!!! this is only temporary
  if ( PPI == "mad" ) { /*PPI[0]='s';*/ NGauss_D = 10; NGauss_D_2 = 10;   NGauss_F = 10;  NGauss_F_2 = 10; }
  likelihood<Type> aux( N_meas, Num, 2 - ((*der2heavyder1)+(*der2der1))/2, 0, PPI, N_part, NGauss_F, NGauss_F_2, 1 );
//  likelihood<Type> aux( N_meas, Num, 2 - ((int)der2heavyder1+(int)der2der1)/2, 1, (string) PPI_in, N_part, NGauss_F, NGauss_F_2, 1 );
  lF1 = aux;
  lF1.SetImproveInteg(0);
  if ( PPI == "sras" || PPI == "sras3d" || PPI == "sras4d" || PPI == "srasph" )  
    lF1.SetImproveInteg(4);
  lF2 = lF1;
  lF3 = lF1;
  lF4 = lF1;

//using Gauss_struct from aux to save some time - only possible when NGauss_D<=NGauss_F
//!!!!!!!!!!!!!!!!!!  likelihood<Type> aux2( N_meas, Num, 0, 2-(*derD2der1), PPI, N_part, NGauss_D, NGauss_D_2, 1, 1, lF1.Gauss_struct );
  likelihood<Type> aux2( N_meas, Num, 2, 2-(*derD2der1), PPI, N_part, NGauss_D, NGauss_D_2, 1, 1, lF1.Gauss_struct );
//  likelihood<Type> aux2( N_meas, Num, 2 - ((int)der2heavyder1+(int)der2der1)/2, 2-(int)derD2der1, (string) PPI_in, N_part, NGauss_D, NGauss_D_2, 1, 1 );
  lD1 = aux2;
  lD1.SetImproveInteg(0);
  if ( PPI == "sras" || PPI == "sras3d" || PPI == "sras4d" || PPI == "srasph" ) 
    lD1.SetImproveInteg(4); //lD1.SetImproveInteg(4);
  lD2 = lD1;
  lD3 = lD1;
  lD4 = lD1;
}



// ***************SAD(H) PART******************

inline void sad_input_llhood( likelihood<Type>* l, int& ICENT, freal& SIGN, freal* SIGMA_N, freal* SIGMA_P, freal& SIGP, freal* SIGP2, 
  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& YO, freal& YOP, freal& YOM, freal& A, freal& B, freal& App, freal& Bpp,
  freal* D_PAR, freal& sigi, freal& sigp12, Type* F, Type* ph )
{
  int rice = 0;
  if ( YOP <= 0. || YOM <= 0. || SIGOP <= 0. || SIGOM <= 0. || 
    SIGMA_N[0] <= 0. || SIGMA_P[0] <= 0. || SIGMA_N[1] <= 0. || SIGMA_P[1] <= 0. ) rice = 1;
  l->SetCentRice(ICENT,rice);
//  l->SetCentRice(0,rice);
  l->cov->no_imag = 1;
  if (!l->Rice)
  {
	l->cov->sigma_N[0] = SIGMA_N[0];
	l->cov->sigma_N[1] = complex<Type> ( SIGMA_N[1], sigi ) ;
//SIGP2P=SIGP2P-2.5*(SIGP2[1]-SIGP2P);
//	l->cov->sigma_N[1] = complex<Type> ( SIGN2P-(SIGP2[1]-SIGP2P), sigi ) ;
	l->cov->part[0].sigma_P[0] = SIGMA_P[0];
	l->cov->part[0].sigma_P[1] = complex<Type> ( SIGMA_P[1], sigi ) ;
	if ( l->cov->N_part > 1 )
	{
//	  l->cov->part[1].sigma_P[0] = SIGP2[0];
//	  l->cov->part[1].sigma_P[1] = complex<Type> ( SIGP2[0], 0 ) ;
//	  l->cov->partpart[0][1].sigma_P[0] = l->cov->partpart[0][1].sigma_P[1] = sigp12;
	}
	l->cov->sig_meas[0] = SIGOP;
	l->cov->sig_meas[1] = SIGOM;
  }
  else
  {
	l->cov->sigma_N[0] = SIGN;
	l->cov->part[0].sigma_P[0] = SIGP;
//	l->cov->part[0].sigma_P[1] = SIGP2[1];
	if ( l->cov->N_part > 1 )
	{
//	  l->cov->part[1].sigma_P[0] = SIGP2[0];
//	  l->cov->partpart[0][1].sigma_P[0] = l->cov->partpart[0][1].sigma_P[1] = sigp12;
	  l->cov->part[1].sigma_P[0] = 0;
	  l->cov->partpart[0][1].sigma_P[0] = l->cov->partpart[0][1].sigma_P[1] = 0;
	}
	l->cov->sig_meas[0] = SIGO;
  }

  if (!l->Rice)
  {
	F[0] = YOP; 
	F[1] = YOM;
	if ( l->GetDType() == "sad" || l->GetDType() == "SAD" ) {
	  Type A_P = A+App, B_P = B+Bpp;
	  Type A_M = A-App, B_M = B-Bpp;
	  Type YC_P = sqrt( A_P*A_P + B_P*B_P );
	  Type YC_M = sqrt( A_M*A_M + B_M*B_M );
	  F[2] = YC_P;
	  F[3] = YC_M;
	  ph[0] = ph[1] = 0.; 
	  ph[2] = atan(B_P/A_P);
	  if (A_P<0) ph[2] += PI;
	  ph[3] = atan(B_M/A_M);
	  if (A_M<0) ph[3] += PI;
	} 
	else { /* sadh */
	  Type YC = sqrt( A*A + B*B );
	  Type YC_H = sqrt( App*App + Bpp*Bpp );
	  F[3] = YC;
	  F[2] = YC_H;
	  ph[0] = ph[1] = 0.; 
	  if (fabs(A)<1e-7) {  if (B>0) ph[3] = HALF_PI; else ph[3] = 3*HALF_PI; }
	  else { ph[3] = atan(B/A); if (A<0) ph[3] += PI; }
	  if (fabs(App)<1e-7) {  if (Bpp>0) ph[2] = HALF_PI; else ph[2] = 3*HALF_PI; }
	  else { ph[2] = atan(Bpp/App); if (App<0) ph[2] += PI; }
	}
  }
  else /*rice*/
  {
	Type YC = sqrt( A*A + B*B );
	F[0] = YO; 
	F[1] = YC;
	if (fabs(A)<1e-7) { if (B>0) ph[3] = HALF_PI; else ph[3] = 3*HALF_PI; }
	else { ph[1] = atan(B/A); if (A<0) ph[1] += PI; }
  }
  l->cov->part[0].D[0][0] = l->cov->part[0].D[1][1] = 1;
  l->cov->part[0].D[0][1] = l->cov->part[0].D[1][0] = D_PAR[1];
  if ( l->cov->N_part > 1 )
  {
	l->cov->part[1].D[0][0] = l->cov->part[1].D[1][1] = 1;
	l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[2];
  }
  if ( l->cov->N_part > 2 )
  {
	l->cov->part[2].D[0][0] = l->cov->part[2].D[1][1] = 1.;
	l->cov->part[2].D[0][1] = l->cov->part[2].D[1][0] = D_PAR[0];  //scale
  }
  if ( l->cov->N_part > 3 )
  {
	l->cov->part[3].D[0][0] = l->cov->part[3].D[1][1] = 1.;
	l->cov->part[3].D[0][1] = l->cov->part[3].D[1][0] = D_PAR[3];  //anom. obs-calc "scale" (for 12 term)
  }
}


//extern "C" void sad_dmyfuncdd_ml_( int& ICENT, freal& SIGN, freal* SIGMA_N, freal* SIGMA_P, freal& SIGP, freal* SIGP2, 
//  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& YO, freal& YOP, freal& YOM, freal& A, freal& B, freal& App, freal& Bpp,
//  int& IR, freal& PH, freal* D_PAR, freal* DFDD, freal* DFDDD, int& DFdim, 
//  freal& FVALUE, freal& sigi, freal& sigp12, freal& fom, int& ID )
FORTRAN_SUBR ( SAD_DMYFUNCDD_ML, sad_dmyfuncdd_ml,
	( int* ICENT, freal* SIGN, freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, 
	  freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	  freal* A, freal* B, freal* App, freal* Bpp,
	  int* IR, freal* PH, freal* D_PAR, freal* DFDD, freal* DFDDD, int* DFdim, 
	  freal* FVALUE, freal* sigi, freal* sigp12, freal* fom, int* ID ),
	( int* ICENT, freal* SIGN, freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, 
	  freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	  freal* A, freal* B, freal* App, freal* Bpp,
	  int* IR, freal* PH, freal* D_PAR, freal* DFDD, freal* DFDDD, int* DFdim, 
	  freal* FVALUE, freal* sigi, freal* sigp12, freal* fom, int* ID ),
	( int* ICENT, freal* SIGN, freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, 
	  freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	  freal* A, freal* B, freal* App, freal* Bpp,
	  int* IR, freal* PH, freal* D_PAR, freal* DFDD, freal* DFDDD, int* DFdim, 
	  freal* FVALUE, freal* sigi, freal* sigp12, freal* fom, int* ID ) )
{
  Type F[4]={0.,0.,0.,0.}, ph[4]={0.,0.,0.,0.};	
Type DFDDD11,DFDDD12,DFDDD13,DFDDD14,DFDDD22,DFDDD23,DFDDD24,DFDDD33,DFDDD34,DFDDD44;
//Type DFDDD[10000]; 
//int DFdim = 8;

  likelihood<Type> *lD;
  if (*ID==0) lD=&lD1;
  if (*ID==1) lD=&lD2;
  if (*ID==2) lD=&lD3;
  if (*ID==3) lD=&lD4;

  sad_input_llhood(lD, *ICENT, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
  *SIGO, *SIGOP, *SIGOM, *YO, *YOP, *YOM, *A, *B, *App, *Bpp, D_PAR, *sigi, *sigp12, F, ph );

  lD->cov->Make_matrix();
  lD->InverseAndEigen();
  *FVALUE = lD->EvaluateSR( F, ph );
//if (lD->Rice) {lD->cov->Print();
//	cout<<lD->cov->sigma_N[0] << " "<< SIGMA_N[0] << endl;
//	cout << lD->cov->part[0].sigma_P[0]  << D_PAR[1] << endl;
//	cout << lD->cov->part[0].sigma_P[1] << " "<< SIGOP << " " << SIGOM << endl;
//}
  *fom = lD->GetFOM();  
  
  DFDD[1] = lD->GetDer_D(0,0,1);					if ( DFDD[1] > maxa )  DFDD[1] = maxa;	if ( DFDD[1] < -maxa )  DFDD[1] = -maxa;
  if ( lD->GetDerD() == 2 ) {
	DFDDD22 = lD->GetDer2_DD(0,0,1,0,0,1);			if ( DFDDD22 > maxa ) DFDDD22 = maxa;	if ( DFDDD22 < -maxa ) DFDDD22 = -maxa;    
	DFDDD[1*(*DFdim)+1] = DFDDD22;
  }

  if ( lD->cov->N_part > 1 )
  {
	DFDD[2] = lD->GetDer_D(1,0,1);					if ( DFDD[2] > maxa )  DFDD[2] = maxa;	if ( DFDD[2] < -maxa )  DFDD[2] = -maxa;
	if ( lD->GetDerD() == 2 ) {
	  DFDDD33 = lD->GetDer2_DD(1,0,1,1,0,1);			if ( DFDDD33 > maxa ) DFDDD33 = maxa;	if ( DFDDD33 < -maxa ) DFDDD33 = -maxa;
	  DFDDD23 = lD->GetDer2_DD(0,0,1,1,0,1);			if ( DFDDD23 > maxa ) DFDDD23 = maxa;	if ( DFDDD23 < -maxa ) DFDDD23 = -maxa;
	  DFDDD[2*(*DFdim)+2] = DFDDD33;
	  DFDDD[2*(*DFdim)+1] = DFDDD[1*(*DFdim)+2] = DFDDD23;
	}
  }
  else { 
	DFDD[2] = DFDDD[2*(*DFdim)+1] = DFDDD[1*(*DFdim)+2] = DFDDD[2*(*DFdim)+2] = 0;
  }

  if ( lD->cov->N_part > 2 )
  {
	DFDD[0] = lD->GetDer_D(2,0,1);					if ( DFDD[0] > maxa )  DFDD[0] = maxa;	if ( DFDD[0] < -maxa )  DFDD[0] = -maxa;
	if ( lD->GetDerD() == 2 ) {
	  DFDDD12 = lD->GetDer2_DD(0,0,1,2,0,1);		if ( DFDDD12 > maxa ) DFDDD12 = maxa;	if ( DFDDD12 < -maxa ) DFDDD12 = -maxa;
	  DFDDD11 = lD->GetDer2_DD(2,0,1,2,0,1);		if ( DFDDD11 > maxa ) DFDDD11 = maxa;	if ( DFDDD11 < -maxa ) DFDDD11 = -maxa;
	  DFDDD13 = lD->GetDer2_DD(1,0,1,2,0,1);		if ( DFDDD13 > maxa ) DFDDD13 = maxa;	if ( DFDDD13 < -maxa ) DFDDD13 = -maxa;
	  DFDDD[1*(*DFdim)+0] = DFDDD[0*(*DFdim)+1] = DFDDD12;
	  DFDDD[0*(*DFdim)+0] = DFDDD11;
	  DFDDD[2*(*DFdim)+0] = DFDDD[0*(*DFdim)+2] = DFDDD13;
	}
  }
  else {
	DFDD[0] = DFDDD[1*(*DFdim)+0] = DFDDD[0*(*DFdim)+1] = DFDDD[0*(*DFdim)+0] = DFDDD[2*(*DFdim)+0] = DFDDD[0*(*DFdim)+2] = 0;
  }

  if ( lD->cov->N_part > 3 )
  {
	DFDD[3] = lD->GetDer_D(3,0,1);					if ( DFDD[3] > maxa )  DFDD[3] = maxa;	if ( DFDD[3] < -maxa )  DFDD[3] = -maxa;
	if ( lD->GetDerD() == 2 ) {
	  DFDDD44 = lD->GetDer2_DD(3,0,1,3,0,1);		if ( DFDDD44 > maxa ) DFDDD44 = maxa;	if ( DFDDD44 < -maxa ) DFDDD44 = -maxa;
	  DFDDD24 = lD->GetDer2_DD(0,0,1,3,0,1);		if ( DFDDD24 > maxa ) DFDDD24 = maxa;	if ( DFDDD24 < -maxa ) DFDDD24 = -maxa;
	  DFDDD14 = lD->GetDer2_DD(2,0,1,3,0,1);		if ( DFDDD14 > maxa ) DFDDD14 = maxa;	if ( DFDDD14 < -maxa ) DFDDD14 = -maxa;
	  DFDDD34 = lD->GetDer2_DD(1,0,1,3,0,1);		if ( DFDDD34 > maxa ) DFDDD34 = maxa;	if ( DFDDD34 < -maxa ) DFDDD34 = -maxa;
	  DFDDD[3*(*DFdim)+3] = DFDDD44;
	  DFDDD[3*(*DFdim)+1] = DFDDD[1*(*DFdim)+3] = DFDDD24;
	  DFDDD[3*(*DFdim)+0] = DFDDD[0*(*DFdim)+3] = DFDDD14;
	  DFDDD[3*(*DFdim)+2] = DFDDD[2*(*DFdim)+3] = DFDDD34;
	}
  }
  else {
	DFDD[3] = DFDDD[3*(*DFdim)+1] = DFDDD[1*(*DFdim)+3] = DFDDD[3*(*DFdim)+0] = DFDDD[0*(*DFdim)+3] = DFDDD[3*(*DFdim)+2] = DFDDD[2*(*DFdim)+3] = DFDDD[3*(*DFdim)+3] = 0;
  }

//freal maxal = maxa*.5;
//  if ( DFDD[0] > maxal || DFDD[0] < -maxal ) { DFDD[0]=DFDD[1]=maxa*.5; if (fabs(DFDD[0])>FVALUE) FVALUE=fabs(DFDD[0]); }
//  if ( DFDD[1] > maxal || DFDD[1] < -maxal ) { DFDD[0]=DFDD[1]=maxa*.5; if (fabs(DFDD[1])>FVALUE) FVALUE=fabs(DFDD[1]); } 

// test this carefully!!! it seems that even eigenvalues bigger than 1 can cause trouble...
//  lD->SetMinEig(0.005*sqrt(lD->eigenvalues1[lD->Rice][lD->Num-1]));
//  lD->SetMinEig(1.e-6*sqrt(lD->eigenvalues1[lD->Rice][lD->Num-1]));

  bool out = 0;
  int i = -1;
  while ( !out  &&  ++i < lD->Num )
  {
	if ( lD->eigenvalues1[lD->Rice][i] < lD->GetMinEig() ) { /*cout << IR << " out " << ICENT << " " << lD->eigenvalues1[lD->cent][i] << endl;*/ out = 1; }
//	 cout << ICENT <<" "<< SIGN2 <<" "<< SIGN2P <<"   "<< SIGP2_1 <<" "<< SIGP2_2 <<" "<< sigp12 <<"   "<< sigi<<" "<< D_PAR_1 <<" "<<  D_PAR_2<< SIGOP<<" "<<SIGOM<<" " << FVALUE<<endl;}
//	if ( i<lD->Num-lD->N_meas && lD->eigenvalues2[lD->cent][i] < lD->min_acc_eigen ) cout << "out2!" << endl; //out = 1;
  }
//  if (out) for (int i=0; i<lD->Num; i++) cout << lD->eigenvalues1[lD->cent][i] << " "; cout << endl;
  if ( out /*&& l.cent*/ ) { *FVALUE = maxa; DFDD[1] = DFDD[0] = DFDD[2] = DFDD[3] = 0/*maxa*/; DFDDD11 = DFDDD22 =DFDDD33 = DFDDD44 = 0;/*maxa*/; DFDDD12 = 0; }

//  if ( FVALUE > maxa ) FVALUE = maxa;
//cout << FVALUE << " " << fom << " " << lD->cent << " " << DFDD1 << " " << DFDDD11 << " " << DFDDD22 << endl;
}




//extern "C" void sad_dmyfuncdab_ml_( int& ICENT, freal& SIGN, freal* SIGMA_N, freal* SIGMA_P, freal& SIGP, freal* SIGP2, 
//  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& YO, freal& YOP, freal& YOM, freal& A, freal& B, freal& App, freal& Bpp,
//  int& IR, freal& PH, freal* D_PAR, freal& DFDA, freal& DFDB, freal& DFDAA, freal& DFDAB, freal& DFDBB, 
//  freal& FVALUE, freal& FOM , freal& PHIB, freal* HL, freal& sigi, freal& sigp12, 
//  freal& DFDApp, freal& DFDBpp, freal& DFDAppApp, freal& DFDAppBpp, freal& DFDBppBpp, freal& DFDAApp, freal& DFDBBpp,
//  freal& DFDABpp, freal& DFDAppB, int& ID, int& VERB, int& doABCD )
FORTRAN_SUBR ( SAD_DMYFUNCDAB_ML, sad_dmyfuncdab_ml,
  ( int* ICENT, freal* SIGN, freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* App, freal* Bpp, int* IR, freal* PH, freal* D_PAR,
	freal* DFDA, freal* DFDB, freal* DFDAA, freal* DFDAB, freal* DFDBB, 
	freal* FVALUE, freal* FOM , freal* PHIB, freal* HL, freal* sigi, freal* sigp12, 
	freal* DFDApp, freal* DFDBpp, freal* DFDAppApp, freal* DFDAppBpp, freal* DFDBppBpp, freal* DFDAApp, freal* DFDBBpp,
	freal* DFDABpp, freal* DFDAppB, int* ID, int* VERB, int* doABCD ),
// just repeating here as  machine_.h requires...
  ( int* ICENT, freal* SIGN, freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* App, freal* Bpp, int* IR, freal* PH, freal* D_PAR,
	freal* DFDA, freal* DFDB, freal* DFDAA, freal* DFDAB, freal* DFDBB, 
	freal* FVALUE, freal* FOM , freal* PHIB, freal* HL, freal* sigi, freal* sigp12, 
	freal* DFDApp, freal* DFDBpp, freal* DFDAppApp, freal* DFDAppBpp, freal* DFDBppBpp, freal* DFDAApp, freal* DFDBBpp,
	freal* DFDABpp, freal* DFDAppB, int* ID, int* VERB, int* doABCD ),
  ( int* ICENT, freal* SIGN, freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* App, freal* Bpp, int* IR, freal* PH, freal* D_PAR,
	freal* DFDA, freal* DFDB, freal* DFDAA, freal* DFDAB, freal* DFDBB, 
	freal* FVALUE, freal* FOM , freal* PHIB, freal* HL, freal* sigi, freal* sigp12, 
	freal* DFDApp, freal* DFDBpp, freal* DFDAppApp, freal* DFDAppBpp, freal* DFDBppBpp, freal* DFDAApp, freal* DFDBBpp,
	freal* DFDABpp, freal* DFDAppB, int* ID, int* VERB, int* doABCD ) )
{
  Type F[4]={0.,0.,0.,0.}, ph[4]={0.,0.,0.,0.}; 

  likelihood<Type> *lF;
  if (*ID==0) lF=&lF1;
  if (*ID==1) lF=&lF2;
  if (*ID==2) lF=&lF3;
  if (*ID==3) lF=&lF4;

  sad_input_llhood( lF, *ICENT, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
  *SIGO, *SIGOP, *SIGOM, *YO, *YOP, *YOM, *A, *B, *App, *Bpp, D_PAR, *sigi, *sigp12, F, ph );

  if (*doABCD) lF->SetCalcHL(1);

// calculating average of PHIB+ and PHIB- does not seem to help?
//if (*doABCD) {
//  lF->cov->Make_matrix();
//  lF->InverseAndEigen();
//  lF->SetNum4PHIB(0);
//  *FVALUE = lF->EvaluateSR( F, ph );
//  *PHIB = lF->GetPHIB();
//  lF->SetNum4PHIB(-1);
//}

  lF->cov->Make_matrix();
  lF->InverseAndEigen();

//  if (IR>900 && IR<1100) cout << "see:" << ICENT << " "<< sqrt(A*A+B*B) << "   " << F[2] << " " << F[3] << "    " << F[0] << " " << F[1] <<endl;

  Type A_P = *A+*App, B_P = *B+*Bpp;
  Type A_M = *A-*App, B_M = *B-*Bpp;

  int Nm = lF->Num - 1;
//  if ( (lF->GetDType() == "sadh" || lF->GetDType() == "SADH") && !lF->Rice ) Nm--;
  Type dF_dA=0, dF_dB=0, dph_dA=0, dph_dB=0, FNm_inv=0, Fsq_inv=0;
  if (F[Nm]>1e-7) {
	FNm_inv = 1/F[Nm];
	Fsq_inv = FNm_inv*FNm_inv;
	dF_dA = A_M*FNm_inv;
	dF_dB = B_M*FNm_inv;
	dph_dA = - B_M*Fsq_inv;
	dph_dB = A_M*Fsq_inv;
  }
	
  if ( lF->Rice==1 || lF->GetDType() == "sadh" )  {
	dF_dA=0, dF_dB=0, dph_dA=0, dph_dB=0;
	dF_dA = (*A)*FNm_inv;
	dF_dB = (*B)*FNm_inv;
	dph_dA = - (*B)*Fsq_inv;
	dph_dB = (*A)*Fsq_inv;
  }
  *FVALUE = lF->EvaluateSR( F, ph );
  Type DFDAM = lF->GetDer_F(Nm)*dF_dA + lF->GetDer_ph(Nm)*dph_dA;
  Type DFDBM = lF->GetDer_F(Nm)*dF_dB + lF->GetDer_ph(Nm)*dph_dB;  
  Type DFDAMAM=0, DFDAMBM=0, DFDBMBM=0;
  if ( lF->GetDerF() == 2 ) 
  {
	DFDAMAM = lF->GetDer2_FF(Nm,Nm)*dF_dA*dF_dA + 2*lF->GetDer2_phF(Nm,Nm)*dF_dA*dph_dA + 
  	  lF->GetDer2_phph(Nm,Nm)*dph_dA*dph_dA    
//  	  + lF->GetDer_F(Nm)*B_M*B_M/Fsq/F[Nm] + lF->GetDer_ph(Nm)*2*A_M*B_M/Fsq/Fsq ;
		+ lF->GetDer_F(Nm)*dF_dB*dF_dB*FNm_inv + lF->GetDer_ph(Nm)*(-2)*dph_dA*dph_dB ;
		
	DFDAMBM = lF->GetDer2_FF(Nm,Nm)*dF_dA*dF_dB + lF->GetDer2_phF(Nm,Nm)*(dF_dA*dph_dB+dF_dB*dph_dA) + 
	  lF->GetDer2_phph(Nm,Nm)*dph_dA*dph_dB    
//	  - lF->GetDer_F(Nm)*A_M*B_M/Fsq/F[Nm] + lF->GetDer_ph(Nm)*(B_M*B_M-A_M*A_M)/Fsq/Fsq;
	  - lF->GetDer_F(Nm)*dF_dA*dF_dB*FNm_inv + lF->GetDer_ph(Nm)*(dph_dA*dph_dA-dph_dB*dph_dB);
	  
	DFDBMBM = lF->GetDer2_FF(Nm,Nm)*dF_dB*dF_dB + 2*lF->GetDer2_phF(Nm,Nm)*dF_dB*dph_dB + 
  	  lF->GetDer2_phph(Nm,Nm)*dph_dB*dph_dB    
//  	  + lF->GetDer_F(Nm)*A_M*A_M/Fsq/F[Nm] - lF->GetDer_ph(Nm)*2*A_M*B_M/Fsq/Fsq;
  	  + lF->GetDer_F(Nm)*dF_dA*dF_dA*FNm_inv - lF->GetDer_ph(Nm)*(-2)*dph_dA*dph_dB;
  }
  if ( lF->Rice==1 || lF->GetDType() == "sadh" ) 
  {
    *DFDA = DFDAM;
    *DFDB = DFDBM;
    *DFDAA = DFDAMAM;
    *DFDAB = DFDAMBM;
    *DFDBB = DFDBMBM;
    *DFDApp = 0;
    *DFDBpp = 0;
    *DFDAppApp = 0;
    *DFDAppBpp = 0;
    *DFDBppBpp = 0;
    *DFDAApp = 0;
    *DFDABpp = 0;
    *DFDAppB = 0;
    *DFDBBpp = 0;
  }
  if ( !lF->Rice ) 
  {
  int Nm1 = Nm - 1;
//  if ( (lF->GetDType() == "sadh" || lF->GetDType() == "SADH") ) Nm1 = Nm + 1;
  Type Fsq1_inv = 0, FNm1_inv = 0;
  if (F[Nm1]>1e-7)  {
	FNm1_inv = 1/F[Nm1];
	Fsq1_inv = FNm1_inv*FNm1_inv;
  }
  Type dF_dA1=0, dF_dB1=0, dph_dA1=0, dph_dB1=0;
  if ( lF->GetDType() == "sadh" && F[Nm1]!=0 ) {
	dF_dA1 = (*App)*FNm1_inv;  
	dF_dB1 = (*Bpp)*FNm1_inv;  
	dph_dA1 = - (*Bpp)*Fsq1_inv;
	dph_dB1 = (*App)*Fsq1_inv;
  } else if ( lF->GetDType() == "sad" )  { 
	dF_dA1 = A_P*FNm1_inv;  
	dF_dB1 = B_P*FNm1_inv;  
	dph_dA1 = - B_P*Fsq1_inv;
	dph_dB1 = A_P*Fsq1_inv;
  }
  Type DFDAP = lF->GetDer_F(Nm1)*dF_dA1 + lF->GetDer_ph(Nm1)*dph_dA1;
  Type DFDBP = lF->GetDer_F(Nm1)*dF_dB1 + lF->GetDer_ph(Nm1)*dph_dB1;
//cout << DFDAP << " " <<  DFDBP << " "<< lF->GetDer_F(Nm1) << " "<<dF_dA1 << endl;
  Type DFDAPAM=0, DFDAPBM=0, DFDAMBP=0, DFDBPBM=0, DFDAPAP=0, DFDAPBP=0, DFDBPBP=0;
  if ( lF->GetDerF() == 2 ) 
  {
	DFDAPAM = lF->GetDer2_FF(Nm,Nm1)*dF_dA*dF_dA1 + lF->GetDer2_phF(Nm,Nm1)*dF_dA1*dph_dA +
	  lF->GetDer2_phF(Nm1,Nm)*dF_dA*dph_dA1 + lF->GetDer2_phph(Nm,Nm1)*dph_dA*dph_dA1;
	DFDAPBM = lF->GetDer2_FF(Nm,Nm1)*dF_dB*dF_dA1 + lF->GetDer2_phF(Nm,Nm1)*dF_dA1*dph_dB +
	  lF->GetDer2_phF(Nm1,Nm)*dF_dB*dph_dA1 + lF->GetDer2_phph(Nm,Nm1)*dph_dB*dph_dA1;
	DFDAMBP = lF->GetDer2_FF(Nm,Nm1)*dF_dA*dF_dB1 + lF->GetDer2_phF(Nm,Nm1)*dF_dB1*dph_dA +
	  lF->GetDer2_phF(Nm1,Nm)*dF_dA*dph_dB1 + lF->GetDer2_phph(Nm,Nm1)*dph_dA*dph_dB1;
	DFDBPBM = lF->GetDer2_FF(Nm,Nm1)*dF_dB*dF_dB1 + lF->GetDer2_phF(Nm,Nm1)*dF_dB1*dph_dB +
	  lF->GetDer2_phF(Nm1,Nm)*dF_dB*dph_dB1 + lF->GetDer2_phph(Nm,Nm1)*dph_dB*dph_dB1;
	DFDAPAP = lF->GetDer2_FF(Nm1,Nm1)*dF_dA1*dF_dA1 + 2*lF->GetDer2_phF(Nm1,Nm1)*dF_dA1*dph_dA1 + 
  	  lF->GetDer2_phph(Nm1,Nm1)*dph_dA1*dph_dA1     
//  	  + lF->GetDer_F(Nm1)*B_P*B_P*Fsq1_inv/F[Nm1] + lF->GetDer_ph(Nm1)*2*A_P*B_P*Fsq1_inv*Fsq1_inv ;
  	  + lF->GetDer_F(Nm1)*dF_dB1*dF_dB1*FNm1_inv + lF->GetDer_ph(Nm1)*(-2)*dph_dA1*dph_dB1 ;
  	  
	DFDAPBP = lF->GetDer2_FF(Nm1,Nm1)*dF_dA1*dF_dB1 + lF->GetDer2_phF(Nm1,Nm1)*(dF_dA1*dph_dB1+dF_dB1*dph_dA1) + 
  	  lF->GetDer2_phph(Nm1,Nm1)*dph_dA1*dph_dB1     
//  	  - lF->GetDer_F(Nm1)*A_P*B_P*Fsq1_inv/F[Nm1] + lF->GetDer_ph(Nm1)*(B_P*B_P-A_P*A_P)*Fsq1_inv*Fsq1_inv;
  	  - lF->GetDer_F(Nm1)*dF_dA1*dF_dB1*FNm_inv + lF->GetDer_ph(Nm1)*(dph_dA1*dph_dA1-dph_dB1*dph_dB1);
  	  
	DFDBPBP = lF->GetDer2_FF(Nm1,Nm1)*dF_dB1*dF_dB1 + 2*lF->GetDer2_phF(Nm1,Nm1)*dF_dB1*dph_dB1 + 
  	  lF->GetDer2_phph(Nm1,Nm1)*dph_dB1*dph_dB1     
//  	  + lF->GetDer_F(Nm1)*A_P*A_P*Fsq1_inv/F[Nm1] - lF->GetDer_ph(Nm1)*2*A_P*B_P*Fsq1_inv*Fsq1_inv;
  	  + lF->GetDer_F(Nm1)*dF_dA1*dF_dA1*FNm_inv - lF->GetDer_ph(Nm1)*(-2)*dph_dA1*dph_dB1;
  }
  if ( lF->GetDType() == "sad" ) {
	*DFDA = DFDAP + DFDAM;
	*DFDB = DFDBP + DFDBM;
	*DFDAA = DFDAPAP + DFDAMAM + 2*DFDAPAM;
	*DFDAB = DFDAPBP + DFDAMBM + DFDAPBM + DFDAMBP;
	*DFDBB = DFDBPBP + DFDBMBM + 2*DFDBPBM;

	*DFDApp = DFDAP - DFDAM;
	*DFDBpp = DFDBP - DFDBM;
	*DFDAppApp = DFDAPAP - 2*DFDAPAM + DFDAMAM;
	*DFDAppBpp = DFDAPBP - DFDAPBM - DFDAMBP + DFDAMBM;
	*DFDBppBpp = DFDBPBP - 2*DFDBPBM + DFDBMBM;
	*DFDAApp = DFDAPAP - DFDAMAM;
	*DFDBBpp = DFDBPBP - DFDBMBM;
	*DFDABpp = DFDAPBP + DFDAMBP - DFDAPBM - DFDAMBM;
	*DFDAppB = DFDAPBP + DFDAPBM - DFDAMBP - DFDAMBM;
  }
  else {  /* sadh */
	*DFDApp = DFDAP;
	*DFDBpp = DFDBP;
	*DFDAppApp = DFDAPAP;
	*DFDAppBpp = DFDAPBP;
	*DFDBppBpp = DFDBPBP;
	*DFDAApp = DFDAPAM;
	*DFDBBpp = DFDBPBM;
	*DFDABpp = DFDAMBP;
	*DFDAppB = DFDAPBM;
  }
  
  }

  if ( *DFDA > maxa )  *DFDA = maxa;		if ( *DFDA < -maxa )  *DFDA = - maxa;
  if ( *DFDB > maxa )  *DFDB = maxa;		if ( *DFDB < -maxa )  *DFDB = - maxa;
  if ( *DFDAA > maxa )  *DFDAA = maxa;		if ( *DFDAA < -maxa )  *DFDAA = - maxa;
  if ( *DFDAB > maxa )  *DFDAB = maxa;		if ( *DFDAB < -maxa )  *DFDAB = - maxa;
  if ( *DFDBB > maxa )  *DFDBB = maxa;		if ( *DFDBB < -maxa )  *DFDBB = - maxa;

  *FOM = lF->GetFOM();
  *PHIB = lF->GetPHIB();
  if (*doABCD) {
	HL[0] = lF->GetHLA();
	HL[1] = lF->GetHLB();
	HL[2] = lF->GetHLC();
	HL[3] = lF->GetHLD();
  }
// if SAD/SADH is used also for centrics
  if ( *ICENT && !lF->Rice ) 
    if ( lF->tab->Cos(*PHIB - ph[3]) >= 0. )  *PHIB = ph[3];
    else *PHIB = ph[3] + PI;
  
// test this carefully!!! it seems that even eigenvalues bigger than 1 can cause trouble...
//  lF->SetMinEig(0.005*sqrt(lF->eigenvalues1[lF->Rice][lF->Num-1]));
//  lF->SetMinEig(1.e-6*lF->eigenvalues1[lF->Rice][lF->Num-1]);

  bool out = 0;
  int i = -1;
  while ( !out  &&  ++i < lF->Num )
  {
	if ( lF->eigenvalues1[lF->Rice][i] < lF->GetMinEig() ) { if (*VERB) cout << *IR << " out " << lF->Rice << " " << lF->eigenvalues1[lF->Rice][i] << endl; out = 1; }
//	 cout << ICENT <<" "<< SIGN2 <<" "<< SIGN2P <<"   "<< SIGP2_1 <<" "<< SIGP2_2 <<" "<< sigp12 <<"   "<< sigi<<" "<< D_PAR_1 <<" "<<  D_PAR_2<< SIGOP<<" "<<SIGOM<<" " << FVALUE<<endl;}
//	if ( i<lF->Num-lF->N_meas && lF->eigenvalues2[lF->cent][i] < lF->min_acc_eigen ) cout << "out2!" << endl; //out = 1;
  }

  if ( out && D_PAR[1] >= .1 ) 
  {
//	D_PAR[0]  *= 0.95;
	D_PAR[1]  *= 0.95;
//  SIGP2_2 *= 0.98;

   FORTRAN_CALL ( SAD_DMYFUNCDAB_ML, sad_dmyfuncdab_ml,
                 ( ICENT, SIGN, SIGMA_N, SIGMA_P, SIGP, SIGP2, SIGO, SIGOP, SIGOM, YO, YOP, YOM,
                   A, B, App, Bpp, IR, PH, D_PAR, DFDA, DFDB, DFDAA, DFDAB, DFDBB, FVALUE, FOM, PHIB, 
                   HL, sigi, sigp12, DFDApp, DFDBpp, DFDAppApp, DFDAppBpp, DFDBppBpp, DFDAApp, DFDBBpp, 
                   DFDABpp, DFDAppB, ID, VERB, doABCD ),
                 ( ICENT, SIGN, SIGMA_N, SIGMA_P, SIGP, SIGP2, SIGO, SIGOP, SIGOM, YO, YOP, YOM,
                   A, B, App, Bpp, IR, PH, D_PAR, DFDA, DFDB, DFDAA, DFDAB, DFDBB, FVALUE, FOM, PHIB, 
                   HL, sigi, sigp12, DFDApp, DFDBpp, DFDAppApp, DFDAppBpp, DFDBppBpp, DFDAApp, DFDBBpp, 
                   DFDABpp, DFDAppB, ID, VERB, doABCD ),
                 ( ICENT, SIGN, SIGMA_N, SIGMA_P, SIGP, SIGP2, SIGO, SIGOP, SIGOM, YO, YOP, YOM,
                   A, B, App, Bpp, IR, PH, D_PAR, DFDA, DFDB, DFDAA, DFDAB, DFDBB, FVALUE, FOM, PHIB, 
                   HL, sigi, sigp12, DFDApp, DFDBpp, DFDAppApp, DFDAppBpp, DFDBppBpp, DFDAApp, DFDBBpp, 
                   DFDABpp, DFDAppB, ID, VERB, doABCD ) );

	out = 0;
	int i = -1;
	while ( !out  &&  ++i < lF->Num )
	  if ( lF->eigenvalues1[lF->Rice][i] < lF->GetMinEig() ) { if (*VERB) cout << *IR << " out again " << lF->eigenvalues1[lF->Rice][i] << endl; out = 1; }
  }

  if ( out /*&& l.cent*/ ) *FVALUE = maxa;
//  if ( FVALUE > maxa ) FVALUE = maxa;
//if (lF->Rice) *PHIB = -1000.;

//  for ( int i=0; i<lF->Num; i++)
//  if ( lF->eigenvalues1[lF->cent][i] < lF->min_acc_eigen ) { cout << IR << " " << ICENT << " out" << endl; }
//if (IR<5340 && IR>5335) { cout << IR << " " << FVALUE << " " << DFDA << " " << DFDB << " " << DFDApp << " " << DFDBpp << endl; 
//lF->cov->Print(); cout<<lF->eigenvalues1[lF->Rice][0]<< endl; cout.flush();}
}



// ***************SIR & PROT+LIGAND (and MLDR) PART******************


inline void sir_input_llhood( likelihood<Type>* l, int& ICENT, freal& SIGN, freal* SIGM_N, freal* SIGM_P, freal& SIGP, freal* SIGP2,
  freal& SIGO, freal& SIGON, freal& SIGOD, freal& YO, freal& YON, freal& YOD, freal& A, freal& B, freal& AH, freal& BH,
  freal* D_PAR, freal& sigp12, freal& sigh, Type* F, Type* ph )
{
  int rice = 0;
  if ( YON <= 0 || YOD <= 0 || SIGON <= 0 || SIGOD <= 0 || ICENT == 2 ) rice = 1;
  l->SetCentRice(ICENT,rice);
  l->cov->no_imag = 1;
  if (!rice)
  {
	l->cov->sigma_N[0] = SIGM_N[0];
	l->cov->sigma_N[1] = SIGM_N[1] ;
//	l->cov->sigma_N[1] = SIGN2 +  SIGP2P - SIGP2[1];
	l->cov->part[0].sigma_P[0] = SIGM_P[0] ;//+ SIGP2[0] + 2*sigp12 ; // cleny 2_1 a 12 by mali patrit do suboru s kov. mat. ale pre jednoduchost takto
	l->cov->part[0].sigma_P[1] = SIGM_P[1] ;//+ SIGP2[0] + 2*sigp12 ;  // pouzita aproximacia D1 = D3, D2 = D4 (D3,D4 D pre 2. parc. model)
//	l->cov->part[0].sigma_P[1] = SIGP2[1] + SIGN2P - SIGN2;
	l->cov->sig_meas[0] = SIGON;
	l->cov->sig_meas[1] = SIGOD;
  }
  else
  {
	l->cov->sigma_N[0] = SIGN;
	l->cov->part[0].sigma_P[0] = SIGP ;//+ SIGP2[0] + 2*sigp12;
	if ( l->GetDType()=="sirph" ) l->cov->part[0].sigma_P[0] = SIGM_P[1] ;
	l->cov->sig_meas[0] = SIGO;
  }

  if ( !l->Rice )
  {
	Type A_D = A+AH, B_D = B+BH;
	Type YC_D = sqrt( A_D*A_D + B_D*B_D );
	Type YC_N = sqrt( A*A + B*B );
	Type YC_H = sqrt( AH*AH + BH*BH );
//  cout << "see:" << ICENT << " "<< sqrt(A*A+B*B) << "   " << F[2] << " " << F[3] << "    " << F[0] << " " << F[1] << endl;
	F[0] = YON; 
	F[1] = YOD;
	F[2] = YC_N;
	ph[0] = ph[1] = 0.; 
	ph[2] = atan2(B,A);
	if (l->GetDType()=="sir")
	{
	  F[3] = YC_D;
	  ph[3] = atan2(B_D,A_D);
	}
	else if (l->GetDType()=="sirh"||l->GetDType()=="sirph")
	{
	  F[3] = YC_H;
	  ph[3] = atan2(BH,AH);
	  if ( l->GetDType()=="sirph" ) {
		F[2] = F[3];	ph[2] = ph[3];
	  }
	}
  }
  else if ( l->Rice )
  {
	Type YC = sqrt( A*A + B*B );
	F[0] = YO; 
	if ( l->GetDType()=="sirph" ) {
	  F[1] = sqrt( AH*AH + BH*BH );
	  ph[1] = atan2(BH,AH);
	} 
	else {
	  F[1] = YC;
	  ph[1] = atan2(B,A);
	}
  }

  l->cov->part[0].D[0][0] = l->cov->part[0].D[1][1] = 1;
  l->cov->part[0].D[0][1] = l->cov->part[0].D[1][0] = D_PAR[1];
  if (!l->Rice) {
	l->cov->part[1].D[0][0] = l->cov->part[1].D[1][1] = 1;
	l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[2];
  }
  if ( l->cov->N_part > 2 ) {
	l->cov->part[2].D[0][0] = l->cov->part[2].D[1][1] = 1.;
	l->cov->part[2].D[0][1] = l->cov->part[2].D[1][0] = D_PAR[0]; 
  }
  if ( l->cov->N_part > 3 ) {
	l->cov->part[3].D[0][0] = l->cov->part[3].D[1][1] = 1.;
	l->cov->part[3].D[0][1] = l->cov->part[3].D[1][0] = D_PAR[3]; 
  }
  if ( l->cov->N_part > 4 ) {
	l->cov->part[4].D[0][0] = l->cov->part[4].D[1][1] = 1.;
	l->cov->part[4].D[0][1] = l->cov->part[4].D[1][0] = D_PAR[4]; 
  }
}


inline void mldr_input_llhood( likelihood<Type>* l, int& ICENT, freal& SIGN, freal& SIGN2, freal& SIGN2P, freal* SIGP2, freal& SIGP2P,
  freal& SIGO, freal& SIGON, freal& SIGOD, freal& YO, freal& YON, freal& YOD, freal& A, freal& B, freal& AH, freal& BH,
  freal* D_PAR, freal& sigp12, freal& sigh, Type* F, Type* ph, Type* F1, Type* ph1 )
{
  l->SetNoIntegLast(1);
// setup 1. function part
  l->SetCentRice(ICENT,1);
  l->cov->sigma_N[0] = SIGN;
  l->cov->part[0].sigma_P[0] = SIGP2[1] ;//+ SIGP2[0] + 2*sigp12 ;
  l->cov->sig_meas[0] = SIGO;
  Type YC = sqrt( A*A + B*B );
  F1[0] = YO; 
  F1[1] = YC;
  ph1[1] = atan(B/A);
  if (A<0) ph1[1] += PI;
  l->cov->part[0].D[0][0] = l->cov->part[0].D[1][1] = 1;
  l->cov->part[0].D[0][1] = l->cov->part[0].D[1][0] = D_PAR[1];
  l->cov->part[1].D[0][0] = l->cov->part[1].D[1][1] = l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = 1.;

  int rice = 0;
  if ( YON <= 0 || YOD <= 0 || SIGON <= 0 || SIGOD <= 0 || ICENT == 2 ) rice = 1; 
  l->SetCentRice(ICENT,rice);
//  l->cov->no_imag = 1;

// setup 2. function part
  if (!rice)
  {
	l->cov->sigma_N[0] = SIGN2;
	l->cov->sigma_N[1] = SIGN2P;
	l->cov->part[0].sigma_P[0] = sigh ;
	l->cov->part[0].sigma_P[1] = 0;			// nonzero if native and derivative have common heavy atoms - not implemented now
	l->cov->sig_meas[1] = SIGON;	// derivative is first here!
	l->cov->sig_meas[0] = SIGOD;

	Type YC_H = sqrt( AH*AH + BH*BH );
//  cout << "see:" << ICENT << " "<< sqrt(A*A+B*B) << "   " << F[2] << " " << F[3] << "    " << F[0] << " " << F[1] << endl;
	F[0] = YOD; 	// derivatiev first
	F[1] = YON;
	F[2] = YC_H;
	ph[0] = ph[1] = 0.; 
	ph[2] = atan(BH/AH);
	if (AH<0) ph[2] += PI;

	l->cov->part[0].D[0][0] = l->cov->part[0].D[1][1] = 1;
	l->cov->part[0].D[0][1] = l->cov->part[0].D[1][0] = D_PAR[0];
	l->cov->part[1].D[0][0] = l->cov->part[1].D[1][1] = l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = 1.;
  }
}


inline void pl_input_llhood( likelihood<Type>* l, int& ICENT, freal& SIGN, freal* SIGMA_N, freal* SIGMA_P, 
  freal& SIGP,  freal* SIGP2, freal& SIGO, freal& SIGOP, freal& SIGOPL, freal& YO, freal& YOP, freal& YOPL, 
  freal& AP, freal& BP, freal& AL, freal& BL, freal* D_PAR, freal& sigh, int& ligin1, Type* F, Type* ph )
{
  int rice = 0;
  if ( YOP <= 0 || YOPL <= 0 || SIGOP <= 0 || SIGOPL <= 0 || ICENT == 2 ||
      SIGMA_N[0] <= 0. || SIGMA_P[0] <= 0. || SIGMA_N[1] <= 0. || SIGMA_P[1] <= 0. ) rice = 1;
  l->SetCentRice(ICENT,rice);
  l->cov->no_imag = 1;
  if (!l->Rice)
  {
	l->cov->sigma_N[0] = SIGMA_N[0];
	l->cov->sigma_N[1] = SIGMA_N[1];
	l->cov->part[0].sigma_P[0] = SIGMA_P[0];
	if ( l->Num > 3 )
	  l->cov->part[0].sigma_P[1] = SIGMA_P[1];
	l->cov->sig_meas[0] = SIGOP;
	l->cov->sig_meas[1] = SIGOPL;
  }
  else
  {
	l->cov->sigma_N[0] = SIGN;
	l->cov->part[0].sigma_P[0] = SIGP ;//+ SIGP2[0] + 2*sigp12;
	l->cov->sig_meas[0] = SIGO;
  }

  if ( !l->Rice )
  {
// for case when ligand is included in the first model 
    if (ligin1) {
	  AP = AP-AL;
	  BP = BP-BL;
	}
	Type YC_P = sqrt( AP*AP + BP*BP );
	Type YC_L = sqrt( AL*AL + BL*BL );
	F[0] = YOP;
	F[1] = YOPL;
	F[2] = YC_P;
	ph[0] = ph[1] = 0.; 
	if (fabs(AP)<1e-7) {  if (BP>0) ph[2] = HALF_PI; else ph[2] = 3*HALF_PI; }
	else { ph[2] = atan(BP/AP); if (AP<0) ph[2] += PI; }
	if (l->Num>3)
	{
	  F[3] = YC_L;
	  if (fabs(AL)<1e-7) {  if (BL>0) ph[3] = HALF_PI; else ph[3] = 3*HALF_PI; }
	  else { ph[3] = atan(BL/AL); if (AL<0) ph[3] += PI; }
	}
  }
  else if ( l->Rice )
  {
	Type YC = sqrt( AP*AP + BP*BP );
	F[0] = YO; 
	F[1] = YC;
	if (fabs(AP)<1e-7) {  if (BP>0) ph[1] = HALF_PI; else ph[1] = 3*HALF_PI; }
	else { ph[1] = atan(BP/AP); if (AP<0) ph[1] += PI; }
  }

  l->cov->part[0].D[0][0] = l->cov->part[0].D[1][1] = 1;
  l->cov->part[0].D[0][1] = l->cov->part[0].D[1][0] = D_PAR[1];
  l->cov->part[1].D[0][0] = l->cov->part[1].D[1][1] = 1;
//  if ( !l->Rice )
	l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[0];
  if ( l->Rice && l->cov->N_part>2 ) 
  	l->cov->part[2].D[0][1] = l->cov->part[2].D[1][0] = 1.; // D3 rice - used as scaling in covmat so needs to be 1!
  if ( l->Rice && l->cov->N_part>3 ) 
	l->cov->part[3].D[0][1] = l->cov->part[3].D[1][0] = 1.; // just in case
  if ( l->cov->N_part > 2 ){
	l->cov->part[2].D[0][0] = l->cov->part[2].D[1][1] = 1.;
	l->cov->part[2].D[0][1] = l->cov->part[2].D[1][0] = D_PAR[2];  ///// D4 (probably in Ruben's notation?)
  }
  if ( l->cov->N_part > 3 ){
	l->cov->part[3].D[0][0] = l->cov->part[3].D[1][1] = 1;
	l->cov->part[3].D[0][1] = l->cov->part[3].D[1][0] = D_PAR[3];
  }
}


//extern "C" void sir_dmyfuncdd_ml_( int& ICENT, freal& SIGN, freal& SIGN2, freal& SIGN2P, 
//  freal* SIGMA_N, freal* SIGMA_P, freal& SIGP, freal* SIGP2, freal& SIGP2P,
//  freal& SIGO, freal& SIGON, freal& SIGOD, freal& YO, freal& YON, freal& YOD, freal& A, freal& B, freal& AH, freal& BH,
//  int& IR, freal& PH, freal* D_PAR, freal* DFDD, 
//  freal& DFDDD11, freal& DFDDD12, freal& DFDDD22, freal& DFDDD13, freal& DFDDD14, 
//  freal& DFDDD23, freal& DFDDD24, freal& DFDDD33, freal& DFDDD34, freal& DFDDD44,
//  freal& FVALUE, freal& sigp12, freal& sigh, int& ligin1, freal& fom, int& ID )
FORTRAN_SUBR( SIR_DMYFUNCDD_ML, sir_dmyfuncdd_ml,
  ( int* ICENT, freal* SIGN, freal* SIGN2, freal* SIGN2P, 
	freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, freal* SIGP2P,
	freal* SIGO, freal* SIGON, freal* SIGOD, freal* YO, freal* YON, freal* YOD, freal* A, freal* B, freal* AH, freal* BH,
	int* IR, freal* PH, freal* D_PAR, freal* DFDD, 
	freal* DFDDD11, freal* DFDDD12, freal* DFDDD22, freal* DFDDD13, freal* DFDDD14, 
	freal* DFDDD23, freal* DFDDD24, freal* DFDDD33, freal* DFDDD34, freal* DFDDD44, freal* DFDDD55,
	freal* FVALUE, freal* sigp12, freal* sigh, int* ligin1, freal* fom, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGN2, freal* SIGN2P, 
	freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, freal* SIGP2P,
	freal* SIGO, freal* SIGON, freal* SIGOD, freal* YO, freal* YON, freal* YOD, freal* A, freal* B, freal* AH, freal* BH,
	int* IR, freal* PH, freal* D_PAR, freal* DFDD, 
	freal* DFDDD11, freal* DFDDD12, freal* DFDDD22, freal* DFDDD13, freal* DFDDD14, 
	freal* DFDDD23, freal* DFDDD24, freal* DFDDD33, freal* DFDDD34, freal* DFDDD44, freal* DFDDD55,
	freal* FVALUE, freal* sigp12, freal* sigh, int* ligin1, freal* fom, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGN2, freal* SIGN2P, 
	freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, freal* SIGP2P,
	freal* SIGO, freal* SIGON, freal* SIGOD, freal* YO, freal* YON, freal* YOD, freal* A, freal* B, freal* AH, freal* BH,
	int* IR, freal* PH, freal* D_PAR, freal* DFDD, 
	freal* DFDDD11, freal* DFDDD12, freal* DFDDD22, freal* DFDDD13, freal* DFDDD14, 
	freal* DFDDD23, freal* DFDDD24, freal* DFDDD33, freal* DFDDD34, freal* DFDDD44, freal* DFDDD55,
	freal* FVALUE, freal* sigp12, freal* sigh, int* ligin1, freal* fom, int* ID ) )
{
//  cout << *YO << " " << ABSYC << " " << PHCC << " " << IR << endl;

  Type F[4], ph[4];
  Type F1[2], ph1[2];	// for mldr

  likelihood<Type> *lD;
  if (*ID==0) lD=&lD1;
  if (*ID==1) lD=&lD2;
  if (*ID==2) lD=&lD3;
  if (*ID==3) lD=&lD4;

  if ( lD->GetDType() == "p+l" )
	pl_input_llhood(lD, *ICENT, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
	  *SIGO, *SIGON, *SIGOD, *YO, *YON, *YOD, *A, *B, *AH, *BH, D_PAR, *sigh, *ligin1, F, ph );
  else if ( lD->GetDType() == "mldr" )
	mldr_input_llhood(lD, *ICENT, *SIGN, *SIGN2, *SIGN2P, SIGP2, *SIGP2P,
	  *SIGO, *SIGON, *SIGOD, *YO, *YON, *YOD, *A, *B, *AH, *BH, D_PAR, *sigp12, *sigh, F, ph, F1, ph1 );
  else
	sir_input_llhood(lD, *ICENT, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2, 
	  *SIGO, *SIGON, *SIGOD, *YO, *YON, *YOD, *A, *B, *AH, *BH, D_PAR, *sigp12, *sigh, F, ph );

  lD->cov->Make_matrix();
  lD->InverseAndEigen();

  int iD1 = 1, iD2 = 0, iD3 = 2, iD4 = 3, iD5 = 4;
  if ( lD->GetDType() == "sirph" ) { iD1=2; iD3=1; }
  if ( lD->GetDType() == "mldr" )
	*FVALUE = lD->EvaluateSR_MLD( F1, ph1, F, ph );
  else
	*FVALUE = lD->EvaluateSR( F, ph );
  *fom = lD->GetFOM();
  
  DFDD[1] = lD->GetDer_D(iD2,0,1);					if ( DFDD[1] > maxa )  DFDD[1] = maxa;		if ( DFDD[1] < -maxa )  DFDD[1] = -maxa;
  if ( lD->GetDerD() == 2 ) 
  {
	*DFDDD22 = lD->GetDer2_DD(iD2,0,1,iD2,0,1);			if ( *DFDDD22 > maxa ) *DFDDD22 = maxa;	if ( *DFDDD22 < -maxa ) *DFDDD22 = -maxa;
  }
  
  DFDD[0] = lD->GetDer_D(iD1,0,1);					if ( DFDD[0] > maxa )  DFDD[0] = maxa;		if ( DFDD[0] < -maxa )  DFDD[0] = -maxa;
  if ( lD->GetDerD() == 2 ) 
  {
	*DFDDD12 = lD->GetDer2_DD(iD1,0,1,iD2,0,1);			if ( *DFDDD12 > maxa ) *DFDDD12 = maxa;	if ( *DFDDD12 < -maxa ) *DFDDD12 = -maxa;
	*DFDDD11 = lD->GetDer2_DD(iD1,0,1,iD1,0,1);			if ( *DFDDD11 > maxa ) *DFDDD11 = maxa;	if ( *DFDDD11 < -maxa ) *DFDDD11 = -maxa;
  }
  
  if ( lD->cov->N_part > 2 ) {
	DFDD[2] = lD->GetDer_D(iD3,0,1);					if ( DFDD[2] > maxa )  DFDD[2] = maxa;		if ( DFDD[2] < -maxa )  DFDD[2] = -maxa;
	if ( lD->Rice && lD->GetDType() == "p+l" ) DFDD[2] = 0.; // in order not to confuse with scaling parameter for p+l
	if ( lD->GetDerD() == 2 ) 
	{
	  *DFDDD13 = lD->GetDer2_DD(iD1,0,1,iD3,0,1);			if ( *DFDDD13 > maxa ) *DFDDD13 = maxa;	if ( *DFDDD13 < -maxa ) *DFDDD13 = -maxa;
	  *DFDDD23 = lD->GetDer2_DD(iD2,0,1,iD3,0,1);			if ( *DFDDD23 > maxa ) *DFDDD23 = maxa;	if ( *DFDDD23 < -maxa ) *DFDDD23 = -maxa;
	  *DFDDD33 = lD->GetDer2_DD(iD3,0,1,iD3,0,1);			if ( *DFDDD33 > maxa ) *DFDDD33 = maxa;	if ( *DFDDD33 < -maxa ) *DFDDD33 = -maxa;
	}
  }

  if ( lD->cov->N_part > 3 ) {
	DFDD[3] = lD->GetDer_D(iD4,0,1);					if ( DFDD[3] > maxa )  DFDD[3] = maxa;		if ( DFDD[3] < -maxa )  DFDD[3] = -maxa;
	if ( lD->Rice ) DFDD[3] = 0.;
	if ( lD->GetDerD() == 2 ) 
	{
	  *DFDDD14 = lD->GetDer2_DD(iD1,0,1,iD4,0,1);			if ( *DFDDD14 > maxa ) *DFDDD14 = maxa;	if ( *DFDDD14 < -maxa ) *DFDDD14 = -maxa;
	  *DFDDD24 = lD->GetDer2_DD(iD2,0,1,iD4,0,1);			if ( *DFDDD24 > maxa ) *DFDDD24 = maxa;	if ( *DFDDD24 < -maxa ) *DFDDD24 = -maxa;
	  *DFDDD34 = lD->GetDer2_DD(iD3,0,1,iD4,0,1);			if ( *DFDDD34 > maxa ) *DFDDD34 = maxa;	if ( *DFDDD34 < -maxa ) *DFDDD34 = -maxa;
	  *DFDDD44 = lD->GetDer2_DD(iD4,0,1,iD4,0,1);			if ( *DFDDD44 > maxa ) *DFDDD44 = maxa;	if ( *DFDDD44 < -maxa ) *DFDDD44 = -maxa;
	}
  }
// no mixed secder here
  if ( lD->cov->N_part > 4 ) {
	DFDD[4] = lD->GetDer_D(iD5,0,1);					if ( DFDD[4] > maxa )  DFDD[4] = maxa;		if ( DFDD[4] < -maxa )  DFDD[4] = -maxa;
	if ( lD->Rice ) DFDD[4] = 0.;
	if ( lD->GetDerD() == 2 ) 
	{
	  *DFDDD55 = lD->GetDer2_DD(iD5,0,1,iD5,0,1);			if ( *DFDDD55 > maxa ) *DFDDD55 = maxa;	if ( *DFDDD55 < -maxa ) *DFDDD55 = -maxa;
	}
  }

  bool out = 0;
  int i = -1;
  while ( !out  &&  ++i < lD->Num )
  {
	if ( lD->eigenvalues1[lD->Rice][i] < lD->GetMinEig() ) { /*cout << *IR << " out " << *ICENT << " " << lD->eigenvalues1[lD->cent][i] << endl;*/ out = 1; }
  }
  if ( out /*&& l.cent*/ ) { *FVALUE = maxa; DFDD[1] = DFDD[0] = maxa; *DFDDD11 = *DFDDD22 = maxa; *DFDDD12 = 0;  }
//  if ( out /*&& l.cent*/ ) { *FVALUE = maxa; DFDD2 = 0; DFDD1 = maxa; DFDDD11 = maxa; DFDDD22 = DFDDD12 = 0;  }
}




//extern "C" void sir_dmyfuncdab_ml_( int* ICENT, freal* SIGN, freal* SIGN2, freal* SIGN2P, 
//  freal* SIGMA_N, freal* SIGMA_P, freal& SIGP, freal* SIGP2, freal& SIGP2P,
//  freal& SIGO, freal& SIGON, freal& SIGOD, freal& YO, freal& YON, freal& YOD, freal& A, freal& B, freal& AH, freal& BH,
//  int& IR, freal& PH, freal* D_PAR, freal& DFDA, freal& DFDB, 
//  freal& DFDAA, freal& DFDAB, freal& DFDBB, freal& FVALUE, freal& FOM, freal& PHIB, freal& sigp12, freal& sigh, freal& DFDAh, freal& DFDBh, 
//  freal& DFDAhAh, freal& DFDAhBh, freal& DFDBhBh, freal& DFDAAh, freal& DFDBBh, freal& DFDABh, freal& DFDAhB, int& ligin1, int& phibcalc, int& ID )
FORTRAN_SUBR( SIR_DMYFUNCDAB_ML, sir_dmyfuncdab_ml,
  ( int* ICENT, freal* SIGN, freal* SIGN2, freal* SIGN2P, 
	freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, freal* SIGP2P,
	freal* SIGO, freal* SIGON, freal* SIGOD, freal* YO, freal* YON, freal* YOD, freal* A, freal* B, freal* AH, freal* BH,
	int* IR, freal* PH, freal* D_PAR, freal* DFDA, freal* DFDB, 
	freal* DFDAA, freal* DFDAB, freal* DFDBB, freal* FVALUE, freal* FOM, freal* PHIB, freal* HL, 
	freal* sigp12, freal* sigh, freal* DFDAh, freal* DFDBh, 
	freal* DFDAhAh, freal* DFDAhBh, freal* DFDBhBh, freal* DFDAAh, freal* DFDBBh, freal* DFDABh, freal* DFDAhB, 
	int* ligin1, int* phibcalc, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGN2, freal* SIGN2P, 
	freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, freal* SIGP2P,
	freal* SIGO, freal* SIGON, freal* SIGOD, freal* YO, freal* YON, freal* YOD, freal* A, freal* B, freal* AH, freal* BH,
	int* IR, freal* PH, freal* D_PAR, freal* DFDA, freal* DFDB, 
	freal* DFDAA, freal* DFDAB, freal* DFDBB, freal* FVALUE, freal* FOM, freal* PHIB, freal* HL, 
	freal* sigp12, freal* sigh, freal* DFDAh, freal* DFDBh, 
	freal* DFDAhAh, freal* DFDAhBh, freal* DFDBhBh, freal* DFDAAh, freal* DFDBBh, freal* DFDABh, freal* DFDAhB, 
	int* ligin1, int* phibcalc, freal* HL, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGN2, freal* SIGN2P, 
	freal* SIGMA_N, freal* SIGMA_P, freal* SIGP, freal* SIGP2, freal* SIGP2P,
	freal* SIGO, freal* SIGON, freal* SIGOD, freal* YO, freal* YON, freal* YOD, freal* A, freal* B, freal* AH, freal* BH,
	int* IR, freal* PH, freal* D_PAR, freal* DFDA, freal* DFDB, 
	freal* DFDAA, freal* DFDAB, freal* DFDBB, freal* FVALUE, freal* FOM, freal* PHIB, freal* HL, 
	freal* sigp12, freal* sigh, freal* DFDAh, freal* DFDBh, 
	freal* DFDAhAh, freal* DFDAhBh, freal* DFDBhBh, freal* DFDAAh, freal* DFDBBh, freal* DFDABh, freal* DFDAhB, 
	int* ligin1, int* phibcalc, freal* HL, int* ID ) )
{
//  cout << *YO << " " << ABSYC << " " << PHCC << " " << *IR << endl;

  Type F[4], ph[4];	
  Type F1[2], ph1[2];	// for mldr

  likelihood<Type> *lF;
  if (*ID==0) lF=&lF1;
  if (*ID==1) lF=&lF2;
  if (*ID==2) lF=&lF3;
  if (*ID==3) lF=&lF4;

  freal DPAR[5] = { D_PAR[0], D_PAR[1], D_PAR[2], D_PAR[3], D_PAR[4] };
  bool out = 1;

  lF->SetNum4PHIB(*phibcalc);
  lF->SetCalcHL(*phibcalc+1);

  int out_count = 0, max_count=10;
  while ( out && ( DPAR[0]>0.1 || DPAR[1]>0.1 || DPAR[0]==D_PAR[0] ) && out_count<max_count )
  {
    if ( lF->GetDType() == "p+l" )
	  pl_input_llhood(lF, *ICENT, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
	    *SIGO, *SIGON, *SIGOD, *YO, *YON, *YOD, *A, *B, *AH, *BH, DPAR, *sigh, *ligin1, F, ph );
	else if ( lF->GetDType() == "mldr" )
	  mldr_input_llhood(lF, *ICENT, *SIGN, *SIGN2, *SIGN2P, SIGP2, *SIGP2P,
		*SIGO, *SIGON, *SIGOD, *YO, *YON, *YOD, *A, *B, *AH, *BH, DPAR, *sigp12, *sigh, F, ph, F1, ph1 );
	else
	  sir_input_llhood( lF, *ICENT, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
		*SIGO, *SIGON, *SIGOD, *YO, *YON, *YOD, *A, *B, *AH, *BH, DPAR, *sigp12, *sigh, F, ph );
  
	lF->cov->Make_matrix();	
	lF->InverseAndEigen();

	out = 0;
	int i = -1;
	while ( !out  &&  ++i < lF->Num )
	  if ( lF->eigenvalues1[lF->Rice][i] < lF->GetMinEig() ) 
		{ cout << *IR << " out " << lF->eigenvalues1[lF->Rice][i] <<" "<< lF->Rice <<"   "<< DPAR[0]<<" "<< DPAR[1] << " "<< DPAR[3]<<" "<< DPAR[4]<<" "<< endl; out = 1; }
	if ( out ) 
	{
	  if (lF->GetDType()!="sirph") DPAR[0]  *= 0.99;
	  DPAR[1]  *= 0.99;
//should probably not decrease the non-isomorphism parameter!
	  if ( lF->cov->N_part > 2 && lF->GetDType()!="sirph") 
		DPAR[2]  *= 0.99;   
	  if ( lF->cov->N_part > 3 ) 
		DPAR[3]  *= 0.99;   // for p+l, 2 models
	  if ( lF->cov->N_part > 4 ) 
		DPAR[4]  *= 0.99;   
	  out_count++;
	}
	if ( out && !lF->Rice && ( DPAR[0]<0.12 && DPAR[1]<0.12 ) ) *ICENT = 2; // problem with pos. def. of matrix - using Rice
  }


  int Nm1 = lF->Num - 2;
  if ( lF->Rice || (lF->GetDType()=="p+l"&&lF->Num==3) ) Nm1 += 1;

  Type F_Nm1;
  if ( lF->GetDType() == "mldr" )
	F_Nm1 = F1[Nm1];
  else
	F_Nm1 = F[Nm1]; 
  Type Fsq1 = F_Nm1*F_Nm1;
  Type dF_dA1=0., dF_dB1=0., dph_dA1=0., dph_dB1=0., F_Nm1_inv=0., Fsq1_inv = 0.;
  if (F_Nm1>1e-7 && (lF->GetDType()!="sirph"||lF->Rice) )  {  
	dF_dA1 = *A/F_Nm1;
	dF_dB1 = *B/F_Nm1;
	dph_dA1 = - *B/Fsq1;
	dph_dB1 = *A/Fsq1;
    F_Nm1_inv = 1/F_Nm1;
    Fsq1_inv = F_Nm1_inv*F_Nm1_inv;
  }

  if ( lF->GetDType() == "mldr" )
	*FVALUE = lF->EvaluateSR_MLD( F1, ph1, F, ph );
  else
	*FVALUE = lF->EvaluateSR( F, ph );
  Type DFDAN=0., DFDBN=0.;
  *DFDAh = *DFDBh = 0.;
// setting to non-zero value because of other routines would complain 
// in cases such as sir(as) phasing if all are 0
  Type DFDANAN=1., DFDANBN=1., DFDBNBN=1.;
  *DFDAhAh = *DFDAhBh = *DFDBhBh = *DFDAAh = *DFDBBh = *DFDABh = *DFDAhB = 1.;
  if ( lF->GetDType()!="sirph" || lF->Rice ) {
	DFDAN = lF->GetDer_F(Nm1)*dF_dA1 + lF->GetDer_ph(Nm1)*dph_dA1;
	DFDBN = lF->GetDer_F(Nm1)*dF_dB1 + lF->GetDer_ph(Nm1)*dph_dB1;
	if ( lF->GetDerF() == 2 ) 
	{
	  DFDANAN = lF->GetDer2_FF(Nm1,Nm1)*dF_dA1*dF_dA1 + 2*lF->GetDer2_phF(Nm1,Nm1)*dF_dA1*dph_dA1 + 
  		lF->GetDer2_phph(Nm1,Nm1)*dph_dA1*dph_dA1 
  		+ lF->GetDer_F(Nm1)*(*B)*(*B)*Fsq1_inv*F_Nm1_inv + lF->GetDer_ph(Nm1)*2*(*A)*(*B)*Fsq1_inv*Fsq1_inv ;
	  DFDANBN = lF->GetDer2_FF(Nm1,Nm1)*dF_dA1*dF_dB1 + lF->GetDer2_phF(Nm1,Nm1)*(dF_dA1*dph_dB1+dF_dB1*dph_dA1) + 
  		lF->GetDer2_phph(Nm1,Nm1)*dph_dA1*dph_dB1 
  		- lF->GetDer_F(Nm1)*(*A)*(*B)*Fsq1_inv*F_Nm1_inv + lF->GetDer_ph(Nm1)*((*B)*(*B)-(*A)*(*A))*Fsq1_inv*Fsq1_inv;
	  DFDBNBN = lF->GetDer2_FF(Nm1,Nm1)*dF_dB1*dF_dB1 + 2*lF->GetDer2_phF(Nm1,Nm1)*dF_dB1*dph_dB1 + 
  		lF->GetDer2_phph(Nm1,Nm1)*dph_dB1*dph_dB1 
  		+ lF->GetDer_F(Nm1)*(*A)*(*A)*Fsq1_inv*F_Nm1_inv - lF->GetDer_ph(Nm1)*2*(*A)*(*B)*Fsq1_inv*Fsq1_inv;
	}
  }
  if ( lF->Rice || (lF->GetDType()=="p+l"&&lF->Num == 3) ) 
  {
    *DFDA = DFDAN;
    *DFDB = DFDBN;
    *DFDAA = DFDANAN;
    *DFDAB = DFDANBN;
    *DFDBB = DFDBNBN;
  }
  else
  {
	Type A_D = *A+*AH, B_D = *B+*BH;
	int Nm2 = Nm1 + 1;

	Type Fsq2 = F[Nm2]*F[Nm2];
	Type dF_dA2=0., dF_dB2=0., dph_dA2=0., dph_dB2=0., F_Nm2_inv=0., Fsq2_inv=0.;
	if ( F[Nm2] > 1e-7 ) {
	  if ( lF->GetDType() == "sir") {
	    dF_dA2 = A_D/F[Nm2];
	    dF_dB2 = B_D/F[Nm2];
	    dph_dA2 = - B_D/Fsq2;
	    dph_dB2 = A_D/Fsq2;
	  }
	  else if ( lF->GetDType() == "sirh" || lF->GetDType() == "mldr" || lF->GetDType() == "sirph" ||
	            (lF->GetDType() == "p+l" && lF->Num == 4)  ) {
	    dF_dA2 = *AH/F[Nm2];
	    dF_dB2 = *BH/F[Nm2];
	    dph_dA2 = - *BH/Fsq2;
	    dph_dB2 = *AH/Fsq2;
	    A_D = *AH, B_D = *BH;
	  }
  	  F_Nm2_inv = 1/F[Nm2];
  	  Fsq2_inv = F_Nm2_inv*F_Nm2_inv;
	}
	
	Type DFDAD = lF->GetDer_F(Nm2)*dF_dA2 + lF->GetDer_ph(Nm2)*dph_dA2;
	Type DFDBD = lF->GetDer_F(Nm2)*dF_dB2 + lF->GetDer_ph(Nm2)*dph_dB2;  
	Type DFDANAD=0, DFDANBD=0, DFDADBN=0, DFDBNBD=0, DFDADAD=0, DFDADBD=0, DFDBDBD=0;
	if ( lF->GetDerF() == 2 ) 
	{
	  DFDADAD = lF->GetDer2_FF(Nm2,Nm2)*dF_dA2*dF_dA2 + 2*lF->GetDer2_phF(Nm2,Nm2)*dF_dA2*dph_dA2 + 
  		lF->GetDer2_phph(Nm2,Nm2)*dph_dA2*dph_dA2 
  		+ lF->GetDer_F(Nm2)*B_D*B_D*Fsq2_inv*F_Nm2_inv + lF->GetDer_ph(Nm2)*2*A_D*B_D*Fsq2_inv*Fsq2_inv ;
	  DFDADBD = lF->GetDer2_FF(Nm2,Nm2)*dF_dA2*dF_dB2 + lF->GetDer2_phF(Nm2,Nm2)*(dF_dA2*dph_dB2+dF_dB2*dph_dA2) + 
  		lF->GetDer2_phph(Nm2,Nm2)*dph_dA2*dph_dB2 
  		- lF->GetDer_F(Nm2)*A_D*B_D*Fsq2_inv*F_Nm2_inv + lF->GetDer_ph(Nm2)*(B_D*B_D-A_D*A_D)*Fsq2_inv*Fsq2_inv;
	  DFDBDBD = lF->GetDer2_FF(Nm2,Nm2)*dF_dB2*dF_dB2 + 2*lF->GetDer2_phF(Nm2,Nm2)*dF_dB2*dph_dB2 + 
  		lF->GetDer2_phph(Nm2,Nm2)*dph_dB2*dph_dB2 
  		+ lF->GetDer_F(Nm2)*A_D*A_D*Fsq2_inv*F_Nm2_inv - lF->GetDer_ph(Nm2)*2*A_D*B_D*Fsq2_inv*Fsq2_inv;

	  DFDANAD = lF->GetDer2_FF(Nm2,Nm1)*dF_dA2*dF_dA1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dA1*dph_dA2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dA2*dph_dA1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dA2*dph_dA1;
	  DFDANBD = lF->GetDer2_FF(Nm2,Nm1)*dF_dB2*dF_dA1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dA1*dph_dB2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dB2*dph_dA1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dB2*dph_dA1;
	  DFDADBN = lF->GetDer2_FF(Nm2,Nm1)*dF_dA2*dF_dB1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dB1*dph_dA2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dA2*dph_dB1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dA2*dph_dB1;
	  DFDBNBD = lF->GetDer2_FF(Nm2,Nm1)*dF_dB2*dF_dB1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dB1*dph_dB2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dB2*dph_dB1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dB2*dph_dB1;
	}

	if ( lF->GetDType() == "sir")
	{
	  *DFDA = DFDAN + DFDAD;  
	  *DFDB = DFDBN + DFDBD;
//cout << " inside: " << *IR  << *DFDA << " " <<  *DFDB << endl;
	  *DFDAA = (DFDANAN + DFDADAD + 2*DFDANAD);
	  *DFDAB = (DFDANBN + DFDADBD + DFDANBD + DFDADBN);
	  *DFDBB = (DFDBNBN + DFDBDBD + 2*DFDBNBD);
//cout << " inside2: " << *IR  << *DFDAA << " " <<  *DFDBB << endl;

	  *DFDAh = DFDAD;
	  *DFDBh = DFDBD;
	  *DFDAhAh = DFDADAD;
	  *DFDAhBh = DFDADBD;
	  *DFDBhBh = DFDBDBD;
	  *DFDAAh = DFDADAD + DFDANAD;
	  *DFDBBh = DFDBDBD + DFDBNBD;
	  *DFDABh = DFDANBD + DFDADBD;
	  *DFDAhB = DFDADBN + DFDADBD;
	}
	else if ( lF->GetDType() == "sirh"  || lF->GetDType() == "mldr" || lF->GetDType() == "sirph" ||
			  (lF->GetDType() == "p+l" && lF->Num == 4) )
	{
	  *DFDA = DFDAN ;
	  *DFDB = DFDBN ;
	  *DFDAA = DFDANAN ;
	  *DFDAB = DFDANBN ;
	  *DFDBB = DFDBNBN ;

	  *DFDAh = DFDAD;
	  *DFDBh = DFDBD;
	  *DFDAhAh = DFDADAD;
	  *DFDAhBh = DFDADBD;
	  *DFDBhBh = DFDBDBD;
	  *DFDAAh = DFDANAD;
	  *DFDBBh = DFDBNBD;
	  *DFDABh = DFDANBD;
	  *DFDAhB = DFDADBN;
	}
	else { cout << "Problem with sir D type!" << endl; exit(1); }
  }
  
  if ( *DFDA > maxa )  *DFDA = maxa;		if ( *DFDA < -maxa )  *DFDA = - maxa;
  if ( *DFDB > maxa )  *DFDB = maxa;		if ( *DFDB < -maxa )  *DFDB = - maxa;
  if ( *DFDAA > maxa )  *DFDAA = maxa;		if ( *DFDAA < -maxa )  *DFDAA = - maxa;
  if ( *DFDAB > maxa )  *DFDAB = maxa;		if ( *DFDAB < -maxa )  *DFDAB = - maxa;
  if ( *DFDBB > maxa )  *DFDBB = maxa;		if ( *DFDBB < -maxa )  *DFDBB = - maxa;
  *FOM = lF->GetFOM();
  *PHIB = lF->GetPHIB();
  if (*phibcalc >= 0) {
	HL[0] = lF->GetHLA();
	HL[1] = lF->GetHLB();
	HL[2] = lF->GetHLC();
	HL[3] = lF->GetHLD();
  }
  
  int Nm2=3;
  if (lF->GetDType()=="sirph") Nm2=2;
  if (lF->Rice) Nm2=1;
  if ( /**phibcalc >= 0 &&*/ *ICENT ) 
    if ( lF->tab->Cos(*PHIB - ph[Nm2]) >= 0. )  *PHIB = ph[Nm2];
    else *PHIB = ph[Nm2] + PI;

  if ( out /*&& l.cent*/ ) *FVALUE = maxa;

if (/**phibcalc >= 0&&*/lF->Rice) *PHIB = -1000.;
}



// ***************SIRAS  PART******************

// determines whether original Rice (with Fisher) should be used for current reflection
// only for SIRAS at the moment and assuming SAD/SIR are not used - this could be improved later
/*
FORTRAN_SUBR( USEORIGRICE, useorigrice,
  ( int* ir, int* nobs, freal* FO, freal* SIGO, int* rice_now ),
  ( int* ir, int* nobs, freal* FO, freal* SIGO, int* rice_now ),
  ( int* ir, int* nobs, freal* FO, freal* SIGO, int* rice_now ) )
{
  *rice_now = 0;
  if ( lF1.GetDType()=="sras4d" || lF1.GetDType()=="sras5d" || lF1.GetDType()=="sras3d" )
    if ( FO[*ir]<=0 || SIGO[*ir] <=0 || FO[*ir+*nobs] <= 0 || FO[*ir+2*(*nobs)] <= 0 || 
	     SIGO[*ir+*nobs] <= 0 || SIGO[*ir+2*(*nobs)] <= 0 )    
	  *rice_now = 1;
}
*/

inline void siras_input_llhood( likelihood<Type>* l, int& ICENT, freal* SIGN, freal* SIGP, freal& SIGN_rice, freal& SIGP_rice, freal* SIGP2,
  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& YO, freal& YOP, freal& YOM, freal& A, freal& B, freal& AH, freal& BH,
  freal& App, freal& Bpp, freal* D_PAR, freal& sigp12, freal& sigh, Type* F, Type* ph )
{
  int rice = 0;
  int sir1=0, sir2=0, sad=0;
  if ( ICENT && (SIGOP<=0||YOP <= 0) && SIGOM>0&&YOM > 0 ) { SIGOP=SIGOM; YOP=YOM; }
  if ( ICENT && (SIGOM<=0||YOM <= 0) && SIGOP>0&&YOP > 0 ) { SIGOM=SIGOP; YOM=YOP; }
  if (l->GetDType()=="srasph"&&SIGP[0]<=0.) SIGP[0]=0.01; // assigning non-zero value so that rice is not used
//  if ( YO<=0 || SIGO <=0 || YOP <= 0 || YOM <= 0 || SIGOP <= 0 || SIGOM <= 0 || ICENT == 2 ||
//      SIGN[0] <= 0. || SIGP[0] <= 0. || SIGN[1] <= 0. || SIGP[1] <= 0. || 
//      SIGN[2] <= 0. || SIGP[2] <= 0. )    rice = 1;
  freal YO_rice = YO;  
  freal SIGO_rice = SIGO;
  int count = 3;
  if ( YO<=0 || SIGO <=0 || SIGN[0] <= 0. ) count--;
  if ( YOP<=0 || SIGOP <=0 || SIGN[1] <= 0.) count--;
  if ( YOM<=0 || SIGOM <=0 || SIGN[2] <= 0.) count--;
  if (count==0&&SIGN_rice>0.) count++;
  if (count==0) cout << "Reflection with no data encountered! F's:" <<YO<<" "<<YOP<<" "<<YOM<< endl; 
  else if (count==1) rice=1;
  else if (count==2) { /*rice=1;*/
	if ( YOP <= 0 || SIGOP <= 0 || SIGN[1] <= 0. )  sir1 = 1; 
	else if ( YOM <= 0 || SIGOM <= 0 || SIGN[2] <= 0. )  sir2 = 1; 
// it seems that phasing SAD reflections does not improve things
	else if ( l->GetDType()!="srasph" ) sad = 1;
	else rice = 1;
  }
//  if ( SIGN[0] <= 0. || SIGP[0] <= 0. || SIGN[1] <= 0. || SIGP[1] <= 0. || 
//       SIGN[2] <= 0. || SIGP[2] <= 0. )  {  
//      rice = 1; sad=sir1=sir2=0;
//  }
  if ( rice == 1 && (YO<=0.||SIGO<=0.) ) 
  	if (SIGOP>0.&&YOP>0.) { YO_rice=YOP; SIGO_rice=SIGOP; } 
  	else                  { YO_rice=YOM; SIGO_rice=SIGOM; }

  l->SetCentRice(ICENT,rice);
  l->cov->SetZeroRows(-1);
  if (l->GetDType()=="srasph") {
	if (sir1) l->cov->SetZeroRows(1,4);
	if (sir2) l->cov->SetZeroRows(2,4);
	if (sad) l->cov->SetZeroRows(0);
  } else {  
	if (sir1) l->cov->SetZeroRows(1,5);
	if (sir2) l->cov->SetZeroRows(2,5);
	if (sad) l->cov->SetZeroRows(0,3);
  }
  
//  l->cov->no_imag = 1;
  if (!l->Rice)
  {
	l->cov->sigma_N[0] = SIGN[0];
	l->cov->sigma_N[1] = SIGN[1];
	l->cov->sigma_N[2] = SIGN[2];
	l->cov->part[0].sigma_P[0] = SIGP[0] ;//+ SIGP2[0] + 2*sigp12 ; // cleny 2_1 a 12 by mali patrit do suboru s kov. mat. ale pre jednoduchost takto
	l->cov->part[0].sigma_P[1] = SIGP[1] ;
	l->cov->part[0].sigma_P[2] = SIGP[2] ;
	l->cov->sig_meas[0] = SIGO;
	l->cov->sig_meas[1] = SIGOP;
	l->cov->sig_meas[2] = SIGOM;
  }
  else
  {
	l->cov->sigma_N[0] = SIGN_rice; 
	l->cov->part[0].sigma_P[0] = SIGP_rice; //SIGP2[1] + SIGP2[0] + 2*sigp12;
//	if ( l->GetDType()=="srasph" ) l->cov->part[0].sigma_P[0] = SIGP[1] ;
	l->cov->sig_meas[0] = SIGO_rice;
  }

  Type YC = sqrt( A*A + B*B );
  if ( !l->Rice )
  {
//	if (l->GetDType()=="srasph") { A= B= YC= 0.; }
	Type A_P = A+AH+App, B_P = B+BH+Bpp;
	Type A_M = A+AH-App, B_M = B+BH-Bpp;
//!!!!!!!!!!!!!!!!!!
//	Type A_D = /*A+*/AH, B_D = /*B+*/BH;
//	Type A_D = A/*+AH*/, B_D = B/*+BH*/;
	Type A_D = A+AH, B_D = B+BH;
	Type YC_P = sqrt( A_P*A_P + B_P*B_P );
	Type YC_M = sqrt( A_M*A_M + B_M*B_M );
	Type YC_D = sqrt( A_D*A_D + B_D*B_D );
	Type YCpp = sqrt( App*App + Bpp*Bpp );
//  cout << "see:" << ICENT << " "<< sqrt(A*A+B*B) << "   " << F[2] << " " << F[3] << "    " << F[0] << " " << F[1] << endl;
	F[0] = YO;		
	F[1] = YOP;		
	F[2] = YOM;		
	if (l->cov->CheckZeroRow(4)) {
	  for (int i=0; i<3; i++) if (F[i] < 1.) F[i]=1.;
	}
	ph[0] = ph[1] = ph[2] = 0.; 
	F[3] = YC;
	if (fabs(A)<1e-7) {  if (B>0) ph[3] = HALF_PI; else ph[3] = 3*HALF_PI; }
	else              {  ph[3] = atan(B/A);       if (A<0) ph[3] += PI;   }
	if ( l->GetDType()=="sras" || l->GetDType()=="sras3d" ) {
	  F[4] = YC_P;
	  if (fabs(A_P)<1e-7) {  if (B_P>0) ph[4] = HALF_PI; else ph[4] = 3*HALF_PI; }
	  else                {  ph[4] = atan(B_P/A_P);   if (A_P<0) ph[4] += PI; }
	  F[5] = YC_M;
	  if (fabs(A_M)<1e-7) {  if (B_M>0) ph[5] = HALF_PI; else ph[5] = 3*HALF_PI; }
	  else                {  ph[5] = atan(B_M/A_M);   if (A_M<0) ph[5] += PI; }
	}
	else { //sras4d, srasph
	  F[4] = YC_D;
	  if (fabs(A_D)<1e-7) {  if (B_D>0) ph[4] = HALF_PI; else ph[4] = 3*HALF_PI; }
	  else                {  ph[4] = atan2(B_D,A_D);   }
	  F[5] = YCpp;
	  if (fabs(App)<1e-7) {  if (Bpp>0) ph[5] = HALF_PI; else ph[5] = 3*HALF_PI; }
	  else                {  ph[5] = atan2(Bpp,App);   }
	  if ( l->GetDType()=="srasph" )  { F[3]=F[4]; ph[3]=ph[4]; F[4]=F[5]; ph[4]=ph[5]; F[5]=ph[5]=0.; }
	}
  }
  else if ( l->Rice )
  {
	F[0] = YO_rice; 
	F[1] = YC;
	if (fabs(A)<1e-7) {  if (B>0) ph[1] = HALF_PI; else ph[1] = 3*HALF_PI; }
	else              {  ph[1] = atan(B/A);       if (A<0) ph[1] += PI;   }
	if (l->GetDType()=="srasph") {
	  F[1] = sqrt((AH+A)*(AH+A) + (BH+B)*(BH+B));  
	  ph[1] = atan2(BH+B,AH+A);
	}
  }
  l->cov->part[0].D[0][0] = l->cov->part[0].D[1][1] = 1;
  l->cov->part[0].D[0][1] = l->cov->part[0].D[1][0] = D_PAR[1];
    l->cov->part[1].D[0][0] = l->cov->part[1].D[1][1] = 1;
  if ( !l->Rice ) {
	if (l->GetDType()=="sras4d"||l->GetDType()=="srasph") 
	  l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[2];
	else
	  l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[0];
  }
//  else if ( l->Rice )
//	l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[1];// aproximation
  if (l->cov->N_part>2 ) {
	if (l->GetDType()=="sras4d"||l->GetDType()=="srasph") 
	  l->cov->part[2].D[0][1] = l->cov->part[2].D[1][0] = D_PAR[0];
	else if (!l->Rice) 
	  l->cov->part[2].D[0][1] = l->cov->part[2].D[1][0] = D_PAR[2];
	else 
// disabling scaling parameter for sras3d rice
	  l->cov->part[2].D[0][1] = l->cov->part[2].D[1][0] = 1.;
  }
  if (l->cov->N_part>3 && !l->Rice ) 
	l->cov->part[3].D[0][1] = l->cov->part[3].D[1][0] = D_PAR[3];
  if (l->cov->N_part>4 && !l->Rice ) 
	l->cov->part[4].D[0][1] = l->cov->part[4].D[1][0] = D_PAR[4];
  if (l->cov->N_part>5 && !l->Rice ) 
	l->cov->part[5].D[0][1] = l->cov->part[5].D[1][0] = D_PAR[5];
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//cout << "F1,F2,F3,F4,F5,F6: " << F[0] <<" "<<F[1]<<" "<<F[2]<<" "<<F[3]<<" "<<F[4]<<" "<<F[5]<< endl;
//cout << "p1,p2,p3,p4,p5,p6: " << ph[0] <<" "<<ph[1]<<" "<<ph[2]<<" "<<ph[3]<<" "<<ph[4]<<" "<<ph[5]<< endl;
//cout << "SigN1,2,3: "<< l->cov->sigma_N[0]<<" "<<l->cov->sigma_N[1]<<" "<<l->cov->sigma_N[2] << endl;
//cout << "SigP1,2,3: "<< l->cov->part[0].sigma_P[0]<<" "<<l->cov->part[0].sigma_P[1]<<" "<<l->cov->part[0].sigma_P[2] << endl;
//cout << "D1,D2" << l->cov->part[0].D[0][1]<< l->cov->part[1].D[0][1]<< endl;
//cout << "sigma1,2,3: "<< l->cov->sig_meas[0]<< " " << l->cov->sig_meas[1]<<" " <<l->cov->sig_meas[2] <<endl;
}



//extern "C" void siras_dmyfuncdd_ml_( int& ICENT, freal* SIGN, freal* SIGP, freal& SIGN_rice, freal& SIGP_rice, freal* SIGP2, 
//  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& YO, freal& YOP, freal& YOM, freal& A, freal& B, freal& AH, freal& BH,
//  freal& App, freal& Bpp, int& IR, freal& PH, freal* D_PAR, freal* DFDD, 
//  freal& DFDDD11, freal& DFDDD12, freal& DFDDD22, freal& FVALUE, freal& sigp12, freal& sigh, freal& fom, int& ID )
FORTRAN_SUBR( SIRAS_DMYFUNCDD_ML, siras_dmyfuncdd_ml,
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGN_rice, freal* SIGP_rice, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp,
	int* IR, freal* PH, freal* D_PAR, freal* DFDD, freal* DFDDD11, freal* DFDDD12, freal* DFDDD22,
	freal* FVALUE, freal* sigp12, freal* sigh, freal* fom, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGN_rice, freal* SIGP_rice, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp,
	int* IR, freal* PH, freal* D_PAR, freal* DFDD, freal* DFDDD11, freal* DFDDD12, freal* DFDDD22,
	freal* FVALUE, freal* sigp12, freal* sigh, freal* fom, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGN_rice, freal* SIGP_rice, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp,
	int* IR, freal* PH, freal* D_PAR, freal* DFDD, freal* DFDDD11, freal* DFDDD12, freal* DFDDD22,
	freal* FVALUE, freal* sigp12, freal* sigh, freal* fom, int* ID ) )
{
  Type F[6], ph[6];

  likelihood<Type> *lD;
  if (*ID==0) lD=&lD1;
  if (*ID==1) lD=&lD2;
  if (*ID==2) lD=&lD3;
  if (*ID==3) lD=&lD4;

  siras_input_llhood(lD, *ICENT, SIGN, SIGP, *SIGN_rice, *SIGP_rice, SIGP2,
	*SIGO, *SIGOP, *SIGOM, *YO, *YOP, *YOM, *A, *B, *AH, *BH, *App, *Bpp, D_PAR, *sigp12, *sigh, F, ph );

  lD->cov->Make_matrix();
  lD->InverseAndEigen();
//lD->cov->Print();
//lD->PrintInvMat(0);
  int iD[6] = {1, 0, 2, 3, 4, 5};
  if (lD->GetDType()=="sras4d"||lD->GetDType()=="srasph") { iD[0]=2; iD[2]=1; }
  *FVALUE = lD->EvaluateSR( F, ph );
  *fom = lD->GetFOM();
  for ( int i=0;  i<lD->cov->N_part;  i++ ) {	// N_part is equal to number of D par's for SIRAS
	DFDD[i] = lD->GetDer_D(iD[i],0,1);			if ( DFDD[i] > maxa )  DFDD[i] = maxa;		if ( DFDD[i] < -maxa )  DFDD[i] = -maxa;
// looks like it is better to exclude SAD/SIR reflections
    if (lD->cov->GetNumZeroRows()>0 || (lD->GetDType()=="srasph"&&lD->Rice) ) 
      { DFDD[i]=0.;  *FVALUE=0.;   *fom=0.;  }
  }
// disabling scaling parameter for sras3d rice
  if ( lD->GetDType()!="sras4d" && lD->GetDType()!="srasph" && lD->Rice && lD->cov->N_part > 2 ) DFDD[2] = 0.;

//int maxal = 100;
//  for ( int i=0;  i<lD->cov->N_part;  i++ ) { if ( DFDD[i] > maxal || DFDD[i] < -maxal ) { DFDD[0]=DFDD[1]=DFDD[2]=maxa*.5; if (fabs(DFDD[i])>*FVALUE) *FVALUE=fabs(DFDD[i]); } }
  if ( lD->GetDerD() == 2 ) 
  {
	cerr << "Error: Second derivatives wrt D not supported for SIRAS";
    cout << "Error: Second derivatives wrt D not supported for SIRAS";  exit(1);
  }

  bool out = 0;
  int i = -1;
  while ( !out  &&  ++i < lD->Num )
  {
	if ( lD->eigenvalues1[lD->Rice][i] < lD->GetMinEig() ) { /*cout << *IR << " out " << *ICENT << " " << lD->eigenvalues1[lD->Rice][i] <<endl;*/ out = 1; }
  }
  if ( out /*&& l.cent*/ ) { *FVALUE = maxa;   for (int i=0; i<lD->cov->N_part; i++) DFDD[i] = maxa; *DFDDD11 = *DFDDD22 = maxa; *DFDDD12 = 0; }
//  if ( out /*&& l.cent*/ ) { FVALUE = maxa; DFDD2 = 0; DFDD1 = maxa; DFDDD11 = maxa; DFDDD22 = DFDDD12 = 0;  }
}


//extern "C" void siras_dmyfuncdab_ml_( int& ICENT, freal* SIGN, freal* SIGP, freal& SIGN_rice, freal& SIGP_rice, freal* SIGP2,
//  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& YO, freal& YOP, freal& YOM, freal& A, freal& B, freal& AH, freal& BH,
//  freal& App, freal& Bpp, int& IR, freal& PH, freal* D_PAR, freal& DFDA, freal& DFDB, 
//  freal& DFDAA, freal& DFDAB, freal& DFDBB, freal& FVALUE, freal& FOM, freal& PHIB, freal* HL, freal& sigp12, freal& sigh, 
//  freal& DFDAp, freal& DFDBp, freal& DFDApp, freal& DFDBpp, 
//  freal& DFDApAp, freal& DFDBpBp, freal& DFDAppApp, freal& DFDBppBpp, int& phibcalc,
//   int& ID )
FORTRAN_SUBR( SIRAS_DMYFUNCDAB_ML, siras_dmyfuncdab_ml,
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGN_rice, freal* SIGP_rice, freal* SIGP2,
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp, 
	int* IR, freal* PH, freal* D_PAR, freal* DFDA, freal* DFDB, 
	freal* DFDAA, freal* DFDAB, freal* DFDBB, 
	freal* FVALUE, freal* FOM, freal* PHIB, freal* HL, freal* sigp12, freal* sigh, 
	freal* DFDAp, freal* DFDBp, freal* DFDApp, freal* DFDBpp, 
	freal* DFDApAp, freal* DFDBpBp, freal* DFDAppApp, freal* DFDBppBpp, int* phibcalc, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGN_rice, freal* SIGP_rice, freal* SIGP2,
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp, 
	int* IR, freal* PH, freal* D_PAR, freal* DFDA, freal* DFDB, 
	freal* DFDAA, freal* DFDAB, freal* DFDBB, 
	freal* FVALUE, freal* FOM, freal* PHIB, freal* HL, freal* sigp12, freal* sigh, 
	freal* DFDAp, freal* DFDBp, freal* DFDApp, freal* DFDBpp, 
	freal* DFDApAp, freal* DFDBpBp, freal* DFDAppApp, freal* DFDBppBpp, int* phibcalc, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGN_rice, freal* SIGP_rice, freal* SIGP2,
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* YO, freal* YOP, freal* YOM, 
	freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp, 
	int* IR, freal* PH, freal* D_PAR, freal* DFDA, freal* DFDB, 
	freal* DFDAA, freal* DFDAB, freal* DFDBB,  
	freal* FVALUE, freal* FOM, freal* PHIB, freal* HL, freal* sigp12, freal* sigh, 
	freal* DFDAp, freal* DFDBp, freal* DFDApp, freal* DFDBpp, 
	freal* DFDApAp, freal* DFDBpBp, freal* DFDAppApp, freal* DFDBppBpp, int* phibcalc, int* ID ) )
{
//  cout << YO << " " << ABSYC << " " << PHCC << " " << IR << endl;
  *DFDA = *DFDB = *DFDAA = *DFDAB = *DFDBB = *DFDAp = *DFDBp = *DFDApp = *DFDBpp =
	      *DFDApAp = *DFDBpBp = *DFDAppApp = *DFDBppBpp = 0.;

  Type F[6], ph[6];
  *PHIB=-1000.;
  *FOM=*FVALUE=0.;

  likelihood<Type> *lF;
  if (*ID==0) lF=&lF1;
  if (*ID==1) lF=&lF2;
  if (*ID==2) lF=&lF3;
  if (*ID==3) lF=&lF4;

  freal DPAR[6] = { D_PAR[0], D_PAR[1] };
  if ( lF->cov->N_part > 2 ) 	DPAR[2]=D_PAR[2];
  if ( lF->cov->N_part > 3 ) 	DPAR[3]=D_PAR[3];
  if ( lF->cov->N_part > 4 ) 	DPAR[4]=D_PAR[4];
  if ( lF->cov->N_part > 5 ) 	DPAR[5]=D_PAR[5];
  bool out = 1;

  int out_count = 0, max_count=10;
  while ( out && ( DPAR[0]>0.1 || DPAR[1]>0.1 || DPAR[0]==D_PAR[0] ) && out_count<max_count )
  {
	siras_input_llhood(lF, *ICENT, SIGN, SIGP, *SIGN_rice, *SIGP_rice, SIGP2,
	  *SIGO, *SIGOP, *SIGOM, *YO, *YOP, *YOM, *A, *B, *AH, *BH, *App, *Bpp, DPAR, *sigp12, *sigh, F, ph );
  
	lF->SetMaxPoints(2000);
//	lF->SetMaxPoints(1000000);
	if (*phibcalc >= 0) lF->SetMaxPoints(10000000);
	if (*phibcalc >= 0) lF->SetImproveInteg(3);
	if (*phibcalc >= 0) lF->SetSaferNumPoints(3);
	lF->SetNum4PHIB(*phibcalc);
	if ( *phibcalc == 0 && lF->cov->CheckZeroRow(0) ) lF->SetNum4PHIB(1);
	lF->SetCalcHL(*phibcalc+1);
	lF->cov->Make_matrix();	
	lF->InverseAndEigen();  
//FVALUE=lF->EvaluateSR( F, ph );  double dD1=lF->GetDer_D(0,0,1); double dD2=lF->GetDer_D(1,0,1); double dD3=0; if ( lF->GetDType() == "sras3d" || lF->GetDType() == "SRAS3D" ) 	 dD3=lF->GetDer_D(2,0,1);
//	lF->PrintEigenv(0);
	out = 0;                                      
//if (fabs(dD1>100)||fabs(dD2>100)||fabs(dD3>100)) { cout << IR << " D out " << dD1 << " " << dD2 << " " << dD3 << endl; out=1; }
	int i = -1;
	while ( !out  &&  ++i < lF->Num )
	  if ( lF->eigenvalues1[lF->Rice][i] < lF->GetMinEig() ) 
		{ cout << *IR << " out " << lF->eigenvalues1[lF->Rice][i] <<" "<< lF->Rice <<" "<< DPAR[0]<<" "<< DPAR[1] << " "<< DPAR[2]<<endl; cout.flush();out = 1; lF->cov->Print(); }
	if (!out) {
	  *FVALUE = lF->EvaluateSR( F, ph );
// this is to save some time - and possibly detect instabilities
	  if (*FVALUE<0)  { cout << *IR << " points out " << -*FVALUE << endl; out = 1; }
	}
	if ( out ) 
	{
	  if (lF->GetDType()!="sras4d"&&lF->GetDType()!="srasph") DPAR[0]  *= 0.98;
	  DPAR[1]  *= 0.98;
	  if ( lF->cov->N_part > 2 )  DPAR[2] *=0.98;
	  if ( lF->cov->N_part > 3 )  DPAR[3] *=0.98;
	  if ( lF->cov->N_part > 4 )  DPAR[4] *=0.98;
	  out_count++;
	}
	if ( out && !lF->Rice && ( DPAR[0]<0.12 && DPAR[1]<0.12 ) ) *ICENT = 2; // problem with pos. def. of matrix - using Rice
// should probably implement the use of Rice here...
  }
  if ( out_count>=max_count )   *FVALUE=1000;
  
  int Nm1 = lF->Num - 3;
  if (lF->Rice) Nm1 = 1;

  Type F_Nm1 = F[Nm1];
  Type Fsq1 = F_Nm1*F_Nm1;
  Type dF_dA1=0., dF_dB1=0., dph_dA1=0., dph_dB1=0., F_Nm1_inv=0., Fsq1_inv=0.;
  if ( F_Nm1>1e-7 && !lF->cov->CheckZeroRow(Nm1) ) {
    dF_dA1 = *A/F_Nm1;
    dF_dB1 = *B/F_Nm1;
    dph_dA1 = - *B/F_Nm1/F_Nm1;
    dph_dB1 = *A/F_Nm1/F_Nm1;
    F_Nm1_inv = 1/F_Nm1;
    Fsq1_inv = F_Nm1_inv*F_Nm1_inv;
    if (lF->GetDType()=="srasph"&&!lF->Rice) { dF_dA1 = dF_dB1 = dph_dA1 = dph_dB1 = F_Nm1_inv = Fsq1_inv = 0.; }
  }

//  FVALUE = lF->EvaluateSR( F, ph );
/*////
  cout << "refl., cent.:" << IR << " " << ICENT << " " <<  endl;
  lF->cov->Print();
  lF->PrintInvMat(0);
  double w[3][6],Wc[3]={0,0,0},Ws[3]={0,0,0},W[3],phi[3];
  for (int j=0; j<3; j++)
  {
	for (int i=j+1; i<6; i++)
	{
	  w[j][i] = 2*F[i]*F[j]*lD->a[j][i];
	  if (i>2) {
		Wc[j] += w[j][i]*cos(ph[i]);
		Ws[j] += w[j][i]*sin(ph[i]);
	  }
	}
	W[j] = sqrt(Wc[j]*Wc[j]+Ws[j]*Ws[j]);
	if ( W[j] != 0. )  phi[j] = acos(Wc[j]/W[j]);
	if ( Ws[j] < 0. )  phi[j] *= -1;
  }
  cout << "W's: " << W[0] << " " << W[1] << " "  << W[2] << endl;
  cout << "phi's: " << phi[0] << " " << phi[1] << " "  << phi[2] << endl;
  cout << "w's: " << w[0][1] << " " << w[0][2] << " "  << w[1][2] << endl;
  cout << "fvalue - der's wrt F - der's wrt ph: " << FVALUE << " - ";
  cout << lF->GetDer_F(3) << " " << lF->GetDer_F(4) << " " << lF->GetDer_F(5) << " - " << lF->GetDer_ph(3) << " " << lF->GetDer_ph(4) <<" " << lF->GetDer_ph(5) << endl;
*/////
//  cout << lF->GetDer_F(3) << " " << lF->GetDer_F(4) << " " << lF->GetDer_F(5) << " - " << lF->GetDer_ph(3) << " " << lF->GetDer_ph(4) <<" " << lF->GetDer_ph(5) << endl;
  Type DFDAN = lF->GetDer_F(Nm1)*dF_dA1 + lF->GetDer_ph(Nm1)*dph_dA1;
  Type DFDBN = lF->GetDer_F(Nm1)*dF_dB1 + lF->GetDer_ph(Nm1)*dph_dB1;
  Type DFDANAN=0, DFDANBN=0, DFDBNBN=0;
  if ( lF->GetDerF() == 2 ) 
  {
	DFDANAN = lF->GetDer2_FF(Nm1,Nm1)*dF_dA1*dF_dA1 + 2*lF->GetDer2_phF(Nm1,Nm1)*dF_dA1*dph_dA1 + 
  	  lF->GetDer2_phph(Nm1,Nm1)*dph_dA1*dph_dA1 
  	  + lF->GetDer_F(Nm1)*(*B)*(*B)*Fsq1_inv*F_Nm1_inv + lF->GetDer_ph(Nm1)*2*(*A)*(*B)*Fsq1_inv*Fsq1_inv ;
	DFDANBN = lF->GetDer2_FF(Nm1,Nm1)*dF_dA1*dF_dB1 + lF->GetDer2_phF(Nm1,Nm1)*(dF_dA1*dph_dB1+dF_dB1*dph_dA1) + 
  	  lF->GetDer2_phph(Nm1,Nm1)*dph_dA1*dph_dB1 
  	  - lF->GetDer_F(Nm1)*(*A)*(*B)*Fsq1_inv*F_Nm1_inv + lF->GetDer_ph(Nm1)*((*B)*(*B)-(*A)*(*A))*Fsq1_inv*Fsq1_inv;
	DFDBNBN = lF->GetDer2_FF(Nm1,Nm1)*dF_dB1*dF_dB1 + 2*lF->GetDer2_phF(Nm1,Nm1)*dF_dB1*dph_dB1 + 
  	  lF->GetDer2_phph(Nm1,Nm1)*dph_dB1*dph_dB1 
  	  + lF->GetDer_F(Nm1)*(*A)*(*A)*Fsq1_inv*F_Nm1_inv - lF->GetDer_ph(Nm1)*2*(*A)*(*B)*Fsq1_inv*Fsq1_inv;
  }

  if ( lF->Rice ) 
  {
    if (lF->GetDType()=="srasph") 
    {
      *DFDA = *DFDB = *DFDAA = *DFDAB = *DFDBB = 0.;    *FVALUE=0.; *FOM=0.; 
    } else 
    {
      *DFDA = DFDAN;
      *DFDB = DFDBN;
      *DFDAA = DFDANAN;
      *DFDAB = DFDANBN;
      *DFDBB = DFDBNBN;
    }
    *DFDAp = *DFDBp = *DFDApp = *DFDBpp = 0.;
    *DFDApAp = *DFDBpBp = *DFDAppApp = *DFDBppBpp = 0.;
  }
  else
  {
	Type A_P, B_P;
  	if (lF->GetDType()=="sras"||lF->GetDType()=="sras3d") {
  	  A_P = *A+*AH+*App, B_P = *B+*BH+*Bpp;
  	}
  	else { //sras4d, srasph
//!!!!!!!!!!!
//  	  A_P = /**A+*/*AH, B_P = /**B+*/*BH;
//  	  A_P = *A/*+*AH*/, B_P = *B/*+*BH*/;
    	  A_P = *A+*AH, B_P = *B+*BH;
  	}
	int Nm2 = Nm1+1;


	Type Fsq2 = F[Nm2]*F[Nm2];
	Type dF_dA2=0., dF_dB2=0., dph_dA2=0., dph_dB2=0., F_Nm2_inv=0., Fsq2_inv=0.;

    if ( F[Nm2]>1e-7 && !lF->cov->CheckZeroRow(Nm2) ) {
	  dF_dA2 = A_P/F[Nm2];
	  dF_dB2 = B_P/F[Nm2];
	  dph_dA2 = - B_P/Fsq2;
	  dph_dB2 = A_P/Fsq2;
      F_Nm2_inv = 1/F[Nm2];
      Fsq2_inv = F_Nm2_inv*F_Nm2_inv;
	}
	
	Type DFDAP = lF->GetDer_F(Nm2)*dF_dA2 + lF->GetDer_ph(Nm2)*dph_dA2;
	Type DFDBP = lF->GetDer_F(Nm2)*dF_dB2 + lF->GetDer_ph(Nm2)*dph_dB2;  

	Type DFDAPAP=0, DFDAPBP=0, DFDBPBP=0,   DFDANAP=0,DFDANBP=0,DFDAPBN=0,DFDBNBP=0;
	if ( lF->GetDerF() == 2 ) 
	{
	  DFDAPAP = lF->GetDer2_FF(Nm2,Nm2)*dF_dA2*dF_dA2 + 2*lF->GetDer2_phF(Nm2,Nm2)*dF_dA2*dph_dA2 + 
  		lF->GetDer2_phph(Nm2,Nm2)*dph_dA2*dph_dA2 
  		+ lF->GetDer_F(Nm2)*B_P*B_P*Fsq2_inv*F_Nm2_inv + lF->GetDer_ph(Nm2)*2*A_P*B_P*Fsq2_inv*Fsq2_inv ;
	  DFDAPBP = lF->GetDer2_FF(Nm2,Nm2)*dF_dA2*dF_dB2 + lF->GetDer2_phF(Nm2,Nm2)*(dF_dA2*dph_dB2+dF_dB2*dph_dA2) + 
  		lF->GetDer2_phph(Nm2,Nm2)*dph_dA2*dph_dB2 
  		- lF->GetDer_F(Nm2)*A_P*B_P*Fsq2_inv*F_Nm2_inv + lF->GetDer_ph(Nm2)*(B_P*B_P-A_P*A_P)*Fsq2_inv*Fsq2_inv;
	  DFDBPBP = lF->GetDer2_FF(Nm2,Nm2)*dF_dB2*dF_dB2 + 2*lF->GetDer2_phF(Nm2,Nm2)*dF_dB2*dph_dB2 + 
  		lF->GetDer2_phph(Nm2,Nm2)*dph_dB2*dph_dB2 
  		+ lF->GetDer_F(Nm2)*A_P*A_P*Fsq2_inv*F_Nm2_inv - lF->GetDer_ph(Nm2)*2*A_P*B_P*Fsq2_inv*Fsq2_inv;

	  DFDANAP = lF->GetDer2_FF(Nm2,Nm1)*dF_dA2*dF_dA1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dA1*dph_dA2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dA2*dph_dA1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dA2*dph_dA1;
	  DFDANBP = lF->GetDer2_FF(Nm2,Nm1)*dF_dB2*dF_dA1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dA1*dph_dB2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dB2*dph_dA1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dB2*dph_dA1;
	  DFDAPBN = lF->GetDer2_FF(Nm2,Nm1)*dF_dA2*dF_dB1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dB1*dph_dA2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dA2*dph_dB1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dA2*dph_dB1;
	  DFDBNBP = lF->GetDer2_FF(Nm2,Nm1)*dF_dB2*dF_dB1 + lF->GetDer2_phF(Nm2,Nm1)*dF_dB1*dph_dB2 +
		lF->GetDer2_phF(Nm1,Nm2)*dF_dB2*dph_dB1 + lF->GetDer2_phph(Nm2,Nm1)*dph_dB2*dph_dB1;
	}

	Type A_M, B_M;
  	if (lF->GetDType()=="sras"||lF->GetDType()=="sras3d") {
  	  A_M = *A+*AH-*App, B_M = *B+*BH-*Bpp;
  	}
  	else { //sras4d
  	  A_M = *App, B_M = *Bpp;
  	}
	int Nm3 = Nm2+1;

	Type Fsq3 = F[Nm3]*F[Nm3];
	Type dF_dA3=0., dF_dB3=0., dph_dA3=0., dph_dB3=0., F_Nm3_inv=0., Fsq3_inv=0.;

	if ( F[Nm3]>1e-7 && !lF->cov->CheckZeroRow(Nm3) ) {
	  dF_dA3 = A_M/F[Nm3];
	  dF_dB3 = B_M/F[Nm3];
	  dph_dA3 = - B_M/Fsq3;
	  dph_dB3 = A_M/Fsq3;
      F_Nm3_inv = 1/F[Nm3];
      Fsq3_inv = F_Nm3_inv*F_Nm3_inv;
	}

	Type DFDAM = lF->GetDer_F(Nm3)*dF_dA3 + lF->GetDer_ph(Nm3)*dph_dA3;
	Type DFDBM = lF->GetDer_F(Nm3)*dF_dB3 + lF->GetDer_ph(Nm3)*dph_dB3;  

	Type DFDAMAM=0, DFDAMBM=0, DFDBMBM=0,   DFDANAM=0,DFDANBM=0,DFDAMBN=0,DFDBNBM=0, DFDAPAM=0,DFDAPBM=0,DFDAMBP=0,DFDBPBM=0;
	if ( lF->GetDerF() == 2 ) 
	{
	  DFDAMAM = lF->GetDer2_FF(Nm3,Nm3)*dF_dA3*dF_dA3 + 2*lF->GetDer2_phF(Nm3,Nm3)*dF_dA3*dph_dA3 + 
  		lF->GetDer2_phph(Nm3,Nm3)*dph_dA3*dph_dA3 
  		+ lF->GetDer_F(Nm3)*B_M*B_M*Fsq3_inv*F_Nm3_inv + lF->GetDer_ph(Nm3)*2*A_M*B_M*Fsq3_inv*Fsq3_inv ;
	  DFDAMBM = lF->GetDer2_FF(Nm3,Nm3)*dF_dA3*dF_dB3 + lF->GetDer2_phF(Nm3,Nm3)*(dF_dA3*dph_dB3+dF_dB3*dph_dA3) + 
  		lF->GetDer2_phph(Nm3,Nm3)*dph_dA3*dph_dB3 
  		- lF->GetDer_F(Nm3)*A_M*B_M*Fsq3_inv*F_Nm3_inv + lF->GetDer_ph(Nm3)*(B_M*B_M-A_M*A_M)*Fsq3_inv*Fsq3_inv;
	  DFDBMBM = lF->GetDer2_FF(Nm3,Nm3)*dF_dB3*dF_dB3 + 2*lF->GetDer2_phF(Nm3,Nm3)*dF_dB3*dph_dB3 + 
  		lF->GetDer2_phph(Nm3,Nm3)*dph_dB3*dph_dB3 
  		+ lF->GetDer_F(Nm3)*A_M*A_M*Fsq3_inv*F_Nm3_inv - lF->GetDer_ph(Nm3)*2*A_M*B_M*Fsq3_inv*Fsq3_inv;

	  DFDANAM = lF->GetDer2_FF(Nm3,Nm1)*dF_dA3*dF_dA1 + lF->GetDer2_phF(Nm3,Nm1)*dF_dA1*dph_dA3 +
		lF->GetDer2_phF(Nm1,Nm3)*dF_dA3*dph_dA1 + lF->GetDer2_phph(Nm3,Nm1)*dph_dA3*dph_dA1;
	  DFDANBM = lF->GetDer2_FF(Nm3,Nm1)*dF_dB3*dF_dA1 + lF->GetDer2_phF(Nm3,Nm1)*dF_dA1*dph_dB3 +
		lF->GetDer2_phF(Nm1,Nm3)*dF_dB3*dph_dA1 + lF->GetDer2_phph(Nm3,Nm1)*dph_dB3*dph_dA1;
	  DFDAMBN = lF->GetDer2_FF(Nm3,Nm1)*dF_dA3*dF_dB1 + lF->GetDer2_phF(Nm3,Nm1)*dF_dB1*dph_dA3 +
		lF->GetDer2_phF(Nm1,Nm3)*dF_dA3*dph_dB1 + lF->GetDer2_phph(Nm3,Nm1)*dph_dA3*dph_dB1;
	  DFDBNBM = lF->GetDer2_FF(Nm3,Nm1)*dF_dB3*dF_dB1 + lF->GetDer2_phF(Nm3,Nm1)*dF_dB1*dph_dB3 +
		lF->GetDer2_phF(Nm1,Nm3)*dF_dB3*dph_dB1 + lF->GetDer2_phph(Nm3,Nm1)*dph_dB3*dph_dB1;

	  DFDAPAM = lF->GetDer2_FF(Nm3,Nm2)*dF_dA3*dF_dA2 + lF->GetDer2_phF(Nm3,Nm2)*dF_dA2*dph_dA3 +
		lF->GetDer2_phF(Nm2,Nm3)*dF_dA3*dph_dA2 + lF->GetDer2_phph(Nm3,Nm2)*dph_dA3*dph_dA2;
	  DFDAPBM = lF->GetDer2_FF(Nm3,Nm2)*dF_dB3*dF_dA2 + lF->GetDer2_phF(Nm3,Nm2)*dF_dA2*dph_dB3 +
		lF->GetDer2_phF(Nm2,Nm3)*dF_dB3*dph_dA2 + lF->GetDer2_phph(Nm3,Nm2)*dph_dB3*dph_dA2;
	  DFDAMBP = lF->GetDer2_FF(Nm3,Nm2)*dF_dA3*dF_dB2 + lF->GetDer2_phF(Nm3,Nm2)*dF_dB2*dph_dA3 +
		lF->GetDer2_phF(Nm2,Nm3)*dF_dA3*dph_dB2 + lF->GetDer2_phph(Nm3,Nm2)*dph_dA3*dph_dB2;
	  DFDBPBM = lF->GetDer2_FF(Nm3,Nm2)*dF_dB3*dF_dB2 + lF->GetDer2_phF(Nm3,Nm2)*dF_dB2*dph_dB3 +
		lF->GetDer2_phF(Nm2,Nm3)*dF_dB3*dph_dB2 + lF->GetDer2_phph(Nm3,Nm2)*dph_dB3*dph_dB2;
	}

	Type DFDANAD=0, DFDANBD=0, DFDADBN=0, DFDBNBD=0, DFDADAD=0, DFDADBD=0, DFDBDBD=0;

  	if (lF->GetDType()=="sras"||lF->GetDType()=="sras3d") {
	  *DFDA = (DFDAN + DFDAP + DFDAM);
	  *DFDB = (DFDBN + DFDBP + DFDBM);
//	DFDA = DFDAN;
//	DFDB = DFDBN;
	  *DFDAA = (DFDANAN + DFDAPAP + DFDAMAM + 2*DFDANAP + 2*DFDANAM + 2*DFDAPAM );
//	DFDAB = (DFDANBN + DFDAPBP + DFDAMBM + DFDANBP + DFDAPBN + DFDANBM + DFDAMBN + DFDAPBM + DFDAMBP);
	  *DFDBB = (DFDBNBN + DFDBPBP + DFDBMBM + 2*DFDBNBP + 2*DFDBNBM + 2*DFDBPBM );

	  *DFDAp = DFDAP + DFDAM;
	  *DFDBp = DFDBP + DFDBM;
  	  *DFDApp = DFDAP - DFDAM;
	  *DFDBpp = DFDBP - DFDBM;
//	  cout << "wwwww "<<DFDAp <<" "<<DFDBp<<" " <<DFDApp<<" "<<DFDBpp<<endl; cout.flush();
	
	  *DFDApAp = DFDAPAP + DFDAMAM + 2*DFDAPAM;
//	DFDApBp = DFDAPBP + DFDAMBM + DFDAPBM + DFDAMBP;
	  *DFDBpBp = DFDBPBP + DFDBMBM + 2*DFDBPBM;
	  *DFDAppApp = DFDAPAP - 2*DFDAPAM + DFDAMAM;
//	DFDAppBpp = DFDAPBP - DFDAPBM - DFDAMBP + DFDAMBM;
	  *DFDBppBpp = DFDBPBP - 2*DFDBPBM + DFDBMBM;
//	DFDAApp = DFDAPAP - DFDAMAM;
//	DFDBBpp = DFDBPBP - DFDBMBM;
//	DFDABpp = DFDAPBP + DFDAMBP - DFDAPBM - DFDAMBM;
//	DFDAppB = DFDAPBP + DFDAPBM - DFDAMBP - DFDAMBM;

//	DFDAAh = DFDADAD + DFDANAD;
//	DFDBBh = DFDBDBD + DFDBNBD;
//	DFDABh = DFDANBD + DFDADBD;
//	DFDAhB = DFDADBN + DFDADBD;
//cout << "dddd " <<DFDA << " " << DFDB << " " << DFDAA << " " <<  DFDBB << endl;
	}
	else { //sras4d, srasph
// looks like that it is better to exclude SAD/SIR reflections?
	  if (lF->cov->GetNumZeroRows()<=0||lF->GetDType()!="srasph") { 
//!!!!!!!!!!!
//        if ( (DFDAN!=0.||DFDBN!=0.) && (DFDAP!=0.||DFDBP!=0.) ) {
		  *DFDA = (DFDAN + DFDAP);
		  *DFDB = (DFDBN + DFDBP);
		  *DFDAA = (DFDANAN + DFDAPAP + 2*DFDANAP );
		  *DFDBB = (DFDBNBN + DFDBPBP + 2*DFDBNBP );
//        }
//	  	*DFDA = ( DFDAP);
//	  	*DFDB = ( DFDBP);
//	  	*DFDAA = ( DFDAPAP  );
//	  	*DFDBB = ( DFDBPBP  );
//	  	*DFDA = (DFDAN + DPAR[1]*DFDAP );
//	  	*DFDB = (DFDBN + DPAR[1]*DFDBP );
//	  	*DFDAA = (DFDANAN + DPAR[1]*DPAR[1]*DFDAPAP + DPAR[1]*2*DFDANAP );
//	  	*DFDBB = (DFDBNBN + DPAR[1]*DPAR[1]*DFDBPBP + DPAR[1]*2*DFDBNBP );

		*DFDAp = DFDAP ;
		*DFDBp = DFDBP ;
		*DFDApAp = DFDAPAP;
		*DFDBpBp = DFDBPBP;

  		*DFDApp = DFDAM;
		*DFDBpp = DFDBM;
		*DFDAppApp = DFDAMAM;
		*DFDBppBpp = DFDBMBM;
	  }
//	  cout <<"4d derivs: "<< DFDA << " " << DFDB << " " << DFDAA << "   " << DFDAp <<" "<<DFDBp<<" "<<DFDApp<<" "<<DFDBpp<<" "<<DFDApAp<<" "<<DFDAppApp << " "<<DFDBppBpp << endl;
	}

//cout << "fval,derF123,derp1:" <<FVALUE << " " << lF->GetDer_F(Nm1) << "  " << lF->GetDer_F(Nm2) << "  "<< lF->GetDer_F(Nm3) << " " << lF->GetDer_ph(Nm1) << endl;

  }
  
  if ( *DFDA > maxa )  *DFDA = maxa;		if ( *DFDA < -maxa )  *DFDA = - maxa;
  if ( *DFDB > maxa )  *DFDB = maxa;		if ( *DFDB < -maxa )  *DFDB = - maxa;
//  if ( *DFDAA > maxa )  *DFDAA = maxa;		if ( *DFDAA < -maxa )  *DFDAA = - maxa;
//  if ( *DFDAB > maxa )  *DFDAB = maxa;		if ( *DFDAB < -maxa )  *DFDAB = - maxa;
//  if ( *DFDBB > maxa )  *DFDBB = maxa;		if ( *DFDBB < -maxa )  *DFDBB = - maxa;

  if ( lF->GetDType()!="srasph" || !lF->Rice )
  {
    *FOM = lF->GetFOM();
    *PHIB = lF->GetPHIB();
    if (*phibcalc >= 0) {
	  HL[0] = lF->GetHLA();
	  HL[1] = lF->GetHLB();
	  HL[2] = lF->GetHLC();
	  HL[3] = lF->GetHLD();
    }
// if SIRAS is used also for centrics (probably 4 should be used for model building and 3 for phasing?)
//  int Nm2=4;  
//  if (lF->GetDType()=="srasph") Nm2=3;
    int Nm2=3;  
    if (lF->Rice) Nm2=1;
    if ( *phibcalc >= 0 && *ICENT ) 
      if ( lF->tab->Cos(*PHIB - ph[Nm2]) >= 0. )  *PHIB = ph[Nm2];
      else *PHIB = ph[Nm2] + PI;
  }
  
  if ( out /*&& l.cent*/ ) *FVALUE = maxa;
//  if (*phibcalc >= 0 && lF->Rice && lF->GetDType()=="srasph") *PHIB = -1000.;
}



// ***************MAD  PART******************



inline void mad_input_llhood( likelihood<Type>* l, int& ICENT, freal* SIGN, freal* SIGP, freal* SIGP2,
  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& SIGOP2, freal& SIGOM2, freal& YO, freal& YOP, freal& YOM, 
  freal& YOP2, freal& YOM2, freal& A, freal& B, freal& AH, freal& BH, freal& App, freal& Bpp, freal& AH2, 
  freal& BH2, freal& App2, freal& Bpp2, freal* D_PAR, freal& sigp12, freal& sigh, Type* F, Type* ph )
{
// only RICE or MAD for the moment - add SAD possibilities maybe?
  int rice = 0;
  if ( YOP<=0 || SIGOP <=0 || YOM<=0 || SIGOM<=0 || YOP2<=0 || YOM2<=0 || SIGOP2<=0 || SIGOM2<=0 || ICENT == 2 ) rice = 1; 
  l->SetCentRice(ICENT,rice);
//  l->cov->no_imag = 1;
  if (!rice)
  {
	for ( int i=0; i<6; i++ ) {
	  l->cov->sigma_N[i] = SIGN[i];
	  l->cov->part[0].sigma_P[i] = SIGP[i] ;
	}
	l->cov->sig_meas[0] = SIGOP;
	l->cov->sig_meas[1] = SIGOM;
	l->cov->sig_meas[2] = SIGOP2;
	l->cov->sig_meas[3] = SIGOM2;
  }
  else
  {
	l->cov->sigma_N[0] = SIGN[0]; 
	l->cov->part[0].sigma_P[0] = SIGP[0];// + SIGP2[0] + 2*sigp12;
	l->cov->sig_meas[0] = SIGO;
  }

  if ( !l->Rice )
  {
	Type A_P = A+AH+App, B_P = B+BH+Bpp;
	Type A_M = A+AH-App, B_M = B+BH-Bpp;
	Type A_P2 = A+AH2+App2, B_P2 = B+BH2+Bpp2;
	Type A_M2 = A+AH2-App2, B_M2 = B+BH2-Bpp2;
	Type YC_P = sqrt( A_P*A_P + B_P*B_P );
	Type YC_M = sqrt( A_M*A_M + B_M*B_M );
	Type YC_P2 = sqrt( A_P2*A_P2 + B_P2*B_P2 );
	Type YC_M2 = sqrt( A_M2*A_M2 + B_M2*B_M2 );
//  cout << "see:" << ICENT << " "<< sqrt(A*A+B*B) << "   " << F[2] << " " << F[3] << "    " << F[0] << " " << F[1] << endl;
	F[0] = YOP;
	F[1] = YOM;
	F[2] = YOP2;
	F[3] = YOM2;
	ph[0] = ph[1] = ph[2] = ph[3] = 0.; 
	F[4] = YC_P;
	ph[4] = atan(B_P/A_P);      if (A_P<0) ph[4] += PI;
	F[5] = YC_M;
	ph[5] = atan(B_M/A_M);   	if (A_M<0) ph[5] += PI;
	F[6] = YC_P2;
	ph[6] = atan(B_P2/A_P2);   if (A_P2<0) ph[6] += PI;
	F[7] = YC_M2;
	ph[7] = atan(B_M2/A_M2);   if (A_M2<0) ph[7] += PI;
  }
  else if ( l->Rice )
  {
	F[0] = YO; 
	F[1] = sqrt( A*A + B*B );
	ph[1] = atan(B/A);
	if (A<0) ph[1] += PI;
  }
  l->cov->part[0].D[0][0] = l->cov->part[0].D[1][1] = 1;
  l->cov->part[0].D[0][1] = l->cov->part[0].D[1][0] = D_PAR[1];
//  if ( !l->Rice )
//	l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[0];
//  else if ( l->Rice )
//	l->cov->part[1].D[0][1] = l->cov->part[1].D[1][0] = D_PAR[1];// aproximation

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//cout << "F1,F2,F3,F4,F5,F6: " << F[0] <<" "<<F[1]<<" "<<F[2]<<" "<<F[3]<<" "<<F[4]<<" "<<F[5]<< endl;
//cout << "p1,p2,p3,p4,p5,p6: " << ph[0] <<" "<<ph[1]<<" "<<ph[2]<<" "<<ph[3]<<" "<<ph[4]<<" "<<ph[5]<< endl;
//cout << "SigN1,2,3: "<< l->cov->sigma_N[0]<<" "<<l->cov->sigma_N[1]<<" "<<l->cov->sigma_N[2] << endl;
//cout << "SigP1,2,3: "<< l->cov->part[0].sigma_P[0]<<" "<<l->cov->part[0].sigma_P[1]<<" "<<l->cov->part[0].sigma_P[2] << endl;
//cout << "D1,D2" << l->cov->part[0].D[0][1]<< l->cov->part[1].D[0][1]<< endl;
//cout << "sigma1,2,3: "<< l->cov->sig_meas[0]<< " " << l->cov->sig_meas[1]<<" " <<l->cov->sig_meas[2] <<endl;
}


//extern "C" void mad_dmyfuncdd_ml_( int& ICENT, freal* SIGN, freal* SIGP, freal* SIGP2, 
//  freal& SIGO, freal& SIGOP, freal& SIGOM, freal& SIGOP2, freal& SIGOM2, freal& YO, freal& YOP, freal& YOM, 
//  freal& YOP2, freal& YOM2, freal& A, freal& B, freal& AH, freal& BH, freal& App, freal& Bpp, freal& AH2, 
//  freal& BH2, freal& App2, freal& Bpp2, int& IR, freal& PH, freal* D_PAR, freal* DFDD, 
//  freal& DFDDD11, freal& DFDDD12, freal& DFDDD22, freal& FVALUE, freal& sigp12, freal& sigh, freal& fom, int& ID )
FORTRAN_SUBR( MAD_DMYFUNCDD_ML, mad_dmyfuncdd_ml,
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* SIGOP2, freal* SIGOM2, freal* YO, freal* YOP, freal* YOM, 
	freal* YOP2, freal* YOM2, freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp, freal* AH2, 
	freal* BH2, freal* App2, freal* Bpp2, int* IR, freal* PH, freal* D_PAR, freal* DFDD, 
	freal* DFDDD11, freal* DFDDD12, freal* DFDDD22, freal* FVALUE, freal* sigp12, freal* sigh, freal* fom, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* SIGOP2, freal* SIGOM2, freal* YO, freal* YOP, freal* YOM, 
	freal* YOP2, freal* YOM2, freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp, freal* AH2, 
	freal* BH2, freal* App2, freal* Bpp2, int* IR, freal* PH, freal* D_PAR, freal* DFDD, 
	freal* DFDDD11, freal* DFDDD12, freal* DFDDD22, freal* FVALUE, freal* sigp12, freal* sigh, freal* fom, int* ID ),
  ( int* ICENT, freal* SIGN, freal* SIGP, freal* SIGP2, 
	freal* SIGO, freal* SIGOP, freal* SIGOM, freal* SIGOP2, freal* SIGOM2, freal* YO, freal* YOP, freal* YOM, 
	freal* YOP2, freal* YOM2, freal* A, freal* B, freal* AH, freal* BH, freal* App, freal* Bpp, freal* AH2, 
	freal* BH2, freal* App2, freal* Bpp2, int* IR, freal* PH, freal* D_PAR, freal* DFDD, 
	freal* DFDDD11, freal* DFDDD12, freal* DFDDD22, freal* FVALUE, freal* sigp12, freal* sigh, freal* fom, int* ID ) )
{
  Type F[8], ph[8];

  likelihood<Type> *lD;
  if (*ID==0) lD=&lD1;
  if (*ID==1) lD=&lD2;
  if (*ID==2) lD=&lD3;
  if (*ID==3) lD=&lD4;

  mad_input_llhood( lD, *ICENT, SIGN, SIGP, SIGP2,  *SIGO, *SIGOP, *SIGOM, *SIGOP2, *SIGOM2,
	 *YO, *YOP, *YOM, *YOP2, *YOM2, *A, *B, *AH, *BH, *App, *Bpp, *AH2, *BH2, *App2, *Bpp2, D_PAR, *sigp12, *sigh, F, ph );

  lD->cov->Make_matrix();
//lD->cov->Print();
  lD->InverseAndEigen();
//lD->cov->Print();
//lD->PrintInvMat(0);

for (int i=0; i<lD->Num; i++)  cout << lD->eigenvalues1[lD->Rice][i] << " "; cout << endl;
  double w[4][8],Wc[4]={0,0,0},Ws[4]={0,0,0},W[4],phi[4];
  for (int j=0; j<4; j++)
  {
	for (int i=j+1; i<8; i++)
	{
	  w[j][i] = 2*F[i]*F[j]*lD->a[j][i];
	  if (i>3) {
		Wc[j] += w[j][i]*cos(ph[i]);
		Ws[j] += w[j][i]*sin(ph[i]);
	  }
	}
	W[j] = sqrt(Wc[j]*Wc[j]+Ws[j]*Ws[j]);
	if ( W[j] != 0. )  phi[j] = acos(Wc[j]/W[j]);
	if ( Ws[j] < 0. )  phi[j] *= -1;
  }
  cout << "W's: " << W[0] << " " << W[1] << " "  << W[2] << " " << W[3] << endl;
  cout << "phi's: " << phi[0] << " " << phi[1] << " "  << phi[2] << " "  << phi[3] << endl;
  cout << "w's: " << w[0][1] <<" "<< w[0][2] <<" "<< w[0][3] <<" "<< w[1][2] <<" "<< w[1][3] <<" "<< w[2][3] << endl;

//temporary disabled!!!!!!!!!!
//  FVALUE = lD->EvaluateSR( F, ph );
  *fom = lD->GetFOM();
  DFDD[1] = lD->GetDer_D(0,0,1);			if ( DFDD[1] > maxa )  DFDD[1] = maxa;		if ( DFDD[1] < -maxa )  DFDD[1] = -maxa;
  if ( lD->GetDerD() == 2 ) 
  {
	cerr << "Error: Second derivatives wrt D not supported for MAD";
    cout << "Error: Second derivatives wrt D not supported for MAD";  exit(1);
  }

  bool out = 0;
  int i = -1;
  while ( !out  &&  ++i < lD->Num )
  {
	if ( lD->eigenvalues1[lD->Rice][i] < lD->GetMinEig() ) { /*cout << IR << " out " << ICENT << " " << lD->eigenvalues1[lD->Rice][i] <<endl;*/ out = 1; }
  }
  if ( out /*&& l.cent*/ ) { *FVALUE = maxa;   for (int i=0; i<lD->cov->N_part; i++) DFDD[i] = maxa; *DFDDD11 = *DFDDD22 = maxa; *DFDDD12 = 0;  }
//  if ( out /*&& l.cent*/ ) { FVALUE = maxa; DFDD2 = 0; DFDD1 = maxa; DFDDD11 = maxa; DFDDD22 = DFDDD12 = 0;  }
}



// ***************GENERAL FUNCTIONS******************


//extern "C" void check_matrix_( int& IBIN, freal& SIGN, freal& SIGN2, freal& SIGN2P, freal& SIGP,
//     freal* SIGP2, freal& SIGP2P, freal* DPAR, freal& sigi, freal& sigp12, freal& sigh, int& VERB, 
//     freal* SIGMA_N, freal* SIGMA_P, bool& scaling )
FORTRAN_SUBR( CHECK_MATRIX, check_matrix,
	( int* IBIN, freal* SIGN, freal* SIGN2, freal* SIGN2P, freal* SIGP,
      freal* SIGP2, freal* SIGP2P, freal* DPAR, freal* sigi, freal* sigp12, freal* sigh, int* VERB, 
      freal* SIGMA_N, freal* SIGMA_P, freal* SIGO, bool* scaling ),
	( int* IBIN, freal* SIGN, freal* SIGN2, freal* SIGN2P, freal* SIGP,
      freal* SIGP2, freal* SIGP2P, freal* DPAR, freal* sigi, freal* sigp12, freal* sigh, int* VERB, 
      freal* SIGMA_N, freal* SIGMA_P, freal* SIGO, bool* scaling ),
	( int* IBIN, freal* SIGN, freal* SIGN2, freal* SIGN2P, freal* SIGP,
      freal* SIGP2, freal* SIGP2P, freal* DPAR, freal* sigi, freal* sigp12, freal* sigh, int* VERB, 
      freal* SIGMA_N, freal* SIGMA_P, freal* SIGO, bool* scaling ) )
{
  likelihood<Type> *lD=&lD1;
  if (*VERB) 
  if ( lD->GetDType() == "sras" || lD->GetDType() == "sras3d" || lD->GetDType() == "sras4d" || 
	   lD->GetDType() == "srasph" || lD->GetDType() == "p+l" || lD->GetDType() == "sirph" ) 
  {
	cout << *IBIN <<": "<<SIGMA_N[0] <<" "<< SIGMA_N[1] <<" "<< SIGMA_N[2] <<" "<< SIGMA_P[0] <<" "<< SIGMA_P[1] <<" "<< SIGMA_P[2]
  	  <<" "<< DPAR[0] <<" "<< DPAR[1];
	if (lD->GetDType() == "sras3d" || lD->GetDType() == "sras4d" || (lD->GetDType() == "p+l" && lD->Num == 4) 
	    || lD->GetDType() == "sirph" || lD->GetDType() == "srasph" ) 
	  cout <<" "<< DPAR[2];
	if ( lD->GetDType() == "sras4d" || (lD->GetDType() == "p+l" && lD->Num == 4) || lD->GetDType() == "srasph" ) 
	  cout <<" "<< DPAR[3];
	cout << endl;
  }
  else
	cout << *IBIN <<": " << *SIGN  << " " << *SIGN2 <<" "<< *SIGN2P <<" "<< SIGP2[1] <<" "<< *SIGP2P
  	  <<" "<< DPAR[0] <<" "<< DPAR[1] <<" "<< DPAR[2] <<" "<< DPAR[3] <<" "<< *sigh  << endl;

  Type F[4], ph[4];
  Type F1[2], ph1[2];
  int out = 1; 
  while ( out && ( DPAR[1]>0.001) )
  {
	int izero = 0;
	int ione = 1;
	freal fzero = 0.0001;
	freal fneg = -1;
	freal SIG1 = fzero, SIG2 = fzero, SIG3 = fzero;
    if ( lD->GetDType() == "sir" || lD->GetDType() == "sirh" || lD->GetDType() == "sirph" )
	  sir_input_llhood(lD, izero, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
	    fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, DPAR, *sigp12, *sigh, F, ph );
    else if ( lD->GetDType() == "p+l" ) 
	  pl_input_llhood(lD, izero, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
	    fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, DPAR, *sigh, ione, F, ph );
    else if ( lD->GetDType() == "sad" || lD->GetDType() == "no" || lD->GetDType() == "sadh" )
	  sad_input_llhood(lD, izero, *SIGN, SIGMA_N, SIGMA_P, *SIGP, SIGP2,
	    *SIGO, *SIGO, *SIGO, fzero, fzero, fzero, fzero, fzero, fzero, fzero, DPAR, fzero, fzero, F, ph );
//	    fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, DPAR, fzero, fzero, F, ph );
    else if ( lD->GetDType() == "sras" || lD->GetDType() == "sras3d" || lD->GetDType() == "sras4d" || lD->GetDType() == "srasph")
    {
//	  if ( SIGMA_N[0]<=0 ) SIG1 = -1.;
//	  if ( SIGMA_N[1]<=0 ) SIG2 = -1.;
//	  if ( SIGMA_N[2]<=0 ) SIG3 = -1.;
		siras_input_llhood(lD, izero, SIGMA_N, SIGMA_P, *SIGN, *SIGP, SIGP2,
	  	  SIG1, SIG2, SIG3, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, DPAR, fzero, fzero, F, ph );
    }
//	  	  *SIGO, *SIGO, *SIGO, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, DPAR, fzero, fzero, F, ph );
//	  else
//		siras_input_llhood(lD, ione, SIGMA_N, SIGMA_P, *SIGN, fzero, SIGP2,
//	  	  fneg, fneg, fneg, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, fzero, DPAR, fzero, fzero, F, ph );
	lD->cov->Make_matrix();  if (*VERB) lD->cov->Print();
	lD->InverseAndEigen();	
// test this carefully!!! it seems that even eigenvalues bigger than 1 can cause trouble...
//    if ( lD->GetDType() == "sadh" || lD->GetDType() == "SADH" || lD->GetDType() == "sad" || lD->GetDType() == "SAD" )
//      lD->SetMinEig(0.005*sqrt(lD->eigenvalues1[lD->Rice][lD->Num-1]));

	out = 0;
	int i = -1;
	while ( !out  &&  ++i < lD->Num ) 
	  if ( lD->eigenvalues1[lD->Rice][i] < lD->GetMinEig() ) 
	  { 
// not decreaing scaling param
		if ( lD->GetDType() != "sadh" && lD->GetDType() != "sras4d" && lD->GetDType() != "srasph" &&
		     lD->GetDType() != "sirph" && lD->GetDType() != "sirh" ) {
		  DPAR[0] *= 0.95;
		}
		else {
		  DPAR[0] *= 1.001;
		}
		DPAR[1] *= 0.95;
        if (*VERB) cout << " D par. in " << *IBIN << " bin decreased to " << DPAR[0] <<", "<< DPAR[1]; out = 1; 
		if ( ( lD->GetDType() == "sras3d" || lD->GetDType() == "sras4d" || lD->GetDType() == "sadh" || 
		       lD->GetDType() == "srasph" || lD->GetDType() == "p+l" || lD->GetDType() == "sirh" ||
		       lD->GetDType() == "sir" || lD->GetDType() == "sirph" ) && lD->cov->N_part > 2 ) {	
		// isomorphic D's should be decreassed much more slowly!
		if ( lD->GetDType() != "sad" && lD->GetDType() != "sadh" && lD->GetDType() != "mad" )
		  DPAR[2] *= 0.995;
		else
		  DPAR[2] *= 0.95;
		  if (*VERB) cout << ", " << DPAR[2];
		}
		if ( lD->GetDType() == "sras4d" || lD->GetDType() == "srasph" || lD->GetDType() == "sirh" ||
		     ( lD->GetDType() == "p+l" && lD->cov->N_part > 3 ) ) {
		  DPAR[3] *= 0.95; 
		  if (*VERB) cout << ", " << DPAR[3]; }
		else if ( lD->GetDType() == "sadh" && lD->cov->N_part > 3) {
		  DPAR[3] *= 1.005; 
		  if (DPAR[3]<0.005) DPAR[3]=0.005;
		  if (*VERB) cout << ", " << DPAR[3];
		}
		if ( ( lD->GetDType() == "sras4d"||lD->GetDType() == "sirh") && lD->cov->N_part > 4 ) {
		  DPAR[4] *= 0.95;
		  if (*VERB) cout << ", " << DPAR[4];
		}
		if ( ( lD->GetDType() == "sras4d"||lD->GetDType() == "sirh") && lD->cov->N_part > 5 ) {
		  DPAR[5] *= 0.95;
		  if (*VERB) cout << ", " << DPAR[5];
		}
		if (*VERB) cout << endl;
	  }
  }
}


//removes white space characters in str and chops after num characters
//str must have allocated memory for at least num characters - this is not checked
void remws( char* str, int num )
{
  int i=0, j=0;
  do  if ( str[i] != ' ' && str[i] != '\0' )   str[j++] = str[i];
  while ( ++i < num );
  str[j]='\0';
}


ifstream f;
ofstream g;

//extern "C" void write_fpp_( float& fpp,  int& refine_fpp )
FORTRAN_SUBR( WRITE_FPP, write_fpp, 
	( float* fpp,  int* refine_fpp ),
	( float* fpp,  int* refine_fpp ),
	( float* fpp,  int* refine_fpp ) )
{
// write actual f'' value for f'' refinement
//  if (*refine_fpp) {
	g.open("fpp");
	if (!g) {  cout << "Error : fpp file cannot be created." << endl; cerr << "Error : fpp file cannot be created." << endl; exit(1); }  
	g.setf( ios::fixed, ios::floatfield );
	g << *fpp << endl;
	g.close();
//  }  
}


//extern "C" void write_anomocc_( float* anom_occ, int* cs_anom, int* id_sf, int& n_atom )
FORTRAN_SUBR( WRITE_ANOMOCC, write_anomocc,
	( float* anom_occ, int* cs_anom, int* id_sf, int* n_atom ),
	( float* anom_occ, int* cs_anom, int* id_sf, int* n_atom ),
	( float* anom_occ, int* cs_anom, int* id_sf, int* n_atom ) )
{
// outputs actual occup_anom in separate file
	g.open("anom_occ");
	if (!g) {  cout << "Error : anom_occ file cannot be created." << endl; cerr << "Error : anom_occ file cannot be created." << endl; exit(1); }  
	g.setf( ios::fixed, ios::floatfield );
	for (int i=0; i<(*n_atom); i++)
	  if (cs_anom[id_sf[i]-1]) g << anom_occ[i] << endl;
	g.close();
}


//extern "C" void read_anomocc_( float* anom_occ_2, int& n_atom, int& ok )
FORTRAN_SUBR( READ_ANOMOCC, read_anomocc,
	( float* anom_occ_2, int* n_atom, int* ok ),
	( float* anom_occ_2, int* n_atom, int* ok ),
	( float* anom_occ_2, int* n_atom, int* ok ) )
{
// reads occup_anom from file previously written by write_anomocc
	*ok=0;
	f.open("anom_occ"); 
	int i=0;
	while (f  && !f.eof()) {  
	  f >> anom_occ_2[i++];
	}
	if (i==(*n_atom)+1) *ok=1;
	if (f) f.close();
}


/*
extern "C" void minexp_tab_( freal& exp_now, freal& x )
{
  if ( x >= 0. && x <= 50. )
  {
	int i = (int) ( .5 + x/.2 );
	Type x_diff = x - lF->Exparr[i][0];
	Type x_diff_sq = x_diff*x_diff;
	exp_now = ( lF->Exparr[i][1] + lF->Exparr[i][2]*x_diff + lF->Exparr[i][3]*x_diff_sq 
		+ lF->Exparr[i][4]*x_diff_sq*x_diff + lF->Exparr[i][5]*x_diff_sq*x_diff_sq );
  }
  else
	exp_now = exp(-x);
}
*/


//performs itoa stuff for fortran calls, i.e. casts integer i to string str given the max. size of str is size
//extern "C" void itoa_( int& i, char* str, int& size )
FORTRAN_SUBR( ITOA, itoa,
	( int* i, char* str, int* size, int *str_len ),
	( int* i, char* str, int* size ),
	( int* i, char* str, int* size, int *str_len ) )
{
  int j,end=0;
  char str_aux[100];
  sprintf(str_aux,"%i",(*i));
  if ( strlen(str_aux)>(*size) ) { exit(1); cout << "Error: Maximal size exceeded in itoa_."; }
  else  for (j=0; j<(*size); j++) {
	if ( end ) str[j] = 0x20; else {
	  str[j]=str_aux[j];
	  if ( str_aux[j]=='\0' ) end=1;
	}
  }
  if ( !end ) { exit(1); cout << "Strange problem in itoa_."; }
//  cout << "*" << str << "*" << endl;
}
