c
c---  These are refmac dependent routines to calculate contact list etc
c
      subroutine analyse_vdw(dmin_vdw)
      implicit none

      real dmin_vdw
      call find_all_contacts_refmac
      call find_vdw_contacts_refmac

      return
      end
c
      subroutine find_all_contacts_refmac
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'atom_com_str.fh'
      include 'restr_files.fh'
      include 'weights.fh'
c
c---  locals
      integer l,ia,ierr,iend,im
      real dlim
c
c---  externals
      integer  lenstr
      external lenstr
c
c---  body
      im = 1
      if(lenstr(all_contacts_file).le.0) then
         call find_unique_file_name(all_contacts_file,'_ALL_CONTACTS')
      endif
c
c---  remove it later
      vdw_file_0 = all_contacts_file
c     
c---  find dlim
      dlim = dvdw_cut_min
      do ia=1,n_atom_mod(im)
         dlim = max(dlim,vdw_rad(ia))
         dlim = max(dlim,ion_rad(ia))
      enddo
      dlim = 2.0*dlim
c
      call find_all_contacts(dlim,
     &     maxatom,n_atom_mod(im),xyz_crd_mod(1,1,im),occup_mod(1,im),
     &     maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &     all_contacts_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'Problem in find_all_contacts')
      endif
c
      return
      end
c
      subroutine find_vdw_contacts_refmac
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'agreem.fh'
      include 'atom_com_str.fh'
      include 'restr_files.fh'
      include 'weights.fh'
      include 'refi_flags.fh'
      include 'anom.fh'
c
c---  This routine uses all_contacts file and bond, angle files
c---  to produce list of potential non-bonding contacts
      integer l,is
      integer iv1(2)
      integer nvdw,nvdw1,iv,iscrv,ierr
      integer itx(3)
      real     xtm(3),xtm1(3)
c
c---occupancy problems
      character at_full*24
      integer   ia,ia1,im
      real      dsq
      real      xyz1(3),xyz2(3),xyz3(3)
c
c---  allocatable arrays
      integer, allocatable :: n_mult(:)
      integer, allocatable :: vdw_pairs(:,:)
      integer, allocatable :: vdw_symm(:,:)
      real,    allocatable :: vdw_vidl(:,:)
      integer, allocatable :: vdw_type(:)
c
      integer nsize_chain,nsize_res,nres_pairs_exclude
      integer nchain_pairs_exclude,natoms_exclude,nsize_atoms
      character(len=4), allocatable :: chains_exclude(:,:)
      character(len=4), allocatable :: residue_exclude_chain(:,:)
      integer, allocatable :: residue_exclude_res(:,:)
      integer, allocatable :: atoms_exclude(:)
c
      character chnamp1*4,chnamp2*4
      integer i,j,ir1,ir2,ipr1,ipr2
c
c---vdw bvalues write
      integer ivdw_w,i1,i2
      real u1,u2
      character vdw_file_external*512
c
      real      dist_cur,over_tot
      logical   error
      integer   lenstr
      external  lenstr
c
c---  body
      im = 1
      call open_unform_file(iscrv,all_contacts_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'Problem in opening all_contacts_file')
      endif
c
      read(iscrv)nvdw
      allocate(vdw_pairs(2,nvdw))
      allocate(vdw_symm(4,nvdw))
      allocate(vdw_vidl(3,nvdw))
      allocate(vdw_type(nvdw))
      do  iv=1,nvdw
         read(iscrv)vdw_pairs(1:2,iv),vdw_symm(1:4,iv)
      enddo
      close(iscrv)
c
c---analyse occupancies and if special positions then adjust them if necessary
      allocate(n_mult(n_atom_mod(im)))
      n_mult(1:n_atom_mod(im)) = 1
      do iv=1,nvdw
         if(vdw_pairs(1,iv).eq.vdw_pairs(2,iv)) then
            ia1 = vdw_pairs(1,iv)
            xyz1(1:3) = xyz_crd_mod(1:3,ia1,im)
            is = vdw_symm(1,iv)
            xyz2(1:3) = matmul(cs_ort_to_frac(1:3,1:3),xyz1(1:3))
            xyz3(1:3) = matmul(cs_m_cs(1:3,1:3,is),xyz2(1:3))+
     &           cs_v_cs(1:3,is) + float(vdw_symm(2:4,iv))
            xyz2(1:3) = matmul(cs_frac_to_ort(1:3,1:3),xyz3(1:3))
            dsq = sum((xyz2(1:3)-xyz1(1:3))**2)
            if(dsq.lt.0.25) n_mult(ia1) = n_mult(ia1) + 1
         endif
      enddo
      over_tot=0.
      do ia=1,n_atom_mod(im)
         over_tot = over_tot + max(1.,occup_mod(ia,im)*real(n_mult(ia)))
         if(n_mult(ia).gt.0.and.(ires_type(i_resid_mod(ia,im)).eq.1.or.
     &        ires_type(i_resid_mod(ia,im)).eq.9)) then
            if(occup_mod(ia,im)*real(n_mult(ia)).gt.1.0001) then
               call full_atom_name(ia,at_full,ierr)
               call errwrt(-1,'Atom ('//trim(at_full)//')"s total'
     &              //' occupancy (occ*multipl) > 1.0. Changing it')
               occup(ia) = 1.0/real(n_mult(ia))
               occup_mod(ia,1) = 1.0/real(n_mult(ia))
               if (.not.separate_anom_occ)  then
                 occup_anom(ia) = occup(ia)
                 occup_anom_mod(ia,1) = occup_mod(ia,1)
               endif
            endif
         endif
      enddo
      if (substruct_flag) then
        over_tot=over_tot/n_atom
        if (over_tot.gt.1.) scale_llh_over=scale_llh_over*over_tot
      endif
      deallocate(n_mult)
c
c---  Remove extra pairs
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(occup_mod(iv1(1),im)+occup_mod(iv1(2),im).le.1.00001.and.
     &        (corr_id(iv1(1)).eq.0.or.corr_id(iv1(2)).eq.0.or.
     &        corr_id(iv1(1)).ne.corr_id(iv1(2)))) then
            vdw_symm(1,iv) = -1
         endif
      enddo
c
c---  Condense vdw pairs
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1                = nvdw1 + 1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_type(nvdw1)      = 1
         endif
      enddo
c
c---write vdw pairs with bvalues
      if(vdw_write_flag) then
         call find_unique_file_name(vdw_file_external,'_vdw_b')
         call open_form_file(ivdw_w,vdw_file_external,ierr)
         do i=1,nvdw1
            if(vdw_symm(1,i).eq.1.and.
     &           sum(abs(vdw_symm(2:4,i))).eq.0) then
               i1 = vdw_pairs(1,i)
               i2 = vdw_pairs(2,i)

               if(u_aniso(2,i1).eq.0) then
                  u1 = u_aniso(1,i1)
               else
                  u1 = sum(u_aniso(1:3,i1))/3
               endif
               if(u_aniso(2,i2).eq.0) then
                  u2 = u_aniso(1,i2)
               else
                  u2 = sum(u_aniso(1:3,i2))/3
               endif
               write(ivdw_w,*)xyz_crd(1:3,i1),u1,xyz_crd(1:3,i2),u2
            endif
         enddo
         call refmac_clean_up_files
         call ccperr(0,'End of Refmac')
      endif

      nvdw = nvdw1
c
c--Remove user defined exclusions
      if(vdwr_exclude_flag) then
         call exclude_vdw_size(nchain_pairs_exclude,nres_pairs_exclude,
     &        natoms_exclude)
         if(nchain_pairs_exclude.le.0.and.nres_pairs_exclude.le.0.and.
     &        natoms_exclude.le.0) vdwr_exclude_flag = .FALSE.
         nsize_chain = max(nchain_pairs_exclude,1)
         allocate(chains_exclude(2,nsize_chain))
         nsize_res = max(nres_pairs_exclude,1)
         allocate(residue_exclude_res(2,nsize_res))
         allocate(residue_exclude_chain(2,nsize_res))
         nsize_atoms = max(natoms_exclude,1)
         allocate(atoms_exclude(nsize_atoms))
         call exclude_vdw_read(nsize_chain,nsize_res,nsize_atoms,
     &        chains_exclude,residue_exclude_res,residue_exclude_chain,
     &        atoms_exclude)
         do i=1,nvdw
            iv1(1) = vdw_pairs(1,i)
            iv1(2) = vdw_pairs(2,i)
            ir1 = i_resid(iv1(1))
            ir2 = i_resid(iv1(2))
            read(res_num_pdb(ir1)(3:7),'(i5)')ipr1
            read(res_num_pdb(ir2)(3:7),'(i5)')ipr2
            call get_chain_namepdb(chnamp1,i_resid(iv1(1)))
            call get_chain_namepdb(chnamp2,i_resid(iv1(2)))
            if(nchain_pairs_exclude.gt.0) then
               do j=1,nchain_pairs_exclude
                  if(chnamp1.eq.chains_exclude(1,j).and.
     &                 chnamp2.eq.chains_exclude(2,j).or.
     &                 chnamp1.eq.chains_exclude(2,j).and.
     &                 chnamp2.eq.chains_exclude(1,j)) then
                     vdw_symm(1,i) = -1
                     goto 20
                  endif
               enddo
            endif
            if(nres_pairs_exclude.gt.0) then
               do j=1,nres_pairs_exclude
                  if(chnamp1.eq.residue_exclude_chain(1,j).and.
     &                 chnamp2.eq.residue_exclude_chain(2,j).and.
     &                 ipr1.eq.residue_exclude_res(1,j).and.
     &                 ipr2.eq.residue_exclude_res(2,j).or.
     &                 chnamp2.eq.residue_exclude_chain(1,j).and.
     &                 chnamp1.eq.residue_exclude_chain(2,j).and.
     &                 ipr2.eq.residue_exclude_res(1,j).and.
     &                 ipr1.eq.residue_exclude_res(2,j)) then  
                     vdw_symm(1,j) = -1
                     goto 20
                  endif
               enddo
            endif
            if(natoms_exclude.gt.0) then
               do j=1,natoms_exclude
                  if(iv1(1).eq.atoms_exclude(j).or.
     &                 iv1(2).eq.atoms_exclude(j)) then
                     vdw_symm(1,i) = -1
                     goto 20
                  endif
               enddo
               endif
 20         continue
         enddo
         if(minval(vdw_symm(1,1:nvdw)).eq.-1) then
            nvdw1 = 0
            do  iv=1,nvdw
               if(vdw_symm(1,iv).gt.0) then
                  nvdw1                = nvdw1 + 1
                  vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
                  vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
                  vdw_type(nvdw1)      = 1
               endif
            enddo
            nvdw = nvdw1
         endif
         deallocate(chains_exclude)
         deallocate(residue_exclude_res)
         deallocate(residue_exclude_chain)
      endif
c
c--   remove bonds and angles
      call remove_bonds_and_angles(nvdw,nvdw1,vdw_pairs(1:2,1:nvdw),
     &     vdw_symm(1:4,1:nvdw),vdw_vidl(1:3,1:nvdw),
     &     vdw_type(1:nvdw),ierr)
      if(ierr.gt.0) then
         call errwrt(1,'Problem in removing bonds from vdw')
      endif
      nvdw = nvdw1
c
c---  Now check and define if it is vdw,ion, hbond etc
      nvdw1 = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         is       = vdw_symm(1,iv)
         itx(1:3) = vdw_symm(2:4,iv)
         xtm(1:3) = xyz_crd_mod(1:3,iv1(2),im)
         call mat2vec(3,3,cs_ort_to_frac,xtm,xtm1,error)
         call mat2vec(3,3,cs_m_cs(1:3,1:3,is),xtm1,xtm,error)
         xtm1(1:3) = xtm(1:3) +cs_v_cs(1:3,is)+float(itx(1:3))
         call mat2vec(3,3,cs_frac_to_ort,xtm1,xtm,error)
         dist_cur = sqrt(sum((xyz_crd_mod(1:3,iv1(1),im)-xtm(1:3))**2))
         if(vdw_type(iv).eq.1) then
            call hbond_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            call ibond_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            call mbond_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            call dummy_check(iv1(1),iv1(2),vdw_type(iv),
     &           vdw_vidl(1,iv),vdw_vidl(2,iv),vdw_vidl(3,iv))
         endif
         if(vdw_type(iv).eq.1) then
            vdw_vidl(1,iv) = vdw_rad(iv1(1))+vdw_rad(iv1(2))
            vdw_vidl(2,iv) = vdw_vidl(1,iv)
            vdw_vidl(3,iv) = vdw_sdi_vdw
         endif
         if(dist_cur.gt.vdw_vidl(2,iv)) then
            vdw_symm(1,iv) = -1
         endif
      enddo
      nvdw1 = 0
      do iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1                 = nvdw1 + 1
            vdw_pairs(1:2,nvdw1)  = vdw_pairs(1:2,iv)
            vdw_vidl(1:3,nvdw1)   = vdw_vidl(1:3,iv)
            vdw_symm(1:4,nvdw1)   = vdw_symm(1:4,iv)
            vdw_type(nvdw1)       = vdw_type(iv)
         endif
      enddo
c
      if(lenstr(vdw_file).le.0) then
         call find_unique_file_name(vdw_file,'_VDW_R')
      endif
      call open_unform_file(iscrv,vdw_file,ierr)
      write(iscrv)nvdw1
      do iv=1,nvdw1
        if(vdw_symm(1,iv).ne.1.or.vdw_symm(2,iv).ne.0.or.
     &        vdw_symm(3,iv).ne.0.or.vdw_symm(4,iv).ne.0) then
           vdw_type(iv) = vdw_type(iv) + 6
        endif
         write(iscrv)vdw_pairs(1:2,iv),vdw_vidl(1:3,iv),
     &        vdw_symm(1:4,iv),vdw_type(iv)
      enddo
c
c---  Now read and find number of vdws and write again
      close(iscrv)
      deallocate(vdw_pairs)
      deallocate(vdw_symm)
      deallocate(vdw_vidl)
      deallocate(vdw_type)
      return
      end
c
      subroutine exclude_vdw_size(nchain_pairs_exclude,
     &     nres_pairs_exclude,natoms_exclude)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'restr_files.fh'
      integer nchain_pairs_exclude
      integer nres_pairs_exclude
      integer natoms_exclude
c
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer lend_f

      integer iscrk,ierr,n1
c
      character chnamp1*4
      integer ir,ne,i,j,jrs,im
      integer, allocatable :: ires_beg(:)
      integer, allocatable :: ires_end(:)
      character(len=4), allocatable :: chain_beg(:)
      character(len=4), allocatable :: chain_end(:)
c
c---  body
      allocate(ires_beg(n_residue))
      allocate(ires_end(n_residue))
      allocate(chain_beg(n_residue))
      allocate(chain_end(n_residue))

      im  = 1
      nchain_pairs_exclude = 0
      nres_pairs_exclude = 0
      natoms_exclude = 0
      ne  = 0
      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
      read(iscrk,'(a)',iostat=lend_f) line
      do while(lend_f.ge.0)
         call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &        ntok,lend,lprint)
         call ccpupc(key)
         do i=1,ntok
            call ccpupc(cvalue(i))
         enddo
         if(key.eq.'VDWR') then
            itk = 2
            if(cvalue(itk).eq.'EXCL') then
               itk = itk + 1
               if(cvalue(itk).eq.'BETW') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'CHAI') then
                     itk = itk + 1
                     n1= ntok-itk+1
                     nchain_pairs_exclude = 
     &                    nchain_pairs_exclude + n1*(n1-1)/2
                  endif
               else if(cvalue(itk).eq.'RESI') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'FROM') then
                     ne = ne + 1
                     itk = itk + 1
                     ires_beg(ne) = nint(fvalue(itk))
                     itk = itk + 1
                     chain_beg(ne) = line(ibeg(itk):iend(itk))
                     itk = itk + 1
                     ires_end(ne) = -999
                     if(cvalue(itk)(1:2).eq.'TO') then
                        itk = itk + 1
                        ires_end(ne) = nint(fvalue(itk))
                        itk = itk + 1
                        chain_end(ne) = line(ibeg(itk):iend(itk))
                     endif
                  else
                     ne = ne + 1
                     itk = itk + 1
                     ires_beg(ne) = nint(fvalue(itk))
                     itk = itk + 1
                     chain_beg(ne) = line(ibeg(itk):iend(itk))
                     itk = itk + 1
                     ires_end(ne) = ires_beg(ne)
                     chain_end(ne) = chain_beg(ne)
                  endif
               endif
            endif
         endif
         read(iscrk,'(a)',iostat=lend_f) line         
      enddo
      natoms_exclude = 0
      if(ne.gt.0) then
         do i=1,n_atom_mod(im)
            call get_chain_namepdb(chnamp1,i_resid_mod(i,im))
            ir = i_resid_mod(i,im)
            read(res_num_pdb(ir)(3:7),'(i5)')jrs
            do j=1,ne
               if(chnamp1.eq.chain_beg(j).and.jrs.ge.ires_beg(j).and.
     &              jrs.le.ires_end(j)) then
                  natoms_exclude = natoms_exclude + 1
               endif
            enddo
         enddo
      endif

      deallocate(ires_beg)
      deallocate(ires_end)
      deallocate(chain_beg)
      deallocate(chain_end)
      close(iscrk)
      return
      end
c
      subroutine exclude_vdw_read(nsize_chain,nsize_res,nsize_atoms,
     &     chains_exclude,residue_exclude_res,residue_exclude_chain,
     &     atoms_exclude)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'restr_files.fh'
      integer nsize_chain
      integer nsize_res
      integer nsize_atoms
      character chains_exclude(2,nsize_chain)*4
      character residue_exclude_chain(2,nsize_res)*4
      integer residue_exclude_res(2,nsize_res)
      integer atoms_exclude(nsize_atoms)
c
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer lend_f
      integer itk1,itk2
c
      integer nexclude_atoms
      integer iscrk,ierr,n1
      integer i,j,ich
      character chnamp1*4
      integer ir,ne,jrs,im
      integer, allocatable :: ires_beg(:)
      integer, allocatable :: ires_end(:)
      character(len=4), allocatable :: chain_beg(:)
      character(len=4), allocatable :: chain_end(:)
c
c---  body
      allocate(ires_beg(n_residue))
      allocate(ires_end(n_residue))
      allocate(chain_beg(n_residue))
      allocate(chain_end(n_residue))
c
c---  body
      im = 1
      ich = 0
      ne = 0
      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
      read(iscrk,'(a)',iostat=lend_f) line
      do while(lend_f.ge.0)
         call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &        ntok,lend,lprint)
         call ccpupc(key)
         do i=1,ntok
            call ccpupc(cvalue(i))
         enddo
         if(key.eq.'VDWR') then
            itk = 2
            if(cvalue(itk).eq.'EXCL') then
               itk = itk + 1
               if(cvalue(itk).eq.'BETW') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'CHAI') then
                     itk = itk + 1
                     n1= ntok-itk+1
                     do i=1,n1-1
                        itk1 = itk + i-1
                        do j=i+1,n1
                           itk2 = itk + j-1
                           ich = ich + 1
                           chains_exclude(1,ich) = 
     &                          line(ibeg(itk1):iend(itk1))
                           chains_exclude(2,ich) = 
     &                          line(ibeg(itk2):iend(itk2))
                        enddo
                     enddo
                     itk = itk + n1
                  endif               
               else if(cvalue(itk).eq.'RESI') then
                  itk = itk + 1
                  if(cvalue(itk).eq.'FROM') then
                     ne = ne + 1
                     itk = itk + 1
                     ires_beg(ne) = nint(fvalue(itk))
                     itk = itk + 1
                     chain_beg(ne) = line(ibeg(itk):iend(itk))
                     itk = itk + 1
                     ires_end(ne) = -999
                     if(cvalue(itk)(1:2).eq.'TO') then
                        itk = itk + 1
                        ires_end(ne) = nint(fvalue(itk))
                        itk = itk + 1
                        chain_end(ne) = line(ibeg(itk):iend(itk))
                     endif
                  else
                     ne = ne + 1
                     itk = itk + 1
                     ires_beg(ne) = nint(fvalue(itk))
                     itk = itk + 1
                     chain_beg(ne) = line(ibeg(itk):iend(itk))
                     itk = itk + 1
                     ires_end(ne) = ires_beg(ne)
                     chain_end(ne) = chain_beg(ne)
                  endif
               endif
            endif
         endif
         read(iscrk,'(a)',iostat=lend_f) line         
      enddo
      nexclude_atoms = 0
      if(ne.gt.0) then
         do i=1,n_atom_mod(im)
            call get_chain_namepdb(chnamp1,i_resid_mod(i,im))
            ir = i_resid_mod(i,im)
            read(res_num_pdb(ir)(3:7),'(i5)')jrs
            do j=1,ne
               if(chnamp1.eq.chain_beg(j).and.jrs.ge.ires_beg(j).and.
     &              jrs.le.ires_end(j)) then
                  nexclude_atoms = nexclude_atoms + 1
                  atoms_exclude(nexclude_atoms) = i
               endif
            enddo
         enddo
      endif

      deallocate(ires_beg)
      deallocate(ires_end)
      deallocate(chain_beg)
      deallocate(chain_end)
      close(iscrk)
      return
      end

c
      SUBROUTINE HBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,
     &                   VDW_SDI)
C
c---Checks if two atoms can make hydrogen bonds. At the moment simple check
C---is perforfmed. If one of atoms is acceptor and another one is donor
C---then they can make hydrogen bonds. This subroutine should be improved
C---considerably.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
      IF(HB_TYPE(IV1).EQ.'A') THEN
C
C---Check second atom should be either donor or donor/acceptor or hydrogen
C---from hyrogen bond capable atom
        IF(HB_TYPE(IV2).EQ.'D'.OR.HB_TYPE(IV2).EQ.'B') THEN
C
C---These two atoms can make hydrogen bond
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                   HBOND_DINC_AD
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND
        ELSEIF(HB_TYPE(IV2).EQ.'H') THEN
C
c---Second atom is hydrogen from hydrogen bond capable atom
           DVDW_IDEAL = VDW_RAD(IV1) + HBOND_DINC_AH
           DVDW_MAX   = DVDW_IDEAL
           IVDW_TYPE  = 3
           VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
      IF(HB_TYPE(IV1).EQ.'D')THEN
C
c---First atom is donor.Second atom should be acceptor only
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'B') THEN
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                    HBOND_DINC_AD 
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND      
        ENDIF
      ENDIF
C
      IF(HB_TYPE(IV1).EQ.'B') THEN
C
C---Firts atom can be donor or acceptor
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'D'.OR.
     &     HB_TYPE(IV2).EQ.'B') THEN
C
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                   HBOND_DINC_AD
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE = 3
          VDW_SDI    = VDW_SDI_HBOND
        ELSEIF(HB_TYPE(IV2).EQ.'H') THEN
C
          DVDW_IDEAL = VDW_RAD(IV1)+HBOND_DINC_AH
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3 
          VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
C
      IF(HB_TYPE(IV1).EQ.'H') THEN
C
c---First atom is hydrogen from hydrogen bond capable atom
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'B') THEN
          DVDW_IDEAL = VDW_RAD(IV2) + HBOND_DINC_AH
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
C
      RETURN
      END
C
      SUBROUTINE IBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,
     &               DVDW_MAX,VDW_SDI)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
C----No idea what to do
      RETURN
      END
C
      SUBROUTINE  MBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,
     &             VDW_SDI)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER MAX_METAL
      PARAMETER (MAX_METAL = 83)
      CHARACTER METAL(MAX_METAL)*2

      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
      REAL RAD1,RAD2
      INTEGER IM
      LOGICAL METAL_FLAG

      DATA METAL/'AG','AL','AU','CA','CD','CE','CO','CR','CS','CU','EU',
     &           'FE','HG','HO','K ','LA','LI','MG','MN','MO','NA','PT',
     &           'TA','ZN','BE','SC','TI','V ','NI','RB','SR','Y ','ZR',
     &           'NB','TC','RU','RH','PD','IN','SN','TE','I ','BA','LA',
     &           'CE','PR','ND','PM','SM','GD','TB','DY','ER','TM','YB',
     &           'LU','HF','W ','RE','OS','IR','TL','PB','BI','PO','AT',
     &           'FR','RA','AC','TH','PA','U ','NP','PU','AM','CM','BK',
     &           'CF','ES','FM','MD','NO','LR'/
c---If one of atoms is metal and second one is capable of coordinating this
C---metal. At the moment no idea how to deal with it.
      METAL_FLAG = .FALSE.
      DO    IM = 1,MAX_METAL
        IF(CS_ELEMENT(ID_SF(IV1))(1:2).EQ.METAL(IM)) THEN
          METAL_FLAG = .TRUE.
          GOTO 100
        ENDIF
      ENDDO
      DO   IM=1,MAX_METAL
        IF(CS_ELEMENT(ID_SF(IV2))(1:2).EQ.METAL(IM)) THEN
          METAL_FLAG = .TRUE.
          GOTO 100
        ENDIF
      ENDDO
      RETURN
 100  CONTINUE
C
C---One of the atoms is metal. Use ionic radii of atoms. 
C---Consider putting restraints on them

      IF(ION_RAD(IV1).GT.0.0.AND.ION_RAD(IV2).GT.0.0) THEN
        RAD1 = ION_RAD(IV1)
        RAD2 = ION_RAD(IV2)
        DVDW_IDEAL = RAD1 + RAD2
        DVDW_MAX   = DVDW_IDEAL
        VDW_SDI    = VDW_SDI_METAL 
        IVDW_TYPE  = 4
      ENDIF
      RETURN
      END
C
      SUBROUTINE  DUMMY_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,
     &             VDW_SDI)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
      REAL RAD1,RAD2
C

      RAD1 = VDW_RAD(IV1)
      RAD2 = VDW_RAD(IV2)
C
      IF((ATM_NAME(IV1).EQ.'DUM'.AND.ATM_NAME(IV2).NE.'DUM').OR.
     &   (ATM_NAME(IV1).NE.'DUM'.AND.ATM_NAME(IV2).EQ.'DUM')) THEN
         DVDW_IDEAL = AMAX1(0.7,RAD1 + RAD2 + DINC_DUMMY)
         DVDW_MAX   = DVDW_IDEAL
         VDW_SDI    = VDW_SDI_DUMMY
         ivdw_type  = 5
      ENDIF
      IF(ATM_NAME(IV1).EQ.'DUM'.AND.ATM_NAME(IV2).EQ.'DUM') THEN
         DVDW_IDEAL = RAD1 + RAD2
         DVDW_MAX   = DVDW_IDEAL
         VDW_SDI    = VDW_SDI_DUMMY
         ivdw_type  = 6
      ENDIF
c
      RETURN
      END
C
      subroutine remove_bonds_and_angles(nvdw,nvdw_out,vdw_pairs,
     &     vdw_symm,vdw_vidl,vdw_type,ierr)
c
      implicit none
      include 'atom_com.fh'
      include 'atom_com_str.fh'
      include 'weights.fh'
      include 'restr_files.fh'
c
      integer nvdw,nvdw_out
      integer vdw_pairs(2,nvdw)
      integer vdw_symm(4,nvdw)
      integer vdw_type(nvdw)
      real    vdw_vidl(3,nvdw)
c
      integer ierr
c
c---  allocatable arrays
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: bond_pairs(:,:)
      integer, allocatable :: bond_symm(:,:)
      integer, allocatable :: rest_per_atom(:,:)
      integer, allocatable :: rest_per_atom_symm(:,:,:)
c
      integer nvdw1,nbond,nbonds
      integer iv,ib,id,first,ia1,ib1,ia2,ib2,iel1,iel2,itype_bond
      integer ia3
      integer nmaxrest
      integer bonds_l(2)
      integer ia_l(2),iv1(2)
      integer isym1(4),isym2(4),isym3(4),isym4(4),isym_l(4)
      integer isym_o1(4),isym_o2(4)
      integer itx1(3),symm_loc(4)
      integer iscrb,iscrv

      real dinc_curr1,dinc_curr2,dinc_current,rs_vidl(2)
c     
      integer nbb,naa,ntt,ntt1
      integer iscri,nint,ii
      integer rs_vidl_i(4)
      integer iend
      integer lenstr
      external lenstr
c
c---- body
      if(len_trim(bond_file).le.0) return
      call open_unform_file(iscrb,bond_file,ierr)
      if(ierr.gt.0) then
         call errwrt(-1,'Problem while opening bond_file')
         return
      endif
      read(iscrb)nbonds
      nbond = 0
      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0
      do  ib=1,nbonds
         read(iscrb,iostat=iend)ia_l(1:2),rs_vidl(1:2),
     &        isym1(1:4),itype_bond
         nbond = nbond + 1
         nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
         nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
      enddo
c
c--   Add intervals as distances
      if(len_trim(interval_file).gt.0) then
         call open_unform_file(iscri,interval_file,ierr)
         if(ierr.gt.0) then
            call errwrt(-1,'Problem whie opening interval file')
            return
         endif
         read(iscri) nint
         do ib=1,nint
            read(iscri,iostat=iend)ia_l(1:2),isym1(1:4),rs_vidl_i(1:4),
     &           itype_bond
            if(itype_bond.eq.1.or.itype_bond.eq.2) then
               nbond = nbond + 1
               nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
               nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
            endif
         enddo
      endif
      nmaxrest = maxval(nrest_per_atom)
      
      allocate(bond_pairs(2,nbond))
      allocate(bond_symm(4,nbond))
      allocate(rest_per_atom(nmaxrest,n_atom))
      allocate(rest_per_atom_symm(4,nmaxrest,n_atom))
      
      nrest_per_atom(1:n_atom) = 0
c
c---read and do a little bit of organisation
      rewind(iscrb)
c
      first  = 0
      read(iscrb)nbonds
      do  ib=1,nbonds
         read(iscrb)bond_pairs(1:2,ib),rs_vidl(1:2),bond_symm(1:4,ib),
     &        itype_bond
         ia_l(1:2) = bond_pairs(1:2,ib)
         nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
          if(ia_l(1).ne.ia_l(2)) then
             nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
          endif
         ib1 = nrest_per_atom(ia_l(1))
         ib2 = nrest_per_atom(ia_l(2))
         rest_per_atom(ib1,ia_l(1)) = ia_l(2)
         rest_per_atom_symm(1:4,ib1,ia_l(1)) = bond_symm(1:4,ib)
         rest_per_atom(ib2,ia_l(2)) = ia_l(1)
         call symm_inv_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &        bond_symm(1:4,ib),isym1,first)
         rest_per_atom_symm(1:4,ib2,ia_l(2)) = isym1(1:4)
      enddo

      ii = nbonds
      close(iscrb)
      rewind(iscri)
      read(iscri)nint
      if(nint.gt.0) then
         do ib=1,nint
            read(iscri)bonds_l(1:2),isym1(1:4),
     &           rs_vidl_i(1:4),itype_bond
            if(itype_bond.eq.1.or.itype_bond.eq.2) then
               ii = ii + 1
               bond_pairs(1:2,ii) = bonds_l(1:2)
               bond_symm(1:4,ii) = isym1(1:4)
               ia_l(1:2) = bond_pairs(1:2,ii)
               nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
               if(ia_l(1).ne.ia_l(2)) then
                  nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
               endif
               ib1 = nrest_per_atom(ia_l(1))
               ib2 = nrest_per_atom(ia_l(2))
               rest_per_atom(ib1,ia_l(1)) = ia_l(2)
               rest_per_atom_symm(1:4,ib1,ia_l(1)) = bond_symm(1:4,ii)
               rest_per_atom(ib2,ia_l(2)) = ia_l(1)
               call symm_inv_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &              bond_symm(1:4,ii),isym1,first)
               rest_per_atom_symm(1:4,ib2,ia_l(2)) = isym1(1:4)
            endif
         enddo
      endif
      close(iscri)
c
c---  Remember that bonds and vdw have already been sorted. 
c
c---  vdw is in the list of bonds remove it
      nbb    = 0
      naa    = 0
      ntt    = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
c
c---  Is it a bond
            do ib=1,nrest_per_atom(iv1(1))
               if(iv1(2).eq.rest_per_atom(ib,iv1(1))) then
                  isym1(1:4)=rest_per_atom_symm(1:4,ib,iv1(1))
                  id=maxval(abs(vdw_symm(1:4,iv)-isym1(1:4)))
                  if(id.eq.0) then
                     nbb = nbb + 1
                     vdw_symm(1,iv) = -1
                     goto 100
                  endif
               endif
            enddo
 100        continue
         endif
      enddo
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1 = nvdw1 +1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_vidl(1:3,nvdw1)  = vdw_vidl(1:3,iv)
            vdw_type(nvdw1)      = vdw_type(iv)
         endif
      enddo
      nvdw = nvdw1
c
c---  Is it an angle
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
            do   ib=1,nrest_per_atom(iv1(1))
               ia1        = rest_per_atom(ib,iv1(1))
               if(nrest_per_atom(ia1).gt.1) then
                  isym1(1:4) = rest_per_atom_symm(1:4,ib,iv1(1))
                  do ib1=1,nrest_per_atom(ia1)
                     if(rest_per_atom(ib1,ia1).eq.iv1(2)) then
                        isym2(1:4) = rest_per_atom_symm(1:4,ib1,ia1)
                        call symm_mult_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,
     &                       isym1,isym2,isym3,first)
                        id=maxval(abs(vdw_symm(1:4,iv)-isym3(1:4)))
                        if(id.eq.0) then
                           naa = naa + 1
                           vdw_symm(1,iv) = -1
                           goto 200
                        endif
                     endif
                  enddo
               endif
            enddo
 200        continue
         endif
      enddo
      nvdw1 = 0
      do  iv=1,nvdw
         if(vdw_symm(1,iv).gt.0) then
            nvdw1 = nvdw1 +1
            vdw_pairs(1:2,nvdw1) = vdw_pairs(1:2,iv)
            vdw_symm(1:4,nvdw1)  = vdw_symm(1:4,iv)
            vdw_vidl(1:3,nvdw1)  = vdw_vidl(1:3,iv)
            vdw_type(nvdw1)      = vdw_type(iv)
         endif
      enddo
      nvdw = nvdw1
c
c---  Torsions
      ntt1 = 0
      do iv=1,nvdw
         iv1(1:2) = vdw_pairs(1:2,iv)
         if(nrest_per_atom(iv1(1)).gt.0.and.
     &        nrest_per_atom(iv1(2)).gt.0) then
            do ib=1,nrest_per_atom(iv1(1))
               ia1 = rest_per_atom(ib,iv1(1))
               if(nrest_per_atom(ia1).gt.1) then
                  isym1(1:4) = rest_per_atom_symm(1:4,ib,iv1(1))
                  do  ib1=1,nrest_per_atom(ia1)
                     ia2=rest_per_atom(ib1,ia1)
                     if(nrest_per_atom(ia2).gt.1) then
                        isym2(1:4) = rest_per_atom_symm(1:4,ib1,ia1)
                        do ib2=1,nrest_per_atom(ia2)
                           ia3=rest_per_atom(ib2,ia2)
                           if(ia3.eq.iv1(2)) then
                              isym3(1:4)=rest_per_atom_symm(1:4,ib2,ia2)
                              call symm_mult_r(maxnso,cs_nsym,cs_m_cs,
     &                             cs_v_cs,
     &                             isym1,isym2,isym_o1,first)
                              call symm_mult_r(maxnso,cs_nsym,cs_m_cs,
     &                             cs_v_cs,
     &                             isym_o1,isym3,isym_o2,first)
                              id=maxval(abs(vdw_symm(1:4,iv)-
     &                             isym_o2(1:4)))
                              ntt1 = ntt1 + 1
                              if(id.eq.0) then
c
c---  Torsion angle related atoms
                                 iel1 = id_sf(iv1(1))
                                 iel2 = id_sf(iv1(2))
                                 if(cs_element(iel1).eq.'O   ') then
                                    dinc_curr1=dinc_torsion_o
                                 elseif(cs_element(iel1).eq.'N   ') then
                                    dinc_curr1=dinc_torsion_n
                                 elseif(cs_element(iel1).eq.'C   ') then
                                    dinc_curr1=dinc_torsion_c
                                 else
                                    dinc_curr1=dinc_torsion_all
                                 endif
                                 if(cs_element(iel2).eq.'O   ') then
                                    dinc_curr2=dinc_torsion_o
                                 elseif(cs_element(iel2).eq.'N   ') then
                                    dinc_curr2=dinc_torsion_n
                                 elseif(cs_element(iel2).eq.'C   ') then
                                    dinc_curr2=dinc_torsion_c
                                 else
                                    dinc_curr2=dinc_torsion_all
                                 endif
                                 dinc_current=dinc_curr1+dinc_curr2
                                 vdw_type(iv) = 2
                                 vdw_vidl(1,iv) = vdw_rad(iv1(1))+
     &                                vdw_rad(iv1(2))+dinc_current
                                 vdw_vidl(3,iv)=vdw_sdi_torsion
                                 vdw_vidl(2,iv)=vdw_vidl(1,iv)
                                 ntt = ntt + 1
                                 goto 300
                              endif
                           endif
                        enddo
                     endif
                  enddo
               endif               
            enddo
 300        continue
         endif
      enddo
c
c--Deallocate
      nvdw_out = nvdw1
      deallocate(nrest_per_atom)
      deallocate(bond_pairs)
      deallocate(bond_symm)
      deallocate(rest_per_atom)
      deallocate(rest_per_atom_symm)
      return
      end
c
      subroutine all_pairs_refmac_prepare(npairs,ierr)
      implicit none
      include 'restr_files.fh'
c
c---  Read from each file and write to a file. We do not need symmetry here
c---  It substantially reduces the complexity of the problem
      integer npairs
      integer ierr
c
      integer ib,nbonds,nbonds_rigid,nall_ncs
      integer iv,nvdw
      integer i,j,k,symm(4)
      integer is_t(4,200)
      integer iend
      integer nplane,npl,ityp,nmaxatom_in_plane
      integer btype,tperied
      integer plane_pairs(100)
      integer nchir,nangles,ia,ntors
      integer ia1(100),symms(4)
      integer ncs_pairs(2,200)
      integer vidls(4),vsigma
      integer ieof
      integer l,iscrt,iscr1,iscrv,nconts,nc1
      character file_tempo*512
      integer tperiod
      integer number_ncs,nchain_ncs,npairs_ncs
      integer nsim_pairs,nsim_here
      integer ncs_quart(4)
c
      integer, allocatable :: all_pairs(:,:)
      
      integer  lenstr
      external lenstr
c
c---  body
      call find_unique_file_name(file_tempo,'_all_pairs_r')
      call open_unform_file(iscrt,file_tempo,ierr)
      if(ierr.gt.0) then
         call errwrt(-1,'Problem in onening intermediate file')
         return
      endif
      nconts = 0
c
c---  vdw_contacts
      if(lenstr(all_contacts_file).gt.0) then
         call open_unform_file(iscr1,all_contacts_file,ierr)
         if(ierr.gt.0) then
            call errwrt(-1,'Problem in opening all contacts file')
            return
         endif
         read(iscr1)nvdw
         do iv=1,nvdw
            read(iscrv)ia1(1:2),symm(1:4)
            write(iscrt)ia1(1:2)
            nconts=nconts+1
         enddo
         close(iscrv)
      endif
c
c---bonds
      if(lenstr(bond_file).gt.0) then
         call open_unform_file(iscr1,bond_file,ierr)
         read(iscr1)nbonds
         do ib=1,nbonds
            read(iscr1,iostat=iend)ia1(1:2),vidls(1:2),symm(1:4),btype
            write(iscrt)ia1(1:2)
            nconts = nconts+1
         enddo
         close(iscr1)
      endif
c
c---angles
      if(lenstr(angle_file).gt.0) then
         call open_unform_file(iscr1,angle_file,ierr)
         read(iscr1,iostat=iend) nangles
         if(nangles.gt.0) then
            read(iscr1,iostat=iend)ia1(1:3),(is_t(1:4,i),i=1,3),
     &           vidls(1:4)
            ia = 1
            do while(iend.eq.0.or.ia.le.nangles) 
               do i=1,2
                  do j=i+1,3
                     write(iscrt)ia1(i),ia1(j)
                     nconts = nconts + 1
                  enddo
               enddo
               read(iscr1,iostat=iend)ia1(1:2),(is_t(1:4,i),i=1,4),
     &              vidls(1:4)
               ia = ia + 1
            enddo
         endif
         close(iscr1)
      endif
c
c---torsions
      if(lenstr(tors_file).gt.0) then
         call open_unform_file(iscr1,tors_file,ierr)
c
c---- symmetry
         read(iscr1,iostat=iend)ntors
         if(ntors.gt.0) then
            read(iscr1,iostat=iend)ia1(1:4),(is_t(1:4,i),i=1,4),
     &           tperiod,vidls(1:2),btype
            ia = 1
            do while(iend.eq.0.and.ia.le.ntors)
               do i=1,3
                  do j=i+1,4
                     write(iscrt)ia1(i),ia1(j)
                     nconts = nconts+1
                  enddo
               enddo
c
c---  symmetry
               read(iscr1,iostat=iend)ia1(1:4),(is_t(1:4,i),i=1,4),
     &              tperiod,vidls(1:2),btype
               ia = ia + 1
            enddo
         endif
         close(iscr1)
      endif
c
c---  chirals
      if(lenstr(chir_file).gt.0) then
         call open_unform_file(iscr1,chir_file,ierr)
c
c---  symmetry
         read(iscr1,iostat=iend)nchir
         if(nchir.gt.0.and.iend.eq.0) then
            read(iscr1,iostat=iend)ia1(1:4),(is_t(1:4,i),i=1,4),
     &           vidls(1:2),btype
            ia = 1
            do while(iend.eq.0.and.ia.le.nchir)
               do i=1,3
                  do j=i+1,4
                     write(iscrt)ia1(i),ia1(j)
                     nconts = nconts + 1
                  enddo
               enddo
               read(iscr1,iostat=iend)ia1(1:4),(is_t(1:4,i),i=1,4),
     &              vidls(1:2),btype
               ia = ia + 1
            enddo
         endif
         close(iscr1)
      endif
c
c---planes
      if(lenstr(plane_file).gt.0) then
         call open_unform_file(iscr1,plane_file,ierr)
c
c--   symmetry
         read(iscr1,iostat=iend)nplane,nmaxatom_in_plane
         if(iend.eq.0.and.nplane.gt.00) then
            read(iscr1,iostat=iend)npl,vidls(1:2),ia1(1:npl),
     &           (is_t(1:4,i),i=1,npl)
            ia = 1
            do while(iend.eq.0.and.ia.le.nplane)
               do i=1,nplane-1
                  do j=i+1,nplane
                     write(iscrt)plane_pairs(i),plane_pairs(j)
                     nconts = nconts + 1
                  enddo
               enddo
               read(iscr1,iostat=iend)npl,vidls(1:2),ia1(1:npl),
     &              (is_t(1:4,i),i=1,npl)
               ia = 1
            enddo
         endif
         close(iscr1)
      endif
c
c---ncs similarities
      if(lenstr(ncs_simil_file).gt.0) then
         call open_unform_file(iscr1,ncs_simil_file,ierr)
         read(iscr1)nall_ncs
         do i=1,number_ncs
            read(iscr1)ncs_quart(1:4),vsigma
            do j=1,3
               do k=j+1,4
                  write(iscrt)ncs_quart(j),ncs_quart(k)
               enddo
            enddo
         enddo
         close(iscr1)
      endif
c
c---  rigid bond
      if(lenstr(rigid_bond_file).gt.0) then
         call open_unform_file(iscr1,rigid_bond_file,ierr)
         if(ierr.eq.0) then
            read(iscr1,iostat=ieof)nbonds_rigid
            if(ieof.eq.0.and.nbonds_rigid.gt.0) then
               read(iscr1,iostat=ieof)ia1(1:2),vsigma,symm,ityp
               if(ieof.eq.0) then
                  write(iscrt)ia1(1),ia1(2)
               endif
            endif
         endif
      endif
c
c--General similarity file
c
c---general similarities
      if(lenstr(gen_simil_file).gt.0) then
         call open_unform_file(iscr1,gen_simil_file,ierr)
         read(iscr1)nsim_pairs
         do i=1,nsim_pairs
            read(iscr1)ncs_quart(1:4),vsigma
            do j=1,3
               do k=j+1,4
                  write(iscrt)ncs_quart(j),ncs_quart(k)
               enddo
            enddo
         enddo
         close(iscr1)
      endif
c
c---General distance file

c
c--Now read the file, sort it and remove duplicates.
      rewind(iscrt)
      allocate(all_pairs(2,nconts))
      nc1 = 1
      do i=1,nconts
         read(iscrt)ia1(1:2)
         if(ia1(1).ne.ia1(2)) then
            nc1 = nc1 + 1
            all_pairs(1:2,nc1) = ia1(1:2)
            if(all_pairs(1,i).gt.all_pairs(2,i)) then
               call swap_int(all_pairs(1,i),all_pairs(2,i))
            endif
         endif
      enddo
      call iheap_sort_0(nconts,2,all_pairs)
c
c---Remove redundunts and write to a file
      ia1(1:2)=all_pairs(1:2,1)
      nc1 = 1
      if(nconts.gt.1) then
         do  i=2,nconts
            if(ia1(1).ne.all_pairs(1,i).or.
     &           ia1(2).ne.all_pairs(2,i)) then
               nc1 = nc1+1
               all_pairs(1:2,nc1) = all_pairs(1:2,i)
               ia1(1:2) = all_pairs(1:2,i)
            endif
         enddo
      endif
c
c---  Add pairs due to alternative groups

      rewind(iscrt)
      write(iscrt)nc1
      do i=1,nc1
         write(iscrt)all_pairs(1:2,i)
      enddo
      close(unit=iscrt)
      npairs = nc1
      deallocate(all_pairs)
      return
      end
c
      subroutine all_pairs_refmac(npairs,all_pairs,ierr)
      implicit none
      include 'restr_files.fh'
c
      integer npairs,ierr
      real all_pairs(2,npairs)
c
      integer i,iscrv,np1
c
      call open_unform_file(iscrv,all_contacts_file,ierr)
      if(ierr.gt.0) then
         call errwrt(-1,'Problem i all pairs')
         return
      endif
c
      read(iscrv)np1
      if(np1.ne.npairs) then
         call errwrt(-1,'Problem: input npairs and that from'//
     &        ' file are different')
         ierr=1
         return
      endif
c
      do  i=1,np1
         read(iscrv)all_pairs(1:2,i)
      enddo
c
      close(iscrv)
      return
      end
