      subroutine sf_calc_and_scale(calc_mode,fvalue_out,gx,gu,gq,hxx,
     &     huu,hqq,hqu)
      implicit none
      include 'atom_com.fh'
      include 'atom_com_str.fh'
      include 'restr_files.fh'
      include 'solvent.fh'
      include 'celsym.fh'
      include 'const_refmac.fh'
      include 'refi_flags.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'rharvest.fh'
c
c     dfdover - gradients for overall parameters
c     d2fdover2 - "second" derivatives for overall paramaters
c
c---  Overall parameters
c--   scale (simple, babinet, partial structure factors)
c--   alpha - twin domains
c--   sigma - parameters of sigma
c
c--This subroutine calculates structure factors, scales
c--them to observation and calculates overall ML parameters.
c--It also calculates statistics
c
      real fvalue_out
      real gx(3,n_atom),gu(6,n_atom),gq(n_atom)
      real hxx(3,3,n_atom),huu(6,6,n_atom),hqq(n_atom),hqu(6,n_atom)
      character calc_mode*(*)
c
      integer nasym
      integer nexcl_atom
      integer, allocatable :: hkl_asym(:,:)
      real, allocatable :: hl_abcd(:,:)
      real, allocatable :: fsolvent(:,:)
      real, allocatable :: fcalc(:,:)
      real, allocatable :: fpart(:,:,:)
      integer, allocatable :: excl_atom_num(:)
c---Observations
      integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      integer, allocatable :: list_2_blocks(:)
      real, allocatable :: iobs(:,:)
      real, allocatable :: fexpected(:,:)
      real, allocatable :: dfdab(:,:)
      real, allocatable :: d2fd2ab(:)
c
      integer ierr
      integer io1,ib,io,jnum_o,ko1
      integer ii,jj,kk
      integer jb1,jb2,js1,js2,jo1,jo2,jas_i,jas_a
c--------------------------------------
      character chnid_loc*1
      integer ires_num_loc
      integer iexcl
      integer ia
      integer i,j,k,ip
      integer ifail,ll,in_file,iout
      integer l
      character scratch*512
      integer lenstr
      external lenstr
      real sumal,a1,b1
      real fmod,phi,cc
c--First read the reflections for asymmetric unit
      calc_mode = 'S'
      ifail = -1
      ll    = 0
      in_file = 0
      call ccpdpn(in_file,refl_asym,'UNKNOWN','U',ll,ifail)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
   
c--If phase info is available then use it also. We could make it as if
c--it is always present. Perhaps it is better way of dealing with this problem
c--
c
      do  i=1,nasym
        read(in_file)hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)
      enddo
      close(in_file)
c
c--If abcd is available then read it.
c
c
c---This portion of the program will become independent solvent contribution
c---calculation
c
      if(solvent_flag) then
        allocate(fsolvent(2,nasym))
        allocate(excl_atom_num(n_atom))
        do  ia=1,n_atom
           excl_atom_num(ia) = 0
        enddo
        nexcl_atom = 0
        if(excl_refi_num.gt.0) then
          do   ia=1,n_atom_mod(1)
              chnid_loc = res_num_pdb(i_resid(ia,1))(1:1)
              read(res_num_pdb(i_resid(ia,1))(3:6),*)ires_num_loc
              do   iexcl=1,excl_refi_num
                 if(excl_refi_begin(iexcl).le.ires_num_loc.and.
     &                excl_refi_end(iexcl).ge.ires_num_loc.and.
     &                excl_refi_chn(iexcl).eq.chnid_loc) then
                    nexcl_atom = nexcl_atom + 1
                    excl_atom_num(nexcl_atom) = ia
                 endif
              enddo
           enddo
        endif
        call calc_mask_solvent(maxatom,n_atom,xyz_crd,occup,
     &       vdw_rad,ion_rad,maxnso,cs_nsym,cs_cell,cs_m_cs,cs_v_cs,
     &       fshann,prob_vdw,prob_ion,radii_shrink,nexcl_atom,
     &       excl_atom_num,stlmax,nasym,hkl_asym,fsolvent,atm_name)
        deallocate(excl_atom_num)
c
c
c---write contribution of solvent to a file of partial structures. Check if
c---we already have partial structures calculated before this routine.
c---If we have a file.
c
        if(solvent_file.eq.' ') then
           call ugtenv('TEMP1',scratch)
           l = lenstr(scratch)
           if(l.gt.0) then
              solvent_file = scratch(1:l)//'.solvent'
           else
              solvent_file = '1.solvent'
           endif
         endif
         ifail = -1
         iout = 0
         ll = 0
         call ccpdpn(iout,solvent_file,'UNKNOWN','U',ll,ifail)
         do i=1,nasym
            write(iout)fsolvent(1,i),fsolvent(2,i)
         enddo
         close(iout)
         iout = 0
         deallocate(fsolvent)
      endif
c
c--This portion of the program will go to several subroutines:
c--function calculation, grad calculation, map calculation etc. 
c--
c
c--First calcuate strcuture factors from coordinates
c
      allocate(fcalc(2,nasym))
c
c---calculate structure factors from coordinates using density     
      call sf_calc(maxatom,n_atom,xyz_crd,occup,u_aniso,id_sf,maxnsf,
     &     cs_nsfatm,cs_a,cs_b,cs_fi,cs_fii,maxnso,cs_nsym,cs_cell,
     &     cs_m_cs,cs_v_cs,stlmax,fshann,ddlim,nasym,hkl_asym,
     &     fcalc)
c
c---  Read partial strictire factors and solvent contributions
      npart_act = 0
      if(partial_file.ne.' ') then
c
c--   find number of partials
      endif
      if(solvent_file.ne.' ') then
         npart_act = npart_act + 1
      endif
      if(npart_act.ge.1) then
      
      endif
      
      if(npart_act.gt.0) then
         allocate(fpart(npart_act,2,nasym))
      else

      endif

      if(solvent_file.ne.' ') then
         ifail   = -1
         ll      =  0
         in_file = 0
         call ccpdpn(in_file,solvent_file,'UNKNOWN','U',ll,ifail)
         do  i=1,nasym
            read(in_file) fpart(1,1,i),fpart(1,2,i)
         enddo
         close(in_file)
         in_file = 0
      endif
C
C---  Now read observations. First number of reflection to allocate memory
      ifail = -1
      in_file = 0
      ll = 0
      call ccpdpn(in_file,refl_file,'UNKNOWN','U',ll,ifail)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c     
c---  We need to define memories
      allocate(freer(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(iobs(2,nobs))
      allocate(obs_start(nobs+1))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      allocate(hl_abcd(4,nasym))
      allocate(fexpected(2,nasym))
      num_list = num_blocks
      allocate(list_2_blocks(num_blocks))
      do  ib=1,num_blocks
         list_2_blocks(ib) = ib
      enddo
c
c--   read abcd       
      hl_abcd(1:4,1:nasym) = 0.0
c
c---  How many fractions do we have. Need to be stored somewhere.
      block_start(1) = 0
      obs_start(1) = 0
      io1 = 1
      ref_2_asym_start(1) = 0
      ii = 0
      ndomain_tw = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
            io1 = io1 + 1
c            write(*,*)'jnum_o',jnum_o
c            write(*,*)'iobs iobs',iobs(1,ii),iobs(2,ii)
c            stop
            do   jj=1,jnum_o
              ndomain_tw = max(ndomain_tw,comp_numb(jo1+jj))
            enddo 
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
      enddo
      close(in_file)
c
c--It needs to be done outside
      do  i=1,nasym
         a1 = fcalc(1,i)*cos(fcalc(2,i))
         b1 = fcalc(1,i)*sin(fcalc(2,i))
         fcalc(1,i) = a1
         fcalc(2,i) = b1
         do  ip=1,npart_act
            a1 = fpart(ip,1,i)*cos(fpart(ip,2,i))
            b1 = fpart(ip,1,i)*sin(fpart(ip,2,i))
            fpart(ip,1,i) = a1
            fpart(ip,2,i) = b1
         enddo
      enddo
c
      if(.not.linit) then
         call init_ls_params(maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &        nasym,hkl_asym,fcalc,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        ierr)
         linit = .TRUE.
      endif
c
c---  start scaling      
      call refine_ls_parameters(maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &     num_list,list_2_blocks,
     &     nasym,hkl_asym,fcalc,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)

      call r_factor(maxsym,nsym,rot,tr,cell,
     &     nasym,hkl_asym,fcalc,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     nmaxpart,npart_act,ndomain_tw,alpha,
     &     b_ls_aniso_over,scale_ls_over,b_ls_over,scale_ls_bulk,
     &     b_ls_bulk,scale_ls_part,b_ls_part,ierr)
    
      write(*,*)'Twin fractions =',alpha(1:ndomain_tw)
      write(*,*)'rfactor_all    = ',rfactor_all,
     &          'rfactor_work   = ',rfactor_work,
     &          'rfactor_free   = ',rfactor_free
c      stop
c
c---  We need nblocks,ncomponentsall,ncomponents,nref2asym,free, 
      write(*,*)'before init_sigma'
      if(.not.mlinit) then
         call init_sigma_pars(maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &        num_list,list_2_blocks,
     &        nasym,hkl_asym,fcalc,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        ierr)
         mlinit = .TRUE.
      endif

      write(*,*)scale_ml_over,b_ml_over
      write(*,*)sigma_ml_scale_over,sigma_ml_b_over
      write(*,*)sigma_ml_scale_bulk,sigma_ml_b_bulk
c
c
c---  Use multivariate gaussian approximation
c      stop
c      call refine_ml_parameters_gauss(maxnso,cs_nsym,ndomain_tw,
c     &     nasym,nobs,ncomp,npart_act,num_asym_ref,
c     &     cs_cell,cs_m_cs,cs_v_cs,alpha,
c     &     block_start,ref_2_asym_start,
c     &     block_2_asym,hkl_asym,fcalc,fpart,obs_start,comp_numb,
c     &     num_blocks,iobs,ref_2_asym,nmaxpart,b_ml_aniso_over,
c     &     scale_ml_over,b_ml_over,scale_ml_bulk,b_ml_bulk,
c     &     scale_ml_part,b_ml_part,sigma_ml_exp) 
c
c      stop
      write(*,*)' before expected'
       call ml_getexpected_f(maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &      nasym,hkl_asym,fcalc,fpart,
     &      num_blocks,block_start,ref_2_asym_start,
     &      nobs,iobs,obs_start,
     &      ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &      num_asym_ref,block_2_asym,fexpected,ierr)
c
c---We can deallocate few arrays
       if(calc_mode.eq.'G') then
c
c---  That needs to be calculated later for full refinement
c          call derivs_ml_over(maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
c     &         nasym,hkl_asym,fcalc,fpart,
c     &         num_blocks,block_start,ref_2_asym_start,
c     &         nobs,iobs,obs_start,
c     &         ncomp,comp_numb,ref_2_asym,ref_2_symm,
c     &         num_asym_ref,block_2_asym,fexpected,nover_par,
c     &         dfdover,d2fdover2,ierr)
c
          allocate(dfdab(2,nasym))
          allocate(d2fd2ab(nasym))
          call calc_ml_dfdab(
     &         nasym,hkl_asym,fcalc,fpart,fexpected,hl_abcd,
     &         dfdab,d2fd2ab,ierr)
c
c---  Calculate gradients and approx secders
c          call calc_grads_secder(maxatom,n_atom,xyz_crd,occup,u_aniso,
c     &         id_sf,atom_ref_flag,
c     &         maxnsf,cs_nsfatm,cs_a,cs_b,cs_fi,cs_fii,maxnso,cs_nsym,
c     &         cs_cell,cs_m_cs,cs_v_cs,
c     &         nasym,stlmax,fshann,ddlim,dglim,hkl_asym,dfdab,d2fd2ab,
c     &         gx,gu,gq,hxx,huu,hqq,hqu)

          deallocate(dfdab)
          deallocate(d2fd2ab)
       else
c
c---  the first and the second derivatives of function wrt a and b
          write(*,*)' after expected'
          call write_mtz_file(maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &         nasym,hkl_asym,fcalc,fpart,fexpected,ierr)
       endif
c
c---  deallocate all allocated memory and return
      deallocate(freer)
      deallocate(block_start)
      deallocate(ref_2_asym_start)
      deallocate(iobs)
      deallocate(obs_start)
      deallocate(comp_numb)
      deallocate(ref_2_asym)
      deallocate(ref_2_symm)
      deallocate(block_2_asym)
      deallocate(hl_abcd)
      deallocate(list_2_blocks)
      deallocate(hkl_asym)
      deallocate(fcalc)
      deallocate(fpart)
      deallocate(fexpected)

c      call ccperr(1,'End of mapcalc')
      return
      end
c
      subroutine init_ls_params(maxsym,nsym,rot,tr,cell,
     &     nasym,hkl_asym,fcalc,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr) 
c
c---Initialise ls scale parameters
c-------------------------------------------------------------------
c
c---  inputs
      implicit none
      include 'agreem.fh'
      include 'restr_files.fh'
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)

      integer nasym
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
c---Outputs
      integer ierr
c
c---locals

      integer i,j,o_s,o_f,c_1,num_obs_all
      real sumal,iover,icover
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss
      real ssqmax_loc,ssqmin_loc
c
c---body
c---------------------------------------------------------------
c
c---alphas. Assume that the first domain is the largest (a little bit larger than others)
      do i=1,ndomain_tw
        alpha(i) = 1.0/real(ndomain_tw)
      enddo
      alpha(1) = alpha(1) + 0.2
      sumal = 0.0
      do  i=1,ndomain_tw
         sumal = sumal + alpha(i)
      enddo
      do  i=1,ndomain_tw
        alpha(i) = alpha(i)/sumal
      enddo
c
c---anisotropic B values are 0. Initialise all others
      do  i=1,6
         b_ls_aniso_over(i) = 0.0
      enddo
      b_ls_over = 0.0
      scale_ls_bulk = 0.4
      b_ls_bulk     = 200.0
      do   i=1,npart_act
         scale_ls_part(i) = 0.33
         b_ls_part(i) = 100.0
      enddo
c
c---  Initialise overall scale parameters: average observation/average calculated
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierr)
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)

      iover = 0.0
      icover = 0.0
      num_obs_all = 0
      ssqmax_loc = -1.0e32
      ssqmin_loc =  1.0e32
      do  i=1,num_blocks
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_1 = ref_2_asym_start(i) + 1
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),
     &        ast,bst,cst,cosast,cosbst,coscst,rsq)
         ssqmax_loc = max(ssqmax_loc,rsq)
         ssqmin_loc = min(ssqmin_loc,rsq)
         do j=o_s,o_f
            num_obs_all = num_obs_all + 1
            iover = iover + max(0.0,iobs(1,j))
         enddo
      enddo
      iover = iover/num_obs_all
      do  i=1,nasym
         call define_res(hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i),
     &        ast,bst,cst,cosast,cosbst,coscst,rsq)
         if(rsq.le.ssqmax_loc.and.rsq.ge.ssqmin_loc) then
            icover = icover + fcalc(1,i)**2+fcalc(2,i)**2
         endif
      enddo
      icover = icover/nasym
      if(icover.gt.0.0) then
         scale_ls_over = iover/icover
      else
         scale_ls_over = 1.0
      endif
c
c---Do initial scaling of observations. It should not affect the results
      do  i=1,num_blocks
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         do j=o_s,o_f
            iobs(1,j) = iobs(1,j)/scale_ls_over
            iobs(2,j) = iobs(2,j)/scale_ls_over
         enddo
      enddo
      scale_ls_init = scale_ls_over
      scale_ls_over = 1.0
      return
      end
c     
      subroutine  init_sigma_pars(maxsym,nsym,rot,tr,cell,
     &     num_list,list_2_blocks,
     &     nasym,hkl_asym,fcalc,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'agreem.fh'
      include 'restr_files.fh'
      integer maxsym,nsym
      real cell(6),rot(3,3,maxsym),tr(3,maxsym)

      integer num_list
      integer list_2_blocks(num_list)
      integer nasym
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      integer ierr
c
c---locals
      integer naver
      real, allocatable :: saver(:)
      real, allocatable :: faver(:)
      real, allocatable :: f2aver(:)
c
      integer maxcont_l
      parameter (maxcont_l = 48)
      real  Ic(maxcont_l)
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)
      real a_all,b_all,ict,io0,exp1,expb,expbs,expbs_bulk,expban
      real s_b_part
      real hkl_this(3)
      real ast,bst,cst,cosast,cosbst,coscst,s,ss,rsq
      integer npar,npar_s
      real dsigmadp(6),d2sdp2(6,6)
      real diff,df(6),d2f(6,6),shift(6)
      real sigma_loc(2),sigma_bulk(2)
      real toler
      integer il
      integer i,j,m,k,jc,jal,is,ip,jp,ip1,iint
      integer o_s,o_f,c_s,c_f,c_n,o_c_s,o_c_f,c_1
      integer ierror
      logical error
c
      integer icycle,ncycle
      integer icent
      real cent,eps,obs2e,ss2
      integer, allocatable :: irot(:,:,:)
c
      real Ict0,Ict1,del,del2,bulk_cont
      integer l,n1_l,ii
      real expbulks,bulk,bulk2,expbulk,cnt,sigma,snorm,d2fds2
      real dfdsc,d2fd2sc
      real part_expbs
      real fvalue,fvalue_old,dfds,smax_l
      real b_ml_0,scale_ml_0,sigma_ml_over,sigma_cur,sigma_l
      real sigma_n0,sigma_l0
      real sigma_bulk_cont,sigma_bulk_cont2,sigma_bulk_exp
      real sigma_bulk_exps
      real sigma_exp,sigma_exps
      real lam

c
c---Apply overall scale to observations 
c
c---It needs to be done in the beginning. Pseudotrans should be recognised
c---Unreasonable patterson also should be identified
      ncycle = 20
      allocate(irot(3,3,nsym))
      irot(1:3,1:3,1:nsym)=nint(rot(1:3,1:3,1:nsym))
c
      toler = 1.0e-8
      df(1:3) = 0.0
      d2f(1:3,1:3) = 0.0
      sigma_ml_exp(1:3) = 0.0
c
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)

      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
c
c---Initialise scale parameters. Use ls parameters
      do  i=1,num_blocks
         o_s = block_start(i) + 1
         o_f = block_start(i+1)
         iobs(1:2,o_s:o_f) = iobs(1:2,o_s:o_f)/scale_ls_over
      enddo
      scale_ls_init = scale_ls_init*scale_ls_over
      scale_ls_over = 1.0
c
      scale_ml_0 = 0.5
      b_ml_0     = 0.0
      scale_ml_over = scale_ls_over
      b_ml_over     = b_ls_over
      scale_ml_part(1:npart_act) = scale_ls_part(1:npart_act)
      b_ml_part(1:npart_act)      = b_ls_part(1:npart_act)
      scale_ml_bulk = scale_ls_bulk
      b_ml_bulk     = b_ls_bulk
      write(*,*)scale_ml_bulk,b_ml_bulk
      write(*,*)scale_ml_part(1:npart_act),b_ml_part(1:npart_act)
c
      df(1:2) = 0.0
      d2f(1:2,1:2) = 0.0
      do i=1,num_blocks
         o_s = block_start(i) + 1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         call  geneps_centr(hkl_asym(1:3,c_1),nsym,nsym,irot,
     &        eps,icent)
c     
c---  All reflections in this block have the same resolution. For inital values
c---  it may work
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq) 
         ss  = rsq/4
         ss2 = ss*ss
         s   = sqrt(rsq)
         expbs = scale_ml_over*exp(-ss*b_ml_over)
         bulk_cont=1.0-scale_ml_bulk*exp(-ss*b_ml_bulk)
         expbs_bulk = bulk_cont*expbs
         jc = 0
         Ic(1:maxcont_l) = 0.0
         do m=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(m)
            a_all = fcalc(1,c_n)
            b_all = fcalc(2,c_n)
            hkl_this(1:3) = real(hkl_asym(1:3,c_n))
            call calc_aniso_scale(maxsym,nsym,rot,tr,cell,
     &           cs_ort_to_frac,hkl_this,b_ls_aniso_over,expban)
            do ip=1,npart_act
               part_expbs = scale_ml_part(ip)*exp(-ss*b_ml_part(ip))
               a_all = a_all + fpart(ip,1,c_n)*part_expbs
               b_all = b_all + fpart(ip,2,c_n)*part_expbs
            enddo
            Ic(jc) = (a_all**2+b_all**2)*expban
         enddo
c
         do j=o_s,o_f
            o_c_s = obs_start(j) + 1
            o_c_f = obs_start(j+1)
            Ict0 = 0.0
            do k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               Ict0 = Ict0 + Ic(jc)*alpha(jal)
            enddo
            Ict = Ict0*expbs_bulk
            del = sqrt(max(0.0,iobs(1,j)))-sqrt(Ict)
c            write(*,*)del,iobs(1,j),Ict
            if(abs(del).gt.0.0) then
               del2 = log(abs(del)**2/((1+icent)*eps))
               df(1) = df(1) + del2
               df(2) = df(2) -ss*del2
               d2f(1,1) = d2f(1,1) + 1.0
               d2f(1,2) = d2f(1,2) - ss
               d2f(2,2) = d2f(2,2) + ss2
            endif
         enddo
      enddo

      d2f(2,1) = d2f(1,2) 
      call eigen_filter_r90(toler,d2f(1:2,1:2),2,2,df(1:2),
     &     sigma_loc(1:2),ierr)
c
      sigma_ml_scale_over = sigma_loc(1)
      sigma_ml_b_over     = sigma_loc(2)
      sigma_ml_scale_bulk = log(0.7)
      sigma_ml_b_bulk     = 200.0
c      stop
c
c--Now we need to refine these scale parameters using gaussian assumption
      fvalue_old = 1.0E32
      npar = 6
      npar_s = 4
      scale_ml_over = log(scale_ml_over)
      do icycle=1,ncycle
         df(1:npar) = 0.0
         d2f(1:npar,1:npar) = 0.0
         fvalue = 0.0
         do il=1,num_list
            i = list_2_blocks(il)
            o_s = block_start(i) + 1
            o_f = block_start(i+1)
            c_s = ref_2_asym_start(i)+1
            c_f = ref_2_asym_start(i+1)
            c_1 = block_2_asym(c_s)
            call  geneps_centr(hkl_asym(1:3,c_1),nsym,nsym,irot,
     &           eps,icent)
c            cent = 1+icent
            cent = 1.0
c     
c---  All reflections in this block have the same resolution. For inital values
c---  it may work
            call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &           hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq) 
            ss  = rsq/4
            ss2 = ss*ss
            s   = sqrt(rsq)
            expbs  = exp(scale_ml_over-ss*b_ml_over)
c            expbs = scale_ml_over*expb
            bulk_cont=1.0-scale_ml_bulk*exp(-ss*b_ml_bulk)
            expbs_bulk = bulk_cont*expbs
            jc = 0
            Ic(1:maxcont_l) = 0.0
            sigma_exp = exp(sigma_ml_scale_over-ss*sigma_ml_b_over)
            sigma_bulk_exp = exp(sigma_ml_scale_bulk-ss*sigma_ml_b_bulk)
            sigma_bulk_cont = 1.0-sigma_bulk_exp
            sigma_bulk_cont2 = sigma_bulk_cont**2
            sigma_l = sigma_exp*sigma_bulk_cont
            dsigmadp(1) = sigma_exp*sigma_bulk_cont
            dsigmadp(2) = -ss*sigma_exp*sigma_bulk_cont
            dsigmadp(3) = -sigma_bulk_exp*sigma_exp
c*sigma_bulk_cont
            dsigmadp(4) =  ss*sigma_bulk_exp*sigma_exp
            dsigmadp(5) = expbs/2.0
            dsigmadp(6) = -ss*expbs/2.0
c*     &           sigma_bulk_cont
            do  ip=1,npar
               do jp=1,npar
                  d2sdp2(ip,jp) = dsigmadp(ip)*dsigmadp(jp)
               enddo
            enddo

            do m=c_s,c_f
               jc = jc + 1
               c_n = block_2_asym(m)
               a_all = fcalc(1,c_n)
               b_all = fcalc(2,c_n)
               hkl_this(1:3) = real(hkl_asym(1:3,c_n))
               call calc_aniso_scale(maxsym,nsym,rot,tr,cell,
     &              cs_ort_to_frac,hkl_this,b_ls_aniso_over,expban)
               do ip=1,npart_act
                  part_expbs = scale_ml_part(ip)*exp(-ss*b_ml_part(ip))
                  a_all = a_all + fpart(ip,1,c_n)*part_expbs
                  b_all = b_all + fpart(ip,2,c_n)*part_expbs
               enddo
               Ic(jc) = (a_all**2+b_all**2)*expban
            enddo
c     
            do j=o_s,o_f
c               if(iobs(1,j).gt.0.0) then
               o_c_s = obs_start(j) + 1
               o_c_f = obs_start(j+1)
               Ict0 = 0.0
               do k=o_c_s,o_c_f
                  jc = ref_2_asym(k)
                  jal = comp_numb(k)
                  Ict0 = Ict0 + Ic(jc)*alpha(jal)
               enddo
               Ict = Ict0*expbs_bulk
               Ict1 = sqrt(Ict0*bulk_cont)
               del = sqrt(max(0.0,iobs(1,j)))-sqrt(Ict)
               del2 = (del)**2/(cent*eps)
               fvalue = fvalue + del2/(cent*sigma_l)+log(sigma_l)/cent
               dfds = -del2/(cent*sigma_l**2)+1/(cent*sigma_l)
               dfdsc = -2.0*Ict1*del/(cent*sigma_l)
               d2fd2sc = 4.0*Ict1**2/(cent*sigma_l)
               d2fds2 = 1/(cent*sigma_l**2)
               df(1:npar_s) = df(1:npar_s) + dfds*dsigmadp(1:npar_s)
               d2f(1:npar_s,1:npar_s)  = d2f(1:npar_s,1:npar_s) + 
     &              d2fds2*d2sdp2(1:npar_s,1:npar_s)
c
               df((npar_s+1):npar) = df((npar_s+1):npar)+
     &              dfdsc*dsigmadp((npar_s+1):npar)
               d2f((npar_s+1):npar,(npar_s+1):npar)=
     &              d2f((npar_s+1):npar,(npar_s+1):npar)+
     &              d2fd2sc*d2sdp2((npar_s+1):npar,(npar_s+1):npar)
c               endif
            enddo
         enddo
         write(*,*)fvalue,fvalue_old,scale_ml_over,b_ml_over
         write(*,*)sigma_ml_scale_over,sigma_ml_b_over
         write(*,*)sigma_ml_scale_bulk,sigma_ml_b_bulk
         if(fvalue.gt.fvalue_old) then

            goto 10
         endif
         fvalue_old = fvalue
c         write(*,*)'Fvalue =',fvalue
         call eigen_filter_r90(toler,d2f(1:npar,1:npar),npar,npar,
     &        df(1:npar),shift(1:npar),ierr)
         lam = 1.0
         sigma_ml_scale_over = sigma_ml_scale_over - lam*shift(1)
         sigma_ml_b_over     = sigma_ml_b_over     - lam*shift(2)
         sigma_ml_scale_bulk = sigma_ml_scale_bulk - lam*shift(3)
         sigma_ml_scale_bulk = 
     &        max(-10.0,min(log(0.9),sigma_ml_scale_bulk))
         sigma_ml_b_bulk     = sigma_ml_b_bulk     - lam*shift(4)
         sigma_ml_b_bulk     = max(0.0,min(400.0,sigma_ml_b_bulk))
         scale_ml_over       = scale_ml_over - lam*shift(5)
         b_ml_over           = b_ml_over - lam*shift(6)
         b_ml_over = max(-50.0,min(200.0,b_ml_over))
c         write(*,*)'sigma parameters '
c         write(*,*)sigma_ml_scale_over,sigma_ml_b_over
c         write(*,*)sigma_ml_scale_bulk,sigma_ml_b_bulk
      enddo
 10   continue
      scale_ml_over = exp(scale_ml_over)
c
      deallocate(irot)
      return
      open(60)
      do i=1,num_blocks
         o_s = block_start(i) + 1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         call  geneps_centr(hkl_asym(1:3,c_1),nsym,nsym,irot,
     &        eps,icent)
c     
c---  All reflections in this block have the same resolution. For inital values
c---  it may work
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq) 
         ss  = rsq/4
         ss2 = ss*ss
         s   = sqrt(rsq)
         expbs = scale_ml_over*exp(-ss*b_ml_over)
         bulk_cont=1.0-scale_ml_bulk*exp(-ss*b_ml_bulk)
         expbs_bulk = bulk_cont*expbs
         jc = 0
         Ic(1:maxcont_l) = 0.0
         sigma_exp = exp(sigma_ml_scale_over-ss*sigma_ml_b_over)
         sigma_bulk_exp = exp(sigma_ml_scale_bulk-ss*sigma_ml_b_bulk)
         sigma_bulk_cont = 1.0-sigma_bulk_exp
         sigma_l = sigma_exp*sigma_bulk_cont

         do m=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(m)
            a_all = fcalc(1,c_n)
            b_all = fcalc(2,c_n)
            hkl_this(1:3) = real(hkl_asym(1:3,c_n))
            call calc_aniso_scale(maxsym,nsym,rot,tr,cell,
     &           cs_ort_to_frac,hkl_this,b_ls_aniso_over,expban)
            do ip=1,npart_act
               part_expbs = scale_ml_part(ip)*exp(-ss*b_ml_part(ip))
               a_all = a_all + fpart(ip,1,c_n)*part_expbs
               b_all = b_all + fpart(ip,2,c_n)*part_expbs
            enddo
            Ic(jc) = (a_all**2+b_all**2)*expban
         enddo
c     
         do j=o_s,o_f
            o_c_s = obs_start(j) + 1
            o_c_f = obs_start(j+1)
            Ict0 = 0.0
            do k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               Ict0 = Ict0 + Ic(jc)*alpha(jal)
            enddo
            Ict = Ict0*expbs_bulk
            del = sqrt(max(0.0,iobs(1,j)))-sqrt(Ict)
            del2 = (del)**2/((1+icent)*eps)
            write(60,*)s,iobs(1,j),Ict,del2,sigma_l
         enddo
      enddo
      close(60)
      return
      end
c
      subroutine calc_ml_dfdab(nasym,hkl_asym,fcalc,fpart,fexpected,
     &     abcd,fval_out,dfdab,d2fd2ab,ierr)
      implicit none
      include 'agreem.fh'
      include 'mtz_params.fh'
      include 'celsym.fh'
c
      integer nasym
      integer hkl_asym(3,nasym)
      real fcalc(2,nasym),fpart(2,npart_act,nasym),fexpected(2,nasym)
      real abcd(4,nasym)
      real dfdab(2,nasym),d2fd2ab(nasym)
      real fval_out
      integer ierr
c
c---  locals
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)

      logical error
      integer i
      real rtodeg
      real cell_out(6)
      real a0,b0,a1,b1,fmod,fmod1,phi,phi1
      real bdata(20)
      real, allocatable :: fc1(:,:)
      real, allocatable :: sigmas(:)
      real, allocatable :: epsls(:)
      real, allocatable :: centrs(:)
c
      real hkl_this(3)
      real ast,bst,cst,cosast,cosbst,coscst,s,ss,rsq

      integer icent
      real abcd_l(4)
      real epscent1,dfdsigma0,dfdd
      real xx,fom_l
      real expbs,expbs_bulk,bulk_cont,sigma1
      real fmod_o,fmod_c,cosphi,sinphi
      real fval_p,cosexp,sinexp,cos2exp,sin2exp,sincosexp
      real fea,feb
      real sim
      external sim
c
c---  body
      allocate(fc1(2,nasym))
      allocate(sigmas(nasym))
      allocate(epsls(nasym))
      allocate(centrs(nasym))
c
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierr)
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
c
      call calc_epsls_centrs(nasym,maxsym,nsym,rot,hkl_asym,epsls,
     &     centrs)
      call calc_sigmas(nasym,cell,sigmas,hkl_asym,error)
      call  calc_full_fcalc(nasym,npart_act,cell,hkl_asym,
     &     fcalc,fpart,fc1,error)
c
      rtodeg = 45.0/atan2(1.0,1.0)
c
c--Experimental file
      fval_out = 0.0
      dfdsigma0 = 0.0
      do   i=1,nasym
         epscent1 = epsls(i)*(1.0+centrs(i))
         sigma1 = epsls(i)*sigmas(i)*(1.0+centrs(i))
         icent = int(centrs(i))
c
         call define_res(hkl_asym(1,i),hkl_asym(2,i),
     &        hkl_asym(3,i),ast,bst,cst,cosast,cosbst,coscst,rsq) 
         ss  = rsq/4
         s   = sqrt(rsq)
         expbs = scale_ml_over*exp(-ss*b_ml_over)
         bulk_cont=1.0-scale_ml_bulk*exp(-ss*b_ml_bulk)
         expbs_bulk = bulk_cont*expbs
c
c--calculate integrals over phases here
         fmod_o = sqrt(fexpected(1,i)**2+fexpected(2,i)**2)
         fmod_c = sqrt(fc1(1,i)**2+fc1(2,i)**2)
         if(fmod_c.gt.0.0) then
            cosphi = fc1(1,i)/fmod_c
            sinphi = fc1(2,i)/fmod_c
         else
            cosphi = 1.0
            sinphi = 0.0
         endif

         xx = 2.0*fmod_o*fmod_c/sigma1
         abcd_l(1) = abcd(1,i) + xx*cosphi
         abcd_l(2) = abcd(2,i) + xx*sinphi
         abcd_l(3) = abcd(3,i)
         abcd_l(4) = abcd(4,i)         
         call phase_prob_gen_vonmise(icent,abcd_l,fval_p,cosexp,sinexp,
     &        cos2exp,sin2exp)
c
c--About alphas, sigmas, overall scales, partials
         fval_out = fval_out + (fmod_o**2+fmod_c**2)/sigma1-fval_p +
     &        log(sigma1)/(1.0+centrs(i))
         fom_l = sqrt(cosexp**2+sinexp**2)
         fea   = fmod_o*cosexp
         feb   = fmod_o*sinexp
c
         dfdab(1,i) = (fea - fc1(1,i))/sigma1
         dfdab(2,i) = (feb - fc1(2,i))/sigma1
         dfdab(1,i) = dfdab(1,i)*expbs_bulk
         dfdab(2,i) = dfdab(2,i)*expbs_bulk

c
c---  may change this part a bit
         d2fd2ab(i) = expbs_bulk**2/sigma1
         dfdsigma0 =  (fmod_o**2+fmod_c**2-
     &        2.0*fom_l*fmod_o*fmod_c)/sigma1**2*epscent1
         dfdd = 2.0*(fmod_c - fom_l*fmod_o)/sigma1
c
c---And other things like alpha
      enddo
c
      deallocate(fc1)
      deallocate(sigmas)
      deallocate(epsls)
      deallocate(centrs)
      return
      end
c
      subroutine write_mtz_file(maxsym1,nsym1,rot1,tr1,cell1,
     &      nasym,hkl_asym,fcalc,fpart,fexpected,ierr)
      implicit none
      include 'agreem.fh'
      include 'mtz_params.fh'
      include 'celsym.fh'
c
      integer maxsym1,nsym1
      real rot1(3,3,maxsym1),tr1(3,maxsym1),cell1(6)
      integer nasym
      integer hkl_asym(3,nasym)
      real fcalc(2,nasym),fpart(2,npart_act,nasym),fexpected(2,nasym)
      integer ierr
c
c---  locals
      logical error
      integer i
      integer mtzout,iappnd
      real rtodeg
      real cell_out(6)
      real a0,b0,a1,b1,fmod,fmod1,phi,phi1
      real bdata(20)
      real, allocatable :: fc1(:,:)
      real, allocatable :: sigmas(:)
      real, allocatable :: epsls(:)
      real, allocatable :: centrs(:)
c
      real xx,fom_l,ss
      real sim
      external sim
c
c---  body
      allocate(fc1(2,nasym))
      allocate(sigmas(nasym))
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call calc_epsls_centrs(nasym,maxsym,nsym,rot,hkl_asym,epsls,
     &     centrs)
      call calc_sigmas(nasym,cell,sigmas,hkl_asym,error)
      call  calc_full_fcalc(nasym,npart_act,cell,hkl_asym,
     &     fcalc,fpart,fc1,error)
c
      rtodeg = 45.0/atan2(1.0,1.0)
      mtzout = 2
      iappnd = 0
      call lwopen(mtzout,'HKLOUT')
      call lwtitl(mtzout,'Output mtz from map_coefs',1)
      cell_out(1:6) = cell1(1:6)
      do  i=4,6
         if(maxval(cell(4:6)).le.5.0) then
            cell_out(4:6)  = cell1(4:6)*rtodeg
         endif
      enddo
c
c
c--Experimental file
      open(70)
      call lwcell(mtzout,cell_out)
      isort(1:5) = 0
      call lwsort(mtzout,isort)
      call lwsymm(mtzout,nsym1,numprimsymm,realsymmmatrx,ltype,
     &     numspacegroup,spacegroupname,pointgroupname)

      call lwassn(mtzout,lsprgo,nlprgo,ctprgo,iappnd)
c
      do   i=1,nasym
         call equal_magic(mtzout,bdata,20)
         bdata(1:3) = real(hkl_asym(1:3,i))
         XX = sqrt(fexpected(1,i)**2+fexpected(2,i)**2)*
     &        sqrt(fc1(1,i)**2+fc1(2,i)**2)/(epsls(i)*sigmas(i))
         if(nint(centrs(i)).eq.0) then
            fom_l = sim(2.0*xx)
         else
            fom_l = tanh(xx)
         endif
         a0 = (fexpected(1,i) - fc1(1,i))
         b0 = (fexpected(2,i) - fc1(2,i))
         a1 = fexpected(1,i) + a0
         b1 = fexpected(2,i) + b0
         write(70,*)a0**2+b0**2,epsls(i)*sigmas(i)

c         a1 = fom_l*fexpected(1,i)
c         b1 = fom_l*fexpected(2,i)
c         write(*,*)sqrt(fexpected(1,i)**2+fexpected(2,i)**2),
c     &        sqrt(fc1(1,i)**2+fc1(2,i)**2)
         fmod = sqrt(a0**2+b0**2)
         fmod1 = sqrt(a1**2+b1**2)
         phi = 0
         if(fmod.gt.0.0) phi = atan2(b0,a0)*rtodeg
         phi1 = 0.0
         if(fmod1.gt.0.0) phi1 = atan2(b1,a1)*rtodeg
         bdata(4) = fmod1
         bdata(5) = phi1
         bdata(6) = fmod
         bdata(7) = phi
         call lwrefl(mtzout,bdata)
      enddo
      close(70)
      call lwclos(mtzout,0)
c
      deallocate(fc1)
      deallocate(sigmas)
      deallocate(epsls)
      deallocate(centrs)
      return
      end
