      SUBROUTINE SET_MOD(MDOC,IERR)    
C -----------------------------------------------
C -P- SET_MOD - set type of terminus residues.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256,GROUP*4,MON*8,LINK*8
C     CHARACTER ATOM*4,CHAIN*4
C -----------------------------------
      IERR = 0
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "SET_MOD", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF

      DO IG=1,N_GROUP

        GROUP = GROUP_ID    (IG)
        IC    = ICHAIN_GRP  (IG)
        IGA   = IATOM_FIRST (IG)
        NR    = NRES_CHAIN  (IG)
        IRS   = IRES_FIRST  (IG)
        NAC   = NATM_CHAIN  (IG)
C       CHAIN = CHAIN_ID    (IG)

        IAF    = IGA - 1
        IRF    = IRS+NR-1         
        ICYCLE = 0

        IRS    = IRES_START_TREE(IG)
        IRF    = IRES_END_TREE  (IG)

C -- tree --
        IR = IRS
C ----------        
 800    CONTINUE  
C       DO IR=IRS,IRF
C -- tree --
          
          IAS = IAF + 1
          IAF = IAS + NATM_RES(IR) - 1

          ITYPE = IRES_TYPE(IR)
          MON   = RES_NAME (IR)

          IOXT  = 0
          IPATM = 0
          IPTER = 0
          DO IA=IAS,IAF
            IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN
              IF(IR.EQ.IRF.AND.ATM_NAME(IA).EQ.'OXT ') IOXT  = 1 
              IF(IR.EQ.IRS.AND.ATM_NAME(IA).EQ.'P   ') IPATM = 1 
              IF(IR.EQ.IRF.AND.ATM_NAME(IA).EQ.'PT  ') IPTER = 1 
            ENDIF
          ENDDO

          ICL = 0

          IF(IR.EQ.IRS) THEN
            IF(LN_N.GT.0) THEN
              DO IL=1,LN_N
                IF(LN_USED(IL).NE.'S') THEN
                IF(LN_2ICHN(IL).EQ.IC) THEN
                  IF(LN_2IRES(IL).EQ.IR)THEN
                    LINK = LN_ID(IL)
                    CALL SET_ICONN(LINK,ICONN)    
                    IF((ITYPE.EQ.3.OR.ITYPE.EQ.4).AND.
     *                 (ICONN.EQ. 2.OR.ICONN.EQ. 3.OR.
     *                  ICONN.EQ.38.OR.ICONN.EQ.39.OR.
     *                  ICONN.EQ.36.OR.ICONN.EQ.37)) ICL = 1
                    IF((ITYPE.EQ.5.OR.ITYPE.EQ.6).AND.
     *                 (ICONN.EQ.4              )) ICL = 1
                    IF(ICL.EQ.1) THEN
                      ICYCLE = ICYCLE + 1
                      GO TO 100
                    ENDIF
                  ENDIF
                ENDIF
                ENDIF
              ENDDO
            ENDIF
            IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN
              ITERM_S_TYPE (IG) = 1  
              IF(MON(1:3).NE.'ILG') THEN
                ITERM_S_TYPE (IG) = 2  
              ENDIF
            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'FOR') THEN
              ITERM_S_TYPE(IG) = 3  
            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'BAL') THEN
              ITERM_S_TYPE(IG) = 2  
            ELSE IF(ITYPE.EQ.5.OR.ITYPE.EQ.6) THEN
              ITERM_S_TYPE(IG) = 5  
              IF(IPATM.EQ.1) ITERM_S_TYPE(IG) = 4  
            ENDIF
          ENDIF           

 100      CONTINUE
          ICL = 0
          IF(IR.EQ.IRF) THEN
            IF(LN_N.GT.0) THEN
              DO IL=1,LN_N
                IF(LN_USED(IL).NE.'S') THEN
                IF(LN_1ICHN(IL).EQ.IC) THEN
                  IF(LN_1IRES(IL).EQ.IR)THEN
                    LINK=LN_ID(IL)
                    CALL SET_ICONN(LINK,ICONN)    
                    IF((ITYPE.EQ.3.OR.ITYPE.EQ.4).AND.
     *                 (ICONN.EQ. 2.OR.ICONN.EQ. 3.OR.
     *                  ICONN.EQ.38.OR.ICONN.EQ.39.OR.
     *                  ICONN.EQ.36.OR.ICONN.EQ.37)) ICL = 1
                    IF((ITYPE.EQ.5.OR.ITYPE.EQ.6).AND.
     *                 (ICONN.EQ.4              )) ICL=1
                    IF(ICL.EQ.1) THEN
                      ICYCLE = ICYCLE+1
                      GO TO 200
                    ENDIF
                  ENDIF
                ENDIF
                ENDIF
              ENDDO
            ENDIF

            IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN

              ITERM_F_TYPE (IG) = 1  

              IF(MON(1:3).NE.'BLE'.AND.MON(1:3).NE.'B1F'.AND.
     *           MON(1:3).NE.'B2F'.AND.MON(1:3).NE.'B2A'.AND.
     *           MON(1:3).NE.'B2I'.AND.MON(1:3).NE.'B2V'.AND.   
     *           MON(1:3).NE.'BLY'.AND.MON(1:3).NE.'ILG'     ) THEN
                IF(IOXT.EQ.1) ITERM_F_TYPE (IG) = 2  
              ENDIF

            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'FOR') THEN
              ITERM_F_TYPE(IG) = 3  
            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'BAL') THEN
              IF(IOXT.EQ.1) ITERM_F_TYPE(IG) = 2  
            ELSE IF(ITYPE.EQ.10.AND.
     *              (MON.EQ.'DFO'.OR.MON.EQ.'STA')) THEN
              ITERM_F_TYPE(IG) = 8  
            ELSE IF(ITYPE.EQ.5.OR.ITYPE.EQ.6) THEN
              ITERM_F_TYPE (IG) = 5  
              IF(IPTER.EQ.1) ITERM_S_TYPE (IG) = 4  
            ENDIF            
          ENDIF

 200      CONTINUE

C --- tree --
C       ENDDO
        IF(IR.NE.IRF) THEN
          IR = IRES_FORW(IR)
          IF(IR.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
            IERR = 1
            RETURN
          ENDIF
          GO TO 800
        ENDIF
C --- tree --

        IF(ICYCLE.GE.2) THEN
          GROUP = GROUP_ID(IG)
          WRITE(LINE,
     *    '('' WARNING : chain '',A,'' is cyclic ?'')') GROUP
          CALL MSGDOC(MDOC,LINE)
        ENDIF

      ENDDO

      RETURN
      END

C -------------------------

      SUBROUTINE DEF_CENTER(MDOC,IERR)
C --------------------------------------------
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
c      COMMON /RESID_INF_2/ CENTER_RES,RADIUS_RES,IFLAG_RES
c      REAL                 CENTER_RES(3,MAXRESID  )
c      REAL                 RADIUS_RES(MAXRESID  )
c      INTEGER              IFLAG_RES (MAXRESID  )
C -----------------------------------
      INCLUDE 'link_com.fh'
C ----------------------------------------------------------------
      REAL      X(3),C(3)
      CHARACTER ASYMB*4,ATYPE*1
C     CHARACTER ANAME*4,ALT*1,CORR*1
C     CHARACTER LINE*256
C --------------------------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        IERR=1
        RETURN
      ENDIF 

      DO IG=1,N_GROUP   

        IAR       = IATOM_FIRST(IG)
        IRP       = I_RESID    (IAR)
        ICH       = I_CHAIN    (IRP)
        IRS       = IRES_FIRST (ICH)
        NRES      = NRES_CHAIN (ICH)

        DO IR=IRS,IRS+NRES-1

          NATMR     = NATM_RES    (IR)
          IAS       = IRATM_FIRST (IR)

          IF(NATMR.LE.1) THEN

            CENTER_RES(1,IR)    = XYZ_CRD  (1,IAS) 
            CENTER_RES(2,IR)    = XYZ_CRD  (2,IAS)  
            CENTER_RES(3,IR)    = XYZ_CRD  (3,IAS)   
            RADIUS_RES(IR)      = 0.0
            IFLAG_RES (IR)      = 0
            NA                  = NATMR

          ELSE

            XMAX =-1.E 30
            YMAX =-1.E 30
            ZMAX =-1.E 30
            XMIN = 1.E 30
            YMIN = 1.E 30
            ZMIN = 1.E 30

            NA = 0
            DO IA=IAS,IAS+NATMR-1
C
              IATOM     = IA
C
C             ANAME     = ATM_NAME (IA)     
              INSF      = ID_SF    (IA)  
              ASYMB     = CS_ATYPE (INSF)      
              ATYPE     = ATM_TYPE (IA)    
C             ALT       = ID_ALT   (IA)    
C             CORR      = ID_CORR  (IA)    
              X(1)      = XYZ_CRD  (1,IA) 
              X(2)      = XYZ_CRD  (2,IA)  
              X(3)      = XYZ_CRD  (3,IA)   
C             BISO      = B_ISO    (IA)  
c             BISO      = U_ANISO  (1,IA)  
              OCC       = OCCUP    (IA)
              IF(OCC.LE.0.0                              ) GO TO 110
              IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') GO TO 110
              IF(ATYPE.EQ.'N'.OR.ATYPE.EQ.'D'.OR.
     *           ATYPE.EQ.'M'.OR.ATYPE.EQ.'U'            ) GO TO 110

                IF(X(1).GT.XMAX) XMAX = X(1)
                IF(X(2).GT.YMAX) YMAX = X(2)
                IF(X(3).GT.ZMAX) ZMAX = X(3)
                IF(X(1).LT.XMIN) XMIN = X(1)
                IF(X(2).LT.YMIN) YMIN = X(2)
                IF(X(3).LT.ZMIN) ZMIN = X(3)
                NA=NA+1
 110          CONTINUE
            ENDDO
            IF(NA.GT.0) THEN
              C(1)    = (XMAX+XMIN)/2.0  
              C(2)    = (YMAX+YMIN)/2.0
              C(3)    = (ZMAX+ZMIN)/2.0
            ELSE
              C(1) = 0.0
              C(2) = 0.0
              C(3) = 0.0
            ENDIF

            NA  = 0
            RAD = 0.0
            DO IA=IAS,IAS+NATMR-1
C
              IATOM     = IA
C
C             ANAME     = ATM_NAME (IA)     
              INSF      = ID_SF    (IA)  
              ASYMB     = CS_ATYPE (INSF)      
              ATYPE     = ATM_TYPE (IA)    
C             ALT       = ID_ALT   (IA)    
C             CORR      = ID_CORR  (IA)    
              X(1)      = XYZ_CRD  (1,IA) 
              X(2)      = XYZ_CRD  (2,IA)  
              X(3)      = XYZ_CRD  (3,IA)   
C             BISO      = B_ISO    (IA)  
c             BISO      = U_ANISO  (1,IA)  
              OCC       = OCCUP    (IA)
              IF(OCC.LE.0.0                              ) GO TO 120
              IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') GO TO 120
              IF(ATYPE.EQ.'N'.OR.ATYPE.EQ.'D'.OR.
     *           ATYPE.EQ.'M'.OR.ATYPE.EQ.'U'            ) GO TO 120

                T1 = X(1)-C(1)
                T2 = X(2)-C(2)
                T3 = X(3)-C(3)
                R  = SQRT(T1*T1+T2*T2+T3*T3)
                IF(R.GT.RAD) RAD = R
                NA = NA + 1
 120          CONTINUE

            ENDDO

            CENTER_RES(1,IR)    = C(1)
            CENTER_RES(2,IR)    = C(2)
            CENTER_RES(3,IR)    = C(3)
            RADIUS_RES(IR)      = RAD
            IFLAG_RES (IR)      = 0
            IF(NA.LE.0)  RADIUS_RES(IR) = -1.0

          ENDIF


          IFLAG_RES (IR)      = 0
          IF(NCONN_PDB.GT.0) THEN
            DO IA=IAS,IAS+NATMR-1
              IATOM = IA
              DO ICN=1,NCONN_PDB
                IF(ICON1_PDB(ICN).EQ.IATOM.OR.
     *             ICON2_PDB(ICN).EQ.IATOM  ) THEN
                  IFLAG_RES(IR) = -1
                  GO TO 130
                ENDIF
              ENDDO
            ENDDO 
          ENDIF
 130      CONTINUE

        ENDDO
 100    CONTINUE

      ENDDO
      RETURN
      END

      SUBROUTINE CHECK_CENTR(IR1,IR2,DLIM,IOUT)
C --------------------------------------------
      INCLUDE 'atom_com.fh'
C --------------------------------------------
c      COMMON /RESID_INF_2/CENTER_RES,RADIUS_RES,IFLAG_RES
c      REAL                CENTER_RES(3,MAXRESID  )
c      REAL                RADIUS_RES(MAXRESID  )
c      INTEGER             IFLAG_RES (MAXRESID  )
C ---
      REAL      X1,X2,Y1,Y2,Z1,Z2,R1,R2
C ----------------------------------------------------
      IF(IFLAG_RES(IR1).LT.0.OR.IFLAG_RES(IR2).LT.0) THEN
        IOUT = -1
        RETURN
      ENDIF

      IF(RADIUS_RES(IR1).LT.0.0.OR.RADIUS_RES(IR2).LT.0.0) THEN  
        IOUT =  3
        RETURN
      ELSE IF(RADIUS_RES(IR1).LE.0.0.OR.
     *        RADIUS_RES(IR2).LE.0.0    ) THEN  
        IOUT =  2
        RETURN
      ENDIF

      X1 = CENTER_RES(1,IR1)  
      Y1 = CENTER_RES(2,IR1)   
      Z1 = CENTER_RES(3,IR1)  
      R1 = RADIUS_RES(IR1)     
      X2 = CENTER_RES(1,IR2)  
      Y2 = CENTER_RES(2,IR2)   
      Z2 = CENTER_RES(3,IR2)  
      R2 = RADIUS_RES(IR2)     
      D  = R1 + R2 + DLIM + .00001
      D2 = D*D
C ---
      IOUT  = 0
      DIST2 = (X1-X2)*(X1-X2)+(Y1-Y2)*(Y1-Y2)+(Z1-Z2)*(Z1-Z2)
      IF(DIST2.LE.D2) IOUT = 1

      RETURN
      END



      SUBROUTINE REPLACE_SYNONYM(IG,IR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER MONN*8,MON*8
C -----------------------------------
      IF(LMS_NSYN.LE.0.OR.N_GROUP.LE.0.OR.IG.LE.0.OR.IR.LE.0) RETURN

C     DO IGG=IG,N_GROUP
      DO IGG=IG,IG

        NRR  = NRES_CHAIN  (IGG)
        IRRS = IRES_FIRST  (IGG)
        IRRF = IRRS+NRR-1        

C       DO IRR=IRRS,IRRF
        DO IRR=IR,IR

          IAAS = IRATM_FIRST(IRR)
          NAA  = NATM_RES   (IRR)     
          IAAF = IAAS+NAA-1
          MONN = RES_NAME   (IRR)
          MON  = ' '

          DO LL=1,LMS_NSYN
            IF(LMS_AMNAME(LL).EQ.MONN) THEN
              MON = LMS_MNAME(LL)
              GO TO 100
            ENDIF
          ENDDO

 100      CONTINUE

          DO IAA=IAAS,IAAF
            DO LL=1,LMS_NSYN
              IF(LMS_MNAME(LL).EQ.MONN.OR.
     *           LMS_MNAME(LL).EQ.MON     ) THEN
                IF(ATM_NAME(IAA).EQ.LMS_AATOM(LL)) THEN
                  ATM_NAME(IAA) = LMS_ATOM(LL)
                  GO TO 200
                ENDIF
              ENDIF
            ENDDO
 200        CONTINUE
          ENDDO

        ENDDO

      ENDDO

      RETURN
      END

      SUBROUTINE GET_ALT_FOR_COPY(MDOC,IAS,IAF,ALT_FOR_COPY,IERR)
C -----------------------------------
      INTEGER   MDOC,IERR,IAS,IAF
      CHARACTER ALT_FOR_COPY*1 
C --
      INCLUDE 'atom_com.fh'
C --
C -----------------------------------------------------------
      INTEGER N_ALT,I_ALT(20)
C ---
      CHARACTER LINE*256,ALT(20)*1
C -----------------------------------
      ALT_FOR_COPY = '.'
      N_ALT        = 0

      DO IA=IAS,IAF

        IF(ATM_TYPE(IA).EQ.'U'.OR.ATM_TYPE(IA).EQ.'D'.OR.
     *                            ATM_TYPE(IA).EQ.'N') GO TO 100
        IF(OCCUP(IA).LT.0.0001.OR.ID_ALT(IA).EQ.'.' ) GO TO 100

        IF(N_ALT.GT.0) THEN
          DO I=1,N_ALT
            IF(ID_ALT(IA).EQ.ALT(I)) THEN
              I_ALT(I) = I_ALT(I) + 1 
              GO TO 100
            ENDIF
          ENDDO
        ENDIF

        IF(N_ALT.LT.20) THEN
          N_ALT = N_ALT + 1
          ALT(N_ALT)   = ID_ALT(IA)
          I_ALT(N_ALT) = 1
        ENDIF
 100    CONTINUE

      ENDDO
C --  
      IF(N_ALT.GT.0) THEN
        N = 0
        DO I=1,N_ALT
          IF(N.LT.I_ALT(I)) THEN
            N = I_ALT(I) 
            ALT_FOR_COPY = ALT(I)
          ENDIF
        ENDDO
      ENDIF
C --
      RETURN
      END

      SUBROUTINE PRE_MONOM(MDOC,IG,IR,IAS,IAF,IERR)    
C -----------------------------------------------
C -P- PRE_MONOM - reads current monomer and copy into C1_... array
C -S-             one copy for alternative position
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IR,IAS,IAF,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------------------------------
C ---
      CHARACTER LINE*256,ALT_FOR_COPY*1
C -----------------------------------
      PI       = 4.0*ATAN(1.0)
      CONST    = 8.0*PI*PI

      C1_NATOM = 0

      CALL GET_ALT_FOR_COPY(MDOC,IAS,IAF,ALT_FOR_COPY,IERR)

      DO IA=IAS,IAF

        IF(ATM_TYPE(IA).EQ.'U'.OR.ATM_TYPE(IA).EQ.'D'.OR.
     *                            ATM_TYPE(IA).EQ.'N') GO TO 200

        IF(C1_NATOM.GT.0) THEN
          DO   I=1,C1_NATOM
            IF(ATM_NAME(IA).EQ.C1_ANAME(I)) THEN
              IF( ID_ALT(IA).EQ.'.'.OR.
     *           (ID_ALT(IA).EQ.ALT_FOR_COPY.AND.C1_ALT(I).NE.'.')) THEN
                GO TO 100
              ENDIF
              GO TO 200
            ENDIF
          ENDDO
        ENDIF
        IF(C1_NATOM.GE.MX1ATOM) THEN
          WRITE(LINE
     * ,'('' ERROR: number of atoms of monomer '',A7,'' >'',I6)') 
     *    RES_NUM_PDB(IR),MX1ATOM
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MX1ATOM in "lib_com.fh"')
          IERR=2
          RETURN
        ENDIF
        C1_NATOM           = C1_NATOM + 1
 100    CONTINUE
        IATM             = C1_NATOM
        C1_NALT (IATM)   = 1
        C1_IALT (IATM)   = 0
        C1_ANAME(IATM)   = ATM_NAME(IA)
        C1_ANAME_INP(IATM)= ATM_NAME_INP(IA)
        C1_ICH           = IG  
        C1_IRES          = IR 
        S1_ICRD (IATM)   = IA
        DO   I=1,3
          C1_XYZ(I,IATM) = XYZ_CRD(I,IA)
C         C1_CSD(I,IATM) = SD_CRD (I,IA)
        ENDDO
        DO   I=1,6
          C1_ANIS(I,IATM) = 0.0
C         C1_ASD (I,IATM) = 0.0
        ENDDO
        C1_OCC   (IATM) = OCCUP   (IA)
C       C1_BSD   (IATM) = 0.0
C       C1_OSD   (IATM) = 0.0
        C1_USER  (IATM) = MULT_FACTOR(IA)+0.001

        S1_CHAR(IATM)   = 0.0 
        S1_CHEM(IATM)   = ATM_CHEM(IA) 

        INSF            = ID_SF   (IA)
        C1_ASYMB (IATM) = CS_ATYPE(INSF)
        C1_SF_ID (IATM) = INSF

        C1_ATYPE (IATM) = 'M'
        C1_ALT   (IATM) = ID_ALT  (IA)
        C1_SEG   (IATM) = SEG_ID  (IA)
        C1_CORR  (IATM) = ID_CORR (IA)

        C1_BTYPE (IATM) = 'I'
        IF(B_FLAG(IA).GT.0) THEN
          C1_BTYPE(IATM) = 'A'
          DO   I=1,6
            C1_ANIS(I,IATM) = U_ANISO(I,IA)
          ENDDO
          CALL CALC_B_EQUIV(U_ANISO(1,IA),BISO)
          C1_BISO  (IATM) = BISO
        ELSE
          C1_ANIS(1,IATM) = U_ANISO(1,IA)
          C1_BISO(IATM)   = U_ANISO(1,IA)/CONST
        ENDIF

        C1_RNAME        = RES_NAME(IR)
        C1_CODE1        = '.'
        C1_PNUM         = RES_NUM_PDB(IR)
        IRT             = IRES_TYPE  (IR)
        C1_RTYPE        = RES_TYPE   (IRT)
        C1_FSC   (IATM) = 'N'
        C1_FSA   (IATM) = 'N'
        C1_FUS   (IATM) = 'N'

 200    CONTINUE
      ENDDO

      IF(C1_NATOM.LE.0) THEN
        WRITE(LINE
     * ,'('' ERROR: number of atoms of monomer (c1_natom)=0'')') 
        CALL MSGERR(MDOC,LINE)
        IERR=2
        RETURN
      ENDIF

      RETURN
      END

      SUBROUTINE COPY_C1_L1(MDOC,MONOMER_NEW,IERR)
C -----------------------------------------------
C     define before L1L_TYPE,L1L_PRSNT
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
C -----------------------------------------------
      CHARACTER ASYMB*4,MONOMER_NEW*8
C -----------------------------------------------
        NANH = 0
        NA   = 0
c --
        L1L_MNAME = MONOMER_NEW
        L1L_MNAME2= MONOMER_NEW
        L1L_NAME  = '.'
        L1L_CODE1 = 'x'
C        L1L_TYPE  = 'non-polymer'  
C        L1L_TYPE  = C1_RTYPE 
        L1L_MODE  = '.'
        L1L_FORM  = '.'
        L1L_FUSE  = '?'
        L1L_HFLAG = '.'
C        L1L_NATM  = C1_NATOM
C        L1L_NHATM = 0
C        L1A_NATOM = C1_NATOM
C        L1A_NHATOM= 0
        L1N_NCONN = 0
        L1B_NBOND = 0
        L1G_NANGL = 0
        L1T_NTORS = 0
        L1C_NCHIR = 0
        L1P_NPLAN = 0
        DO I=1,C1_NATOM
          IF(NA.GT.0) THEN
            DO J=1,NA
              IF(C1_ANAME(I).EQ.L1A_ANAME(J)) GO TO 100
            ENDDO
          ENDIF
          NA = NA + 1
          L1A_COOR_FLAG(I) = 'Y'
          IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(NA) = 'N'
          L1A_X    (NA) = C1_XYZ(1,I)
          L1A_Y    (NA) = C1_XYZ(2,I)
          L1A_Z    (NA) = C1_XYZ(3,I)
          L1A_CHARG(NA) = S1_CHAR(I) 
          L1A_INEW (NA) = I
          L1A_IOLD (NA) = I
          L1A_ICR  (NA) = 0
          L1A_NDIST(NA) = 0
          L1A_IBACK(NA) = 0
          L1A_IFORW(NA) = 0
          L1A_BACK (NA) = '.'
          L1A_TYPE (NA) = '.' 
          L1A_FORW (NA) = '.'
          L1A_ANAME(NA) = C1_ANAME(I)
          L1A_CHEM (NA) = S1_CHEM (I)
          L1A_SYMB (NA) = C1_ASYMB(I) 

          ASYMB = L1A_SYMB(NA)
          IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
            NANH = NANH + 1 
          ENDIF

          NA = NA + 1
          ASYMB = CS_ATYPE(C1_SF_ID(I))
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          L1A_SF_ID(NA) = INSF
C          L1A_CHEM (NA) = L1A_SYMB(NA) 
          L1A_ATYPE(NA) = C1_ATYPE(I)
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,NA) = 0
            L1A_LENCON (J,NA) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,NA)  = 0
          ENDDO
 100      CONTINUE
        ENDDO

        L1L_NATM   = NA
        L1L_NHATM  = NANH
        L1A_NATOM  = NA
        L1A_NHATOM = NANH

      RETURN
      END

      SUBROUTINE CREAT_MOD(MDOC,MOD,MON,FUNC,NAMEM,ATOM_M,ATOM_U
     * ,IATOM_M,IATOM_U,IMOD,CHEMM,CHEMU,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
C     REAL       DIST
      INTEGER*4 IMOD,MDOC,IERR
      CHARACTER MON*8,ATOM_M*4,ATOM_U*4,CHEMM*4,CHEMU*4,FUNC*3
      CHARACTER MOD*8,NAMEM*(*),ATOM*4,DEF_FLAG*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C     INCLUDE 'ener_com.fh'
C ******
      CHARACTER LINE*256,DETAIL*48,CHEM1*4,CHEM2*4
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,LB*3
C ---
      COMMON/COM_CRT_MOD/ IFIRST_D
C -----------------------------------
      M  =-ABS(MDOC)-1
      NA = 0
      NB = 0
      NG = 0
      NT = 0
      NP = 0
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)


      WRITE(LINE,'(''           create modification: '',A)') 
     * MOD
      CALL MSGDOC(M,LINE)
      WRITE(LINE,'(''           detail: '',A)') 
     * DETAIL(1:LEN)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.78) LEN=78
      CALL MSGDOC(M,LINE(1:LEN))

      IF(LDL_NMOD.GE.MAXDMDF) THEN
        IF(IFIRST_D.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXDMDF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXDMDF in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(A)')
     *'           Now program stops to create new modifications.'
          CALL MSGERR(MDOC,LINE)
          IFIRST_D=1
        ENDIF 
        IERR=1
        RETURN
      ELSE
        IFIRST_D=0
      ENDIF
      LDL_NMOD = LDL_NMOD+1
      LDL_IMOD = LDL_NMOD
      IMOD     = LDL_NMOD
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)
      CALL LENSTR_BL(MOD,LEN)
      LDL_MNAME (IMOD) = MOD(1:LEN)
      LDL_COMP  (IMOD) = '.'
      CALL LENSTR_BL(DETAIL,LEN)
      LDL_DETAIL(IMOD) = DETAIL(1:LEN)
C//'<-- do not change that'
      LDL_ORDER  (IMOD) = 0
      LDL_TYPE   (IMOD) = '.'
      LDL_FUSE   (IMOD) = 'C'
      LDL_ICONN  (IMOD) = 0
      LDL_IATOM  (IMOD) = 0
      LDL_IBOND  (IMOD) = 0
      LDL_ITHET  (IMOD) = 0
      LDL_IPLAN  (IMOD) = 0
      LDL_ICHIR  (IMOD) = 0
      LDL_ITORS  (IMOD) = 0

      LB = 'MOD'
      NA = LDA_NATOM
      CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
      IF(IERR.NE.0) RETURN

      LDA_NATOM            = LDA_NATOM + 1
      LDL_IATOM(IMOD)      = LDA_NATOM
      LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
      LDA_BACK (LDA_NATOM) = '.'
      LDA_FORW (LDA_NATOM) = '.'
      LDA_CHARG(LDA_NATOM) = 0.0


      IF(FUNC.EQ.'REP') THEN
        LDA_FUNCT(LDA_NATOM) = 'change'
        LDA_ANAME(LDA_NATOM) = ATOM_M
        LDA_ANEW (LDA_NATOM) = ATOM_U
        LDA_SYMB (LDA_NATOM) = CHEMU
        LDA_CHEM (LDA_NATOM) = CHEMU
      ELSE IF(FUNC.EQ.'ADD') THEN
        LDA_FUNCT(LDA_NATOM) = 'add'
        LDA_ANAME(LDA_NATOM) = '.'
        LDA_ANEW (LDA_NATOM) = ATOM_U
        LDA_SYMB (LDA_NATOM) = CHEMU
        LDA_CHEM (LDA_NATOM) = CHEMU
      ELSE IF(FUNC.EQ.'DEL') THEN
        LDA_FUNCT(LDA_NATOM) = 'delete'
        LDA_ANAME(LDA_NATOM) = ATOM_M
        LDA_ANEW (LDA_NATOM) = '.'
        LDA_SYMB (LDA_NATOM) = '.'
        LDA_CHEM (LDA_NATOM) = '.'
      ENDIF


      IF(FUNC.EQ.'REP') THEN
        IF(L1B_NBOND.GT.0) THEN
          DO I=1,L1B_NBOND
            J = 0
            IF(L1B_1ATM (I).EQ.ATOM_M) THEN
              I1 = IATOM_M  
              J = 1
            ELSE IF(L1B_2ATM (I).EQ.ATOM_M) THEN
              J  = 2
              I2 = IATOM_U
            ENDIF
            IF(J.NE.0) THEN

              IF(J.EQ.1) THEN
                L1B_1ATM (I) = ATOM_U
                ATOM         = L1B_2ATM (I)
              ELSE
                L1B_2ATM (I) = ATOM_U
                ATOM         = L1B_1ATM (I)
              ENDIF
              IF(L1A_NATOM.GT.0) THEN
                DO L=1,L1A_NATOM
                  IF(L1A_ANAME(L).EQ.ATOM) THEN
                    IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *                 L1A_SYMB(L)(1:2).EQ.'D ') THEN
                      LB = 'MOD'
                      NA = LDA_NATOM
                      CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
                      IF(IERR.NE.0) RETURN
                      LDA_NATOM            = LDA_NATOM + 1
                      LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
                      LDA_FUNCT(LDA_NATOM) = 'delete'
                      LDA_ANAME(LDA_NATOM) = L1A_ANAME(L)
                      LDA_ANEW (LDA_NATOM) = '.'
                      LDA_SYMB (LDA_NATOM) = '.'
                      LDA_CHEM (LDA_NATOM) = '.'
                      LDA_BACK (LDA_NATOM) = '.'
                      LDA_FORW (LDA_NATOM) = '.'
                      LDA_CHARG(LDA_NATOM) = 0.0
                      GO TO 100
                    ELSE
                      IF(J.EQ.1) CHEM2 = L1A_CHEM(L)
                      IF(J.EQ.2) CHEM1 = L1A_CHEM(L)
                      GO TO 200
                    ENDIF
                  ENDIF
                ENDDO
              ENDIF
              GO TO 100
 200          CONTINUE


              LB = 'MOD'
              NB = LDB_NBOND
              CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
              IF(IERR.NE.0) RETURN
              LDB_NBOND = LDB_NBOND + 1
              IF(LDL_IBOND(IMOD).EQ.0) LDL_IBOND(IMOD) = LDB_NBOND


              LDB_FUNCT(LDB_NBOND)   = 'change'
              LDB_MNAME(LDB_NBOND)   = LDL_MNAME (IMOD)
              IF(J.EQ.1) THEN
                LDB_1ATM (LDB_NBOND) = ATOM_U
                LDB_2ATM (LDB_NBOND) = ATOM
                CHEM1                = CHEMU
              ELSE
                LDB_2ATM (LDB_NBOND) = ATOM_U
                LDB_1ATM (LDB_NBOND) = ATOM
                CHEM2                = CHEMU
              ENDIF

C              WRITE(*,*) j,';',CHEM1,';',CHEM2,';'

              CALL GET_DEFAULT_VBOND(M,CHEM1,CHEM2
     *            ,VAL,DEF_FLAG,IERR)
              IF(IERR.NE.0) RETURN

              IF(DEF_FLAG.EQ.'Y') THEN
                WRITE(LINE,
     *                '(''           '',A3,
     &                '' : default bond legnth will be used '')')
     *                MON
                CALL MSGDOC(M,LINE)
                WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '           chem_type: ',CHEM1,'-',CHEM2,' ',L1B_VAL(L),
     *  ' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),')' 
                CALL MSGDOC(M,LINE)
              ENDIF

              L1B_DEV (I) = 0.02
              IF(VAL.GT.0.0) L1B_VAL(I)=VAL

              LDB_TYPE (LDB_NBOND) = '.'
              LDB_VAL  (LDB_NBOND) = L1B_VAL(I)
              LDB_DEV  (LDB_NBOND) = L1B_DEV(I)
 100          CONTINUE

            ENDIF
          ENDDO
        ENDIF

        IF(L1G_NANGL.GT.0) THEN
          DO I=1,L1G_NANGL
            J = 0
            IF(L1G_1ATM (I).EQ.ATOM_M) THEN
              L1G_1ATM (I) = ATOM_U
              J            = 1
              ATOM2        = L1G_2ATM (I)
              ATOM3        = L1G_3ATM (I)
            ELSE IF(L1G_2ATM (I).EQ.ATOM_M) THEN
              L1G_2ATM (I) = ATOM_U
              J            = 2
              ATOM1        = L1G_1ATM (I)
              ATOM3        = L1G_3ATM (I)
            ELSE IF(L1G_3ATM (I).EQ.ATOM_M) THEN
              L1G_3ATM (I) = ATOM_U
              J            = 3
              ATOM1        = L1G_1ATM (I)
              ATOM2        = L1G_2ATM (I)
            ENDIF
            IF(L1A_NATOM.GT.0) THEN
              DO L=1,L1A_NATOM
                IF(L1A_ANAME(L).EQ.ATOM1) THEN
                  IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *               L1A_SYMB(L)(1:2).EQ.'D ') THEN
                    J = 0
                  ENDIF  
                ENDIF  
                IF(L1A_ANAME(L).EQ.ATOM2) THEN
                  IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *               L1A_SYMB(L)(1:2).EQ.'D ') THEN
                    J = 0
                  ENDIF  
                ENDIF  
                IF(L1A_ANAME(L).EQ.ATOM3) THEN
                  IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *               L1A_SYMB(L)(1:2).EQ.'D ') THEN
                    J = 0
                  ENDIF  
                ENDIF  
              ENDDO  
            ENDIF  
            IF(J.NE.0) THEN

              LB = 'MOD'
              NG = LDG_NANGL
              CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
              IF(IERR.NE.0) RETURN
              LDG_NANGL = LDG_NANGL + 1
              IF(LDL_ITHET(IMOD).EQ.0) LDL_ITHET(IMOD) = LDG_NANGL

              LDG_FUNCT(LDG_NANGL)   = 'change'
              LDG_MNAME(LDG_NANGL)   = LDL_MNAME (IMOD)
              IF(J.EQ.1) THEN
                LDG_1ATM (LDG_NANGL) = ATOM_U
                LDG_2ATM (LDG_NANGL) = ATOM2
                LDG_3ATM (LDG_NANGL) = ATOM3
              ELSE IF(J.EQ.2) THEN
                LDG_2ATM (LDG_NANGL) = ATOM_U
                LDG_1ATM (LDG_NANGL) = ATOM1
                LDG_3ATM (LDG_NANGL) = ATOM3
              ELSE
                LDG_3ATM (LDG_NANGL) = ATOM_U
                LDG_1ATM (LDG_NANGL) = ATOM1
                LDG_2ATM (LDG_NANGL) = ATOM2
              ENDIF
              LDG_VAL  (LDG_NANGL) = L1G_VAL(I)
              LDG_DEV  (LDG_NANGL) = L1G_DEV(I)

            ENDIF
          ENDDO
        ENDIF
      ELSE IF(FUNC.EQ.'ADD') THEN

        DO IAC=1,C1_NATOM
          IF(C1_ANAME(IAC).EQ.ATOM_U) THEN

c            WRITE(*,*) IAC,S1_NDIST(IAC)

            IF(S1_NDIST(IAC).LE.0) RETURN
            IF(S1_NDIST(IAC).GT.0) THEN
              DO JAC=S1_NDIST(IAC),1,-1
                IF(S1_CONN(JAC,IAC).GT.0) THEN
                  IA    = S1_CONN(JAC,IAC)
                  ATOM  = C1_ANAME(IA)
                  CHEM2 = S1_CHEM (IA)
                  IF(C1_ASYMB(IA)(1:2).NE.'H '.AND.
     *               C1_ASYMB(IA)(1:2).NE.'D ') THEN
                  
C ////


        LB = 'MOD'
        NB = LDB_NBOND
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
        IF(IERR.NE.0) RETURN
        LDB_NBOND = LDB_NBOND+1
        IF(LDL_IBOND(IMOD).EQ.0) LDL_IBOND(IMOD) = LDB_NBOND


        LDB_FUNCT(LDB_NBOND)   = 'add'
        LDB_MNAME(LDB_NBOND)   = LDL_MNAME (IMOD)
        LDB_1ATM (LDB_NBOND)   = ATOM_U
        LDB_2ATM (LDB_NBOND)   = ATOM
        CHEM1                  = CHEMU

        VAL = 0.0
        DO K=1,LEB_NBOND
           IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *        (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1))
     *     THEN
             VAL = LEB_LENGTH(K) 
             GO TO 400
           ENDIF
        ENDDO
        D1 = 0.0
        D2 = 0.0
        DO K=1,LEB_NBOND
          IF(LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *          D1=LEB_LENGTH(K)
          IF(LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D2 = LEB_LENGTH(K)

        ENDDO
        IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
          DA  = (D1+D2)/2.0
          VAL = DA  
        ENDIF
        IF(VAL.LE.0.0) VAL = 1.5

        WRITE(LINE,
     *       '('' WARNING : '',A3,
     &       '' : default bond legnth will be used '')')
     *       MON
        CALL MSGDOC(M,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '           chem_type: ',CHEM1,'-',CHEM2,' ',VAL,' (',ATOM_U,
     *'-',ATOM,')'
                CALL MSGDOC(M,LINE)


 400    CONTINUE
        DEV = 0.02

        LDB_TYPE (LDB_NBOND) = '.'
        LDB_VAL  (LDB_NBOND) = VAL
        LDB_DEV  (LDB_NBOND) = DEV
C ///


                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO



      ELSE IF(FUNC.EQ.'DEL') THEN

      ENDIF

      RETURN
      END

      SUBROUTINE CREAT_MOD_NADD(MDOC,MOD,MON,IMOD,NAMEM
     * ,NATM,ATOM_UM,CHEMUM,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      INTEGER*4  IMOD,MDOC,IERR
      CHARACTER  MON*8,ATOM_UM(9)*4,CHEMUM(9)*4
C     CHARACTER  FUNC*3
      CHARACTER  MOD*8,NAMEM*(*),ATOM_U*4,CHEMU*4
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C     INCLUDE 'ener_com.fh'
C ******
      CHARACTER LINE*256,DETAIL*48,LB*3,CHEM1*4,CHEM2*4
      CHARACTER ATOM1*4,ATOM2*4,ATOM*4,CHEM*4
C ---
      COMMON/COM_CRT_MOD/ IFIRST_D
C -----------------------------------
      IERR = 0
      IF(NATM.LE.0.OR.NATM.GE.10) RETURN

      NA = 0
      NB = 0
      NG = 0
      NT = 0
      NP = 0

      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)

      WRITE(LINE,'(''           create modification: '',A)') 
     * MOD
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           detail: '',A)') 
     * DETAIL(1:LEN)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.78) LEN=78
      CALL MSGDOC(MDOC,LINE(1:LEN))

      IF(LDL_NMOD.GE.MAXDMDF) THEN
        IF(IFIRST_D.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXDMDF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXDMDF in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(A)')
     *'           Now program stops to create new modifications.'
          CALL MSGERR(MDOC,LINE)
          IFIRST_D = 1
        ENDIF 
        IERR=1
        RETURN
      ELSE
        IFIRST_D = 0
      ENDIF

      LDL_NMOD = LDL_NMOD+1
      LDL_IMOD = LDL_NMOD
      IMOD     = LDL_NMOD
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)
      CALL LENSTR_BL(MOD,LEN)
      LDL_MNAME (IMOD) = MOD(1:LEN)
      LDL_COMP  (IMOD) = '.'
      CALL LENSTR_BL(DETAIL,LEN)
      LDL_DETAIL(IMOD) = DETAIL(1:LEN)
C//'<-- do not change that'
      LDL_ORDER  (IMOD) = 0
      LDL_TYPE   (IMOD) = '.'
      LDL_FUSE   (IMOD) = 'C'
      LDL_ICONN  (IMOD) = 0
      LDL_IATOM  (IMOD) = 0
      LDL_IBOND  (IMOD) = 0
      LDL_ITHET  (IMOD) = 0
      LDL_IPLAN  (IMOD) = 0
      LDL_ICHIR  (IMOD) = 0
      LDL_ITORS  (IMOD) = 0

      LDL_IATOM(IMOD)  = LDA_NATOM + 1
      DO IADD=1,NATM
        LB = 'MOD'
        NA = LDA_NATOM
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
        IF(IERR.NE.0) RETURN

        LDA_NATOM            = LDA_NATOM + 1
        LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
        LDA_BACK (LDA_NATOM) = '.'
        LDA_FORW (LDA_NATOM) = '.'
        LDA_CHARG(LDA_NATOM) = 0.0

        LDA_FUNCT(LDA_NATOM) = 'add'
        LDA_ANAME(LDA_NATOM) = '.'
        LDA_ANEW (LDA_NATOM) = ATOM_UM(IADD)
        LDA_SYMB (LDA_NATOM) = CHEMUM (IADD)
        LDA_CHEM (LDA_NATOM) = CHEMUM (IADD)
      ENDDO
C     --- BONDS
      DO IU=1,NATM
        ATOM_U = ATOM_UM(IU)
        CHEMU  = CHEMUM(IU)
        DO IAC=1,C1_NATOM
          IF(C1_ANAME(IAC).EQ.ATOM_U) THEN
            IF(S1_NDIST(IAC).LE.0) GO TO 410
            IF(S1_NDIST(IAC).GT.0) THEN
              DO JAC=S1_NDIST(IAC),1,-1
                IF(S1_CONN(JAC,IAC).GT.0) THEN
                  IA    = S1_CONN(JAC,IAC)
                  ATOM  = C1_ANAME(IA)
                  CHEM2 = S1_CHEM (IA)
                  IF(C1_ASYMB(IA)(1:2).NE.'H '.AND.
     *               C1_ASYMB(IA)(1:2).NE.'D ') THEN
C ////
        LB = 'MOD'
        NB = LDB_NBOND
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
        IF(IERR.NE.0) RETURN
        LDB_NBOND = LDB_NBOND + 1
        IF(LDL_IBOND(IMOD).EQ.0) LDL_IBOND(IMOD) = LDB_NBOND


        LDB_FUNCT(LDB_NBOND)   = 'add'
        LDB_MNAME(LDB_NBOND)   = LDL_MNAME (IMOD)
        LDB_1ATM (LDB_NBOND)   = ATOM_U
        LDB_2ATM (LDB_NBOND)   = ATOM
        CHEM1                  = CHEMU
        VAL = 0.0
        DO K=1,LEB_NBOND
           IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *        (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1))
     *     THEN
             VAL = LEB_LENGTH(K) 
             GO TO 400
           ENDIF
        ENDDO
        D1 = 0.0
        D2 = 0.0
        DO K=1,LEB_NBOND
          IF(LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *          D1 = LEB_LENGTH(K)
          IF(LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D2 = LEB_LENGTH(K)

        ENDDO
        IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
          DA  = (D1+D2)/2.0
          VAL = DA  
        ENDIF
        IF(VAL.LE.0.0) VAL = 1.5
        WRITE(LINE,
     *       '(''           '',A,
     &       '' : default bond legnth will be used '')')
     *       MON
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *'           chem_type: ',CHEM1,'-',CHEM2,' ',VAL,' (',ATOM_U,'-',
     *ATOM,')'
                CALL MSGDOC(MDOC,LINE)


 400    CONTINUE
        DEV = 0.02

        LDB_TYPE (LDB_NBOND) = '.'
        LDB_VAL  (LDB_NBOND) = VAL
        LDB_DEV  (LDB_NBOND) = DEV
C ///
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDIF
 410      CONTINUE
        ENDDO

      ENDDO
C     --- ANGLES
      DO IAC=1,C1_NATOM
        ATOM  = C1_ANAME(IAC)
        CHEM  = S1_CHEM (IAC)
        IF(C1_ASYMB(IAC)(1:2).NE.'H '.AND.
     *     C1_ASYMB(IAC)(1:2).NE.'D ') THEN
          IF(S1_NDIST(IAC).LE.0) GO TO 510
          IF(S1_NDIST(IAC).GT.1) THEN
            DO JAC=1,S1_NDIST(IAC)-1
              IA1 = S1_CONN(JAC,IAC)
              IF(S1_CONN(JAC,IAC).GT.0) THEN
                ATOM1 = C1_ANAME(IA1)
                CHEM1 = S1_CHEM (IA1)
                IF(C1_ASYMB(IA1)(1:2).NE.'H '.AND.
     *             C1_ASYMB(IA1)(1:2).NE.'D ') THEN
                  DO KAC=JAC+1,S1_NDIST(IAC)
                    IA2   = S1_CONN(KAC,IAC)
                    IF(S1_CONN(KAC,IAC).GT.0) THEN
                      ATOM2 = C1_ANAME(IA2)
                      CHEM2 = S1_CHEM (IA2)
                      IF(C1_ASYMB(IA2)(1:2).NE.'H '.AND.
     *                   C1_ASYMB(IA2)(1:2).NE.'D ') THEN
                        DO IU=1,NATM
                          ATOM_U = ATOM_UM(IU)
                          CHEMU  = CHEMUM(IU)
                          IF((ATOM1.EQ.ATOM_U).OR.
     *                       (ATOM2.EQ.ATOM_U)) THEN
C ////

C       LG = 'MOD'
        NG = LDG_NANGL
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
        IF(IERR.NE.0) RETURN
        LDG_NANGL = LDG_NANGL + 1

        IF(LDL_ITHET(IMOD).EQ.0) LDL_ITHET(IMOD) = LDG_NANGL

        LDG_FUNCT(LDG_NANGL)   = 'add'
        LDG_MNAME(LDG_NANGL)   = LDL_MNAME (IMOD)
        LDG_1ATM (LDG_NANGL)   = ATOM1
        LDG_2ATM (LDG_NANGL)   = ATOM
        LDG_3ATM (LDG_NANGL)   = ATOM2

        VAL = 0.0
        DO K=1,LEG_NANGL
          IF(LEG_2ATM(K).EQ.CHEM) THEN
            IF((LEG_1ATM(K).EQ.CHEM1.AND.LEG_3ATM(K).EQ.CHEM2).OR.
     *         (LEG_1ATM(K).EQ.CHEM2.AND.LEG_3ATM(K).EQ.CHEM1))
     *      THEN
              VAL = LEG_ANGLE(K) 
              GO TO 500
            ENDIF
          ENDIF
        ENDDO
        D1 = 0.0
        DO K=1,LEG_NANGL
          IF(LEG_2ATM(K).EQ.CHEM) THEN
            IF(LEG_1ATM(K)(1:1).EQ.'.'.AND.LEG_3ATM(K)(1:1).EQ.'.')
     *      THEN
              D1 = LEG_ANGLE(K)
            ENDIF
          ENDIF
        ENDDO
        IF(D1.GT.0.0) THEN
          VAL = D1  
        ENDIF
        IF(VAL.LE.0.0) VAL = 109.45

        WRITE(LINE,'(A,A,A)')
     *       '           ',MON,
     &       ' : default angle value will be used '
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *  '           chem_type: ',CHEM1,'-',CHEM,'-',CHEM2,' ',VAL,' (',
     *  ' (',ATOM1,'-',ATOM,'-',ATOM2,')' 
                CALL MSGDOC(MDOC,LINE)
 500    CONTINUE
        DEV = 3.0

        LDG_VAL  (LDG_NANGL) = VAL
        LDG_DEV  (LDG_NANGL) = DEV
C ///
                          ENDIF
                        ENDDO
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF
 510    CONTINUE
      ENDDO
C ---
      RETURN
      END


      SUBROUTINE CREAT_MOD_NDEL(MDOC,MOD,MON,IMOD,NAMEM
     * ,NATM,ATOM_UM,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      INTEGER*4  IMOD,MDOC,IERR
      CHARACTER  MON*8,ATOM_UM(9)*4
      CHARACTER  MOD*8,NAMEM*(*)
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C     INCLUDE 'ener_com.fh'
C ******
      CHARACTER LINE*256,DETAIL*48,LB*3
C     CHARACTER CHEM1*4,CHEM2*4,CHEMU*4,FUNC*3
C     CHARACTER ATOM1*4,ATOM2*4,ATOM*4,CHEM*4,ATOM_U*4
C ---
      COMMON/COM_CRT_MOD/ IFIRST_D
C -----------------------------------
      IERR = 0
      IF(NATM.LE.0.OR.NATM.GE.10) RETURN

      NA = 0
      NB = 0
      NG = 0
      NT = 0
      NP = 0

      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)

      WRITE(LINE,'(''           create modification: '',A)') 
     * MOD
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           detail: '',A)') 
     * DETAIL(1:LEN)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.78) LEN=78
      CALL MSGDOC(MDOC,LINE(1:LEN))

      IF(LDL_NMOD.GE.MAXDMDF) THEN
        IF(IFIRST_D.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXDMDF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXDMDF in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Now program stops to create new modifications.'')')
          CALL MSGERR(MDOC,LINE)
          IFIRST_D = 1
        ENDIF 
        IERR = 1
        RETURN
      ELSE
        IFIRST_D=0
      ENDIF

      LDL_NMOD = LDL_NMOD + 1
      LDL_IMOD = LDL_NMOD
      IMOD     = LDL_NMOD
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)
      CALL LENSTR_BL(MOD,LEN)
      LDL_MNAME (IMOD) = MOD(1:LEN)
      LDL_COMP  (IMOD) = '.'
      CALL LENSTR_BL(DETAIL,LEN)
      LDL_DETAIL(IMOD) = DETAIL(1:LEN)
C//'<-- do not change that'
      LDL_ORDER  (IMOD) = 0
      LDL_TYPE   (IMOD) = '.'
      LDL_FUSE   (IMOD) = 'C'
      LDL_ICONN  (IMOD) = 0
      LDL_IATOM  (IMOD) = 0
      LDL_IBOND  (IMOD) = 0
      LDL_ITHET  (IMOD) = 0
      LDL_IPLAN  (IMOD) = 0
      LDL_ICHIR  (IMOD) = 0
      LDL_ITORS  (IMOD) = 0

      LDL_IATOM(IMOD)  = LDA_NATOM + 1

      DO IADD=1,NATM
        LB = 'MOD'
        NA = LDA_NATOM
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
        IF(IERR.NE.0) RETURN

        LDA_NATOM            = LDA_NATOM+1
        LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
        LDA_BACK (LDA_NATOM) = '.'
        LDA_FORW (LDA_NATOM) = '.'
        LDA_CHARG(LDA_NATOM) = 0.0

        LDA_FUNCT(LDA_NATOM) = 'delete'
        LDA_ANAME(LDA_NATOM) = ATOM_UM(IADD)
        LDA_ANEW (LDA_NATOM) = '.'
        LDA_SYMB (LDA_NATOM) = '.'
        LDA_CHEM (LDA_NATOM) = '.'
      ENDDO
      RETURN
      END

      SUBROUTINE LOOK_MOD(MON,ATOM_MISS,ATOM_UNK,NATM,MOD,NAMEM
     * ,ATOM_U,FUNC,IMOD,IRTYPE,IERR)
C -----------------------------------------------
C -P-  return IMOD = 0  not found in table of MODs ( LDL_ )
C -S-                N  number of MOD in table.
C      search by MOD, NAMEM
C
C       check modification:   id: 'MONATMAT' rep ATM <-- AT
C                                 'MON-ATMM' del 
C                                 'MON+ATMU' add
C                                 'MON+9ADD' mad N atoms N < 10
C                                 'MON+7DEL' mad N atoms N < 10
C                           name:                      'REP-C5M_<-BR__-Td'
C                                                      'ADD-BR__->Td'
C                                 'ADD-atm1-atm2-atm3'
C                                 'DEL-atm1-atm2-atm3'
C                                                      'DEL-C5M_-Td'
C     compare MOD and DETAIL
C -----------------------------------------------
      INTEGER*4 IMOD,IERR
      CHARACTER MOD*8,MON*8,FUNC*3,STR*80,MOD_L*8,FUNC_L*3
      CHARACTER ATOM_MISS*4,ATOM_UNK*4,ATOM_U(9)*4,AUM(9)*4
      CHARACTER M3*3,AM*4,AU*4,CH1*1,CH2*2,NAMEM*(*)
C ---
      INCLUDE 'lib_com.fh'
C      INCLUDE 'atom_com.fh'
C -----------------------------------
C     create id and name
      M3 = MON(1:3)
      CALL LENSTR_BL(M3,LEN)
      IF(LEN.LE.1.OR.M3(2:2).EQ.' ') THEN
        M3(2:2)  = '_'
        MON(2:2) = ' '
      ENDIF
      IF(LEN.LE.2.OR.M3(3:3).EQ.' ') THEN
        M3(3:3)  = '_'
        MON(3:3) = ' '
      ENDIF
      IF(FUNC.EQ.'MAD'.OR.FUNC.EQ.'MDL') THEN 
        DO II=1,NATM
          AU=ATOM_U(II)
          CALL LENSTR_BL(AU,LEN)
          IF(LEN.LE.0.OR.AU(1:1).EQ.' ') AU(1:1)='_'
          IF(LEN.LE.1.OR.AU(2:2).EQ.' ') AU(2:2)='_'
          IF(LEN.LE.2.OR.AU(3:3).EQ.' ') AU(3:3)='_'
          IF(LEN.LE.3.OR.AU(4:4).EQ.' ') AU(4:4)='_'
          AUM(II)=AU
        ENDDO
      ELSE
        AM=ATOM_MISS
        CALL LENSTR_BL(AM,LEN)
        IF(LEN.LE.0.OR.AM(1:1).EQ.' ') AM(1:1)=' '
        IF(LEN.LE.1.OR.AM(2:2).EQ.' ') AM(2:2)=' '
        IF(LEN.LE.2.OR.AM(3:3).EQ.' ') AM(3:3)=' '
        IF(LEN.LE.3.OR.AM(4:4).EQ.' ') AM(4:4)=' '
        ATOM_MISS=AM

        AU=ATOM_UNK
        CALL LENSTR_BL(AU,LEN)
        IF(LEN.LE.0.OR.AU(1:1).EQ.' ') AU(1:1)=' '
        IF(LEN.LE.1.OR.AU(2:2).EQ.' ') AU(2:2)=' '
        IF(LEN.LE.2.OR.AU(3:3).EQ.' ') AU(3:3)=' '
        IF(LEN.LE.3.OR.AU(4:4).EQ.' ') AU(4:4)=' '
        ATOM_UNK=AU

        AM=ATOM_MISS
        CALL LENSTR_BL(AM,LEN)
        IF(LEN.LE.0.OR.AM(1:1).EQ.' ') AM(1:1)='_'
        IF(LEN.LE.1.OR.AM(2:2).EQ.' ') AM(2:2)='_'
        IF(LEN.LE.2.OR.AM(3:3).EQ.' ') AM(3:3)='_'
        IF(LEN.LE.3.OR.AM(4:4).EQ.' ') AM(4:4)='_'
        AU=ATOM_UNK
        CALL LENSTR_BL(AU,LEN)
        IF(LEN.LE.0.OR.AU(1:1).EQ.' ') AU(1:1)='_'
        IF(LEN.LE.1.OR.AU(2:2).EQ.' ') AU(2:2)='_'
        IF(LEN.LE.2.OR.AU(3:3).EQ.' ') AU(3:3)='_'
        IF(LEN.LE.3.OR.AU(4:4).EQ.' ') AU(4:4)='_'

      ENDIF

      IF(FUNC.EQ.'REP') THEN
        CH2   = '<-'
        MOD   = M3//AM(1:3)//ATOM_UNK(1:2)
        NAMEM = FUNC//'-'//AM//CH2//AU//'-'//MON
      ELSE IF(FUNC.EQ.'ADD') THEN
        CH2   = '->'
        MOD   = M3//'+'//ATOM_UNK(1:4)
        NAMEM = FUNC//'-'//AU//CH2//MON
      ELSE IF(FUNC.EQ.'DEL') THEN 
        CH2   = '->'
        MOD   = M3//'-'//ATOM_MISS(1:4)
        NAMEM = FUNC//'-'//AM//CH2//MON
      ELSE IF(FUNC.EQ.'MAD') THEN 
        IF(NATM.LE.0.OR.NATM.GE.10) RETURN
        WRITE(CH1,'(I1)') NATM
        MOD = M3//'+'//CH1//ATOM_U(1)(1:3)
        STR = 'ADD'
        DO II=1,NATM
          CALL LENSTR_BL(STR,LEN)
          NAMEM = STR(1:LEN)//'-'//AUM(II)
          STR   = NAMEM 
        ENDDO
      ELSE IF(FUNC.EQ.'MDL') THEN 
        IF(NATM.LE.0.OR.NATM.GE.10) RETURN
        WRITE(CH1,'(I1)') NATM
        MOD = M3//'-'//CH1//ATOM_U(1)(1:3)
        STR = 'DEL'
        DO II=1,NATM
          CALL LENSTR_BL(STR,LEN)
          NAMEM = STR(1:LEN)//'-'//AUM(II)
          STR   = NAMEM 
        ENDDO
      ENDIF
C     search
      IMOD = 0

      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD
          IF(MOD.EQ.LDL_MNAME(L)) THEN
            CALL LENSTR_BL(NAMEM,LEN)
            IF(NAMEM(1:LEN).EQ.LDL_DETAIL(L)(1:LEN)) THEN
              IMOD = L
              RETURN
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      IF(LDL_NMOD.GT.0) THEN
        
        FUNC_L = FUNC
        IF(FUNC.EQ.'MDL') FUNC_L = 'DEL'
        IF(FUNC.EQ.'MAD') FUNC_L = 'ADD'

        IF(IRTYPE.EQ.3.OR.IRTYPE.EQ.4) THEN
C         protein
          IT = 3
        ELSE IF(IRTYPE.EQ.5.OR.IRTYPE.EQ.6) THEN
C         DNA/RNA
          IT = 5
        ELSE IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
C         saccharide

          MOD_L = ' '
          IF(MOD(4:7).EQ.'-1O1'.AND.NAMEM(1:8).EQ.'DEL-O1__') THEN
            MOD_L = 'DEL-O1'
          ELSE IF(MOD(4:7).EQ.'-1O2'.AND.NAMEM(1:8).EQ.'DEL-O2__')THEN
            MOD_L = 'DEL-O2'
          ENDIF

          IF(LDL_NMOD.GT.0.AND.MOD_L.NE.' ') THEN
            DO L=1,LDL_NMOD
              IF(MOD_L.EQ.LDL_MNAME(L)) THEN
                MOD  = MOD_L
                IMOD = L
                RETURN
              ENDIF
            ENDDO
          ENDIF

        ENDIF

        CALL LOOK_MODREC(FUNC_L,IT,NAMEM,IMOD,MOD_L,IERR)      
        IF(IMOD.GT.0) MOD = MOD_L

      ENDIF

      RETURN
      END

      
      SUBROUTINE LOOK_MODREC(FUNC,IRTYPE,NAMEM,IMOD,MOD,IERR)      
C ------------------------------------------------------
      INTEGER*4 IMOD,IERR
      CHARACTER NAMEM*(*),MOD*8,FUNC*3
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      IERR = 0
      IMOD = 0
      MOD  = ' '

      CALL LENSTR_BL(NAMEM,LEN)

      IF(LEN      .LE.0) RETURN
      IF(N_MOD_REC.LE.0) RETURN

C      WRITE(*,*) ' N_MOD_REC:',N_MOD_REC,';',FUNC

      DO L=1,N_MOD_REC

C        WRITE(*,*) IRTYPE,MOD_REC_IRTYPE(L)
C        WRITE(*,*) ';',NAMEM(1:LEN),';',MOD_REC_DETAIL(L)(1:LEN),';'
C     *  ,MOD_REC_FUNC(L),';'

        IF(IRTYPE.EQ.MOD_REC_IRTYPE(L).AND.
     *     FUNC  .EQ.MOD_REC_FUNC(L)       ) THEN
          IF(NAMEM(1:LEN).EQ.MOD_REC_DETAIL(L)(1:LEN)) THEN
            MOD = MOD_REC_ID(L)

C            WRITE(*,*) ' MOD:',';',MOD,';'             

            GO TO 100
          ENDIF
        ENDIF
      ENDDO 
      RETURN

 100  CONTINUE
      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD

C        WRITE(*,*) L,';',MOD,';',LDL_MNAME(L),';'

          IF(MOD.EQ.LDL_MNAME(L)) THEN
            IF(MOD.EQ.LDL_MNAME(L)) THEN
              IMOD = L
              RETURN
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
C --------------------------------
      INTEGER   NA,NB,NG,NT,NP,IERR
      CHARACTER LB*3,LINE*256
      INCLUDE 'lib_com.fh'
C --------------------------------
C     LB = 'MON' 'LB1' 'MOD' 'LIN'
C
      IERR=0
      IF(LB.EQ.'MOD') THEN
        IF(NA.GE.MAXDATM) THEN
          WRITE(LINE,
     *'('' ERROR: number of atoms for the modifications >'',I6)') 
     *  MAXDATM
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''        Change parameter MAXDATM in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        IF(NB.GE.MAXDBND) THEN
          WRITE(LINE,
     *'('' ERROR: number of bonds for the modifications >'',I6)') 
     *  MAXDBND
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''        Change parameter MAXDBND in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        IF(NG.GE.MAXDANG) THEN
          WRITE(LINE,
     *'('' ERROR: number of angles for the modifications >'',I6)') 
     *  MAXDANG
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''        Change parameter MAXDANG in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
      ENDIF
      RETURN
      END

      SUBROUTINE CHECK_COMPL(MDOC,LIST,MODE,ISYN,MON,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ------------------------------------------
      INTEGER*4 IPAIR1(LENLIM)
      INTEGER*4 IPAIR2(LENLIM)

      CHARACTER LINE*80,SYMB*4,CH4*4,MONN*8,ATOM*4,AATOM*4
      INTEGER   ICONTENT(15)
      CHARACTER ATM_SYMB(15)*2
      DATA  ATM_SYMB
     */'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN'
     *,'MO','  '/
C       1    2    3    4    5    6    7    8    9    10   11   12   13
C       14   15
C --------------------------------
      IERR = 0
      M    =-ABS(MDOC)-1
      IF(LIST.EQ.'T'.OR.LIST.EQ.'L') M = MDOC
C ------------------------------------------
      MTC_NTYPE = 0
      DO I=1,MAX1ATM
        MTC_NUMB  (I,1) = 0
        MTC_NUMB  (I,2) = 0
        MTC_NUMB1 (I)   = 0
        MTC_NUMB2 (I)   = 0
        MTC_NAME1 (I)   = ' '
        MTC_NAME2 (I)   = ' '
        MTC_IB1   (I)   = 0
        MTC_IB2   (I)   = 0
        DO J=1,MAX1ATM
          MTC_CONN(I,J) = 0
        ENDDO
      ENDDO
      DO I=1,LENLIM
        MTC_INDEX1(I)   = 0
        MTC_INDEX2(I)   = 0
      ENDDO
      DO I=1,LENLIM
        IPAIR1(I)   = 0
        IPAIR2(I)   = 0
      ENDDO
      DO I=1,15
        ICONTENT(I) = 0
      ENDDO

      MTC_C_INDEX   = '000'
      MTC_C_CONTENT = '000'
      MTC_C_PAIR    = '000'

      ISCORE  = 0
      NOCC    = 0
C --------------------------------------
      IF(MODE.EQ.'LIB ') GO TO 420      

      MTC_NA1 = 0

      IF(C1_NATOM.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        write(line,'(''crd NA:'',I4,A)')
     *  C1_NATOM,C1_RNAME
        CALL MSGDOC(MDoc,LINE)
        DO I=1,C1_NATOM
          write(line,'(''  '',I4,A,A,F8.2)')
     *    i,C1_ANAME(I),C1_ASYMB(I),C1_OCC(I)
          CALL MSGDOC(MDoc,LINE)
          NL = S1_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              k = S1_CONN(J,I)
              write(line,'(''  --->'',2I4,A,A)')
     *        j,S1_CONN(J,I),C1_ANAME(k),C1_ASYMB(k)
              CALL MSGDOC(MDoc,LINE)
            ENDDO
          ENDIF
        ENDDO
      ENDIF 

      DO I=1,C1_NATOM
      IF(C1_ANAME(I).NE.'    ') THEN
        IF(C1_OCC(I).LT.0.0001) THEN
          NOCC = NOCC + 1
        ELSE
          SYMB = C1_ASYMB(I)
          IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
            MTC_NA1            = MTC_NA1+1
            MTC_NUMB1(MTC_NA1) = I
            MTC_NAME1(MTC_NA1) = C1_ANAME(I)
            MTC_IB1  (I)       = MTC_NA1
            MTC_SYMB1(MTC_NA1) = 4
            IF(SYMB(1:2).EQ.'C ') MTC_SYMB1(MTC_NA1) = 1
            IF(SYMB(1:2).EQ.'N ') MTC_SYMB1(MTC_NA1) = 2
            IF(SYMB(1:2).EQ.'O ') MTC_SYMB1(MTC_NA1) = 3
            IF(MTC_NTYPE.GT.0) THEN
              DO J=1,MTC_NTYPE
                IF(SYMB(1:2).EQ. MTC_SYMB(J)(1:2)) THEN
                  MTC_NUMB(J,1) = MTC_NUMB(J,1) + 1
                  GO TO 400
                ENDIF
              ENDDO
            ENDIF
            MTC_NTYPE     = MTC_NTYPE + 1
            J             = MTC_NTYPE
            MTC_NUMB(J,1) = MTC_NUMB(J,1) + 1
            MTC_SYMB(J)   = SYMB(1:2)
 400        CONTINUE
            IF(MODE(1:1).NE.' ') THEN
              DO K=1,15
                IF(SYMB(1:2).EQ.ATM_SYMB(K)) THEN
                  ICONTENT(K) =  ICONTENT(K) + 1
                  GO TO 410
                ENDIF
              ENDDO
            ENDIF
 410        CONTINUE
          ENDIF
        ENDIF
      ENDIF
      ENDDO

      IF(MTC_NA1.GT.0) THEN
        DO IM=1,MTC_NA1
          I  = MTC_NUMB1(IM)
          NL = S1_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              KK = S1_CONN(J,I)
              IF(MTC_IB1(KK).NE.0) THEN
                NJA  = MTC_IB1(KK)
                SYMB = C1_ASYMB(KK)
                IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
                  IF(IM.GT.NJA) THEN
C                   MTC_CONN1(IM<NJA)
                    MTC_CONN(NJA,IM) = 1
                  ELSE
                    MTC_CONN(IM,NJA) = 1
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF            
        ENDDO 
      ENDIF

      IF(MODE.EQ.'CRD ') THEN
        DO I=1,15
          WRITE(CH4,'(I4)') ICONTENT(I)
          IF(ICONTENT(I).GT.99) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          I1 = (I-1)*2 + 1
          I2 = I1  + 1
          MTC_C_CONTENT(I1:I2) = CH4(3:4)
        ENDDO

        IF(LIST.EQ.'T') THEN
          write(line,'(''crd -->'',A30,'';'')')
     *    MTC_C_CONTENT
          CALL MSGDOC(MDoc,LINE)
        endif

      ENDIF

      IF(MTC_NA1.LE.1.AND.MODE.EQ.'CRD ') RETURN

 420  CONTINUE
      IF(MODE.EQ.'CRD ') GO TO 450      

      MTC_NA2 = 0
 
      IF(L1A_NATOM.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        write(line,'(''lib NA:'',I4,A)')
     *  L1A_NATOM,L1L_MNAME
        CALL MSGDOC(MDoc,LINE)
        DO I=1,l1a_NATOM
          write(line,'(''  '',I4,A,A,i4)')
     *    i,L1A_ANAME(I),L1A_SYMB(I),L1A_NDIST(I)
          CALL MSGDOC(MDoc,LINE)
          NL = L1A_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              k = L1A_CONN(J,I)
              write(line,'(''  --->'',2I4,A,A)')
     *        j,L1A_CONN(J,I),L1A_ANAME(k),L1A_SYMB(k)
              CALL MSGDOC(MDoc,LINE)
            ENDDO
          ENDIF
        ENDDO
        IF(L1B_NBOND.GT.0) THEN
          DO IB=1,L1B_NBOND
            write(line,'(''  bond'',I4,'' '',A,''-->'',A)')
     *      IB,L1B_1ATM(IB),L1B_2ATM(IB)
            CALL MSGDOC(MDoc,LINE)
          ENDDO
        ENDIF
      ENDIF 


      DO I=1,L1A_NATOM
      IF(L1A_ANAME(I).NE.'    ') THEN
        SYMB = L1A_SYMB(I)
        IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
          MTC_NA2            = MTC_NA2+1
          MTC_NUMB2(MTC_NA2) = I
          MTC_NAME2(MTC_NA2) = L1A_ANAME(I)
          MTC_IB2(I)         = MTC_NA2
          MTC_SYMB2(MTC_NA2) = 4
          IF(SYMB(1:2).EQ.'C ') MTC_SYMB2(MTC_NA2) = 1
          IF(SYMB(1:2).EQ.'N ') MTC_SYMB2(MTC_NA2) = 2
          IF(SYMB(1:2).EQ.'O ') MTC_SYMB2(MTC_NA2) = 3
          IF(MTC_NTYPE.GT.0) THEN
            DO J=1,MTC_NTYPE
              IF(SYMB(1:2).EQ. MTC_SYMB(J)(1:2)) THEN
                MTC_NUMB(J,2) = MTC_NUMB(J,2) + 1
                GO TO 430
              ENDIF
            ENDDO
          ENDIF
          MTC_NTYPE     = MTC_NTYPE + 1
          J             = MTC_NTYPE
          MTC_NUMB(J,2) = MTC_NUMB(J,2) + 1
          MTC_SYMB(J)   = SYMB(1:2)
 430      CONTINUE
          IF(MODE(1:1).NE.' ') THEN
            DO K=1,15
              IF(SYMB(1:2).EQ.ATM_SYMB(K)) THEN
                ICONTENT(K) =  ICONTENT(K) + 1
                GO TO 440
              ENDIF
            ENDDO
          ENDIF
 440      CONTINUE
        ENDIF
      ENDIF
      ENDDO

      IF(MTC_NA2.GT.0) THEN
   
        DO IM=1,MTC_NA2
          I  = MTC_NUMB2(IM)
          NL = L1A_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              KK = L1A_CONN(J,I)
              IF(MTC_IB2(KK).NE.0) THEN
                NJA  = MTC_IB2(KK)
                SYMB = L1A_SYMB(KK)
                IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
                  IF(IM.GT.NJA) THEN
C                   MTC_CONN2(IM>NJA)
                    MTC_CONN(IM,NJA) = 1
                  ELSE
                    MTC_CONN(NJA,IM) = 1
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF            
        ENDDO

      ENDIF

      IF(MODE.EQ.'LIB ') THEN
        DO I=1,15
          WRITE(CH4,'(I4)') ICONTENT(I)
          IF(ICONTENT(I).GT.99) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          I1 = (I-1)*2 + 1
          I2 = I1  + 1
          MTC_C_CONTENT(I1:I2) = CH4(3:4)
        ENDDO

        IF(LIST.EQ.'T') THEN
          write(line,'(''lib -->'',A30,'';'')')
     *    MTC_C_CONTENT
          CALL MSGDOC(MDoc,LINE)
        ENDIF

      ENDIF

      IF(MTC_NA2.LE.1.AND.MODE.EQ.'LIB ') RETURN

 450  CONTINUE


      IF((MTC_NA1.LE.1.OR.MTC_NA2.LE.1).AND.MODE(1:1).EQ.' ') THEN

        IF(MTC_NA1.EQ.1.AND.MTC_NA2.EQ.1) THEN
          IF(MTC_NAME1(1).EQ.MTC_NAME2(1)) THEN
            RETURN
          ELSE
            IS = MTC_SYMB1(1)
            JS = MTC_SYMB2(1)
            IF(IS.EQ.JS) THEN
              MTC_NEW(1)=1
              GO TO 200
            ENDIF
          ENDIF 
        ELSE IF(MTC_NA1.LE.0.OR.MTC_NA2.LE.0) THEN
          IERR=5 
        ELSE IF(MTC_NA1.EQ.1) THEN
          IERR=6
        ELSE IF(MTC_NA2.EQ.1) THEN
          IERR=7
        ENDIF

        RETURN

      ENDIF

C -----////
      IF(LIST.EQ.'T') THEN
      IF(MODE(1:1).EQ.' ') THEN
        N =  MTC_NTYPE
        IF(N.GT.25) N = 25
        WRITE(LINE,'(''Natom(crd,lib),Nocc:'',3(1X,I3))') 
     *  MTC_NA1,MTC_NA2,NOCC
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(4X,25(1X,A2))'   ) (MTC_SYMB(J)  ,J=1,N)
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(''crd:'',25(I3))') (MTC_NUMB(J,1),J=1,N)
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(''lib:'',25(I3))') (MTC_NUMB(J,2),J=1,N)
        CALL MSGERR(MDOC,LINE)
      ENDIF
      ENDIF
C -----////

      IF(MODE(1:1).EQ.' ') THEN
C       IF((MTC_NA1-MTC_NA2).GT.(NOCC+1)) THEN
        IF(ABS((MTC_NA1+NOCC)-MTC_NA2).GT.2) THEN
          IERR = 11
          RETURN
        ENDIF

        DO I=1,MTC_NTYPE
          IF(MTC_SYMB(I).NE.'C   '.AND.MTC_SYMB(I).NE.'N   '.AND.
     *       MTC_SYMB(I).NE.'O   '                         ) THEN
            IF(MTC_NUMB(I,1).NE.MTC_NUMB(I,2)) THEN
              IERR = 12
              RETURN
            ENDIF
          ENDIF
        ENDDO
      ENDIF
C --------------------   
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' ')
        write(line,'(''-->1     '',10A4)')
     *  (MTC_NAME1(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        DO J=1,10
          write(line,'(''l '',A4,'' '',10I4,''  '',a4)')
     *    MTC_NAME2(J),(MTC_CONN(J,I),I=1,10),mtc_name1(j)
          CALL MSGDOC(MDoc,LINE)
        ENDDO
        write(line,'(''-->2     '',10A4)')
     *  (MTC_NAME2(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        CALL MSGDOC(MDoc,' ')
      ENDIF

      IF(MODE.NE.'LIB ') CALL SET_TABCONN_C
      IF(MODE.NE.'CRD ') CALL SET_TABCONN_L

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' ')
        write(line,'(''       '',10A4)')
     *  (MTC_NAME1(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        DO J=1,10
          write(line,'(''l '',A4,'' '',10I4)')
     *    MTC_NAME2(J),(MTC_CONN(J,I),I=1,10)
          CALL MSGDOC(MDoc,LINE)
        ENDDO
        write(line,'(''-->2     '',10A4)')
     *  (MTC_NAME2(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        CALL MSGDOC(MDoc,' ')
      ENDIF
C -------------------
C                I
C         \      .
C          \     .
C   J  .....\... N          N - minimal number of bonds between I - J atoms
C            \
C      L1A    \  C1
C              \
C               \
C                \
C
C
C --------------------
      IF(MODE.NE.'LIB ') CALL SET_VECTOR_C(IPAIR1)
      IF(MODE.NE.'CRD ') CALL SET_VECTOR_L(IPAIR2)
c -----------------------------------------------
c           1, 2, ..length..  ,8
c  index:             N                 N  pairs of atoms with with length
c
c            1, 2, ...          ,8
c  vector: 1          Nc             C
c  / for   2          Nn             N
c   each   3          No             O
c   atom / 4          N-             -
c ------------------------------------------------

C -----////
      IF(LIST.EQ.'T') THEN

      IF(MODE(1:1).EQ.' ') THEN
      CALL MSGERR(MDOC,' ----crd------')
      WRITE(LINE,'('' Index: '',8(1X,I3))') (MTC_INDEX1(J),J=1,LENLIM)
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA1
        WRITE(LINE,'(I3,1X,A4,1X,I4,8(1X,I3),'' C '')') 
     *      I,MTC_NAME1(I),MTC_SYMB1(I),(MTC_VEC1(I,J,1),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' N '')') 
     *               (MTC_VEC1(I,J,2),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' O '')') 
     *               (MTC_VEC1(I,J,3),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' - '')') 
     *               (MTC_VEC1(I,J,4),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
      ENDDO

      CALL CREATE_INDEX(MTC_INDEX1,MTC_C_INDEX,IPAIR1,MTC_C_PAIR)

      write(line,'(''-->'',A24,'';'')')
     *MTC_C_INDEX
      CALL MSGDOC(MDOC,LINE)
      write(line,'(''  ;'',A24,'';'')')
     *MTC_C_PAIR
      CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(MODE(1:1).EQ.' ') THEN
      CALL MSGERR(MDOC,' ----lib------')
      WRITE(LINE,'('' Index: '',8(1X,I3))') (MTC_INDEX2(J),J=1,LENLIM)
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA2
        WRITE(LINE,'(I3,1X,A4,1X,I4,8(1X,I3),'' C '')') 
     *       I,MTC_NAME2(I),MTC_SYMB2(I),(MTC_VEC2(I,J,1),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' N '')') 
     *               (MTC_VEC2(I,J,2),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' O '')') 
     *               (MTC_VEC2(I,J,3),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' - '')') 
     *               (MTC_VEC2(I,J,4),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
      ENDDO
      CALL MSGERR(MDOC,' ----------')

      CALL CREATE_INDEX(MTC_INDEX2,MTC_C_INDEX,IPAIR2,MTC_C_PAIR)

      write(line,'(''-->'',A24,'';'')')
     *MTC_C_INDEX
      CALL MSGDOC(MDOC,LINE)
      write(line,'(''  ;'',A24,'';'')')
     *MTC_C_PAIR
      CALL MSGDOC(MDOC,LINE)
      ENDIF

      ENDIF
C -----////
C --------------------
      IF(MODE.EQ.'CRD ') THEN
        CALL CREATE_INDEX(MTC_INDEX1,MTC_C_INDEX,IPAIR1,MTC_C_PAIR)
        RETURN
      ELSE IF(MODE.EQ.'LIB ') THEN
        CALL CREATE_INDEX(MTC_INDEX2,MTC_C_INDEX,IPAIR2,MTC_C_PAIR)

        IF(LIST.EQ.'T') THEN
        write(line,'(''-->'',A24,'';'')')
     *  MTC_C_INDEX
        CALL MSGDOC(MDOC,LINE)
        write(line,'(''  ;'',A24,'';'')')
     *  MTC_C_PAIR
        CALL MSGDOC(MDOC,LINE)
        ENDIF

        RETURN
      ENDIF
C --------------------
      CALL COMP_VECTOR
C ---------------------------------------
C              ATOM_1
C       1,2 ---   i  ---
C
C           ...  N_equiv ...     
C
C a   1          "
C t   2          "
C o   .          "
C m   j         delt
C !   .          "
C 2   .          "
C     .          "
C ---------------------------------------- 

C -----////
      IF(LIST.EQ.'T') THEN
      CALL MSGERR(MDOC,' ---- EQUIV ------')
      DO I=1,MTC_NA1
        N =  MTC_NEQUIV(I)
        IF(N.GT.20) N = 20
        IF(N.GT.0) THEN
          WRITE(LINE,'(2I4,'' - '',20(1X,I2))') 
     *    I,N,(MTC_DELTA(J,I),J=1,N) 
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(''         - '',20(1X,I2))') 
     *    (MTC_IEQUIV(J,I),J=1,N) 
          CALL MSGERR(MDOC,LINE)
        ELSE
          WRITE(LINE,'(2I4,'' - '')') 
     *    I,N 
          CALL MSGERR(MDOC,LINE)
        ENDIF  
      ENDDO 
      ENDIF
C -----////


C --------------------
      DO I=1,MTC_NA1
        MTC_NEW(I) = 0
      ENDDO
      N_NEW = 0
C --------------------

 100  CONTINUE

      CALL CHECK_EQUIV(MDOC,N_NEW,IFLAG,ISCORE,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF

      IF(N_NEW.EQ.MTC_NA1) GO TO 200
      IF(IFLAG.EQ.1      ) GO TO 100

      IF(N_NEW.LT.MTC_NA1) THEN

C       IF((MTC_NA1-N_NEW).EQ.1) ?????

        IERR=5
        RETURN
      ENDIF

C -----------------
C     --- OK ---
C 
 200  CONTINUE
C  SYNONYMS & COORDS


C -----////
      IF(LIST.EQ.'T') THEN
      WRITE(LINE,'(''  ISCORE : '',I5)') ISCORE
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).NE.0) THEN
          J  = MTC_NEW(I)
          WRITE(LINE,*) I,MTC_NAME1(I),J,MTC_NAME2(J)
          CALL MSGERR(MDOC,LINE)
        ELSE
          WRITE(LINE,*) I,MTC_NAME1(I),' -'
          CALL MSGERR(MDOC,LINE)
        ENDIF
      ENDDO
      ENDIF
C -----////

      DO I=1,MTC_NA1
        IF(MTC_NEW(I).NE.0) THEN
          J  = MTC_NEW(I)
          IF(MTC_NAME1(I).NE.MTC_NAME2(J)) THEN
            DO I2=1,MTC_NA1
              IF(MTC_NAME1(I2).EQ.MTC_NAME2(J)) THEN
                J2  = MTC_NEW(I2)
                IF(MTC_NAME1(I).EQ.MTC_NAME2(J2)) THEN
                  MTC_NEW(I)  = J2
                  MTC_NEW(I2) = J
                  II = MTC_NUMB2(J)
                  MTC_NUMB2(J) = MTC_NUMB2(J2)
                  MTC_NUMB2(J2)= II
                  II = MTC_NUMB1(I)
                  MTC_NUMB1(I) = MTC_NUMB1(I2)
                  MTC_NUMB1(I2)= II
                  GO TO 300
                ELSE
C                 I - J
C                     I2- J3
C                         I3-J3  
                  DO I3=1,MTC_NA1
                   IF(MTC_NAME1(I3).EQ.MTC_NAME2(J2)) THEN
                     J3  = MTC_NEW(I3)
                     IF(MTC_NAME1(I).EQ.MTC_NAME2(J3)) THEN
                        MTC_NEW(I)  = J3
                        MTC_NEW(I2) = J
                        MTC_NEW(I3) = J2
                        II = MTC_NUMB2(J)
                        MTC_NUMB2(J) = MTC_NUMB2(J3)
                        MTC_NUMB2(J3)= MTC_NUMB2(J2)
                        MTC_NUMB2(J2)= II
                        II = MTC_NUMB1(I)
                        MTC_NUMB1(I) = MTC_NUMB1(I3)
                        MTC_NUMB1(I3)= MTC_NUMB1(I2)
                        MTC_NUMB1(I2)= II
                        GO TO 300
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF        
 300    CONTINUE
      ENDDO

C -----////
      IF(LIST.EQ.'T') THEN
      WRITE(LINE,'('' NEW --- : '')') 
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).NE.0) THEN
          J  = MTC_NEW(I)
          WRITE(LINE,*) I,MTC_NAME1(I),J,MTC_NAME2(J)
          CALL MSGERR(MDOC,LINE)
        ELSE
          WRITE(LINE,*) I,MTC_NAME1(I),' -'
          CALL MSGERR(MDOC,LINE)
        ENDIF
      ENDDO
      ENDIF
C -----////

      IFIRST   = 0
      IFIRST_S = 0

C     IF(ISYN.GE.1) RETURN
      IF(ISYN.EQ.1) RETURN

      CALL COPYC2(MDOC,IERR)

      DO I=1,MTC_NA1

        IF(MTC_NEW(I).NE.0) THEN

          J  = MTC_NEW(I)
          JJ = MTC_NUMB2(J)
          II = MTC_NUMB1(I)

          L1A_COOR_FLAG(JJ) = 'Y'
          IF(C1_OCC(II).LT.0.0001) L1A_COOR_FLAG(JJ) = 'N'
          L1A_X (JJ) = C1_XYZ(1,II)
          L1A_Y (JJ) = C1_XYZ(2,II)
          L1A_Z (JJ) = C1_XYZ(3,II)

          IF(C1_ANAME(II).NE.L1A_ANAME(JJ)) THEN

            IF(ISYN.EQ.0) THEN

              IF(LMS_NSYN.GE.MAXMLIST) RETURN
              IF(LMS_NSYN.GT.0) THEN
                DO IS=1,LMS_NSYN
                  IF(LMS_MNAME (IS).EQ.MON     .AND.
     *               LMS_MNAME2(IS).EQ.C1_RNAME     ) THEN
                    IF(LMS_ATOM (IS).EQ.L1A_ANAME(JJ).AND.
     *                 LMS_AATOM(IS).EQ.C1_ANAME(II)      ) THEN
                      GO TO 500
                    ENDIF
                  ENDIF
                ENDDO
              ENDIF

              MONN  = C1_RNAME
              IF(MON.EQ.MONN) MONN = '.'
              ATOM  = L1A_ANAME(JJ)
              AATOM = C1_ANAME (II)
 
              CALL CHECK_SYNONYM(IT,MON,MONN,ATOM,AATOM)
              IF(IT.EQ.0) THEN
                LMS_NSYN = LMS_NSYN + 1
                LMS_NEW  = LMS_NEW  + 1
                IF(IFIRST_S.EQ.0) THEN
                  LMS_ISYN = LMS_NSYN
                  IFIRST_S = 1
                ENDIF
                LMS_MNAME  (LMS_NSYN) = MON
                LMS_MNAME2 (LMS_NSYN) = '.'
                LMS_ATOM   (LMS_NSYN) = ATOM
                LMS_MOD    (LMS_NSYN) = '.' 
                LMS_AATOM  (LMS_NSYN) = AATOM 
                LMS_AMNAME (LMS_NSYN) = MONN  
                LMS_AMNAME2(LMS_NSYN) = '.' 
                LMS_FLAG   (LMS_NSYN) = 'N' 
              ENDIF

 500          CONTINUE

            ENDIF

            IF(IFIRST.EQ.0) THEN
              IFIRST   = 1
                WRITE(LINE,
     * '('' WARNING : program changed some atom names to standard'')')
              CALL MSGDOC(M,LINE)
            ENDIF
            WRITE(LINE,'(A,A,A,A4,A,A4,A)')
     *'           ',MON,'  "',C1_ANAME(II),'" ---> "',L1A_ANAME(JJ),'"'
            CALL MSGDOC(M,LINE)

            C2_ANAME(II)=L1A_ANAME(JJ)
C           C1_ANAME(II)=L1A_ANAME(JJ)

          ENDIF
        ENDIF
      ENDDO

      IF(IFIRST.NE.0.AND.ISYN.EQ.0) THEN
        CALL COPYC1(MDOC,IERR)  
      ENDIF

C --------------------
      RETURN
      END

      SUBROUTINE CREATE_INDEX(INDEX,C_INDEX,IPAIR,C_PAIR)
C ------------------------------------------
      PARAMETER (LENLIM   =  8)
      INTEGER*4 INDEX(LENLIM)
      INTEGER*4 IPAIR(LENLIM)
      CHARACTER C_INDEX  *24
      CHARACTER C_PAIR   *24
      CHARACTER CH4*4
C ------------------------------------------
        DO I=1,8
          IND = INDEX(I)/2
          WRITE(CH4,'(I4)') IND
          IF(IND.GT.999) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          IF(CH4(2:2).EQ.' ') CH4(2:2) = '0' 
          I1 = (I-1)*3 + 1
          I2 = I1  + 2
          C_INDEX(I1:I2) = CH4(2:4)

          IND =  IPAIR(I)/2
          WRITE(CH4,'(I4)') IND
          IF(IND.GT.999) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          IF(CH4(2:2).EQ.' ') CH4(2:2) = '0' 
          I1 = (I-1)*3 + 1
          I2 = I1  + 2
          C_PAIR(I1:I2) = CH4(2:4)
        ENDDO
      RETURN
      END

      SUBROUTINE CHECK_SYNONYM(IT,MON,MONN,ATOM,AATOM)
C ----------------------------
      INTEGER   IT
      CHARACTER MON*8,MONN*8,ATOM*4,AATOM*4
C ---
      INCLUDE 'lib_com.fh'
C ----------------------------

      IT = 2
      IF(LMS_NSYN.GE.MAXMLIST) RETURN
       
      IF(LMS_NSYN.GT.0) THEN
        DO I=1,LMS_NSYN
          IF(LMS_MNAME(I).EQ.MON .AND.LMS_AMNAME(I).EQ.MONN .AND.
     *       LMS_ATOM (I).EQ.ATOM.AND.LMS_AATOM (I).EQ.AATOM     )
     *    THEN
            IT = 1
            RETURN
          ENDIF 
        ENDDO
      ENDIF
      IT = 0
      RETURN
      END


      SUBROUTINE SET_VECTOR_L(IPAIR2)
C -----------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24

      INTEGER*4 IPAIR2(*)
C ---------------------------------------------
      NA = MTC_NA2
      DO I=1,NA
        DO J=1,LENLIM
          DO K=1,ISYMBMAX
            MTC_VEC2(I,J,K) = 0
          ENDDO
        ENDDO
      ENDDO
C --
      LN = NA
      IF(LN.GT.LENLIM) LN = LENLIM

      DO I=1,NA
        IS = MTC_SYMB2(I)
        DO J=1,NA
          IF(I.NE.J) THEN
            JS = MTC_SYMB2(J)
            IF(J.GT.I) THEN
              IL = MTC_CONN(J,I)
            ELSE
              IL = MTC_CONN(I,J)
            ENDIF
            IF(IL.GT.0.AND.IL.LE.LN.AND.JS.GT.0.AND.JS.LE.ISYMBMAX)
     *      THEN
              MTC_VEC2(I,IL,JS) = MTC_VEC2(I,IL,JS) + 1
              MTC_INDEX2(IL)    = MTC_INDEX2(IL)    + 1
C            'C ','N ','O ',..
              IP = 0
              IF(IL.EQ.1) THEN
              IF(IS.EQ.1) THEN
                IF(JS.EQ.1) THEN
                  IP = 1
                ELSE IF(JS.EQ.2) THEN
                  IP = 2
                ELSE IF(JS.EQ.3) THEN
                  IP = 3
                ENDIF
              ELSE IF(IS.EQ.2) THEN
                IF(JS.EQ.1) THEN
                  IP = 2
                ELSE IF(JS.EQ.2) THEN
                  IP = 4
                ELSE IF(JS.EQ.3) THEN
                  IP = 5
                ENDIF
              ELSE IF(IS.EQ.3) THEN
                IF(JS.EQ.1) THEN
                  IP = 3
                ELSE IF(JS.EQ.2) THEN
                  IP = 5
                ELSE IF(JS.EQ.3) THEN
                  IP = 6
                ENDIF
              ENDIF
              ENDIF
              IF(IP.GT.0) IPAIR2(IP) = IPAIR2(IP) + 1
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      RETURN
      END

      SUBROUTINE SET_VECTOR_C(IPAIR1)
C -----------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24

      INTEGER*4 IPAIR1(*)
C ---------------------------------------------
      NA = MTC_NA1
      DO I=1,NA
        DO J=1,LENLIM
          DO K=1,ISYMBMAX
            MTC_VEC1(I,J,K) = 0
          ENDDO
        ENDDO
      ENDDO
C --
      LN = NA
      IF(LN.GT.LENLIM) LN = LENLIM

      DO I=1,NA
        IS = MTC_SYMB1(I)
        DO J=1,NA
          IF(I.NE.J) THEN
            JS = MTC_SYMB1(J)
            IF(I.GT.J) THEN
              IL = MTC_CONN(J,I)
            ELSE
              IL = MTC_CONN(I,J)
            ENDIF
            IF(IL.GT.0.AND.IL.LE.LN.AND.JS.GT.0.AND.JS.LE.ISYMBMAX)
     *      THEN
              MTC_VEC1(I,IL,JS) = MTC_VEC1(I,IL,JS) + 1
              MTC_INDEX1(IL)    = MTC_INDEX1(IL)    + 1
C            'C ','N ','O ',..
              IP = 0
              IF(IL.EQ.1) THEN
              IF(IS.EQ.1) THEN
                IF(JS.EQ.1) THEN
                  IP = 1
                ELSE IF(JS.EQ.2) THEN
                  IP = 2
                ELSE IF(JS.EQ.3) THEN
                  IP = 3
                ENDIF
              ELSE IF(IS.EQ.2) THEN
                IF(JS.EQ.1) THEN
                  IP = 2
                ELSE IF(JS.EQ.2) THEN
                  IP = 4
                ELSE IF(JS.EQ.3) THEN
                  IP = 5
                ENDIF
              ELSE IF(IS.EQ.3) THEN
                IF(JS.EQ.1) THEN
                  IP = 3
                ELSE IF(JS.EQ.2) THEN
                  IP = 5
                ELSE IF(JS.EQ.3) THEN
                  IP = 6
                ENDIF
              ENDIF
              ENDIF
              IF(IP.GT.0) IPAIR1(IP) = IPAIR1(IP) + 1
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      RETURN
      END


       SUBROUTINE SET_TABCONN_C
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ---------------------------------------------
       NA = MTC_NA1
       DO I=1,NA
C --1    I-I1     
         DO I1=1,NA
           IF(I.EQ.I1) GO TO 101
           IF(I.GT.I1) THEN
             IL1=MTC_CONN(I1,I)
           ELSE
             IL1=MTC_CONN(I,I1)
           ENDIF
           IF(IL1.EQ.1.AND.NA.GT.2) THEN
C --2        I-I1-I2     
             DO I2=1,NA
               IF(I.EQ.I2.OR.I1.EQ.I2) GO TO 102
               IF(I1.GT.I2) THEN
                 IL2=MTC_CONN(I2,I1)
               ELSE
                 IL2=MTC_CONN(I1,I2)
               ENDIF
               IF(IL2.EQ.1.AND.NA.GE.3) THEN
                 IF(I.GT.I2) THEN
                   IF(MTC_CONN(I2,I).EQ.0.OR.
     *             MTC_CONN(I2,I).GT.2) MTC_CONN(I2,I)=2 
                 ELSE
                   IF(MTC_CONN(I,I2).EQ.0.OR.
     *             MTC_CONN(I,I2).GT.2) MTC_CONN(I,I2)=2 
                 ENDIF
C --3          I-I1-I2-I3     
                 DO I3=1,NA
                   IF(I.EQ.I3.OR.I1.EQ.I3.OR.I2.EQ.I3) GO TO 103
                   IF(I2.GT.I3) THEN
                     IL3=MTC_CONN(I3,I2)
                   ELSE
                     IL3=MTC_CONN(I2,I3)
                   ENDIF
                   IF(IL3.EQ.1.AND.NA.GE.4) THEN
                     IF(I.GT.I3) THEN
                       IF(MTC_CONN(I3,I).EQ.0.OR. 
     *                 MTC_CONN(I3,I).GT.3)  
     *                 MTC_CONN(I3,I)=3 
                     ELSE
                       IF(MTC_CONN(I,I3).EQ.0.OR.
     *                 MTC_CONN(I,I3).GT.3)  
     *                 MTC_CONN(I,I3)=3 
                     ENDIF
C --4
                     DO I4=1,NA
                       IF(I.EQ.I4.OR.I1.EQ.I4.OR.I2.EQ.I4.OR. 
     *                 I3.EQ.I4) GO TO 104
                       IF(I3.GT.I4) THEN
                         IL4=MTC_CONN(I4,I3)
                       ELSE
                         IL4=MTC_CONN(I3,I4)
                       ENDIF
                       IF(IL4.EQ.1.AND.NA.GE.5) THEN
                         IF(I.GT.I4) THEN
                           IF(MTC_CONN(I4,I).EQ.0.OR.
     *                     MTC_CONN(I4,I).GT.4)  
     *                     MTC_CONN(I4,I)=4 
                         ELSE
                           IF(MTC_CONN(I,I4).EQ.0.OR. 
     *                     MTC_CONN(I,I4).GT.4)  
     *                     MTC_CONN(I,I4)=4 
                         ENDIF
C --5
                         DO I5=1,NA
                           IF(I.EQ.I5.OR.I1.EQ.I5.OR.I2.EQ.I5.OR.
     *                     I3.EQ.I5.OR.I4.EQ.I5) GO TO 105
                           IF(I4.GT.I5) THEN
                             IL5=MTC_CONN(I5,I4)
                           ELSE
                             IL5=MTC_CONN(I4,I5)
                           ENDIF
                           IF(IL5.EQ.1.AND.NA.GE.6) THEN
                             IF(I.GT.I5) THEN
                               IF(MTC_CONN(I5,I).EQ.0.OR. 
     *                         MTC_CONN(I5,I).GT.5)  
     *                         MTC_CONN(I5,I)=5 
                             ELSE
                               IF(MTC_CONN(I,I5).EQ.0.OR. 
     *                         MTC_CONN(I,I5).GT.5) 
     *                         MTC_CONN(I,I5)=5 
                             ENDIF
C --6
                             DO I6=1,NA
                               IF(I.EQ.I6.OR.I1.EQ.I6.OR.I2.EQ.I6.OR.
     *                         I3.EQ.I6.OR.I4.EQ.I6.OR.I5.EQ.I6) 
     *                         GO TO 106
                               IF(I5.GT.I6) THEN
                                 IL6=MTC_CONN(I6,I5)
                               ELSE
                                 IL6=MTC_CONN(I5,I6)
                               ENDIF
                               IF(IL6.EQ.1.AND.NA.GE.7) THEN
                                 IF(I.GT.I6) THEN
                                   IF(MTC_CONN(I6,I).EQ.0.OR.
     *                             MTC_CONN(I6,I).GT.6)
     *                             MTC_CONN(I6,I)=6 
                                 ELSE
                                   IF(MTC_CONN(I,I6).EQ.0.OR. 
     *                             MTC_CONN(I,I6).GT.6)
     *                             MTC_CONN(I,I6)=6 
                                 ENDIF
C --7
                                 DO I7=1,NA
                                   IF(I.EQ.I7.OR.I1.EQ.I7.OR.I2.EQ.I7
     *                             .OR.I3.EQ.I7.OR.I4.EQ.I7.OR. 
     *                             I5.EQ.I7.OR.I6.EQ.I7) GO TO 107
                                   IF(I6.GT.I7) THEN
                                     IL7=MTC_CONN(I7,I6)
                                   ELSE
                                     IL7=MTC_CONN(I6,I7)
                                   ENDIF
                                   IF(IL7.EQ.1.AND.NA.GE.8) THEN
                                     IF(I.GT.I7) THEN
                                       IF(MTC_CONN(I7,I).EQ.0.OR.
     *                                 MTC_CONN(I7,I).GT.7) 
     *                                 MTC_CONN(I7,I)=7 
                                     ELSE
                                       IF(MTC_CONN(I,I7).EQ.0.OR. 
     *                                 MTC_CONN(I,I7).GT.7)  
     *                                 MTC_CONN(I,I7)=7 
                                     ENDIF
C --8
                                     DO I8=1,NA
                                     IF(I.EQ.I8.OR.I1.EQ.I8.OR.I2.EQ.I8
     *                               .OR.I3.EQ.I8.OR.I4.EQ.I8.OR. 
     *                               I5.EQ.I8.OR.I6.EQ.I8.OR.I7.EQ.I8) 
     *                                 GO TO 108
                                       IF(I7.GT.I8) THEN
                                         IL8=MTC_CONN(I8,I7)
                                       ELSE
                                         IL8=MTC_CONN(I7,I8)
                                       ENDIF
                                       IF(IL8.EQ.1) THEN
                                         IF(I.GT.I8) THEN
                                           IF(MTC_CONN(I8,I).EQ.0.OR.
     *                                     MTC_CONN(I8,I).GT.8)
     *                                     MTC_CONN(I8,I)=8 
                                         ELSE
                                           IF(MTC_CONN(I,I8).EQ.0.OR.
     *                                     MTC_CONN(I,I8).GT.8)  
     *                                     MTC_CONN(I,I8)=8 
                                         ENDIF


                                       ENDIF
 108                                   CONTINUE
                                     ENDDO
C --8
                                   ENDIF
 107                               CONTINUE
                                 ENDDO
C --7
                               ENDIF
 106                           CONTINUE
                             ENDDO
C --6
                           ENDIF
 105                       CONTINUE
                         ENDDO
C --5
                       ENDIF
 104                   CONTINUE
                     ENDDO
C --4
                   ENDIF
 103               CONTINUE
                 ENDDO
C --3
               ENDIF
 102           CONTINUE
             ENDDO
C --2
           ENDIF
 101       CONTINUE
         ENDDO
C --1    
       ENDDO

       RETURN
       END

       SUBROUTINE SET_TABCONN_L
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ---------------------------------------------
       NA=MTC_NA2
       DO I=1,NA
C --1    I-I1     
         DO I1=1,NA
           IF(I.EQ.I1) GO TO 201
           IF(I1.GT.I) THEN
             IL1=MTC_CONN(I1,I)
           ELSE
             IL1=MTC_CONN(I,I1)
           ENDIF
           IF(IL1.EQ.1.AND.NA.GT.2) THEN
C --2        I-I1-I2     
             DO I2=1,NA
               IF(I.EQ.I2.OR.I1.EQ.I2) GO TO 202
               IF(I2.GT.I1) THEN
                 IL2=MTC_CONN(I2,I1)
               ELSE
                 IL2=MTC_CONN(I1,I2)
               ENDIF
               IF(IL2.EQ.1.AND.NA.GE.3) THEN
                 IF(I2.GT.I) THEN
                   IF(MTC_CONN(I2,I).EQ.0.OR. 
     *             MTC_CONN(I2,I).GT.2) 
     *             MTC_CONN(I2,I)=2 
                 ELSE
                   IF(MTC_CONN(I,I2).EQ.0.OR.
     *             MTC_CONN(I,I2).GT.2) 
     *             MTC_CONN(I,I2)=2 
                 ENDIF
C --3          I-I1-I2-I3     
                 DO I3=1,NA
                   IF(I.EQ.I3.OR.I1.EQ.I3.OR.I2.EQ.I3) GO TO 203
                   IF(I3.GT.I2) THEN
                     IL3=MTC_CONN(I3,I2)
                   ELSE
                     IL3=MTC_CONN(I2,I3)
                   ENDIF
                   IF(IL3.EQ.1.AND.NA.GE.4) THEN
                     IF(I3.GT.I) THEN
                       IF(MTC_CONN(I3,I).EQ.0.OR.
     *                 MTC_CONN(I3,I).GT.3) 
     *                 MTC_CONN(I3,I)=3 
                     ELSE
                       IF(MTC_CONN(I,I3).EQ.0.OR. 
     *                 MTC_CONN(I,I3).GT.3) 
     *                 MTC_CONN(I,I3)=3 
                     ENDIF
C --4
                     DO I4=1,NA
                       IF(I.EQ.I4.OR.I1.EQ.I4.OR.I2.EQ.I4.OR. 
     *                 I3.EQ.I4) GO TO 204
                       IF(I4.GT.I3) THEN
                         IL4=MTC_CONN(I4,I3)
                       ELSE
                         IL4=MTC_CONN(I3,I4)
                       ENDIF
                       IF(IL4.EQ.1.AND.NA.GE.5) THEN
                         IF(I4.GT.I) THEN
                           IF(MTC_CONN(I4,I).EQ.0.OR. 
     *                     MTC_CONN(I4,I).GT.4) 
     *                     MTC_CONN(I4,I)=4 
                         ELSE
                           IF(MTC_CONN(I,I4).EQ.0.OR. 
     *                     MTC_CONN(I,I4).GT.4) 
     *                     MTC_CONN(I,I4)=4 
                         ENDIF
C --5
                         DO I5=1,NA
                           IF(I.EQ.I5.OR.I1.EQ.I5.OR.I2.EQ.I5.OR.
     *                     I3.EQ.I5.OR.I4.EQ.I5) GO TO 205
                           IF(I5.GT.I4) THEN
                             IL5=MTC_CONN(I5,I4)
                           ELSE
                             IL5=MTC_CONN(I4,I5)
                           ENDIF
                           IF(IL5.EQ.1.AND.NA.GE.6) THEN
                             IF(I5.GT.I) THEN
                               IF(MTC_CONN(I5,I).EQ.0.OR. 
     *                         MTC_CONN(I5,I).GT.5) 
     *                         MTC_CONN(I5,I)=5 
                             ELSE
                               IF(MTC_CONN(I,I5).EQ.0.OR. 
     *                         MTC_CONN(I,I5).GT.5) 
     *                         MTC_CONN(I,I5)=5 
                             ENDIF
C --6
                             DO I6=1,NA
                               IF(I.EQ.I6.OR.I1.EQ.I6.OR.I2.EQ.I6.OR.
     *                         I3.EQ.I6.OR.I4.EQ.I6.OR.I5.EQ.I6) 
     *                         GO TO 206
                               IF(I6.GT.I5) THEN
                                 IL6=MTC_CONN(I6,I5)
                               ELSE
                                 IL6=MTC_CONN(I5,I6)
                               ENDIF
                               IF(IL6.EQ.1.AND.NA.GE.7) THEN
                                 IF(I6.GT.I) THEN
                                   IF(MTC_CONN(I6,I).EQ.0.OR. 
     *                             MTC_CONN(I6,I).GT.6) 
     *                             MTC_CONN(I6,I)=6 
                                 ELSE
                                   IF(MTC_CONN(I,I6).EQ.0.OR. 
     *                             MTC_CONN(I,I6).GT.6) 
     *                             MTC_CONN(I,I6)=6 
                                 ENDIF
C --7
                                 DO I7=1,NA
                                   IF(I.EQ.I7.OR.I1.EQ.I7.OR.I2.EQ.I7
     *                             .OR.I3.EQ.I7.OR.I4.EQ.I7.OR. 
     *                             I5.EQ.I7.OR.I6.EQ.I7) GO TO 207
                                   IF(I7.GT.I6) THEN
                                     IL7=MTC_CONN(I7,I6)
                                   ELSE
                                     IL7=MTC_CONN(I6,I7)
                                   ENDIF
                                   IF(IL7.EQ.1.AND.NA.GE.8) THEN
                                     IF(I7.GT.I) THEN
                                       IF(MTC_CONN(I7,I).EQ.0.OR. 
     *                                 MTC_CONN(I7,I).GT.7) 
     *                                 MTC_CONN(I7,I)=7 
                                     ELSE
                                       IF(MTC_CONN(I,I7).EQ.0.OR. 
     *                                 MTC_CONN(I,I7).GT.7) 
     *                                 MTC_CONN(I,I7)=7 
                                     ENDIF
C --8
                                     DO I8=1,NA
                                     IF(I.EQ.I8.OR.I1.EQ.I8.OR.I2.EQ.I8
     *                               .OR.I3.EQ.I8.OR.I4.EQ.I8.OR. 
     *                               I5.EQ.I8.OR.I6.EQ.I8.OR.I7.EQ.I8) 
     *                                 GO TO 208
                                       IF(I8.GT.I7) THEN
                                         IL8=MTC_CONN(I8,I7)
                                       ELSE
                                         IL8=MTC_CONN(I7,I8)
                                       ENDIF
                                       IF(IL8.EQ.1) THEN
                                         IF(I8.GT.I) THEN
                                           IF(MTC_CONN(I8,I).EQ.0.OR. 
     *                                     MTC_CONN(I8,I).GT.8) 
     *                                     MTC_CONN(I8,I)=8 
                                         ELSE
                                           IF(MTC_CONN(I,I8).EQ.0.OR. 
     *                                     MTC_CONN(I,I8).GT.8) 
     *                                     MTC_CONN(I,I8)=8 
                                         ENDIF


                                       ENDIF
 208                                   CONTINUE
                                     ENDDO
C --8
                                   ENDIF
 207                               CONTINUE
                                 ENDDO
C --7
                               ENDIF
 206                           CONTINUE
                             ENDDO
C --6
                           ENDIF
 205                       CONTINUE
                         ENDDO
C --5
                       ENDIF
 204                   CONTINUE
                     ENDDO
C --4
                   ENDIF
 203               CONTINUE
                 ENDDO
C --3
               ENDIF
 202           CONTINUE
             ENDDO
C --2
           ENDIF
 201       CONTINUE
         ENDDO
C --1    
       ENDDO


C ------------------
       RETURN
       END

      SUBROUTINE COMP_VECTOR
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ---------------------------------------------
      ND = ABS(MTC_NA2-MTC_NA1)
      IF(MTC_NA2.LT.5.AND.ND.GT.0) THEN
        ND = 1
      ELSE IF(MTC_NA2.LT.10.AND.ND.GT.1) THEN
        ND = 2
      ELSE IF(ND.GT.10) THEN
        ND = 10
      ENDIF

      DO I=1,MTC_NA1
        MTC_NEQUIV(I) = 0
      ENDDO

      DO I1=1,MTC_NA1

        DO I2=1,MTC_NA2
          IF(MTC_SYMB1(I1).EQ.MTC_SYMB2(I2)) THEN
            IDEL = 0
            DO I=1,ISYMBMAX
              DO J=1,LENLIM
                IDEL = IDEL + ABS(MTC_VEC1(I1,J,I)-MTC_VEC2(I2,J,I))
              ENDDO
            ENDDO
            IF(IDEL.LE.ND) THEN
              MTC_NEQUIV(I1)    = MTC_NEQUIV(I1)+1
              II                = MTC_NEQUIV(I1)
              MTC_IEQUIV(II,I1) = I2
              MTC_DELTA (II,I1) = IDEL
            ENDIF
          ENDIF
        ENDDO

      ENDDO 

C ---------
      RETURN
      END

      SUBROUTINE CHECK_EQUIV(MDOC,N_NEW,IFLAG,ISCORE,IERR)
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C --------------------
C     CHARACTER LINE*80
C --------------------
      IERR = 0
C ---
C
C     now MTC_SYMB1() - pointer to defined atoms in MTC_...1
C
      N_NEW_OLD = N_NEW
      IONE      = 0
      IDELTA    = 1000
      IFLAG     = 0
      NMIN      = 1000
      IMIN      = 0
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).EQ.0) THEN
          IF(MTC_NEQUIV(I).EQ.0) THEN
            IERR = 3
            RETURN
          ENDIF
          IF(MTC_NEQUIV(I).LT.NMIN) THEN
            NMIN = MTC_NEQUIV(I)
            IMIN = I
          ENDIF
          IF(MTC_NEQUIV(I).EQ.1) THEN
            IF(IONE.EQ.0) THEN
              IONE   = I
              IDELTA = MTC_DELTA(1,IONE)
            ELSE IF(MTC_DELTA(1,I).LT.IDELTA) THEN
              IONE   = I
              IDELTA = MTC_DELTA(1,IONE)
            ELSE IF(MTC_DELTA(1,I).EQ.IDELTA) THEN
              J = MTC_IEQUIV(1,I)
              IF(MTC_NAME1(I).EQ.MTC_NAME2(J)) THEN
                IONE   = I
                IDELTA = MTC_DELTA(1,IONE)
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      IF(IONE.GT.0) THEN
        MTC_NEW(IONE) = MTC_IEQUIV(1,IONE)
        ISCORE        = ISCORE + IDELTA

C        WRITE(LINE,'(I3,'' = '',I3,''( 1 )'',I3)') 
C     *  IONE,MTC_NEW(IONE),ISCORE
C        CALL MSGERR(MDOC,LINE)

        GO TO 100
      ENDIF
C ----------
      NE = MTC_NEQUIV(IMIN)
      NN = N_NEW
      IF(NN.GT.0) THEN
        ISUM_MIN = 100000
        IDELTA   = 1000
        JMIN     = 0
        DO I=1,NE
          IF(MTC_DELTA(I,IMIN).LE.IDELTA) THEN
            ISUM = 0
            II   = MTC_IEQUIV(I,IMIN)
            DO J=1,NN
              J1 = MTC_SYMB1(J)
              J2 = MTC_NEW(J1)
C -1-
              IF(IMIN.GT.J1) THEN
                IDIST1 = MTC_CONN(J1,IMIN)
              ELSE
                IDIST1 = MTC_CONN(IMIN,J1)
              ENDIF
C -2-
              IF(J2.GT.II) THEN
                IDIST2 = MTC_CONN(J2,II)
              ELSE
                IDIST2 = MTC_CONN(II,J2)
              ENDIF

              ISUM = ISUM + ABS(IDIST1-IDIST2)

            ENDDO

            IF(MTC_DELTA(I,IMIN).LT.IDELTA) THEN

              IA_MIN   = I
              IDELTA   = MTC_DELTA(I,IMIN)
              ISUM_MIN = ISUM

            ELSE IF(MTC_DELTA(I,IMIN).EQ.IDELTA) THEN

              IF(ISUM.LE.ISUM_MIN) THEN
                IF(ISUM.LT.ISUM_MIN) THEN
                  ISUM_MIN = ISUM
                  IA_MIN   = I                
                ELSE IF(MTC_NAME1(IMIN).EQ.MTC_NAME2(II)) THEN
                  ISUM_MIN = ISUM
                  IA_MIN   = I
                ENDIF
              ENDIF
             
            ENDIF

          ENDIF

        ENDDO

        IONE          = IMIN
        MTC_NEW(IONE) = MTC_IEQUIV(IA_MIN,IONE)
        ISCORE        = ISCORE + MTC_DELTA(IA_MIN,IMIN)

C        WRITE(LINE,'(I3,'' = '',I3,''('',I3,'' )'',I3)') 
C     *  IONE,MTC_NEW(IONE),IA_MIN,ISCORE
C        CALL MSGERR(MDOC,LINE)

      ELSE
        IA     = 0
        IDELTA = 1000
        DO I=1,NE
          II = MTC_IEQUIV(I,IMIN)
          IF(MTC_DELTA(I,IMIN).LT.IDELTA) THEN
            IDELTA = MTC_DELTA(I,IMIN)
            IA     = I
          ELSE IF(MTC_DELTA(I,IMIN).EQ.IDELTA) THEN
            IF(MTC_NAME1(IMIN).EQ.MTC_NAME2(II)) THEN
              IA     = I
              IDELTA = MTC_DELTA(I,IMIN)
            ENDIF
          ENDIF
        ENDDO

        IONE          = IMIN
        MTC_NEW(IMIN) = MTC_IEQUIV(IA,IMIN)
        ISCORE        = ISCORE + IDELTA

C        WRITE(LINE,'(I3,'' = '',I3,''('',I3,'' )'',I3)') 
C     *  IONE,MTC_NEW(IONE),IA,ISCORE
C        CALL MSGERR(MDOC,LINE)

      ENDIF
C ----------
 100  CONTINUE
      DO I=1,MTC_NA1-1
        DO J=I+1,MTC_NA1
          IF(MTC_NEW(I).NE.0.AND.MTC_NEW(I).EQ.MTC_NEW(J)) THEN
            IERR = 4
            RETURN
          ENDIF
        ENDDO
      ENDDO
      N_NEW = 0
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).EQ.0.AND.MTC_NEQUIV(I).GT.0) THEN
          JJ = 0
          NN = MTC_NEQUIV(I)
          DO J=1,NN
            IF(MTC_IEQUIV(J,I).NE.MTC_NEW(IONE)) THEN
              JJ = JJ+1
              MTC_IEQUIV(JJ,I) = MTC_IEQUIV(J,I)
              MTC_DELTA (JJ,I) = MTC_DELTA (J,I)
            ELSE
              MTC_NEQUIV(I) = MTC_NEQUIV(I)-1

C        WRITE(LINE,'(I3,'' REMOVE '',I3,'' now nequiv  '',I3)') 
C     *  I,MTC_NEW(IONE),MTC_NEQUIV(I)
C        CALL MSGERR(MDOC,LINE)

            ENDIF
          ENDDO
        ENDIF
        IF(MTC_NEW(I).GT.0) THEN
          N_NEW = N_NEW+1
          MTC_SYMB1(N_NEW) = I 
        ENDIF
      ENDDO
      IF(N_NEW.GT.N_NEW_OLD) IFLAG = 1
C --------------------
      RETURN
      END

      SUBROUTINE TEST_GM(MDOC,LIST,SRCH
     *              ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -------------------------------------
      INTEGER MEMORY
      PARAMETER (MEMORY  =  1 000 000)
C ----
      INTEGER*2 IPOOL(MEMORY)
C -------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 1600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       MATCH_POOL(IP+3) = ICONTENT(I) 
C       . . . . . 
C       MATCH_POOL(IP+17) = ICONTENT(I) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IB + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------
      CHARACTER LINE*256,MON*8,LIST*1,SRCH*1,MOD_R*1,MON_NEW*8
      CHARACTER MON_INP*8,NODIST*1
C ---------------------------------------------------------------
      M         = 99
      MON_INP   = L1L_MNAME
      CALL COPYL2(MDOC,IERR)

      L_BEST    = 0
      ILIB_BEST = 0
C     for complete matching  INDI_BEST = 0
C     INDI_BEST = 13
      INDI_BEST = 0
      INDP_BEST = 100000

      IF(SRCH.EQ.'G') GO TO 700

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC, '-----INDEX ---')
      ENDIF

      DO I=1,LMX_NMON 

        ND = ABS(NAC - LMX_NATOM(I))

C        IF(NAC.EQ.LMX_NATOM(I).OR.(NAC.GT.9.AND.ND.LE.2)) THEN
        IF(ND.LE.0) THEN

          CALL CALC_INDEX_DIFF(M,C_CONTENT,C_INDEX,C_PAIR
     *     ,LMX_CONTENT(I),LMX_INDEX(I),LMX_PAIR(I)
     *     ,IDIFFC,IDIFFI,IDIFFP,IERR)


          IF(IDIFFC.EQ.0) THEN

            IF(IDIFFI.EQ.0.AND.IDIFFP.EQ.0) THEN

C            IF((INDI_BEST.GT.IDIFFI).OR.
C     *         (INDI_BEST.EQ.IDIFFI.AND.
C     *          INDP_BEST.GT.IDIFFP     )) THEN

              IF(LIST.EQ.'T') THEN
            write(line,'(''-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *        LMX_NATOM(I),LMX_MNAME(I),LMX_CONTENT(I),LMX_INDEX(I)
              CALL MSGDOC(MDOC,LINE)
              write(line,'(''          :'',A24,'';'',3I4)')
     *        LMX_PAIR(I),IDIFFC,IDIFFI,IDIFFP
              CALL MSGDOC(MDOC,LINE)
              ENDIF

              DO L=1,LML_NMON
                IF(LMX_MNAME(I).EQ.LML_MNAME(L)) THEN
                  GO TO 400
                ENDIF     
              ENDDO

              GO TO 300

 400          CONTINUE

              L_BEST    = I
              ILIB_BEST = L
              INDI_BEST = IDIFFI
              INDP_BEST = IDIFFP
              GO TO 200

            ENDIF
          ENDIF
        ENDIF

 300    CONTINUE

      ENDDO

 200  CONTINUE

      IF(L_BEST.GT.0) THEN

        I       = L_BEST
        L       = ILIB_BEST
        MON_NEW = LMX_MNAME(I) 
        LINE = ' WARNING : monomer looks like '//LMX_MNAME(I)
     *        //'program will use this one' 
        CALL MSGDOC(MDOC,LINE)
C        IF(LML_FUSE(L).EQ.'N') THEN
C         read mon_lib.cif
C          LML_FUSE(L) = 'R'
C          MOD_R       = 'M'
C          CALL READ_LIB(M,MOD_R,LIST,IERR)
C          IF(IERR.NE.0) RETURN
C        ENDIF
C        CALL CP_MLIB(MDOC,MON_NEW,IERR)
C        IF(IERR.NE.0) RETURN
C
C        L1L_MNAME  = MON_INP
C        L1L_MNAME2 = MON_INP
C        L1L_NAME   = '.'

        DO IM=1,MATCH_NMON
          IP   = MATCH_POINTER(IM)
          IMON = MATCH_POOL(IP  )
          MON  = LML_MNAME(IMON)
          IF(MON.EQ.MON_NEW) THEN
            IMS = IM
            IMF = IM
            GO TO 500
          ENDIF
        ENDDO
      ELSE
        IERR = 1
      ENDIF
C ------------------------------------------

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '--after index srch',srch,ierr
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(SRCH.NE.'A') RETURN

      IERR = 0

 700  CONTINUE

      IMS = 1
      IMF = MATCH_NMON
 500  CONTINUE
C ---
      IDIRECT = 0

      IPT   = MATCH_POINTER(MATCH_NMON+1)
      IMONT = MATCH_POOL(IPT  )
      N     = MATCH_POOL(IPT+1)
      NE    = MATCH_POOL(IPT+2)

      I_MU  = 1
      I_IE  = I_MU  + N
 
      IPA = IPT + 17
      J   = 0
      DO IA=1,N
        J = J + 2
        IPOOL(I_MU -1 + IA) = MATCH_POOL(IPA+J) 
      ENDDO

      IPB = IPT + 17 + 2*N
      J   = 0
      DO IB=1,NE
        J = J + 1
        IPOOL(I_IE -1 + J) = MATCH_POOL(IPB+J) 
        J = J + 1
        IPOOL(I_IE -1 + J) = MATCH_POOL(IPB+J) 
        J = J + 1
        IPOOL(I_IE -1 + J) = 1 
      ENDDO

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '----- N MATCH ---:',N,MATCH_NMON
        CALL MSGDOC(MDOC,LINE)
        write(LINE,*) '--:',ipt,imont,n,ne 
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      DO IM=IMS,IMF

        IP  = MATCH_POINTER(IM)

        IMON = MATCH_POOL(IP  )
        MON  = LML_MNAME(IMON)
        M    = MATCH_POOL(IP+1)
        NEI  = MATCH_POOL(IP+2)  

        

        IF(M.GE.N.AND.MON.NE.MON_INP) THEN
C ---
          IPT_C = IPT + 2
          IP_C  = IP  + 2
          DO IC=1,15
            IF(MATCH_POOL(IPT_C+IC).GT.MATCH_POOL(IP_C+IC)) GO TO 100
          ENDDO
C --- 
          MEM = 2*N + M + 3*NE + 3*NEI + N*(N+1)*M
          IF(MEM.GT.MEMORY) THEN
            IF(LIST.EQ.'T') THEN
              WRITE(LINE,*) '--- Insufficient memory :',MON,IM
              CALL MSGDOC(MDOC,LINE)
            ENDIF
            GO TO 100
          ENDIF 

          I_MUI = I_IE  + NE*3
          I_IEI = I_MUI + M
          I_ISO = I_IEI + NEI*3
          I_IP  = I_ISO + N
C ---
          IPA = IP + 17
          J   = 0
          DO IA=1,M
            J = J + 2
            IPOOL(I_MUI -1 + IA) = MATCH_POOL(IPA+J) 
          ENDDO

          IPB = IP + 17 + 2*M
          J   = 0
          DO IB=1,NEI
            J = J + 1
            IPOOL(I_IEI -1 + J) = MATCH_POOL(IPB+J) 
            J = J + 1
            IPOOL(I_IEI -1 + J) = MATCH_POOL(IPB+J) 
            J = J + 1
            IPOOL(I_IEI -1 + J) = 1 
          ENDDO
C --- 
          CALL GM_ULLMAN(N,NE,M,NEI,IDIRECT
     *     ,IPOOL(I_MU),IPOOL(I_MUI),IPOOL(I_IE),IPOOL(I_IEI)
     *     ,I,IPOOL(I_ISO),IPOOL(I_IP))
C ---
          IF(I.GT.N) THEN

            IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '=========',IM,' ==== ',MON,' ====='
            CALL MSGDOC(MDOC,LINE)
            DO J=1,N
              WRITE(LINE,*) J,' I_mu --> I_mui',IPOOL(I_ISO + J - 1) 
              CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            LINE = ' INFO: sub_structure in :'//MON
            CALL MSGDOC(MDOC,LINE)
            GO TO 600
          ENDIF

        ENDIF
 100    CONTINUE
      ENDDO
      CALL MSGDOC(MDOC,' INFO:  no sub_structure was found' )
      IERR = 1
      RETURN
C -------------------------------------
 600  CONTINUE
      CALL COPYL2(MDOC,IERR)
      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 610
        ENDIF     
      ENDDO
      IERR = 1
      RETURN
 610  CONTINUE

      IF(LML_FUSE(L).EQ.'N') THEN
C       read mon_lib.cif
        LML_FUSE(L) = 'R'
        MOD_R       = 'M'
        NODIST      = 'N'
        CALL READ_LIB(M,MOD_R,NODIST,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      CALL CP_MLIB(MDOC,MON,IERR)
      IF(IERR.NE.0) RETURN

      L1L_MNAME  = MON_INP
      L1L_MNAME2 = MON_INP
      L1L_NAME   = '.'
      IF(M.NE.N) THEN
        L1L_TYPE  = 'non-polymer'
      ENDIF
C ---
C     atom's number
      IPT   = MATCH_POINTER(MATCH_NMON+1)
      IPA = IPT + 17
      J   = -1
      DO IA=1,N
        J = J + 2
        IPOOL(I_IE -1 + IA) = MATCH_POOL(IPA+J) 
      ENDDO
C ---
C     atom's number
      IP  = MATCH_POINTER(IM)
      IPA = IP + 17
      J   = -1
      DO IA=1,M
        J = J + 2
        IPOOL(I_IEI -1 + IA) = MATCH_POOL(IPA+J) 
      ENDDO
C ---

      CALL CORR_DESCRIPTION_GM(MDOC,LIST,N,M
     *,IPOOL(I_MU),IPOOL(I_IE),IPOOL(I_MUI),IPOOL(I_IEI),IPOOL(I_ISO)
     *,IERR)                       
C       NU             NP        MU           MP          ISO
C ---
C     atom_names L2 -> L1, remove other atoms.
C -- 
C     atom's number: 
c     IPOOL(I_IE) IPOOL(I_IEI)
C       NP           MP
C
c     IPOOL(I_MU) IPOOL(I_MUI) ,IPOOL(I_ISO)
c       NU           MU           ISO
c       N            M
c      ISO - isomorphism  /  NU(i) = MU(ISO(i)) /
C      NP(I) ->L2   MP(I) ->L1      
C ---  
C -------------------------------------
      RETURN
      END

      SUBROUTINE GM_ULLMAN(N,NE,M,NEI,IDIRECT
     *                    ,MU,MUI,IE,IEI,I,ISO,IP)
C -------------------------------------
C      SUBROUTINE GM_ULLMAN(N,NE,M,NEI,IDIRECT
C     *                    ,MU,MUI,IE,IEI,I,ISO,IP)
C ----------
C   Graph_matching_Ullmann_algorithm   
C ----------
C                    n           m        n =< m
C list of atoms     MU          MUI (*) labels
C N of bonds        NE          NEI
C list of bonds     IE          IEI (3,*) I1,I2,label
C
C output: OK if I > n else not found isomorphous graph.
C         ISO - isomorphism  /  MU(i) = MUI(ISO(i)) /
C
C -------------------------------------
      INTEGER*2 MU(*),MUI(*),IE(3,*),IEI(3,*),ISO(*),IP(N,M,*)
C -------------------------------------
c      write(*,*) '-----N:',n
c      DO K=1,N
c        write(*,*) k,mu(k)
c      enddo
c      write(*,*) '-----M:',m
c      DO K=1,M
c        write(*,*) k,mui(k)
c      enddo
c      write(*,*) '-----'


      DO K=1,N
      DO L=1,M
        IF(MU(K).EQ.MUI(L)) THEN
          IP(K,L,1) = 1
        ELSE
          IP(K,L,1) = 0
        ENDIF
      ENDDO
      ENDDO
      I = 1
      J = 1
C ---------
 100  CONTINUE
      IF(I.GT.N) RETURN

      IF(IP(I,J,I).NE.0) THEN

        ISO(I) = J

        DO K=1,N
        DO L=1,M
          IP(K,L,I+1) = IP(K,L,I)
          IF(K.GT.I.AND.L.EQ.J) IP(K,L,I+1) = 0
        ENDDO
        ENDDO

        CALL FORWARD_CHECK_GM(I,N,NE,M,NEI,IDIRECT
     *                            ,IE,IEI,ISO,IP,IFLAG)

        IF(IFLAG.EQ.0) THEN
          I = I + 1
          J = 1
        ELSE
          J = ISO(I)
          J = J + 1
       ENDIF

      ELSE
        J = J + 1
      ENDIF
      IF(J.GT.M) THEN
        IF(I.LE.1) RETURN        
        I = I -1
        J = ISO(I)
        J = J + 1
      ENDIF    
      GO TO 100
C -------------------------------------
      END

      SUBROUTINE FORWARD_CHECK_GM(I,N,NE,M,NEI,IDIRECT
     *                            ,IE,IEI,ISO,IP,IFLAG)
C -------------------------------------
      INTEGER*2 IE(3,*),IEI(3,*),ISO(*),IP(N,M,*)
C -------------------------------------
      DO K=I+1,N
      DO L=1,M

        IF(IP(K,L,I+1).GT.0) THEN

          DO IS=1,I
            IWS = ISO(IS)
C       ---
          IFLAG1 = 0
          DO KE=1,NE
            IF((IE(1,KE).EQ.K.AND.IE(2,KE).EQ.IS).OR.
     *         (IDIRECT.EQ.0.AND.
     *          IE(2,KE).EQ.K.AND.IE(1,KE).EQ.IS))THEN

              IFLAG1 =-1
                
              DO JE=1,NEI

                IF((IEI(1,JE).EQ.L.AND.IEI(2,JE).EQ.IWS).OR.
     *             (IDIRECT.EQ.0.AND.
     *              IEI(2,JE).EQ.L.AND.IEI(1,JE).EQ.IWS)) THEN
                  IF(IE(3,KE).EQ.IEI(3,JE)) THEN
                    IFLAG1 = 1
                    GO TO 100
                  ENDIF
                ENDIF
              ENDDO 
            ENDIF
          ENDDO

 100      CONTINUE

C       ---
          IFLAG2 = 0
          DO JE=1,NEI
            IF((IEI(1,JE).EQ.L.AND.IEI(2,JE).EQ.IWS).OR.
     *         (IDIRECT.EQ.0.AND.
     *          IEI(2,JE).EQ.L.AND.IEI(1,JE).EQ.IWS)) THEN

              IFLAG2 =-1

              DO KE=1,NE

                IF((IE(1,KE).EQ.K.AND.IE(2,KE).EQ.IS).OR.
     *             (IDIRECT.EQ.0.AND.
     *              IE(2,KE).EQ.K.AND.IE(1,KE).EQ.IS)) THEN
                  IF(IE(3,KE).EQ.IEI(3,JE)) THEN
                    IFLAG2 = 1
                    GO TO 200
                  ENDIF
                ENDIF
              ENDDO 
            ENDIF
          ENDDO

 200      CONTINUE

          ENDDO

          IF(IFLAG1.EQ.1.AND.IFLAG2.EQ.1) THEN
            IP(K,L,I+1) = 1
          ELSE IF(IFLAG1.EQ.-1.OR.IFLAG2.EQ.-1) THEN
            IP(K,L,I+1) = 0
          ENDIF
C       ---
 300      CONTINUE          
        ENDIF

      ENDDO
      ENDDO
C ----      
      IFLAG = 0
      DO K=1,N
        DO L=1,M
          IF(IP(K,L,I+1).GT.0) GO TO 400
        ENDDO
        IFLAG = 1
        RETURN
 400    CONTINUE
      ENDDO
C ----
      RETURN
C -------------------------------------
      END

      SUBROUTINE CORR_DESCRIPTION_GM(MDOC,LIST,N,M,NU,NP,MU,MP,ISO,IERR)
C --------------------------------------------------------
C     atom_names L2 -> L1, remove other atoms.
C -- 
C     atom's number: 
c     IPOOL(I_IE) IPOOL(I_IEI)
C       NP           MP
C
c     IPOOL(I_MU) IPOOL(I_MUI) ,IPOOL(I_ISO)
c       NU           MU           ISO
c       N            M
c      ISO - isomorphism  /  NU(i) = MU(ISO(i)) /
C      NP(I) ->L2   MP(I) ->L1      
C ---  
C     I --> IP = NP(I)   ISO(I) --> J --> JP --> MP(J)
C           !                             ! 
C           V                             V
C          L2A_                          L1A_
C ---------------------------------------------------------
      INTEGER   MDOC,N,M,IERR
      INTEGER*2 NU(*),NP(*),MU(*),MP(*),ISO(*)
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,LIST*1,SYMB*4,ATOM*4,ATOM_NEW*4,TREE*1
C ---
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ---------------------------------------------------------------
      M = 99
C ----
      DO I=1,L1A_NATOM
        L1A_ICR(I) = 0   
      ENDDO
      DO I=1,L2A_NATOM
        L2A_ICR(I) = 0   
      ENDDO
      CALL SET_NUM_L1_GM(MDOC,IERR)
      CALL SET_NUM_L2_GM(MDOC,IERR)
C ----
      DO JP=1,L1A_NATOM
        DO J=1,M
          IF(JP.EQ.MP(J)) THEN
            DO I=1,N
              IF(ISO(I).EQ.J) THEN
                L1A_ICR(JP)    = NP(I)
                L2A_ICR(NP(I)) = JP
                GO TO 100
              ENDIF 
            ENDDO
          ENDIF
        ENDDO
 100    CONTINUE
      ENDDO
C ----

      IF(LIST.EQ.'T') THEN
        line = ' --- l1 --  CORR_DESCRIPTION_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          write(line,
     *    '(i2,1x,a,1x,i4)')
     *     ia,l1a_aname(ia),L1A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        DO    I=1,L1B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l1b_1atm(i),L1b_2atm(I),l1b_i1atm(i),L1b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        IF(L1G_NANGL.GT.0) THEN
        DO    I=1,L1G_NANGL
          write(line,'(i2,1x,a,1x,a,1x,A,1X,3i4)')
     *     i,l1G_1atm(i),L1G_2atm(I),L1G_3atm(I)
     *     ,l1G_i1atm(i),L1G_i2atm(I),L1G_i3atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

        line = ' --- l2 --  CORR_DESCRIPTION_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L2A_ISTART,L2A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L2A_NATOM
          write(line,'(i2,1x,a,1x,i4)')ia,l2a_aname(ia),L2A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        DO    I=1,L2B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l2b_1atm(i),L2b_2atm(I),l2b_i1atm(i),L2b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        line = ' --- iso-- CORR_DESCRIPTION_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) '  N,M:',n,m
        CALL MSGDOC(MDOC,LINE)

        DO    I=1,N
          write(line, '(2i4,1x,a,1x,2i4)')
     *     i,np(I),' -->',iso(i),mp(iso(i))
          CALL MSGDOC(MDOC,LINE)
        ENDDO

      ENDIF

C ----
      DO I=1,L1A_NATOM
        SYMB = L1A_SYMB(I)
        IF((SYMB(1:2).EQ.'H '.OR.SYMB(1:2).EQ.'D ').AND.
     *                                    L1B_NBOND.GT.0) THEN
          DO IB=1,L1B_NBOND
            IF((L1B_I1ATM(IB).EQ.I.AND.L1A_ICR(L1B_I2ATM(IB)).GT.0).OR.
     *         (L1B_I2ATM(IB).EQ.I.AND.L1A_ICR(L1B_I1ATM(IB)).GT.0))THEN
C --
              IF(L1B_I1ATM(IB).EQ.I) JP = L1B_I2ATM(IB)
              IF(L1B_I2ATM(IB).EQ.I) JP = L1B_I1ATM(IB)
              IP = L1A_ICR(JP) 

              IF(L2B_NBOND.GT.0) THEN
              DO K=1,L2B_NBOND
                KA = 0
                IF(L2B_I1ATM(K).EQ.IP) KA = L2B_I2ATM(K)
                IF(L2B_I2ATM(K).EQ.IP) KA = L2B_I1ATM(K)
                IF(KA.GT.0) THEN
                  SYMB = L2A_SYMB(KA)
                  IF((SYMB(1:2).EQ.'H '.OR.SYMB(1:2).EQ.'D ').AND.
     *                                            L2A_ICR(KA).EQ.0) THEN
                    L2A_ICR(KA) = I
                    L1A_ICR(I)  = KA
                    GO TO 200
                  ENDIF
                ENDIF
              ENDDO
              ENDIF
C --          
              L1A_ICR(I) = -1            
              GO TO 200
            ENDIF
          ENDDO
        ENDIF
 200    CONTINUE
      ENDDO
C ----
      DO IA=1,L1A_NATOM
        IF(L1A_ICR(IA).GE.0) THEN
          ATOM     = L1A_ANAME(IA) 
          ATOM_NEW = '????'
          IF(L1A_ICR(IA).GT.0) ATOM_NEW = L2A_ANAME(L1A_ICR(IA))
C ---
          DO JA=1,L1A_NATOM
            IF(L1A_IBACK(JA).EQ.IA) L1A_BACK(JA) = ATOM_NEW 
            IF(L1A_IFORW(JA).EQ.IA) L1A_FORW(JA) = ATOM_NEW 
          ENDDO
          IF(L1N_NCONN.GT.0) THEN
            DO I=1,L1N_NCONN
              IF(L1N_I1ATM(I).EQ.IA) L1N_1ATM(I) = ATOM_NEW
              IF(L1N_I2ATM(I).EQ.IA) L1N_2ATM(I) = ATOM_NEW
            ENDDO
          ENDIF

          IF(L1B_NBOND.GT.0) THEN 
            DO I=1,L1B_NBOND
              IF(L1B_I1ATM(I).EQ.IA) L1B_1ATM(I) = ATOM_NEW 
              IF(L1B_I2ATM(I).EQ.IA) L1B_2ATM(I) = ATOM_NEW  
            ENDDO
          ENDIF
          IF(L1G_NANGL.GT.0) THEN
            DO I=1,L1G_NANGL
              IF(L1G_I1ATM(I).EQ.IA) L1G_1ATM(I) = ATOM_NEW
              IF(L1G_I2ATM(I).EQ.IA) L1G_2ATM(I) = ATOM_NEW
              IF(L1G_I3ATM(I).EQ.IA) L1G_3ATM(I) = ATOM_NEW
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN 
            DO I=1,L1T_NTORS 
              IF(L1T_I1ATM(I).EQ.IA) L1T_1ATM(I) = ATOM_NEW 
              IF(L1T_I2ATM(I).EQ.IA) L1T_2ATM(I) = ATOM_NEW 
              IF(L1T_I3ATM(I).EQ.IA) L1T_3ATM(I) = ATOM_NEW 
              IF(L1T_I4ATM(I).EQ.IA) L1T_4ATM(I) = ATOM_NEW 
            ENDDO
          ENDIF
          IF(L1C_NCHIR.GT.0) THEN 
            DO I=1,L1C_NCHIR 
              IF(L1C_I1ATM(I).EQ.IA) L1C_1ATM(I) = ATOM_NEW 
              IF(L1C_I2ATM(I).EQ.IA) L1C_2ATM(I) = ATOM_NEW 
              IF(L1C_I3ATM(I).EQ.IA) L1C_3ATM(I) = ATOM_NEW 
              IF(L1C_I4ATM(I).EQ.IA) L1C_4ATM(I) = ATOM_NEW 
              IF(L1C_I5ATM(I).EQ.IA) L1C_5ATM(I) = ATOM_NEW 
              IF(L1C_I6ATM(I).EQ.IA) L1C_6ATM(I) = ATOM_NEW 
              IF(L1C_I7ATM(I).EQ.IA) L1C_7ATM(I) = ATOM_NEW 
              IF(L1C_I8ATM(I).EQ.IA) L1C_8ATM(I) = ATOM_NEW 
              IF(L1C_I9ATM(I).EQ.IA) L1C_9ATM(I) = ATOM_NEW 
           ENDDO
          ENDIF
          IF(L1P_NPLAN.GT.0) THEN
            DO I=1,L1P_NPLAN 
              IF(L1P_NATOM(I).GT.0) THEN
                DO J=1,L1P_NATOM(I)
                  IF(L1P_IATOM(J,I).EQ.IA) THEN
                    ICH4 = L1P_ATOM(J,I)
                    CH4 = ATOM_NEW 
                    L1P_ATOM(J,I) = ICH4
                    IF(CH4.EQ.'????') L1P_IATOM(J,I) = 0
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF          
C --- 
          L1A_ANAME(IA) = ATOM_NEW
        ENDIF
      ENDDO


      IF(LIST.EQ.'T') THEN
        line = ' --- l1 --  before compress_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          write(line,'(i2,1x,a,1x,i4)')
     *     ia,l1a_aname(ia),L1A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        DO    I=1,L1B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l1b_1atm(i),L1b_2atm(I),l1b_i1atm(i),L1b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        IF(L1G_NANGL.GT.0) THEN
        DO    I=1,L1G_NANGL
          write(line,'(i2,1x,a,1x,a,1x,A,1X,3i4)')
     *     i,l1G_1atm(i),L1G_2atm(I),L1G_3atm(I)
     *     ,l1G_i1atm(i),L1G_i2atm(I),L1G_i3atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

        line = ' --- l2 -- before compress_ _GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L2A_ISTART,L2A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L2A_NATOM
          write(line,'(i2,1x,a,1x,i4)')
     *     ia,l2a_aname(ia),L2A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        DO    I=1,L2B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l2b_1atm(i),L2b_2atm(I),l2b_i1atm(i),L2b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO


      ENDIF

C ----
C     compress L1
      CALL COMPRESS_L1_GM(MDOC,IERR)


      IF(LIST.EQ.'T') THEN
        line = ' --- l1 --  after compress_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          write(line,'(i2,1x,a,1x,i4)')
     *     ia,l1a_aname(ia),L1A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        DO    I=1,L1B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l1b_1atm(i),L1b_2atm(I),l1b_i1atm(i),L1b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        IF(L1G_NANGL.GT.0) THEN
        DO    I=1,L1G_NANGL
          write(line,'(i2,1x,a,1x,a,1x,A,1X,3i4)')
     *     i,l1G_1atm(i),L1G_2atm(I),L1G_3atm(I)
     *     ,l1G_i1atm(i),L1G_i2atm(I),L1G_i3atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF


      ENDIF
      IF(N.NE.M) THEN
        DO JA=1,L1A_NATOM
          L1A_BACK(JA) = '.' 
          L1A_FORW(JA) = '.' 
        ENDDO
      ENDIF
C ----
C     check tree
      L = 0
      CALL CHECK_RLIB_TREE(MDOC,LIST,L,IERR)                 
C ---
C     L =< 0 from L1 (not cp_mlib) ; l = 0 cpl_mlib with  L1L_FUSE = 'C'
C ------
      RETURN
      END

      SUBROUTINE LIB_CREATE_TEST_INDEX2(MDOC,IMON
     *            ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 1600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       MATCH_POOL(IP+3) = ICONTENT(I) 
C       . . . . . 
C       MATCH_POOL(IP+17) = ICONTENT(I) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IB + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
      INTEGER  MDOC,IERR,MEM_TOT,IMON,NMON
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER SYMB*4,MON*8,LINE*256
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------

      INTEGER   ICONTENT(15)
      CHARACTER ATM_SYMB(15)*2
      DATA  ATM_SYMB
     */'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN'
     *,'MO','  '/
C       1    2    3    4    5    6    7    8    9    10   11   12   13
C       14   15
C ---------------------------------------------------------------------
      IERR   = 0
c      IF(NMON.GE.MAXMPONTER) THEN
c        WRITE(LINE,
c     *'('' ERROR: in LIB_CREATE_TEST_INDEX2: numbe of monomers >'',I8)')
c     *  MAXMPONTER
c        CALL MSGERR(MDOC,LINE)         
c        IERR = 1
c        RETURN
c      ENDIF    
C -----
      CALL COPYL2(MDOC,IERR)
      IF(IMON.GT.0) THEN
        MON = LML_MNAME(IMON)
      ELSE
        MON = L1L_MNAME
      ENDIF
C -----
      CALL CALC_INDEX(MDOC,MON,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -----
      NA     = L2A_NATOM
      IF(NA.LE.1) THEN
        RETURN
      ENDIF
      DO I=1,15
        ICONTENT(I) = 0
      ENDDO
C --------------------
      NATOM  = 0

      DO IA=1,NA
        L2A_ICR(IA) = 0 
        IF(L2A_ANAME(IA).NE.'    ') THEN
          SYMB = L2A_SYMB(IA)
          IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
            DO K=1,15
              IF(SYMB(1:2).EQ.ATM_SYMB(K)) THEN
                GO TO 100
              ENDIF             
            ENDDO
            K = 15
 100        CONTINUE
            NATOM       = NATOM + 1
            ICONTENT(K) = ICONTENT(K) + 1
            L2A_ICR(IA) = NATOM
            L2A_CONN(1,NATOM) = IA
            L2A_CONN(2,NATOM) = K
          ENDIF
        ENDIF
      ENDDO  
      IF(NATOM.LE.4)     RETURN
      IF(L2B_NBOND.LE.3) RETURN
C -------------------- 
      NBOND = 0     
      DO IA=1,NA-1
        IF(L2A_ICR(IA).GT.0) THEN 
          DO JA=IA+1,NA
            IF(L2A_ICR(JA).GT.0) THEN 
              DO IB=1,L2B_NBOND
                IF(L2B_1ATM(IB).EQ.L2A_ANAME(IA).AND.
     *             L2B_2ATM(IB).EQ.L2A_ANAME(JA)) THEN
                  NBOND = NBOND + 1
                  L2N_I1ATM (NBOND) = L2A_ICR(IA)
                  L2N_I2ATM (NBOND) = L2A_ICR(JA)
                  L2N_TYPE  (NBOND) = L2B_TYPE(IB)
                  GO TO 200
                ELSE IF(L2B_2ATM(IB).EQ.L2A_ANAME(IA).AND.
     *                  L2B_1ATM(IB).EQ.L2A_ANAME(JA)) THEN
                  NBOND = NBOND + 1
                  L2N_I1ATM (NBOND) = L2A_ICR(JA)
                  L2N_I2ATM (NBOND) = L2A_ICR(IA)
                  L2N_TYPE  (NBOND) = L2B_TYPE(IB)
                  GO TO 200
                ENDIF
              ENDDO

 200          CONTINUE
            ENDIF
          ENDDO
        ENDIF
      ENDDO
C --------------------
      IF(NATOM.LE.4) RETURN
      IF(NBOND.LE.3) RETURN      
C ----------------------------------------
      MEM  = MEM_TOT
      NMON = MATCH_NMON
      IT = MEM + 18 +NATOM*2 + NBOND*3
      IF(IT.GT.MAXMPOOL) THEN
        WRITE(LINE,
     *  '('' ERROR: in LIB_CREATE_INDEX2: Insufficient memory:'')')
        CALL MSGERR(MDOC,LINE)         
        IERR = 1
        RETURN
      ENDIF    

      NMON1    = NMON + 1

      MEM = MEM + 1
      MATCH_POINTER(NMON1) = MEM
c     MATCH_NMON           = NMON

c     write(*,*) '--ind2:',nmon1,mem,imon,natom,nbond 

      MATCH_POOL(MEM) = IMON 
      MEM = MEM + 1
      MATCH_POOL(MEM) = NATOM  
      MEM = MEM + 1
      MATCH_POOL(MEM) = NBOND

      DO I=1,15
        MEM = MEM + 1 
        MATCH_POOL(MEM) = ICONTENT(I) 
      ENDDO

      DO IA=1,NATOM

        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2A_CONN(1,IA) 

        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2A_CONN(2,IA) 

      ENDDO

      DO IB=1,NBOND

        IT = 0

C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova

        IF(L2N_TYPE(IB)(1:4).EQ.'sing') THEN
          IT = 1
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'doub') THEN
          IT = 2
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'trip') THEN
          IT = 3
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'arom') THEN
          IT = 4
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'delo') THEN
          IT = 5
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'meta') THEN
          IT = 6
        ELSE IF((L2N_TYPE(IB)(1:4).EQ.'cova').OR.
     *          (L2N_TYPE(IB)(1:1).EQ.'.'   )    )THEN
          IT = 7
        ENDIF

        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2N_I1ATM(IB) 
        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2N_I2ATM(IB) 
        MEM = MEM + 1 
        MATCH_POOL(MEM) = IT 

      ENDDO

C ---------------------
      RETURN
      END

      SUBROUTINE CALC_INDEX(MDOC,MON,N,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ------------------------------------------
      CHARACTER LINE*256
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C --------------------------------
      IERR = 0
      M    =-ABS(MDOC)-1
C ------------------------------------------
      MODE = 'LIB '
      LIST = ' '
      ISYN = 0
      CALL CHECK_COMPL(MDOC,LIST,MODE,ISYN,MON,IERR)

      C_CONTENT = MTC_C_CONTENT
      C_INDEX   = MTC_C_INDEX
      C_PAIR    = MTC_C_PAIR
      N         = MTC_NA2
      RETURN
      END

      SUBROUTINE COOR_CONN(MDOC,MODE,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL      DLIM(4)
      CHARACTER CIATOM*1,CJATOM*1,LINE*256,MON*8
      CHARACTER FLAG*1
C     INTEGER*4 IJA(3),ICH4
C     CHARACTER CH2*2,CH4*4,ASYMB*4,CTYPE*4,MOD*1
C     EQUIVALENCE (ICH4,CH4)
      DATA DLIM/ 1.2, 1.9, 2.5, 2.85 /
C --------------------------------
C     M = -ABS(MDOC)-1

      NA     = L1A_NATOM
      MON    = L1L_MNAME        

      IF(NA.LE.1) THEN
        RETURN
      ENDIF

      DO    IA=1,NA-1
      IF(L1A_ANAME(IA).NE.'    ') THEN
        CIATOM = L1A_ATYPE(IA)
        XI     = L1A_X(IA)
        YI     = L1A_Y(IA)
        ZI     = L1A_Z(IA)
        DO    JA=IA+1,NA
        IF(L1A_ANAME(JA).NE.'    ') THEN
          CJATOM = L1A_ATYPE(JA)
          XJ     = L1A_X(JA)
          YJ     = L1A_Y(JA)
          ZJ     = L1A_Z(JA)
          IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
            IC=1 
          ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
            IC=2
          ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
            IC=4
          ELSE 
            IC=3
          ENDIF
 
          IF(IC.GT.0) THEN
            
            DIST = 0.0
            IF(L1A_COOR_FLAG(IA).EQ.'Y'.AND.
     *         L1A_COOR_FLAG(JA).EQ.'Y'     ) THEN
              DX   = XI-XJ
              DY   = YI-YJ
              DZ   = ZI-ZJ
              DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
            ENDIF 

            FLAG = 'N'
            IF(MODE.EQ.'CONN') THEN
              IF(L1N_NCONN.GT.0) THEN
                DO ICN=1,L1N_NCONN
                  IF((L1N_I1ATM(ICN).EQ.IA.AND.
     *                L1N_I2ATM(ICN).EQ.JA     ).OR.
     *               (L1N_I1ATM(ICN).EQ.JA.AND.
     *                L1N_I2ATM(ICN).EQ.IA     )) THEN
                    FLAG = 'Y'
                    GO TO 500
                  ENDIF
                ENDDO
              ENDIF
 500          CONTINUE
            ENDIF

            IF((DIST.LE.DLIM(IC).AND.DIST.GT.0.001)
     *                              .OR.FLAG.EQ.'Y') THEN
              IF(L1B_NBOND.GE.MAX1BND) THEN
                WRITE(LINE,'(3A,I6)')
     *          ' ERROR: number of bonds of new monomer '
     *          ,L1L_MNAME,' >',MAX1BND 
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *  '          Change parameter MAX1BND in "lib_com.fh"')
                IERR=1
                RETURN
              ENDIF 
              IF(L1A_NDIST(IA).LT.MAX1BRN) THEN
                L1A_NDIST(IA)              = L1A_NDIST(IA) + 1
                L1A_CONN(L1A_NDIST(IA),IA) = JA
                IF(L1A_ATYPE(JA).EQ.'H') THEN
                  L1A_LENCON(1,IA) = L1A_LENCON(1,IA) + 1
                ENDIF
              ENDIF
              IF(L1A_NDIST(JA).LT.MAX1BRN) THEN
                L1A_NDIST(JA)              = L1A_NDIST(JA) + 1
                L1A_CONN(L1A_NDIST(JA),JA) = IA
                IF(L1A_ATYPE(IA).EQ.'H') THEN
                  L1A_LENCON(1,JA) = L1A_LENCON(1,JA) + 1
                ENDIF
              ENDIF
              L1B_NBOND             = L1B_NBOND+1
              L1B_I1ATM (L1B_NBOND) = IA
              L1B_1ATM  (L1B_NBOND) = L1A_ANAME(IA)
              L1B_I2ATM (L1B_NBOND) = JA
              L1B_2ATM  (L1B_NBOND) = L1A_ANAME(JA)
              L1B_VOBS  (L1B_NBOND) = DIST
              L1B_TYPE  (L1B_NBOND) = '.'
            ENDIF
          ENDIF
        ENDIF
        ENDDO
      ENDIF
      ENDDO
c
c---Remove potentially wron hydrogen connections

      RETURN
      END

      SUBROUTINE CRD_CONN(MDOC,MODE,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL      DLIM(4)
C     CHARACTER LINE*256
      CHARACTER CIATOM*1,CJATOM*1,MON*8
      CHARACTER ASYMB*4,CTYPE*4
C     INTEGER*4 IJA(3),ICH4
C     CHARACTER CH2*2,CH4*4,FLAG*1,MOD*1
C     EQUIVALENCE (ICH4,CH4)
      DATA DLIM/ 1.2, 1.9, 2.5, 2.85 /
C --------------------------------
      IERR = 0
      M    =-ABS(MDOC)-1

      NA   = L1A_NATOM
      MON  = L1L_MNAME        

      DO I=1,C1_NATOM
        S1_INEW (I) = I 
        S1_IOLD (I) = I
        S1_ICHEM(I) = 0              
        S1_NDIST(I) = 0
        S1_IBACK(I) = 0
        S1_IFORW(I) = 0
        S1_BACK (I) = '.'
        S1_FORW (I) = '.'
        S1_CHEM (I) = C1_ASYMB(I) 
        DO  J=1,MX1BRN 
          S1_CONN   (J,I) = 0
          S1_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MX1EXT 
          S1_IEXTR (J,I) = 0
        ENDDO
        ASYMB = C1_ASYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        C1_ATYPE(I) = CTYPE(1:1)
      ENDDO

      IF(C1_NATOM.GT.1) THEN
        DO    IA=1,C1_NATOM-1
        IF(C1_ANAME(IA).NE.'    ') THEN
          CIATOM = C1_ATYPE(IA)
          XI     = C1_XYZ(1,IA)
          YI     = C1_XYZ(2,IA)
          ZI     = C1_XYZ(3,IA)
          DO    JA=IA+1,C1_NATOM
          IF(C1_ANAME(JA).NE.'    ') THEN
            CJATOM = C1_ATYPE(JA)
            XJ     = C1_XYZ(1,JA)
            YJ     = C1_XYZ(2,JA)
            ZJ     = C1_XYZ(3,JA)
            IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
              IC=1 
            ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
              IC=2
            ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
              IC=4
            ELSE 
              IC=3
            ENDIF
 
            IF(IC.GT.0) THEN
            
              DIST = 0.0
              IF(C1_OCC(IA).GT.0.0001.AND.
     *           C1_OCC(JA).GT.0.0001     ) THEN
                DX   = XI-XJ
                DY   = YI-YJ
                DZ   = ZI-ZJ
                DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
              ENDIF 

              IF(DIST.LE.DLIM(IC).AND.DIST.GT.0.001) THEN
                IF(S1_NDIST(IA).LT.MX1BRN) THEN
                  S1_NDIST(IA)             = S1_NDIST(IA) + 1
                  S1_CONN(S1_NDIST(IA),IA) = JA
                  IF(C1_ATYPE(JA).EQ.'H') THEN
                    S1_LENCON(1,IA) = S1_LENCON(1,IA) + 1
                  ENDIF
                ENDIF
                IF(S1_NDIST(JA).LT.MX1BRN) THEN
                  S1_NDIST(JA)             = S1_NDIST(JA) + 1
                  S1_CONN(S1_NDIST(JA),JA) = IA
                  IF(C1_ATYPE(IA).EQ.'H') THEN
                    S1_LENCON(1,JA) = S1_LENCON(1,JA) + 1
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
          ENDDO
        ENDIF
        ENDDO
      ENDIF

      RETURN
      END
C
      SUBROUTINE SET_NUM_MOD(MDOC,MON,PNUM,IERR)
C -----------------------------------------------
C -P- SET_NUM - defines atom's number for atom's name.
C    
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,PNUM*12
C ---
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      CHARACTER NAME*4,LINE*256
C --------------------------------------------------------
      IERR = 0
C --
      DO I=1,L1A_NATOM
        L1A_IOLD  (I) = I
        L1A_INEW  (I) = I
        L1A_LENGTH(I) =-1.0
        L1A_THETA (I) =-1.0
        L1A_PHI   (I) = 0.0
        L1A_ID_PSI(I) = '?' 
      ENDDO
      IFLAGB      = 0
      IFLAGF      = 0
      L1A_ISTART  = 0
      L1A_IFINISH = 0
C ------
      IF(L1A_NATOM.GT.1) THEN
        DO I=1,L1A_NATOM-1
          NAME = L1A_ANAME(I)
          DO J=I+1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              IF(PNUM(1:1).EQ.' ') THEN
                LINE = ' WARNING : '//MON//
     *                 ' : duplicated atom_name : '//L1A_ANAME(J)
              ELSE
                LINE = ' WARNING : '//MON//' '//PNUM//
     *                 ' : duplicated atom_name : '//L1A_ANAME(J)
              ENDIF
              CALL MSGDOC(MDOC,LINE)
              IERR = 1
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ------
      DO I=1,L1A_NATOM
C --
        NAME = L1A_BACK(I)
        IF(NAME(1:1).NE.'.'.AND.NAME(1:1).NE.'n/a') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1A_IBACK(I) = J
              GO TO 100
            ENDIF
          ENDDO

C         without back atom

          L1A_IBACK(I) = 0
          IF(L1A_SYMB(I)(1:2).NE.'H '.AND.L1A_SYMB(I)(1:2).NE.'D ') THEN
            IF(PNUM(1:1).EQ.' ') THEN
              LINE = ' WARNING : '//MON//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ELSE      
              LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ENDIF
            CALL MSGDOC(MDOC,LINE)
            IERR = 1
          ELSE
            L1A_BACK(I) = '.'
            L1A_FORW(I) = '.'
          ENDIF
  100     CONTINUE
        ELSE     
          L1A_IBACK(I) = -1
          L1A_ISTART   = I
          IFLAGB       = IFLAGB + 1
        ENDIF
C --
        CALL LENSTR_BL(L1A_FORW(I),LEN)
        IF(LEN.LE.0) L1A_FORW(I) = '.'
        NAME = L1A_FORW(I)
        IF(NAME(1:3).EQ.'END') THEN
          L1A_IFORW(I) = -1
          L1A_IFINISH  = I
          IFLAGF       = IFLAGF + 1
        ELSE IF(NAME(1:1).NE.'.') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN 
              L1A_IFORW(I) = J
              IF(L1A_BACK(J).NE.L1A_ANAME(I)) THEN
                IF(PNUM(1:1).EQ.' ') THEN
                  LINE = ' WARNING : '//MON//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ELSE
                  LINE = ' WARNING : '//MON//' '//PNUM//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ENDIF 
                CALL MSGDOC(MDOC,LINE)
                IERR=1
              ENDIF
              GO TO 120
            ENDIF
          ENDDO
          L1A_IFORW(I) = 0
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ELSE   
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ENDIF
          CALL MSGDOC(MDOC,LINE)
          IERR = 1
  120     CONTINUE
        ELSE     
          L1A_IFORW(I) = 0
        ENDIF
C ------
        L1A_NDIST(I) = 0
        L1A_NEXTR(I) = 0
      ENDDO

      IF(IFLAGB.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : first atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : first atom of the tree is absent'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGB.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : wrong definition of first atom of the tree'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : wrong definition of first atom of the tree'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ENDIF
      IF(IFLAGF.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : last atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : last atom of the tree is absent'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGF.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
           LINE = ' WARNING : '//MON//
     *            ' : multiple definition of the last atom of the tree'
        ELSE
           LINE = ' WARNING : '//MON//' '//PNUM//
     *            ' : multiple definition of the last atom of the tree'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ENDIF
C -----
      IF(IERR.EQ.0) THEN
C
C       back bone definition
C
        DO I=1,L1A_NATOM
          L1A_NDIST(I) = 0
        ENDDO
        I = L1A_IFINISH 
  700     CONTINUE
          J = L1A_IBACK(I)
          IF(J.LT.0) GO TO 710
          L1A_FORW(J)  = L1A_ANAME(I)
          L1A_IFORW(J) = I 

          L1A_NDIST(J) = L1A_NDIST(J) + 1

          I            = J
          GO TO 700
  710   CONTINUE
      ENDIF
C ---
      RETURN
      END

C ******
      SUBROUTINE MODIF(MDOC,MOD_IN,IERR)
C -----------------------------------------------
C -P- MODIF - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
      CHARACTER COMP*8,TYPE*8,PNUM*12,TREE*1,BACK*4,FORW*4
      CHARACTER LIST *1,MOD_IN*8
C -----------------------------------
      IERR = 0
      LIST = '.'
c      LIST = 'T'

      MOD = MOD_IN

      IF(MOD(1:1).EQ.'.') RETURN

      IF(LDL_NMOD.LE.0) THEN
        CALL MSGDOC(MDOC,
     * ' WARNING: number of modifications in library = 0')
        IERR = 0
        RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF


      IF(MOD.EQ.'NH3'.OR.MOD.EQ.'AA-STAND'.OR.
     *                   MOD.EQ.'AA-STPRO'    ) THEN
      IF(L1A_NATOM.GT.3.AND.L1B_NBOND.GT.2) THEN
        DO I=1,L1B_NBOND
          IF((L1B_1ATM(I).EQ.'N' .AND.L1B_2ATM(I).EQ.'CD').OR.
     *       (L1B_1ATM(I).EQ.'CD'.AND.L1B_2ATM(I).EQ.'N' ).OR.
     *       (L1B_1ATM(I).EQ.'N' .AND.L1B_2ATM(I).EQ.'CN').OR.
     *       (L1B_1ATM(I).EQ.'CN'.AND.L1B_2ATM(I).EQ.'N' )) THEN
            IF(MOD.EQ.'NH3'     ) THEN
              MOD = 'NH2'
              IF((L1B_1ATM(I).EQ.'N' .AND.L1B_2ATM(I).EQ.'CN').OR.
     *        (L1B_1ATM(I).EQ.'CN'.AND.L1B_2ATM(I).EQ.'N' )) 
     *        MOD = 'NH2N'
            ENDIF
            IF(MOD.EQ.'AA-STAND') MOD = 'AA-STPRO'
            GO TO 600          
          ENDIF
        ENDDO
      ENDIF
      ENDIF

 600  CONTINUE

      DO   L=1,LDL_NMOD
        IF(MOD.EQ.LDL_MNAME(L)) THEN
          LDL_IMOD = L
          GO TO 100
        ENDIF
C       IF(MOD.EQ.LDL_MNAME(L).AND.LDL_FUSE(L).NE.'N') GO TO 100
      ENDDO  

      WRITE(LINE,'(A,A8,A,A)')' WARNING: modification ',MOD,
     *    ' not found in library for ',L1L_MNAME
      CALL MSGDOC(MDOC,LINE)
      IERR = 0
      RETURN

  100 CONTINUE
      L = LDL_IMOD

      IF(L.LE.0) THEN
        IF(LIST.EQ.'T') THEN
          WRITE(*,*) ' ERROR: L=0 for:',MOD
        ENDIF 
        RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF0:',mod,l
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      PNUM = ' '
      IF(L1L_PRSNT.EQ.'Y'.OR.L1L_PRSNT.EQ.'.') THEN
        TREE = 'N'
        DO I=1,L1A_NATOM
          IF(L1A_BACK(I).NE.'.') TREE = 'Y'
        ENDDO

        IF(TREE.EQ.'Y') THEN
          CALL SET_NUM_MOD(MDOC,L1L_MNAME,PNUM,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N' 
            IERR = 0
          ENDIF
        ENDIF
      ELSE
        TREE = 'N' 
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF2:',mod,tree
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      IA      = LDL_IATOM(L)
      IN      = LDL_ICONN(L)
      IB      = LDL_IBOND(L)
      IG      = LDL_ITHET(L)
      IT      = LDL_ITORS(L)
      IP      = LDL_IPLAN(L)
      IC      = LDL_ICHIR(L)
      IO      = LDL_ORDER(L)
      IF(L1L_PRSNT.NE.'Y'.AND.L1L_PRSNT.NE.'.') THEN
        IN = 0
        IG = 0
        IT = 0
        IP = 0 
      ENDIF
      IDELA   = 0
      IDELN   = 0
      IDELB   = 0
      IDELG   = 0
      IDELT   = 0
      IDELC   = 0
      IDELP   = 0
      ISTART  = 0
      IFINISH = 0
      ISTART_OLD  = 0
      IFINISH_OLD = 0

      COMP = LDL_COMP(L)
      TYPE = LDL_TYPE(L)
 
      IF(IA.GT.0) THEN
        CALL MOD_AMLIB(MDOC,MOD,IA,TREE,ISTART,IFINISH
     *         ,IDELA,IDELN,IDELB,IDELG,IDELT,IDELC,IDELP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IN.GT.0) THEN
        CALL MOD_NMLIB(MDOC,MOD,IN,TREE
     *  ,ISTART,IFINISH,ISTART_OLD,IFINISH_OLD,IDELN,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IB.GT.0) THEN
        CALL MOD_BMLIB(MDOC,MOD,IB,IDELB,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IG.GT.0) THEN
        CALL MOD_GMLIB(MDOC,MOD,IG,IDELG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IT.GT.0) THEN
        CALL MOD_TMLIB(MDOC,MOD,IT,IDELT,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IP.GT.0) THEN
        CALL MOD_PMLIB(MDOC,MOD,IP,IDELP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IC.GT.0) THEN
        CALL MOD_CMLIB(MDOC,MOD,IC,IDELC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF3:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      WRITE(*,*) ' so,fo:',ISTART_old,IFINISH_old
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      IF(ISTART_OLD.GT.0) THEN
        BACK = L1A_BACK(ISTART_OLD)        
        DO LA=1,L1A_NATOM
          IF(L1A_ANAME(LA).EQ.BACK) THEN
            L1A_BACK (LA) = '.'
            GO TO 300
          ENDIF
        ENDDO
      ENDIF
 300  CONTINUE
      IF(IFINISH_OLD.GT.0) THEN
        FORW = L1A_FORW(IFINISH_OLD)        
        DO LA=1,L1A_NATOM
          IF(L1A_ANAME(LA).EQ.FORW) THEN
            L1A_FORW (LA) = 'END'
            GO TO 400
          ENDIF
        ENDDO
      ENDIF
 400  CONTINUE
      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF4:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      IF(IDELA.GT.0) THEN
        N      = 0
        NHATOM = 0
        DO LA=1,L1A_NATOM
          IF(L1A_ANAME(LA).NE.'    ') THEN
            N                = N+1 
            L1A_COOR_FLAG(N) = L1A_COOR_FLAG(LA)
            L1A_CHARG(N)     = L1A_CHARG(LA)
            IF(L1A_COOR_FLAG(N).EQ.'Y') THEN
              L1A_X    (N) = L1A_X    (LA)
              L1A_Y    (N) = L1A_Y    (LA)
              L1A_Z    (N) = L1A_Z    (LA)
            ELSE
              L1A_X    (N) = 0.0
              L1A_Y    (N) = 0.0
              L1A_Z    (N) = 0.0 
            ENDIF
            IF(LA.EQ.L1A_ISTART)  L1A_ISTART  = N
            IF(LA.EQ.L1A_IFINISH) L1A_IFINISH = N
            IF(LA.EQ.ISTART)  ISTART  = N
            IF(LA.EQ.IFINISH) IFINISH = N
            L1A_INEW (N) = N 
            L1A_IOLD (N) = N
            L1A_ICR  (N) = 0
            L1A_NDIST(N) = 0
            L1A_IBACK(N) = 0
            L1A_IFORW(N) = 0
            L1A_BACK (N) = L1A_BACK (LA)
            L1A_TYPE (N) = L1A_TYPE (LA) 
            L1A_FORW (N) = L1A_FORW (LA) 
            L1A_ANAME(N) = L1A_ANAME(LA)
            L1A_SYMB (N) = L1A_SYMB (LA)  
            L1A_CHEM (N) = L1A_CHEM (LA)
            L1A_ATYPE(N) = 'M'
            IF(L1A_SYMB(N)(1:2).NE.'H '.AND.
     *         L1A_SYMB(N)(1:2).NE.'D ' )
     *         NHATOM = NHATOM + 1
            DO  J=1,MAX1BRN 
              L1A_CONN   (J,N) = 0
              L1A_LENCON (J,N) = 0
            ENDDO
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,N) = 0
              L1A_TEXTR (J,N) = 0
            ENDDO
          ENDIF
        ENDDO
        L1A_NATOM  = N
        L1A_NHATOM = NHATOM
      ENDIF

      IF(IDELB.GT.0) THEN
        IF(L1B_NBOND.GT.0) THEN
          N = 0
          DO LB=1,L1B_NBOND
            IF(L1B_1ATM(LB).NE.'    ') THEN
              N            = N+1 
              L1B_I1ATM(N) = 0
              L1B_I2ATM(N) = 0
              L1B_1ATM (N) = L1B_1ATM (LB)
              L1B_2ATM (N) = L1B_2ATM (LB)
              L1B_TYPE (N) = L1B_TYPE (LB)
              L1B_FLAG (N) = L1B_FLAG (LB)
              L1B_VOBS (N) = L1B_VOBS (LB)  
              L1B_VAL  (N) = L1B_VAL  (LB) 
              L1B_DEV  (N) = L1B_DEV  (LB) 
            ENDIF
          ENDDO
          L1B_NBOND = N
        ENDIF
      ENDIF

      IF(IDELN.GT.0) THEN
        IF(L1N_NCONN.GT.0) THEN
          N = 0
          DO LN=1,L1N_NCONN
            IF(L1N_1ATM(LN).NE.'    ') THEN
              N            = N+1 
              L1N_I1ATM(N) = 0
              L1N_I2ATM(N) = 0
              L1N_1ATM (N) = L1N_1ATM (LN)
              L1N_2ATM (N) = L1N_2ATM (LN)
              L1N_TYPE (N) = L1N_TYPE (LN)
            ENDIF
          ENDDO
          L1N_NCONN = N
        ENDIF
      ENDIF
 
      IF(IDELG.GT.0) THEN
        IF(L1G_NANGL.GT.0) THEN
          N = 0
          DO LG=1,L1G_NANGL
            IF(L1G_1ATM(LG).NE.'    ') THEN
              N            = N+1 
              L1G_I1ATM(N) = 0
              L1G_I2ATM(N) = 0
              L1G_I3ATM(N) = 0
              L1G_1ATM (N) = L1G_1ATM (LG)
              L1G_2ATM (N) = L1G_2ATM (LG)
              L1G_3ATM (N) = L1G_3ATM (LG)
              L1G_FLAG (N) = L1G_FLAG (LG)
              L1G_VOBS (N) = L1G_VOBS (LG)  
              L1G_VAL  (N) = L1G_VAL  (LG) 
              L1G_DEV  (N) = L1G_DEV  (LG) 
            ENDIF
          ENDDO
          L1G_NANGL = N
        ENDIF
      ENDIF

      IF(IDELT.GT.0) THEN
        IF(L1T_NTORS.GT.0) THEN
          N = 0
          DO LT=1,L1T_NTORS
            IF(L1T_1ATM(LT).NE.'    ') THEN
              N            = N+1 
              L1T_I1ATM(N) = 0
              L1T_I2ATM(N) = 0
              L1T_I3ATM(N) = 0
              L1T_I4ATM(N) = 0
              L1T_1ATM (N) = L1T_1ATM (LT)
              L1T_2ATM (N) = L1T_2ATM (LT)
              L1T_3ATM (N) = L1T_3ATM (LT)
              L1T_4ATM (N) = L1T_4ATM (LT)
              L1T_FLAG (N) = L1T_FLAG (LT)
              L1T_VOBS (N) = L1T_VOBS (LT)  
              L1T_VAL  (N) = L1T_VAL  (LT) 
              L1T_DEV  (N) = L1T_DEV  (LT) 
              L1T_PRD  (N) = L1T_PRD  (LT) 
              L1T_LABEL(N) = L1T_LABEL(LT) 
            ENDIF
          ENDDO
          L1T_NTORS = N
        ENDIF
      ENDIF

      IF(IDELC.GT.0) THEN
        IF(L1C_NCHIR.GT.0) THEN
          N = 0
          DO LC=1,L1C_NCHIR
            IF(L1C_1ATM(LC).NE.'    ') THEN
              N            = N+1 
              L1C_I1ATM(N) = 0
              L1C_I2ATM(N) = 0
              L1C_I3ATM(N) = 0
              L1C_I4ATM(N) = 0
              L1C_1ATM (N) = L1C_1ATM (LC)
              L1C_2ATM (N) = L1C_2ATM (LC)
              L1C_3ATM (N) = L1C_3ATM (LC)
              L1C_4ATM (N) = L1C_4ATM (LC)
              L1C_5ATM (N) = L1C_5ATM (LC)
              L1C_6ATM (N) = L1C_6ATM (LC)
              L1C_7ATM (N) = L1C_7ATM (LC)
              L1C_8ATM (N) = L1C_8ATM (LC)
              L1C_9ATM (N) = L1C_9ATM (LC)
              L1C_FLAG (N) = L1C_FLAG (LC)
              L1C_VOL  (N) = L1C_VOL  (LC) 
              L1C_VOBS (N) = L1C_VOBS (LC) 
              L1C_SIGN (N) = L1C_SIGN (LC) 
            ENDIF
          ENDDO
          L1C_NCHIR = N
        ENDIF
      ENDIF

        IF(IDELP.GT.0) THEN
          IF(L1P_NPLAN.GT.0) THEN

C           remove plan with NA < 4
            DO LP=1,L1P_NPLAN
              N = 0
              DO LPA=1,L1P_NATOM(LP)
                IF(L1P_ATOM(LPA,LP).GT.0) THEN
                  N = N + 1
                  L1P_FLAG  (N,LP) = L1P_FLAG (LPA,LP) 
                  L1P_DOBS  (N,LP) = L1P_DOBS (LPA,LP)
                  L1P_EDEV  (N,LP) = L1P_EDEV (LPA,LP)
                  L1P_IATOM (N,LP) = L1P_IATOM(LPA,LP)
                  L1P_DEV   (N,LP) = L1P_DEV  (LPA,LP)
                  L1P_ATOM  (N,LP) = L1P_ATOM (LPA,LP)
                 ENDIF
              ENDDO
              IF(N.GT.3) THEN
                L1P_NATOM(LP) = N
              ELSE 
                L1P_NATOM(LP) = 0
              ENDIF
            ENDDO
C           unite common plans 
            IF(L1P_NPLAN.GT.1) THEN
              DO LP1=1,L1P_NPLAN-1
              IF(L1P_NATOM(LP1).GT.0) THEN
              DO LP2=LP1+1,L1P_NPLAN
              IF(L1P_NATOM(LP2).GT.0) THEN
 
                NCOMM = 0
                DO LPA1=1,L1P_NATOM(LP1)
                DO LPA2=1,L1P_NATOM(LP2)
                  IF(L1P_ATOM(LPA1,LP1).EQ.L1P_ATOM(LPA2,LP2)) THEN
                    NCOMM = NCOMM + 1
                  ENDIF
                ENDDO
                ENDDO
                IF(NCOMM.GE.3) THEN
                  N = L1P_NATOM(LP1)
                  DO LPA2=1,L1P_NATOM(LP2)
                    DO LPA1=1,L1P_NATOM(LP1)
                      IF(L1P_ATOM(LPA1,LP1).EQ.
     *                   L1P_ATOM(LPA2,LP2)) THEN
                        GO TO 500
                      ENDIF
                    ENDDO
                    N = N + 1
                    L1P_FLAG  (N,LP1) = L1P_FLAG (LPA2,LP2) 
                    L1P_DOBS  (N,LP1) = L1P_DOBS (LPA2,LP2)
                    L1P_EDEV  (N,LP1) = L1P_EDEV (LPA2,LP2)
                    L1P_IATOM (N,LP1) = L1P_IATOM(LPA2,LP2)
                    L1P_DEV   (N,LP1) = L1P_DEV  (LPA2,LP2)
                    L1P_ATOM  (N,LP1) = L1P_ATOM (LPA2,LP2)
 500                CONTINUE
                  ENDDO
                  L1P_NATOM(LP1) = N
                  L1P_NATOM(LP2) = 0
                ENDIF 
              ENDIF
              ENDDO
              ENDIF
              ENDDO 
            ENDIF
C           remove plan with NA = 0
            NP = 0
            DO LP=1,L1P_NPLAN
              IF(L1P_NATOM(LP).GT.0) THEN
                NP = NP + 1
                L1P_NATOM(NP) = L1P_NATOM(LP)
                L1P_LABEL(NP) = L1P_LABEL(LP)
                DO LPA=1,L1P_NATOM(LP)
                  L1P_FLAG  (LPA,NP) = L1P_FLAG (LPA,LP) 
                  L1P_DOBS  (LPA,NP) = L1P_DOBS (LPA,LP)
                  L1P_EDEV  (LPA,NP) = L1P_EDEV (LPA,LP)
                  L1P_IATOM (LPA,NP) = L1P_IATOM(LPA,LP)
                  L1P_DEV   (LPA,NP) = L1P_DEV  (LPA,LP)
                  L1P_ATOM  (LPA,NP) = L1P_ATOM (LPA,LP)
                ENDDO
              ENDIF
            ENDDO
            L1P_NPLAN = NP
c
          ENDIF
        ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF5:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF
 
      IF(L1L_PRSNT.EQ.'Y'.OR.L1L_PRSNT.EQ.'.') THEN
      IF(TREE.EQ.'Y') THEN
        PNUM = ' '
        CALL SET_NUM_MOD(MDOC,L1L_MNAME,PNUM,IERR)
        IF(IERR.NE.0) THEN
          TREE = 'N' 
          IERR = 0
        ENDIF
      ENDIF
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF6:::',mod,tree
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
       write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF
 
      IF(TREE.EQ.'Y'.AND.
     *   ((ISTART .NE.0.AND.ISTART .NE.L1A_ISTART ).OR.
     *    (IFINISH.NE.0.AND.IFINISH.NE.L1A_IFINISH)    )) THEN
        IF(ISTART.EQ.L1A_IFINISH.AND.ISTART.GT.0) THEN
          ITYPE = 0
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 200
          ENDIF
        ENDIF
        IF(ISTART.NE.L1A_ISTART.AND.ISTART.GT.0) THEN
          ITYPE = 1
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 200
          ENDIF
        ENDIF
        IF(IFINISH.NE.L1A_IFINISH.AND.IFINISH.GT.0) THEN
          ITYPE = 2
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 200
          ENDIF
        ENDIF
      ENDIF
 200  CONTINUE

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIFend:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF
 
      RETURN
      END

      SUBROUTINE MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C --
      CHARACTER TYPE*8,TYPE_T*8
C -----------------------------------------------
      IERR = 0

      IF(ITYPE.EQ.0) THEN

C       revers
C        write(*,*) '   revers:',istart,ifinish

        I            = L1A_IFINISH 
        L1A_BACK (I) = '.'         
        L1A_IBACK(I) = -1
        
  100     CONTINUE

          IF(I.LE.0) GO TO 400
          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 110

          IF(I.GT.0.AND.J.GT.0) THEN

            L1A_IBACK(J) = I 
            L1A_BACK (J) = L1A_ANAME(I)
            TYPE         = L1A_TYPE (J)
            L1A_TYPE (J) = L1A_TYPE (I)
            L1A_FORW (I) = L1A_ANAME(J)
            L1A_IFORW(I) = J
            L1A_TYPE (I) = TYPE  

          ELSE
            GO TO 400
          ENDIF

          I = J
          GO TO 100

  110   CONTINUE

        IST          = L1A_ISTART
        L1A_ISTART   = L1A_IFINISH
        L1A_IFINISH  = I
        L1A_FORW (I) = 'END'         
        L1A_IFORW(I) = -1

      ELSE IF(ITYPE.EQ.1) THEN

C       new start       
C        write(*,*) '   new start:',istart

        I    = ISTART 
        II   = 0
        TYPE = '.'
        
  200     CONTINUE

          IF(I.LE.0) GO TO 400

          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 210

          IF(I.GT.0.AND.II.GT.0) THEN
            L1A_IBACK(I) = II 
            TYPE_T       = L1A_TYPE (I)
            L1A_BACK (I) = L1A_ANAME(II)
            L1A_TYPE (I) = TYPE
            TYPE         = TYPE_T
          ENDIF   

          L1A_FORW (I) = L1A_ANAME(J)
          L1A_IFORW(I) = J 

          II = I 
          I  = J
          GO TO 200

  210   CONTINUE

        IF(I.GT.0.AND.II.GT.0) THEN
          L1A_IBACK(I) = II 
          L1A_BACK (I) = L1A_ANAME(II)
          L1A_TYPE (I) = TYPE
          L1A_FORW (I) = '.'
          L1A_IFORW(I) = 0 
        ENDIF   

        L1A_ISTART        = ISTART
        L1A_BACK (ISTART) = '.'         
        L1A_IBACK(ISTART) = -1
c ----
C       check backbon
C       

          I            = L1A_IFINISH 
          IF(I.GT.0) THEN
            L1A_FORW (I) = 'END'         
            L1A_IFORW(I) = -1
          ENDIF
 
  220     CONTINUE

          IF(I.LE.0) GO TO 400
          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 230

          IF(J.GT.0.AND.I.GT.0) THEN
            L1A_FORW (J) = L1A_ANAME(I)
            L1A_IFORW(J) = I
c            GO TO 230 
          ENDIF

          I = J
          GO TO 220

  230   CONTINUE

c ----
      ELSE IF(ITYPE.EQ.2) THEN

C       new finish
C        write(*,*) '   new finish:',ifinish

          I            = IFINISH 
          IF(IFINISH.GT.0) THEN
            L1A_FORW (I) = 'END'         
            L1A_IFORW(I) = -1
          ENDIF
  300     CONTINUE

          IF(I.LE.0) GO TO 400
          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 310

          IF(J.GT.0.AND.I.GT.0) THEN
            L1A_FORW (J) = L1A_ANAME(I)
            L1A_IFORW(J) = I
c            GO TO 310 
          ENDIF

          I = J
          GO TO 300

  310   CONTINUE

        IF(L1A_IFINISH.GT.0) THEN
          L1A_FORW (L1A_IFINISH) = '.'
          L1A_IFORW(L1A_IFINISH) = 0
        ENDIF

        L1A_IFINISH   = IFINISH

      ENDIF

      RETURN
 400  CONTINUE
      IERR = 1
      RETURN

      END

      SUBROUTINE MOD_AMLIB(MDOC,MOD,IA,TREE,ISTART,IFINISH
     *         ,IDELA,IDELN,IDELB,IDELG,IDELT,IDELC,IDELP,IERR)
C -----------------------------------------------
C -P- MOD_AMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MOD*8,TREE*1
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      CHARG
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ANAME*4,ANEW*4,SYMB*4,CHEM*4
C ---
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      IERR = 0
      IF(LDA_NATOM.LE.0.OR.LDA_NATOM.LT.IA.OR.IA.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of atoms in monomer = 0')
c        IERR = 1
        RETURN
      ENDIF

      DO   L=IA,LDA_NATOM
        IF(MOD.EQ.LDA_MNAME(L)) THEN
          FUNCT = LDA_FUNCT(L)
          ANAME = LDA_ANAME(L)
          ANEW  = LDA_ANEW (L)
          SYMB  = LDA_SYMB (L)
          CHEM  = LDA_CHEM (L)
          CHARG = LDA_CHARG(L)
             
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1A_NATOM.LE.0) THEN
              WRITE(LINE,'(5A)')' WARNING: number of atoms in mon ',
     *  L1L_MNAME,' for mod ',MOD,' = 0'
              CALL MSGDOC(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF

            DO LA=1,L1A_NATOM
              IF(ANAME.EQ.L1A_ANAME(LA)) THEN

                L1A_ANAME(LA) = '    '
                L1A_ATYPE(LA) = 'D'
                IDELA = 1

                DO LAJ=1,L1A_NATOM
C                  IF(ANAME.EQ.L1A_BACK(LAJ)) THEN
C                    L1A_BACK(LAJ) = '.'
C                  ENDIF
                  IF(ANAME.EQ.L1A_FORW(LAJ)) THEN
                    L1A_FORW(LAJ) = '.'
                  ENDIF
                ENDDO

                IF(LA.EQ.L1A_ISTART) THEN
                  ISTART            = L1A_IFORW(LA)
                  IF(ISTART.GT.0) THEN
                    L1A_IBACK(ISTART) = -1 
                    L1A_BACK(ISTART)  = '.' 
                    L1A_ISTART        = ISTART
                  ENDIF
                ELSE IF(LA.EQ.L1A_IFINISH) THEN 
                  IFINISH            = L1A_IBACK(LA)
                  IF(IFINISH.GT.0) THEN 
                    L1A_IFORW(IFINISH) = -1 
                    L1A_FORW(IFINISH)  = 'END' 
                    L1A_IFINISH        = IFINISH
                  ENDIF
                ENDIF

                IF(L1B_NBOND.GT.0) THEN
                  DO LB=1,L1B_NBOND
                    IF(ANAME.EQ.L1B_1ATM(LB).OR.
     *                 ANAME.EQ.L1B_2ATM(LB)) THEN
                      L1B_1ATM(LB) = '    '
                      L1B_2ATM(LB) = '    '
                      IDELB        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1G_NANGL.GT.0) THEN
                  DO LG=1,L1G_NANGL
                    IF(ANAME.EQ.L1G_1ATM(LG).OR.
     *                 ANAME.EQ.L1G_2ATM(LG).OR.
     *                 ANAME.EQ.L1G_3ATM(LG)) THEN
                      L1G_1ATM(LG) = '    '
                      L1G_2ATM(LG) = '    '
                      L1G_3ATM(LG) = '    '
                      IDELG        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1T_NTORS.GT.0) THEN
                  DO LT=1,L1T_NTORS
                    IF(ANAME.EQ.L1T_1ATM(LT).OR.
     *                 ANAME.EQ.L1T_2ATM(LT).OR.
     *                 ANAME.EQ.L1T_3ATM(LT).OR.
     *                 ANAME.EQ.L1T_4ATM(LT)) THEN
                      L1T_1ATM(LT) = '    '
                      L1T_2ATM(LT) = '    '
                      L1T_3ATM(LT) = '    '
                      L1T_4ATM(LT) = '    '
                      IDELT        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1C_NCHIR.GT.0) THEN
                  DO LC=1,L1C_NCHIR
                    IF(ANAME.EQ.L1C_1ATM(LC).OR.
     *                 ANAME.EQ.L1C_2ATM(LC).OR.
     *                 ANAME.EQ.L1C_3ATM(LC).OR.
     *                 ANAME.EQ.L1C_4ATM(LC).OR.
     *                 ANAME.EQ.L1C_5ATM(LC).OR.
     *                 ANAME.EQ.L1C_6ATM(LC).OR.
     *                 ANAME.EQ.L1C_7ATM(LC).OR.
     *                 ANAME.EQ.L1C_8ATM(LC).OR.
     *                 ANAME.EQ.L1C_9ATM(LC)) THEN
                      L1C_1ATM(LC) = '    '
                      L1C_2ATM(LC) = '    '
                      L1C_3ATM(LC) = '    '
                      L1C_4ATM(LC) = '    '
                      L1C_5ATM(LC) = '    '
                      L1C_6ATM(LC) = '    '
                      L1C_7ATM(LC) = '    '
                      L1C_8ATM(LC) = '    '
                      L1C_9ATM(LC) = '    '
                      IDELC        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1N_NCONN.GT.0) THEN
                  DO LN=1,L1N_NCONN
                    IF(ANAME.EQ.L1N_1ATM(LN).OR.
     *                 ANAME.EQ.L1N_2ATM(LN)    ) THEN
                      L1N_1ATM(LN) = '    '
                      L1N_2ATM(LN) = '    '
                      IDELN        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1P_NPLAN.GT.0) THEN
                  ATOM = ANAME
                  DO LP=1,L1P_NPLAN
                    IF(L1P_NATOM(LP).GT.0) THEN
                      DO IA1=1,L1P_NATOM(LP)
                        IF(L1P_ATOM(IA1,LP).EQ.IATOM) THEN
                          L1P_ATOM(IA1,LP) = 0
                        ENDIF
                      ENDDO
                    ENDIF
                  ENDDO
                  IDELP = 1
                ENDIF
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1A_NATOM.LE.0) THEN
              WRITE(LINE,'(5A)')' WARNING: number of atoms in mon ',
     * L1L_MNAME,' for mod ',MOD,' = 0'
              CALL MSGDOC(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LA=1,L1A_NATOM
              IF(ANAME.EQ.L1A_ANAME(LA)) THEN

                IF(ABS(CHARG).GT.0.0) L1A_CHARG(LA) = CHARG
                IF(ANEW(1:1).NE.'.')  L1A_ANAME(LA) = ANEW
                IF(SYMB(1:1).NE.'.')  L1A_SYMB (LA) = SYMB  
                IF(CHEM(1:1).NE.'.')  L1A_CHEM (LA) = CHEM 

                IF(ANEW(1:1).EQ.'.') GO TO 100
                IF(L1B_NBOND.GT.0) THEN
                  DO LB=1,L1B_NBOND
                    IF(ANAME.EQ.L1B_1ATM(LB)) THEN
                      L1B_1ATM(LB) = ANEW
                    ELSE IF(ANAME.EQ.L1B_2ATM(LB)) THEN
                      L1B_2ATM(LB) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1G_NANGL.GT.0) THEN
                  DO LG=1,L1G_NANGL
                    IF(ANAME.EQ.L1G_1ATM(LG)) THEN
                      L1G_1ATM(LG) = ANEW
                    ELSE IF(ANAME.EQ.L1G_2ATM(LG)) THEN
                      L1G_2ATM(LG) = ANEW
                    ELSE IF(ANAME.EQ.L1G_3ATM(LG)) THEN
                      L1G_3ATM(LG) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1T_NTORS.GT.0) THEN
                  DO LT=1,L1T_NTORS
                    IF(ANAME.EQ.L1T_1ATM(LT)) THEN
                      L1T_1ATM(LT) = ANEW
                    ELSE IF(ANAME.EQ.L1T_2ATM(LT)) THEN
                      L1T_2ATM(LT) = ANEW
                    ELSE IF(ANAME.EQ.L1T_3ATM(LT)) THEN
                      L1T_3ATM(LT) = ANEW
                    ELSE IF(ANAME.EQ.L1T_4ATM(LT)) THEN
                      L1T_4ATM(LT) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1C_NCHIR.GT.0) THEN
                  DO LC=1,L1C_NCHIR
                    IF(ANAME.EQ.L1C_1ATM(LC)) THEN
                      L1C_1ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_2ATM(LC)) THEN
                      L1C_2ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_3ATM(LC)) THEN
                      L1C_3ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_4ATM(LC)) THEN
                      L1C_4ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_5ATM(LC)) THEN
                      L1C_5ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_6ATM(LC)) THEN
                      L1C_6ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_7ATM(LC)) THEN
                      L1C_7ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_8ATM(LC)) THEN
                      L1C_8ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_9ATM(LC)) THEN
                      L1C_9ATM(LC) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1N_NCONN.GT.0) THEN
                  DO LN=1,L1N_NCONN
                    IF(ANAME.EQ.L1N_1ATM(LN)) THEN
                      L1N_1ATM(LN) = ANEW
                    ELSE IF(ANAME.EQ.L1N_2ATM(LN)) THEN
                      L1N_2ATM(LN) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1A_NATOM.GT.MAX1ATM) THEN
              WRITE(LINE,'(3A,I6)')
     *' WARNING: number of atoms in monomer ',L1L_MNAME,' for mod  >',
     *   MAX1ATM
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ATM in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            DO I=1,L1A_NATOM
              IF(L1A_ANAME(I).EQ.ANEW) GO TO 100 
            ENDDO

            L1A_NATOM = L1A_NATOM+1

            L1A_COOR_FLAG(L1A_NATOM) = 'N'
            L1A_CHARG(L1A_NATOM) = CHARG
            L1A_X    (L1A_NATOM) = 0.0
            L1A_Y    (L1A_NATOM) = 0.0
            L1A_Z    (L1A_NATOM) = 0.0
            L1A_INEW (L1A_NATOM) = L1A_NATOM 
            L1A_IOLD (L1A_NATOM) = L1A_NATOM
            L1A_ICR  (L1A_NATOM) = 0
            L1A_NDIST(L1A_NATOM) = 0
            L1A_IBACK(L1A_NATOM) = 0
            L1A_IFORW(L1A_NATOM) = 0
            L1A_BACK (L1A_NATOM) = ' '
            L1A_TYPE (L1A_NATOM) = ' ' 
            L1A_FORW (L1A_NATOM) = ' ' 
            L1A_ANAME(L1A_NATOM) = ANEW
            L1A_SYMB (L1A_NATOM) = SYMB  
            L1A_CHEM (L1A_NATOM) = CHEM 
            IF(L1A_SYMB(L1A_NATOM)(1:2).NE.'H '.AND.
     *         L1A_SYMB(L1A_NATOM)(1:2).NE.'D ' )
     *         L1A_NHATOM = L1A_NHATOM + 1
            L1A_ATYPE(L1A_NATOM) = 'M'
            DO  J=1,MAX1BRN 
              L1A_CONN   (J,L1A_NATOM) = 0
              L1A_LENCON (J,L1A_NATOM) = 0
            ENDDO
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,L1A_NATOM) = 0
              L1A_TEXTR (J,L1A_NATOM) = 0
            ENDDO
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  


      RETURN
      END

      SUBROUTINE MOD_NMLIB(MDOC,MOD,IN,TREE,ISTART,IFINISH
     *  ,ISTART_OLD,IFINISH_OLD,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_NMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IN,IERR,IDEL
      CHARACTER MOD*8,TREE*1
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256,FUNCT*8
      CHARACTER BACK*4,FORW*4,ATOM*4,ATM1*4,ATM2*4,BTYPE*8,TYPE*8
C -----------------------------------
      IERR = 0
      IF(LDN_NCONN.LE.0.OR.LDN_NCONN.LT.IN.OR.IN.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of conn. in monomer = 0.')
c        IERR = 1
        RETURN
      ENDIF

      IDEL = 0

      DO   L=IN,LDN_NCONN

        IF(MOD.EQ.LDN_MNAME(L)) THEN
          FUNCT = LDN_FUNCT(L)
          BACK  = LDN_BACK (L)
          FORW  = LDN_FORW (L)
          ATOM  = LDN_ATOM (L)
          ATM1  = LDN_1ATM (L)
          ATM2  = LDN_2ATM (L)
          BTYPE = LDN_BTYPE(L)
          TYPE  = LDN_TYPE (L)

          IF(FUNCT(1:6).EQ.'delete') THEN

C            IF(L1A_NATOM.GT.0) THEN
C            DO LA=1,L1A_NATOM
C              IF(ATOM.EQ.L1A_ANAME(LA)) THEN
C                L1A_BACK (LA) = ' '
C                L1A_FORW (LA) = ' '
C                L1A_TYPE (LA) = ' '
C                GO TO 100
C              ENDIF
C            ENDDO
C            ENDIF

            IF(L1N_NCONN.GT.0) THEN
            DO LN=1,L1N_NCONN
              IF((ATM1.EQ.L1N_1ATM(LN).AND.ATM2.EQ.L1N_2ATM(LN)).OR.
     *           (ATM2.EQ.L1N_1ATM(LN).AND.ATM1.EQ.L1N_2ATM(LN))) THEN
                L1N_1ATM (LN) = ' '
                L1N_2ATM (LN) = ' '
                L1N_TYPE (LN) = ' '
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

          ELSE IF(FUNCT(1:6).EQ.'change') THEN

            IF(L1A_NATOM.GT.0) THEN
              DO LA=1,L1A_NATOM
                IF(ATOM.EQ.L1A_ANAME(LA)) THEN
                  IF(BACK (1:1).NE.'.') THEN
                    IF(L1A_BACK(LA).EQ.'.'.OR.L1A_BACK(LA).EQ.'n/a'.OR.
     *                 L1A_BACK(LA).EQ.'START') THEN
                      ISTART_OLD = LA
                    ENDIF
                    L1A_BACK(LA) = BACK 
                  ENDIF
                  IF(FORW (1:1).NE.'.') THEN
                    IF(L1A_FORW(LA).EQ.'END') THEN
                      IFINISH_OLD = LA
                    ENDIF
                    L1A_FORW(LA) = FORW
                  ENDIF
                  IF(BTYPE(1:1).NE.'.') L1A_TYPE(LA) = BTYPE
C                 IF(TYPE (1:3).EQ.'END'  ) L1A_FORW(LA) = 'END'
C                 IF(TYPE (1:5).EQ.'START') L1A_BACK(LA) = '.'
                  IF(TYPE (1:3).EQ.'END'  ) IFINISH = LA
                  IF(TYPE (1:5).EQ.'START') ISTART  = LA
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF

            IF(L1N_NCONN.GT.0) THEN
            DO LN=1,L1N_NCONN
              IF((ATM1.EQ.L1N_1ATM(LN).AND.ATM2.EQ.L1N_2ATM(LN)).OR.
     *           (ATM2.EQ.L1N_1ATM(LN).AND.ATM1.EQ.L1N_2ATM(LN))) THEN
                L1N_1ATM (LN) = ATM1
                L1N_2ATM (LN) = ATM2
                L1N_TYPE (LN) = TYPE
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

          ELSE IF(FUNCT(1:3).EQ.'add') THEN

            IF(L1A_NATOM.GT.0) THEN
              DO LA=1,L1A_NATOM
                IF(ATOM.EQ.L1A_ANAME(LA)) THEN

                  IF(BACK (1:1).NE.'.') L1A_BACK(LA) = BACK 
                  IF(FORW (1:1).NE.'.') L1A_FORW(LA) = FORW
                  IF(BTYPE(1:1).NE.'.') L1A_TYPE(LA) = BTYPE
C                  IF(TYPE (1:3).EQ.'END'  ) L1A_FORW(LA) = 'END'
C                  IF(TYPE (1:5).EQ.'START') L1A_BACK(LA) = '.'
                  IF(TYPE (1:3).EQ.'END'  ) IFINISH = LA
                  IF(TYPE (1:5).EQ.'START') ISTART  = LA
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF
 
            IF(L1N_NCONN.GT.0) THEN
            DO LN=1,L1N_NCONN
              IF((ATM1.EQ.L1N_1ATM(LN).AND.ATM2.EQ.L1N_2ATM(LN)).OR.
     *           (ATM2.EQ.L1N_1ATM(LN).AND.ATM1.EQ.L1N_2ATM(LN))) THEN
                L1N_1ATM (LN) = ATM1
                L1N_2ATM (LN) = ATM2
                L1N_TYPE (LN) = TYPE
                GO TO 100
              ENDIF
            ENDDO
            ENDIF


            IF(L1N_NCONN.GT.MAX1CONN) THEN
              WRITE(LINE,'(3A,I6)')
     *' WARNING: number of CONNs in monomer ',L1L_MNAME,' for mod  >',
     *    MAX1CONN
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1CONN in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF
            L1N_NCONN            = L1N_NCONN + 1
            L1N_1ATM (L1N_NCONN) = ATM1 
            L1N_2ATM (L1N_NCONN) = ATM2
            L1A_TYPE (L1N_NCONN) = TYPE
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  

      RETURN
      END

      SUBROUTINE MOD_BMLIB(MDOC,MOD,IB,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_BMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IB,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VAL,VOBS,DEV
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,TYPE*8
C -----------------------------------
      IERR = 0
      IF(LDB_NBOND.LE.0.OR.LDB_NBOND.LT.IB.OR.IB.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of bonds in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IB,LDB_NBOND
        IF(MOD.EQ.LDB_MNAME(L)) THEN
          FUNCT=LDB_FUNCT(L)
          ATM1 =LDB_1ATM (L)
          ATM2 =LDB_2ATM (L)
          TYPE =LDB_TYPE (L)
          VAL  =LDB_VAL  (L)
          VOBS =LDB_VOBS (L)
          DEV  =LDB_DEV  (L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1B_NBOND.LE.0) THEN
c              WRITE(LINE,
c     *''WARNING: number of bonds in mon '',A,'' for mod '',A,'' = 0''
c     *)')     L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LB=1,L1B_NBOND
              IF( ((ATM1.EQ.L1B_1ATM(LB)).AND.(ATM2.EQ.L1B_2ATM(LB))) 
     *        .OR.((ATM2.EQ.L1B_1ATM(LB)).AND.(ATM1.EQ.L1B_2ATM(LB)))) 
     *          THEN
                L1B_1ATM(LB)='    '
                L1B_2ATM(LB)='    '
                IDEL=1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1B_NBOND.LE.0) THEN
c              WRITE(LINE,'(
c     *'' WARNING: number of bonds in mon '',A,'' for mod '',A,'' = 0''
c     *)')     L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
               IERR=0
              GO TO 100
            ENDIF
            DO LB=1,L1B_NBOND
              IF( ((ATM1.EQ.L1B_1ATM(LB)).AND.(ATM2.EQ.L1B_2ATM(LB))) 
     *        .OR.((ATM2.EQ.L1B_1ATM(LB)).AND.(ATM1.EQ.L1B_2ATM(LB)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1B_VAL (LB)  = VAL
                IF(ABS(VOBS).GT.0.0) L1B_VOBS(LB)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1B_DEV (LB)  = DEV
                IF(TYPE(1:1).NE.'.') L1B_TYPE(LB)  = TYPE
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1B_NBOND.GT.MAX1BND) THEN
              WRITE(LINE,'(3A,I6)')
     * ' WARNING: number of bonds in monomer ',MAX1BND,' for mod  >',
     *    MAX1BND
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1BND in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1B_NBOND.GT.0) THEN
            DO LB=1,L1B_NBOND
              IF( ((ATM1.EQ.L1B_1ATM(LB)).AND.(ATM2.EQ.L1B_2ATM(LB))) 
     *        .OR.((ATM2.EQ.L1B_1ATM(LB)).AND.(ATM1.EQ.L1B_2ATM(LB)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1B_VAL (LB)  = VAL
                IF(ABS(VOBS).GT.0.0) L1B_VOBS(LB)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1B_DEV (LB)  = DEV
                IF(TYPE(1:1).NE.'.') L1B_TYPE(LB)  = TYPE
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1B_NBOND = L1B_NBOND+1

            L1B_I1ATM(L1B_NBOND) = 0
            L1B_I2ATM(L1B_NBOND) = 0
            L1B_1ATM (L1B_NBOND) = ATM1 
            L1B_2ATM (L1B_NBOND) = ATM2
            L1B_TYPE (L1B_NBOND) = TYPE
            L1B_FLAG (L1B_NBOND) = ' '
            L1B_VOBS (L1B_NBOND) = VOBS  
            L1B_VAL  (L1B_NBOND) = VAL 
            L1B_DEV  (L1B_NBOND) = DEV 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_GMLIB(MDOC,MOD,IG,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_GMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VAL,VOBS,DEV
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4
C     CHARACTER TYPE*8
C -----------------------------------
      IERR = 0
      IF(LDG_NANGL.LE.0.OR.LDG_NANGL.LT.IG.OR.IG.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of angles in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IG,LDG_NANGL
        IF(MOD.EQ.LDG_MNAME(L)) THEN
          FUNCT=LDG_FUNCT(L)
          ATM1 =LDG_1ATM (L)
          ATM2 =LDG_2ATM (L)
          ATM3 =LDG_3ATM (L)
          VAL  =LDG_VAL  (L)
          VOBS =LDG_VOBS (L)
          DEV  =LDG_DEV  (L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1G_NANGL.LE.0) THEN
c              WRITE(LINE,'(
c     *''WARNING: number of angles in mon '',A,'' for mod '',A,'' = 0''
c     *)') L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LG=1,L1G_NANGL
              IF( ((ATM1.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG)) 
     *                                   .AND.(ATM3.EQ.L1G_3ATM(LG))) 
     *        .OR.((ATM3.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG))
     *                                   .AND.(ATM1.EQ.L1G_3ATM(LG)))) 
     *          THEN
                L1G_1ATM(LG)='    '
                L1G_2ATM(LG)='    '
                L1G_3ATM(LG)='    '
                IDEL=1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1G_NANGL.LE.0) THEN
c              WRITE(LINE,'(
c     *'' WARNING: number of angles in mon '',A,'' for mod '',A,'' = 0''
c     *)')     L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LG=1,L1G_NANGL
              IF( ((ATM1.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG)) 
     *                                   .AND.(ATM3.EQ.L1G_3ATM(LG))) 
     *        .OR.((ATM3.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG))
     *                                   .AND.(ATM1.EQ.L1G_3ATM(LG)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1G_VAL (LG)  = VAL
                IF(ABS(VOBS).GT.0.0) L1G_VOBS(LG)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1G_DEV (LG)  = DEV
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1G_NANGL.GT.MAX1ANG) THEN
          WRITE(LINE,'(3A,I6)')' WARNING: number of angles in monomer ',
     *        L1L_MNAME,' for mod  >',MAX1ANG
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1G_NANGL.GT.0) THEN
            DO LG=1,L1G_NANGL
              IF( ((ATM1.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG)) 
     *                                   .AND.(ATM3.EQ.L1G_3ATM(LG))) 
     *        .OR.((ATM3.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG))
     *                                   .AND.(ATM1.EQ.L1G_3ATM(LG)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1G_VAL (LG)  = VAL
                IF(ABS(VOBS).GT.0.0) L1G_VOBS(LG)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1G_DEV (LG)  = DEV
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1G_NANGL = L1G_NANGL+1

            L1G_I1ATM(L1G_NANGL) = 0
            L1G_I2ATM(L1G_NANGL) = 0
            L1G_I3ATM(L1G_NANGL) = 0
            L1G_1ATM (L1G_NANGL) = ATM1 
            L1G_2ATM (L1G_NANGL) = ATM2
            L1G_3ATM (L1G_NANGL) = ATM3
            L1G_FLAG (L1G_NANGL) = ' '
            L1G_VOBS (L1G_NANGL) = VOBS  
            L1G_VAL  (L1G_NANGL) = VAL 
            L1G_DEV  (L1G_NANGL) = DEV 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_TMLIB(MDOC,MOD,IT,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_TMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IT,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VAL,VOBS,DEV
      INTEGER   IPRD
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4,LABEL*8
C -----------------------------------
      IERR = 0
      IF(LDT_NTORS.LE.0.OR.LDT_NTORS.LT.IT.OR.IT.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of tors in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IT,LDT_NTORS
        IF(MOD.EQ.LDT_MNAME(L)) THEN
          FUNCT = LDT_FUNCT(L)
          ATM1  = LDT_1ATM (L)
          ATM2  = LDT_2ATM (L)
          ATM3  = LDT_3ATM (L)
          ATM4  = LDT_4ATM (L)
          VAL   = LDT_VAL  (L)
          VOBS  = LDT_VOBS (L)
          DEV   = LDT_DEV  (L)
          IPRD  = LDT_PRD  (L)
          LABEL = LDT_LABEL(L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1T_NTORS.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LT=1,L1T_NTORS
              IF((ATM1.EQ.L1T_1ATM(LT).AND.ATM2.EQ.L1T_2ATM(LT).AND. 
     *            ATM3.EQ.L1T_3ATM(LT).AND.ATM4.EQ.L1T_4ATM(LT) )    
     *       .OR.(ATM4.EQ.L1T_1ATM(LT).AND.ATM3.EQ.L1T_2ATM(LT).AND.
     *            ATM2.EQ.L1T_3ATM(LT).AND.ATM1.EQ.L1T_4ATM(LT) ) ) THEN 
                L1T_1ATM(LT)='    '
                L1T_2ATM(LT)='    '
                L1T_3ATM(LT)='    '
                L1T_4ATM(LT)='    '
                IDEL = 1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1T_NTORS.LE.0) THEN
              IERR=0
              GO TO 100
            ENDIF
            DO LT=1,L1T_NTORS
              IF((ATM1.EQ.L1T_1ATM(LT).AND.ATM2.EQ.L1T_2ATM(LT).AND. 
     *            ATM3.EQ.L1T_3ATM(LT).AND.ATM4.EQ.L1T_4ATM(LT) )    
     *       .OR.(ATM4.EQ.L1T_1ATM(LT).AND.ATM3.EQ.L1T_2ATM(LT).AND.
     *            ATM2.EQ.L1T_3ATM(LT).AND.ATM1.EQ.L1T_4ATM(LT) ) ) THEN 
                IF(ABS(VAL)  .GT.0.0) L1T_VAL  (LT) = VAL
                IF(ABS(VOBS) .GT.0.0) L1T_VOBS (LT) = VOBS
                IF(ABS(DEV)  .GT.0.0) L1T_DEV  (LT) = DEV
                                      L1T_PRD  (LT) = IPRD
                IF(LABEL(1:1).NE.'.') L1T_LABEL(LT) = LABEL
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1T_NTORS.GT.MAX1TOR) THEN
          WRITE(LINE,'(3A,I6)')' WARNING: number of tors in monomer ',
     *        L1L_MNAME,' for mod  >',MAX1TOR
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1TOR in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1T_NTORS.GT.0) THEN
            DO LT=1,L1T_NTORS
              IF((ATM1.EQ.L1T_1ATM(LT).AND.ATM2.EQ.L1T_2ATM(LT).AND. 
     *            ATM3.EQ.L1T_3ATM(LT).AND.ATM4.EQ.L1T_4ATM(LT) )    
     *       .OR.(ATM4.EQ.L1T_1ATM(LT).AND.ATM3.EQ.L1T_2ATM(LT).AND.
     *            ATM2.EQ.L1T_3ATM(LT).AND.ATM1.EQ.L1T_4ATM(LT) ) ) THEN 
                IF(ABS(VAL)  .GT.0.0) L1T_VAL  (LT) = VAL
                IF(ABS(VOBS) .GT.0.0) L1T_VOBS (LT) = VOBS
                IF(ABS(DEV)  .GT.0.0) L1T_DEV  (LT) = DEV
                                      L1T_PRD  (LT) = IPRD
                IF(LABEL(1:1).NE.'.') L1T_LABEL(LT) = LABEL
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1T_NTORS = L1T_NTORS+1

            L1T_I1ATM(L1T_NTORS) = 0
            L1T_I2ATM(L1T_NTORS) = 0
            L1T_I3ATM(L1T_NTORS) = 0
            L1T_I4ATM(L1T_NTORS) = 0
            L1T_1ATM (L1T_NTORS) = ATM1 
            L1T_2ATM (L1T_NTORS) = ATM2
            L1T_3ATM (L1T_NTORS) = ATM3
            L1T_4ATM (L1T_NTORS) = ATM4
            L1T_FLAG (L1T_NTORS) = ' '
            L1T_VOBS (L1T_NTORS) = VOBS  
            L1T_VAL  (L1T_NTORS) = VAL 
            L1T_DEV  (L1T_NTORS) = DEV 
            L1T_LABEL(L1T_NTORS) = LABEL 
            L1T_PRD  (L1T_NTORS) = IPRD 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_CMLIB(MDOC,MOD,IC,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_CMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IC,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VOL
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4,SIGN*8
      CHARACTER ATM5*4,ATM6*4,ATM7*4,ATM8*4,ATM9*4
C -----------------------------------
      IERR = 0
      IF(LDC_NCHIR.LE.0.OR.LDC_NCHIR.LT.IC.OR.IC.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of CHIR in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IC,LDC_NCHIR
        IF(MOD.EQ.LDC_MNAME(L)) THEN
          FUNCT = LDC_FUNCT(L)
          ATM1  = LDC_1ATM (L)
          ATM2  = LDC_2ATM (L)
          ATM3  = LDC_3ATM (L)
          ATM4  = LDC_4ATM (L)
          ATM5  = LDC_5ATM (L)
          ATM6  = LDC_6ATM (L)
          ATM7  = LDC_7ATM (L)
          ATM8  = LDC_8ATM (L)
          ATM9  = LDC_9ATM (L)
          VOL   = LDC_VOL  (L)
          SIGN  = LDC_SIGN (L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1C_NCHIR.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LC=1,L1C_NCHIR
              IF(((ATM1.EQ.L1C_1ATM(LC).AND.ATM2.EQ.L1C_2ATM(LC).AND. 
     *            ATM3.EQ.L1C_3ATM(LC).AND.ATM4.EQ.L1C_4ATM(LC) )    
     *       .OR.(ATM4.EQ.L1C_1ATM(LC).AND.ATM3.EQ.L1C_2ATM(LC).AND.
     *            ATM2.EQ.L1C_3ATM(LC).AND.ATM1.EQ.L1C_4ATM(LC) ) ) 
     *       .OR.(ATM1.EQ.L1C_1ATM(LC).AND.
     *                    L1C_SIGN(LC)(1:4).EQ.'cros')) THEN
                L1C_1ATM(LC)='.   '
                L1C_2ATM(LC)='.   '
                L1C_3ATM(LC)='.   '
                L1C_4ATM(LC)='.   '
                L1C_5ATM(LC)='.   '
                L1C_6ATM(LC)='.   '
                L1C_7ATM(LC)='.   '
                L1C_8ATM(LC)='.   '
                L1C_9ATM(LC)='.   '
                IDEL = 1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1C_NCHIR.LE.0) THEN
              IERR=0
              GO TO 100
            ENDIF
            DO LC=1,L1C_NCHIR
              IF(((ATM1.EQ.L1C_1ATM(LC).AND.ATM2.EQ.L1C_2ATM(LC).AND. 
     *            ATM3.EQ.L1C_3ATM(LC).AND.ATM4.EQ.L1C_4ATM(LC) )    
     *       .OR.(ATM4.EQ.L1C_1ATM(LC).AND.ATM3.EQ.L1C_2ATM(LC).AND.
     *           (ATM2.EQ.L1C_3ATM(LC).AND.ATM1.EQ.L1C_4ATM(LC) ) ) )
     *       .OR.(ATM1.EQ.L1C_1ATM(LC).AND.
     *                    SIGN(1:4).EQ.'cros')) THEN
                IF(ABS(VOL)  .GT.0.0) L1C_VOL  (LC) = VOL
                IF(SIGN(1:1).NE.'.')  L1C_SIGN (LC) = SIGN
                IF(SIGN(1:4).EQ.'cros') THEN
                  L1C_I2ATM(LC) = 0
                  L1C_I3ATM(LC) = 0
                  L1C_I4ATM(LC) = 0
                  L1C_I5ATM(LC) = 0
                  L1C_I6ATM(LC) = 0
                  L1C_I7ATM(LC) = 0
                  L1C_I8ATM(LC) = 0
                  L1C_I9ATM(LC) = 0
                  L1C_2ATM (LC) = ATM2
                  L1C_3ATM (LC) = ATM3
                  L1C_4ATM (LC) = ATM4
                  L1C_5ATM (LC) = ATM5 
                  L1C_6ATM (LC) = ATM6
                  L1C_7ATM (LC) = ATM7
                  L1C_8ATM (LC) = ATM8
                  L1C_9ATM (LC) = ATM9
                ENDIF 
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1C_NCHIR.GT.MAX1CHR) THEN
          WRITE(LINE,'(3A,I6)')' WARNING: number of chir. in monomer ',
     *     L1L_MNAME,' for mod  >',MAX1CHR
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1CHR in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1C_NCHIR.GT.0) THEN
            DO LC=1,L1C_NCHIR
              IF((ATM1.EQ.L1C_1ATM(LC).AND.ATM2.EQ.L1C_2ATM(LC).AND. 
     *            ATM3.EQ.L1C_3ATM(LC).AND.ATM4.EQ.L1C_4ATM(LC) )    
     *       .OR.(ATM4.EQ.L1C_1ATM(LC).AND.ATM3.EQ.L1C_2ATM(LC).AND.
     *            ATM2.EQ.L1C_3ATM(LC).AND.ATM1.EQ.L1C_4ATM(LC) ) ) THEN 
                IF(ABS(VOL)  .GT.0.0) L1C_VOL  (LC) = VOL
                IF(SIGN(1:1).NE.'.')  L1C_SIGN (LC) = SIGN
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1C_NCHIR = L1C_NCHIR+1

            L1C_I1ATM(L1C_NCHIR) = 0
            L1C_I2ATM(L1C_NCHIR) = 0
            L1C_I3ATM(L1C_NCHIR) = 0
            L1C_I4ATM(L1C_NCHIR) = 0
            L1C_I5ATM(L1C_NCHIR) = 0
            L1C_I6ATM(L1C_NCHIR) = 0
            L1C_I7ATM(L1C_NCHIR) = 0
            L1C_I8ATM(L1C_NCHIR) = 0
            L1C_I9ATM(L1C_NCHIR) = 0
            L1C_1ATM (L1C_NCHIR) = ATM1 
            L1C_2ATM (L1C_NCHIR) = ATM2
            L1C_3ATM (L1C_NCHIR) = ATM3
            L1C_4ATM (L1C_NCHIR) = ATM4
            L1C_5ATM (L1C_NCHIR) = ATM5 
            L1C_6ATM (L1C_NCHIR) = ATM6
            L1C_7ATM (L1C_NCHIR) = ATM7
            L1C_8ATM (L1C_NCHIR) = ATM8
            L1C_9ATM (L1C_NCHIR) = ATM9
            L1C_FLAG (L1C_NCHIR) = ' '
            L1C_VOL  (L1C_NCHIR) = VOL 
            L1C_SIGN (L1C_NCHIR) = SIGN 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_PMLIB(MDOC,MOD,IP,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_PMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IP,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
C     REAL      VOL
      CHARACTER LINE*256,FUNCT*8,LABEL*8
C     CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4,SIGN*8
C -----------------------------------
      IERR = 0
      IF(LDP_NPLAN.LE.0.OR.LDP_NPLAN.LT.IP.OR.IP.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of PLAN in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IP,LDP_NPLAN
        IF(MOD.EQ.LDP_MNAME(L)) THEN

          FUNCT = LDP_FUNCT(L)
          LABEL = LDP_LABEL(L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1P_NPLAN.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LP=1,L1P_NPLAN
              IF(LABEL.EQ.L1P_LABEL(LP)) THEN 
                IF(LDP_NATOM(L).GT.0.AND.L1P_NATOM(LP).GT.0) THEN
                  DO IA=1,LDP_NATOM(L)
                    DO IA1=1,L1P_NATOM(LP)
                      IF(LDP_ATOM(IA,L).EQ.L1P_ATOM(IA1,LP)) THEN
                        L1P_ATOM(IA1,LP) = 0
                        IDEL = 1
                      ENDIF
                    ENDDO
                  ENDDO
                ENDIF
                GO TO 100  
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
C           change only L1P_DEV
            IF(L1P_NPLAN.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LP=1,L1P_NPLAN
              IF(LABEL.EQ.L1P_LABEL(LP)) THEN 
                IF(LDP_NATOM(L).GT.0.AND.L1P_NATOM(LP).GT.0) THEN
                  DO IA=1,LDP_NATOM(L)
                    DO IA1=1,L1P_NATOM(LP)
                      IF(LDP_ATOM(IA,L).EQ.L1P_ATOM(IA1,LP)) THEN
                        L1P_DEV(IA1,LP) = LDP_DEV(IA,L)
                      ENDIF
                    ENDDO
                  ENDDO
                ENDIF
                GO TO 100  
              ENDIF
            ENDDO

          ELSE IF(FUNCT(1:3).EQ.'add') THEN
C           only add new plan
            IF(L1P_NPLAN+1.GT.MAX1PLN) THEN
         WRITE(LINE,'(3A,I6)')' ERR: number of planar groups for mod '
     *        ,MOD,' >',MAX1PLN
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *   '           Change parameter MAX1PLN in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF

            IF(LDP_NATOM(L).GT.MAX1APL-4) THEN
             WRITE(LINE,'(3A,I6)')' ERR: number of plan atoms in mod '
     *        ,MOD,' >',MAX1APL
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *   '           Change parameter MAX1APL in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF
            IF(LDP_NATOM(L).LE.3) THEN
              WRITE(LINE,'(3A)')
     *        ' WARNING: number of plan atoms in mod '
     *        ,MOD,'  < 4'
              CALL MSGERR(MDOC,LINE)
              RETURN
            ENDIF

            L1P_NPLAN = L1P_NPLAN+1
            L1P_NATOM (L1P_NPLAN) = LDP_NATOM(L)
            L1P_LABEL (L1P_NPLAN) = LDP_LABEL(L)
            DO   I=1,L1P_NATOM(L1P_NPLAN)
              L1P_FLAG  (I,L1P_NPLAN) = 0
              L1P_DOBS  (I,L1P_NPLAN) = 0.0
              L1P_EDEV  (I,L1P_NPLAN) = 0.0
              L1P_IATOM (I,L1P_NPLAN) = 0
              L1P_DEV   (I,L1P_NPLAN) = LDP_DEV (I,L)
              L1P_ATOM  (I,L1P_NPLAN) = LDP_ATOM(I,L)
            ENDDO  
            IDEL = 1
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE SET_NUM_L1_GM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          L1B_I1ATM(I) = 0 
          L1B_I2ATM(I) = 0 
        ENDDO
      ENDIF
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          L1N_I1ATM(I) = 0
          L1N_I2ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1G_NANGL.GT.0) THEN
        DO I=1,L1G_NANGL
          L1G_I1ATM(I) = 0
          L1G_I2ATM(I) = 0
          L1G_I3ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1T_NTORS.GT.0) THEN 
        DO I=1,L1T_NTORS 
          L1T_I1ATM(I) = 0 
          L1T_I2ATM(I) = 0 
          L1T_I3ATM(I) = 0 
          L1T_I4ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1C_NCHIR.GT.0) THEN 
        DO I=1,L1C_NCHIR 
          L1C_I1ATM(I) = 0
          L1C_I2ATM(I) = 0 
          L1C_I3ATM(I) = 0 
          L1C_I4ATM(I) = 0
          L1C_I5ATM(I) = 0
          L1C_I6ATM(I) = 0 
          L1C_I7ATM(I) = 0 
          L1C_I8ATM(I) = 0
          L1C_I9ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1P_NPLAN.GT.0) THEN
        DO I=1,L1P_NPLAN 
          IF(L1P_NATOM(I).GT.0) THEN
            DO J=1,L1P_NATOM(I)
              L1P_IATOM(J,I) = 0
            ENDDO
          ENDIF
        ENDDO
      ENDIF
C --
      DO IA=1,L1A_NATOM
        ATOM = L1A_ANAME(IA)
C --    
        DO JA=1,L1A_NATOM
          IF(L1A_BACK(JA).EQ.ATOM) L1A_IBACK(JA) = IA
          IF(L1A_FORW(JA).EQ.ATOM) L1A_IFORW(JA) = IA
        ENDDO
        IF(L1N_NCONN.GT.0) THEN
          DO I=1,L1N_NCONN
            IF(L1N_1ATM(I).EQ.ATOM) L1N_I1ATM(I) = IA
            IF(L1N_2ATM(I).EQ.ATOM) L1N_I2ATM(I) = IA
          ENDDO
        ENDIF
        IF(L1B_NBOND.GT.0) THEN 
          DO I=1,L1B_NBOND
            IF(L1B_1ATM(I).EQ.ATOM) L1B_I1ATM(I) = IA 
            IF(L1B_2ATM(I).EQ.ATOM) L1B_I2ATM(I) = IA 
          ENDDO
        ENDIF
        IF(L1G_NANGL.GT.0) THEN
          DO I=1,L1G_NANGL
            IF(L1G_1ATM(I).EQ.ATOM) L1G_I1ATM(I) = IA
            IF(L1G_2ATM(I).EQ.ATOM) L1G_I2ATM(I) = IA
            IF(L1G_3ATM(I).EQ.ATOM) L1G_I3ATM(I) = IA
          ENDDO
        ENDIF
        IF(L1T_NTORS.GT.0) THEN 
          DO I=1,L1T_NTORS 
            IF(L1T_1ATM(I).EQ.ATOM) L1T_I1ATM(I) = IA 
            IF(L1T_2ATM(I).EQ.ATOM) L1T_I2ATM(I) = IA 
            IF(L1T_3ATM(I).EQ.ATOM) L1T_I3ATM(I) = IA 
            IF(L1T_4ATM(I).EQ.ATOM) L1T_I4ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L1C_NCHIR.GT.0) THEN 
          DO I=1,L1C_NCHIR 
            IF(L1C_1ATM(I).EQ.ATOM) L1C_I1ATM(I) = IA 
            IF(L1C_2ATM(I).EQ.ATOM) L1C_I2ATM(I) = IA 
            IF(L1C_3ATM(I).EQ.ATOM) L1C_I3ATM(I) = IA 
            IF(L1C_4ATM(I).EQ.ATOM) L1C_I4ATM(I) = IA 
            IF(L1C_5ATM(I).EQ.ATOM) L1C_I5ATM(I) = IA 
            IF(L1C_6ATM(I).EQ.ATOM) L1C_I6ATM(I) = IA 
            IF(L1C_7ATM(I).EQ.ATOM) L1C_I7ATM(I) = IA 
            IF(L1C_8ATM(I).EQ.ATOM) L1C_I8ATM(I) = IA 
            IF(L1C_9ATM(I).EQ.ATOM) L1C_I9ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L1P_NPLAN.GT.0) THEN
          DO I=1,L1P_NPLAN 
            IF(L1P_NATOM(I).GT.0) THEN
              DO J=1,L1P_NATOM(I)
                ICH4 = L1P_ATOM(J,I)
                IF(CH4.EQ.ATOM) L1P_IATOM(J,I) = IA
              ENDDO
            ENDIF
          ENDDO
        ENDIF
C ---
      ENDDO
C ----
      RETURN
      END   

      SUBROUTINE SET_NUM_L2_GM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------
      IF(L2B_NBOND.GT.0) THEN 
        DO I=1,L2B_NBOND
          L2B_I1ATM(I) = 0 
          L2B_I2ATM(I) = 0 
        ENDDO
      ENDIF
      IF(L2N_NCONN.GT.0) THEN
        DO I=1,L2N_NCONN
          L2N_I1ATM(I) = 0
          L2N_I2ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2G_NANGL.GT.0) THEN
        DO I=1,L2G_NANGL
          L2G_I1ATM(I) = 0
          L2G_I2ATM(I) = 0
          L2G_I3ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2T_NTORS.GT.0) THEN 
        DO I=1,L2T_NTORS 
          L2T_I1ATM(I) = 0 
          L2T_I2ATM(I) = 0 
          L2T_I3ATM(I) = 0 
          L2T_I4ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2C_NCHIR.GT.0) THEN 
        DO I=1,L2C_NCHIR 
          L2C_I1ATM(I) = 0
          L2C_I2ATM(I) = 0 
          L2C_I3ATM(I) = 0 
          L2C_I4ATM(I) = 0
          L2C_I5ATM(I) = 0
          L2C_I6ATM(I) = 0 
          L2C_I7ATM(I) = 0 
          L2C_I8ATM(I) = 0
          L2C_I9ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2P_NPLAN.GT.0) THEN
        DO I=1,L2P_NPLAN 
          IF(L2P_NATOM(I).GT.0) THEN
            DO J=1,L2P_NATOM(I)
              L2P_IATOM(J,I) = 0
            ENDDO
          ENDIF
        ENDDO
      ENDIF
C --
      DO IA=1,L2A_NATOM
        ATOM = L2A_ANAME(IA)
C --    
        DO JA=1,L2A_NATOM
          IF(L2A_BACK(JA).EQ.ATOM) L2A_IBACK(JA) = IA
          IF(L2A_FORW(JA).EQ.ATOM) L2A_IFORW(JA) = IA
        ENDDO
        IF(L2N_NCONN.GT.0) THEN
          DO I=1,L2N_NCONN
            IF(L2N_1ATM(I).EQ.ATOM) L2N_I1ATM(I) = IA
            IF(L2N_2ATM(I).EQ.ATOM) L2N_I2ATM(I) = IA
          ENDDO
        ENDIF
        IF(L2B_NBOND.GT.0) THEN 
          DO I=1,L2B_NBOND
            IF(L2B_1ATM(I).EQ.ATOM) L2B_I1ATM(I) = IA 
            IF(L2B_2ATM(I).EQ.ATOM) L2B_I2ATM(I) = IA 
          ENDDO
        ENDIF
        IF(L2G_NANGL.GT.0) THEN
          DO I=1,L2G_NANGL
            IF(L2G_1ATM(I).EQ.ATOM) L2G_I1ATM(I) = IA
            IF(L2G_2ATM(I).EQ.ATOM) L2G_I2ATM(I) = IA
            IF(L2G_3ATM(I).EQ.ATOM) L2G_I3ATM(I) = IA
          ENDDO
        ENDIF
        IF(L2T_NTORS.GT.0) THEN 
          DO I=1,L2T_NTORS 
            IF(L2T_1ATM(I).EQ.ATOM) L2T_I1ATM(I) = IA 
            IF(L2T_2ATM(I).EQ.ATOM) L2T_I2ATM(I) = IA 
            IF(L2T_3ATM(I).EQ.ATOM) L2T_I3ATM(I) = IA 
            IF(L2T_4ATM(I).EQ.ATOM) L2T_I4ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L2C_NCHIR.GT.0) THEN 
          DO I=1,L2C_NCHIR 
            IF(L2C_1ATM(I).EQ.ATOM) L2C_I1ATM(I) = IA 
            IF(L2C_2ATM(I).EQ.ATOM) L2C_I2ATM(I) = IA 
            IF(L2C_3ATM(I).EQ.ATOM) L2C_I3ATM(I) = IA 
            IF(L2C_4ATM(I).EQ.ATOM) L2C_I4ATM(I) = IA 
            IF(L2C_5ATM(I).EQ.ATOM) L2C_I5ATM(I) = IA 
            IF(L2C_6ATM(I).EQ.ATOM) L2C_I6ATM(I) = IA 
            IF(L2C_7ATM(I).EQ.ATOM) L2C_I7ATM(I) = IA 
            IF(L2C_8ATM(I).EQ.ATOM) L2C_I8ATM(I) = IA 
            IF(L2C_9ATM(I).EQ.ATOM) L2C_I9ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L2P_NPLAN.GT.0) THEN
          DO I=1,L2P_NPLAN 
            IF(L2P_NATOM(I).GT.0) THEN
              DO J=1,L2P_NATOM(I)
                ICH4 = L2P_ATOM(J,I)
                IF(CH4.EQ.ATOM) L2P_IATOM(J,I) = IA
              ENDDO
            ENDIF
          ENDDO
        ENDIF
C ---
      ENDDO
C ----
      RETURN
      END

      SUBROUTINE COMPRESS_L1_GM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------
      NA = 0
      DO IATM=1,L1A_NATOM
        IF(L1A_ANAME(IATM).NE.'????'.AND.
     *     L1A_ICR(IATM).NE.0) THEN
         NA = NA + 1
          L1A_CHARG (NA) = L1A_CHARG (IATM)
          L1A_X     (NA) = L1A_X     (IATM)
          L1A_Y     (NA) = L1A_Y     (IATM)
          L1A_Z     (NA) = L1A_Z     (IATM)
          L1A_LENGTH(NA) = L1A_LENGTH(IATM)
          L1A_THETA (NA) = L1A_THETA (IATM)
          L1A_PHI   (NA) = L1A_PHI   (IATM)
          L1A_NRING (NA) = L1A_NRING (IATM)
          L1A_INEW  (NA) = L1A_INEW  (IATM)
          L1A_IOLD  (NA) = L1A_IOLD  (IATM)
          L1A_ICR   (NA) = L1A_ICR   (IATM)
          L1A_IBACK (NA) = L1A_IBACK (IATM)
          L1A_IFORW (NA) = L1A_IFORW (IATM)
          L1A_NDIST (NA) = L1A_NDIST (IATM)
          L1A_NEXTR (NA) = L1A_NEXTR (IATM)
          L1A_ICHEM (NA) = L1A_ICHEM (IATM)
          L1A_SF_ID (NA) = L1A_SF_ID (IATM)
          L1A_ID_PSI(NA) = L1A_ID_PSI(IATM)
          L1A_SYMB  (NA) = L1A_SYMB  (IATM)
          L1A_ATYPE (NA) = L1A_ATYPE (IATM)
          L1A_ANAME (NA) = L1A_ANAME (IATM)
          L1A_TYPE  (NA) = L1A_TYPE  (IATM)
          L1A_BACK  (NA) = L1A_BACK  (IATM)
          L1A_FORW  (NA) = L1A_FORW  (IATM)
          L1A_CHEM  (NA) = L1A_CHEM  (IATM)
          L1A_COOR_FLAG(NA) = L1A_COOR_FLAG(IATM)  
        ENDIF
      ENDDO
      L1A_NATOM = NA
C --    
      NC = 0
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          IF(L1N_1ATM(I).NE.'????'.AND.L1N_2ATM(I).NE.'????'.AND.
     *       L1N_I1ATM(I).NE.0.AND.L1N_I2ATM(I).NE.0) THEN
            NC = NC + 1
            L1N_I1ATM (NC) = L1N_I1ATM (I)
            L1N_I2ATM (NC) = L1N_I2ATM (I)
            L1N_1ATM  (NC) = L1N_1ATM  (I)
            L1N_2ATM  (NC) = L1N_2ATM  (I)
            L1N_TYPE  (NC) = L1N_TYPE  (I)
          ENDIF
        ENDDO
      ENDIF
      L1N_NCONN = NC
C --
      NB = 0
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          IF(L1B_1ATM(I).NE.'????'.AND.L1B_2ATM(I).NE.'????'.AND.
     *       L1B_I1ATM(I).NE.0.AND.L1B_I2ATM(I).NE.0) THEN
            NB = NB + 1
            L1B_I1ATM (NB) = L1B_I1ATM (I)
            L1B_I2ATM (NB) = L1B_I2ATM (I)
            L1B_1ATM  (NB) = L1B_1ATM  (I)
            L1B_2ATM  (NB) = L1B_2ATM  (I)
            L1B_TYPE  (NB) = L1B_TYPE  (I)
            L1B_FLAG  (NB) = L1B_FLAG  (I) 
            L1B_VAL   (NB) = L1B_VAL   (I)
            L1B_DEV   (NB) = L1B_DEV   (I)
            L1B_VOBS  (NB) = L1B_VOBS  (I) 
            L1B_EVAL  (NB) = L1B_EVAL  (I)
          ENDIF
        ENDDO
      ENDIF
      L1B_NBOND = NB
C ---
      NG = 0
      IF(L1G_NANGL.GT.0) THEN
        DO I=1,L1G_NANGL
          IF(L1G_1ATM(I).NE.'????'.AND.L1G_2ATM(I).NE.'????'.AND.
     *                                 L1G_3ATM(I).NE.'????'.AND.
     *       L1G_I1ATM(I).NE.0.AND.L1G_I2ATM(I).NE.0.AND.
     *                                 L1G_I3ATM(I).NE.0     ) THEN
            NG = NG + 1
            L1G_I1ATM (NG) = L1G_I1ATM (I)
            L1G_I2ATM (NG) = L1G_I2ATM (I)
            L1G_I3ATM (NG) = L1G_I3ATM (I)
            L1G_1ATM  (NG) = L1G_1ATM  (I)
            L1G_2ATM  (NG) = L1G_2ATM  (I)
            L1G_3ATM  (NG) = L1G_3ATM  (I)
            L1G_VAL   (NG) = L1G_VAL   (I)
            L1G_VOBS  (NG) = L1G_VOBS  (I)
            L1G_DEV   (NG) = L1G_DEV   (I)
            L1G_EVAL  (NG) = L1G_EVAL  (I) 
          ENDIF
        ENDDO
      ENDIF
      L1G_NANGL = NG
C ---
      NT = 0
      IF(L1T_NTORS.GT.0) THEN 
        DO I=1,L1T_NTORS 
          IF(L1T_1ATM(I).NE.'????'.AND.L1T_2ATM(I).NE.'????'.AND.
     *       L1T_3ATM(I).NE.'????'.AND.L1T_4ATM(I).NE.'????'.AND.
     *       L1T_I1ATM(I).NE.0.AND.L1T_I2ATM(I).NE.0.AND.
     *       L1T_I3ATM(I).NE.0.AND.L1T_I4ATM(I).NE.0     ) THEN
            NT = NT + 1
            L1T_1ATM  (NT) = L1T_1ATM  (I) 
            L1T_2ATM  (NT) = L1T_2ATM  (I)
            L1T_3ATM  (NT) = L1T_3ATM  (I)
            L1T_4ATM  (NT) = L1T_4ATM  (I)
            L1T_LABEL (NT) = L1T_LABEL (I)
            L1T_FLAG  (NT) = L1T_FLAG  (I)
            L1T_VAL   (NT) = L1T_VAL   (I)
            L1T_DEV   (NT) = L1T_DEV   (I) 
            L1T_VOBS  (NT) = L1T_VOBS  (I)
            L1T_EVAL  (NT) = L1T_EVAL  (I)
            L1T_PRD   (NT) = L1T_PRD   (I)
            L1T_I1ATM (NT) = L1T_I2ATM (I)
            L1T_I2ATM (NT) = L1T_I2ATM (I)
            L1T_I3ATM (NT) = L1T_I3ATM (I)
            L1T_I4ATM (NT) = L1T_I4ATM (I)
          ENDIF
        ENDDO
      ENDIF
      L1T_NTORS = NT
C ---
      NC = 0
      IF(L1C_NCHIR.GT.0) THEN 
        DO I=1,L1C_NCHIR 
          IF(L1C_1ATM(I).NE.'????'.AND.L1C_2ATM(I).NE.'????'.AND.
     *       L1C_3ATM(I).NE.'????'.AND.L1C_4ATM(I).NE.'????'.AND.
     *       L1C_I1ATM(I).NE.0) THEN 
            IF((L1C_SIGN(I)(1:4).EQ.'cros').or.(L1C_I2ATM(I).NE.0
     *         .AND.L1C_I3ATM(I).NE.0.AND.L1C_I4ATM(I).NE.0)) THEN
              NC = NC + 1
              L1C_I1ATM (NC) = L1C_I1ATM (I) 
              L1C_I2ATM (NC) = L1C_I2ATM (I)
              L1C_I3ATM (NC) = L1C_I3ATM (I) 
              L1C_I4ATM (NC) = L1C_I4ATM (I)
              L1C_I5ATM (NC) = L1C_I5ATM (I) 
              L1C_I6ATM (NC) = L1C_I6ATM (I)
              L1C_I7ATM (NC) = L1C_I7ATM (I) 
              L1C_I8ATM (NC) = L1C_I8ATM (I)
              L1C_I9ATM (NC) = L1C_I9ATM (I)
              L1C_1ATM  (NC) = L1C_1ATM  (I)  
              L1C_2ATM  (NC) = L1C_2ATM  (I)
              L1C_3ATM  (NC) = L1C_3ATM  (I)
              L1C_4ATM  (NC) = L1C_4ATM  (I)
              L1C_5ATM  (NC) = L1C_5ATM  (I)  
              L1C_6ATM  (NC) = L1C_6ATM  (I)
              L1C_7ATM  (NC) = L1C_7ATM  (I)
              L1C_8ATM  (NC) = L1C_8ATM  (I)
              L1C_9ATM  (NC) = L1C_9ATM  (I)
              L1C_SIGN  (NC) = L1C_SIGN  (I)
              L1C_FLAG  (NC) = L1C_FLAG  (I)
              L1C_VOL   (NC) = L1C_VOL   (I)
              L1C_VOBS  (NC) = L1C_VOBS  (I)
              L1C_EVOL  (NC) = L1C_EVOL  (I)
            ENDIF
          ENDIF
        ENDDO
      ENDIF
      L1C_NCHIR = NC
C ---
      NP = 1
      IF(L1P_NPLAN.GT.0) THEN
        DO I=1,L1P_NPLAN 
          NPA = 0
          IF(L1P_NATOM(I).GT.0) THEN
            DO J=1,L1P_NATOM(I)
              IF(L1P_IATOM(J,I).GT.0) THEN
                NPA = NPA + 1
                L1P_IATOM (NPA,NP) = L1P_IATOM (J,I)
                L1P_ATOM  (NPA,NP) = L1P_ATOM  (J,I)
                L1P_FLAG  (NPA,NP) = L1P_FLAG  (J,I)
                L1P_DEV   (NPA,NP) = L1P_DEV   (J,I)
                L1P_DOBS  (NPA,NP) = L1P_DOBS  (J,I)
                L1P_EDEV  (NPA,NP) = L1P_EDEV  (J,I) 
              ENDIF
            ENDDO
            IF(NPA.GE.4) THEN 
              L1P_LABEL (NP) = L1P_LABEL (I)
              L1P_NATOM (NP) = NPA
              NP = NP + 1
            ENDIF
          ENDIF
        ENDDO
      ENDIF
      L1P_NPLAN = NP - 1 
C ----
      RETURN
      END   
