C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE RIGID_BODY
      IMPLICIT NONE
C
C---Refienement by rigid body
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'agreem.fh'

      INTEGER MCOLS
      PARAMETER (MCOLS = 200)
      REAL ROT_RIGID,RIGID_TRANS,RIGID_ALPHA,TGRAV
      INTEGER IGROUP

      COMMON /some_rigid/ IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN)
      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
c
      INTEGER LREMAIN
      PARAMETER (LREMAIN = 100)      
      real workspace(lremain)
      real, allocatable :: gx_rigid(:,:)
      real, allocatable :: hx_rigid(:,:,:)
      real, allocatable :: shft_rigid(:,:)

      real, allocatable :: gx_tls(:,:)
      real, allocatable :: hx_tls(:,:,:)
      real, allocatable :: shft_tls(:,:)

      real, allocatable :: t_tls(:,:)
      real, allocatable :: l_tls(:,:)
      real, allocatable :: s_tls(:,:)

      REAL TOLER
C---Local variables
      INTEGER ICYCL,IDOM,IWRITE_FIRST,IANALYSE_REST,NDOMAIN6,nmodel
      integer jj,i1,i2
      INTEGER I,J,IERROR
      REAL ALPHA,FXRAY_OLD,DELTA_SHIFTS,EPS_RIGID_CONVERGED
      LOGICAL LREFIN_SAVE,ALL_SCALE_SAVE,ERROR
      LOGICAL GAMMA_FLAG,STEP_FLAG
      REAL GAMMA,STEP
      CHARACTER MON_STYLE_SAVE*4,LINE*256
C
c assuming one model
      nmodel = 1
C---Convert atoms into orthogonal system
      HCALC_DIAG = .TRUE.
C
C---Define rigid body domains
      TOLER = 1.0E-7
      EPS_RIGID_CONVERGED = 1.0E-3
      CALL DEFINE_DOMAINS
      CALL FINDCGRAV
c

      allocate(gx_rigid(ndomain,6))
      allocate(hx_rigid(ndomain,6,6))
      allocate(shft_rigid(ndomain,6))

      allocate(gx_tls(ndomain,20))
      allocate(hx_tls(ndomain,20,20))
      allocate(shft_tls(ndomain,6))

C
c----Initialise
c      trans_init_rigid(1,1) = 1.0
c      trans_init_rigid(1,2) = -1.0
      DO IDOM=1,NDOMAIN
         SHFT_RIGID(idom,1) = TRANS_INIT_RIGID(1,IDOM)
         SHFT_RIGID(idom,2) = TRANS_INIT_RIGID(2,IDOM)
         SHFT_RIGID(idom,3) = TRANS_INIT_RIGID(3,IDOM)
         SHFT_RIGID(idom,4) = EULER_INIT_RIGID(1,IDOM)
         SHFT_RIGID(idom,5) = EULER_INIT_RIGID(2,IDOM) 
         SHFT_RIGID(idom,6) = EULER_INIT_RIGID(3,IDOM)
      ENDDO
      CALL APPLY_SHIFTS_RIGID(SHFT_RIGID,DELTA_SHIFTS)

C---These should go
      NDOMAIN6 = NDOMAIN*6
      MON_STYLE_SAVE = MON_STYLE
      DO    ICYCL=1,NRIGID_CYCLE
         WRITE(LINE,'(5x,A,I6)')'Rigid body cycle = ',ICYCL
         CALL ERRWRT(-1,' ')
         CALL ERRWRT(-1,LINE)
         CALL ERRWRT(-1,' ')
         IF(ICYCL.GT.1.AND.ICYCL.LT.NRIGID_CYCLE) THEN
            IF(MON_STYLE.EQ.'MEDI') MON_STYLE = 'FEW'
         ELSEIF(ICYCL.EQ.NRIGID_CYCLE) THEN
            MON_STYLE = MON_STYLE_SAVE
         ENDIF          
C
C---  Calculate derivatives wrt individual atomic parameters
         CALL REFALL(nmodel)
         CALL REPORT_XRAY_STATS
         FXRAY_OLD = FXRAY
c         write(*,*)'Functional value =',fxray
C
C---  Precondition rigid body params
         CALL PRECOND_RBODY
C
C---  Calculate derivatives wrt rigid body parameters using chain rule
c
c--Add tls components also
         CALL DERIVS_OF_RBODY(gx_rigid,hx_rigid)
C     
C---  Solve linear equations using eigenvalue filtering
C     
C---  Predondition ????
         do jj=1,ndomain
            call eigen_filter_r(toler,hx_rigid(jj,1:6,1:6),6,6,
     &           gx_rigid(jj,1:6),shft_rigid(jj,1:6),workspace,lremain)
c
c---  Add tls components

c            shft_rigid(jj,1:6) = 10.0*shft_rigid(jj,1:6)
         enddo

         CALL APPLY_SHIFTS_RIGID(SHFT_RIGID,DELTA_SHIFTS)
c
c---  Add tls components
         IF(MON_STYLE.EQ.'MANY'.OR.(MON_STYLE.NE.'NONE'.AND.
     +      ICYCL.EQ.NRIGID_CYCLE)) CALL PRINT_RIGIDPARS
      ENDDO
C
C---Write new mtz
 100  CONTINUE
c      IF(NLPRGO.NE.0) THEN
        LREFIN_SAVE = LREFIN
        LREFIN    = .FALSE.
        CALL REFALL(nmodel)
        CALL REPORT_XRAY_STATS
        LREFIN = LREFIN_SAVE
c      ENDIF
C
      deallocate(gx_rigid)
      deallocate(hx_rigid)
      deallocate(shft_rigid)
      deallocate(gx_tls)
      deallocate(hx_tls)
      deallocate(shft_tls)

      RETURN
      END
C
      SUBROUTINE PRECOND_RBODY
C
C---Preconditioning rigid body.
      RETURN
      END
         
      SUBROUTINE DERIVS_OF_RBODY(gx_rigid,hx_rigid)
      IMPLICIT NONE
C
C---Calculates derivatives of minimised function wrt domain parameters.
C---using chain rule. Neglects contribution of first derivative of function 
C---wrt (x,y,z) to second derviatives of fucntion wrt domain parameters.
C---Only diagonal terms of second derivative of function wrt (x,y,z) are
C---used
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'refi_flags.fh'
c
      real gx_rigid(ndomain,6),hx_rigid(ndomain,6,6)
c
      REAL ROT_RIGID,RIGID_TRANS,RIGID_ALPHA,TGRAV
      INTEGER IGROUP
      COMMON /some_rigid/ IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN)

      COMMON /REF_SPG/ GX,GU1,GQ,gu1_anom,gq_anom
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      real gu1_anom(6*maxatom),gq_anom(maxatom)
      INTEGER IA,IA1,IA2,NS_DIST(4),IVDW_TYPE,ISCRV,IFAIL,LL
      INTEGER IRIG1,IRIG2,IGR1,IGR2,IPAR,IPAR1,IPAR0,IPAR10,IDOMAIN
      integer idom,imod
      INTEGER IA11,IA12,IA21,IA22
      INTEGER IM,IV
      REAL WEIGHT
      REAL RS_VIDL,RS_SDI
      REAL DRDR1(3,6),DRDR2(3,6)
      REAL H_XXD,H_UUD(3),HQQD,H_UQD,H_QQD,X2DR(3)
      real h_uud_anom(3),h_uqd_anom,h_qqd_anom
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),
     &     H_BQ,H_QB,H_UQ(6),H_QU(6)
      REAL CC,TMP,HX2DR(3)
      LOGICAL ERROR
      INTEGER LENSTR,I_USED
      REAL DOT1_R
      EXTERNAL LENSTR,DOT1_R
C
C---Initialise
      gx_rigid(1:ndomain,1:6)     = 0.0
      hx_rigid(1:ndomain,1:6,1:6) = 0.0

C
C---Calculate derivatives of minimised function wrt domain
C---parameters using chain rule. 
      IV = 0
      IM = 0
      imod=1
      DO   IA=1,N_ATOM
        IF(ATOM_REF_mod_FLAG(IA,1).GT.0) THEN
          IRIG1 = IGROUP(IA)
          IA11 = ATOM_REF_mod_FLAG(IA,1)/10
          IA12 = ATOM_REF_mod_FLAG(IA,1)-IA11*10
          IF(IRIG1.GT.0.AND.IA12.GT.2) THEN
            CALL DERIVS_WRT_EULER1(XYZ_CRD_mod(1,IA,1),TGRAV(1,IRIG1),
     +        DRDR1)
            WEIGHT = 1.0
            IF(WEIGHT_DOMAIN(IRIG1).EQ.'MCHA') THEN
              IF(ATM_NAME(IA).EQ.'CA  '.OR.
     +           ATM_NAME(IA).EQ.'N   '.OR.
     +           ATM_NAME(IA).EQ.'C   '.OR.
     +           ATM_NAME(IA).EQ.'O   ')
     +               WEIGHT = WEIGHT_DOMAIN_VALUE(IRIG1)
            ELSEIF(WEIGHT_DOMAIN(IRIG1).EQ.'SCHA') THEN
              IF(ATM_NAME(IA).NE.'CA  '.AND.
     +           ATM_NAME(IA).NE.'N   '.AND.
     +           ATM_NAME(IA).NE.'C   '.AND.
     +           ATM_NAME(IA).NE.'O   ')
     +                 WEIGHT = WEIGHT_DOMAIN_VALUE(IRIG1)
            ENDIF
            CALL FAST_HESSIAN_DIAGONAL(IA,imod,H_XXD,H_UUD,H_UQD,H_QQD,
     &           h_uud_anom,h_uqd_anom,h_qqd_anom)  
            IPAR0   = 6*IRIG1-6
            DO   IPAR = 1,6
              IPAR0 = IPAR0 + 1
              gx_rigid(irig1,ipar) = gx_rigid(irig1,ipar) + 
     +                         (GX(IV+1)*DRDR1(1,IPAR)+
     +                          GX(IV+2)*DRDR1(2,IPAR)+
     +                          GX(IV+3)*DRDR1(3,IPAR))*WEIGHT
              IPAR10 = 6*IRIG1-6
              DO   IPAR1 = 1,6
                IPAR10 = IPAR10 + 1
                HX_RIGID(irig1,IPAR,IPAR1)=HX_RIGID(irig1,IPAR,IPAR1)+ 
     +          H_XXD*DOT1_R(3,3,DRDR1(1,IPAR),DRDR1(1,IPAR1))
     +                                               *WEIGHT**2
              ENDDO
            ENDDO
            IM = IM + 6
            IV = IV + 3
          ENDIF
        ENDIF
      ENDDO
C
C---Add distance block. Read from the file.
      RETURN
      END
C
      SUBROUTINE APPLY_SHIFTS_RIGID(SHFT_RIGID,DELTA_SHIFTS)
C
C---Applies translation and rotation (in euler angles) to get new 
C---coordinates.
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'rigid_body.fh'

      REAL SHFT_RIGID(ndomain,6)
      COMMON /some_rigid/ IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN)

      INTEGER IDOMAIN,I1,IA,IX
      REAL ROT_SHIFT(3,3),ROT_NEW(3,3),ROT_OLD(3,3),XYZ_1(3)
      REAL DELTA_SHIFTS
      REAL XYZ_OLD(3)
      LOGICAL ERROR
C
C---Convert Euler angles to rotation matrix
      DELTA_SHIFTS = 0.0
      DO   IDOMAIN=1,NDOMAIN
        DO   I=1,3
          TGRAV(I,IDOMAIN) = TGRAV(I,IDOMAIN) + SHFT_RIGID(idomain,i)
          RIGID_TRANS(I,IDOMAIN) = RIGID_TRANS(I,IDOMAIN) + 
     &                SHFT_RIGID(idomain,i)
        ENDDO
        CALL EUL2MATR(SHFT_RIGID(idomain,4),SHFT_RIGID(idomain,5),
     &   SHFT_RIGID(idomain,6),ROT_SHIFT)
        DO   IA = 1,N_ATOM
          IF(IGROUP(IA).EQ.IDOMAIN) THEN
            N_REFINED_RIGID = N_REFINED_RIGID + 1
            DO   IX = 1,3
             XYZ_OLD(IX) = XYZ_CRD_mod(IX,IA,1)
             I1 = ID1 + IX
             XYZ_CRD(IX,IA) = XYZ_CRD_mod(IX,IA,1) + 
     &         SHFT_RIGID(idomain,ix)
             XYZ_CRD_mod(IX,IA,1) = XYZ_CRD_mod(IX,IA,1) + 
     &         SHFT_RIGID(idomain,ix)
             XYZ_1(IX) = XYZ_CRD_mod(IX,IA,1) - TGRAV(IX,IDOMAIN)
            ENDDO
            CALL MAT2VEC(3,3,ROT_SHIFT,XYZ_1,XYZ_CRD_mod(1,IA,1),ERROR)
            DO   IX = 1,3
              XYZ_CRD(IX,IA) = XYZ_CRD_mod(IX,IA,1) + TGRAV(IX,IDOMAIN)
              XYZ_CRD_mod(IX,IA,1) = XYZ_CRD_mod(IX,IA,1) + 
     &          TGRAV(IX,IDOMAIN)
              DELTA_SHIFTS = AMAX1(DELTA_SHIFTS,
     &                  ABS(XYZ_CRD_mod(IX,IA,1)-XYZ_OLD(IX)))
            ENDDO
          ENDIF
        ENDDO
C
c---Now accumulate angular part
        CALL EUL2MATR(RIGID_ALPHA(1,IDOMAIN),RIGID_ALPHA(2,IDOMAIN),
     &         RIGID_ALPHA(3,IDOMAIN),ROT_OLD)
        CALL MAT2MAT(3,3,ROT_SHIFT,ROT_OLD,ROT_NEW,ERROR)
        CALL MATR2EUL_UNSAFE(ROT_NEW,RIGID_ALPHA(1,IDOMAIN),
     &      RIGID_ALPHA(2,IDOMAIN),RIGID_ALPHA(3,IDOMAIN))
       
      ENDDO
      RETURN
      END
C
C---Subroutines independent on include files

      SUBROUTINE DERIVS_WRT_EULER1(XYZ_CUR,XYZ_CENT,DXDDOMAIN)
      IMPLICIT NONE
C
C--Derivatives of the current atom wrt rigid body parameters.
C---Initial angles are assumed to be 0
C
      REAL XYZ_CUR(3),XYZ_CENT(3),DXDDOMAIN(3,6)
C
c----local variables
      REAL XYZ(3)
C
C---Derivatives wrt translational parameters      

      DXDDOMAIN(1,1) = 1.0
      DXDDOMAIN(2,1) = 0.0
      DXDDOMAIN(3,1) = 0.0
      DXDDOMAIN(1,2) = 0.0
      DXDDOMAIN(2,2) = 1.0
      DXDDOMAIN(3,2) = 0.0
      DXDDOMAIN(1,3) = 0.0
      DXDDOMAIN(2,3) = 0.0
      DXDDOMAIN(3,3) = 1.0
C
C---Derivatives of atomic positional parameters wrt rotational angles
      XYZ(1) = XYZ_CUR(1)-XYZ_CENT(1)
      XYZ(2) = XYZ_CUR(2)-XYZ_CENT(2)
      XYZ(3) = XYZ_CUR(3)-XYZ_CENT(3)

      DXDDOMAIN(1,4) = -XYZ(2)
      DXDDOMAIN(2,4) =  XYZ(1)
      DXDDOMAIN(3,4) =  0.0

      DXDDOMAIN(1,5) =  XYZ(3)
      DXDDOMAIN(2,5) =  0.0
      DXDDOMAIN(3,5) = -XYZ(1)

      DXDDOMAIN(1,6) = -XYZ(2)
      DXDDOMAIN(2,6) =  XYZ(1)
      DXDDOMAIN(3,6) =  0.0

      RETURN
      END
C
      SUBROUTINE DEFINE_DOMAINS
      implicit none
C
C--Defines groups according to read parameters
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      REAL      ROT_RIGID,RIGID_TRANS,RIGID_ALPHA,TGRAV
      integer igroup
      COMMON /some_rigid/ IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN)
C     
C---Local variables
      integer idom,ipiece,ia,ia1,ip1,jrs
      CHARACTER CHNNMP*4
      character line*512
c
      integer is,nsegment,nmax_segment
      character seg_cur*8
      character*8, allocatable :: segment_domain(:)
      logical seg_flag
c
c---body
      nmax_segment = 1000
      IF(NDOMAIN.GT.0) THEN
        DO   IA = 1,N_ATOM
          IGROUP(IA) = 0
          DO     IDOM=1,NDOMAIN
            IF(IDOMAIN_PIECES(IDOM).GT.0) THEN
              IPIECE = IDOMAIN_PIECES(IDOM)
              DO IP1 = 1,IPIECE
C
C---Add checking
                 call get_chain_namepdb(chnnmp,i_resid(ia))
c                IF(REFID.EQ.'UNRE') THEN
c                  CHNNMP = RES_NUM_PDB(I_RESID(IA))(1:1)
c                ELSE
c                  CHNNMP = ASM_GROUP_ID(I_CHAIN(I_RESID(IA)))(1:1)
c                ENDIF
                READ(RES_NUM_PDB(I_RESID(IA))(3:6),*)JRS
                IF(CHNNMP.EQ.IDOMAIN_CHN(IP1,IDOM).AND.
     +                  JRS.GE.IDOMAIN_FROM(IP1,IDOM).AND.
     +                  JRS.LE.IDOMAIN_TO(IP1,IDOM)) THEN
                    IGROUP(IA) = IDOM
                    GOTO 10
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 10       CONTINUE
        ENDDO
      ELSE
         seg_flag = .FALSE.
         do ia=1,n_atom
            if(seg_id(ia).ne.'.'.and.seg_id(ia).ne.' ') then
               seg_flag = .TRUE.
               goto 15
            endif
         enddo
 15      continue
         nsegment = 1
         allocate(segment_domain(nmax_segment))
         if(seg_flag) then
            segment_domain(1) = seg_id(1)
         else
            call get_chain_namepdb(chnnmp,i_resid(1))
            segment_domain(1) = chnnmp
         endif
c     
         do ia=1,n_atom
            if(seg_flag) then
               seg_cur = seg_id(ia)
               do is=1,nsegment
                  if(seg_cur.eq.segment_domain(is)) then
                     idom = is
                     goto 20
                  endif
               enddo
            else
               call get_chain_namepdb(chnnmp,i_resid(ia))
               seg_cur = chnnmp
               do is=1,nsegment
                  if(seg_cur.eq.segment_domain(is)) then
                     idom = is
                     goto 20
                  endif
               enddo
            endif
            nsegment = nsegment + 1
            if(nsegment.gt.nmax_segment) then
               write(line,'(a,i5)')
     &              'Too many segids. Maximum allowed is ',nmax_segment
               call errwrt(1,line)
            endif
            idom = nsegment
            segment_domain(nsegment) = seg_cur
 20         continue
            igroup(ia) = idom
         enddo
         deallocate(segment_domain)
         ndomain = nsegment
      ENDIF
C
C---Main chain or side chain atoms may not be included in refinement
C---but they will be rotated
      IA1 = 0
      DO    IA=1,N_ATOM
        ATOM_REF_mod_FLAG(IA,1) = 1
        IDOM = IGROUP(IA)
        IF(OCCUP(IA).EQ.0.0) THEN
           ATOM_REF_mod_FLAG(IA,1) = 0
        ENDIF
        IF(ATOM_REF_mod_FLAG(IA,1).NE.0) THEN
          IA1 = IA1 + 1
          IF( CS_ELEMENT(ID_SF_mod(IA,1)).EQ.'H   '.OR.
     &        CS_ELEMENT(ID_SF_mod(IA,1)).EQ.'H-1 ') THEN
            ATOM_REF_mod_FLAG(IA,1) = IA1*10 + 2
          ELSE
            ATOM_REF_mod_FLAG(IA,1) = IA1*10 + 4
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END
c
      SUBROUTINE   FINDCGRAV
C
C---Finds center of gravity of atoms and makes this point as center 
C---of given atoms
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'rigid_body.fh'


      COMMON /some_rigid/ IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN)

      REAL QATOM(MAXDOMAIN)
c
      DO    IDOMAIN = 1,NDOMAIN
          DO   IX=1,3
             TGRAV(IX,IDOMAIN) = 0.0
          ENDDO
          QATOM(IDOMAIN) = 0.0
      ENDDO

      DO    IA=1,N_ATOM
        IF(ATOM_REF_mod_FLAG(IA,1).GT.0) THEN
          IDOMAIN  = IGROUP(IA)
          IF(IDOMAIN.GT.0) THEN
            DO    IX=1,3
              TGRAV(IX,IDOMAIN) = TGRAV(IX,IDOMAIN)+
     +            XYZ_CRD_mod(IX,IA,1)*OCCUP(IA)
            ENDDO
            QATOM(IDOMAIN) = QATOM(IDOMAIN) + OCCUP_mod(IA,1)
          ENDIF
        ENDIF
      ENDDO

      DO    IDOMAIN = 1,NDOMAIN
        DO   IX=1,3
          IF(QATOM(IDOMAIN).GT.0.0) THEN
            TGRAV(IX,IDOMAIN) = TGRAV(IX,IDOMAIN)/QATOM(IDOMAIN)
          ENDIF
        ENDDO
      ENDDO
      RETURN
      END

      SUBROUTINE PRINT_RIGIDPARS
C
C---Prints parameters of rigid body like euler angles translation
C---matrices
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rigid_body.fh'

      COMMON /some_rigid/ IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN)

      REAL TRANS(3),ALPHA0(3),ROT_TEMP(3,3)
      CHARACTER LINE*120
C
C---
      CALL ERRWRT(-1,
     +     '----------------------------------------------------------') 
      CALL ERRWRT(-1,
     +     '  Rigid body parameters will be applied to coordinates')
      CALL ERRWRT(-1,'  as following')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' Xnew = Rot*Xold - Rot*Tg + Tg +deltaTg')
      CALL ERRWRT(-1,'Where')
      CALL ERRWRT(-1,
     +   ' Xnew and Xold are new and old coordinates of atoms in')
      CALL ERRWRT(-1,'              this domain')
      CALL ERRWRT(-1,
     +' Rot           is rotation matrix derived from Euler angles')
      CALL ERRWRT(-1,' Tg            is centre of mass of this domain')
      CALL ERRWRT(-1,' deltaTg       is shift of centre of mass')
      CALL ERRWRT(-1,
     +     '----------------------------------------------------------') 
      DO    IDOM=1,NDOMAIN
        WRITE(LINE,'(A,I5)')'Domain ',IDOM
        CALL ERRWRT(-1,LINE)
        CALL EUL2MATR(RIGID_ALPHA(1,IDOM),RIGID_ALPHA(2,IDOM),
     &           RIGID_ALPHA(3,IDOM),ROT_RIGID(1,1,IDOM))
        DO    IX=1,3
          ALPHA0(IX) = RIGID_ALPHA(IX,IDOM)
          TRANS(IX)  = RIGID_TRANS(IX,IDOM)
        ENDDO
C
C--Print Euler angles and translations

        WRITE(LINE,'(A,3F10.3)')'Centre of mass: ',
     +    TGRAV(1,IDOM),TGRAV(2,IDOM),TGRAV(3,IDOM)
        CALL ERRWRT(-1,LINE)
        IF(EULER_PRINT_RIGID) THEN
           ALPHA1 = ALPHA0(1)*RTODEG
           ALPHA2 = ALPHA0(2)*RTODEG
           ALPHA3 = ALPHA0(3)*RTODEG
           WRITE(LINE,'(A,3x,6F9.2)')' Euler angles and deltaTg: ',
     +           ALPHA1,ALPHA2,ALPHA3, TRANS(1),TRANS(2),TRANS(3)
           CALL ERRWRT(-1,LINE)
           CALL ERRWRT(-1,' ')
        ENDIF
        IF(MATRIX_PRINT_RIGID) THEN
C
C--Print rotation matrix and translations
          LINE = ' '
          CALL ERRWRT(-1,' Matrix and deltaTg')
          WRITE(LINE,'(3X,3F10.3)')
     +       ROT_RIGID(1,1,IDOM),ROT_RIGID(1,2,IDOM),ROT_RIGID(1,3,IDOM)
          CALL ERRWRT(-1,LINE) 
          WRITE(LINE,'(3X,3F10.3)')
     +       ROT_RIGID(2,1,IDOM),ROT_RIGID(2,2,IDOM),ROT_RIGID(2,3,IDOM)
          CALL ERRWRT(-1,LINE) 
          WRITE(LINE,'(3X,3F10.3)')
     +       ROT_RIGID(3,1,IDOM),ROT_RIGID(3,2,IDOM),ROT_RIGID(3,3,IDOM)
          CALL ERRWRT(-1,LINE) 
          WRITE(LINE,'(3X,3F10.3)')
     +              TRANS(1),TRANS(2),TRANS(3)
          CALL ERRWRT(-1,LINE) 
          CALL ERRWRT(-1,' ') 
        ENDIF
        IF(POLAR_PRINT_RIGID) THEN
          DO   IX=1,3
            DO   IY=1,3
              ROT_TEMP(IX,IY) = ROT_RIGID(IX,IY,IDOM)
            ENDDO
          ENDDO
          CALL POLAR(ROT_TEMP,PSI,PHI,CHI)               
          WRITE(LINE,'(3X,A,6F9.2)')
     +   'Polar angles: PHI, PSI(or Omega), CHI(or Kappa), deltaTg: ',
     +            PHI,PSI,CHI, TRANS(1),TRANS(2),TRANS(3)
          CALL ERRWRT(-1,LINE) 
          CALL ERRWRT(-1,' ') 
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE AMOD1(A,B)
C
      B1 = ABS(B)/2.0
      B2 = ABS(B)
10    CONTINUE 
      IF(A.GT.B1) THEN
        A = A-B2
        GOTO 10
      ENDIF
20    CONTINUE
      IF(A.LT.-B1) THEN
        A = A + B2
        GOTO 20
      ENDIF
      RETURN
      END
