      subroutine r_factor(maxsym,nsym,rot,tr,cell,
     &     nasym,hkl_asym,fcalc,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     nmaxpart,npart,ndomain,alpha,
     &     b_ls_aniso_over,scale_ls_over,b_ls_over,scale_ls_bulk,
     &     b_ls_bulk,scale_ls_part,b_ls_part,ierr)
      implicit none
      include 'rharvest.fh'
c
c---  calculate statistics related with agreement of observations and calc
c
c---  inputs
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      integer nasym
      integer nmaxpart,npart
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
      integer ndomain
      real b_ls_aniso_over(6),scale_ls_over,b_ls_over,scale_ls_bulk
      real b_ls_bulk,scale_ls_part(nmaxpart),b_ls_part(nmaxpart)
      real    alpha(48)
c
c---outputs
      integer ierr
c
c---locals
      logical isitfree
      real hkl_this(3),hkl_sym(3),s_this(3),ss_v(6)
      real ast,bst,cst,cosast,cosbst,coscst,rsq,s,ss,ss0
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      integer i,k,j,ip,is,m,jc,jal
      integer o_s,o_f,c_s,c_f,c_1,o_c_s,o_c_f,c_n

      real a_all,b_all,ict,ico,fo0,wfo0,delta,adelta,wdelta,sigma
      real fct
      real ic(48)
      integer ish
      real foav_work,fcav_work,fo2av_work,fc2av_work,fofcav_work
      real foav_free,fcav_free,fo2av_free,fc2av_free,fofcav_free
      real foav_all,fcav_all,fo2av_all,fc2av_all,fofcav_all

      real foav_shell_work(hmaxshell),fcav_shell_work(hmaxshell)
      real foav_shell_free(hmaxshell),fcav_shell_free(hmaxshell)
      real foav_shell_all(hmaxshell),fcav_shell_all(hmaxshell)

      real numer_all,denom_all,wnumer_all,wdenom_all
      real numer_free,denom_free,wnumer_free,wdenom_free
      real numer_work,denom_work,wnumer_work,wdenom_work
 
      real numer_shell_free(hmaxshell),denom_shell_free(hmaxshell)
      real wnumer_shell_free(hmaxshell),wdenom_shell_free(hmaxshell)
      real numer_shell_work(hmaxshell),denom_shell_work(hmaxshell)
      real wnumer_shell_work(hmaxshell),wdenom_shell_work(hmaxshell) 
      real numer_shell_all(hmaxshell),denom_shell_all(hmaxshell)
      real wnumer_shell_all(hmaxshell),wdenom_shell_all(hmaxshell)
c
      real bans,exp1,expban,s_b_part,expbs,expbs_bulk

      logical error
c
c---  body
c
c----Initialise
      nhrefl_work = 0
      nhrefl_free = 0
      nhrefl_all = 0

      rfactor_all = 0.0
      rfactor_free = 0.0
      rfactor_work = 0.0
      foav_work = 0.0
      fcav_work = 0.0
      fo2av_work = 0.0
      fc2av_work = 0.0
      fofcav_work = 0.0
      hcorr_fofc = 0.0
            
      rfactor_free = 0.0
      foav_free = 0.0
      fcav_free = 0.0
      fo2av_free = 0.0
      fc2av_free = 0.0
      fofcav_free = 0.0
      hcorr_fofc = 0.0
      hcorr_fofc_free = 0.0

      numer_all = 0.0
      denom_all = 0.
      wnumer_all = 0.0
      wdenom_all =0.0
      numer_free = 0.0
      denom_free = 0.0
      numer_work = 0.0
      denom_work = 0.0

      do  ish=1,hnshell
         numer_shell_free(ish) = 0.0
         denom_shell_free(ish) = 0.0
         wnumer_shell_free(ish) = 0.0
         wdenom_shell_free(ish) = 0.0

         numer_shell_work(ish) = 0.0
         denom_shell_work(ish) = 0.0
         wnumer_shell_work(ish) = 0.0
         wdenom_shell_work(ish) = 0.0
            
         numer_shell_all(ish) = 0.0
         denom_shell_all(ish) = 0.0
         wnumer_shell_all(ish) = 0.0
         wdenom_shell_all(ish) = 0.0

         hrfac_shell_free(ish) = 0.0
         hwrfac_shell_free(ish) = 0.0
         hrfac_shell_work(ish) =0.0
         hwrfac_shell_work(ish) = 0.0
         hwrfac_shell_all(ish) =  0.0
         hwrfac_shell_all(ish) = 0.0
      enddo
c
c---------------
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierr)
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
  
      do  i=1,num_blocks
         isitfree = .FALSE.
         if(freer(i).eq.0) isitfree = .TRUE.
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq)
         s = sqrt(rsq)/2.0
         ss = rsq/4.0
         ss0 = 0.5*s/hstlmax*hnshell
         ish = min(hnshell,int(ss0) + 1)

         if(ierr.gt.0) then
            write(*,*)
            write(*,*)'subroutine r_factor'
            write(*,*)'Problem in finding shell for ',ss
            write(*,*)
            ierr=1
            return
         endif
         expbs = exp(-ss*b_ls_over)*scale_ls_over
         expbs_bulk = (1.0-exp(-ss*b_ls_bulk)*scale_ls_bulk)*expbs
         jc = 0
         do m=c_s,c_f
            jc = jc + 1
            c_n           = block_2_asym(m)
            hkl_this(1:3) = hkl_asym(1:3,c_n)
            a_all         = fcalc(1,c_n)
            b_all         = fcalc(2,c_n)
            expban = 0.0
            do  is=1,nsym
               call mat2vect(3,3,rot(1,1,is),hkl_this,hkl_sym,error)
               call mat2vect(3,3,cs_ort_to_frac,hkl_sym,s_this,error)
               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans = ss_v(1)*b_ls_aniso_over(1)+
     &              ss_v(2)*b_ls_aniso_over(2)+
     &              ss_v(3)*b_ls_aniso_over(3)+
     &              ss_v(4)*b_ls_aniso_over(4)+
     &              ss_v(5)*b_ls_aniso_over(5)+
     &              ss_v(6)*b_ls_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
            enddo
            expban = expban/nsym
            do ip=1,npart
               s_b_part = scale_ls_part(ip)*exp(-b_ls_part(ip)*ss)
               a_all    = a_all+fpart(ip,1,c_n)*s_b_part
               b_all    = b_all+fpart(ip,2,c_n)*s_b_part
            enddo 
            Ic(jc) = (a_all**2+b_all**2)*expban
         enddo
         do j=o_s,o_f
            o_c_s = obs_start(j) + 1
            o_c_f = obs_start(j+1)
            ict=0.0
            do k=o_c_s,o_c_f
               jc  = ref_2_asym(k)
               jal = comp_numb(k)
               ict = ict+alpha(jal)*Ic(jc)
            enddo
            fo0 = sqrt(max(0.1*iobs(2,j),iobs(1,j)))
            sigma = iobs(2,j)**2/(sqrt(fo0**2+iobs(2,j)**2)+fo0)
            ict = ict*expbs_bulk
            fct = sqrt(ict)

            delta = fo0-fct
            adelta = abs(delta)
            wdelta = adelta/sigma
            wfo0    = fo0/sigma

            numer_all = numer_all + adelta
            denom_all = denom_all + fo0
            wnumer_all = wnumer_all + wdelta
            wdenom_all = wdenom_all + wfo0

            if(isitfree) then
               nhrefl_free = nhrefl_free + 1
               fo2av_free = fo2av_free + fo0**2
               fc2av_free = fc2av_free + fct**2
               fofcav_free  = fofcav_free  + fo0*fct
               foav_free = foav_free + fo0
               fcav_free = fcav_free + fct
               hnref_shell_free(ish) = hnref_shell_free(ish) + 1
               numer_free = numer_free + adelta
               denom_free = denom_free + fo0
               hnref_shell_free(ish) = hnref_shell_free(ish) + 1
               denom_shell_free(ish) = denom_shell_free(ish) + fo0
               numer_shell_free(ish) = numer_shell_free(ish) + adelta
               wdenom_shell_free(ish) = wdenom_shell_free(ish) + wfo0
               wnumer_shell_free(ish) = wnumer_shell_free(ish) +wdelta
            else
               nhrefl_work = nhrefl_work + 1
               fo2av_work = fo2av_work + fo0**2
               fc2av_work = fc2av_work + fct**2
               fofcav_work  = fofcav_work  + fo0*fct
               foav_work = foav_work + fo0
               fcav_work = fcav_work + fct
               hnref_shell_work(ish) = hnref_shell_work(ish) + 1
               numer_work = numer_work + adelta
               denom_work = denom_work + fo0
               hnref_shell_work(ish) = hnref_shell_work(ish) + 1
               denom_shell_work(ish) = denom_shell_work(ish) + fo0
               numer_shell_work(ish) = numer_shell_work(ish) +adelta
               wdenom_shell_work(ish) = wdenom_shell_work(ish) + wfo0
               wnumer_shell_work(ish) = wnumer_shell_work(ish) +wdelta
            endif
         enddo
      enddo         
c
c---
      if(denom_all.gt.0.0) rfactor_all = numer_all/denom_all
      if(denom_free.gt.0.0) rfactor_free = numer_free/denom_free
      if(denom_work.gt.0.0) rfactor_work = numer_work/denom_work
      if(nhrefl_work.gt.0) then
         rfactor_work = numer_work/denom_work

         foav_work = foav_work/nhrefl_work
         fcav_work = fcav_work/nhrefl_work
         fo2av_work = fo2av_work/nhrefl_work
         fc2av_work = fc2av_work/nhrefl_work
         fofcav_work = fofcav_work/nhrefl_work
         hcorr_fofc = (fofcav_work-foav_work*fcav_work)/
     &        (sqrt(fo2av_work-foav_work**2)*
     &          sqrt(fc2av_work-fcav_work**2))
      endif
      if(nhrefl_free.gt.0) then
         rfactor_free = numer_free/denom_free
         foav_free = foav_free/nhrefl_free
         fcav_free = fcav_free/nhrefl_free
         fo2av_free = fo2av_free/nhrefl_free
         fc2av_free = fc2av_free/nhrefl_free
         fofcav_free = fofcav_free/nhrefl_free
         hcorr_fofc_free = (fofcav_free-foav_free*fcav_free)/
     &        (sqrt(fo2av_free-foav_free**2)*
     &          sqrt(fc2av_free-fcav_free**2)) 
      endif
      do  ish=1,hnshell
         if(hnref_shell_free(ish).gt.0) then
            hrfac_shell_free(ish) = 
     &           numer_shell_free(ish)/denom_shell_free(ish)
            hwrfac_shell_free(ish) = 
     &           wnumer_shell_free(ish)/wdenom_shell_free(ish)
         endif
         if(hnref_shell_work(ish).gt.0) then
            hrfac_shell_work(ish) = 
     &           numer_shell_work(ish)/denom_shell_work(ish)
            hwrfac_shell_work(ish) = 
     &           wnumer_shell_work(ish)/wdenom_shell_work(ish)
         endif
         if(hnref_shell_all(ish).gt.0) then
            hrfac_shell_all(ish) = 
     &           numer_shell_all(ish)/denom_shell_all(ish)
            hwrfac_shell_all(ish) = 
     &           wnumer_shell_all(ish)/wdenom_shell_all(ish)
         endif
      enddo
c
      return
      end
c
      subroutine report_xray_stats
      implicit none
c
c---report xray statistics
      include 'rharvest.fh'
      include 'monitor.fh'
      include 'twin_refmac.fh'
c
c--   locals
      integer ish
c
c---  body
      if(ntwin_domain.gt.1) then
         write(*,'(a,i10)')'The number of twin domains             = ',
     &        ntwin_domain
         write(*,'(a,30f6.5)')'Twin fractions ',
     &        alpha_twin(1:ntwin_domain)
      endif
c
      if(mon_style.eq.'MANY') then
         do ish=1,hnshell

         enddo
      endif
c
      if(mon_style.eq.'MANY') then

      endif
      write(*,'(a,f10.4)')'Overall R factor                     = ',
     &  rfactor_work
      if(rfactor_free.ge.0.0) then
         write(*,'(a,f10.4)')'Overall R factor                     = ',
     &        rfactor_work
      endif
      if(fomover.gt.0.0) then
         write(*,'(a,f10.4)')'Overall figure of merit              = ',
     &     fomover
      endif

      return
      end
