C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
C  Subroutines to perform fast calculation of density, graident and
C  second derivatives (or elements of normal matrix)
C
C-----------------------------------------------------------------
      SUBROUTINE PROPI(NREF,ndens,NIND,FO,SIGO,H_A,H_B,fwt,FC,PHASE,
     &                 FREER)
c-----------------------------------------------------------------
C     ROUTINE TO CALL Subroutines which scales SFs and calculates
C     coefficients for fourie transformation to calculate gradients (and
C     hessian ) and agreement factors.
C -----------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'anom.fh'
c-------------------------
      real    FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      real    FO(*),SIGO(*),FREER(*)
      REAL    H_A(*),H_B(*)
      real    fwt(*)
      INTEGER NREF,ndens
      INTEGER NIND(*)
      LOGICAL MIR_SAVE,LEXP_SAVE
C-----------------------------------
      INTEGER N_ATOM1,IP,IA,NPART1,ir,dimen
      LOGICAL SCALE_LS_PART_REFINE_FLAG_SAVE(NMAXPART),
     &        B_LS_PART_REFINE_FLAG_SAVE(NMAXPART)
      REAL B_LS_PART_SAVE(NMAXPART),SCALE_LS_PART_SAVE(NMAXPART),
     &       BOVER_ATOM,UISO_EQUAV,BOVER1,BAVER_CURRENT
      integer i,n,mod2
      real A_CALCS(NMAXPART),B_CALCS(NMAXPART)
      real, allocatable :: fc_save(:)
C
C---Some initialisations. If necessary
      npart1 = npart + 1
      call return_mat_dim(dimen)
C
c switch fc's for scaling for sir(as) substructure case.
      if ((dppi_sras.or.dppi_sir).and.substruct_flag) then
        allocate(fc_save(nobs))
        mod2=3; if (dppi_sir) mod2=2;
        n = 1+NPART*NOBS
        fc_save(1:nobs) = fc(n:n+nobs-1,1)
        fc(n:n+nobs-1,1) = fc(1:nobs,mod2)
      endif
C---Here add some check if partial structure B etc should be refined
C---or fixed.
      BOVER_ATOM = 0.0
      IF(.NOT.LINIT) THEN
      
c--Use log scaling
        CALL LOG_SCALING(NREF,ndens,NIND,FO,SIGO,fwt,FC(1+NPART*NOBS,1),
     &                   FREER)
C
C---Find initial values for LS scale factors. Here it is based on log
C---scaling or whatever comes from LOG_SCALING
        LINIT = .TRUE.
        B_LS_OVER0 = 0.0
        DO  IP=1,NPART
          B_LS_PART_REFINE_FLAG_SAVE(IP) = B_LS_PART_REFINE_FLAG(IP)
          B_LS_PART_REFINE_FLAG(IP) = .FALSE.
          SCALE_LS_PART_REFINE_FLAG_SAVE(IP) =  
     &           SCALE_LS_PART_REFINE_FLAG(IP)
C???? Check it again.
          SCALE_LS_PART_REFINE_FLAG(IP) = .FALSE.
          SCALE_LS_PART_SAVE(IP) = SCALE_LS_PART(IP)
          SCALE_LS_PART(IP) = 0.0
          B_LS_PART_SAVE(IP) = B_LS_PART(IP)
          B_LS_PART(IP) = 0.0
        ENDDO
        CALL LS_SCALING(NREF,ndens,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
        DO   IP=1,NPART
          B_LS_PART_REFINE_FLAG(IP) = B_LS_PART_REFINE_FLAG_SAVE(IP)
          SCALE_LS_PART_REFINE_FLAG(IP) = 
     &              SCALE_LS_PART_REFINE_FLAG_SAVE(IP)
          SCALE_LS_PART(IP) = SCALE_LS_PART_SAVE(IP)
          B_LS_PART(IP) = B_LS_PART_SAVE(IP)
        ENDDO
        B_LS_ANISO_OVER_REFINE_FLAG = .FALSE.

      ELSE
        B_LS_OVER = 0.0
      ENDIF
      IF(ALL_SCALES_FLAG.AND.LS_SCALE_FLAG) 
     & CALL LS_SCALING(NREF,ndens,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      UOVER_ATOM = B_LS_OVER/PISQ8
c
      do ir=1,nref
        if (fo(ir+nref).gt.0.and.sigo(ir+nref).gt.0 ) then
c          fo(ir)=fo(ir+nref)
c          sigo(ir)=sigo(ir+nref)
        endif
      enddo
      CALL LSQ_COEF(NREF,ndens,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      do ir=1,nref
        if (fo(ir+nref).gt.0.and.sigo(ir+nref).gt.0 ) then
c          fo(ir)=fo(ir+2*nref)
c          sigo(ir)=sigo(ir+2*nref)
        endif
      enddo

c swtiching back here
      if ((dppi_sras.or.dppi_sir).and.substruct_flag) then
        fc(n:n+nobs-1,1) = fc_save(1:nobs)
        deallocate(fc_save)
      endif

      IF(REFS.EQ.'LSQF')GOTO 500
      CALL APPLYSCALES(NREF,ndens,NIND,0,NPART1,FO,SIGO,FC,H_A,H_B)
C
      IF(REFS.EQ.'LSQI') THEN
C
C--Coefficietns for intensity based LSQ refinement
      ELSEIF(REFS.EQ.'MLKF') THEN
        IF(.NOT.MLINIT) THEN
          if (.not.DPPI_no) call CALC_SIGM(NREF,ndens,NIND,FO,SIGO,
     &      H_A,H_B,fwt,FC,PHASE,FREER)
          CALL DMLINIT_R(NREF,ndens,NIND,FO,SIGO,H_A,H_B,fwt,FC,PHASE,
     &                   FREER)
          MLINIT = .TRUE.
        ENDIF
        MIR_SAVE = MIR_FLAG
        USEWORK   = MLUSEWORK
        LEXP_SAVE = LEXPUSE
        LEXPUSE   = MLEXPUSE
        LEXPUSE   = .FALSE.
        IF(.NOT.PHASE_SIGMAA_FLAG)MIR_FLAG=.FALSE.
        IF(ALL_SCALES_FLAG.AND.ML_SCALE_FLAG) 
     &    CALL ML_SCALING(NREF,ndens,NIND,FO,SIGO,H_A,H_B,fwt,FC,PHASE,
     &                    FREER)
        NRESIOPT = 1 
        MIR_FLAG=MIR_SAVE
        LEXPUSE = LEXP_SAVE
        CALL ML1CF(NREF,ndens,NIND,FO,SIGO,H_A,H_B,fwt,FC,PHASE,FREER)
      ENDIF
 500  CONTINUE
      LEXPUSE = LEXP_SAVE
      RETURN
      END
C
      SUBROUTINE PRINT_LS_SCALE
C
C---Prints parameters of scale factors.
      IMPLICIT NONE
C
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      include 'twin_refmac.fh'
      INTEGER IP
      CHARACTER LINE*512
C
      IF(MON_STYLE.EQ.'NONE') RETURN
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      if(twin_flag.and.ntwin_domain.gt.0) then
         write(line,'(a,i3)')
     &        'The number of twin domains    = ',ntwin_domain
         call errwrt(-1,line)
         write(line,'(a,48(2x,F7.4))')
     &        'Twin fractions                = ',
     &        twin_frac(1:ntwin_domain)
         call errwrt(-1,line)
      endif
      WRITE(LINE,'(A,2(A,F8.3))')  'Overall               :'
     &          ,' scale = ',SCALE_LS_OVER,', B  =',B_LS_OVER
      CALL ERRWRT(-1,LINE)
      IF(BULK_LS_FLAG) THEN
        WRITE(LINE,'(A,2(A,F8.3))')'Babinet"s bulk solvent:'
     &          ,' scale = ',SCALE_LS_BULK,', B  =',B_LS_BULK
        CALL ERRWRT(-1,LINE)
      ENDIF
      DO   IP=1,NPART
        WRITE(LINE,'(A,I3,2(A,F8.3))')'Partial structure  ',IP,
     &        ': scale = ',SCALE_LS_PART(IP),', B  =', B_LS_PART(IP)
        CALL ERRWRT(-1,LINE)
      ENDDO
      IF(B_LS_ANISO_OVER_FLAG) THEN
        CALl ERRWRT(-1,'Overall anisotropic scale factors')
        WRITE(LINE,'(2X,6(A,F6.2))')' B11 =',B_LS_ANISO_OVER(1),
     &                             ' B22 =',B_LS_ANISO_OVER(2),
     &                             ' B33 =',B_LS_ANISO_OVER(3),
     &                             ' B12 =',B_LS_ANISO_OVER(4),
     &                             ' B13 =',B_LS_ANISO_OVER(5),
     &                             ' B23 =',B_LS_ANISO_OVER(6)
        CALL ERRWRT(-1,LINE)
      ENDIF
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      RETURN
      END
C
      SUBROUTINE PRINT_ML_SCALE
C
C---Prints parameters of scale factors.
      IMPLICIT NONE
C
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INTEGER IP
      CHARACTER LINE*128
C
      IF(MON_STYLE.EQ.'NONE') RETURN
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'----ML scale parameters---')
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      WRITE(LINE,'(A,2(A,F8.3))')  'Overall               :'
     &          ,' scale = ',D_ML_SCALE_OVER,', B  =',D_ML_B_OVER
      CALL ERRWRT(-1,LINE)
      IF(BULK_LS_FLAG) THEN
        WRITE(LINE,'(A,2(A,F8.3))')'Babinet"s bulk solvent:'
     &          ,' scale = ',D_ML_SCALE_BBULK,', B  =',D_ML_B_BBULK
        CALL ERRWRT(-1,LINE)
      ENDIF
      DO   IP=1,NPART
        WRITE(LINE,'(A,I3,2(A,F8.3))')'Partial structure  ',IP,
     &        ': scale = ',D_ML_SCALE_PART(IP),', B  =', D_ML_B_PART(IP)
        CALL ERRWRT(-1,LINE)
      ENDDO

      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      RETURN
      END
C
      SUBROUTINE REPORT_XRAY_STATS
C
      IMPLICIT NONE
      INCLUDE 'rharvest.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
C
      INTEGER I,NB1,NREFT,IREST
      REAL Smean,ssss
      CHARACTER LINE*128,NC_LOC*30
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      NB1 = NBIN+1
      IF(MON_STYLE.EQ.'NONE') RETURN
C
      CALL PRINT_LS_SCALE
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
C
      IF(NCYCLE_OVERALL.LT.NMAX_CYCLE) 
     &             NCYCLE_OVERALL = NCYCLE_OVERALL + 1
      WRITE(NC_LOC,'(A,I4)')'Cycle ',NCYCLE_OVERALL
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY') THEN
C
C---Stats over resolution. For loggraph
        CALL HEADER('Things for loggraph, R factor and others')
        CALL ERRWRT(-1,' ')
        IF(FREER_FLAG) THEN
        CALL ERRWRT(-1,
     &     '$TABLE: '//NC_LOC(1:LENSTR(NC_LOC))//
     &           '. Rfactor analysis, F distribution v resln  :')
        CALL ERRWRT(-1,'$GRAPHS:'//NC_LOC(1:LENSTR(NC_LOC))//
     &                  '. <Rfactor> v. resln :N:1,6,7,11,12:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &             '. <Fobs> and <Fc> v. resln :N:1,4,5,9,10:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. % observed v. resln :N:1,3:')
        CALL ERRWRT(-1,'$$')
        CALL ERRWRT(-1,
     &'M(4SSQ/LL) NR_used %_obs M(Fo_used) M(Fc_used) Rf_used'//
     &' WR_used')
        CALL ERRWRT(-1,
     & 'NR_free M(Fo_free) M(Fc_free) Rf_free   WR_free $$')
        CALL ERRWRT(-1,'$$')
        DO    I=1,NBIN
          Smean =  2.0*(SMINB(I)**2 + SMAXB(I)**2)
          IF(HPERC_SHELL_REFL(I).GT.0.0) THEN
          WRITE(LINE,'(F6.3,I8,F7.2,2F8.1,2F6.2,I8,2F8.1,2F6.2)')
     &  Smean,HNREF_SHELL_WORK(I),HPERC_SHELL_REFL(I),AFO(1,I),AFC(1,I),
     &  HRFAC_SHELL_WORK(I),HWRFAC_SHELL_WORK(I),HNREF_SHELL_FREE(I),
     &  AFO(2,I),AFC(2,I),HRFAC_SHELL_FREE(I),HWRFAC_SHELL_FREE(I)
          CALL ERRWRT(-1,LINE)
          ENDIF
        ENDDO
        ELSE
        CALL ERRWRT(-1,
     &     '$TABLE: '//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. Rfactor analysis, F distribution v resln  :')
        CALL ERRWRT(-1,'$GRAPHS:'//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. M(Rfactor) v. resln :N:1,6,7:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. M(Fobs) and M(Fc) v. resln :N:1,4,5:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &               '. % observed v. resln :N:1,3:')
        CALL ERRWRT(-1,'$$')
        CALL ERRWRT(-1,
     &'M(4SSQ/LL) NR_used %_obs M(Fo_used) M(Fc_used) Rf_used'//
     &' WR_used $$')
        CALL ERRWRT(-1,'$$')
        DO    I=1,NBIN
          Smean =  2.0*(SMINB(I)**2 + SMAXB(I)**2)
          IF(HPERC_SHELL_REFL(I).GT.0.0) THEN
          WRITE(LINE,'(F6.3,I8,F7.2,2F8.1,2F6.2)')
     &  Smean,HNREF_SHELL_WORK(I),HPERC_SHELL_REFL(I),AFO(1,I),AFC(1,I),
     &  HRFAC_SHELL_WORK(I),HWRFAC_SHELL_WORK(I)
          CALL ERRWRT(-1,LINE)
          ENDIF
        ENDDO
        ENDIF
C
        CALl ERRWRT(-1,'$$')
C
        CALL HEADER('Fom and SigmaA vs resolution')
        CALL ERRWRT(-1,
     +' $TABLE: '//NC_LOC(1:LENSTR(NC_LOC))//
     &   '. Fom(<cos(DelPhi)>-acentric, centric, overall v resln:')
        CALL ERRWRT(-1,' $GRAPHS:'//NC_LOC(1:LENSTR(NC_LOC))//
     &          '. M(Fom) v. resln :N:1,3,5,7,8:')
        CALL ERRWRT(-1,' $$')
        CALL ERRWRT(-1,
     +' <4SSQ/LL> NREFa  FOMa  NREFc FOMc NREFall FOMall  '//
     + 'SigmaA_Fc1 $$')
        CALL ERRWRT(-1,' $$')
c
        DO    I=1,NBIN
          Smean =  2.0*(SMINB(I)**2 + SMAXB(I)**2)
         IF(NSCOPT.EQ.1 .AND. NDPAR.GE.4)
     $  ssss = (1.0 + DMLPAR(NDPAR -1) * EXP(-DMLPAR(NDPAR)*Smean /4.0))
     $  * DMLPAR(NDPAR -3)*EXP(-DMLPAR(NDPAR -2)*Smean /4.0)
         IF(NSCOPT.EQ.0 .AND. NDPAR.GE.2)
     $   ssss =  DMLPAR(NDPAR -1) * EXP(-DMLPAR(NDPAR)*Smean /4.0)
          NREFT = NREFA(1,I)+NREFC(1,I)
         IF(NREFT.GT.0) THEN
           FOMAVT(1,I) = (FOMAVA(1,I)*NREFA(1,I)+
     +                           FOMAVC(1,I)*NREFC(1,I))/NREFT
         WRITE(LINE,'(f8.4,I6,F8.3,I6,F8.3,I6,F8.3,F7.3)')
     +    Smean,NREFA(1,I),FOMAVA(1,I),NREFC(1,I),FOMAVC(1,I),
     +      NREFT,FOMAVT(1,I),D_ML(1,I)
         CALL ERRWRT(-1,LINE)
         ENDIF
        ENDDO
        CALL ERRWRT(-1,' $$ ')

      ENDIF

C
C---Overall stats
      WRITE(LINE,'(A,2F10.3)')'Resolution limits                    = ',
     &                   HD_LOW,HD_HIGH
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,I10)')   'Number of used reflections           = ',
     &           HNREF_SHELL_WORK(NB1)
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Percentage observed                  = ',
     &   HPERC_SHELL_REFL(NB1)
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Percentage of free reflections       = ',
     &     PERC_FREE
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Overall R factor                     = ',
     &  RFACTOR_WORK
      CALL ERRWRT(-1,LINE)
      RFACTOR_VS_CYCLE(NCYCLE_OVERALL) = RFACTOR_WORK
cd      IF(LREFIN) THEN
      LLG_VS_CYCLE(NCYCLE_OVERALL)     = FXRAY
      LLGFREE_VS_CYCLE(NCYCLE_OVERALL)     = FXFREE

cd      ELSE
cd        IF(NCYCLE_OVERALL.GE.2) THEN
cd          LLG_VS_CYCLE(NCYCLE_OVERALL) = LLG_VS_CYCLE(NCYCLE_OVERALL-1)
cd        ELSE
cd          LLG_VS_CYCLE(NCYCLE_OVERALL) = 0.0
cd        ENDIF
cd      ENDIF
      WRITE(LINE,'(A,F10.4)') 'Free R factor                        = ',
     &  RFACTOR_FREE
      IF(RFACTOR_FREE.GT.0.0) THEN
        CALL ERRWRT(-1,LINE)
        RFREE_VS_CYCLE(NCYCLE_OVERALL) = RFACTOR_FREE
      ENDIF
      
      WRITE(LINE,'(A,F10.4)') 'Overall weighted R factor            = ',
     &   RWFACTOR_WORK
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Free weighted R factor               = ',
     &   RWFACTOR_FREE
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &      RWFACTOR_FREE.GT.0.0) CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Overall correlation coefficient      = ',
     &   HCORR_FOFC
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Free correlation coefficient         = ',
     &   HCORR_FOFC_FREE
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &    HCORR_FOFC_FREE.GT.-1.0)CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Cruickshanks DPI for coordinate error= ',
     &   HESU_CRUIC
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &    HESU_CRUIC.GT.0.0) CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'DPI based on free R factor           = ',
     &   HESU_FREE
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &      HESU_FREE.GT.0.0)CALL ERRWRT(-1,LINE)
      IF(REFS.EQ.'MLKF') THEN
      WRITE(LINE,'(A,F10.4)') 'Overall figure of merit              = ',
     &     FOMOVERT(1)
      CALL ERRWRT(-1,LINE)
      FOM_VS_CYCLE(NCYCLE_OVERALL) = FOMOVERT(1)
C
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &  HESU_ML.GT.0.0) THEN
      WRITE(LINE,'(A,F10.4)') 'ML based su of positional parameters = ',
     &     HESU_ML
      CALL ERRWRT(-1,LINE)
      ENDIF
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &  HESU_ML_B.GT.0.0) THEN
      WRITE(LINE,'(A,F10.4)') 'ML based su of thermal parameters    = ',
     &     HESU_ML_B
        CALL ERRWRT(-1,LINE)
      ENDIF

      ENDIF
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
C
C---Add geometry if there is any.
      IF(HNRESTR.GT.0) THEN
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond distances: refined atoms')THEN
      BOND_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_DEV(IREST)
      ZBOND_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_Z(IREST)

      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond angles  : refined atoms')THEN
        ANGLE_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_DEV(IREST)
        ZANGLE_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_Z(IREST)

      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Chiral centres: refined atoms')THEN
       CHIR_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_DEV(IREST)
      ENDIF
      ENDDO    
      ENDIF
      
      RETURN
      END
C
      
      SUBROUTINE ADD_PARTIAL(NREF,ndens,FC,PHASE)
C-----------------------------------------------------------
C    SUBROUTINE adds partial structure factor to previous list.
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
      INCLUDE 'solvent.fh'
      REAL FC(nobs,ndens),PHASE(nobs,ndens)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
      REAL HLA,HLB,HLC,HLD
      integer di
      real YOALL(MAX_DATASETS), SIGYOALL(MAX_DATASETS)
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
      CHARACTER SCRATCH_FILE*256,REFSCR_1*256
      LOGICAL LEXISTS
      INTEGER LENSTR
      EXTERNAL LENSTR
      EXTERNAL PACK
C---------------------------------------------------------
      IREF=1
      NFRR=0
C---------------------------------------------------------
      I = 0
      NPARTALL   = NPARTALL_SAVE
      NPART      = NPART_SAVE
      FPART_FLAG = FPART_FLAG_SAVE
      DO    IP=1,NPARTALL
        ILSCALTYP(IP) = ILSCALTYP_SAVE(IP)
        ISCPART(IP)   = ISCPART_SAVE(IP)       
      ENDDO
      ISCRF = IFSCR_SAVE
      REWIND ISCRF
      call find_unique_file_name(refscr_1,'_REFSCR_1')
      inquire(file=refscr_1,exist=lexists)
      if(lexists) close(unit=iscrf0,status='DELETE')
      call open_unform_file(iscrf0,refscr_1,ifail)

100   CONTINUE 
      IF(iREF.GT.NOBS) goto 500
      FPP(NPARTALL+1) = FC(iREF,1)
      APP(NPARTALL+1) = PHASE(iREF,1)*RTODEG
      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND..NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +           (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +           (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
     +     ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(iREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIND: Number of reflections more than expected')
      iREF = iREF+1
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
c
      ISCRF      = ISCRF0
      FPART_FLAG = .TRUE.
      NPARTALL   = NPARTALL + 1
      NPART      = NPART  + 1
      ISCPART(NPARTALL) = 1
      ILSCALTYP(NPART+1) = ILSCALTYP(NPART)
c---  SOLVENT_FLAG = .FALSE.
c---  B_LS_BULK = 400.0
c---  B_LS_BULK_REFINE_FLAG = .FALSE.
      RETURN
      END
C
      SUBROUTINE READ_INDICES(NREF,NIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads saves Fo and SIGF also (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NIND(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN

      REAL HLA,HLB,HLC,HLD
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
      EXTERNAL PACK
C---------------------------------------------------------
      NREF=0
      NFRR=0
C---------------------------------------------------------
      I = 0
      REWIND ISCRF
100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND..NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      NREF=NREF+1
      IF(NREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIND: Number of reflections more than expected')
      CALL PACK(IND,IH,IK,IL)
      NIND(NREF) = IND
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
c
      RETURN
      END
C
      SUBROUTINE read_nrefl(NREF)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads saves Fo and SIGF also (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
c
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN

      REAL HLA,HLB,HLC,HLD
      integer di
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
      real YOALL(MAX_DATASETS), SIGYOALL(MAX_DATASETS)
      EXTERNAL PACK
C---------------------------------------------------------
      NREF=0
      NFRR=0
C---------------------------------------------------------
      I = 0
      REWIND ISCRF
100   CONTINUE 
      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND..NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      NREF=NREF+1
      IF(NREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIND: Number of reflections more than expected')
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
c
      RETURN
      END
c
      SUBROUTINE RDIND(NREF,FO,SIGO,FREER,NIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads saves Fo and SIGF also (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NIND(*)
      REAL FO(*),SIGO(*),FREER(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN

      REAL HLA,HLB,HLC,HLD
      integer di
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
      real YOALL(MAX_DATASETS), SIGYOALL(MAX_DATASETS)
      EXTERNAL PACK
C---------------------------------------------------------
      NREF=0
      NFRR=0
C---------------------------------------------------------
      I = 0
      REWIND ISCRF
100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND..NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      NREF=NREF+1
      IF(NREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIND: Number of reflections more than expected')
      CALL PACK(IND,IH,IK,IL)
      NIND(NREF) = IND
      FO(NREF)   = YO
      SIGO(NREF) = SIGYOA
      do di=1,dataset_num_tot
        FO(NREF+di*NOBS) = YOALL(di)
        SIGO(NREF+di*NOBS) = SIGYOALL(di)
      enddo
      IF(FREER_FLAG)FREER(NREF) = FRR
      IF(FREER_FLAG )THEN 
        IF( ABS(FREER(NREF) - LFreeRexcludeVal) .LT.0.01)NFRR = NFRR + 1
      END IF
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
c
      RETURN
      END
C
      SUBROUTINE RDIND1(NREF,ndens,FO,SIGO,FREER,FC,PHASE,NIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads saves Fo and SIGF also (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
      INTEGER NIND(*),ndens
      REAL    FO(*),SIGO(*),FREER(*),FC(nobs,ndens),PHASE(nobs,ndens)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
      REAL HLA,HLB,HLC,HLD
      integer di,di2,di_start,found
      real YOALL(MAX_DATASETS), SIGYOALL(MAX_DATASETS)
      REAL FPP(NMAXPART),APP(NMAXPART)
      EXTERNAL PACK
C
C---First change position of phases
      IF(NREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIN1: Number of reflections more than expected')
      DO    IR=1,NREF
        IPOS        = IR+NPART*NOBS
        FCC         = FC(IR,1)
        PHICC       = PHASE(IR,1)
        FC(IPOS,1)    = FCC*COS(PHICC)
        PHASE(IPOS,1) = FCC*SIN(PHICC)
      ENDDO
C 
      IREF = 0
      NFRR=0
      REWIND ISCRF
100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
     +   ,(YOALL(di),SIGYOALL(di),di=1,dataset_num_tot)
        ENDIF
      ENDIF
      IREF=IREF+1
      IF(IREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIN1: Number of reflections more than expected')
      CALL PACK(IND,IH,IK,IL)
      NIND(IREF) = IND
      FO(IREF)   = YO
      SIGO(IREF) = SIGYOA
c
      di_start=1
      found=0
      do di=1,dataset_num_tot
        if (LL.lt.0.and.dataset_PM(di).ne.0) then
cthe following should fix the cases when we have to switch F+ and F- anomalous data
          if (found.eq.0) then
            do di2=di_start,dataset_num_tot
              if (dataset_dernum(di).eq.dataset_dernum(di2).and.
     &     	      dataset_PM(di).ne.dataset_PM(di2).and.
     &            dataset_PM(di2).ne.0 ) then
                FO(IREF+di2*NOBS) = YOALL(di)
          	    SIGO(IREF+di2*NOBS) = SIGYOALL(di)              
                found=di
                if (VERBREF_5N) write(*,*)'Switching F+ and F- datasets'
                goto 101
              endif
            enddo
            write(*,*)'WARNING: Only one Friedel pair data found for '//
     &        'derivative ',dataset_dernum(di),', the required switch'//
     &        'of F+ and F- could not be performed!'
              FO(IREF+di*NOBS) = YOALL(di)
              SIGO(IREF+di*NOBS) = SIGYOALL(di)
          else
            FO(IREF+found*NOBS) = YOALL(di)
          	SIGO(IREF+found*NOBS) = SIGYOALL(di)
          	found = 0
          	di_start = di+1
          endif	  
  101     continue
        else
          FO(IREF+di*NOBS) = YOALL(di)
          SIGO(IREF+di*NOBS) = SIGYOALL(di)
        endif
      enddo
c      
      IF(FREER_FLAG)FREER(IREF) = FRR
      ICPOS = IREF + NPART*NOBS
      IF(FPART_FLAG) THEN
         IP1 = 0
         DO   IP=1,NPARTALL
           IF(ISCPART(IP).EQ.0) THEN
             FC(ICPOS,1)    = FC(ICPOS,1)   +FPP(IP)*COS(APP(IP)*DEGTOR)
             PHASE(ICPOS,1) = PHASE(ICPOS,1)+FPP(IP)*SIN(APP(IP)*DEGTOR)
           ELSE

             IP1          = IP1 + 1
             IPOS         = IREF+(IP1-1)*NOBS
             FC(IPOS,1)     = FPP(IP)
             PHASE(IPOS,1)  = APP(IP)*DEGTOR

           ENDIF
         ENDDO
      ENDIF
      IF(MIR_FLAG) THEN
        IPOS         = (NPART+1)*NOBS + IREF
        PHASE(IPOS,1)  = HLA
        IPOS         = IPOS + NOBS
        PHASE(IPOS,1)  = HLB
        IPOS         = IPOS + NOBS
        PHASE(IPOS,1)  = HLC
        IPOS         = IPOS + NOBS
        PHASE(IPOS,1)  = HLD
      ENDIF

      Ftemp = SQRT(ABS(FC(ICPOS,1)**2+PHASE(ICPOS,1)**2))
      Ptemp = 0.0
      IF(Ftemp.NE.0.0) Ptemp = ATAN2(PHASE(ICPOS,1),FC(ICPOS,1))
      FC(ICPOS,1)    = Ftemp
      PHASE(ICPOS,1) = Ptemp
      IF(FREER_FLAG )THEN 
        IF( ABS(FREER(IREF) - LFreeRexcludeVal) .LT.0.01)NFRR = NFRR + 1
      END IF
      GOTO 100
499   CALL ERRWRT(1,'READ Scratch file of reflections')
500   CONTINUE
      RETURN
      END

      SUBROUTINE RDSORT(LIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads old sorting order (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER LIND(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN

      REAL HLA,HLB,HLC,HLD
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
C---------------------------------------------------------
      NREF=0
C---------------------------------------------------------
      I = 0
      REWIND ISCRF

100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      NREF=NREF+1
      LL1 = IABS(LL)
      LIND(LL1) = NREF
      IF(LL.LE.0) LIND(LL1) = -NREF
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
      RETURN
      END
C
      subroutine read_foweights(nref,fo_map,sigo_map,fwt)
      implicit none
      include 'restr_files.fh'
      integer nref
      real fo_map(nref),sigo_map(nref),fwt(nref)

      integer i
      integer ifail,ll,iunit
c

      if(fomap_file(1:1).eq.' ') then
         do i=1,nref
            fwt(i) = 1.0
         enddo
         return
      endif
      call open_unform_file(iunit,fomap_file,ifail)
      do i=1,nref
         read(iunit)fo_map(i),sigo_map(i),fwt(i)
      enddo
      close(iunit)
      return
      end
c
      SUBROUTINE LOG_SCALING(NREF,ndens,NIND,FO,SIGO,fwt,FC,FREER)
c
c------Program for log scaling observed and calculated structure
c------factors. Scale factor will be applied to observed and 
c------temperature factor to calculated structure factors
C------
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      REAL FO(*),SIGO(*),FC(nobs,ndens),FREER(*)
      real fwt(*)
      INTEGER NREF,ndens
      INTEGER NIND(*)

C-----------------------------------------------------------
c
c----Local variables
      INTEGER  I,IH1,IH2,IH3
      REAL     RSQ,RHO,DF(2),DF2(2,2),SHIFTS(2),WORKSPACE(25)
      LOGICAL  TESTFREE1,TESTFREE2
      REAL     LSTLSQ,YC,TOLER
      EXTERNAL LSTLSQ,UNPACK
C
C----SCFOFC - TO MINIMIZE SUM(S*FO-exp(-Bc*rs^2)FC)**2
C
C----Log scaling
      TOLER    = 1.0E-8
      DF(1)    = 0.0
      DF(2)    = 0.0
      DF2(1,1) = 0.0
      DF2(1,2) = 0.0
      DF2(2,1) = 0.0
      DF2(2,2) = 0.0
C
C--Initial scale
      DO     I=1,NREF
        TESTFREE1 = .FALSE.
        TESTFREE2 = .TRUE.
        IF(SIGO(I).GT.0.0 .AND.FO(I).GT.0.0 .AND.FC(I,1).GT.0.00) 
     +        TESTFREE1 = .TRUE.
        IF(FREER_FLAG) THEN
          IF (ABS(FREER(I) - LFreeRexcludeVal) .LT.0.1 )
     +           TESTFREE2 = .FALSE.
        END IF
        IF(TESTFREE1  .AND. TESTFREE2 .and. fwt(i).gt.0.0 ) THEN
          CALL UNPACK(NIND(I),IH1,IH2,IH3)
          RSQ =  LSTLSQ(1,IH1,IH2,IH3)
          RHO = SQRT(RSQ)
          IF(RHO.GE.SMINS.AND.RHO.LE.SMAXS) THEN
            YC       = FC(I,1)
            DF(1)    = DF(1)    - fwt(i)*(LOG(FO(I)) - LOG(FC(I,1)))
            DF(2)    = DF(2)    + fwt(i)*(LOG(FO(I)) - LOG(FC(I,1)))*RSQ 
            DF2(1,1) = DF2(1,1) + fwt(i)
            DF2(1,2) = DF2(1,2) - fwt(i)*RSQ
            DF2(2,2) = DF2(2,2) + fwt(i)*RSQ*RSQ
          ENDIF
        ENDIF
      ENDDO
      DF2(2,1) = DF2(1,2)
      CALL EIGEN_FILTER_R(TOLER,DF2,2,2,DF,SHIFTS,WORKSPACE,25)
      SCALE_LS_OVER = EXP(-SHIFTS(1))
      B_LS_OVER     = -SHIFTS(2)
C
      RETURN
      END
C
      SUBROUTINE REDALLI(N1,N2,N3,NX,NY,NZ,ndens,ROTIN,TRIN,NSYMIN,DEN)
C-------------------------------------------------
C--This routine reduces electron density to the asymmetric unit 
C--   *******  SPACE GROUP GENERAL  *******
C--------------------------------------------------
      IMPLICIT NONE
      INTEGER N1,N2,N3,NX,NY,NZ,NSYMIN,ndens
      REAL    DEN(N1,N2,N3,ndens)
      REAL ROTIN(3,3,*),TRIN(3,*)
c
c----192 is maximum number of possible symmetries.
      integer id
      INTEGER IX,IY,IZ,IX1,IY1,IZ1,IXN,IYN,IZN,I,J,IS,N31,N21,N11,NMULT
      INTEGER NX22,NY22,NZ22
      INTEGER IROT(3,3,192),ITR(3,192)
      INTEGER IXN1(192),IYN1(192),IZN1(192),
     +        IXN2(192),IYN2(192),IZN2(192)

C----------------------------------------------------------
      DO     IS = 1,NSYMIN
         DO   I=1,3
         DO   J=1,3
            IROT(I,J,IS) = NINT(ROTIN(I,J,IS))
         ENDDO
         ENDDO
         ITR(1,IS) = NINT(TRIN(1,IS)*NX)
         ITR(2,IS) = NINT(TRIN(2,IS)*NY)
         ITR(3,IS) = NINT(TRIN(3,IS)*NZ)
      ENDDO
C
      N31=N3-1
      N21=N2-1
      N11=N1-1
      NX22 = NX*2
      NY22 = NY*2
      NZ22 = NZ*2
      DO     IZ=0,N31
        IZ1 = IZ + 1
        DO     I=2,NSYMIN
          IXN1(I) = IROT(1,3,I)*IZ+ITR(1,I)
          IYN1(I) = IROT(2,3,I)*IZ+ITR(2,I)
          IZN1(I) = IROT(3,3,I)*IZ+ITR(3,I)
        ENDDO 
        DO     IY=0,N21
          IY1 = IY + 1
          DO     I=2,NSYMIN
            IXN2(I) = IROT(1,2,I)*IY+IXN1(I)
            IYN2(I) = IROT(2,2,I)*IY+IYN1(I)
            IZN2(I) = IROT(3,2,I)*IY+IZN1(I)
          ENDDO 
          DO     IX=0,N11
            IX1   = IX + 1
c this looks as a bug to me???? (in case of ndens>1)
c            IF(DEN(IX1,IY1,IZ1,1).EQ.0.0) GOTO 201
            NMULT = 1
            DO     I=2,NSYMIN
C---------------------------------------------------------------------
              IZN = IROT(3,1,I)*IX+IZN2(I)
              IF(IZN.LT.0) THEN 
                IZN = IZN + NZ
              ELSE IF(IZN.GE.NZ) THEN
                IZN = IZN - NZ
              ENDIF
              
cd              IZN = MOD(IZN,NZ)
              IF(IZN.GT.N31) GOTO 160
              IF(IZN.LT.IZ) GOTO 140
              IF(IZN.GT.IZ) GOTO 160

              IYN = IROT(2,1,I)*IX+IYN2(I)
              IF(IYN.LT.0) THEN
                IYN = IYN + NY
              ELSE IF(IYN.GE.NY) THEN
                IYN = IYN - NY
              ENDIF
cd              IYN = MOD(IYN,NY)
              IF(IYN.GT.N21) GOTO 160 
              IF(IYN.LT.IY) GOTO 140
              IF(IYN.GT.IY) GOTO 160

              IXN = IROT(1,1,I)*IX+IXN2(I)
              IF(IXN.LT.0) THEN
                IXN = IXN + NX
              ELSE IF(IXN.GE.NY) THEN
                IXN = IXN - NX
              ENDIF
cd              IXN = MOD(IXN,NX)
              IF(IXN.GT.N11) GOTO 160
              IF(IXN.LT.IX) GOTO 140
              IF(IXN.GT.IX) THEN
                GOTO 160
              ELSE
                NMULT = NMULT + 1
                GOTO 160
              ENDIF
C
 140          CONTINUE
              do id=1,ndens
                 DEN(IX1,IY1,IZ1,id) = 0.0
              enddo
              GOTO 200
160           CONTINUE
            ENDDO
200         CONTINUE
            do id=1,ndens
               DEN(IX1,IY1,IZ1,id) = DEN(IX1,IY1,IZ1,id)/NMULT
            enddo
 201        CONTINUE
          ENDDO
        ENDDO
      ENDDO
C----------------------------------------------------
      END
C
C-----------------------------------------------------------------
C
C---Subroutines for modelling electron density from atomic model,
C---gradient and diagonal terms of second deivative matrix using 
C---electron density
C
      SUBROUTINE DENSTY(nl1,nl2,nl3,ndens,nmodel,DEN)
      implicit none
C
C---This subroutine call ELDEN to add to electron density distribution
C---contribution from atoms with isotropic B-values and ELDEN_ANISO 
C---to add contribution of ansiotropic atoms
C
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'atom_com.fh'
      integer nl1,nl2,nl3,ndens,nmodel
      REAL DEN(nl1,nl2,nl3,ndens)

C
      den(1:nl1,1:nl2,1:nl3,1:ndens) = 0.0
C
C---Add contributions of isotropic atoms
C

      CALL ELDEN(nl1,nl2,nl3,ndens,nmodel,DEN)
C
C---Anisotropic contribution should be added here
      CALL ELDEN_ANISO(nl1,nl2,nl3,ndens,nmodel,DEN)
C
c      DO  I3=1,N3
c        DO  I2=1,N2
c          DO  I1=1,N1
c            write(*,*)DEN(I1,I2,I3)
c          ENDDO
c        ENDDO
c      ENDDO
c      stop
      RETURN
      END
C
      SUBROUTINE ELDEN(nl1,nl2,nl3,ndens,nmodel,DEN)
      implicit none
C-----------------------------------------------------------------
C---------           SPACE GROUP GENERAL
C---This subroutine calculates electron density from atoms and fills
C---"asymmetric" unit of crystals. Displacement parameters are as U
C---values
C-------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      include 'anom.fh'
      include 'refi_flags.fh'
C
      integer nl1,nl2,nl3,ndens,nmodel
      REAL   DEN(nl1,nl2,nl3,ndens)
C
C---Local variables
      integer i,ia,im,il,il1,ia1,ia11,id31,ig,ilist
      integer isxl,isxu,isyl,isyu,iszl,iszu
      integer natom_list
      integer nx50,ny50,nz50
      integer ix,iy,iz,ix1,iy1,iz1,ix2,iy2,iz2
      integer wave_pos,nmod_anom,nadn
      REAL*8   GAUSS(10001)
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      REAL*8    CL1(5),BL1(5)
      real*8    clan,blan
      real      fbandu,fban
      real XYZ(3)
      real csa2,csb2,csg2
      real dxo2,dyzrox,dyo,dyo2,dlimit,dlim1,dsq,dsq1,d1,d22,d238
      real d238_anom
      real dx,dy,dz,dyz,dxo,dxmin,dxo2pyo2
      real dzcsa2,dzo2,dzcsb,dzo,dzroy,dzrox
      real d2,d4,d7,dsqmin
      real radx,rady,radz,sx,sy,sz,sxl,sxu,syl,syu,szl,szu
      real x1,y1,z1,xc,yc,zc
      real u11,u11_anom,ul,zcosaxdelta
      real xlow,xupper,ylow,yupper,zlow,zupper,xdelta,zcosa
      real*8 fac,facan
      LOGICAL ERROR, anom
C
C----Find extension limits for asymmetric unit
      CALL ASYMLIM_FRAC(DDLIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      cosa = cos(cs_cell(4))
      cosb = cos(cs_cell(5))
      cosg = cos(cs_cell(6))
      sina = sin(cs_cell(4))
      sinb = sin(cs_cell(5))
      sing = sin(cs_cell(6))
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      DLIMIT = DDLIM
C
C---Perhaps it should be calculated only once
      DO  I=1,5000
        GAUSS(I) = EXP(-.002d0*I+.002d0)
      ENDDO
      GAUSS(5001) = 0.0d0
      CSA2        = 2.0*COSA
      CSB2        = 2.0*COSB
      CSG2        = 2.0*COSG
C ---
      D22 = SX*SY*SZ*COSZ*SING/(TWOPI)**1.5
C
      nmod_anom=0
      if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad) then
        wave_pos = dataset_wavenum(dataset_order(2))
        if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras) nmod_anom=1
        if (DPPI_mad) nmod_anom=2
      endif
      NX50 = 50*NX
      NY50 = 50*NY
      NZ50 = 50*NZ            
C----Loop over all atoms in all models
      do im=1,nmodel
      anom=.false.
      if ((DPPI_sad.or.DPPI_sadh.or.DPPI_mad).and.im.eq.1) anom=.true.
      if (DPPI_sras.and.im.eq.2) anom=.true.
c current non-anomalous density (order) number
      nadn = 1 + (1+nmod_anom)*(im-1)
      DO IA=1,N_ATOM_mod(im)
        IA1 = ATOM_REF_mod_FLAG(IA,im)/10
        IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
        IF(IA11.LE.1)   GOTO 500
        IF(U_ANISO_mod(2,IA,im).NE.0.0) goto 500
c.OR.OCCUP(IA).LE.0.0)  GOTO 500
C
C---If atom has isotropic U values

C
C---Add NCS here
        IL   = ID_SF_mod(IA,im)
        D238 = OCCUP_mod(IA,im)*D22
        d238_anom = occup_anom_mod(ia,im)*d22
        IL1  = CS_NELEC(IL)
        U11  = 2.0*U_ANISO_mod(1,IA,im)
        u11_anom = 2.0*u_anom_mod(1,ia,im)
        IF(IL1.GT.16)U11=AMAX1(U11,0.38)
        UL   = 0.70+U11
cd        IF(IL1.EQ.1)UL = 0.38+U11
        DLIM1= DLIMIT 
        D1   = DLIM1*UL
        U11  = U_ANISO_mod(1,IA,im)
        DO    IG=1,5
           FBANDU  = CS_B(IG,IL)/PISQ8 + U11
           BL1(IG) = 250.0/FBANDU
           CL1(IG) = D238*CS_A(IG,IL)*FBANDU**(-1.5)
        ENDDO
c
c---anom density
        if(anom.and.cs_anom(il)) then
c           fban = u11_anom
           fban = u11
           blan = 250.0/fban
           clan = d238_anom*f2prime(t2at(il),wave_pos)*fban**(-1.5)
        endif
C
C---List of all atoms contributing to asymmetric unit
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD_mod(1,IA,im),XYZ,ERROR)
        CALL ATLIST1(XYZ,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +       ZUPPER,INDSYM_LIST,NATOM_LIST)
C
C----Loop over list of atoms which contribute to "asymmetric" unit
        DO    ILIST=1,NATOM_LIST
           X1 = XA_list(1,ILIST)*CS_CELL(1)
           Y1 = XA_list(2,ILIST)*CS_CELL(2)
           Z1 = XA_list(3,ILIST)*CS_CELL(3)
           XC = X1/SX
           YC = Y1/SY
           ZC = Z1/SZ
C
           RADZ = SQRT(D1)/(SZ*COSZ)
           SZL  = ZC - RADZ
           SZU  = ZC + RADZ
           ISZL = INT(SZL+501.0)
           ISZU = INT(SZU+500.0)
           DO      IZ1 = ISZL,ISZU
              IZ  = IZ1 - 500
              IZ2 = MOD(IZ+NZ50,NZ) + 1
              IF(IZ2.GT.N3)GO TO 300
              DZ  = IZ*SZ - Z1
              DZO = DZ*RO_UNIT(3,3)
              DZO2= DZO*DZO
              D2  = DZ*DZ
              D7  = D1 - DZO2
              IF (D7.LT.0.0)GO TO 300
              RADY   = SQRT(D7)/(SY*SING)
              ZCOSA  = DZ*COSAST/SY
              SYL    = YC - RADY - ZCOSA
              SYU    = YC + RADY - ZCOSA
              ISYL   = INT(SYL+501.0)
              ISYU   = INT(SYU+500.0)
              DZCSA2 = DZ*CSA2
              DZROX  = DZ*RO_UNIT(1,3)
              DZROY  = RO_UNIT(2,3)*DZ
              DZCSB  = DZ*COSB
              DO     IY1 = ISYL,ISYU
                 IY  = IY1-500
                 IY2 = MOD(IY+NY50,NY)+1
C---  CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
                 IF(IY2.GT.N2)GO TO 290
                 DY     = IY*SY-Y1
                 DYO    = DY*RO_UNIT(2,2) + DZROY
                 DYO2   = DYO*DYO
                 DYZ    = D2+(DZCSA2+DY)*DY
                 DXMIN  =-DY*COSG-DZCSB
                 DSQMIN = DYZ - DXMIN**2
                 D4     = D1 - DSQMIN
                 IF(D4.LT.0.0) GOTO 290
                 RADX     = SQRT(D4)/(SX*SING)
                 XDELTA   = DXMIN/SX
                 SXL      = XC - RADX + XDELTA
                 SXU      = XC + RADX + XDELTA
                 ISXL     = INT(SXL+501.0)
                 ISXU     = INT(SXU+500.0)
                 DYZROX   = DY*RO_UNIT(1,2) + DZROX
                 DXO2PYO2 = DYO2 + DZO2
               
                 DO      IX1 = ISXL,ISXU
                    IX   = IX1 - 500
                    IX2  = MOD(IX+NX50,NX)+1
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                    IF(IX2.GT.N1)GO TO 280
                    DX   = IX*SX-X1
                    DXO  = DX*RO_UNIT(1,1) + DYZROX
                    DXO2 = DXO*DXO
                    DSQ  = DXO2 + DXO2PYO2
                    IF(DSQ.GT.D1)GO TO 280
                    FAC  = 0.0D0
                    DO   IG=1,NGAUS
                       DSQ1 = DSQ*BL1(IG)+1.0
                       ID31 = MIN1(DSQ1,5001.1)
                       FAC  = FAC + CL1(IG)*GAUSS(ID31)
                    ENDDO
                    DEN(IX2,IY2,IZ2,nadn) = DEN(IX2,IY2,IZ2,nadn) + FAC
                    if(anom.and.cs_anom(il))then
                       dsq1  = dsq*blan + 1.0
                       id31  = min1(dsq1,5001.1)
                       facan = clan*gauss(id31)
                       den(ix2,iy2,iz2,nadn+1) = den(ix2,iy2,iz2,nadn+1)
     &                                         + facan
                    endif
 280                CONTINUE
                 ENDDO
 290             CONTINUE
              ENDDO
 300          CONTINUE
           ENDDO
        ENDDO
 500    CONTINUE
      ENDDO
      enddo
      RETURN
      END
C
      SUBROUTINE ATLIST1(XFRAC_input,XA_list,XLOW,YLOW,ZLOW,
     +                   XUPPER,YUPPER,ZUPPER,INDSYM_list,NATOM_list)
      implicit none
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
C
C----Finds list of atoms which has something to do with enlarged 
C----asymmetric unit after application of symmetry operations.
C----Could be used for atoms with isotropic B-values
C
      integer natom_list
      REAL    XFRAC_input(3)
      REAL    XA_list(3,*)
      real xlow,xupper,ylow,yupper,zlow,zupper
      INTEGER INDSYM_list(*)
c
      integer isym
      real xt,yt,zt
C----------------------------------------------------------------
C-----Input 
C-----
C----- XFRAC_input,
C----- YFRAC_input,
C----- ZFRAC_input  positional paramters of atoms in fractional 
C-----              coordinates
C----- XLOW,
C----- YLOW,
C----- ZLOW,
C----- XUPPER,
C----- YUPPER,
C----- ZUPPER       lower and upper limits of asymmetric unit for 
C-----              enlarging (in fractional coordiates)
C-----
C-----Output
C-----
C----- Xa_list      list of coordinates 
C----- INDSYM_list  corresponding symmetry operation
C----- NATOM_list   number of atoms in the list 
C-----
C---------------------------------------------------------------
      NATOM_list = 0
      DO    ISYM=1,NumSymmetry
        XT = RealSymmMatrx(1,1,ISYM)*XFRAC_input(1) + 
     +       RealSymmMatrx(1,2,ISYM)*XFRAC_input(2) +
     +       RealSymmMatrx(1,3,ISYM)*XFRAC_input(3) + 
     +       RealSymmMatrx(1,4,ISYM)

        YT = RealSymmMatrx(2,1,ISYM)*XFRAC_input(1) + 
     +       RealSymmMatrx(2,2,ISYM)*XFRAC_input(2) +
     +       RealSymmMatrx(2,3,ISYM)*XFRAC_input(3) + 
     +       RealSymmMatrx(2,4,ISYM)

        ZT = RealSymmMatrx(3,1,ISYM)*XFRAC_input(1) + 
     +       RealSymmMatrx(3,2,ISYM)*XFRAC_input(2) +
     +       RealSymmMatrx(3,3,ISYM)*XFRAC_input(3) +  
     +       RealSymmMatrx(3,4,ISYM)
C
C---Check if atom is inside enlarged asymmetric unit
20      IF(XT.LT.XLOW)GO TO 21
        XT = XT - 1.0
        GO TO 20
21      XT = XT + 1.0
        IF(XT.LT.XLOW) GO TO 21
30      IF(YT.LT.YLOW) GO TO 31
        YT = YT - 1.0
        GO TO 30
31      YT = YT + 1.0
        IF(YT.LT.YLOW)GO TO 31
40      IF(ZT.LT.ZLOW)GO TO 41
        ZT = ZT - 1.0
        GO TO 40
41      ZT = ZT + 1.0
        IF(ZT.LT.ZLOW)GO TO 41
        IF(XT.GT.XUPPER)GO TO 90
        IF(YT.GT.YUPPER)GO TO 90
        IF(ZT.GT.ZUPPER)GO TO 90
C
C---Atom is inside enlarged asymmetric unit. Store its coordinates and
C---symmetry operation by which this atom came into asymmetric unit
        NATOM_list              = NATOM_list + 1
        XA_list(1,NATOM_list)   = XT
        XA_list(2,NATOM_list)   = YT
        XA_list(3,NATOM_list)   = ZT
        INDSYM_list(NATOM_list) = ISYM
90      CONTINUE
      ENDDO
      RETURN
      END

      SUBROUTINE ASYMLIM_FRAC(DLIM,XLOWER_F,YLOWER_F,ZLOWER_F,XUPPER_F,
     +                         YUPPER_F,ZUPPER_F)
      implicit none
C
C---Gives limits for enlarging of asymetric unit by given DLIM defined
C---in angstroms. Takes into account cell angles
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
c
      real dlim,xlower_f,xupper_f,ylower_f,yupper_f,zlower_f,zupper_f
c
      real xmin,xmax,ymin,ymax,zmin,zmax
      real xlower_a,xupper_a,ylower_a,yupper_a,zlower_a,zupper_a
      real v,dlm
C
C----Limit of asymmetric unit. (In fact it is not asymmetric unit in all
C----cases. It is minimum box containing asymmetric unit)
      XMIN = 0.0
      YMIN = 0.0
      ZMIN = 0.0
      XMAX = CS_CELL(1)/IPX
      YMAX = CS_CELL(2)/IPY
      ZMAX = CS_CELL(3)/IPZ

      DLM    = SQRT(DLIM*60.0)/TWOPI
C
C---Limits of enlarged asymmetric unit in angstroms
      V        = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
      XLOWER_A = XMIN-DLM*SINA/V
      YLOWER_A = YMIN-DLM*SINB/V
      ZLOWER_A = ZMIN-DLM*SING/V
      XUPPER_A = XMAX+DLM*SINA/V
      YUPPER_A = YMAX+DLM*SINB/V
      ZUPPER_A = ZMAX+DLM*SING/V
C
C---Limits of enlarged asymmetric unit in fractional coordinates
      XLOWER_F = XLOWER_A/CS_CELL(1)
      XUPPER_F = XUPPER_A/CS_CELL(1)
      YLOWER_F = YLOWER_A/CS_CELL(2)
      YUPPER_F = YUPPER_A/CS_CELL(2)
      ZLOWER_F = ZLOWER_A/CS_CELL(3)
      ZUPPER_F = ZUPPER_A/CS_CELL(3)

      RETURN
      END
C
C-----Block for gardient calculation
C
      SUBROUTINE GRAD_ALL(nl1,nl2,nl3,ndens,nmodel,DEN,GX,GU1,GQ,
     &     gu1_anom,gq_anom)
      implicit none
C
C----This subroutine calls GRAD and GRAD_ANISO to calculate gradients
C----for isotropic and anisotropic atoms
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      integer nl1,nl2,nl3,ndens,nmodel
      REAL DEN(nl1,nl2,nl3,ndens),GX(*),GU1(*),GQ(*)
      real gu1_anom(*),gq_anom(*)
      integer n_atom_tot,im
C
C----Initialise. Perhaps it should be done before this routine
      n_atom_tot=0
      do im=1,nmodel
        n_atom_tot=n_atom_tot+n_atom_mod(im)
      enddo
      gx(1:(3*n_atom_tot))  = 0.0
      gu1(1:(6*n_atom_tot)) = 0.0
      gq(1:n_atom_tot) = 0.0
      gq_anom(1:n_atom_tot) = 0.0
      gu1_anom(1:(6*n_atom_tot)) = 0.0

      CALL GRAD(nl1,nl2,nl3,ndens,nmodel,DEN,GX,GU1,GQ,gu1_anom,gq_anom)
C
C-----Gradients for anisotropic atoms
      CALL GRAD_ANISO(nl1,nl2,nl3,ndens,nmodel,DEN,GX,GU1,GQ,gu1_anom,
     &  gq_anom)
C
      RETURN
      END
C
      SUBROUTINE GRAD(nl1,nl2,nl3,ndens,nmodel,DEN,GX,GU,GQ,gu_anom,
     &  gq_anom)
      implicit none
C-----------------------------------------------------------------
C--------         SPACE GROUP GENEREAL              ------------------
C---Calculates gradients on asymmetric unit
C--------------------------------------------------------------------
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'anom.fh'
      INCLUDE 'refi_flags.fh'
C
      integer nl1,nl2,nl3,ndens,nmodel
      REAL   GX(*),GU(*),GQ(*)
      real   gu_anom(*),gq_anom(*)
      REAL   DEN(nl1,nl2,nl3,ndens)
      REAL*8   GAUSS(5001)
C
C---Local variables
      integer i,il,il1,ilist,id31,ig,ia,ia1,ia11,im
      integer ix,iy,iz,ixl,ixu,iyl,iyu,izl,izu,ix1,iy1,iz1
      integer ix2,iy2,iz2,ih,ixt,it,isym,iq
      integer nx50,ny50,nz50,natom_list,npnt,npoints
      integer wave_pos,nadn,nmod_anom
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      REAL    BL1(5),BL11(5),BB1(5),CL1(5),XYZ_FRAC(3),GXP(3)
      real     GXP1(3),GXP2(3)
      real fbandu
      real bban,blan1,blan11,cca,clan,fban,ddan,dd,dcc,dan44,dan31
      real dan4,d4,dd_all
      real*8 cc1(5)
      real*8 gxx,gyy,gzz,guu,gqq,guu_anom,gqq_anom
      real dxo,dyo,dzo,dzroy,dzo2,dzrox,dzcsb,dsca2,dyzrox
      real dx,dy,dz,d22,d44,d55,d7,d31,d238,d238_anom
      real csa2,csb2,csg2,sx,sy,sz
      real ccan,dancc,dan55,rad,radz,radx,radsq,rady,dzz
      real dzcsa2,dyo2,dyo2pzo2,dyz1,x1,y1,z1
      real x1p,y1p,z1p
      real xl,xu,yl,yu,zl,zu,u11,dsq2,dxmin,dxo2,dsq,dsq1
      real u11_anom
      real dlim
      real xlow,xupper,ylow,yupper,zlow,zupper
      CHARACTER FILE_NAME*256
      LOGICAL ERROR, anom
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C-    THERE ARE REDUNDANT POINTS ON  THE ASYMMETRIC UNIT.  THE
C-    DENSITY AT THESE POINTS IS SET EQUAL TO ZERO.
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      CALL REDALLI(N1,N2,N3,NX,NY,NZ,ndens,ROT,TR,NumSymmetry,DEN)
C
C----Find extension limits for asymmetric unit
      CALL ASYMLIM_FRAC(DGLIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      cosa = cos(cs_cell(4))
      cosb = cos(cs_cell(5))
      cosg = cos(cs_cell(6))
      sina = sin(cs_cell(4))
      sinb = sin(cs_cell(5))
      sing = sin(cs_cell(6))
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      DO    I=1,5000
         GAUSS(I) = EXP(-.002d0*I+.002d0)
      ENDDO
      GAUSS(5001) = 0.0d0
      NX50        = 50*NX
      NY50        = 50*NY
      NZ50        = 50*NZ
      CSA2        = 2.0*COSA
C-------------------------------------------------------------------
      D22 = CS_CELL(1)*CS_CELL(2)*CS_CELL(3)*COSZ*SING/(TWOPI)**1.5
      IT  = 1
      IXT = 1
      IQ  = 1
      nmod_anom=0
      if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad) then
        wave_pos = dataset_wavenum(dataset_order(2))
        if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras) nmod_anom=1
        if (DPPI_mad) nmod_anom=2
      endif
C
      do  im=1,nmodel
      anom=.false.
      if ((DPPI_sad.or.DPPI_sadh.or.DPPI_mad).and.im.eq.1) anom=.true.
      if (DPPI_sras.and.im.eq.2) anom=.true.
c non-anomalous density (order) number corresponding to model im
      nadn = 1 + (1+nmod_anom)*(im-1)
      DO    IA=1,N_ATOM_mod(im)
C----Case 1. Atom is dummy. Do not calculate gradients. And there is no
C----chance that there will be any contribution for this atom even from
C----for example geometry
        IA1 = ATOM_REF_mod_FLAG(IA,im)/10
        IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
        IF(IA1.LE.0) GOTO 500
C
C----Case 2. Atom will not have contribution from x-ray. But it might have
C----contribution from some other sources for example geometry.
        IF(IA11.LE.2.OR.U_ANISO_mod(2,IA,im).NE.0.0) GOTO 498
C
C---Add NCS here
        D238 = D22*OCCUP_mod(IA,im)
        d238_anom = d22*occup_anom_mod(ia,im)
        IL   = ID_SF_mod(IA,im)
        IL1  = CS_NELEC(IL)
        DLIM = DGLIM
        IF(IL1.EQ.1)DLIM=3.5
        U11 = 2.0*U_ANISO_mod(1,IA,im)
        IF(IL1.GT.16) U11 = AMAX1(U11,0.6)
        RADSQ = DLIM*(U11+0.70)
        RAD   = SQRT(RADSQ)
        U11   = U_ANISO_mod(1,IA,im)
c        u11_anom = u_anom_mod(1,ia,im)
        DO    IG=1,5
          FBANDU   = CS_B(IG,IL)/PISQ8 + U11
          BL1(IG)  =               1.0/FBANDU
          BL11(IG) =               0.5/FBANDU**2
          BB1(IG)  =               1.5/FBANDU
          CL1(IG)  =   D238*CS_A(IG,IL)*FBANDU**(-1.5)
          CC1(IG)  =    D22*CS_A(IG,IL)*FBANDU**(-1.5)
        ENDDO
        if(anom.and.cs_anom(il)) then
c           fban = u11_anom
           fban = u11
           blan1  = 1.0/fban
           blan11 = 0.5/fban**2
           bban   = 1.5/fban
           clan   = d238_anom*f2prime(t2at(il),wave_pos)*fban**(-1.5)
           ccan   =  d22*f2prime(t2at(il),wave_pos)*fban**(-1.5)
        endif
        RADZ    = RAD/(COSZ)
C
C---Find all symmetry related atoms which might contribute to gradient
cd        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC,ERROR)
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD_mod(1,IA,im),XYZ_FRAC,
     &    ERROR)
        CALL ATLIST1(XYZ_FRAC,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +              ZUPPER,INDSYM_LIST,NATOM_LIST)

        DO   ILIST=1,NATOM_LIST
C
C----Loop over all symmetry related atoms which contribute to gradient
          GXX = 0.0d0
          GYY = 0.0d0
          GZZ = 0.0d0
          guu = 0.0d0
          gqq = 0.0d0
          guu_anom = 0.0d0
          gqq_anom = 0.0d0
          ISYM    = INDSYM_LIST(ILIST)
          X1      = XA_list(1,ILIST)*CS_CELL(1)
          Y1      = XA_list(2,ILIST)*CS_CELL(2)
          Z1      = XA_list(3,ILIST)*CS_CELL(3)
          ZL      = Z1 - RADZ
          ZU      = Z1 + RADZ
          IZL     = INT(ZL/SZ + 501.)
          IZU     = INT(ZU/SZ + 500.)
          NPOINTS = 0
          DO 300 IZ1=IZL,IZU
            IZ  = IZ1 - 500
            IZ2 = MOD(IZ+NZ50,NZ)+1
            IF(IZ2.GT.N3)GO TO 300
            DZ   = IZ*SZ - Z1
            DZO  = DZ*RO_UNIT(3,3)
            DZO2 = DZO*DZO
            DZZ  = DZ*DZ
            D7   = RADSQ - DZO2
            IF (D7.LT.0.0)GO TO 300
            RADY   = SQRT(D7)/SING
            Y1P    = Y1  - DZ*COSAST
            YL     = Y1P - RADY
            YU     = Y1P + RADY
            IYL    = INT(YL/SY+501.)
            IYU    = INT(YU/SY+500.)
            IF(IYU.LT.IYL)GO TO 300
            DZROX  = DZ*RO_UNIT(1,3)
            DZROY  = DZ*RO_UNIT(2,3)
            DZCSA2 = DZ*CSA2
            DZCSB  = DZ*COSB
            DO 290 IY1=IYL,IYU
              IY  = IY1-500
              IY2 = MOD(IY+NY50,NY)+1
C---CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
              IF(IY2.GT.N2)GO TO 290
              DY    = IY*SY-Y1
              DXMIN =-DY*COSG-DZCSB
              DYZ1  = DZZ + DY*(DZCSA2 + DY)
              D4    = RADSQ - DYZ1 + DXMIN**2
              IF (D4.LT.0.0)GO TO 290
              RADX   = SQRT(D4)/SING
              X1P    = X1  + DXMIN
              XL     = X1P - RADX
              XU     = X1P + RADX
              IXL    = INT(XL/SX+501.)
              IXU    = INT(XU/SX+500.)
              IF(IXU.LT.IXL)GO TO 290
              DYO   = DY*RO_UNIT(2,2) + DZROY
              DYO2  = DYO*DYO
              DYZROX   = DY*RO_UNIT(1,2) + DZROX
              DYO2PZO2 = DYO2 + DZO2
              DO 280 IX1=IXL,IXU
                IX  = IX1-500
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                IX2 = MOD(IX+NX50,NX)+1
                IF(IX2.GT.N1)GO TO 280
                DD  = DEN(IX2,IY2,IZ2,nadn)
                if (anom.and.cs_anom(il)) then
                   ddan = den(ix2,iy2,iz2,nadn+1)
                   dd_all = abs(dd)+abs(ddan)
                else
                   dd_all = abs(dd)
                endif
                IF(dd_all.EQ.0.0) GOTO 280
C--------------------------------------
                DX   = IX*SX-X1
                DXO  = DX*RO_UNIT(1,1) + DYZROX
                DXO2 = DXO*DXO
                DSQ  = DXO2 + DYO2PZO2
                IF(DSQ.GT.RADSQ)GO TO 280
                DSQ1 = DSQ*250.0
                D44  = 0.0
                D55  = 0.0
                DCC  = 0.0
                NPNT = 0
                DO   IG=1,5
                  DSQ2=DSQ1*BL1(IG)+1.0
                  ID31=MIN1(DSQ2,5001.1)
                  IF(ID31.LT.5001) THEN
                     D31 = CL1(IG)*GAUSS(ID31)
                     D44 = D44 + D31*BL1(IG)
                     D55 = D55 + D31*(BL11(IG)*DSQ-BB1(IG))
                     DCC = DCC + CC1(IG)*GAUSS(ID31)
                     NPNT = NPNT + 1
                  ENDIF
                ENDDO
                IF(NPNT.GT.0) THEN
                   D44    = D44*DD
                   GXX    = GXX    + DXO*D44
                   GYY    = GYY    + DYO*D44
                   GZZ    = GZZ    + DZO*D44
                   guu    = guu + d55*dd
                   gqq    = gqq + dcc*dd
c     GU(IT) = GU(IT) + D55*DD
c     GQ(IQ) = GQ(IQ) + DCC*DD
                ENDIF
                NPOINTS = NPOINTS + NPNT
                if (anom.and.cs_anom(il)) then
                   dsq2 = dsq1*blan1+1.0
                   id31 = min1(dsq2,5001.1)
                   dan31 = clan*gauss(id31)
                   dan44 = dan31*blan1
                   dan55 = dan31*(blan11*dsq-bban)
                   dancc = ccan*gauss(id31)
c
                   dan44 = dan44*ddan
                   gxx = gxx + dxo*dan44
                   gyy = gyy + dyo*dan44
                   gzz = gzz + dzo*dan44
                   guu_anom = guu_anom + dan55*ddan
c                   guu      = guu +dan55*ddan
c                   gqq = gqq + dancc*ddan
                   gqq_anom = gqq_anom + dancc*ddan
                endif

280           CONTINUE
290         CONTINUE
300       CONTINUE
          IF(NPOINTS.GT.0) THEN
            GXP(1) = GXX 
            GXP(2) = GYY
            GXP(3) = GZZ
            IF(ISYM.GT.1) THEN
              CALL MAT2VECT(3,3,CS_FRAC_TO_ORT,GXP,GXP1,ERROR)
              CALL MAT2VECT(3,3,ROT(1,1,ISYM),GXP1,GXP2,ERROR)
              CALL MAT2VECT(3,3,CS_ORT_TO_FRAC,GXP2,GXP,ERROR)
            ENDIF
            GX(IXT  ) = GX(IXT  ) + GXP(1)
            GX(IXT+1) = GX(IXT+1) + GXP(2)
            GX(IXT+2) = GX(IXT+2) + GXP(3)
            gu(it)    = gu(it) + guu + guu_anom
c--Keep anomolous occupancies seperate
            gq(iq)    = gq(iq) + gqq 
c            + gqq_anom
            gu_anom(it) = gu_anom(it) + guu_anom
            gq_anom(iq) = gq_anom(iq) + gqq_anom
          ENDIF
        ENDDO
c      write(*,*)im,ia,ixt,gx(ixt),gx(ixt+1),gx(ixt+2)
c      write(*,*)im,ia,it,gu(it),gu_anom(it)
c      write(*,*)im,ia,iq,gq(iq),gq_anom(iq)
c      write(*,*) GX(IXT  )
c        
 498    CONTINUE
        IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
          IT  = IT  + 1
        ELSE
          IT  = IT + 6
        ENDIF
        IXT = IXT + 3
        IQ  = IQ + 1
 500    CONTINUE
      ENDDO
      enddo
      RETURN
      END
C
      SUBROUTINE HDIAG_R(NREF,NIND,FO,HXX,HUU,HQQ,HQU)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rharvest.fh'
C
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),HXX(*),HUU(*),HQQ(*),HQU(*)
C
      INTEGER I,IG,IA,N_SAMPLE,IXT,IQ,IU,IA1,IA11,I_INTER,IM,IU_CUR,
     &        ISYSAB,IHH(3),IREF,ICENT,N_REFINED,IQU
      real stl_c
      REAL U_MAX,U_MIN,U_CUR,DELTA_U,ZERO,HUU1,HQQ1,HXX1,
     &     HQU1,CC0,CC2,CC4,CC5,
     &     DGAUS,C1111,C1212,C1122,EPSI,RSQ,HDC_S0,HDC_S2,U_CUR1,
     &     HDC_S4,HUU1111,HUU1122,HUU1212,FOURPISQ,YO,OCCUP2
      REAL GAUSS(20001),HD_S0(1000),HD_S2(1000),HD_S4(1000),
     &     U_SAMPLE(1000)
      real*8 d2df_weight
      REAL LSTLSQ,DPIML1,DPIML2,CONST_LOC
      EXTERNAL LSTLSQ,UNPACK
C
C--Initialisation
      i_inter = -1
      DPIML1 = 0.0
      DPIML2 = 0.0
      ZERO = 0.0
      CALL INIT_VEC(6*N_ATOM,HXX,ZERO)
      CALL INIT_VEC(21*N_ATOM,HUU,ZERO)
      CALL INIT_VEC(N_ATOM,HQQ,ZERO)
      CALL INIT_VEC(6*N_ATOM,HQU,ZERO)
C
C---Find minimum and maximum U including formfactor Us
      U_MAX = -1.0E32
      U_MIN =  1.0E32
      DO   IA=1,N_ATOM
        IA1 = ATOM_REF_FLAG(IA)/10
        IA11 = ATOM_REF_FLAG(IA)-IA1*10
        IM   = ID_SF(IA)
        IF(IA11.GT.2) THEN
          IF(U_ANISO(2,IA).EQ.0.0) THEN
            U_CUR = U_ANISO(1,IA)
          ELSE
            U_CUR = (U_ANISO(1,IA)+U_ANISO(2,IA)+U_ANISO(3,IA))/3.0
          ENDIF
          DO   IG=1,NGAUS
            U_CUR1 = U_CUR + CS_B(IG,IM)/PISQ8
            U_MAX = AMAX1(U_MAX,U_CUR1)
            U_MIN = AMIN1(U_MIN,U_CUR1)
          ENDDO
        ENDIF
      ENDDO
C
C---Multiply by 4*PI**2
      FOURPISQ = 16.0*PI*PI
      U_MIN    = U_MIN*FOURPISQ - 0.001
      U_MAX    = U_MAX*FOURPISQ + 0.001

C
C---Tabulate exponential values. It should be done once. This part
C---is used very often so should be done in the beginning of the program
C--
      DO   I = 1,20000
        GAUSS(I) = EXP(-0.001*I+0.001)
      ENDDO
      GAUSS(20001) = 0.0
C
C----Find sample points for U values. 
      DELTA_U = AMAX1(1.0,(U_MAX-U_MIN)/500.0)
      U_SAMPLE(1) = U_MIN
      N_SAMPLE = 601
      DO   I=2,601
        U_SAMPLE(I) = U_SAMPLE(I-1) + DELTA_U
        IF(U_SAMPLE(I).GT.U_MAX) THEN
          N_SAMPLE = I
          GOTO 10
        ENDIF
      ENDDO
 10   CONTINUE
      CALL INIT_VEC(N_SAMPLE,HD_S0,ZERO)
      CALL INIT_VEC(N_SAMPLE,HD_S2,ZERO)
      CALL INIT_VEC(N_SAMPLE,HD_S4,ZERO)
C
c---Loop over all reflections to calculate values at the sample points
      DO    IREF=1,NREF
        CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
        RSQ  =  LSTLSQ(1,IHH(1),IHH(2),IHH(3))
        CALL EPSLON(IHH,EPSI,ISYSAB)
        CALL CENTR(IHH,ICENT)
C
        STL_C = 2.0*SQRT(RSQ)
cd        pp = .false.
cd        YO = D2DF_WEIGHT(STL_C,I_INTER,im,pp)/(EPSI*REAL(ICENT+1))
        YO  = FO(IREF)*(EPSI*REAL(ICENT+1))/float(nsmult)
cd        YO  = 2.0*FO(IREF)**2*(FLOAT(ICENT+1)*EPSI)
cd        yo = yo/nsmult
        CC0 = YO
        CC2 = 4.0*YO*RSQ
        CC4 = 4.0*CC2*RSQ
C
C---For each sample points calculate contributors for
C---derivatives wrt occupancy, xyz and u values.
        DO   I=1,N_SAMPLE
          IU_CUR   = MIN(INT(U_SAMPLE(I)*RSQ*1000.0),20000)
          DGAUS    = GAUSS(IU_CUR+1)
          HD_S0(I) = HD_S0(I) + CC0*DGAUS
          HD_S2(I) = HD_S2(I) + CC2*DGAUS
          HD_S4(I) = HD_S4(I) + CC4*DGAUS
        ENDDO
      ENDDO
c
C---Now we have second deriv approximation at the sample points.
C---Approximate diagonal elements for second derivatives
C
C--first calculate necessary constants
      CC0      = 2.0*REAL(NumSymmetry)
cd*NSMULT)
      CC2      = CC0*TWOPI**2/3.0
      CC4      = CC0*4.0*PI**4
      CC5      = CC0*2.0*PI**2
C     CC6      = CC0

C     C1111    = 13.0/60.0
      C1111    = 1.0/5.0
      C1212    = 4.0/15.0
C     C1212    = 7.0/30.0
C     C1122    = 7.0/120.0
      C1122    = 4.0/60.0

cd      DO   I=1,N_SAMPLE
cd        WRITE(*,*)U_SAMPLE(I)/2.0,1.0/(8.0*SQRT(CC2*HD_S2(I)))*PISQ8
cd      ENDDO
cd      STOP
cd      C1122 = 0.0
C
C---Loop over atoms
      IQ  = 1
      IXT = 1
      IU  = 1
      IQU = 1
      N_REFINED = 0
      I_INTER = -1
      DO   IA=1,N_ATOM
        IA1  = ATOM_REF_FLAG(IA)/10
        IA11 = ATOM_REF_FLAG(IA)-IA1*10
        IF(IA11.GE.1) THEN
          IF(IA11.LE.2) THEN
            IF(U_ANISO(2,IA).EQ.0.0) THEN
             IU  = IU  + 1
            ELSE
             IU  = IU + 21
            ENDIF
            IXT = IXT + 6
            IQ  = IQ  + 1
          ELSE
            N_REFINED = N_REFINED + 1
            IM     = ID_SF(IA)
            OCCUP2 = OCCUP(IA)*OCCUP(IA)
            IF(U_ANISO(2,IA).EQ.0.0) THEN
              U_CUR = U_ANISO(1,IA)
            ELSE
              U_CUR = (U_ANISO(1,IA)+U_ANISO(2,IA)+U_ANISO(3,IA))/3.0
            ENDIF
            U_CUR = U_CUR*FOURPISQ
            HUU1 = 0.0
            HXX1 = 0.0
            HQQ1 = 0.0
            DO   IG=1,NGAUS2
              U_CUR1 = U_CUR+CS_BB(IG,IM)       
C
C--Find values for HD_S0 and so on
              CALL  LINTER_VALUE2(N_SAMPLE,U_SAMPLE,HD_S0,U_CUR1,
     &                              I_INTER,HDC_S0)
              CALL  LINTER_VALUE2(N_SAMPLE,U_SAMPLE,HD_S2,U_CUR1,
     &                              I_INTER,HDC_S2)
              CALL  LINTER_VALUE2(N_SAMPLE,U_SAMPLE,HD_S4,U_CUR1,
     &                              I_INTER,HDC_S4)
              HXX1 = HXX1 + CS_AA(IG,IM)*HDC_S2
              HQQ1 = HQQ1 + CS_AA(IG,IM)*HDC_S0
              HUU1 = HUU1 + CS_AA(IG,IM)*HDC_S4
            ENDDO
            HQQ(IQ)    = HQQ1*CC0
            HQU1       = OCCUP(IA)*HXX1*CC5
            HXX1       = OCCUP2*HXX1*CC2
            HUU1       = OCCUP2*HUU1*CC4
            HXX(IXT  ) = HXX1
            HXX(IXT+1) = HXX1
            HXX(IXT+2) = HXX1
            DPIML1     = DPIML1 + HXX1
            DPIML2     = DPIML2 + HUU1
            IF(U_ANISO(2,IA).EQ.0.0) THEN
              HUU(IU)  = HUU1
              IU       = IU + 1
C
             HQU(IQU)  = HQU1
             IQU       = IQU + 1
            ELSE
              HUU1111    = HUU1*C1111
              HUU1212    = HUU1*C1212
              HUU1122    = HUU1*C1122
              HUU(IU  )  = HUU1111
              HUU(IU+1)  = HUU1111
              HUU(IU+2)  = HUU1111

              HUU(IU+3)  = HUU1212
              HUU(IU+4)  = HUU1212
              HUU(IU+5)  = HUU1212

              HUU(IU+6)  = HUU1122
              HUU(IU+7)  = HUU1122
              HUU(IU+11) = HUU1122
              IU         = IU + 21
C
              HQU(IQU)   = HQU1/3.0
              HQU(IQU+1) = HQU(IQU) 
              HQU(IQU+2) = HQU(IQU) 
              IQU        = IQU + 6
            ENDIF
            IXT = IXT + 6
            IQ  = IQ  + 1
          ENDIF
        ENDIF 
      ENDDO
cd      DO   IQ = 1,10
cd         WRITE(*,*)HQQ(IQ)
cd      ENDDO
cd      STOP
      CONST_LOC = REAL(2.0*N_REFINED)
      HESU_ML   = SQRT(CONST_LOC/DPIML1)
      HESU_ML_B = PISQ8*SQRT(CONST_LOC/DPIML2)
      
      RETURN
      END
C
      SUBROUTINE XGEOMADD(FX,FG,FT,WX,WG,qqm,qqv,AM_G,V_G,GX,GU,GQ,
     &     gu_anom,gq_anom,nmodel,atom_ligand,atom_ligand_sw,IERROR)
      IMPLICIT NONE
C
C---Subroutine to add X-ray and geom part of gradients and hessians
C---We assume that geometric part is in AM and V
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'anom.fh'
      
      INTEGER LWORK,IERROR,IA,N_TARGET,N_OBJECT,NW_UVAL,I1,I2,ID,
     &        NSYM_DIST(4,QQD)
      REAL FX,FG,FT,WX,WG
      integer qqm,qqv,nmodel
      REAL   AM_G(qqm),V_G(qqv),GX(*),GU(*),GQ(*),gu_anom(*),gq_anom(*)
      REAL   H_XXD,H_UUD(3),H_UQD,H_QQD
      real   h_uud_anom(3),h_uqd_anom,h_qqd_anom
      integer atom_ligand(n_atom_mod(2)), atom_ligand_sw(n_atom_mod(1))
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),  
     &     H_BQ,H_QB,H_UQ(6),H_QU(6)
      CHARACTER LINE*128 
      COMMON /DISTNS/ N_OBJECT( QQD),N_TARGET( QQD),NW_UVAL( QQD),
     &                NSYM_DIST
      integer iposa,it
      INTEGER NMAXU,IMX,IMX1,IMG,IA1,IA11,LM,LXG,LXM,LXMX,IPOSX,IPOSU,
     &        NMMAXU,I,IA2,IA12,IA21,IA22,im
      INTEGER COUNT_UP,J
      REAL XNX,XNB,GNX,GNB,GEOMDIAG,XRAYDIAG,RXTOGEOM,XTOGX,COSANGL,
     &     BTOGB,FX1,SCXR1
      INTEGER IAN
      REAL USAVE1(6),USAVE2(6),TEMP
C
cd      REAL HXX(6*MAXATOM),HUU(21*MAXATOM),HQQ(MAXATOM),HQU(6*MAXATOM)
cd      COMMON /REF_SEC/HXX,HUU,HQQ,HQU
C
      REAL DOT_R
      EXTERNAL DOT_R
c
      integer, allocatable :: u_hist(:)
      real, allocatable :: lig_val_save(:,:)
      
      if (DPPI_pl.and.nmodel.eq.2) then 
         allocate(lig_val_save(n_atom_mod(2),12))
      endif
C
C----Positional paramaters
      allocate(u_hist(n_atom))
c      SCALXRAY = 1.0
      XNX = 0.0
      GNX = 0.0
      XNB = 0.0
      GNB = 0.0
      IF(.NOT.HCALC) GOTO 100
      if(x_ray_flag.and.geom_flag.and.weight.eq.'AUTO') then
c         call adjust_x2g_weight(weight_loc)
      endif
      IF(X_RAY_FLAG) THEN
        IF(NVPOS.GT.0)
     +           XNX = SQRT(ABS(DOT_R(NVPOS,QQV,GX,GX))/REAL(NVPOS))
c
c---ADPs
        IF(ITEMP.NE.0) THEN
          IF(NVTMP.GT.0) THEN
             NMAXU = QQV-NVPOS
             XNB = SQRT(ABS(DOT_R(NVTMP,NMAXU,GU,GU))/FLOAT(NVTMP))
          ENDIF
c
c---Occupancies
        ENDIF
      ENDIF
      IF(GEOM_FLAG) THEN
        GNX = SQRT(ABS(DOT_R(NVPOS,QQV,V_G(1),V_G(1)))/FLOAT(NVPOS))
        IF(ITEMP.NE.0) THEN
          NMAXU = QQV-NVPOS
          GNB = SQRT(ABS(DOT_R(NVTMP,NMAXU,V_G(NVPOS+1),
     +                                   V_G(NVPOS+1)))/FLOAT(NVTMP))
        ENDIF
      ENDIF
C
C---Find relative weights using trace of second derivative matrix

      IF((WEIGHT.EQ.'MATR'.OR.WEIGHT.EQ.'AUTO').AND.REFID.EQ.'REST')THEN
        GEOMDIAG = 0.0
        XRAYDIAG = 0.0
        IMX      = 0
        IMX1     = 0
        IMG = 0
C
c---Find traces of x-ray and geomtric second derivatives
c will need to separate xraydiag geomdiag etc when geometry is supported for more models
        do im=1,nmodel
          DO    IA=1,N_ATOM_mod(im)
            IA1 = ATOM_REF_mod_FLAG(IA,im)/10
            IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
            IF(IA11.GT.2) THEN
c              CALL CALC_DIAG(XYZ_CRD(1,IA),HX_CALC,,,,)
              GEOMDIAG = GEOMDIAG+AM_G(IMX+1)+AM_G(IMX+2)+AM_G(IMX+3)
              CALL FAST_HESSIAN_DIAGONAL(IA,im,H_XXD,H_UUD,H_UQD,H_QQD,
     &             h_uud_anom,h_uqd_anom,h_qqd_anom)
              XRAYDIAG = XRAYDIAG+3*H_XXD
cd              XRAYDIAG = XRAYDIAG + HXX(IMX1+1)+HXX(IMX1+2)+HXX(IMX1+3)
              IMX      = IMX + 6
              IMX1     = IMX1 + 6
              IMG      = IMG + 3
            ELSEIF(IA11.GT.0) THEN
               IMX  = IMX + 6
               IMX1 = IMX1 + 6
               IMG  = IMG + 3
            ENDIF
          ENDDO
        enddo
        RXTOGEOM = 0.0
        IF(XRAYDIAG.NE.0.0)  RXTOGEOM = GEOMDIAG/XRAYDIAG
        IF(WEIGHT.EQ.'MATR') THEN
           SCALXRAY = RXTOGEOM*WEIGHTXMAT
        ELSEIF(WEIGHT.EQ.'AUTO') THEN
           SCALXRAY = WEIGHTAUTO
        ENDIF
        IF(SCALXRAY.LT.0.0) SCALXRAY = 0.0
        if(geomdiag.le.0) then
           writE(*,*)'weight matrix ',0.0
        else
           write(*,*)'weigth matrix ',xraydiag/geomdiag*scalxray
        endif
C     SCALXRAY=10.
      ELSEIF(WEIGHT.EQ.'GRAD'.AND.REFID.EQ.'REST') THEN
C
C---Weight using gradient.
C>IJT
        IF(XNX.LE.0.) THEN
          RXTOGEOM = 10./WEIGHTXMAT
        ELSE
          RXTOGEOM = GNX/XNX
        ENDIF
        SCALXRAY = RXTOGEOM*WEIGHTXMAT
C<IJT
      ENDIF
 100  CONTINUE
C
C---Monitor norm of gradients and so on
      FT = SCALXRAY*FX + FG
      IF(MON_STYLE.NE.'NONE') THEN
        IF(X_RAY_FLAG) THEN
          XNX = XNX*SCALXRAY
          WRITE(LINE,'(A,G15.3)')
     +              'Norm of X_ray positional gradient         ',XNX
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
        ENDIF
        IF(GEOM_FLAG) THEN
          WRITE(LINE,'(A,G15.3)')
     +              'Norm of Geom. positional gradient         ',GNX
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
        ENDIF
        IF(ITEMP.NE.0) THEN 
          IF(X_RAY_FLAG) THEN
            XNB = XNB*SCALXRAY
            WRITE(LINE,'(A,G15.3)')
     +              'Norm of X_ray B-factor gradient           ',XNB
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          ENDIF
          IF(GEOM_FLAG) THEN
            WRITE(LINE,'(A,G15.3)')
     +              'Norm of Geom. B-factor gradient           ',GNB
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          ENDIF
        ENDIF
        IF(GEOM_FLAG.AND.X_RAY_FLAG) THEN
          XTOGX = SCALXRAY*DOT_R(NVPOS,QQV,GX,V_G(1))
          COSANGL = 0.0
          IF(ABS(GNX).NE.0.0.AND.ABS(XNX).NE.0.0) 
     +                COSANGL = XTOGX/(GNX*XNX*FLOAT(NVPOS))
          WRITE(LINE, '(A,G15.3)')
     +              'Product of X_ray and Geom posit. gradients',XTOGX
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)   
          WRITE(LINE, '(A,F15.3)')
     +              ' Cosine of angle between them             ',COSANGL
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          IF(ITEMP.NE.0) THEN
            BTOGB   =  SCALXRAY*DOT_R(NVTMP,QQV,GU,V_G(NVPOS+1))
            COSANGL = 0.0
            IF(ABS(GNB).NE.0.0.AND.ABS(XNB).NE.0.0)
     +        COSANGL = BTOGB/(GNB*XNB*NVTMP)
            WRITE(LINE, '(A,G15.3)')
     +              'Product of X_ray and Geom B-fact gradients',BTOGB
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
            WRITE(LINE, '(A,F15.3)')
     +              ' Cosine of angle between them             ',COSANGL
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          ENDIF
          CALL ERRWRT(-1,' ')
          CALL ERRWRT(-1,' ')
          IF(GEOM_FLAG.AND.X_RAY_FLAG) THEN
            FX1 = SCALXRAY*FX
            WRITE(LINE,'(A,G15.4,A,G15.4,A,G15.4)')
     +       'Residuals: XRAY=',FX1,' GEOM=',FG,' TOTAL=',FT
          ELSEIF(.NOT.GEOM_FLAG .AND. X_RAY_FLAG) THEN
            WRITE(LINE,'(A,G15.4,A,G15.4,A,G15.4)')
     +           'Residuals: XRAY=',FX
          ELSEIF(GEOM_FLAG .AND. .NOT.X_RAY_FLAG) THEN
            WRITE(LINE,'(A,G15.4,A,G15.4,A,G15.4)')
     +           'Residuals: GEOM=',FG
          ENDIF
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
        ENDIF
      ENDIF
      IF(.NOT.X_RAY_FLAG) RETURN
C
C---These things should be precalculated
      LM    = NMPOS + 9*NDIS + 1
      LXG   = 1
      LXM   = 1
      LXMX  = 1
      SCXR1 = 0.0
      IF(GEOM_FLAG) SCXR1 = SCALXRAY
cd      scalxray = 0.0
*
      CALL ADD_TLS2DERIVS(nmodel,GX,GU)
*
c--- p+l 2 models GRADIENTS. adding geom from L part of 1. model to 2.
      iposx=0
      iposu=NVPOS
      IT=1
      if (DPPI_pl.and.nmodel.eq.2) then
c        write(*,*)'atommod', N_ATOM_mod(1), N_ATOM_mod(2)
        do im=1,nmodel
          do   IA=1,N_ATOM_mod(im)
            if(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
              IA1  = ATOM_REF_mod_FLAG(IA,im)/10
c              IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
              if (IA1.GE.0) then
                if (im.eq.1) then
                  ia2 = atom_ligand_sw(ia)
                  if(ia2.gt.0) THEN
                    lig_val_save(ia2,1) = V_G(IPOSX+1)
                    lig_val_save(ia2,2) = V_G(IPOSX+2)
                    lig_val_save(ia2,3) = V_G(IPOSX+3)
                    lig_val_save(ia2,4) = V_G(IPOSU+1)
                    if (U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                      lig_val_save(ia2,5) = V_G(IPOSU+2)
                      lig_val_save(ia2,6) = V_G(IPOSU+3)
                      lig_val_save(ia2,7) = V_G(IPOSU+4)
                      lig_val_save(ia2,8) = V_G(IPOSU+5)
                      lig_val_save(ia2,9) = V_G(IPOSU+6)
                    endif
                  endif
                else
                  if (atom_ligand(ia).ne.0) then
                    V_G(IPOSX+1) = lig_val_save(ia,1)
                    V_G(IPOSX+2) = lig_val_save(ia,2)
                    V_G(IPOSX+3) = lig_val_save(ia,3)
                    V_G(IPOSU+1) = lig_val_save(ia,4)
                    if (U_ANISO_mod(2,IA,im).gt.0.0) THEN
                      V_G(IPOSU+2) = lig_val_save(ia,5)
                      V_G(IPOSU+3) = lig_val_save(ia,6)
                      V_G(IPOSU+4) = lig_val_save(ia,7)
                      V_G(IPOSU+5) = lig_val_save(ia,8)
                      V_G(IPOSU+6) = lig_val_save(ia,9)
                    endif
                    lig_val_save(ia,1) = GX(IPOSX+1)
                    lig_val_save(ia,2) = GX(IPOSX+2)
                    lig_val_save(ia,3) = GX(IPOSX+3)
c      write(*,*) 'checking0:',im,ia,GX(IPOSX+1),GX(IPOSX+2),GX(IPOSX+3)
                    lig_val_save(ia,4) = GU(IT)
                    if (U_ANISO_mod(2,IA,im).gt.0.0) THEN
                      lig_val_save(ia,5) = GU(IT+1)
                      lig_val_save(ia,6) = GU(IT+2)
                      lig_val_save(ia,7) = GU(IT+3)
                      lig_val_save(ia,8) = GU(IT+4)
                      lig_val_save(ia,9) = GU(IT+5)
                    endif
                  endif
                endif
                iposx=iposx+3
                IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                  iposu=iposu+1
                  IT=IT+1
                ELSE
                  iposu=iposu+6
                  IT=IT+6
                ENDIF
              endif
            endif
          enddo
        enddo
      endif   
c--- p+l 2 models. gradients. adding x-ray from 2. model to L part of 1.
      iposx=0
      IT=1
      if (DPPI_pl.and.nmodel.eq.2) then
        im=1
        do   IA=1,N_ATOM_mod(im)
          if(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            IA1  = ATOM_REF_mod_FLAG(IA,im)/10
c            IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
            if (IA1.GE.0) then
              ia2 = atom_ligand_sw(ia)
              if(ia2.gt.0) THEN
                GX(IPOSX+1) = lig_val_save(ia2,1)
                GX(IPOSX+2) = lig_val_save(ia2,2)
                GX(IPOSX+3) = lig_val_save(ia2,3)
                GU(IT) = lig_val_save(ia2,4)
                if (U_ANISO_mod(2,IA,im).gt.0.0) THEN
                  GU(IT+1) = lig_val_save(ia2,5)
                  GU(IT+2) = lig_val_save(ia2,6)
                  GU(IT+3) = lig_val_save(ia2,7)
                  GU(IT+4) = lig_val_save(ia2,8)
                  GU(IT+5) = lig_val_save(ia2,9)
                endif
              endif  
c      write(*,*) 'checking1:',im,ia,GX(IPOSX+1),GX(IPOSX+2),GX(IPOSX+3)
              iposx=iposx+3
              IF(U_ANISO_mod(2,IA,im).EQ.0.0) THEN
                IT=IT+1
              ELSE
                IT=IT+6
              ENDIF
            endif
          endif
        enddo
      endif
C
      CALL AVECPVEC_R(NVPOS,QQV,SCALXRAY,GX(1),V_G(1),V_G(1),IERROR)
c
      IPOSX = 0
      IPOSU = LM-1
      iposa = 0
      it = 1
      xraydiag = 0.0
      do im=1,nmodel
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
C       
C---Add hessian elements if atoms are to be refined against X-ray also.
            IA1  = ATOM_REF_mod_FLAG(IA,im)/10
            IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
            IF(IA11.GE.3) THEN
C-----------save
              DO  IAN=1,6
                USAVE1(IAN) = U_ANISO_mod(IAN,IA,im)
              ENDDO
              IF (U_ANISO_mod(2,IA,im).GT.0.0.AND.
     &            UANISO_OLD_mod(2,IA,im).LE.0.0) THEN
                TEMP = ( U_ANISO_mod(1,IA,im)+U_ANISO_mod(2,IA,im) + 
     &                   U_ANISO_mod(3,IA,im) )/3.0
                if (im.eq.1) U_ANISO(1,IA) = TEMP
                U_ANISO_mod(1,IA,im) = TEMP
                DO  IAN=2,6
                  if (im.eq.1) U_ANISO(IAN,IA) = 0.0
                  U_ANISO_mod(IAN,IA,im) = 0.0
                ENDDO
              ENDIF
c------------end of save
c              if (DPPI_pl.and.nmodel.eq.2) then
c                if (im.eq.2.or.atom_ligand_sw(ia).eq.0) then
c                  CALL FAST_HESSIAN_DIAGONAL(IA,im,H_XXD,
c     &               H_UUD,H_UQD,H_QQD,h_uud_anom,h_uqd_anom,h_qqd_anom)
c                else
c                  H_XXD=0.
c                  H_UUD(1:3)=0.
c                  H_UQD=0.
c                  H_QQD=0.
c                  h_uud_anom(1:3)=0.
c                  h_uqd_anom=0.
c                  h_qqd_anom=0.
c                endif
c              else
                CALL FAST_HESSIAN_DIAGONAL(IA,im,H_XXD,H_UUD,H_UQD,
     &             H_QQD,h_uud_anom,h_uqd_anom,h_qqd_anom)
c              endif
              xraydiag = xraydiag + 3.0*H_xxd
        
c p+l 2 models
              if (DPPI_pl.and.nmodel.eq.2) then
                if (im.eq.1) then
                  ia2 = atom_ligand_sw(ia)
                  if(ia2.gt.0) THEN
                    lig_val_save(ia2,1) = AM_G(IPOSX+1) 
                    lig_val_save(ia2,2) = AM_G(IPOSX+2) 
                    lig_val_save(ia2,3) = AM_G(IPOSX+3) 
                    h_xxd = 0.
                  endif
                else 
                  if (atom_ligand(ia).ne.0) then
                    AM_G(IPOSX+1) = lig_val_save(ia,1)
                    AM_G(IPOSX+2) = lig_val_save(ia,2)
                    AM_G(IPOSX+3) = lig_val_save(ia,3)
                    lig_val_save(ia,1) = SCALXRAY*H_XXD 
                    lig_val_save(ia,2) = SCALXRAY*H_XXD 
                    lig_val_save(ia,3) = SCALXRAY*H_XXD 
                  endif
                endif
              endif
c
              AM_G(IPOSX+1) = AM_G(IPOSX+1) + SCALXRAY*H_XXD
              AM_G(IPOSX+2) = AM_G(IPOSX+2) + SCALXRAY*H_XXD
              AM_G(IPOSX+3) = AM_G(IPOSX+3) + SCALXRAY*H_XXD
c      write(*,*)'secd0',im,ia,AM_G(IPOSX+1),AM_G(IPOSX+2),AM_G(IPOSX+3)
c        if (im.eq.2.or.ia.eq.100)  write(*,*)'xgeom hess',
c     & im,ia,AM_G(IPOSX+1),AM_G(IPOSX+2),AM_G(IPOSX+3)
              IPOSX = IPOSX + 6
c       
c---Save u as well as uq derivs
              iposa = iposa+1
              IF(ITEMP.NE.0) THEN
                IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
C---------------isotropic
ccc        if (cs_anom(id_sf(ia))) write(*,*) 'inside xgeom',im,ia,
ccc     +  AM_G(IPOSU+1),SCALXRAY*H_UUD(1),IPOSU+1,nmpos+ 9*NDIS
                  AM_G(IPOSU+1) = AM_G(IPOSU+1) + SCALXRAY*H_UUD(1)
c p+l 2 models
                  if (DPPI_pl.and.nmodel.eq.2) then
                    if (im.eq.1) then
                      ia2 = atom_ligand_sw(ia)
                      if (ia2.gt.0) THEN
                        lig_val_save(ia2,4) = AM_G(IPOSU+1)
                        H_UUD(1) = 0.
                      endif
                    else
                      if (atom_ligand(ia).ne.0) then
                        AM_G(IPOSU+1) = lig_val_save(ia,4)
                        lig_val_save(ia,4) = SCALXRAY*H_UUD(1)
                      endif
                    endif
                  endif
                  IPOSU = IPOSU + 1
                ELSE
C---------------anisotropic
C       
                  if (DPPI_pl.and.nmodel.eq.2) then
                    if (im.eq.1) then
                      ia2 = atom_ligand_sw(ia)
                      if (ia2.gt.0) THEN
                        lig_val_save(ia2,4) = AM_G(IPOSU+1)
                        lig_val_save(ia2,5) = AM_G(IPOSU+2)
                        lig_val_save(ia2,6) = AM_G(IPOSU+3)
                        lig_val_save(ia2,7) = AM_G(IPOSU+4)
                        lig_val_save(ia2,8) = AM_G(IPOSU+5)
                        lig_val_save(ia2,9) = AM_G(IPOSU+6)
                        lig_val_save(ia2,10) = AM_G(IPOSU+7)
                        lig_val_save(ia2,11) = AM_G(IPOSU+8)
                        lig_val_save(ia2,12) = AM_G(IPOSU+12)
                        H_UUD(1) = 0.
                        H_UUD(2) = 0.
                        H_UUD(3) = 0.
                      endif
                    else 
                      if (atom_ligand(ia).ne.0) then
                        AM_G(IPOSU+1) = lig_val_save(ia,4)
                        AM_G(IPOSU+2) = lig_val_save(ia,5)
                        AM_G(IPOSU+3) = lig_val_save(ia,6)
                        AM_G(IPOSU+4) = lig_val_save(ia,7)
                        AM_G(IPOSU+5) = lig_val_save(ia,8)
                        AM_G(IPOSU+6) = lig_val_save(ia,9)
                        AM_G(IPOSU+7) = lig_val_save(ia,10)
                        AM_G(IPOSU+8) = lig_val_save(ia,11)
                        AM_G(IPOSU+12) = lig_val_save(ia,12)
                        lig_val_save(ia,4) = SCALXRAY*H_UUD(1)
                        lig_val_save(ia,5) = SCALXRAY*H_UUD(1)
                        lig_val_save(ia,6) = SCALXRAY*H_UUD(1) 
                        lig_val_save(ia,7) = SCALXRAY*H_UUD(2)
                        lig_val_save(ia,8) = SCALXRAY*H_UUD(2)
                        lig_val_save(ia,9) = SCALXRAY*H_UUD(2) 
                        lig_val_save(ia,10) = SCALXRAY*H_UUD(3)
                        lig_val_save(ia,11) = SCALXRAY*H_UUD(3)
                        lig_val_save(ia,12) = SCALXRAY*H_UUD(3) 
                      endif
                    endif
                  endif
                  AM_G(IPOSU+1)  = AM_G(IPOSU+1)  + SCALXRAY*H_UUD(1)
                  AM_G(IPOSU+2)  = AM_G(IPOSU+2)  + SCALXRAY*H_UUD(1)
                  AM_G(IPOSU+3)  = AM_G(IPOSU+3)  + SCALXRAY*H_UUD(1)
                  AM_G(IPOSU+4)  = AM_G(IPOSU+4)  + SCALXRAY*H_UUD(3)
                  AM_G(IPOSU+5)  = AM_G(IPOSU+5)  + SCALXRAY*H_UUD(3)
                  AM_G(IPOSU+6)  = AM_G(IPOSU+6)  + SCALXRAY*H_UUD(3)
                  AM_G(IPOSU+7)  = AM_G(IPOSU+7 ) + SCALXRAY*H_UUD(2)
                  AM_G(IPOSU+8)  = AM_G(IPOSU+8 ) + SCALXRAY*H_UUD(2)
                  AM_G(IPOSU+12) = AM_G(IPOSU+12) + SCALXRAY*H_UUD(2)
                  IPOSU = IPOSU + 21
                ENDIF
              ENDIF
C-----------restore
              DO  IAN = 1,6
                 if (im.eq.1) U_ANISO(IAN,IA) = USAVE1(IAN)
                 U_ANISO_mod(IAN,IA,im) = USAVE1(IAN)
              ENDDO
c-----------end of restore
            ELSE
              IPOSX = IPOSX + 6
              IF(UANISO_OLD_mod(2,IA,im).LE.0.0) IPOSU = IPOSU + 1
              IF(UANISO_OLD_mod(2,IA,im).GT.0.0) IPOSU = IPOSU + 21
            ENDIF
          ENDIF
        ENDDO
      enddo
c--- add hessian terms from 2. model to L part of 1. model
      if (DPPI_pl.and.nmodel.eq.2) then
        IPOSX = 0
        IPOSU = LM-1
        im=1
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            IA1  = ATOM_REF_mod_FLAG(IA,im)/10
            IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
            IF(IA11.GE.3) THEN
              ia2 = atom_ligand_sw(ia)
              if (ia2.gt.0) THEN
                AM_G(IPOSX+1) = AM_G(IPOSX+1) + lig_val_save(ia2,1)
                AM_G(IPOSX+2) = AM_G(IPOSX+2) + lig_val_save(ia2,2)
                AM_G(IPOSX+3) = AM_G(IPOSX+3) + lig_val_save(ia2,3)                
c      write(*,*)'secd1',im,ia,AM_G(IPOSX+1),AM_G(IPOSX+2),AM_G(IPOSX+3)
                IF(ITEMP.NE.0) THEN
                  AM_G(IPOSU+1) = AM_G(IPOSU+1) + lig_val_save(ia2,4)
                  if(U_ANISO_mod(2,IA,im).gt.0.0) THEN
                    AM_G(IPOSU+2) = AM_G(IPOSU+2) + lig_val_save(ia2,5)
                    AM_G(IPOSU+3) = AM_G(IPOSU+3) + lig_val_save(ia2,6)
                    AM_G(IPOSU+4) = AM_G(IPOSU+4) + lig_val_save(ia2,7)
                    AM_G(IPOSU+5) = AM_G(IPOSU+5) + lig_val_save(ia2,8)
                    AM_G(IPOSU+6) = AM_G(IPOSU+6) + lig_val_save(ia2,9)
                    AM_G(IPOSU+7) = AM_G(IPOSU+7) + lig_val_save(ia2,10)
                    AM_G(IPOSU+8) = AM_G(IPOSU+8) + lig_val_save(ia2,11)
                    AM_G(IPOSU+12) = AM_G(IPOSU+12)+lig_val_save(ia2,12)
                  endif
                ENDIF
              endif
            ENDIF
            IPOSX = IPOSX + 6
            IF(UANISO_OLD_mod(2,IA,im).LE.0.0) IPOSU = IPOSU + 1
            IF(UANISO_OLD_mod(2,IA,im).GT.0.0) IPOSU = IPOSU + 21
          ENDIF
        enddo
      endif
c
      IF(XNONDIAG_FLAG) THEN
c one model only assumed here. maybe could be added when adding geometry for more models.
c but nondiag is probably not going to be used for more models anyway.
C
C---Find positions of U values in the diagonal of hessian
        COUNT_UP = NMPOS + 9*NDIS
        IA1 = 0
        im=1
        DO   IA=1,N_ATOM_mod(im)
          IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
            IA1 = IA1 + 1
            U_HIST(IA1) = COUNT_UP
            IF(UANISO_OLD_mod(2,IA,im).LE.0.0) THEN
              COUNT_UP = COUNT_UP + 1
            ELSE
              COUNT_UP = COUNT_UP + 21
            ENDIF
          ENDIF
        ENDDO
        IPOSX = NMPOS
        IPOSU = LM + NMTMP - 1
        DO  ID=1,NDIS
          I1 = N_TARGET(ID)
          I2 = N_OBJECT(ID)
          IA1 = ATOM_REF_mod_FLAG(I1,im)
          IA2 = ATOM_REF_mod_FLAG(I2,im)
          IA11 = IA1/10
          IA21 = IA2/10
          IA12 = IA1 - IA11*10
          IA22 = IA2 - IA21*10
          NW_UVAL(ID) = 1
          IF(IA12.GT.2.AND.IA22.GT.2) THEN
C---Consider case when pair of IAs are equal.
C---------save
            DO   IAN = 1,6
              USAVE1(IAN) = U_ANISO_mod(IAN,I1,im)
              USAVE2(IAN) = U_ANISO_mod(IAN,I2,im)
            ENDDO
            IF (U_ANISO_mod(2,I1,im).GT.0.0 .AND.
     &          UANISO_OLD_mod(2,I1,im).LE.0.0)  THEN
              TEMP = (U_ANISO_mod(1,I1,im)+U_ANISO_mod(2,I1,im)+
     &          U_ANISO_mod(3,I1,im))/3.0
              DO  IAN=1,6
                U_ANISO_mod(IAN,I1,im) = 0.0
              ENDDO
              U_ANISO_mod(1,I1,im) = TEMP
            ENDIF
            IF (U_ANISO_mod(2,I2,im).GT.0.0 .AND.
     &          UANISO_OLD_mod(2,I2,im).LE.0.0) THEN
              TEMP = (U_ANISO_mod(1,I2,im)+U_ANISO_mod(2,I2,im)+ 
     &          U_ANISO_mod(3,I2,im))/3.0
              DO  IAN=1,6
                U_ANISO_mod(IAN,I2,im) = 0.0
              ENDDO
              U_ANISO_mod(1,I2,im) = TEMP
            ENDIF
c----------end of save
            CALL FAST_HESSIAN_NONDIAGONAL(I1,I2,NSYM_DIST(1,ID),
     &      H_XX,H_UU,H_QQ,H_XB,H_XU,H_XQ,H_QX,H_BQ,H_QB,H_UQ,H_QU)
C---Take care of symmetry and atoms in the special positions.
C
cd            IF(I1.LE.10) THEN
cd               WRITE(*,*)H_XX
cd            ENDIF
            IF (I1.NE.I2) THEN
              CALL ADD_NONDIAG_X(IPOSX,SCALXRAY,AM_G,H_XX)
              IF (ITEMP.NE.0) THEN
                CALL ADD_NONDIAG_U(IPOSU,SCALXRAY,U_ANISO_mod(1,I1,im),
     &                               U_ANISO_mod(1,I2,im),AM_G,H_UU)
              ENDIF
            ELSE
              CALL FAST_HESSIAN_DIAGONAL(I1,im,H_XXD,H_UUD,H_UQD,H_QQD,
     &              h_uud_anom,h_uqd_anom,h_qqd_anom)
               CALL ADD_DIAG_X(IA11,SCALXRAY,AM_G,H_XX)
               IF (ITEMP.NE.0) THEN
                  CALL ADD_DIAG_U(U_HIST(IA11),SCALXRAY,
     &                            U_ANISO_mod(1,I1,im),AM_G,H_UU)
               ENDIF
               I = U_HIST(IA11)
               IPOSX = IPOSX + 9
               IF (U_ANISO(2,I1).LE.0.0) THEN
                  IPOSU = IPOSU + 1
               ELSE
                  IPOSU = IPOSU + 36
               ENDIF
            ENDIF
c----------restore
            DO   IAN=1,6
              if (im.eq.1) U_ANISO(IAN,I1) = USAVE1(IAN)
              if (im.eq.1) U_ANISO(IAN,I2) = USAVE2(IAN)
              U_ANISO_mod(IAN,I1,im) = USAVE1(IAN)
              U_ANISO_mod(IAN,I2,im) = USAVE2(IAN)
            ENDDO
C----------end of restore
          ELSE
            IPOSX = IPOSX + 9
            IF (UANISO_OLD_mod(2,I1,im).LE.0.0.AND.
     &          UANISO_OLD_mod(2,I2,im).LE.0.) THEN
              IPOSU = IPOSU + 1
            ELSE IF(UANISO_OLD_mod(2,I1,im).GT.0.0.AND.
     &              UANISO_OLD_mod(2,I2,im).LE.0.0.OR.
     &              UANISO_OLD_mod(2,I1,im).LE.0.0.AND.
     &              UANISO_OLD_mod(2,I2,im).GT.0.0) THEN
              IPOSU = IPOSU + 6
            ELSE
              IPOSU = IPOSU + 36
            ENDIF
          ENDIF
        ENDDO
      ENDIF
cd      STOP
      NBIS = NDIS
C
      IF(ITEMP.NE.0) THEN
        NMAXU   = QQV-NVPOS
        NMMAXU  = QQM-NMPOS

c      iposu=NVPOS
c      do im=1,nmodel
c      do ia=1,n_atom_mod(im)
c      iposu=iposu+1
c      write(*,*) 'grad bef',im,ia,V_G(iposu)
c      enddo
c      enddo
        CALL AVECPVEC_R(NVTMP,NMAXU,SCALXRAY,GU(1),V_G(NVPOS+1),
     +                         V_G(NVPOS+1),IERROR)
c      iposx=0
c      iposu=NVPOS
c      do im=1,nmodel
c      do ia=1,n_atom_mod(im)
c      iposx=iposx+3
c      iposu=iposu+1
c      if(im.eq.2.or.(ia.gt.3178)) write(*,*) 'grad aft, x',im,ia,
c     &  V_g(iposx-2),V_g(iposx-1),V_g(iposx),iposx
c      if(im.eq.2.or.ia.eq.100) write(*,*) 'grad aft, u',im,ia,V_G(iposu)
c      enddo
c      enddo
      ENDIF
      deallocate(u_hist)
      if (DPPI_pl.and.nmodel.eq.2) then
        deallocate(lig_val_save)
      endif
      RETURN
      END
C
      subroutine adjust_x2g_weight(qqm,qqv,AM_G,V_G,GX,GU,GQ,
     &     gu_anom,gq_anom,nmodel,atom_ligand,atom_ligand_sw,
     &     w_in,w_out,IERROR)
      IMPLICIT NONE
C
C---Subroutine to add X-ray and geom part of gradients and hessians
C---We assume that geometric part is in AM and V
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'anom.fh'
      include 'rharvest.fh'
c
      real w_in,w_out
      
      INTEGER LWORK,IERROR,IA,N_TARGET,N_OBJECT,NW_UVAL,I1,I2,ID,
     &        NSYM_DIST(4,QQD)
      REAL FX,FG,FT,WX,WG
      integer qqm,qqv,nmodel
      REAL   AM_G(qqm),V_G(qqv),GX(*),GU(*),GQ(*),gu_anom(*),gq_anom(*)
      REAL   H_XXD,H_UUD(3),H_UQD,H_QQD
      real   h_uud_anom(3),h_uqd_anom,h_qqd_anom
      integer atom_ligand(n_atom_mod(2)), atom_ligand_sw(n_atom_mod(1))
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),  
     &     H_BQ,H_QB,H_UQ(6),H_QU(6)
      CHARACTER LINE*128 
      COMMON /DISTNS/ N_OBJECT( QQD),N_TARGET( QQD),NW_UVAL( QQD),
     &                NSYM_DIST
      integer iposa,it
      INTEGER NMAXU,IMX,IMX1,IMG,IA1,IA11,LM,LXG,LXM,LXMX,IPOSX,IPOSU,
     &        NMMAXU,I,IA2,IA12,IA21,IA22,im
      INTEGER COUNT_UP,J
      REAL XNX,XNB,GNX,GNB,GEOMDIAG,XRAYDIAG,RXTOGEOM,XTOGX,COSANGL,
     &     BTOGB,FX1,SCXR1
      INTEGER IAN
      REAL USAVE1(6),USAVE2(6),TEMP
C
      REAL DOT_R
      EXTERNAL DOT_R
c
      real toler
      real zbond,rmsbond
      real zloose,ztight
      real zbond_l(100),rmsbond_l(100)
      character zlog(100)*1
      real, allocatable :: lig_val_save(:,:)
      real, allocatable :: am_l(:)
      real, allocatable :: v_l(:)
      real, allocatable :: dv_l(:)
      real, allocatable :: xyz_save(:,:)
      real, allocatable :: xyz_mod_save(:,:)
c
      logical correct_weight
c
      integer itemp_save,nmodel_save
      integer nvar,nmat,ncong
      real gamma,step
      LOGICAL   CONV_FLAG,GAMMA_FLAG,STEP_FLAG
      EXTERNAL SCALE_SHIFTS_ALL,SCALE_UVAL,MATMUL_UVAL,
     +         SCALE_POS,MATMUL_POS,INV_SCALE_POS,INV_SCALE_UVAL,
     +         SCALE_ALL,MATMUL_ALL,INV_SCALE_ALL
c
      real w_l
c
c---  body
      if(nbond_refmac.le.0) return
      zlog(1:100) = ' '
      if (DPPI_pl.and.nmodel.eq.2) then 
         allocate(lig_val_save(n_atom_mod(2),12))
      endif
      nmodel_save = nmodel
      nmodel = 1
      itemp_save = itemp
      itemp = 0
      allocate(xyz_save(3,n_atom))
      allocate(xyz_mod_save(3,n_atom))
      xyz_save(1:3,1:n_atom) = xyz_crd(1:3,1:n_atom)
      xyz_mod_save(1:3,1:n_atom) = xyz_crd_mod(1:3,1:n_atom,1)
C
C----Positional paramaters
      SCALXRAY = 1.0
      nvar = nvpos
      
C
C---These things should be precalculated
      LM    = NMPOS + 9*NDIS + 1
      nmat  = nmpos + 9*ndis + 1
      allocate(v_l(nvar))
      allocate(dv_l(nvar))
      allocate(am_l(nmat))

      LXG   = 1
      LXM   = 1
      LXMX  = 1
      SCXR1 = 0.0
cd      scalxray = 0.0
*
      CALL ADD_TLS2DERIVS(nmodel,GX,GU)
*
c--- p+l 2 models GRADIENTS. adding geom from L part of 1. model to 2.
      correct_weight = .FALSE.
      scalxray = w_in
      zbond_l(1) = zbond_vs_cycle(ncycle_overall)
      do while(correct_weight)
         v_l(1:nvar) = v_g(1:nmat)
         dv_l(1:nvar) = 0.0
         am_l(1:nmat) = am_g(1:nmat)
         
C
         CALL AVECPVEC_R(NVPOS,QQV,SCALXRAY,GX(1),v_l(1),
     &        v_l(1),IERROR)
c
         IPOSX = 0
         iposa = 0
         it = 1
         do im=1,nmodel
            DO   IA=1,N_ATOM_mod(im)
               IF(ATOM_REF_mod_FLAG(IA,im).GT.0) THEN
C     
C---  Add hessian elements if atoms are to be refined against X-ray also.
                  IA1  = ATOM_REF_mod_FLAG(IA,im)/10
                  IA11 = ATOM_REF_mod_FLAG(IA,im)-IA1*10
                  IF(IA11.GE.3) THEN
                     
                     CALL FAST_HESSIAN_DIAGONAL(IA,im,H_XXD,H_UUD,H_UQD,
     &                    H_QQD,h_uud_anom,h_uqd_anom,h_qqd_anom)
c     
                     am_l(IPOSX+1) = am_l(IPOSX+1) + SCALXRAY*H_XXD
                     am_l(IPOSX+2) = am_l(IPOSX+2) + SCALXRAY*H_XXD
                     am_l(IPOSX+3) = am_l(IPOSX+3) + SCALXRAY*H_XXD
c     write(*,*)'secd0',im,ia,AM_G(IPOSX+1),AM_G(IPOSX+2),AM_G(IPOSX+3)
c     if (im.eq.2.or.ia.eq.100)  write(*,*)'xgeom hess',
c     & im,ia,AM_G(IPOSX+1),AM_G(IPOSX+2),AM_G(IPOSX+3)
                     IPOSX = IPOSX + 6
                  endif
               ENDIF
            ENDDO
         enddo
c
c---  add the distance block
         call cgsol_rm(nvar,ncong,toler,am_l,v_l,dv_l,scale_all,
     &        matmul_all,scale_shifts_all,inv_scale_all,ierror,
     &        gamma_flag,gamma,step_flag,step,nmodel)
         step = 1.0
         call add_shift_xonly(nmodel,step,dv_l)
         call calc_rms_bond(rmsbond,zbond)
         zbond_l(2)   = zbond
c
c---  How to find correct weight based on rms bonds?
         if(zbond_l(1).le.zb_mx.and.zbond_l(2).le.zb_mx.and.
     &        zbond_l(1).ge.zb_mn.and.zbond_l(2).ge.zb_mn) then
            correct_weight = .TRUE.
         else if(zbond_l(1).gt.zb_mx.and.
     &           zbond_l(2).lt.zbond_l(1)*zb_reduce) then
            correct_weight = .TRUE.
         else if(zbond_l(1).le.zb_mn.and.
     &           zbond_l(2).gt.zbond_l(1)*zb_increase.and.
     &           zbond_l(2).le.zb_mx) then
            correct_weight = .TRUE.
         else if(zbond_l(1).gt.zb_mx.and.zbond_l(2).le.zb_mx) then
            correct_weight = .TRUE.
         else if(zbond_l(1).lt.zb_mn.and.zbond_l(2).ge.zb_mn.and.
     &           zbond_l(2).le.zb_mx) then
            correct_weight = .TRUE.
         else if(zbond_l(2).gt.zb_mx) then
c
c---we need tighter restraints
            zlog(i) = 'L'
            zloose = scalxray
            scalxray = scalxray/1.3
            w_l = scalxray
            correct_weight = .FALSE.
         else if(zbond_l(i+1).lt.zb_mn) then
            zlog(i) = 'T'
            ztight = scalxray
            scalxray = scalxray*1.3
            w_l = scalxray
            correct_weight = .FALSE.
         endif
         if(i.gt.1) then
            if(zlog(i-1).ne.zlog(i)) then
               scalxray = (zloose+ztight)/2.0
               w_l = scalxray
               correct_weight = .TRUE.
            else if(zlog(i).eq.'L'.and.zlog(i-1).eq.'L') then
               scalxray = scalxray/1.3
               w_l = scalxray
               correct_weight = .TRUE.
            else if(zlog(i).eq.'T'.and.zlog(i-1).eq.'T') then
               scalxray = scalxray*1.3
               correct_weight = .TRUE.
            endif
         endif
      enddo
c
      w_out = scalxray
      nmodel = nmodel_save
      itemp = itemp_save
      xyz_crd(1:3,1:n_atom) = xyz_save(1:3,1:n_atom)
      xyz_crd_mod(1:3,1:n_atom,1) = xyz_mod_save(1:3,1:n_atom)
      deallocate(xyz_save)
      deallocate(xyz_mod_save)
      deallocate(v_l)
      deallocate(dv_l)
      deallocate(am_l)
      if (DPPI_pl.and.nmodel.eq.2) then
         deallocate(lig_val_save)
      endif
      RETURN
      END
C
      SUBROUTINE ADD_NONDIAG_X(IPOSX,SCALEXRAY,AM,H_XX)
      IMPLICIT NONE
C
c--Comment
      INTEGER IPOSX
      REAL AM(*),SCALEXRAY,H_XX(3,3)
C
      AM(IPOSX + 1) = AM(IPOSX+1) + SCALEXRAY*H_XX(1,1)
      AM(IPOSX + 2) = AM(IPOSX+2) + SCALEXRAY*H_XX(1,2)
      AM(IPOSX + 3) = AM(IPOSX+3) + SCALEXRAY*H_XX(1,3)
      AM(IPOSX + 4) = AM(IPOSX+4) + SCALEXRAY*H_XX(2,1)
      AM(IPOSX + 5) = AM(IPOSX+5) + SCALEXRAY*H_XX(2,2)
      AM(IPOSX + 6) = AM(IPOSX+6) + SCALEXRAY*H_XX(2,3)
      AM(IPOSX + 7) = AM(IPOSX+7) + SCALEXRAY*H_XX(3,1)
      AM(IPOSX + 8) = AM(IPOSX+8) + SCALEXRAY*H_XX(3,2)
      AM(IPOSX + 9) = AM(IPOSX+9) + SCALEXRAY*H_XX(3,3)
      IPOSX = IPOSX + 9
      RETURN
      END
c
      SUBROUTINE ADD_DIAG_X(IP,SCALEXRAY,AM,H_XX)
      IMPLICIT NONE
C
c--Comment
      INTEGER IP,IPOS
      REAL AM(*),SCALEXRAY,H_XX(3,3)
C
      IPOS = (IP-1)*6
      AM(IPOS + 1) = AM(IPOS+1) + SCALEXRAY*H_XX(1,1)
      AM(IPOS + 2) = AM(IPOS+2) + SCALEXRAY*H_XX(2,2)
      AM(IPOS + 3) = AM(IPOS+3) + SCALEXRAY*H_XX(3,3)
      AM(IPOS + 4) = AM(IPOS+4) + SCALEXRAY*H_XX(1,2)
      AM(IPOS + 5) = AM(IPOS+5) + SCALEXRAY*H_XX(1,3)
      AM(IPOS + 6) = AM(IPOS+6) + SCALEXRAY*H_XX(2,3)
      RETURN
      END
C
      SUBROUTINE ADD_NONDIAG_U(IPOSU,SCALEXRAY,U1,U2,AM,H_UU)
      IMPLICIT NONE
C
c--Comment
      INTEGER IPOSU,IANISO,IANISO1
      REAL SCALEXRAY
      REAL U1(6),U2(6),AM(*),H_UU(6,6)
C
C-----both atoms isotropic
      IF (U1(2).le.0.0.and.U2(2).le.0.0) THEN
        AM(IPOSU+1) = AM(IPOSU + 1) + SCALEXRAY* H_UU(1,1)
        IPOSU = IPOSU + 1
      ELSEIF (U1(2).gt.0.0.and.U2(2).gt.0.0) THEN
C---------both atoms anisotropic
        DO IANISO=1,6
          DO IANISO1=1,6
            AM(IPOSU+1) = AM(IPOSU+1) + SCALEXRAY*H_UU(IANISO1,IANISO)
            IPOSU       = IPOSU + 1
          ENDDO
        ENDDO
C---On of them is isotropic, another anisotropic
      ELSE
        DO IANISO=1,6
          AM(IPOSU+1) = AM(IPOSU+1) + SCALEXRAY*H_UU(IANISO,1)
          IPOSU       = IPOSU + 1
        ENDDO
      ENDIF
      RETURN
      END
c
      SUBROUTINE ADD_DIAG_U(IPOSU,SCALXRAY,U1,AM_G,H_UU)
      IMPLICIT NONE
C
c--Comment
      INTEGER IPOSU,IANISO,IANISO1
      REAL SCALXRAY
      REAL U1(6),AM_G(*),H_UU(6,6)
C
C----- isotropic
      IF (U1(2).le.0.0) THEN
        AM_G(IPOSU+1) = AM_G(IPOSU + 1) + SCALXRAY*H_UU(1,1)
      ELSE
        AM_G(IPOSU+1)  = AM_G(IPOSU+1)  + SCALXRAY*H_UU(1,1)
        AM_G(IPOSU+2)  = AM_G(IPOSU+2)  + SCALXRAY*H_UU(2,2)
        AM_G(IPOSU+3)  = AM_G(IPOSU+3)  + SCALXRAY*H_UU(3,3)
        AM_G(IPOSU+4)  = AM_G(IPOSU+4)  + SCALXRAY*H_UU(4,4)
        AM_G(IPOSU+5)  = AM_G(IPOSU+5)  + SCALXRAY*H_UU(5,5)
        AM_G(IPOSU+6)  = AM_G(IPOSU+6)  + SCALXRAY*H_UU(6,6)
        AM_G(IPOSU+7)  = AM_G(IPOSU+7 ) + SCALXRAY*H_UU(1,2)
        AM_G(IPOSU+8)  = AM_G(IPOSU+8 ) + SCALXRAY*H_UU(1,3)
        AM_G(IPOSU+9)  = AM_G(IPOSU+9 ) + SCALXRAY*H_UU(1,4)
        AM_G(IPOSU+10) = AM_G(IPOSU+10) + SCALXRAY*H_UU(1,5)
        AM_G(IPOSU+11) = AM_G(IPOSU+11) + SCALXRAY*H_UU(1,6)
        AM_G(IPOSU+12) = AM_G(IPOSU+12) + SCALXRAY*H_UU(2,3)
        AM_G(IPOSU+13) = AM_G(IPOSU+13) + SCALXRAY*H_UU(2,4)
        AM_G(IPOSU+14) = AM_G(IPOSU+14) + SCALXRAY*H_UU(2,5)
        AM_G(IPOSU+15) = AM_G(IPOSU+15) + SCALXRAY*H_UU(2,6)
        AM_G(IPOSU+16) = AM_G(IPOSU+16) + SCALXRAY*H_UU(3,4)
        AM_G(IPOSU+17) = AM_G(IPOSU+17) + SCALXRAY*H_UU(3,5)
        AM_G(IPOSU+18) = AM_G(IPOSU+18) + SCALXRAY*H_UU(3,6)
        AM_G(IPOSU+19) = AM_G(IPOSU+19) + SCALXRAY*H_UU(4,5)
        AM_G(IPOSU+20) = AM_G(IPOSU+20) + SCALXRAY*H_UU(4,6)
        AM_G(IPOSU+21) = AM_G(IPOSU+21) + SCALXRAY*H_UU(5,6)
      ENDIF
      RETURN
      END
