C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE REF_MON(MDOC,LIST,NCYCLER,REFR,ITESTR,IMODE,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ener_com.fh'
C --------------------------------------------------------
      INCLUDE 'lib_com.fh'
C ----------------------------------------------------------------
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR,NCYCLER
      CHARACTER   REFR*1,LIST*1
      REAL        SLIMR
C ----------------------------------------------------------------
      INTEGER*2 ISYM(5,3,1)
      REAL      POOL(1)
      CHARACTER PROG_LIB_PATH*80,PROG_NAME*80 
C ----------------------------------------------------------------
      CHARACTER LINE*256,PATH*80,EXT*80
      INTEGER*4 NOSPGR_INPUT
      REAL      CELL_INPUT(6)
C==================================================================
      IERR   = 0
      SLIMR  = 0.0
      RESOLR = 0.0
C -----------------------------
      MD  = -ABS(MDOC)-1
      M   = 99
      MT  = 999
      IF(LIST.EQ.'T'.OR.LIST.EQ.'L') MT = MDOC

      CALL MSGDOC(MT,'--- libcheck_min---')
c     write(*,*) '--- libcheck_min---'
C ---
      IF(SLIMR  .LE.0.0) SLIMR   =-0.01  
      IF(NCYCLER.LE.0  ) NCYCLER = 10
C --------
      MEMORY  = 1
      NCRDMAX = 1
      IPRSYM  = 1
      NSYM    = 1
      NCYCLE  = NCYCLER
      ICYCLE  = 0
      SLIM    = 100.
      NAMEG   = ' '
      NAMEI   = ' '
      NAMER   = ' '
      NAMEV   = ' '
      NFUNCT  = 0
      NSTEP   = 0
      NGRAD   = 0
      NBACK   = 0
      NSHAKE  = 0
      WEIGHT  = 1.0
      IDEBUG  = 0
      IF(LIST.EQ.'T') IDEBUG = 1
      REF     = 'E'
      IF(REFR.EQ.'S') REF = 'S'
      IF(REFR.EQ.'P') REF = 'P'
c     REF     = REFR
      MOD_E   = 'N'

      IF(REF.EQ.'E') MOD_E = '2'

      MOD_D   = ' '
      MOD_R   = 'N'
      IF(RESOLR.LE.0.0) RESOLR = 1.0
      RESOL     = RESOLR
      SHIFT_LIM = 0.5
      SHIFT_MIN = 0.0
      SHIFT_SHK = 0.0
      SLIM   = SLIMR
C ---
      CALL MSGDOC(MDOC,' --- minimization ---')
C ---
      ITEST = ITESTR
      CALL INIT_AT_INF(MDOC,IERR)
      CALL GET_ATOM_LIBCHECK(MDOC,LIST,ITEST,IERR)
      IF(IERR.NE.0) THEN
c        IERR = 99
        GO TO 100
      ENDIF
      IF(REF.NE.'S') THEN
        CALL GET_RESTR_LIBCHECK(MDOC,LIST,ITEST,IERR)
        IF(IERR.NE.0) GO TO 100
      ENDIF

      IF(REF.EQ.'P') THEN
        CALL LIBCHECK_IDEAL(MDOC,LIST,ITEST,IERR)
        IF(IERR.NE.0) GO TO 100
        GO TO 200
      ENDIF

      CALL M_MIN(MT,LIST,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)

      IF(IERR.NE.0) GO TO 100

      IF(REF.NE.'S') THEN      
        CALL EE_FUNCT(MT,LIST,IERR)
        IF(IERR.NE.0) GO TO 100
      ELSE
        CALL EE_FUNCT_S(MT,LIST,IERR)
        IF(IERR.NE.0) GO TO 100
      ENDIF

 200  CONTINUE

      CALL ATOM_BACK_LIBCHECK(MDOC,IERR)

      IF(LIST.EQ.'T') THEN
        write(line,*) ' --- after ref 3 ---'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          CALL W_CRD_LBC(MDOC,IA)
        ENDDO
      ENDIF

      IF(REF.EQ.'E') THEN

        CALL CRTOANG(IMODE,L1A_NATOM,L1A_IFORW,L1A_IBACK
     *  ,L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_X,L1A_Y,L1A_Z,L1A_ID_PSI)

        IF(LIST.EQ.'T') THEN
          write(line,*) ' --- after ref : crd --> ang ---',imode
          CALL MSGDOC(MDOC,LINE)
          DO    IA=1,L1A_NATOM
            CALL W_CRD_LBC(MDOC,IA)
          ENDDO
        ENDIF

c        CALL ANGTOCR(MDOC,LIST,L1A_ISTART,L1A_IFINISH
c     *  ,L1A_X,L1A_Y,L1A_Z,L1A_NDIST
c     *  ,L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_CONN,MAX1BRN,IERR)

      ENDIF

      IF(LIST.EQ.'T') THEN
        write(line,*) ' ---after libcheck_min ---'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          CALL W_CRD_LBC(MDOC,IA)
        ENDDO
        write(line,*) ' ------'
      ENDIF



C --------------------------------------
 100  CONTINUE
      RETURN
      END

      SUBROUTINE GET_ATOM_LIBCHECK(MDOC,LIST,ITEST,IERR)
C --------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'rstr_com.fh'
C --------------------------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   LINE*256,LIST*1
C --------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      IF(L1A_NATOM.LE.3) THEN
c       IERR = 99 
        IERR = 98
        RETURN
      ENDIF
C ---------
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM + L1A_NDUMMY
        write(line,*) ' libchec_min..'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *  '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        write(line,*) ' nplan:',L1P_NPLAN
        CALL MSGDOC(MDOC,LINE)
        IF(L1P_NPLAN.GT.0) THEN
          DO  IP=1,L1P_NPLAN
            write(line,*) ' Iplan,NA:',IP,L1P_NATOM(IP)
            CALL MSGDOC(MDOC,LINE)
            IF(L1P_NATOM(IP).GT.0) THEN
              DO K=1,L1P_NATOM(IP)

                write(line,*) 
     *          '    A:',L1A_ANAME(L1P_IATOM(K,IP)),':',L1P_IATOM(K,IP)
                CALL MSGDOC(MDOC,LINE)
              ENDDO
            ENDIF
          ENDDO
        ENDIF

      ENDIF
C ---

C
      N_ATOM        = L1A_NATOM + L1A_NDUMMY
      IF(REF.NE.'S') N_ATOM = L1A_NATOM 
      N_GROUP       = 1
      GROUP_ID(1)   = 'AA  '
      NRES_CHAIN(1) = 1
      IRES_FIRST(1) = 1
      I_CHAIN(1)    = 1
      NATM_RES(1)   = N_ATOM
      RES_NUM_PDB(1)= 'AA   1 AA   '
      RES_NAME(1)   = L1L_MNAME
      IRATM_FIRST(1)= 1
      N_TREE        = 1
      IATM_FIRST_TREE(1) = 1 
      XYZ_TREE(1,1)     = 0.0
      XYZ_TREE(2,1)     = 0.0
      XYZ_TREE(3,1)     = 0.0
      ANGLES_TREE(1,1)  = 0.0
      ANGLES_TREE(2,1)  = 0.0
      ANGLES_TREE(3,1)  = 0.0
      DO I=1,N_ATOM
        ATM_NAME(I)   = L1A_ANAME(I)
        ATM_NAME_INP(I) = L1A_ANAME(I)
        ATM_CHEM(I)   = L1A_CHEM(I)
        ATM_TYPE(I)   = L1A_ATYPE(I)
        CHEM_TYPE(I)  = L1A_CHEM(I)
        ID_TREE(I)    = 1
        I_RESID (I)   = 1 
        B_FLAG(I)     = 0
        DO IAN=1,6
          U_ANISO(IAN,I) = 0.0
        ENDDO
        U_ANISO(1,I)  = 20.0
        ID_ALT   (I)  = '.'
        SEG_ID   (I)  = '.'
        ID_CORR  (I)  = '.'
        XYZ_CRD (1,I) = L1A_X(I)
        XYZ_CRD (2,I) = L1A_Y(I)
        XYZ_CRD (3,I) = L1A_Z(I)
        OCCUP(I)      = 1.0
        IF(L1A_COOR_FLAG(I).NE.'Y') OCCUP(I) = 0.0
        I_RESID(I)    = 1 

        ATM_DIST  (I) = L1A_LENGTH(I)
        ATM_THETA (I) = L1A_THETA(I)
        ATM_PSI   (I) = L1A_PHI(I)
        IATM_BACK (I) = L1A_IBACK(I)
        IATM_FOR  (I) = L1A_IFORW(I)
        ATM_NDIST (I) = L1A_NDIST(I)

        IATM_EXTR (I) = 0
        IATM_EXTR2(I) = 0
        IATM_EXTR3(I) = 0
        IF(L1A_NEXTR(I).GT.0) THEN
          IATM_EXTR (I) = L1A_IEXTR(1,I)
          IF(L1A_NEXTR(I).GT.1) IATM_EXTR2(I) = L1A_IEXTR(2,I)
          IF(L1A_NEXTR(I).GT.2) IATM_EXTR3(I) = L1A_IEXTR(3,I)
        ENDIF

C       ID_PSI(I) = L1A_ID_PSI(I)(1:4) 
        ID_PSI(I) = 'C'

        IF(REF.NE.'S') IPOINTER_VAR(I) = 1 

      ENDDO

      N_PHI   = 0
      NR_BOND = 0
C--   NR_VDW=0 whitout VDW (REF=S)  
      NR_VDW  = 1
      IATM_LAST_TREE(1) = 0 
      ATM_NDUMMY = 0
      IF(REF.EQ.'S') THEN
        IF(ITEST.LT.0) NR_VDW  = 0
        DO I=1,N_ATOM
          IF(IATM_BACK(I).LE.0) ATM_ISTART  = I
          IF(IATM_FOR(I) .LT.0) THEN
            ATM_IFINISH = I      
            IATM_LAST_TREE(1) = I 
          ENDIF
          DO J=1,MAXBRN 
            ATM_CONN(J,I) = 0
          ENDDO
          IF(L1A_NDIST(I).GT.0) THEN
            DO J=1,L1A_NDIST(I)
              ATM_CONN(J,I) = L1A_CONN(J,I)
            ENDDO
          ENDIF
C          J = IATM_FOR(I)
C          IF(J.GT.0.AND.ID_PSI(I)(1:1).NE.'C') THEN
C            N_PHI = N_PHI + 1
C            PHI_VAR(N_PHI) = ATM_PSI(J)  
C            ID_PHI(I)      = N_PHI 
C            IP_PSI (N_PHI) = I
C            IPOINTER_VAR(N_PHI) = I 
C            ID_PSI(I)      = 'var'
C          ENDIF
        ENDDO
        IF(IATM_LAST_TREE(1).GE.0) IATM_LAST_TREE(1) = N_ATOM 

        IF(L1A_NDUMMY.GT.0) THEN
          ATM_NDUMMY = L1A_NDUMMY
          DO I=L1A_NATOM+1,L1A_NATOM+L1A_NDUMMY
            IB = IATM_BACK(I)
            ND = ATM_NDIST(IB)
            IF(ND.GT.0) THEN
              JJ = ATM_CONN(ND,IB)
              ATM_CONN(ND  ,IB) = I
              ATM_CONN(ND+1,IB) = JJ
            ELSE
              ATM_CONN(1,IB) = I
              IATM_FOR(IB)   = I
            ENDIF
            ATM_NDIST(IB) = ND + 1
C            J = IATM_FOR(IB)
C            IF(J.EQ.1.OR.ID_PSI(I)(1:1).EQ.'C') THEN
C              N_PHI = N_PHI + 1
C              PHI_VAR(N_PHI) = ATM_PSI(J)  
C              ID_PHI(IB)      = N_PHI 
C              IP_PSI (N_PHI) = IB
C              IPOINTER_VAR(N_PHI) = IB 
C              ID_PSI(IB)      = 'var'
C            ENDIF
            NE = L1A_NEXTR(I)
            IF(NE.GT.0) THEN
              NR_BOND = NR_BOND + 1
              RB_VIDL (NR_BOND) = 0.0
              RB_SDID (NR_BOND) = 0.02
              RB_CNST (NR_BOND) = 450.0
              RB_IA1  (NR_BOND) = I
              RB_IA2  (NR_BOND) = L1A_IEXTR(1,I)
            ENDIF          
          ENDDO
        ENDIF
C ----
        DO I=1,N_ATOM
          J = IATM_FOR(I)
          IF(J.GT.0) THEN
            IF(L1A_ID_PSI(J)(1:1).EQ.'V'.OR.
     *         L1A_ID_PSI(J)(1:1).EQ.'v'    ) THEN
              N_PHI = N_PHI + 1
              PHI_VAR(N_PHI) = ATM_PSI(J)  
              ID_PHI(I)      = N_PHI 
              IP_PSI (N_PHI) = I
              IPOINTER_VAR(N_PHI) = I
              ID_PSI(I)      = 'var'
            ENDIF
          ENDIF
        ENDDO        

      ENDIF

        IF(LIST.EQ.'T') THEN
          NA     = N_ATOM
          write(line,*) ' libcheck_min_str',n_phi,nr_vdw,itest
          CALL MSGDOC(MDOC,LINE)
          write(line,*) 'first,LAST:',ATM_ISTART,ATM_IFINISH
          CALL MSGDOC(MDOC,LINE)
          LINE=
     *'name, back , forw  , nd,conn(1..5) , ext,ext2'
          CALL MSGDOC(MDOC,LINE)
          DO    IA=1,NA
          write(line,
     *  '(i2,1x,a4,1x,2i4,'';'',6i3,'';'',3i3,'';'',3F8.2,I4)') 
     *    ia,ATM_NAME(IA)
     *    ,iATM_back(Ia),iATM_FOR(Ia)
     *    ,ATM_NDIST(IA),(ATM_conn(j,ia),j=1,5)
     *    ,IaTM_extr(ia),IATM_extr2(ia),IATM_extr3(ia)
     *    ,ATM_DIST(IA),ATM_THETA(IA),ATM_PSI(IA),ID_PHI(IA)
          CALL MSGDOC(MDOC,LINE)
          ENDDO

          write(line,*) ' nbond:',NR_bond
          CALL MSGDOC(MDOC,LINE)
          IF(nr_bond.GT.0) THEN
            DO  Ib=1,nr_bond
            write(line,'(3I4,2F8.3)') 
     *      IB,RB_IA1(IB),RB_IA2(IB),RB_VIDL(IB),RB_CNST(IB) 
            CALL MSGDOC(MDOC,LINE)
            write(*,*)'-1:',XYZ_CRD(1,RB_IA1(IB))
     *      ,XYZ_CRD(2,RB_IA1(IB)),XYZ_CRD(3,RB_IA1(IB))
            write(*,*)'-2:',XYZ_CRD(1,RB_IA2(IB))
     *      ,XYZ_CRD(2,RB_IA2(IB)),XYZ_CRD(3,RB_IA2(IB))
            ENDDO
          ENDIF
          write(line,*) ' n_PHI:',N_PHI
          CALL MSGDOC(MDOC,LINE)
          IF(N_PHI.GT.0) THEN
            DO  I=1,n_PHI
            write(line,'(I4,F8.3,2I4)') 
     *      I,PHI_VAR(I),IP_PSI(I),IPOINTER_VAR(I)  
            CALL MSGDOC(MDOC,LINE)
            ENDDO
          ENDIF
        ENDIF
C ----
      IF(N_PHI.LE.0.AND.REF.EQ.'S') THEN
        IERR = 99
      ENDIF
C --------
      RETURN
      END

      SUBROUTINE ATOM_BACK_LIBCHECK(MDOC,IERR)
C --------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ref_com_str.fh'
C --------------------------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   LINE*256
C --------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      IF(N_ATOM.LE.0) RETURN
C
      DO I=1,N_ATOM
        L1A_X(I) = XYZ_CRD (1,I)
        L1A_Y(I) = XYZ_CRD (2,I) 
        L1A_Z(I) = XYZ_CRD (3,I)
C        OCCUP(I)      = 1.0
C        IF(L1A_COOR_FLAG(I).NE.'Y') OCCUP(I) = 0.0
        IF(REF.EQ.'S') THEN
         L1A_LENGTH(I) = ATM_DIST  (I) 
         L1A_THETA (I) = ATM_THETA (I) 
         L1A_PHI   (I) = ATM_PSI   (I) 
        ENDIF
      ENDDO
C --------
      RETURN
      END

      SUBROUTINE GET_RESTR_LIBCHECK(MDOC,LIST,ITEST,IERR)
C --------------------------------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C --------------------------------------------------------------
      COMMON/REF_NAMES_E/ SLIM,NAMER,NAMEV,NAMEG,NAMEI
      CHARACTER NAMER*80,NAMEV*80,NAMEG*80,NAMEI*80
      REAL      SLIM
C ==----------------------------------------------------------
      INTEGER     RS_NUM_OLD,I4(4)
      INTEGER     MDOC,IERR
      CHARACTER   LINE*256,LIST*1
      CHARACTER   C_LINE*256,ASYMB1*4,ASYMB2*4
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      IF(N_ATOM.LE.1) THEN
        CALL MSGERR(MDOC,'ERROR: number of atoms < 2')
        IERR=1
        RETURN
      ENDIF
C --------
      NR_BOND     = 0
      NR_ANGL     = 0
      NR_TORS     = 0
      NR_CHIR     = 0
      NR_PLAN     = 0
C --------------------------------
      IFLAG  = 0   
      C_LINE = ' '

C ITEST:  BOND,  1,3,8,9,10,11,12,13 
C         ANGLE, 2,3,8,9,10,11,12,13 
C         3 only BOND and ANGLE 
C        13 only BOND and ANGLE and VDW and HB
C         TORS   5,8,12,#9,#10,#11,#13
C         5 only tors   
C         CHIR   6,8,9,#10,#11,#12,#13
C         6 only chir
C         PLAN   7,8,9,10,11,12,#13
C         7 only plan
C         VDW and HB  4,11,13  
C       4 only VDW and HB 4  
C       8 whitout VDW and HB   
C       9 whitout tors, 
C      10 whitout tors and chir, 
C      11 whitout tors,chir
C      12 whitout chir,VDW,NB
      IF(ITEST.NE.4) THEN

        IF(L1B_NBOND.GT.0.AND.
     *     (ITEST.EQ.0.OR.ITEST.EQ.1.OR.ITEST.EQ.3.OR.ITEST.EQ.8.OR.
     *      ITEST.EQ.9.OR.ITEST.EQ.10.OR.ITEST.EQ.11.OR.
     *      ITEST.EQ.12.OR.ITEST.EQ.13))THEN
          DO IB =1,L1B_NBOND

            RS_NAME  = 'BOND'
            IA1      = L1B_I1ATM(IB)
            IA2      = L1B_I2ATM(IB)
            
            RS_VIDL  = L1B_VAL(IB)

            IF(L1B_TYPE(IB).NE.'dummy') THEN
            IF(IA1.GT.0.AND.IA2.GT.0.AND.IA1.LE.N_ATOM.AND.
     *         IA1.LE.N_ATOM.AND.RS_VIDL.GT.0.1) THEN
              RS_SDI   = L1B_DEV(IB)
              RS_LABEL = '.'
              RS_VOBS  = L1B_VOBS(IB)
              RS_CNS   = 450.0
              CALL GET_BOND_EMIN(MDOC,RS_NAME,NR_BOND,RS_LABEL,IA1,IA2
     *        ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *        ,C_LINE,IFLAG,IERR)
              IF(IERR.NE.0) RETURN

              IF(LIST.EQ.'T') THEN
                WRITE(LINE,'(A,3I4,A,A,A,2F8.3,A)') 
     *          'IB:',IB,IA1,IA2,L1B_1ATM(IB),' - '
     *          ,L1B_2ATM(IB),L1B_VAL(IB),L1B_VOBS(IB),L1B_TYPE(IB)
                CALL MSGDOC(MDOC,LINE)
              ENDIF
            
            ENDIF
            ENDIF
          ENDDO
        ENDIF

        IF(L1G_NANGL.GT.0.AND.
     *     (ITEST.EQ.0.OR.ITEST.EQ.2.OR.ITEST.EQ.3.OR.ITEST.EQ.8.OR.
     *      ITEST.EQ.9.OR.ITEST.EQ.10.OR.ITEST.EQ.11.OR.
     *      ITEST.EQ.12.OR.ITEST.EQ.13))THEN
         DO IG =1,L1G_NANGL
            RS_NAME  = 'ANGL'
            IA1      = L1G_I1ATM(IG)
            IA2      = L1G_I2ATM(IG)
            IA3      = L1G_I3ATM(IG)

            RS_VIDL  = L1G_VAL(IG)

            IF(IA1.GT.0.AND.IA2.GT.0.AND.IA3.GT.0.AND.
     *         IA1.LE.N_ATOM.AND.IA2.LE.N_ATOM.AND.IA3.LE.N_ATOM.AND.
     *         RS_VIDL.GT.0.1) THEN

              RS_SDI   = L1G_DEV(IG)
              RS_LABEL = '.'
              RS_VOBS  = L1G_VOBS(IG)
              RS_CNS   = 45.0

              CALL GET_ANGLE_EMIN(MDOC,RS_NAME,NR_ANGL
     *         ,RS_LABEL,IA1,IA2,IA3
     *         ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *         ,C_LINE,IFLAG,IERR)
              IF(IERR.NE.0) RETURN

              IF(LIST.EQ.'T') THEN
                WRITE(LINE,'(A,4I4,A,A,A,A,A,2F8.3)') 
     *          'IANG:',IG,IA1,IA2,IA3,L1G_1ATM(IG),' - '
     *          ,L1G_2ATM(IG),' - ',L1G_3ATM(IG),L1G_VAL(IG)
     *          ,L1G_VOBS(IG)
                CALL MSGDOC(MDOC,LINE)
              ENDIF

            ENDIF
          ENDDO 
        ENDIF

        IF((ITEST.EQ.0.OR.ITEST.EQ.5.OR.ITEST.EQ.8.OR.ITEST.EQ.12).AND.
     *     ITEST.NE.9.AND.ITEST.NE.10.AND.ITEST.NE.11.AND.
     *     ITEST.NE.13) THEN

          IF(L1T_NTORS.GT.0) THEN
            DO IT=1,L1T_NTORS
              IA1 = L1T_I1ATM(IT)
              IA2 = L1T_I2ATM(IT)
              IA3 = L1T_I3ATM(IT)
              IA4 = L1T_I4ATM(IT)
              RS_NAME  = 'TORS'
              RS_LABEL = L1T_LABEL(IT)
              RS_VIDL  = L1T_VAL(IT)
              RS_SDI   = L1T_DEV(IT)
              RS_VOBS  = L1T_VOBS(IT)
              RS_PRD   = L1T_PRD(IT)
              RS_CNS   = 5.0

            IF(IA1.GT.0.AND.IA2.GT.0.AND.IA3.GT.0.AND.IA4.GT.0.AND.
     *         IA1.LE.N_ATOM.AND.IA2.LE.N_ATOM.AND.IA3.LE.N_ATOM.AND.
     *         IA4.LE.N_ATOM.AND.
     *         RS_LABEL(1:6).EQ.'CONST_') THEN

              IF(RS_VIDL.LE.-360.0) RS_VIDL = RS_VIDL + 360.0 
              IF(RS_VIDL.LE.-180.0) RS_VIDL = RS_VIDL + 360.0 
        

              CALL GET_TORS_EMIN(MDOC,RS_NAME,NR_TORS,RS_LABEL
     *        ,IA1,IA2,IA3,IA4
     *        ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD,RS_CNS
     *        ,C_LINE,IFLAG,IERR)
              IF(IERR.NE.0) RETURN

              IF(LIST.EQ.'T') THEN
                WRITE(LINE,'(A,A,4I4,A,A,A,A,A,A,A,3F8.3)') 
     *          'ITOR:',L1T_LABEL(IT),IT,IA1,IA2,IA3,L1T_1ATM(IT),' - '
     *          ,L1T_2ATM(IT),' - ',L1T_3ATM(IT),' - '
     *          ,L1T_4ATM(IT),L1T_VAL(IT),RS_VIDL,L1T_VOBS(IT)
                CALL MSGDOC(MDOC,LINE)
              ENDIF

              ENDIF
            ENDDO
          ENDIF
        ENDIF

        IF((ITEST.EQ.0.OR.ITEST.EQ.6.OR.ITEST.EQ.8.OR.
     *      ITEST.EQ.9).AND.ITEST.NE.10.AND.ITEST.NE.11.AND.
     *      ITEST.NE.12.AND.ITEST.NE.13)THEN
          IF(L1C_NCHIR.GT.0) THEN
            DO IC=1,L1C_NCHIR
            IF(L1C_SIGN(IC)(1:4).NE.'star'.AND.
     *         L1C_SIGN(IC)(1:4).NE.'cros'     ) THEN
              IA1 = L1C_I1ATM(IC)
              IA2 = L1C_I2ATM(IC)
              IA3 = L1C_I3ATM(IC)
              IA4 = L1C_I4ATM(IC)

              IF(IA1.GT.0.AND.IA2.GT.0.AND.IA3.GT.0.AND.IA4.GT.0.AND.
     *           IA1.LE.N_ATOM.AND.IA2.LE.N_ATOM.AND.IA3.LE.N_ATOM.AND.
     *           IA4.LE.N_ATOM) THEN

                RS_NAME  = 'CHIR'
                RS_LABEL = L1C_SIGN(IC)
                RS_VIDL  = L1C_VOL(IC)
                RS_SDI   = 0.0
                RS_VOBS  = L1C_VOBS(IC)
                RS_CNS   = 120.0


                IF(LIST.EQ.'T') THEN
                  WRITE(LINE,'(A,A,4I4,A,A,A,A,A,A,A,2F8.3)') 
     *            'ICHR:',L1C_SIGN(IC),IC,IA1,IA2,IA3,L1C_1ATM(IC),' - '
     *            ,L1C_2ATM(IC),' - ',L1C_3ATM(IC),' - '
     *            ,L1C_4ATM(IC),L1C_VOL(IC),L1C_VOBS(IC)
                  CALL MSGDOC(MDOC,LINE)
                ENDIF

                CALL GET_CHIR_EMIN(MDOC,RS_NAME,NR_CHIR,RS_LABEL
     *          ,IA1,IA2,IA3,IA4
     *          ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *          ,C_LINE,IFLAG,IERR)
                IF(IERR.NE.0) RETURN

                CALL GET_CHIR_EMIN(MDOC,RS_NAME,NR_CHIR,RS_LABEL
     *          ,IA1,IA3,IA4,IA2
     *          ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *          ,C_LINE,IFLAG,IERR)
                IF(IERR.NE.0) RETURN

                CALL GET_CHIR_EMIN(MDOC,RS_NAME,NR_CHIR,RS_LABEL
     *          ,IA1,IA4,IA2,IA3
     *          ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *          ,C_LINE,IFLAG,IERR)
                IF(IERR.NE.0) RETURN

              ENDIF
            ENDIF
            ENDDO
          ENDIF
        ENDIF

        NR_PLAN    = 0
        NRPLAN     = 0
        RS_NUM_OLD =-1
        NP = L1P_NPLAN
        IF((ITEST.EQ.0.OR.ITEST.EQ.7.OR.ITEST.EQ.8.OR.
     *     ITEST.EQ.9.OR.ITEST.EQ.10.OR.ITEST.EQ.11.OR.
     *     ITEST.EQ.12).AND.ITEST.NE.13)THEN
          IF(NP.GT.0) THEN
            DO IP=1,NP
C             IF(L1P_NATOM(IP).GT.4) THEN
              IF(NR_PLAN.GE.MAXRPLAN) THEN
                CALL MSGERR(MDOC
     *          ,' ERROR: number of plan restraints > limit.')
                CALL MSGERR(MDOC
     *          ,'      change parameter MAXRPLAN in "rstr_com.fh"')
                IERR=1
                RETURN
              ENDIF
              NR_PLAN = NR_PLAN + 1
              RP_NATOM(NR_PLAN) = 0
              RP_LABEL(NR_PLAN) = L1P_LABEL(IP)
              RP_FLAG (NR_PLAN) = ' '
c L1P_FLAG(IAP)
              NAP = L1P_NATOM(IP)
              IF(NAP.GE.MAXRATMP) THEN
                CALL MSGERR(MDOC
     *          ,' ERROR: number of plan atoms > limit.')
                CALL MSGERR(MDOC
     *          ,'      change parameter MAXRATMP in "rstr-com.fh"')
                IERR=1
                RETURN
              ENDIF
              DO IAP=1,NAP
                RP_NATOM(NR_PLAN)     = RP_NATOM(NR_PLAN)+1
                NRA                   = RP_NATOM(NR_PLAN)
                RP_IATM (NRA,NR_PLAN) = L1P_IATOM(IAP,IP)
                RP_DEV  (NRA,NR_PLAN) = L1P_DEV(IAP,IP)
                RP_DOBS (NRA,NR_PLAN) = L1P_DOBS(IAP,IP)

              ENDDO
C             ENDIF
            ENDDO

            IF(LIST.EQ.'T') THEN
              WRITE(LINE,'(A,2I4)') 
     *        'PR=:',NR_PLAN,RP_NATOM(1)
              CALL MSGDOC(MDOC,LINE)
              DO IP=1,NR_PLAN
                NAPP=RP_NATOM(IP)
                DO IAP=1,NAPP
                  IA1 =  RP_IATM(IAP,IP)
                  WRITE(LINE,'(A,I4,A,I4,A,A)') 
     *            'PR:',IP,RP_LABEL(ip),IA1,' - ',L1A_ANAME(IA1)
                  CALL MSGDOC(MDOC,LINE)
                ENDDO
              ENDDO
            ENDIF

          ENDIF   
        ENDIF
     
      ENDIF
C------------------------------ --------
      IFLAG_VDW = 0
      IFLAG_HB  = 0
      NR_VDW    = 0
      NR_HB     = 0
      IFLAG  = 0   
      C_LINE = ' '      
C --------
C     IF((ITEST.NE.0.AND.ITEST.NE.4).OR.ITEST.EQ.9) GO TO 500
      IF(ITEST.NE.0.AND.ITEST.NE.4.AND.ITEST.NE.11.AND.ITEST.NE.13) 
     * GO TO 500

      DO IA1=1,N_ATOM-1
        DO IA2=IA1+1,N_ATOM        

          IFLAG_VDW = 0
          IFLAG_HB  = 0

          CALL CHECK_POSSIBLE_VDW_LBC(MDOC,IA1,IA2,ICHECK,IERR)
          IF(ICHECK.EQ.1) GO TO 100
 
          ASYMB1 = L1A_SYMB(IA1)
          ASYMB2 = L1A_SYMB(IA2)
 
c          IF(ASYMB1(1:2).EQ.'H '.OR.ASYMB1(1:2).EQ.'D ') GO TO 100
c          IF(ASYMB2(1:2).EQ.'H '.OR.ASYMB2(1:2).EQ.'D ') GO TO 100

          RSV_NAME = 'VDW '
          IF((ASYMB1(1:2).EQ.'N '.AND.ASYMB2(1:2).EQ.'O ').OR.
     *       (ASYMB1(1:2).EQ.'O '.AND.ASYMB2(1:2).EQ.'N ').OR.
     *       (ASYMB1(1:2).EQ.'O '.AND.ASYMB2(1:2).EQ.'O ')    ) THEN
            RSV_NAME = 'HB  '
          ENDIF

          IF(RSV_NAME.EQ.'VDW '.AND.IFLAG_VDW.EQ.0) THEN
C CH1  CH1     -0.09011     3.600   .
            RSV_RIDL  = 3.600
            RSV_ROBS  = 0.0
            RSV_CNS   =-0.09011 
            RSV_HFLAG = ' '
            RSV_TYPE  = ' '
            RSV_SYMM  = '1_555'
            CALL GET_VDW_EMIN(MDOC,RSV_NAME,NR_VDW,RSV_SYMM
     *       ,IA1,IA2
     *       ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *       ,C_LINE,IFLAG,IERR)
            IF(IERR.NE.0) THEN
              IFLAG_VDW = 1
              IERR      = 0
            ENDIF

c            IF(LIST.EQ.'T') THEN
c              WRITE(LINE,'(A,3I4,A,A,A)') 
c     *'Ivdw:',NR_VDW,IA1,IA2,L1A_ANAME(IA1),' - ',L1A_ANAME(IA2)
c              CALL MSGDOC(MDOC,LINE)
c            ENDIF

          ELSE IF(RSV_NAME.EQ.'HB  '.AND.IFLAG_HB.EQ.0) THEN
C OH1  NH1    -1.500    2.850
            RSV_RIDL  = 2.850
            RSV_ROBS  = 0.0
            RSV_CNS   =-1.50 
            RSV_HFLAG = ' '
            RSV_TYPE  = ' '
            RSV_SYMM  = '1_555'
            CALL GET_HB_EMIN(MDOC,RSV_NAME,NR_HB,RSV_SYMM
     *        ,IA1,IA2
     *        ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *        ,C_LINE,IFLAG,IERR)
            IF(IERR.NE.0) THEN
              IFLAG_HB = 1
              IERR     = 0
            ENDIF
c            IF(LIST.EQ.'T') THEN
c              WRITE(LINE,'(A,3I4,A,A,A)') 
c     *'IHB :',NR_HB,IA1,IA2,L1A_ANAME(IA1),' - ',L1A_ANAME(IA2)
c              CALL MSGDOC(MDOC,LINE)
c            ENDIF
          ENDIF

 100      CONTINUE
        ENDDO
      ENDDO
C --------------------------------------
 500  CONTINUE
C ---
      IF(LIST.EQ.'L'.OR.LIST.EQ.'T') THEN
      CALL MSGDOC(MDOC,'----- ')
      WRITE(LINE,'('' Number of bond restraints    :'',I8)') 
     *NR_BOND
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of angle restraints   :'',I8)') 
     *NR_ANGL
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of torsion restraints :'',I8)') 
     *NR_TORS
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of chiralities        :'',I8)') 
     *NR_CHIR
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of planar groups      :'',I8)') 
     *NR_PLAN
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of VDW_contacts       :'',I8)') 
     *NR_VDW
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           H_bonds            :'',I8)') 
     *NR_HB 
      CALL MSGDOC(MDOC,LINE)
C ---
      CALL MSGDOC(MDOC,'----- ')
      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_POSSIBLE_VDW_LBC(MDOC,I1,I2,ICHECK,IERR)
C --------------------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C      INCLUDE 'ref_com_str.fh'
C --------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   LINE*256
C --------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      ICHECK = 0
      IF(N_ATOM.LE.0) RETURN
C      IF(ATM_NDUMMY.GT.0) THEN
C        NT = N_ATOM - ATM_NDUMMY
C        IF(I1.GT.NT.OR.I2.GT.NT) THEN
C          ICHECK = 1
C          RETURN
C        ENDIF
C      ENDIF
      DO IA=1,N_ATOM
        CALL CHECK_BOND_LBC_MIN(MDOC,IA,I1,ICHECKB1,IERR)
        CALL CHECK_BOND_LBC_MIN(MDOC,IA,I2,ICHECKB2,IERR)
        IF(ICHECKB1.NE.0.AND.ICHECKB2.NE.0) THEN
          ICHECK = 1
          RETURN
        ENDIF
        IF(ICHECKB1.NE.0) THEN
          DO IAA=1,N_ATOM
            CALL CHECK_BOND_LBC_MIN(MDOC,IAA,IA,ICHECKBA1,IERR)
            CALL CHECK_BOND_LBC_MIN(MDOC,IAA,I2,ICHECKBA2,IERR)
            IF(ICHECKBA1.NE.0.AND.ICHECKBA2.NE.0) THEN
              ICHECK = 1
              RETURN
            ENDIF
          ENDDO
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE CHECK_BOND_LBC_MIN(MDOC,I1,I2,ICHECK,IERR)
C --------------------------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   LINE*256
C --------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      ICHECK = 0
      IF(L1A_NATOM.LE.0) RETURN
      IF(L1B_NBOND.GT.0) THEN
        DO IB =1,L1B_NBOND
          IA1      = L1B_I1ATM(IB)
          IA2      = L1B_I2ATM(IB)
          IF((IA1.EQ.I1.AND.IA2.EQ.I2).OR.
     *       (IA2.EQ.I1.AND.IA1.EQ.I2)    ) THEN
            ICHECK = 1
            RETURN
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END

C ==========================================


      SUBROUTINE POLTOCRD(INEXT,I,N,A,X,Y,Z
     *                    ,LENGTH,THETA,PHI,CONN,MAX1BRN)
C ---------------------
      REAL      LENGTH(*),X(*),Y(*),Z(*),THETA(*),PHI(*)
      REAL      A(3,3),DX(3),DY(3)
      INTEGER   CONN(MAX1BRN,*)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -----------------------------------
      PHI0 = PHI(CONN(N,I))
      PHII = PHI(INEXT)

      IF(CONN(N,I).NE.INEXT) PHII = PHII + PHI0 

      PHII   = PHII*PI180
      THETAI = THETA(INEXT)*PI180
      DX(1)  =-COS(THETAI)*LENGTH(INEXT)
      DDX    = SIN(THETAI)*LENGTH(INEXT)
      DX(2)  = COS(PHII)*DDX
      DX(3)  = SIN(PHII)*DDX

      CALL NB_MVMULT(A,DX,DY)

      X(INEXT) = X(I) + DY(1)
      Y(INEXT) = Y(I) + DY(2)
      Z(INEXT) = Z(I) + DY(3)

C      WRITE(*,*) 'PTC',INEXT,I,N,ddx  
C      WRITE(*,*) 'pf',THETA(INEXT),PHI(INEXT)  
C      write(*,*) 'A ',A(1,1),A(1,2),A(1,3)
C      write(*,*) 'A ',A(2,1),A(2,2),A(2,3)
C      write(*,*) 'A ',A(3,1),A(3,2),A(3,3)
C
C      write(*,*) 'xi', X(I),Y(I),Z(I)
C      write(*,*) 'dx',dx(1),dx(2),dx(3)
C      write(*,*) 'dy',dy(1),dy(2),dy(3)
C      write(*,*) 'xn', X(INEXT),Y(INEXT),Z(INEXT)


      RETURN
      END

      SUBROUTINE ANGLE_CORRECTION(IMODE,NATOM,NDUMMY
     *                           ,NF,NB,DL,THETA,PSI
     *                           ,NDIST,CONN,MAX1BRN,X,Y,Z,LABEL)
C -----------------------------------
      INTEGER   NF(*),NB(*),NDIST(*),CONN(MAX1BRN,*)
      REAL      DL(*),THETA(*),PSI(*),X(*),Y(*),Z(*)
      CHARACTER LABEL(NATOM)*8
C------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -----------------------------------
      DO I=1,NATOM+NDUMMY

C        IF(NDIST(I).GT.1.AND.NF(I).GT.0) THEN
C          IF(NF(I).NE.CONN(NDIST(I),I)) THEN
C            DO J=NDIST(I)-1,1,-1
C              IF(CONN(J,I).EQ.NF(I)) THEN
C                CONN(J,I)        = CONN(NDIST(I),I)
C                CONN(NDIST(I),I) = NF(I)
C                GO TO 100
C              ENDIF
C            ENDDO
C          ENDIF          
C        ENDIF
C 100    CONTINUE

        I1 = NB(I)
        IF(I1.LE.0) THEN
          PSI  (I) = 0.0
          THETA(I) = 90.0
          GO TO 110
        ENDIF

        NFI1 = NF(I1)

        IF(NFI1.LT.0) THEN
          IF(NDIST(I1).GT.0) THEN
            NFI1 = CONN(NDIST(I1),I1)
          ENDIF
        ENDIF        

        IF(NFI1.GT.0.AND.I.NE.NFI1) THEN
          ALPHA = PSI(I) - PSI(NFI1)
          IF(ALPHA.GE. 360.0) ALPHA = ALPHA - 360.0
          IF(ALPHA.LE.-360.0) ALPHA = ALPHA + 360.0
          IF(ALPHA.GT. 180.0) ALPHA = ALPHA - 360.0
          IF(ALPHA.LE.-180.0) ALPHA = ALPHA + 360.0          
          PSI(I) = ALPHA 
        ENDIF

 110    CONTINUE
      ENDDO
      RETURN
      END

      SUBROUTINE CRTOANG(IMODE,NATOM,NF,NB,DL,THETA,PSI,X,Y,Z,LABEL)
C -----------------------------------
      INTEGER   NF(*),NB(*)
      REAL      DL(*),THETA(*),PSI(*),X(*),Y(*),Z(*)
      CHARACTER LABEL(NATOM)*8
      REAL      X2(3),X1(3),V1(3),V2(3)
C------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -----------------------------------
      DO I=1,NATOM
        IF(IMODE.EQ.0) DL(I) = 0.0
        I1 = NB(I)
        IF(I1.LE.0) THEN
          IF(IMODE.EQ.0) DL(I) = 1.0
          PSI  (I) = 0.0
          THETA(I) = 90.0
          GO TO 110
        ENDIF
        I2 = NB(I1)
        II2= I2 

 200    CONTINUE
        IF(II2.GT.0) THEN
          I3 = NB(II2)
        ELSE
          I3 = 0
        ENDIF
        IF(II2.LE.0) THEN
          X2(1) =-1.
          X2(2) = 0.
          X2(3) = 0.
          X1(1) =-1.
          X1(2) = 1.
          X1(3) = 0.
        ELSE
          X2(1) = X(II2)
          X2(2) = Y(II2)
          X2(3) = Z(II2)
          IF(I3.LE.0) THEN
            X1(1) =-1.
            X1(2) = 0.
            X1(3) = 0.
          ELSE
            X1(1) = X(I3)
            X1(2) = Y(I3)
            X1(3) = Z(I3)
          ENDIF
        ENDIF
        V1(1) = X2(1)-X1(1)
        V1(2) = X2(2)-X1(2)
        V1(3) = X2(3)-X1(3)
        V2(1) = X(I1)-X2(1)
        V2(2) = Y(I1)-X2(2)
        V2(3) = Z(I1)-X2(3)
        CALL NB_VMOD(V1,AV1)
        CALL NB_VMOD(V2,AV2)
        CALL NB_VPROD(V1,V2,S)
        COSA1 = S/(AV1*AV2)
        ANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
        ANG1  = PI-ANG1
C       10 grad = 0.175
        D    = PI - 0.175/2.0                                 
        IF(ANG1.GT.D.AND.II2.GT.0) THEN
          IB = NB(II2)
          IF(IB.GT.0) THEN
            I3 = NB(IB)
          ELSE
            I3 = 0
          ENDIF
          II2 = IB
          GO TO 200
        ENDIF
       
        A3 = X(I)-X(I1)
        B3 = Y(I)-Y(I1)
        C3 = Z(I)-Z(I1)
        A2 = X(I1)-X2(1)
        B2 = Y(I1)-X2(2)
        C2 = Z(I1)-X2(3)
        A1 = X2(1)-X1(1)
        B1 = X2(2)-X1(2)
        C1 = X2(3)-X1(3)
      
        AMOD = ABS(SQRT(A2*A2+B2*B2+C2*C2)*SQRT(A3*A3+B3*B3+C3*C3))
        T      = AMOD
        IF(T.LT.1.0E-8) T = 1.0
        COST   = (A3*A2+B3*B2+C3*C2)/T
        IF(COST.GT. 1.0) COST = 1.0
        IF(COST.LT.-1.0) COST =-1.0
        ANGOBS   = ACOS(COST)
        ANGOBS   = PI-ANGOBS
        IF(ANGOBS.GT. PI) ANGOBS = ANGOBS - TWOPI
        IF(ANGOBS.LT.-PI) ANGOBS = ANGOBS + TWOPI

        IF(IMODE.EQ.0) THETA(I) = ANGOBS/PI180

        DN1X = B1*C2-B2*C1
        DN1Y = A1*C2-A2*C1
        DN1Z = A1*B2-A2*B1
        DN2X = B2*C3-B3*C2
        DN2Y = A2*C3-A3*C2
        DN2Z = A2*B3-A3*B2
        E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
        E2   = SQRT(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z)
        E3   = SQRT(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z)
        IF(E2.LT.1.E-8.OR.E3.LT.1.E-8) THEN
          IF(E1.GE.0.) COSG = 1.
          IF(E1.LT.0.) COSG =-1.
        ELSE
          T    = E2*E3
          IF(T.LT.1.0E-8) T = 1.0
          COSG = E1/T
        ENDIF
C ------------------
        ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
        SS     = ABS(1.0 - COSG*COSG)
        SING   = SIGN(1.0,ABC)*SQRT(SS)
        ALPHA  = ATAN2(SING,COSG)

        IF(IMODE.EQ.0) THEN
          PSI(I) = ALPHA
          IF(NF(I1).EQ.I) THEN
            DL(I) = ALPHA
          ENDIF
        ELSE
          IF(NF(I1).EQ.I.AND.LABEL(I)(1:1).NE.'C') THEN
            PSI(I) = ALPHA/PI180          
          ENDIF
        ENDIF

 110    CONTINUE
      ENDDO
      IF(IMODE.GT.0) RETURN

      DO I=1,NATOM
        I1 = NB(I)
        ALPHA = PSI(I)
        IF(I1.GT.0) THEN
          IF(NF(I1).NE.I.AND.NF(I1).GT.0) THEN
            ALPHA = ALPHA - DL(NF(I1))
          ENDIF
        ENDIF
        IF(ALPHA.GE. TWOPI) ALPHA = ALPHA - TWOPI
        IF(ALPHA.LE.-TWOPI) ALPHA = ALPHA + TWOPI
        IF(ALPHA.GT. PI) ALPHA = ALPHA - TWOPI
        IF(ALPHA.LE.-PI) ALPHA = ALPHA + TWOPI
        PSI(I) = ALPHA/PI180          
      ENDDO

      DO I=1,NATOM
        I1 = NB(I)
        IF(I1.LE.0) THEN
          DL(I) = 1.
        ELSE
          A3 = X(I)-X(I1)
          B3 = Y(I)-Y(I1)
          C3 = Z(I)-Z(I1)
          DL(I) = SQRT(A3*A3+B3*B3+C3*C3)
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE ANGTOCR(MDOC,LIST,ISTART,IFINISH
     *  ,X,Y,Z,NDIST
     *  ,LENGTH,THETA,PHI,CONN,MAX1BRN,IERR)
C      SUBROUTINE ANGTOCR(MDOC,LIST,L1A_ISTART,L1A_IFINISH
C     *  ,L1A_X,L1A_Y,L1A_Z,L1A_NDIST
C     *  ,L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_CONN,MAX1BRN,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      REAL      LENGTH(*),X(*),Y(*),Z(*),THETA(*),PHI(*)
      INTEGER   CONN(MAX1BRN,*),NDIST(*)
C ---
      PARAMETER ( NSTLIM = 10 )
      INTEGER*4 NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
      REAL      ASTACK(3,3,10)
C --------------------------------------
      REAL      A(3,3)
      INTEGER*4 IC
      CHARACTER LINE*256,LIST*1
C ---------------------------------------
C      PARAMETER (MAX1ATM   = 250 )
C      PARAMETER (MAX1BND   = MAX1ATM )
C      PARAMETER (MAX1ANG   =  2 * MAX1ATM )
C      PARAMETER (MAX1TOR   = MAX1ATM )
C      PARAMETER (MAX1CHR   =  50 )
C      PARAMETER (MAX1PLN   =  50 )
C      PARAMETER (MAX1APL   = 100 )
C      PARAMETER (MAX1BRN   =   8 )
C      PARAMETER (MAX1EXT   =   8 )
C      PARAMETER (MAX1CONN  = 500 )
C      PARAMETER (MX1ATOM = 250)
C      PARAMETER (MX1BRN  =   8)
C      PARAMETER (MX1ALT  =  20)
C      PARAMETER (MX1EXT  =  50)
C      INTEGER*4 L1A_IEXTR (MAX1EXT,MAX1ATM) 
C      INTEGER*4 L1A_TEXTR (MAX1EXT,MAX1ATM)
C      INTEGER*4 L1A_CONN  (MAX1BRN,MAX1ATM) 
C      INTEGER*4 L1A_LENCON(MAX1BRN,MAX1ATM) 
C      INTEGER*4 L1A_IBACK (MAX1ATM)
C      INTEGER*4 L1A_IFORW (MAX1ATM)
C      INTEGER*4 L1A_ICHEM (MAX1ATM)
C      INTEGER*4 L1A_SF_ID (MAX1ATM)

C      CHARACTER L1A_ID_PSI    (MX1ATOM)*8 
C      CHARACTER L2A_ID_PSI    (MX1ATOM)*8 

C        L1A_ISTART L1A_IFINISH            L1A_X,L1A_Y,L1A_Z
C     *  L1A_NDIST(I),L1A_LENGTH,L1A_THETA,L1A_PHI,L1A_CONN,MAX1BRN)
C ----
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      IERR = 0
C ---
      DO I=1,3
      DO J=1,3
        A(I,J) = 0.0
      ENDDO
      ENDDO
      A(1,1) = 1.0
      A(2,2) = 1.0
      A(3,3) = 1.0

C      ISTART  = L1A_ISTART
C      IFINISH = L1A_IFINISH

C ---
      I        = ISTART
      IC       = 1
      NSTCK    = 0

      X(I) = 0.0
      Y(I) = 0.0
      Z(I) = 0.0

  400 CONTINUE

      N = NDIST(I)

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '------>',I,N,IC
        IF(N.GT.0)  WRITE(*,*)'-CONN->',(conn(jjj,i),jjj=1,n)
      ENDIF


      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500

        IF(N.EQ.0) THEN

          IF(NSTCK.LE.0) THEN
            GO TO 2000
          ENDIF

c         write(line,*) ' --- from stack ---',nstck
c         CALL MSGDOC(MDOC,LINE)
 
          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          CALL  NB_MCOPY(ASTACK(1,1,NSTCK),A)
          NSTCK = NSTCK-1
          IF(I.LE.0.OR.IC.LE.0) THEN
            GO TO 2000
          ENDIF

        ELSE IF(N.EQ.1) THEN

          INEXT = CONN(1,I)

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '--1:',INEXT,I,N,IC,(conn(jjj,I),jjj=1,n)
          ENDIF 

          CALL POLTOCRD(INEXT,I,N,A,X,Y,Z
     *        ,LENGTH,THETA,PHI,CONN,MAX1BRN)
          CALL CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
          IC    = 1
          I     = INEXT

        ELSE IF(N.GT.1) THEN

          INEXT = CONN(IC,I)

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '--2:',INEXT,I,N,IC,(conn(jjj,i),jjj=1,n)
            WRITE(*,*) '--2:',(phi(conn(jjj,i)),jjj=1,n)

          ENDIF 

          CALL POLTOCRD(INEXT,I,N,A,X,Y,Z
     *        ,LENGTH,THETA,PHI,CONN,MAX1BRN)

          IF(IC.LT.N) THEN
            IC    = IC + 1
            NSTCK = NSTCK + 1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(LINE,
     *        '('' ERROR: in ANGTOCR : N-stack > '',I6)')
     *        NSTLIM
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF

c           write(line,*) ' --- to stack ---',nstck
c           CALL MSGDOC(MDOC,LINE)

            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
            CALL  NB_MCOPY(A,ASTACK(1,1,NSTCK))
          ENDIF
   

          CALL CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
          I  = INEXT
          IC = 1

        ELSE

          GO TO 2000

        ENDIF
      GO TO 400
C -----------------
  500 CONTINUE
      RETURN
C ------------------
 2000 CONTINUE
      WRITE(LINE,
     *'('' WARNING: ANGTOCR : wrong tree structure'')')
      CALL MSGERR(MDOC,LINE)
      RETURN    
      END

      SUBROUTINE LIBCHECK_IDEAL(MDOC,LIST,ITEST,IERR)
C --------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C --------------------------------------------------------
      INTEGER     MDOC,ITEST,IERR
      CHARACTER   LINE*256,LIST*1
C --------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
C ITEST: 1 only BOND, 2 only ANGLE, 3 only BOND and ANGLE, 4 only VDW and HB
C        5 only tors,  6 only chir, 7 only plan, 8 whitout VDW and HB   
C        9 whitout tors, 10 whitout tors and chir, 11 whitout tors,chir,VDW,NB
C       12 whitout chir
C --------
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' -----LIBCHECK_IDEAL--------')
        write(line,*) ' N_ATOM:',N_ATOM
        CALL MSGDOC(MDOC,LINE)
        DO I=1,N_ATOM
          write(line,'(I4,1X,A4,3F10.3)') I,ATM_NAME(I)
     *    ,XYZ_CRD(1,I),XYZ_CRD(2,I),XYZ_CRD(3,I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        CALL MSGDOC(MDOC,' -------------')
        write(line,*) ' NR_BOND:',NR_BOND
        CALL MSGDOC(MDOC,LINE)
        IF(NR_BOND.GT.0) THEN      
        DO I=1,NR_BOND
          write(line,'(I4,'')'',I4,I4,1X,A4,1X,A4)')
     *    I,RB_IA1(I),RB_IA2(I),ATM_NAME(RB_IA1(I)),ATM_NAME(RB_IA2(I))
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
        CALL MSGDOC(MDOC,' -------------')
        write(line,*) ' NR_ANGL:',NR_ANGL
        CALL MSGDOC(MDOC,LINE)
        IF(NR_ANGL.GT.0) THEN      
        DO I=1,NR_ANGL
          write(line,'(I4,'')'',I4,I4,I4,1X,A4,1X,A4,1X,A4)')
     *    I,RA_IA1(I),RA_IA2(I),RA_IA3(I)
     *    ,ATM_NAME(RA_IA1(I)),ATM_NAME(RA_IA2(I)),ATM_NAME(RA_IA3(I))
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
        CALL MSGDOC(MDOC,' -------------')
        write(line,*) ' NR_CHIR:',NR_CHIR
        CALL MSGDOC(MDOC,LINE)
        IF(NR_CHIR.GT.0) THEN
        DO I=1,NR_CHIR
          write(line
     *    ,'(I4,'')'',I4,I4,I4,I4,1X,A4,1X,A4,1X,A4,1X,A4,1X,A)')
     *    I,RC_IA1(I),RC_IA2(I),RC_IA3(I),RC_IA4(I)
     *    ,ATM_NAME(RC_IA1(I)),ATM_NAME(RC_IA2(I)),ATM_NAME(RC_IA3(I))
     *    ,ATM_NAME(RC_IA4(I)),RC_SIGN(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
        CALL MSGDOC(MDOC,' -------------')
        write(line,*) ' NR_PLAN:',NR_PLAN
        CALL MSGDOC(MDOC,LINE)
        IF(NR_PLAN.GT.0) THEN
        DO I=1,NR_PLAN
          DO J=1,RP_NATOM(I)
            write(line,'(I4,'')'',I4,2X,A4,I4)')
     *      I,J,ATM_NAME(RP_IATM(J,I)),RP_IATM(J,I)
            CALL MSGDOC(MDOC,LINE)
          ENDDO
        ENDDO
        ENDIF
        CALL MSGDOC(MDOC,' -------------')
      ENDIF
C ---

C ---
      RETURN
      END   

