      subroutine refine_ml_parameters_twin(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
      include 'celsym.fh'
      include 'agreem.fh'
      include 'twin_refmac.fh'
      include 'ls_params_save.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
c---  Outputs. Scale parameters are in agreem.fh
      integer ierr
c
      integer num_p
      real, allocatable :: dfdp1(:) 
      real, allocatable :: dfdp1dp2(:,:)
      real, allocatable :: shift(:)
      real, allocatable ::  workspace(:)
      real, allocatable :: par0(:)
      real, allocatable :: epsls(:)
      real, allocatable :: centrs(:)
      real, allocatable :: resos(:)
      integer, allocatable :: end_mlsc_bin(:)
c
c
      integer nworkspace
      real toler

      integer i,ncycle_ml,j,k,j1
      integer ip,maxobs
c---locals for line minimisation
      real fold,g2p
      real r1,r2,tmp,tst,a,b
      real d1,d2,f_value,rfac_i,rfac_w_i,rfac_f
      real lambd,lambd2,lambdmin,lam0,l12
      real f1,f2,d2p
      real tol_conv,al0
      parameter (tol_conv = 1.0e-2)
      parameter (al0 = 1.0e-4)
      real dot_r
      external dot_r
c
c     this subroutine refines the least square overall parameters like
c     scale, domain fractions
c
c--Refine only ML parameters. In resolution bins
      allocate(end_mlsc_bin(nbin_ml))
      end_mlsc_bin(1:nbin_ml) = 1

      num_p = nbin_ml
      call dmlinit_twin
cd      write (*,*)'alpha before ls refine',alpha(1:2) 
c
c--   allocate memory    
      if(.not.allocated(dfdp1)) allocate(dfdp1(num_p))
      if(.not.allocated(dfdp1dp2)) allocate(dfdp1dp2(num_p,num_p))
      if(.not.allocated(shift)) allocate(shift(num_p))
      allocate(par0(num_p))
      allocate(epsls(nasym))
      allocate(centrs(nasym))
cd      allocate(resos(nasym))
c------------------------------
      nworkspace = num_p*num_p
      ncycle_ml=50
      call save_params_ml_twin(npart_act)
c
c--Precalculate all esplns and centricities
      call calc_epsls_centrs(nasym,maxsym,nsym,rot,hkl_asym,epsls,
     &     centrs)
      call assign_bin_numbers()
cd      call calc_resls(nasym,maxsym,nsym,rot,tr,cell,hkl_asym,resos)
c
c---  Overall cycles for minimisation
cd      stop
      do while(i.le.ncycle_ml.and.end_mlsc_all.lt.0) 
         i = i + 1
         write(*,*)'ML cycle ',i
         call copy_ml_params_bin_twin(num_p,npart_act,par0)
c
         dfdp1dp2(1:num_p,1:num_p,1:nbin_ml) = 0.0
         dfdp1(1:num_l,1:nbin_ml) = 0.0
         do ib=1,num_blocks
            ibin = block_bin_number(ib)
            if(end_mlsc_bin(ibin).lt.0) then
               call find_max
               call derivs
               dfdp1dp2(1:num_p,1:num_p,ibin)=
     &              dfdp1dp2(1:num_p,1:num_p,ibin) + 
     &              d2f_s(1:num_p,1:num_p)
               dfdp1(1:num_p,ibin) = dfdp1(1:num_p,ibin) + df_s(1:num_p)
               fold_bin(ibin) = fold_bin(ibin) + f_value
            endif
         enddo
         ftot = sum(fold_bin(1:nbin_ml))
         shift(1:num_p,1:nbin_ml) = 0.0
         do ib=1,nbin_ml
            if(end_mlsc_bin(ib).gt.0) then
               call eigen_filter_r90(toler,dfdp1dp2,num_p,num_p,dfdp1,
     &              shift,ierr)
            endif
         enddo

c
c--Find the reasonable initial alpha. I.e. parameters must be reasonable
         call init_lambd_ml_twin(num_p,npart_act,lambd,shift)
         g2p = dot_r(num_p,num_p,shift,dfdp1)
         tst = 0.0
c
c---  Line minimisation
         do  j=1,num_p
            tst = max(tst,abs(shift(j))/max(abs(par0(j)),1.0))
         enddo
         lambdmin = tol_conv/tst
         lambd = 1.0
         do j=1,100
            call add_shift_ml_twin(num_p,npart_act,lambd,shift) 
cd      stop
            call fvalue_ml_twin(nasym,hkl_asym,fcalc,fpart,
     &           num_blocks,block_start,ref_2_asym_start,
     &           nobs,iobs,obs_start,
     &           ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &           num_asym_ref,block_2_asym,
     &           fvalue,
     &           ierr)
c     
c--   Shifts are too small or convergence have been reached
            if(lambd.le.lambdmin) goto 20
            if(f1.le.fold+al0*lambd*g2p) goto 20
c
c--   Try new point and use interpolations
            if(j.eq.1) then
               tmp = -g2p/(2.0*(f1-fold-g2p))
            else
               l12 = lambd-lambd2
               r1 = f1-fold-lambd*g2p
               r2 = f2-fold-lambd2*g2p
               a  = (r1/lambd**2-r2/lambd2**2)/l12
               b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
               if(a.eq.0.0) then
                  tmp = -g2p/(2.0*b)
               else
                  d1 = max(0.0,b**2-3.0*a*g2p)
cd                  if(d1.le.0.0) then
cd                     call errwrt(0,'Problem with roundoff')
cd                  endif
                  tmp = (-b+sqrt(d1))/(3.0*a)
               endif
            endif
            tmp = min(tmp,0.9*lambd)
            lambd2 = lambd
            f2 = f1
            lambd = max(tmp,0.1*lambd)
         enddo
         call errwrt(1,'Line minimisation failed')
 20      continue
c
c--Check the convergence
         tst = 0.0
         do  j=1,num_p
            tst = max(tst,abs(shift(j))*lambd/max(abs(par0(j)),1.0))
         enddo
         tst = g2p*lambd/(num_p)


         if(tst.lt.tol_conv.or.f1.gt.fold) then 
            if(f1.gt.fold) then
               call restore_params_ml_twin
            endif
            goto 30
         endif
         call add_shift_ml_twin(num_p,npart_act,lambd,shift)
         call save_params_ml_twin(npart_act)
      enddo
 30   continue
c
c--   deallocate memory
      deallocate (dfdp1)
      deallocate (dfdp1dp2)
      deallocate (shift)
      deallocate (par0)
      deallocate (epsls)
      deallocate (centrs)
cd      deallocate (resos)
c----------------------
cd      call ccperr(0,'End of the routine')
cd      stop
      return 
      end
c
      subroutine derivative_mlg_df_dp(nasym,num_block,nobs,ncomp,
     &     maxobs,nref_block_obs,nref_block_contri,sum_contri,
     &     block_contributor,iobs,obs_2_asym,
     &     hkl_asym,npart1,fc,fcp1,nref_comp,
     &     comp_numb,num_p,maxsym,nsym,rot,cell,epsls,centrs,
     &     b_ml_aniso_over,scale_ml_over,
     &     b_ml_over,
     &     scale_ml_bulk,b_ml_bulk,scale_ml_part,
     &     b_ml_part,maxpart,
     &     num_alpha,alpha,sigma_ml_exp,dfdp1,d2fdp2,
     &     f_value)
      implicit none
c
c---Inputs
      integer maxsym,nsym,maxobs
      integer nasym,nobs,ncomp,num_p,maxpart
      integer num_block,sum_contri,npart1,num_alpha
      integer nref_block_obs(num_block+1)
      integer nref_block_contri(num_block+1)
      integer block_contributor(sum_contri)
      integer hkl_asym(3,nasym)
      real epsls(nasym),centrs(nasym)
      real alpha(48)
      real fc(2,nasym),fcp1(npart1,2,nasym)
      integer nref_comp(nobs+1)
      integer comp_numb(ncomp)
      real  iobs(2,nobs)
      integer obs_2_asym(ncomp) 
      real rot(3,3,maxsym),cell(6)
      real b_ml_aniso_over(6),scale_ml_over,b_ml_over,scale_ml_bulk
      real b_ml_bulk,scale_ml_part(maxpart),b_ml_part(maxpart)
      real sigma_ml_exp(3)
c---Outputs
      real dfdp1(num_p)
      real d2fdp2(num_p,num_p)
      real f_value
c
c---locals
      integer i,j,m,k,is,jc,jc1,jal,jal1,ia,ii
      integer jo,jo1,jp,j1,k1
      integer nal1
      integer o_s,o_e,c_1,c_n,no,o_c_s,o_c_e,o_c_s1,o_c_e1
      integer maxpart_l,maxcont_l
      parameter (maxpart_l = 6)
      parameter (maxcont_l = 48)
c
      integer c_s,c_e
      integer contributor_1,contri_number,ip,ip1
      integer obs_contributor_start,obs_contributor_finish
      integer contri_number_obs,obs_num
      real w,fh,dfh_dIct
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss
      real expb,expbs,expbsres,expbulk,expbulks,expbulksres
      real expbs2,bulk_cont2,expbs_bulk2,expban2,s2ban,tmp,tmp1
      real dtmp,dtmp1,s1,s2,s3,a12
      real epsi,centr
      real sigma0,dsigma_dsp(3),sigma1,wsigma0,wdet
      real bulk_cont,expbs_bulk,expban,bans,exp1
      real ss_v(6),hkl_this(3),hkl_sym(3),s_this(3)
      real a_all,b_all,a_part(maxpart_l),b_part(maxpart_l)
      real falp
      real part_expb(maxpart_l)
      real part_expbs(maxpart_l)
      real part_expbsres(maxpart_l)
c
c--Things for derivatives
      integer maxpar
      real dsdandb(6)
      real, allocatable :: Ic(:)
      real, allocatable ::  Ict(:)
      real, allocatable :: dIc_dp(:,:)
      real, allocatable :: dIct_dp(:,:)
      real, allocatable :: dIct_dalpha(:)
      real, allocatable :: wsigma(:)
      real, allocatable :: w_inv(:,:)
      real, allocatable :: dwsigma_dp(:,:)
      real, allocatable :: Wct(:,:)
      real, allocatable :: dWct_dp(:,:,:)
      real, allocatable :: dWct_dalpha(:,:,:)
      real, allocatable :: wtmp(:,:,:)
      real, allocatable :: delta(:)
      real, allocatable :: dvec1(:)
      real, allocatable :: vec(:,:)
      real, allocatable :: dvec2(:)
      real det_wm
      real Ic0,Ic1,Ict0
c
      real tr,tr1
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)
      real sqrtw
      real c0
      integer ierror
      logical error
      real dot_r
c
c---Body
c
c--allocate
      allocate(Ic(maxcont_l))
      allocate(dIc_dp(maxcont_l,num_p))
      allocate(Ict(maxobs))
      allocate(dIct_dp(maxobs,num_p))
      allocate(dIct_dalpha(num_alpha))
      allocate(wsigma(maxcont_l))

      allocate(w_inv(maxobs,maxobs))
      allocate(Wct(maxobs,maxobs))
      allocate(dwsigma_dp(maxcont_l,num_p))
      allocate(dWct_dp(maxobs,maxobs,num_p))
      allocate(dWct_dalpha(maxobs,maxobs,num_alpha))
      allocate(wtmp(maxobs,maxobs,num_p))
      allocate(delta(maxobs))
      allocate(dvec1(maxobs))
      allocate(dvec2(maxobs))
      allocate(vec(maxobs,num_p))

c
      nal1 = num_alpha-1
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      dfdp1(1:num_p) = 0.0
      d2fdp2(1:num_p,1:num_p) = 0.0
      f_value=0.0
c     
      do i=1,num_block
c     
c--   Define necessary pointers to contributors and observations
         o_s=nref_block_obs(i)+1
         o_e=nref_block_obs(i+1)
         c_s=nref_block_contri(i)+1
         c_e=nref_block_contri(i+1)
         c_1=block_contributor(c_s)
c     
c---  All reflections in this block have the same resolution (???)
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq)
         ss=rsq/4.0
         expb     = exp(-ss*b_ml_over)
         expbs    = expb*scale_ml_over
         expbs2   = expbs*expbs
         expbsres = -expbs*ss
         expbulk  = exp(-ss*b_ml_bulk)
         expbulks = scale_ml_bulk*expbulk
         expbulksres = -ss*expbulks
         bulk_cont = 1.0-expbulks
         bulk_cont2 = bulk_cont*bulk_cont
         expbs_bulk = bulk_cont*expbs
         expbs_bulk2= expbs_bulk*expbs_bulk
         sigma0 = exp(sigma_ml_exp(1)+sigma_ml_exp(2)*ss+
     &        sigma_ml_exp(3)*ss*ss)
         dsigma_dsp(1) = sigma0
         dsigma_dsp(2) = ss*sigma0
         dsigma_dsp(3) = ss*dsigma_dsp(2)
c     Calculate all necessary properties of contributors to the reflections
         jc = 0
         Ic(1:maxcont_l) = 0.0
         dIc_dp(1:maxcont_l,1:num_p) = 0.0
         wsigma(1:maxcont_l) = 0.0
         dwsigma_dp(1:maxcont_l,1:num_p) = 0.0
         do m=c_s,c_e
            jc = jc + 1
            c_n=block_contributor(m)
            a_all = fc(1,c_n)
            b_all = fc(2,c_n)
            epsi = epsls(c_n)
            centr = 1.0 + centrs(c_n)
c
c--   Calculate anisotropic scales and derivatives wrt them.
            hkl_this(1:3) = hkl_asym(1:3,m)
            expban = 0.0
            dsdandb(1:6) = 0.0
            do  is=1,nsym
               call mat2vect(3,3,rot(1,1,is),hkl_this,hkl_sym,error)
               call mat2vect(3,3,cs_ort_to_frac,hkl_sym,s_this,error)
               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans = ss_v(1)*b_ml_aniso_over(1)+
     &              ss_v(2)*b_ml_aniso_over(2)+
     &              ss_v(3)*b_ml_aniso_over(3)+
     &              ss_v(4)*b_ml_aniso_over(4)+
     &              ss_v(5)*b_ml_aniso_over(5)+
     &              ss_v(6)*b_ml_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
               dsdandb(1:6) = dsdandb(1:6) - ss_v(1:6)*exp1
            enddo
            expban = expban/nsym
            dsdandb(1:6) = dsdandb(1:6)/(4*nsym) 
c
c---  Calculate contributions from partials and their derivatives
            do ip=1,npart1
               part_expb(ip) = exp(-b_ml_part(ip)*ss)
               part_expbs(ip) = part_expb(ip)*scale_ml_part(ip)
               part_expbsres(ip) = -ss*part_expbs(ip)
               a_part(ip) = fcp1(ip,1,c_n)
               b_part(ip) = fcp1(ip,2,c_n)
               a_all = a_all + a_part(ip)*part_expbs(ip)
               b_all = b_all + b_part(ip)*part_expbs(ip)
            enddo
C     
C--Derivatives corresponding to contributors
            expban2 = expban*expban
            s2ban = expban*expbs_bulk
            Ic0 = a_all**2.0+b_all**2.0
            sigma1 = sigma0*epsi
            wsigma0 = sigma1*(2.0*Ic0+sigma1)*centr
            wsigma(jc) = wsigma0*s2ban**2
            Ic1 = Ic0 + sigma1
            Ic(jc) = Ic1*s2ban
c
c---aniso. Trace of the matrix is 0
            ip = num_alpha
            dtmp = (dsdandb(1)-dsdandb(3))
            dtmp1 = 2.0*expban*dtmp
            dIc_dp(jc,ip) = Ic1*dtmp*expbs_bulk
            dwsigma_dp(jc,ip) = wsigma0*dtmp1*expbs_bulk2
            ip = ip + 1
            dtmp = dsdandb(2)-dsdandb(3)
            dtmp1 = 2.0*expban*dtmp
            dIc_dp(jc,ip) = Ic1*dtmp*expbs_bulk
            dwsigma_dp(jc,ip) = wsigma0*dtmp1*expbs_bulk2
            ip = ip + 1
            dtmp = Ic1*expbs_bulk
            dtmp1 = 2.0*wsigma0*expban*expbs_bulk2
            do  jp=ip,ip+2
               dIc_dp(jc,jp) = dtmp*dsdandb(jp-ip+4)
               dwsigma_dp(jc,jp)=dtmp1*dsdandb(jp-ip+4)
            enddo
c
c--Overalls
            ip = ip + 3
            dtmp = Ic1*expban*bulk_cont
            dIc_dp(jc,ip) = dtmp*expb
            dtmp1 = 2.0*wsigma0*expban2*bulk_cont2*expbs
            dwsigma_dp(jc,ip) = dtmp1*expb
            ip = ip + 1
            dIc_dp(jc,ip) = dtmp*expbsres
            dwsigma_dp(jc,ip) =dtmp1*expbsres
            ip = ip + 1
c
c--Partials. Need correction. Sigma takes unscaled intensities and the scales 
c--are applied
            s1 = expban*expbs_bulk
            s2 = s1*s1
            s3 = 2.0*centr*sigma1*s2
            do  jp=1,npart1
               falp  = 2.0*(a_all*a_part(jp)+ b_all*b_part(jp))
c*expban*expbs_bulk
               dIc_dp(jc,ip) = falp*part_expb(jp)*s1
               dwsigma_dp(jc,ip) = falp*part_expb(jp)*s3
               ip = ip + 1
               dIc_dp(jc,ip) = falp*part_expbsres(jp)*s1
               dwsigma_dp(jc,ip) = falp*part_expbsres(jp)*s3
               ip = ip + 1
            enddo
c
c--   Bulk
            tmp = -Ic1*expban*expbs
            tmp1 = -2.0*wsigma0*expban2*expbs2*bulk_cont
            dIc_dp(jc,ip) = tmp*expbulk
            dwsigma_dp(jc,ip)=tmp1*expbulk
            ip = ip + 1
            dIc_dp(jc,ip) = tmp*expbulksres
            dwsigma_dp(jc,ip) = tmp1*expbulksres
            ip = ip + 1
c
c--   sigmas
            tmp = s1*epsi
            dIc_dp(jc,ip:ip+2) = tmp*dsigma_dsp(1:3)
            tmp1 = 2.0*s2*Ic1*centr*epsi
            dwsigma_dp(jc,ip:ip+2) = tmp1*dsigma_dsp(1:3)
         enddo
c     
c     go through each observation in that block
         no = o_e-o_s+1
         dIct_dp(1:maxobs,1:num_p) = 0.0
         Ict(1:maxobs) = 0.0
         Wct(1:maxobs,1:maxobs) = 0.0
         dWct_dp(1:maxobs,1:maxobs,1:num_p) = 0.0
         dWct_dalpha(1:maxobs,1:maxobs,1:num_alpha) = 0.0

         jo = 0
         do j=o_s,o_e
            dIct_dalpha(1:num_alpha) = 0.0
            jo = jo + 1
            o_c_s=nref_comp(j)+1
            o_c_e=nref_comp(j+1)
            do k=o_c_s,o_c_e
               jc  = obs_2_asym(k)
               jal = comp_numb(k)
               Ict(jo) = Ict(jo) + Ic(jc)*alpha(jal)
               dIct_dp(jo,num_alpha:num_p)=dIct_dp(jo,num_alpha:num_p)+
     &              dIc_dp(jc,num_alpha:num_p)*alpha(jal)
c
c--alphas
               dIct_dalpha(jal) = dIct_dalpha(jal) + Ic(jc)
c     
c--   Find position of this contributor and domain number (alpha)
           enddo
           if(nal1.gt.0) then
              do  j1=1,nal1
                 dIct_dp(jo,j1) = dIct_dp(jo,j1) + dIct_dalpha(j1+1)-
     &                dIct_dalpha(1)
              enddo
           endif
           jo1 = 0
           write(*,*)'Ict ',Ict(1:no)
           do  j1=o_s,o_e
              jo1 = jo1 + 1
              o_c_s1 = nref_comp(j1) + 1
              o_c_e1 = nref_comp(j1+1)
              do k1=o_c_s1,o_c_e1
                 jc1 =obs_2_asym(k1)
                 do  k=o_c_s,o_c_e
                    jc = obs_2_asym(k)
                    if(jc1.eq.jc) then
                       jal1 = comp_numb(k1)
                       jal  = comp_numb(k)
                       a12 = alpha(jal)*alpha(jal1)
                       Wct(jo,jo1) = Wct(jo,jo1) + a12*wsigma(jc)
                       dWct_dp(jo,jo1,num_alpha:num_p)=
     &                      dWct_dp(jo,jo1,num_alpha:num_p)+
     &                      dwsigma_dp(jc,num_alpha:num_p)*a12
                       dWct_dalpha(jo1,jo,jal)=dWct_dalpha(jo1,jo,jal) + 
     &                      alpha(jal1)*wsigma(jc)
                       dWct_dalpha(jo1,jo,jal1)=
     &                      dWct_dalpha(jo1,jo,jal1) + 
     &                      alpha(jal)*wsigma(jc)
                    endif
                 enddo
              enddo
           enddo

c
c--Add the experimental uncertainties to the diagonal
           write(*,*)iobs(2,j),Wct(jo,jo)

           Wct(jo,jo) = Wct(jo,jo) + iobs(2,j)**2
c
c--End of observations
        enddo
        if(nal1.gt.0) then
           do  jo=1,no
              do  jo1=1,no
                 do  ip=1,nal1
                    dWct_dp(jo,jo1,ip)=
     &                   dWct_dalpha(jo,jo1,ip+1)-
     &                   dWct_dalpha(jo,jo1,1)
                 enddo
              enddo
           enddo
        endif
cd        if(no.gt.1) then
cd           write(*,*)Ic(1:2),wsigma(1:2)
cd           write(*,*)dWct_dp(1:no,1:no,1)
cd           write(*,*)dWct_dp(1:no,1:no,2)
cd           write(*,*)dWct_dp(1:no,1:no,7)
cd           stop
cd        endif

c
c--Remaining part is just a simple matter of matrix manipulations
c
c--Process and add contributions for this block
        call matrix_invanddet(maxobs,no,Wct,w_inv,wdet,error)

        if(error) then
           write(*,*)maxobs,no,Wct(1:no,1:no)
           write(*,*)' 1 ',Wct(1:no,1:no),wsigma(1),wsigma0
           stop
        endif
        if(wdet.le.0.0) then
           write(*,*)o_s,o_e,c_s,c_e,c_1,o_c_s,o_c_e
           write(*,*)no,Wct(1:no,1:no),wdet
           stop
        endif
        delta(1:no) = Ict(1:no)-iobs(1,o_s:o_e)
        call mat2vec(maxobs,no,w_inv,delta,dvec1,error)
        f_value = f_value + 
     &       0.5*(dot_r(no,maxobs,delta,dvec1) + log(wdet))
        do  ip=1,num_p
           call mat2mat(maxobs,no,w_inv,dWct_dp(1,1,ip),
     &          wtmp(1,1,ip),error)
           call mat2vec(maxobs,no,w_inv,dIct_dp(1,ip),vec(1,ip),error)
           call mat2vec(maxobs,no,dWct_dp(1,1,ip),dvec1,dvec2,error)
           call trace_mat(maxobs,no,wtmp(1,1,ip),tr,error)
           dfdp1(ip) = dfdp1(ip) + 
     &          dot_r(no,maxobs,dvec1,dIct_dp(1,ip)) -
     &          0.5*dot_r(no,maxobs,dvec1,dvec2) +
     &          0.5*tr
           do  ip1=1,ip
              call trace_matmul(maxobs,no,wtmp(1,1,ip),wtmp(1,1,ip1),
     &             tr1,error)
              d2fdp2(ip,ip1)= d2fdp2(ip,ip1) + 
     &             dot_r(no,maxobs,vec(1,ip),dIct_dp(1,ip1))+
     &             0.5*tr1
           enddo
        enddo
c     
c--   end of blocks   
      enddo
c
c---Add upper triangular part.
      do  ip=1,num_p-1
         do  ip1=ip+1,num_p
            d2fdp2(ip,ip1) = d2fdp2(ip1,ip)
         enddo
      enddo
c--dallocate
cd      write(*,*)dfdp1(1:num_p)
cd      write(*,*)
cd      write(*,*)d2fdp2(1:num_p,1:num_p)

      deallocate(Ic)
      deallocate(dIc_dp)
      deallocate(Ict)
      deallocate(dIct_dp)
      deallocate(dIct_dalpha)
      deallocate(wsigma)
      deallocate(w_inv)
      deallocate(Wct)
      deallocate(dwsigma_dp)
      deallocate(dWct_dp)
      deallocate(dWct_dalpha)
      deallocate(wtmp)
      deallocate(delta)
      deallocate(dvec1)
      deallocate(dvec2)
      deallocate(vec)


      return 
      end
c
      subroutine fvalue_mlg_scale(nasym,num_block,nobs,ncomp,
     &     maxobs,nref_block_obs,nref_block_contri,sum_contri,
     &     block_contributor,iobs,obs_2_asym,
     &     hkl_asym,npart1,fc,fcp1,nref_comp,
     &     comp_numb,num_p,maxsym,nsym,rot,cell,epsls,centrs,
     &     b_ml_aniso_over,scale_ml_over,
     &     b_ml_over,
     &     scale_ml_bulk,b_ml_bulk,scale_ml_part,
     &     b_ml_part,maxpart,
     &     num_alpha,alpha,sigma_ml_exp,
     &     f_value)
      implicit none
c
c---Inputs
      integer maxsym,nsym,maxobs
      integer nasym,nobs,ncomp,num_p,maxpart
      integer num_block,sum_contri,npart1,num_alpha
      integer nref_block_obs(num_block+1)
      integer nref_block_contri(num_block+1)
      integer block_contributor(sum_contri)
      integer hkl_asym(3,nasym)
      real epsls(nasym),centrs(nasym)
      real alpha(48)
      real fc(2,nasym),fcp1(npart1,2,nasym)
      integer nref_comp(nobs+1)
      integer comp_numb(ncomp)
      real  iobs(2,nobs)
      integer obs_2_asym(ncomp) 
      real rot(3,3,maxsym),cell(6)
      real b_ml_aniso_over(6),scale_ml_over,b_ml_over,scale_ml_bulk
      real b_ml_bulk,scale_ml_part(maxpart),b_ml_part(maxpart)
      real sigma_ml_exp(3)
c---Outputs
      real f_value
c
c---locals
      integer i,j,m,k,is,jc,jc1,jal,jal1,ia,ii
      integer jo,jo1,jp,j1,k1
      integer nal1
      integer o_s,o_e,c_1,c_n,no,o_c_s,o_c_e,o_c_s1,o_c_e1
      integer maxpart_l,maxcont_l
      parameter (maxpart_l = 6)
      parameter (maxcont_l = 48)
c
      integer c_s,c_e
      integer contributor_1,contri_number,ip,ip1
      integer obs_contributor_start,obs_contributor_finish
      integer contri_number_obs,obs_num
      real w,fh,dfh_dIct
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss
      real expb,expbs,expbsres,expbulk,expbulks,expbulksres
      real expbs2,bulk_cont2,expbs_bulk2,expban2,s2ban,tmp,tmp1
      real dtmp,dtmp1,s1,s2,s3,a12
      real epsi,centr
      real sigma0,dsigma_dsp(3),sigma1,wsigma0,wdet
      real bulk_cont,expbs_bulk,expban,bans,exp1
      real ss_v(6),hkl_this(3),hkl_sym(3),s_this(3)
      real a_all,b_all,a_part(maxpart_l),b_part(maxpart_l)
      real falp
      real part_expb
      real part_expbs
c
c--Things for derivatives
      integer maxpar
      real dsdandb(6)
      real, allocatable :: Ic(:)
      real, allocatable :: Ict(:) 
      real, allocatable :: wsigma(:)
      real, allocatable :: w_inv(:,:)
      real, allocatable :: Wct(:,:)
      real, allocatable :: delta(:)
      real, allocatable :: dvec1(:)
      real det_wm
      real Ic0,Ic1,Ict0
c
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)
      real sqrtw
      real c0
      integer ierror
      logical error
      real dot_r
c
c---Body
c
c--allocate
      allocate(Ic(maxcont_l))
      allocate(Ict(maxobs))
      allocate(wsigma(maxcont_l))
      allocate(w_inv(maxobs,maxobs))
      allocate(Wct(maxobs,maxobs))
      allocate(delta(maxobs))
      allocate(dvec1(maxobs))
c
      nal1 = num_alpha-1
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      f_value=0.0
c     
      do i=1,num_block
c     
c--   Define necessary pointers to contributors and observations
         o_s=nref_block_obs(i)+1
         o_e=nref_block_obs(i+1)
         c_s=nref_block_contri(i)+1
         c_e=nref_block_contri(i+1)
         c_1=block_contributor(c_s)
c     
c---  All reflections in this block have the same resolution (???)
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq)
         ss=rsq/4.0
         expb     = exp(-ss*b_ml_over)
         expbs    = expb*scale_ml_over
         expbs2   = expbs*expbs
         expbulk  = exp(-ss*b_ml_bulk)
         expbulks = scale_ml_bulk*expbulk
         bulk_cont = 1.0-expbulks
         bulk_cont2 = bulk_cont*bulk_cont
         expbs_bulk = bulk_cont*expbs
         expbs_bulk2= expbs_bulk*expbs_bulk
         sigma0 = exp(sigma_ml_exp(1)+sigma_ml_exp(2)*ss+
     &        sigma_ml_exp(3)*ss*ss)
c     Calculate all necessary properties of contributors to the reflections
         jc = 0
         Ic(1:maxcont_l) = 0.0
         wsigma(1:maxcont_l) = 0.0
         do m=c_s,c_e
            jc = jc + 1
            c_n=block_contributor(m)
            a_all = fc(1,c_n)
            b_all = fc(2,c_n)
            epsi = epsls(c_n)
            centr = 1.0 + centrs(c_n)
c
c--   Calculate anisotropic scales and derivatives wrt them.
            hkl_this(1:3) = hkl_asym(1:3,m)
            expban = 0.0
            do  is=1,nsym
               call mat2vect(3,3,rot(1,1,is),hkl_this,hkl_sym,error)
               call mat2vect(3,3,cs_ort_to_frac,hkl_sym,s_this,error)
               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans = ss_v(1)*b_ml_aniso_over(1)+
     &              ss_v(2)*b_ml_aniso_over(2)+
     &              ss_v(3)*b_ml_aniso_over(3)+
     &              ss_v(4)*b_ml_aniso_over(4)+
     &              ss_v(5)*b_ml_aniso_over(5)+
     &              ss_v(6)*b_ml_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
            enddo
            expban = expban/nsym
c
c---  Calculate contributions from partials and their derivatives
            do ip=1,npart1
               part_expb = exp(-b_ml_part(ip)*ss)
               part_expbs = part_expb*scale_ml_part(ip)
               a_all = a_all + fcp1(ip,1,c_n)*part_expbs
               b_all = b_all + fcp1(ip,2,c_n)*part_expbs
            enddo
C     
C--Derivatives corresponding to contributors
            s2ban = expban*expbs_bulk
            Ic0 = a_all**2.0+b_all**2.0
            sigma1 = sigma0*epsi
            wsigma(jc) = sigma1*(2.0*Ic0+sigma1)*s2ban**2*centr
            Ic(jc) = (Ic0+sigma1)*s2ban
         enddo
c     
c     go through each observation in that block
         no = o_e-o_s+1
         Ict(1:no) = 0.0
         Wct(1:no,1:no) = 0.0
         jo = 0
         do j=o_s,o_e
            jo = jo + 1
            o_c_s=nref_comp(j)+1
            o_c_e=nref_comp(j+1)
            do k=o_c_s,o_c_e
               jc  = obs_2_asym(k)
               jal = comp_numb(k)
               Ict(jo) = Ict(jo) + Ic(jc)*alpha(jal)
           enddo
           jo1 = 0
           do  j1=o_s,o_e
              jo1 = jo1 + 1
              o_c_s1 = nref_comp(j1) + 1
              o_c_e1 = nref_comp(j1+1)
              do k1=o_c_s1,o_c_e1
                 jc1 =obs_2_asym(k1)
                 do k=o_c_s,o_c_e
                    jc = obs_2_asym(k)
                    if(jc1.eq.jc) then
                       jal1 = comp_numb(k1)
                       jal = comp_numb(k)
                       a12 = alpha(jal)*alpha(jal1)
                       Wct(jo,jo1) = Wct(jo,jo1) + a12*wsigma(jc)
                    endif
                 enddo
              enddo
           enddo
c
c--Add the experimental uncertainties to the diagonal
           Wct(jo,jo) = Wct(jo,jo) + iobs(2,j)**2
c
c--End of observations
        enddo
c
c--Remaining part is just a simple matter of matrix manipulations
c
c--Process and add contributions for this block
        call matrix_invanddet(maxobs,no,Wct,w_inv,wdet,error)
        if(error) then
           write(*,*)' 2'
           write(*,*)alpha(1:num_alpha)
           write(*,*)scale_ml_over,b_ml_over
           write(*,*)b_ml_aniso_over
           write(*,*)sigma_ml_exp
           write(*,*)scale_ml_bulk,b_ml_bulk
           write(*,*)scale_ml_part(1),b_ml_part(1)
           write(*,*)'1',wdet,Wct(1:no,1:no)
           stop
        endif
        delta(1:no) = Ict(1:no)-iobs(1,o_s:o_e)
        call mat2vec(maxobs,no,w_inv,delta,dvec1,error)
        f_value = f_value + 
     &       0.5*(dot_r(no,maxobs,delta,dvec1) + log(wdet))     
      enddo
c--dallocate

      deallocate(Ic)
      deallocate(Ict)
      deallocate(wsigma)
      deallocate(w_inv)
      deallocate(Wct)
      deallocate(delta)
      deallocate(dvec1)
      return 
      end
c
      subroutine save_params_ml(maxpart,maxpart_l,maxcont_l,npart1,
     &     num_alpha,scale_ml_over,b_ml_over,scale_ml_part,
     &     b_ml_part,b_ml_aniso_over,scale_ml_bulk,b_ml_bulk,alpha,
     &     sigma_ml_exp,
     &     scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,scale_bulk0,
     &     b_bulk0,alpha0,sigma_ml0)
      implicit none
      integer maxpart,maxpart_l,maxcont_l,npart1,num_alpha
c
c---  inputs
      real scale_ml_over,b_ml_over,scale_ml_part(maxpart)
      real b_ml_part(maxpart),alpha(48),b_ml_aniso_over(6)
      real scale_ml_bulk,b_ml_bulk
      real sigma_ml_exp(3)
c
c---  outputs
      real scale_ov0,b_ov0,scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(maxcont_l),baniso_ov0(6)
      real scale_bulk0,b_bulk0
      real sigma_ml0(3)
c
c--locals
c
c---  body
      scale_ov0 = scale_ml_over
      b_ov0 = b_ml_over
      baniso_ov0(1:6) = b_ml_aniso_over(1:6)
      scale_part0(1:npart1) = scale_ml_part(1:npart1)
      b_part0(1:npart1) = b_ml_part(1:npart1)
      alpha0(1:num_alpha) = alpha(1:num_alpha)
      scale_bulk0 = scale_ml_bulk
      b_bulk0     = b_ml_bulk
      sigma_ml0(1:3) = sigma_ml_exp(1:3)
      return
      end
c
      subroutine restore_params_ml(maxpart,maxpart_l,maxcont_l,npart1,
     &     num_alpha,scale_ml_over,b_ml_over,scale_ml_part,
     &     b_ml_part,b_ml_aniso_over,scale_ml_bulk,b_ml_bulk,alpha,
     &     sigma_ml_exp,
     &     scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,scale_bulk0,
     &     b_bulk0,alpha0,sigma_ml0)
      implicit none
      integer maxpart,maxpart_l,maxcont_l,npart1,num_alpha
c
c---  inputs
      real scale_ml_over,b_ml_over,scale_ml_part(maxpart)
      real b_ml_part(maxpart),alpha(48),b_ml_aniso_over(6)
      real scale_ml_bulk,b_ml_bulk
      real sigma_ml_exp(3)
c
c---  outputs
      real scale_ov0,b_ov0,scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(maxcont_l),baniso_ov0(6)
      real scale_bulk0,b_bulk0
      real sigma_ml0(3)
c
c--locals
      
c
c---  body
      scale_ml_over = scale_ov0
      b_ml_over = b_ov0
      b_ml_aniso_over(1:6) = baniso_ov0(1:6) 
      scale_ml_part(1:npart1) = scale_part0(1:npart1)
      b_ml_part(1:npart1) = b_part0(1:npart1)
      alpha(1:num_alpha) = alpha0(1:num_alpha)
      scale_ml_bulk = scale_bulk0
      b_ml_bulk = b_bulk0
      sigma_ml_exp(1:3) = sigma_ml0(1:3)
      return
      end 
c
      subroutine copy_ml_params(num_p,maxpart_l,maxcont_l,
     &     npart1,num_alpha,par0,scale_ov0,b_ov0,scale_part0,b_part0,
     &     baniso_ov0,scale_bulk0,b_bulk0,alpha0,sigma_ml0)
c
      implicit none
c
c---inputs
      integer max_num_p,maxpart_l,maxcont_l,npart1,num_alpha,num_p
      real scale_ov0,b_ov0,scale_bulk0,b_bulk0
      real baniso_ov0(6),scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(48),sigma_ml0(3)
c
c--outputs
      real par0(num_p)
c
c--locals
      integer ip,i
c
      do   ip=1,num_alpha-1
         par0(ip) = alpha0(ip+1)
      enddo
      ip = num_alpha
      par0(ip) = baniso_ov0(1)
      ip = ip + 1
      par0(ip) = baniso_ov0(2)
      ip = ip + 1
      par0(ip) = baniso_ov0(4)
      ip = ip + 1
      par0(ip) = baniso_ov0(5)
      ip = ip + 1
      par0(ip) = baniso_ov0(6)
      ip = ip + 1
      par0(ip) = scale_ov0
      ip = ip + 1
      par0(ip) = b_ov0
      do  i=1,npart1
         ip = ip + 1
         par0(ip) = scale_part0(i)
         ip = ip + 1
         par0(ip) = b_part0(i)
      enddo
      ip = ip + 1
      par0(ip) = scale_bulk0
      ip = ip + 1
      par0(ip) = b_bulk0
      par0(ip+1:ip+3) = sigma_ml0(1:3)
      return
      end
c
      subroutine init_lambd_ml(shift,lam0,maxpart,npart1,maxpart_l,
     &     maxcont_l,num_alpha,num_p,scale_ml_over,b_ml_over,
     &     scale_ml_part,b_ml_part,b_ml_aniso_over,scale_ml_bulk,
     &     b_ml_bulk,alpha,sigma_ml_exp,
     &     scale_ov0,b_ov0,scale_part0,b_part0,
     &     baniso_ov0,scale_bulk0,b_bulk0,alpha0,sigma_ml0)
c
      implicit none 
c
c--inputs
      integer maxpart,maxpart_l,maxcont_l,num_alpha,num_p,npart1
      real alpha(48)
      real scale_ml_over,b_ml_over,scale_ml_bulk,b_ml_bulk
      real b_ml_aniso_over(6),scale_ml_part(maxpart),b_ml_part(maxpart)
      real sigma_ml_exp(3)
      real shift (num_p)
      real scale_ov0,b_ov0,scale_bulk0,b_bulk0
      real baniso_ov0(6)
      real scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(48),sigma_ml0(3)
c
c---output
      real lam0
c
c--locals
      integer count
      integer ip,i
c
c---body
      lam0 = 1.0
      count = 1
      do while(count.gt.0)
         call add_shift_mlg(shift,lam0,maxpart,maxpart_l,maxcont_l,
     &        npart1,num_alpha,num_p,scale_ml_over,b_ml_over,
     &        scale_ml_part,
     &        b_ml_part,b_ml_aniso_over,scale_ml_bulk,b_ml_bulk,alpha,
     &        sigma_ml_exp,
     &        scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,
     &        scale_bulk0,b_bulk0,alpha0,sigma_ml0)
         count = 0
         do  ip=1,num_alpha
            if(alpha(ip).lt.0.0) then
               count = count + 1
            endif
            if(alpha(ip).gt.1.0) then
               count = count+1
            endif
         enddo
         if(scale_ml_over.lt.0.0) then
            count = count + 1
         endif
         do  ip=1,npart1
            if(scale_ml_part(ip).lt.0.0) then
               count = count + 1
            endif
         enddo
         if(scale_ml_bulk.lt.0.0) then
            count = count + 1
         endif
         if(scale_ml_bulk.gt.1.0) then
            count = count + 1
         endif
         if(b_ml_bulk.lt.0.0) count = count + 1
         if(sigma_ml_exp(1).lt.0.0) count = count + 1
         if(Sigma_ml_exp(1).gt.20.0) count = count + 1
         if(sigma_ml_exp(2).gt.0.0 ) count = count + 1
         if(sigma_ml_exp(2).lt.-500.0) count = count + 1
         if(count.gt.0) then
            lam0 = lam0/2.0
         endif
  
      enddo
c
      return
      end
c
      subroutine add_shift_mlg(shift,lamb,maxpart,maxpart_l,maxcont_l,
     &     npart1,num_alpha,num_p,scale_ml_over,b_ml_over,
     &     scale_ml_part,b_ml_part,b_ml_aniso_over,scale_ml_bulk,
     &     b_ml_bulk,alpha,sigma_ml_exp,
     &     scale_ov0,b_ov0,scale_part0,b_part0,
     &     baniso_ov0,scale_bulk0,b_bulk0,alpha0,sigma_ml0)
c
      implicit none 
c
c--inputs
      integer maxpart,maxpart_l,maxcont_l,num_alpha,num_p,npart1
      real alpha(48),sigma_ml_exp(3)
      real scale_ml_over,b_ml_over,scale_ml_bulk,b_ml_bulk
      real b_ml_aniso_over(6),scale_ml_part(maxpart),b_ml_part(maxpart)
      real lamb,shift (num_p)
c
c--outputs
      real scale_ov0,b_ov0,scale_bulk0,b_bulk0
      real baniso_ov0(6)
      real scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(48),sigma_ml0(3)
c
c--locals
      integer ip,j
      real alpha_sum
c
c--body
c
c      add shifts    
       do ip=1,num_alpha-1
          alpha(ip+1)=alpha0(ip+1)-lamb*shift(ip)
       enddo
       alpha_sum = 0.0
       do ip=2,num_alpha
          alpha_sum=alpha_sum+alpha(ip)
       enddo
       alpha(1)=1.0-alpha_sum
       
       b_ml_aniso_over(1) = baniso_ov0(1) - lamb*shift(num_alpha)
       b_ml_aniso_over(2) = baniso_ov0(2) - lamb*shift(num_alpha+1)
       b_ml_aniso_over(3) = baniso_ov0(3) + 
     &      lamb*(shift(num_alpha) + shift(num_alpha+1))
       b_ml_aniso_over(4) = baniso_ov0(4) - lamb*shift(num_alpha+2)
       b_ml_aniso_over(5) = baniso_ov0(5) - lamb*shift(num_alpha+3)
       b_ml_aniso_over(6) = baniso_ov0(6) - lamb*shift(num_alpha+4)
       scale_ml_over      = scale_ov0     - lamb*shift(num_alpha+5)
       b_ml_over          = b_ov0         - lamb*shift(num_alpha+6)
    
       do  ip=1,npart1
          scale_ml_part(ip) = scale_part0(ip)-
     &         lamb*shift(num_alpha+6+ip)
          b_ml_part(ip)     = b_part0(ip) -
     &         lamb*shift(num_alpha+6+npart1+ip)
       enddo
       
       scale_ml_bulk = scale_bulk0 - lamb*shift(num_alpha+2*npart1+7)
       b_ml_bulk     = b_bulk0     - lamb*shift(num_alpha+2*npart1+8) 
       ip = num_alpha+2*npart1+9
       sigma_ml_exp(1:3) = sigma_ml0(1:3)-lamb*shift(ip:ip+2)

       return
       end
c
      subroutine find_maxinblock(num_block,nref_block_obs,maxobs)
      implicit none
c
c---  inputs
      integer num_block
      integer nref_block_obs(num_block+1)
c
c---  output
      integer maxobs
c
c--   locals
      integer i
c
c---  body
      maxobs = 0
      do i=1,num_block
         maxobs = max(maxobs,nref_block_obs(i+1)-nref_block_obs(i))
      enddo
      return
      end
c
      subroutine phase_prob_gen_vonmise(icent,abcd_l,fval_p,cosexp,
     &     sinexp,cos2exp,sin2exp)
      implicit none
c
c--   Calculate the value of generalised von Mise distribution and expected values
c--   for sin, cos, sin2 and cos2
      integer icent
      real abcd_l(4)
      real cosexp,sinexp,cos2exp,sin2exp
      real fval_p
c     
c---  locals

c
c---  body
      if(icent.eq.0) then
c
c---  acentric reflections
         call phase_prob_acentr(abcd_l,fval_p,cosexp,
     &     sinexp,cos2exp,sin2exp)
      else
c
c---  centric reflections
         call phase_prob_centr(abcd_l,fval_p,cosexp,
     &     sinexp,cos2exp,sin2exp)
      endif
      return
      end
c
      subroutine phase_prob_acentr(abcd_l,fval_p,cosexp,
     &     sinexp,cos2exp,sin2exp)
      implicit none
      include 'expcost.fh'
c
c---  Probability and expected values for acentric phase probability distributions
      real abcd_l(4)
      real cosexp,sinexp,cos2exp,sin2exp
      real fval_p
c
c---  locals
      integer ind,i
      real xx,sinp1,cosp1,sin2p1,cos2p1,xc,anorm1,expargd
      real cosaa1,sinaa1,cos2a1,sin2a1,argc,arghi
      real hlc1,hld1,fomm,fom2
      real xx1,xx2
      real arg(1440)
      logical log_loc
      real sim
      external sim
      real twopi,eps_loc
      data twopi/6.283185/,eps_loc/1.0e-3/
c
c---  body
      xx = sqrt(abcd_l(1)**2+abcd_l(2)**2)
      xx1 = sqrt(abcd_l(3)**2+abcd_l(4)**2)
      log_loc = xx.gt.0.0
      if(log_loc) then
         log_loc = log_loc.and.(xx1/xx.le.eps_loc)
      endif
      if(log_loc) then
         fomm = sim(xx)
         fom2 = 1.0-2.0*fomm/xx
         cosp1 = abcd_l(1)/xx
         sinp1 = abcd_l(2)/xx
         
         cos2p1 = 2.0*cosp1*cosp1-1.0
         sin2p1 = 2.0*sinp1*cosp1
         cosexp = fomm*cosp1
         sinexp = fomm*sinp1
         cos2exp = fom2*cos2p1
         sin2exp = fom2*sin2p1
         call bessi0(xx,xx1,xx2)
         fval_p = log(xx1/twopi) + xx2
      else
         if(.not.expcos_tabulated) call expcos_tabulate
         if(xx.gt.0.) then
            cosp1 = abcd_l(1)/xx
            sinp1 = abcd_l(2)/xx
         else
            cosp1 = 1.0
            sinp1 = 0.0
         endif
         cos2p1 = 2.0*cosp1*cosp1 - 1.0
         sin2p1 = 2.0*sinp1*cosp1
         hlc1 =  abcd_l(3)*cos2p1+abcd_l(4)*sin2p1
         hld1 = -abcd_l(3)*sin2p1+abcd_l(4)*cos2p1

         arghi = -1.0e32
         do i=1,nmaxtrig,ntriginc
            arg(i)  =  xx*cos1_tab(i)+cos2_tab(i)*hlc1+sin2_tab(i)*hld1
         enddo
         arghi = maxval(arg(1:nmaxtrig))
         xc = 0.0
         if(arghi.gt.argmax) xc = arghi - argmax + 0.001
c     
c--   calculate integrals
         cosaa1 = 0.0
         sinaa1 = 0.0
         cos2a1 = 0.0
         sin2a1 = 0.0
         anorm1 = 0.0
c     
c---  Calculate expected values. Use iterative trapezoid method
         do i=1,nmaxtrig,ntriginc          
            argc  = arg(i) - xc
            ind = min(nmaxexp+1,max(1,nint(abs(argc)/argstep)+1))
c
            if(argc.ge.0.0) then
               expargd = etab(ind)
            else if(argc.lt.0.0.and.argc.gt.-argmax) then
               expargd = 1.0/etab(ind)
            else
               expargd = 0.0
            endif
c
            anorm1 = anorm1 + expargd
            cosaa1 = cosaa1 + cos1_tab(i)*expargd
            sinaa1 = sinaa1 + sin1_tab(i)*expargd
            cos2a1 = cos2a1 + cos2_tab(i)*expargd
            sin2a1 = sin2a1 + sin2_tab(i)*expargd
         enddo
         cosexp  = (cosp1*cosaa1  - sinp1*sinaa1 )/anorm1
         sinexp  = (sinp1*cosaa1  + cosp1*sinaa1 )/anorm1
         cos2exp = (cos2p1*cos2a1 - sin2p1*sin2a1)/anorm1
         sin2exp = (sin2p1*cos2a1 + cos2p1*sin2a1)/anorm1
         fval_p = log(anorm1/twopi*width) + xc
      endif

      return
      end
c
      subroutine phase_prob_centr(abcd_l,fval_p,cosexp,
     &     sinexp,cos2exp,sin2exp)
      implicit none
c
c--   Probability and expected values for centric phase probability distributions
c--   Assumption is that: potential values of phases are: atan2(abcd(2),abcd(1))
c--   Values of C and D of Hendrickson Lattmann are redundant
      real abcd_l(4)
      real cosexp,sinexp,cos2exp,sin2exp
      real fval_p
c
c---  locals
      real xx,fomm,cos1,sin1
c
c---  body
      xx = sqrt(abcd_l(1)**2+abcd_l(2)**2)

      if(xx.gt.30.0) then
         fomm = 1.0
         fval_p = log(0.5) + xx
      else
         fomm = tanh(xx)
         fval_p = log(cosh(xx))
      endif
      if(xx.gt.0.0) then
         cos1 = abcd_l(1)/xx
         sin1 = abcd_l(2)/xx
         cosexp = fomm*cos1
         sinexp = fomm*sin1
         cos2exp = 2.0*cos1*cos1-1.0
         sin2exp = 2.0*cos1*sin1
      else
         cosexp = 0.0
         sinexp = 0.0
         cos2exp = 0.0
         sin2exp = 0.0
      endif

      return
      end
c
      subroutine expcos_tabulate
      implicit none
      include 'expcost.fh'
c
      integer i
      real argm,step
      real twopi
      data twopi/6.283185/

      ntriginc = 10
      step = twopi/nmaxtrig
      width = ntriginc*step
      ARGM = 0.0
      DO     I=2,NMAXTRIG
         ARGM    = ARGM + STEP
         COS1_TAB(I) = COS(ARGM)
         SIN1_TAB(I) = SIN(ARGM)
         COS2_TAB(I) = COS(2.0*ARGM)
         SIN2_TAB(I) = SIN(2.0*ARGM)
      ENDDO

      argmax = 30.0
      ARGSTEP = ARGMAX/REAL(NMAXEXP)
      ETAB(1) = 1.0
      ARGM = 0.0
      DO    I=2,NMAXEXP+1
        ARGM = ARGM + ARGSTEP
        ETAB(I) = EXP(ARGM)
      ENDDO
      expcos_tabulated = .TRUE.

      return
      end
c
      subroutine  init_ml_pars(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
      integer i,j,k,ibin,ib
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f
      real Ict0,Ic(100)
      real a_all,b_all
      real eps,cent
c
      integer, allocatable :: obs_bins(:)
c
      scale_ml(1:(npart_act+1),1:nbin_ml) = 1.0
      sigma_ml(1:nbin_ml) = 0.0
      nref_ml(1:nbin_ml) = 0.0
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c  
      do i=1,num_blocks
         if(freer(i).gt.0.or.mlusework) then
            ibin = obs_bin(i)
            o_s = obs_start(i)+1
            o_f = obs_start(i+1)
            c_s = ref_2_asym_start(i)+1
            c_f = ref_2_asym_start(i+1)
            do j=c_s,c_f
               a_all = fcalc(1,j)
               b_all = fcalc(2,j)
               do k=1,npart_act
                  a_all = a_all + fpart(k,1,j)
                  b_all = b_all + fpart(k,2,j)
               enddo
               Ic(j) = a_all*a_all+b_all*b_all
            enddo
            do j=o_s,o_f
               o_c_s = obs_start(j) + 1
               o_c_f = obs_start(j+1)
               Ict0 = 0.0
               do k=o_c_s,o_c_f
                  jc = ref_2_asym(k)
                  jal = comp_numb(k)
                  Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
               enddo
               del = sqrt(max(0.0,iobs(1,j))-sqrt(Ict0)
               sigma_ml(ibin) = sigma_ml(ibin)+del*del
               nref_ml(ibin) = nref_ml(ibin) + 1
            enddo
         endif
      enddo
      do ib=1,nbin_ml
         if(nref_ml(ibin).gt.0) then
            sigma_ml(ibin) = sigma_ml(ibin)/nref_ml(ibin)
         else
            write(line,'(a,i,a)')
     &           'There is not enough reflections in '//
     &           'resolution bin ',ib,' for estimation'
            call errwrt(-1,line)
            call errwrt(1,'Problem in estimation. Cannot continue')
         endif
      enddo
c
      deallocate(obs_bins)
      return
      end
c
      subroutine  ls_ml_pars(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      real freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      integer ierr
c
c---locals
      integer, allocatable :: obs_bins(:)
c
      integer maxcont_l
      parameter (maxcont_l = 48)
      real  Ic(maxcont_l)
      real a_all,b_all,ict,io0,exp1,expb,expbs,expbs_bulk,expban
      real s_b_part
      real hkl_this(3)
      real ast,bst,cst,cosast,cosbst,coscst,s,ss,rsq
      integer npar,npar_s
      real dsigmadp(6),d2sdp2(6,6)
      real diff,df(6),d2f(6,6),shift(6)
      real sigma_loc(2),sigma_bulk(2)
      real toler
      integer il
      integer i,j,m,k,jc,jal,is,ip,jp,ip1,iint
      integer o_s,o_f,c_s,c_f,c_n,o_c_s,o_c_f,c_1
      integer ierror
      logical error
c
      integer icycle,ncycle
      integer icent
      real cent,eps,obs2e,ss2
c
      real Ict0,Ict1,del,del2,bulk_cont
      integer l,n1_l,ii
      real expbulks,bulk,bulk2,expbulk,cnt,sigma,snorm,d2fds2
      real dfdsc,d2fd2sc
      real part_expbs
c
      logical conv_sc
c
c---- Assumptions: all ls scale values have already been applied.
c
c---  Do minimisation in resolution bins
      ncycle = 20
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
      do ibin=1,nbin_ml
         ic = 0
         conv_sc = .FALSE.
         do while(ic.le.ncycle.and. .not.conv_sc)
            ic = ic + 1
            sigma_ml_bin(ibin) = 0.0
c
c--   Recalculate sigmas where it is necessay. Do not consider converged bins
            do i=1,num_blocks
               ib1 = obs_bin(i)
               if(ib1.eq.ibin) then
                  if(freer(i).gt.0 .or. mlusework) then
                     o_s = block_start(i) + 1
                     o_f = bloc_start(i+1)
                     c_s = ref_2_asym_stat(i) + 1
                     c_f = ref_2_asym_start(i+1)
c     
                     do j=c_s,c_f
                        a_all = scale_ml(1,ibin)*fcalc(1,j)
                        b_all = scale_ml(1,ibin)*fcalc(2,j)
                        do k=1,npart_act
                           a_part = scale_part_ml(k+1,ibin)*fpart(k,1,j)
                           b_part = scale_part_ml(k+1,ibin)*fpart(k,2,j)
                           a_all = a_all + a_part
                           b_all = b_all + b_part
                        enddo
                        Ic(j) = a_all**2+b_all**2
                     enddo
c     
                     do j=o_s,o_f
                        o_c_s = obs_start(j) + 1
                        o_c_f = obs_start(j+1)
                        Ict0 = 0.0
                        do k=o_c_s,o_c_f
                           jc = ref_2_asym(k)
                           jal = comp_numb(k)
                           Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
                        enddo
c     
c---  another option for delta
                        del = (max(-3.0*iobs(2,j),iobs(1,j))-Ict0)/
     &                       (sqrt(max(0.0,iobs(1,j)))+sqrt(Ict0)
c     del = sqrt(max(0.0,iobs(1j)))-sqrt(Ict0))
                        sigma_ml_bin(ibin) = sigma_ml_bin(ibin) + 
     &                       del**2
                        nref_in_bin(ibin) = nref_in_bin(ibin) + 1
                     enddo
                  endif
               endif
            enddo
c--   Previous subroutines should have made sure that the number of reflections
c--   is more than 0
            sigma_ml_bin(ibin) = 
     &           sigma_ml_ibin(ibin)/max(1,nref_in_bin(ibin))
c     
c--   Now refine scale parameters
            fold = 0.0
            do i=1,num_blocks
               ibb = obs_bin(i)
               if(ibb.eq.ibin) then
                  sigma = sigma_ml(ibin)*eps
                  o_s = obs_start(i)+1
                  o_f = obs_start(i+1)
                  c_s = ref_2_asym_start(i)+1
                  c_f = ref_2_asym_start(i+1)
                  do j=c_s,c_f
                     a_p(1) = fcalc(1,k)
                     b_p(1) = fcalc(2,k)
                     a_all = scale_ml(1,ibin)*a_p(1)
                     b_all = scale_nl(1,ibin)*b_p(1)
                     do ip=1,npart_act
                        a_p(ip+1) = fpart(ip,1,k)
                        b_p(ip+1) = fpart(ip,2,k)
                        a_all = a_all + scale_ml(ip+1,ibin)*a_p(ip+1)
                        b_all = b_all + scale_ml(ip+1,ibin)*b_p(ip+1)
                     enddo
                     Ic(j) = a_all*a_ll+b_all*b_all
                  enddo
c
                  do j=o_s,o_f
                     o_c_s = obs_start(j) + 1
                     o_c_f = obs_start(j+1)
                     Ict0 = 0.0
                     dIctdp(1:np1) = 0.0
                     do k=o_c_s,o_c_f
                        jc = ref_2_asym(k)
                        jal = comp_numb(k)
                        Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
                        dIctdp(1:np1) = dIctdp(1:np1) + 
     &                       twin_frac(jal)*(a_ll*a_p(1:np1)+
     &                       b_all*b_p(1:np1))
                     enddo
                     f0 = max(-3.0*iobs(2,j),iobs(1,j))-Ict0
                     f1 = sqrt(max(0.0,iobs(1,j)))+sqrt(Ict0)                     
                     fvalue_this = fvalue_this+0.5*(f0/f1)**2/sigma+ 
     &                    0.5*log(sigma)
                     dfdIct = (-1.0/f1-0.5*f0/(sqrt(Ict0)*f1**2))/sigma
                     d2fdIct = -1.0/sigma1
                     df1(1:np1) = df1(1:np1) + dfdIct*dIctdp(1:np1)
                     do ip=1,np1
                        do jp=1,np1
                           df2(ip,jp) = df2(ip,jp)+
     &                          d2fdIct*dIctdp(ip)*dIctdp(jp)
                        enddo
                     enddo
                  enddo
               enddo
            endif
         enddo
c
c---line minimise
         call  eigen_filter_r90(toler,df2(1:np1,1:np1,ibin),
     &        num_p,num_p,dfdp1(1:np1,ibin),shift(1:np1),ierr)
         g2p = dot_product(shift(1:np1),df1(1:np1))
c
c---  line minimise
         tst = 0.0
         do j=1,num_p
            tst = max(tst,abs(shift(j)/max(abs(scale_ml(j,ibin),1.0)
         enddo
         lambdmin - tol_conv1/tst
         lambd = 1.0
         conv_line = .FALSE
         scale_ml0(1:np1,1:nbin_ml) = scale_ml(1:np1,1:nbin_ml)
         jc = 0
         do while(jc.le.100)
            jc = jc + 1
            do ip=1,np1
               scale_ml(ip,ibin)=scale_ml0(ip,ibin)+
     &              lambd*shift(ip,ibin)
               scale_ml(ip,ibin) = max(0.01,scale_ml(ip,ibin))
               scale_ml(ip,ibin) = min(2.0,scale_ml(ip,ibin))
            enddo
            do i=1,num_blocks
               ibb = obs_bins(i)
               if(ibb.eq.ibin) then
                  o_s = obs_start(i) + 1
                  o_f = obs_start(i+1)
                  c_s = ref_2_asym_stat(i) + 1
                  c_f = ref_2_asym_start(i+1)
c     
                  do j=c_s,c_f
                     a_all = scale_ml(1,ibin)*fcalc(1,j)
                     b_all = scale_ml(1,ibin)*fcalc(2,j)
                     do k=1,npart_act
                        a_part = scale_part_ml(k+1,ibin)*fpart(k,1,j)
                        b_part = scale_part_ml(k+1,ibin)*fpart(k,2,j)
                        a_all = a_all + a_part
                        b_all = b_all + b_part
                     enddo
                     Ic(j) = a_all**2+b_all**2
                  enddo
c     
                  do j=o_s,o_f
                     o_c_s = obs_start(j) + 1
                     o_c_f = obs_start(j+1)
                     Ict0 = 0.0
                     do k=o_c_s,o_c_f
                        jc = ref_2_asym(k)
                        jal = comp_numb(k)
                        Ict0 = Ict0 + Ic(jc)*twin_frac(jal)
                     enddo
c     
c---  another option for delta
                     del = (max(-3.0*iobs(2,j),iobs(1,j))-Ict0)/
     &                    (sqrt(max(0.0,iobs(1,j)))+sqrt(Ict0)
                     f1 = f1 + 0.5*del**2/sigma1 + c1*log(sigma)
                  enddo
               endif
            enddo

            if(lambd.le.lambdmin) goto 20
            if(f1.le.fold+al0*lambd*g2p) goto 20
c
c---  Try new point and use interpolations
            if(j.eq.1) then
               tmp = -g2p/(2.0*(f1-fold-g2p))
            else
               l12 = lambd-lambd2
               r1 = f1-fold-lambd*g2p
               r2 = f2-fold-lambd2*g2p
               a  = (r1/lambd**2-r2/lambd2**2)/l12
               b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
               if(a.eq.0.0) then
                  tmp = -g2p/(2.0*b)
               else
                  d1 = max(0.0,b**2-3.0*a*g2p)
                  tmp = (-b+sqrt(d1))/(3.0*a)
               endif
            endif
            tmp = min(tmp,0.5*lambd)
            lambd2 = lambd
            f2 = f1
            lambd = max(tmp,0.1*lambd)
         enddo
         call errwrt(1,'Line minimisation failed')
 20      continue
c---  Check the convergence
         tst = 0.0
         do  j=1,num_p
            tst = max(tst,abs(shift(j))*lambd/max(abs(par0(j)),1.0))
         enddo
         tst = g2p*lambd/num_p
         if(tst.lt.tol_conv.or.f1.ge.fold) then 
            if(f1.gt.fold) then
               scale_ml(1:np1,ibin) = scale_ml0(1:np1)
            endif
            conv_sc = .TRUE.
         endif
      enddo
      deallocate(obs_bins)
      return
      end
c
      subroutine  ml_ml_pars(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      real freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      integer ierr
c
c---locals
      integer, allocatable :: obs_bins(:)
c
      integer maxcont_l
      parameter (maxcont_l = 48)
      real  Ic(maxcont_l)
      real a_all,b_all,ict,io0,exp1,expb,expbs,expbs_bulk,expban
      real s_b_part
      real hkl_this(3)
      real ast,bst,cst,cosast,cosbst,coscst,s,ss,rsq
      integer npar,npar_s
      real dsigmadp(6),d2sdp2(6,6)
      real diff,df(6),d2f(6,6),shift(6)
      real sigma_loc(2),sigma_bulk(2)
      real toler
      integer il
      integer i,j,m,k,jc,jal,is,ip,jp,ip1,iint
      integer o_s,o_f,c_s,c_f,c_n,o_c_s,o_c_f,c_1
      integer ierror
      logical error
c
      integer icycle,ncycle
      integer icent
      real cent,eps,obs2e,ss2
c
      real Ict0,Ict1,del,del2,bulk_cont
      integer l,n1_l,ii
      real expbulks,bulk,bulk2,expbulk,cnt,sigma,snorm,d2fds2
      real dfdsc,d2fd2sc
      real part_expbs
c
      logical conv_sc
c
c---- Assumptions: We already have laplace approximation to all reflections.
c
c---  Do minimisation in resolution bins
      ncycle = 20
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      do ibin=1,nbin_ml
         ic = 0
         conv_sc = .FALSE.
         do while(ic.le.ncycle.and. .not.conv_sc)
            ic = ic + 1
            sigma_ml_bin(ibin) = 0.0
c
c--   Recalculate sigmas where it is necessay. Do not consider converged bins
            do i=1,num_blocks
               ib1 = obs_bin(i)
               if(ib1.eq.ibin) then
                  if(freer(i).gt.0 .or. mlusework) then
                     o_s = block_start(i) + 1
                     o_f = bloc_start(i+1)
                     c_s = ref_2_asym_stat(i) + 1
                     c_f = ref_2_asym_start(i+1)
c
                     do j=c_s,c_f
                        cent = centr_hkl(j)
                        eps  = epslon_hkl(j)
                        a_all = scale_ml(1,ibin)*fcalc(1,j)
                        b_all = scale_ml(1,ibin)*fcalc(2,j)
                        do k=1,npart_act
                           a_part = scale_part_ml(k+1,ibin)*fpart(k,1,j)
                           b_part = scale_part_ml(k+1,ibin)*fpart(k,2,j)
                           a_all = a_all + a_part
                           b_all = b_all + b_part
                        enddo
                        Ic(j) = a_all**2+b_all**2
                        Icmax = fmax(1,j)**2+fmax(2,j)**2
                        fc1 = sqrt(Ic(j))
                        fc2 = sqrt(Icmax)
                        xx  = fc1*fc2/(sigma*eps*cent)
                        if(icent.eq.0) then
                           fom = sim(xx)
                        else
                           if(xx.gt.30.0) then
                              fom = 1.0
                           else
                              fom = tanh(xx)
                           endif
                        endif
                        del2 = Icmax+Ic(j)- 2.0*sqrt(Ic(j)*Icmax)*fom
                        del2 = del/(sigma*eps*cent)
                        sigma_ml(ibin) = sigma_ml(ibin) + 
     &                       del2
                        nref_ml(ibin) = nref_ml(ibin) + cent
                     enddo
c
                  endif
               endif
            enddo
c--   Previous subroutines should have made sure that the number of reflections
c--   is more than 0
            sigma_ml_bin(ibin) = 
     &           sigma_ml_ibin(ibin)/max(1,nref_in_bin(ibin))
c
c---We may need to refine sigma till convergence
c     
c--   Now refine scale parameters
            fold = 0.0
            do i=1,num_blocks
               ibb = obs_bin(i)
               if(ibb.eq.ibin) then
                  sigma = sigma_ml(ibin)*eps
                  o_s = obs_start(i)+1
                  o_f = obs_start(i+1)
                  c_s = ref_2_asym_start(i)+1
                  c_f = ref_2_asym_start(i+1)
                  do j=c_s,c_f
                     a_p(1) = fcalc(1,k)
                     b_p(1) = fcalc(2,k)
                     a_all = scale_ml(1,ibin)*a_p(1)
                     b_all = scale_nl(1,ibin)*b_p(1)
                     do ip=1,npart_act
                        a_p(ip+1) = fpart(ip,1,k)
                        b_p(ip+1) = fpart(ip,2,k)
                        a_all = a_all + scale_ml(ip+1,ibin)*a_p(ip+1)
                        b_all = b_all + scale_ml(ip+1,ibin)*b_p(ip+1)
                     enddo
                     Ic(j) = a_all*a_ll+b_all*b_all
                     fc = sqrt(Ic(j)))
                     cosp  = 0.0
                     sinp  = 0.0
                     if(fc.gt.0.0) then
                        cosp = a_all/fc
                        sinp = b_all/fc
                     endif
c
c--   all calculations here. If we need to add corrections then we can add 
c---  them later
                     fmaxm = sqrt(fmax(1,j)**2 + fmax(2,j)**2)
                     fnow = fvalue_r(fmaxm,fc,sigma,eps,cent)
                     fvalue = fvalue + fnow

                     dFdp(1:np1) = cosp*a_p(1:np1)+sinp*b_p(1:np1)
                     dfdF = (fc-fmaxm*fom)/sigma1
                     d2fdF= = 1/sigma1
                     df(1:np1) = df(1:np1) + dfdF*dFdp(1:np1)

                     do ip=1,np1
                        do jp=1,np1
                           df2(ip,jp)=df2(ip,jp)+d2fdF*dFdp(ip)*dFdp(jp)
                        enddo
                     enddo
                  enddo
c
               enddo
            endif
         enddo
c
c---line minimise
         call  eigen_filter_r90(toler,df2(1:np1,1:np1,ibin),
     &        num_p,num_p,dfdp1(1:np1,ibin),shift(1:np1),ierr)
         g2p = dot_product(shift(1:np1),df1(1:np1))
c
c---  line minimise
         tst = 0.0
         do j=1,num_p
            tst = max(tst,abs(shift(j)/max(abs(scale_ml(j,ibin),1.0)
         enddo
         lambdmin = tol_conv1/tst
         lambd = 1.0
         conv_line = .FALSE
         scale_ml0(1:np1,1:nbin_ml) = scale_ml(1:np1,1:nbin_ml)
         jc = 0
         do while(jc.le.100)
            jc = jc + 1
            do ip=1,np1
               scale_ml(ip,ibin)=scale_ml0(ip,ibin)+
     &              lambd*shift(ip,ibin)
               scale_ml(ip,ibin) = max(0.001,scale_ml(ip,ibin))
               scale_ml(ip,ibin) = min(5.0,scale_ml(ip,ibin))
            enddo
            f1 = 0.0
            do i=1,num_blocks
               ibb = obs_bins(i)
               if(ibb.eq.ibin) then
                  o_s = obs_start(i) + 1
                  o_f = obs_start(i+1)
                  c_s = ref_2_asym_stat(i) + 1
                  c_f = ref_2_asym_start(i+1)
c
                  do j=c_s,c_f
                     sigma = sigma_ml(ibin)
                     cent = centr_hkl(j)
                     eps  = eps_hkl(j)
                     a_all = scale_ml(1,ibin)*fcalc(1,j)
                     b_all = scale_ml(1,ibin)*fcalc(2,j)
                     do k=1,npart_act
                        a_part = scale_part_ml(k+1,ibin)*fpart(k,1,j)
                        b_part = scale_part_ml(k+1,ibin)*fpart(k,2,j)
                        a_all = a_all + a_part
                        b_all = b_all + b_part
                     enddo
                     fmaxm = sqrt(fmax(1,j)**2+fmax(2,j)**2)
                     fc = sqrt(a_all**2+b_all**2)
                     fnow= fvalue_r(fmaxm,fc,sigma,eps,cent)
                     f1 = f1 + fnow
                  enddo
               endif
            enddo

            if(lambd.le.lambdmin) goto 20
            if(f1.le.fold+al0*lambd*g2p) goto 20
c
c---  Try new point and use interpolations
            if(j.eq.1) then
               tmp = -g2p/(2.0*(f1-fold-g2p))
            else
               l12 = lambd-lambd2
               r1 = f1-fold-lambd*g2p
               r2 = f2-fold-lambd2*g2p
               a  = (r1/lambd**2-r2/lambd2**2)/l12
               b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
               if(a.eq.0.0) then
                  tmp = -g2p/(2.0*b)
               else
                  d1 = max(0.0,b**2-3.0*a*g2p)
                  tmp = (-b+sqrt(d1))/(3.0*a)
               endif
            endif
            tmp = min(tmp,0.5*lambd)
            lambd2 = lambd
            f2 = f1
            lambd = max(tmp,0.1*lambd)
         enddo
         call errwrt(1,'Line minimisation failed')
 20      continue
c---  Check the convergence
         tst = 0.0
         do  j=1,num_p
            tst = max(tst,abs(shift(j))*lambd/max(abs(par0(j)),1.0))
         enddo
         tst = g2p*lambd/num_p
         if(tst.lt.tol_conv.or.f1.ge.fold) then 
            if(f1.gt.fold) then
               scale_ml(1:np1,ibin) = scale_ml0(1:np1)
            endif
            conv_sc = .TRUE.
         endif
      enddo
      deallocate(obs_bins)
      return
      end
c
      subroutine get_obs_bins(nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,freer,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      real freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
c
c---  outputs
      integer obs_bins(num_blocks)
      integer ierr
c
      integer ibin,i
      integer o_s,o_f,c_s,c_f,c_1
      real rsq,stl_c
c
      real lstlsq_r
c
      obs_bins(1:num_blocks) = 0
      do i=1,num_blocks
         o_s = obs_start(i)+1
         o_f = obs_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,c_1))
         stl_c = sqrt(rsq)
         do ibin=1,nbin_ml
            if(stl_c.gt.sminb_ml(ibin).and.stl_c.le.smaxb_ml(ibin))
     &           then
               obs_bins(i) = ibin
               goto 50
            endif
         enddo
      enddo
 50   continue

      return
      end
c
      subroutine get_max_simple()


      do i=1,num_blocks
         o_s = obs_start(i)+1
         o_e = obs_stat(i+1)
         ibin = obs_bin(i)
         df(1:ncomp) = 0.0
         d2f(1:ncomp,1:ncomp) = 0.0
         jc = 0
         do j=c_s,c_f
            jc = jc + 1
            a_all = fcalc(1,j)*scale_ml(1,ibin)
            b_all = fcalc(2,j)*scale_ml(1,ibin)
            do k=1,npart_act
               a_all = a_all + fpart(k,1,j)*scale_ml(k+1,j)
               b_all = b_all + fpart(k,2,j)*scale_ml(k+1,j)
            enddo
            Ic = a_all*a_all+b_all*b_all
            sigma = sigma_ml(ibin)*(sigm_ml(ibin)+2.0*Ic)

            df(jc) = df(jc) + Ic/sigma
            d2f(jc,jc) = d2f(jc,jc) + 1.0/sigma
         enddo

         do j=o_s,o_f
            o_s_c = obs_start(j)+1
            o_s_f = obs_start(j+1)
            do k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               df(j) = df(j) + twin_frac(jal)*iobs(1,j)/iobs(2,j)
               do k1=o_c_s,o_c_f
                  jc1 = ref_2_asym(k1)
                  jal1 = comp_numb(k1)
                  d2f(jc,jc1) = d2f(jc,jc1) + 
     &                 twin_frac(jal)*twin_frac(jal1)/iobs(2,j)
               enddo
            enddo
         enddo
c
c--   Solve the equation
         call solve_linear_refmac()
c
c---Solve linear
         do j=c_s,c_f
            if(shift(jj).gt.0.0) then
               fmax(j) = sqrt(shift(jj))
            else
               fmax(j) = sqrt(Ic(jj))
         enddo
         if(fmax(j).lt.0.0) fmax(j) = 
      enddo
      return
      end
c
      subroutine get_max_mllaplace()

      return
      end
c
