C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C -----------------------------------------------
C 
C use before: subr. "lput_new" to put info into L1L_, L1A_
C
C use after : subr."cpl_mlib" to copy descr. of new mon. to library.
C
C ierr  2 - list of bonds is not correct (L1A_PSNT = 'M')
C      10 - not completely connected
C
      SUBROUTINE CREAT_NEW(MMDOC,LIST,MODE_I,PNUM,NAME,VANGLE,IERR)
C --------------------------------------------------------
C -P- CREAT_NEW -
C         -- MODE: 'COOR'/'TEST' --
C           'TEST' as COOR but Vobs --> Vidl
C
C       L1L_PRSNT = 'N'
C     input:
C        L1L_MNAME
C        L1L_CODE
C        L1L_TYPE
C        L1L_NAME
C        L1A_NATOM 
C        L1A_COOR_FLAG()  = 'Y' 
C        L1A_X        () 
C        L1A_Y        () 
C        L1A_Z        ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C
C       L1L_PRSNT = 'N'
C     input:
C        L1L_MNAME
C        L1L_CODE
C        L1L_TYPE
C        L1L_NAME
C        L1A_NATOM 
C        L1A_COOR_FLAG()  = 'N' (or 'Y')
C              L1A_X        () 
C              L1A_Y        () 
C              L1A_Z        ()
C        L1A_CHEM     ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_TYPE     () ? or L1A_CHEM or full(with H) list of atoms 
C
C        L1C_NCHIR
C ---
C -S-
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE_I*4,NAME*(*),LIST*1,PNUM*12
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
      CHARACTER LINE*256,CH4*4,MON*8,COOR*1,MODE*4,MON_INPUT*8
      CHARACTER ASYMB*4,CTYPE*4,MOD*1,MODE_M*4,CHEM_FLAG*1,TYPE*16
C ---------------------------------------------
      MDOC = MMDOC
      M  = 99
      MD =-ABS(MDOC)-1
      MT = 99
      IF(LIST.EQ.'T') MT = MDOC
      IF(LIST.EQ.'T'.OR.LIST.EQ.'L') THEN        
        MD = MDOC
      ELSE IF(LIST.EQ.'S') THEN
        MDOC = 99
        MD   = 99       
      ENDIF
      IERR = 0
C --------------------------------------------------------
      COOR = 'N'
      MODE = 'CONN'

      MON  = L1L_MNAME        

      IF(MODE_I.EQ.'TEST') THEN
        COOR ='Y'
      ENDIF

      IF(L1L_PRSNT.NE.'N'.AND.L1L_PRSNT.NE.'M') THEN
        LINE = ' ERROR in MAKE_NEW: '//MON//
     *         ' : L1L_PRSNT must be N or M'
        CALL MSGDOC(MD,LINE)
        IERR = 1
        RETURN
      ENDIF           

      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---make_new :prsnt,coor:',L1L_PRSNT,COOR
        CALL MSGERR(MDOC,LINE)
      ENDIF

      IF(L1A_NATOM.LE.0) THEN
        WRITE(LINE,'(3A,I4)')
     *' ERROR: number of atoms in new monomer ',L1L_MNAME,' = ',
     * L1A_NATOM
        CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      NA     = L1A_NATOM
      MON    = L1L_MNAME        

C     check unique atom names

      IF(NA.GT.1) THEN
        DO I=1,NA-1
          DO J=I+1,NA
            IF(L1A_ANAME(I).EQ.L1A_ANAME(J)) THEN
              LINE = ' ERROR : '//MON//
     *               ' : duplicated atom_name : "'//L1A_ANAME(I)//'".'
              CALL MSGERR(MDOC,LINE)
              IERR = 1
            ENDIF           
          ENDDO
        ENDDO
        IF(IERR.NE.0) RETURN
      ENDIF

C     set atom types to L1A_ATYPE() using L1A_SYMB

      DO I=1,NA
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
          L1A_NHATOM   = L1A_NHATOM + 1
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        L1A_ATYPE(I)=CTYPE(1:1)
      ENDDO

C --------------------------------------------------------

      IF(L1L_PRSNT.EQ.'N') THEN
        CHEM_FLAG  = 'N'
        MODE = 'COOR'

C       remove Hatoms with occ = 0
C       check occ.

        CALL CHECK_LIST_ATOM(MDOC,IERR)
        IF(IERR.NE.0) RETURN
        NA = L1A_NATOM
        
      ELSE IF(L1L_PRSNT.EQ.'M') THEN
        MODE       = 'CONN'
        CHEM_FLAG  = 'Y'

c       check list of bonds

        CALL CHECK_LIST_BOND(MDOC,CHEM_FLAG,IERR)
        IF(IERR.NE.0) RETURN

      ENDIF

C     clean some arrays

      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---chir before:',L1C_NCHIR,L1L_PRSNT
        CALL MSGERR(MDOC,LINE)
      ENDIF

      L1A_NHATOM = 0
      IF(L1L_PRSNT.NE.'M') THEN
        L1C_NCHIR  = 0
      ELSE
C       check atoms of chiralities

        CALL CHECK_CHIR_ATOM(MDOC,IERR)
        IF(IERR.NE.0) RETURN

      ENDIF

      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---chir after:',L1C_NCHIR,L1L_PRSNT
        CALL MSGERR(MDOC,LINE)
      ENDIF


      L1N_NCONN  = 0
      L1P_NPLAN  = 0 
      L1T_NTORS  = 0
      L1G_NANGL  = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_ICHIR(I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
        L1A_BACK (I) = '.'
        L1A_TYPE (I) = '.' 
        L1A_FORW (I) = '.'
        L1A_NRING(I) = 0

        IF(CHEM_FLAG.NE.'Y') L1A_CHEM(I) = '.' 

        DO  J=1,MAX1BRN 
          L1A_CONN     (J,I) = 0
          L1A_LENCON   (J,I) = 0
          L1A_RING_ID  (J,I) = 0
          L1A_RING_ORD (J,I) = 0
          L1A_RING_FLAT(J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
      ENDDO
C ---
      IF(NA.LE.1) THEN
        L1A_ISTART  = 1
        L1A_IFINISH = 1
        L1A_BACK(1) = '.'
        L1A_FORW(1) = 'END'
        L1A_CHEM(1) = L1A_SYMB(1) 
        NRING       = 0
        L1A_NRING(1)= 0
        ITYPE_RES   = 1
        GO TO 300
      ENDIF
C --------------------------------------------------------
C ---

      i=1
      LINE = ' --- before lib_conn/coor_conn ---'
      CALL WRITE_TEST(MT,i,line)

C      create description of connectivity  
      IF(L1L_PRSNT.NE.'M') THEN
        CALL LIST_BONDS_FROM_COOR(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      i=2
      LINE = ' --- before REMOVE_TRIANGLE_H ---'
      CALL WRITE_TEST(MT,i,line)

      CALL REMOVE_TRIANGLE_H(MDOC,IERR)
      i=2
      LINE = ' --- after REMOVE_TRIANGLE_H ---'
      CALL WRITE_TEST(MT,i,line)

C     CALL REMOVE_TRIANGLE(MDOC,IERR)

      CALL LIB_CONN(MDOC,MODE,IERR)
      IF(IERR.NE.0) RETURN

      i=2
      LINE = ' --- after lib_conn/coor_conn ---'
      CALL WRITE_TEST(MT,i,line)
C --------------------------------------------------------
C

      CALL CHECK_CONNECTIVITY(MDOC,LIST,IERR)
      IF(IERR.NE.0) RETURN

      i=2
      LINE = ' --- after  CHECK_CONNECTIVITY---'
      CALL WRITE_TEST(MT,i,line)
C
C --------------------------------------------------------
C
C     define l1a_ichir     
C     L1A_ICHIR() = 1 user, 2 (n=4 or n=3( coords--> volume >  RLIMC(=0.5))

      CALL DEFINE_CHIR_FLAG(MDOC,IERR)
      IF(IERR.NE.0) RETURN
C       
C
C --------------------------------------------------------
C
C     list of rings
C --
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        line = ' --- before ring -- chem_flag:'//CHEM_FLAG
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(*,*) 'charge:',l1a_charg(ia)
          write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_ichir(Ia),L1A_ichem(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IPRSNT = 1
      CALL RING(MDOC,LIST,NRINGT,IPRSNT,IERR)
      IF(IERR.NE.0) RETURN

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        line = ' --- after ring -- chem_flag:'//CHEM_FLAG
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_ichir(Ia),L1A_ichem(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF


C --------------------------------------------------------
C      coors        CHEM_FLAG  = 'N'
C      bond order   CHEM_FLAG  = 'B'
C      chem type    CHEM_FLAG  = 'Y'
C      atom list    CHEM_FLAG  = 'L'

C      IF(CHEM_FLAG.EQ.'Y') CHEM_FLAG  = 'L'

      IF(CHEM_FLAG.EQ.'N') THEN
C       bond_order from coords
        CALL ADD_TYPE_USING_COORD(MDOC,LIST,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: in subroutine ADD_TYPE_USING_COORD')
          RETURN
        ENDIF
      ELSE IF(CHEM_FLAG.EQ.'Y') THEN
         write(*,*)'We are here '
C       bond_order from chem types
c        CALL ADD_TYPE_USING_CHEM(MDOC,LIST,IERR)
        CALL ADD_TYPE_USING_LIST(MDOC,LIST,IERR)

        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: in subroutine ADD_TYPE_USING_CHEM')
          RETURN
        ENDIF
      ELSE IF(CHEM_FLAG.EQ.'L') THEN
C       bond_order from list of atoms and bonds 
        CALL ADD_TYPE_USING_LIST(MDOC,LIST,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: in subroutine ADD_TYPE_USING_LIST')
          RETURN
        ENDIF
      ENDIF
cd      STOP
      CALL USE_VALENCY(MDOC,LIST,IERR)     
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: in subroutine USE_VALENCY')
        RETURN
      ENDIF

C --------------------------------------------------------
      NA  = L1A_NATOM
      NNH = L1A_NHATOM
C --------------------------------------------------------
C     define  chemical types
C
      CALL CHECK_CHEM_DD_MIN(MDOC,LIST,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: in subroutine CHECK_CHEM_DD_MIN')
        RETURN
      ENDIF

C ---

      IF(LIST.EQ.'T') THEN
        i=3
        LINE = ' --- after check_chem_dd ---'
        CALL WRITE_TEST(MT,i,line)
        call msgdoc(mdoc,' --- rings ---n,id,ord,flat')
        DO I=1,NA
          WRITE(LINE,'(I4,1X,A,1X,I4,3X,5(3I3,2X))') 
     *    I,l1a_aname(I),L1A_NRING(I)
     *    ,(L1A_RING_ID(J,I),L1A_RING_ORD(J,I),L1A_RING_FLAT(J,I),J=1,5)
          call msgdoc(mdoc,line)
        ENDDO
        call msgdoc(mdoc,' ------')
      ENDIF
C --------------------------------------------------------
C     CHECK_CHIR
C     analyze atoms conneted with othere 3 atoms  and create chir. or plan 
C     without coordinates,

      CALL LENSTR_BL(L1L_TYPE,LEN) 
      DO IT=1,N_RES_TYPE
        TYPE = RES_TYPE(IT)
        IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 801
      ENDDO
      IT = 1
 801  CONTINUE
      ITYPE_RES = IT
 
      CALL CHECK_CHIR(MDOC,LIST,ITYPE_RES,IERR)
      IF(IERR.NE.0) RETURN

C       calc number of noH-atoms

      NH = 0
      DO I=1,L1A_NATOM
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          NH = NH + 1
        ENDIF
      ENDDO
      L1A_NHATOM = NH
      L1L_NATM   = L1A_NATOM
      L1L_NHATM  = L1A_NHATOM
C --------------------------------------------------------
C     CHECK_PLAN
C     check plans

      CALL CHECK_PLAN(MDOC,NRINGT,LIST,IERR)
      IF(IERR.NE.0) RETURN

C
C --------------------------------------------------------
C     create tree like structure
c
      CALL CREATE_TREE_NEW(MDOC,LIST,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: in subroutine CREATE_TREE_NEW')
        RETURN
      ENDIF
C      CALL CHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
C      IF(IERR.NE.0) RETURN
c      CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                                  (MDOC,ITYPE_RES,IERR)
c       CALL GET_INI_RES_TYPE(MDOC,LINE,CH8,IT,IERR)

      CALL LENSTR_BL(L1L_TYPE,LEN) 
      DO IT=1,N_RES_TYPE
        TYPE = RES_TYPE(IT)
        IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 800
      ENDDO
      IT = 1
 800  CONTINUE
      ITYPE_RES = IT

      CALL CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
      IF(IERR.NE.0) RETURN

 300  CONTINUE
C ---
C     calc number of noH-atoms
      NH = 0
      DO I=1,L1A_NATOM
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          NH = NH + 1
        ENDIF
      ENDDO
      L1A_NHATOM = NH
C ---------
      IF(LIST.EQ.'T') THEN
        i=4
        WRITE(LINE,'(A,2I5)') 
     *  '-  after create_tree -',L1C_NCHIR,L1P_NPLAN
        CALL MSGDOC(MDOC,LINE)
        write(LINE,*) '==res_type',ITYPE_RES
        CALL MSGDOC(MDOC,LINE)
        CALL WRITE_TEST(MT,i,line)
      ENDIF
C -----------------------------------------------
C SET_NUM - defines atom's number for atom's name.
C           checks tree like sructure, extra_atoms
C           adds H_atoms
      CALL SET_NUM(MDOC,MON,PNUM,IERR)
      IF(IERR.NE.0) RETURN

C -----------------------------------------------
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,i3,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_iold(ia),l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C --------------------------------------------------------
      CALL ADD_HATOM_TO_PLAN(MDOC,IERR)
      IERR = 0
C --------------------------------------------------------
C --------------------------------------------------------
C     create new descriptions (bonds,angles,tors) with values

      L1G_NANGL = 0
      L1T_NTORS = 0
      CALL CALC_VOBSN(MDOC,LIST,MON,NRINGT,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF 
      IF(COOR.EQ.'Y') THEN
        CALL SET_VOBS_TO_VIDL(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C ----
C     rebuild coords for H-atoms if all nonH-atoms have coords.

      IT = 0
      CALL H_ATOM_COORS_REBUILD(MDOC,LIST,IT,IERR)

C --------------------------------------------------
      IF(LIST.EQ.'T') write(*,*) ' --- ps---'
C ---   Create PostScript file ---
C      IF(L1L_PRSNT.NE.'M') THEN
      IF(NAME(1:1).NE.'?') THEN
        MOD       = 'C'
        MON_INPUT = ' '
        CALL GRAPH_NEWL(MDOC,MOD,MON_INPUT,NAME,VANGLE,IERR)
        IERR = 0
      ENDIF
C --------------------------------------------------
      IF(LIST.EQ.'T') write(*,*) ' ---end  ps---'
C     calc number of noH-atoms
      NH = 0
      DO I=1,L1A_NATOM
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          NH = NH + 1
        ENDIF
      ENDDO
      L1A_NHATOM = NH
      L1L_NATM   = L1A_NATOM
      L1L_NHATM  = L1A_NHATOM
      L1L_FUSE   = 'C'
      L1L_PRSNT  = '.'
C --------------------------------------------------
      IF(LIST.EQ.'T') write(*,*) ' ---end  make_new---'

      RETURN
      END     
C
      SUBROUTINE  CHECK_LIST_BOND(MDOC,CHEM_FLAG,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER CHEM_FLAG*1
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM1*4,ATOM2*4,CHEM*4,MON*8
C ---------------------------------------------
C      check list of bonds
C
C      bond order ? CHEM_FLAG  = 'B'
C      chem type  ? CHEM_FLAG  = 'Y'
C      atom list  ? CHEM_FLAG  = 'L'
C ------------------------------------
      IERR = 0
      NA   = L1A_NATOM
      NB   = L1B_NBOND 
      MON  = L1L_MNAME        

      IF(NA.LE.0.OR.NB.LE.0) RETURN

C     remove duplicated bonds
      IF(NB.GT.1) THEN
        NNB = 1
        DO IB=2,NB
          ATOM1 = L1B_1ATM(IB)
          ATOM2 = L1B_2ATM(IB)
          DO JB=1,NNB
            IF((ATOM1.EQ.L1B_1ATM(JB).AND.ATOM2.EQ.L1B_2ATM(JB)).OR. 
     *         (ATOM1.EQ.L1B_2ATM(JB).AND.ATOM2.EQ.L1B_1ATM(JB))) THEN 
              GO TO 100
            ENDIF 
          ENDDO
          NNB            = NNB + 1
          L1B_1ATM (NNB) = ATOM1 
          L1B_2ATM (NNB) = ATOM2 
          L1B_TYPE (NNB) = L1B_TYPE (IB)
          L1B_I1ATM(NNB) = L1B_I1ATM(IB)
          L1B_I2ATM(NNB) = L1B_I2ATM(IB)
          L1B_VOBS (NNB) = L1B_VOBS (IB)
          L1B_VAL  (NNB) = L1B_VAL  (IB) 
          L1B_DEV  (NNB) = L1B_DEV  (IB) 


 100      CONTINUE
        ENDDO
        L1B_NBOND = NNB
        NB        = NNB 
      ENDIF

C     check all l1b_1atm,l1b_2atm in the atom list
      DO IB=1,NB
        ATOM1 = L1B_1ATM(IB)
        ATOM2 = L1B_2ATM(IB)
        DO IA=1,NA 
          IF(ATOM1.EQ.L1A_ANAME(IA)) GO TO 200         
        ENDDO
        IERR = 2
        LINE = ' ERROR: '//MON//
     *         ' : list of bonds: ATOM:'//ATOM1//' ?'
        CALL MSGDOC(MDOC,LINE)
        
 200    CONTINUE
        DO IA=1,NA 
          IF(ATOM2.EQ.L1A_ANAME(IA)) GO TO 300         
        ENDDO
        IERR = 2
        LINE = ' ERROR: '//MON//
     *         ' : list of bonds: ATOM:'//ATOM2//' ?'
        CALL MSGDOC(MDOC,LINE)

 300    CONTINUE
      ENDDO
      IF(IERR.NE.0) RETURN

C      bond order ? CHEM_FLAG  = 'B'
C      chem type  ? CHEM_FLAG  = 'Y'
C      atom list  ? CHEM_FLAG  = 'L'
      CHEM_FLAG = 'B'
      DO IB=1,NB
        IF(L1B_TYPE(IB)(1:1).EQ.'.'.OR.L1B_TYPE(IB)(1:4).EQ.'cova') THEN
          CHEM_FLAG = 'Y'
        ENDIF
      ENDDO
      IF(CHEM_FLAG.EQ.'Y') THEN
        DO IA=1,NA
          IF(L1A_CHEM(IA)(1:1).EQ.'.') CHEM_FLAG = 'L'
        ENDDO
      ENDIF

      IF(CHEM_FLAG.EQ.'Y') THEN
C       check chem types    
        DO IA=1,NA
          CHEM = L1A_CHEM(IA) 
          DO IE=1,LEA_NATOM
            IF(CHEM.EQ.LEA_ANAME (IE)) GO TO 400
          ENDDO
          CHEM_FLAG = 'L'
          LINE = ' WARNING: '//MON//
     *         ' : chemical TYPE:'//CHEM//' not found'
          CALL MSGDOC(MDOC,LINE)
 400      CONTINUE
        ENDDO
      ENDIF


      RETURN
      END

      SUBROUTINE REMOVE_TRIANGLE(MDOC,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NB   = L1B_NBOND
      IF(NB.LE.2) RETURN
C ---
      DO I=1,NB-2
        IF(L1B_TYPE(I)(1:1).NE.'?') THEN
          DO J=I+1,NB-1
            IF(L1B_TYPE(J)(1:1).NE.'?') THEN
              IF(L1B_I1ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I1ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE
                IB1 = 0
                IB2 = 0
                IB3 = 0
              ENDIF
              IF(IB1.GT.0.AND.IB2.GT.0.AND.IB3.GT.0) THEN
                DO K=J+1,NB
                  IF(L1B_TYPE(K)(1:1).NE.'?') THEN
                  IF((L1B_I1ATM(K).EQ.IB1.AND.L1B_I2ATM(K).EQ.IB2).OR.
     *               (L1B_I1ATM(K).EQ.IB2.AND.L1B_I2ATM(K).EQ.IB1))THEN
                    L1B_TYPE(K) = '?' 

        LINE = ' WARNING: '//MON//' triangle:'//L1A_ANAME(IB1)//
     *         ' - '//L1A_ANAME(IB2)//' - '//L1A_ANAME(IB3)
        CALL MSGDOC(MDOC,LINE)
        LINE = '          bond:'//L1B_1ATM(K)//' - '//L1B_2ATM(K)//
     *         ' is removed'
        CALL MSGDOC(MDOC,LINE)
                    GO TO 200
                  ENDIF
                  ENDIF
 200              CONTINUE
                ENDDO
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
      ENDDO
C -----
      NNB = 0
      DO IB=1,L1B_NBOND
        IF(L1B_TYPE(IB)(1:1).NE.'?') THEN
          NNB            = NNB + 1
          L1B_1ATM (NNB) = L1B_1ATM (IB) 
          L1B_2ATM (NNB) = L1B_2ATM (IB)
          L1B_TYPE (NNB) = L1B_TYPE (IB)
          L1B_I1ATM(NNB) = L1B_I1ATM(IB)
          L1B_I2ATM(NNB) = L1B_I2ATM(IB)
          L1B_VOBS (NNB) = L1B_VOBS (IB)
          L1B_VAL  (NNB) = L1B_VAL  (IB) 
          L1B_DEV  (NNB) = L1B_DEV  (IB) 
        ENDIF 
      ENDDO
      L1B_NBOND = NNB

      RETURN
      END

      SUBROUTINE REMOVE_TRIANGLE_H(MDOC,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NB   = L1B_NBOND
      IF(NB.LE.2) RETURN
C ---
      DO I=1,NB-2
        IF(L1B_TYPE(I)(1:1).NE.'?') THEN
          DO J=I+1,NB-1
            IF(L1B_TYPE(J)(1:1).NE.'?') THEN
              IF(L1B_I1ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I1ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE
                IB1 = 0
                IB2 = 0
                IB3 = 0
              ENDIF
              IF(IB1.GT.0.AND.ib2.gt.0.and.ib3.gt.0) then
               if(L1A_ATYPE(IB2).EQ.'H') THEN
                DO K=J+1,NB
                  IF(L1B_TYPE(K)(1:1).NE.'?') THEN
                  IF((L1B_I1ATM(K).EQ.IB1.AND.L1B_I2ATM(K).EQ.IB2).OR.
     *               (L1B_I1ATM(K).EQ.IB2.AND.L1B_I2ATM(K).EQ.IB1))THEN
        LINE = ' WARNING: '//MON//' triangle:'//L1A_ANAME(IB1)//
     *         ' - '//L1A_ANAME(IB2)//' - '//L1A_ANAME(IB3)
        CALL MSGDOC(MDOC,LINE)
                    IF(L1A_ATYPE(IB3).EQ.'H') THEN 
                      L1B_TYPE(J) = '?'
        LINE = '          bond:'//L1B_1ATM(J)//' - '//L1B_2ATM(J)//
     *         ' is removed'
        CALL MSGDOC(MDOC,LINE)
                       GO TO 100
                    ENDIF 
                    L1B_TYPE(K) = '?' 
        LINE = '          bond:'//L1B_1ATM(K)//' - '//L1B_2ATM(K)//
     *         ' is removed'
        CALL MSGDOC(MDOC,LINE)
                    GO TO 200
                  ENDIF
                  ENDIF
 200              CONTINUE
                ENDDO
                endif
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
 100    CONTINUE
      ENDDO
C -----
      NNB = 0
      DO IB=1,L1B_NBOND
        IF(L1B_TYPE(IB)(1:1).NE.'?') THEN
          NNB            = NNB + 1
          L1B_1ATM (NNB) = L1B_1ATM (IB) 
          L1B_2ATM (NNB) = L1B_2ATM (IB)
          L1B_TYPE (NNB) = L1B_TYPE (IB)
          L1B_I1ATM(NNB) = L1B_I1ATM(IB)
          L1B_I2ATM(NNB) = L1B_I2ATM(IB)
          L1B_VOBS (NNB) = L1B_VOBS (IB)
          L1B_VAL  (NNB) = L1B_VAL  (IB) 
          L1B_DEV  (NNB) = L1B_DEV  (IB) 
        ENDIF 
      ENDDO
      L1B_NBOND = NNB

      RETURN
      END
C


      SUBROUTINE DEFINE_CHIR_FLAG(MDOC,IERR)
C -------------------------------------------------
C     DIFINE_CHIR_FLAG
C     not flat atom
C     L1A_ICHIR() = 1 user, 2 (n=4 or n=3( coords--> volume >  RLIMC)
C 
C     RLIMC=0.5
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      INTEGER*4 IJA(3)
      CHARACTER LINE*256
C ----------------------------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ----------------
      NA     = L1A_NATOM
      RLIMC  = 0.5

      IF(L1L_PRSNT.EQ.'M'.AND.L1C_NCHIR.GT.0) THEN
        DO I=1,L1C_NCHIR
          IF(L1C_SIGN(I)(1:4).NE.'cros'.AND.
     *       L1C_SIGN(I)(1:4).NE.'star'     ) THEN  
            J = L1C_I1ATM(I)
            IF(J.GT.0) L1A_ICHIR(J) = 1
          ENDIF         
        ENDDO
      ENDIF

      IF(NA.GT.3) THEN
        DO   I=1,NA

          IF(L1A_NDIST(I).GE.3.AND.L1A_ATYPE(I).NE.'H'.AND.
     *                             L1A_ICHIR(I).LE.0) THEN
            NNH  = 0
            NH   = 0
            AVOL = 0.0
            VOL  = 0.0

            DO J=1,L1A_NDIST(I)
              IJ = ABS(L1A_CONN(J,I))
              IF(L1A_ATYPE(IJ).NE.'H') THEN
                NNH = NNH + 1
                IF(NNH.LE.3) IJA(NNH) = IJ
              ELSE
                NH = NH + 1
              ENDIF
            ENDDO  

                
            N = NNH +NH
            IF(N.GT.3) THEN
              L1A_ICHIR(I) = 2
            ENDIF

c           IF(NNH.GE.3.AND.L1L_PRSNT.EQ.'M') THEN
            IF(NNH.GE.3) THEN
              I1 = IJA(1)
              I2 = IJA(2)
              I3 = IJA(3)
              IF(L1A_COOR_FLAG(I ).EQ.'N'.OR.
     *           L1A_COOR_FLAG(I1).EQ.'N'.OR.
     *           L1A_COOR_FLAG(I2).EQ.'N'.OR.
     *           L1A_COOR_FLAG(I3).EQ.'N'    ) THEN                 
                GO TO 600
              ENDIF
              X1 = L1A_X(I)
              Y1 = L1A_Y(I)
              Z1 = L1A_Z(I)
              X2 = L1A_X(I1)
              Y2 = L1A_Y(I1)
              Z2 = L1A_Z(I1)
              X3 = L1A_X(I2)
              Y3 = L1A_Y(I2)
              Z3 = L1A_Z(I2)
              X4 = L1A_X(I3)
              Y4 = L1A_Y(I3)
              Z4 = L1A_Z(I3)
              A1 = X2-X1
              A4 = Y2-Y1
              A7 = Z2-Z1
              A2 = X3-X1
              A5 = Y3-Y1
              A8 = Z3-Z1
              A3 = X4-X1
              A6 = Y4-Y1
              A9 = Z4-Z1
              VOL = A1*(A5*A9 - A8*A6)
     *             -A4*(A2*A9 - A8*A3)
     *             +A7*(A2*A6 - A5*A3)
              AVOL = ABS(VOL)
              IF(AVOL.GT.RLIMC) L1A_ICHIR(I) = 2
            ENDIF

 600        CONTINUE

          ENDIF
        ENDDO
      ENDIF

      RETURN
      END


      SUBROUTINE LIB_CONN(MDOC,MODE,IERR)
C -----------------------------------------
C  output:
C
C     L1A_NDIST(IA)   - number of connect. 
C     L1A_CONN(I,IA)  - list of connect. ( Ith conn. with atom L1A_CONN(I,IA))
C     L1A_LENCON(1,IA)- number oc connect. with H atoms
C
C    list of connect / only set atom's number using L1B_1ATM() and L1B_2ATM()
C     L1B_I1ATM (IB) = IA
C     L1B_I2ATM (IB) = JA
C     L1B_VOBS  (IB) = DIST  / if L1A_COOR_FLAG(IA) = 'Y' /
C -------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER CIATOM*1,CJATOM*1,MON*8
      CHARACTER FLAG*1,LINE*256
C --------------------------------
      IERR = 0
C     M    = -ABS(MDOC)-1
C -----
      NA     = L1A_NATOM
      MON    = L1L_MNAME        


      DO IA=1,NA
        L1A_NDIST(IA) = 0
      ENDDO
     
      IF(NA.LE.1) THEN
        RETURN
      ENDIF

      DO    IA=1,NA-1
      IF(L1A_ANAME(IA).NE.'    ') THEN
        CIATOM = L1A_ATYPE(IA)
        XI     = L1A_X(IA)
        YI     = L1A_Y(IA)
        ZI     = L1A_Z(IA)

        DO    JA=IA+1,NA
        IF(L1A_ANAME(JA).NE.'    ') THEN
          CJATOM = L1A_ATYPE(JA)
          XJ     = L1A_X(JA)
          YJ     = L1A_Y(JA)
          ZJ     = L1A_Z(JA)
          IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
            IC=1 
          ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
            IC=2
          ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
            IC=4
          ELSE 
            IC=3
          ENDIF
 
          DIST=0.0

          IF(L1A_COOR_FLAG(IA).EQ.'Y'.AND.
     *       L1A_COOR_FLAG(JA).EQ.'Y'     ) THEN
            DX   = XI-XJ
            DY   = YI-YJ
            DZ   = ZI-ZJ
            DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
          ENDIF 

          FLAG = 'N'
          IF(L1B_NBOND.GT.0) THEN
            DO IB=1,L1B_NBOND
              IF(L1B_1ATM(IB).EQ.L1A_ANAME(IA).AND.
     *           L1B_2ATM(IB).EQ.L1A_ANAME(JA)) THEN
                L1B_I1ATM (IB) = IA
                L1B_I2ATM (IB) = JA
                L1B_VOBS  (IB) = DIST
                FLAG           = 'Y'
                GO TO 501
              ELSE IF(L1B_2ATM(IB).EQ.L1A_ANAME(IA).AND.
     *                L1B_1ATM(IB).EQ.L1A_ANAME(JA)) THEN
                L1B_I1ATM (IB) = JA
                L1B_I2ATM (IB) = IA
                L1B_VOBS  (IB) = DIST
                FLAG           = 'Y'
                GO TO 501
              ENDIF
            ENDDO

 501        CONTINUE
            IF(FLAG.EQ.'Y') THEN
              IF(L1A_NDIST(IA).LT.MAX1BRN) THEN
                L1A_NDIST(IA)              = L1A_NDIST(IA) + 1
                L1A_CONN(L1A_NDIST(IA),IA) = JA
                IF(L1A_ATYPE(JA).EQ.'H') THEN
                  L1A_LENCON(1,IA) = L1A_LENCON(1,IA) + 1
                ENDIF
              ELSE
                WRITE(LINE,'(3A,I6)')
     *          ' WARNING: number of connections of new monomer '
     *          ,L1L_MNAME,' >',MAX1BND 
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *    '        Change parameter MAX1BND in "lib_com.fh"')
              ENDIF
              IF(L1A_NDIST(JA).LT.MAX1BRN) THEN
                L1A_NDIST(JA)              = L1A_NDIST(JA) + 1
                L1A_CONN(L1A_NDIST(JA),JA) = IA
                IF(L1A_ATYPE(IA).EQ.'H') THEN
                  L1A_LENCON(1,JA) = L1A_LENCON(1,JA) + 1
                ENDIF
              ELSE
                WRITE(LINE,'(3A,I6)')
     *          ' WARNING: number of connections of new monomer '
     *          ,L1L_MNAME,' >',MAX1BND 
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *    '        Change parameter MAX1BND in "lib_com.fh"')
              ENDIF
            ENDIF

          ENDIF
        ENDIF
        ENDDO
      ENDIF
      ENDDO

      RETURN
      END

      SUBROUTINE LIST_BONDS_FROM_COOR(MDOC,IERR)
C -----------------------------------------
C  output:
C
C     L1A_NDIST(IA)   - number of connect. 
C     L1A_CONN(I,IA)  - list of connect. ( Ith conn. with atom L1A_CONN(I,IA))
C     L1A_LENCON(1,IA)- number oc connect. with H atoms
C
C    list of connect / only set atom's number using L1B_1ATM() and L1B_2ATM()
C     L1B_I1ATM (IB) = IA
C     L1B_I2ATM (IB) = JA
C     L1B_VOBS  (IB) = DIST  
C -------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
      REAL      DLIM(4)
      CHARACTER CIATOM*1,CJATOM*1
      DATA DLIM/ 1.2, 1.9, 2.5, 2.85 /
C --------------------------------
      IERR   = 0
      IFIRST = 0
 100  CONTINUE
C -----
      NA        = L1A_NATOM
      L1B_NBOND = 0

      IF(NA.LE.1) THEN
        RETURN
      ENDIF

      DO IA=1,NA
        L1A_NDIST(IA) = 0 
      ENDDO
C ---
      DO    IA=1,NA-1
        CIATOM = L1A_ATYPE(IA)
        XI     = L1A_X(IA)
        YI     = L1A_Y(IA)
        ZI     = L1A_Z(IA)
        DO    JA=IA+1,NA
          CJATOM = L1A_ATYPE(JA)
          XJ     = L1A_X(JA)
          YJ     = L1A_Y(JA)
          ZJ     = L1A_Z(JA)
          IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
            IC=1 
          ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
            IC=2
          ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
            IC=4
          ELSE 
            IC=3
          ENDIF
          DX   = XI-XJ
          DY   = YI-YJ
          DZ   = ZI-ZJ
          DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
          IF(DIST.LE.DLIM(IC).AND.DIST.GT.0.001) THEN 
            IF(L1B_NBOND.GE.MAX1BND) THEN
              WRITE(LINE,'(3A,I6)')
     *        ' ERROR: number of bonds of new monomer '
     *        ,L1L_MNAME,' >',MAX1BND 
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *  '          Change parameter MAX1BND in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF 
            L1A_NDIST(IA) = L1A_NDIST(IA) + 1
            L1A_NDIST(JA) = L1A_NDIST(JA) + 1

            L1B_NBOND             = L1B_NBOND+1
            L1B_I1ATM (L1B_NBOND) = IA
            L1B_1ATM  (L1B_NBOND) = L1A_ANAME(IA)
            L1B_I2ATM (L1B_NBOND) = JA
            L1B_2ATM  (L1B_NBOND) = L1A_ANAME(JA)
            L1B_VOBS  (L1B_NBOND) = DIST
            L1B_TYPE  (L1B_NBOND) = '.'
          ENDIF

        ENDDO
      ENDDO

C     check_H-atoms connection, must be = 1

      IF(IFIRST.EQ.0) THEN
        IERR   = 0
        IFIRST = 1
        DO    IA=1,NA
          CIATOM = L1A_ATYPE(IA)
          IF(CIATOM.EQ.'H'.AND.L1A_NDIST(IA).NE.1) THEN
            L1A_ATYPE(IA) = '?'
            IERR = 1
          ENDIF
        ENDDO
        IF(IERR.NE.0) THEN
          IERR = 0
          CALL CHECK_LIST_ATOM(MDOC,IERR)
          IF(IERR.EQ.0) GO TO 100
        ENDIF
      ENDIF
C ---
      RETURN
      END

C --- Garib ---

C
      SUBROUTINE ADD_TYPE_USING_COORD(MDOC,LIST,IERR)
C --------------------------------------------
      IMPLICIT NONE
      INCLUDE 'lib_com.fh'
C
C--defines bond orders using coordinates
C
C----Alternative way is loop over atoms and their neibours.
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C ------------------------------
C        L1A_NATOM 
C        L1A_COOR_FLAG()  'Y' 
C        L1A_X        () 
C        L1A_Y        () 
C        L1A_Z        ()
C        L1A_CHARG    ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1A_ATYPE    ()  'H' for H and D
C                         'C' for C,N,O,B,F,LI  
C                         'P' for P,S  
C                         '$' other heavy atoms'   
C
C --- connection         
c
C    DO IC=1,L1A_NDIST(IA)  for each  IA - L1A_NDIST number of connected atoms
C    IAC = L1A_CONN(IC,IA)  connection:  IA --> IAC
C
C    number of connections with H-atoms
C    N_HATOM     = L1A_LENCON(1,IA)
C
C    only for H-atom:  
C    ICONN_H defines connection for H-atom
c    ICONN_H  = ABS(L1A_CONN(1,I))
C    i.e H-atom I is connected with atom ICONN_H 
C    ring
CC
c        DO I=1,L1A_NRING(IA)
c          L1A_RING_ID  (I,IA) - ring number
c          L1A_RING_ORD (I,IA) = 4,5,6 
c          L1A_RING_FLAT(I,IA) = 1 flat, 0 not flat
c
C --- chirality
C
C     L1A_ICHIR() : > 0 chir
C     L1A_ICHIR() = 1 user, 2 (ndist>3 or 
C                              ndist>2 ( coords--> volume >  RLIMC(=0.5))
c
C ---
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_TYPE     () 
C        L1B_VOBS     () 
C
C ---------------------
C
      integer ir1,ir2
      INTEGER IB,IA1,IA2,IB1,IB2,IEB1,IEB2,ILB,IL1,IL2,IBB,IA3,NBOND
      INTEGER ISING,iarom
      REAL    DIST,DIFF_DIST,DIFF_PREV,DIST1,DIST_BOND,VAL
      CHARACTER BOND_ORDER*8,BOND_ORDER1*8,ASYMB1*4,ASYMB2*4
      CHARACTER LINE*256
      real count
      integer icorrect,lbonds_loc(20),lat_loc(20)
      logical cont_correct
C
C -----------------------------------------------------------
c
      
      IERR = 0
      IF(L1B_NBOND.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
C
      do ia1=1,l1a_natom
         asymb1 = l1a_symb(ia1)
         if(asymb1(1:2).eq.'N ') then
            if(l1a_ndist(ia1).eq.4) then
               l1a_charg(ia1) = 1
            endif
         endif
c         write(*,*)l1a_symb(ia1),l1a_ndist(ia1),l1a_lencon(1,ia1)
      enddo
c      stop
      DO IB=1,L1B_NBOND
         if(l1b_type(ib).ne.' '.and.l1b_type(ib).ne.'.') goto 150
C
C---loop over all energetic type pairs and find 
C---closest distance for these element pairs.
         IA1    = abs(L1B_I1ATM(IB))
         IA2    = abs(L1B_I2ATM(IB))
         ASYMB1 = L1A_SYMB(IA1)
         ASYMB2 = L1A_SYMB(IA2)
         DIST   = L1B_VOBS(IB)
C---- Now check and define
C
C---  Values should be read from the library
         BOND_ORDER = '.'
         DIFF_PREV  = 1.0E32
C
C 
C---  Define obvious ones first
C
cd        WRITE(*,*)ASYMB1,ASYMB2,L1A_NDIST(IA1),L1A_NDIST(IA2),
cd     &            L1A_LENCON(1,IA1),L1A_LENCON(1,IA2)
         IF(ASYMB1(1:2).EQ.'H '.OR.
     &        ASYMB1(1:2).EQ.'D '.OR.
     &        ASYMB2(1:2).EQ.'H '.OR.
     &        ASYMB2(1:2).EQ.'D '.OR.
     &        ASYMB1(1:2).EQ.'F '.OR.
     &        ASYMB2(1:2).EQ.'F '.OR.
     &        ASYMB1(1:2).EQ.'CL'.OR.
     &        ASYMB2(1:2).EQ.'CL'.OR.
     &        ASYMB1(1:2).EQ.'I '.OR.
     &        ASYMB2(1:2).EQ.'I '.OR.
     &        ASYMB1(1:2).EQ.'CL'.OR.
     &        ASYMB2(1:2).EQ.'CL'.OR.
     &        ASYMB1(1:2).EQ.'BR'.OR.
     &        ASYMB2(1:2).EQ.'BR'.OR.
     &        ASYMB1(1:2).EQ.'B '.OR.
     &        ASYMB2(1:2).EQ.'B '
     &                                       )THEN
            BOND_ORDER = 'single'
         ELSEIF(ASYMB1(1:2).EQ.'O ') THEN
            IF(L1A_NDIST(IA1).EQ.2) BOND_ORDER = 'single'
         ELSEIF(ASYMB2(1:2).EQ.'O ') THEN
            IF(L1A_NDIST(IA2).EQ.2) BOND_ORDER = 'single'
         ELSEIF(ASYMB1(1:2).EQ.'C ') THEN
            IF(L1A_NDIST(IA1).EQ.4) BOND_ORDER = 'single'
         ELSEIF(ASYMB2(1:2).EQ.'C ') THEN
            IF(L1A_NDIST(IA2).EQ.4) BOND_ORDER = 'single'
         ELSEIF(ASYMB1(1:2).EQ.'N ') THEN
            IF(L1A_NDIST(IA1).EQ.4) BOND_ORDER = 'single'
         ELSEIF(ASYMB2(1:2).EQ.'N ') THEN
            IF(L1A_NDIST(IA2).EQ.4) BOND_ORDER = 'single'
         ELSEIF(ASYMB1(1:2).EQ.'S ') THEN
            IF(L1A_NDIST(IA1).EQ.2) BOND_ORDER = 'single'
         ELSEIF(ASYMB2(1:2).EQ.'S ') THEN
            IF(L1A_NDIST(IA2).EQ.2) BOND_ORDER = 'single'
         ELSE IF(ASYMB1(1:2).EQ.'SE') THEN
            IF(L1A_NDIST(IA1).EQ.2) BOND_ORDER = 'single'
         ELSE IF(ASYMB2(1:2).EQ.'SE') THEN
            IF(L1A_NDIST(IA2).EQ.2) BOND_ORDER = 'single'
         ENDIF
C
         DO   ILB=1,LEB_NBOND
            IB1 = LEB_I1ATM(ILB)
            IB2 = LEB_I2ATM(ILB)
C
C--Make sure that we are not considering single bonds between sp1
C--atoms. They are much shorter.
            IF((ASYMB1(1:2).EQ.LEA_ENAME(IB1)(1:2).AND.
     &           ASYMB2(1:2).EQ.LEA_ENAME(IB2)(1:2)).OR.
     &           (ASYMB2(1:2).EQ.LEA_ENAME(IB1)(1:2).AND.
     &           ASYMB1(1:2).EQ.LEA_ENAME(IB2)(1:2))) THEN

               IF((LEB_1ATM(ILB)(1:3).NE.'CSP'.AND.
     &              LEB_2ATM(ILB)(1:3).NE.'CSP'.AND.
     &              LEB_1ATM(ILB)(1:2).NE.'NS'.AND.
     &              LEB_2ATM(ILB)(1:2).NE.'NS').OR.
     &              LEB_TYPE(ILB)(1:4).EQ.'trip') THEN
                  DIFF_DIST = ABS(DIST-LEB_LENGTH(ILB))
                  IF(DIFF_DIST.LT.DIFF_PREV) THEN
                     DIFF_PREV  = DIFF_DIST
                     BOND_ORDER = LEB_TYPE(ILB)
                  ENDIF
               ENDIF
            ENDIF
         ENDDO
C
C---  There is no pair. Look for "covalent diameter" of atoms
         BOND_ORDER1 = '.'
         IF(BOND_ORDER(1:1).EQ.'.') THEN
            DO   IEB1=1,LEB_NBOND
               IF(LEB_2ATM(IEB1)(1:1).EQ.'.') THEN
                  IL1 = LEB_I1ATM(IEB1)
                  IF(ASYMB1(1:2).EQ.LEA_ENAME(IL1)(1:2)) THEN
                     BOND_ORDER1 = LEB_TYPE(IEB1)
                     DO  IEB2=1,LEB_NBOND
                        IF(LEB_2ATM(IEB2)(1:1).EQ.'.') THEN
                           IF(BOND_ORDER1(1:4).EQ.
     &                          LEB_TYPE(IEB2)(1:4)) THEN
                              IL2 = LEB_I1ATM(IEB2)
                              IF(ASYMB2(1:2).EQ.
     &                             LEA_ENAME(IL2)(1:2)) THEN
                                 DIST_BOND = 
     &                          (LEB_LENGTH(IEB1)+LEB_LENGTH(IEB2))/2.0
                                 DIFF_DIST = ABS(DIST_BOND-DIST)
                                 IF(DIFF_DIST.LT.DIFF_PREV) THEN
                                    DIFF_PREV  = DIFF_DIST
                                    BOND_ORDER = BOND_ORDER1
                                 ENDIF
                              ENDIF
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDIF
               ENDIF
            ENDDO
         ENDIF
C
C---  Still no bond order. If one of the atoms can have metal bond
         IF(BOND_ORDER(1:1).EQ.'.') THEN
            DO   IEB1=1,LEB_NBOND
               IB1 = LEB_I1ATM(IEB1)
               IB2 = LEB_I2ATM(IEB1)

c            IB1 = LEB_I1ATM(ILB)
c            IB2 = LEB_I2ATM(ILB)

c       write(*,*) ib1,ib2,'<',ASYMB1,'><',ASYMB2,'>'
c     * ,'<',LEA_ENAME(IB1),'><',LEA_ENAME(IB2),'>',LEB_TYPE(IEB1)


               IF((ASYMB1(1:2).EQ.LEA_ENAME(IB1)(1:2) .OR.
     &              ASYMB2(1:2).EQ.LEA_ENAME(IB1)(1:2) .OR.
     &              ASYMB1(1:2).EQ.LEA_ENAME(IB2)(1:2) .OR.
     &              ASYMB2(1:2).EQ.LEA_ENAME(IB2)(1:2)).AND.
     &              LEB_TYPE(IEB1)(1:5).EQ.'metal'         ) THEN
                  BOND_ORDER = 'metal'
                  GOTO 100
               ENDIF
            ENDDO
         ENDIF
C
c---Could not find from the energetic library. Something is wrong.
C---All atoms should be in the energetic library. Either library is not full
C---or element name is not correct.
         IF(BOND_ORDER.EQ.'.') THEN
            IERR = 1
            BOND_ORDER = 'single'
         ENDIF
 100     CONTINUE
C
c---Now define bond orders.
         L1B_TYPE(IB) = BOND_ORDER
 150     continue
C
C--Print to make sure things are all right.

      ENDDO
C
C---Check if element name is not correct.
C
      IF(IERR.NE.0) THEN
        DO   IA1=1,L1A_NATOM
          ASYMB1 = L1A_SYMB(IA1)
          DO   IL1=1,LEA_NATOM
            IF(ASYMB1(1:2).EQ.LEA_ENAME(IL1)) GOTO 200
          ENDDO
          LINE = 'ERROR: Atom '//L1A_ANAME(IA1)(1:4)//
     &    ' with element name '//ASYMB1(1:2)
          CALL MSGERR(MDOC,LINE)
          LINE = '       does not exist in the'//
     &        'energetic library "ener_lib.cif"'
          CALL MSGERR(MDOC,LINE)
 200      CONTINUE
        ENDDO
        LINE = 'ERROR: Energetic library - "ener_lib.cif" is incomplete'
        CALL MSGERR(MDOC,LINE)
        RETURN
      ENDIF
C
C--Can we correct some bond orders?
C
C--First see if we have triple bond. Then another bond must be single
      DO   IB=1,L1B_NBOND
        IA1    = L1B_I1ATM(IB)
        IA2    = L1B_I2ATM(IB)
        IF(L1B_TYPE(IB).EQ.'trip') THEN
          ASYMB1 = L1A_SYMB(IA1)
          ASYMB2 = L1A_SYMB(IA2)
          NBOND = L1A_NDIST(IA1)
          DO   IBB=1,NBOND
            IA3 = L1A_CONN(IBB,IA1)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.NE.IA2.AND.IA3.GT.0) THEN
              CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,IERR)
              IF(L1B_TYPE(IB1)(1:4).NE.'meta') L1B_TYPE(IB1) = 'single'
            ENDIF
          ENDDO
          NBOND = L1A_NDIST(IA2)
          DO   IBB=1,NBOND
            IA3 = L1A_CONN(IBB,IA2)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.NE.IA1.AND.IA3.GT.0) THEN
              CALL SRCH_BOND(MDOC,L1L_MNAME,IA2,IA3,VAL,IB1,IERR)
              IF(L1B_TYPE(IB1)(1:4).NE.'meta') L1B_TYPE(IB1) = 'single'
            ENDIF
          ENDDO
       else if(l1b_type(ib)(1:4).eq.'doub') then
c          asymb1 = l1a_symb(ia1)
c          asymb2 = l1a_symb(ia2)
c          if(asymb1(1:2).eq.'C ') then
c             nbond = l1a_ndist(ia1)
c             if(nbond.eq.3) then
c                do  ibb=1,nbond
c                   ia3 = l1a_conn(ibb,ia1)
c                   if(ia3.lt.0) ia3 = -ia3
c                   if(ia3.ne.ia2.and.ia3.gt.0) then
c                      call srch_bond
c     &                     (mdoc,l1l_mname,ia1,ia3,val,ib1,ierr)
c                      l1b_type(ib1) = 'single'
c                   endif
c                enddo
c             endif
c          else if(asymb2(1:2).eq.'C ') then
c             nbond = l1a_ndist(ia1)
c             if(nbond.eq.3) then
c                do  ibb=1,nbond
c                   ia3 = l1a_conn(ibb,ia2)
c                   if(ia3.lt.0) ia3 = -ia3
c                   if(ia3.ne.ia1.and.ia3.gt.0) then
c                      call srch_bond
c     &                     (mdoc,l1l_mname,ia2,ia3,val,ib1,ierr)
c                      l1b_type(ib1) = 'single'
c                   endif
c                enddo
c             endif
c          endif
c        ELSE IF(L1B_TYPE(IB)(1:4).EQ.'delo'.OR.
c     &          L1B_TYPE(IB)(1:4).EQ.'arom') THEN
C
C--   If one of the atoms is C and bond order is 'deloc' or 'arom'
C--   and C has three bonds, two of them is single then 'deloc' should become 'double'
c          ASYMB1 = L1A_SYMB(IA1)
c          ASYMB2 = L1A_SYMB(IA2)
c          ISING = 0
c          IF(ASYMB1(1:2).EQ.'C ') THEN
c            NBOND = L1A_NDIST(IA1)
c            DO   IBB=1,NBOND
c              IA3 = L1A_CONN(IBB,IA1)
c              IF(IA3.LT.0) IA3 = -IA3
c              IF(IA3.NE.IA2.AND.IA3.GT.0) THEN
c                CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,IERR)
c                IF(L1B_TYPE(IB1)(1:4).EQ.'sing') ISING = ISING + 1
c              ENDIF
c            ENDDO
c          ELSE IF(ASYMB2(1:2).EQ.'C ') THEN
c            NBOND = L1A_NDIST(IA2)
c            DO   IBB=1,NBOND
c              IA3 = L1A_CONN(IBB,IA2)
c              IF(IA3.LT.0) IA3 = -IA3
c              IF(IA3.NE.IA1.AND.IA3.GT.0) THEN
c                CALL SRCH_BOND(MDOC,L1L_MNAME,IA2,IA3,VAL,IB1,IERR)
c                IF(L1B_TYPE(IB1)(1:4).EQ.'sing') ISING = ISING + 1
c              ENDIF
c            ENDDO
c          ENDIF
c          IF(ISING.EQ.2) L1B_TYPE(IB) = 'double'
       ENDIF  
C
C--If one of the atoms is Hydrogen then bond order is single
       IF((L1A_SYMB(IA1)(1:2).EQ.'H '.OR.
     &      L1A_SYMB(IA2)(1:2).EQ.'H ').AND.
     &      L1B_TYPE(IB)(1:4).NE.'meta') THEN
          L1B_TYPE(IB) = 'single'
       ENDIF
      ENDDO
      cont_correct = .TRUE.
      do while(cont_correct) 
         icorrect = 0
         do ia1=1,l1a_natom
            nbond = l1a_ndist(ia1)
            if(nbond.gt.1) then
               if(l1a_symb(ia1).eq.'C ') then
                  do ib=1,nbond
                     ia2 = abs(l1a_conn(ib,ia1))
                     call srch_bond(mdoc,l1l_mname,ia1,ia2,val,ib1,ierr)
                     lbonds_loc(ib) = ib1
                     lat_loc(ib) = abs(ia2)
c                     write(*,*)ia1,ia2
                  enddo
                  if(nbond.eq.2) then
                     if(l1b_type(lbonds_loc(1))(1:4).eq.'sing'.and.
     &                    (l1b_type(lbonds_loc(2))(1:4).eq.'delo'.or.
     &                     l1b_type(lbonds_loc(2))(1:4).eq.'arom')) then
                        l1b_type(lbonds_loc(2)) = 'double'
                        icorrect = icorrect + 1
                     endif
                     if(l1b_type(lbonds_loc(2))(1:4).eq.'sing'.and.
     &                    (l1b_type(lbonds_loc(1))(1:4).eq.'delo'.or.
     &                     l1b_type(lbonds_loc(1))(1:4).eq.'arom')) then
                        l1b_type(lbonds_loc(1)) = 'double'
                        icorrect = icorrect + 1
                     endif
                     if(l1b_type(lbonds_loc(1))(1:4).eq.'doub'.and.
     &                    (l1b_type(lbonds_loc(2))(1:4).eq.'delo'.or.
     &                     l1b_type(lbonds_loc(2))(1:4).eq.'arom')) then
                        l1b_type(lbonds_loc(2)) = 'single'
                        icorrect = icorrect + 1

                     endif
                     if(l1b_type(lbonds_loc(2))(1:4).eq.'doub'.and.
     &                    (l1b_type(lbonds_loc(1))(1:4).eq.'delo'.or.
     &                     l1b_type(lbonds_loc(1))(1:4).eq.'arom')) then
                        l1b_type(lbonds_loc(1)) = 'single'
                        icorrect = icorrect + 1
                     endif
                  else if(nbond.eq.3.and.l1a_nring(ia1).gt.0) then
                     do ib2=1,nbond
                        ia2 = lat_loc(ib2)
                        if(l1a_nring(ia2).eq.0) then
                           if(l1b_type(lbonds_loc(ib2))(1:4).eq.'delo'
     &                                 .or.
     &                        l1b_type(lbonds_loc(ib2))(1:4).eq.'arom') 
     &                                           then
                              l1b_type(lbonds_loc(ib2)) = 'single'
                              icorrect = icorrect + 1
                           else if(l1a_nring(ia2).gt.0) then
                              do ir1=1,l1a_nring(ia1)
                                 do  ir2=1,l1a_nring(ia2)
                                    if(l1a_ring_id(ir1,ia1).eq.
     &                                   l1a_ring_id(ir2,ia2)) then
                                       goto 300
                                    endif
                                 enddo
                              enddo
                              l1b_type(lbonds_loc(ib2))='single'
                              icorrect = icorrect + 1
 300                          continue
                           endif
                        endif
                     enddo
                     if(l1a_ichir(ia1).eq.0) then
                        ising = 0
                        iarom = 0
                        do ib2=1,nbond
                           if(l1b_type(lbonds_loc(ib2))(1:4).eq.'sing')
     &                          ising = ising + 1
                           if(l1b_type(lbonds_loc(ib2))(1:4).eq.'delo'
     &                                  .or.
     &                        l1b_type(lbonds_loc(ib2))(1:4).eq.'arom')
     &                            iarom = iarom + 1
                        enddo
                        if(ising.eq.2.and.iarom.eq.1) then
                           do ib2=1,nbond
                             if(l1b_type(lbonds_loc(ib2))(1:4).eq.'delo'
     &                           .or.
     &                        l1b_type(lbonds_loc(ib2))(1:4).eq.'arom')
     &                           l1b_type(lbonds_loc(ib2)) = 'double'
                             icorrect = icorrect + 1
                           enddo
                        endif
                     endif
                  endif
               else if(l1a_symb(ia1).eq.'N ') then
                  if(l1a_ichir(ia1).eq.0) then
                     count = 0.0
                     if(nbond.eq.2.and.l1a_nring(ia1).gt.0) then
                        if(l1b_type(lbonds_loc(1))(1:4).eq.'sing'.and.
     &                       (l1b_type(lbonds_loc(2))(1:4).eq.'arom'.or.
     &                        l1b_type(lbonds_loc(2))(1:4).eq.'delo')
     &                                .and.
     &                        l1b_vobs(lbonds_loc(2)).lt.
     &                        l1b_vobs(lbonds_loc(1))) then
                           l1b_type(lbonds_loc(2)) = 'double'
                           icorrect = icorrect + 1
                        endif
                        if(l1b_type(lbonds_loc(2))(1:4).eq.'sing'.and.
     &                       (l1b_type(lbonds_loc(1))(1:4).eq.'arom'.or.
     &                        l1b_type(lbonds_loc(1))(1:4).eq.'delo')
     &                                 .and.
     &                        l1b_vobs(lbonds_loc(2)).lt.
     &                        L1b_vobs(lbonds_loc(1))) then
                           l1b_type(lbonds_loc(2)) = 'double'
                           icorrect = icorrect + 1
                        endif
                     endif
                     if(nbond.ge.3) then
                        do ib=1,nbond
                           if(l1b_type(ib)(1:4).eq.'sing') then
                              count = count + 1.0
                           else if(l1b_type(ib)(1:4).eq.'doub') then
                              count = count + 2.0
                           else if(l1b_type(ib)(1:4).eq.'arom') then
                              count = count + 1.5
                           else if(l1b_type(ib).eq.'delo') then
                              count = count + 1.5
                           endif
                           if(count.gt.3.5.and.count.le.4.5) then
                              if(l1a_charg(ia1).eq.0) then
                                 l1a_charg(ia1) = 1
                                 icorrect = icorrect + 1
                                 if(l1a_nring(ia1).gt.0) then
c                              dist_prev = 0.0
                                    
                                 endif
                              endif
                           endif
                        enddo
                     endif
                  endif
               endif
            endif
         enddo
         cont_correct = .TRUE.
         if(icorrect.eq.0) cont_correct = .FALSE.
      enddo
      

      RETURN
      END

      SUBROUTINE CHECK_OXYGENS_BOND(MDOC,LIST,IERR) 
      IMPLICIT NONE
      INCLUDE 'lib_com.fh'

      INTEGER MDOC,IERR
      CHARACTER LIST*1
C
C---Makes corrections for Oxygens bound to C, S and P
      INTEGER IA,IA1,IA2,IA3,ID,IB1,IB2,IB3,IB4,IOXIG,IA_OX(10)
      INTEGER IA31,IA32,IOTHER_BOND
      REAL EPS_L,VAL
      DATA EPS_L/1.0E-4/
C
      DO   IA=1,L1A_NATOM
C
C--Try to avoid repeatation.
        IF(L1A_SYMB(IA)(1:2).EQ.'O '.AND.
     &            ABS(L1A_CHARG(IA)).LT.EPS_L) THEN
          IF(L1A_NDIST(IA).EQ.1) THEN
C
C--Check neibouring atom. If it is C, N, S or P then try to make corrections
            IA1 = L1A_CONN(1,IA)
            IF(IA1.LT.0) IA1 = -IA1
            IF(IA1.GT.0) THEN
              IF(L1A_SYMB(IA1)(1:2).EQ.'C '.AND.L1A_NDIST(IA1).LT.4) 
     &                 THEN
C
C---It is C. If it is sp2 C then correction can be made. If C has four bounds 
C---then it cannot be SP2. Then it is SP3. 
                DO  ID=1,L1A_NDIST(IA1)
                  IA3 = L1A_CONN(ID,IA1)
                  IF(IA3.LT.0) IA3 = -IA3
                  IF(IA3.GT.0.AND.IA3.NE.IA) THEN
                    IF(L1A_SYMB(IA3)(1:2).EQ.'O ') THEN
C
C---There is another oxygen binds to the C. 
                      IF(L1A_NDIST(IA3).EQ.1) THEN
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB1,
     &                            IERR)
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB2,
     &                            IERR)
                        L1B_TYPE(IB1) = 'deloc'
                        L1B_TYPE(IB2) = 'deloc'
                        IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                     ABS(L1A_CHARG(IA3)).LT.EPS_L) THEN
                              L1A_CHARG(IA ) = -0.5
                              L1A_CHARG(IA3) = -0.5
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDIF
                ENDDO
             ELSEIF(L1A_SYMB(IA1)(1:2).EQ.'N '.AND.L1A_NDIST(IA1).EQ.3) 
     &                 THEN
C
C---It is C. If it is sp2 C then correction can be made. If C has four bounds 
C---then it cannot be SP2. Then it is SP3. 
                DO  ID=1,L1A_NDIST(IA1)
                  IA3 = L1A_CONN(ID,IA1)
                  IF(IA3.LT.0) IA3 = -IA3
                  IF(IA3.GT.0.AND.IA3.NE.IA) THEN
                    IF(L1A_SYMB(IA3)(1:2).EQ.'O ') THEN
C
C---There is another oxygen binds to the N. 
                      IF(L1A_NDIST(IA3).EQ.1) THEN
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB1,
     &                            IERR)
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB2,
     &                            IERR)
                        L1B_TYPE(IB1) = 'deloc'
                        L1B_TYPE(IB2) = 'deloc'
                        IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                     ABS(L1A_CHARG(IA3)).LT.EPS_L) THEN
                              L1A_CHARG(IA ) = -0.5
                              L1A_CHARG(IA3) = -0.5
                              L1A_CHARG(IA1) =  1.0
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDIF
                ENDDO
              ELSE IF(L1A_SYMB(IA1)(1:2).EQ.'S ') THEN
C
C---If there are 2 Oxygens with one bond. or 3 oxygens
                IF(L1A_NDIST(IA1).EQ.4) THEN
                  IOXIG = 0
                  IOTHER_BOND = 0
                  DO  ID=1,L1A_NDIST(IA1)
                    IA3 = L1A_CONN(ID,IA1)
                    IF(IA3.LT.0) IA3 = -IA3
                    IF(IA3.NE.IA.AND.IA3.GT.0) THEN
                      IF(L1A_SYMB(IA3)(1:2).EQ.'O ') THEN
                        IF(L1A_NDIST(IA3).EQ.1) THEN
                          IOXIG       = IOXIG + 1
                          IA_OX(IOXIG) = IA3
                        ELSE
                          IOTHER_BOND = IOTHER_BOND + 1
                        ENDIF
                      ELSE
C
C---What is happenning to the bond which is bound to the S and something else.
C---If it is not O then it can have double bond to S.
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                        IF(L1B_TYPE(IB1).EQ.'single') THEN
                          IOTHER_BOND = IOTHER_BOND + 1
                        ELSE IF(L1B_TYPE(IB1).EQ.'double') THEN
                          IOTHER_BOND = IOTHER_BOND + 2
                        ELSE
                          IOTHER_BOND = IOTHER_BOND + 1
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDDO
                  IF(IOXIG.EQ.0) THEN
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.5) THEN
                      L1B_TYPE(IB2) = 'single'
                    ELSEIF(IOTHER_BOND.EQ.4) THEN
                      L1B_TYPE(IB2) = 'double'
                    ENDIF
                  ELSE IF(IOXIG.EQ.1) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
C
C--If there is only one Oxygen then bonds could be double only. Should count 
C--number of other bonds also.
                    IF(IOTHER_BOND.EQ.2) THEN
                      L1B_TYPE(IB1) = 'double'
                      L1B_TYPE(IB2) = 'double'
                    ELSEIF(IOTHER_BOND.EQ.3) THEN 
C
c---Charge is -1
                      L1B_TYPE(IB1)  = 'deloc'
                      L1B_TYPE(IB2)  = 'deloc'
                      L1A_CHARG(IA)  = -0.5
                      L1A_CHARG(IA3) = -0.5
                    ELSEIF(IOTHER_BOND.EQ.4) THEN
                       L1B_TYPE(IB1) = 'deloc'
                       L1B_TYPE(IB2) = 'deloc'
                       L1A_CHARG(IA) = -1.0
                       L1A_CHARG(IA3) = -1.0
                    ENDIF
                  ELSE IF(IOXIG.EQ.2) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB3,
     &                            IERR)
C
C---If there are 2 more Oxygens then bonds are double and charge is -1
                    IF(IOTHER_BOND.EQ.1) THEN
                      L1B_TYPE(IB1)   = 'deloc'
                      L1B_TYPE(IB2)   = 'deloc'
                      L1B_TYPE(IB3)   = 'deloc'
C
C---Can one of the bonds not with Oxygen be double bond?? Check it
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA  ) = -0.33
                        L1A_CHARG(IA3 ) = -0.33
                        L1A_CHARG(IA31) = -0.33
                      ENDIF
                    ELSEIF(IOTHER_BOND.EQ.2) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      L1B_TYPE(IB3) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA  ) = -0.66
                        L1A_CHARG(IA3 ) = -0.66
                        L1A_CHARG(IA31) = -0.66
                      ENDIF
                    ENDIF
                  ELSE IF(IOXIG.EQ.3) THEN
C
C---If there are 3 extra Oxygens then it is SO4 and charge should ne -2
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    IA32 = IA_OX(3)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA32,VAL,IB3,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB4,
     &                            IERR)
                    L1B_TYPE(IB1) = 'deloc'
                    L1B_TYPE(IB2) = 'deloc'
                    L1B_TYPE(IB3) = 'deloc'
                    L1B_TYPE(IB4) = 'deloc'
                    IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(3))).LT.EPS_L) THEN

                      L1A_CHARG(IA  ) = -0.5
                      L1A_CHARG(IA3 ) = -0.5
                      L1A_CHARG(IA31) = -0.5
                      L1A_CHARG(IA32) = -0.5
                    ENDIF
                  ENDIF
                ENDIF
              ELSE IF(L1A_SYMB(IA1)(1:2).EQ.'P ') THEN
C
C--If there are 2 oxygens with one bond
C
C---If there are 2 Oxygens with one bond. or 3 oxygens
                IF(L1A_NDIST(IA1).EQ.4) THEN
                  IOXIG = 0
                  IOTHER_BOND = 0
                  DO  ID=1,L1A_NDIST(IA1)
                    IA3 = L1A_CONN(ID,IA1)
                    IF(IA3.LT.0) IA3 = -IA3
                    IF(IA3.NE.IA.AND.IA3.GT.0) THEN
                      IF(L1A_SYMB(IA3)(1:2).EQ.'O ') THEN
                        IF(L1A_NDIST(IA3).EQ.1) THEN
                          IOXIG = IOXIG + 1
                          IA_OX(IOXIG) = IA3
                        ELSE
                          IOTHER_BOND = IOTHER_BOND +1 
                        ENDIF
                      ELSE
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                        IF(L1B_TYPE(IB1).EQ.'single') THEN
                          IOTHER_BOND = IOTHER_BOND + 1
                        ELSE IF(L1B_TYPE(IB1).EQ.'double') THEN
                          IOTHER_BOND = IOTHER_BOND + 2
                        ELSE
                          IOTHER_BOND = IOTHER_BOND + 1
                        ENDIF                         
                      ENDIF
                    ENDIF
                  ENDDO
                  IF(IOXIG.EQ.0) THEN
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.3) THEN
                      L1B_TYPE(IB2) = 'double'
                    ELSE IF(IOTHER_BOND.EQ.4) THEN
                      L1B_TYPE(IB2) = 'single'
                    ENDIF
                  ELSEIF(IOXIG.EQ.1) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.2) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA3)).LT.EPS_L) THEN
                        L1A_CHARG(IA) = -0.5
                        L1A_CHARG(IA3) = -0.5
                      ENDIF
                    ELSE IF(IOTHER_BOND.EQ.3) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB1) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA3)).LT.EPS_L) THEN
                        L1A_CHARG(IA)  = -1.0
                        L1A_CHARG(IA3) = -1.0
                      ENDIF            
                    ENDIF
                  ELSE IF(IOXIG.EQ.2) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB3,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.1) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      L1B_TYPE(IB3) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA)   = -0.66
                        L1A_CHARG(IA3)  = -0.66
                        L1A_CHARG(IA31) = -0.66
                      ENDIF
                    ELSE
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      L1B_tYPE(IB3) = 'deloc'
                      L1B_TYPE(IB3) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA)   = -0.33
                        L1A_CHARG(IA3)  = -0.33
                        L1A_CHARG(IA31) = -0.33
                      ENDIF
                    ENDIF
                  ELSE IF(IOXIG.EQ.3) THEN
                     IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    IA32 = IA_OX(3)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA2,VAL,IB3,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB4,
     &                            IERR) 
                    L1B_TYPE(IB1) = 'deloc'
                    L1B_TYPE(IB2) = 'deloc'
                    L1B_TYPE(IB3) = 'deloc'
                   L1B_TYPE(IB4) = 'deloc'
                    IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                      L1A_CHARG(IA)   = -0.75
                      L1A_CHARG(IA3)  = -0.75
                      L1A_CHARG(IA31) = -0.75
                      L1A_CHARG(IA32) = -0.75
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE ADD_TYPE_USING_CHEM(MDOC,LIST,IERR)
C --------------------------------------------
      IMPLICIT NONE
C
C--defines bond orders using atom chemical types
C
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C --
      INCLUDE 'lib_com.fh'
C --
C ------------------------------
C        L1A_NATOM 
C        L1A_CHARG    ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1A_CHEM     ()
C        L1A_ATYPE    ()  'H' for H and D
C                         'C' for C,N,O,B,F,LI  
C                         'P' for P,S  
C                         '$' other heavy atoms'   
C
C --- connection         
c
C    DO IC=1,L1A_NDIST(IA)  for each  IA - L1A_NDIST number of connected atoms
C    IAC = L1A_CONN(IC,IA)  connection:  IA --> IAC
C
C    number of connections with H-atoms
C    N_HATOM     = L1A_LENCON(1,IA)
C
C    only for H-atom:  
C    ICONN_H defines connection for H-atom
c    ICONN_H  = ABS(L1A_CONN(1,I))
C    i.e H-atom I is connected with atom ICONN_H 
C    ring
CC
c        DO I=1,L1A_NRING(IA)
c          L1A_RING_ID  (I,IA) - ring number
c          L1A_RING_ORD (I,IA) = 4,5,6 
c          L1A_RING_FLAT(I,IA) = 1 flat, 0 not flat
c
C --- chirality
C
C     L1A_ICHIR() : > 0 chir, < 0 flat, else =0
C     L1A_ICHIR() = 1 user, 2 (ndist > 3 )
c
C ---
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_TYPE     () 
C        L1B_VOBS     () 
C
C ---------------------

      IERR = 1

C --------------------------------------------
C ---
      RETURN
      END

      SUBROUTINE ADD_TYPE_USING_LIST(MDOC,LIST,IERR)
C --------------------------------------------
      IMPLICIT NONE
C
C--defines bond orders using list of atoms (without chemical types)
C                       and list of bonds (without orders)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C --
      INCLUDE 'lib_com.fh'
C --
C ------------------------------
C        L1A_NATOM 
C        L1A_CHARG    ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1A_ATYPE    ()  'H' for H and D
C                         'C' for C,N,O,B,F,LI  
C                         'P' for P,S  
C                         '$' other heavy atoms'   
C
C --- connection         
c
C    DO IC=1,L1A_NDIST(IA)  for each  IA - L1A_NDIST number of connected atoms
C    IAC = L1A_CONN(IC,IA)  connection:  IA --> IAC
C
C    number of connections with H-atoms
C    N_HATOM     = L1A_LENCON(1,IA)
C
C    only for H-atom:  
C    ICONN_H defines connection for H-atom
c    ICONN_H  = ABS(L1A_CONN(1,I))
C    i.e H-atom I is connected with atom ICONN_H 
C    ring
C
c        DO I=1,L1A_NRING(IA)
c          L1A_RING_ID  (I,IA) - ring number
c          L1A_RING_ORD (I,IA) = 4,5,6 
c          L1A_RING_FLAT(I,IA) = 1 flat, 0 not flat
c
C --- chirality
C
C     L1A_ICHIR() : > 0 chir, < 0 flat, 0 non-flat
C     L1A_ICHIR() = 1 user, 2 (ndist > 3 )
c
C ---
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_VOBS     () 
C
C ---------------------
C
C---First define sp2, sp3 types etc. 
      INTEGER I,NBOND,N_HATOM,IA,IA1,IA2,IB,IR,IR1,IR2,NRING_ALL,
     &        IRING_FLAG,IAA,NBOND1,IA3
      REAL OXIDATION
      CHARACTER SYMB*4,SYMB1*4,SYMB2*4
      LOGICAL IS_IT_METAL,IS_IT_METAL1,IS_IT_METAL2
      EXTERNAL IS_IT_METAL
C
C--Treat simplest cases first.
      DO   I=1,L1B_NBOND
        IA1 = L1B_I1ATM(I)
        IA2 = L1B_I2ATM(I)
C
C---Find NBOND = all_bonds-metal_bonds. Metals have to be treated
C---properly. Sometimes metal bond will be counted in other cases
C---they should not be counted.

        SYMB1 = L1A_SYMB(IA1)
        SYMB2 = L1A_SYMB(IA2)

        IF(SYMB1(1:2).EQ.'H '.OR.
     &     SYMB1(1:2).EQ.'D '.OR.
     &     SYMB2(1:2).EQ.'H '.OR.
     &     SYMB2(1:2).EQ.'D '.OR.

     &     SYMB1(1:2).EQ.'F '.OR.
     &     SYMB2(1:2).EQ.'F '.OR.

     &     SYMB1(1:2).EQ.'CL'.OR.
     &     SYMB2(1:2).EQ.'CL'.OR.

     &     SYMB1(1:2).EQ.'I '.OR.
     &     SYMB2(1:2).EQ.'I '.OR.

     &     SYMB1(1:2).EQ.'CL'.OR.
     &     SYMB2(1:2).EQ.'CL'.OR.

     &     SYMB1(1:2).EQ.'BR'.OR.
     &     SYMB2(1:2).EQ.'BR'.OR.

     &     SYMB1(1:2).EQ.'B '.OR.
     &     SYMB2(1:2).EQ.'B '
     &                                        )THEN
          L1B_TYPE(I) = 'single'
        ELSEIF(IS_IT_METAL(L1A_SYMB(IA1)).OR.
     &         IS_IT_METAL(L1A_SYMB(IA2))) THEN
          L1B_TYPE(I) = 'metal'
        ELSE
          NBOND1 = L1A_NDIST(IA1)
          NBOND  = NBOND1
          DO  IAA=1,NBOND
            IA3 = L1A_CONN(IAA,IA1)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IS_IT_METAL(L1A_SYMB(IA3))) NBOND1 = NBOND1-1
          ENDDO
          IF(SYMB1(1:2).EQ.'C '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'O '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'N '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'S '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'SE'.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ENDIF

          NBOND1 = L1A_NDIST(IA2)
          NBOND  = NBOND1
          DO  IAA=1,NBOND
            IA3 = L1A_CONN(IAA,IA2)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IS_IT_METAL(L1A_SYMB(IA3))) NBOND1 = NBOND1-1
          ENDDO

C ????????????????????????
C         OXIDATION  = L1A_CHARG(IA2) ???
          OXIDATION  = 0.0
          IF(SYMB1(1:2).EQ.'C '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'O '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'N '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'S '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'SE'.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ENDIF
        ENDIF
      ENDDO
C
      DO   I=1,L1B_NBOND
        IF(L1B_TYPE(I).EQ.'.'.OR.L1B_TYPE(I)(1:3).EQ.'cov') GOTO 100
      ENDDO
      RETURN
C
C---We have not finished yet.
 100  CONTINUE
C
C--Define sp2 atoms. L1A_ICHIR(I) = -1
      DO   IA=1,L1A_NATOM
        L1A_ICHIR(IA) = 0
        SYMB  = L1A_SYMB(IA)
        NBOND = L1A_NDIST(IA)
        IF(SYMB(1:2).EQ.'C ') THEN
          IF(NBOND.EQ.3) THEN
            L1A_ICHIR(IA) = -1
          ENDIF
        ELSEIF(SYMB(1:2).EQ.'N ') THEN
          IF(NBOND.EQ.3.OR.NBOND.EQ.2) THEN
            L1A_ICHIR(IA) = -1
          ENDIF
        ELSEIF(SYMB(1:2).EQ.'B ') THEN
          IF(NBOND.EQ.3) THEN
            L1A_ICHIR(IA) = -1
          ENDIF
        ELSE

        ENDIF
      ENDDO
             
C
C---Go through rings and define if they are aromatic
C---Find number of rings
      NRING_ALL = 0
      DO  IA=1,L1A_NATOM
        DO   IR=1,L1A_NRING(IA)
          IF(NRING_ALL.LT.L1A_RING_ID(IR,IA)) 
     &             NRING_ALL=L1A_RING_ID(IR,IA)
        ENDDO
      ENDDO
C
C---Go through all rings
      IF(NRING_ALL.GT.0) THEN
        DO   IR=1,NRING_ALL
          IRING_FLAG = 0
          DO   IA=1,L1A_NATOM
            IF(L1A_NRING(IA).GT.0) THEN
              DO  IR1=1,L1A_NRING(IA)
                IF(L1A_RING_ID(IR1,IA).EQ.IR) THEN
                  IF(L1A_ICHIR(IA).NE.-1) THEN
                    IRING_FLAG = 1
                    GOTO 200
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDDO
C
c--It is flat ring. all bonds inside this ring are aromatic
          DO   IB=1,L1B_NBOND
            IA1 = L1B_I1ATM(IB)
            IA2 = L1B_I2ATM(IB)
            IF(L1A_NRING(IA1).GT.0.AND.L1A_NRING(IA2).GT.0) THEN
              DO   IR1=1,L1A_NRING(IA1)
                IF(L1A_RING_ID(IR1,IA1).EQ.IR) THEN
                  DO  IR2=1,L1A_NRING(IA2)
                    IF(L1A_RING_ID(IR2,IA2).EQ.IR) THEN
C
C--atoms are from the same ring and  ring is flat then nond is aromatic
                      IF(L1B_TYPE(IB).NE.'.'.AND.
     &                   L1B_TYPE(IB)(1:3).NE.'cov')THEN
                        L1B_TYPE(IB) = 'aromatic'
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 200      CONTINUE
        ENDDO
      ENDIF
C
      DO   I=1,L1B_NBOND
        IF(L1B_TYPE(I)(1:1).EQ.'.'.OR.L1B_TYPE(I)(1:2).EQ.'co') GOTO 300
      ENDDO
      GOTO 500
 300  CONTINUE
C
c---If still have not decided then if N or in some other cases we can make
C---decisions
C

C---Go through bonds
      DO   IB=1,L1B_NBOND
        IF(L1B_TYPE(IB)(1:1).EQ.'.'.OR.L1B_TYPE(IB)(1:3).EQ.'cov') THEN
C
C--Look atoms which make this bond and count their defined bonds
          IA1 = L1B_I1ATM(IB)
          IA2 = L1B_I2ATM(IB)
C
C---If atom would be aromatic decison could have been made already. It is
C---not
          IF(L1A_SYMB(IA1)(1:2).EQ.'N ') THEN
            IF(L1A_NDIST(IA1).GE.3) THEN
              L1B_TYPE(IB) = 'single'
C
c---Goto the next bond
              GOTO 400
            ENDIF
          ENDIF
          IF(L1A_SYMB(IA2)(1:2).EQ.'N ') THEN
            IF(L1A_NDIST(IA2).GE.3) THEN
              L1B_TYPE(IB) = 'single'
C
c---Goto the next bond
              GOTO 400
            ENDIF
          ENDIF
        ENDIF
 400    CONTINUE
      ENDDO

cd      DO   I=1,L1B_NBOND
cd        IF(L1B_TYPE(I).EQ.'.'.OR.L1B_TYPE(I)(1:3).EQ.'cov') GOTO 300
cd      ENDDO
 500  CONTINUE
C ---
      RETURN
      END
C
      LOGICAL FUNCTION IS_IT_METAL(SYMB)
C
c--
      IMPLICIT NONE
      INCLUDE 'metal.fh'
      CHARACTER SYMB*(*)
C
      INTEGER I
C
      DO I=1,N_NAME
        IF(SYMB(1:2).EQ.NAME(I)(1:2)) THEN
          IS_IT_METAL = .TRUE.
          RETURN
        ENDIF
      ENDDO
      IS_IT_METAL = .FALSE.
      RETURN
      END

      SUBROUTINE USE_VALENCY(MDOC,LIST,IERR)
      IMPLICIT NONE
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C ---
      REAL ANBO
      INTEGER NBO
      REAL    OXIDATION 
      INCLUDE 'lib_com.fh'
      CHARACTER LINE*256
      CHARACTER BTYPE*8,ANAME*4,ASYMB*4,ANAME_H*4,CH1*1,CH4*4
      CHARACTER ATOM_BONDS(20)*4
      INTEGER IA,ND,NBOND_ATOM,IB,NA,NNH,IDD,ID,LB,NH_ADD,LAN,IH,
     &        LLL,J,K,N_DUBL
      REAL    VAL
C ---------------------------------------------
      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---use valency --'
        CALL MSGERR(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
        WRITE(LINE,'(I4,'' bond '',A4,'' - '',A4,'' :'',2F8.3,2I3,A)')
     *    IB,L1B_1ATM(IB),L1B_2ATM(IB),L1B_VAL(IB),L1B_VOBS(IB)
     *    ,L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_TYPE(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO 
        ENDIF
      ENDIF

      CALL CHECK_OXYGENS_BOND(MDOC,LIST,IERR)
      NA  = L1A_NATOM
      NNH = L1A_NHATOM
C
C---Oxygens have to be treated using routine ???
      N_DUBL = 0

      DO IA=1,L1A_NATOM
        NBO        = 0
        ANBO       = 0.0
        NBOND_ATOM = 0
        OXIDATION  = L1A_CHARG(IA)
        ND         = L1A_NDIST(IA)
        ASYMB      = L1A_SYMB(IA)
        ANAME      = L1A_ANAME(IA)

        IF(ND.GT.0.AND.
     *     (ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')) THEN
          DO IDD=1,ND
            ID = L1A_CONN(IDD,IA)
            IF(ID.LT.0) ID = -ID
            CALL SRCH_BOND(MDOC,L1L_MNAME,IA,ID,VAL,LB,IERR)
            IF(IERR.EQ.0.AND.LB.GT.0) THEN
              BTYPE = L1B_TYPE(LB)
              IF(BTYPE(1:4).EQ.'sing') THEN
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'sing'
              ELSE IF(BTYPE(1:4).EQ.'doub') THEN
                ANBO       = ANBO + 2.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'doub'

              ELSE IF(BTYPE(1:4).EQ.'trip') THEN
                ANBO       = ANBO + 3.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'trip'

              ELSE IF(BTYPE(1:4).EQ.'arom') THEN
                ANBO       = ANBO + 1.5 
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'arom'

              ELSE IF(BTYPE(1:4).EQ.'delo') THEN
                ANBO       = ANBO + 1.5
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'delo'
              ELSE IF(BTYPE(1:4).EQ.'cova') THEN
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'cova'
              ELSE IF(BTYPE(1:4).EQ.'meta') THEN
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'meta'
              ELSE IF(BTYPE(1:4).EQ.'dumm') THEN
C               dummy bond
              ELSE
                WRITE(LINE,'(A)')'Warning: Unrecognised bond type.'
     &              //' Assumed single'
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'sing'
              ENDIF
            ELSE
              IERR = 0
              GO TO 100
            ENDIF
          ENDDO
          NBO   = NINT(ANBO+0.1)
          ASYMB = L1A_SYMB(IA)

          CALL FIND_HYDR_TYPE(MDOC,NBO,ANBO,NBOND_ATOM,OXIDATION,
     &                      NH_ADD,ASYMB,ATOM_BONDS)


          IF(LIST.EQ.'T') THEN
            WRITE(LINE,'('' ia,asym,nd,nbo,val:'',i3,a,2i4,f4.2)')
     *      IA,ASYMB,ND,NBO,OXIDATION
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(NH_ADD.LE.0) GO TO 100

          CALL LENSTR_BL(ANAME,LAN)
          IF(ASYMB(1:1).EQ.'C ') THEN
            IF(LAN.LE.1) THEN
              ANAME_H = 'H'
              LAN = 1
            ELSE
              IF(LAN.GT.4) LAN = 4
              ANAME_H = 'H'//ANAME(2:LAN)
C             LAN     = LAN + 1
            ENDIF
          ELSE  
            IF(LAN.GT.3) LAN = 3
            ANAME_H = 'H'//ANAME(1:LAN)
            LAN     = LAN + 1
          ENDIF

C  ????   unique name ?       

          DO IH=1,NH_ADD

            IF(NA.GE.MAX1ATM) THEN
              WRITE(LINE
     *        ,'('' ERROR : number of atoms of monomer >'',I6)') 
     *        MAX1ATM
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     *        ,'         Change parameter MAX1ATM in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF

            NA  = NA + 1
            NNH = NNH + 1

            L1A_COOR_FLAG(NA) = 'N'
            L1A_X    (NA) = 0.0
            L1A_Y    (NA) = 0.0
            L1A_Z    (NA) = 0.0
            L1A_CHARG(NA) = 0.0
            L1A_INEW (NA) = NA
            L1A_IOLD (NA) = NA
            L1A_ICR  (NA) = 0
            L1A_ICHIR(NA) = 0
            L1A_IBACK(NA) = 0
            L1A_IFORW(NA) = 0
            L1A_BACK (NA) = '.'
            L1A_TYPE (NA) = '.' 
            L1A_FORW (NA) = '.'
            LLL           = LAN
            IF(NH_ADD.GT.1) THEN
              WRITE(CH1,'(I1)') IH
              LLL = LAN + 1
              IF(LLL.GT.4) LLL = 4
              ANAME_H(LLL:LLL) = CH1
            ENDIF

            DO K=1,NA-1
              IF(ANAME_H.EQ.L1A_ANAME(K)) THEN
                N_DUBL = N_DUBL + 1
                WRITE(CH4,'(I4)') N_DUBL
                IF(CH4(2:2).EQ.' ') CH4(2:2) = '_' 
                IF(CH4(3:3).EQ.' ') CH4(3:3) = '_' 
                ANAME_H = 'H'//CH4(2:4)
              ENDIF           
            ENDDO

            CALL LENSTR_BL(ANAME_H,LLL)
            L1A_ANAME(NA) = ANAME_H(1:LLL)       

            L1A_CHEM (NA) = 'H   '
            L1A_SYMB (NA) = 'H   '

            L1A_ATYPE(NA) = 'H'

            L1A_NDIST(NA) = 1
            L1A_CONN   (1,NA) = IA
            L1A_LENCON (1,NA) = 0

            L1A_NDIST(IA) = L1A_NDIST(IA) + 1 
            L1A_CONN (L1A_NDIST(IA),IA) = NA
            L1A_LENCON (1,IA) = L1A_LENCON (1,IA) + 1

            L1A_NEXTR(NA) = 0
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,NA)  = 0
            ENDDO
            L1A_LENGTH(NA) = 0.0
            L1A_THETA (NA) = 0.0
            L1A_PHI   (NA) = 0.0
            L1A_ID_PSI(NA) = '.'

            L1A_RING_ID  (1,NA) = 0
            L1A_RING_ORD (1,NA) = 0
            L1A_RING_FLAT(1,NA) = 0

            IF(L1B_NBOND.LT.MAX1BND) THEN
              L1B_NBOND             = L1B_NBOND+1
              L1B_I1ATM (L1B_NBOND) = IA
              L1B_1ATM  (L1B_NBOND) = L1A_ANAME(IA)
              L1B_I2ATM (L1B_NBOND) = NA
              L1B_2ATM  (L1B_NBOND) = L1A_ANAME(NA)
              L1B_VAL   (L1B_NBOND) = 0.98
              L1B_VOBS  (L1B_NBOND) = 0.0
              L1B_TYPE  (L1B_NBOND) = 'single'
              L1B_EVAL  (L1B_NBOND) = 0.0
              L1B_DEV   (L1B_NBOND) = 0.02
            ENDIF
          ENDDO
        ENDIF
 100    CONTINUE
      ENDDO
C----
      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---after use valency --'
        CALL MSGERR(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
        WRITE(LINE,'(I4,'' bond '',A4,'' - '',A4,'' :'',2F8.3,2I3,A)')
     *    IB,L1B_1ATM(IB),L1B_2ATM(IB),L1B_VAL(IB),L1B_VOBS(IB)
     *    ,L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_TYPE(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO 
        ENDIF
      ENDIF

      L1A_NATOM  = NA
      L1A_NHATOM = NNH
      L1L_NATM   = L1A_NATOM
      L1L_NHATM  = L1A_NHATOM
      RETURN
      END
C
      SUBROUTINE FIND_HYDR_TYPE(MDOC,NBOND,ANBOND,
     &           NBOND_ATOM,OXIDATION,N_MISSING,ASYMB,ATOM_BONDS)

      IMPLICIT NONE
C
C---Finds number of missing hydrogens. Uses oxidation state
C---number of atoms bound already, number of bonds.      
      INTEGER MDOC,NBOND,NBOND_ATOM,N_OXIDATION,N_MISSING
      REAL    ANBOND,OXIDATION
      CHARACTER ASYMB*(*),LINE*256
C
      INTEGER IATOM,IVALENCY
      CHARACTER ATOM_BONDS(20)*(*)
C
C---Loop over possible atoms
      N_MISSING = 0
      IF(ASYMB.EQ.'LI') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'BE') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'B ') THEN
        N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3
cd        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'C ') THEN
        N_MISSING = INT(4.0-(ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'N ') THEN
        N_MISSING = INT(3.0-(ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'O ') THEN
        N_MISSING = INT(2.0-(ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2
        IF((NBOND_ATOM+N_MISSING).GT.2) THEN
          N_MISSING = 2 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'F ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MG') THEN
        N_MISSING = INT(2.0 - (ANBOND - OXIDATION)+0.2)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'AL') THEN
        N_MISSING = INT(3.0 - (ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'SI') THEN
        N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'P ') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND-OXIDATION)+0.25)
        ELSE
          N_MISSING = INT(5.0- (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'S ') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        ELSEIF(NBOND.LE.4) THEN
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(6.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'CL') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'K ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CA') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0


      ELSE IF(ASYMB(1:2).EQ.'SC') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TI') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'V ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'FE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NI') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ZN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'GA') THEN
        N_MISSING = INT(3.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'GE') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'AS') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(5.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'SE') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSEIF(NBOND.LE.4) THEN
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(6.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM 
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'BR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'KR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'SR') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'Y ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ZR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TC') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RH') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AG') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'IN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'SN') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'SB') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(5.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'TE') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSEIF(NBOND.LE.4) THEN
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(6.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'I ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'XE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CS') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'BA') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'LA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ND') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'SM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'EU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'GD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'DY') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'HO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ER') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'YB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'LU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'HF') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'W ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'OS') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'IR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PT') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'HG') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TL') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PB') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'BI') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(5.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.5) N_MISSING = 5

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'PO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AT') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'FR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AC') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TH') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'U ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NP') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'BK') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CF') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ES') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'FM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'LR') THEN
        N_MISSING = 0
      ELSE
        LINE = 'WARNING: Unrecognised atom name: '//ASYMB
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      RETURN
      END

C
      SUBROUTINE CHECK_CHEM_DD_MIN(MDOC,LIST,IERR)
      IMPLICIT NONE
C -----------------------------------------
C -P- CHECK_CHEM -
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C -----------------------------------------
      INTEGER NA,I,NBOND,N_OXIDATION,N_HATOM,IR1,IRING5,IRING6,
     &        IRING_THIS,ICONN_H,IR,IRING_FLAG,NBOND_OXI,J,
     &        NRING_ALL,IA,IA3
      INTEGER LB,IRING_FLAT1
      INTEGER IOXIG,IB,IA_OX(8)
      REAL    VAL
      CHARACTER LINE*256,SYMB*4,NAME*4,CHEM*4
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
C -----------------------------------------
      IERR = 0
      NA   = L1A_NATOM

      IF(LIST.EQ.'T') THEN
        call msgdoc(mdoc,'---check_chem_dd_min---')
        call msgdoc(mdoc,'aname/symb/chem/nbond/nhatom/iback/iforw')
      ENDIF

      DO I=1,NA

cd        L1A_SP_HYBR(I) = 4
C --
        NBOND       = L1A_NDIST(I)
C       number of connections with H-atoms
        N_HATOM     = L1A_LENCON(1,I)
        N_OXIDATION = L1A_CHARG(I)
C       element name
        SYMB        = L1A_SYMB(I)
C       ring-5:  
C               IRING5 >  0 flat 
C               IRING5 > 10 flat ring-55 
C               IRING5 <  0 not flat 
        IRING5      = L1A_IBACK(I)
C       ring-6:  
C               IRING6 >  0 flat 
C               IRING6 > 10 flat ring-66 
C               IRING6 <  0 not flat 
        IRING6      = L1A_IFORW(I)
C       only for H-atom:  
C          ICONN_H defines connection for H-atom
        ICONN_H     = ABS(L1A_CONN(1,I))
C          if(abs(ICONN_H)) > 0
C          connection with: L1A_SYMB(ICONN_H)
C --
        IF(LIST.EQ.'T') THEN
          write(line,'(i5,a,a,a,a,a,a,a,4i5)') 
     *    i,'/',L1A_ANAME(I),'/',L1A_SYMB(I),'/',L1A_CHEM(I),'/'
     *    ,NBOND,N_HATOM,L1A_IBACK(I),L1A_IFORW(I)
          call msgdoc(mdoc,line) 
        ENDIF
        NBOND_OXI = NBOND-N_OXIDATION
        IF(NBOND.GT.0) THEN
          IF(SYMB(1:2).EQ.'LI') THEN
C
C---Group 1 elements
            L1A_CHEM(I) = 'LI'

C
C---Group 2 elements


C
C---Group 3 elements
          ELSE IF(SYMB(1:2).EQ.'B ') THEN
             L1A_CHEM(I) = 'B   '
C
C---Group 4 elements
          ELSE IF(SYMB(1:2).EQ.'C ') THEN
C
C---Carbon. 
            IF(NBOND.EQ.4) THEN
C
c--Take care of the formal charge.
C
C---sp3 carbon
              L1A_ICHIR(I) = 0
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'CT  '
                L1A_ICHIR(I) = 1
              ELSEIF(N_HATOM.EQ.1) THEN
                 L1A_CHEM(I) = 'CH1 '
                 L1A_ICHIR(I) = 1
              ELSEIF(N_HATOM.EQ.2) THEN
                L1A_CHEM(I) = 'CH2 '
              ELSEIF(N_HATOM.EQ.3) THEN
                L1A_CHEM(I) = 'CH3 '
              ELSEIF(N_HATOM.EQ.4) THEN
C
C--This seems to be wrong. or methane
              ELSEIF(N_HATOM.EQ.4) THEN
                L1A_CHEM(I) = 'CH3 '
              ELSE
                
C
C--Wrong number of hydrogens
              ENDIF
            ELSEIF(NBOND.EQ.3) THEN
C
C--sp2 carbon. In this case chirality will be removed.
C
C--Save for future use
              L1A_ICHIR(I) = -1
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'C   '
              ELSEIF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'C1  '
              ELSEIF(N_HATOM.EQ.2) THEN
                L1A_CHEM(I) = 'C2  '
              ELSE
C
C--Error
                IERR = 1
              ENDIF
            ELSEIF(NBOND.EQ.2) THEN
C
C--sp1 carbon
              L1A_ICHIR(I) = 0
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'CSP '
              ELSEIF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'CSP1'
              ELSE
C
C---Error
                IERR = 1
              ENDIF
            ELSE
C
C---Wrong number of bonds on carbon
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'SI') THEN
C
C---Most SI are tetragonal (according to csd. But there are hexagonal
C---SI also.
            L1A_ICHIR(I) = 1
            IF(NBOND.EQ.4) THEN
              L1A_CHEM(I) = 'SI  '
            ELSE
              L1A_CHEM(I) = 'SI1 '
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'GE') THEN
            L1A_ICHIR(I) = 1
            IF(NBOND.EQ.4) THEN
              L1A_CHEM(I) = 'GE  '
            ELSE
              L1A_CHEM(I) = 'GE1 '
            ENDIF

          ELSE IF(SYMB(1:2).EQ.'SN') THEN
C
c---SN has various forms. 
             L1A_CHEM(I)  = 'SN  '
             L1A_ICHIR(I) = 0

          ELSE IF(SYMB(1:2).EQ.'PB') THEN
C
C--Same problem
             L1A_CHEM(I)  = 'PB  '
             L1A_ICHIR(I) = 0
C
C--Group 5 elements
          ELSE IF(SYMB(1:2).EQ.'N ') THEN
            IF(NBOND.EQ.4) THEN
C
C---Definitely sp3
              L1A_ICHIR(I) = 1
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'NT  '
              ELSE IF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'NT1 '
              ELSE IF(N_HATOM.EQ.2) THEN
                L1A_CHEM(I) = 'NT2 '
                L1A_ICHIR(I) = 0
              ELSE IF(N_HATOM.EQ.3) THEN
                L1A_CHEM(I) = 'NT3 '
                L1A_ICHIR(I) = 0
              ELSE IF(N_HATOM.EQ.4) THEN
C
C--NH4(+1) assign NT
                L1A_CHEM(I) = 'NT  '
                L1A_ICHIR(I) = 0
              ELSE
C
C---Error
              ENDIF
            ELSE IF(NBOND.EQ.3) THEN
C
C---Could be sp2 or sp3. Could be sp3 if bonds are longer.
              IF(L1A_ICHIR(I).EQ.2) THEN
C
C---Too much reliance on coordinates. How to define sp3 N when 
C---there are no coordinates?????
                IF(N_HATOM.EQ.0) THEN
                  L1A_CHEM(I) = 'NT  '
                ELSE IF(N_HATOM.EQ.1) THEN
                  L1A_CHEM(I) = 'NT1 '
                ELSE IF(N_HATOM.EQ.2) THEN
                  L1A_CHEM(I) = 'NT2 '
                ELSE IF(N_HATOM.EQ.3) THEN
C
C---NH3 unlikely. but consider as NT3
                L1A_CHEM(I) = 'NT3 '

                ENDIF

              ELSE
C
C---SP2. Same problem as above
                L1A_ICHIR(I) = -1
                IF(N_HATOM.EQ.0) THEN
                  L1A_CHEM(I) = 'N   '
                ELSE IF(N_HATOM.EQ.1) THEN
                  L1A_CHEM(I) = 'NH1 '
                ELSE IF(N_HATOM.EQ.2) THEN
                  L1A_CHEM(I) = 'NH2 '
                ELSE IF(N_HATOM.EQ.3) THEN
C
C---NH3 unlikely. but consider as N
                  L1A_CHEM(I) = 'N   '
                ELSE
C
C---Error
                ENDIF          
              ENDIF
C
C--sp2 define and save for the future use
            ELSE IF(NBOND.EQ.2) THEN
              L1A_ICHIR(I) = -1
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'N   '
              ELSE IF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'N   '
              ELSE
C
C---Error
              ENDIF
            ELSE IF(NBOND.EQ.1) THEN
C
C---sp1
              L1A_ICHIR(I) = 0
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'NS  '
              ELSE
C
C---Error
              ENDIF
C
C---Error
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'P ') THEN
C
c--Most P are tetragonal
             L1A_ICHIR(I) = 1
             IF(NBOND.EQ.4) THEN
               L1A_CHEM(I) = 'P   '
             ELSE
               L1A_CHEM(I) = 'P1  ' 
             ENDIF
             IF(NBOND.NE.3) L1A_ICHIR(I) = 0
          ELSE IF(SYMB(1:2).EQ.'AS') THEN
C
             L1A_ICHIR(I) = 0
             IF(NBOND.EQ.4) THEN
               L1A_CHEM(I) = 'AS  '
             ELSE
               L1A_CHEM(I) = 'AS1 '
             ENDIF
          ELSE IF(SYMB(1:2).EQ.'SB') THEN
C
C---Very different
             L1A_CHEM(I) = 'SB  '
          ELSE IF(SYMB(1:2).EQ.'BI') THEN
             L1A_CHEM(I) = 'BI  '
C
C---Group 6 elements
             
          ELSE IF(SYMB(1:2).EQ.'O ') THEN
C
C--Here we should check bonded atom and its environment
            IF(NBOND.EQ.2) THEN
              IF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'OH1 '
              ELSEIF(N_HATOM.EQ.0) THEN
                IF(NBOND.EQ.2) THEN
                  L1A_CHEM(I) = 'O2  '
                ELSE
C
C--Go and look bound atom if it has another O change its type also.
                ENDIF
              ENDIF
            ELSE IF(NBOND.EQ.1) THEN
C
c--This case will have to be revisited below.
              L1A_CHEM(I) = 'O   '

           ELSE
C---Error
           ENDIF          
C
C----Error
          ELSE IF(SYMB(1:2).EQ.'S ') THEN
C
C---With I have to do a little bit more. But perhaps later.
            IF(NBOND.EQ.4) THEN
              L1A_CHEM(I) = 'ST  '
            ELSEIF(NBOND.EQ.3) THEN
              L1A_CHEM(I) = 'S3  '
            ELSE IF(NBOND.EQ.2) THEN
              L1A_CHEM(I) = 'S2  '
              IF(N_HATOM.EQ.1) L1A_CHEM(I) = 'SH1 '
            ELSE IF(NBOND.EQ.1) THEN
              L1A_CHEM(I) = 'S1  '
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'SE') THEN
            L1A_CHEM(I) = 'SE  '
            IF(NBOND.EQ.4) L1A_ICHIR(I) = 1
          ELSEIF(SYMB(1:2).EQ.'TE') THEN
            L1A_CHEM(I) = 'TE  '
          ELSEIF(SYMB(1:2).EQ.'PO') THEN
            L1A_CHEM(I) = 'PO  '
     
          ELSEIF(SYMB(1:2).EQ.'B ') THEN
C

            IF(NBOND.EQ.4) THEN

            ENDIF

          ELSEIF(SYMB(1:2).EQ.'H '.OR.SYMB(1:2).EQ.'D ') THEN
C
C---Not more than one bond.
            L1A_CHEM(I) = 'H   '
          ELSE
            L1A_CHEM(I) = SYMB
          ENDIF
        ENDIF

        IF(L1A_CHEM(I).EQ.'.') L1A_CHEM(I) = L1A_SYMB(I)
C       check with table 
        NAME = L1A_CHEM(I)
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              L1A_CHEM(I) = LES_ATYP(J)
              GO TO 140
            ENDIF  
          ENDDO
        ENDIF

        IF(L1A_CHEM(I)(1:1).NE.'H') THEN
          LINE = ' WARNING: '// L1L_MNAME//
     *    ' : unknown chemical_type of atom '//L1A_ANAME(I)//
     *    ' - "'//L1A_CHEM(I) //'"'
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *    '(''                default type is - "'',A4,''"'')')
     *      NAME
          CALL MSGERR(MDOC,LINE)
        ENDIF
        L1A_CHEM(I)  = L1A_SYMB(I)
        NAME         = L1A_CHEM(I)
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              L1A_CHEM(I) = LES_ATYP(J)
              GO TO 140
            ENDIF  
          ENDDO
        ENDIF
  140   CONTINUE

      ENDDO
C
C---Now loop over rings and see if they are flat
C
C--Find number of rings
      NRING_ALL = 0
      DO   I=1,L1A_NATOM
        IF(L1A_NRING(I).GT.0) THEN
          DO   IR=1,L1A_NRING(I)
            IF(NRING_ALL.LT.L1A_RING_ID(IR,I))
     &             NRING_ALL = L1A_RING_ID(IR,I)
          ENDDO
        ENDIF
      ENDDO
      IF(NRING_ALL.GT.0) THEN
        DO   IR=1,NRING_ALL
          IRING_FLAG = 0
          DO  IA=1,L1A_NATOM
            IF(L1A_NRING(IA).GT.0) THEN
C
C--If at least two of the atoms is not sp2 ring is not flat
              DO  IR1=1,L1A_NRING(IA)
                IF(L1A_RING_ID(IR1,IA).EQ.IR) THEN

C --- 23.03.03
                  IF(IS_IT_METAL(L1A_SYMB(IA))) THEN
                    IRING_FLAG = 2
                    GOTO 10  
                  ENDIF
C ---
                  IF(L1A_ICHIR(IA).NE.-1) THEN
                    IRING_FLAG = IRING_FLAG + 1
C A-VA --???        GOTO 10
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 10       CONTINUE
C
C---If IRING_FLAG > 1 then ring is not flat. go and correct all ring id
          DO   IA=1,L1A_NATOM
            IF(L1A_NRING(IA).GT.0) THEN
              DO  IR1=1,L1A_NRING(IA)
              IF(L1A_RING_ID(IR1,IA).EQ.IR) THEN
                IF(IRING_FLAG.EQ.0) THEN
                  L1A_RING_FLAT(IR1,IA) = 1
                ELSE IF(IRING_FLAG.EQ.1) THEN
C A-VA ????       L1A_RING_FLAT(IR1,IA) = 2
                  L1A_RING_FLAT(IR1,IA) = 1
                ELSE
                  L1A_RING_FLAT(IR1,IA) = 0
                ENDIF
              ENDIF
              ENDDO
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C
C--Now go through atoms and define their atomic types using 
C--ring info also.
      DO   I=1,L1A_NATOM
C
C---Can be flat ring if atom is sp2.
          IF(L1A_ICHIR(I).EQ.-1) THEN
            IF(L1A_NRING(I).GT.0) THEN
              IRING_THIS = 0
              CHEM = L1A_CHEM(I)
              DO   IR=1,L1A_NRING(I)
                IRING_FLAT1 = L1A_RING_FLAT(IR,I)
                IF(L1A_RING_FLAT(IR,I).EQ.1) THEN
                  IF(L1A_RING_ORD(IR,I).EQ.5) THEN
C
c--Only N and C are considered. How about S?
                     IF(CHEM.EQ.'C   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'CR55'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'CR56'
                       ELSE
                         L1A_CHEM(I) = 'CR5 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'C1  ') THEN
                       L1A_CHEM(I) = 'CR15'
                     ELSE IF(CHEM.EQ.'C2  ') THEN
C
C---Impossible
                     ELSE IF(CHEM.EQ.'N   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'NR55'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'NR56'
                       ELSE
                         L1A_CHEM(I) = 'NRD5'
                         IF(L1A_NDIST(I).EQ.3) L1A_CHEM(I) = 'NR5 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'NH1 ') THEN
                       L1A_CHEM(I) = 'NR15'
                     ELSE IF(CHEM.EQ.'NH2 ') THEN
C
C---Impossible
                     ENDIF
                     IRING_THIS = 5
                  ELSEIF(L1A_RING_ORD(IR,I).EQ.6) THEN
C
c--Only N and C are considered. How about S?
                     IF(CHEM.EQ.'C   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'CR56'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'CR66'
                       ELSE
                         L1A_CHEM(I) = 'CR6 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'C1  ') THEN
                       L1A_CHEM(I) = 'CR16'
                     ELSE IF(CHEM.EQ.'C2  ') THEN
C
C---Impossible
                     ELSE IF(CHEM.EQ.'N   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'NR56'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'NR66'
                       ELSE
                         L1A_CHEM(I) = 'NRD6'
                         IF(L1A_NDIST(I).EQ.3) L1A_CHEM(I) = 'NR6 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'NH1 ') THEN
                       L1A_CHEM(I) = 'NR16'
                     ELSE IF(CHEM.EQ.'NH2 ') THEN
C
C---Impossible
                     ENDIF
                     IRING_THIS = 6
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDIF
C
C---Now correct for N
        IF(L1A_SYMB(I)(1:2).EQ.'N ') THEN
          IF(L1A_NDIST(I).EQ.2.OR.L1A_NDIST(I).EQ.1) THEN
            DO   IB=1,L1A_NDIST(I)
              IA3 = L1A_CONN(IB,I)
              IF(IA3.LT.0) IA3 = -IA3
              IF(IA3.GT.0) THEN
                CALL SRCH_BOND(MDOC,L1L_MNAME,I,IA3,VAL,LB,IERR)
                IF(L1B_TYPE(LB)(1:3).EQ.'tri')  L1A_CHEM(I) = 'NS  '
              ENDIF
            ENDDO
          ENDIF
        ENDIF
C
C--Now correct for oxygens.
        IF(L1A_SYMB(I)(1:2).EQ.'C '.AND.L1A_ICHIR(I).EQ.-1) THEN
          IOXIG  = 0
          DO   IB=1,L1A_NDIST(I)
            IA3 = L1A_CONN(IB,I)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.GT.0) THEN
              IF(L1A_SYMB(IA3).EQ.'O '.AND.L1A_NDIST(IA3).EQ.1) THEN
                IOXIG = IOXIG + 1
                IA_OX(IOXIG) = IA3
              ENDIF
            ENDIF
          ENDDO
          IF(IOXIG.EQ.2) THEN
            L1A_CHEM(IA_OX(1)) = 'OC  '
            L1A_CHEM(IA_OX(2)) = 'OC  '
          ENDIF
        ELSEIF(L1A_SYMB(I)(1:2).EQ.'S ') THEN
          IOXIG  = 0
          DO   IB=1,L1A_NDIST(I)
            IA3 = L1A_CONN(IB,I)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.GT.0) THEN
              IF(L1A_SYMB(IA3).EQ.'O '.AND.L1A_NDIST(IA3).EQ.1) THEN
                IOXIG = IOXIG + 1
                IA_OX(IOXIG) = IA3
              ENDIF
            ENDIF
          ENDDO
          IF(IOXIG.GE.2) THEN
            DO J=1,IOXIG
              L1A_CHEM(IA_OX(J)) = 'OS  '
            ENDDO
          ENDIF
        ELSEIF(L1A_SYMB(I)(1:2).EQ.'P ') THEN
          IOXIG  = 0
          DO   IB=1,L1A_NDIST(I) 
            IA3 = L1A_CONN(IB,I)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.GT.0) THEN
              IF(L1A_SYMB(IA3).EQ.'O '.AND.L1A_NDIST(IA3).EQ.1) THEN
                IOXIG = IOXIG + 1
                IA_OX(IOXIG) = IA3
              ENDIF
            ENDIF
          ENDDO
          IF(IOXIG.GE.2) THEN
            DO J=1,IOXIG
              L1A_CHEM(IA_OX(J)) = 'OP  '
            ENDDO
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END

C --- Garib ---

      SUBROUTINE CHECK_CHIR(MDOC,LIST,ITYPE_RES,IERR)
C -------------------------------------------------
C     CHIRALITY OR PLAN
C
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      INTEGER*4 IJA(3),IJHA(3),NNH,NHA,I,J,IJ,NA,IC,I1,I2,I3,NCOMM
      CHARACTER LINE*256,SYMB*4,CH2*2
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ----------------------------------------------------
      IERR =  0
C ----------------
      NA     = L1A_NATOM

      IF(NA.GT.3) THEN

        CALL REMOVE_USER_CHIR_CENTRE(MDOC,LIST,IERR)

        DO   I=1,NA
          IF(L1A_NDIST(I).GE.2.AND.L1A_ATYPE(I).NE.'H') THEN
            IF(IS_IT_METAL(L1A_SYMB(I))) GO TO 600
            NNH=0
            NHA=0
            DO IJ=1,3
              IJA (IJ) = 0
              IJHA(IJ) = 0
            ENDDO
            DO J=1,L1A_NDIST(I)
              IJ = ABS(L1A_CONN(J,I))
              IF(L1A_ATYPE(IJ).NE.'H') THEN
                NNH = NNH + 1
                IF(NNH.LE.3) IJA(NNH) = IJ
              ELSE
                NHA = NHA + 1
                IF(NHA.LE.3) IJHA(NHA) = IJ
              ENDIF
            ENDDO 

            IF(L1A_ICHIR(I).LT.0.AND.NNH.LE.2.AND.NNH.GT.0) THEN
              IF(NHA.GT.0) THEN
                NNH      = NNH + 1
                IJA(NNH) = IJHA(1)
                IF(NHA.GT.1.AND.NNH.LT.3) THEN
                  NNH      = NNH + 1
                  IJA(NNH) = IJHA(2)
                ENDIF
              ENDIF
            ENDIF
 
            I1 = IJA(1)
            I2 = IJA(2)
            I3 = IJA(3)

            IF(LIST.EQ.'T') THEN
              WRITE(line,'(A,I5,A,5I5)') 
     *        'cc:',I,L1A_ANAME(I),L1A_ICHIR(I),NNH,I1,I2,I3
              call msgdoc(mdoc,line)
            ENDIF

            IF(L1A_ICHIR(I).LT.0.AND.NNH.GE.2) THEN
C               planar groups
                IF(L1P_NPLAN.GT.0) THEN
                  DO IP=1,L1P_NPLAN
                    NAP   = L1P_NATOM(IP)
                    NCOMM = 0
                    DO IAP=1,NAP
                      ICH4 = L1P_ATOM(IAP,IP) 
                      IF(CH4.EQ.L1A_ANAME( I).OR.
     *                   CH4.EQ.L1A_ANAME(I1).OR.
     *                   CH4.EQ.L1A_ANAME(I2)    ) THEN
                        NCOMM = NCOMM + 1
                      ELSE IF(I3.GT.0) THEN 
                        IF(CH4.EQ.L1A_ANAME(I3)) NCOMM = NCOMM + 1
                      ENDIF     
                    ENDDO
                    IF(NCOMM.GE.3) GO TO 600
C                   IF(NCOMM.GE.4) GO TO 600
                  ENDDO
                ENDIF

                IF(L1P_NPLAN.GE.MAX1PLN) THEN
                  WRITE(LINE,
     *'(''ERROR: number of plan groups in new monomer '',A,'' >'',I6)'
     *) L1L_MNAME,MAX1PLN
                  CALL MSGERR(MDOC,LINE)
                  CALL MSGERR(MDOC,
     *  '          Change parameter MAX1PLN in "lib_com.fh"')
                  IERR=1
                  RETURN
                ENDIF

                IF(I1.GT.0.AND.I2.GT.0) THEN
                  L1P_NPLAN              = L1P_NPLAN + 1
                  L1A_ICHEM(I)           = L1P_NPLAN              
                  L1P_NATOM(L1P_NPLAN)   = 3
                  L1P_IATOM(1,L1P_NPLAN) = I
                  CH4                    = L1A_ANAME(I)
                  L1P_ATOM (1,L1P_NPLAN) = ICH4
                  L1P_IATOM(2,L1P_NPLAN) = I1
                  CH4                    = L1A_ANAME(I1)
                  L1P_ATOM (2,L1P_NPLAN) = ICH4
                  L1P_IATOM(3,L1P_NPLAN) = I2
                  CH4                    = L1A_ANAME(I2)
                  L1P_ATOM (3,L1P_NPLAN) = ICH4
                  IF(I3.GT.0) THEN
                    L1P_NATOM(L1P_NPLAN)   = 4
                    L1P_IATOM(4,L1P_NPLAN) = I3
                    CH4                    = L1A_ANAME(I3)
                    L1P_ATOM (4,L1P_NPLAN) = ICH4
                  ELSE
                    L1P_IATOM(4,L1P_NPLAN) = 0
                    L1P_ATOM (4,L1P_NPLAN) = 0
                  ENDIF
                  WRITE(CH2,'(I2)') L1P_NPLAN              
                  IF(CH2(1:1).EQ.' ') THEN
                    L1P_LABEL(L1P_NPLAN)='plan-'//CH2(2:2)
                  ELSE
                    L1P_LABEL(L1P_NPLAN)='plan-'//CH2
                  ENDIF

                  L1P_DOBS(1,L1P_NPLAN) = 0.0
                  L1P_DEV (1,L1P_NPLAN) = 0.02
                ENDIF

            ELSE IF(L1A_ICHIR(I).GT.0.AND.NNH.GE.3) THEN
C               chiral centres 

                IF(NNH.GE.3) THEN
                  IF(L1C_NCHIR.GT.0) THEN
                    DO IC=1,L1C_NCHIR
                      IF(L1C_1ATM(IC).EQ.L1A_ANAME(I)) GO TO 600 
                    ENDDO
                  ENDIF
                  IF(L1C_NCHIR.GE.MAX1CHR) THEN
                    WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) L1L_MNAME,MAX1CHR
                    CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
                    IERR=1
                    RETURN
                  ENDIF
                  CALL SRCH_CHIR_CENTRE(MDOC,L1L_MNAME,I,LC,IERR)
                  IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.LC.LE.0) THEN
                    L1C_NCHIR   = L1C_NCHIR + 1
                    L1A_ICHEM(I)= - L1C_NCHIR         
                    L1C_I1ATM(L1C_NCHIR) = I
                    L1C_1ATM (L1C_NCHIR) = L1A_ANAME(I)
                    L1C_I2ATM(L1C_NCHIR) = I1
                    L1C_2ATM (L1C_NCHIR) = L1A_ANAME(I1)
                    L1C_I3ATM(L1C_NCHIR) = I2
                    L1C_3ATM (L1C_NCHIR) = L1A_ANAME(I2)
                    L1C_I4ATM(L1C_NCHIR) = I3
                    L1C_4ATM (L1C_NCHIR) = L1A_ANAME(I3)
                    L1C_I5ATM(L1C_NCHIR) = 0
                    L1C_5ATM (L1C_NCHIR) = '.'
                    L1C_I6ATM(L1C_NCHIR) = 0
                    L1C_6ATM (L1C_NCHIR) = '.'
                    L1C_I7ATM(L1C_NCHIR) = 0
                    L1C_7ATM (L1C_NCHIR) = '.'
                    L1C_I8ATM(L1C_NCHIR) = 0
                    L1C_8ATM (L1C_NCHIR) = '.'
                    L1C_I9ATM(L1C_NCHIR) = 0
                    L1C_9ATM (L1C_NCHIR) = '.'
                    L1C_VOL  (L1C_NCHIR) = 0.0
                    L1C_VOBS (L1C_NCHIR) = 0.0

c                   IF(L1L_PRSNT.EQ.'N'.AND.
                    IF(L1A_COOR_FLAG(I ).EQ.'Y'.AND.
     *                 L1A_COOR_FLAG(I1).EQ.'Y'.AND. 
     *                 L1A_COOR_FLAG(I2).EQ.'Y'.AND. 
     *                 L1A_COOR_FLAG(I3).EQ.'Y'     ) THEN
                      X1 = L1A_X(I)
                      Y1 = L1A_Y(I)
                      Z1 = L1A_Z(I)
                      X2 = L1A_X(I1)
                      Y2 = L1A_Y(I1)
                      Z2 = L1A_Z(I1)
                      X3 = L1A_X(I2)
                      Y3 = L1A_Y(I2)
                      Z3 = L1A_Z(I2)
                      X4 = L1A_X(I3)
                      Y4 = L1A_Y(I3)
                      Z4 = L1A_Z(I3)
                      A1 = X2-X1
                      A4 = Y2-Y1
                      A7 = Z2-Z1
                      A2 = X3-X1
                      A5 = Y3-Y1
                      A8 = Z3-Z1
                      A3 = X4-X1
                      A6 = Y4-Y1
                      A9 = Z4-Z1
                      VOL = A1*(A5*A9 - A8*A6)
     *                     -A4*(A2*A9 - A8*A3)
     *                     +A7*(A2*A6 - A5*A3)
                      IF(VOL.LT.0.0) THEN
                        L1C_SIGN(L1C_NCHIR) = 'negativ'
                        L1C_FLAG(L1C_NCHIR) = 'L'
                      ELSE
                        L1C_SIGN(L1C_NCHIR) = 'positiv'
                        L1C_FLAG(L1C_NCHIR) = 'R'
                      ENDIF
                    ELSE 
                      L1C_SIGN(L1C_NCHIR) = 'both   '
                      L1C_FLAG(L1C_NCHIR) = 'B'
                      IF(L1C_1ATM(L1C_NCHIR).EQ.'CA  '.AND.
     *                  (ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4)) THEN
                        CALL PEPTIDE_CHIR_CORR(MDOC,LIST,ITYPE_RES,
     *                  L1C_2ATM(L1C_NCHIR),L1C_3ATM(L1C_NCHIR),
     *                  L1C_4ATM(L1C_NCHIR),L1C_SIGN(L1C_NCHIR),
     *                  L1C_FLAG(L1C_NCHIR),IERR)
                      ENDIF
                    ENDIF
                  ENDIF
                ENDIF

            ENDIF

 600        CONTINUE

          ENDIF
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE PEPTIDE_CHIR_CORR(MDOC,LIST,ITYPE_RES,
     *       ATOM1,ATOM2,ATOM3,SIGN,FLAG,IERR)
C -----------------------------------------
      INTEGER   MDOC,IERR,ITYPE_RES
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,SIGN*8,FLAG*1
      CHARACTER LINE*256,LIST*1
C -----------------------------------------
C     CA --> N  CB  C  neg L-pept
      IT = 0
      IF(ATOM1.EQ.'N   ') THEN
        IF(ATOM2.EQ.'C   ') THEN
          IF(ATOM3.EQ.'CB  ') IT =-1
        ELSE IF(ATOM2.EQ.'CB  ') THEN
          IF(ATOM3.EQ.'C   ') IT = 1
        ENDIF
      ELSE IF(ATOM1.EQ.'C   ') THEN
        IF(ATOM2.EQ.'CB  ') THEN
          IF(ATOM3.EQ.'N   ') IT =-1
        ELSE IF(ATOM2.EQ.'N   ') THEN
          IF(ATOM3.EQ.'CB  ') IT = 1
        ENDIF
      ELSE IF(ATOM1.EQ.'CB  ') THEN
        IF(ATOM2.EQ.'N   ') THEN
          IF(ATOM3.EQ.'C   ') IT =-1
        ELSE IF(ATOM2.EQ.'C   ') THEN
          IF(ATOM3.EQ.'N   ') IT = 1
        ENDIF
      ENDIF
      
      IF(IT.EQ.0) RETURN
      IF(ITYPE_RES.EQ.3) IT =-IT

      IF(IT.LT.0) THEN
        SIGN = 'negativ'
        FLAG = 'L'
      ELSE
        SIGN = 'positiv'
        FLAG = 'R'
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_PLAN(MDOC,NRING,LIST,IERR)
C -----------------------------------------
C -P- CHECK_PLAN -
C -S-
C -----------------------------------------
      INTEGER   MDOC,IERR,NRING
C ---
      INCLUDE 'lib_com.fh'
C ******
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
      CHARACTER LINE*256,LIST*1
      INTEGER   NA,IP,IAP,I,J,IA,NP,N,NCONN,ICONN,JCONN,JA,IFLAT,JFLAT
      INTEGER*4 ICH4,IAC,KI,NAI,KJ,NAJ,IR,IFLAT_SAME,IB,LB
      CHARACTER CH2*2,CH4*4,SYMB*4,BTYPE*8
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------------
C     L1A_ICHIR() : > 0 chir, < 0 flat, 0 non-flat
C
      NA = L1A_NATOM

C --- define l1a_icr() - number of flat ring 
      DO IA=1,NA
        L1A_ICR(IA) = 0
      ENDDO
      IF(NRING.GT.0) THEN      
        DO J=1,NRING
          DO IA=1,NA
            IF(L1A_NRING(IA).GT.0) THEN
              DO IR=1,L1A_NRING(IA)
                IF(L1A_RING_ID  (IR,IA).EQ.J.AND.
     *             L1A_RING_FLAT(IR,IA).GT.0     ) THEN
                  L1A_ICR(IA) = J
                ENDIF
              ENDDO
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ---

      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
         call msgdoc(mdoc,'ip,iap,icr,ichir(<0 flat,>0 chir')
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)              
               WRITE(line,'(A,4I5,A)') 
     *        'plan-;',ip,iap,L1A_ICR(j),L1A_ICHIR(j),l1a_aname(j)
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF


      IF(L1P_NPLAN.GT.0.AND.NRING.GT.0) THEN
        DO I=1,L1P_NPLAN

          DO J=1,NRING

            NP = 0
            DO IA=1,NA
              IF(L1A_ICR(IA).EQ.J) THEN
                DO IP=1,L1P_NATOM(I)
                  IF(L1P_IATOM(IP,I).EQ.IA) THEN
                    NP = NP+1
                  ENDIF
                ENDDO  
              ENDIF
            ENDDO
C
C           NP -number of atoms (from i-plan) in j-ring(flat)            
C
C          

c           IF(NP.GT.2) THEN
            IF(NP.GE.2) THEN
              DO IA=1,NA
                IF(L1A_ICR(IA).EQ.J.AND.L1A_ICR(IA).NE.0) THEN
                  IF(L1P_IATOM(1,I).NE.IA.AND.
     *               L1P_IATOM(2,I).NE.IA.AND.
     *               L1P_IATOM(3,I).NE.IA.AND.
     *               L1P_IATOM(4,I).NE.IA     ) THEN
                    IF(L1P_NATOM(I).GE.MAX1APL) THEN
                      WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *                ,L1L_MNAME,' >',MAX1APL
                      CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                      IERR=1
                      RETURN
                    ENDIF
                
C                    IF(L1A_SYMB(IA).NE.'FE  ') THEN
c                    IF(IS_IT_METAL(L1A_SYMB(IA))) THEN

                    L1P_NATOM(I)              = L1P_NATOM(I) + 1
                    L1P_IATOM(L1P_NATOM(I),I) = IA
                    CH4                       = L1A_ANAME(IA)
                    L1P_ATOM (L1P_NATOM(I),I) = ICH4
                    L1P_DOBS (L1P_NATOM(I),I) = 0.0
                    L1P_DEV  (L1P_NATOM(I),I) = 0.02
                    
C                    ENDIF

                  ENDIF
                  L1A_ICR(IA) = 0
                ENDIF
              ENDDO
            ENDIF
  
          ENDDO
        ENDDO
      ENDIF

      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)
              WRITE(line,*) 'plan=;',ip,iap,L1A_ICR(j),l1a_aname(j)
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF



      IF(NRING.GT.0) THEN
        DO J=1,NRING
          IFIRST = 0
          DO IA=1,NA
C///
            L1A_ICR(IA) = 0
            IF(L1A_NRING(IA).GT.0) THEN
              DO IR=1,L1A_NRING(IA)
                IF(L1A_RING_ID  (IR,IA).EQ.J.AND.
     *             L1A_RING_FLAT(IR,IA).GT.0     ) THEN
                  L1A_ICR(IA) = J
                ENDIF
              ENDDO
            ENDIF
C///
            IF(L1A_ICR(IA).EQ.J) THEN
              IF(IFIRST.EQ.0) THEN
                IF(L1P_NPLAN.GE.MAX1PLN) THEN
                  WRITE(LINE,'(3A,I6)')
     *         ' ERROR: number of planar groups in new monomer'
     *            ,L1L_MNAME,' >',MAX1PLN
                  CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1PLN in "lib_com.fh"')
                  IERR=1
                  RETURN
                ENDIF
                L1P_NPLAN            = L1P_NPLAN + 1
                L1P_NATOM(L1P_NPLAN) = 0
                WRITE(CH2,'(I2)') L1P_NPLAN              
                IF(CH2(1:1).EQ.' ') THEN
                  L1P_LABEL(L1P_NPLAN) = 'plan-'//CH2(2:2)
                ELSE
                  L1P_LABEL(L1P_NPLAN) = 'plan-'//CH2
                ENDIF
                IFIRST = 1
              ENDIF

              IF(L1P_NATOM(L1P_NPLAN).GE.MAX1APL) THEN
                WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *            ,L1L_MNAME,' >',MAX1APL
                CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                IERR=1
                RETURN
              ENDIF

C              IF(L1A_SYMB(IA).NE.'FE  '.AND.L1A_SYMB(IA).NE.'H   '
C     *                       .AND.L1A_SYMB(IA).NE.'D   ') THEN
              IF(L1A_SYMB(IA).NE.'H   '.AND.L1A_SYMB(IA).NE.'D   ') THEN
               
                IF(L1P_NATOM(L1P_NPLAN).GT.0) THEN
                  DO JAP=1,L1P_NATOM(L1P_NPLAN)
                    JA = L1P_IATOM(JAP,L1P_NPLAN)
                    IF(JA.EQ.IA) GO TO 300
                  ENDDO
                ENDIF

                L1P_NATOM(L1P_NPLAN)     = L1P_NATOM(L1P_NPLAN) + 1
                IAP                      = L1P_NATOM(L1P_NPLAN)
                L1P_IATOM(IAP,L1P_NPLAN) = IA
                CH4                      = L1A_ANAME(IA)
                L1P_ATOM (IAP,L1P_NPLAN) = ICH4
                L1P_DOBS(IAP,L1P_NPLAN)  = 0.0
                L1P_DEV (IAP,L1P_NPLAN)  = 0.02

 300            CONTINUE

                L1A_ICR(IA)             = 0

C                IF(L1A_NDIST(IA).EQ.3.OR.
C     *                (L1A_NDIST(IA).EQ.2.AND.L1A_ICHIR(IA).LT.0)) THEN
                IF(L1A_NDIST(IA).EQ.3.OR.
     *                (L1A_NDIST(IA).EQ.2.AND.L1A_ICR(IA).GT.0)) THEN

                  DO ID=1,L1A_NDIST(IA)
                    I = ABS(L1A_CONN(ID,IA)) 
C                    IF(L1A_ICR(I).LE.0.AND.I.GT.0.AND.
C     *                 L1A_SYMB(I).NE.'FE  '.AND.L1A_SYMB(I).NE.'H   '
C     *                       .AND.L1A_SYMB(I).NE.'D   ') THEN
                    IF(I.GT.0) THEN
                    IF(L1A_ICR (I).LE.0     .AND.
     *                 L1A_SYMB(I).NE.'H   '.AND.
     *                 L1A_SYMB(I).NE.'D   '     ) THEN

                      IF(L1P_NATOM(L1P_NPLAN).GT.0) THEN
                        DO JAP=1,L1P_NATOM(L1P_NPLAN)
                          JA = L1P_IATOM(JAP,L1P_NPLAN)
                          IF(JA.EQ.IA) GO TO 200
                        ENDDO
                      ENDIF

                      L1P_NATOM(L1P_NPLAN)    = L1P_NATOM(L1P_NPLAN)+1
                      IAP                     = L1P_NATOM(L1P_NPLAN)
                      L1P_IATOM(IAP,L1P_NPLAN)= I
                      CH4                     = L1A_ANAME(I)
                      L1P_ATOM (IAP,L1P_NPLAN)= ICH4
                      L1P_DOBS(IAP,L1P_NPLAN) = 0.0
                      L1P_DEV (IAP,L1P_NPLAN) = 0.02

 200                  CONTINUE
                      
                    ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF
              
            ENDIF
          ENDDO
        ENDDO
      ENDIF

C --- define l1a_icr() - number of flat ring 

      DO IA=1,NA
        L1A_ICR(IA) = 0
      ENDDO
      IF(NRING.GT.0) THEN      
        DO J=1,NRING
          DO IA=1,NA
            IF(L1A_NRING(IA).GT.0) THEN
              DO IR=1,L1A_NRING(IA)
                IF(L1A_RING_ID  (IR,IA).EQ.J.AND.
     *             L1A_RING_FLAT(IR,IA).GT.0     ) THEN
                  L1A_ICR(IA) = J
                ENDIF
              ENDDO
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ---
      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)
              WRITE(line,*) 'plan==;',ip,iap,L1A_ICR(j),l1a_aname(j)
     *                       ,L1P_DOBS(iap,ip)
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF
C ---
      IF(L1P_NPLAN.GT.1) THEN
        NP = L1P_NPLAN
        DO I=1,NP-1
          NAI = L1P_NATOM(I)
          IF(NAI.GT.0) THEN
            DO J=I+1,NP
              NAJ = L1P_NATOM(J)

              IF(NAJ.GT.0) THEN
                N     = 0
                ICONN = 0
                JCONN = 0
                DO KJ=1,NAJ
                  JA   = L1P_IATOM(KJ,J)
                  DO KI=1,NAI
                    IA   = L1P_IATOM(KI,I)

                    IF(L1P_ATOM(KJ,J).EQ.L1P_ATOM(KI,I)) THEN
                      L1P_DOBS(KJ,J)   =-1.0
                      N                = N + 1
                      IF(N.EQ.1) ICONN = JA
                      IF(N.EQ.2) JCONN = JA
                    ENDIF

                  ENDDO
                ENDDO

                IF(LIST.EQ.'T') THEN
                  WRITE(line,'(A,3I5)') 
     *            '---i,j,n;',i,j,n
                  call msgdoc(mdoc,line)
                ENDIF

                IF(N.GE.3) THEN
                  N = 3
                ELSE IF(N.EQ.2) THEN

C                  IFLAT  = 0  
c                  IF(L1A_ICHIR(ICONN).LT.0) IFLAT = 1
C                  IF(L1A_ICR(ICONN).GT.0) IFLAT = 1
C                  JFLAT  = 0  
c                  IF(L1A_ICHIR(JCONN).LT.0) JFLAT = 1
C                  IF(L1A_ICR(JCONN).GT.0) JFLAT = 1

                  CALL CHECK_PLAN_CONNECTION(LIST,ICONN,JCONN,IFLAT)

                  N = 0

                  CALL SRCH_BOND(MDOC,L1L_MNAME,ICONN,JCONN,VAL,LB,IERR)
                  KERR = IERR
                  IF(IERR.EQ.0.AND.LB.GT.0) THEN                
                    BTYPE = L1B_TYPE(LB)
                    IF(BTYPE(1:4).EQ.'sing'.OR.BTYPE(1:4).EQ.'cova'.OR.
     *                 BTYPE(1:1).EQ.'.') THEN
                      IB = 1

                      IF(IFLAT.GT.0) IB = 2 
                      
                    ELSE
                      IB = 2

                      IF(IFLAT.LT.0) IB = 1 

                    ENDIF
                  ELSE
                    IERR = 0
                    IB   = 1
                  ENDIF
                  IF(IB.GE.2) N = 3

                  IF(LIST.EQ.'T') THEN
                    WRITE(line,'(A,2I5,a,a,4i5)') 
     *              '---ia,ja,n,ib;',ICONN,JCONN,
     *              L1A_ANAME(Iconn),L1A_ANAME(jconn),N,IB,IFLAT,KERR
                    call msgdoc(mdoc,line)
                  ENDIF

                ENDIF

                IF(N.GE.3) THEN
                  DO KJ=1,NAJ
                    IF(L1P_DOBS(KJ,J).GE.0.0) THEN
                      NAI = NAI+1
                      IF(NAI.GT.MAX1APL) THEN
                        WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *            ,L1L_MNAME,' >',MAX1APL
                        CALL MSGERR(MDOC,LINE)
                        CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                        IERR=1
                        RETURN
                      ENDIF
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_DOBS (NAI,I) = L1P_DOBS (KJ,J)
                      L1P_IATOM(NAI,I) = L1P_IATOM(KJ,J)
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_NATOM(I)     = NAI
                    ENDIF
                  ENDDO
                  L1P_NATOM(J) = 0
                ELSE
                  DO KJ=1,NAJ
                    L1P_DOBS(KJ,J) = 0.0
                  ENDDO
                ENDIF
              ENDIF

            ENDDO
          ENDIF
        ENDDO

        IF(LIST.EQ.'T') THEN
        IF(L1P_NPLAN.GT.0) THEN
          DO IP=1,L1P_NPLAN
            NAP = L1P_NATOM(IP)
            IF(NAP.GT.0) THEN
              DO IAP=1,NAP
                j=L1P_IATOM(IAP,IP)
                WRITE(line,*) 'plan...;',ip,iap,l1a_aname(j)
     *                       ,L1P_DOBS(iap,ip)
                call msgdoc(mdoc,line)
              ENDDO
            ENDIF
          ENDDO
        ENDIF
        ENDIF
C ---
        NP = L1P_NPLAN
        DO I=1,NP-1
          NAI = L1P_NATOM(I)
          IF(NAI.GT.0) THEN
            DO J=I+1,NP
              NAJ = L1P_NATOM(J)
              IF(NAJ.GT.0) THEN
                N     = 0
                DO KJ=1,NAJ
                  JA   = L1P_IATOM(KJ,J)
                  DO KI=1,NAI
                    IA   = L1P_IATOM(KI,I)
                    IF(L1P_ATOM(KJ,J).EQ.L1P_ATOM(KI,I)) THEN
                      L1P_DOBS(KJ,J)   =-1.0
                      N                = N + 1
                    ENDIF
                  ENDDO
                ENDDO

                IF(LIST.EQ.'T') THEN
                  WRITE(line,'(A,3I5)') 
     *            '-=-i,j,n;',i,j,n
                  call msgdoc(mdoc,line)
                ENDIF

                IF(N.GE.3) THEN
                  DO KJ=1,NAJ
                    IF(L1P_DOBS(KJ,J).GE.0.0) THEN
                      NAI = NAI+1
                      IF(NAI.GT.MAX1APL) THEN
                        WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *            ,L1L_MNAME,' >',MAX1APL
                        CALL MSGERR(MDOC,LINE)
                        CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                        IERR=1
                        RETURN
                      ENDIF
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_DOBS (NAI,I) = L1P_DOBS (KJ,J)
                      L1P_IATOM(NAI,I) = L1P_IATOM(KJ,J)
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_NATOM(I)     = NAI
                    ENDIF
                  ENDDO
                  L1P_NATOM(J) = 0
                ELSE
                  DO KJ=1,NAJ
                    L1P_DOBS(KJ,J) = 0.0
                  ENDDO
                ENDIF
              ENDIF

            ENDDO
          ENDIF
        ENDDO

C ---
        II = 0
        DO I=1,NP
          IF(L1P_NATOM(I).GT.0) THEN
            II            = II + 1
            L1P_NATOM(II) = L1P_NATOM(I)
C           L1P_LABEL(II) = L1P_LABEL(I)
            WRITE(CH2,'(I2)') II              
            IF(CH2(1:1).EQ.' ') THEN
              L1P_LABEL(II) = 'plan-'//CH2(2:2)
            ELSE
              L1P_LABEL(II) = 'plan-'//CH2
            ENDIF
            DO IA=1,L1P_NATOM(I)
              L1P_ATOM (IA,II) = L1P_ATOM (IA,I)
              L1P_DOBS (IA,II) = L1P_DOBS (IA,I)
              L1P_IATOM(IA,II) = L1P_IATOM(IA,I)
              L1P_ATOM (IA,II) = L1P_ATOM (IA,I)
              L1P_DEV  (IA,II) = 0.02
            ENDDO
          ENDIF
        ENDDO
        L1P_NPLAN=II
      ENDIF

      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)
              WRITE(line,*) 'plan===;',ip,iap,l1a_aname(j)     
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_PLAN_CONNECTION(LIST,IA,JA,IFLAT)
C -----------------------------------------------------
      INTEGER*4 IA,JA
      CHARACTER LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---
C -------------------------------
      IFLAT = 0
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '-- CHECK_PLAN_CONNECTION--'
        WRITE(*,*) IA,JA,L1A_NRING(IA),L1A_NRING(JA)
      ENDIF

C     is atoms: Ia,Ja in the same ring ?

      IF(L1A_NRING(IA).GT.0.AND.L1A_NRING(JA).GT.0) THEN


        DO I=1,L1A_NRING(IA)
          ID = L1A_RING_ID(I,IA)
          DO J=1,L1A_NRING(JA)
            JD = L1A_RING_ID(J,JA)
            IF(ID.EQ.JD) THEN
              IF(L1A_RING_FLAT(I,IA).GT.0) IFLAT = 1
              IF(IFLAT.EQ.0) IFLAT = -1
            ENDIF
          ENDDO
        ENDDO

      ENDIF

      RETURN
      END

      SUBROUTINE RING(MDOC,LIST,NRINGT,IPRSNT,IERR)
C -----------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER LINE*256,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER NDIST(MAX1ATM) 
      INTEGER IRING(MX1ATOM)
      INTEGER CONN (MAX1BRN,MAX1ATM) 
      INTEGER ICHEM(MAX1ATM)
C -------------------------------
C     IPRSNT = 1 for make_new
C     make_new: L1A_ICHEM() : > 0 plan , < 0 chir
C --------------------------------
      IERR = 0
C --
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        write(line,*) ' --- ring ---'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a4,1x,i4,'';'',6i3,'';'',7i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Ichir(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_ICHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      NA     = L1A_NATOM
      NRINGT = 0
      DO I=1,NA
        ICHEM(I) = 0 
        L1A_NRING(I) = 0
        NDIST(I) = L1A_NDIST(I)
        IF(NDIST(I).GT.0) THEN
          DO J=1,NDIST(I)
            CONN(J,I) = L1A_CONN(J,I)
          ENDDO
        ENDIF
        IF(IPRSNT.EQ.0) THEN
          IF(L1A_NEXTR(I).GT.0) THEN
            DO J=1,L1A_NEXTR(I)
              K = L1A_IEXTR(J,I)
              IF(K.GT.0) THEN
                NDIST(I) = NDIST(I) + 1
                CONN(NDIST(I),I) = K
              ENDIF
            ENDDO
          ENDIF         
          IF(L1A_IBACK(I).GT.0) THEN
            NDIST(I) = NDIST(I) + 1
            CONN(NDIST(I),I) = L1A_IBACK(I)
          ENDIF 
        ELSE
          IF(L1A_ICHIR(I).GT.0.OR.L1A_ATYPE(I).EQ.'P'.OR.
     *    L1A_ATYPE(I).EQ.'P') ICHEM(I)=-1
        ENDIF     
        DO J=1,MAX1BRN
          L1A_RING_ID  (J,I) = 0
          L1A_RING_ORD (J,I) = 0
          L1A_RING_FLAT(J,I) = 0
        ENDDO
      ENDDO
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,'---------')
        DO    IA=1,NA
          write(line,
     * '(''=ia:'',i3,A,'' Ndist:'',i4,'' ;'',12i3,'';'')') 
     *    ia,l1a_aname(ia),NDIST(IA),(conn(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        CALL MSGDOC(MDOC,'---------')
      ENDIF

C -------------------

      IF(NA.GE.4) THEN
        DO I=1,NA
          IRING(1) = I
          NDI = NDIST(I)
          IF(NDI.LE.0) GO TO 100

          JP = I
c         IF(L1A_NRING(I).NE.0) JP = 0

          DO I1=1,NDI
            IP1 = CONN(I1,I)
            JP1 = IP1
C           I --> IP1
            IRING(2) = IP1
            NDI1     = NDIST(IP1)
            IF(NDI1.LE.1) GO TO 101
            DO I2=1,NDI1
              IP2 = CONN(I2,IP1)
              JP2 = IP2
              IF(IP2.EQ.I) GO TO 102
C             I --> IP1 --> IP2
              IRING(3) = IP2
              NDI2     = NDIST(IP2)
              IF(NDI2.LE.1) GO TO 102
              DO I3=1,NDI2
                IP3 = CONN(I3,IP2)
                JP3 = IP3
                IF(IP3.EQ.IP1) GO TO 103
C               I --> IP1 --> IP2 --> IP3
                IF(I.EQ.IP3) THEN
C                 triangle
                  IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *               JP3.GT.0.AND.IPRSNT.GT.0) THEN
                    DO II=1,L1A_NDIST(I)
                      IF(L1A_CONN(II,I).EQ.IP2) THEN
C                       L1A_CONN(II,I) =-ABS(L1A_CONN(II,I)) 
                        GO TO 220
                      ENDIF
                    ENDDO
  220               CONTINUE
C                   L1A_CONN(I3,IP2) =-ABS(L1A_CONN(I3,IP2))
                  ENDIF
                  GO TO 103
                ENDIF
                IRING(4) = IP3
                NDI3     = NDIST(IP3)
                IF(NDI3.LE.1) GO TO 103
                DO I4=1,NDI3
                  IP4 = CONN(I4,IP3)
                  JP4 = IP4
                  IF(IP4.EQ.IP1.OR.IP4.EQ.IP2) GO TO 104
C                 I --> IP1 --> IP2 --> IP3 --> IP4
                  IF(I.EQ.IP4) THEN
C                   square

                    NR = 4
                    CALL IS_THERE_THIS_RING(NR,IRING
     *                                     ,NRINGT,IRING_ID) 
                    IF(IRING_ID.LE.0) THEN

c                        write(*,*) '5:',i,ip1,ip2,ip3,ip4
c                        write(*,*) ' :',jp,jp1,jp2,jp3,jp4
c                        write(*,*) ' :',iprsnt

                      IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *                   JP3.GT.0.AND.JP4.GT.0.AND.IPRSNT.GT.0) THEN
                        DO II=1,L1A_NDIST(I)
                          IF(L1A_CONN(II,I).EQ.IP3) THEN
                            L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                            GO TO 230
                          ENDIF
                        ENDDO
  230                   CONTINUE
                        L1A_CONN(I4,IP3) =-ABS(L1A_CONN(I4,IP3)) 
                      ENDIF

                      NRINGT = NRINGT + 1
                      CALL ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
                    ENDIF
                    GO TO 104
                  ENDIF
                  IRING(5) = IP4
                  NDI4     = NDIST(IP4)
                  IF(NDI4.LE.1) GO TO 104
                  DO I5=1,NDI4
                    IP5 = CONN(I5,IP4)
                    JP5 = IP5
                    IF(IP5.EQ.IP1.OR.IP5.EQ.IP2.OR.IP5.EQ.IP3) GO TO 105
C                   I-->IP1-->IP2-->IP3-->IP4-->IP5
                    IF(I.EQ.IP5) THEN
                      NR = 5
                      CALL IS_THERE_THIS_RING(NR,IRING
     *                                       ,NRINGT,IRING_ID) 
                      IF(IRING_ID.LE.0) THEN

c                        write(*,*) '5:',i,ip1,ip2,ip3,ip4,ip5
c                        write(*,*) ' :',jp,jp1,jp2,jp3,jp4,jp5
c                        write(*,*) ' :',iprsnt

                        IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *                     JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *                     IPRSNT.GT.0) THEN
                           DO II=1,L1A_NDIST(I)
                             IF(L1A_CONN(II,I).EQ.IP4) THEN
                               L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                               GO TO 240
                             ENDIF
                           ENDDO
  240                      CONTINUE
                           L1A_CONN(I5,IP4) =-ABS(L1A_CONN(I5,IP4)) 

c                        write(*,*) ' >',L1A_CONN(I5,IP4),i5,ip4
c                        write(*,*) ' >',L1A_CONN(ii,I)  ,ii,i

                        ENDIF

                        NRINGT = NRINGT + 1
                        CALL ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
                      ENDIF
                      GO TO 105
                    ENDIF
                    IRING(6) = IP5
                    NDI5     = NDIST(IP5)
                    IF(NDI5.LE.1) GO TO 105
                    DO I6=1,NDI5
                      IP6 = CONN(I6,IP5)
                      JP6 = IP6
                      IF(IP6.EQ.IP1.OR.IP6.EQ.IP2.OR.IP6.EQ.IP3.OR.
     *                   IP6.EQ.IP4) GO TO 106
C                         I-->IP1-->IP2-->IP3-->IP4-->IP5-->IP6
                      IF(I.EQ.IP6) THEN
                        NR = 6
                        CALL IS_THERE_THIS_RING(NR,IRING
     *                                         ,NRINGT,IRING_ID) 
                        IF(IRING_ID.LE.0) THEN

c                          write(*,*) '6:',i,ip1,ip2,ip3,ip4,ip5,ip6
c                          write(*,*) ' :',jp,jp1,jp2,jp3,jp4,jp5,jp6
c                          write(*,*) ' :',iprsnt

                          IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *                       JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *                       JP6.GT.0.AND.IPRSNT.GT.0) THEN
                            DO II=1,L1A_NDIST(I)
                              IF(L1A_CONN(II,I).EQ.IP5) THEN
                                L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                                GO TO 250
                              ENDIF
                            ENDDO
  250                       CONTINUE
                            L1A_CONN(I6,IP5) =-ABS(L1A_CONN(I6,IP5)) 

c                            write(*,*) ' >',L1A_CONN(I6,IP5),ip6,ip5
c                            write(*,*) ' >',L1A_CONN(ii,I)  ,ii,i

                          ENDIF

                          NRINGT = NRINGT + 1
                          CALL ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
                        ENDIF
                        GO TO 106
                      ENDIF
C ---///
        IF(IPRSNT.GT.1.AND.NA.GE.7) THEN
          NDI6     = NDIST(IP6)
          IF(NDI6.LE.1) GO TO 106
          DO I7=1,NDI6
            JP7 = CONN(I7,IP6)
            IF(I.EQ.JP7) THEN
C             NR = 7
              IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *           JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *           JP6.GT.0.AND.JP7.GT.0.AND.
     *           IPRSNT.GT.0) THEN
                DO II=1,L1A_NDIST(I)
                  IF(L1A_CONN(II,I).EQ.IP6) THEN
                    L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                    GO TO 260
                  ENDIF
                ENDDO
  260           CONTINUE
                L1A_CONN(I7,IP6) =-ABS(L1A_CONN(I7,IP6)) 
              ENDIF
              GO TO 107 
            ENDIF
            NDI7     = NDIST(JP7)
            IF(NDI7.LE.1) GO TO 107
            DO I8=1,NDI7
              JP8 = CONN(I8,JP7)
              IF(I.EQ.JP8) THEN
C               NR = 8
                IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *             JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *             JP6.GT.0.AND.JP7.GT.0.AND.JP8.GT.0.AND.
     *             IPRSNT.GT.0) THEN
                  DO II=1,L1A_NDIST(I)
                    IF(L1A_CONN(II,I).EQ.JP7) THEN
                      L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                      GO TO 270
                    ENDIF
                  ENDDO
  270             CONTINUE
                  L1A_CONN(I8,JP7) =-ABS(L1A_CONN(I8,JP7)) 
                ENDIF
                GO TO 108 
              ENDIF
C ...

 108        CONTINUE
            ENDDO
 107        CONTINUE
          ENDDO
        ENDIF
C----///
C                     I-->IP1-->IP2-->IP3-->IP4-->IP5-->IP6 end
 106                  CONTINUE
                    ENDDO
C                   I-->IP1-->IP2-->IP3-->IP4-->IP5end
 105                CONTINUE
                  ENDDO
C                 I --> IP1 --> IP2 --> IP3 --> IP4 end
  104             CONTINUE
                ENDDO
C               I --> IP1 --> IP2 --> IP3 end
  103           CONTINUE
              ENDDO
C             I --> IP1 --> IP2 end
  102         CONTINUE
            ENDDO
C           I --> IP1 end
  101       CONTINUE
          ENDDO      
  100     CONTINUE
        ENDDO
      ENDIF 

C -------------------

C ---
      IF(LIST.EQ.'T') THEN
        call msgdoc(mdoc,' --- rings ---')
        WRITE(LINE,'(A,I5)') 'Nringt=',NRINGT 
        call msgdoc(mdoc,line)
        DO I=1,NA
          WRITE(LINE,'(I4,1X,A,1X,I4,3X,5(3I3,2X))') 
     *    I,l1a_aname(I),L1A_NRING(I)
     *    ,(L1A_RING_ID(J,I),L1A_RING_ORD(J,I)
     *    ,L1A_RING_FLAT(J,I),J=1,5)
          call msgdoc(mdoc,line)
        ENDDO
        call msgdoc(mdoc,' ------')
      ENDIF
C ---
      RETURN
      END     

      SUBROUTINE ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
C -----------------------------------------------------
      INTEGER MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER IRING(*)
      INTEGER ICHEM(*)
C -------------------------------
      IF(NR.LE.0) RETURN
      IFLAT = 1
      DO I=1,NR                   
        IF(ICHEM(I).LT.0) IFLAT = 0          
      ENDDO
      DO I=1,NR
        IA = IRING(I)                    
        L1A_NRING(IA) = L1A_NRING(IA) + 1
        L1A_RING_ID  (L1A_NRING(IA),IA) = NRINGT
        L1A_RING_ORD (L1A_NRING(IA),IA) = NR
        L1A_RING_FLAT(L1A_NRING(IA),IA) = IFLAT
      ENDDO
C ---
      RETURN
      END     

      SUBROUTINE IS_THERE_THIS_RING(NR,IRING,NRINGT,IRING_ID)
C -----------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER IRING(*)
      INTEGER JRING(MX1ATOM)
C -------------------------------
      IRING_ID = 0
      IF(NR.LE.2.OR.NRINGT.LE.0) RETURN

      CALL RING_SRCH(NR,IRING,NRINGT,IRING_ID)
      IF(IRING_ID.GT.0) RETURN
C ---
      IF(NR.LE.3) RETURN
      DO I=1,NR
        NNR = 0
        DO J=1,NR
          IF(I.NE.J) THEN
            NNR = NNR + 1
            JRING(NNR) = IRING(J)
          ENDIF
        ENDDO
        IF(NNR.GT.2) THEN
          CALL RING_SRCH(NNR,JRING,NRINGT,IRING_ID)
          IF(IRING_ID.GT.0) RETURN
        ENDIF
      ENDDO
C ---
      IF(NR.LE.4) RETURN
      DO I=1,NR
      DO K=1,NR
        IF(I.NE.K) THEN
          NNR = 0
          DO J=1,NR
            IF(J.NE.I.AND.J.NE.K) THEN
              NNR = NNR + 1
              JRING(NNR) = IRING(J)
            ENDIF
          ENDDO
          IF(NNR.GT.2) THEN
            CALL RING_SRCH(NNR,JRING,NRINGT,IRING_ID)
            IF(IRING_ID.GT.0) RETURN
          ENDIF
        ENDIF
      ENDDO
      ENDDO
C ---
      IF(NR.LE.5) RETURN
      DO I=1,NR
      DO K=1,NR
      DO L=1,NR
        IF(I.NE.K.AND.I.NE.L.AND.K.NE.L) THEN
          NNR = 0
          DO J=1,NR
            IF(J.NE.I.AND.J.NE.K.AND.J.NE.L) THEN
              NNR = NNR + 1
              JRING(NNR) = IRING(J)
            ENDIF
          ENDDO
          IF(NNR.GT.2) THEN
            CALL RING_SRCH(NNR,JRING,NRINGT,IRING_ID)
            IF(IRING_ID.GT.0) RETURN
          ENDIF
        ENDIF
      ENDDO
      ENDDO
      ENDDO
C ---         
      RETURN
      END     

      SUBROUTINE RING_SRCH(NR,IRING,NRINGT,IRING_ID)
C -----------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER IRING(*)
C -------------------------------
      IRING_ID = 0
      IF(NR.LE.2.OR.NRINGT.LE.0) RETURN
      DO I=1,NRINGT
        DO J=1,NR
          IA = IRING(J)
          IF(L1A_NRING(IA).LE.0) RETURN
          DO K=1,L1A_NRING(IA)
            IF(L1A_RING_ID(K,IA).EQ.I) GO TO 100
          ENDDO
          GO TO 200
 100      CONTINUE
        ENDDO
        IRING_ID = I
        RETURN  
 200    CONTINUE
      ENDDO
C ---
      RETURN
      END     


      SUBROUTINE ADD_HATOM_TO_PLAN(MDOC,IERR)
C -------------------------------------------------
C     add H_atoms to PLAN
C
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      CHARACTER LINE*256,SYMB*4,ANAME*4,HANAME*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ----------------------------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ----------------
      IF(L1P_NPLAN.LE.0) RETURN

      DO IP=1,L1P_NPLAN
        NAP = L1P_NATOM(IP) 

C        write(*,*) '--plan',ip,nap

        DO IA=1,NAP 
          I    = L1P_IATOM(IA,IP)
          SYMB = L1A_CHEM(I)

C          iCH4 = L1P_ATOM(iA,IP)
C          write(*,*) '  ',symb,i,L1A_NDIST(I),ch4
          
          IF(L1A_ICHIR(I).LT.0) THEN

            ND = L1A_NDIST(I) + L1A_NEXTR(I)
            IF(L1A_IBACK(I).GT.0) ND = ND + 1

            IF(ND.GE.2) THEN
              DO J=1,L1A_NDIST(I)
                IJ = ABS(L1A_CONN(J,I))
 
C            write(*,*) '   conn',ij,L1A_ATYPE(IJ),L1A_ANAME(IJ)

                IF(L1A_ATYPE(IJ).EQ.'H'.OR.L1A_ATYPE(IJ).EQ.'M') THEN
                  HANAME = L1A_ANAME(IJ)
                  DO JA=1,NAP 
                    ICH4  = L1P_ATOM(JA,IP) 
                    ANAME = CH4
                    IF(ANAME.EQ.HANAME) GO TO 100
                  ENDDO
                  IF(L1P_NATOM(IP).GE.MAX1APL) THEN
                    WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *                ,L1L_MNAME,' >',MAX1APL
                    CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                    IERR=1
                    RETURN
                  ENDIF
                  L1P_NATOM(IP)    = L1P_NATOM(IP) + 1
                  KA               = L1P_NATOM(IP)
                  L1P_IATOM(KA,IP) = IJ
                  CH4              = HANAME
                  L1P_ATOM(KA,IP)  = ICH4
                  L1P_DOBS(KA,IP)  = 0.0
                  L1P_DEV (KA,IP)  = 0.02
  100             CONTINUE
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO
      ENDDO
C ----
      RETURN
      END       
C
      SUBROUTINE CHECK_CONNECTIVITY(MDOC,LIST,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,LIST*1,TREE*1
C -----------------------------------------------
      IERR = 0
      MON  = L1L_MNAME
      NA   = L1A_NATOM
      IF(NA.LE.1) RETURN
      CALL COPYL2(MDOC,IERR)
C --
      DO I=1,L2A_NATOM
        L2A_ICR(I) = I  
      ENDDO

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' -- PRECHECK_L1_MON_DESCRIPTION --- ')
        WRITE(LINE,*) ' --- NA:',L1A_NATOM
        CALL MSGDOC(MDOC,LINE)
        IF(NA.GT.0) THEN
        DO IA=1,NA
          WRITE(LINE,*) IA,' ',L1A_ANAME(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
        WRITE(LINE,*) ' --- NB:',L1B_NBOND
        CALL MSGDOC(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          WRITE(LINE,*) IB,' ',L1B_I1ATM(IB),L1B_I2ATM(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
      ENDIF
C -----
      DO IA=1,NA
        DO JA=1,NA
          J = L2A_ICR(JA) 
          DO IB=1,L2B_NBOND
            IK = 0
            IF(L2B_I1ATM(IB).EQ.J.AND.L2B_I2ATM(IB).NE.J) THEN
              IK = L2B_I2ATM(IB)
            ELSE IF(L2B_I2ATM(IB).EQ.J.AND.L2B_I1ATM(IB).NE.J) THEN
              IK = L2B_I1ATM(IB)
            ENDIF
            IF(IK.GT.0) THEN
              DO KA=1,NA
                IF(L2A_ICR(KA).EQ.IK) L2A_ICR(KA) = J  
              ENDDO
              DO JB=1,L2B_NBOND
                IF(L2B_I1ATM(JB).EQ.IK) L2B_I1ATM(JB) = J
                IF(L2B_I2ATM(JB).EQ.IK) L2B_I2ATM(JB) = J
              ENDDO
            ENDIF    
          ENDDO
        ENDDO
C --
        NPIECE = 1
        DO J=2,NA
          DO K=1,J-1
            IF(L2A_ICR(J).EQ.L2A_ICR(K)) GO TO 100
          ENDDO
          NPIECE = NPIECE + 1 
 100      CONTINUE
        ENDDO
        IF(NPIECE.LE.1) GO TO 200
C -- 
      ENDDO

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '---- I,NPIECE:',I,NPIECE
        CALL MSGDOC(MDOC,LINE)         
        DO K=1,NA
          WRITE(LINE,*) '--',L2A_ANAME(K),K,L2A_ICR(K) 
          CALL MSGDOC(MDOC,LINE)         
        ENDDO
        CALL MSGDOC(MDOC,'-----------------')         
      ENDIF 

      NPIECE1 = NPIECE - 1
      WRITE(LINE,
     *'('' ERROR: monomer:'',A,'' is not completely connected.'')') MON
      CALL MSGERR(MDOC,LINE)         

      IERR = 20

 200  CONTINUE
C -------
      RETURN
      END

      SUBROUTINE  CHECK_LIST_ATOM(MDOC,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM1*4,ATOM2*4,CHEM*4,MON*8
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NA   = L1A_NATOM
      I = 0
      DO IA=1,NA
        IF((L1A_ATYPE(IA).NE.'H'.AND.L1A_ATYPE(IA).NE.'?').OR.
     *     (L1A_ATYPE(IA).EQ.'H'.AND.L1A_COOR_FLAG(IA).EQ.'Y')) THEN
          I = I + 1
          L1A_COOR_FLAG(I) = L1A_COOR_FLAG(IA) 
          L1A_X        (I) = L1A_X        (IA)
          L1A_Y        (I) = L1A_Y        (IA)
          L1A_Z        (I) = L1A_Z        (IA)
          L1A_ANAME    (I) = L1A_ANAME    (IA) 
          L1A_SYMB     (I) = L1A_SYMB     (IA)
          L1A_CHEM     (I) = L1A_CHEM     (IA)
          L1A_ATYPE    (I) = L1A_ATYPE    (IA)
        ENDIF
      ENDDO
      IF(I.LE.0) THEN
        IERR = 1
        LINE = ' ERROR: '//MON//': number atoms = 0'
        CALL MSGDOC(MDOC,LINE)
        RETURN
      ELSE
        L1A_NATOM = I     
        NA        = I
      ENDIF
C ---
      DO IA=1,NA
        IF(L1A_COOR_FLAG(IA).NE.'Y') THEN
          IERR = 1
          LINE = ' ERROR: '//MON//': can not create new monomer'
          CALL MSGDOC(MDOC,LINE)
          LINE = '                   Some atoms without coordinates' 
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
      ENDDO    

      RETURN
      END

      SUBROUTINE REMOVE_USER_CHIR_CENTRE(MDOC,LIST,IERR)
C -------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
      INTEGER   I,J,IA,N
      CHARACTER LINE*256,ATOM*4,MON*8,LIST*1
C ----------------------------------------------------
      IERR = 0
C ----------------
      IF(L1A_NATOM.LE.0) RETURN
      IF(L1C_NCHIR.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        write(*,*) ' before R_U_C_C nchir:',L1C_NCHIR 
      ENDIF
 
      N = 0
      DO I=1,L1C_NCHIR  

        IF(L1C_SIGN(I)(1:4).EQ.'cros'.OR.
     *     L1C_SIGN(I)(1:4).EQ.'star'    ) THEN
          J = 1
          GO TO 100
        ENDIF

        IA = L1C_I1ATM(I)
        IF(IS_IT_METAL(L1A_SYMB(IA))) THEN 
          IF(L1L_PRSNT.EQ.'M') THEN
            J = 1
            GO TO 100
          ENDIF
        ENDIF 

        ATOM = L1C_1ATM(I)
        J = 0
        DO IA=1,L1A_NATOM
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            IF(L1A_ICHIR(IA).LE.0) J = 0
            GO TO 100
          ENDIF
        ENDDO
 100    CONTINUE

        IF(J.GT.0) THEN
          N = N + 1
          L1C_I1ATM(N) = L1C_I1ATM(I) 
          L1C_1ATM (N) = L1C_1ATM (I) 
          L1C_I2ATM(N) = L1C_I2ATM(I) 
          L1C_2ATM (N) = L1C_2ATM (I) 
          L1C_I3ATM(N) = L1C_I3ATM(I) 
          L1C_3ATM (N) = L1C_3ATM (I) 
          L1C_I4ATM(N) = L1C_I4ATM(I) 
          L1C_4ATM (N) = L1C_4ATM (I) 
          L1C_SIGN (N) = L1C_SIGN (I)
          L1C_FLAG (N) = L1C_FLAG (I)
          L1C_VOL  (N) = L1C_VOL  (I)
          L1C_VOBS (N) = L1C_VOBS (I)
          L1C_I5ATM(N) = L1C_I5ATM(I) 
          L1C_5ATM (N) = L1C_5ATM (I) 
          L1C_I6ATM(N) = L1C_I6ATM(I) 
          L1C_6ATM (N) = L1C_6ATM (I) 
          L1C_I7ATM(N) = L1C_I7ATM(I) 
          L1C_7ATM (N) = L1C_7ATM (I) 
          L1C_I8ATM(N) = L1C_I8ATM(I) 
          L1C_8ATM (N) = L1C_8ATM (I) 
          L1C_I9ATM(N) = L1C_I9ATM(I) 
          L1C_9ATM (N) = L1C_9ATM (I) 
        ENDIF
      ENDDO

      L1C_NCHIR = N 

      IF(LIST.EQ.'T') THEN
        write(*,*) ' R_U_C_C nchir:',L1C_NCHIR 
      ENDIF
C ---
      RETURN
      END 

      SUBROUTINE CHECK_CHIR_ATOM(MDOC,IERR)
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      CHARACTER LINE*256,ATOM*4,MON*8
C ----------------------------------------------------
      IERR = 0
C ----------------
      NA   = L1A_NATOM
      MON  = L1L_MNAME        
      IF(NA.LE.0) RETURN
      IF(L1C_NCHIR.LE.0) RETURN

      DO I=1,L1C_NCHIR  
        ATOM = L1C_1ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 100
          ENDIF
        ENDDO
 100    L1C_I1ATM(I) = J
        ATOM = L1C_2ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 200
          ENDIF
        ENDDO
 200    L1C_I2ATM(I) = J
        ATOM = L1C_3ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 300
          ENDIF
        ENDDO
 300    L1C_I3ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 400
          ENDIF
        ENDDO
 400    L1C_I4ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 500
          ENDIF
        ENDDO
 500    L1C_I5ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 600
          ENDIF
        ENDDO
 600    L1C_I6ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 700
          ENDIF
        ENDDO
 700    L1C_I7ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 800
          ENDIF
        ENDDO
 800    L1C_I8ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 900
          ENDIF
        ENDDO
 900    L1C_I9ATM(I) = J
      ENDDO

      N    = 0
      JERR = 0
      DO I=1,L1C_NCHIR  
        IF(L1C_SIGN(I)(1:4).NE.'cros'.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *    (L1C_I1ATM(I).EQ.0.OR.L1C_I2ATM(I).EQ.0.AND.
     *     L1C_I3ATM(I).EQ.0.OR.L1C_I4ATM(I).EQ.0     )) THEN
          JERR = 1
          GO TO 1000
        ELSE IF(L1C_I1ATM(I).EQ.0) THEN
          JERR = 1
          GO TO 1000
        ENDIF 

          N = N + 1
          L1C_I1ATM(N) = L1C_I1ATM(I) 
          L1C_1ATM (N) = L1C_1ATM (I) 
          L1C_I2ATM(N) = L1C_I2ATM(I) 
          L1C_2ATM (N) = L1C_2ATM (I) 
          L1C_I3ATM(N) = L1C_I3ATM(I) 
          L1C_3ATM (N) = L1C_3ATM (I) 
          L1C_I4ATM(N) = L1C_I4ATM(I) 
          L1C_4ATM (N) = L1C_4ATM (I) 
          L1C_SIGN (N) = L1C_SIGN (I)
          L1C_I1ATM(N) = L1C_I1ATM(I) 
          L1C_1ATM (N) = L1C_1ATM (I) 
          L1C_FLAG (N) = L1C_FLAG (I)
          L1C_I5ATM(N) = L1C_I5ATM(I) 
          L1C_5ATM (N) = L1C_5ATM (I) 
          L1C_I6ATM(N) = L1C_I6ATM(I) 
          L1C_6ATM (N) = L1C_6ATM (I) 
          L1C_I7ATM(N) = L1C_I7ATM(I) 
          L1C_7ATM (N) = L1C_7ATM (I) 
          L1C_I8ATM(N) = L1C_I8ATM(I) 
          L1C_8ATM (N) = L1C_8ATM (I) 
          L1C_I9ATM(N) = L1C_I9ATM(I) 
          L1C_9ATM (N) = L1C_9ATM (I) 
          L1C_VOBS (N) = L1C_VOBS (I)
          L1C_VOL  (N) = L1C_VOL  (I)
 1000     CONTINUE

      ENDDO
      IF(JERR.NE.0) THEN
        LINE = ' WARNING: '//MON//': some chirality is not defined'
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      L1C_NCHIR = N 
C ---
      RETURN
      END 

      SUBROUTINE CALC_VOBSN(MDOC,LIST,MON,NRINGT,IERR)
C -----------------------------------------------
C -P- CONNECT - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NSTLIM = 10 )
      INTEGER*4 NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
C --------------------------------------
      CHARACTER LINE*256
C ---------------------------------------
      IERR=0
C ---
c      DO I=1,L1A_NATOM
c        IF(L1A_NDIST(I).GT.0) THEN
c          N=0
c          DO J=1,L1A_NDIST(I)
c            K=L1A_CONN(J,I)
c            IF(L1A_TYPE(K).NE.'DUMMY') THEN
c              N=N+1
c              L1A_CONN(N,I)=K
c            ENDIF  
c          ENDDO
c          L1A_NDIST(I)=N
c        ENDIF
c        IF(L1A_NEXTR(I).GT.0) THEN
c          NN=0
c          DO J=1,L1A_NEXTR(I)
c            K=L1A_TEXTR(J,I)
c            IF(K.EQ.0) THEN
c              NN=NN+1
c              L1A_IEXTR(NN,I)=L1A_IEXTR(J,I)
c              L1A_TEXTR(NN,I)=0
c            ENDIF  
c          ENDDO
c          L1A_NEXTR(I)=NN
c        ENDIF
c      ENDDO
C ---
      ISTART  = L1A_ISTART
      IFINISH = L1A_IFINISH
      ISTART2 = 0
C ---
      I       = ISTART
      IC      = 1
      NSTCK   = 0
      NV      = 0
      NC      = 0
C ----------------------------
  400 CONTINUE

      N = L1A_NDIST(I)
      NE= L1A_NEXTR(I)

      IF(LIST.EQ.'T') THEN
        write(*,*) '---CALC_VOBSN--'
        write(*,'(''i,ic,NST,n,NE,'',5I3,1X,A4,1X,I3)') 
     *  i,ic,NSTCK,n,NE,l1a_aname(i),L1A_CONN(1,I)
      ENDIF

      IF(IC.EQ.1) THEN

        CALL CALC_VOBSNN(MDOC,LIST,I,NV,NC,MON,IERR)
        IF(IERR.NE.0) RETURN

      ENDIF

      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500

        IF(N.EQ.0) THEN

          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          NSTCK = NSTCK-1

        ELSE IF(N.EQ.1) THEN

          INEXT = L1A_CONN(1,I)
          IC    = 1
          I     = INEXT

        ELSE IF(N.GT.1) THEN

  410     CONTINUE
          INEXT = L1A_CONN(IC,I)

          IF(IC.LT.N) THEN
            IC    = IC+1
            NSTCK = NSTCK+1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(LINE,
     *        '('' ERROR: '',A,'' : N-stack > '',I6)')
     *        MON,NSTLIM
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF
            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
          ENDIF   
          I  = INEXT
          IC = 1

        ELSE

          WRITE(LINE,
     *    '('' WARNING : '',A,'' : bad tree structure '')')
     *    MON
          CALL MSGERR(MDOC,LINE)
          IERR=1
          GO TO 2000

        ENDIF

      GO TO 400
C -------------------------------
  500 CONTINUE
C ---

      IF(LIST.EQ.'T') write(*,*) '---end CALC_VOBSN--'

      CALL SET_TRIANGLE_ANGLES(MDOC,LIST,IERR)
      IF(IERR.NE.0) GO TO 2000

      IF(LIST.EQ.'T') THEN
        MMM=1
        CALL PRINT_LIB_LBC(MMM,IERR)
      ENDIF

      IANGL = 0
      IMET  = 0
      CALL CHECK_METAL_CHIR(MDOC,MON,IANGL,LIST,IERR)
      IF(IERR.NE.0) THEN
        ICOOR = 0
        COOR_SUM = 0.0
        DO I=1,L1A_NATOM
          IF(L1A_SYMB(I).NE.'H   '.AND.
     *       L1A_SYMB(I).NE.'D   '     ) THEN
            IF(L1A_COOR_FLAG(I).EQ.'N'.OR.
     *         L1A_COOR_FLAG(I).EQ.'.') THEN
              ICOOR=1 
            ELSE
              COOR_SUM = COOR_SUM +  
     *               ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
            ENDIF
          ENDIF
        ENDDO
        IF(COOR_SUM.LT.0.001) ICOOR = 1
        IF(ICOOR.GT.0) GO TO 2000 
        IERR = 0
        IMET = 1
      ENDIF

      IF(LIST.EQ.'T') write(*,*) '---before TORS_CORR --'

      IF(LIST.EQ.'T') THEN
        MMM=1
        CALL PRINT_LIB_LBC(MMM,IERR)
      ENDIF

      IF(IMET.EQ.0) THEN 
        CALL TORSION_CORRECTION(MDOC,LIST,NRINGT,IERR)
        IF(IERR.NE.0) GO TO 2000
      ENDIF

      IF(LIST.EQ.'T') write(*,*) '---after TORS_CORR --',L1B_NBOND

      IF(L1C_NCHIR.GT.0) THEN
        DO  I = 1,L1C_NCHIR
          PH1 = 0.0
          PH2 = 0.0
          PH3 = 0.0
          CALL CALC_IVOL(I,VOLIDL,PH1,PH2,PH3)
          CALL CALC_OVOL(I,VOLOBS,IERR)
          IERR = 0
          L1C_VOL (I) = VOLIDL
          L1C_VOBS(I) = VOLOBS
c         L1C_SIGN(I) = 'positiv'
        ENDDO
      ENDIF

      CALL PLAN_RSTR(MDOC,IERR)

      IF(LIST.EQ.'T') write(*,*)'---end end CALC_VOBSN--',L1B_NBOND

      IF(LIST.EQ.'T') THEN
        MMM=1
        CALL PRINT_LIB_LBC(MMM,IERR)
      ENDIF

      RETURN
C -------------------------------
 2000 CONTINUE
      WRITE(LINE,
     * '('' WARNING : '',A,'' /subroutine CALC_VOBSN/'')')
     * MON
      CALL MSGERR(MDOC,LINE)
      RETURN    
      END

      SUBROUTINE SET_TRIANGLE_ANGLES(MDOC,LIST,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,LIST*1
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NB   = L1B_NBOND
      IF(NB.LE.2) RETURN
C ---
      DO I=1,NB-2
        DO J=I+1,NB-1
          IF(L1B_I1ATM(I).EQ.L1B_I1ATM(J)) THEN 
            IB1 = L1B_I2ATM(I)   
            IB2 = L1B_I2ATM(J)   
            IB3 = L1B_I1ATM(I)
          ELSE IF(L1B_I1ATM(I).EQ.L1B_I2ATM(J)) THEN 
            IB1 = L1B_I2ATM(I)   
            IB2 = L1B_I1ATM(J)   
            IB3 = L1B_I1ATM(I)
          ELSE IF(L1B_I2ATM(I).EQ.L1B_I1ATM(J)) THEN 
            IB1 = L1B_I1ATM(I)   
            IB2 = L1B_I2ATM(J)   
            IB3 = L1B_I2ATM(I)
          ELSE IF(L1B_I2ATM(I).EQ.L1B_I2ATM(J)) THEN 
            IB1 = L1B_I1ATM(I)   
            IB2 = L1B_I1ATM(J)   
            IB3 = L1B_I2ATM(I)
          ELSE
            IB1 = 0
            IB2 = 0
            IB3 = 0
          ENDIF
          IF(IB1.GT.0) THEN
            DO K=J+1,NB
              IF((L1B_I1ATM(K).EQ.IB1.AND.L1B_I2ATM(K).EQ.IB2).OR.
     *           (L1B_I1ATM(K).EQ.IB2.AND.L1B_I2ATM(K).EQ.IB1))THEN
                IF(LIST.EQ.'T') THEN  
        LINE = ' WARNING: '//MON//' triangle:'//L1A_ANAME(IB1)//
     *         ' - '//L1A_ANAME(IB2)//' - '//L1A_ANAME(IB3)
        CALL MSGDOC(MDOC,LINE)
        LINE = '          bond:'//L1B_1ATM(K)//' - '//L1B_2ATM(K)
        CALL MSGDOC(MDOC,LINE)
                ENDIF

                CALL SET_TANGLE_VALUE(MDOC,MON,I,J,K,IB1,IB2,IB3,IERR)
                IERR = 0
                GO TO 200
              ENDIF
 200          CONTINUE
            ENDDO
          ENDIF
        ENDDO
      ENDDO

      RETURN
      END

      SUBROUTINE SET_TANGLE_VALUE(MDOC,MON,I,J,K,IA1,IA2,IA3,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,I,J,K,IA1,IA2,IA3,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C --
      REAL      BOND1,BOND2,BOND3
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
C       IA1--ib3--IA2
C         \      /
C         ib2  ib1
C           \  /  
C           IA3
C --------------------------------------------------------
      M    =-ABS(MDOC)-1  
      IERR = 0
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C ---
      IB1 = 0
      IB2 = 0
      IB3 = 0
      IF((L1B_I1ATM(I).EQ.IA1.AND.L1B_I2ATM(I).EQ.IA2).OR.
     *   (L1B_I1ATM(I).EQ.IA2.AND.L1B_I2ATM(I).EQ.IA1))THEN
        IB3 = I
      ELSE IF((L1B_I1ATM(I).EQ.IA2.AND.L1B_I2ATM(I).EQ.IA3).OR.
     *        (L1B_I1ATM(I).EQ.IA3.AND.L1B_I2ATM(I).EQ.IA2))THEN
        IB1 = I
      ELSE IF((L1B_I1ATM(I).EQ.IA1.AND.L1B_I2ATM(I).EQ.IA3).OR.
     *        (L1B_I1ATM(I).EQ.IA3.AND.L1B_I2ATM(I).EQ.IA1))THEN
        IB2 = I
      ENDIF
      IF((L1B_I1ATM(J).EQ.IA1.AND.L1B_I2ATM(J).EQ.IA2).OR.
     *   (L1B_I1ATM(J).EQ.IA2.AND.L1B_I2ATM(J).EQ.IA1))THEN
        IB3 = J
      ELSE IF((L1B_I1ATM(J).EQ.IA2.AND.L1B_I2ATM(J).EQ.IA3).OR.
     *        (L1B_I1ATM(J).EQ.IA3.AND.L1B_I2ATM(J).EQ.IA2))THEN
        IB1 = J
      ELSE IF((L1B_I1ATM(J).EQ.IA1.AND.L1B_I2ATM(J).EQ.IA3).OR.
     *        (L1B_I1ATM(J).EQ.IA3.AND.L1B_I2ATM(J).EQ.IA1))THEN
        IB2 = J
      ENDIF
      IF((L1B_I1ATM(K).EQ.IA1.AND.L1B_I2ATM(K).EQ.IA2).OR.
     *   (L1B_I1ATM(K).EQ.IA2.AND.L1B_I2ATM(K).EQ.IA1))THEN
        IB3 = K
      ELSE IF((L1B_I1ATM(K).EQ.IA2.AND.L1B_I2ATM(K).EQ.IA3).OR.
     *        (L1B_I1ATM(K).EQ.IA3.AND.L1B_I2ATM(K).EQ.IA2))THEN
        IB1 = K
      ELSE IF((L1B_I1ATM(K).EQ.IA1.AND.L1B_I2ATM(K).EQ.IA3).OR.
     *        (L1B_I1ATM(K).EQ.IA3.AND.L1B_I2ATM(K).EQ.IA1))THEN
        IB2 = K
      ENDIF
      IF(IB1.EQ.0.OR.IB2.EQ.0.OR.IB3.EQ.0) RETURN
C ---  
      BOND1 = L1B_VAL(IB1) 
      BOND2 = L1B_VAL(IB2) 
      BOND3 = L1B_VAL(IB3) 
      IF(BOND1.LT.0.001.OR.BOND2.LT.0.001.OR.BOND3.LT.0.001) RETURN
C ---
      DO II=1,3
        IF(II.EQ.1) THEN
          IAA1 = IA1
          IAA2 = IA2
          IAA3 = IA3
          B1   = BOND1
          B2   = BOND2
          B3   = BOND3      
        ELSE IF(II.EQ.2) THEN
          IAA1 = IA3
          IAA2 = IA1
          IAA3 = IA2
          B1   = BOND3
          B2   = BOND1
          B3   = BOND2      
        ELSE
          IAA1 = IA2
          IAA2 = IA3
          IAA3 = IA1
          B1   = BOND2
          B2   = BOND3
          B3   = BOND1      
        ENDIF
C ---
        T1     = B1*B1 + B3*B3 - B2*B2 
        T2     = 2.0*B1*B3 
        IF(T2.LT.0.0001) GO TO 200 
        COSANG = T1/T2
        IF(ABS(COSANG).GT.1.0) GO TO 200 
        ANG    = ACOS(COSANG)
        IF(ANG.GT. PI) ANG = ANG - TWOPI
        IF(ANG.LT.-PI) ANG = ANG + TWOPI
        ANG = ANG/PI180
C ---  
        CALL SRCH_ANGL(MDOC,MON,IAA1,IAA2,IAA3,VAL,L,IERR)
        IF(IERR.EQ.0.AND.L.GT.0) GO TO 100
        IERR = 0
        IF(L1G_NANGL.GE.MAX1ANG) THEN
          WRITE(LINE
     * ,'('' ERROR: number of angles of monomer >'',I6)') 
     *    MAX1ANG
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
          IERR=1
          RETURN
        ENDIF
        L1G_NANGL   = L1G_NANGL+1
        L           = L1G_NANGL
        L1G_1ATM(L) = L1A_ANAME(IAA1)
        L1G_2ATM(L) = L1A_ANAME(IAA2)
        L1G_3ATM(L) = L1A_ANAME(IAA3)
        L1G_I1ATM(L)= IAA1
        L1G_I2ATM(L)= IAA2
        L1G_I3ATM(L)= IAA3
        L1G_VOBS(L) = 0.0
        L1G_EVAL(L) = 0.0
        L1G_DEV (L) = 3.0
 100    CONTINUE
        L1G_VAL(L) = ANG
 200    CONTINUE
      ENDDO
C ---
      RETURN
      END            


      SUBROUTINE PRINT_LIB_LBC(MDOC,IERR)
C -----------------------------------------------
C -P- 
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
      CHARACTER SIGN*8
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
      IF(ABS(MDOC).GE.99) RETURN

      WRITE(LINE,'('' N BOND,ANGLE,TORS,CHIR,PLAN:'',5I4)')
     * L1B_NBOND,L1G_NANGL,L1T_NTORS,L1C_NCHIR,L1P_NPLAN
      CALL MSGDOC(MDOC,LINE)
      IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          WRITE(LINE,
     *    '(I4,'' bond '',A4,'' - '',A4,'' :'',2F8.3,2I3,A)')
     *    IB,L1B_1ATM(IB),L1B_2ATM(IB),L1B_VAL(IB),L1B_VOBS(IB)
     *    ,L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_TYPE(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO 
      ENDIF
C ---
      IF(L1G_NANGL.GT.0) THEN
        DO IG=1,L1G_NANGL
          WRITE(LINE,'(I4,'' angle '',A4,'' - '',A4,'' - '',A4
     *    ,2F8.3,3I3)')
     *    IG,L1G_1ATM(IG),L1G_2ATM(IG),L1G_3ATM(IG)
     *    ,L1G_VAL(IG),L1G_VOBS(IG)
     *    ,L1G_I1ATM(IG),L1G_I2ATM(IG),L1G_I3ATM(IG)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IF(L1T_NTORS.GT.0) THEN
        DO IT=1,L1T_NTORS
          WRITE(LINE,'(I4,''tr:'',A4,'' - '',A4,'' - '',A4
     *     ,'' - '',A4,'' :'',2F6.1,I2,A,4I3)')
     *    IT,L1T_1ATM(IT),L1T_2ATM(IT),L1T_3ATM(IT),L1T_4ATM(IT)
     *    ,L1T_VAL(IT), L1T_VOBS(IT),L1T_PRD(IT),L1T_LABEL(IT)
     *    ,L1T_I1ATM(IT),L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IF(L1C_NCHIR.GT.0) THEN
        DO IC=1,L1C_NCHIR
          WRITE(LINE,'(I4,''ch:'',A4,'' '',A4,'' '',A4,'' '',A4
     *    ,'' :'',2F7.2,A,4I3,A)')
     *    IC,L1C_1ATM(IC),L1C_2ATM(IC),L1C_3ATM(IC),L1C_4ATM(IC)
     *    ,L1C_VOL(IC),L1C_VOBS(IC),L1C_SIGN(IC)
     *    ,L1C_I1ATM(IC),L1C_I2ATM(IC),L1C_I3ATM(IC),L1C_I4ATM(IC)
     *    ,L1C_FLAG(IC)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF

      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          DO  I = 1,L1P_NATOM(IP)
            WRITE(LINE,'(I4,'' '',A,'' atom '',A4,I4)')
     *      IP,L1P_LABEL(IP),L1P_ATOM(I,IP),L1P_IATOM(I,IP)
            CALL MSGDOC(MDOC,LINE)
          ENDDO
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE CALC_VOBSNN(MDOC,LIST,I0,NV,NC,MON,IERR)
C -----------------------------------------------
C -P- CALC_VOBS - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C --------------------------------------------------------
        IF(LIST.EQ.'T') THEN
          write(*,*) '   CALC_VOBSNN-->',I0,L1B_NBOND
        ENDIF

        I  = I0
        I1 = I 
        IF(L1A_IBACK(I1).GT.0.AND.L1A_TYPE(I1).NE.'DUMMY') THEN
          I2 = L1A_IBACK(I1)
          CALL SET_VBOND(MDOC,MON,I1,I2,IERR)
          IF(IERR.NE.0) RETURN
        ENDIF

        IF(L1A_NEXTR(I).GT.0) THEN
          DO K = 1,L1A_NEXTR(I)
            I1 = I
            I2 = L1A_IEXTR(K,I)
            IF(I1.LT.I2) THEN
              CALL SET_VBOND(MDOC,MON,I1,I2,IERR)
              IF(IERR.NE.0) RETURN
            ENDIF
          ENDDO
        ENDIF

        I2 = I
 
        IF(L1A_IBACK(I2).GT.0.AND.L1A_TYPE(I2).NE.'DUMMY') THEN
          I1 = L1A_IBACK(I2)
          IF(L1A_NDIST(I2).GT.0) THEN
            DO J = 1,L1A_NDIST(I2)
              I3 = L1A_CONN(J,I2)
              IF(I3.GT.0) THEN
              IF(L1A_TYPE(I3).NE.'DUMMY') THEN
                CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
                IF(IERR.NE.0) RETURN
              ENDIF
              ENDIF
            ENDDO
          ENDIF 
          IF(L1A_NEXTR(I2).GT.0) THEN
            DO J = 1,L1A_NEXTR(I2)
              I3 = L1A_IEXTR(J,I2)
              CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
              IF(IERR.NE.0) RETURN
            ENDDO
          ENDIF 
        ENDIF

        IF(L1A_NDIST(I2).GT.1) THEN
          DO J = 2,L1A_NDIST(I2)
            I3 = L1A_CONN(J,I2)
            IF(I3.GT.0) THEN
            IF(L1A_TYPE(I3).NE.'DUMMY') THEN
              DO K=1,J-1
                I1 = L1A_CONN(K,I2)
                IF(I1.GT.0) THEN
                IF(L1A_TYPE(I1).NE.'DUMMY') THEN
                  CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
                  IF(IERR.NE.0) RETURN
                ENDIF
                ENDIF
              ENDDO
            ENDIF
            ENDIF
          ENDDO
        ENDIF  
        IF(L1A_NEXTR(I2).GT.1) THEN
          DO J = 2,L1A_NEXTR(I2)
C           I1=L1A_IEXTR(J-1,I2)
            I3 = L1A_IEXTR(J,I2)
            DO K=1,J-1
              I1 = L1A_IEXTR(K,I2)
              CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
              IF(IERR.NE.0) RETURN
            ENDDO
          ENDDO
        ENDIF  

        IF(L1A_NEXTR(I2).GT.0.AND.L1A_NDIST(I2).GT.0) THEN
          DO J=1,L1A_NEXTR(I2)
            I3 = L1A_IEXTR(J,I2)
            DO K=1,L1A_NDIST(I2)
              I1 = L1A_CONN(K,I2)
              IF(I1.GT.0) THEN
              IF(L1A_TYPE(I1).NE.'DUMMY') THEN
                CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
                IF(IERR.NE.0) RETURN
              ENDIF
              ENDIF
            ENDDO
          ENDDO
        ENDIF  

C ---   tors ---

        I3 = I
        IF(L1A_IBACK(I3).GT.0.AND.L1A_TYPE(I3).NE.'DUMMY') THEN
          I2 = L1A_IBACK(I3)
        ELSE
          I2 = 0
          GO TO 100
        ENDIF

        IF(L1A_IBACK(I2).GT.0.AND.L1A_TYPE(I2).NE.'DUMMY') THEN
          I1 = L1A_IBACK(I2)
        ELSE IF(L1A_NDIST(I2).GT.1) THEN
          I1 = 0
          NDIST = L1A_NDIST(I2)  
          IF(L1A_CONN(NDIST  ,I2).NE.I3) THEN
            I1 = L1A_CONN(NDIST,I2)
          ELSE
            IF(L1A_CONN(NDIST-1,I2).NE.I3) I1 = L1A_CONN(NDIST-1,I2)
          ENDIF
          IF(I1.LE.0) GO TO 100  
        ELSE IF(L1A_NEXTR(I3).GT.0) THEN
          J  = L1A_NEXTR(I3)
          I1 = L1A_IEXTR(J,I2)
        ELSE 
          I1 = 0
          GO TO 100
        ENDIF

        I4 = L1A_IFORW(I3)
        IF(I4.GT.0) THEN
          IF(L1A_TYPE(I4).EQ.'DUMMY') I4=0
        ENDIF

        IF(I4.GT.0) THEN
          IF((L1A_SYMB(I4)(1:2).EQ.'H '.OR.L1A_SYMB(I4)(1:2).EQ.'D ')
     *       .AND.L1A_NEXTR(I3).GT.0) THEN
            I4 = L1A_IEXTR(1,I3)
          ENDIF
        ENDIF

        IF(I4.GT.0) THEN
          IF(I1.NE.I2.AND.I1.NE.I3.AND.I1.NE.I4.AND.I2.NE.I3.AND.
     *       I2.NE.I4.AND.I3.NE.I4) THEN
            CALL SET_VTORS(MDOC,I1,I2,I3,I4,NV,NC,IERR)
            IF(IERR.NE.0) RETURN
          ENDIF
        ELSE
          IF(L1A_NEXTR(I3).GT.0) THEN
            IF(I1.NE.I2.AND.I1.NE.I3.AND.I2.NE.I3) THEN
              DO II=1,L1A_NEXTR(I3)
                I4 = L1A_IEXTR(II,I3)
                IF(I4.GT.0) THEN
                  CALL SET_VTORS(MDOC,I1,I2,I3,I4,NV,NC,IERR)
                  IF(IERR.NE.0) RETURN
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDIF

  100   CONTINUE

        IF(L1A_NEXTR(I3).GT.0.AND.I2.GT.0) THEN
          DO II=1,L1A_NEXTR(I3)
            I4 = L1A_IEXTR(II,I3)
            IF(I4.GT.0) THEN
              I5 = L1A_IBACK(I4)
              IF(I5.GT.0) THEN
                IF(I3.GE.I4) I5 = 0
              ELSE
                I5 = L1A_IFORW(I4)
              ENDIF 
              IF(I5.GT.0) THEN
                CALL SET_VTORS(MDOC,I2,I3,I4,I5,NV,NC,IERR)
                IF(IERR.NE.0) RETURN
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      RETURN
      END

      SUBROUTINE SET_VBOND(MDOC,MON,I1,I2,IERR)
C -----------------------------------------------
C -P- SET_VBOND - 
C -S-
      INTEGER*4 MDOC,I1,I2,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ------------------------------------------------
      CHARACTER LINE*256
      CHARACTER CHEM1*4,CHEM2*4,BTYPE*8,ECHEM1*4,ECHEM2*4
      REAL      DLIM1(4),DLIM2(4),DEFD(4)
      INTEGER*4 ICH4
      CHARACTER CIATOM*1,CJATOM*1
      CHARACTER ASYMB*4,CTYPE*4,CH4*4
      EQUIVALENCE (ICH4,CH4)
      DATA DLIM1/ 0.75 , 1.10 , 1.50 , 1.8 /
      DATA DLIM2/ 1.2  , 1.90 , 2.50 , 3.0 /
      DATA DEFD / 0.96 , 1.45 , 1.80 , 2.5 /
C --------------------------------------------------------
      M=-ABS(MDOC)-1
      IERR = 0
      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y') THEN
        CALL CALC_DOBS(I1,I2,DOBS)
      ELSE
        DOBS=0.0
      ENDIF

      CALL SRCH_BOND(MDOC,MON,I1,I2,VAL,L,IERR)

      IF(IERR.NE.0) THEN
        IF(L1B_NBOND.GE.MAX1BND) THEN
          WRITE(LINE
     *   ,'('' ERROR: number of bonds of monomer >'',I6)') 
     *    MAX1BND
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     *   ,'         Change parameter MAX1BND in "lib_com.fh"')
          IERR=1
          RETURN
        ENDIF
        IERR = 0
        L1B_NBOND   = L1B_NBOND+1
        L           = L1B_NBOND
        BTYPE       = 'coval'
      ELSE
        BTYPE       = L1B_TYPE(L)
      ENDIF
      
      L1B_1ATM(L) = L1A_ANAME(I1)
      L1B_2ATM(L) = L1A_ANAME(I2)
      L1B_I1ATM(L)= I1
      L1B_I2ATM(L)= I2
      L1B_TYPE(L) = BTYPE
      L1B_VOBS(L) = DOBS
      L1B_EVAL(L) = 0.0
      L1B_DEV (L) = 0.02
      CHEM1       = L1A_CHEM(I1)
      CHEM2       = L1A_CHEM(I2)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '

      IDEF_TYPE = 0
      DIST1     = 0.0
      DIST2     = 0.0
      DIST3     = 0.0
      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEB_2ATM(J) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2).OR.
     *     (ECHEM1.EQ.CHEM2.AND.ECHEM2.EQ.CHEM1)) THEN
          IF((BTYPE.EQ.'.'.AND.LEB_TYPE(J).EQ.'.').OR.
     *       (BTYPE(1:4).EQ.LEB_TYPE(J)(1:4)     )    ) THEN
            L1B_VAL(L) = LEB_LENGTH(J) 
            L1B_EVAL(L)= LEB_LENGTH(J) 
            GO TO 100
          ENDIF
          IF(LEB_TYPE(J).EQ.'.') THEN
            DIST1     = LEB_LENGTH(J)
            IDEF_TYPE = 1 
          ELSE IF(LEB_TYPE(J)(1:4).EQ.'sing') THEN
            DIST2     = LEB_LENGTH(J)
            IDEF_TYPE = 2 
          ELSE
            DIST3     = LEB_LENGTH(J)
            IDEF_TYPE = 3 
          ENDIF     
        ENDIF
      ENDDO
      IF(IDEF_TYPE.GT.0) THEN
        IF(IDEF_TYPE.EQ.1) DIST3 = DIST1
        IF(IDEF_TYPE.EQ.2) DIST3 = DIST2
        L1B_VAL(L) = DIST3 
        L1B_EVAL(L)= DIST3
        GO TO 100
      ENDIF
      D1 = 0.0
      D2 = 0.0
      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        IF(ECHEM1.EQ.CHEM1.AND.LEB_2ATM(J)(1:1).EQ.'.')
     *  D1=LEB_LENGTH(J)
        IF(ECHEM1.EQ.CHEM2.AND.LEB_2ATM(J)(1:1).EQ.'.')
     *  D2=LEB_LENGTH(J)
      ENDDO
      IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
        DA         = (D1+D2)/2.0
        L1B_VAL(L) = DA  
        L1B_EVAL(L)= DA
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default bond length will be used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '                 chem_type: ',CHEM1,'-',CHEM2,' ',L1B_VAL(L),
     *   ' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),')'
c        CALL MSGDOC(MDOC,LINE)
        GO TO 100
      ENDIF

      ASYMB = L1A_SYMB(I1)
      IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *   ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *   ASYMB(1:2).EQ.'F '                           ) THEN
        CTYPE = 'C   '
      ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
        CTYPE = 'H   '
      ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
        CTYPE = 'P   '
      ELSE
        CTYPE = '$   '
      ENDIF
      CIATOM = CTYPE(1:1)
      ASYMB  = L1A_SYMB(I2)
      IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *   ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *   ASYMB(1:2).EQ.'F '                           ) THEN
        CTYPE='C   '
      ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
        CTYPE='H   '
      ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
        CTYPE='P   '
      ELSE
        CTYPE='$   '
      ENDIF
      CJATOM = CTYPE(1:1)
      IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
        IC=1 
      ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
        IC=2
      ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
        IC=4
      ELSE 
        IC=3
      ENDIF
      IF(IC.GT.0.AND.DOBS.GT.DLIM1(IC).AND.DOBS.LT.DLIM2(IC)) THEN
        L1B_VAL(L) = DOBS
        WRITE(LINE,'(3A)')
     *' WARNING : ',MON,' : observed bond legnth will be used '
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '             chem_type: ',CHEM1,'-',CHEM2,' ',DOBS,' (',
     * L1A_ANAME(I1),'-',L1A_ANAME(I2),')'
        CALL MSGDOC(MDOC,LINE)
      ELSE
        IF(IC.GT.0) THEN
          L1B_VAL(L) = DEFD(IC)
        ELSE
          L1B_VAL(L) = 1.0
        ENDIF
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default bond legnth will be used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '                 chem_type: ',CHEM1,'-',CHEM2,' ',L1B_VAL(L),
     *  ' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),')'
c        CALL MSGDOC(MDOC,LINE)
      ENDIF
  100 CONTINUE
      RETURN
      END

      SUBROUTINE SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
C -----------------------------------------------
C -P- SET_VANGL - 
C -S-
      INTEGER*4 MDOC,I1,I2,I3,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      M=-ABS(MDOC)-1  
      IERR = 0
      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *   L1A_COOR_FLAG(I3).EQ.'Y') THEN
        CALL CALC_ANGOBS(I1,I2,I3,ANGOBS)
      ELSE
        ANGOBS = 0.0
      ENDIF
      IF(L1G_NANGL.GE.MAX1ANG) THEN
        WRITE(LINE
     * ,'('' ERROR: number of angles of monomer >'',I6)') 
     *    MAX1ANG
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF
      L1G_NANGL   = L1G_NANGL+1
      L           = L1G_NANGL
      L1G_1ATM(L) = L1A_ANAME(I1)
      L1G_2ATM(L) = L1A_ANAME(I2)
      L1G_3ATM(L) = L1A_ANAME(I3)
      L1G_I1ATM(L)= I1
      L1G_I2ATM(L)= I2
      L1G_I3ATM(L)= I3
      L1G_VOBS(L) = ANGOBS
      L1G_EVAL(L) = 0.0
      L1G_DEV (L) = 3.0
      CHEM1       = L1A_CHEM(I1)
      CHEM2       = L1A_CHEM(I2)
      CHEM3       = L1A_CHEM(I3)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '

      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                      ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                      ECHEM3.EQ.CHEM1)) THEN
          L1G_VAL(L) = LEG_ANGLE(I) 
          L1G_EVAL(L)= LEG_ANGLE(I) 
          GO TO 100
        ENDIF
      ENDDO
      AENER=0.0
      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        IF(ECHEM1(1:1).EQ.'.'.AND.ECHEM2.EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') AENER = LEG_ANGLE(I)
      ENDDO
      IF(AENER.GT.0.0) THEN
        DD = ABS(90.0-AENER)
        IF(ANGOBS.GT.165.0.AND.DD.LT.1.0) AENER=180.0
        L1G_VAL(L) = AENER 
        L1G_EVAL(L)= AENER
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default angle value will be used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *'                 chem_type : ',CHEM1,'-',CHEM2,'-',CHEM3,' ',
     *AENER,' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),'-',L1A_ANAME(I3),')'
c       CALL MSGDOC(MDOC,LINE)
        GO TO 100
      ENDIF

      IF(ANGOBS.GT.30.0) THEN
        L1G_VAL(L) = ANGOBS
        WRITE(LINE,
     *'('' WARNING : '',A,'' : observed angle value will be used '')')
     *  MON
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *'                 chem_type : ',CHEM1,'-',CHEM2,'-',CHEM3,' ',
     *ANGOBS,' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),'-',L1A_ANAME(I3)
       CALL MSGDOC(MDOC,LINE)
      ELSE
        ANGOBS=109.47
        L1G_VAL(L) = ANGOBS
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default angle value will be used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *'                 chem_type : ',CHEM1,'-',CHEM2,'-',CHEM3,' ',
     *ANGOBS,' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),'-',L1A_ANAME(I3)
c       CALL MSGDOC(MDOC,LINE)
      ENDIF
  100 CONTINUE

      RETURN
      END            

