
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE OPPRO(n_model)
C
C----Subroutine to read parameters of model
C----In the current version this routine uses Alexei's routines
C----to read mmCIF file. 
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'tabfunc.fh'
      INCLUDE 'anom.fh'
      include 'agreem.fh'
      include 'mtz_things.fh'
C
C--Local variables and arrays
      REAL A(4),B(4),CU(2),MO(2)
C
C--Will be deleted
      CHARACTER LINE*128
      CHARACTER FILE_NAME*256
      integer ir,i,j,is,is2,ierr,ia,n_model,cs_nsfatm_temp,ais
      real fp1,fp2
      real, allocatable:: occup_anom_temp(:)
      character CS_ELEMENT_temp(MAXNSF)*4
      integer assig(MAXNSF)
      integer n_atom_tot,i_mod_read
      logical ok,no_fpp,no_fpp_now,empty1
C
C---Read coordinates from mmCIF file
c---first step towards more models. crystal,geometry etc on more models not supported at this stage - 
c---only the first model has it or it is shared (should be sufficient for S(M)IRAS sharing the protein model).
c---data organisation: atomic parameters are separated for different models while atomic type parameters are together.
      cs_nsfatm_temp=0
      IERR = 0
      n_atom_mod_max=0
      n_model = 1
      ligin1 = .true.
      empty1 = .false.
c      ligin1 = .false.
c      if (PPI.eq.'sras'.or.PPI.eq.'sir'.or.PPI.eq.'p+l') n_model = 2
      if (PPI.eq.'sras'.or.PPI.eq.'sir') then
        call num_inp_mod(n_model)
        if (n_model.eq.1) then
          if (.not.substruct_flag) then
            call errwrt(1,'Experiments with isomorphic replacement '//
     &      'require more than 1 model. Please specify the second '//
     &      'model by XYZIN2 keyword. Or if you intended to run '//
     &      'substructure refinement/phasing, please use REFI '//
     &      'SUBStructure YES keyword.')
          else
            empty1=.true.
          endif
        endif
        n_model = 2
      endif
c      n_model = 2
C
c--- reading input models
      do i=n_model,1,-1
        i_mod_read = i
        if (empty1) i_mod_read = i_mod_read-1
        if (i_mod_read.gt.0) then
          IF(REFID.NE.'UNRE') THEN
            CALL MAKECIF_REFMAC(i_mod_read)
          ELSE
            CALL READ_ATOMS_REFMAC(i_mod_read)
          ENDIF
        else
c should change the code so that empty 1. model (ampty models in general) do not lead to errors
c as of now workaround: putting single arbitrary atom (from second model) to the first model.
          n_atom=1
        endif
c add atom type parameters to existing arrays
        if (CS_NSFATM_temp+CS_NSFATM.gt.MAXNSF)   call errwrt(1,
     &     'Too many atom types. Increase MAXNSF and recompile.')
        is2=0
        do is=1,CS_NSFATM
          assig(is)=-1
          do j=1,CS_NSFATM_temp
            if (CS_ELEMENT_temp(j).eq.CS_ELEMENT(IS)) assig(is)=j
          enddo
          if (assig(is).le.0) then
            is2=is2+1
            CS_ELEMENT_temp(IS2+CS_NSFATM_temp) = CS_ELEMENT(IS)
            assig(is)=IS2+CS_NSFATM_temp
          endif
        enddo
        CS_NSFATM_temp=CS_NSFATM_temp+is2
c copy atomic model parameters to separate arrays
        n_atom_mod(i)=n_atom
        if (n_atom.gt.n_atom_mod_max) n_atom_mod_max=n_atom
        do ia=1,n_atom
          occup_mod(ia,i)=occup(ia)
          mult_factor_mod(ia,i)=mult_factor(ia)
          do j=1,3
            xyz_crd_mod(j,ia,i)=xyz_crd(j,ia)
          enddo
          do j=1,6
            u_aniso_mod(j,ia,i)=u_aniso(j,ia)
          enddo
          id_sf_mod(ia,i) = assig(id_sf(ia))
          id_sf(ia) = id_sf_mod(ia,i)
          I_ATOLD_mod(ia,i)=I_ATOLD(ia)
          ATOM_REF_mod_FLAG(ia,i)=ATOM_REF_FLAG(ia)
          ATM_NAME_INP_mod(ia,i)=ATM_NAME_INP(ia)
          ATM_TYPE_mod(ia,i)=ATM_TYPE(ia)
          I_RESID_mod(ia,i)=I_RESID(ia)
          ID_ALT_mod(ia,i)=ID_ALT(ia)
          RES_NAME_mod(I_RESID(ia),i)=RES_NAME(I_RESID(ia))          
          RES_NUM_PDB_mod(I_RESID(ia),i)=RES_NUM_PDB(I_RESID(ia))
        enddo
      enddo
c 
      do is=1,CS_NSFATM_temp
        CS_ELEMENT(IS) = CS_ELEMENT_temp(IS)
      enddo
      CS_NSFATM = CS_NSFATM_temp
C
C
      write(*,*)'Are we here ?'
      IF(BSET_DEFAULT_FLAG) CALL RESET_BVALUES(n_model)
C
C---Treat NCS if it has been defined
      IF(NUMBER_NCSR.GT.0..AND.REFID.EQ.'REST') CALL NCSR_EQUAVALENCES
c      IF(NUMBER_NCSC.GT.0..AND.REFID.EQ.'REST') CALL NCSC_EQUAVALENCES

C
C---Read form factors of atoms. 
      NG    = 5
      NGAUS = 5
      IF(CS_NSFATM.LE.0) CALL ERRWRT(1,'No Scatterers')
      DO    IS=1,CS_NSFATM
        cs_anom(is)=.false.
        IFAIL = -1
        CALL SFREAD2(CS_ELEMENT(IS),NG,A,B,C,IWT,IELEC,CU,
     +              MO,IFAIL)
        IF(IFAIL.LT.0) 
     +       CALL ERRWRT(1,' No match for ATOM ID'//CS_ELEMENT(IS))
        DO   I=1,4
          CS_A(I,IS) = A(I)
          CS_B(I,IS) = B(I)
        ENDDO

        CS_A(5,IS)   = C
        CS_B(5,IS)   = 0.0
c these are Alexei's - not going to be used. 
c        CS_FI(IS)    = 0.
c        CS_FII(IS)   = 0.
        CS_NELEC(IS) = IELEC
c        write(*,*) 'Number of anomalously scattering atom types:',
c     &    nform_ano
      	do  i=1,nform_ano
          if(cs_element(is).eq.ano_elem(i)) then
            cs_anom(is)=.true.
            t2at(is)=i
          endif
        enddo
c if f',f'' not given by user then get it from wavelength by Garib's crossec
        if (.not.cs_anom(is).and.ielec.gt.8) then
c.and.
c     &      (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad)) then
c        if (.not.cs_anom(is).and.ielec.gt.108) then
      	  cs_anom(is) = .true.
      	  nform_ano = nform_ano+1
      	  t2at(is)=nform_ano
      	  ano_elem(nform_ano)=cs_element(is)
      	  do i=1,max(1,dataset_wavenum_tot)
            if (wavelength(i).gt.0) then
      	  	  call wave2fs(cs_element(is),wavelength(i),fp1,fp2,ierr)
      	  	  fprime(nform_ano,i)=fp1
      	  	  f2prime(nform_ano,i)=fp2
c        write(*,*) 'fprimes:',fprime(nform_ano,i),f2prime(nform_ano,i)
            else 
              if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.DPPI_mad)
     +          call errwrt(0,'(at least 1 of) wavelength(s) not known')
      	  	  fprime(nform_ano,i)=0.
      	  	  f2prime(nform_ano,i)=0.
      	  	endif
          enddo
        endif
c for MAD etc cs_a(5,is), fprime(i,j)  will be held separately, for no, SAD etc added to cs_a
        if (cs_anom(is)) then
          if (DPPI_no.or.DPPI_sad.or.DPPI_sadh.or.
     &             DPPI_sir.or.DPPI_sras) then
              do i=1,nform_ano
                 if(cs_element(is).eq.ano_elem(i)) then
                    cs_a(5,is) = cs_a(5,is) + fprime(i,1)
                 endif
              enddo
          endif
        endif
      ENDDO
      n_atom_ano = 0
      n_atom_tot = 0
      do i=1,n_model
        n_atom_tot = n_atom_tot + n_atom_mod(i)
        do  ia=1,n_atom_mod(i)
          if (cs_anom(id_sf_mod(ia,i)))  then
            n_atom_ano = n_atom_ano + 1
c for compatibility reasons only - to be removed later
c          cs_anom(CS_NSFATM+1)=.false.
c          id_sf(n_atom+n_atom_ano)=CS_NSFATM+1
          endif
        enddo
      enddo
c check whether we have something with f'' for anomalous targets
      no_fpp=.false.
      do i=1,dataset_wavenum_tot
        no_fpp_now=.true.
        do  aIS=1,nform_ano
          if (f2prime(ais,i).ne.0.) no_fpp_now=.false.
        enddo
        if (no_fpp_now)  no_fpp=.true.
      enddo
      if ((PPI.eq.'sad'.or.PPI.eq.'sadh'.or.PPI.eq.'sras'
     +  .or.PPI.eq.'mad').and.(n_atom_ano.le.0.or.no_fpp)) then
        call errwrt(-1,'No anomalous scaterrers found in PDB file. '//
     +    'They are required for SAD target.')
        call errwrt(-1,'Have you forgotten to specify them by ANOM '//
     +    'keyword?')
        call errwrt(-1,'Or if you want to produce anomalous maps '//
     +    'without using SAD function then use ANOM MAPOnly keyword')
        call errwrt(1,'No anomalous scaterrers found in PDB file. '//
     +    'Have a look at the end of logfile for more information.')
      endif
      if ((n_atom_ano.le.0.or.no_fpp).and.anom_maponly_flag) then
c        oc_PHDELAN%use = .false.
c        oc_DELFAN%use = .false.
c        call errwrt(-1,'No anomalous scatterers found - difference'//
c     &     ' anomalous difference map coefs will not be outputted')
      endif
c--- the following condition is meant to be the autodetection 
c--- of substructure/very higly incomplete model refinement
      if (substruct_determine.and..not.DPPI_no.and.n_atom_ano.gt.0.
     &  and.n_atom_tot.lt.3*n_atom_ano) then
c        if (dppi_sras)  sigN_calc=3
        substruct_flag = .true.
        call errwrt(-1,'Substructure refinement activated')
      elseif (substruct_flag) then
        call errwrt(-1,'Substructure refinement activated '//
     &    '(on user request)')
      elseif (.not.substruct_flag) then
        call errwrt(-1,'Substructure refinement not activated.')
      endif
c refine individual occupancies for substructure case 
c      if (substruct_flag)   OCCUP_REF_FLAG = .true.
C "activation" of given likelihood target
      if (PPI.ne.'no') THEN
        call activatellhood(PPI,der2der1_flag,derD2der1_flag,
     +     der2heavyder1_flag,substruct_flag,expf_arr,trigf_arr,n_model)
      endif
C
C---Prepare form factors for second derivative matrices
C
C---Make Gaussians for squared atoms to calculate hessians
C
C----First for square of same atoms
C----WARNING!!!!!
C----Here we define only for same atoms convolution. It is
C----enough for diag calculation. For nondiag other kind of convolution
C----should be calculated also
      NGAUS2 = NGAUS*(NGAUS+1)/2
      DO     ISCAT=1,CS_NSFATM
        IGG = 0
        DO     IG1=1,NGAUS
          DO    IG2=IG1,NGAUS
            CC = 2.0
            IF(IG1.EQ.IG2) CC = 1.0
            IGG = IGG+1
            CS_AA(IGG,ISCAT) = CC*CS_A(IG1,ISCAT)*CS_A(IG2,ISCAT)
            CS_BB(IGG,ISCAT) = CS_B(IG1,ISCAT) + CS_B(IG2,ISCAT)
          ENDDO
        ENDDO
      ENDDO
C
C---CIF
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' loop_')
      CALL ERRWRT(-1,'     _atom_type_symbol')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a1')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b1')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a2')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b2')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a3')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b3')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_a4')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_b4')
      CALL ERRWRT(-1,'     _atom_type_scat_Cromer_Mann_c')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
      DO    ISC = 1,CS_NSFATM
         WRITE(LINE,'(2X,A4,9F9.4)')CS_ELEMENT(ISC),(CS_A(II,ISC),
     +                 CS_B(II,ISC),II=1,4),CS_A(5,ISC)
         CALL ERRWRT(-1,LINE)
      ENDDO
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
C
C---Any other things. like check symmetry and so on
C
C---Restraints should be read and prepared here
c      if(excl_refi_flag) then
c        call prepare_excl_refi
c      endif
      IF(REFID.EQ.'REST'.OR.REFID.EQ.'IDEA') then
         CALL READ_RESTR
      ENDIF
C     
C---Read some chemical information about atoms in the coordiante file
      CALL READ_STR_REFMAC(n_model)
c
c---  correct hb type of hydrogens
      call correct_hb_hydrogens(n_model)
C
c---Preparation for anomolous refinement if needed
      occup_anom(1:n_atom) = occup(1:n_atom)
      u_anom(1:6,1:n_atom) = u_aniso(1:6,1:n_atom)
      do i=1,n_model
        occup_anom_mod(1:n_atom_mod(i),i) = occup_mod(1:n_atom_mod(i),i)
        u_anom_mod(1:6,1:n_atom_mod(i),i) = 
     &    u_aniso_mod(1:6,1:n_atom_mod(i),i)
      enddo
c testing anom occ reading in - assuming the same number of anomalous in the same order in the input file
      if (read_anom_occ_flag) then
        allocate(occup_anom_temp(n_atom_ano))
        call read_anomocc(occup_anom_temp,n_atom_ano,ok)
        is=1
        do i=1,n_atom
          if (cs_anom(id_sf(i)).and.ok) then
            occup_anom(i)=occup_anom_temp(is)
            occup_anom_mod(i,1)=occup_anom_temp(is)
            is=is+1
c            write(*,*)'qqqqqqqqqqqq',occup_anom(i)
          endif
        enddo
        deallocate(occup_anom_temp)
      endif
 
c---  sort out input ADPs
c      call sort_out_messy_adp

      RETURN
      END
C
      SUBROUTINE RESET_BVALUES(nmodel)
C
C---Sets B values to predefined values. Could be extended to reset
C---b values for predefined residues or atoms (using atom selection)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'models.fh'
      INCLUDE 'refi_flags.fh'
C
      integer nmodel
      INTEGER IA,i,im
C
      do im=1,nmodel
        DO   IA = 1,N_ATOM_mod(im)
          IF(U_ANISO_mod(2,IA,im).LE.0.0) THEN
C
C---Isotropic atom
            if (im.eq.1) U_ANISO(1,IA) = UDefault_Ind
            U_ANISO_mod(1,IA,im) = UDefault_Ind
          ELSE
            do i=1,6
              if (im.eq.1) U_ANISO(i,IA) = UDefault_Ind
              U_ANISO_mod(i,IA,im) = UDefault_Ind
            enddo
          ENDIF
        ENDDO
      enddo

      RETURN
      END
C
      SUBROUTINE CHECK_SYMMETRY(NSPGRP,SPGRP,NSYM_IN,ROT_IN,VECT_IN,
     &                 IERROR)
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INTEGER NSPGRP,IERROR,NSYM_IN
      REAL ROT_IN(3,3,*),VECT_IN(3,*)
      CHARACTER SPGRP*(*)

      INTEGER I,J,IS
      INTEGER LENSTR

      IERROR = 0
C
C--First check if space group numbers are same
C
      IF(ISPNO.LT.1.AND.NSPGRP.GE.1) THEN
C
C---Symmetry has not been defined previously. Use new symmetry
        DO    IS=1,NSYM_IN
          DO   J=1,3
            DO   I=1,3
              RealSymmMatrx(I,J,IS) = ROT_IN(I,J,IS)
            ENDDO
            RealSymmMatrx(J,4,IS) = VECT_IN(J,IS)
            RealSymmMatrx(4,J,IS) = 0.0
          ENDDO
          RealSymmMatrx(4,4,IS) = 1.0
        ENDDO
        NumSymmetry = NSYM_IN
        ISPNO = NSPGRP
        SpaceGroupName = SPGRP(1:LENSTR(SPGRP))
        IERROR = 0
        RETURN
      ELSEIF(ISPNO.GT.1.AND.NSPGRP.LE.1) THEN
C
C---There is no new symmetry. But old symmetry has been defined. Use old
C---symmetry
        DO   IS=1,NumSymmetry
          DO    J=1,3
            DO   I=1,3
              ROT_IN(I,J,IS) = RealSymmMatrx(I,J,IS)
            ENDDO
            VECT_IN(J,IS) = RealSymmMatrx(J,4,IS)
          ENDDO
        ENDDO
        NSYM_IN = NumSymmetry
        NSPGRP = ISPNO
        SPGRP  = SpaceGroupName(1:LENSTR(SpaceGroupName))
        IERROR = 1
        RETURN
      ELSEIF(ISPNO.NE.NSPGRP) THEN
C
C---Space group names are different. It is serious error
        IERROR = 2
        RETURN
      ELSE
C
C---Space group number is same. Check and make other parameters
c---of symmetry consistent with each other

      ENDIF

      END
C
      SUBROUTINE CHECK_CELL(CELL_IN,IERROR)
C
c---this routine checks if new cell and that from celsym.fh (previously
C---read cell) are consistent.If not then changes cell parameters accordingly
      IMPLICIT NONE
      INCLUDE 'celsym.fh'

      INTEGER IERROR
      REAL CELL_IN(6)
C
C---local varaibles
      INTEGER I
      REAL DELTA_C,DELTA_A,DENUM_C,DENUM_A,EPS_LOCAL,CELL_TOL1,
     &     DELTA_C1,CELL_TOL2
      REAL DEGTOR
      DATA EPS_LOCAL/1.0E-8/,CELL_TOL1/0.01/,CELL_TOL2/0.1/
      DATA DEGTOR/0.017453293/
C
c---Makecif wants cell angles in radians
      IF(CELL(4).GT.5.0.AND.CELL(5).GT.5.0.AND.CELL(6).GT.5.0) THEN
        CELL(4) = CELL(4)*DEGTOR
        CELL(5) = CELL(5)*DEGTOR
        CELL(6) = CELL(6)*DEGTOR
      ENDIF
C
      IF(CELL_IN(4).GT.5.0.AND.CELL_IN(5).GT.5.0
     &                    .AND.CELL_IN(6).GT.5.0) THEN
         CELL_IN(4) = CELL_IN(4)*DEGTOR
         CELL_IN(5) = CELL_IN(5)*DEGTOR
         CELL_IN(6) = CELL_IN(6)*DEGTOR
      ENDIF
C
C---First check if we have already cell
      IERROR = 0
      DELTA_C = CELL_IN(1)**2 + CELL_IN(2)**2 + CELL_IN(3)**2+
     &          CELL_IN(4)**2 + CELL_IN(5)**2 + CELL_IN(6)**2
      DELTA_C1 = CELL(1)**2 + CELL(2)**2 + CELL(3)**2+CELL(4)**2
     &         +CELL(5)**2 + CELL(6)**2
      IF(SQRT(DELTA_C).LE.EPS_LOCAL) THEN
C
C---There is no cell parameters. Use old ones
        IERROR = 1
        DO   I=1,6
          CELL_IN(I) = CELL(I)
        ENDDO
      ELSEIF(DELTA_C1.LE.EPS_LOCAL) THEN
C
C---There was no cell. Use new one
        IERROR = 1
        DO   I=1,6
          CELL(I) = CELL_IN(I)
        ENDDO
      ELSE
C
C---We had cell. Now check if they agree
        DELTA_C = SQRT((CELL(1)-CELL_IN(1))**2 + (CELL(2)-CELL_IN(2))**2
     &                +(CELL(3)-CELL_IN(3))**2)
        DENUM_C = AMAX1(CELL(1),CELL_IN(1))+AMAX1(CELL(2),CELL_IN(2))+
     &            AMAX1(CELL(3),CELL_IN(3))
        DELTA_A = SQRT((CELL(4)-CELL_IN(4))**2 + (CELL(5)-CELL_IN(5))**2
     &                +(CELL(6)-CELL_IN(6))**2)
        DENUM_A = AMAX1(CELL(4),CELL_IN(4))+AMAX1(CELL(5),CELL_IN(5))+
     &            AMAX1(CELL(6),CELL_IN(6))
        IF(DELTA_C/DENUM_C.LE.CELL_TOL1.AND.
     &     DELTA_A/DENUM_A.LE.CELL_TOL1) THEN
C
c---Difference in cell dimensions is less than 1%. No worries. Make them 
C---equal
          IERROR = 0
          DO    I=1,6
            CELL_IN(I) = CELL(I)
          ENDDO
        ELSEIF(DELTA_C/DENUM_C.LE.CELL_TOL2.AND.
     &         DELTA_A/DENUM_A.LE.CELL_TOL2) THEN
C
C---Difference is less than 10 more than 1%. Use previous cell. 
          IERROR = 2
          DO    I=1,6
            CELL_IN(I) = CELL(I)
          ENDDO
        ELSE
C
C---Difference is more than 10%. Use previous cell. But it is serious. 
C---Outside this routine error should be reported
          IERROR = 3
          DO   I=1,6
            CELL_IN(I) = CELL(I)
          ENDDO
        ENDIF
      ENDIF
      RETURN
      END
C
      subroutine num_inp_mod(num)
      implicit none
c      
      integer num,ll
      INTEGER LENSTR
      EXTERNAL LENSTR
      character string_model*3, IN_COORD_FILE*256
c
      num=0
      ll=0
      string_model=' '
      IN_COORD_FILE='start'
      do while (IN_COORD_FILE.ne.' ')
        num=num+1
        if (num.gt.1) then
          call itoa(num,string_model,3)
          ll=lenstr(string_model)
        endif
        CALL UGTENV('XYZIN'//string_model(1:ll),IN_COORD_FILE)
      enddo
      num=num-1
      return
      end

      SUBROUTINE MAKECIF_REFMAC(model)
C
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
C
C---This routine calls makecif. makecif reads coordinate file
C---and creates restraint list. If hydrogens should be restored
C---then makecif is called twice. First call to find positions
C---of hydrogens and second call to find restraint list. Same is
C---if any other absent atoms needed to be restored.
      integer model
      REAL CELL_C(6)
      CHARACTER IN_COORD_FILE*256,SCRATCH*256,
     &          OUT_FILE_CIF*256,MAKE_PROG_NAME*20,LIST_MAKE*1
      CHARACTER DICT_PATH*250
      CHARACTER MAKE_FSTOP*1
      INTEGER IERR,MDOC,IN_FILE,IFAIL,LL,NSPGRP,I,IUNIT,IERROR,IRUN
      LOGICAL LEXISTS
      INTEGER LENSTR
      EXTERNAL LENSTR
      character string_model*3

      IRUN = 1
      MDOC = -999
      if (model.gt.1) then
        call itoa(model,string_model,3)
        ll=lenstr(string_model)
        CALL UGTENV('XYZIN'//string_model(1:ll),IN_COORD_FILE)
        if (IN_COORD_FILE.eq.' ')  call errwrt(1,'Model '//
     &    string_model(1:ll)//' must be given (by XYZIN'//string_model)
      else
        CALL UGTENV('XYZIN',IN_COORD_FILE)
      endif
      call find_unique_file_name(out_file_cif,'_new')
      MAKE_PROG_NAME    = 'refmac'
      call ugtenv('LIB_BALBES',DICT_PATH)
      if(DICT_PATH.eq.' ') CALL UGTENV('CLIBD_MON',DICT_PATH)
      IF(DICT_PATH.EQ.' ') CALL UGTENV('CDIC_REFMAC',DICT_PATH)
      IF(DICT_PATH.EQ.' ') THEN
cpjx  MAKECIFLIB would be set in temp_makecif_path.fh
cpjx  but this is unsafe e.g. portability problems.
cpjx        MAKE_PROG_LIB_PATH = MAKECIFLIB(1:LENSTR(MAKECIFLIB))
cpjx  Instead fail if the dictionary path isn't set
        CALL errwrt(1,'No path for dictionary files!')
      ELSE
        MAKE_PROG_LIB_PATH =DICT_PATH(1:LENSTR(DICT_PATH))
      ENDIF
C
C---If we have cell and symmetry then use it
      NSPGRP = ISPNO
      DO   I=1,6
         CELL_C(I) = 0.0
      ENDDO
      IF(CELL(1)*CELL(2)*CELL(3).GT.1) THEN
         DO  I=1,6
           CELL_C(I) = CELL(I)
         ENDDO
        IF(CELL(4).LT.5.0.OR.CELL(5).LT.5.0
     &                    .OR.CELL(6).LT.5.0) THEN
          CELL_C(4) = CELL_C(4)/DEGTOR
          CELL_C(5) = CELL_C(5)/DEGTOR
          CELL_C(6) = CELL_C(6)/DEGTOR
        ENDIF
      ENDIF
      LIST_MAKE = 'M'
      CALL UGTENV('LIBIN',MAKE_FILE_LIB2)
      IF(MAKE_FILE_LIB2.EQ.' ') CALL UGTENV('LIB_IN',MAKE_FILE_LIB2)

      CALL UGTENV('LIBOUT',MAKE_LIB_OUT)
      if(make_lib_out.eq.' ') 
     &     call find_unique_file_name(make_lib_out,'_lib.cif')
      IF(MON_STYLE.EQ.'MANY') LIST_MAKE = 'L'
C
c---Undocumented option.
      IF(MON_STYLE.EQ.'TEST') LIST_MAKE = 'T'
      MAKE_NEW_FLAG = ' '
      IERR          = 0
      CALL MAKECIF(MDOC,IN_COORD_FILE,OUT_FILE_CIF,MAKE_FILE_LIB2
     *  ,MAKE_CUTOFF,MAKE_DMIN_SPEC,MAKE_CONN_FLAG,MAKE_CIS_FLAG
     &  ,MAKE_LNK_FLAG,MAKE_CHAIN_FLAG,MAKE_PEPT_FLAG,MAKE_CHECK_SPEC
     &  ,MAKE_HFLAG,MAKE_RFLAG,MAKE_FORM,MAKE_SYMM_FLAG,MAKE_SS_FLAG
     &  ,MAKE_SUGAR_FLAG,LIST_MAKE,MAKE_CHECK,MAKE_NEWL_VALUE_FLAG
     &  ,MAKE_SRCH_FLAG
     &  ,make_segid_in_flag,MAKE_PROG_LIB_PATH,MAKE_LIBS_PATH
     &  ,MAKE_LIBS_NAME,MAKE_LIBS_EXT
     &  ,MAKE_PROG_NAME,NSPGRP,CELL_C,MAKE_LIB_OUT,MAKE_NEW_FLAG
     &  ,MAKE_FSTOP,IERR)
C
C---Check if cell parameters from mtz and from pdb are consistent.
      CALL CHECK_CELL_FROM_MAKECIF(IERR)

C
      DO   I=1,6
        CELL_C(I) = 0.0
      ENDDO
      IF(N_ATOM.LE.0) THEN
        CALL ERRWRT(-1,'Number of atoms in the input file is 0')
        CALL ERRWRT(-1,'Input pdb file seems to be empty')
        CALL ERRWRT(1,'Check input coordinates')
      ENDIF
      IF(N_ATOM.GT.MAXATOM) THEN
        CALL ERRWRT(-1,'Too many atoms in the input coordinate file')
        CALL ERRWRT(-1,'It may happen because of hydrogen generations')
        CALL ERRWRT(-1,'Change MAXATOM in "atom_com.fh" and recompile'
     &    //' the program')
        CALL ERRWRT(1,'Too many atoms in the input file')
      ENDIF
      IF(IERR.EQ.6) THEN
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is an error in the input coordinate file')
        CALL ERRWRT(-1,'At least one the chains has 2 residues with the'
     &    //' same number')
        CALL ERRWRT(-1,'Check above to see error')
        CALL ERRWRT(1,'Problem with coordinate file')
      ENDIF
C
C---Exit if nothing else is required
cd      IF(MAKE_LIGAND_LEVEL_FLAG.EQ.'H'.AND.MAKE_NEW_FLAG.EQ.'Y') THEN
      IF(MAKE_LIGAND_LEVEL_FLAG.EQ.'H'.AND.MAKE_FSTOP.EQ.'Y') THEN
        CALL WRITE_ATOMS_REFMAC(model)
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'Important, Important, Important!!!!!')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'Your coordinate file has a ligand which has'
     &    //' either minimum or no description in the library')
        CALL ERRWRT(-1,'A new ligand description has been added to '//
     &      MAKE_LIB_OUT(1:LENSTR(MAKE_LIB_OUT)))
        CALL ERRWRT(-1,'Picture of the new ligand can be viewed using '
     &   //'postscript file. See above')
        CALL ERRWRT(-1,'Check description in this file and, if'
     &    //' satisfied, use it as the input library')
        CALL ERRWRT(-1,'Otherwise either edit bond orders manually'
     &    //' or use CCP4i Sketcher to view and edit the ligand')
        CALL ERRWRT(-1,'and create a library entry by running libcheck')
        CALL ERRWRT(-1,'It is strongly recommended that dictionary '
     &   //' entry should be checked carefully before using it')
        CALL ERRWRT(-1,'If you are happy with the library description '
     &   //'then use the keyword (MAKE CHECK NONE)')
        CALL ERRWRT(-1,'I.e. do not check correctness'
     &   //' of the coordinates ')
C
C---Something about postscript file
        CALL errwrt(1,'New ligand has been encountered. Stopping now')
      ELSEIF(MAKE_NEW_FLAG.EQ.'Y'.AND.MAKE_FSTOP.EQ.'Y') THEN
        MAKE_FILE_LIB2 = MAKE_LIB_OUT
        call find_unique_file_name(make_lib_out,'_lib1.cif')
        ierr = 0
        write(*,*)make_file_lib2
      ENDIF
      
C
C---General errors
      IF(IERR.GT.0) THEN
        WRITE(*,*)'IERR = ',IERR
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is error. See above')
        CALL ERRWRT(1,'Fatal error. Cannot continue')
      ENDIF
      IF(MAKE_HFLAG.NE.'A'.AND.MAKE_RFLAG.NE.'Y') GOTO 200
      STRUCT_FILE    = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.str'
      INQUIRE (FILE=STRUCT_FILE(1:LENSTR(STRUCT_FILE)),EXIST=LEXISTS)
      IF(LEXISTS) THEN
         call open_unform_file(iunit,struct_file,ierr)
         close(iunit,status='DELETE')
      ENDIF
C
c---Do not run second time if no hydrogens are needed
      IRUN = IRUN + 1
C
C---Now check if space group and symmetry were present in the coordinate file   
      LIST_MAKE = 'S'
      IF(MAKE_HFLAG.EQ.'A') MAKE_HFLAG = 'Y'
      IF(MAKE_RFLAG.EQ.'Y') MAKE_RFLAG = 'N'
      MAKE_CHECK     = '0'
      MAKE_CONN_FLAG = '0'
      MAKE_LNK_FLAG  = '0'
      IERR       = 0
      IN_COORD_FILE = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.crd'
      call find_unique_file_name(out_file_cif,'_new1')
      CALL MAKECIF(MDOC,IN_COORD_FILE,OUT_FILE_CIF,MAKE_FILE_LIB2
     &  ,MAKE_CUTOFF,MAKE_DMIN_SPEC,MAKE_CONN_FLAG,MAKE_CIS_FLAG
     &  ,MAKE_LNK_FLAG,MAKE_CHAIN_FLAG,MAKE_PEPT_FLAG,MAKE_CHECK_SPEC
     &  ,MAKE_HFLAG,MAKE_RFLAG,MAKE_FORM,MAKE_SYMM_FLAG,MAKE_SS_FLAG
     &  ,MAKE_SUGAR_FLAG,LIST_MAKE,MAKE_CHECK,MAKE_NEWL_VALUE_FLAG
     &  ,MAKE_SRCH_FLAG
     &  ,make_segid_in_flag,MAKE_PROG_LIB_PATH,MAKE_LIBS_PATH
     &  ,MAKE_LIBS_NAME,MAKE_LIBS_EXT
     &  ,MAKE_PROG_NAME,NSPGRP,CELL_C,MAKE_LIB_OUT,MAKE_NEW_FLAG
     &  ,MAKE_FSTOP,IERR)
      IF(IERR.GT.0) THEN
        WRITE(*,*)'IERR = ',IERR
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is error. See above')
        CALL ERRWRT(1,'Fatal error. Cannot continue')
      ENDIF
C
C---Delete intermediate file.
 200  CONTINUE
      IF(MAKE_EXIT.EQ.'Y') THEN
        CALL WRITE_ATOMS_REFMAC(model)
        CALL ERRWRT(-1,'Restraints file: '
     &     //OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.rst')
        CALL ERRWRT(-1,'mmCIF file     : '
     &     //OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.crd')
        CALL ERRWRT(-1,'Connectivity file: '
     &     //OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.str')
        CALL CCPERR(0,'After Makecif')
      ENDIF
      IF(IRUN.GT.1) THEN
         call open_form_file(in_file,in_coord_file,ierr)
        CLOSE (UNIT=IN_FILE,STATUS='DELETE')
      ENDIF
      call open_form_file(in_file,out_file_cif,ierr)
      CLOSE (UNIT=IN_FILE,STATUS='DELETE')
C
C---Find name of necessary files for future use.
      RESTRAINT_FILE = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.rst'
      STRUCT_FILE    = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.str'
      COORD_FILE     = OUT_FILE_CIF(1:LENSTR(OUT_FILE_CIF))//'.crd'
C
C---Process and change some of the parameters (e.g. xyz 9999.000 occ = 0)
C
      call process_strange_pdb_r(model)
C
cd      CALL MAKECIF_SYMMCOPY
C
      RETURN
      END
C

      SUBROUTINE CHECK_CELL_FROM_MAKECIF(IERR)
C
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER IERR
      INTEGER ISYM,I,J
C
C
C---Check if cell parameters from mtz and from pdb are consistent.
cd      WRITE(*,*)'IERR = ',IERR,CS_NSPGR
cd      STOP
      if(cs_nsym.le.0) then
        call errwrt(1,'Unrecognised space group')
      endif
      IF(IERR.EQ.7) THEN
        CALL ERRWRT(-1,'Input coordinate does not have CRYST card')
        CALL ERRWRT(-1,'Check the input coordinate file')
        CALL ERRWRT(1,'Input coordinate file is not complete')
      ENDIF
      IF(IERR.EQ.9) THEN
         CALL ERRWRT(-1,
     &        'Inpit coordinate file does not have CRYST card')
         CALL ERRWRT(-1,'Coordinate file must have cryst card')
         CALL ERRWRT(-1,
     &        'Check if your coordinates and mtz correspond each other')
         CALL ERRWRT(1,'Problem with cell dimensions')
      ENDIF

      IF(IERR.EQ.10) THEN
        CALL ERRWRT(-1,
     &        'Large differences between cells from pdb and mtz')
        CALL ERRWRT(-1,
     &        'Check if coordinate file corresponds to this mtz file')
        CALL ERRWRT(1,'Disagreement between mtz and pdb')
      ENDIF
C
C---Copy symmetry back to RealSymm.
cd      stop
      ISPNO  = CS_NSPGR
      NumSymmetry = CS_NSYM
      DO    ISYM=1,CS_NSYM

        DO   J=1,3
          DO   I=1,3
            RealSymmMatrx(I,J,ISYM) = CS_M_CS(I,J,ISYM)
          ENDDO
          RealSymmMatrx(J,4,ISYM) = CS_V_CS(J,ISYM)
          RealSymmMatrx(4,J,ISYM) = 0.0
        ENDDO
      ENDDO
C
C---Oder of symmetry may have changed. Take precautions
      DO    ISYM=1,NumSymmetry
        DO    I=1,3
           DO    J=1,3
            ROT(I,J,ISYM) = RealSymmMatrx(I,J,ISYM)
          ENDDO
          TR(I,ISYM)   = RealSymmMatrx(I,4,ISYM)
        ENDDO
      ENDDO
      NSYM  = NumSymmetry
      CALL TKNONCUB

C
C---Copy cells also
      DO   I=1,6
         CELL(I) = CS_CELL(I)
      ENDDO
      RETURN
      END
C
      SUBROUTINE READ_ATOMS_REFMAC(model)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      include 'makecif.fh'

C
C----This routine reads coordinate file. Input file could be in mmcif
C----or pdb format. This routine will normally be called in unrestrained
C----refinement mode
C
      REAL CELL_C(6)
      CHARACTER FILE_TYPE_FLAG*1,PEPT_FLAG*1,IN_COORD_FILE*256,EXT*10,
     &          PATH*10
      INTEGER MDOC,IERR,LEN,NSPGRP,I,ll,model
      INTEGER LENSTR
      CHARACTER OUT_FILE_CRD*256
      CHARACTER H_R*1
      character string_model*3

      CALL UGTENV('XYZOUT',OUT_FILE_CRD)
      IF(OUT_FILE_CRD.EQ.' ') THEN
         CALL ERRWRT(0,' No output coordinate file has been defined')
         CALL ERRWRT(0,' Output coordinates will be written to XYZOUT')
         OUT_FILE_CRD = 'XYZOUT'
      ENDIF
C
      if (model.gt.1) then
        call itoa(model,string_model,3)
        ll=lenstr(string_model)
        CALL UGTENV('XYZIN'//string_model(1:ll),IN_COORD_FILE)
        if (IN_COORD_FILE.eq.' ')  call errwrt(1,'Model '//
     &    string_model(1:ll)//' must be given (by XYZIN'//string_model)
      else
        CALL UGTENV('XYZIN',IN_COORD_FILE)
        IF(IN_COORD_FILE.EQ.' ') IN_COORD_FILE = 'XYZIN'
      endif
C
c---Check if input file has pdb or mmcif format
      CALL PDB_OR_CIF(MDOC,IN_COORD_FILE,FILE_TYPE_FLAG,IERR)
C
C =============================================
C
C     read coord input file 
C
      MDOC      = -999
      EXT       = ' '
      PATH      = ' '
      PEPT_FLAG = 'N'
      IERR      = 0
      NSPGRP    = ISPNO
      DO   I=1,6
        CELL_C(I) = 0.0
      ENDDO
      IF(CELL(1)*CELL(2)*CELL(3).GT.1) THEN
         DO  I=1,6
           CELL_C(I) = CELL(I)
         ENDDO
        IF(CELL(4).LT.5.0.OR.CELL(5).LT.5.0
     &                    .OR.CELL(6).LT.5.0) THEN
          CELL_C(4) = CELL_C(4)/DEGTOR
          CELL_C(5) = CELL_C(5)/DEGTOR
          CELL_C(6) = CELL_C(6)/DEGTOR
        ENDIF
      ENDIF
      CALL INIT_ATM_INF(MDOC,IERR)
      CALL INIT_DEFAULTS

      IERR = 0
      IF(FILE_TYPE_FLAG.EQ.'P') THEN
C       ---  read PDB_file.
C       make_PDB.f
        H_R = 'Y'
        CALL GET_PDB(MDOC,IN_COORD_FILE,NSPGRP,CELL_C,PEPT_FLAG,
     &        make_segid_in_flag,H_R,IERR)    
        IF(IERR.EQ.7.OR.IERR.EQ.9) THEN
          CALL ERRWRT(-1,'Input coordinate does not have CRYST card')
          CALL ERRWRT(-1,'Check the input coordinate file')
          CALL ERRWRT(1,'Input coordinate file is not complete')
        ENDIF
        IF(IERR.EQ.10) THEN
          CALL ERRWRT(-1,
     &        'Large differences between cells from pdb and mtz')
          CALL ERRWRT(-1,
     &        'Check if coordinate file corresponds to this mtz file')
          CALL ERRWRT(1,'Disagreement between mtz and pdb')
        ENDIF
      ELSE
        LEN =  LENSTR(IN_COORD_FILE)
        IF(LEN.GT.0.AND.IN_COORD_FILE(1:1).NE.' '.AND.
     *    IN_COORD_FILE(1:1).NE.',') THEN
C          --- read CIFile.
C         read_CIF.f
          CALL READ_ATOMS(MDOC,PATH,IN_COORD_FILE,EXT,NSPGRP,CELL_C,
     &                  IERR)
         CALL CHECK_CELL_FROM_MAKECIF(IERR)
        ELSE
          GOTO 100
        ENDIF
      ENDIF
      IERR = 0
      RETURN
 100  CONTINUE
      CALL ERRWRT(1,'Reading coordinate file')
      END
C
      SUBROUTINE WRITE_ATOMS_REFMAC(model)
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'makecif.fh'
      include 'tls.fh'
      include 'anom.fh'
      integer model
      INTEGER IOUT,IERR,MDOC,IA
      INTEGER LENSTR
      CHARACTER OUT_FILE_CRD*256,E*10,PATH*10
      integer eps_l,ll,j,iresid,nim,filemodel
      logical tls_exists,linitial
      character string_model*3

      filemodel=model
      call num_inp_mod(nim)
      if ((PPI.eq.'sras'.or.PPI.eq.'sir').and.nim.eq.1) then
        if (model.eq.1) goto 999
        filemodel=model-1
      endif
c
      if (filemodel.gt.1) then
        call itoa(filemodel,string_model,3)
        ll=lenstr(string_model)
        CALL UGTENV('XYZOUT'//string_model(1:ll),OUT_FILE_CRD)
        if (OUT_FILE_CRD.eq.' ')  then
          call errwrt(-1,'Model '//
     &    string_model(1:ll)//' output file not given - '//
     &    'XYZOUT'//string_model(1:ll)//' will be used')
          OUT_FILE_CRD = 'XYZOUT'//string_model(1:ll)
        endif
      else
        CALL UGTENV('XYZOUT',OUT_FILE_CRD)
        IF(OUT_FILE_CRD.EQ.' ') OUT_FILE_CRD = 'XYZOUT'
      endif
      
      IOUT = 0
      PATH = ' '
      E    = ' '
      MDOC = -999
      eps_l = 1.0e-8
C
C---Write in a pdb format
      tls_exists = .FALSE.
      linitial  = .FALSE.
      if(ntlsgrp.gt.0) then
         if(maxval(abs(tmat(1:6,1:ntlsgrp)))+
     &        maxval(abs(lmat(1:6,1:ntlsgrp)))+
     &        maxval(abs(smat(1:8,1:ntlsgrp))).gt.eps_l) 
     &        tls_exists = .TRUE.
      endif
      if(tls_add_atoms.and.tls_exists) then
         call tls2anisou(linitial)
      endif
      DO   IA=1,N_ATOM_mod(model)
        IF(U_ANISO_mod(2,IA,model).NE.0.0) THEN
          B_FLAG(IA) = IA
        ENDIF
      ENDDO
      CALL OPENFW(IOUT,MDOC,PATH,OUT_FILE_CRD,E,IERR)
      IF(IERR.GT.0) THEN
         CALL ERRWRT(1,'Problem with output coordinate file')
      ENDIF
      CLOSE(IOUT)
      if (model.gt.1) then
        do ia=1,n_atom_mod(model)
          occup(ia)=occup_mod(ia,model)
          mult_factor(ia)=mult_factor_mod(ia,model)
          do j=1,3
            xyz_crd(j,ia)=xyz_crd_mod(j,ia,model)
          enddo
          do j=1,6
            u_aniso(j,ia)=u_aniso_mod(j,ia,model)
          enddo
          ATOM_REF_FLAG(ia)=ATOM_REF_mod_FLAG(ia,model)
          id_sf(ia)=id_sf_mod(ia,model)
          I_ATOLD(ia)=I_ATOLD_mod(ia,model)
          ATM_NAME_INP(ia)=ATM_NAME_INP_mod(ia,model)
          ATM_TYPE(ia)=ATM_TYPE_mod(ia,model)
          I_RESID(ia)=I_RESID_mod(ia,model)
          ID_ALT(ia)=ID_ALT_mod(ia,model)
          RES_NAME(I_RESID(ia)) = RES_NAME_mod(I_RESID(ia),model)
          RES_NUM_PDB(I_RESID(ia))=RES_NUM_PDB_mod(I_RESID(ia),model)
        enddo
        n_atom=n_atom_mod(model)
c??? do I have put back the parameters for model 1 to the arrays if more models? 
c is something going to use it again?  not doing it as of now 
      endif
      CALL WRITE_ATOMS_PDB(MDOC,MAKE_HFLAG_O,MAKE_DEPOS,
     &     make_segid_out_flag,PATH,
     &                       OUT_FILE_CRD,E,IERR)

cd      CALL WRITE_ATOMS(MDOC,PATH,OUT_FILE_CRD,E,IERR)
c
c---Add here CIF format
c
  999 continue
      RETURN
      END
C
      SUBROUTINE READ_RESTR
C
c---This routine reads list of restraint from MAKECIF and writes into 
C---separate unformatted files for further use
C
      IMPLICIT NONE
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'restr_params.fh'

      INTEGER MAXPLN_ATOM
      PARAMETER (MAXPLN_ATOM = 50)
      integer ia1(4)
      INTEGER IS_LOCAL,IS_LOCAL1,IS_LOCAL2,IS_LOCAL3
      integer MD,IN,ISCRB,ISCRA,ISCRT,ISCRC,ISCRP
      INTEGER NR_BOND,NR_ANGL,NR_TORS,NR_CHIR,NR_PLAN,IEND,NREST
      integer NA_PLAN
      integer nb,na,nt,nc,np,na_p,nmaxatom_plane
      integer nr_bond1
c
      integer is_t(4,200)

      integer, allocatable :: ia1_b(:,:)
      integer, allocatable :: is_bond(:,:)
      integer, allocatable :: ia1_a(:,:)
      integer, allocatable :: ia1_t(:,:)
      integer, allocatable :: itors_period(:)
      integer, allocatable :: itor_flag(:)
      integer, allocatable :: ia1_c(:,:)
      integer, allocatable :: ichir_sign(:)
      integer, allocatable :: ia1_p(:,:)
      integer, allocatable :: nplane(:)

      real,    allocatable :: rs_vidl_b(:,:)
      real,    allocatable :: rs_vidl_a(:,:)
      real,    allocatable :: rs_vidl_t(:,:)
      real,    allocatable :: rs_vidl_c(:,:)
      real,    allocatable :: rs_vidl_p(:,:)
      character*8, allocatable :: tors_label(:)

      REAL SIGN_CHIR
      INTEGER N_REMAIN_ARRAY
c
      INTEGER IERROR
      INTEGER LENSTR
      REAL FIND_CHIR_SIGN
      EXTERNAL LENSTR,FIND_CHIR_SIGN

      INTEGER LL,IFAIL,IR,RS_NUM_OLD,NREAD,MODE,IPL,IERR,
     &        I,J,JRS
      CHARACTER PATHR*10,EXTR*10,THIS_ALT*1
      character chnamp1*4
      LOGICAL APPLY_OK
C
      MD  = 0
      IN  = 0
      PATHR = ' '
      EXTR = ' '
      IERR = 0

C
C---Output files
      ISCRB = 0
      ISCRA = 0
      ISCRT = 0
      ISCRC = 0
      ISCRP = 0
      IS_LOCAL = 0
      IS_LOCAL1 = 0
      IS_LOCAL2 = 0
      IS_LOCAL3 = 0

      IFAIL = 0
      LL    = 0
      call find_unique_file_name(bond_file,'_BOND_R')
      call open_unform_file(iscrb,bond_file,ierr)

      call find_unique_file_name(angle_file,'_ANGL_R')
      call open_unform_file(iscra,angle_file,ierr)

      call find_unique_file_name(tors_file,'_TORS_R')
      call open_unform_file(iscrt,tors_file,ierr)

      call find_unique_file_name(chir_file,'_CHIR_R')
      call open_unform_file(iscrc,chir_file,ierr)

      call find_unique_file_name(plane_file,'_plane_R')
      call open_unform_file(iscrp,plane_file,ierr)

C
C---Initialise. Number of different restraint types is 0
      NR_BOND     = 0
      NR_ANGL     = 0
      NR_TORS     = 0
      NR_CHIR     = 0
      NR_PLAN     = 0
      RS_NUM_OLD  = -1
      IEND        = 0
      NREST       = 0
      NA_PLAN     = 0
      NREAD       = 0
      ierr        = 0
      CALL ORRST_CIF(MD,IN,PATHR,RESTRAINT_FILE,EXTR,IERR)

      IF(IERR.EQ.100) THEN
c
c--No restraints. We need to write empty restraints file and return
         CLOSE(UNIT=IN,STATUS='DELETE')
         write(iscrb)nr_bond
         close(iscrb)
         na = 0
         write(iscra)na
         close(unit=iscra)
         np = 0
         nmaxatom_plane = 0
         write(iscrp)np,nmaxatom_plane
         close(unit=iscrp)
         nc = 0
         write(iscrc)nc
         close(unit=iscrc)
         nt = 0
         write(iscrt)nt
         close(unit=iscrt)
         call read_psuedorest
         call read_harm_et_al
         RETURN
       END IF
      IERR        = 0
cd      MD          = -999
C
C---Start reading restraints. If there is new restraint return here
c
c---First read and define sizes
      iend = 0
      na_plan = 0
      nmaxatom_plane = 0
      call rdrst_cif(md,in,mode,iend,ierr)
      do while(iend.eq.0)
         if(mode.eq.0) then
            if(rs_name.eq.'BOND'.or.rs_name.eq.'BNDS') then
               nr_bond = nr_bond + 1
            elseif(rs_name.eq.'ANGL') then
               nr_angl = nr_angl+1
            elseif(rs_name.eq.'TORS') then
               nr_tors = nr_tors + 1
            elseif(rs_name.eq.'CHIR') then
               nr_chir = nr_chir + 1
            elseif(rs_name.eq.'PLAN') then
               if(rs_num_old.ne.rs_num) then
                  nmaxatom_plane = max(nmaxatom_plane,na_plan)
                  nr_plan = nr_plan + 1
                  na_plan = 1
               else
                  na_plan = na_plan + 1
               endif
               rs_num_old = rs_num
            endif
         endif
         call rdrst_cif(md,in,mode,iend,ierr)
      enddo
      if(nr_plan.ge.0) then
         nmaxatom_plane = max(nmaxatom_plane,na_plan)
      endif
      close(in)
      md = 0
      in = 0
      pathr = ' '
      extr = ' '
      ierr = 0
      call orrst_cif(md,in,pathr,restraint_file,extr,ierr)

c      stop
      allocate(ia1_b(2,nr_bond))
      allocate(is_bond(4,nr_bond))
      allocate(rs_vidl_b(2,nr_bond))

      allocate(ia1_a(3,nr_angl))
      allocate(rs_vidl_a(3,nr_angl))

      allocate(ia1_t(4,nr_tors))
      allocate(rs_vidl_t(2,nr_tors))
      allocate(itors_period(nr_tors))
      allocate(tors_label(nr_tors))
      allocate(itor_flag(nr_tors))

      allocate(ia1_c(4,nr_chir))
      allocate(ichir_sign(nr_chir))
      allocate(rs_vidl_c(2,nr_chir))

      allocate(ia1_p(nmaxatom_plane,nr_plan))
      allocate(rs_vidl_p(2,nr_plan))
      allocate(nplane(nr_plan))

      rs_num_old = -1

      nb = 0
      na = 0
      nt = 0
      nc = 0
      np = 0
      na_p = 0
      
      iend = 0
      call rdrst_cif(md,in,mode,iend,ierr)
      do while(iend.eq.0)
         if(mode.eq.0) then
            ia1(1) = rs_ia1
            ia1(2) = rs_ia2
            ia1(3) = rs_ia3
            ia1(4) = rs_ia4
            if(rs_name.eq.'BOND') then
               nb = nb + 1
               ia1_b(1:2,nb) = ia1(1:2)
               rs_vidl_b(1,nb) = rs_vidl
               if(rs_vidl.le.0.0) rs_sdi = 0.03
               rs_vidl_b(2,nb) = rs_sdi
               is_bond(1,nb) = 1
               is_bond(2:4,nb) = 0
            elseif(rs_name.eq.'BNDS') then
               nb = nb + 1
               ia1_b(1,nb) = ia1(2)
               ia1_b(2,nb) = ia1(1)
               rs_vidl_b(1,nb) = rs_vidl
               if(rs_sdi.le.0.0) rs_sdi = 0.03
               rs_vidl_b(2,nb) = rs_sdi
               call extract_symm_from_label(rs_label,is_bond(1,nb),
     &              ierror)
               if(ierror.gt.0) then
                  call errwrt(1,'Reading symmetry related bonds')
               endif
            elseif(rs_name.eq.'ANGL') then
               na = na + 1
               ia1_a(1:3,na) = ia1(1:3)
               rs_vidl_a(1,na) = rs_vidl
               rs_vidl_a(2,na) = rs_sdi
            elseif(rs_name.eq.'TORS') then
               nt = nt + 1
               ia1_t(1:4,nt) = ia1(1:4)
               rs_vidl_t(1,nt) = rs_vidl
               rs_vidl_t(2,nt) = rs_sdi
               itors_period(nt) = rs_prd
               tors_label(nt)   = rs_label
               call is_it_restr_torsion(tors_label(nt),ia1_t(1,nt),
     &              ia1_t(2,nt),ia1_t(3,nt),ia1_t(4,nt),
     &              itors_period(nt),rs_vidl_t(1,nt),rs_vidl_t(2,nt),
     &              rs_source_id,itor_flag(nt))
               if(itor_flag(nt).le.0) itor_flag(nt) = 0
            elseif(rs_name.eq.'CHIR') then
               nc = nc + 1
               ia1_c(1:4,nc) = ia1(1:4)
               ichir_sign(nc) = 1
               if(rs_label(1:4).eq.'nega') then
                  ichir_sign(nc) = -1
               elseif(rs_label(1:4).eq.'both') then
                  ichir_sign(nc) = 0
               elseif(rs_label(1:4).eq.'anom') then
                  sign_chir = find_chir_sign(xyz_crd(1:3,ia1_c(1,nc)),
     &                                       xyz_crd(1:3,ia1_c(2,nc)),
     &                                       xyz_crd(1:3,ia1_c(3,nc)),
     &                                       xyz_crd(1:3,ia1_c(4,nc)))
                  if(sign_chir.lt.0.0) then
                     ichir_sign(nc) = -1
                  else
                     ichir_sign(nc) = 1
                  endif
               endif
               rs_vidl_c(1,nc) = rs_vidl
c               rs_vidl_c(2,nc) = rs_sdi
               rs_vidl_c(2,nc) = 0.20
            elseif(rs_name.eq.'PLAN') then
               if(rs_num_old.ne.rs_num) then
c
c--   There is a bug in converting sigma from libdary to restraints. It is 
c--   a quick fix. But it should be dealt with carefully later
                  np = np + 1
                  na_p = 1
                  nplane(np)  = 1
                  ia1_p(na_p,np) = ia1(1)
                  rs_vidl_p(1,np) = 0.0
                  rs_vidl_p(2,np) = rs_vidl
                  if(rs_vidl_p(2,np).le.0.0) rs_vidl_p(2,np) = 0.02
               else
                  na_p = na_p + 1
                  nplane(np) = nplane(np) + 1
                  ia1_p(na_p,np) = ia1(1)
               endif
               rs_num_old = rs_num
            endif
         endif
         call rdrst_cif(md,in,mode,iend,ierr)
      enddo
c      stop
C
C---Write restraints to output intermediate files. They will be used 
C---for restraints and report of geometry
      nr_bond1 = 0
      do ir=1,nr_bond
         if(minval(occup(ia1_b(1:2,ir))).gt.0.0) nr_bond1 = nr_bond1 + 1
      enddo
      write(iscrb)nr_bond1
      do ir=1,nr_bond
         if(minval(occup(ia1_b(1:2,ir))).gt.0.0) then
            write(iscrb)ia1_b(1:2,ir),rs_vidl_b(1:2,ir),
     &           is_bond(1:4,ir),1
         endif
      enddo

      deallocate(ia1_b)
      deallocate(rs_vidl_b)
      deallocate(is_bond)
      close(unit=iscrb)
C
c---Add new bonds here
c
      is_t(1,1:200) = 1
      is_t(2:4,1:200) = 0
      na = 0
      do ir=1,nr_angl
         if(minval(occup(ia1_a(1:3,ir))).gt.0.0) na = na + 1
      enddo
      write(iscra)na
      do ir=1,nr_angl
         if(minval(occup(ia1_a(1:3,ir))).gt.0.0) then
c
c---  add symmetry
            write(iscra)ia1_a(1:3,ir),(is_t(1:4,i),i=1,3),
     &           rs_vidl_a(1:2,ir)
         endif
      enddo
      deallocate(ia1_a)
      deallocate(rs_vidl_a)

C
      DO  IR=1,NR_TORS
        IF(TORS_LABEL(IR)(1:4).EQ.'omeg'.AND.ITOR_FLAG(IR).GT.0) THEN
          IF(NCIS_TRANS_RES.GT.0) THEN
            DO   I=1,NCIS_TRANS_RES
              J = I_RESID(IA1_T(1,IR))
              call get_chain_namepdb(chnamp1,j)
              READ(RES_NUM_PDB(J)(3:6),*)JRS
              IF(JRS.EQ.CIS_TRANS_RES(I)) THEN
                IF(CIS_TRANS_CHAIN(I).EQ.chnamp1) THEN
                  THIS_ALT= CIS_TRANS_ALT(I)
                  APPLY_OK = .FALSE.
                  IF(THIS_ALT.NE.'.') THEN
                    IF(ID_ALT(IA1_T(1,IR)).EQ.THIS_ALT) THEN
C
C---Check all atoms must have same alt code
                      IF(ID_ALT(IA1_T(1,IR)).EQ.THIS_ALT.AND.
     &                   ID_ALT(IA1_T(2,IR)).EQ.THIS_ALT.AND.
     &                   ID_ALT(IA1_T(3,IR)).EQ.THIS_ALT.AND.
     &                   ID_ALT(IA1_T(4,IR)).EQ.THIS_ALT) THEN
                        APPLY_OK = .TRUE.
                      ENDIF
                    ENDIF
                  ELSE
                    APPLY_OK = .TRUE.
                  ENDIF
                  IF(APPLY_OK) THEN
                    IF(CIS_TRANS_VALUE(I)(1:3).EQ.'CIS') THEN
                      RS_VIDL_T(1,IR) = 0.0
                    ELSE IF(CIS_TRANS_VALUE(I)(1:3).EQ.'TRA') THEN
                      RS_VIDL_T(1,IR) = 180.0
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF
cd        IF(TORS_LABEL(IR)(1:3).EQ.'chi'.AND.
cd     &    RES_NAME(I_RESID(IR)).NE.'PRO') ITOR_FLAG = 3
cd          IF(ITORS_PERIOD(IR).EQ.1) RS_SDI_T(IR) = 3.0
cd        IF(TORS_LABEL(IR)(1:4).EQ.'omeg') RS_SDI_T(IR) = 3.0
c        if(minval(occup(ia1_t(1:4,ir))).gt.0.0) then
c           write(iscrt)tors_label(ir),ia1_t(1:4,ir),itors_period(ir),
c     &          rs_vidl_t(1:2,ir),itor_flag(ir)
c        endif
      ENDDO
      nt = 0
      do ir=1,nr_tors
         if(minval(occup(ia1_t(1:4,ir))).gt.0.0) nt = nt + 1
      enddo

      write(iscrt)nt
      do ir=1,nr_tors
         if(minval(occup(ia1_t(1:4,ir))).gt.0.0) then
           write(iscrt)tors_label(ir),ia1_t(1:4,ir),(is_t(1:4,i),i=1,4),
     &           itors_period(ir),rs_vidl_t(1:2,ir),itor_flag(ir)
        endif
      enddo
c
      deallocate(tors_label)
      deallocate(ia1_t)
      deallocate(itors_period)
      deallocate(rs_vidl_t)
      deallocate(itor_flag)
C
      DO   IR=1,NR_CHIR
        IF(NCHIR_REPLACE.GT.0) THEN
          DO   I=1,NCHIR_REPLACE
            J = I_RESID(IA1_C(1,IR))
            call get_chain_namepdb(chnamp1,j)
            READ(RES_NUM_PDB(J)(3:6),*)JRS
            IF(JRS.EQ.CHIR_REPL_RES(I)) THEN
              IF(CHIR_REPL_CHAIN(I).EQ.chnamp1) THEN
                IF(CHIR_REPL_ATOM(I).EQ.ATM_NAME_INP(IA1_C(1,IR))) THEN
                  THIS_ALT = CHIR_REPL_ALT(I)
                  APPLY_OK = .FALSE.
                  IF(THIS_ALT.NE.'.') THEN
                    IF(ID_ALT(IA1_C(1,IR)).EQ.THIS_ALT) THEN
                       APPLY_OK = .TRUE.
                    ENDIF
                  ELSE
                    APPLY_OK = .TRUE.
                  ENDIF
C
                  IF(APPLY_OK) THEN
                    IF(CHIR_REPL_SIGN(I).EQ.'P') THEN
                      ICHIR_SIGN(IR) = 1
                    ELSE IF(CHIR_REPL_SIGN(I).EQ.'M') THEN
                      ICHIR_SIGN(IR) = -1
                    ELSE IF(CHIR_REPL_SIGN(I).EQ.'B') THEN
                      ICHIR_SIGN(IR) = 0
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF
        if(rs_vidl_c(2,ir).le.0.0) rs_vidl_c(2,IR) = 0.20
c        if(minval(occup(ia1_c(1:4,ir))).gt.0.0) then
c           write(iscrc)ia1_c(1:4,ir),rs_vidl_c(1:2,ir),ichir_sign(ir)
c        endif
      ENDDO
      nc = 0
      do ir=1,nr_chir
         if(minval(occup(ia1_c(1:4,ir))).gt.0.0) nc = nc + 1
      enddo
      write(iscrc)nc
      do ir=1,nr_chir
         if(minval(occup(ia1_c(1:4,ir))).gt.0.0) then
            
           write(iscrc)ia1_c(1:4,ir),(is_t(1:4,i),i=1,4),
     &           rs_vidl_c(1:2,ir),ichir_sign(ir)
        endif
      enddo
      deallocate(ia1_c)
      deallocate(rs_vidl_c)
      deallocate(ichir_sign)
C
      np = 0
      DO   IR=1,NR_PLAN
        NA_PLAN = 0
        DO  IPL=1,NPLANE(IR)
          IF(OCCUP(IA1_P(IPL,IR)).GT.0.0) THEN
            NA_PLAN = NA_PLAN  + 1
            IA1_P(NA_PLAN,IR) = IA1_P(IPL,IR)
          ENDIF
        ENDDO
        NPLANE(IR) = NA_PLAN
        IF(NA_PLAN.GT.3) THEN
          if(rs_vidl_p(2,ir).le.0.0) rs_vidl_p(2,ir) =  0.02
          np = np + 1
c          WRITE(ISCRP)NPLANE(IR),RS_VIDL_P(1:2,IR),
c     &           (IA1_P(IPL,IR),IPL=1,NPLANE(IR))
        ENDIF
      ENDDO
      nmaxatom_plane = maxval(nplane(1:nr_plan))
      write(iscrp)np,nmaxatom_plane
      do ir=1,nr_plan
         if(nplane(ir).gt.3) then
            write(iscrp)nplane(ir),rs_vidl_p(1:2,ir),
     &           ia1_p(1:nplane(ir),ir),(is_t(1:4,i),i=1,nplane(ir))
         endif
      enddo
c
      deallocate(nplane)
      deallocate(rs_vidl_p)
      deallocate(ia1_p)

      CLOSE(UNIT=IN,STATUS='DELETE')
      CLOSE(UNIT=ISCRA)
      CLOSE(UNIT=ISCRP)
      CLOSE(UNIT=ISCRC)
      CLOSE(UNIT=ISCRT)
c
c---Read and add external restraints
c
      call read_psuedorest
      call read_harm_et_al
c
      RETURN
      END
C
      SUBROUTINE IS_IT_RESTR_TORSION(TORS_LABEL,IA1,IA2,IA3,
     &           IA4,ITORS_PERIOD,RS_VIDL_T,RS_SDI_T,RS_SOURCE_ID,
     &           ITOR_FLAG)
      IMPLICIT NONE
      INCLUDE 'restr_params.fh'
      INCLUDE 'atom_com.fh'
C
C---Looks up to the list defined in 'restr_params.fh' and decides if
C---it is restrainable torsion
      INTEGER IA1,IA2,IA3,IA4,ITORS_PERIOD,ITOR_FLAG,I_C,L_RES_T1,
     &        L_TORS_N,L_TORS_L,L_GROUP_L,L_TYPE_L,I_TYPE_R
      REAL RS_VIDL_T,RS_SDI_T
      CHARACTER TORS_LABEL*(*),RS_SOURCE_ID*(*)
      character tors_local*8
      INTEGER I,I_SAME_RESIDUE,L_RES_T,I_RES_C1,I_RES_C2,I_NAME_R
      INTEGER LENSTR
      EXTERNAL LENSTR
C
C---Initialise
      ITOR_FLAG = 0
C
C---All atoms must be from the same residue. If yes look up residue names/groups
C---If no look link names, groups.
C
      I_SAME_RESIDUE = 0
      IF(IA1.LE.0.OR.IA2.LE.0.OR.IA3.LE.0.OR.IA4.LE.0) RETURN
      IF(I_RESID(IA1).EQ.I_RESID(IA2).AND.
     &    I_RESID(IA1).EQ.I_RESID(IA3).AND.
     &    I_RESID(IA1).EQ.I_RESID(IA4))THEN
        I_SAME_RESIDUE = 1
        I_RES_C1       = I_RESID(IA1)
      ELSE
        I_RES_C1 = I_RESID(IA1)
        IF(I_RESID(IA1).NE.I_RESID(IA2)) THEN
          I_RES_C2 = I_RESID(IA2)
        ELSEIF(I_RESID(IA1).NE.I_RESID(IA3)) THEN
          I_RES_C2 =  I_RESID(IA3)
        ELSEIF(I_RESID(IA1).NE.I_RESID(IA4)) THEN
          I_RES_C2 =  I_RESID(IA4)
        ENDIF
      ENDIF
C
C---Now look if it is one of the residues or groups
      IF(I_SAME_RESIDUE.EQ.1) THEN
        I_C = 0
        L_TORS_L = MIN(8,LENSTR(TORS_LABEL))
        I_TYPE_R = IRES_TYPE(I_RES_C1)
cd        I_NAME_R = I_RESID(I_RES_C1)
       
        L_TYPE_L = MIN(8,LENSTR(RS_SOURCE_ID))
        L_RES_T1 = MIN(8,LENSTR(RES_NAME(I_RES_C1)))
c
        DO   I=1,N_RESTRAIN_TORS
C
C---Look residue name and torsion angle name
          tors_local = tors_label
          call ccpupc(tors_local)
          IF(RES_NAME_TORS_RESTR(I)(1:1).NE.'.') THEN
             IF(trim(RES_NAME(I_RES_C1)).EQ.
     &            trim(RES_NAME_TORS_RESTR(I)).AND.
     &            trim(TORS_LABEL).EQ.
     &            trim(RES_NAME_TORS_NAME(I))) THEN
                ITOR_FLAG = 1
                I_C = I
                GOTO 110
             ENDIF
          ENDIF
        ENDDO
c
c--
        DO   I=1,N_RESTRAIN_TORS
C
C---Look residue name. If torsion angle was not defined
          tors_local = tors_label
          call ccpupc(tors_local)
          IF(RES_NAME_TORS_RESTR(I)(1:1).NE.'.') THEN
             IF(trim(RES_NAME(I_RES_C1)).EQ.
     &            trim(RES_NAME_TORS_RESTR(I)).AND.
     &            trim(RES_NAME_TORS_NAME(I)).eq.'.'.and.
     &            tors_local(1:3).eq.'VAR') THEN
                ITOR_FLAG = 1
                I_C = I
                GOTO 110
             ENDIF
          ENDIF
        ENDDO
C
c--If user defined group of monomers. User has defined torsion name
        DO   I=1,N_RESTRAIN_TORS
          tors_local = tors_label
          call ccpupc(tors_local)
          IF(GROUP_NAME_TORS_RESTR(I)(1:1).NE.'.') THEN
C
C---Decide using group ('peptide', 'DNA' etc) name. We should have access 
C---to this information
            IF(trim(GROUP_NAME_TORS_RESTR(I)).EQ.
     &         trim(RS_SOURCE_ID).AND.
     &         trim(TORS_LABEL).EQ.
     &         trim(RES_NAME_TORS_NAME(I))) THEN
              ITOR_FLAG = 1
              I_C = I
              GOTO 110
            ENDIF
          ENDIF
        ENDDO
c
c--If user defined group of monomers and has not defined torsion. All "var"s
        DO   I=1,N_RESTRAIN_TORS
          tors_local = tors_label
          call ccpupc(tors_local)
          IF(GROUP_NAME_TORS_RESTR(I)(1:1).NE.'.') THEN
C
C---Decide using group ('peptide', 'DNA' etc) name. We should have access 
C---this information
            IF(trim(GROUP_NAME_TORS_RESTR(I)).EQ.
     &         trim(RS_SOURCE_ID).AND.
     &         res_name_tors_name(i).eq.'.'.and.
     &         tors_local(1:3).eq.'VAR') THEN
              ITOR_FLAG = 1
              I_C = I
              GOTO 110
            ENDIF
          ENDIF
        ENDDO

 110    CONTINUE

        I = I_C
C
C---If user has changed targets and other things apply them.
        IF(ITOR_FLAG.GT.0.AND.I_C.GT.0) THEN
          IF(RES_NAME_TORS_PERIOD(I).GT.0)
     &           ITORS_PERIOD = RES_NAME_TORS_PERIOD(I)
          IF(RES_NAME_TORS_VALUE(I).GE.-180.0) 
     &         RS_VIDL_T = RES_NAME_TORS_VALUE(I)
          IF(RES_NAME_TORS_SIGMA(I).GT.0.0)
     &       RS_SDI_T = RES_NAME_TORS_SIGMA(I)
        ENDIF
      ELSE
C
C---Torsion is between residues. Link info. Use that info.
C---It is a link and user defined torsion angle name
        I_C = 0
        tors_local = tors_label
        call ccpupc(tors_local)
        DO   I=1,N_RESTRAIN_TORS
          IF(trim(LINK_NAME_TORS_RESTR(I)).EQ.
     &         trim(RS_SOURCE_ID).AND.
     &         trim(TORS_LABEL).EQ.
     &         trim(RES_NAME_TORS_NAME(I))) THEN
              ITOR_FLAG = 1
              I_C = I
              GOTO 200 
          ENDIF
        ENDDO
c
c---Between residues (link). User defined link name but not torsion name. All "vars"
        DO   I=1,N_RESTRAIN_TORS
          IF(trim(LINK_NAME_TORS_RESTR(I)).EQ.
     &         trim(RS_SOURCE_ID).AND.
     &         tors_local(1:3).eq.'VAR'.and.
     &         RES_NAME_TORS_NAME(I)(1:1).eq.'.') THEN
              ITOR_FLAG = 1
              I_C = I
              GOTO 200 
          ENDIF
        ENDDO
 200    CONTINUE
C
C---If user has changed targets and other things apply them.
        IF(ITOR_FLAG.GT.0.AND.I_C.GT.0) THEN
C
          I = I_C
          IF(RES_NAME_TORS_PERIOD(I).GT.0)
     &           ITORS_PERIOD = RES_NAME_TORS_PERIOD(I)
          IF(RES_NAME_TORS_VALUE(I).GE.0.0) 
     &         RS_VIDL_T = RES_NAME_TORS_VALUE(I)
          IF(RES_NAME_TORS_SIGMA(I).GT.0.0)
     &       RS_SDI_T = RES_NAME_TORS_SIGMA(I)
        ENDIF
      ENDIF
C
C---Now remove torsion angles from restraints if such thing have been defined
      IF(N_RESTRAIN_TORS_E.GT.0) THEN
      IF(I_SAME_RESIDUE.EQ.1) THEN
        I_C = 0
        L_TORS_L = MIN(8,LENSTR(TORS_LABEL))
        DO   I=1,N_RESTRAIN_TORS_E
C
C---Look residue name
          L_RES_T = MIN(8,LENSTR(RES_NAME_TORS_RESTR_E(I)))
          L_RES_T1 = MIN(8,LENSTR(RES_NAME(I_RES_C1)))
          L_TORS_N = MIN(8,LENSTR(RES_NAME_TORS_NAME_E(I)))
          IF(L_RES_T.GT.0.AND.RES_NAME_TORS_RESTR_E(I)(1:1).NE.'.') THEN
            IF(L_RES_T1.GT.0.AND.L_TORS_N.GT.0.AND.L_TORS_L.GT.0) THEN
              IF(RES_NAME(I_RES_C1)(1:L_RES_T1).EQ.
     &           RES_NAME_TORS_RESTR_E(I)(1:L_RES_T).AND.
     &           TORS_LABEL(1:L_TORS_L).EQ.
     &           RES_NAME_TORS_NAME_E(I)(1:L_TORS_N)) THEN
                ITOR_FLAG = 0
                I_C = I
                GOTO 210
              ENDIF
            ENDIF
          ENDIF
C
          L_GROUP_L = MIN(8,LENSTR(GROUP_NAME_TORS_RESTR_E(I)))
          IF(L_GROUP_L.GT.0.AND.
     &       GROUP_NAME_TORS_RESTR_E(I)(1:1).NE.'.') THEN
C
C---Decide using group ('peptide', 'DNA' etc) name. We should have access 
C---this information
            I_TYPE_R = IRES_TYPE(I_RES_C1)
            L_TYPE_L = MIN(8,LENSTR(RS_SOURCE_ID))
            IF(GROUP_NAME_TORS_RESTR_E(I)(1:L_GROUP_L).EQ.
     &         RS_SOURCE_ID(1:L_TYPE_L).AND.
     &         TORS_LABEL(1:L_TORS_L).EQ.
     &         RES_NAME_TORS_NAME_E(I)(1:L_TORS_N)) THEN
              ITOR_FLAG = 0
              I_C = I
              GOTO 210
            ENDIF
          ENDIF
C
        ENDDO
 210    CONTINUE

      ELSE
C
C---Torsion is between residues. Link info. Use that info.
C---It is a link.
        I_C = 0
        L_TYPE_L  = MIN(8,LENSTR(RS_SOURCE_ID))
        L_TORS_L  = MIN(8,LENSTR(TORS_LABEL))
        DO   I=1,N_RESTRAIN_TORS_E
          L_GROUP_L = MIN(8,LENSTR(LINK_NAME_TORS_RESTR_E(I)))
          L_TORS_N  = MIN(8,LENSTR(RES_NAME_TORS_NAME_E(I)))
          IF(LINK_NAME_TORS_RESTR_E(I)(1:L_GROUP_L).EQ.
     &         RS_SOURCE_ID(1:L_TYPE_L).AND.
     &         TORS_LABEL(1:L_TORS_L).EQ.
     &         RES_NAME_TORS_NAME_E(I)(1:L_TORS_N)) THEN
              ITOR_FLAG = 0
              I_C = I
              GOTO 300 
          ENDIF
        ENDDO
 300    CONTINUE
C
      ENDIF
      ENDIF
      return
      END
C
      SUBROUTINE EXTRACT_SYMM_FROM_LABEL(RS_LABEL,IS_REST,IERROR)
      IMPLICIT NONE
C
      CHARACTER RS_LABEL*(*)
      INTEGER IERROR,IS_REST(4)
C
C----Local variables
      INTEGER I,LEN_RS
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      IERROR = 0
      IS_REST(1) = 0
      IS_REST(2) = 0
      IS_REST(3) = 0
      IS_REST(4) = 0
C
      LEN_RS = LENSTR(RS_LABEL)
      DO   I=1,LEN_RS
        IF(RS_LABEL(I:I).EQ.'_') GOTO 100
      ENDDO
C
c---No underscore. Error
      IERROR = 1
      RETURN
C
 100  CONTINUE
      IF(I.NE.LEN_RS-3) THEN
        IERROR = 1
        RETURN
      ENDIF
      IF(I.LE.1) THEN
        IERROR = 1
        RETURN
      ENDIF
C
C---Now extarct symmetry
      READ(RS_LABEL(1:I-1),*)IS_REST(1)
      I = I + 1
      READ(RS_LABEL(I:I),'(I1)')IS_REST(2)
      IS_REST(2) = IS_REST(2) - 5
      I = I + 1
      READ(RS_LABEL(I:I),'(I1)') IS_REST(3)
      IS_REST(3) = IS_REST(3) - 5
      I = I + 1
      READ(RS_LABEL(I:I),'(I1)')IS_REST(4)
      IS_REST(4) = IS_REST(4) - 5
C
      RETURN
      END

C
cd      SUBROUTINE DIVIDE_PLANES
C
cd      DO   IPL = 1,NPLANE
cd        IF(N_BOND_ATOM(IPL).GT.1.AND.PLANE_ATOM_ALL_FLAG(IPL).GT.0) THEN
cd          IAT_PLANE = 1
cd          PLANE_ATOM = (IPL)
cd          DO   IPL1 = 1,N_BOND_ATOM(IPL)
cd            IAT_PLANE = IAT_PLANE + 1
cd            PLANE_ATOM(IAT_PLANE) = (IPL1)
cd            PLANE_ATOM_ALL_FLAG(IPL1) = 0
cd            DO  IPL2 = 1,NBOND_ATOM(IPL1)
cd              IAT_PLANE = IAT_PLANE + 1
cd              PLANE_ATOM(IAT_PLANE) = (IPL2)
cd            ENDDO
cd          ENDDO
cd        ENDIF
cd      ENDDO
C
      SUBROUTINE READ_STR_REFMAC(nmodel)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'models.fh'
      INCLUDE 'ref_com_str.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
C
      integer nmodel
      CHARACTER*15 AT_FULL1,AT_FULL2,AT_FULL3,AT_FULL4
      INTEGER MD,IN,IERR,IEND,IATOM_C,IA_TYPE,LENSTR,IA,im
      INTEGER IFLAG_OCC,IMODE,I,J,IERROR,I1,I2,I3,I4
      CHARACTER EXTR*2,PATHR*2
      LOGICAL LEXISTS
C
      MD  = -999
      IN  = 0
      PATHR = ' '
      EXTR = ' '
      IERR = 0
C
C---First check if STRUCT_FILE exists
      IF(STRUCT_FILE.EQ.' ') THEN
        CALL DEFAULT_ATOMTYPE
        RETURN
      ENDIF
      INQUIRE (FILE=STRUCT_FILE(1:LENSTR(STRUCT_FILE)),EXIST=LEXISTS)
      IF(.NOT.LEXISTS) THEN
C
C--Set defaults atomic types and radii. It happens in unrestrained refinement
        CALL DEFAULT_ATOMTYPE
        RETURN  
      ENDIF
      CALL READ_STR(MD,PATHR,STRUCT_FILE,EXTR,IERR)
      IF(IERR.GT.0) THEN
        CALL ERRWRT(-1,'Something is wrong with tree')
        CALL errwrt(1,'Reading tree filed')
      ENDIF
C
C---Find maximum vdw radius and replace default maximum if default is less 
C---than that from coordinates
cd      call default_atomtype
c geometry for more models has to be added later
      do im=1,1
        DO   IA=1,N_ATOM_mod(im)
          if(OCCUP_mod(IA,im).GT.0.0) THEN
            DVDW_CUT_MIN = AMAX1(DVDW_CUT_MIN,VDW_RAD(IA))
          endif
        ENDDO
      enddo
      call read_vdw_ion_external

      RETURN
      END
C
      subroutine correct_hb_hydrogens(n_model)
      include 'atom_com.fh'
      include 'atom_com_str.fh'
      include 'restr_files.fh'
c
c---  correct hb types of hydrogens. If hydrogen is attached to 
c---  an accepter or to "both" then hb type for this hdyrogen should be
c---  H
      integer ia_l(2),isym1(4)
      integer iscrb,ierr
      integer nbond,nbonds,itype_bond
      integer nmaxrest
      integer i,ib,ia,ib1,ib2
      real rs_vidl(4)
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: rest_per_atom(:,:)
c
c---- body
      if(len_trim(bond_file).le.0) return
      call open_unform_file(iscrb,bond_file,ierr)
      if(ierr.gt.0) then
         call errwrt(-1,'Problem while opening bond_file')
         return
      endif
      read(iscrb)nbonds
      nbond = 0
      allocate(nrest_per_atom(n_atom))
      nrest_per_atom(1:n_atom) = 0
      do  ib=1,nbonds
         read(iscrb,iostat=iend)ia_l(1:2),rs_vidl(1:2),
     &        isym1(1:4),itype_bond
         nbond = nbond + 1
         nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
         nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
      enddo
      nmaxrest = maxval(nrest_per_atom(1:n_atom))
      allocate(rest_per_atom(nmaxrest,n_atom))
      
      nrest_per_atom(1:n_atom) = 0
c
c---read and do a little bit of organisation
      rewind(iscrb)
c
      read(iscrb)nbonds
      do  ib=1,nbonds
         read(iscrb)ia_l(1:2),rs_vidl(1:2),isym1(1:4),
     &        itype_bond
         nrest_per_atom(ia_l(1)) = nrest_per_atom(ia_l(1))+1
          if(ia_l(1).ne.ia_l(2)) then
             nrest_per_atom(ia_l(2)) = nrest_per_atom(ia_l(2))+1
          endif
         ib1 = nrest_per_atom(ia_l(1))
         ib2 = nrest_per_atom(ia_l(2))
         rest_per_atom(ib1,ia_l(1)) = ia_l(2)
         rest_per_atom(ib2,ia_l(2)) = ia_l(1)
      enddo

      close(iscrb)

      do i=1,n_atom
         if(trim(cs_element(id_sf(i))).eq.'H') then
            do ib=1,nrest_per_atom(i)
               ia = rest_per_atom(ib,i)
               if(hb_type(ia).eq.'D'.or.hb_type(ia).eq.'B') then
c                  write(*,*)hb_type(i),chem_type(i),atm_name(i),
c     &                 atm_name(ia)
                  hb_type(i) = 'H'
               endif
            enddo
         endif
      enddo
      deallocate(rest_per_atom)
      deallocate(nrest_per_atom)
c      stop

      return
      end

      SUBROUTINE DEFAULT_ATOMTYPE
C
C---Defines default atom types. They are names of elements and some default
C---radii for them
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
C
      INTEGER IA
C
cd      CALL ERRWRT(1,'Here we are')
      IF(N_ATOM.LE.0) THEN
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,'There is no atom. DEFAULT_ATOMTYPE should'
     &           //' be called when atoms have already been read')
        CALL ERRWRT(1,'PROBLEM in DEFAULT_ATOMTYPE')
      ENDIF  
      DO   IA = 1,N_ATOM
        CHEM_TYPE(IA)     = CS_ATYPE(ID_SF(IA))
        HB_TYPE(IA) = 'N'
        IF(CS_ELEMENT(ID_SF(IA)).EQ.'H ') THEN
           VDW_RAD(IA) = 1.2
           ION_RAD(IA) = -1.0
c          VDW_RAD(IA) = 0.7
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'O ') then
           VDW_RAD(IA) = 1.52
           ION_RAD(IA) = 1.28
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'C ') then
           VDW_RAD(IA) = 1.8
           ION_RAD(IA) = -1.0
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'N ') then
           VDW_RAD(IA) = 1.55
           ION_RAD(IA) = 1.32
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'S ') then
           VDW_RAD(IA) = 1.80
           ION_RAD(IA) = 0.4
        ELSE IF(CS_ELEMENT(ID_SF(IA)).EQ.'P ') then
           VDW_RAD(IA) = 1.80
           ION_RAD(IA) = 0.59
        ELSE
          VDW_RAD(IA) = 1.8
          ION_RAD(IA) = -1.0
        ENDIF
      ENDDO
      RETURN
      END
C
C
      subroutine refpre
      implicit none
      include 'twin_refmac.fh'
      include 'refi_flags.fh'
c
c--Intensities?
      if(twin_flag.or.intens_flag) then
         call refpre_twin
      else
         call refpre_n
      endif

      return
      end
C
      SUBROUTINE REFPRE_n
      implicit none
C
C---Reads and prepares reflection list.
      include 'atom_com.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      include 'map_params.fh'

      INTEGER ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL,INXYZ,
     &        IOUTX,MTZIN
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
C
      integer sz,nobs0
      INTEGER HMAX,KMAX,LMAX
      COMMON /HKLLIM/ HMAX, KMAX, LMAX
C
      character line*512
c
c---allocatable
      integer, allocatable :: inds(:)
      integer, allocatable :: lind(:)
      integer, allocatable :: freer(:)
      real, allocatable :: fo(:)
      real, allocatable :: sigo(:)
      real, allocatable :: fo_map(:)
      real, allocatable :: sigo_map(:)
      real, allocatable :: fpart(:)
      real, allocatable :: apart(:)
      real, allocatable :: hlabcd(:)
      real, allocatable :: fo_weight(:)
      INTEGER I,IPAKLM,INTLIM,NO,NGX,NGY,NGZ
      REAL STLMIN0,STLMAX0,SMAX
C
C---Define bins 
      STLMIN0 = STLMIN
      STLMAX0 = STLMAX
      stlmin_input = stlmin
      stlmax_input = stlmax
      IF(REFTYP.EQ.'MTZ') THEN
C
C---Find maximum resolution of observed structure factors
         CALL MTZ_FIND_MAX_RESO_FO(MTZIN,STLMIN0,STLMAX0,nobs0)
      ENDIF

      STLMAX = AMIN1(STLMAX,STLMAX0)
      SMINS  = AMIN1(STLMIN,SMINS)
      SMAXS  = AMAX1(STLMAX,SMAXS)
      if(.not.map_extend_flag) then
         stlmin_input = stlmin
         stlmax_input = stlmax
      endif
C
C
c---Option with ranges and equal number of reflections
      BINSIZE  = (STLMAX**2 - STLMIN**2)/NBIN
      SMINB(1) = STLMIN
      DO    I=2,NBIN
        SMINB(I)   = SQRT(SMINB(I-1)**2 + BINSIZE)
        SMAXB(I-1) = SMINB(I)
      ENDDO
      SMAXB(NBIN)   = STLMAX
      SMAXB(NBIN+1) = SMINB(1)
      SMINB(NBIN+1) = SMINB(1)
C
C---If we are using mtz open and read usefull information from there
      SMAX = STLMAX*2.0
      HMAX = INT(CELL(1)*SMAX)
      KMAX = INT(CELL(2)*SMAX)
      LMAX = INT(CELL(3)*SMAX)
C
C   Check packing limits - cant go above 2**23
      IPAKLM = LMAX* (2*KMAX+1) * (2*HMAX+1)
      INTLIM = 1024*1024*512
      IF(IPAKLM .GT. INTLIM) THEN
         WRITE(LINE,'(A,A,I10)')
     +          ' Packing problem - your cell is TOO BIG! ',
     +          'Maximum allowed packed index',INTLIM
         CALL ERRWRT(0,LINE)
         WRITE(LINE,'(A,I10)')
     +         ' Maximum expected from this cell and resolution:',IPAKLM
         CALL ERRWRT(1,LINE)
      ENDIF
      nobs = nobs0
      SZ = NOBS 
C---
C---First define sizes of arrays and give space for them
      allocate(inds(SZ))
      allocate(fo(sz*(dataset_num_tot+1)))
      allocate(sigo(sz*(dataset_num_tot+1)))
      allocate(lind(sz))
      allocate(freer(sz))
      if(fpart_flag) then
         allocate(fpart(npart*sz))
         allocate(apart(npart*sz))
      else
         allocate(fpart(2))
         allocate(apart(2))
      endif
      if(mir_flag.or.phase_flag) then
         allocate(hlabcd(4*sz))
      else
         allocate(hlabcd(4))
      endif
      allocate(fo_map(sz))
      allocate(sigo_map(sz))
      allocate(fo_weight(sz))
C
C----Read reflection and write into Reflscr unformatted file
      IF(REFTYP.EQ.'MTZ') THEN
C
C---Reflection are in MTZ format
        CALL MTZRED(no,inds,fo,sigo,freer,lind,fpart,apart,hlabcd,
     &        fo_map,sigo_map,fo_weight,sz)

      ELSE
        CALL ERRWRT(1,'Other than MTZ reflection type')
      ENDIF
      CALL GET_GRID_SPACING(FSHANN,NGX,NGY,NGZ,HMAX,KMAX,LMAX)
C
C---Report grids
      N1 = NX/IPX
      N2 = NY/IPY
      N3 = NZ/IPZ
c
c---  deallocate
      deallocate(inds)
      deallocate(fo)
      deallocate(sigo)
      deallocate(freer)
      deallocate(lind)
      deallocate(fpart)
      deallocate(apart)
      deallocate(fo_map)
      deallocate(sigo_map)
      deallocate(fo_weight)

      RETURN
      END
C
 
      SUBROUTINE MTZ_FIND_MAX_RESO_FO(MTZIN1,STLMIN0,STLMAX0,nref)
      IMPLICIT NONE
      include 'agreem.fh'
      include 'mtz_things.fh'
C
C---This subroutine finds resolution limits for fobs.
      INTEGER MTZIN1
      REAL STLMIN0,STLMAX0
C
C---Areas for reading mtz file
c      INTEGER MCOLS
c      PARAMETER (MCOLS = 200)
c      INTEGER LOOKUP(MCOLS)
c      LOGICAL LOGMSS(MCOLS)
C
c      INTEGER NLPRGI,NLPRGO
c      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
C
C--Array for mtz
c      REAL ADATA(200)
C
C---Local scalars
c      INTEGER IFO,ISO,NREF
      INTEGER NREF
      REAL SSQMAX0,SSQMAX,SSQMIN0,SSQMIN,SSQ
      LOGICAL EOF
C
      if (LookUp(4).ne.0) then
        IFO     = LOOKUP(4)
        ISO     = LOOKUP(5)
      elseif (LookUp(i_FPL).ne.0) then
        IFO     = LOOKUP(i_FPL)
        ISO     = LOOKUP(i_SIGFPL)
      else
        IFO     = 0.
        ISO     = 0.
        call errwrt(0,'No F''s in mtz_find_max_reso')
      endif
      SSQMAX  = (2.0*STLMAX0)**2
      SSQMAX0 = -1.0E32
      SSQMIN0 = 1.0E32
      NREF    = 0
 10   CONTINUE
      CALL LRREFL(MTZIN,SSQ,ADATA,EOF)
      IF(EOF) GOTO 100
      NREF = NREF + 1
      IF(SSQ.GT.SSQMAX) GOTO 10
      CALL LRREFM(MTZIN,LOGMSS)
      IF(.NOT.LOGMSS(IFO) ) THEN
        SSQMAX0 = AMAX1(SSQMAX0,SSQ)
        SSQMIN0 = AMIN1(SSQMIN0,SSQ)
      ENDIF
      IF(.NOT.LOGMSS(ISO) ) THEN
        SSQMAX0 = AMAX1(SSQMAX0,SSQ)
        SSQMIN0 = AMIN1(SSQMIN0,SSQ)
      ENDIF
C
      GOTO 10
 100  CONTINUE
      STLMAX0 = SQRT(SSQMAX0)/2.0+1.0E-5
      STLMIN0 = SQRT(SSQMIN0)/2.0-1.0E-5
      CALL LRREWD(MTZIN)
      RETURN
      END
C
      SUBROUTINE MTZRED(NO,NIND,FO,SIGO,FREER,LIND,FPART,PHIP,ABCD,
     +  fo_map,sigo_map,fo_weight,SZ)
      implicit none
C
C---Subroutine reads reflection from mtz file sorts them (l>0 h fastest
C---k second and l slowest indices
C---writes sorted reflections into unformatted output file. LIND stores
C---information about old sort
C---
      include 'atom_com.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      include 'restr_files.fh'
      include 'mtz_things.fh'
      include 'anom.fh'

      INTEGER SZ,no
      REAL FO(*),SIGO(*),FREER(*),FPART(*),PHIP(*),ABCD(*)
      real fo_map(sz),sigo_map(*)
      real fo_weight(sz)
      INTEGER NIND(SZ),LIND(SZ)
      integer ih,ik,il,ind,ierr,icent
      integer i,di,nref,lnd,ip,ipos,ip1,ifree
      real sthol,tmp_loc,rsq,ssqmax,ssqmax0
      real phase,fom,blur_factor,ssq
      integer isysr,isysw,ifofc,iscrf,iatmr,idisk,jdisk,newfil,
     &        inxyz,ioutx,mtzin1
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL,
     &                INXYZ,IOUTX,MTZIN1
      EXTERNAL PACK,UNPACK
C
C---Areas for reading mtz file
c      PARAMETER (MCOLS = 200)
c      INTEGER LOOKUP(MCOLS)
c      LOGICAL LOGMSS(MCOLS)
C
c      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
c      REAL ADATA(200)
      REAL STLMAX0
      LOGICAL EOF
      INTEGER IHH(3)
c
c      integer ifo_map,isigo_map,ifo_weight
      integer ifomap_unit,ifail,ll
      character refl_scratch*512
C
C---
      REAL FPP(NMAXPART),PHPP(NMAXPART)
c      INTEGER IFPART(NMAXPART),IAPART(NMAXPART)
      REAL SIGNORM(100)
      CHARACTER LINE*120
      REAL HLA,HLB,HLC,HLD
c      INTEGER IFOALL(dataset_num_tot),ISOALL(dataset_num_tot)
C
      REAL LSTLSQ
      EXTERNAL  LSTLSQ
C
C---Now read reflections into massive
      IFO    = LOOKUP(4)
      ISO    = LOOKUP(5)
      do di=1,dataset_num_tot
        IFOALL(di) = LOOKUP(i_FPL+(di-1)*2)
        ISOALL(di) = LOOKUP(i_SIGFPL+(di-1)*2)
      enddo
c just to initialize ifo and iso somehow if not given for sad somehow here (they are calculated from +- later)
      if (lookup(4).eq.0.and.dataset_num_tot.gt.1) then
        ifo = ifoall(1)
        iso = isoall(1)
      endif
      IFREE = 0
      IHLA  = 0
      IHLB  = 0
      IHLC  = 0
      IHLD  = 0
      IFOM  = 0
      IPB   = 0
      IF(FREER_FLAG) IFREE=LOOKUP(i_FREE)
      IF(FPART_FLAG) THEN
         DO    IP=1,NPART
           IFPART(IP) = 0
           IAPART(IP) = 0
         ENDDO
         IP1 = 0
         DO    IP=0,NMAXPART-1
           IF (LOOKUP(i_FPART1+2*IP).NE.0 .AND. 
     &         LOOKUP(i_PHIP1+2*IP).NE.0) THEN
             IP1 = IP1+1
             IFPART(IP1) = LOOKUP(i_FPART1+2*IP)
             IAPART(IP1) = LOOKUP(i_PHIP1+2*IP)
             ISCPART(IP1) = ISCPART(IP)
           ENDIF
         ENDDO
      ENDIF
      IF(MIR_FLAG) THEN
         IHLA=max(0,LOOKUP(i_HLA))
         IHLB=max(0,LOOKUP(i_HLB))
         IHLC=max(0,LOOKUP(i_HLC))
         IHLD=max(0,LOOKUP(i_HLD))
      ENDIF
      IF(PHASE_FLAG) THEN
         IFOM = max(0,LOOKUP(i_FOM))
         IPB  = max(0,LOOKUP(i_PHIB))
         CALL BESSTAB
      ENDIF
      if(fomap_flag) then
         ifo_map=max(0,lookup(i_FP_MAP))
         isigo_map=max(0,lookup(i_SIGFP_MAP))
         if(ifo_map.le.0 .or. isigo_map .le. 0 ) fomap_flag = .FALSE.
      endif
      if(foweight_flag) then
         ifo_weight = max(0,lookup(i_W))
      else
         ifo_weight = 0
      endif
      NREF = 0
      I = 0
      SSQMAX = (2.0*STLMAX_input)**2
      SSQMAX0 = SSQMAX
C
 20   CONTINUE
      CALL LRREFL(MTZIN,SSQ,ADATA,EOF)
      do while(.not.eof)
         NREF = NREF + 1
         IF(SSQ.le.SSQMAX)  then
            CALL LRREFM(MTZIN,LOGMSS)
            IF(LOGMSS(IFO) ) ADATA(IFO) = 0.0
            IF(LOGMSS(ISO) ) ADATA(ISO) = -0.01
            do di=1,dataset_num_tot
              IF (LOGMSS(IFOALL(di))) ADATA(IFOALL(di)) = 0.0
              IF (LOGMSS(ISOALL(di)) ) ADATA(ISOALL(di)) = -0.01      
              IF (ADATA(IFOALL(di)).LE.0.0) ADATA(ISOALL(di)) = -0.01
            enddo
C
C---Problem with 0 reflections. I think you can't have 0 refections without
C---having 0 sigma's. Some data processing softwares give 0 reflections
C---I am replacing them with unknown reflections which is not best thing in the
C---world. But this problem should be dealt in data processing programs and 
C---if intensities are less than 0 they should be converted into positive
C---amplitudes as it is done by TRUNCATE (reference: French and Wilson 1978??)
            IF(ADATA(IFO).LE.0.0) ADATA(ISO) = -0.01
            I = I+1
C
C---If we should read other information (Fpart,PHI,ABCD or others
C---add here
            IH      = NINT(ADATA(1))
            IK      = NINT(ADATA(2))
            IL      = NINT(ADATA(3))
            IHH(1) = IH
            IHH(2) = IK
            IHH(3) = IL
            CALL CENTR(IHH,ICENT)
c            fo(i)   = adata(ifo)
c            sigo(i) = adata(iso)
            fo(i)   = adata(ifo)*exp(b_sharp_refine*ssq/4.0)
            sigo(i) = adata(iso)*exp(b_sharp_refine*ssq/4.0)
            do di=1,dataset_num_tot
              FO(I+di*NOBS) = ADATA(IFOALL(di))
     +                        *exp(b_sharp_refine*ssq/4.0)
              SIGO(I+di*NOBS) = ADATA(ISOALL(di))
     +                          *exp(b_sharp_refine*ssq/4.0)
            enddo
c if sad(h) then fo is calculated from f+,f-
c            if ((DPPI_sad.or.DPPI_sadh).and.lookup(4).eq.0) then
            if (LOOKUP(i_FPL).ne.0.and.LOOKUP(i_FMI).ne.0.and.
     &          LOOKUP(i_SIGFPL).ne.0.and.LOOKUP(i_SIGFMI).ne.0
     &          .and.lookup(4).eq.0) then
              if (fo(i+NOBS).le.0.0.and.fo(i+2*NOBS).le.0.0) then
                sigo(i) = -0.01
              elseif (fo(i+NOBS).gt.0.0.and.fo(i+2*NOBS).gt.0.0) then
                fo(i) = (fo(i+NOBS)+fo(i+2*NOBS))/2
                sigo(i) = sqrt( sigo(i+NOBS)*sigo(i+NOBS) + 
     +                          sigo(i+2*NOBS)*sigo(i+2*NOBS) )/2
              elseif (fo(i+NOBS).gt.0.0) then
                fo(i) = fo(i+NOBS)
                sigo(i) = sigo(i+NOBS)
              else
                fo(i) = fo(i+2*NOBS)
                sigo(i) = sigo(i+2*NOBS)             
              endif
            endif
c            FO(I)   =  ADATA(IFO)*exp(b_sharp_refine*ssq/4.0)
c            SIGO(I) =  ADATA(ISO)*exp(b_sharp_refine*ssq/4.0)

cd      SIGO(I) =  FO(I)*0.01
            LIND(I) = I
            IF(FREER_FLAG) THEN
               IF(LOGMSS(IFREE)) then
                  if(LfreeRexcludeVal.eq.0) then
                     freer(i) = 1.0
                  else
                     freer(i) = 0.0
                  endif
               else
                  freer(i) = adata(ifree)
               endif
               IF(LOGMSS(IFO) .OR. LOGMSS(ISO))  FREER(I) = -FREER(I)
            END IF
            IF(FPART_FLAG) THEN
               DO    IP=1,NPART
                  IPOS = I+(IP-1)*NOBS
                  FPART(IPOS) = 0.0
                  PHIP(IPOS) = 0.0
                  IF(.NOT.LOGMSS(IFPART(IP))) 
     &                 FPART(IPOS)=ADATA(IFPART(IP))
                  IF(.NOT.LOGMSS(IFPART(IP))) 
     &                 PHIP(IPOS)=ADATA(IAPART(IP))
               ENDDO
            ELSE
               NSCPART = 0
            ENDIF
            IF(MIR_FLAG) THEN
               HLA = 0.0
               HLB = 0.0
               HLC = 0.0
               HLD = 0.0
               IF(.NOT.LOGMSS(IHLA).AND..NOT.LOGMSS(IHLB).AND.
     +              .NOT.LOGMSS(IHLC).AND..NOT.LOGMSS(IHLD)) THEN
                  IF(IHLA.NE.0) HLA = ADATA(IHLA)
                  IF(IHLB.NE.0) HLB = ADATA(IHLB)
                  IF(IHLC.NE.0) HLC = ADATA(IHLC)
                  IF(IHLD.NE.0) HLD = ADATA(IHLD)
               ENDIF
            ENDIF
            IF(.NOT.MIR_FLAG.AND.PHASE_FLAG) THEN
               FOM = 1.0
               IF(IFOM.GT.0) THEN
                  FOM = 0.0
                  IF(.NOT.LOGMSS(IFOM)) FOM = ADATA(IFOM)
               ENDIF
               IF(.NOT.LOGMSS(IPB)) THEN
                  PHASE = ADATA(IPB)
               ELSE
                  FOM   = 0.0
                  PHASE = 0.0 
               ENDIF
               CALL FOMPHASE2AB(ICENT,FOM,PHASE,HLA,HLB)
               HLC = 0.0
               HLD = 0.0
            ENDIF
            IF(MIR_FLAG.OR.PHASE_FLAG) THEN
               IPOS        = I
               RSQ         =  LSTLSQ(MTZIN,IH,IK,IL)
               BLUR_FACTOR = PHAS_BLUR_SCAL*EXP(-RSQ*PHAS_BLUR_BVAL)
               ABCD(IPOS)  = HLA*BLUR_FACTOR
               IPOS        = IPOS+NOBS
               ABCD(IPOS)  = HLB*BLUR_FACTOR
               IPOS        = IPOS+NOBS
               ABCD(IPOS)  = HLC*BLUR_FACTOR
               IPOS        = IPOS+NOBS
               ABCD(IPOS)  = HLD*BLUR_FACTOR
            ENDIF
            if(fomap_flag) then
               tmp_loc = exp(b_sharp_refine*ssq/4.0)
               fo_map(i) = adata(ifo_map)*tmp_loc
               sigo_map(i) = adata(isigo_map)*tmp_loc
            else
               tmp_loc = exp(b_sharp_refine*ssq/4.0)
               fo_map(i) = fo(i)*tmp_loc
               sigo_map(i)=sigo(i)*tmp_loc
            endif
            if(foweight_flag.and.ifo_weight.gt.0) then
               fo_weight(i) = adata(ifo_weight)
            else
               fo_weight(i) = 1.0
            endif
C
            IF(IL.LT.0) THEN
               IH      = -IH
               IK      = -IK
               IL      = -IL
               LIND(I) = -LIND(I)
            ELSEIF(IL.EQ.0.AND.IK.LT.0) THEN
               IK = -IK
               IH = -IH
               LIND(I) = -LIND(I)
            ELSEIF(IL.EQ.0.AND.IK.EQ.0.AND.IH.LT.0) THEN
               IH = -IH
               LIND(I) = -LIND(I)
            ENDIF
            if(lind(i).lt.0) then
               IF(FPART_FLAG) THEN
                  DO    IP=1,NPART
                     IPOS       = I+(IP-1)*NOBS
                     PHIP(IPOS) = -PHIP(IPOS)
                  ENDDO
               ENDIF
               IF(MIR_FLAG.OR.PHASE_FLAG) THEN
                  IPOS       = I + NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
                  IPOS       = IPOS + 2*NOBS
                  ABCD(IPOS) = -ABCD(IPOS)
               ENDIF
c
c---Add anom F+ and F- here
            endif
            CALL PACK(IND,IH,IK,IL)
C
C----Add some calculation to calculate number of reflections in bins 
C---- and so on
            NIND(I) = IND
         endif
         call lrrefl(mtzin,ssq,adata,eof)
      enddo
      IF(PHASE_FLAG) MIR_FLAG = .TRUE.
      NO = I
      IF(NO.GT.SZ) THEN
         LINE =  ' ***ERROR- More observed data than is consistent'
         CALL ERRWRT(-1,LINE)
         LINE =  ' with the resolution cut-off and the spacegroup. ***'
         CALL ERRWRT(-1,LINE)
         LINE = ' Are you inputting only ONE asymmetric unit?'
         CALL ERRWRT(1,LINE)
      END IF
C
c---Now define resolution bins for MLestimates. Take care of minimum
C----resolution of actual observed data and minimum resolution desired.
C----They might be different.
C
      CALL DEFINE_BINS_FOR_ML(NO,NIND,FO,SIGO,FREER)
c
C---  Now sort reflections
      WRITE(ISYSW,'(A,I10)')' Number of reflections in file ',NREF
      WRITE(ISYSW,'(A,I10)')' Number of reflection read     ',NO
c
c---  Define resolution bins for stats
      call define_reso_bins_stats(no,fo,sigo,nind)
c
      CALL ISORT1(NO,NIND,LIND)
C
C---Now write into output file sorted reflections
      IFAIL = -1
      call find_unique_file_name(refl_scratch,'_REFSCR')
      call open_unform_file(iscrf,refl_scratch,ierr)

      IFSCR_SAVE = ISCRF

c      if(fomap_flag) then
      call find_unique_file_name(fomap_file,'.fomap')
      call open_unform_file(ifomap_unit,fomap_file,ierr)

      do i=1,no
         lnd = abs(lind(i))
         write(ifomap_unit) fo_map(lnd),sigo_map(lnd),fo_weight(lnd)
      enddo
      close(ifomap_unit)
c
      DO     I=1,NO
        LND = IABS(LIND(I))
C
C--If phases process here
c
c--Each type of dat ain a seperate file?
        IND = NIND(I)
        CALL UNPACK(IND,IH,IK,IL)
        RSQ   =  LSTLSQ(MTZIN,IH,IK,IL)
        STHOL = SQRT(RSQ)
        IF(MIR_FLAG) THEN
          IPOS = LND
          HLA  = ABCD(IPOS)
          IPOS = IPOS+NOBS
          HLB  = ABCD(IPOS)
          IPOS = IPOS+NOBS
          HLC  = ABCD(IPOS)
          IPOS = IPOS+NOBS
          HLD  = ABCD(IPOS)
        ENDIF
cd        FO(LND) = FO(LND)*EXP(RSQ*60)
cd        SIGO(LND) = SIGO(LND)*EXP(RSQ*60)
        IF(FREER_FLAG.AND.FPART_FLAG) THEN
          DO    IP=1,NPART
            IPOS = LND+(IP-1)*NOBS
            FPP(IP) = FPART(IPOS)
            PHPP(IP) = PHIP(IPOS)
          ENDDO
          IF(.NOT.MIR_FLAG) THEN
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART)
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ELSE
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART),
     +               HLA,HLB,HLC,HLD
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ENDIF
        ENDIF
        IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
          DO    IP=1,NPART
            IPOS = LND+(IP-1)*NOBS
            FPP(IP) = FPART(IPOS)
            PHPP(IP) = PHIP(IPOS)
          ENDDO
          IF(.NOT.MIR_FLAG) THEN    
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +            LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART)
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ELSE
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +        LIND(I),(FPP(IP),PHPP(IP),IP=1,NPART),
     +        HLA,HLB,HLC,HLD
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ENDIF
        ENDIF
        IF(FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
          IF(.NOT.MIR_FLAG) THEN
             WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I)
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ELSE
             WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),FREER(LND),
     +               LIND(I),HLA,HLB,HLC,HLD
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ENDIF
        ENDIF
        IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
          IF(.NOT.MIR_FLAG) THEN
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +               LIND(I)
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ELSE
            WRITE(ISCRF)IH,IK,IL,STHOL,FO(LND),SIGO(LND),
     +               LIND(I),HLA,HLB,HLC,HLD
     +         ,(FO(LND+di*NOBS),SIGO(LND+di*NOBS),di=1,dataset_num_tot)
          ENDIF
        ENDIF
      ENDDO
C
C---Close file for writing and open for reading.
      REWIND(ISCRF)
cd      CLOSE(UNIT = ISCRF)
      IF(MIR_FLAG) CALL EXPCOS_TABLE
      NPARTALL = NPART
      NPART    = NSCPART
      NOBS = NREF + 1
      RETURN
      END
C
      subroutine define_reso_bins_stats(no,fo,sigo,nind)
      implicit none
      include 'weights.fh'
      include 'refi_flags.fh'
c
c---  inputs
      integer no
      integer nind(*)
      real    fo(*)
      real    sigo(*)
c
c---  locals
      integer i,ii,ib
      integer h,k,l
      integer n_in_bin,n_new_in_bin
      real binsize_l
c
c---  allocatables
      real, allocatable :: sint2l(:)
      integer, allocatable :: indx(:)
c
c---  externals
      real lstlsq
      external lstlsq
c
c---  body
      if(bint.eq.'REFL') then
         allocate(sint2l(no))
         allocate(indx(no))
c
         do i=1,no
            call unpack(nind(i),h,k,l)
            indx(i) = i
            sint2l(i) = sqrt(lstlsq(1,h,k,l))
         enddo
         
         call sort_real(no,sint2l,indx)
c     
         sminb(1) = stlmin
         n_in_bin = nint(float(no)/float(nbin))
         n_new_in_bin = 0
         ib = 0
         do i=1,no
            ii = indx(i)
            n_new_in_bin = n_new_in_bin + 1
            if(n_new_in_bin.eq.n_in_bin) then
               ib = ib + 1
               smaxb(ib) = sint2l(i)
               sminb(ib+1) = smaxb(ib)
               n_new_in_bin = 0
            endif
         enddo
         smaxb(nbin) = stlmax
         sminb(nbin+1) = sminb(1)
         smaxb(nbin+1) = stlmax
         deallocate(sint2l)
         deallocate(indx)
      else
C
c---  Option of simple division of (sin(theta)/lambda)**2
         binsize_l = (stlmax**2-stlmin**2)/nbin
         sminb(1) = stlmin
         do i=2,nbin
            sminb(i) = sqrt(sminb(i-1)**2 + binsize_l)
            smaxb(i-1) = sminb(i)
         enddo
         smaxb(nbin) = stlmax
         sminb(nbin+1) = sminb(1)
         smaxb(nbin+1) = stlmax
      endif
      return
      end
c
      SUBROUTINE DEFINE_BINS_FOR_ML(NO,NIND,FO,SIGO,FREER)
      IMPLICIT NONE
C
C---Defines resolution bins for ML parameters estimation.
C---Number of reflections necessary for estimation of ML
C---parameters (NMIN_REF_BINS) has been defined before this routine
C---
      include 'atom_com.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'anom.fh'
      INTEGER NO
      INTEGER NIND(*)
      REAL FO(*),FREER(*),SIGO(*)
C
C----Local variables
      REAL STL_C,STLMN_FO,STLMX_FO,RSQ,BINSIZE_ML_DELTA
      INTEGER NREF_ALL
      INTEGER I,IREF,I_START,ICASE,IB,NMIN_REF_IN_BINS
      CHARACTER LINE*256
      LOGICAL FREERCHK
      STLMIN_ML = STLMIN*2.0
      STLMAX_ML = STLMAX*2.0
C
C---Find actual resolution range for observed amplitudes.
C---Resoluiton used for map calculation might be different from
C---this value
      STLMX_FO  = -1.0E32
      STLMN_FO  = 1.0E32
      DO   IREF = 1,NO
         IF(SIGO(IREF).GT.0.0.AND.FO(IREF).GT.0.0) THEN
           CALL INDTORS(NIND(IREF),RSQ)
           STL_C = SQRT(RSQ)
           STLMN_FO = AMIN1(STLMN_FO,STL_C)
           STLMX_FO = AMAX1(STLMX_FO,STL_C)
         ENDIF
      ENDDO
      STLMIN_ML = AMAX1(STLMN_FO,STLMIN_ML-1.0E-5)
      STLMAX_ML = AMIN1(STLMX_FO,STLMAX_ML+1.0E-5)
C
C---BINSIZE has been defined before this routine.
C---Start defining resolution bins.
C
C---Now find number of bins. Start with largest possible and then decide.
C
      IF(MLUSEWORK) THEN
        NMIN_REF_IN_BINS = 100
ccc        NMIN_REF_IN_BINS = 50
      ELSE
        NMIN_REF_IN_BINS =  50
ccc        NMIN_REF_IN_BINS =  25
      ENDIF
C
 1    continue
      BINSIZE_ML = 0.0005
      NBIN_ML = MAX(1,MIN(MAXBIN,
     &     INT(((STLMAX_ML**3-STLMIN_ML**3)/BINSIZE_ML)) 
     &               + 1))
ccc      NBIN_ML = MAX(1,MIN(50,NBIN_ML))
      NBIN_ML = MAX(1,MIN(30,NBIN_ML))
       BINSIZE_ML = 
     &         ((STLMAX_ML**3-STLMIN_ML**3)/NBIN_ML)
cd      BINSIZE_ML = ((STLMAX_ML**3-STLMIN_ML**3)/MAXBIN)
      BINSIZE_ML_DELTA = BINSIZE_ML/5.0
C
      NBIN_ML = MAXBIN
 9    CONTINUE
      SMINB_ML(1) = STLMIN_ML
      DO   I=2,NBIN_ML
        SMINB_ML(I) = (SMINB_ML(I-1)**3 + BINSIZE_ML)**(1.0/3.0)
        SMAXB_ML(I-1) = SMINB_ML(I)
      ENDDO
      SMAXB_ML(NBIN_ML) = STLMAX_ML
C
C---  Now check if there are enough reflections in each bin
C

C
C----Find number of reflections in the resolution bins
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
      ENDDO
      NREF_ALL = 0
      DO   IREF=1,NO
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND. 
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0) THEN
          CALL INDTORS(NIND(IREF),RSQ)
          STL_C = SQRT(RSQ)
          DO   I=1,NBIN_ML
            IF(STL_C.LE.SMAXB_ML(I).AND.STL_C.GE.SMINB_ML(I)) THEN
              NREF_ML(I) = NREF_ML(I) + 1
              NREF_ALL   = NREF_ALL + 1
            ENDIF
          ENDDO
        ENDIF
      ENDDO
C
C----Check if there are enough reflection in each bin. 
      IF(NBIN_ML.EQ.1.AND..NOT.MLUSEWORK.AND.
     &              NREF_ALL.LE.NMIN_REF_IN_BINS.AND.
     &                                       FREER_FLAG) THEN
ccc      IF(NBIN_ML.EQ.1.AND..NOT.MLUSEWORK.AND.FREER_FLAG.or.
ccc     &     nref_all.le.200) THEN
c     &              NREF_ALL.LE.NMIN_REF_IN_BINS.AND.

        CALL ERRWRT(0,'Not enough reflections for ML parameters')
        WRITE(LINE,'(A,I6)')
     &                    'Number of reflections for ML = ',nref_all
        CALL ERRWRT(0,LINE)
        CALL ERRWRT(0,'Switching to option "SCALE MLSCALE WORK"')
        CALL ERRWRT(0,'I.e. use working reflection for ML estimation')
        MLUSEWORK = .TRUE.
        NMIN_REF_IN_BINS = 100
        GOTO 1
      ELSEIF(NBIN_ML.EQ.1) THEN 
       GOTO 100
      ELSE
        DO  IB=1,NBIN_ML
          IF(NREF_ML(IB).LT.NMIN_REF_IN_BINS) THEN
C
C---  Increase the bin size
            BINSIZE_ML = BINSIZE_ML + BINSIZE_ML_DELTA           
            NBIN_ML = MAX(1,MIN(NBIN_ML-1,
     &       INT(((STLMAX_ML**3-STLMIN_ML**3)/BINSIZE_ML)) 
     &               + 1))
            BINSIZE_ML = 
     &         ((STLMAX_ML**3-STLMIN_ML**3)/NBIN_ML)
cd            WRITE(*,*)BINSIZE_ML,NBIN_ML
            GOTO 9
          ENDIF
        ENDDO

      ENDIF
C
 100  CONTINUE
      KERNEL_G = (SMAXB_ML(1)**3-SMINB_ML(1)**3)/2.0
      KERNEL_G_RAD = KERNEL_G
      NBIN_ML1 = NBIN_ML+1
      DELTA_S_TABLE = 0.0005
      N_POINTS_TABLE_S = INT((STLMAX_ML**3-STLMIN_ML**3)/DELTA_S_TABLE)
      N_POINTS_TABLE_S = MAX(20,MIN(2000,N_POINTS_TABLE_S))
      DELTA_S_TABLE = (STLMAX_ML**3-STLMIN_ML**3)/N_POINTS_TABLE_S
cd      WRITE(*,*)'tables ',N_POINTS_TABLE_S,DELTA_S_TABLE
      SMEANB_ML(1) = SMINB_ML(1)
      SMEANB_RAD(1) = SMINB_ML(1)**3
      IF(NBIN_ML.GT.1) THEN
        DO   I=2,NBIN_ML
          SMEANB_RAD(I) = SMINB_ML(I)**3
          SMEANB_ML(I) = (SMINB_ML(I)+SMAXB_ML(I)*3.0)/4.0
        ENDDO
      ENDIF
      SMEANB_ML(NBIN_ML1) = SMAXB_ML(NBIN_ML)
      SMEANB_RAD(NBIN_ML1) = SMAXB_ML(NBIN_ML)**3
c
C---  Define style for sigma and some other estimations
      if(1.0/SMAXB_ML(nbin_ml).GT.3.0.OR.NREF_ALL.LE.300.or.
     +  PPI.ne.'no') THEN
         SIGMA_REFINE_STYLE = 'BINS'
c         SIGMA_REFINE_STYLE = 'EXPS'
      else
         SIGMA_REFINE_STYLE = 'BINS'
c         SIGMA_REFINE_STYLE = 'EXPS'
      endif
c      write(*,*)sigma_refine_style
c      stop
c         SIGMA_REFINE_STYLE = 'EXPS'

C
C---If MLUSEWORK is .false. then define different bins for sec.der.
C
      NBIN_RAD = NBIN_ML
      IF(.NOT.MLUSEWORK) THEN
        NMIN_REF_IN_BINS = 100
 101    continue
        BINSIZE_ML = 0.0005
        NBIN_RAD = MAX(1,MIN(MAXBIN,
     &     INT(((STLMAX_ML**3-STLMIN_ML**3)/BINSIZE_ML)) 
     &               + 1))
        NBIN_RAD = MAX(1,MIN(30,NBIN_RAD))
        BINSIZE_ML = 
     &         ((STLMAX_ML**3-STLMIN_ML**3)/NBIN_RAD)
        BINSIZE_ML_DELTA = BINSIZE_ML/5.0
C
 109    CONTINUE
        SMEANB_RAD(1) = STLMIN_ML
        DO   I=2,NBIN_RAD
          SMEANB_RAD(I) = (SMEANB_RAD(I-1)**3 + BINSIZE_ML)**(1.0/3.0)
        ENDDO
        SMEANB_RAD(NBIN_RAD+1) = STLMAX_ML
C
C---  Now check if there are enough reflections in each bin
C
C----Find number of reflections in the resolution bins
        DO   I=1,NBIN_RAD
          NREF_ML(I) = 0
        ENDDO
        NREF_ALL = 0
        DO   IREF=1,NO
          FREERCHK = .FALSE.
          IF(FREER_FLAG )THEN 
            IF( 
     +      (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
          END IF
          IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0) THEN
            CALL INDTORS(NIND(IREF),RSQ)
            STL_C = SQRT(RSQ)
            DO   I=1,NBIN_RAD
               IF(STL_C.LE.SMEANB_RAD(I+1).AND.
     &              STL_C.GE.SMEANB_RAD(I)) THEN
                  NREF_ML(I) = NREF_ML(I) + 1
                  NREF_ALL   = NREF_ALL + 1
               ENDIF
            ENDDO
         ENDIF
        ENDDO
C
C----Check if there are enough reflection in each bin. 
        IF(NBIN_RAD.EQ.1) THEN 
         GOTO 200
        ELSE
          DO  IB=1,NBIN_RAD
            IF(NREF_ML(IB).LT.NMIN_REF_IN_BINS) THEN
C
C---  Increase the bin size
C
              BINSIZE_ML = BINSIZE_ML + BINSIZE_ML_DELTA           
              NBIN_RAD = MAX(1,MIN(NBIN_RAD-1,
     &         INT(((STLMAX_ML**3-STLMIN_ML**3)/BINSIZE_ML)) 
     &               + 1))
              BINSIZE_ML = 
     &         ((STLMAX_ML**3-STLMIN_ML**3)/NBIN_RAD)
cd            WRITE(*,*)BINSIZE_ML,NBIN_ML
              GOTO 109
            ENDIF
          ENDDO
        ENDIF
C
 200    CONTINUE
        DO   I=1,NBIN_RAD+1
          SMEANB_RAD(I) = SMEANB_RAD(I)**3
        ENDDO
      ENDIF
      KERNEL_G_RAD = (SMEANB_RAD(2)-SMEANB_RAD(1))/2.0
c
      RETURN
      END
C
      SUBROUTINE DEFINE_OVERALL_B(NREF,NIND,FO,SIGO)
      IMPLICIT NONE
      INCLUDE 'const.fh'
      INCLUDE 'weights.fh'
C
C---  Find overall B value using Patterson origin peak. It meant to be
C---  more reliable. 
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),SIGO(*)

      INTEGER I,IREF,N_PATT_POINTS,ISYSAB,ICENT
      INTEGER IHH(3)
      REAL DIST,RSQ,STL_C,SS,RHO,XX0,FO2,EPSI,DELTA_X,XX1,XX2
      INTEGER MAX_PATT_POINTS
      PARAMETER (MAX_PATT_POINTS = 100)
      REAL XX(MAX_PATT_POINTS),PATT(MAX_PATT_POINTS)
      REAL PATT_RES(MAX_PATT_POINTS)
      REAL LSTLSQ
      EXTERNAL LSTLSQ,UNPACK

      N_PATT_POINTS = 61
      DELTA_X       = 0.1
      DO   I=1,N_PATT_POINTS
        PATT(I) = 0.0
        XX(I)   = DELTA_X*FLOAT(I-1)
        XX0     = TWOPI*XX(I)*STLMAX_ML
        IF(I.EQ.1) THEN
          PATT_RES(1) = 1.0
        ELSE
          PATT_RES(I) = 3*(SIN(XX0)-XX0*COS(XX0))/XX0**3
        ENDIF
      ENDDO
C
      DO  IREF = 1,NREF
        IF(SIGO(IREF).GT.0.0) THEN
          CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
          RSQ = 4.0*LSTLSQ(1,IHH(1),IHH(2),IHH(3))
          STL_C = SQRT(RSQ)
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)

          FO2 = FO(IREF)**2/(FLOAT(ICENT+1)*EPSI)
          SS = TWOPI*STL_C
          PATT(1) = PATT(1) + FO2
          DO   I=2,N_PATT_POINTS
            XX0 = SS*XX(I)
            PATT(I) = PATT(I) + FO2*SIN(XX0)/XX0
          ENDDO
        ENDIF
      ENDDO
C
C---Now analyse
C
      OPEN(68,file='68.dat')
      DO   I=2,N_PATT_POINTS
        IF(PATT(I).LE.0.0.OR.PATT_RES(I).LE.0.0) GOTO 100
        XX0 = -PISQ8/2.0*XX(I)**2/(ALOG(PATT(I))-ALOG(PATT(1)))
        XX1 = -PISQ8/2.0*XX(I)**2/(ALOG(PATT_RES(I)-ALOG(PATT_RES(1))))
        xx2 = (xx0-xx1)/2.0
        WRITE(68,*)XX(I)**2,PATT(I)/PATT(1),PATT_RES(I)/PATT_RES(1),
     &                        XX0,XX1,XX2
      ENDDO
 100  CONTINUE
      STOP
      RETURN
      END
C
      SUBROUTINE MTZWRITE(NREF,ndens,LIND,NIND,FO,SIGO,H_A,H_B,FC,PHASE,
     &                    FREER)
      IMPLICIT NONe
C
C---Mtz writer
c      INTEGER MCOLS
c      PARAMETER (MCOLS = 200)
c      INTEGER MSETS
c      PARAMETER (MSETS=MCOLS)
c      INTEGER PRGO
c      PARAMETER (PRGO = 50)

      include 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      INCLUDE 'map_params.fh'
      include 'restr_files.fh'
      INCLUDE 'anom.fh'
      include 'mtz_things.fh'
      INTEGER NREF,ndens
      real FC(nobs*(npart+1),ndens),PHASE(nobs*(npart+5),ndens)
      REAL FO(*),SIGO(*),FREER(*)
      REAL H_A(*),H_B(*)
      INTEGER NIND(*),LIND(*)
      EXTERNAL UNPACK
      REAL LSTLSQ
      EXTERNAL LSTLSQ
C
C--Mtz things
c      INTEGER LOOKUP(MCOLS)
      integer, parameter :: bdata_num = 50
      REAL BDATA(bdata_num)
      INTEGER IHH(3)
      LOGICAL TESTFREE1,TESTFREE2,TESTFREE3
C
c      INTEGER NLPRGI,NLPRGO
c      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
c      CHARACTER LSPRGO(PRGO)*30,CTPRGO(PRGO)*1
c      COMMON /MTZRDC/LSPRGO,CTPRGO
      REAL   COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
C
c      INTEGER ISET,NDATASETS
c      REAL DATCELL,DATWAVE
c      CHARACTER*64 PNAME,XNAME,DNAME,PNAME_OUT,XNAME_OUT,DNAME_OUT
c      COMMON /MTZSET/ NDATASETS,PNAME(MSETS),XNAME(MSETS),DNAME(MSETS),
c     +         PNAME_OUT(MCOLS),XNAME_OUT(MCOLS),DNAME_OUT(MCOLS),
c     +         DATCELL(6,MSETS),DATWAVE(MSETS)
C
      INTEGER I,NPART1,MTZOUT,IAPPND,ICELL,ICENT,ISYSAB,IR,IRR,I_INTER,
     &        IOUT,NPART2,ID,i_max, ibin_ml,ibbb_ml
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),HH(3),A_ALL,B_ALL,
     &     SCALE_NOW,SCALE_P,SIGMA_IN,SIGMA,EPSI,WT1,DFDA,DFDB,DFDAA,
     &     DFDBB,DFDAB,FOM,FVALUE,FCC0,PHCC,PHCC0,RHO,STL_C,RSQ,PHSIGN,
     &     PHCOMB,A0,B0,A1,B1,F0,F1,PH0,PH1,YO,A_ALL1,B_ALL1,PHIB,
     &     DET2,A11,A12,A22,HL(4)
      integer ierr,calcABCD,num4phib
      real a_allls,b_allls,s_local
      real auser,buser
      real w_h
      real fo_wt
      REAL SIGN_NOW, SIGP_NOW, SIGN2_NOW, SIGN2P_NOW, YOP,YOM,SIGP12_NOW
      real SIGOPL,SIGOMI,SIGOP2,SIGOM2
      REAL DSIGP2_NOW,SIGP2P_NOW,A_ALL_D,B_ALL_D,sigi_now,FVAL_ALL,YC
      real D_PAR(NMAXPART*2+2)
      real SIGP2_NOW(NMAXPART), SIGH_NOW
      real SP_NOW(NMAX_SIG),SN_NOW(NMAX_SIG)
      real DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,DFDAApp,DFDBBpp,
     &     DFDABpp,DFDAppB,DFDAp,DFDBp,dfdapap,dfdbpbp
      INTEGER OMP_GET_THREAD_NUM
c
      integer ifomap_unit,ifail,ll,dimen
      integer labout_map(prgo)
c
      INTEGER MPARS
      PARAMETER (MPARS = 200)
      INTEGER IBEG(MPARS),IEND(MPARS),IDEC(MPARS),ITYP(MPARS),ntok
      REAL FVAL(MPARS)
      CHARACTER CVAL(MPARS)*4
      logical lend
      character KEY*4
C
c
      call return_mat_dim(dimen)
      sigopl=.1
      sigomi=.1
C-----the PHIB and FB labels are to be output if substructure ref. 
C     (can't be done in rcard because of automatic detection in oppro)
      if (.not.substruct_flag) then
        oc_FB%use = .false.
        oc_PHIB%use = .false.
        oc_HLA%use = .false.
        oc_HLB%use = .false.
        oc_HLC%use = .false.
        oc_HLD%use = .false.
      else
        oc_PHIC_ALL%use = .false.
        oc_FC_all%use = .false.
c        oc_PHAN%use = .false.
c        oc_FAN%use = .false.
      endif
      
      call make_PRGO(labout_map)
      if (NLPRGO.gt.bdata_num) 
     &  call errwrt(1,'Too many columns for output mtz file.')
      MTZOUT = 2
      NTOK=MPARS
      CALL PARSER(KEY,LABOUT_SAVE,IBEG,IEND,ITYP,FVAL,CVAL,IDEC,
     &                NTOK,LEND,.FALSE.)
      CALL LKYOUT(MTZOUT,LSPRGO,NLPRGO,NTOK,LABOUT_SAVE,IBEG,IEND)
c
C----Read old sorting order
      NPART1 = NPART + 1
      NPART2 = NPART + 2
C
c
c--Read FP_MAP if defined and replace FO with these
c
      if(fomap_flag) then
         call open_unform_file(ifomap_unit,fomap_file,ierr)
         do i=1,nref
            read(ifomap_unit)fo(i),sigo(i),fo_wt
         enddo
         close(ifomap_unit)
         call applyscales_map(nref,nind,fo,sigo)
      endif
c
      CALL RDSORT(LIND)
C
      FVAL_ALL = 0
      MTZOUT = 2
      IAPPND = 0
      CALL LWOPEN(MTZOUT,'HKLOUT')
      CALL LWTITL(MTZOUT,'  Output mtz file from refmac',1)
      DO    ICELL=4,6
        IF(CELL(4).LE.5.0.AND.CELL(5).LE.5.0.AND.CELL(6).LE.5.0) THEN
          CELL(4) = CELL(4)*RTODEG
          CELL(5) = CELL(5)*RTODEG
          CELL(6) = CELL(6)*RTODEG
        ENDIF
      ENDDO
      CALL LWCELL(MTZOUT,CELL)
      CALL LWSORT(MTZOUT,ISORT)
C
      NumPrimSymm = NumSymmetry/NSMULT
C            ******************************
      CALL LWSYMM(MTZOUT,
     +                NumSymmetry,
     +                 NumPrimSymm,
     +                  RealSymmMatrx,
     +                   Ltype,
     +                    NumSpaceGroup,
     +                     SpaceGroupName,
     +                      PointGroupName)
      CALL LWASSN(MTZOUT,LSPRGO,NLPRGO,CTPRGO,IAPPND)
C Store the project name and dataset name in the mtz header:
      write(*,*)ndatasets
      stop

      IF (NDATASETS.GT.0) THEN
        DO ISET = 1,NDATASETS
CMDW-4.2          CALL LWID(MTZOUT,PNAME(ISET),DNAME(ISET))
          CALL LWIDX(MTZOUT,PNAME(ISET),XNAME(ISET),DNAME(ISET),
     +                      DATCELL(1,ISET),DATWAVE(ISET))
        ENDDO
CMDW-4.2        CALL LWIDAS(MTZOUT,NLPRGO,PNAME_OUT,DNAME_OUT,IAPPND)
        CALL LWIDASX(MTZOUT,NLPRGO,XNAME_OUT,DNAME_OUT,IAPPND)
      ENDIF
C

cd      CALL COPY_LSML2DPAR
      I_INTER = -1
c!$OMP PARALLEL DO REDUCTION(+:FVAL_ALL) PRIVATE(IR,PHSIGN,BDATA,I,STL_C,
c!$OMP+  RSQ,RHO,IHH,ICENT,EPSI,ISYSAB,FCC0,PHCC0,IOUT,A_CALCS,B_CALCS,
c!$OMP+  A_ALL,B_ALL,A_ALL1,B_ALL1,SCALE_P,SCALE_NOW,WT1,SIGMA_IN,SIGMA,
c!$OMP+  YO,YOP,YOM,SIGOPL,SIGOMI,SIGOP2,SIGOM2,SIGN_NOW,SIGP_NOW,
c!$OMP+  SN_NOW,SP_NOW,i_max,SIGN2_NOW,SIGN2P_NOW,SIGP2_NOW,SIGP2P_NOW,
c!$OMP+  DSIGP2_NOW,D_PAR,DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM,DFDAp,
c!$OMP+  DFDBp,DFDApp,DFDBpp,I_INTER,COSC,SINC,COSAA,SINAA,YC,TESTFREE1,
c!$OMP+  TESTFREE2,A0,B0,F0,PH0,A1,B1,F1,PH1,PHCOMB,AUSER,BUSER, ID)
      DO    IRR = 1,NREF
        IR      = LIND(IRR)
        IF(LIND(IRR).LT.0)IR = -IR
        PHSIGN = 1.0
        IF(LIND(IRR).LT.0) PHSIGN = -1.0
C            *******************************
c!$OMP CRITICAL(EQUAL_MAGIC)
        CALL EQUAL_MAGIC(MTZOUT,BDATA,bdata_num)
c!$OMP END CRITICAL(EQUAL_MAGIC)
        labouts(labout_map(1:nlprgo))%val = bdata(1:nlprgo)
C            *******************************
C---Use LIND to find old sorting order
        CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
cd        write(*,*)IRR,LIND(IRR),NREF,FO(IR),SIGO(IR)
cd        WRITE(*,*)IHH

        CALL INDTORS(NIND(IR),RSQ)
        STL_C = SQRT(RSQ)
        RHO   = STL_C/2.0

        IF(STL_C.LT.SMINB_ML(1).OR.STL_C.GT.SMAXB_ML(NBIN_ML)) GOTO 100
        CALL CENTR(IHH,ICENT)
        CALL EPSLON(IHH,EPSI,ISYSAB)
C 
        oc_H%val = PHSIGN*IHH(1)
        oc_K%val = PHSIGN*IHH(2)
        oc_L%val = PHSIGN*IHH(3)
        FOM      = 0.0
C
C ejd - I think FC(..,1) has already had Fobs B factor applied in subag sr propi?
        FCC0   = FC(IR+NPART*NOBS,1)
        PHCC0  = PHASE(IR+NPART*NOBS,1)
        if (dppi_sras.and.substruct_flag) then
          FCC0   = FC(IR,3)
          PHCC0  = PHASE(IR,3)
        endif
        IF(REFS.EQ.'LSQF') THEN
C
C----Write str.factors for case lsq with magnitudes
C----First write observed str.factors in "absolute" scale. Replace unobserved
C----and "free" reflections by calculated ones.
          IF(SIGO(IR).GT.0.0) THEN
            oc_FP%val    = FO(IR)
            oc_SIGFP%val = SIGO(IR)
          ENDIF
          if (oc_FREE%use) oc_FREE%val = ABS(FREER(IR))
C
C---write scaled and summed FC-s. 
          oc_FC%val = FC(IR+NPART*NOBS,1)
          oc_PHIC%val = PHSIGN*RTODEG*PHASE(IR+NPART*NOBS,1)
        ELSEIF(REFS.EQ.'MLKF') THEN
C
c---First extract partial As and Bs from scrambled phase and FC
          CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
c---Now find D multiplied A_all and B_all
          if (DPPI_no) then
            WT1 = REAL(1+ICENT)*EPSI
          else
            wt1 = epsi
          endif
          IF(SIGMA_REFINE_STYLE.EQ.'BINS') THEN
            A_ALL = 0.0
            B_ALL = 0.0
            A_ALL1 = 0.0
            B_ALL1 = 0.0
            a_allls = 0.0
            b_allls = 0.0
            IF(NPART.GT.0) THEN
              DO  I=1,NPART
                CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,I),
     &                               STL_C,
     &                              I_INTER,SCALE_NOW)
                A_ALL = A_ALL + A_CALCS(I)*SCALE_NOW
                B_ALL = B_ALL + B_CALCS(I)*SCALE_NOW
                A_ALL1 = A_ALL1 + A_CALCS(I)
                B_ALL1 = B_ALL1 + B_CALCS(I)
                s_local = scale_ls_part(i)/scale_ls_over*
     &               exp(-rsq*b_ls_part(i))
                a_allls = a_allls + a_calcs(i)*s_local
                b_allls = b_allls + b_calcs(i)*s_local
              ENDDO
            ENDIF

            CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,NPART1),
     &                              STL_C,I_INTER,SCALE_P)
            if (anom_maponly_flag) then
              YOP  = FO(dataset_order(1)*NOBS+IR)
              YOM  = FO(dataset_order(2)*NOBS+IR)
              SIGOPL = SIGO(dataset_order(1)*NOBS+IR)
              SIGOMI = SIGO(dataset_order(2)*NOBS+IR)
            endif
            if (.not.DPPI_no) then  
              IBIN_ml = 0
              do ibbb_ml=1,NBIN_ML2
                IF ( STL_C.LE.SMAXB_ML2(IBbb_ml).AND.
     +             STL_C.GT.SMINB_ML2(IBbb_ml) )
     +           ibin_ml = ibbb_ml
              enddo
c sometimes one/a few reflections are outside of bins from some reason
              if (ibin_ml.eq.0.and..not.dppi_no)  goto 100
              if (NPART.ne.0) then 
                D_PAR(1) = SCALE_NOW
                D_PAR(2) = SCALE_P
              else
                D_PAR(1) = SCALE_P
                CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,2),
     &                              STL_C,I_INTER,SCALE_NOW)
                D_PAR(2) = SCALE_NOW 
              endif
            endif
            if (DPPI_sras.or.DPPI_sad.or.DPPI_sadh.or.DPPI_pl.or.
     &          DPPI_sir) then
              D_PAR(1) = SCALE_ML2(Ibin_ml,1)
              D_PAR(2) = SCALE_ML2(IBin_ml,2)
              SCALE_P = D_PAR(2)
              if (Dppi_sras.or.Dppi_sadh.or.DPPI_pl.or.DPPI_sir)
     &          D_PAR(3) = SCALE_ML2(IBin_ml,3)
          	  if (dppi_sadh.or.(DPPI_pl.and.dimen.eq.4).or.DPPI_sras) 
     &      	D_PAR(4) = SCALE_ML2(IBin_ml,4)
          	  if (dppi_sras)
     &        	D_PAR(5) = SCALE_ML2(IBin_ml,5)
            endif
            A_ALL = A_ALL + A_CALCS(NPART1)*SCALE_P
            B_ALL = B_ALL + B_CALCS(NPART1)*SCALE_P
            A_ALL1 = A_ALL1 + A_CALCS(NPART1)
            B_ALL1 = B_ALL1 + B_CALCS(NPART1)
            a_allls = a_allls + a_calcs(npart1)
            b_allls = b_allls + b_calcs(npart1)
C
c---Extract Sigma
            if (DPPI_no) then
              CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGMA_ML,STL_C,
     &                              I_INTER,SIGMA_IN)  
            else
              CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGN,STL_C,
     &                              I_INTER,SIGN_NOW)  
      	      SIGN_NOW = SIGN_NOW*WT1
              CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP,STL_C,
     &                              I_INTER,SIGP_NOW)  
      	      SIGP_NOW = SIGP_NOW*WT1
              if (.not.DPPI_pl) then
              CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP2(1,1),STL_C,
     &                              I_INTER,SIGP2_NOW(1))
      	      SIGP2_NOW(1) = SIGP2_NOW(1)*WT1
              endif
              CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP2(1,2),STL_C,
     &                              I_INTER,SIGP2_NOW(2))
      	      SIGP2_NOW(2) = SIGP2_NOW(2)*WT1
              sigi_now = 0.
              if (DPPI_mldr.or.DPPI_mad) then
                CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGN2,STL_C,
     &                              I_INTER,SIGN2_NOW)  
      	        SIGN2_NOW = SIGN2_NOW*WT1
                CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP2P,STL_C,
     &                              I_INTER,SIGP2P_NOW)
      	        SIGP2P_NOW = SIGP2P_NOW*WT1
                CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGN2P,STL_C,
     &                              I_INTER,SIGN2P_NOW)  	 
      	        SIGN2P_NOW = SIGN2P_NOW*WT1
                CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGP12,STL_C,
     &                              I_INTER,SIGP12_NOW)
                SIGP12_NOW = SIGP12_NOW*WT1
                CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGH,STL_C,
     &                              I_INTER,SIGH_NOW)  	 
                SIGH_NOW = SIGH_NOW*WT1
              endif
            endif
          ELSE
            CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
            CALL CALC_SCALE_P(RSQ,SCALE_P)

            SIGMA_IN  = 0.0
            SIGMA_IN  = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                                SIGMA_ML_B_OVER*RSQ/4.0
     &                              + SIGMA_ML_B1_OVER*RSQ*RSQ/16.0
            SIGMA_IN = SIGMA_IN    + SIGMA_ML_B2_OVER*RSQ*RSQ*RSQ/64.0
            SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))
          ENDIF             
          SIGMA_IN = SIGMA_IN*WT1
          YO       = FO(IR)
          if (DPPI_sras.or.DPPI_sad.or.DPPI_sadh.or.DPPI_pl.or.
     &        DPPI_sir) then
            do i=1,3              
cc              CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,sigm_N(1,i),STL_C,
cc     &                              I_INTER,SN_NOW(i)) 
cc              CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,sigm_P(1,i),STL_C,
cc     &                              I_INTER,SP_NOW(i)) 
cc              SN_NOW(i) = SN_NOW(i)*WT1
cc              SP_NOW(i) = SP_NOW(i)*WT1
cc      if (PPI.eq.'sras') then
              SN_NOW(i) = sigm_N(IBin_ml,i)*WT1
              SP_NOW(i) = sigm_P(IBin_ml,i)*WT1
cc      endif
C this can happen for instance if datasets are of different resolution
              if (SN_NOW(i).lt.0.001) SN_NOW(i) = 0.
              if (SP_NOW(i).lt.0.001) SP_NOW(i) = 0.
            enddo
          endif
          if (DPPI_sad.or.DPPI_sadh.or.DPPI_sir.or.DPPI_mldr.or.DPPI_pl)
     &    then
            YOP  = FO(dataset_order(1)*NOBS+IR)
            YOM  = FO(dataset_order(2)*NOBS+IR)
            SIGOPL = SIGO(dataset_order(1)*NOBS+IR)
            SIGOMI = SIGO(dataset_order(2)*NOBS+IR)
          else  if (DPPI_sras) then
            YOP  = FO(dataset_order(2)*NOBS+IR)
            YOM  = FO(dataset_order(3)*NOBS+IR)
            SIGOPL  = SIGO(dataset_order(2)*NOBS+IR)
            SIGOMI  = SIGO(dataset_order(3)*NOBS+IR)
          endif
  444     continue
C
c---Call to calculate phase combination and coefficents for 
C---gradient
ccc          ID = OMP_GET_THREAD_NUM()
          ID = 1
          calcABCD=1
          num4phib=0;
          if (DPPI_sad.or.DPPI_sadh) then
        call SAD_DMYFUNCDAB_ML(ICENT,SIGN_NOW,SN_NOW,SP_NOW,
     +  SIGP_NOW,SIGP2_NOW(1),SIGO(IR),SIGOPL,SIGOMI,
     +	YO,YOP,YOM,A_ALL1,B_ALL1,H_A(ir),H_B(ir),IR,PHASE,
     +  D_PAR(1),DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM,PHIB,HL(1),
     +  sigi_now,sigp12_now,DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,
     +  DFDAApp,DFDBBpp,DFDABpp,DFDAppB,ID,VERBREF_5N,calcABCD)
c prerobit toto !!!?
        A_ALL1 = A_ALL1 * D_PAR(2)
        B_ALL1 = B_ALL1 * D_PAR(2)
          else if (DPPI_sir.or.DPPI_mldr.or.DPPI_pl) then
        call SIR_DMYFUNCDAB_ML(ICENT,SIGN_NOW,SIGN2_NOW,SIGN2P_NOW,
     +  SN_NOW,SP_NOW,SIGP_NOW,SIGP2_NOW(1),SIGP2P_NOW,SIGO(IR),
     +	SIGOPL,SIGOMI,YO,YOP,YOM,A_CALCS(NPART1),B_CALCS(NPART1),
     +  H_A(ir),H_B(ir),IR,PHASE,D_PAR(1),
     +  DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM,PHIB,
     +  sigp12_now,SIGH_NOW,DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,
     +  DFDAApp,DFDBBpp,DFDABpp,DFDAppB,ligin1, num4phib,ID)
          else if (DPPI_sras) then
c      write(*,*) 'tttttt',D_PAR(1),D_PAR(2),ibin_ml,SCALE_ML2(Ibin_ml,1)
c        flush(6)
c        if (substruct_flag.and.SP_NOW(2).gt.0.) SIGP_NOW = SP_NOW(2)
        call SIRAS_DMYFUNCDAB_ML(ICENT,SN_NOW(1),SP_NOW(1),SIGN_NOW,
     +  SIGP_NOW,SIGP2_NOW(1),SIGO(IR),SIGOPL,SIGOMI,YO,YOP,YOM,
     +	A_CALCS(NPART1),B_CALCS(NPART1),H_A(ir),H_B(ir),
     +  H_A(ir+NOBS),H_B(ir+NOBS),IR,PHASE,D_PAR(1),
     +  DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM,PHIB,HL,
     +  sigp12_now,sigh_now,DFDAp,DFDBp,DFDApp,DFDBpp,
     +  DFDApAp,DFDBpBp,DFDAppApp,DFDBppBpp, num4phib,ID)
c        A_ALL1 = A_ALL1 * D_PAR(1) 		* D_PAR(2) 
c        B_ALL1 = B_ALL1 * D_PAR(1) 		* D_PAR(2) 
        A_ALL1 = A_ALL1 * D_PAR(2)
        B_ALL1 = B_ALL1 * D_PAR(2)
          else if (DPPI_no) then
              CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
              CALL DFUNCDAB_ML(ndens,ICENT,SIGMA,YO,A_ALL,B_ALL,
     &                        IR,PHASE,
     &                     DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM)
          endif
          if (.not.DPPI_no) then
                  COSC = 1.0
                  SINC = 0.0
                  YC   = SQRT(A_ALL1*A_ALL1+B_ALL1*B_ALL1)
                  IF(YC.GT.0.0) THEN
                    COSC = A_ALL1/YC
                    SINC = B_ALL1/YC
                  ENDIF
      			  COSAA = FOM*COSC
      			  SINAA = FOM*SINC
          endif
c!              endif
          if (SIGO(IR).gt.0.0) THEN
            FVAL_ALL = FVAL_ALL + FVALUE
          endif

cd          DET2 = DFDAA*DFDBB-DFDAB**2
cd          A11  = DFDBB/DET2
cd          A12  = -DFDAB/DET2
cd          A22  = DFDAA/DET2
cd          FOM  = SQRT(COSAA**2+SINAA**2)
cd          WRITE(*,*)YO,1.0-YO**2/SIGMA*(1-FOM**2),1.0/STL_C
C
C---Write Fo and Fc unnormalized and scaled to FC1
C
cd         CALL INTEGRATE_INFO(icent,sigma,yo,a_all,b_all,ir,phase,w_h)
cd        w_h = amax1(0.4,2.0*w_h)
          IF(SIGO(IR).GT.0.0) THEN
            oc_FP%val    = FO(IR)
            oc_SIGFP%val = SIGO(IR)
            if (oc_F1%use.or.oc_SIGF1%use) then
               if (FO(ir+nobs).gt.0.0.and.SIGO(IR+nobs).gt.0.) then
                  oc_F1%val    = FO(IR+nobs)
                  oc_SIGF1%val = SIGO(IR+nobs)
               endif
            endif
            if (oc_F2%use.or.oc_SIGF2%use) then
               if(FO(ir+2*nobs).gt.0.0.and.SIGO(IR+2*nobs).gt.0.) then
                  oc_F2%val    = FO(IR+2*nobs)
                  oc_SIGF2%val = SIGO(IR+2*nobs)
               endif
            endif
          END IF
          if (oc_FREE%use) oc_FREE%val = ABS(FREER(IR))
C---write scaled FC-s. It can be scaled by other programs. Bulk solvent
C---etc have not been applied
c         FCC0 = SQRT(A_ALLl**2+B_ALLl**2)
c         PHCC0 = 0.0
c         if(FCC0.gt.0.0) PHCC0 = atan2(B_ALLl,A_ALLl)
          oc_FC%val = FCC0

          oc_PHIC%val = PHSIGN*RTODEG*PHCC0
          IF(oc_PHIC%val.LT.0.0) oc_PHIC%val = oc_PHIC%val + 360.0

C
C>IJT Add FC_ALL & PHIC_ALL code (from GM).
C---Write scaled FCs.  Bulk solvent correction has been applied.
          IF (A_ALL.EQ.0. .AND. B_ALL.EQ.0.) THEN
            FCC0 = 0.
            PHCC0 = 0.
          ELSE
            FCC0 = SQRT(A_ALL**2+B_ALL**2)
            PHCC0 = ATAN2(B_ALL,A_ALL)
          ENDIF
C
          oc_FC_ALL%val = FCC0
          oc_PHIC_ALL%val = PHSIGN*RTODEG*PHCC0
          IF(oc_PHIC_ALL%val.lt.0.) 
     &       oc_PHIC_ALL%val = oc_PHIC_ALL%val + 360.
c!!!!!
c          if (SIGO(IR).GT.0.0.and.(oc_FB%use.or.oc_PHIB%use)) then 
          if (SIGO(IR).GT.0.0.and.(oc_FB%use.or.oc_PHIB%use).and.
     +      PHIB.ne.-1000.) then 
            oc_FB%val = FOM*FO(IR)
            oc_PHIB%val  = PHSIGN*RTODEG*PHIB
            IF (oc_PHIB%val.LT.0.0) oc_PHIB%val=oc_PHIB%val+360.0
          endif
          if (SIGO(IR).GT.0.0.and.(oc_HLA%use.and.oc_HLB%use)) then 
            oc_HLA%val = HL(1)
            oc_HLB%val = phsign*HL(2)
            if (oc_HLC%use) oc_HLC%val = HL(3)
            if (oc_HLD%use) oc_HLD%val = phsign*HL(4)
          endif
C<IJT

          TESTFREE1   = .true.
          TESTFREE2   = .TRUE.
          testfree3 = .true.
          IF(SIGO(IR).le.0.0) TESTFREE1 = .false.
          if (sigopl.le.0..or.sigomi.le.0.) testfree3 = .false.
          IF(FREER_FLAG) THEN
            IF (ABS(FREER(IR) - LFreeRexcludeVal) .LT.0.1 )
     +        TESTFREE2 = .FALSE.
          END IF
          IF(TESTFREE1  .AND. (TESTFREE2.OR.FREE_FOR_MAP.EQ.'I')) THEN
C---Now write coefficients for 2mfo-dfc and mfo-dfc. Think about centric 
C---refections
cd             IF(ICENT.EQ.0) THEN
cd            A0          = FO(IR)*COSAA/AMAX1(0.0001,SCALE_P) - 
cd     &                              A_CALCS(NPART1)
cd            B0          = FO(IR)*SINAA/AMAX1(0.0001,SCALE_P) - 
cd     &                              B_CALCS(NPART1)
cd            IF(DET2.GT.0.0) THEN
           if (DPPI_no) then
              A0          = (FO(IR)*COSAA - A_ALL)
              B0          = (FO(IR)*SINAA - B_ALL)
           else
              A0          = (FO(IR)*COSAA - A_ALL1)
              B0          = (FO(IR)*SINAA - B_ALL1)
           endif            
cd            ELSE
cd              A0 = 0.0
cd              B0 = 0.0
cd            ENDIF
C
cd            A0  = -(DFDA*A11+DFDB*A12)
cd            B0  = -(DFDA*A12+DFDB*A22)
C
cd             ELSE
cd               A0          = 0.0
cd               B0          = 0.0
cd             ENDIF
            F0          = SQRT(A0*A0+B0*B0)
            PH0         = 0.0
            IF(F0.NE.0.0) PH0 = PHSIGN*ATAN2(B0,A0)*RTODEG
            IF(PH0.LT.0.0) PH0 = PH0 + 360.0
            A1          = FO(IR)*COSAA + A0
            B1          = FO(IR)*SINAA + B0
            F1          = SQRT(A1*A1+B1*B1)
            PH1         = 0.0
            IF(F1.NE.0.0) PH1 = PHSIGN*ATAN2(B1,A1)*RTODEG
            IF(PH1.LT.0.0) PH1 = PH1 + 360.0
            oc_FWT%val = F1*exp(b_sharp_map*rsq/4.0)
            oc_PHWT%val = PH1
            oc_DELFWT%val = F0*exp(b_sharp_map*rsq/4.0)
            oc_PHDELWT%val = PH0
            oc_FOM%val = FOM
            if (oc_PHCOMB%use) then
              PHCOMB = 0.0
              IF(SINAA*SINAA+COSAA*COSAA.GT.0.0) 
     +               PHCOMB=PHSIGN*ATAN2(SINAA,COSAA)*RTODEG
              IF(PHCOMB.LT.0.0)PHCOMB = PHCOMB + 360.0
              oc_PHCOMB%val = PHCOMB
            ENDIF
            if(oc_F_user%use.or.oc_phi_user%use) then
              AUSER       = scale_map_obs*FO(IR)*COSAA - 
     &                              scale_map_calc*A_ALL
              BUSER       = scale_map_obs*FO(IR)*SINAA - 
     &                              scale_map_calc*B_ALL
              oc_f_user%val = sqrt(auser**2+buser**2)*
     &                   exp(b_sharp_map*rsq/4.0)
              oc_phi_user%val = 0.0
              if (oc_f_user%val.gt.0.0) then
                oc_phi_user%val = PHSIGN*ATAN2(buser,auser)*RTODEG
                if (oc_phi_user%val.lt.0.0) 
     &              oc_phi_user%val = oc_phi_user%val + 360.0
              endif
            endif
            if (testfree3) then
            endif
          ELSE IF(FREE_FOR_MAP.EQ.'R') THEN
C
C---Non measured reflection. Assume that <FO> = sumDFC. Then difference
C---map will have zero coefficient and 2fo-fc will have sumDFC
            if (DPPI_no) then
              oc_FWT%val = SQRT(A_ALL*A_ALL+B_ALL*B_ALL)
            else
              oc_FWT%val = SQRT(A_ALL1*A_ALL1+B_ALL1*B_ALL1)
            endif
            PHCC        = 0.0
            if (DPPI_no) then
              IF(oc_FWT%val.GT.0.0) PHCC = ATAN2(B_ALL,A_ALL)
            else
              IF(oc_FWT%val.GT.0.0) PHCC = ATAN2(B_ALL1,A_ALL1)
            endif
             oc_PHWT%val = PHSIGN*PHCC*RTODEG
             IF(oc_PHWT%val.LT.0.0) oc_PHWT%val = oc_PHWT%val + 360.0
             oc_DELFWT%val = 0.0
             oc_PHDELWT%val = 0.0
             oc_FOM%val = 0.0
             if (oc_PHCOMB%use) then
               oc_PHCOMB%val =  PHSIGN*PHCC*RTODEG
               IF(oc_PHCOMB%val.LT.0.0) 
     &            oc_PHCOMB%val = oc_PHCOMB%val + 360.0
             ENDIF
             if (oc_f_user%use.or.oc_phi_user%use) then
               oc_f_user%val = 0.0
               oc_phi_user%val = 0.0
             endif
          ENDIF
c anomalous coefficients.
          IF(TESTFREE3  .AND. (TESTFREE2.OR.FREE_FOR_MAP.EQ.'I')) THEN
            if (oc_PHAN%use.or.oc_FAN%use) then
              F0  = FOM*(YOP-YOM)
              PH0 = oc_PHIC%val - 90.
              if (substruct_flag) PH0 = oc_PHIB%val - 90.
              IF(PH0.LT.0.0) PH0 = PH0 + 360.0
              oc_FAN%val = F0*exp(b_sharp_map*rsq/4.0)
              oc_PHAN%val = PH0
            endif
            if (oc_PHDELAN%use.or.oc_DELFAN%use) then
              F0 = 0.
              if (heavy_sf_model_num.gt.0) then
                F0  = sqrt( (A_CALCS(NPART1)+H_A(ir))**2+
     &                      (B_CALCS(NPART1)+H_b(ir))**2 ) -
     &                sqrt( (A_CALCS(NPART1)-H_A(ir))**2+
     &                      (B_CALCS(NPART1)-H_b(ir))**2 ) 
              endif
              F0  = FOM*(YOP-YOM) - F0*D_PAR(2)
              PH0 = oc_PHIC%val - 90.
              if (substruct_flag) PH0 = oc_PHIB%val - 90.              
              IF(PH0.LT.0.0) PH0 = PH0 + 360.0
              oc_DELFAN%val = F0*exp(b_sharp_map*rsq/4.0)
              oc_PHDELAN%val = PH0
            endif
          ELSE IF(FREE_FOR_MAP.EQ.'R') THEN
            if (oc_PHAN%use.or.oc_FAN%use) then
              if (heavy_sf_model_num.gt.0) then
                 F0  = sqrt( (A_CALCS(NPART1)+H_A(ir))**2+
     &                       (B_CALCS(NPART1)+H_b(ir))**2 ) -
     &                 sqrt( (A_CALCS(NPART1)-H_A(ir))**2+
     &                       (B_CALCS(NPART1)-H_b(ir))**2 ) 
              endif
c               F0 = YOP - YOM
              PH0 = oc_PHIC%val - 90.
              if (substruct_flag) PH0 = oc_PHIB%val - 90.              
              IF(PH0.LT.0.0) PH0 = PH0 + 360.0
              oc_FAN%val = F0*D_PAR(2)
              oc_PHAN%val = PH0
            endif
            if (oc_PHDELAN%use.or.oc_DELFAN%use) then
              oc_DELFAN%val = 0.
              oc_PHDELAN%val = 0.
            endif
          ENDIF
        ENDIF
        if ((oc_PHAN%use.or.oc_FAN%use).and.oc_FAN%val.lt.0.) then
          oc_FAN%val = - oc_FAN%val
          oc_PHAN%val = oc_PHAN%val - 180.
          IF(oc_PHAN%val.LT.0.0) oc_PHAN%val = oc_PHAN%val + 360.0
        endif
c         do i=1,dataset_num_tot
c           if (SIGO(dataset_order(i)*NOBS+IR).GT.0.0) then
c             BDATA(IOUT)=FO(dataset_order(i)*NOBS+IR)
c             BDATA(IOUT+1)=SIGO(dataset_order(i)*NOBS+IR)
c           endif
c           IOUT = IOUT + 2
c         enddo
         call make_BDATA_OUT(BDATA,bdata_num,labout_map)
c!$OMP CRITICAL(LWREFL)
         CALL LWREFL(MTZOUT,BDATA)
c!$OMP END CRITICAL(LWREFL)
100      CONTINUE
       ENDDO
C
C--Careful. Check it
C
cd       NOBS = NREF
       write(6,*)  'Function value in mtzwrite : ', FVAL_ALL
ccb       call flush(6)
       CALL LWCLOS(MTZOUT,0)
       RETURN
       END
C

C
cd      SUBROUTINE BIAS_CALCULATE(NREF,NIND,FO,SIGO,FC,SCALE_BIAS,B_BIAS)
cd      IMPLICIT NONE
C
cd      INTEGER NREF
cd      INTEGER NIND(*)
cd      REAL FO(*),FC(nobs,ndens),SIGO(*)
cd      REAL SCALE_BIAS,B_BIAS
C
C---  local variables
cd      INTEGER IR,ISYSAB,ICENT
cd      INTEGER IHH(3)
cd      REAL RSQ,STL_C,EPSI,WT1
cfut      
cfut      SCALE_BIAS = 1.0
cfut      B_BIAS     = 0.0
C
cfut      DO IR=1,NREF
C       
cfut        IF(SIGO(IR).GT.0.0) THEN
cfut          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
cfut          CALL INDTORS(NIND(IR),RSQ)
cfut          STL_C = SQRT(RSQ)
cfut          CALL CENTR(IHH,ICENT)
cfut          CALL EPSLON(IHH,EPSI,ISYSAB)
cfut          WT1 = DBLE(ICENT+1)*DBLE(EPSI)
cfut          CALL CALC_TCHEB_APPROX_CLENSHW(N_COEFS,SCURRENT,TCH_COEFS,
cfut     &                 SIGMA_IN)
cfut          SIGMA_IN  = SIGMA_IN + SIGMA_ML_SCALE_OVER-
cfut     &                                 SIGMA_ML_B_OVER*RSQ
cfut          SIGMA_IN  = EXP(AMAX1(1.0,AMIN1(30.0,SIGMA_IN)))*WT1
cfut          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
cfut          CALL EXTRACT_ABS(IR,ndens,FC,PHASE,A_CALCS,B_CALCS)
c---Now find D multiplied A_all and B_all
cfut          CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
cfut     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
cfut          CALL CALC_SCALE_P(RSQ,SCALE_P)
c---Call to calculate phase combination and coefficents for 
C---gradient
cfut          CALL DFUNCDAB_ML(ndens,ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,
cfut     &                     DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM)
cfut              A0          = (FO(IR)*COSAA - A_ALL)
cfut              B0          = (FO(IR)*SINAA - B_ALL)
cfut              B(1) = 
cfut              B(2) =
cfut              A(1,1) = 
cfut              A(1,2) = 
cfut              A(2,2) = 
cfut              FVALUE = 
cfut        ENDIF
cfut      ENDDO
C
C---Solve equation and apply shifts
cfut      CALL DEIGEN
C
C---Line minimiser

cfut      write(*,*)scale_bias,b_bias

cfut      RETURN
cfut      END
C
       SUBROUTINE FOMPHASE2AB(ICENT,FOM,PHASE,HLA,HLB)
C
C--Calculates Hendrickson and Lattman A and B from FOM and PHIbest
C
       INCLUDE 'const.fh'
       INCLUDE 'expcost.fh'
       REAL HLA,HLB
C
       IF(FOM.GT.0.9999) FOM = 0.9999
       IF(FOM.EQ.0.0) THEN
          XX = 0.0
       ELSEIF(FOM.LE.0.9999) THEN
         IF(ICENT.NE.0) THEN
          XX = LOG((1+FOM)/(1-FOM))*0.5
         ELSE
          DO  J=2,19
            IF(ABTAB(J).GT.FOM) GOTO 40
          ENDDO
40        XX = ((FOM-ABTAB(J-1))/ (ABTAB(J)-ABTAB(J-1))+REAL(J-2))/3.0
         ENDIF
       ELSE
         XX =  6.00
       ENDIF
       HLA = COS(DEGTOR*PHASE)*XX
       HLB = SIN(DEGTOR*PHASE)*XX
       RETURN
       END
C
       SUBROUTINE BESSTAB
       INCLUDE 'expcost.fh'
C
       DO     J=1,20
          XX = REAL(J-1)/3.0
          ABTAB(J) = (XX+0.4807)*XX/ ((XX+0.8636)*XX+1.3943)
       ENDDO
       RETURN
       END
C
      subroutine saveinit_restore_occ_for_excl(save,nmodel,natom_max,
     &   nanom,occupancy_save,init_val)
C
C---prepares atoms to be excluded/included from various options (in ideal world)
C---save=true: converts occupancy of atoms to be init_val (usually 0 for exclusion)
C---save=false: restores occupancies back to their original values before exclusion
C---
c  will need to define excl stuff for more models if we  want this for more models
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'refi_flags.fh'
      include 'anom.fh'
      logical save
      integer nmodel,natom_max, nanom
      real, dimension(natom_max,nmodel,nanom+1) :: occupancy_save
      real init_val
      integer ia,im,natom_im,iexcl,ires_num_loc
      character chnid_loc*4
c
      do im=1,nmodel
        natom_im = n_atom_mod(im)
c save
        if (save) then
          occupancy_save(1:natom_im,im,1)=occup_mod(1:natom_im,im)
          if (nanom.gt.0) occupancy_save(1:natom_im,im,2) = 
     &              occup_anom_mod(1:natom_im,im)
        endif
        if(excl_refi_num.gt.0) then
          do   ia=1,natom_im
            call get_chain_namepdb(chnid_loc,i_resid_mod(ia,im))
            read(res_num_pdb(i_resid_mod(ia,im))(3:6),*)ires_num_loc 
            do   iexcl=1,excl_refi_num
              if(excl_refi_begin(iexcl).le.ires_num_loc.and.
     &              excl_refi_end(iexcl).ge.ires_num_loc.and.
     &              excl_refi_chn(iexcl).eq.chnid_loc) then
c set initial values
                if (save) then
                  if (im.eq.1) occup(ia) = init_val
                  occup_mod(ia,im) = init_val
c restore
                else
                  if (im.eq.1) occup(ia) = occupancy_save(ia,im,1)
                  occup_mod(ia,im) = occupancy_save(ia,im,1)
                endif
                if (nanom.gt.0) then
                  if (save) then
                    if (im.eq.1) occup_anom(ia) = init_val
                    occup_anom_mod(ia,1) = init_val
                  else
                    if(im.eq.1) occup_anom(ia) = occupancy_save(ia,im,2)
                    occup_anom_mod(ia,im) = occupancy_save(ia,im,2)
                  endif
                endif
              endif
            enddo
          enddo
        endif
      enddo
      return
      end
