      subroutine mtz_write_twin(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'atom_com.fh'
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'map_params.fh'
      include 'restr_files.fh'
      include 'mtz_things.fh'
      include 'anom.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
      integer ierr
c
c
c
c---mtz writing. move to another routine
      integer c_s,c_f,c_n,j
      real, allocatable :: fexpected(:,:)
      real, allocatable :: fomcalc(:)
      integer, allocatable :: asym_2_obs(:)
c
      real a_all(2)
      real sc_p,ss
      real stl_c,rsq
      integer ip,ibin
      integer mtzout,iout,icell,iappnd,ib,i,i_inter
      integer, parameter :: bdata_num = 50
      real bdata(bdata_num)
      real a0,b0,a1,b1,f0,f1,ph0,ph1,scale_now
      real auser,buser
      real rtodeg
      real lstlsq_r
      external lstlsq_r
      integer labout_map(prgo)
c
      logical test_free

c
c---  body
C-----the PHIB and FB labels are to be output if substructure ref. 
C     (can't be done in rcard since detection of twin and substructure is done later)
      if (.not.substruct_flag) then
        oc_FB%use = .false.
        oc_PHIB%use = .false.
        oc_HLA%use = .false.
        oc_HLB%use = .false.
        oc_HLC%use = .false.
        oc_HLD%use = .false.
      else
        oc_PHIC_ALL%use = .false.
        oc_FC_all%use = .false.
      endif
c
      call make_PRGO(labout_map)
      rtodeg = 45.0/atan2(1.0,1.0)
      allocate(fexpected(2,nasym))
      allocate(fomcalc(nasym))
      allocate(asym_2_obs(nasym))

      asym_2_obs(1:nasym) = -1
      do i=1,num_blocks
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         do j=c_s,c_f
            c_n = block_2_asym(j)
            asym_2_obs(j) = i
         enddo
      enddo
c
      call find_fexpected_ml(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,fexpected,fomcalc,
     &     ierr)
c
c
c---test mtz
      MTZOUT = 2
      IAPPND = 0
      CALL LWOPEN(MTZOUT,'HKLOUT')
      CALL LWTITL(MTZOUT,'  Output mtz file from refmac',1)
      DO    ICELL=4,6
        IF(CELL(4).LE.5.0.AND.CELL(5).LE.5.0.AND.CELL(6).LE.5.0) THEN
          CELL(4) = CELL(4)*RTODEG
          CELL(5) = CELL(5)*RTODEG
          CELL(6) = CELL(6)*RTODEG
        ENDIF
      ENDDO
      CALL LWCELL(MTZOUT,CELL)
      CALL LWSORT(MTZOUT,ISORT)
C
      NumPrimSymm = NumSymmetry/NSMULT
C            ******************************
      CALL LWSYMM(MTZOUT,
     +                NumSymmetry,
     +                 NumPrimSymm,
     +                  RealSymmMatrx,
     +                   Ltype,
     +                    NumSpaceGroup,
     +                     SpaceGroupName,
     +                      PointGroupName)
      CALL LWASSN(MTZOUT,LSPRGO,NLPRGO,CTPRGO,IAPPND)

C Store the project name and dataset name in the mtz header:

      IF (NDATASETS.GT.0) THEN
        DO ISET = 1,NDATASETS
          CALL LWIDX(MTZOUT,PNAME(ISET),XNAME(ISET),DNAME(ISET),
     +                      DATCELL(1,ISET),DATWAVE(ISET))
        ENDDO
        CALL LWIDASX(MTZOUT,NLPRGO,XNAME_OUT,DNAME_OUT,IAPPND)
      ENDIF
c
      i_inter = -1
      do i=1,nasym
         CALL EQUAL_MAGIC(MTZOUT,BDATA,nlprgo)
         labouts(labout_map(1:nlprgo))%val = bdata(1:nlprgo)
c
c---  hkl
         labouts(1:3)%val = hkl_asym(1:3,i)
c
c---  FreeR set
         if(asym_2_obs(i).gt.0) then
           if (oc_FREE%use) oc_FREE%val = freer(asym_2_obs(i))
         endif
         rsq = 4.0*lstlsq_r(1,hkl_asym(1:3,i))
         stl_c = sqrt(rsq)
         do ib=1,nbin_ml
            if(stl_c.ge.sminb_ml(ib).and.stl_c.le.smaxb_ml(ib))
     &           then
               ibin = ib
               goto 50
            endif
         enddo
         if(stl_c.ge.smaxb_ml(nbin_ml))ibin = nbin_ml
         if(stl_c.le.sminb_ml(1)) ibin = 1
 50      continue
         if (oc_FC%use.and.oc_PHIC%use) then
            oc_FC%val = sqrt(fcalc(1,i)**2+fcalc(2,i)**2)
            oc_PHIC%val = rtodeg*atan2(fcalc(2,i),fcalc(1,i))
         endif
c
         call linter_value2(nbin_ml,smeanb_ml,scale_ml(1,1),
     &        stl_c,i_inter,scale_now)
         a_all(1) = scale_now*fcalc(1,i)
         a_all(2) = scale_now*fcalc(2,i)
         ss = lstlsq_r(1,hkl_asym(1:3,i))
         sc_p  = scale_ls_over*exp(-b_ls_over*ss)*
     &        (1.0-scale_ls_bulk*exp(-b_ls_bulk*ss))
         sc_p = sqrt(sc_p)*scale_ml(ibin,1)
         do ip=1,npart_act
            call linter_value2(nbin_ml,smeanb_ml,scale_ml(1,ip+1),
     &           stl_c,i_inter,scale_now)
            a_all(1)=a_all(1)+scale_now*fpart(ip,1,i)
            a_all(2)=a_all(2)+scale_now*fpart(ip,2,i)
         enddo
         if (oc_FC_ALL%use.and.oc_PHIC_ALL%use) then
            oc_FC_ALL%val = sqrt(a_all(1)**2+a_all(2)**2)
            oc_PHIC_ALL%val = rtodeg*atan2(a_all(2),a_all(1))
         endif
c
c---Observation exists
         test_free = .FALSE.
         if(asym_2_obs(i).gt.0) then
            if(fmax(1,i).gt.0.0.and.freer(asym_2_obs(i)).gt.0.or.
     &           free_for_map.eq.'I') test_free = .TRUE.
         endif
         if (test_free) then          
            if(oc_FREE%use) oc_FREE%val = freer(asym_2_obs(i))
            if (oc_FP%use) oc_FP%val = fmax(1,i)
            if (oc_SIGFP%use) oc_SIGFP%val = fmax(2,i)

            a0 = fexpected(1,i)-a_all(1)
            b0 = fexpected(2,i)-a_all(2)
            f0 = sqrt(a0**2+b0**2)
            ph0 = rtodeg*atan2(b0,a0)
            a1 = 2.0*a0 + a_all(1)
            b1 = 2.0*b0 + a_all(2)
            f1 = sqrt(a1**2+b1**2)
            ph1 = rtodeg*atan2(b1,a1)
            if (oc_FWT%use.and.oc_PHWT%use) then
              oc_FWT%val = f1*exp(b_sharp_map*rsq/4.0)
              oc_PHWT%val = ph1
            endif

            if (oc_DELFWT%use.and.oc_PHDELWT%use) then
              oc_DELFWT%val = f0*exp(b_sharp_map*rsq/4.0)
              oc_PHDELWT%val = ph0
            endif
            if (oc_FOM%use) oc_FOM%val = fomcalc(i)
            if(oc_F_user%use.or.oc_phi_user%use) then
              auser       = scale_map_obs*fexpected(1,i) - 
     &                              scale_map_calc*a_all(1)
              buser       = scale_map_obs*fexpected(2,i) - 
     &                              scale_map_calc*a_all(2)
              oc_f_user%val = sqrt(auser**2+buser**2)*
     &                   exp(b_sharp_map*rsq/4.0)
              oc_phi_user%val = 0.0
              if (oc_f_user%val.gt.0.0) then
                oc_phi_user%val = rtodeg*ATAN2(buser,auser)
                if (oc_f_user%val.lt.0.0) 
     &              oc_phi_user%val = oc_phi_user%val + 360.0
              endif
            endif
         else if(free_for_map.eq.'R') then
           if (oc_FREE%use) oc_FREE%val = 0
            if(oc_FWT%use.and.oc_PHDELWT%use) then
               oc_FWT%val = sqrt(a_all(1)**2+a_all(2)**2)
               oc_FWT%val = oc_FWT%val*exp(b_sharp_map*rsq/4.0)
               oc_PHWT%val = 0.0
               if(oc_FWT%val .gt. 0.0) 
     &              oc_PHWT%val=rtodeg*atan2(a_all(2),a_all(1))
            endif
            if(oc_DELFWT%use.and.oc_PHDELWT%use) then
               oc_DELFWT%val = 0.0
               oc_PHDELWT%val = 0.0
            endif
            if(oc_FOM%use) oc_FOM%val = 0.0
            if(oc_PHCOMB%use) then
               oc_PHCOMB%val = rtodeg*atan2(a_all(2),a_all(1))
            endif
            if (oc_f_user%use.or.oc_phi_user%use) then
               oc_f_user%val = sqrt(a_all(1)**2+a_all(2)**2)
               oc_f_user%val = oc_f_user%val*exp(b_sharp_map*rsq/4.0)
               oc_phi_user%val = 0.0
               if(oc_f_user%val.gt.0.0) 
     &              oc_phi_user%val = rtodeg*atan2(a_all(2),a_all(1))
            endif
         endif
         call make_BDATA_OUT(BDATA,bdata_num,labout_map)
         call lwrefl(mtzout,bdata)
      enddo
      call lwclos(mtzout,0)
      deallocate(fexpected)
      deallocate(fomcalc)
      deallocate(asym_2_obs)
      return
      end
