C
c calculates heavy atoms and anomalous contributions for every reflection
c for SAD: H_A(ir),H_B(ir) store f'' contributions
c for SIR: H_A(ir),H_B(ir) store heavy atoms contributions
c for SIRAS: H_A(ir),H_B(ir) store f and f' contributions, H_A(ir+NOBS) f'' contributions
c for MAD: H_A(ir),H_B(ir) store f'' contribs for 1. wavelength, H_A(ir+NOBS) f'' contribs for 2. wl and
c can also store the "normal" contributions from heavy atoms for SAD if using separate heavy atom file (deprecated)
      SUBROUTINE CALC_HEAVY(NREF,ndens,NIND,H_A,H_B,FC,PHASE,FREER)
C
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'anom.fh'
C
      INTEGER NREF,ndens
      INTEGER NIND(*)
      
      REAL    FC(nobs,ndens),PHASE(nobs,ndens),FREER(*)
      REAL H_A(*),H_B(*)
      INTEGER I,ir,ICENT,ISYSAB,IB,IHH(3),rewr_sf
      REAL stol2, TWO_PI_XH, RSQ
      real fpp_now,fp_now,f_now, exp20stol2, expBstol2, HH(3), XS,YS,ZS
      real fpp2_now,fp2_now,f2_now
      integer IS, IT, AIT, ibin, IPOS, ia, ih, j, wave_pos, wave_pos2
      real cos_temp, sin_temp
      real hpa,hpb
      EXTERNAL UNPACK,CENTR,EPSLON
      LOGICAL FREERCHK,lg
ccc      ,A_CALCS(NMAXPART),B_CALCS(NMAXPART)
      REAL ERR
      CHARACTER FILE_NAME*256
C
      INCLUDE 'tabfunc.fh'
C
c
      do IS=1,CS_NSYM
        call MAT2MAT(3,3,CS_M_CS(1,1,IS),CS_ORT_TO_FRAC,
     +     SYM_ORT_M(1,1,IS),ERR)
c        do IH=1,NUM_HEAVY
c          call MAT2VEC(3,3,SYM_ORT_M(1,1,IS),H_C(1,IH),
c     +      XYZ_2PI(1,IH,IS),ERR)
c          XYZ_2PI(1,IH,IS) = TWOPI*( XYZ_2PI(1,IH,IS) + CS_V_CS(1,IS) )
c          XYZ_2PI(2,IH,IS) = TWOPI*( XYZ_2PI(2,IH,IS) + CS_V_CS(2,IS) )
c          XYZ_2PI(3,IH,IS) = TWOPI*( XYZ_2PI(3,IH,IS) + CS_V_CS(3,IS) )
c        enddo
      enddo
c
      write(6,'(A,i3,A)') 'There is ',n_atom_ano,' anomalously '//
     +  'scattering/heavy atoms.'
      if (VERBREF_5N) then
        write(6,*) 'HEAVY ATOMS PARAMATERS: '
        do ia = 1, N_ATOM+n_atom_ano
          if (cs_anom(ID_SF(ia))) then 
            write(6,'(i5,A,A5,f8.3,f8.3,f8.3,f6.2,f6.3)') 
     +        ia,' ',cs_element(id_sf(ia)),XYZ_CRD(1,ia),XYZ_CRD(2,ia),
     +        XYZ_CRD(3,ia),(U_ANISO(1,ia)-u_add_loc)*PISQ8,OCCUP(ia)
          endif
        enddo
      endif
C
      do ir = 1, NREF
        H_A(ir) = 0.
        H_B(ir) = 0.
        CALL INDTORS(NIND(IR),RSQ)
c        STL_C = SQRT(RSQ)
        CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
        CALL CENTR(IHH,ICENT)
        IF (ICENT.eq.1.and.(DPPI_sad.or.DPPI_sadh)) goto 125
c        CALL EPSLON(IHH,EPSI,ISYSAB)
        HH(1) = FLOAT(IHH(1))
        HH(2) = FLOAT(IHH(2))
        HH(3) = FLOAT(IHH(3))
c        CALL EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
      	stol2 = RSQ/4
c        exp20stol2 = exp(-(10.+B_LS_OVER)*stol2)
c  +B_LS_OVER
        HPA=0
        HPB=0

        wave_pos = dataset_wavenum(dataset_order(2))
        if (DPPI_mad)
     +    wave_pos2 = dataset_wavenum(dataset_order(3))
        do ia = 1, n_atom+n_atom_ano
        if (cs_anom(ID_SF(ia))) then 
          IT=ID_SF(ia)
          AIT=t2at(IT)
c isotropic temp. factor
c          x_arg = ((U_ANISO(1,ia)-u_add_loc)*PISQ8+B_LS_OVER)*stol2
          x_arg = U_ANISO(1,ia)*PISQ8*stol2
c 	just calling tabulated exp... is there any other more clever way of doing it without subroutine call (which is too expensive) ? 
          if (x_arg.gt.0..and.x_arg.lt.50.) then
            tab_i = getexpint(x_arg)
            x_diff = getexpdiff(x_arg,tab_i)
            x_diff_sq = x_diff*x_diff		
            expBstol2 = expf(x_diff,x_diff_sq,tab_i)
          else
            expBstol2 = exp(-x_arg)
          endif
      	  f_now = 0
      	  do j = 1,4
            x_arg = CS_B(j,IT)*stol2
            if (x_arg.gt.0..and.x_arg.lt.50.) then
              tab_i = getexpint(x_arg)
              x_diff = getexpdiff(x_arg,tab_i)
              x_diff_sq = x_diff*x_diff		
         	  f_now = f_now + CS_A(j,IT)*expf(x_diff,x_diff_sq,tab_i)
            else
         	  f_now = f_now + CS_A(j,IT)*exp(-x_arg)
            endif
      	  enddo  
          f_now = ( f_now + CS_A(5,IT)+fprime(AIT,wave_pos) ) *OCCUP(ia)
c for SAD, f' is already included in cs_a
          if (DPPI_sad.or.DPPI_sadh)  
     +      f_now = f_now - fprime(AIT,wave_pos)*OCCUP(ia)
          if (DPPI_mad)  then
            f2_now = ( f_now + CS_A(5,IT) + fprime(AIT,wave_pos2) )
     +        * OCCUP(ia)
            fp2_now =  fprime(AIT,wave_pos2)    *OCCUP(ia)
            fpp2_now = f2prime(AIT,wave_pos2)   *OCCUP(ia)
          endif
          if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras.or.
     +      DPPI_mad)
     +		fpp_now = f2prime(AIT,wave_pos)  *OCCUP(ia)
          do IS=1,CS_NSYM
            XS=( SYM_ORT_M(1,1,IS)*XYZ_CRD(1,ia) +
     *           SYM_ORT_M(1,2,IS)*XYZ_CRD(2,ia) + 
     *           SYM_ORT_M(1,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(1,IS) )
            YS=( SYM_ORT_M(2,1,IS)*XYZ_CRD(1,ia) +
     *           SYM_ORT_M(2,2,IS)*XYZ_CRD(2,ia) +
     *           SYM_ORT_M(2,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(2,IS) )
            ZS=( SYM_ORT_M(3,1,IS)*XYZ_CRD(1,ia) + 
     *           SYM_ORT_M(3,2,IS)*XYZ_CRD(2,ia) +
     *           SYM_ORT_M(3,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(3,IS) )
            TWO_PI_XH = TWOPI*( XS*HH(1) + YS*HH(2) + ZS*HH(3) )
c            TWO_PI_XH = XYZ_2PI(1,IH,IS)*HH(1) + XYZ_2PI(2,IH,IS)*HH(2)
c     +            + XYZ_2PI(3,IH,IS)*HH(3)
            if (TWO_PI_XH.gt.TWOPI) TWO_PI_XH = normtrigbig(TWO_PI_XH)
            if (TWO_PI_XH.lt.0.)  TWO_PI_XH = normtrigsmall(TWO_PI_XH)
            tab_i = gettrigint(TWO_PI_XH)
            x_diff = gettrigdiff(TWO_PI_XH,tab_i)
            x_diff_sq = x_diff*x_diff		
            cos_temp = cosf(x_diff,x_diff_sq,tab_i)*expBstol2
            sin_temp = sinf(x_diff,x_diff_sq,tab_i)*expBstol2
c            cos_temp = cos(TWO_PI_XH)*expBstol2
c            sin_temp = sin(TWO_PI_XH)*expBstol2
            if (DPPI_sad.or.DPPI_sadh) then
c        exp20stol2 = exp(-(B(ia)+B_LS_OVER)*stol2)
c          	  HPA = HPA + fp_now*expBstol2*cos(TWO_PI_XH)
c          	  HPB = HPB + fp_now*expBstol2*sin(TWO_PI_XH)
          	  HPA = HPA + f_now*cos_temp
          	  HPB = HPB + f_now*sin_temp
          	  H_B(ir) = H_B(ir) + fpp_now*cos_temp
          	  H_A(ir) = H_A(ir) - fpp_now*sin_temp
            endif
            if (DPPI_mad) then
          	  HPA = HPA + (f2_now-fp2_now)*cos_temp
          	  HPB = HPB + (f2_now-fp2_now)*sin_temp
          	  H_B(ir) = H_B(ir) + fpp_now*cos_temp
          	  H_A(ir) = H_A(ir) - fpp_now*sin_temp
          	  H_B(ir+NOBS) = H_B(ir+NOBS) + fpp2_now*cos_temp
          	  H_A(ir+NOBS) = H_A(ir+NOBS) - fpp2_now*sin_temp
          	  H_A(ir+2*NOBS) = H_A(ir+2*NOBS) + f_now*cos_temp
          	  H_B(ir+2*NOBS) = H_B(ir+2*NOBS) + f_now*sin_temp
          	  H_A(ir+3*NOBS) = H_A(ir+3*NOBS) + f2_now*cos_temp
          	  H_B(ir+3*NOBS) = H_B(ir+3*NOBS) + f2_now*sin_temp
            endif
            if (DPPI_sras)then
          	  H_B(ir+NOBS) = H_B(ir+NOBS) + fpp_now*cos_temp
          	  H_A(ir+NOBS) = H_A(ir+NOBS) - fpp_now*sin_temp
            endif
            if (DPPI_sir.or.DPPI_mldr.or.DPPI_sras)then
          	  H_A(ir) = H_A(ir) + f_now*cos_temp
          	  H_B(ir) = H_B(ir) + f_now*sin_temp
            endif
            if (DPPI_sad.or.DPPI_sadh.or.DPPI_sras)then
              H_A(ir+(heavy_sf_model_num-1)*NOBS) = HPA
              H_B(ir+(heavy_sf_model_num-1)*NOBS) = HPB
            endif
          enddo
        endif
        enddo        
125     continue
      enddo
c      stop
      END
C
C
C
      SUBROUTINE SAD_HEAVY_DER(NREF,IR,HH,stol2,H_A,H_B,DFDA,DFDB,
     +   DFDAA,DFDAB,DFDBB,DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,
     +   DFDAApp,DFDBBpp,DFDABpp,DFDAppB,A_ALL,B_ALL,ibin)
C
      IMPLICIT NONE
C
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'anom.fh'
c
      REAL H_A(*),H_B(*)
      real HH(*),stol2,DFDA,DFDB,DFDAA,DFDAB,DFDBB,A_ALL,B_ALL
      real DFDApp,DFDBpp,DFDAppApp,DFDAppBpp,DFDBppBpp,DFDAApp,DFDBBpp,
     &     DFDABpp,DFDAppB
      INTEGER NREF,IR,ICENT,IB
      real XS,YS,ZS,TWO_PI_XH
      real fpp_now, expBstol2, f_now, der_now
      integer NHA_ACT, IS, IT, AIT, ibin, ia, ih, i, j, k, act, wave_pos
      real der_trig_arg(3),der_triga_now,sin_temper,cos_temper
      real f_cos_temp, f_sin_temp, fpp_cos_temp, fpp_sin_temp, modncycl2
c
      real derApos(3),derBpos(3),derAPPpos(3),derBPPpos(3),
     &     der2Apos(6),der2Bpos(6),der2APPpos(6),der2BPPpos(6),
     &     derAtemp,derBtemp,derAPPtemp,derBPPtemp,
     &     der2Atemp,der2Btemp,der2APPtemp,der2BPPtemp,
     &     derAocc,derBocc,derAPPocc,derBPPocc,derAPPfpp,derBPPfpp
      logical full
      CHARACTER FILE_NAME*256
c
      INCLUDE 'tabfunc.fh'      
C
      modncycl2 = mod(ncycl,2)
      wave_pos = dataset_wavenum(dataset_order(2))
      ih=0
      CALL UGTENV('HEAVYIN',FILE_NAME)
      full=.false.
      if (FILE_NAME(1:1).ne.' ')  full=.true.
      do ia = 1, n_atom+n_atom_ano
      if (cs_anom(ID_SF(ia))) then 
        IT=ID_SF(ia)
        AIT=t2at(it)
        ih=ih+1
        if ( HREF_COOR_FLAG ) then
          do j = 1, 3
            derApos(j) = 0
            derBpos(j) = 0
            derAPPpos(j) = 0
            derBPPpos(j) = 0
          enddo
          do j = 1, 6
            der2Apos(j) = 0
            der2Bpos(j) = 0
            der2APPpos(j) = 0
            der2BPPpos(j) = 0
          enddo
        endif
        if ( HREF_TEMP_FLAG.and.((.not.HREF_OCC_FLAG).or.modncycl2.eq.0
     +    .or..not.full) ) then
          derAtemp = 0
          derBtemp = 0
          derAPPtemp = 0
          derBPPtemp = 0
          der2Atemp = 0
          der2Btemp = 0
          der2APPtemp = 0
          der2BPPtemp = 0
        endif
        if ( HREF_OCC_FLAG.and.( (.not.HREF_TEMP_FLAG).or.modncycl2.eq.1
     +    .or..not.full) ) then
          derAocc = 0
          derBocc = 0
          derAPPocc = 0
          derBPPocc = 0
        endif
        if (HREF_FPP_FLAG) then 
ccc          do i=1,nform_ano+CS_NSFATM
ccc            if (cs_anom(i)) then
              derAPPfpp = 0
              derBPPfpp = 0
ccc            endif
ccc          enddo
        endif
c isotropic temp. factor
c have to subtract u_add_loc here (because thi routine is called from propi before u_add_loc is subtracted)
        x_arg = ((U_ANISO(1,ia)-u_add_loc)*PISQ8+B_LS_OVER)*stol2
c        x_arg = (U_ANISO(1,ia)-u_add_loc)*PISQ8*stol2
        if (x_arg.gt.0..and.x_arg.lt.50.) then
          tab_i = getexpint(x_arg)
          x_diff = getexpdiff(x_arg,tab_i)
          x_diff_sq = x_diff*x_diff		
          expBstol2 = expf(x_diff,x_diff_sq,tab_i)
        else
          expBstol2 = exp(-x_arg)
        endif
      	f_now = 0
      	do j = 1,4
          x_arg = CS_B(j,IT)*stol2
          if (x_arg.gt.0..and.x_arg.lt.50.) then  
            tab_i = getexpint(x_arg)
            x_diff = getexpdiff(x_arg,tab_i)
            x_diff_sq = x_diff*x_diff		
            f_now = f_now + CS_A(j,IT)*expf(x_diff,x_diff_sq,tab_i)
          else
            f_now = f_now + CS_A(j,IT)*exp(-x_arg)
          endif
      	enddo
        f_now =( f_now + CS_A(5,IT) )  *OCCUP(ia)
        fpp_now = f2prime(AIT,wave_pos) *OCCUP(ia)
        do IS=1,CS_NSYM
c          TWO_PI_XH = XYZ_2PI(1,IH,IS)*HH(1) + XYZ_2PI(2,IH,IS)*HH(2)
c     +              + XYZ_2PI(3,IH,IS)*HH(3)
          XS=( SYM_ORT_M(1,1,IS)*XYZ_CRD(1,ia) +
     *         SYM_ORT_M(1,2,IS)*XYZ_CRD(2,ia) + 
     *         SYM_ORT_M(1,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(1,IS) )
          YS=( SYM_ORT_M(2,1,IS)*XYZ_CRD(1,ia) +
     *         SYM_ORT_M(2,2,IS)*XYZ_CRD(2,ia) +
     *         SYM_ORT_M(2,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(2,IS) )
          ZS=( SYM_ORT_M(3,1,IS)*XYZ_CRD(1,ia) + 
     *         SYM_ORT_M(3,2,IS)*XYZ_CRD(2,ia) +
     *         SYM_ORT_M(3,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(3,IS) )
          TWO_PI_XH = TWOPI*( XS*HH(1) + YS*HH(2) + ZS*HH(3) )
c        write(6,*) SYM_ORT_M(1,1,IS),SYM_ORT_M(1,2,IS),SYM_ORT_M(1,3,IS)
c        write(6,*) SYM_ORT_M(2,1,IS),SYM_ORT_M(2,2,IS),SYM_ORT_M(2,3,IS)
c        write(6,*) SYM_ORT_M(3,1,IS),SYM_ORT_M(3,2,IS),SYM_ORT_M(3,3,IS)
            if (TWO_PI_XH.gt.TWOPI) TWO_PI_XH = normtrigbig(TWO_PI_XH)
            if (TWO_PI_XH.lt.0.)  TWO_PI_XH = normtrigsmall(TWO_PI_XH)
            tab_i = gettrigint(TWO_PI_XH)
            x_diff = gettrigdiff(TWO_PI_XH,tab_i)
            x_diff_sq = x_diff*x_diff
            cos_temper = cosf(x_diff,x_diff_sq,tab_i)*expBstol2
            sin_temper = sinf(x_diff,x_diff_sq,tab_i)*expBstol2
c            cos_temper = cos(TWO_PI_XH)*expBstol2
c            sin_temper = sin(TWO_PI_XH)*expBstol2
            f_cos_temp = f_now*cos_temper
            f_sin_temp = f_now*sin_temper
            fpp_cos_temp = fpp_now*cos_temper
            fpp_sin_temp = fpp_now*sin_temper
c   deriv. of A,B,App,Bpp wrt coordinates
          if ( HREF_COOR_FLAG ) then
          do j = 1,3
            der_trig_arg(j) = TWOPI*( HH(1)*SYM_ORT_M(1,j,IS) +
     +                                HH(2)*SYM_ORT_M(2,j,IS) + 
     +                                HH(3)*SYM_ORT_M(3,j,IS) )
c              der_trig_arg = 2*PI/CELL(j)*( HH(1)*CS_M_CS(1,j,IS) +
c     +                              HH(2)*CS_M_CS(2,j,IS) + 
c     +                              HH(3)*CS_M_CS(3,j,IS) )
            derApos(j) = derApos(j) - der_trig_arg(j)*f_sin_temp
            derBpos(j) = derBpos(j) + der_trig_arg(j)*f_cos_temp
            derAPPpos(j)= derAPPpos(j)-der_trig_arg(j)*fpp_cos_temp
            derBPPpos(j)= derBPPpos(j)-der_trig_arg(j)*fpp_sin_temp
          enddo
c 2. deriv. of A,B,App,Bpp wrt coordinates
          if (.not.der2heavyder1_flag) then
            do j = 1,3
              do k = j,3
                if (j.eq.k) then 
                  act = j
                else
                  act = j+k+1
                endif
                der_triga_now = der_trig_arg(j)*der_trig_arg(k)
                der2Apos(act) = der2Apos(act) - der_triga_now*f_cos_temp
                der2Bpos(act) = der2Bpos(act) - der_triga_now*f_sin_temp
                der2APPpos(act) = der2APPpos(act) +
     +              der_triga_now*fpp_sin_temp
                der2BPPpos(act) = der2BPPpos(act) - 
     +              der_triga_now*fpp_cos_temp
              enddo
            enddo
          endif
          endif
          if( HREF_TEMP_FLAG.and.((.not.HREF_OCC_FLAG).or.modncycl2.eq.0
     +      .or..not.full) ) then
c  deriv. of A,B,App,Bpp wrt temperature factors
            der_triga_now = stol2*PISQ8
            derAtemp = derAtemp - der_triga_now*f_cos_temp
            derBtemp = derBtemp - der_triga_now*f_sin_temp
            derAPPtemp = derAPPtemp + der_triga_now*fpp_sin_temp
            derBPPtemp = derBPPtemp - der_triga_now*fpp_cos_temp
c  2. deriv. of A,B,App,Bpp wrt temperature factors
            if (.not.der2heavyder1_flag) then
              der_triga_now = stol2*stol2*PISQ8*PISQ8
              der2Atemp = der2Atemp + der_triga_now*f_cos_temp
              der2Btemp = der2Btemp + der_triga_now*f_sin_temp
              der2APPtemp = der2APPtemp - der_triga_now*fpp_sin_temp
              der2BPPtemp = der2BPPtemp + der_triga_now*fpp_cos_temp
            endif
          endif
c  deriv. of A,B,App,Bpp wrt occupancies
          if(HREF_OCC_FLAG.and.((.not.HREF_TEMP_FLAG).or.modncycl2.eq.1
     +      .or..not.full) ) then
            derAocc = derAocc + f_cos_temp/OCCUP(ia)
            derBocc = derBocc + f_sin_temp/OCCUP(ia)
            derAPPocc =derAPPocc - fpp_sin_temp/OCCUP(ia)
            derBPPocc =derBPPocc + fpp_cos_temp/OCCUP(ia)
          endif
c  deriv. of A,B,App,Bpp wrt f''
          if (HREF_FPP_FLAG) then 
            if (f2prime(AIT,wave_pos).ne.0.) then
              derAPPfpp = derAPPfpp - 
     +                       fpp_sin_temp/f2prime(AIT,wave_pos)
              derBPPfpp = derBPPfpp + 
     +                       fpp_cos_temp/f2prime(AIT,wave_pos)
            endif
          endif
        enddo 
        if ( HREF_COOR_FLAG ) then
          do j = 1,3
c der2Apos is used as auxiliary variable (storing 1. ders) now
            der2Apos(j) = DFDApp*derAPPpos(j) + DFDBpp*derBPPpos(j)
            if (full)	  der2Apos(j) = der2Apos(j) + 
     +        DFDA*derApos(j) + DFDB*derBpos(j)
c!!!!!!!!!!!!
c      der2Apos(j) = der2Apos(j) + DFDA*derApos(j) + DFDB*derBpos(j)
c      der2Apos(j) = DFDA*derApos(j) + DFDB*derBpos(j)
            derpos(ih,j) = derpos(ih,j) + der2Apos(j)
          enddo
          do j = 1,3
          do k = j,3
            if (j.eq.k) then 
              act = j
            else
              act = j+k+1
            endif
            if (.not.der2heavyder1_flag) then
              der2pos(ih,act) = der2pos(ih,act) + 
     +		  DFDA*der2Apos(act) + DFDB*der2Bpos(act) +
     +        DFDApp*der2APPpos(act) + DFDBpp*der2BPPpos(act) +
     +        DFDAA*derApos(j)*derApos(k) + DFDBB*derBpos(j)*derBpos(k)+
     +        DFDAppApp*derAPPpos(j)*derAPPpos(k) + 
     +        DFDBppBpp*derBPPpos(j)*derBPPpos(k) +
     +        DFDAB*( derApos(j)*derBpos(k) + derBpos(j)*derApos(k) ) +
     +        DFDAApp*(derApos(j)*derAPPpos(k)+derAPPpos(j)*derApos(k))+
     +        DFDABpp*(derApos(j)*derBPPpos(k)+derBPPpos(j)*derApos(k))+
     +        DFDAppB*(derAPPpos(j)*derBpos(k)+derBpos(j)*derAPPpos(k))+
     +        DFDBBpp*(derBPPpos(j)*derBpos(k)+derBpos(j)*derBPPpos(k))+
     +   DFDAppBpp*(derAPPpos(j)*derBPPpos(k)+derBPPpos(j)*derAPPpos(k))
            else
              der2pos(ih,act)= der2pos(ih,act) + der2Apos(j)*der2Apos(k)
            endif
          enddo
          enddo
        endif
        if ( HREF_TEMP_FLAG.and.((.not.HREF_OCC_FLAG).or.modncycl2.eq.0
     +    .or..not.full) ) then
          der_now = DFDApp*derAPPtemp + DFDBpp*derBPPtemp
          if (full) der_now =  der_now + DFDA*derAtemp + DFDB*derBtemp 
c!!!!!!!!!!!!
c      der_now =  der_now + DFDA*derAtemp + DFDB*derBtemp
c      der_now =   DFDA*derAtemp + DFDB*derBtemp 
          derB(ih) = derB(ih) + der_now
          if (.not.der2heavyder1_flag) then
            der2B(ih) = der2B(ih) + 
ccc     +		  DFDA*der2Atemp + DFDB*der2Btemp + 
     +        DFDApp*der2APPtemp + DFDBpp*der2BPPtemp +
     +        DFDAA*derAtemp*derAtemp + DFDBB*derBtemp*derBtemp + 
     +        DFDAppApp*derAPPtemp*derAPPtemp + 
     +        DFDBppBpp*derBPPtemp*derBPPtemp + 
     +        2*DFDAB*derAtemp*derBtemp +
     +        2*DFDAApp*derAtemp*derAPPtemp +
     +        2*DFDABpp*derAtemp*derBPPtemp +
     +        2*DFDAppB*derAPPtemp*derBtemp +
     +        2*DFDBBpp*derBPPtemp*derBtemp +
     +        2*DFDAppBpp*derAPPtemp*derBPPtemp
          else
            der2B(ih) = der2B(ih) + der_now*der_now
          endif
        endif
        if ( HREF_OCC_FLAG.and.((.not.HREF_TEMP_FLAG).or.modncycl2.eq.1
     +    .or..not.full) ) then
          der_now = DFDApp*derAPPocc + DFDBpp*derBPPocc
          if (full)  der_now = der_now + DFDA*derAocc + DFDB*derBocc
ccc!!!!!!!!!!!!!
c      der_now = der_now + DFDA*derAocc + DFDB*derBocc
c      der_now = DFDA*derAocc + DFDB*derBocc
          derocc(ih) = derocc(ih) + der_now
          if (.not.der2heavyder1_flag) then
            der2occ(ih) = der2occ(ih) + 
     +        DFDAA*derAocc*derAocc + DFDBB*derBocc*derBocc +
     +        DFDAppApp*derAPPocc*derAPPocc + 
     +        DFDBppBpp*derBPPocc*derBPPocc +
     +        2*DFDAB*derAocc*derBocc +
     +        2*DFDAApp*derAocc*derAPPocc +
     +        2*DFDABpp*derAocc*derBPPocc +
     +        2*DFDAppB*derAPPocc*derBocc +
     +        2*DFDBBpp*derBPPocc*derBocc +
     +        2*DFDAppBpp*derAPPocc*derBPPocc
          else
            der2occ(ih) = der2occ(ih) + der_now*der_now
          endif
c        if (ih.eq.1) write(6,*) derB(ih)
        endif
        if (HREF_FPP_FLAG) then
ccc          do i=1,nform_ano+CS_NSFATM
ccc            if (cs_anom(i)) then 
              der_now = DFDApp*derAPPfpp + DFDBpp*derBPPfpp
              derfpp(ait) = derfpp(ait) + der_now
              der2fpp(ait) = der2fpp(ait) + der_now*der_now
      if (ir.lt.5340.and.ir.gt.5335) then
c      write(*,*)'heavy',ir,DFDApp,DFDBpp,derAPPfpp(ait),derBPPfpp(ait)
c      write(*,*) ir,ia,h_a(ir),der_now,derfpp(ait),der2fpp(ait)
c     +  ,DFDApp,DFDBpp,derAPPfpp,derBPPfpp
c      flush(6)
      endif
ccc            endif
ccc          enddo
        endif
      endif
      enddo      
ccccccccc
ccccccccccc
c  this is only to check if FFT gives the same results as direct FT +
c for SAD see the differences with and without heavy atom contributions
      if (VERBREF_5N) then
      if (ir.eq.985.or.ir.eq.2020.or.ir.eq.5009.or.ir.eq.1023
     +  .or.ir.eq.385.or.ir.eq.1389.or.ir.eq.3897.or.ir.eq.2023) then
c      if (ibin.le.4.or.ibin.ge.17) then
        derAtemp = 0
        derBtemp = 0
        do ia = 1,N_ATOM
        if (ATOM_REF_FLAG(ia).ne.0) then
          f_now = 0
          do j = 1,4
            f_now =f_now + CS_A( j,ID_SF(ia) )
     +             *exp( -CS_B( j,ID_SF(ia) )*stol2 )
          enddo
          f_now = ( f_now + CS_A( 5, ID_SF(ia) ) ) * OCCUP(ia)
          do IS=1,CS_NSYM
            XS=( SYM_ORT_M(1,1,IS)*XYZ_CRD(1,ia) +
     *           SYM_ORT_M(1,2,IS)*XYZ_CRD(2,ia) + 
     *           SYM_ORT_M(1,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(1,IS) )
            YS=( SYM_ORT_M(2,1,IS)*XYZ_CRD(1,ia) +
     *           SYM_ORT_M(2,2,IS)*XYZ_CRD(2,ia) +
     *           SYM_ORT_M(2,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(2,IS) )
            ZS=( SYM_ORT_M(3,1,IS)*XYZ_CRD(1,ia) + 
     *           SYM_ORT_M(3,2,IS)*XYZ_CRD(2,ia) +
     *           SYM_ORT_M(3,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(3,IS) )
            TWO_PI_XH = TWOPI*( XS*HH(1) + YS*HH(2) + ZS*HH(3) )
            expBstol2 = 
     +        exp(-((U_ANISO(1,ia)-u_add_loc)*PISQ8+B_LS_OVER)*stol2)
c            expBstol2 = exp(-(U_ANISO(1,ia)*PISQ8)*stol2)
            derAtemp = derAtemp + f_now*expBstol2*cos(TWO_PI_XH)
            derBtemp = derBtemp + f_now*expBstol2*sin(TWO_PI_XH)
          enddo
        endif
        enddo
        
        write(6,*) 'tutok  ',ir,derAtemp, A_ALL
        write(6,*) derBtemp, B_ALL
      endif
      endif
      END
C
C
C
C
      SUBROUTINE SIR_HEAVY_DER(NREF,IR,HH,stol2,H_A,H_B,DFDA,DFDB,DFDAA,
     +   DFDAB,DFDBB,DFDAh,DFDBh,DFDAhAh,DFDAhBh,DFDBhBh,DFDAAh,
     +   DFDBBh,DFDABh,DFDAhB,A_ALL,B_ALL,ibin)
C
      IMPLICIT NONE
C
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'anom.fh'

c      
      REAL H_A(*),H_B(*)
      real HH(3),stol2,DFDA,DFDB,DFDAA,DFDAB,DFDBB,A_ALL,B_ALL
      real DFDAh,DFDBh,DFDAhAh,DFDAhBh,DFDBhBh,DFDAAh,DFDBBh,
     &     DFDABh,DFDAhB
      INTEGER NREF,IR,ICENT,IB
      real XS,YS,ZS,TWO_PI_XH
      real expBstol2, f_now, der_now
      integer NHA_ACT, IS, IT, AIT, ibin, ia, ih, j, k, act, wave_pos
      real der_trig_arg(3),der_triga_now,sin_temper,cos_temper
      real f_cos_temp, f_sin_temp, fpp_cos_temp, fpp_sin_temp, modncycl2
      real derApos(3),derBpos(3),der2Apos(6),der2Bpos(6),
     &     derAtemp,derBtemp,der2Atemp,der2Btemp,derAocc,derBocc
c
      INCLUDE 'tabfunc.fh'      
C
      modncycl2 = mod(ncycl,2)
      wave_pos = dataset_wavenum(dataset_order(2))
      ih=0
      do ia = 1, n_atom+n_atom_ano
      if (cs_anom(ID_SF(ia))) then 
        IT=ID_SF(ia)
        AIT=t2at(IT)
        ih=ih+1
        if ( HREF_COOR_FLAG ) then
          do j = 1, 3
            derApos(j) = 0
            derBpos(j) = 0
          enddo
          do j = 1, 6
            der2Apos(j) = 0
            der2Bpos(j) = 0
          enddo
        endif
        if(HREF_TEMP_FLAG.and.((.not.HREF_OCC_FLAG).or.modncycl2.eq.0)
     +    )then
          derAtemp = 0
          derBtemp = 0
          der2Atemp = 0
          der2Btemp = 0
        endif
        if(HREF_OCC_FLAG.and.((.not.HREF_TEMP_FLAG).or.modncycl2.eq.1)
     +    )then
          derAocc = 0
          derBocc = 0
        endif
c isotropic temp. factor
        x_arg = ((U_ANISO(1,ia)-u_add_loc)*PISQ8+B_LS_OVER)*stol2
        if (x_arg.gt.0..and.x_arg.lt.50.) then
          tab_i = getexpint(x_arg)
          x_diff = getexpdiff(x_arg,tab_i)
          x_diff_sq = x_diff*x_diff		
          expBstol2 = expf(x_diff,x_diff_sq,tab_i)
        else
          expBstol2 = exp(-x_arg)
        endif
      	f_now = 0
      	do j = 1,4
          x_arg = CS_B(j,IT)*stol2
          if (x_arg.gt.0..and.x_arg.lt.50.) then
            tab_i = getexpint(x_arg)
            x_diff = getexpdiff(x_arg,tab_i)
            x_diff_sq = x_diff*x_diff		
            f_now = f_now + CS_A(j,IT)*expf(x_diff,x_diff_sq,tab_i)
          else
            f_now = f_now + CS_A(j,IT)*exp(-x_arg)
          endif
      	enddo
        f_now = ( f_now + CS_A(5,IT) + fprime(AIT,wave_pos) ) *OCCUP(ia)
c          fpp_now = Hfpp(HEAVY_TYPE(ih)) * OCCUP(ia) 
        do IS=1,CS_NSYM
cc          TWO_PI_XH = XYZ_2PI(1,IH,IS)*HH(1) + XYZ_2PI(2,IH,IS)*HH(2)
cc     +              + XYZ_2PI(3,IH,IS)*HH(3)
          XS=( SYM_ORT_M(1,1,IS)*XYZ_CRD(1,ia) +
     *         SYM_ORT_M(1,2,IS)*XYZ_CRD(2,ia) + 
     *         SYM_ORT_M(1,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(1,IS) )
          YS=( SYM_ORT_M(2,1,IS)*XYZ_CRD(1,ia) +
     *         SYM_ORT_M(2,2,IS)*XYZ_CRD(2,ia) +
     *         SYM_ORT_M(2,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(2,IS) )
          ZS=( SYM_ORT_M(3,1,IS)*XYZ_CRD(1,ia) + 
     *         SYM_ORT_M(3,2,IS)*XYZ_CRD(2,ia) +
     *         SYM_ORT_M(3,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(3,IS) )
          TWO_PI_XH = TWOPI*( XS*HH(1) + YS*HH(2) + ZS*HH(3) )
c        write(6,*) SYM_ORT_M(1,1,IS),SYM_ORT_M(1,2,IS),SYM_ORT_M(1,3,IS)
c        write(6,*) SYM_ORT_M(2,1,IS),SYM_ORT_M(2,2,IS),SYM_ORT_M(2,3,IS)
c        write(6,*) SYM_ORT_M(3,1,IS),SYM_ORT_M(3,2,IS),SYM_ORT_M(3,3,IS)
            if (TWO_PI_XH.gt.TWOPI) TWO_PI_XH = normtrigbig(TWO_PI_XH)
            if (TWO_PI_XH.lt.0.)  TWO_PI_XH = normtrigsmall(TWO_PI_XH)
            tab_i = gettrigint(TWO_PI_XH)
            x_diff = gettrigdiff(TWO_PI_XH,tab_i)
            x_diff_sq = x_diff*x_diff
            cos_temper = cosf(x_diff,x_diff_sq,tab_i)*expBstol2
            sin_temper = sinf(x_diff,x_diff_sq,tab_i)*expBstol2
            f_cos_temp = f_now*cos_temper
            f_sin_temp = f_now*sin_temper
c   deriv. of AH,BH wrt coordinates
          if ( HREF_COOR_FLAG ) then
          do j = 1,3
            der_trig_arg(j) = TWOPI*( HH(1)*SYM_ORT_M(1,j,IS) +
     +                                HH(2)*SYM_ORT_M(2,j,IS) + 
     +                                HH(3)*SYM_ORT_M(3,j,IS) )
            derApos(j) = derApos(j) - der_trig_arg(j)*f_sin_temp
            derBpos(j) = derBpos(j) + der_trig_arg(j)*f_cos_temp
          enddo
c 2.  deriv. of AH,BH wrt coordinates
          if (.not.der2heavyder1_flag) then
            do j = 1,3
              do k = j,3
                if (j.eq.k) then 
                  act = j
                else
                  act = j+k+1
                endif
                der_triga_now = der_trig_arg(j)*der_trig_arg(k)
                der2Apos(act) = der2Apos(act) - der_triga_now*f_cos_temp
                der2Bpos(act) = der2Bpos(act) - der_triga_now*f_sin_temp
              enddo
            enddo
          endif
          endif
          if (HREF_TEMP_FLAG.and.(
     +      (.not.HREF_OCC_FLAG).or.modncycl2.eq.0)  ) then
c  deriv. of AH,BH wrt temperature factors
            der_triga_now = stol2
            derAtemp = derAtemp - der_triga_now*f_cos_temp
            derBtemp = derBtemp - der_triga_now*f_sin_temp
c  2. deriv. of AH,BH wrt temperature factors
            if (.not.der2heavyder1_flag) then
              der_triga_now = stol2*stol2
              der2Atemp = der2Atemp + der_triga_now*f_cos_temp
              der2Btemp = der2Btemp + der_triga_now*f_sin_temp
            endif
          endif
          if (HREF_OCC_FLAG.and.(
     +      (.not.HREF_TEMP_FLAG).or.modncycl2.eq.1)  )then
c  deriv. of AH,BH wrt occupancies
            derAocc = derAocc + f_cos_temp/OCCUP(ia)
            derBocc = derBocc + f_sin_temp/OCCUP(ia)
          endif
        enddo 
        if ( HREF_COOR_FLAG ) then
          do j = 1,3
            if (.not.der2heavyder1_flag) then
              derpos(ih,j) = derpos(ih,j) + 
     +           DFDAh*derApos(j) + DFDBh*derBpos(j)
            else
              der2Apos(j) = DFDAh*derApos(j) + DFDBh*derBpos(j)
              derpos(ih,j) = derpos(ih,j) + der2Apos(j)
            endif
          enddo
          do j = 1,3
          do k = j,3
            if (j.eq.k) then 
              act = j
            else
              act = j+k+1
            endif
            if (.not.der2heavyder1_flag) then
              der2pos(ih,act) = der2pos(ih,act) + 
     +		  DFDAh*der2Apos(act) + DFDBh*der2Bpos(act) +
     +        DFDAhAh*derApos(j)*derApos(k) + 
     +        DFDBhBh*derBpos(j)*derBpos(k) +
     +        DFDAhBh*( derApos(j)*derBpos(k) + derBpos(j)*derApos(k) )
            else
              der2pos(ih,act)= der2pos(ih,act) + der2Apos(j)*der2Apos(k)
            endif
          enddo
          enddo
        endif
        if (HREF_TEMP_FLAG.and.(
     +    (.not.HREF_OCC_FLAG).or.modncycl2.eq.0)  )then
          if (.not.der2heavyder1_flag) then
            derB(ih) = derB(ih) + DFDAh*derAtemp + DFDBh*derBtemp
            der2B(ih) = der2B(ih) + 
     +		  DFDAh*der2Atemp + DFDBh*der2Btemp +
     +        DFDAhAh*derAtemp*derAtemp + DFDBhBh*derBtemp*derBtemp +
     +        2*DFDAhBh*derAtemp*derBtemp
          else
            der_now = DFDAh*derAtemp + DFDBh*derBtemp
            derB(ih) = derB(ih) + der_now
            der2B(ih) = der2B(ih) + der_now*der_now
          endif
        endif
        if (HREF_OCC_FLAG.and.(
     +    (.not.HREF_TEMP_FLAG).or.modncycl2.eq.1)  )then
          if (.not.der2heavyder1_flag) then
            derocc(ih) = derocc(ih) + DFDAh*derAocc + DFDBh*derBocc
            der2occ(ih) = der2occ(ih) + 
     +        DFDAhAh*derAocc*derAocc + DFDBhBh*derBocc*derBocc +
     +        2*DFDAhBh*derAocc*derBocc
          else
            der_now = DFDAh*derAocc + DFDBh*derBocc
            derocc(ih) = derocc(ih) + der_now
            der2occ(ih) = der2occ(ih) + der_now*der_now
          endif
        endif
      endif
      enddo      
ccccccccc
ccccccccc
ccccccccccc
      if (ir.eq.985.or.ir.eq.2020.or.ir.eq.5009.or.ir.eq.1023
     +  .or.ir.eq.385.or.ir.eq.1389.or.ir.eq.3897.or.ir.eq.2023) then
c      if (ibin.le.4.or.ibin.ge.17) then
        derAtemp = 0
        derBtemp = 0
        do ia = 1,N_ATOM
        if (ATOM_REF_FLAG(ia).ne.0) then
          f_now = 0
          do j = 1,4
            f_now =f_now + CS_A( j,ID_SF(ia) )
     +             *exp( -CS_B( j,ID_SF(ia) )*stol2 )
          enddo
          f_now = f_now + CS_A( 5, ID_SF(ia) )
          f_now = f_now*OCCUP(ia)
          do IS=1,CS_NSYM
            XS=( SYM_ORT_M(1,1,IS)*XYZ_CRD(1,ia) +
     *           SYM_ORT_M(1,2,IS)*XYZ_CRD(2,ia) + 
     *           SYM_ORT_M(1,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(1,IS) )
            YS=( SYM_ORT_M(2,1,IS)*XYZ_CRD(1,ia) +
     *           SYM_ORT_M(2,2,IS)*XYZ_CRD(2,ia) +
     *           SYM_ORT_M(2,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(2,IS) )
            ZS=( SYM_ORT_M(3,1,IS)*XYZ_CRD(1,ia) + 
     *           SYM_ORT_M(3,2,IS)*XYZ_CRD(2,ia) +
     *           SYM_ORT_M(3,3,IS)*XYZ_CRD(3,ia) + CS_V_CS(3,IS) )
            TWO_PI_XH = TWOPI*( XS*HH(1) + YS*HH(2) + ZS*HH(3) )
            expBstol2 =
     +        exp(-((U_ANISO(1,ia)-u_add_loc)*PISQ8+B_LS_OVER)*stol2)
            derAtemp = derAtemp + f_now*expBstol2*cos(TWO_PI_XH)
            derBtemp = derBtemp + f_now*expBstol2*sin(TWO_PI_XH)
          enddo
        endif
        enddo
        if (VERBREF_5N) then
          write(6,*) 'tutok  ',ir,derAtemp, A_ALL
          write(6,*) derBtemp, B_ALL
        endif
      endif
      END
C
C
C
      SUBROUTINE ref_heavy
      INCLUDE 'refi_flags.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
      INCLUDE 'anom.fh'

      real shift,DF(3),DFF(3,3),SHIFTS(3),TOLER,modncycl2,max
      integer i,j,ih,ia,NWORKSPACE,wave_pos,ait
c
      modncycl2 = mod(ncycl,2)
      if ( (HREF_OCC_FLAG.or.HREF_COOR_FLAG.or.HREF_TEMP_FLAG) ) then
      ih=0
      do ia = 1, n_atom+n_atom_ano
      if (cs_anom(ID_SF(ia))) then 
        IT=ID_SF(ia)
        AIT=t2at(it)
        ih=ih+1
        if (HREF_TEMP_FLAG.and.((.not.HREF_OCC_FLAG).or.modncycl2.eq.0))
     +    then
          shift = amax1( amin1(derB(ih)/abs(der2B(ih)), 
     +      5./PISQ8),-5./PISQ8 )
          shift = amax1( amin1(derB(ih)/abs(der2B(ih)), 
     +      5.),-5. )
c        write(6,*) 'U bef. : ', H_U(ih)
c        write(6,*) shift,derB(ih),der2B(ih),derB(ih)/abs(der2B(ih))
          U_ANISO(1,ia) =  
     +      amax1( amin1( U_ANISO(1,ia) - shift, 99./PISQ8 ), 2./PISQ8 )
c        write(6,*) 'U after : ', H_U(ih)
        endif  
        if (HREF_OCC_FLAG.and.((.not.HREF_TEMP_FLAG).or.modncycl2.eq.1))
     +    then
          shift = amax1( amin1(derocc(ih)/abs(der2occ(ih)),.1), -.1 )
          OCCUP(ia) = 
     +      amin1( amax1( OCCUP(ia) - shift, 0.01 ), 5.0 )
        endif
        if ( HREF_COOR_FLAG ) then
          do i = 1, 3
            DF(i) = derpos(ih,i)
            DFF(i,i) = der2pos(ih,i)
            do j = i+1, 3
              DFF(i,j) = der2pos(ih,i+j+1)
              DFF(j,i) = DFF(i,j)
            enddo
          enddo
          NWORKSPACE = 100
          CALL  EIGEN_FILTER_R(TOLER,DFF(1,1),3,3,
     &      DF(1),SHIFTS(1),WORKSPACE,NWORKSPACE)
          do i = 1, 3
c            shift = amax1(amin1(derpos(ih,i)/abs(der2pos(ih,i)),.3),-.3)
            shift = amax1( amin1(shifts(i),.3),-.3 )
            XYZ_CRD(i,ia) = XYZ_CRD(i,ia) - shift
          enddo
        endif
      endif
      enddo
      endif
c
      END
C
      SUBROUTINE ref_fpp
      INCLUDE 'refi_flags.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
      INCLUDE 'anom.fh'

      real shift,DF(3),DFF(3,3),SHIFTS(3),TOLER,modncycl2,max
      integer i,j,ih,ia,NWORKSPACE,wave_pos,ait
c     
ccc          wave_pos = dataset_wavenum(dataset_order(2))*MAXN_H_TYP
        wave_pos = dataset_wavenum(dataset_order(2))
c should add the looping via wavelengths later!
        do AIT=1,nform_ano
ccc            max = amin1(0.075*Hfpp(HEAVY_TYPE(i)+wave_pos),.4)
            max = amin1(0.075*f2prime(AIT,wave_pos),.4)
            if (der2fpp(ait).ne.0) then
              shift=amax1(amin1(derfpp(ait)/abs(der2fpp(ait)),max),-max)
      write(*,*) 'lets see:',aIT,derfpp(ait),der2fpp(ait)
ccc      	      Hfpp(HEAVY_TYPE(i)+wave_pos) = 
ccc     +          Hfpp(HEAVY_TYPE(i)+wave_pos) - shift
      	      f2prime(AIT,wave_pos) = f2prime(AIT,wave_pos) - shift
            endif
            write(*,*) 'f'''' refined to ',f2prime(AIT,wave_pos)
        enddo
ccc      write(*,*) 'f'''' refined to ',Hfpp(HEAVY_TYPE(1)+wave_pos)
c     +	  , shift,derfpp,der2fpp
      end
C
C
      SUBROUTINE read_heavy_atoms
      INCLUDE 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
      INCLUDE 'anom.fh'

      INTEGER LENSTR
      EXTERNAL LENSTR
      REAL A(4),B(4),CU(2),MO(2)
      CHARACTER FILE_NAME*256
      integer wave
      real H_C(3,MAXN_HEAVY),H_U(MAXN_HEAVY),H_O(MAXN_HEAVY)
c-- HEAVY_TYPE stores the heavy atom numbering of types
      integer HEAVY_TYPE(MAXN_HEAVY), NUM_HTYPE
c-- H_ELEM stores the heavy atom id's of types
      CHARACTER H_ELEM(maxform_ano)*4
c
      CALL UGTENV('HEAVYIN',FILE_NAME)
      IF(FILE_NAME(1:1).NE.' ') THEN
        write(6,*)
        WRITE(6,*)'Input file.  Logical name - HEAVYIN'//
     &        ' actual file name  - '//FILE_NAME(1:LENSTR(FILE_NAME))
c      ELSE
c        WRITE(6,*)'Input file.  Logical name - HEAVYIN'//
c     &        ' actual file name  - HEAVYIN'
      ENDIF
      LENFILENAME = lenstr(FILE_NAME)
c at the moment, for SIR n_atom_ano means the heavy atoms missing in the native - this should be changed, espec. for MIR etc
      call read_heavy(n_atom_ano,H_C,H_U,H_O,NUM_HTYPE,HEAVY_TYPE,
     +  H_ELEM,FILE_NAME,LENFILENAME,MAXN_HEAVY,maxform_ano)
      do ih = 1, n_atom_ano
        OCCUP(N_ATOM+ih) = H_O(ih)
        XYZ_CRD(1,N_ATOM+ih) = H_C(1,ih)
        XYZ_CRD(2,N_ATOM+ih) = H_C(2,ih)
        XYZ_CRD(3,N_ATOM+ih) = H_C(3,ih)
        U_ANISO(1,N_ATOM+ih) = H_U(ih)/PISQ8
        ID_SF(ih+N_ATOM) = CS_NSFATM + HEAVY_TYPE(ih)
      enddo
c      n_atom=n_atom+n_atom_ano
      found_given = 0
      DO    IS = CS_NSFATM+1, CS_NSFATM+NUM_HTYPE
        NT = IS - CS_NSFATM
        cs_element(IS) = H_ELEM(NT)
        CALL SFREAD2(H_ELEM(NT),NG,A,B,C,IWT,IELEC,CU,
     +              MO,IFAIL)
        IF(IFAIL.LT.0) 
     +   CALL ERRWRT(1,' No match for ATOM ID'//H_ELEM(NT))
        DO   I=1,4
          CS_A(I,IS) = A(I)
          CS_B(I,IS) = B(I)
        ENDDO
        CS_A(5,IS)   = C
        CS_B(5,IS)   = 0.0
c        CS_FI(IS,1)    = CU(1)
c        CS_FII(IS,1)   = CU(2)
        CS_NELEC(IS) = IELEC
        do i=1,nform_ano
      	  if ( ano_elem(i).eq.H_ELEM(NT) ) then
            found_given = found_given + 1
            cs_anom(is)=.true.
            do j=1,dataset_wavenum_tot
              if (PPI.eq.'no'.or.PPI.eq.'sad'.or.PPI.eq.'sadh')
     +          cs_a(5,is) = cs_a(5,is) + fprime(i,j)
            enddo
          else
            cs_anom(is)=.false.
          endif
        enddo
      ENDDO
c           write(*,*) Hfp(1),Hfpp(1),Hfp(2),Hfpp(2)
c      write(*,*) found_given,nform_ano
      if (found_given.lt.nform_ano)
     &    CALL ERRWRT(1,'At least one heavy atom type given by ANOM '//
     &	  'not found in heavy input file')      
      if (found_given.lt.NUM_HTYPE) then
         CALL ERRWRT(0,'At least one heavy atom type from heavy atom'//
     +     'input file not given by ANOM - using Cu f'' and f'''' here')
         nform_ano = NUM_HTYPE
      endif

      END
C
cc      real FUNCTION expf( x )
cc      common /TAB/ expf_arr
cc      real expf_arr(251,6)
cc      real x, x_diff, x_diff_sq
cc      integer i
c
cc      i = int( 1.5 + x*5. )
cc      x_diff = x - expf_arr(i,1)
cc      x_diff_sq = x_diff*x_diff		
c      write(*,*) x,x_diff,x_diff_sq,i,expf_arr(i,1) 
cc      expf = ( expf_arr(i,2) * ( 1. - x_diff + 0.5*x_diff_sq -
cc     +      0.166666666666666666*x_diff_sq*x_diff + 
cc     + 	    0.0416666666666666*x_diff_sq*x_diff_sq ) )
cc      RETURN
cc      END
