C           HELIXREST
C
C  To generate alpha helix restraints for refmac. For each helix, the start and end
C  residue numbers should be given on a RESIDUE keyword. Multiple definitions are
C  allowed on the same line. The chain ID(s) MUST also be given using the CHAIN keyword.
C  ***** IMPORTANT ****
C  ***** IMPORTANT ****
C  ***** IMPORTANT ****
C  All helix restraints for any chain chain A must be given sequentially (on muliple lines if desired).
C  The following input *** WILL NOT WORK ***
C     residue 10 30 CHAIN A
C     residue 20 50 CHAIN B
C     residue 35 50 CHAIN A
C
C  This MUST be given as:
C     residue 10 30 CHAIN A
C     residue 35 50 CHAIN A
C     residue 20 50 CHAIN B
C
C  The pdb file must be given as XYZIN.
C  The restraints are written to the file specified by "links".
C  
C  Example command script:
C  myhelixrest xyzin cring_pq.pdb links mylink.dat << eof-hel
C  residue 5 20 40 48 chain P Q
C  residue 53 62 chain Q
C  eof-hel
C
C
C234567890123456789012345678901234567890123456789012345678901234567890
cTOM      1  N   GLY A   1       2.553  36.173  12.377  1.00 46.65    
C
      IMPLICIT NONE
      INTEGER NPARM,MXCHAIN,MXATOM,MXSEG
      PARAMETER (NPARM=200)
      PARAMETER (MXCHAIN=20)
      PARAMETER (MXATOM=1000)
      PARAMETER (MXSEG=1000)
	CHARACTER LINE*80,S1*17,LABEL*1,LABELOLD*1,S2*39,IDENT1*10,
     +            STR(8)*40,FLNAME1*80,FLNAME2*80,IDENT2*10,RESTYP*3,
     +            CHAIN*1,
     +            FLNAME3*80,RESTYPE*3,SUBKEY*4,KEY*4
      CHARACTER CHID(MXCHAIN)*1,FIRSTRES(MXATOM)*3,SECRES(MXATOM)*3
        INTEGER IRES1,IRESOLD,IRES,IN,IDELTA,IROUT,IMUT,LIDENT1,
     +          LIDENT2,LSTR,NHDR,NTOT,ICH,NSEG,INDEXN,INDEXO,NALPHA,
     +          K,NSEG1,NSEG2,ISEG,NCHAIN,NSEGS,I,J,NREST,ICHAIN
        LOGICAL NEWSEG,NUC,NEWRES,PRINT,LOUT(MXSEG,MXCHAIN)
      INTEGER IRST(MXSEG),IREND(MXSEG),ISTSEG(MXCHAIN),
     +        IENDSEG(MXCHAIN)
      REAL DIST
C
C---- Things for parser
C
      INTEGER NTOK, IBEG(NPARM), IEND(NPARM), ITYPE(NPARM), IDEC(NPARM),
     +        IVAL(NPARM),ICOUNT
      REAL FVALUE(NPARM),RVAL(NPARM)
      LOGICAL LEND
      CHARACTER CVALUE(NPARM)*4
C     ..
C     .. External Functions ..
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      DO 1 I = 1,MXSEG
      DO 1 J = 1,MXCHAIN
        LOUT(I,J) = .FALSE.
 1    CONTINUE
      DIST = 2.7
      NREST = 0
C
      CALL CCPFYP
      CALL CCPDPN(1,'XYZIN','READONLY','F',0,0)
      CALL CCPDPN(2,'LINKS','UNKNOWN','F',0,0)
C
C---- Read definition of helices as chainid,resno
C
C
      NSEG = 0
      NCHAIN = 0
 2    LINE = ' '
      CALL PARSER(KEY, LINE, IBEG, IEND, ITYPE, FVALUE, CVALUE, IDEC,
     +     NTOK, LEND, .TRUE.)
C
      IF (LEND) GOTO 10
C
      CALL CCPUPC(KEY)
      IF (KEY.EQ.'RESI') THEN
C
C---- Example: RESIDUES 10 24 CHAINS A B C
C
        NSEGS = NSEG + 1
        ICOUNT = 2
 4      CALL GTNINT (ICOUNT,2,IVAL, NTOK, ITYPE, FVALUE)
        IF ((ICOUNT+1).GT.NTOK) THEN
          WRITE(6,108)
 108     FORMAT(1X,'***** ERROR *****',/,1X,'A start and end residue',
     +           ' number must be given for each segment')
          STOP
        END IF
        NSEG = NSEG + 1
        IRST(NSEG) = IVAL(1)
        IREND(NSEG) = IVAL(2)
        ICOUNT = ICOUNT + 2
        IF (ICOUNT.GT.NTOK) THEN
          WRITE(6,106)
 106      FORMAT(1X,'***** ERROR *****',/,1X,'The chain identifiers',
     +          ' must be given with subkey CHAIN.')

          STOP
        END IF
C
C---- If next token is a number, read two next residues
C
        IF (ITYPE(ICOUNT).EQ.2) THEN
          GOTO 4
        ELSE
          SUBKEY = LINE(IBEG(ICOUNT):IEND(ICOUNT))
          CALL CCPUPC(SUBKEY)
          IF (SUBKEY.EQ.'CHAI') THEN
            DO 6 I = ICOUNT+1,NTOK
                CALL CCPUPC(LINE(IBEG(I):IEND(I)))
                CHAIN = LINE(IBEG(I):IEND(I))
C
c---- Is this a new chain ? 
C
                IF (NCHAIN.GE.1) THEN
                  DO 5 J = 1,NCHAIN
                    IF (CHAIN.EQ.CHID(J)) THEN
                      ICHAIN = J
                      GOTO 7
                    END IF
 5                CONTINUE
C
C---- This is a new chain
C
                  NCHAIN = NCHAIN + 1
                  ICHAIN = NCHAIN
                  CHID(NCHAIN) = CHAIN
                  ISTSEG(ICHAIN) = NSEGS
C                  TYPE *,'NCHAIN IS NOW',NCHAIN
                ELSE
                  ICHAIN = 1
                  NCHAIN = 1
                  CHID(NCHAIN) = CHAIN
                  ISTSEG(ICHAIN) = NSEGS
                END IF
 7              IENDSEG(ICHAIN) = NSEG
 6          CONTINUE
            ICOUNT = NTOK
          ELSE
            WRITE(6,102) SUBKEY
 102        FORMAT(1X,'***** ERROR *****',/,1X,'Subkey ',A,
     +          ' not recognised, must be CHAIN.')
          END IF
        END IF
C
      ELSE IF (KEY.EQ.'PRIN') THEN
        PRINT = .TRUE.
      ELSE
            WRITE(6,104) KEY
 104        FORMAT(1X,'***** ERROR *****',/,1X,'Keyword ',A,
     +          ' not recognised.')
      END IF
      GOTO 2
C
C
C---- Reflect definitions
C
 10   DO 11 ICH = 1,NCHAIN
         NSEG1 = ISTSEG(ICH)
         NSEG2 = IENDSEG(ICH)
         WRITE(6,FMT=110) CHID(ICH),(IRST(K),IREND(K),K=NSEG1,NSEG2)
 110     FORMAT(1X,'Helices defined for chain ',A,/,
     +         (1X,8(I4,' to',I4)))
 11   CONTINUE
C
C
      WRITE(6,112)
 112  FORMAT(//,1X,'List of all H-bond restraints generated:')
C
C---- Go through coord file, seting up restraints
C
 12	READ(1,100,END=70) LINE
 100	FORMAT(A)
C
C  Test for ATOM card
C
	IF (LINE(1:4).EQ.'ATOM') THEN
          IN = IN + 1
     	  READ(LINE,200) S1,RESTYPE,CHAIN,IRES,LABEL,S2
C          TYPE *,'READ LINE',IN
          GOTO 16
	ENDIF
 200	FORMAT(A,A,1X,A,I4,A,A)
        GOTO 12
C
C---- Does this chain have any defined helices ?
C
 16     DO 20 ICH = 1,NCHAIN
          IF (CHAIN.EQ.CHID(ICH)) THEN
C
C---- Check if this residue is in a helix. First get the first and
C     last helix segments that are in this chain
C
            NSEG1 = ISTSEG(ICH)
            NSEG2 = IENDSEG(ICH)
C
C---- Now loop through these segments, checking residue number
C
            DO 22 ISEG = NSEG1,NSEG2
              IF ((IRES.GE.IRST(ISEG)).AND.(IRES.LE.IREND(ISEG))) THEN
                INDEXO = IRES - IRST(ISEG) + 1
                FIRSTRES(INDEXO) = RESTYPE
                INDEXN = IRES - 4 - IRST(ISEG) + 1
                IF (INDEXN.GT.0) SECRES(INDEXN) = RESTYPE
C
C---- If this is last residue in helix, write out restraints
C
                IF (IRES.EQ.IREND(ISEG).AND.(.NOT.LOUT(ISEG,ICH))) THEN
                  NALPHA = IREND(ISEG) - IRST(ISEG) - 3
                  LOUT(ISEG,ICH) = .TRUE.
                  DO 24 K = 1,NALPHA
                    WRITE(6,FMT=130)  CHID(ICH),FIRSTRES(K),
     +               IRST(ISEG)+K-1,CHID(ICH),SECRES(K),
     +               IRST(ISEG)+K+3
 130                FORMAT(1X,A,2X,A,I4,' TO ',A,2X,A,I4)
                    WRITE(2,FMT=132) FIRSTRES(K),CHID(ICH),
     +               IRST(ISEG)+K-1,DIST,SECRES(K),CHID(ICH),
     +               IRST(ISEG)+K+3
 132   FORMAT('LINK         O   ',A,1X,A,I4,F11.1,'      N   ',A,1X,A,
     +        I4,'                HPEP')
                     NREST = NREST + 1
 24               CONTINUE
                END IF
              END IF
 22         CONTINUE
          END IF
 20     CONTINUE
	GOTO 12
C
C---- Write an "END" ot total file
C
C
 70     WRITE(6,270) NREST
 270	FORMAT(//1X,I6,' restraints written to LINKS file')
        STOP
	END
