c undefined reference to `slamch_'
c undefined reference to `dlamch_'
c undefined reference to `ssyev_'
c undefined reference to `dsyev_'
c undefined reference to `dstevd_'

! ====================================================================
      subroutine Z4_eigv3sym( w, r, b, err )
      implicit   none

! --------------------------------------------------------------------

!     w = b^T* r* b ( see the last cycle )

!     input:

!     w:       matrix to decompose

!     output:

!     a, b:    ortogonal matrices (det = 1)
!     r:       diagonal (with possibly negative elements)
!     err = T: no convergency in 50 cycles

!     test:

!     fvb = T
! --------------------------------------------------------------------

      real*4     w(3,3), r(3), b(3,3)

      integer*4  i, j, k

      real*4     x(3,3)
      real*4     dp, op
      real*4     dm, om, tm, cm, sm
      real*4     c1, s1
      real*4     xx

      integer*4  ict, ics
      logical*4   err, fvb

      real*4     tol, tt
      save       tol

      data       tol / 1.0D-02 /

! --------------------------------------------------------------------
      fvb = .false.

      do i = 1,3
         do j = 1,3
            x(j,i) = ( w(j,i) + w(i,j) )* 0.5D+00
            b(j,i) = 0
         enddo
         b(i,i) = 1
      enddo
      ict = 0
      ics = 0

      if( fvb )then
         write(*,'(33(''-''))')
         write(*,'(2i6)') ics, ict
         write(*,'((3d26.18))') x
         write(*,'(33(''-''))')
      endif

      do while( ics .lt. 3 .and. ict .lt. 50 )
         ict = ict + 1
         do i = 1,3
            do j = 1,i-1                        ! increasing eigenvalues
!           do j = i+1,3                        ! decreasing eigenvalues

               dp = x(i,i) + x(j,j)
               dm = x(i,i) - x(j,j)
               op = x(j,i) + x(i,j)
               om = x(j,i) - x(i,j)
               tm = sqrt( op**2 + dm**2 )

               tt = dp + tm* tol
               if( tt .ne. dp )then
                  cm = dm/ tm
                  sm = op/ tm
               else
                  cm = 1
                  sm = 0
               endif

               if( cm .lt. 0 )then
                  s1 = sqrt( 0.5D+00* ( 1 - cm ) )
                  c1 = sm/ ( 2.0D+00* s1 )
               else
                  c1 = sqrt( 0.5D+00* ( 1 + cm ) )
                  s1 = sm/ ( 2.0D+00* c1 )
               endif

               tt = 1 + s1* tol
               if( tt .eq. 1 )then
                  s1 = 0
                  ics = ics + 1
               else
                  ics = 0
               endif

               x(i,i) = ( dp + tm )* 0.5D+00
               x(j,j) = ( dp - tm )* 0.5D+00
               x(i,j) = 0
               x(j,i) = 0

               k = 6 - i - j

               xx     = c1* x(k,i) + s1* x(k,j)
               x(k,j) = c1* x(k,j) - s1* x(k,i)
               x(k,i) = xx

               x(j,k) = x(k,j)
               x(i,k) = x(k,i)

               do k = 1,3
                  xx     = c1* b(i,k) + s1* b(j,k)
                  b(j,k) = c1* b(j,k) - s1* b(i,k)
                  b(i,k) = xx
               enddo

               if( fvb )then
                  write(*,'(2i6)') ics, ict
                  write(*,'((3d26.18))') x
                  write(*,'(33(''-''))')
               endif
            enddo
         enddo
      enddo
      do i = 1,3
         r(i) = x(i,i)
      enddo
      if( fvb )then
         do i = 1,3
            do j = 1,3
               x(j,i) = 0
               do k = 1,3
                  x(j,i) = x(j,i) + b(k,j)* r(k)* b(k,i)
               enddo
            enddo
         enddo
      endif
      err = ics .lt. 3
      end

c ====================================================================
      subroutine Zm_eigv3sym( w, r, b, err )
      implicit   none

! --------------------------------------------------------------------

!     w = b^T* r* b ( see the last cycle )

!     input:

!     w:       matrix to decompose

!     output:

!     a, b:    ortogonal matrices (det = 1)
!     r:       diagonal (with possibly negative elements)
!     err = T: no convergency in 50 cycles

!     test:

!     fvb = T
! --------------------------------------------------------------------

      real*8     w(3,3), r(3), b(3,3)

      integer*4  i, j, k

      real*8     x(3,3)
      real*8     dp, op
      real*8     dm, om, tm, cm, sm
      real*8     c1, s1
      real*8     xx

      integer*4  ict, ics
      logical*4   err, fvb

      real*8     tol, tt
      save       tol

      data       tol / 1.0D-02 /

! --------------------------------------------------------------------
      fvb = .false.

      do i = 1,3
         do j = 1,3
            x(j,i) = ( w(j,i) + w(i,j) )* 0.5D+00
            b(j,i) = 0
         enddo
         b(i,i) = 1
      enddo
      ict = 0
      ics = 0

      if( fvb )then
         write(*,'(33(''-''))')
         write(*,'(2i6)') ics, ict
         write(*,'((3d26.18))') x
         write(*,'(33(''-''))')
      endif

      do while( ics .lt. 3 .and. ict .lt. 50 )
         ict = ict + 1
         do i = 1,3
            do j = 1,i-1                        ! increasing eigenvalues
!           do j = i+1,3                        ! decreasing eigenvalues

               dp = x(i,i) + x(j,j)
               dm = x(i,i) - x(j,j)
               op = x(j,i) + x(i,j)
               om = x(j,i) - x(i,j)
               tm = sqrt( op**2 + dm**2 )

               tt = dp + tm* tol
               if( tt .ne. dp )then
                  cm = dm/ tm
                  sm = op/ tm
               else
                  cm = 1
                  sm = 0
               endif

               if( cm .lt. 0 )then
                  s1 = sqrt( 0.5D+00* ( 1 - cm ) )
                  c1 = sm/ ( 2.0D+00* s1 )
               else
                  c1 = sqrt( 0.5D+00* ( 1 + cm ) )
                  s1 = sm/ ( 2.0D+00* c1 )
               endif

               tt = 1 + s1* tol
               if( tt .eq. 1 )then
                  s1 = 0
                  ics = ics + 1
               else
                  ics = 0
               endif

               x(i,i) = ( dp + tm )* 0.5D+00
               x(j,j) = ( dp - tm )* 0.5D+00
               x(i,j) = 0
               x(j,i) = 0

               k = 6 - i - j

               xx     = c1* x(k,i) + s1* x(k,j)
               x(k,j) = c1* x(k,j) - s1* x(k,i)
               x(k,i) = xx

               x(j,k) = x(k,j)
               x(i,k) = x(k,i)

               do k = 1,3
                  xx     = c1* b(i,k) + s1* b(j,k)
                  b(j,k) = c1* b(j,k) - s1* b(i,k)
                  b(i,k) = xx
               enddo

               if( fvb )then
                  write(*,'(2i6)') ics, ict
                  write(*,'((3d26.18))') x
                  write(*,'(33(''-''))')
               endif
            enddo
         enddo
      enddo
      do i = 1,3
         r(i) = x(i,i)
      enddo
      if( fvb )then
         do i = 1,3
            do j = 1,3
               x(j,i) = 0
               do k = 1,3
                  x(j,i) = x(j,i) + b(k,j)* r(k)* b(k,i)
               enddo
            enddo
         enddo
      endif
      err = ics .lt. 3
      end

c ====================================================================
c     implicit   none

c     integer*4  m, n, i, j, info, me
c     parameter  ( m = 122 )
c     parameter  ( n = 6 )
c     parameter  ( me = n )
c     real*8     d(m), e(me)
c     real*8     q(m,m)

c --------------------------------------------------------------------
c     do i = 1,n
c        do j = 1,i-1
c           q(j,i) = q(i,j)
c        enddo
c        read(*,*)
c        read(*,'(2x,e24.16)') q(i,i)
c        do j = i+1,n
c           read(*,'(2x,2e24.16)') q(j,i)
c        enddo
c     enddo

c     do i = 1,n
c        write(33,'(a)')
c        write(33,'(a2,e24.16)') 'q', q(i,i)
c        do j = i+1,n
c           write(33,'(a2,2e24.16)') 'q', q(j,i)
c        enddo
c     enddo

c the first option is for testing subroutine dstevd_mo:
c
c     call dsyev( 'V', 'U', n, q, m, d, e, me, info )
c     call dsyev_mo( 'V', 'U', n, q, m, d, e, me, info )
c
c     if( info .ne. 0 )                                        stop'a'

c     call qd3q_double( m, n, q, d, e )

c     do i = 1,n
c        write(34,'(a)')
c        write(34,'(a2,e24.16)') 'q', q(i,i)
c        do j = i+1,n
c           write(34,'(a2,2e24.16)') 'q', q(j,i)
c        enddo
c     enddo
c     end

c ====================================================================
c     subroutine qd3q_double( m, n, q, d, e )
c     implicit   none

c     integer*4  m, n, i, j, k
c     real*8     q(m,n), d(n), e(n), f

c --------------------------------------------------------------------
c     do i = 1,n
c        do k = 1,n
c           e(k) = q(i,k)* d(k)
c        enddo
c        f = 0
c        do k = 1,n
c           f = f + q(i,k)* e(k)
c        enddo
c        q(i,i) = f
c        do j = 1,i-1
c           q(i,j) = q(j,i)
c        enddo
c        do j = i+1,n
c           q(i,j) = 0
c           do k = 1,n
c              q(i,j) = q(i,j) + q(j,k)* e(k)
c           enddo
c        enddo
c     enddo
c     end

c ====================================================================
c     subroutine dsyev( ch1, ch2, n, q, m, d, e, me, info )
c     implicit   none

c     character  ch1*1, ch2*1, ch1a*1, ch2a*1
c     integer*4  info

c     character  ch3*1 / '@' /
c     save       ch3

c     integer*4  m, n
c     real*8     q(m,n), d(n)

c     integer*4  mc, me
c     parameter  ( mc = 10000 )
c     integer*4  c(mc)
c     real*8     e(me)

c --------------------------------------------------------------------
c next two statement are due to avoid unused variables
c     if( ch1 .eq. 'X' ) ch1a = ch1
c     if( ch2 .eq. 'X' ) ch2a = ch2

c     if( me .ge. n )then
c        call q3qd_tred_double( m, n, d, q, e )
c        call dstevd_mo( ch3, n, d, e, q, m, e, me, c, mc, info )
c     else
c        info = - 8
c     endif
c     end

c ====================================================================
      subroutine dsyev_mo( ch1, ch2, n, q, m, d, e, me, info )
      implicit   none

      character  ch1*1, ch1a*1
      character  ch2*1
      integer*4  info

      integer*4  m, n, i, j
      real*8     q(m,n), d(n)

      integer*4  mc, me
      parameter  ( mc = 10000 )
      integer*4  c(mc)
      real*8     e(me)
      real*8     f

c --------------------------------------------------------------------
c the next statement is due to avoid info "unused variables"
      if( ch1 .eq. '@' ) ch1a = ch1

      info = 0
      if( me .ge. n .and. mc .ge. n* 2 )then
         if( ch2 .eq. 'U' )then
            do i = 1,n
               do j = i+1,n
                  q(j,i) = q(i,j)
               enddo
            enddo
         else if( ch2 .eq. 'L' )then
            do i = 1,n
               do j = 1,i-1
                  q(j,i) = q(i,j)
               enddo
            enddo
         else
            info = - 2
         endif
      else
         info = - 8
      endif
      if( info .eq. 0 )then
         call q3qd_tred_double( m, n, d, q, e )
         call q3qd_tqli_double( m, n, d, q, e, info )
      endif
      if( info .eq. 0 )then
         call q3qd_diff_double( n, c, d )
         call q3qd_move_double( n, c, m, n, q, e )
         call q3qd_diff_double( n, c, d )
         call q3qd_move_double( n, c, 1, 1, d, f )
      endif
      if( info .ne. 0 )                 write(0,*) 'error in dsyev_mo'
      end

c ====================================================================
      subroutine dstevd_mo( ch3, n, d, e, q, m, w, mw, c, mc, info )
      implicit   none

      character  ch3*1
      integer*4  info

      integer*4  m, n, i, j
      real*8     q(m,n), d(n), e(n), f

      integer*4  mc, mw
      integer*4  c(mc)
      real*8     w(mw)

c --------------------------------------------------------------------
c the next statement is due to avoid info "unused variables"
      if( mw .ge. 1 ) f = w(1)

      if( mc .ge. 2* n )then
         if( ch3 .ne. '@' )then
            do i = 1,n
               do j = 1,n
                  q(j,i) = 0
               enddo
               q(i,i) = 1
            enddo
         endif
         call q3qd_tqli_double( m, n, d, q, e, info )
      else
         info = - 10
      endif
      if( info .eq. 0 )then
         call q3qd_diff_double( n, c, d )
         call q3qd_move_double( n, c, m, n, q, e )
         call q3qd_diff_double( n, c, d )
         call q3qd_move_double( n, c, 1, 1, d, f )
      endif
      if( info .ne. 0 )                write(0,*) 'error in dstevd_mo'
      end

c ====================================================================
      subroutine q3qd_tred_double( m, n, d, q, e )
      implicit   none

      real*8     one / 1 /
      real*8     half
      integer*4  i, j, k, m, n
      real*8     d(n), q(m,n), e(n), r

c --------------------------------------------------------------------
      half = one/ 2

      do k = n-1,2,-1
         r = 0
         do i = 1,k
            r = r + q(i,k+1)**2
         enddo
         if( q(k,k+1) .gt. 0 )then
            e(k+1) = - sqrt(r)
         else
            e(k+1) = + sqrt(r)
         endif
         r = r - e(k+1)* q(k,k+1)

         if( r .gt. 0 )then

         r = 1/ sqrt( r )
         q(k,k+1) = q(k,k+1) - e(k+1)
         do i = 1,k
            q(i,k+1) = r* q(i,k+1)
         enddo
         do i = 1,k
            e(i) = 0
            do j = 1,k
               e(i) = e(i) + q(j,i)* q(j,k+1)
            enddo
         enddo
         r = 0
         do i = 1,k
            r = r + e(i)* q(i,k+1)
         enddo
         r = half* r
         do i = 1,k
            e(i) = e(i) - r* q(i,k+1)
         enddo
         do i = 1,k
            do j = 1,k
               r = half* ( e(i)* q(j,k+1) + e(j)* q(i,k+1) )
               q(j,i) = q(j,i) - r
               q(i,j) = q(i,j) - r
            enddo
         enddo

         endif
      enddo

      e(1) = q(1,2)
      do i = 2,n-1
         e(i) = e(i+1)
      enddo
      e(n) = 0
      do i = 1,n
         d(i) = q(i,i)
      enddo
      q(1,2) = 1
      do i = 1,n-1
         do j = 1,i
            q(j,i) = q(j,i+1)
         enddo
      enddo

      do k = 2,n-1
         do i = 1,k-1
            r = 0
            do j = 1,k-1
               r = r + q(j,i)* q(j,k)
            enddo
            do j = 1,k-1
               q(j,i) = q(j,i) - r* q(j,k)
            enddo
            q(k,i) = - r* q(k,k)
         enddo
         r = q(k,k)
         do j = 1,k
            q(j,k) = - r * q(j,k)
         enddo
         q(k,k) = q(k,k) + 1
      enddo

      do i = 1,n-1
         q(i,n) = 0
         q(n,i) = 0
      enddo
      q(n,n) = 1
      end

c ====================================================================
      subroutine q3qd_tqli_double( m, n, d, q, e, info )
      implicit   none

      real*8     half / 0.5D+00 /
      logical*4  fcont
      integer*4  i, j, k, l, m, n, icy, ncy, info
      real*8     d(n), q(m,n), e(n)
      real*8     f, g, h, t, s, c, s2, c2, zp, zn, q1, q2, dd1, dd2
      real*8     r

c --------------------------------------------------------------------
      ncy = 4* n**2
      icy = 0
      l = 1
      do while( l .lt. n .and. icy .lt. ncy )
         fcont = .true.
         do while( fcont .and. icy .lt. ncy )
            k = l
            do while( fcont .and. k .lt. n )
               dd1 = abs( d(k) ) + abs( d(k+1) )
               dd2 = abs( e(k) )* 0.1D+00 + dd1
               fcont = dd2 .ne. dd1
               if( fcont ) k = k + 1
            enddo
            fcont = k .gt. l
            if( fcont )then
               zp = half* ( d(l) + d(l+1) )
               zn = half* ( d(l) - d(l+1) )
!@@
               call q3qd_tqli_sqrt_double( zn, e(l), r )
               t = d(k) - ( zp + r )
!@@            t = d(k) - ( zp + sqrt( zn**2 + e(l)**2 ) )
!@@
               g = d(k)
               s = 1
               c = 1
               do i = k-1,l,-1
                  icy = icy + 1
                  f = e(i)* c
                  h = e(i)* s
!@@
                  call q3qd_tqli_sqrt_double( h, t, e(i+1) )
!@@               e(i+1) = sqrt( h**2 + t**2 )
!@@
                  if( e(i+1) .eq. 0 )then
                     s = 0
                     c = 1
                  else
                     s = h/ e(i+1)
                     c = t/ e(i+1)
                  endif
                  s2 = 2* s* c
                  c2 = c**2 - s**2
                  zp = half* ( d(i) + g )
                  zn = half* ( d(i) - g )
                  d(i+1) = zp - zn* c2 + f* s2
                  t =           zn* s2 + f* c2
                  g =      zp + zn* c2 - f* s2
                  do j = 1,n
                     q1 = c* q(j,i) - s* q(j,i+1)
                     q2 = s* q(j,i) + c* q(j,i+1)
                     q(j,i) = q1
                     q(j,i+1) = q2
                  enddo
               enddo
               d(l) = g
               e(l) = t
               e(k) = 0
            endif
         enddo
         l = l + 1
      enddo
      info = n - l
      end

! ====================================================================
      subroutine q3qd_tqli_sqrt_double( x1, x2, r )
      implicit   none

      real*8     x1, x2, a1, a2, r

! --------------------------------------------------------------------
      a1 = abs( x1 )
      a2 = abs( x2 )
      if( a1 .gt. a2 )then
         r = a1* sqrt( 1 + ( a2/ a1 )**2 )
      else
         r = a2* sqrt( 1 + ( a1/ a2 )**2 )
      endif
      end

c ====================================================================
      subroutine q3qd_diff_double( nc, c, r )
      implicit   none

      integer*4  ia, ja
      integer*4  ib, jb
      integer*4  ic, jc, kc, nc
      integer*4  c(nc*2)
      real*8     r(nc)

c --------------------------------------------------------------------
      do ic = 1,nc
         c(ic) = ic
      enddo
      jc = 2* nc
      kc = 1
      do while ( kc .lt. nc )
         ia = 1
         ib = 1 + kc
         ic = 1 + nc
         do while( ic .le. jc )
            ja = min( nc, ia + kc - 1 )
            jb = min( nc, ib + kc - 1 )
            do while( ia .le. ja .and. ib .le. jb )
               if( r(c(ib)) .ge. r(c(ia)) )then
                  c(ic) = c(ia)
                  ia = ia + 1
               else
                  c(ic) = c(ib)
                  ib = ib + 1
               endif
               ic = ic + 1
            enddo
            do while( ia .le. ja )
               c(ic) = c(ia)
               ia = ia + 1
               ic = ic + 1
            enddo
            do while( ib .le. jb )
               c(ic) = c(ib)
               ib = ib + 1
               ic = ic + 1
            enddo
            ia = ia + kc
            ib = ib + kc
         enddo
         do ic = 1,nc
            c(ic) = c(ic+nc)
         enddo
         kc = kc* 2
      enddo
      do ic = 1,nc
         c(nc+ic) = c(ic)
      enddo
      end

c ====================================================================
      subroutine q3qd_move_double( nc, c, mr, nr, r, r0 )
      implicit   none

      integer*4  nc, ic, jc
      integer*4  c(nc)
      integer*4  mr, nr, ir
      real*8     r(mr,nc), r0(nr)
      logical*4  found

c --------------------------------------------------------------------
      ic = 0
      found = .false.
      do while( .not. found .and. ic .lt. nc )
         ic = ic + 1
         found = ic .ne. c(ic)
      enddo
      do while( found )
         do ir = 1,nr
            r0(ir) = r(ir,ic)
         enddo
         jc = ic
         ic = c(ic)
         c(jc) = jc
         do while( ic .ne. c(ic) )
            do ir = 1,nr
               r(ir,jc) = r(ir,ic)
            enddo
            jc = ic
            ic = c(ic)
            c(jc) = jc
         enddo
         do ir = 1,nr
            r(ir,jc) = r0(ir)
         enddo
         found = .false.
         do while( .not. found .and. ic .lt. nc )
            ic = ic + 1
            found = ic .ne. c(ic)
         enddo
      enddo
      end

c ====================================================================
c ====================================================================
c     implicit   none

c     integer*4  m, n, i, j, info, me
c     parameter  ( m = 122 )
c     parameter  ( n = 6 )
c     parameter  ( me = n )
c     real       d(m), e(me)
c     real       q(m,m)

c --------------------------------------------------------------------
c     do i = 1,n
c        do j = 1,i-1
c           q(j,i) = q(i,j)
c        enddo
c        read(*,*)
c        read(*,'(2x,e24.16)') q(i,i)
c        do j = i+1,n
c           read(*,'(2x,2e24.16)') q(j,i)
c        enddo
c     enddo

c     do i = 1,n
c        write(33,'(a)')
c        write(33,'(a2,e24.16)') 'q', q(i,i)
c        do j = i+1,n
c           write(33,'(a2,2e24.16)') 'q', q(j,i)
c        enddo
c     enddo

c the first option is for testing subroutine sstevd_mo:
c
c     call ssyev( 'V', 'U', n, q, m, d, e, me, info )
c     call ssyev_mo( 'V', 'U', n, q, m, d, e, me, info )
c
c     if( info .ne. 0 )                                        stop'a'

c     call qd3q_single( m, n, q, d, e )

c     do i = 1,n
c        write(34,'(a)')
c        write(34,'(a2,e24.16)') 'q', q(i,i)
c        do j = i+1,n
c           write(34,'(a2,2e24.16)') 'q', q(j,i)
c        enddo
c     enddo
c     end

c ====================================================================
c     subroutine qd3q_single( m, n, q, d, e )
c     implicit   none

c     integer*4  m, n, i, j, k
c     real       q(m,n), d(n), e(n), f

c --------------------------------------------------------------------
c     do i = 1,n
c        do k = 1,n
c           e(k) = q(i,k)* d(k)
c        enddo
c        f = 0
c        do k = 1,n
c           f = f + q(i,k)* e(k)
c        enddo
c        q(i,i) = f
c        do j = 1,i-1
c           q(i,j) = q(j,i)
c        enddo
c        do j = i+1,n
c           q(i,j) = 0
c           do k = 1,n
c              q(i,j) = q(i,j) + q(j,k)* e(k)
c           enddo
c        enddo
c     enddo
c     end

c ====================================================================
c     subroutine ssyev( ch1, ch2, n, q, m, d, e, me, info )
c     implicit   none

c     character  ch1*1, ch2*1, ch1a*1, ch2a*1
c     integer*4  info

c     character  ch3*1 / '@' /
c     save       ch3

c     integer*4  m, n
c     real       q(m,n), d(n)

c     integer*4  mc, me
c     parameter  ( mc = 10000 )
c     integer*4  c(mc)
c     real       e(me)

c --------------------------------------------------------------------
c next two statement are due to avoid unused variables
c     if( ch1 .eq. 'X' ) ch1a = ch1
c     if( ch2 .eq. 'X' ) ch2a = ch2

c     if( me .ge. n )then
c        call q3qd_tred_single( m, n, d, q, e )
c        call sstevd_mo( ch3, n, d, e, q, m, e, me, c, mc, info )
c     else
c        info = - 8
c     endif
c     end

c ====================================================================
      subroutine ssyev_mo( ch1, ch2, n, q, m, d, e, me, info )
      implicit   none

      character  ch1*1, ch1a*1
      character  ch2*1
      integer*4  info

      integer*4  m, n, i, j
      real       q(m,n), d(n)

      integer*4  mc, me
      parameter  ( mc = 10000 )
      integer*4  c(mc)
      real       e(me)
      real       f

c --------------------------------------------------------------------
c the next statement is due to avoid info "unused variables"
      if( ch1 .eq. '@' ) ch1a = ch1

      info = 0
      if( me .ge. n .and. mc .ge. n* 2 )then
         if( ch2 .eq. 'U' )then
            do i = 1,n
               do j = i+1,n
                  q(j,i) = q(i,j)
               enddo
            enddo
         else if( ch2 .eq. 'L' )then
            do i = 1,n
               do j = 1,i-1
                  q(j,i) = q(i,j)
               enddo
            enddo
         else
            info = - 2
         endif
      else
         info = - 8
      endif
      if( info .eq. 0 )then
         call q3qd_tred_single( m, n, d, q, e )
         call q3qd_tqli_single( m, n, d, q, e, info )
      endif
      if( info .eq. 0 )then
         call q3qd_diff_single( n, c, d )
         call q3qd_move_single( n, c, m, n, q, e )
         call q3qd_diff_single( n, c, d )
         call q3qd_move_single( n, c, 1, 1, d, f )
      endif
      if( info .ne. 0 )        write(*,*) info,'error in ssyev_mo'
      end

c ====================================================================
      subroutine sstevd_mo( ch3, n, d, e, q, m, w, mw, c, mc, info )
      implicit   none

      character  ch3*1
      integer*4  info

      integer*4  m, n, i, j
      real       q(m,n), d(n), e(n), f

      integer*4  mc, mw
      integer*4  c(mc)
      real       w(mw)

c --------------------------------------------------------------------
c the next statement is due to avoid info "unused variables"
      if( mw .ge. 1 ) f = w(1)

      if( mc .ge. 2* n )then
         if( ch3 .ne. '@' )then
            do i = 1,n
               do j = 1,n
                  q(j,i) = 0
               enddo
               q(i,i) = 1
            enddo
         endif
         call q3qd_tqli_single( m, n, d, q, e, info )
      else
         info = - 10
      endif
      if( info .eq. 0 )then
         call q3qd_diff_single( n, c, d )
         call q3qd_move_single( n, c, m, n, q, e )
         call q3qd_diff_single( n, c, d )
         call q3qd_move_single( n, c, 1, 1, d, f )
      endif
      if( info .ne. 0 )                write(0,*) 'error in sstevd_mo'
      end

c ====================================================================
      subroutine q3qd_tred_single( m, n, d, q, e )
      implicit   none

      real       one / 1 /
      real       half
      integer*4  i, j, k, m, n
      real       d(n), q(m,n), e(n), r

c --------------------------------------------------------------------
      half = one/ 2

      do k = n-1,2,-1
         r = 0
         do i = 1,k
            r = r + q(i,k+1)**2
         enddo
         if( q(k,k+1) .gt. 0 )then
            e(k+1) = - sqrt(r)
         else
            e(k+1) = + sqrt(r)
         endif
         r = r - e(k+1)* q(k,k+1)

         if( r .gt. 0 )then

         r = 1/ sqrt( r )
         q(k,k+1) = q(k,k+1) - e(k+1)
         do i = 1,k
            q(i,k+1) = r* q(i,k+1)
         enddo
         do i = 1,k
            e(i) = 0
            do j = 1,k
               e(i) = e(i) + q(j,i)* q(j,k+1)
            enddo
         enddo
         r = 0
         do i = 1,k
            r = r + e(i)* q(i,k+1)
         enddo
         r = half* r
         do i = 1,k
            e(i) = e(i) - r* q(i,k+1)
         enddo
         do i = 1,k
            do j = 1,k
               r = half* ( e(i)* q(j,k+1) + e(j)* q(i,k+1) )
               q(j,i) = q(j,i) - r
               q(i,j) = q(i,j) - r
            enddo
         enddo

         endif
      enddo

      e(1) = q(1,2)
      do i = 2,n-1
         e(i) = e(i+1)
      enddo
      e(n) = 0
      do i = 1,n
         d(i) = q(i,i)
      enddo
      q(1,2) = 1
      do i = 1,n-1
         do j = 1,i
            q(j,i) = q(j,i+1)
         enddo
      enddo

      do k = 2,n-1
         do i = 1,k-1
            r = 0
            do j = 1,k-1
               r = r + q(j,i)* q(j,k)
            enddo
            do j = 1,k-1
               q(j,i) = q(j,i) - r* q(j,k)
            enddo
            q(k,i) = - r* q(k,k)
         enddo
         r = q(k,k)
         do j = 1,k
            q(j,k) = - r * q(j,k)
         enddo
         q(k,k) = q(k,k) + 1
      enddo

      do i = 1,n-1
         q(i,n) = 0
         q(n,i) = 0
      enddo
      q(n,n) = 1
      end

c ====================================================================
      subroutine q3qd_tqli_single( m, n, d, q, e, info )
      implicit   none

      real       half / 0.5D+00 /
      logical*4  fcont
      integer*4  i, j, k, l, m, n, icy, ncy, info
      real       d(n), q(m,n), e(n)
      real       f, g, h, t, s, c, s2, c2, zp, zn, q1, q2, dd1, dd2
      real       r

c --------------------------------------------------------------------
      ncy = 4* n**2
      icy = 0
      l = 1
      do while( l .lt. n .and. icy .lt. ncy )
         fcont = .true.
         do while( fcont .and. icy .lt. ncy )
            k = l
            do while( fcont .and. k .lt. n )
               dd1 = abs( d(k) ) + abs( d(k+1) )
               dd2 = abs( e(k) )* 0.1E+00 + dd1
               fcont = dd2 .ne. dd1
               if( fcont ) k = k + 1
            enddo
            fcont = k .gt. l
            if( fcont )then
               zp = half* ( d(l) + d(l+1) )
               zn = half* ( d(l) - d(l+1) )
!@@
               call q3qd_tqli_sqrt_single( zn, e(l), r )
               t = d(k) - ( zp + r )
!@@            t = d(k) - ( zp + sqrt( zn**2 + e(l)**2 ) )
!@@
               g = d(k)
               s = 1
               c = 1
               do i = k-1,l,-1
                  icy = icy + 1
                  f = e(i)* c
                  h = e(i)* s
!@@
                  call q3qd_tqli_sqrt_single( h, t, e(i+1) )
!@@               e(i+1) = sqrt( h**2 + t**2 )
!@@
                  if( e(i+1) .eq. 0 )then
                     s = 0
                     c = 1
                  else
                     s = h/ e(i+1)
                     c = t/ e(i+1)
                  endif
                  s2 = 2* s* c
                  c2 = c**2 - s**2
                  zp = half* ( d(i) + g )
                  zn = half* ( d(i) - g )
                  d(i+1) = zp - zn* c2 + f* s2
                  t =           zn* s2 + f* c2
                  g =      zp + zn* c2 - f* s2
                  do j = 1,n
                     q1 = c* q(j,i) - s* q(j,i+1)
                     q2 = s* q(j,i) + c* q(j,i+1)
                     q(j,i) = q1
                     q(j,i+1) = q2
                  enddo
               enddo
               d(l) = g
               e(l) = t
               e(k) = 0
            endif
         enddo
         l = l + 1
      enddo
      info = n - l
      end

! ====================================================================
      subroutine q3qd_tqli_sqrt_single( x1, x2, r )
      implicit   none

      real       x1, x2, a1, a2, r

! --------------------------------------------------------------------
      a1 = abs( x1 )
      a2 = abs( x2 )
      if( a1 .gt. a2 )then
         r = a1* sqrt( 1 + ( a2/ a1 )**2 )
      else
         r = a2* sqrt( 1 + ( a1/ a2 )**2 )
      endif
      end

c ====================================================================
      subroutine q3qd_diff_single( nc, c, r )
      implicit   none

      integer*4  ia, ja
      integer*4  ib, jb
      integer*4  ic, jc, kc, nc
      integer*4  c(nc*2)
      real       r(nc)

c --------------------------------------------------------------------
      do ic = 1,nc
         c(ic) = ic
      enddo
      jc = 2* nc
      kc = 1
      do while ( kc .lt. nc )
         ia = 1
         ib = 1 + kc
         ic = 1 + nc
         do while( ic .le. jc )
            ja = min( nc, ia + kc - 1 )
            jb = min( nc, ib + kc - 1 )
            do while( ia .le. ja .and. ib .le. jb )
               if( r(c(ib)) .ge. r(c(ia)) )then
                  c(ic) = c(ia)
                  ia = ia + 1
               else
                  c(ic) = c(ib)
                  ib = ib + 1
               endif
               ic = ic + 1
            enddo
            do while( ia .le. ja )
               c(ic) = c(ia)
               ia = ia + 1
               ic = ic + 1
            enddo
            do while( ib .le. jb )
               c(ic) = c(ib)
               ib = ib + 1
               ic = ic + 1
            enddo
            ia = ia + kc
            ib = ib + kc
         enddo
         do ic = 1,nc
            c(ic) = c(ic+nc)
         enddo
         kc = kc* 2
      enddo
      do ic = 1,nc
         c(nc+ic) = c(ic)
      enddo
      end

c ====================================================================
      subroutine q3qd_move_single( nc, c, mr, nr, r, r0 )
      implicit   none

      integer*4  nc, ic, jc
      integer*4  c(nc)
      integer*4  mr, nr, ir
      real       r(mr,nc), r0(nr)
      logical*4  found

c --------------------------------------------------------------------
      ic = 0
      found = .false.
      do while( .not. found .and. ic .lt. nc )
         ic = ic + 1
         found = ic .ne. c(ic)
      enddo
      do while( found )
         do ir = 1,nr
            r0(ir) = r(ir,ic)
         enddo
         jc = ic
         ic = c(ic)
         c(jc) = jc
         do while( ic .ne. c(ic) )
            do ir = 1,nr
               r(ir,jc) = r(ir,ic)
            enddo
            jc = ic
            ic = c(ic)
            c(jc) = jc
         enddo
         do ir = 1,nr
            r(ir,jc) = r0(ir)
         enddo
         found = .false.
         do while( .not. found .and. ic .lt. nc )
            ic = ic + 1
            found = ic .ne. c(ic)
         enddo
      enddo
      end

c ====================================================================
      DOUBLE PRECISION FUNCTION DLAMCH( CMACH )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      CHARACTER          CMACH
*     ..
*
*  Purpose
*  =======
*
*  DLAMCH determines double precision machine parameters.
*
*  Arguments
*  =========
*
*  CMACH   (input) CHARACTER*1
*          Specifies the value to be returned by DLAMCH:
*          = 'E' or 'e',   DLAMCH := eps
*          = 'S' or 's ,   DLAMCH := sfmin
*          = 'B' or 'b',   DLAMCH := base
*          = 'P' or 'p',   DLAMCH := eps*base
*          = 'N' or 'n',   DLAMCH := t
*          = 'R' or 'r',   DLAMCH := rnd
*          = 'M' or 'm',   DLAMCH := emin
*          = 'U' or 'u',   DLAMCH := rmin
*          = 'L' or 'l',   DLAMCH := emax
*          = 'O' or 'o',   DLAMCH := rmax
*
*          where
*
*          eps   = relative machine precision
*          sfmin = safe minimum, such that 1/sfmin does not overflow
*          base  = base of the machine
*          prec  = eps*base
*          t     = number of (base) digits in the mantissa
*          rnd   = 1.0 when rounding occurs in addition, 0.0 otherwise
*          emin  = minimum exponent before (gradual) underflow
*          rmin  = underflow threshold - base**(emin-1)
*          emax  = largest exponent before overflow
*          rmax  = overflow threshold  - (base**emax)*(1-eps)
*
* =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            FIRST, LRND
      INTEGER            BETA, IMAX, IMIN, IT
      DOUBLE PRECISION   BASE, EMAX, EMIN, EPS, PREC, RMACH, RMAX, RMIN,
     $                   RND, SFMIN, SMALL, T
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           DLAMC2
*     ..
*     .. Save statement ..
      SAVE               FIRST, EPS, SFMIN, BASE, T, RND, EMIN, RMIN,
     $                   EMAX, RMAX, PREC
*     ..
*     .. Data statements ..
      DATA               FIRST / .TRUE. /
*     ..
*     .. Executable Statements ..
*
      IF( FIRST ) THEN
         FIRST = .FALSE.
         CALL DLAMC2( BETA, IT, LRND, EPS, IMIN, RMIN, IMAX, RMAX )
         BASE = BETA
         T = IT
         IF( LRND ) THEN
            RND = ONE
            EPS = ( BASE**( 1-IT ) ) / 2
         ELSE
            RND = ZERO
            EPS = BASE**( 1-IT )
         END IF
         PREC = EPS*BASE
         EMIN = IMIN
         EMAX = IMAX
         SFMIN = RMIN
         SMALL = ONE / RMAX
         IF( SMALL.GE.SFMIN ) THEN
*
*           Use SMALL plus a bit, to avoid the possibility of rounding
*           causing overflow when computing  1/sfmin.
*
            SFMIN = SMALL*( ONE+EPS )
         END IF
      END IF
*
      IF( LSAME( CMACH, 'E' ) ) THEN
         RMACH = EPS
      ELSE IF( LSAME( CMACH, 'S' ) ) THEN
         RMACH = SFMIN
      ELSE IF( LSAME( CMACH, 'B' ) ) THEN
         RMACH = BASE
      ELSE IF( LSAME( CMACH, 'P' ) ) THEN
         RMACH = PREC
      ELSE IF( LSAME( CMACH, 'N' ) ) THEN
         RMACH = T
      ELSE IF( LSAME( CMACH, 'R' ) ) THEN
         RMACH = RND
      ELSE IF( LSAME( CMACH, 'M' ) ) THEN
         RMACH = EMIN
      ELSE IF( LSAME( CMACH, 'U' ) ) THEN
         RMACH = RMIN
      ELSE IF( LSAME( CMACH, 'L' ) ) THEN
         RMACH = EMAX
      ELSE IF( LSAME( CMACH, 'O' ) ) THEN
         RMACH = RMAX
      END IF
*
      DLAMCH = RMACH
      RETURN
*
*     End of DLAMCH
*
      END
*
************************************************************************
*
      SUBROUTINE DLAMC1( BETA, T, RND, IEEE1 )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      LOGICAL            IEEE1, RND
      INTEGER            BETA, T
*     ..
*
*  Purpose
*  =======
*
*  DLAMC1 determines the machine parameters given by BETA, T, RND, and
*  IEEE1.
*
*  Arguments
*  =========
*
*  BETA    (output) INTEGER
*          The base of the machine.
*
*  T       (output) INTEGER
*          The number of ( BETA ) digits in the mantissa.
*
*  RND     (output) LOGICAL
*          Specifies whether proper rounding  ( RND = .TRUE. )  or
*          chopping  ( RND = .FALSE. )  occurs in addition. This may not
*          be a reliable guide to the way in which the machine performs
*          its arithmetic.
*
*  IEEE1   (output) LOGICAL
*          Specifies whether rounding appears to be done in the IEEE
*          'round to nearest' style.
*
*  Further Details
*  ===============
*
*  The routine is based on the routine  ENVRON  by Malcolm and
*  incorporates suggestions by Gentleman and Marovich. See
*
*     Malcolm M. A. (1972) Algorithms to reveal properties of
*        floating-point arithmetic. Comms. of the ACM, 15, 949-951.
*
*     Gentleman W. M. and Marovich S. B. (1974) More on algorithms
*        that reveal properties of floating point arithmetic units.
*        Comms. of the ACM, 17, 276-277.
*
* =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            FIRST, LIEEE1, LRND
      INTEGER            LBETA, LT
      DOUBLE PRECISION   A, B, C, F, ONE, QTR, SAVEC, T1, T2
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMC3
      EXTERNAL           DLAMC3
*     ..
*     .. Save statement ..
      SAVE               FIRST, LIEEE1, LBETA, LRND, LT
*     ..
*     .. Data statements ..
      DATA               FIRST / .TRUE. /
*     ..
*     .. Executable Statements ..
*
      IF( FIRST ) THEN
         FIRST = .FALSE.
         ONE = 1
*
*        LBETA,  LIEEE1,  LT and  LRND  are the  local values  of  BETA,
*        IEEE1, T and RND.
*
*        Throughout this routine  we use the function  DLAMC3  to ensure
*        that relevant values are  stored and not held in registers,  or
*        are not affected by optimizers.
*
*        Compute  a = 2.0**m  with the  smallest positive integer m such
*        that
*
*           fl( a + 1.0 ) = a.
*
         A = 1
         C = 1
*
*+       WHILE( C.EQ.ONE )LOOP
   10    CONTINUE
         IF( C.EQ.ONE ) THEN
            A = 2*A
c@          C = DLAMC3( A, ONE )
            CALL DLAMC3a( C, A, ONE )
c@          C = DLAMC3( C, -A )
            CALL DLAMC3a( C, C, -A )
            GO TO 10
         END IF
*+       END WHILE
*
*        Now compute  b = 2.0**m  with the smallest positive integer m
*        such that
*
*           fl( a + b ) .gt. a.
*
         B = 1
c@       C = DLAMC3( A, B )
         CALL DLAMC3a( C, A, B )
*
*+       WHILE( C.EQ.A )LOOP
   20    CONTINUE
         IF( C.EQ.A ) THEN
            B = 2*B
c@          C = DLAMC3( A, B )
            CALL DLAMC3a( C, A, B )
            GO TO 20
         END IF
*+       END WHILE
*
*        Now compute the base.  a and c  are neighbouring floating point
*        numbers  in the  interval  ( beta**t, beta**( t + 1 ) )  and so
*        their difference is beta. Adding 0.25 to c is to ensure that it
*        is truncated to beta and not ( beta - 1 ).
*
         QTR = ONE / 4
         SAVEC = C
c@       C = DLAMC3( C, -A )
         CALL DLAMC3a( C, C, -A )
         LBETA = C + QTR
*
*        Now determine whether rounding or chopping occurs,  by adding a
*        bit  less  than  beta/2  and a  bit  more  than  beta/2  to  a.
*
         B = LBETA
c@       F = DLAMC3( B / 2, -B / 100 )
         CALL DLAMC3a( F, B / 2, -B / 100 )
c@       C = DLAMC3( F, A )
         CALL DLAMC3a( C, F, A )
         IF( C.EQ.A ) THEN
            LRND = .TRUE.
         ELSE
            LRND = .FALSE.
         END IF
c@       F = DLAMC3( B / 2, B / 100 )
         CALL DLAMC3a( F, B / 2, B / 100 )
c@       C = DLAMC3( F, A )
         CALL DLAMC3a( C, F, A )
         IF( ( LRND ) .AND. ( C.EQ.A ) )
     $      LRND = .FALSE.
*
*        Try and decide whether rounding is done in the  IEEE  'round to
*        nearest' style. B/2 is half a unit in the last place of the two
*        numbers A and SAVEC. Furthermore, A is even, i.e. has last  bit
*        zero, and SAVEC is odd. Thus adding B/2 to A should not  change
*        A, but adding B/2 to SAVEC should change SAVEC.
*
c@       T1 = DLAMC3( B / 2, A )
         CALL DLAMC3a( T1, B / 2, A )
c@       T2 = DLAMC3( B / 2, SAVEC )
         CALL DLAMC3a( T2, B / 2, SAVEC )
         LIEEE1 = ( T1.EQ.A ) .AND. ( T2.GT.SAVEC ) .AND. LRND
*
*        Now find  the  mantissa, t.  It should  be the  integer part of
*        log to the base beta of a,  however it is safer to determine  t
*        by powering.  So we find t as the smallest positive integer for
*        which
*
*           fl( beta**t + 1.0 ) = 1.0.
*
         LT = 0
         A = 1
         C = 1
*
*+       WHILE( C.EQ.ONE )LOOP
   30    CONTINUE
         IF( C.EQ.ONE ) THEN
            LT = LT + 1
            A = A*LBETA
c@          C = DLAMC3( A, ONE )
            CALL DLAMC3a( C, A, ONE )
c@          C = DLAMC3( C, -A )
            CALL DLAMC3a( C, C, -A )
            GO TO 30
         END IF
*+       END WHILE
*
      END IF
*
      BETA = LBETA
      T = LT
      RND = LRND
      IEEE1 = LIEEE1
      RETURN
*
*     End of DLAMC1
*
      END
*
************************************************************************
*
      SUBROUTINE DLAMC2( BETA, T, RND, EPS, EMIN, RMIN, EMAX, RMAX )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      LOGICAL            RND
      INTEGER            BETA, EMAX, EMIN, T
      DOUBLE PRECISION   EPS, RMAX, RMIN
*     ..
*
*  Purpose
*  =======
*
*  DLAMC2 determines the machine parameters specified in its argument
*  list.
*
*  Arguments
*  =========
*
*  BETA    (output) INTEGER
*          The base of the machine.
*
*  T       (output) INTEGER
*          The number of ( BETA ) digits in the mantissa.
*
*  RND     (output) LOGICAL
*          Specifies whether proper rounding  ( RND = .TRUE. )  or
*          chopping  ( RND = .FALSE. )  occurs in addition. This may not
*          be a reliable guide to the way in which the machine performs
*          its arithmetic.
*
*  EPS     (output) DOUBLE PRECISION
*          The smallest positive number such that
*
*             fl( 1.0 - EPS ) .LT. 1.0,
*
*          where fl denotes the computed value.
*
*  EMIN    (output) INTEGER
*          The minimum exponent before (gradual) underflow occurs.
*
*  RMIN    (output) DOUBLE PRECISION
*          The smallest normalized number for the machine, given by
*          BASE**( EMIN - 1 ), where  BASE  is the floating point value
*          of BETA.
*
*  EMAX    (output) INTEGER
*          The maximum exponent before overflow occurs.
*
*  RMAX    (output) DOUBLE PRECISION
*          The largest positive number for the machine, given by
*          BASE**EMAX * ( 1 - EPS ), where  BASE  is the floating point
*          value of BETA.
*
*  Further Details
*  ===============
*
*  The computation of  EPS  is based on a routine PARANOIA by
*  W. Kahan of the University of California at Berkeley.
*
* =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            FIRST, IEEE, IWARN, LIEEE1, LRND
      INTEGER            GNMIN, GPMIN, I, LBETA, LEMAX, LEMIN, LT,
     $                   NGNMIN, NGPMIN
      DOUBLE PRECISION   A, B, C, HALF, LEPS, LRMAX, LRMIN, ONE, RBASE,
     $                   SIXTH, SMALL, THIRD, TWO, ZERO
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMC3
      EXTERNAL           DLAMC3
*     ..
*     .. External Subroutines ..
      EXTERNAL           DLAMC1, DLAMC4, DLAMC5
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN
*     ..
*     .. Save statement ..
      SAVE               FIRST, IWARN, LBETA, LEMAX, LEMIN, LEPS, LRMAX,
     $                   LRMIN, LT
*     ..
*     .. Data statements ..
      DATA               FIRST / .TRUE. / , IWARN / .FALSE. /
*     ..
*     .. Executable Statements ..
*
      IF( FIRST ) THEN
         FIRST = .FALSE.
         ZERO = 0
         ONE = 1
         TWO = 2
*
*        LBETA, LT, LRND, LEPS, LEMIN and LRMIN  are the local values of
*        BETA, T, RND, EPS, EMIN and RMIN.
*
*        Throughout this routine  we use the function  DLAMC3  to ensure
*        that relevant values are stored  and not held in registers,  or
*        are not affected by optimizers.
*
*        DLAMC1 returns the parameters  LBETA, LT, LRND and LIEEE1.
*
         CALL DLAMC1( LBETA, LT, LRND, LIEEE1 )
*
*        Start to find EPS.
*
         B = LBETA
         A = B**( -LT )
         LEPS = A
*
*        Try some tricks to see whether or not this is the correct  EPS.
*
         B = TWO / 3
         HALF = ONE / 2
c@       SIXTH = DLAMC3( B, -HALF )
         CALL DLAMC3a( SIXTH, B, -HALF )
c@       THIRD = DLAMC3( SIXTH, SIXTH )
         CALL DLAMC3a( THIRD, SIXTH, SIXTH )
c@       B = DLAMC3( THIRD, -HALF )
         CALL DLAMC3a( B, THIRD, -HALF )
c@       B = DLAMC3( B, SIXTH )
         CALL DLAMC3a( B, B, SIXTH )
         B = ABS( B )
         IF( B.LT.LEPS )
     $      B = LEPS
*
         LEPS = 1
*
*+       WHILE( ( LEPS.GT.B ).AND.( B.GT.ZERO ) )LOOP
   10    CONTINUE
         IF( ( LEPS.GT.B ) .AND. ( B.GT.ZERO ) ) THEN
            LEPS = B
c@          C = DLAMC3( HALF*LEPS, ( TWO**5 )*( LEPS**2 ) )
            CALL DLAMC3a( C, HALF*LEPS, ( TWO**5 )*( LEPS**2 ) )
c@          C = DLAMC3( HALF, -C )
            CALL DLAMC3a( C, HALF, -C )
c@          B = DLAMC3( HALF, C )
            CALL DLAMC3a( B, HALF, C )
c@          C = DLAMC3( HALF, -B )
            CALL DLAMC3a( C, HALF, -B )
c@          B = DLAMC3( HALF, C )
            CALL DLAMC3a( B, HALF, C )
            GO TO 10
         END IF
*+       END WHILE
*
         IF( A.LT.LEPS )
     $      LEPS = A
*
*        Computation of EPS complete.
*
*        Now find  EMIN.  Let A = + or - 1, and + or - (1 + BASE**(-3)).
*        Keep dividing  A by BETA until (gradual) underflow occurs. This
*        is detected when we cannot recover the previous A.
*
         RBASE = ONE / LBETA
         SMALL = ONE
         DO 20 I = 1, 3
c@          SMALL = DLAMC3( SMALL*RBASE, ZERO )
            CALL DLAMC3a( SMALL, SMALL*RBASE, ZERO )
   20    CONTINUE
c@       A = DLAMC3( ONE, SMALL )
         CALL DLAMC3a( A, ONE, SMALL )
         CALL DLAMC4( NGPMIN, ONE, LBETA )
         CALL DLAMC4( NGNMIN, -ONE, LBETA )
         CALL DLAMC4( GPMIN, A, LBETA )
         CALL DLAMC4( GNMIN, -A, LBETA )
         IEEE = .FALSE.
*
         IF( ( NGPMIN.EQ.NGNMIN ) .AND. ( GPMIN.EQ.GNMIN ) ) THEN
            IF( NGPMIN.EQ.GPMIN ) THEN
               LEMIN = NGPMIN
*            ( Non twos-complement machines, no gradual underflow;
*              e.g.,  VAX )
            ELSE IF( ( GPMIN-NGPMIN ).EQ.3 ) THEN
               LEMIN = NGPMIN - 1 + LT
               IEEE = .TRUE.
*            ( Non twos-complement machines, with gradual underflow;
*              e.g., IEEE standard followers )
            ELSE
               LEMIN = MIN( NGPMIN, GPMIN )
*            ( A guess; no known machine )
               IWARN = .TRUE.
            END IF
*
         ELSE IF( ( NGPMIN.EQ.GPMIN ) .AND. ( NGNMIN.EQ.GNMIN ) ) THEN
            IF( ABS( NGPMIN-NGNMIN ).EQ.1 ) THEN
               LEMIN = MAX( NGPMIN, NGNMIN )
*            ( Twos-complement machines, no gradual underflow;
*              e.g., CYBER 205 )
            ELSE
               LEMIN = MIN( NGPMIN, NGNMIN )
*            ( A guess; no known machine )
               IWARN = .TRUE.
            END IF
*
         ELSE IF( ( ABS( NGPMIN-NGNMIN ).EQ.1 ) .AND.
     $            ( GPMIN.EQ.GNMIN ) ) THEN
            IF( ( GPMIN-MIN( NGPMIN, NGNMIN ) ).EQ.3 ) THEN
               LEMIN = MAX( NGPMIN, NGNMIN ) - 1 + LT
*            ( Twos-complement machines with gradual underflow;
*              no known machine )
            ELSE
               LEMIN = MIN( NGPMIN, NGNMIN )
*            ( A guess; no known machine )
               IWARN = .TRUE.
            END IF
*
         ELSE
            LEMIN = MIN( NGPMIN, NGNMIN, GPMIN, GNMIN )
*         ( A guess; no known machine )
            IWARN = .TRUE.
         END IF
***
* Comment out this if block if EMIN is ok
         IF( IWARN ) THEN
            FIRST = .TRUE.
            WRITE( 6, FMT = 9999 )LEMIN
         END IF
***
*
*        Assume IEEE arithmetic if we found denormalised  numbers above,
*        or if arithmetic seems to round in the  IEEE style,  determined
*        in routine DLAMC1. A true IEEE machine should have both  things
*        true; however, faulty machines may have one or the other.
*
         IEEE = IEEE .OR. LIEEE1
*
*        Compute  RMIN by successive division by  BETA. We could compute
*        RMIN as BASE**( EMIN - 1 ),  but some machines underflow during
*        this computation.
*
         LRMIN = 1
         DO 30 I = 1, 1 - LEMIN
c@          LRMIN = DLAMC3( LRMIN*RBASE, ZERO )
            CALL DLAMC3a( LRMIN, LRMIN*RBASE, ZERO )
   30    CONTINUE
*
*        Finally, call DLAMC5 to compute EMAX and RMAX.
*
         CALL DLAMC5( LBETA, LT, LEMIN, IEEE, LEMAX, LRMAX )
      END IF
*
      BETA = LBETA
      T = LT
      RND = LRND
      EPS = LEPS
      EMIN = LEMIN
      RMIN = LRMIN
      EMAX = LEMAX
      RMAX = LRMAX
*
      RETURN
*
 9999 FORMAT( / / ' WARNING. The value EMIN may be incorrect:-',
     $      '  EMIN = ', I8, /
     $      ' If, after inspection, the value EMIN looks',
     $      ' acceptable please comment out ',
     $      / ' the IF block as marked within the code of routine',
     $      ' DLAMC2,', / ' otherwise supply EMIN explicitly.', / )
*
*     End of DLAMC2
*
      END
*
************************************************************************
      SUBROUTINE       DLAMC3a( C, A, B )
      DOUBLE PRECISION A, B, C
      C = A + B
      RETURN
      END
************************************************************************
*
      DOUBLE PRECISION FUNCTION DLAMC3( A, B )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      DOUBLE PRECISION   A, B
*     ..
*
*  Purpose
*  =======
*
*  DLAMC3  is intended to force  A  and  B  to be stored prior to doing
*  the addition of  A  and  B ,  for use in situations where optimizers
*  might hold one of these in a register.
*
*  Arguments
*  =========
*
*  A, B    (input) DOUBLE PRECISION
*          The values A and B.
*
* =====================================================================
*
*     .. Executable Statements ..
*
      DLAMC3 = A + B
*
      RETURN
*
*     End of DLAMC3
*
      END
*
************************************************************************
*
      SUBROUTINE DLAMC4( EMIN, START, BASE )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      INTEGER            BASE, EMIN
      DOUBLE PRECISION   START
*     ..
*
*  Purpose
*  =======
*
*  DLAMC4 is a service routine for DLAMC2.
*
*  Arguments
*  =========
*
*  EMIN    (output) EMIN
*          The minimum exponent before (gradual) underflow, computed by
*          setting A = START and dividing by BASE until the previous A
*          can not be recovered.
*
*  START   (input) DOUBLE PRECISION
*          The starting point for determining EMIN.
*
*  BASE    (input) INTEGER
*          The base of the machine.
*
* =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I
      DOUBLE PRECISION   A, B1, B2, C1, C2, D1, D2, ONE, RBASE, ZERO
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMC3
      EXTERNAL           DLAMC3
*     ..
*     .. Executable Statements ..
*
      A = START
      ONE = 1
      RBASE = ONE / BASE
      ZERO = 0
      EMIN = 1
c@    B1 = DLAMC3( A*RBASE, ZERO )
      CALL DLAMC3a( B1, A*RBASE, ZERO )
      C1 = A
      C2 = A
      D1 = A
      D2 = A
*+    WHILE( ( C1.EQ.A ).AND.( C2.EQ.A ).AND.
*    $       ( D1.EQ.A ).AND.( D2.EQ.A )      )LOOP
   10 CONTINUE
      IF( ( C1.EQ.A ) .AND. ( C2.EQ.A ) .AND. ( D1.EQ.A ) .AND.
     $    ( D2.EQ.A ) ) THEN
         EMIN = EMIN - 1
         A = B1
c@       B1 = DLAMC3( A / BASE, ZERO )
         CALL DLAMC3a( B1, A / BASE, ZERO )
c@       C1 = DLAMC3( B1*BASE, ZERO )
         CALL DLAMC3a( C1, B1*BASE, ZERO )
         D1 = ZERO
         DO 20 I = 1, BASE
            D1 = D1 + B1
   20    CONTINUE
c@       B2 = DLAMC3( A*RBASE, ZERO )
         CALL DLAMC3a( B2, A*RBASE, ZERO )
c@       C2 = DLAMC3( B2 / RBASE, ZERO )
         CALL DLAMC3a( C2, B2 / RBASE, ZERO )
         D2 = ZERO
         DO 30 I = 1, BASE
            D2 = D2 + B2
   30    CONTINUE
         GO TO 10
      END IF
*+    END WHILE
*
      RETURN
*
*     End of DLAMC4
*
      END
*
************************************************************************
*
      SUBROUTINE DLAMC5( BETA, P, EMIN, IEEE, EMAX, RMAX )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      LOGICAL            IEEE
      INTEGER            BETA, EMAX, EMIN, P
      DOUBLE PRECISION   RMAX
*     ..
*
*  Purpose
*  =======
*
*  DLAMC5 attempts to compute RMAX, the largest machine floating-point
*  number, without overflow.  It assumes that EMAX + abs(EMIN) sum
*  approximately to a power of 2.  It will fail on machines where this
*  assumption does not hold, for example, the Cyber 205 (EMIN = -28625,
*  EMAX = 28718).  It will also fail if the value supplied for EMIN is
*  too large (i.e. too close to zero), probably with overflow.
*
*  Arguments
*  =========
*
*  BETA    (input) INTEGER
*          The base of floating-point arithmetic.
*
*  P       (input) INTEGER
*          The number of base BETA digits in the mantissa of a
*          floating-point value.
*
*  EMIN    (input) INTEGER
*          The minimum exponent before (gradual) underflow.
*
*  IEEE    (input) LOGICAL
*          A logical flag specifying whether or not the arithmetic
*          system is thought to comply with the IEEE standard.
*
*  EMAX    (output) INTEGER
*          The largest exponent before overflow
*
*  RMAX    (output) DOUBLE PRECISION
*          The largest machine floating-point number.
*
* =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D0, ONE = 1.0D0 )
*     ..
*     .. Local Scalars ..
      INTEGER            EXBITS, EXPSUM, I, LEXP, NBITS, TRY, UEXP
      DOUBLE PRECISION   OLDY, RECBAS, Y, Z
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMC3
      EXTERNAL           DLAMC3
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
*     First compute LEXP and UEXP, two powers of 2 that bound
*     abs(EMIN). We then assume that EMAX + abs(EMIN) will sum
*     approximately to the bound that is closest to abs(EMIN).
*     (EMAX is the exponent of the required number RMAX).
*
      LEXP = 1
      EXBITS = 1
   10 CONTINUE
      TRY = LEXP*2
      IF( TRY.LE.( -EMIN ) ) THEN
         LEXP = TRY
         EXBITS = EXBITS + 1
         GO TO 10
      END IF
      IF( LEXP.EQ.-EMIN ) THEN
         UEXP = LEXP
      ELSE
         UEXP = TRY
         EXBITS = EXBITS + 1
      END IF
*
*     Now -LEXP is less than or equal to EMIN, and -UEXP is greater
*     than or equal to EMIN. EXBITS is the number of bits needed to
*     store the exponent.
*
      IF( ( UEXP+EMIN ).GT.( -LEXP-EMIN ) ) THEN
         EXPSUM = 2*LEXP
      ELSE
         EXPSUM = 2*UEXP
      END IF
*
*     EXPSUM is the exponent range, approximately equal to
*     EMAX - EMIN + 1 .
*
      EMAX = EXPSUM + EMIN - 1
      NBITS = 1 + EXBITS + P
*
*     NBITS is the total number of bits needed to store a
*     floating-point number.
*
      IF( ( MOD( NBITS, 2 ).EQ.1 ) .AND. ( BETA.EQ.2 ) ) THEN
*
*        Either there are an odd number of bits used to store a
*        floating-point number, which is unlikely, or some bits are
*        not used in the representation of numbers, which is possible,
*        (e.g. Cray machines) or the mantissa has an implicit bit,
*        (e.g. IEEE machines, Dec Vax machines), which is perhaps the
*        most likely. We have to assume the last alternative.
*        If this is true, then we need to reduce EMAX by one because
*        there must be some way of representing zero in an implicit-bit
*        system. On machines like Cray, we are reducing EMAX by one
*        unnecessarily.
*
         EMAX = EMAX - 1
      END IF
*
      IF( IEEE ) THEN
*
*        Assume we are on an IEEE machine which reserves one exponent
*        for infinity and NaN.
*
         EMAX = EMAX - 1
      END IF
*
*     Now create RMAX, the largest machine number, which should
*     be equal to (1.0 - BETA**(-P)) * BETA**EMAX .
*
*     First compute 1.0 - BETA**(-P), being careful that the
*     result is less than 1.0 .
*
      RECBAS = ONE / BETA
      Z = BETA - ONE
      Y = ZERO
      DO 20 I = 1, P
         Z = Z*RECBAS
         IF( Y.LT.ONE )
     $      OLDY = Y
c@       Y = DLAMC3( Y, Z )
         CALL DLAMC3a( Y, Y, Z )
   20 CONTINUE
      IF( Y.GE.ONE )
     $   Y = OLDY
*
*     Now multiply by BETA**EMAX to get RMAX.
*
      DO 30 I = 1, EMAX
c@       Y = DLAMC3( Y*BETA, ZERO )
         CALL DLAMC3a( Y, Y*BETA, ZERO )
   30 CONTINUE
*
      RMAX = Y
      RETURN
*
*     End of DLAMC5
*
      END
      REAL             FUNCTION SLAMCH( CMACH )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992 
*
*     .. Scalar Arguments ..
      CHARACTER          CMACH
*     ..
*
*  Purpose
*  =======
*
*  SLAMCH determines single precision machine parameters.
*
*  Arguments
*  =========
*
*  CMACH   (input) CHARACTER*1
*          Specifies the value to be returned by SLAMCH:
*          = 'E' or 'e',   SLAMCH := eps
*          = 'S' or 's ,   SLAMCH := sfmin
*          = 'B' or 'b',   SLAMCH := base
*          = 'P' or 'p',   SLAMCH := eps*base
*          = 'N' or 'n',   SLAMCH := t
*          = 'R' or 'r',   SLAMCH := rnd
*          = 'M' or 'm',   SLAMCH := emin
*          = 'U' or 'u',   SLAMCH := rmin
*          = 'L' or 'l',   SLAMCH := emax
*          = 'O' or 'o',   SLAMCH := rmax
*
*          where
*
*          eps   = relative machine precision
*          sfmin = safe minimum, such that 1/sfmin does not overflow
*          base  = base of the machine
*          prec  = eps*base
*          t     = number of (base) digits in the mantissa
*          rnd   = 1.0 when rounding occurs in addition, 0.0 otherwise
*          emin  = minimum exponent before (gradual) underflow
*          rmin  = underflow threshold - base**(emin-1)
*          emax  = largest exponent before overflow
*          rmax  = overflow threshold  - (base**emax)*(1-eps)
*
* =====================================================================
*
*     .. Parameters ..
      REAL               ONE, ZERO
      PARAMETER          ( ONE = 1.0E+0, ZERO = 0.0E+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            FIRST, LRND
      INTEGER            BETA, IMAX, IMIN, IT
      REAL               BASE, EMAX, EMIN, EPS, PREC, RMACH, RMAX, RMIN,
     $                   RND, SFMIN, SMALL, T
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           SLAMC2
*     ..
*     .. Save statement ..
      SAVE               FIRST, EPS, SFMIN, BASE, T, RND, EMIN, RMIN,
     $                   EMAX, RMAX, PREC
*     ..
*     .. Data statements ..
      DATA               FIRST / .TRUE. /
*     ..
*     .. Executable Statements ..
*
      IF( FIRST ) THEN
         FIRST = .FALSE.
         CALL SLAMC2( BETA, IT, LRND, EPS, IMIN, RMIN, IMAX, RMAX )
         BASE = BETA
         T = IT
         IF( LRND ) THEN
            RND = ONE
            EPS = ( BASE**( 1-IT ) ) / 2
         ELSE
            RND = ZERO
            EPS = BASE**( 1-IT )
         END IF
         PREC = EPS*BASE
         EMIN = IMIN
         EMAX = IMAX
         SFMIN = RMIN
         SMALL = ONE / RMAX
         IF( SMALL.GE.SFMIN ) THEN
*
*           Use SMALL plus a bit, to avoid the possibility of rounding
*           causing overflow when computing  1/sfmin.
*
            SFMIN = SMALL*( ONE+EPS )
         END IF
      END IF
*
      IF( LSAME( CMACH, 'E' ) ) THEN
         RMACH = EPS
      ELSE IF( LSAME( CMACH, 'S' ) ) THEN
         RMACH = SFMIN
      ELSE IF( LSAME( CMACH, 'B' ) ) THEN
         RMACH = BASE
      ELSE IF( LSAME( CMACH, 'P' ) ) THEN
         RMACH = PREC
      ELSE IF( LSAME( CMACH, 'N' ) ) THEN
         RMACH = T
      ELSE IF( LSAME( CMACH, 'R' ) ) THEN
         RMACH = RND
      ELSE IF( LSAME( CMACH, 'M' ) ) THEN
         RMACH = EMIN
      ELSE IF( LSAME( CMACH, 'U' ) ) THEN
         RMACH = RMIN
      ELSE IF( LSAME( CMACH, 'L' ) ) THEN
         RMACH = EMAX
      ELSE IF( LSAME( CMACH, 'O' ) ) THEN
         RMACH = RMAX
      END IF
*
      SLAMCH = RMACH
      RETURN
*
*     End of SLAMCH
*
      END
*
************************************************************************
*
      SUBROUTINE SLAMC1( BETA, T, RND, IEEE1 )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      LOGICAL            IEEE1, RND
      INTEGER            BETA, T
*     ..
*
*  Purpose
*  =======
*
*  SLAMC1 determines the machine parameters given by BETA, T, RND, and
*  IEEE1.
*
*  Arguments
*  =========
*
*  BETA    (output) INTEGER
*          The base of the machine.
*
*  T       (output) INTEGER
*          The number of ( BETA ) digits in the mantissa.
*
*  RND     (output) LOGICAL
*          Specifies whether proper rounding  ( RND = .TRUE. )  or
*          chopping  ( RND = .FALSE. )  occurs in addition. This may not
*          be a reliable guide to the way in which the machine performs
*          its arithmetic.
*
*  IEEE1   (output) LOGICAL
*          Specifies whether rounding appears to be done in the IEEE
*          'round to nearest' style.
*
*  Further Details
*  ===============
*
*  The routine is based on the routine  ENVRON  by Malcolm and
*  incorporates suggestions by Gentleman and Marovich. See
*
*     Malcolm M. A. (1972) Algorithms to reveal properties of
*        floating-point arithmetic. Comms. of the ACM, 15, 949-951.
*
*     Gentleman W. M. and Marovich S. B. (1974) More on algorithms
*        that reveal properties of floating point arithmetic units.
*        Comms. of the ACM, 17, 276-277.
*
* =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            FIRST, LIEEE1, LRND
      INTEGER            LBETA, LT
      REAL               A, B, C, F, ONE, QTR, SAVEC, T1, T2
*     ..
*     .. External Functions ..
      REAL               SLAMC3
      EXTERNAL           SLAMC3
*     ..
*     .. Save statement ..
      SAVE               FIRST, LIEEE1, LBETA, LRND, LT
*     ..
*     .. Data statements ..
      DATA               FIRST / .TRUE. /
*     ..
*     .. Executable Statements ..
*
      IF( FIRST ) THEN
         FIRST = .FALSE.
         ONE = 1
*
*        LBETA,  LIEEE1,  LT and  LRND  are the  local values  of  BETA,
*        IEEE1, T and RND.
*
*        Throughout this routine  we use the function  SLAMC3  to ensure
*        that relevant values are  stored and not held in registers,  or
*        are not affected by optimizers.
*
*        Compute  a = 2.0**m  with the  smallest positive integer m such
*        that
*
*           fl( a + 1.0 ) = a.
*
         A = 1
         C = 1
*
*+       WHILE( C.EQ.ONE )LOOP
   10    CONTINUE
         IF( C.EQ.ONE ) THEN
            A = 2*A
c@          C = SLAMC3( A, ONE )
            CALL SLAMC3a( C, A, ONE )
c@          C = SLAMC3( C, -A )
            CALL SLAMC3a( C, C, -A )
            GO TO 10
         END IF
*+       END WHILE
*
*        Now compute  b = 2.0**m  with the smallest positive integer m
*        such that
*
*           fl( a + b ) .gt. a.
*
         B = 1
c@       C = SLAMC3( A, B )
         CALL SLAMC3a( C, A, B )
*
*+       WHILE( C.EQ.A )LOOP
   20    CONTINUE
         IF( C.EQ.A ) THEN
            B = 2*B
c@          C = SLAMC3( A, B )
            CALL SLAMC3a( C, A, B )
            GO TO 20
         END IF
*+       END WHILE
*
*        Now compute the base.  a and c  are neighbouring floating point
*        numbers  in the  interval  ( beta**t, beta**( t + 1 ) )  and so
*        their difference is beta. Adding 0.25 to c is to ensure that it
*        is truncated to beta and not ( beta - 1 ).
*
         QTR = ONE / 4
         SAVEC = C
c@       C = SLAMC3( C, -A )
         CALL SLAMC3a( C, C, -A )
         LBETA = C + QTR
*
*        Now determine whether rounding or chopping occurs,  by adding a
*        bit  less  than  beta/2  and a  bit  more  than  beta/2  to  a.
*
         B = LBETA
c@       F = SLAMC3( B / 2, -B / 100 )
         CALL SLAMC3a( F, B / 2, -B / 100 )
c@       C = SLAMC3( F, A )
         CALL SLAMC3a( C, F, A )
         IF( C.EQ.A ) THEN
            LRND = .TRUE.
         ELSE
            LRND = .FALSE.
         END IF
c@       F = SLAMC3( B / 2, B / 100 )
         CALL SLAMC3a( F, B / 2, B / 100 )
c@       C = SLAMC3( F, A )
         CALL SLAMC3a( C, F, A )
         IF( ( LRND ) .AND. ( C.EQ.A ) )
     $      LRND = .FALSE.
*
*        Try and decide whether rounding is done in the  IEEE  'round to
*        nearest' style. B/2 is half a unit in the last place of the two
*        numbers A and SAVEC. Furthermore, A is even, i.e. has last  bit
*        zero, and SAVEC is odd. Thus adding B/2 to A should not  change
*        A, but adding B/2 to SAVEC should change SAVEC.
*
c@       T1 = SLAMC3( B / 2, A )
         CALL SLAMC3a( T1, B / 2, A )
c@       T2 = SLAMC3( B / 2, SAVEC )
         CALL SLAMC3a( T2, B / 2, SAVEC )
         LIEEE1 = ( T1.EQ.A ) .AND. ( T2.GT.SAVEC ) .AND. LRND
*
*        Now find  the  mantissa, t.  It should  be the  integer part of
*        log to the base beta of a,  however it is safer to determine  t
*        by powering.  So we find t as the smallest positive integer for
*        which
*
*           fl( beta**t + 1.0 ) = 1.0.
*
         LT = 0
         A = 1
         C = 1
*
*+       WHILE( C.EQ.ONE )LOOP
   30    CONTINUE
         IF( C.EQ.ONE ) THEN
            LT = LT + 1
            A = A*LBETA
c@          C = SLAMC3( A, ONE )
            CALL SLAMC3a( C, A, ONE )
c@          C = SLAMC3( C, -A )
            CALL SLAMC3a( C, C, -A )
            GO TO 30
         END IF
*+       END WHILE
*
      END IF
*
      BETA = LBETA
      T = LT
      RND = LRND
      IEEE1 = LIEEE1
      RETURN
*
*     End of SLAMC1
*
      END
*
************************************************************************
*
      SUBROUTINE SLAMC2( BETA, T, RND, EPS, EMIN, RMIN, EMAX, RMAX )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      LOGICAL            RND
      INTEGER            BETA, EMAX, EMIN, T
      REAL               EPS, RMAX, RMIN
*     ..
*
*  Purpose
*  =======
*
*  SLAMC2 determines the machine parameters specified in its argument
*  list.
*
*  Arguments
*  =========
*
*  BETA    (output) INTEGER
*          The base of the machine.
*
*  T       (output) INTEGER
*          The number of ( BETA ) digits in the mantissa.
*
*  RND     (output) LOGICAL
*          Specifies whether proper rounding  ( RND = .TRUE. )  or
*          chopping  ( RND = .FALSE. )  occurs in addition. This may not
*          be a reliable guide to the way in which the machine performs
*          its arithmetic.
*
*  EPS     (output) REAL
*          The smallest positive number such that
*
*             fl( 1.0 - EPS ) .LT. 1.0,
*
*          where fl denotes the computed value.
*
*  EMIN    (output) INTEGER
*          The minimum exponent before (gradual) underflow occurs.
*
*  RMIN    (output) REAL
*          The smallest normalized number for the machine, given by
*          BASE**( EMIN - 1 ), where  BASE  is the floating point value
*          of BETA.
*
*  EMAX    (output) INTEGER
*          The maximum exponent before overflow occurs.
*
*  RMAX    (output) REAL
*          The largest positive number for the machine, given by
*          BASE**EMAX * ( 1 - EPS ), where  BASE  is the floating point
*          value of BETA.
*
*  Further Details
*  ===============
*
*  The computation of  EPS  is based on a routine PARANOIA by
*  W. Kahan of the University of California at Berkeley.
*
* =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            FIRST, IEEE, IWARN, LIEEE1, LRND
      INTEGER            GNMIN, GPMIN, I, LBETA, LEMAX, LEMIN, LT,
     $                   NGNMIN, NGPMIN
      REAL               A, B, C, HALF, LEPS, LRMAX, LRMIN, ONE, RBASE,
     $                   SIXTH, SMALL, THIRD, TWO, ZERO
*     ..
*     .. External Functions ..
      REAL               SLAMC3
      EXTERNAL           SLAMC3
*     ..
*     .. External Subroutines ..
      EXTERNAL           SLAMC1, SLAMC4, SLAMC5
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN
*     ..
*     .. Save statement ..
      SAVE               FIRST, IWARN, LBETA, LEMAX, LEMIN, LEPS, LRMAX,
     $                   LRMIN, LT
*     ..
*     .. Data statements ..
      DATA               FIRST / .TRUE. / , IWARN / .FALSE. /
*     ..
*     .. Executable Statements ..
*
      IF( FIRST ) THEN
         FIRST = .FALSE.
         ZERO = 0
         ONE = 1
         TWO = 2
*
*        LBETA, LT, LRND, LEPS, LEMIN and LRMIN  are the local values of
*        BETA, T, RND, EPS, EMIN and RMIN.
*
*        Throughout this routine  we use the function  SLAMC3  to ensure
*        that relevant values are stored  and not held in registers,  or
*        are not affected by optimizers.
*
*        SLAMC1 returns the parameters  LBETA, LT, LRND and LIEEE1.
*
         CALL SLAMC1( LBETA, LT, LRND, LIEEE1 )
*
*        Start to find EPS.
*
         B = LBETA
         A = B**( -LT )
         LEPS = A
*
*        Try some tricks to see whether or not this is the correct  EPS.
*
         B = TWO / 3
         HALF = ONE / 2
c@       SIXTH = SLAMC3( B, -HALF )
         CALL SLAMC3a( SIXTH, B, -HALF )
c@       THIRD = SLAMC3( SIXTH, SIXTH )
         CALL SLAMC3a( THIRD, SIXTH, SIXTH )
c@       B = SLAMC3( THIRD, -HALF )
         CALL SLAMC3a( B, THIRD, -HALF )
c@       B = SLAMC3( B, SIXTH )
         CALL SLAMC3a( B, B, SIXTH )
         B = ABS( B )
         IF( B.LT.LEPS )
     $      B = LEPS
*
         LEPS = 1
*
*+       WHILE( ( LEPS.GT.B ).AND.( B.GT.ZERO ) )LOOP
   10    CONTINUE
         IF( ( LEPS.GT.B ) .AND. ( B.GT.ZERO ) ) THEN
            LEPS = B
c@          C = SLAMC3( HALF*LEPS, ( TWO**5 )*( LEPS**2 ) )
            CALL SLAMC3a( C, HALF*LEPS, ( TWO**5 )*( LEPS**2 ) )
c@          C = SLAMC3( HALF, -C )
            CALL SLAMC3a( C, HALF, -C )
c@          B = SLAMC3( HALF, C )
            CALL SLAMC3a( B, HALF, C )
c@          C = SLAMC3( HALF, -B )
            CALL SLAMC3a( C, HALF, -B )
c@          B = SLAMC3( HALF, C )
            CALL SLAMC3a( B, HALF, C )
            GO TO 10
         END IF
*+       END WHILE
*
         IF( A.LT.LEPS )
     $      LEPS = A
*
*        Computation of EPS complete.
*
*        Now find  EMIN.  Let A = + or - 1, and + or - (1 + BASE**(-3)).
*        Keep dividing  A by BETA until (gradual) underflow occurs. This
*        is detected when we cannot recover the previous A.
*
         RBASE = ONE / LBETA
         SMALL = ONE
         DO 20 I = 1, 3
c@          SMALL = SLAMC3( SMALL*RBASE, ZERO )
            CALL SLAMC3a( SMALL, SMALL*RBASE, ZERO )
   20    CONTINUE
c@       A = SLAMC3( ONE, SMALL )
         CALL SLAMC3a( A, ONE, SMALL )
         CALL SLAMC4( NGPMIN, ONE, LBETA )
         CALL SLAMC4( NGNMIN, -ONE, LBETA )
         CALL SLAMC4( GPMIN, A, LBETA )
         CALL SLAMC4( GNMIN, -A, LBETA )
         IEEE = .FALSE.
*
         IF( ( NGPMIN.EQ.NGNMIN ) .AND. ( GPMIN.EQ.GNMIN ) ) THEN
            IF( NGPMIN.EQ.GPMIN ) THEN
               LEMIN = NGPMIN
*            ( Non twos-complement machines, no gradual underflow;
*              e.g.,  VAX )
            ELSE IF( ( GPMIN-NGPMIN ).EQ.3 ) THEN
               LEMIN = NGPMIN - 1 + LT
               IEEE = .TRUE.
*            ( Non twos-complement machines, with gradual underflow;
*              e.g., IEEE standard followers )
            ELSE
               LEMIN = MIN( NGPMIN, GPMIN )
*            ( A guess; no known machine )
               IWARN = .TRUE.
            END IF
*
         ELSE IF( ( NGPMIN.EQ.GPMIN ) .AND. ( NGNMIN.EQ.GNMIN ) ) THEN
            IF( ABS( NGPMIN-NGNMIN ).EQ.1 ) THEN
               LEMIN = MAX( NGPMIN, NGNMIN )
*            ( Twos-complement machines, no gradual underflow;
*              e.g., CYBER 205 )
            ELSE
               LEMIN = MIN( NGPMIN, NGNMIN )
*            ( A guess; no known machine )
               IWARN = .TRUE.
            END IF
*
         ELSE IF( ( ABS( NGPMIN-NGNMIN ).EQ.1 ) .AND.
     $            ( GPMIN.EQ.GNMIN ) ) THEN
            IF( ( GPMIN-MIN( NGPMIN, NGNMIN ) ).EQ.3 ) THEN
               LEMIN = MAX( NGPMIN, NGNMIN ) - 1 + LT
*            ( Twos-complement machines with gradual underflow;
*              no known machine )
            ELSE
               LEMIN = MIN( NGPMIN, NGNMIN )
*            ( A guess; no known machine )
               IWARN = .TRUE.
            END IF
*
         ELSE
            LEMIN = MIN( NGPMIN, NGNMIN, GPMIN, GNMIN )
*         ( A guess; no known machine )
            IWARN = .TRUE.
         END IF
***
* Comment out this if block if EMIN is ok
         IF( IWARN ) THEN
            FIRST = .TRUE.
            WRITE( 6, FMT = 9999 )LEMIN
         END IF
***
*
*        Assume IEEE arithmetic if we found denormalised  numbers above,
*        or if arithmetic seems to round in the  IEEE style,  determined
*        in routine SLAMC1. A true IEEE machine should have both  things
*        true; however, faulty machines may have one or the other.
*
         IEEE = IEEE .OR. LIEEE1
*
*        Compute  RMIN by successive division by  BETA. We could compute
*        RMIN as BASE**( EMIN - 1 ),  but some machines underflow during
*        this computation.
*
         LRMIN = 1
         DO 30 I = 1, 1 - LEMIN
c@          LRMIN = SLAMC3( LRMIN*RBASE, ZERO )
            CALL SLAMC3a( LRMIN, LRMIN*RBASE, ZERO )
   30    CONTINUE
*
*        Finally, call SLAMC5 to compute EMAX and RMAX.
*
         CALL SLAMC5( LBETA, LT, LEMIN, IEEE, LEMAX, LRMAX )
      END IF
*
      BETA = LBETA
      T = LT
      RND = LRND
      EPS = LEPS
      EMIN = LEMIN
      RMIN = LRMIN
      EMAX = LEMAX
      RMAX = LRMAX
*
      RETURN
*
 9999 FORMAT( / / ' WARNING. The value EMIN may be incorrect:-',
     $      '  EMIN = ', I8, /
     $      ' If, after inspection, the value EMIN looks',
     $      ' acceptable please comment out ',
     $      / ' the IF block as marked within the code of routine',
     $      ' SLAMC2,', / ' otherwise supply EMIN explicitly.', / )
*
*     End of SLAMC2
*
      END
*
************************************************************************
      SUBROUTINE SLAMC3a( C, A, B )
      IMPLICIT   NONE
      REAL       A, B, C
      C = A + B
      RETURN
      END
************************************************************************
*
      REAL             FUNCTION SLAMC3( A, B )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      REAL               A, B
*     ..
*
*  Purpose
*  =======
*
*  SLAMC3  is intended to force  A  and  B  to be stored prior to doing
*  the addition of  A  and  B ,  for use in situations where optimizers
*  might hold one of these in a register.
*
*  Arguments
*  =========
*
*  A, B    (input) REAL
*          The values A and B.
*
* =====================================================================
*
*     .. Executable Statements ..
*
      SLAMC3 = A + B
*
      RETURN
*
*     End of SLAMC3
*
      END
*
************************************************************************
*
      SUBROUTINE SLAMC4( EMIN, START, BASE )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      INTEGER            BASE, EMIN
      REAL               START
*     ..
*
*  Purpose
*  =======
*
*  SLAMC4 is a service routine for SLAMC2.
*
*  Arguments
*  =========
*
*  EMIN    (output) EMIN
*          The minimum exponent before (gradual) underflow, computed by
*          setting A = START and dividing by BASE until the previous A
*          can not be recovered.
*
*  START   (input) REAL
*          The starting point for determining EMIN.
*
*  BASE    (input) INTEGER
*          The base of the machine.
*
* =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I
      REAL               A, B1, B2, C1, C2, D1, D2, ONE, RBASE, ZERO
*     ..
*     .. External Functions ..
      REAL               SLAMC3
      EXTERNAL           SLAMC3
*     ..
*     .. Executable Statements ..
*
      A = START
      ONE = 1
      RBASE = ONE / BASE
      ZERO = 0
      EMIN = 1
c@    B1 = SLAMC3( A*RBASE, ZERO )
      CALL SLAMC3a( B1, A*RBASE, ZERO )
      C1 = A
      C2 = A
      D1 = A
      D2 = A
*+    WHILE( ( C1.EQ.A ).AND.( C2.EQ.A ).AND.
*    $       ( D1.EQ.A ).AND.( D2.EQ.A )      )LOOP
   10 CONTINUE
      IF( ( C1.EQ.A ) .AND. ( C2.EQ.A ) .AND. ( D1.EQ.A ) .AND.
     $    ( D2.EQ.A ) ) THEN
         EMIN = EMIN - 1
         A = B1
c@       B1 = SLAMC3( A / BASE, ZERO )
         CALL SLAMC3a( B1, A / BASE, ZERO )
c@       C1 = SLAMC3( B1*BASE, ZERO )
         CALL SLAMC3a( C1, B1*BASE, ZERO )
         D1 = ZERO
         DO 20 I = 1, BASE
            D1 = D1 + B1
   20    CONTINUE
c@       B2 = SLAMC3( A*RBASE, ZERO )
         CALL SLAMC3a( B2, A*RBASE, ZERO )
c@       C2 = SLAMC3( B2 / RBASE, ZERO )
         CALL SLAMC3a( C2, B2 / RBASE, ZERO )
         D2 = ZERO
         DO 30 I = 1, BASE
            D2 = D2 + B2
   30    CONTINUE
         GO TO 10
      END IF
*+    END WHILE
*
      RETURN
*
*     End of SLAMC4
*
      END
*
************************************************************************
*
      SUBROUTINE SLAMC5( BETA, P, EMIN, IEEE, EMAX, RMAX )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*
*     .. Scalar Arguments ..
      LOGICAL            IEEE
      INTEGER            BETA, EMAX, EMIN, P
      REAL               RMAX
*     ..
*
*  Purpose
*  =======
*
*  SLAMC5 attempts to compute RMAX, the largest machine floating-point
*  number, without overflow.  It assumes that EMAX + abs(EMIN) sum
*  approximately to a power of 2.  It will fail on machines where this
*  assumption does not hold, for example, the Cyber 205 (EMIN = -28625,
*  EMAX = 28718).  It will also fail if the value supplied for EMIN is
*  too large (i.e. too close to zero), probably with overflow.
*
*  Arguments
*  =========
*
*  BETA    (input) INTEGER
*          The base of floating-point arithmetic.
*
*  P       (input) INTEGER
*          The number of base BETA digits in the mantissa of a
*          floating-point value.
*
*  EMIN    (input) INTEGER
*          The minimum exponent before (gradual) underflow.
*
*  IEEE    (input) LOGICAL
*          A logical flag specifying whether or not the arithmetic
*          system is thought to comply with the IEEE standard.
*
*  EMAX    (output) INTEGER
*          The largest exponent before overflow
*
*  RMAX    (output) REAL
*          The largest machine floating-point number.
*
* =====================================================================
*
*     .. Parameters ..
      REAL               ZERO, ONE
      PARAMETER          ( ZERO = 0.0E0, ONE = 1.0E0 )
*     ..
*     .. Local Scalars ..
      INTEGER            EXBITS, EXPSUM, I, LEXP, NBITS, TRY, UEXP
      REAL               OLDY, RECBAS, Y, Z
*     ..
*     .. External Functions ..
      REAL               SLAMC3
      EXTERNAL           SLAMC3
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
*     First compute LEXP and UEXP, two powers of 2 that bound
*     abs(EMIN). We then assume that EMAX + abs(EMIN) will sum
*     approximately to the bound that is closest to abs(EMIN).
*     (EMAX is the exponent of the required number RMAX).
*
      LEXP = 1
      EXBITS = 1
   10 CONTINUE
      TRY = LEXP*2
      IF( TRY.LE.( -EMIN ) ) THEN
         LEXP = TRY
         EXBITS = EXBITS + 1
         GO TO 10
      END IF
      IF( LEXP.EQ.-EMIN ) THEN
         UEXP = LEXP
      ELSE
         UEXP = TRY
         EXBITS = EXBITS + 1
      END IF
*
*     Now -LEXP is less than or equal to EMIN, and -UEXP is greater
*     than or equal to EMIN. EXBITS is the number of bits needed to
*     store the exponent.
*
      IF( ( UEXP+EMIN ).GT.( -LEXP-EMIN ) ) THEN
         EXPSUM = 2*LEXP
      ELSE
         EXPSUM = 2*UEXP
      END IF
*
*     EXPSUM is the exponent range, approximately equal to
*     EMAX - EMIN + 1 .
*
      EMAX = EXPSUM + EMIN - 1
      NBITS = 1 + EXBITS + P
*
*     NBITS is the total number of bits needed to store a
*     floating-point number.
*
      IF( ( MOD( NBITS, 2 ).EQ.1 ) .AND. ( BETA.EQ.2 ) ) THEN
*
*        Either there are an odd number of bits used to store a
*        floating-point number, which is unlikely, or some bits are
*        not used in the representation of numbers, which is possible,
*        (e.g. Cray machines) or the mantissa has an implicit bit,
*        (e.g. IEEE machines, Dec Vax machines), which is perhaps the
*        most likely. We have to assume the last alternative.
*        If this is true, then we need to reduce EMAX by one because
*        there must be some way of representing zero in an implicit-bit
*        system. On machines like Cray, we are reducing EMAX by one
*        unnecessarily.
*
         EMAX = EMAX - 1
      END IF
*
      IF( IEEE ) THEN
*
*        Assume we are on an IEEE machine which reserves one exponent
*        for infinity and NaN.
*
         EMAX = EMAX - 1
      END IF
*
*     Now create RMAX, the largest machine number, which should
*     be equal to (1.0 - BETA**(-P)) * BETA**EMAX .
*
*     First compute 1.0 - BETA**(-P), being careful that the
*     result is less than 1.0 .
*
      RECBAS = ONE / BETA
      Z = BETA - ONE
      Y = ZERO
      DO 20 I = 1, P
         Z = Z*RECBAS
         IF( Y.LT.ONE )
     $      OLDY = Y
c@       Y = SLAMC3( Y, Z )
         CALL SLAMC3a( Y, Y, Z )
   20 CONTINUE
      IF( Y.GE.ONE )
     $   Y = OLDY
*
*     Now multiply by BETA**EMAX to get RMAX.
*
      DO 30 I = 1, EMAX
c@       Y = SLAMC3( Y*BETA, ZERO )
         CALL SLAMC3a( Y, Y*BETA, ZERO )
   30 CONTINUE
*
      RMAX = Y
      RETURN
*
*     End of SLAMC5
*
      END
      LOGICAL          FUNCTION LSAME( CA, CB )
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*
*     .. Scalar Arguments ..
      CHARACTER          CA, CB
*     ..
*
*  Purpose
*  =======
*
*  LSAME returns .TRUE. if CA is the same letter as CB regardless of
*  case.
*
*  Arguments
*  =========
*
*  CA      (input) CHARACTER*1
*  CB      (input) CHARACTER*1
*          CA and CB specify the single characters to be compared.
*
* =====================================================================
*
*     .. Intrinsic Functions ..
      INTRINSIC          ICHAR
*     ..
*     .. Local Scalars ..
      INTEGER            INTA, INTB, ZCODE
*     ..
*     .. Executable Statements ..
*
*     Test if the characters are equal
*
      LSAME = CA.EQ.CB
      IF( LSAME )
     $   RETURN
*
*     Now test for equivalence if both characters are alphabetic.
*
      ZCODE = ICHAR( 'Z' )
*
*     Use 'Z' rather than 'A' so that ASCII can be detected on Prime
*     machines, on which ICHAR returns a value with bit 8 set.
*     ICHAR('A') on Prime machines returns 193 which is the same as
*     ICHAR('A') on an EBCDIC machine.
*
      INTA = ICHAR( CA )
      INTB = ICHAR( CB )
*
      IF( ZCODE.EQ.90 .OR. ZCODE.EQ.122 ) THEN
*
*        ASCII is assumed - ZCODE is the ASCII code of either lower or
*        upper case 'Z'.
*
         IF( INTA.GE.97 .AND. INTA.LE.122 ) INTA = INTA - 32
         IF( INTB.GE.97 .AND. INTB.LE.122 ) INTB = INTB - 32
*
      ELSE IF( ZCODE.EQ.233 .OR. ZCODE.EQ.169 ) THEN
*
*        EBCDIC is assumed - ZCODE is the EBCDIC code of either lower or
*        upper case 'Z'.
*
         IF( INTA.GE.129 .AND. INTA.LE.137 .OR.
     $       INTA.GE.145 .AND. INTA.LE.153 .OR.
     $       INTA.GE.162 .AND. INTA.LE.169 ) INTA = INTA + 64
         IF( INTB.GE.129 .AND. INTB.LE.137 .OR.
     $       INTB.GE.145 .AND. INTB.LE.153 .OR.
     $       INTB.GE.162 .AND. INTB.LE.169 ) INTB = INTB + 64
*
      ELSE IF( ZCODE.EQ.218 .OR. ZCODE.EQ.250 ) THEN
*
*        ASCII is assumed, on Prime machines - ZCODE is the ASCII code
*        plus 128 of either lower or upper case 'Z'.
*
         IF( INTA.GE.225 .AND. INTA.LE.250 ) INTA = INTA - 32
         IF( INTB.GE.225 .AND. INTB.LE.250 ) INTB = INTB - 32
      END IF
      LSAME = INTA.EQ.INTB
*
*     RETURN
*
*     End of LSAME
*
      END
