c
      SUBROUTINE find_all_contacts(dlim,
     &     maxatom,n_atom,xyz_crd,occup,maxsym,nsym,rot,tr,cell,
     &     vdw_file_o,ierr)

      IMPLICIT NONE
C
C----This routine finds contact list using bricking technique which is similar
C----to hash table technique. First atoms extended so that to cover extended
C----asymmetric unit. Extension of asymmeric unit is equal to brick size.
C----After that list of atoms and pointers to atoms for each brick is assigned
C----Having this for each atom which is unique (in a sence that it is first
C----symmetry related atom which is entirely in asymmeteric unit) 27 neibouring
C----bricks are searched for possible contacts. Having find contact symmetries
C----are assigned symply by look up to the tabel R1^-1 * R2 (beacues symmetry
C----is group result of this operation should be member of the group). 
c----The results are written to vdw_file_o
C
C---- Inputs and outputs
      real dlim
      integer maxatom,n_atom
      real xyz_crd(3,maxatom),occup(maxatom)
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      character vdw_file_o*(*)
      integer ierr
c
c---  locals
      integer, allocatable :: n_sym_atoms(:)
      integer, allocatable :: first_atom(:)
      real,    allocatable :: xyzs(:,:)
      integer, allocatable :: symm_refer(:,:)
      integer, allocatable :: refer_to_atom(:)
      integer, allocatable :: atoms_in_this_brick(:,:,:) 
      integer, allocatable :: atoms_in_brick(:,:,:,:)
      integer, allocatable :: nvdw_pairs(:,:)
      integer, allocatable :: nvdw_symm(:,:)
      integer, allocatable :: index_v(:)

      integer i,ia_refer,ia_box,ll,iscrv,ifail,it,isym1,isym2,isym3
      integer first,imodx,imody,imodz,isym_cur,itx_cur(3)
      real d,dx,d1_cut2,dxy,dsq,xyzs_transx,xyzs_transy,xyzs_transz,t
      integer ia,nmax_in_brick,nxyzs
      integer ix,iy,iz,ix_this,iy_this,iz_this,is,i_add
      integer ixmin,ixmax,iymin,iymax,izmin,izmax
      integer maxvdw,nvdw,xyz_size
      integer nvdw_t,nvdw_o,nvdw_s(4)
      integer n_first_atom
      integer iiden0
      integer nbricks(3),itx1(3),symm_loc(4)
      integer nmfour,ipxyz(3)
      real cell_asym(3),cell_asym_min(3),cell_asym_max(3)
      real cell_asym_min_frac(3),cell_asym_max_frac(3)
      real frac_xyz(3),dvdw2_frac(3)
      real d_bricks(3),d_bricks_frac(3),d_bricks_out(3)
      real ext_asym_min(3),ext_asym_max(3),ext_mn(3),ext_mx(3)
      real xyz_frac(3),xyz_frac1(3),xyz_frac2(3),xyzs_cell(3)
      real d_vdw2_frac(3)
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      integer icount
      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL ERROR
      REAL SMALL_EPS,ONE
      DATA ONE/1.0/,SMALL_EPS/1.0E-6/
C
c---  body
      ierr = 0
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     & cs_frac_to_ort,cs_ort_to_frac,ierr)
C
c---Find sizes
      call find_vdw_sizes(dlim,maxatom,n_atom,xyz_crd,occup,
     &     maxsym,nsym,rot,tr,cell,xyz_size,nmax_in_brick,ierr)
      if(ierr.gt.0) then
         call errwrt(-1,'Error in find_all_contacts')
         return
      endif
c
c---find nbricks et al
      d_bricks(1:3) = dlim
      CALL ASYLIM_r(maxsym,nsym,rot,tr,IPXYZ(1),IPXYZ(2),IPXYZ(3),
     &     NMFOUR)
      call brick_limits(d_bricks,cell,d_bricks_out)

      cell_asym(1:3) = cell(1:3)/ipxyz(1:3)
      nbricks(1:3) = int(cell_asym(1:3)/d_bricks_out(1:3))+5
c
      allocate(first_atom(n_atom))
      allocate(n_sym_atoms(n_atom))
      allocate(xyzs(3,xyz_size))
      allocate(symm_refer(4,xyz_size))
      allocate(refer_to_atom(xyz_size))
c
      NXYZS = 0
      CELL_ASYM_MIN(1:3) = 0.0
      CELL_ASYM_MAX(1:3) = CELL(1:3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1:3))
      CELL_ASYM_MIN_FRAC(1:3) = CELL_ASYM_MIN(1:3)/CELL(1:3)
      CELL_ASYM_MAX_FRAC(1:3) = CELL_ASYM_MAX(1:3)/CELL(1:3)
c
      CALL GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      D_VDW2_FRAC(1:3)  = dlim*FRAC_XYZ(1:3)/CELL(1:3)
      EXT_ASYM_MAX(1:3) = CELL_ASYM_MAX_FRAC(1:3) + D_VDW2_FRAC(1:3)
      EXT_ASYM_MIN(1:3) = CELL_ASYM_MIN_FRAC(1:3) - D_VDW2_FRAC(1:3)
      ext_mn(1:3) = 1.0/float(ipxyz(1:3)) - d_vdw2_frac(1:3)
      ext_mx(1:3) = 1.0/float(ipxyz(1:3)) + d_vdw2_frac(1:3)
      ext_mn(1:3) = ext_asym_min(1:3)
      ext_mx(1:3) = ext_asym_max(1:3)

      DO    IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
         N_SYM_ATOMS(IA) = 0
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C
C---  Now find all symmetry related atoms which are inside the extended 
c---  asymmetric unit
         DO    IS=1,nsym
            call mat2vec(3,3,rot(1:3,1:3,is),xyz_frac1,xyz_frac2,error)
            xyz_frac(1:3) = xyz_frac2(1:3) + tr(1:3,is)
C
C---Find translation by which this atom comes to asymmetic unit          
            CALL AMOD_R(XYZ_FRAC(1),ONE,IMODX,XYZS_CELL(1))
            CALL AMOD_R(XYZ_FRAC(2),ONE,IMODY,XYZS_CELL(2))
            CALL AMOD_R(XYZ_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
            DO    IZ = -1,1
               XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
               IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +              XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
                  DO   IY = -1,1
                     XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                     IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +                    XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                        DO    IX=-1,1
                           XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                           IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                          XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN
C
C----Add this position to list of atoms in asymmetric unit. Make sure to 
C----remember reference to symmetry. Increase number of symmetry related atomns
C----for this particular atom.
                              N_SYM_ATOMS(IA) = N_SYM_ATOMS(IA) + 1
                              NXYZS           = NXYZS + 1
                              XYZS(1,NXYZS)   = XYZS_TRANSX
                              XYZS(2,NXYZS)   = XYZS_TRANSY
                              XYZS(3,NXYZS)   = XYZS_TRANSZ
                              SYMM_REFER(1,NXYZS)  = IS
                              SYMM_REFER(2,NXYZS)  = -IMODX + IX
                              SYMM_REFER(3,NXYZS)  = -IMODY + IY
                              SYMM_REFER(4,NXYZS)  = -IMODZ + IZ
                              REFER_TO_ATOM(NXYZS) = IA
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
         ENDDO
c
c---Find first atom inside entirely in asymmetric unit and remember its address
         FIRST_ATOM(IA) = 0
         DO    IS = 1,N_SYM_ATOMS(IA)
            I_ADD = NXYZS - IS + 1   
            IF(XYZS(1,I_ADD).LE.CELL_ASYM_MAX_FRAC(1).AND.
     &           XYZS(1,I_ADD).GE.CELL_ASYM_MIN_FRAC(1).AND.
     &           XYZS(2,I_ADD).LE.CELL_ASYM_MAX_FRAC(2).AND.
     &           XYZS(2,I_ADD).GE.CELL_ASYM_MIN_FRAC(2).AND.
     &           XYZS(3,I_ADD).LE.CELL_ASYM_MAX_FRAC(3).AND.
     &           XYZS(3,I_ADD).GE.CELL_ASYM_MIN_FRAC(3)) THEN
C
c---This atom is entirely in "asymmetric unit"
C---Promote this atom to the first in the list of symmetry related atoms for this 
C---particular atom
               N_FIRST_ATOM = NXYZS - N_SYM_ATOMS(IA) + 1
               DO   I=1,3
                  T                          = XYZS(I,I_ADD)
                  XYZS(I,I_ADD)              = XYZS(I,N_FIRST_ATOM)  
                  XYZS(I,N_FIRST_ATOM)       = T
                  IT                         = SYMM_REFER(I,I_ADD)
                  SYMM_REFER(I,I_ADD)      = SYMM_REFER(I,N_FIRST_ATOM)
                  SYMM_REFER(I,N_FIRST_ATOM) = IT
               ENDDO
               IT                         = SYMM_REFER(4,I_ADD)
               SYMM_REFER(4,I_ADD)    = SYMM_REFER(4,N_FIRST_ATOM)
               SYMM_REFER(4,N_FIRST_ATOM) = IT
               FIRST_ATOM(IA)             = N_FIRST_ATOM
               GOTO 100
            ENDIF
         ENDDO
 100     CONTINUE
         endif
      ENDDO
C     
C---  Now we have list of symmetry related atoms and references to first atoms
C---  in "asymmetric unit". Create net. I.e. For each box find references to the
C---  atoms in asymmetric unit
      d_bricks_frac(1:3) = d_bricks_out(1:3)/cell(1:3)
c
c---
      allocate(atoms_in_this_brick(nbricks(1),nbricks(2),nbricks(3)))
      allocate(atoms_in_brick(nmax_in_brick,
     &     nbricks(1),nbricks(2),nbricks(3)))
      CALL CREATE_NET(NXYZS,XYZS,NBRICKs(1),NBRICKs(2),
     +     NBRICKs(3),NMAX_in_BRICK,ATOMS_IN_THIS_BRICK,
     +     ATOMS_IN_BRICK,ext_mn,D_BRICKS_FRAC)
C
C---  Convert all atoms to orthogonal coordinates
      DO   IA=1,NXYZS
         CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZS(1:3,IA),xyz_frac,ERROR)
         xyzs(1:3,ia) = xyz_frac(1:3)
      ENDDO
c
c---   Open the output file
      call open_unform_file(iscrv,vdw_file_o,ifail)
C     
C---  Loop over first atoms in the asymmetric unit
      D1_CUT2 = dlim**2
      first = 0
      nvdw = 0
      icount = 0
      DO   IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
            N_FIRST_ATOM = FIRST_ATOM(IA)
            IF(N_FIRST_ATOM.LE.0) THEN
               write(*,*)IA,XYZ_CRD(1,IA),XYZ_CRD(2,IA),XYZ_CRD(3,IA)
               write(*,*)'Disaster with machine precision.'
               CALL ERRWRT(1,'Disaster, Disaster!!!!!')
            endif
            CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZS(1,N_FIRST_ATOM),
     +           XYZ_FRAC,ERROR)
C     
C---  Find  brick where this atom belongs
            IX_THIS = 
     +           INT((XYZ_FRAC(1)-ext_mn(1))/D_BRICKS_FRAC(1))+1
            IY_THIS = 
     +           INT((XYZ_FRAC(2)-ext_mn(2))/D_BRICKS_FRAC(2))+1
            IZ_THIS = 
     +           INT((XYZ_FRAC(3)-ext_mn(3))/D_BRICKS_FRAC(3))+1
C     
C---  loop over 27 bricks
            ixmin = max(2,ix_this)
            ixmax = min(nbricks(1)-1,ix_this)
            iymin = max(2,iy_this)
            iymax = min(nbricks(2)-1,iy_this)
            izmin = max(2,iz_this)
            izmax = min(nbricks(3)-1,iz_this)
            DO   IX=ixmin-1,ixmax+1
               DO   IY=iymin-1,iymax+1
                  DO   IZ=izmin-1,izmax+1
C
C---  loop over atoms in this box
                     DO    IA_BOX=1,ATOMS_IN_THIS_BRICK(IX,IY,IZ)
C     
c---  Take address of atom in the brick
                        I_ADD = ATOMS_IN_BRICK(IA_BOX,IX,IY,IZ)
                        IA_REFER = REFER_TO_ATOM(I_ADD)
                        IF(IA_REFER.GE.IA.AND.
     +                       I_ADD.NE.N_FIRST_ATOM) THEN
C     
C---  Check this atom
                           DX = (XYZS(1,I_ADD)-XYZS(1,N_FIRST_ATOM))**2
                           IF(DX.LE.D1_CUT2) THEN
                              d = xyzs(2,i_add)-xyzs(2,n_first_atom)
                              DXY = DX + d**2
                              IF(DXY.LE.D1_CUT2) THEN
                                 d = xyzs(3,i_add)-xyzs(3,n_first_atom)
                                 DSQ = DXY + d**2
                                 icount = icount + 1
                                 IF(DSQ.LE.D1_CUT2) THEN         
                                    NVDW = NVDW + 1
                                    NVDW_T = IA
                                    NVDW_O = REFER_TO_ATOM(I_ADD)
                                    ISYM1 = SYMM_REFER(1,N_FIRST_ATOM)
                                    ISYM2 = SYMM_REFER(1,I_ADD)
                                    DO    IS=1,3
                                      ITX1(IS) = SYMM_REFER(IS+1,I_ADD)-
     +                                     SYMM_REFER(IS+1,N_FIRST_ATOM)
                                    ENDDO
                                    CALL SYM_FIND_r(MAXSYM,nsym,
     +                                   rot,tr,ISYM1,ISYM2,ITX1,
     +                                   ISYM_CUR,ITX_CUR,FIRST)
                                    NVDW_S(1) = ISYM_CUR
                                    NVDW_S(2:4) = ITX_CUR(1:3)
                                    write(iscrv)
     &                                   nvdw_t,nvdw_o,nvdw_s(1:4)
                                 ENDIF
                              ENDIF
                           ENDIF
                        ENDIF
                     ENDDO
                  ENDDO
               ENDDO
            ENDDO
         endif
      ENDDO
c
c---  deallocate
      deallocate(n_sym_atoms)
      deallocate(first_atom)
      deallocate(xyzs)
      deallocate(symm_refer)
      deallocate(refer_to_atom)
      deallocate(atoms_in_this_brick)
      deallocate(atoms_in_brick)
c
c---  write the results to the output file: vdw_file_o.
      allocate(nvdw_pairs(2,nvdw))
      allocate(nvdw_symm(4,nvdw))
      rewind(iscrv)
      iiden0 = 1
      do i=1,nvdw
         read(iscrv)nvdw_pairs(1:2,i),nvdw_symm(1:4,i)
         if(nvdw_pairs(1,i).gt.nvdw_pairs(2,i)) then
            it = nvdw_pairs(1,i)
            nvdw_pairs(1,i) = nvdw_pairs(2,i)
            nvdw_pairs(2,i) = it
            itx1 = nvdw_symm(2:4,i)
            call symm_inv_r(maxsym,nsym,
     &           rot,tr,nvdw_symm(1:4,i),symm_loc(1:4),first,ierr)
            nvdw_symm(1:4,i) = symm_loc(1:4)
         endif
      enddo
      allocate(index_v(nvdw))
      do  i=1,nvdw
         index_v(i) = i
      enddo
      call iheap_sort_r(nvdw,2,nvdw_pairs,index_v)
      rewind(iscrv)
      write(iscrv)nvdw
      do i=1,nvdw
         write(iscrv)nvdw_pairs(1:2,i),nvdw_symm(1:4,index_v(i))
      enddo
      close(iscrv)
      deallocate(index_v)
      deallocate(nvdw_pairs)
      deallocate(nvdw_symm)
c
      RETURN
      END
C
      SUBROUTINE CREATE_NET(NXYZS,XYZS,NX,NY,NZ,
     +                     N_MAX_IN_BRICK,ATOMS_IN_THIS,ATOMS_IN_BRICKS,
     +                     BOX_MIN,D_BRICKS)
      IMPLICIT NONE
C
c---This routine creates net. I.e. for each brick list of atoms belonging
C---to this brick is stored. Make sure that large box contains all atoms.
C---
      INTEGER NXYZS,NX,NY,NZ,N_MAX_IN_BRICK
      integer ATOMS_IN_THIS(NX,NY,NZ)
      integer ATOMS_IN_BRICKS(N_MAX_IN_BRICK,NX,NY,NZ)
      REAL    XYZS(3,nxyzs),BOX_MIN(3),D_BRICKS(3)
C
C---  Local variables
      INTEGER IX,IY,IZ,IA
C
c---  body
      atoms_in_this(1:nx,1:ny,1:nz) = 0
      atoms_in_bricks(1:n_max_in_brick,1:nx,1:ny,1:nz)=0
      DO   IA=1,NXYZS
        IX = INT((XYZS(1,IA)-BOX_MIN(1))/D_BRICKS(1)) + 1
        IY = INT((XYZS(2,IA)-BOX_MIN(2))/D_BRICKS(2)) + 1
        IZ = INT((XYZS(3,IA)-BOX_MIN(3))/D_BRICKS(3)) + 1
        ix = max(1,min(nx,ix))
        iy = max(1,min(ny,iy))
        iz = max(1,min(nz,iz))
        ATOMS_IN_THIS(IX,IY,IZ) = ATOMS_IN_THIS(IX,IY,IZ) + 1
        ATOMS_IN_BRICKS(ATOMS_IN_THIS(IX,IY,IZ),IX,IY,IZ) = IA
      ENDDO
      RETURN
      END
c
      SUBROUTINE find_vdw_sizes(dlim,
     &     maxatom,n_atom,xyz_crd,occup,maxsym,nsym,rot,tr,cell,
     &     xyz_size,nmax_in_brick,ierr)

      IMPLICIT NONE
C
C----This routine finds contact list using bricking technique which is similar
C----to hash table technique. First atoms extended so that to cover extended
C----asymmetric unit. Extension of asymmeric unit is equal to brick size.
C----After that list of atoms and pointers to atoms for each brick is assigned
C----Having this for each atom which is unique (in a sence that it is first
C----symmetry related atom which is entirely in asymmeteric unit) 27 neibouring
C----bricks are searched for possible contacts. Having find contact symmetries
C----are assigned symply by look up to the tabel R1^-1 * R2 (beacues symmetry
C----is group result of this operation should be member of the group). 
c----The results are written to vdw_file_o
C
C---- Inputs and outputs
      real dlim
      integer maxatom,n_atom
      real xyz_crd(3,maxatom),occup(maxatom)
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      integer xyz_size,nmax_in_brick
      integer ierr
c
c---  locals
      integer, allocatable :: n_sym_atoms(:)
      integer, allocatable :: first_atom(:)
      real   , allocatable :: xyzs(:,:)
      integer, allocatable :: symm_refer(:,:)
      integer, allocatable :: refer_to_atom(:)
      integer, allocatable :: atoms_in_this_brick(:,:,:) 
      integer, allocatable :: atoms_in_brick(:,:,:,:)
      integer, allocatable :: nvdw_target(:)
      integer, allocatable :: nvdw_object(:)
      integer, allocatable :: nvdw_symm(:,:)

      integer i,ia_refer,ia_box,ll,iscrv,ifail,it,isym1,isym2,isym3
      integer first,imodx,imody,imodz,isym_cur,itx_cur(3)
      real d,dx,d1_cut2,dxy,dsq,xyzs_transx,xyzs_transy,xyzs_transz,t
      integer ia,nxyzs
      integer ix,iy,iz,ix_this,iy_this,iz_this,is,i_add
      integer maxvdw,nvdw
      integer nvdw_t,nvdw_o,nvdw_s(4)
      integer n_first_atom
      integer nbricks(3),itx1(3)
      integer nmfour,ipxyz(3)
      real cell_asym(3),cell_asym_min(3),cell_asym_max(3)
      real cell_asym_min_frac(3),cell_asym_max_frac(3)
      real frac_xyz(3),dvdw2_frac(3)
      real d_bricks(3),d_bricks_frac(3),d_bricks_out(3)
      real ext_asym_min(3),ext_asym_max(3)
      real xyz_frac(3),xyz_frac1(3),xyz_frac2(3),xyzs_cell(3)
      real d_vdw2_frac(3)
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL ERROR
      REAL SMALL_EPS,ONE
      DATA ONE/1.0/,SMALL_EPS/1.0E-6/
C
c---  body
      ierr = 0
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     & cs_frac_to_ort,cs_ort_to_frac,ierr)
C
c---Find sizes
      if(ierr.gt.0) then
         call errwrt(-1,'Error in find_all_contacts')
         return
      endif
c
c---find nbricks et al
      d_bricks(1:3) = dlim
      CALL ASYLIM_r(maxsym,nsym,rot,tr,IPXYZ(1),IPXYZ(2),IPXYZ(3),
     &     NMFOUR)
      call brick_limits(d_bricks,cell,d_bricks_out)
      cell_asym(1:3) = cell(1:3)/ipxyz(1:3)
      nbricks(1:3) = int(cell_asym(1:3)/d_bricks_out(1:3))+5
c
      call GET_XYZS_NUMBER(dlim,maxatom,n_atom,xyz_crd,occup,
     &     maxsym,nsym,rot,tr,cell,XYZ_SIZE)
      allocate(xyzs(3,xyz_size))
c
      NXYZS = 0
      CELL_ASYM_MIN(1:3) = 0.0
      CELL_ASYM_MAX(1:3) = CELL(1:3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1:3))
      CELL_ASYM_MIN_FRAC(1:3) = CELL_ASYM_MIN(1:3)/CELL(1:3)
      CELL_ASYM_MAX_FRAC(1:3) = CELL_ASYM_MAX(1:3)/CELL(1:3)
c
      CALL GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      D_VDW2_FRAC(1:3) = dlim*FRAC_XYZ(1:3)/CELL(1:3)
      EXT_ASYM_MAX(1:3) = CELL_ASYM_MAX_FRAC(1:3) + D_VDW2_FRAC(1:3)
      EXT_ASYM_MIN(1:3) = CELL_ASYM_MIN_FRAC(1:3) - D_VDW2_FRAC(1:3)
      DO    IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C
C---Now find all symmetry related atoms which are inside extended asymmetric 
C----unit
         DO    IS=1,nsym
            call mat2vec(3,3,rot(1:3,1:3,is),xyz_frac1,xyz_frac2,error)
            xyz_frac(1:3) = xyz_frac2(1:3) + tr(1:3,is)
C
C---Find translation by which this atom comes to asymmetic unit          
            CALL AMOD_R(XYZ_FRAC(1),ONE,IMODX,XYZS_CELL(1))
            CALL AMOD_R(XYZ_FRAC(2),ONE,IMODY,XYZS_CELL(2))
            CALL AMOD_R(XYZ_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
            DO    IZ = -1,1
               XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
               IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +              XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
                  DO   IY = -1,1
                     XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                     IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +                    XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                        DO    IX=-1,1
                           XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                           IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                          XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN
C
C----Add this position to list of atoms in asymmetric unit. Make sure to 
C----remember reference to symmetry. Increase number of symmetry related atomns
C----for this particular atom.
                              NXYZS           = NXYZS + 1
                              XYZS(1,NXYZS)   = XYZS_TRANSX
                              XYZS(2,NXYZS)   = XYZS_TRANSY
                              XYZS(3,NXYZS)   = XYZS_TRANSZ
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
         ENDDO
         endif
      ENDDO
C     
C---  Now we have list of symmetry related atoms and references to first atoms
C---  in "asymmetric unit". Create net. I.e. For each box find references to the
C---  atoms in asymmetric unit
      d_bricks_frac(1:3) = d_bricks_out(1:3)/cell(1:3)
c
c---
      allocate(atoms_in_this_brick(nbricks(1),nbricks(2),nbricks(3)))
      CALL CREATE_NET_size(NXYZS,XYZS,NBRICKs(1),NBRICKs(2),
     +     NBRICKs(3),NMAX_in_BRICK,ATOMS_IN_THIS_BRICK,
     +     EXT_ASYM_MIN,D_BRICKS_FRAC)
c
c---  deallocate
      deallocate(xyzs)
      deallocate(atoms_in_this_brick)
c
      RETURN
      END
C
      SUBROUTINE CREATE_NET_size(NXYZS,XYZS,NX,NY,NZ,
     +                     N_MAX_IN_BRICK,ATOMS_IN_THIS,
     +                     BOX_MIN,D_BRICKS)
      IMPLICIT NONE
C
c---This routine creates net. I.e. for each brick list of atoms belonging
C---to this brick is stored. Make sure that large box contains all atoms.
C---
      INTEGER NXYZS,NX,NY,NZ,N_MAX_IN_BRICK
      integer ATOMS_IN_THIS(NX,NY,NZ)
      REAL    XYZS(3,nxyzs),BOX_MIN(3),D_BRICKS(3)
C
C---  Local variables
      INTEGER IX,IY,IZ,IA
C
c---  body
      atoms_in_this(1:nx,1:ny,1:nz) = 0
      DO   IA=1,NXYZS
        IX = INT((XYZS(1,IA)-BOX_MIN(1))/D_BRICKS(1)) + 1
        IY = INT((XYZS(2,IA)-BOX_MIN(2))/D_BRICKS(2)) + 1
        IZ = INT((XYZS(3,IA)-BOX_MIN(3))/D_BRICKS(3)) + 1
        ix = max(1,min(nx,ix))
        iy = max(1,min(ny,iy))
        iz = max(1,min(nz,iz))
        ATOMS_IN_THIS(IX,IY,IZ) = ATOMS_IN_THIS(IX,IY,IZ) + 1
      ENDDO
      n_max_in_brick = maxval(atoms_in_this)
      RETURN
      END
c
      SUBROUTINE GET_XYZS_NUMBER(dlim,maxatom,n_atom,xyz_crd,occup,
     &     maxsym,nsym,rot,tr,cell,XYZ_SIZE)
      IMPLICIT NONE
c
c---inputs and outputs
      real dlim
      integer maxatom,n_atom
      real xyz_crd(3,maxatom),occup(maxatom)
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)
      integer xyz_size
c
c---  locals
      integer ierr
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)
      REAL D_BRICKS(3)
      INTEGER IPXYZ(3)
      INTEGER NMFOUR,I,IA,IMODX,IMODY,IMODZ,IX,IY,IZ,IS,NXYZS
      REAL CELL_ASYM_MIN(3),CELL_ASYM_MAX(3),EXT_ASYM_MAX(3)
      real xyz_frac(3),XYZ_FRAC1(3),XYZ_FRAC2(3),XYZS_CELL(3)
      real EXT_ASYM_MIN(3)
      real CELL_ASYM_MIN_FRAC(3),CELL_ASYM_MAX_FRAC(3),FRAC_XYZ(3)
      real D_VDW2_FRAC(3)
      REAL ONE,XYZS_TRANSX,XYZS_TRANSY,XYZS_TRANSZ,D_VDW2,DVDW_MAX
      REAL DVDW_MAX2
      REAL SMALL_EPS
      LOGICAL ERROR
      DATA ONE/1.0/,SMALL_EPS/1.0E-6/
C
c---  body
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     & cs_frac_to_ort,cs_ort_to_frac,ierr)
      NXYZS = 0
      CALL ASYLIM_r(maxsym,nsym,rot,tr,
     &     IPXYZ(1),IPXYZ(2),IPXYZ(3),NMFOUR)

      CELL_ASYM_MIN(1:3) = 0.0
      CELL_ASYM_MAX(1:3) = CELL(1:3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1:3))
      CELL_ASYM_MIN_FRAC(1:3) = CELL_ASYM_MIN(1:3)/CELL(1:3)
      CELL_ASYM_MAX_FRAC(1:3) = CELL_ASYM_MAX(1:3)/CELL(1:3)
      CALL GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      D_VDW2_FRAC(1:3)  = dlim*FRAC_XYZ(1:3)/CELL(1:3)
      EXT_ASYM_MAX(1:3) = CELL_ASYM_MAX_FRAC(1:3) + D_VDW2_FRAC(1:3)
      EXT_ASYM_MIN(1:3) = CELL_ASYM_MIN_FRAC(1:3) - D_VDW2_FRAC(1:3)
      DO    IA=1,N_ATOM
         if(occup(ia).gt.0.001) then
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C     
C---  Now find all symmetry related atoms which are inside extended asymmetric 
C---- unit
         DO    IS=1,nsym
            call mat2vec(3,3,rot(1:3,1:3,is),xyz_frac1,xyz_frac2,error)
            xyz_frac(1:3) = xyz_frac2(1:3)+tr(1:3,is)
C     
C---  Find translation by which this atom comes to asymmetic unit            
            CALL AMOD_R(XYZ_FRAC(1),ONE,IMODX,XYZS_CELL(1))
            CALL AMOD_R(XYZ_FRAC(2),ONE,IMODY,XYZS_CELL(2))
            CALL AMOD_R(XYZ_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
            DO    IZ = -1,1
               XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
               IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +              XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
                  DO   IY = -1,1
                     XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                     IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +                    XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                        DO    IX=-1,1
                           XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                           IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                          XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN
                              NXYZS           = NXYZS + 1
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
         ENDDO
         endif
      ENDDO
      XYZ_SIZE = NXYZS
      RETURN
      END
c
      SUBROUTINE BRICK_LIMITS(D_BRICK,CELL,D_BRICK_OUT)
      IMPLICIT NONE
C
C---  Finds brick limits for a given space group, if cell 
C---  dimensions have been specified. 

C
C---  Real arrays
      REAL CELL(6),D_BRICK(3),D_BRICK_OUT(6)
C
c---  Real local arrays
      REAL ALPHA,BETA,GAMMA,COSA,SINA,COSB,SINB,COSG,SING,
     +     VOLUME
c
c---  body
C     
C---  Cell dimensions are assumed to be in radians
      ALPHA = CELL(4)
      BETA  = CELL(5)
      GAMMA = CELL(6)
      COSA  = COS(ALPHA)
      SINA  = SIN(ALPHA)
      COSB  = COS(BETA)
      SINB  = SIN(BETA)
      COSG  = COS(GAMMA)
      SING  = SIN(GAMMA)
      VOLUME = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
C
C----Output brick size
      D_BRICK_OUT(1) = D_BRICK(1)*SINA/VOLUME
      D_BRICK_OUT(2) = D_BRICK(2)*SINB/VOLUME
      D_BRICK_OUT(3) = D_BRICK(3)*SING/VOLUME
C
      RETURN
      END
